(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   2383473,      94317]*)
(*NotebookOutlinePosition[   2384217,      94342]*)
(*  CellTagsIndexPosition[   2384173,      94338]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["FOCUSING BEHIND A POSITIVE DELTA-FUNCTION \
NONHOMOGENEITY", "Text",
  CellFrame->True,
  FontSize->14,
  Background->None]], "Title",
  CellFrame->True,
  Background->GrayLevel[0.849989]],

Cell[TextData[{
  StyleBox["The wavefront  and the tail  are incident from the left.\n\nThe \
nonhomogeneity  v[x]  ",
    FontSize->12],
  StyleBox["is a delta-function of strength  c0, positive or negative, \
located at  x=0.",
    FontSize->12,
    CharacterEncoding->"WindowsANSI"],
  StyleBox["  The potential has one bound state if  c0<0  and no bound states \
if  c0>0.\n\nThe focusing location,  ",
    FontSize->12],
  StyleBox["x0",
    FontSize->12,
    FontVariations->{"CompatibilityType"->0},
    CharacterEncoding->"WindowsANSI"],
  StyleBox[" >0, is behind the nonhomogeneity and needs to be specified. ",
    FontSize->12],
  StyleBox["\n\nThe transmission coefficient, left reflection coefficient, \
and right reflection coefficient, respectively, are denoted by  T[k],  L[k],  \
R[k].\n\nThe tail of the wave is denoted by  g[x,t].\n\nThe focusing moment \
is chosen as  t=0.",
    FontSize->12,
    CharacterEncoding->"WindowsANSI"]
}], "Text",
  FontSize->18,
  Background->RGBColor[1, 1, 0]],

Cell["\<\
The potential and the scattering coefficients are given next:\
\>", \
"Text",
  Background->RGBColor[1, 1, 0]],

Cell[BoxData[{
    \(\(Clear[v, T, L, R, c0, x0, g];\)\), "\[IndentingNewLine]", 
    \(\(v[x_] = \ c0\ \ DiracDelta[x]\ ;\)\), "\n", 
    \(\(T[k_] = k/\((k + I\ \ c0/2)\);\)\), "\n", 
    \(\(L[k_] = \((\(-I\)\ c0/2)\)/\((k + I\ \ c0/2)\);\)\), "\n", 
    \(\(R[k_] = \((\(-I\)\ c0/2)\)/\((k + I\ \ c0/2)\);\)\)}], "Input",
  CellOpen->False],

Cell["\<\
Specify the strength of the potential, c0, a positive number;
also specify the focusing location  x0, a positive number, next:\
\>", "Text",\

  Background->RGBColor[1, 1, 0]],

Cell[BoxData[
    \(\(\(c0 = 1\)\(;\)\(\ \ \)\(x0 = 1\)\(;\)\(\ \)\)\)], "Input"],

Cell["The tail  g[x,t]  of the focusing  wave is evaluated  next:", "Text",
  Background->RGBColor[1, 1, 0]],

Cell[BoxData[
    \(\(\(\n\)\(g[x_, 
          t_] = \ \(-\ \((c0/2)\)\)\ UnitStep[
              x]\ \ UnitStep[\(-x\) - x0 + 
                t]\ E^\((c0 \((x + x0 - t)\)/2)\) + \((c0/2)\) 
            UnitStep[\(-x\)]\ \((UnitStep[\(-x\) + x0 + t]\  - \ 
                UnitStep[\(-x\) - x0 + t]\  - \ UnitStep[x + x0 + t] + \ 
                UnitStep[x - x0 + t] - \ 
                UnitStep[
                    x - x0 + 
                      t]\ E^\((c0 \((\(-x\) + x0 - t)\)/
                          2)\))\);\)\)\)], "Input",
  CellOpen->False],

Cell[BoxData[
    \(<< Graphics`Animation`\)], "Input",
  CellOpen->False],

Cell[BoxData[
    \(<< Graphics`FilledPlot`\)], "Input",
  CellOpen->False],

Cell[TextData[{
  "The focusing wave is animated  next. The wavefront (",
  StyleBox["magenta",
    FontColor->RGBColor[1, 0, 1]],
  ") and the tail (",
  StyleBox["blue",
    FontColor->RGBColor[0, 0, 1]],
  ") are incident from the left onto the nonhomogeneity (",
  StyleBox["green",
    FontColor->RGBColor[0, 1, 0]],
  "):"
}], "Text",
  Background->RGBColor[1, 1, 0]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Animate[{FilledPlot\[IndentingNewLine][{v[x]}, \ {x, \ \(-4\), \ 
              4}, \ PlotRange -> {\(-1\), 1}, \ 
            Fills \[Rule] {Hue[ .3]}], \[IndentingNewLine]\ \ \ \ \ \ \ \
Plot[{10\ UnitStep[x - x0 - t]}, \ {x, \ \(-4\), \ 4}, \ 
            PlotStyle \[Rule] \ Hue[ .9], 
            PlotRange -> {\(-1\), 
                1}], \[IndentingNewLine]\ \ \ \ \ \ \ Plot[{g[x, 
                t]}, {x, \ \(-4\), \ 4}, \ PlotStyle \[Rule] \ Hue[ .6], \ 
            PlotRange -> {\(-1\), 1}]}, \[IndentingNewLine]\ {t, \ \(-2\), \ 
          2.9, 0.05}, PlotLabel \[Rule] {"\<t\>", t}];\)\)], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -22.0938 0 ]
[.5 .63053 22.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -83.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
97.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.32392 .30902 L
.34309 .30902 L
.36173 .30902 L
.37114 .30902 L
.37372 .30902 L
.37649 .30902 L
.37783 .30902 L
.3791 .30902 L
.38025 .30902 L
s
.38025 .30902 m
.38037 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.08255 .30902 L
.10458 .30902 L
.11448 .30902 L
.12507 .30902 L
.1302 .30902 L
.13506 .30902 L
.13942 .30902 L
.14061 .30902 L
.14188 .30902 L
.14296 .46353 L
.14415 .46353 L
.18444 .46353 L
.22321 .46353 L
.26444 .46353 L
.30414 .46353 L
.34234 .46353 L
.36201 .46353 L
.36767 .46353 L
.37301 .46353 L
.3778 .46353 L
.37911 .46353 L
.37983 .46353 L
.3805 .46353 L
.38168 .30902 L
.38298 .30902 L
.42189 .30902 L
.46325 .30902 L
.5031 .30902 L
.54143 .30902 L
.58221 .30902 L
.62148 .30902 L
.65923 .30902 L
.69943 .30902 L
.73812 .30902 L
.77926 .30902 L
.81888 .30902 L
.85699 .30902 L
.89755 .30902 L
.9366 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -22.0938 0 ]
[.5 .63053 22.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -83.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
97.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0
003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo
00goool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo01Goool001Koool0
0`000?ooooooo`0Koooo00<0I_ooooooool07?ooo`030000oooooooo01_oool00`1Vooooooooo`0K
oooo00<0003oooooool0>Oooo`030000oooooooo03[oool00`000?ooooooo`0Eoooo000doooo00<0
I_ooooooool0>_ooo`0306Kooooooooo01_oool00`000?ooooooo`2>oooo000doooo00<0I_oooooo
ool0>_ooo`0306Kooooooooo01_oool20000Soooo`00=?ooo`0306Kooooooooo03[oool00`1Voooo
ooooo`0Koooo00<0003oooooool0S_ooo`00=?ooo`0306Kooooooooo03[oool00`1Vooooooooo`0K
oooo00<0003oooooool0S_ooo`00=?ooo`0306Kooooooooo03[oool00`1Vooooooooo`0Koooo00<0
003oooooool0S_ooo`00=?ooo`0306Kooooooooo03[oool00`1Vooooooooo`0Koooo0P0008ooool0
03Coool00`1Vooooooooo`0joooo00<0I_ooooooool06oooo`030000oooooooo08koool003Coool0
0`1Vooooooooo`0joooo00<0I_ooooooool06oooo`030000oooooooo08koool003Coool00`1Voooo
ooooo`0joooo00<0I_ooooooool06oooo`030000oooooooo08koool003Coool00`1Vooooooooo`0j
oooo00<0I_ooooooool06oooo`80002?oooo000doooo00<0I_ooooooool0>_ooo`0306Kooooooooo
01_oool00`000?ooooooo`2>oooo000doooo00<0I_ooooooool0>_ooo`0306Kooooooooo01_oool0
0`000?ooooooo`2>oooo000doooo00<0I_ooooooool0>_ooo`0306Kooooooooo01_oool00`000?oo
ooooo`2>oooo000doooo00<0I_ooooooool0>_ooo`0306Kooooooooo01_oool20000Soooo`00=?oo
o`0306Kooooooooo03[oool00`1Vooooooooo`0Koooo00<0003oooooool0S_ooo`00=?ooo`0306Ko
oooooooo03[oool00`1Vooooooooo`02oooo0P0000Coool200000oooo`@00003oooo0P0000Goool0
0`000?ooooooo`2>oooo000doooo00<0I_ooooooool0>_ooo`0506Kooooooooooooo000000;oool0
0`000?ooooooo`06oooo00<0003oooooool00oooo`040000oooooooo00001?ooo`030000oooooooo
08koool003Coool00`1Vooooooooo`0joooo00D0I_ooooooooooool000000_ooo`030000oooooooo
00Ooool00`000?ooooooo`05oooo00<0003oooooool00_ooo`<0002>oooo000doooo00<0I_oooooo
ool0>_ooo`0506Kooooooooooooo000000;oool00`000?ooooooo`08oooo00<0003oooooool00_oo
o`800005oooo00<0003oooooool0S_ooo`00=?ooo`0306Kooooooooo03[oool01@1Voooooooooooo
o`000002oooo00<0003oooooool01_ooo`040000oooooooo00000oooo`030000oooooooo00Coool0
0`000?ooooooo`2>oooo000doooo00<0I_ooooooool0>_ooo`0306Kooooooooo00;oool200002_oo
o`800004oooo0`0000Coool00`000?ooooooo`2>oooo000doooo00<0I_ooooooool0>_ooo`0306Ko
oooooooo01_oool20000Soooo`00=?ooo`0306Kooooooooo03[oool00`1Vooooooooo`0Koooo00<0
003oooooool0S_ooo`00=?ooo`0306Kooooooooo03[oool00`1Vooooooooo`0Koooo00<0003ooooo
ool0S_ooo`00=?ooo`0306Kooooooooo03[oool00`1Vooooooooo`0Koooo00<0003oooooool0S_oo
o`00=?ooo`0306Kooooooooo03[oool00`1Vooooooooo`0Koooo0P0008ooool003Coool00`1Voooo
ooooo`0joooo00<0I_ooooooool06oooo`030000oooooooo08koool003Coool00`1Vooooooooo`0j
oooo00<0I_ooooooool06oooo`030000oooooooo08koool003Coool00`1Vooooooooo`0joooo00<0
I_ooooooool06oooo`030000oooooooo08koool003Coool00`1Vooooooooo`0joooo00<0I_oooooo
ool06oooo`80002?oooo000doooo00<0I_ooooooool0>_ooo`0306Kooooooooo01_oool00`000?oo
ooooo`2>oooo000doooo00<0I_ooooooool0>_ooo`0306Kooooooooo01_oool00`000?ooooooo`2>
oooo000doooo00<0I_ooooooool0>_ooo`0306Kooooooooo01_oool00`000?ooooooo`2>oooo000d
oooo00<0I_ooooooool0>_ooo`0306Kooooooooo01_oool20000Soooo`00=?ooo`0306Kooooooooo
03[oool00`1Vooooooooo`0Koooo00<0003oooooool0S_ooo`00=?ooo`0306Kooooooooo03[oool0
0`1Vooooooooo`08oooo0P0000Coool200001?ooo`800005oooo00<0003oooooool0S_ooo`00=?oo
o`0306Kooooooooo03[oool00`1Vooooooooo`07oooo00@0003oooooool00008oooo00@0003ooooo
ool00004oooo00<0003oooooool0S_ooo`00=?oooch0I_l9oooo00@0003oooooool0000;oooo00<0
003oooooool00_ooo`<0002>oooo001aoooo00?o09Woooooool01oooo`040000oooooooo00002Ooo
o`800005oooo00<0003oooooool0S_ooo`00LOooo`03o`2Ioooooooo00Ooool010000?ooooooo`00
00Woool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00LOooo`03o`2Ioooooooo00Soool2
00002_ooo`<00004oooo00<0003oooooool0S_ooo`00LOooo`03o`2Ioooooooo01_oool20000Sooo
o`00LOooo`03o`2Ioooooooo01_oool00`000?ooooooo`2>oooo001aoooo00?o09Woooooool06ooo
o`030000oooooooo08koool0077oool00ol0VOooooooo`0Koooo0P0008ooool0077oool00ol0VOoo
ooooo`0Koooo00<0003oooooool0S_ooo`00LOooo`03o`2Ioooooooo01_oool00`000?ooooooo`2>
oooo001aoooo00?o09Woooooool06oooo`030000oooooooo08koool0077oool00ol0VOooooooo`0K
oooo0P0008ooool0077oool00ol0VOooooooo`0Koooo00<0003oooooool0S_ooo`00LOooo`03o`2I
oooooooo01_oool00`000?ooooooo`2>oooo001aoooo00?o09Woooooool06oooo`030000oooooooo
08koool0077oool00ol0VOooooooo`0Koooo0P0008ooool0077oool00ol0VOooooooo`0Koooo00<0
003oooooool0S_ooo`00LOooo`03o`2Ioooooooo00;oool200001?ooo`800005oooo00<0003ooooo
ool00_ooo`800005oooo00<0003oooooool0S_ooo`00LOooo`05o`2Ioooooooooooo000000;oool0
0`000?ooooooo`08oooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?oo
ooooo`2>oooo001aoooo00Go09Woooooooooool000000_ooo`030000oooooooo00Soool00`000?oo
ooooo`04oooo00<0003oooooool00_ooo`<0002>oooo001aoooo00Go09Woooooooooool000000_oo
o`030000oooooooo00Woool010000?ooooooooooo`800005oooo00<0003oooooool0S_ooo`00LOoo
o`05o`2Ioooooooooooo000000;oool00`000?ooooooo`06oooo00@0003oooooool00003oooo00<0
003oooooool01?ooo`030000oooooooo08koool0077oool00ol0VOooooooo`02oooo0P0000Woool4
00000oooo`<00004oooo00<0003oooooool0S_ooo`00LOooo`03o`2Ioooooooo01_oool20000Sooo
o`00LOooo`03o`2Ioooooooo01_oool00`000?ooooooo`2>oooo001aoooo00?o09Woooooool06ooo
o`030000oooooooo08koool0077oool00ol0VOooooooo`0Koooo00<0003oooooool0S_ooo`00LOoo
o`03o`2Ioooooooo01_oool20000Soooo`00LOooo`03o`2Ioooooooo01_oool00`000?ooooooo`2>
oooo001aoooo00?o09Woooooool06oooo`030000oooooooo08koool0077oool00ol0VOooooooo`0K
oooo00<0003oooooool0S_ooo`00LOooo`03o`2Ioooooooo01_oool20000Soooo`00LOooo`03o`2I
oooooooo01_oool00`000?ooooooo`2>oooo001aoooo00?o09Woooooool06oooo`030000oooooooo
08koool0077oool00ol0VOooooooo`0Koooo00<0003oooooool0S_ooo`00LOooo`03o`2Ioooooooo
01_oool20000Soooo`00LOooo`03o`2Ioooooooo01_oool00`000?ooooooo`2>oooo001aoooo00?o
09Woooooool04oooo`D00003oooo00<0003oooooool0S_ooo`00LOooo`03o`2Ioooooooo01Goool0
0`000?ooooooo`03oooo00<0003oooooool0S_ooo`00LOooo`03o`2Ioooooooo01Goool00`000?oo
ooooo`03oooo0`0008koool008Woool00`000?ooooooo`2Doooo0029oooo00<0003oooooool0U?oo
o`00R?ooo`80002Foooo003ooooo8Oooo`00ooooob7oool007ooool00`000?ooooooo`0Loooo00<0
003oooooool0Ooooo`00O_ooo`030000oooooooo00Soool00`000?ooooooo`0Coooo00<0003ooooo
ool0O_ooo`00O_ooo`030000oooooooo00;oool200001?ooo`030000oooooooo00coool400000ooo
o`030000oooooooo07koool007koool01@000?ooooooooooo`000002oooo00<0003oooooool00_oo
o`030000oooooooo00Coool400000oooo`030000oooooooo00Coool00`000?ooooooo`1noooo001m
oooo00<0003oooooool00_ooo`030000oooooooo01Coool00`000?ooooooo`04oooo00<0003ooooo
ool0OOooo`00O_ooo`030000oooooooo00D0000Doooo00<0003oooooool00_ooo`030000oooooooo
07koool007koool01@000?ooooooooooo`00000Eoooo00@0003oooooool00003oooo00<0003ooooo
ool0O_ooo`00Ooooo`030000oooooooo01Ooool200000oooo`030000oooooooo07ooool00?oooolQ
oooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {290.125, 148.813}} -> {-0.349561, \
1.05307, 0.00349883, 0.00566123}, {{79.875, 308.563}, {290.125, 148.813}} -> \
{-8.05779, 1.32095, 0.0331906, 0.0127866}, {{79.875, 308.563}, {290.125, \
148.813}} -> {-8.05779, 1.32095, 0.0331906, 0.0127866}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.95) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.36136 .30902 L
.37176 .30902 L
.37685 .30902 L
.3815 .30902 L
.38384 .30902 L
.38508 .30902 L
.3864 .30902 L
s
.3864 .30902 m
.38653 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.12507 .30902 L
.13506 .30902 L
.14415 .30902 L
.14635 .30902 L
.14756 .30902 L
.14868 .30902 L
.1499 .46353 L
.15055 .46353 L
.15124 .46353 L
.1536 .46353 L
.16254 .46353 L
.18221 .46353 L
.22343 .46353 L
.26314 .46353 L
.30133 .46353 L
.34198 .46353 L
.36078 .46353 L
.37066 .46353 L
.38111 .46353 L
.38367 .46353 L
.38509 .46353 L
.38578 .46353 L
.38643 .46353 L
.38718 .30902 L
.388 .30902 L
.38944 .30902 L
.39226 .30902 L
.40252 .30902 L
.42269 .30902 L
.46196 .30902 L
.49971 .30902 L
.53991 .30902 L
.5786 .30902 L
.61974 .30902 L
.65936 .30902 L
.69747 .30902 L
.73803 .30902 L
.77708 .30902 L
.81858 .30902 L
.85856 .30902 L
.89702 .30902 L
.93794 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.95) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
o`1Vo`0=oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0
0000I_ooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo
00goool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo01Goool001Koool0
0`000?ooooooo`0Moooo00<0I_ooooooool06_ooo`030000oooooooo01coool00`1Vooooooooo`0J
oooo00<0003oooooool0>Oooo`030000oooooooo03[oool00`000?ooooooo`0Eoooo000foooo00<0
I_ooooooool0>Oooo`0306Kooooooooo01[oool00`000?ooooooo`2>oooo000foooo00<0I_oooooo
ool0>Oooo`0306Kooooooooo01[oool20000Soooo`00=_ooo`0306Kooooooooo03Woool00`1Voooo
ooooo`0Joooo00<0003oooooool0S_ooo`00=_ooo`0306Kooooooooo03Woool00`1Vooooooooo`0J
oooo00<0003oooooool0S_ooo`00=_ooo`0306Kooooooooo03Woool00`1Vooooooooo`0Joooo00<0
003oooooool0S_ooo`00=_ooo`0306Kooooooooo03Woool00`1Vooooooooo`0Joooo0P0008ooool0
03Koool00`1Vooooooooo`0ioooo00<0I_ooooooool06_ooo`030000oooooooo08koool003Koool0
0`1Vooooooooo`0ioooo00<0I_ooooooool06_ooo`030000oooooooo08koool003Koool00`1Voooo
ooooo`0ioooo00<0I_ooooooool06_ooo`030000oooooooo08koool003Koool00`1Vooooooooo`0i
oooo00<0I_ooooooool06_ooo`80002?oooo000foooo00<0I_ooooooool0>Oooo`0306Kooooooooo
01[oool00`000?ooooooo`2>oooo000foooo00<0I_ooooooool0>Oooo`0306Kooooooooo01[oool0
0`000?ooooooo`2>oooo000foooo00<0I_ooooooool0>Oooo`0306Kooooooooo01[oool00`000?oo
ooooo`2>oooo000foooo00<0I_ooooooool0>Oooo`0306Kooooooooo01[oool20000Soooo`00=_oo
o`0306Kooooooooo03Woool00`1Vooooooooo`0Joooo00<0003oooooool0S_ooo`00=_ooo`0306Ko
oooooooo03Woool0101Vooooooooooooo`800004oooo0P0000?oool400000oooo`800005oooo00<0
003oooooool0S_ooo`00=_ooo`0306Kooooooooo03Woool0101Vooooooooo`0000;oool00`000?oo
ooooo`06oooo00<0003oooooool00oooo`040000oooooooo00001?ooo`030000oooooooo08koool0
03Koool00`1Vooooooooo`0ioooo00@0I_ooooooool00002oooo00<0003oooooool01oooo`030000
oooooooo00Goool00`000?ooooooo`02oooo0`0008koool003Koool00`1Vooooooooo`0ioooo00@0
I_ooooooool00002oooo00<0003oooooool02?ooo`030000oooooooo00;oool200001Oooo`030000
oooooooo08koool003Koool00`1Vooooooooo`0ioooo00@0I_ooooooool00002oooo00<0003ooooo
ool01_ooo`040000oooooooo00000oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo000f
oooo00<0I_ooooooool0>Oooo`0406Kooooooooooooo0P0000[oool200001?ooo`<00004oooo00<0
003oooooool0S_ooo`00=_ooo`0306Kooooooooo03Woool00`1Vooooooooo`0Joooo0P0008ooool0
03Koool00`1Vooooooooo`0ioooo00<0I_ooooooool06_ooo`030000oooooooo08koool003Koool0
0`1Vooooooooo`0ioooo00<0I_ooooooool06_ooo`030000oooooooo08koool003Koool00`1Voooo
ooooo`0ioooo00<0I_ooooooool06_ooo`030000oooooooo08koool003Koool00`1Vooooooooo`0i
oooo00<0I_ooooooool06_ooo`80002?oooo000foooo00<0I_ooooooool0>Oooo`0306Kooooooooo
01[oool00`000?ooooooo`2>oooo000foooo00<0I_ooooooool0>Oooo`0306Kooooooooo01[oool0
0`000?ooooooo`2>oooo000foooo00<0I_ooooooool0>Oooo`0306Kooooooooo01[oool00`000?oo
ooooo`2>oooo000foooo00<0I_ooooooool0>Oooo`0306Kooooooooo01[oool20000Soooo`00=_oo
o`0306Kooooooooo03Woool00`1Vooooooooo`0Joooo00<0003oooooool0S_ooo`00=_ooo`0306Ko
oooooooo03Woool00`1Vooooooooo`0Joooo00<0003oooooool0S_ooo`00=_ooo`0306Kooooooooo
03Woool00`1Vooooooooo`0Joooo00<0003oooooool0S_ooo`00=_ooo`0306Kooooooooo03Woool0
0`1Vooooooooo`0Joooo0P0008ooool003Koool00`1Vooooooooo`0ioooo00<0I_ooooooool06_oo
o`030000oooooooo08koool003Koool00`1Vooooooooo`0ioooo00<0I_ooooooool01oooo`800004
oooo0P0000Coool200001Oooo`030000oooooooo08koool003Koool00`1Vooooooooo`0ioooo00<0
I_ooooooool01_ooo`040000oooooooo00002?ooo`040000oooooooo00001?ooo`030000oooooooo
08koool003Kooolm06Ko2?ooo`040000oooooooo00002oooo`030000oooooooo00;oool30000S_oo
o`00L_ooo`03o`2Ioooooooo00Koool010000?ooooooo`0000Woool200001Oooo`030000oooooooo
08koool007;oool00ol0VOooooooo`06oooo00@0003oooooool00009oooo00<0003oooooool01?oo
o`030000oooooooo08koool007;oool00ol0VOooooooo`07oooo0P0000[oool300001?ooo`030000
oooooooo08koool007;oool00ol0VOooooooo`0Joooo0P0008ooool007;oool00ol0VOooooooo`0J
oooo00<0003oooooool0S_ooo`00L_ooo`03o`2Ioooooooo01[oool00`000?ooooooo`2>oooo001b
oooo00?o09Woooooool06_ooo`80002?oooo001boooo00?o09Woooooool06_ooo`030000oooooooo
08koool007;oool00ol0VOooooooo`0Joooo00<0003oooooool0S_ooo`00L_ooo`03o`2Ioooooooo
01[oool00`000?ooooooo`2>oooo001boooo00?o09Woooooool06_ooo`80002?oooo001boooo00?o
09Woooooool06_ooo`030000oooooooo08koool007;oool00ol0VOooooooo`0Joooo00<0003ooooo
ool0S_ooo`00L_ooo`03o`2Ioooooooo01[oool00`000?ooooooo`2>oooo001boooo00?o09Wooooo
ool06_ooo`80002?oooo001boooo00?o09Woooooool06_ooo`030000oooooooo08koool007;oool0
1?l0VOooooooooooo`800004oooo0P0000Goool00`000?ooooooo`02oooo0P0000Goool00`000?oo
ooooo`2>oooo001boooo00Co09Woooooool00002oooo00<0003oooooool02?ooo`050000oooooooo
oooo000000;oool00`000?ooooooo`02oooo00<0003oooooool0S_ooo`00L_ooo`04o`2Ioooooooo
00000_ooo`030000oooooooo00Soool00`000?ooooooo`04oooo00<0003oooooool00_ooo`<0002>
oooo001boooo00Co09Woooooool00002oooo00<0003oooooool02Oooo`040000oooooooooooo0P00
00Goool00`000?ooooooo`2>oooo001boooo00Co09Woooooool00002oooo00<0003oooooool01_oo
o`040000oooooooo00000oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001boooo00Co
09Woooooooooool200002Oooo`@00003oooo0`0000Coool00`000?ooooooo`2>oooo001boooo00?o
09Woooooool06_ooo`80002?oooo001boooo00?o09Woooooool06_ooo`030000oooooooo08koool0
07;oool00ol0VOooooooo`0Joooo00<0003oooooool0S_ooo`00L_ooo`03o`2Ioooooooo01[oool0
0`000?ooooooo`2>oooo001boooo00?o09Woooooool06_ooo`80002?oooo001boooo00?o09Wooooo
ool06_ooo`030000oooooooo08koool007;oool00ol0VOooooooo`0Joooo00<0003oooooool0S_oo
o`00L_ooo`03o`2Ioooooooo01[oool00`000?ooooooo`2>oooo001boooo00?o09Woooooool06_oo
o`80002?oooo001boooo00?o09Woooooool06_ooo`030000oooooooo08koool007;oool00ol0VOoo
ooooo`0Joooo00<0003oooooool0S_ooo`00L_ooo`03o`2Ioooooooo01[oool00`000?ooooooo`2>
oooo001boooo00?o09Woooooool06_ooo`80002?oooo001boooo00?o09Woooooool06_ooo`030000
oooooooo08koool007;oool00ol0VOooooooo`0Boooo1@0000?oool00`000?ooooooo`2>oooo001b
oooo00?o09Woooooool05?ooo`030000oooooooo00?oool00`000?ooooooo`2>oooo001boooo00?o
09Woooooool05?ooo`030000oooooooo00?oool30000S_ooo`00ROooo`030000oooooooo09Coool0
08Woool00`000?ooooooo`2Doooo0028oooo0P0009Koool00?oooolQoooo003ooooo8Oooo`00M_oo
o`030000oooooooo02koool00`000?ooooooo`1foooo001eoooo00<0003oooooool02?ooo`030000
oooooooo02Goool00`000?ooooooo`1eoooo001eoooo00<0003oooooool00_ooo`800004oooo00<0
003oooooool03?ooo`D00002oooo0P0000?oool300001?ooo`800004oooo00<0003oooooool0MOoo
o`00MOooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01?oo
o`@00005oooo00<0003oooooool02Oooo`050000oooooooooooo000000;oool01@000?oooooooooo
o`00001goooo001doooo00<0003oooooool00_ooo`030000oooooooo01Goool00`000?ooooooo`08
oooo0`0000Goool00`000?ooooooo`02oooo00<0003oooooool0M?ooo`00MOooo`030000oooooooo
00D0000Doooo00<0003oooooool01oooo`040000oooooooo00000oooo`800004oooo00<0003ooooo
ool0MOooo`00MOooo`050000oooooooooooo000001Ooool00`000?ooooooo`07oooo00@0003ooooo
ool00003oooo00<0003oooooool00oooo`030000oooooooo07Goool007Koool00`000?ooooooo`0G
oooo0P0000[oool300000oooo`<00002oooo00<0003oooooool0M_ooo`00ooooob7oool00?oooolQ
oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.9) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.36136 .30902 L
.37176 .30902 L
.3815 .30902 L
.3864 .30902 L
.38881 .30902 L
.39106 .30902 L
.3923 .30902 L
s
.3923 .30902 m
.39237 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.12507 .30902 L
.13506 .30902 L
.14415 .30902 L
.14868 .30902 L
.15107 .30902 L
.15238 .30902 L
.1536 .30902 L
.15467 .30902 L
.15581 .46353 L
.15709 .46353 L
.15825 .46353 L
.16254 .46353 L
.18221 .46353 L
.22192 .46353 L
.26011 .46353 L
.30075 .46353 L
.33988 .46353 L
.35986 .46353 L
.37037 .46353 L
.38147 .46353 L
.38627 .46353 L
.38891 .46353 L
.39141 .46353 L
.3921 .46353 L
.39283 .46353 L
.39363 .30902 L
.39437 .30902 L
.39706 .30902 L
.40233 .30902 L
.42153 .30902 L
.45928 .30902 L
.49949 .30902 L
.53817 .30902 L
.57931 .30902 L
.61894 .30902 L
.65705 .30902 L
.69761 .30902 L
.73665 .30902 L
.77815 .30902 L
.81813 .30902 L
.8566 .30902 L
.89752 .30902 L
.93692 .30902 L
.97481 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.9) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool010000?oo
ooooo`1Vo`coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00coool0
10000?ooooooo`1Vo`_oool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo
00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0Eoooo000F
oooo00<0003oooooool07_ooo`0306Kooooooooo01Woool00`000?ooooooo`0Noooo00<0I_oooooo
ool06?ooo`030000oooooooo03Woool00`000?ooooooo`0joooo00<0003oooooool05Oooo`00=ooo
o`0306Kooooooooo03[oool00`1Vooooooooo`0Hoooo00<0003oooooool0S_ooo`00=oooo`0306Ko
oooooooo03[oool00`1Vooooooooo`0Hoooo0P0008ooool003Ooool00`1Vooooooooo`0joooo00<0
I_ooooooool06?ooo`030000oooooooo08koool003Ooool00`1Vooooooooo`0joooo00<0I_oooooo
ool06?ooo`030000oooooooo08koool003Ooool00`1Vooooooooo`0joooo00<0I_ooooooool06?oo
o`030000oooooooo08koool003Ooool00`1Vooooooooo`0joooo00<0I_ooooooool06?ooo`80002?
oooo000goooo00<0I_ooooooool0>_ooo`0306Kooooooooo01Soool00`000?ooooooo`2>oooo000g
oooo00<0I_ooooooool0>_ooo`0306Kooooooooo01Soool00`000?ooooooo`2>oooo000goooo00<0
I_ooooooool0>_ooo`0306Kooooooooo01Soool00`000?ooooooo`2>oooo000goooo00<0I_oooooo
ool0>_ooo`0306Kooooooooo01Soool20000Soooo`00=oooo`0306Kooooooooo03[oool00`1Voooo
ooooo`0Hoooo00<0003oooooool0S_ooo`00=oooo`0306Kooooooooo03[oool00`1Vooooooooo`0H
oooo00<0003oooooool0S_ooo`00=oooo`0306Kooooooooo03[oool00`1Vooooooooo`0Hoooo00<0
003oooooool0S_ooo`00=oooo`0306Kooooooooo03[oool00`1Vooooooooo`0Hoooo0P0008ooool0
03Ooool00`1Vooooooooo`0joooo00<0I_ooooooool06?ooo`030000oooooooo08koool003Ooool0
0`1Vooooooooo`0joooo00@0I_ooool000000004oooo0P0000?oool400000oooo`800005oooo00<0
003oooooool0S_ooo`00=oooo`0306Kooooooooo03[oool01@1Vo`000?ooooooo`000008oooo00<0
003oooooool00oooo`040000oooooooo00001?ooo`030000oooooooo08koool003Ooool00`1Voooo
ooooo`0joooo00D0I_l0003oooooool000002Oooo`030000oooooooo00Goool00`000?ooooooo`02
oooo0`0008koool003Soool00`1Vooooooooo`0ioooo00D0I_l0003oooooool000002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool003Soool00`1Vooooooooo`0ioooo00D0
I_l0003oooooool000002?ooo`040000oooooooo00000oooo`030000oooooooo00Coool00`000?oo
ooooo`2>oooo000hoooo00<0I_ooooooool0>Oooo`0406Kooooo000000002_ooo`800004oooo0`00
00Coool00`000?ooooooo`2>oooo000hoooo00<0I_ooooooool0>Oooo`0306Kooooooooo01Soool2
0000Soooo`00>?ooo`0306Kooooooooo03Woool00`1Vooooooooo`0Hoooo00<0003oooooool0S_oo
o`00>?ooo`0306Kooooooooo03Woool00`1Vooooooooo`0Hoooo00<0003oooooool0S_ooo`00>?oo
o`0306Kooooooooo03Woool00`1Vooooooooo`0Hoooo00<0003oooooool0S_ooo`00>?ooo`0306Ko
oooooooo03Woool00`1Vooooooooo`0Hoooo0P0008ooool003Soool00`1Vooooooooo`0ioooo00<0
I_ooooooool06?ooo`030000oooooooo08koool003Soool00`1Vooooooooo`0ioooo00<0I_oooooo
ool06?ooo`030000oooooooo08koool003Soool00`1Vooooooooo`0ioooo00<0I_ooooooool06?oo
o`030000oooooooo08koool003Soool00`1Vooooooooo`0ioooo00<0I_ooooooool06?ooo`80002?
oooo000hoooo00<0I_ooooooool0>Oooo`0306Kooooooooo01Soool00`000?ooooooo`2>oooo000h
oooo00<0I_ooooooool0>Oooo`0306Kooooooooo01Soool00`000?ooooooo`2>oooo000hoooo00<0
I_ooooooool0>Oooo`0306Kooooooooo01Soool00`000?ooooooo`2>oooo000hoooo00<0I_oooooo
ool0>Oooo`0306Kooooooooo01Soool20000Soooo`00>?ooo`0306Kooooooooo03Woool00`1Voooo
ooooo`0Hoooo00<0003oooooool0S_ooo`00>?ooo`0306Kooooooooo03Woool00`1Vooooooooo`05
oooo0P0000Coool200001?ooo`800005oooo00<0003oooooool0S_ooo`00>?ooo`0306Kooooooooo
03Woool00`1Vooooooooo`04oooo00@0003oooooool00008oooo00@0003oooooool00004oooo00<0
003oooooool0S_ooo`00>?ooocd0I_l6oooo00@0003oooooool0000;oooo00<0003oooooool00_oo
o`<0002>oooo001doooo00?o09Woooooool01?ooo`040000oooooooo00002Oooo`800005oooo00<0
003oooooool0S_ooo`00M?ooo`03o`2Ioooooooo00Coool010000?ooooooo`0000Woool00`000?oo
ooooo`04oooo00<0003oooooool0S_ooo`00M?ooo`03o`2Ioooooooo00Goool200002_ooo`<00004
oooo00<0003oooooool0S_ooo`00M?ooo`03o`2Ioooooooo01Soool20000Soooo`00M?ooo`03o`2I
oooooooo01Soool00`000?ooooooo`2>oooo001doooo00?o09Woooooool06?ooo`030000oooooooo
08koool007Coool00ol0VOooooooo`0Hoooo0P0008ooool007Coool00ol0VOooooooo`0Hoooo00<0
003oooooool0S_ooo`00M?ooo`03o`2Ioooooooo01Soool00`000?ooooooo`2>oooo001doooo00?o
09Woooooool06?ooo`030000oooooooo08koool007Coool00ol0VOooooooo`0Hoooo0P0008ooool0
07Coool00ol0VOooooooo`0Hoooo00<0003oooooool0S_ooo`00M?ooo`03o`2Ioooooooo01Soool0
0`000?ooooooo`2>oooo001doooo00?o09Woooooool06?ooo`030000oooooooo08koool007Coool0
0ol0VOooooooo`0Hoooo0P0008ooool007Coool00ol0VOooooooo`0Hoooo00<0003oooooool0S_oo
o`00M?ooo`04o`2Ioooo000000001?ooo`800005oooo00<0003oooooool00_ooo`800005oooo00<0
003oooooool0S_ooo`00M?ooo`05o`2I0000oooooooo000000[oool01@000?ooooooooooo`000002
oooo00<0003oooooool00_ooo`030000oooooooo08koool007Coool01Ol0V@000?ooooooo`00000:
oooo00<0003oooooool01?ooo`030000oooooooo00;oool30000S_ooo`00M?ooo`05o`2I0000oooo
oooo000000_oool010000?ooooooooooo`800005oooo00<0003oooooool0S_ooo`00M?ooo`05o`2I
0000oooooooo000000Soool010000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003ooooo
ool0S_ooo`00M?ooo`04o`2Ioooo000000002Oooo`@00003oooo0`0000Coool00`000?ooooooo`2>
oooo001doooo00?o09Woooooool06?ooo`80002?oooo001doooo00?o09Woooooool06?ooo`030000
oooooooo08koool007Coool00ol0VOooooooo`0Hoooo00<0003oooooool0S_ooo`00M?ooo`03o`2I
oooooooo01Soool00`000?ooooooo`2>oooo001doooo00?o09Woooooool06?ooo`80002?oooo001d
oooo00?o09Woooooool06?ooo`030000oooooooo08koool007Coool00ol0VOooooooo`0Hoooo00<0
003oooooool0S_ooo`00M?ooo`03o`2Ioooooooo01Soool00`000?ooooooo`2>oooo001doooo00?o
09Woooooool06?ooo`80002?oooo001doooo00?o09Woooooool06?ooo`030000oooooooo08koool0
07Coool00ol0VOooooooo`0Hoooo00<0003oooooool0S_ooo`00M?ooo`03o`2Ioooooooo01Soool0
0`000?ooooooo`2>oooo001doooo00?o09Woooooool06?ooo`80002?oooo001doooo00?o09Wooooo
ool06?ooo`030000oooooooo08koool007Coool00ol0VOooooooo`0@oooo1@0000?oool00`000?oo
ooooo`2>oooo001doooo00?o09Woooooool04_ooo`030000oooooooo00?oool00`000?ooooooo`2>
oooo001doooo00?o09Woooooool04_ooo`030000oooooooo00?oool30000S_ooo`00ROooo`030000
oooooooo09Coool008Woool00`000?ooooooo`2Doooo0028oooo0P0009Koool00?oooolQoooo003o
oooo8Oooo`00NOooo`030000oooooooo02Soool00`000?ooooooo`1ioooo001hoooo00<0003ooooo
ool02?ooo`030000oooooooo01ooool00`000?ooooooo`1hoooo001hoooo00<0003oooooool00_oo
o`800004oooo00<0003oooooool03?ooo`D00002oooo0P0000?oool300001?ooo`030000oooooooo
07Soool007Soool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
00Coool400001Oooo`030000oooooooo00Woool00`000?ooooooo`02oooo00<0003oooooool0N?oo
o`00Moooo`030000oooooooo00;oool00`000?ooooooo`0Eoooo00<0003oooooool02?ooo`<00004
oooo00<0003oooooool0Moooo`00N?ooo`030000oooooooo00D0000Doooo00<0003oooooool01ooo
o`040000oooooooo00000oooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`00000G
oooo00<0003oooooool01oooo`040000oooooooo00000oooo`030000oooooooo07Soool007Woool0
0`000?ooooooo`0Goooo0P0000[oool300000_ooo`030000oooooooo07Woool00?oooolQoooo003o
oooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.85) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.36136 .30902 L
.37176 .30902 L
.3815 .30902 L
.39106 .30902 L
.39381 .30902 L
.39642 .30902 L
.39756 .30902 L
.39877 .30902 L
s
.39877 .30902 m
.39884 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.12507 .30902 L
.13506 .30902 L
.14415 .30902 L
.14868 .30902 L
.1536 .30902 L
.15586 .30902 L
.15825 .30902 L
.15923 .30902 L
.16029 .30902 L
.16145 .46353 L
.16254 .46353 L
.18221 .46353 L
.22343 .46353 L
.26314 .46353 L
.30133 .46353 L
.34198 .46353 L
.36078 .46353 L
.38111 .46353 L
.38653 .46353 L
.39226 .46353 L
.39462 .46353 L
.39715 .46353 L
.3979 .46353 L
.3986 .46353 L
.39924 .30902 L
.39993 .30902 L
.40252 .30902 L
.42269 .30902 L
.46347 .30902 L
.50274 .30902 L
.54049 .30902 L
.58069 .30902 L
.61938 .30902 L
.66052 .30902 L
.70014 .30902 L
.73825 .30902 L
.77881 .30902 L
.81786 .30902 L
.85936 .30902 L
.89934 .30902 L
.93781 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.85) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`02oooo00<0I_ooooooool02?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0
003oooooool03?ooo`050000oooooooooooo06Ko00[oool00`000?ooooooo`0<oooo00<0003ooooo
ool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000
oooooooo00coool00`000?ooooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00coool0
0`000?ooooooo`0Eoooo000Foooo00<0003oooooool08?ooo`0306Kooooooooo01Ooool00`000?oo
ooooo`0Ooooo00<0I_ooooooool05oooo`030000oooooooo03Woool00`000?ooooooo`0joooo00<0
003oooooool05Oooo`00>Oooo`0306Kooooooooo03Woool00`1Vooooooooo`0Goooo00<0003ooooo
ool0S_ooo`00>Oooo`0306Kooooooooo03Woool00`1Vooooooooo`0Goooo0P0008ooool003Woool0
0`1Vooooooooo`0ioooo00<0I_ooooooool05oooo`030000oooooooo08koool003Woool00`1Voooo
ooooo`0ioooo00<0I_ooooooool05oooo`030000oooooooo08koool003Woool00`1Vooooooooo`0i
oooo00<0I_ooooooool05oooo`030000oooooooo08koool003Woool00`1Vooooooooo`0ioooo00<0
I_ooooooool05oooo`80002?oooo000ioooo00<0I_ooooooool0>Oooo`0306Kooooooooo01Ooool0
0`000?ooooooo`2>oooo000ioooo00<0I_ooooooool0>Oooo`0306Kooooooooo01Ooool00`000?oo
ooooo`2>oooo000ioooo00<0I_ooooooool0>Oooo`0306Kooooooooo01Ooool00`000?ooooooo`2>
oooo000ioooo00<0I_ooooooool0>Oooo`0306Kooooooooo01Ooool20000Soooo`00>Oooo`0306Ko
oooooooo03Woool00`1Vooooooooo`0Goooo00<0003oooooool0S_ooo`00>Oooo`0306Kooooooooo
03Woool00`1Vooooooooo`0Goooo00<0003oooooool0S_ooo`00>Oooo`0306Kooooooooo03Woool0
0`1Vooooooooo`0Goooo00<0003oooooool0S_ooo`00>Oooo`0306Kooooooooo03Woool00`1Voooo
ooooo`0Goooo0P0008ooool003Woool00`1Vooooooooo`0ioooo00<0I_ooooooool05oooo`030000
oooooooo08koool003Woool00`1Vooooooooo`0ioooo00<0I_l0000000001?ooo`800003oooo1000
00?oool200001Oooo`030000oooooooo08koool003Woool00`1Vooooooooo`0ioooo00@0003ooooo
ool00008oooo00<0003oooooool00oooo`040000oooooooo00001?ooo`030000oooooooo08koool0
03Woool00`1Vooooooooo`0ioooo00@0003oooooool00009oooo00<0003oooooool01Oooo`030000
oooooooo00;oool30000S_ooo`00>Oooo`0306Kooooooooo03Woool010000?ooooooo`0000[oool0
0`000?ooooooo`02oooo0P0000Goool00`000?ooooooo`2>oooo000ioooo00<0I_ooooooool0>Ooo
o`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo00Coool00`000?oo
ooooo`2>oooo000ioooo00<0I_ooooooool0>Oooo`0306Ko0000000000[oool200001?ooo`<00004
oooo00<0003oooooool0S_ooo`00>Oooo`0306Kooooooooo03Woool00`1Vooooooooo`0Goooo0P00
08ooool003Woool00`1Vooooooooo`0ioooo00<0I_ooooooool05oooo`030000oooooooo08koool0
03Woool00`1Vooooooooo`0ioooo00<0I_ooooooool05oooo`030000oooooooo08koool003Woool0
0`1Vooooooooo`0ioooo00<0I_ooooooool05oooo`030000oooooooo08koool003Woool00`1Voooo
ooooo`0ioooo00<0I_ooooooool05oooo`80002?oooo000ioooo00<0I_ooooooool0>Oooo`0306Ko
oooooooo01Ooool00`000?ooooooo`2>oooo000ioooo00<0I_ooooooool0>Oooo`0306Kooooooooo
01Ooool00`000?ooooooo`2>oooo000ioooo00<0I_ooooooool0>Oooo`0306Kooooooooo01Ooool0
0`000?ooooooo`2>oooo000ioooo00<0I_ooooooool0>Oooo`0306Kooooooooo01Ooool20000Sooo
o`00>Oooo`0306Kooooooooo03Woool00`1Vooooooooo`0Goooo00<0003oooooool0S_ooo`00>Ooo
o`0306Kooooooooo03Woool00`1Vooooooooo`0Goooo00<0003oooooool0S_ooo`00>Oooo`0306Ko
oooooooo03Woool00`1Vooooooooo`0Goooo00<0003oooooool0S_ooo`00>Oooo`0306Kooooooooo
03Woool00`1Vooooooooo`0Goooo0P0008ooool003Woool00`1Vooooooooo`0ioooo00<0I_oooooo
ool05oooo`030000oooooooo08koool003Woool00`1Vooooooooo`0ioooo00<0I_ooooooool01?oo
o`800004oooo0P0000Coool200001Oooo`030000oooooooo08koool003Woool00`1Vooooooooo`0i
oooo00<0I_ooooooool00oooo`040000oooooooo00002?ooo`040000oooooooo00001?ooo`030000
oooooooo08koool003Wooolm06Ko1Oooo`040000oooooooo00002oooo`030000oooooooo00;oool3
0000S_ooo`00MOooo`03o`2Ioooooooo00?oool010000?ooooooo`0000Woool200001Oooo`030000
oooooooo08koool007Goool00ol0VOooooooo`03oooo00@0003oooooool00009oooo00<0003ooooo
ool01?ooo`030000oooooooo08koool007Goool00ol0VOooooooo`04oooo0P0000[oool300001?oo
o`030000oooooooo08koool007Goool00ol0VOooooooo`0Goooo0P0008ooool007Goool00ol0VOoo
ooooo`0Goooo00<0003oooooool0S_ooo`00MOooo`03o`2Ioooooooo01Ooool00`000?ooooooo`2>
oooo001eoooo00?o09Woooooool05oooo`80002?oooo001eoooo00?o09Woooooool05oooo`030000
oooooooo08koool007Goool00ol0VOooooooo`0Goooo00<0003oooooool0S_ooo`00MOooo`03o`2I
oooooooo01Ooool00`000?ooooooo`2>oooo001eoooo00?o09Woooooool05oooo`80002?oooo001e
oooo00?o09Woooooool05oooo`030000oooooooo08koool007Goool00ol0VOooooooo`0Goooo00<0
003oooooool0S_ooo`00MOooo`03o`2Ioooooooo01Ooool00`000?ooooooo`2>oooo001eoooo00?o
09Woooooool05oooo`80002?oooo001eoooo00?o09Woooooool05oooo`030000oooooooo08koool0
07Goool00ol0V@0000000004oooo0P0000Goool00`000?ooooooo`02oooo0P0000Goool00`000?oo
ooooo`2>oooo001eoooo00@0003oooooool0000:oooo00D0003oooooooooool000000_ooo`030000
oooooooo00;oool00`000?ooooooo`2>oooo001eoooo00@0003oooooool0000:oooo00<0003ooooo
ool01?ooo`030000oooooooo00;oool30000S_ooo`00MOooo`040000oooooooo00002oooo`040000
oooooooooooo0P0000Goool00`000?ooooooo`2>oooo001eoooo00@0003oooooool00008oooo00@0
003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo08koool007Goool00ol0V@00
00000009oooo100000?oool300001?ooo`030000oooooooo08koool007Goool00ol0VOooooooo`0G
oooo0P0008ooool007Goool00ol0VOooooooo`0Goooo00<0003oooooool0S_ooo`00MOooo`03o`2I
oooooooo01Ooool00`000?ooooooo`2>oooo001eoooo00?o09Woooooool05oooo`030000oooooooo
08koool007Goool00ol0VOooooooo`0Goooo0P0008ooool007Goool00ol0VOooooooo`0Goooo00<0
003oooooool0S_ooo`00MOooo`03o`2Ioooooooo01Ooool00`000?ooooooo`2>oooo001eoooo00?o
09Woooooool05oooo`030000oooooooo08koool007Goool00ol0VOooooooo`0Goooo0P0008ooool0
07Goool00ol0VOooooooo`0Goooo00<0003oooooool0S_ooo`00MOooo`03o`2Ioooooooo01Ooool0
0`000?ooooooo`2>oooo001eoooo00?o09Woooooool05oooo`030000oooooooo08koool007Goool0
0ol0VOooooooo`0Goooo0P0008ooool007Goool00ol0VOooooooo`0Goooo00<0003oooooool0S_oo
o`00MOooo`03o`2Ioooooooo00ooool500000oooo`030000oooooooo08koool007Goool00ol0VOoo
ooooo`0Aoooo00<0003oooooool00oooo`030000oooooooo08koool007Goool00ol0VOooooooo`0A
oooo00<0003oooooool00oooo`<0002>oooo0029oooo00<0003oooooool0U?ooo`00ROooo`030000
oooooooo09Coool008Soool20000U_ooo`00ooooob7oool00?oooolQoooo001foooo00<0003ooooo
ool0;_ooo`030000oooooooo07Koool007Goool00`000?ooooooo`08oooo00<0003oooooool09Ooo
o`030000oooooooo07Goool007Goool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<
oooo1@0000;oool200001?ooo`800004oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0
003oooooooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`04oooo100000Goool0
0`000?ooooooo`07oooo00@0003oooooool00002oooo00@0003oooooool00003oooo00<0003ooooo
ool0MOooo`00M?ooo`030000oooooooo00;oool00`000?ooooooo`0Eoooo00<0003oooooool01ooo
o`040000oooooooo00001Oooo`030000oooooooo00;oool00`000?ooooooo`1doooo001eoooo00<0
003oooooool01@0001Coool00`000?ooooooo`08oooo0P0000Coool200001?ooo`030000oooooooo
07Goool007Goool01@000?ooooooooooo`00000Goooo00<0003oooooool01oooo`040000oooooooo
00000oooo`030000oooooooo00?oool00`000?ooooooo`1eoooo001foooo00<0003oooooool05ooo
o`80000:oooo0P0000Coool300000_ooo`030000oooooooo07Koool00?oooolQoooo003ooooo8Ooo
o`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.39174 .30902 L
.39675 .30902 L
.40134 .30902 L
.40252 .30902 L
.40381 .30902 L
s
.40381 .30902 m
.40393 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.12507 .30902 L
.14415 .30902 L
.1536 .30902 L
.15825 .30902 L
.16254 .30902 L
.16494 .30902 L
.16615 .30902 L
.16683 .46353 L
.16748 .46353 L
.17284 .46353 L
.18221 .46353 L
.22098 .46353 L
.2622 .46353 L
.30191 .46353 L
.34011 .46353 L
.36142 .46353 L
.38075 .46353 L
.39043 .46353 L
.39552 .46353 L
.3983 .46353 L
.4009 .46353 L
.40317 .46353 L
.40445 .46353 L
.40561 .30902 L
.40688 .30902 L
.40827 .30902 L
.41079 .30902 L
.41988 .30902 L
.46066 .30902 L
.49993 .30902 L
.53768 .30902 L
.57788 .30902 L
.61657 .30902 L
.65771 .30902 L
.69733 .30902 L
.73544 .30902 L
.776 .30902 L
.81505 .30902 L
.85655 .30902 L
.89653 .30902 L
.935 .30902 L
.97591 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`03oooo00<0I_ooooooool01oooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0
003oooooool03?ooo`030000oooooooo00?oool00`1Vooooooooo`06oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo
00coool00`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo00coool00`000?oo
ooooo`0<oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo027oool00`1Vooooooooo`0F
oooo00<0003oooooool08Oooo`0306Kooooooooo01Goool00`000?ooooooo`0ioooo00<0003ooooo
ool0>_ooo`030000oooooooo01Goool003[oool00`1Vooooooooo`0joooo00<0I_ooooooool05Ooo
o`030000oooooooo08koool003[oool00`1Vooooooooo`0joooo00<0I_ooooooool05Oooo`80002?
oooo000joooo00<0I_ooooooool0>_ooo`0306Kooooooooo01Goool00`000?ooooooo`2>oooo000j
oooo00<0I_ooooooool0>_ooo`0306Kooooooooo01Goool00`000?ooooooo`2>oooo000joooo00<0
I_ooooooool0>_ooo`0306Kooooooooo01Goool00`000?ooooooo`2>oooo000joooo00<0I_oooooo
ool0>_ooo`0306Kooooooooo01Goool20000Soooo`00>_ooo`0306Kooooooooo03[oool00`1Voooo
ooooo`0Eoooo00<0003oooooool0S_ooo`00>_ooo`0306Kooooooooo03[oool00`1Vooooooooo`0E
oooo00<0003oooooool0S_ooo`00>_ooo`0306Kooooooooo03[oool00`1Vooooooooo`0Eoooo00<0
003oooooool0S_ooo`00>_ooo`0306Kooooooooo03[oool00`1Vooooooooo`0Eoooo0P0008ooool0
03[oool00`1Vooooooooo`0joooo00<0I_ooooooool05Oooo`030000oooooooo08koool003[oool0
0`1Vooooooooo`0joooo00<0I_ooooooool05Oooo`030000oooooooo08koool003[oool00`1Voooo
ooooo`0joooo00<0I_ooooooool05Oooo`030000oooooooo08koool003[oool00`1Vooooooooo`0j
oooo00<0I_ooooooool05Oooo`80002?oooo000joooo00<0I_ooooooool0>_ooo`0306Kooooooooo
01Goool00`000?ooooooo`2>oooo000joooo00<0I_ooooooool0>Oooo`800004oooo0P0000?oool4
00000oooo`800005oooo00<0003oooooool0S_ooo`00>_ooo`0306Kooooooooo03Soool010000?oo
o`1Vo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004oooo00<0003oooooool0S_oo
o`00>_ooo`0306Kooooooooo03Soool010000?ooo`1Vo`0000Woool00`000?ooooooo`05oooo00<0
003oooooool00_ooo`<0002>oooo000joooo00<0I_ooooooool0>?ooo`040000oooo06Ko00002_oo
o`030000oooooooo00;oool200001Oooo`030000oooooooo08koool003[oool00`1Vooooooooo`0h
oooo00@0003oool0I_l00008oooo00@0003oooooool00003oooo00<0003oooooool01?ooo`030000
oooooooo08koool003[oool00`1Vooooooooo`0ioooo0P0000[oool200001?ooo`<00004oooo00<0
003oooooool0S_ooo`00>_ooo`0306Kooooooooo03[oool00`1Vooooooooo`0Eoooo0P0008ooool0
03[oool00`1Vooooooooo`0joooo00<0I_ooooooool05Oooo`030000oooooooo08koool003[oool0
0`1Vooooooooo`0joooo00<0I_ooooooool05Oooo`030000oooooooo08koool003[oool00`1Voooo
ooooo`0joooo00<0I_ooooooool05Oooo`030000oooooooo08koool003[oool00`1Vooooooooo`0j
oooo00<0I_ooooooool05Oooo`80002?oooo000joooo00<0I_ooooooool0>_ooo`0306Kooooooooo
01Goool00`000?ooooooo`2>oooo000joooo00<0I_ooooooool0>_ooo`0306Kooooooooo01Goool0
0`000?ooooooo`2>oooo000joooo00<0I_ooooooool0>_ooo`0306Kooooooooo01Goool00`000?oo
ooooo`2>oooo000joooo00<0I_ooooooool0>_ooo`0306Kooooooooo01Goool20000Soooo`00>_oo
o`0306Kooooooooo03[oool00`1Vooooooooo`0Eoooo00<0003oooooool0S_ooo`00>_ooo`0306Ko
oooooooo03[oool00`1Vooooooooo`0Eoooo00<0003oooooool0S_ooo`00>_ooo`0306Kooooooooo
03[oool00`1Vooooooooo`0Eoooo00<0003oooooool0S_ooo`00>_ooo`0306Kooooooooo03[oool0
0`1Vooooooooo`0Eoooo0P0008ooool003[oool00`1Vooooooooo`0joooo00<0I_ooooooool05Ooo
o`030000oooooooo08koool003[oool00`1Vooooooooo`0joooo00<0I_ooooooool00_ooo`800004
oooo0P0000Coool200001Oooo`030000oooooooo08koool003[oool00`1Vooooooooo`0joooo00D0
I_ooooooooooool000000_ooo`030000oooooooo00Koool010000?ooooooo`0000Coool00`000?oo
ooooo`2>oooo000joooo?P1Vo`?oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Ooool01Ol0VOooooooooooo`000002oooo00<0003oooooool01oooo`800005oooo00<0
003oooooool0S_ooo`00Moooo`05o`2Ioooooooooooo000000;oool00`000?ooooooo`07oooo00<0
003oooooool01?ooo`030000oooooooo08koool007Ooool00ol0VOooooooo`02oooo0P0000[oool3
00001?ooo`030000oooooooo08koool007Ooool00ol0VOooooooo`0Eoooo0P0008ooool007Ooool0
0ol0VOooooooo`0Eoooo00<0003oooooool0S_ooo`00Moooo`03o`2Ioooooooo01Goool00`000?oo
ooooo`2>oooo001goooo00?o09Woooooool05Oooo`80002?oooo001goooo00?o09Woooooool05Ooo
o`030000oooooooo08koool007Ooool00ol0VOooooooo`0Eoooo00<0003oooooool0S_ooo`00Mooo
o`03o`2Ioooooooo01Goool00`000?ooooooo`2>oooo001goooo00?o09Woooooool05Oooo`80002?
oooo001goooo00?o09Woooooool05Oooo`030000oooooooo08koool007Ooool00ol0VOooooooo`0E
oooo00<0003oooooool0S_ooo`00Moooo`03o`2Ioooooooo01Goool00`000?ooooooo`2>oooo001g
oooo00?o09Woooooool05Oooo`80002?oooo001goooo00?o09Woooooool05Oooo`030000oooooooo
08koool007Koool200001?ooo`800005oooo00<0003oooooool00_ooo`800005oooo00<0003ooooo
ool0S_ooo`00MOooo`040000ooooo`2I00002_ooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool0S_ooo`00MOooo`040000ooooo`2I00002_ooo`030000oooooooo
00Coool00`000?ooooooo`02oooo0`0008koool007Goool010000?ooool0V@0000_oool010000?oo
ooooooooo`800005oooo00<0003oooooool0S_ooo`00MOooo`040000ooooo`2I00002?ooo`040000
oooooooo00000oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool4
00000oooo`<00004oooo00<0003oooooool0S_ooo`00Moooo`03o`2Ioooooooo01Goool20000Sooo
o`00Moooo`03o`2Ioooooooo01Goool00`000?ooooooo`2>oooo001goooo00?o09Woooooool05Ooo
o`030000oooooooo08koool007Ooool00ol0VOooooooo`0Eoooo00<0003oooooool0S_ooo`00Mooo
o`03o`2Ioooooooo01Goool20000Soooo`00Moooo`03o`2Ioooooooo01Goool00`000?ooooooo`2>
oooo001goooo00?o09Woooooool05Oooo`030000oooooooo08koool007Ooool00ol0VOooooooo`0E
oooo00<0003oooooool0S_ooo`00Moooo`03o`2Ioooooooo01Goool20000Soooo`00Moooo`03o`2I
oooooooo01Goool00`000?ooooooo`2>oooo001goooo00?o09Woooooool05Oooo`030000oooooooo
08koool007Ooool00ol0VOooooooo`0Eoooo00<0003oooooool0S_ooo`00Moooo`03o`2Ioooooooo
01Goool20000Soooo`00Moooo`03o`2Ioooooooo01Goool00`000?ooooooo`2>oooo001goooo00?o
09Woooooool03Oooo`D00003oooo00<0003oooooool0S_ooo`00Moooo`03o`2Ioooooooo00ooool0
0`000?ooooooo`03oooo00<0003oooooool0S_ooo`00Moooo`03o`2Ioooooooo00ooool00`000?oo
ooooo`03oooo0`0008koool008Woool00`000?ooooooo`2Doooo0029oooo00<0003oooooool0U?oo
o`00R?ooo`80002Foooo003ooooo8Oooo`00ooooob7oool007Woool00`000?ooooooo`0Xoooo00<0
003oooooool0NOooo`00N?ooo`030000oooooooo00Soool00`000?ooooooo`0Ooooo00<0003ooooo
ool0N?ooo`00N?ooo`030000oooooooo00;oool200001?ooo`030000oooooooo00coool500000_oo
o`800004oooo0P0000Coool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000000_oo
o`030000oooooooo00;oool00`000?ooooooo`04oooo100000Goool00`000?ooooooo`07oooo00@0
003oooooool00003oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo00;oool00`000?oo
ooooo`0Eoooo00<0003oooooool01oooo`040000oooooooo00001?ooo`030000oooooooo07Ooool0
07Soool00`000?ooooooo`0500005?ooo`030000oooooooo00Soool200001?ooo`030000oooooooo
07Soool007Soool01@000?ooooooooooo`00000Goooo00<0003oooooool01oooo`040000oooooooo
00000oooo`030000oooooooo07Soool007Woool00`000?ooooooo`0Goooo0P0000[oool200000ooo
o`030000oooooooo07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.75) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.39174 .30902 L
.40134 .30902 L
.40616 .30902 L
.40755 .30902 L
.40887 .30902 L
.41005 .30902 L
s
.41005 .30902 m
.41018 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.12507 .30902 L
.14415 .30902 L
.1536 .30902 L
.16254 .30902 L
.16748 .30902 L
.16883 .30902 L
.17026 .30902 L
.17149 .30902 L
.17219 .30902 L
.17284 .46353 L
.17405 .46353 L
.1752 .46353 L
.17735 .46353 L
.18221 .46353 L
.2204 .46353 L
.26105 .46353 L
.30018 .46353 L
.34176 .46353 L
.36263 .46353 L
.38182 .46353 L
.40057 .46353 L
.40513 .46353 L
.40764 .46353 L
.40887 .46353 L
.41001 .46353 L
.41066 .46353 L
.41135 .30902 L
.41205 .30902 L
.41282 .30902 L
.41537 .30902 L
.42038 .30902 L
.46058 .30902 L
.49927 .30902 L
.54041 .30902 L
.58003 .30902 L
.61814 .30902 L
.6587 .30902 L
.69774 .30902 L
.73924 .30902 L
.77922 .30902 L
.81769 .30902 L
.85861 .30902 L
.89801 .30902 L
.9359 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.75) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`05oooo00<0I_ooooooool01Oooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0
003oooooool03?ooo`030000oooooooo00Coool00`1Vooooooooo`05oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo
00coool00`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo00coool00`000?oo
ooooo`0<oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo02?oool00`1Vooooooooo`0D
oooo00<0003oooooool08_ooo`0306Kooooooooo01Coool00`000?ooooooo`0ioooo00<0003ooooo
ool0>_ooo`030000oooooooo01Goool003coool00`1Vooooooooo`0ioooo00<0I_ooooooool05?oo
o`030000oooooooo08koool003coool00`1Vooooooooo`0ioooo00<0I_ooooooool05?ooo`80002?
oooo000loooo00<0I_ooooooool0>Oooo`0306Kooooooooo01Coool00`000?ooooooo`2>oooo000l
oooo00<0I_ooooooool0>Oooo`0306Kooooooooo01Coool00`000?ooooooo`2>oooo000loooo00<0
I_ooooooool0>Oooo`0306Kooooooooo01Coool00`000?ooooooo`2>oooo000loooo00<0I_oooooo
ool0>Oooo`0306Kooooooooo01Coool20000Soooo`00??ooo`0306Kooooooooo03Woool00`1Voooo
ooooo`0Doooo00<0003oooooool0S_ooo`00??ooo`0306Kooooooooo03Woool00`1Vooooooooo`0D
oooo00<0003oooooool0S_ooo`00??ooo`0306Kooooooooo03Woool00`1Vooooooooo`0Doooo00<0
003oooooool0S_ooo`00??ooo`0306Kooooooooo03Woool00`1Vooooooooo`0Doooo0P0008ooool0
03coool00`1Vooooooooo`0ioooo00<0I_ooooooool05?ooo`030000oooooooo08koool003coool0
0`1Vooooooooo`0ioooo00<0I_ooooooool05?ooo`030000oooooooo08koool003coool00`1Voooo
ooooo`0ioooo00<0I_ooooooool05?ooo`030000oooooooo08koool003coool00`1Vooooooooo`0i
oooo00<0I_ooooooool05?ooo`80002?oooo000loooo00<0I_ooooooool0>Oooo`0306Kooooooooo
01Coool00`000?ooooooo`2>oooo000loooo00<0I_ooooooool0=oooo`800000101Voooooooooooo
o`800003oooo100000?oool200001Oooo`030000oooooooo08koool003coool00`1Vooooooooo`0f
oooo00@0003oooooool00008oooo00<0003oooooool00oooo`040000oooooooo00001?ooo`030000
oooooooo08koool003coool00`1Vooooooooo`0foooo00@0003oooooool00009oooo00<0003ooooo
ool01Oooo`030000oooooooo00;oool30000S_ooo`00??ooo`0306Kooooooooo03Koool010000?oo
ooooo`0000[oool00`000?ooooooo`02oooo0P0000Goool00`000?ooooooo`2>oooo000loooo00<0
I_ooooooool0=_ooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo
00Coool00`000?ooooooo`2>oooo000loooo00<0I_ooooooool0=oooo`8000000`1Vooooooooo`07
oooo0P0000Coool300001?ooo`030000oooooooo08koool003coool00`1Vooooooooo`0ioooo00<0
I_ooooooool05?ooo`80002?oooo000loooo00<0I_ooooooool0>Oooo`0306Kooooooooo01Coool0
0`000?ooooooo`2>oooo000loooo00<0I_ooooooool0>Oooo`0306Kooooooooo01Coool00`000?oo
ooooo`2>oooo000loooo00<0I_ooooooool0>Oooo`0306Kooooooooo01Coool00`000?ooooooo`2>
oooo000loooo00<0I_ooooooool0>Oooo`0306Kooooooooo01Coool20000Soooo`00??ooo`0306Ko
oooooooo03Woool00`1Vooooooooo`0Doooo00<0003oooooool0S_ooo`00??ooo`0306Kooooooooo
03Woool00`1Vooooooooo`0Doooo00<0003oooooool0S_ooo`00??ooo`0306Kooooooooo03Woool0
0`1Vooooooooo`0Doooo00<0003oooooool0S_ooo`00??ooo`0306Kooooooooo03Woool00`1Voooo
ooooo`0Doooo0P0008ooool003coool00`1Vooooooooo`0ioooo00<0I_ooooooool05?ooo`030000
oooooooo08koool003coool00`1Vooooooooo`0ioooo00<0I_ooooooool05?ooo`030000oooooooo
08koool003coool00`1Vooooooooo`0ioooo00<0I_ooooooool05?ooo`030000oooooooo08koool0
03coool00`1Vooooooooo`0ioooo00<0I_ooooooool05?ooo`80002?oooo000loooo00<0I_oooooo
ool0>Oooo`0306Kooooooooo01Coool00`000?ooooooo`2>oooo000loooo00<0I_ooooooool0>Ooo
o`0406Kooooooooooooo0P0000Coool200001?ooo`800005oooo00<0003oooooool0S_ooo`00??oo
o`0306Kooooooooo03Woool0101Vooooooooo`0000;oool00`000?ooooooo`06oooo00@0003ooooo
ool00004oooo00<0003oooooool0S_ooo`00??ooocd0I_l2oooo00@0003oooooool0000;oooo00<0
003oooooool00_ooo`<0002>oooo001hoooo00Co09Woooooool00002oooo00<0003oooooool01ooo
o`800005oooo00<0003oooooool0S_ooo`00N?ooo`04o`2Ioooooooo00000_ooo`030000oooooooo
00Ooool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00N?ooo`04o`2Ioooooooooooo0P00
00[oool300001?ooo`030000oooooooo08koool007Soool00ol0VOooooooo`0Doooo0P0008ooool0
07Soool00ol0VOooooooo`0Doooo00<0003oooooool0S_ooo`00N?ooo`03o`2Ioooooooo01Coool0
0`000?ooooooo`2>oooo001hoooo00?o09Woooooool05?ooo`80002?oooo001hoooo00?o09Wooooo
ool05?ooo`030000oooooooo08koool007Soool00ol0VOooooooo`0Doooo00<0003oooooool0S_oo
o`00N?ooo`03o`2Ioooooooo01Coool00`000?ooooooo`2>oooo001hoooo00?o09Woooooool05?oo
o`80002?oooo001hoooo00?o09Woooooool05?ooo`030000oooooooo08koool007Soool00ol0VOoo
ooooo`0Doooo00<0003oooooool0S_ooo`00N?ooo`03o`2Ioooooooo01Coool00`000?ooooooo`2>
oooo001hoooo00?o09Woooooool05?ooo`80002?oooo001hoooo00?o09Woooooool05?ooo`030000
oooooooo08koool007Koool2000000Co09Woooooooooool200001Oooo`030000oooooooo00;oool2
00001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000[oool01@000?oooooooooo
o`000002oooo00<0003oooooool00_ooo`030000oooooooo08koool007Goool010000?ooooooo`00
00[oool00`000?ooooooo`04oooo00<0003oooooool00_ooo`<0002>oooo001eoooo00@0003ooooo
ool0000;oooo00@0003oooooooooool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000Soool010000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_oo
o`00M_ooo`8000000ol0VOooooooo`06oooo100000?oool300001?ooo`030000oooooooo08koool0
07Soool00ol0VOooooooo`0Doooo0P0008ooool007Soool00ol0VOooooooo`0Doooo00<0003ooooo
ool0S_ooo`00N?ooo`03o`2Ioooooooo01Coool00`000?ooooooo`2>oooo001hoooo00?o09Wooooo
ool05?ooo`030000oooooooo08koool007Soool00ol0VOooooooo`0Doooo0P0008ooool007Soool0
0ol0VOooooooo`0Doooo00<0003oooooool0S_ooo`00N?ooo`03o`2Ioooooooo01Coool00`000?oo
ooooo`2>oooo001hoooo00?o09Woooooool05?ooo`030000oooooooo08koool007Soool00ol0VOoo
ooooo`0Doooo0P0008ooool007Soool00ol0VOooooooo`0Doooo00<0003oooooool0S_ooo`00N?oo
o`03o`2Ioooooooo01Coool00`000?ooooooo`2>oooo001hoooo00?o09Woooooool05?ooo`030000
oooooooo08koool007Soool00ol0VOooooooo`0Doooo0P0008ooool007Soool00ol0VOooooooo`0D
oooo00<0003oooooool0S_ooo`00N?ooo`03o`2Ioooooooo00coool500000oooo`030000oooooooo
08koool007Soool00ol0VOooooooo`0>oooo00<0003oooooool00oooo`030000oooooooo08koool0
07Soool00ol0VOooooooo`0>oooo00<0003oooooool00oooo`<0002>oooo0029oooo00<0003ooooo
ool0U?ooo`00ROooo`030000oooooooo09Coool008Soool20000U_ooo`00ooooob7oool00?oooolQ
oooo001foooo00<0003oooooool0;_ooo`030000oooooooo07Koool007Goool00`000?ooooooo`08
oooo00<0003oooooool09Oooo`030000oooooooo07Goool007Goool00`000?ooooooo`02oooo0P00
00Coool00`000?ooooooo`0<oooo1@0000;oool200001Oooo`030000oooooooo00;oool200001?oo
o`030000oooooooo07Goool007Goool01@000?ooooooooooo`000002oooo00<0003oooooool00_oo
o`030000oooooooo00Coool400001Oooo`030000oooooooo00Woool01@000?ooooooooooo`000002
oooo00D0003oooooooooool00000Moooo`00M?ooo`030000oooooooo00;oool00`000?ooooooo`0E
oooo00<0003oooooool02Oooo`030000oooooooo00Coool00`000?ooooooo`02oooo00<0003ooooo
ool0M?ooo`00MOooo`030000oooooooo00D0000Doooo00<0003oooooool02_ooo`040000oooooooo
oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000005oooo`030000
oooooooo00Ooool010000?ooooooo`0000?oool00`000?ooooooo`03oooo00<0003oooooool0MOoo
o`00M_ooo`030000oooooooo01Ooool200002Oooo`@00003oooo0`0000;oool00`000?ooooooo`1f
oooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.7) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.40134 .30902 L
.40616 .30902 L
.41134 .30902 L
.41287 .30902 L
.41432 .30902 L
.41562 .30902 L
.41635 .30902 L
s
.41635 .30902 m
.41642 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.12507 .30902 L
.14415 .30902 L
.16254 .30902 L
.16783 .30902 L
.17284 .30902 L
.17502 .30902 L
.17733 .30902 L
.17854 .30902 L
.17922 .46353 L
.17987 .46353 L
.18221 .46353 L
.22098 .46353 L
.2622 .46353 L
.30191 .46353 L
.34011 .46353 L
.36142 .46353 L
.38075 .46353 L
.39043 .46353 L
.4009 .46353 L
.40571 .46353 L
.41079 .46353 L
.41288 .46353 L
.41512 .46353 L
.41641 .46353 L
.41758 .30902 L
.41876 .30902 L
.41988 .30902 L
.45821 .30902 L
.49899 .30902 L
.53826 .30902 L
.57601 .30902 L
.61621 .30902 L
.6549 .30902 L
.69604 .30902 L
.73566 .30902 L
.77377 .30902 L
.81433 .30902 L
.85338 .30902 L
.89488 .30902 L
.93486 .30902 L
.97332 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.7) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`06oooo00<0I_ooooooool01?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0
003oooooool03?ooo`030000oooooooo00Koool00`1Vooooooooo`03oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo
00coool00`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo00coool00`000?oo
ooooo`0<oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo02Coool00`1Vooooooooo`0C
oooo00<0003oooooool09?ooo`0306Kooooooooo01;oool00`000?ooooooo`0ioooo00<0003ooooo
ool0>_ooo`030000oooooooo01Goool003goool00`1Vooooooooo`0joooo00<0I_ooooooool04_oo
o`030000oooooooo08koool003goool00`1Vooooooooo`0joooo00<0I_ooooooool04_ooo`80002?
oooo000moooo00<0I_ooooooool0>_ooo`0306Kooooooooo01;oool00`000?ooooooo`2>oooo000m
oooo00<0I_ooooooool0>_ooo`0306Kooooooooo01;oool00`000?ooooooo`2>oooo000moooo00<0
I_ooooooool0>_ooo`0306Kooooooooo01;oool00`000?ooooooo`2>oooo000moooo00<0I_oooooo
ool0>_ooo`0306Kooooooooo01;oool20000Soooo`00?Oooo`0306Kooooooooo03[oool00`1Voooo
ooooo`0Boooo00<0003oooooool0S_ooo`00?Oooo`0306Kooooooooo03[oool00`1Vooooooooo`0B
oooo00<0003oooooool0S_ooo`00?Oooo`0306Kooooooooo03[oool00`1Vooooooooo`0Boooo00<0
003oooooool0S_ooo`00?Oooo`0306Kooooooooo03[oool00`1Vooooooooo`0Boooo0P0008ooool0
03goool00`1Vooooooooo`0joooo00<0I_ooooooool04_ooo`030000oooooooo08koool003goool0
0`1Vooooooooo`0joooo00<0I_ooooooool04_ooo`030000oooooooo08koool003goool00`1Voooo
ooooo`0joooo00<0I_ooooooool04_ooo`030000oooooooo08koool003goool00`1Vooooooooo`0j
oooo00<0I_ooooooool04_ooo`80002?oooo000moooo00<0I_ooooooool0>_ooo`0306Kooooooooo
01;oool00`000?ooooooo`2>oooo000moooo00<0I_ooooooool0=_ooo`800002oooo00@0I_ooool0
00000003oooo100000?oool200001Oooo`030000oooooooo08koool003goool00`1Vooooooooo`0e
oooo00H0003oooooool0003oool0I_l6oooo00<0003oooooool00oooo`040000oooooooo00001?oo
o`030000oooooooo08koool003goool00`1Vooooooooo`0eoooo00H0003oooooool0003oool0I_l7
oooo00<0003oooooool01Oooo`030000oooooooo00;oool30000S_ooo`00?_ooo`0306Kooooooooo
03Coool01P000?ooooooo`000?ooo`1Vo`Soool00`000?ooooooo`02oooo0P0000Goool00`000?oo
ooooo`2>oooo000noooo00<0I_ooooooool0=?ooo`060000oooooooo0000oooo06Ko1_ooo`040000
oooooooo00000oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo000noooo00<0I_oooooo
ool0=Oooo`800002oooo00<0I_ooooooool01Oooo`800004oooo0`0000Coool00`000?ooooooo`2>
oooo000noooo00<0I_ooooooool0>Oooo`0306Kooooooooo01;oool20000Soooo`00?_ooo`0306Ko
oooooooo03Woool00`1Vooooooooo`0Boooo00<0003oooooool0S_ooo`00?_ooo`0306Kooooooooo
03Woool00`1Vooooooooo`0Boooo00<0003oooooool0S_ooo`00?_ooo`0306Kooooooooo03Woool0
0`1Vooooooooo`0Boooo00<0003oooooool0S_ooo`00?_ooo`0306Kooooooooo03Woool00`1Voooo
ooooo`0Boooo0P0008ooool003koool00`1Vooooooooo`0ioooo00<0I_ooooooool04_ooo`030000
oooooooo08koool003koool00`1Vooooooooo`0ioooo00<0I_ooooooool04_ooo`030000oooooooo
08koool003koool00`1Vooooooooo`0ioooo00<0I_ooooooool04_ooo`030000oooooooo08koool0
03koool00`1Vooooooooo`0ioooo00<0I_ooooooool04_ooo`80002?oooo000noooo00<0I_oooooo
ool0>Oooo`0306Kooooooooo01;oool00`000?ooooooo`2>oooo000noooo00<0I_ooooooool0>Ooo
o`0306Kooooooooo01;oool00`000?ooooooo`2>oooo000noooo00<0I_ooooooool0>Oooo`0306Ko
oooooooo01;oool00`000?ooooooo`2>oooo000noooo00<0I_ooooooool0>Oooo`0306Kooooooooo
01;oool20000Soooo`00?_ooo`0306Kooooooooo03Woool00`1Vooooooooo`0Boooo00<0003ooooo
ool0S_ooo`00?_ooo`0306Kooooooooo03Woool0101Vooooo`00000000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00?_ooo`0306Kooooooooo03Woool01@1Vo`000?ooooooo`000008
oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00?_ooocd0I_l010000?ooooooo`00
00_oool00`000?ooooooo`02oooo0`0008koool007[oool01Ol0V@000?ooooooo`000009oooo0P00
00Goool00`000?ooooooo`2>oooo001joooo00Go09T0003oooooool000002Oooo`030000oooooooo
00Coool00`000?ooooooo`2>oooo001joooo00Co09Woool00000000:oooo0`0000Coool00`000?oo
ooooo`2>oooo001joooo00?o09Woooooool04_ooo`80002?oooo001joooo00?o09Woooooool04_oo
o`030000oooooooo08koool007[oool00ol0VOooooooo`0Boooo00<0003oooooool0S_ooo`00N_oo
o`03o`2Ioooooooo01;oool20000Soooo`00N_ooo`03o`2Ioooooooo01;oool00`000?ooooooo`2>
oooo001joooo00?o09Woooooool04_ooo`030000oooooooo08koool007[oool00ol0VOooooooo`0B
oooo00<0003oooooool0S_ooo`00N_ooo`03o`2Ioooooooo01;oool20000Soooo`00N_ooo`03o`2I
oooooooo01;oool00`000?ooooooo`2>oooo001joooo00?o09Woooooool04_ooo`030000oooooooo
08koool007[oool00ol0VOooooooo`0Boooo00<0003oooooool0S_ooo`00N_ooo`03o`2Ioooooooo
01;oool20000Soooo`00N_ooo`03o`2Ioooooooo01;oool00`000?ooooooo`2>oooo001foooo0P00
00;oool01?l0VOooo`00000000Goool00`000?ooooooo`02oooo0P0000Goool00`000?ooooooo`2>
oooo001eoooo00H0003oooooool0003ooooo09T8oooo00D0003oooooooooool000000_ooo`030000
oooooooo00;oool00`000?ooooooo`2>oooo001eoooo00H0003oooooool0003ooooo09T8oooo00<0
003oooooool01?ooo`030000oooooooo00;oool30000S_ooo`00MOooo`060000oooooooo0000oooo
o`2I2Oooo`040000oooooooooooo0P0000Goool00`000?ooooooo`2>oooo001eoooo00H0003ooooo
ool0003ooooo09T6oooo00@0003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo
08koool007Koool200000_ooo`03o`2Ioooooooo00Coool400000oooo`<00004oooo00<0003ooooo
ool0S_ooo`00N_ooo`03o`2Ioooooooo01;oool20000Soooo`00N_ooo`03o`2Ioooooooo01;oool0
0`000?ooooooo`2>oooo001joooo00?o09Woooooool04_ooo`030000oooooooo08koool007[oool0
0ol0VOooooooo`0Boooo00<0003oooooool0S_ooo`00N_ooo`03o`2Ioooooooo01;oool20000Sooo
o`00N_ooo`03o`2Ioooooooo01;oool00`000?ooooooo`2>oooo001joooo00?o09Woooooool04_oo
o`030000oooooooo08koool007[oool00ol0VOooooooo`0Boooo00<0003oooooool0S_ooo`00N_oo
o`03o`2Ioooooooo01;oool20000Soooo`00N_ooo`03o`2Ioooooooo01;oool00`000?ooooooo`2>
oooo001joooo00?o09Woooooool04_ooo`030000oooooooo08koool007[oool00ol0VOooooooo`0B
oooo00<0003oooooool0S_ooo`00N_ooo`03o`2Ioooooooo01;oool20000Soooo`00N_ooo`03o`2I
oooooooo01;oool00`000?ooooooo`2>oooo001joooo00?o09Woooooool02_ooo`D00003oooo00<0
003oooooool0S_ooo`00N_ooo`03o`2Ioooooooo00coool00`000?ooooooo`03oooo00<0003ooooo
ool0S_ooo`00N_ooo`03o`2Ioooooooo00coool00`000?ooooooo`03oooo0`0008koool008Woool0
0`000?ooooooo`2Doooo0029oooo00<0003oooooool0U?ooo`00R?ooo`80002Foooo003ooooo8Ooo
o`00ooooob7oool007Woool00`000?ooooooo`0Xoooo00<0003oooooool0NOooo`00N?ooo`030000
oooooooo00Soool00`000?ooooooo`0Ooooo00<0003oooooool0N?ooo`00N?ooo`030000oooooooo
00;oool200001?ooo`030000oooooooo00coool500000_ooo`800005oooo00<0003oooooool00_oo
o`030000oooooooo07Soool007Soool01@000?ooooooooooo`000002oooo00<0003oooooool00_oo
o`030000oooooooo00Coool400001Oooo`030000oooooooo00Woool00`000?ooooooo`02oooo00<0
003oooooool0N?ooo`00Moooo`030000oooooooo00;oool00`000?ooooooo`0Eoooo00<0003ooooo
ool02Oooo`030000oooooooo00?oool00`000?ooooooo`1goooo001hoooo00<0003oooooool01@00
01Coool00`000?ooooooo`0:oooo00D0003oooooooooool00000N_ooo`00N?ooo`050000oooooooo
oooo000001Ooool00`000?ooooooo`07oooo00@0003oooooool00003oooo00<0003oooooool0N?oo
o`00NOooo`030000oooooooo01Ooool200002Oooo`@00002oooo00<0003oooooool0NOooo`00oooo
ob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.65) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.40095 .30902 L
.41127 .30902 L
.41696 .30902 L
.41976 .30902 L
.42113 .30902 L
.42237 .30902 L
s
.42237 .30902 m
.42249 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.16408 .30902 L
.17277 .30902 L
.17735 .30902 L
.17986 .30902 L
.18221 .30902 L
.18341 .30902 L
.1847 .46353 L
.18543 .46353 L
.18613 .46353 L
.18744 .46353 L
.19227 .46353 L
.20178 .46353 L
.22272 .46353 L
.26091 .46353 L
.30156 .46353 L
.34068 .46353 L
.38227 .46353 L
.40313 .46353 L
.41229 .46353 L
.41714 .46353 L
.4198 .46353 L
.42112 .46353 L
.42233 .46353 L
.42351 .30902 L
.42476 .30902 L
.4274 .30902 L
.43203 .30902 L
.44108 .30902 L
.46088 .30902 L
.49863 .30902 L
.53884 .30902 L
.57753 .30902 L
.61867 .30902 L
.65829 .30902 L
.6964 .30902 L
.73696 .30902 L
.776 .30902 L
.8175 .30902 L
.85748 .30902 L
.89595 .30902 L
.93687 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.65) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`08oooo00<0I_ooooooool00_ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0
003oooooool03?ooo`030000oooooooo00Ooool00ol0V@1Vooooo`02oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo
00coool00`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo00coool00`000?oo
ooooo`0<oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo02Koool00`1Vooooooooo`0A
oooo00<0003oooooool09Oooo`03o`2I06Kooooo017oool00`000?ooooooo`0ioooo00<0003ooooo
ool0>_ooo`030000oooooooo01Goool003ooool00`1Vooooooooo`0ioooo00?o09T0I_ooool04Ooo
o`030000oooooooo08koool003ooool00`1Vooooooooo`0ioooo00?o09T0I_ooool04Oooo`80002?
oooo000ooooo00<0I_ooooooool0>Oooo`03o`2I06Kooooo017oool00`000?ooooooo`2>oooo000o
oooo00<0I_ooooooool0>Oooo`03o`2I06Kooooo017oool00`000?ooooooo`2>oooo000ooooo00<0
I_ooooooool0>Oooo`03o`2I06Kooooo017oool00`000?ooooooo`2>oooo000ooooo00<0I_oooooo
ool0>Oooo`03o`2I06Kooooo017oool20000Soooo`00?oooo`0306Kooooooooo03Woool00ol0V@1V
ooooo`0Aoooo00<0003oooooool0S_ooo`00?oooo`0306Kooooooooo03Woool00ol0V@1Vooooo`0A
oooo00<0003oooooool0S_ooo`00?oooo`0306Kooooooooo03Woool00ol0V@1Vooooo`0Aoooo00<0
003oooooool0S_ooo`00?oooo`0306Kooooooooo03Woool00ol0V@1Vooooo`0Aoooo0P0008ooool0
03ooool00`1Vooooooooo`0ioooo00?o09T0I_ooool04Oooo`030000oooooooo08koool003ooool0
0`1Vooooooooo`0ioooo00?o09T0I_ooool04Oooo`030000oooooooo08koool003ooool00`1Voooo
ooooo`0ioooo00?o09T0I_ooool04Oooo`030000oooooooo08koool003ooool00`1Vooooooooo`0i
oooo00?o09T0I_ooool04Oooo`80002?oooo000ooooo00<0I_ooooooool0>Oooo`03o`2I06Kooooo
017oool00`000?ooooooo`2>oooo000ooooo00<0I_ooooooool0=?ooo`800003oooo00?o09T00000
00000oooo`@00003oooo0P0000Goool00`000?ooooooo`2>oooo000ooooo00<0I_ooooooool0<ooo
o`040000oooooooo00000_ooo`03o`2I06Kooooo00?oool00`000?ooooooo`03oooo00@0003ooooo
ool00004oooo00<0003oooooool0S_ooo`00?oooo`0306Kooooooooo03?oool010000?ooooooo`00
00;oool00`1Vooooooooo`04oooo00<0003oooooool01Oooo`030000oooooooo00;oool30000S_oo
o`00?oooo`0306Kooooooooo03?oool010000?ooooooo`0000;oool00`1Vooooooooo`05oooo00<0
003oooooool00_ooo`800005oooo00<0003oooooool0S_ooo`00?oooo`0306Kooooooooo03?oool0
10000?ooooooo`0000;oool00`1Vooooooooo`03oooo00@0003oooooool00003oooo00<0003ooooo
ool01?ooo`030000oooooooo08koool003ooool00`1Vooooooooo`0doooo0P0000?oool00`1Voooo
ooooo`04oooo0P0000Coool300001?ooo`030000oooooooo08koool003ooool00`1Vooooooooo`0i
oooo00<0I_ooooooool04Oooo`80002?oooo000ooooo00<0I_ooooooool0>Oooo`0306Kooooooooo
017oool00`000?ooooooo`2>oooo000ooooo00<0I_ooooooool0>Oooo`0306Kooooooooo017oool0
0`000?ooooooo`2>oooo000ooooo00<0I_ooooooool0>Oooo`0306Kooooooooo017oool00`000?oo
ooooo`2>oooo000ooooo00<0I_ooooooool0>Oooo`0306Kooooooooo017oool20000Soooo`00?ooo
o`0306Kooooooooo03Woool00`1Vooooooooo`0Aoooo00<0003oooooool0S_ooo`00?oooo`0306Ko
oooooooo03Woool00`1Vooooooooo`0Aoooo00<0003oooooool0S_ooo`00?oooo`0306Kooooooooo
03Woool00`1Vooooooooo`0Aoooo00<0003oooooool0S_ooo`00?oooo`0306Kooooooooo03Woool0
0`1Vooooooooo`0Aoooo0P0008ooool003ooool00`1Vooooooooo`0ioooo00<0I_ooooooool04Ooo
o`030000oooooooo08koool003ooool00`1Vooooooooo`0ioooo00<0I_ooooooool04Oooo`030000
oooooooo08koool003ooool00`1Vooooooooo`0ioooo00<0I_ooooooool04Oooo`030000oooooooo
08koool003ooool00`1Vooooooooo`0ioooo00<0I_ooooooool04Oooo`80002?oooo000ooooo00<0
I_ooooooool0>Oooo`0306Kooooooooo017oool00`000?ooooooo`2>oooo000ooooo00<0I_oooooo
ool0>Oooo`0306Ko0000000000Coool200001?ooo`800005oooo00<0003oooooool0S_ooo`00?ooo
o`0306Kooooooooo03Woool010000?ooooooo`0000Soool010000?ooooooo`0000Coool00`000?oo
ooooo`2>oooo000ooooo?01Vo`040000oooooooo00002oooo`030000oooooooo00;oool30000S_oo
o`00Noooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_ooo`00Noooo`040000
oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001koooo00?o09T00000
00002_ooo`<00004oooo00<0003oooooool0S_ooo`00Noooo`03o`2Ioooooooo017oool20000Sooo
o`00Noooo`03o`2Ioooooooo017oool00`000?ooooooo`2>oooo001koooo00?o09Woooooool04Ooo
o`030000oooooooo08koool007_oool00ol0VOooooooo`0Aoooo0P0008ooool007_oool00ol0VOoo
ooooo`0Aoooo00<0003oooooool0S_ooo`00Noooo`03o`2Ioooooooo017oool00`000?ooooooo`2>
oooo001koooo00?o09Woooooool04Oooo`030000oooooooo08koool007_oool00ol0VOooooooo`0A
oooo0P0008ooool007_oool00ol0VOooooooo`0Aoooo00<0003oooooool0S_ooo`00Noooo`03o`2I
oooooooo017oool00`000?ooooooo`2>oooo001koooo00?o09Woooooool04Oooo`030000oooooooo
08koool007_oool00ol0VOooooooo`0Aoooo0P0008ooool007_oool00ol0VOooooooo`0Aoooo00<0
003oooooool0S_ooo`00M_ooo`800003oooo00?o09T0000000001Oooo`030000oooooooo00;oool2
00001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000;oool00ol0VOooooooo`05
oooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`2>oooo001e
oooo00@0003oooooool00002oooo00?o09Woooooool01Oooo`030000oooooooo00Coool00`000?oo
ooooo`02oooo0`0008koool007Goool010000?ooooooo`0000;oool00ol0VOooooooo`06oooo00@0
003oooooooooool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000;oool0
0ol0VOooooooo`03oooo00@0003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo
08koool007Koool200000oooo`03o`2Ioooooooo00?oool400000oooo`<00004oooo00<0003ooooo
ool0S_ooo`00Noooo`03o`2Ioooooooo017oool20000Soooo`00Noooo`03o`2Ioooooooo017oool0
0`000?ooooooo`2>oooo001koooo00?o09Woooooool04Oooo`030000oooooooo08koool007_oool0
0ol0VOooooooo`0Aoooo00<0003oooooool0S_ooo`00Noooo`03o`2Ioooooooo017oool20000Sooo
o`00Noooo`03o`2Ioooooooo017oool00`000?ooooooo`2>oooo001koooo00?o09Woooooool04Ooo
o`030000oooooooo08koool007_oool00ol0VOooooooo`0Aoooo00<0003oooooool0S_ooo`00Nooo
o`03o`2Ioooooooo017oool20000Soooo`00Noooo`03o`2Ioooooooo017oool00`000?ooooooo`2>
oooo001koooo00?o09Woooooool04Oooo`030000oooooooo08koool007_oool00ol0VOooooooo`0A
oooo00<0003oooooool0S_ooo`00Noooo`03o`2Ioooooooo017oool20000Soooo`00Noooo`03o`2I
oooooooo017oool00`000?ooooooo`2>oooo001koooo00?o09Woooooool02Oooo`D00003oooo00<0
003oooooool0S_ooo`00Noooo`03o`2Ioooooooo00_oool00`000?ooooooo`03oooo00<0003ooooo
ool0S_ooo`00Noooo`03o`2Ioooooooo00_oool00`000?ooooooo`03oooo0`0008koool008Woool0
0`000?ooooooo`2Doooo0029oooo00<0003oooooool0U?ooo`00R?ooo`80002Foooo003ooooo8Ooo
o`00ooooob7oool007Koool00`000?ooooooo`0^oooo00<0003oooooool0M_ooo`00MOooo`030000
oooooooo00Soool00`000?ooooooo`0Uoooo00<0003oooooool0MOooo`00MOooo`030000oooooooo
00;oool200001?ooo`030000oooooooo00coool500000_ooo`800003oooo0`0000Coool200001?oo
o`030000oooooooo07Goool007Goool01@000?ooooooooooo`000002oooo00<0003oooooool00_oo
o`030000oooooooo00Coool400001Oooo`030000oooooooo00Ooool010000?ooooooo`0000;oool0
10000?ooooooo`0000?oool00`000?ooooooo`1eoooo001doooo00<0003oooooool00_ooo`030000
oooooooo01Goool00`000?ooooooo`07oooo00@0003oooooool00005oooo00<0003oooooool00_oo
o`030000oooooooo07Coool007Goool00`000?ooooooo`0500005?ooo`030000oooooooo00Ooool3
00001?ooo`800004oooo00<0003oooooool0MOooo`00MOooo`050000oooooooooooo000001Ooool0
0`000?ooooooo`08oooo00<0003oooooool00oooo`030000oooooooo00?oool00`000?ooooooo`1e
oooo001foooo00<0003oooooool05oooo`80000:oooo0`0000?oool300000_ooo`030000oooooooo
07Koool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.40095 .30902 L
.41127 .30902 L
.41696 .30902 L
.42237 .30902 L
.42482 .30902 L
.42617 .30902 L
.42744 .30902 L
.42816 .30902 L
s
.42816 .30902 m
.42824 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.16408 .30902 L
.17277 .30902 L
.18221 .30902 L
.18475 .30902 L
.18744 .30902 L
.18855 .30902 L
.18974 .30902 L
.19104 .46353 L
.19227 .46353 L
.20178 .46353 L
.22272 .46353 L
.26394 .46353 L
.30365 .46353 L
.34184 .46353 L
.38249 .46353 L
.40128 .46353 L
.41117 .46353 L
.42162 .46353 L
.42418 .46353 L
.42693 .46353 L
.42774 .46353 L
.42851 .46353 L
.4292 .30902 L
.42995 .30902 L
.43277 .30902 L
.44303 .30902 L
.4632 .30902 L
.50398 .30902 L
.54325 .30902 L
.581 .30902 L
.6212 .30902 L
.65989 .30902 L
.70103 .30902 L
.74065 .30902 L
.77876 .30902 L
.81932 .30902 L
.85837 .30902 L
.89987 .30902 L
.93985 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`09oooo00D0I_ooooooooooool000003_ooo`030000oooooooo00coool00`000?ooooooo`0<
oooo00<0003oooooool02Oooo`0406Kooooooooo00003_ooo`030000oooooooo00coool00`000?oo
ooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0
003oooooool03Oooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool05Ooo
o`005_ooo`030000oooooooo02Ooool00`1Vooooooooo`0@oooo00<0003oooooool09oooo`0306Ko
oooooooo00ooool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo01Goool0
043oool00`1Vooooooooo`0joooo00<0I_ooooooool03oooo`030000oooooooo08koool0043oool0
0`1Vooooooooo`0joooo00<0I_ooooooool03oooo`80002?oooo0010oooo00<0I_ooooooool0>_oo
o`0306Kooooooooo00ooool00`000?ooooooo`2>oooo0010oooo00<0I_ooooooool0>_ooo`0306Ko
oooooooo00ooool00`000?ooooooo`2>oooo0010oooo00<0I_ooooooool0>_ooo`0306Kooooooooo
00ooool00`000?ooooooo`2>oooo0010oooo00<0I_ooooooool0>_ooo`0306Kooooooooo00ooool2
0000Soooo`00@?ooo`0306Kooooooooo03[oool00`1Vooooooooo`0?oooo00<0003oooooool0S_oo
o`00@?ooo`0306Kooooooooo03[oool00`1Vooooooooo`0?oooo00<0003oooooool0S_ooo`00@?oo
o`0306Kooooooooo03[oool00`1Vooooooooo`0?oooo00<0003oooooool0S_ooo`00@?ooo`0306Ko
oooooooo03[oool00`1Vooooooooo`0?oooo0P0008ooool0043oool00`1Vooooooooo`0joooo00<0
I_ooooooool03oooo`030000oooooooo08koool0043oool00`1Vooooooooo`0joooo00<0I_oooooo
ool03oooo`030000oooooooo08koool0043oool00`1Vooooooooo`0joooo00<0I_ooooooool03ooo
o`030000oooooooo08koool0043oool00`1Vooooooooo`0joooo00<0I_ooooooool03oooo`80002?
oooo0010oooo00<0I_ooooooool0>_ooo`0306Kooooooooo00ooool00`000?ooooooo`2>oooo0010
oooo00<0I_ooooooool0<oooo`800004oooo0P0000?oool400000oooo`800005oooo00<0003ooooo
ool0S_ooo`00@?ooo`0306Kooooooooo03;oool010000?ooooooo`0000Coool01@1Voooooooooooo
o`000005oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00@?ooo`0306Kooooooooo
03;oool010000?ooooooo`0000Coool00`1Vooooooooo`02oooo00<0003oooooool01Oooo`030000
oooooooo00;oool30000S_ooo`00@Oooo`0306Kooooooooo037oool010000?ooooooo`0000Coool0
0`1Vooooooooo`03oooo00<0003oooooool00_ooo`800005oooo00<0003oooooool0S_ooo`00@Ooo
o`0306Kooooooooo037oool010000?ooooooo`0000Coool01@1Vooooooooooooo`000002oooo00D0
003oooooooooool000001_ooo`030000oooooooo08koool0047oool00`1Vooooooooo`0boooo0P00
00Goool00`1Vooooooooo`02oooo0P0000Coool300001?ooo`030000oooooooo08koool0047oool0
0`1Vooooooooo`0ioooo00<0I_ooooooool03oooo`80002?oooo0011oooo00<0I_ooooooool0>Ooo
o`0306Kooooooooo00ooool00`000?ooooooo`2>oooo0011oooo00<0I_ooooooool0>Oooo`0306Ko
oooooooo00ooool00`000?ooooooo`2>oooo0011oooo00<0I_ooooooool0>Oooo`0306Kooooooooo
00ooool00`000?ooooooo`2>oooo0011oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00ooool2
0000Soooo`00@Oooo`0306Kooooooooo03Woool00`1Vooooooooo`0?oooo00<0003oooooool0S_oo
o`00@Oooo`0306Kooooooooo03Woool00`1Vooooooooo`0?oooo00<0003oooooool0S_ooo`00@Ooo
o`0306Kooooooooo03Woool00`1Vooooooooo`0?oooo00<0003oooooool0S_ooo`00@Oooo`0306Ko
oooooooo03Woool00`1Vooooooooo`0?oooo0P0008ooool0047oool00`1Vooooooooo`0ioooo00<0
I_ooooooool03oooo`030000oooooooo08koool0047oool00`1Vooooooooo`0ioooo00<0I_oooooo
ool03oooo`030000oooooooo08koool0047oool00`1Vooooooooo`0ioooo00<0I_ooooooool03ooo
o`030000oooooooo08koool0047oool00`1Vooooooooo`0ioooo00<0I_ooooooool03oooo`80002?
oooo0011oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00ooool00`000?ooooooo`2>oooo0011
oooo00<0I_ooooooool0>?ooo`800004oooo0P0000Coool200001Oooo`030000oooooooo08koool0
047oool00`1Vooooooooo`0goooo00@0003oool0I_l00008oooo00@0003oooooool00004oooo00<0
003oooooool0S_ooo`00@OooocX0I_l01000001Vo`1Vo`0000_oool00`000?ooooooo`02oooo0`00
08koool007_oool010000?ooool0V@0000Woool200001Oooo`030000oooooooo08koool007_oool0
10000?ooool0V@0000Woool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00O?ooo`80000:
oooo0`0000Coool00`000?ooooooo`2>oooo001moooo00?o09Woooooool03oooo`80002?oooo001m
oooo00?o09Woooooool03oooo`030000oooooooo08koool007goool00ol0VOooooooo`0?oooo00<0
003oooooool0S_ooo`00OOooo`03o`2Ioooooooo00ooool20000Soooo`00OOooo`03o`2Ioooooooo
00ooool00`000?ooooooo`2>oooo001moooo00?o09Woooooool03oooo`030000oooooooo08koool0
07goool00ol0VOooooooo`0?oooo00<0003oooooool0S_ooo`00OOooo`03o`2Ioooooooo00ooool2
0000Soooo`00OOooo`03o`2Ioooooooo00ooool00`000?ooooooo`2>oooo001moooo00?o09Wooooo
ool03oooo`030000oooooooo08koool007goool00ol0VOooooooo`0?oooo00<0003oooooool0S_oo
o`00OOooo`03o`2Ioooooooo00ooool20000Soooo`00OOooo`03o`2Ioooooooo00ooool00`000?oo
ooooo`2>oooo001foooo0P0000Coool200001Oooo`030000oooooooo00;oool200001Oooo`030000
oooooooo08koool007Goool010000?ooooooo`0000Coool00ol0VOooooooo`03oooo00D0003ooooo
ooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`2>oooo001eoooo00@0003ooooo
ool00004oooo00?o09Woooooool00oooo`030000oooooooo00Coool00`000?ooooooo`02oooo0`00
08koool007Goool010000?ooooooo`0000Coool00ol0VOooooooo`04oooo00@0003oooooooooool2
00001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Coool01Ol0VOoooooooooo
o`000002oooo00D0003oooooooooool000001_ooo`030000oooooooo08koool007Koool200001Ooo
o`04o`2Ioooooooooooo100000?oool300001?ooo`030000oooooooo08koool007goool00ol0VOoo
ooooo`0?oooo0P0008ooool007goool00ol0VOooooooo`0?oooo00<0003oooooool0S_ooo`00OOoo
o`03o`2Ioooooooo00ooool00`000?ooooooo`2>oooo001moooo00?o09Woooooool03oooo`030000
oooooooo08koool007goool00ol0VOooooooo`0?oooo0P0008ooool007goool00ol0VOooooooo`0?
oooo00<0003oooooool0S_ooo`00OOooo`03o`2Ioooooooo00ooool00`000?ooooooo`2>oooo001m
oooo00?o09Woooooool03oooo`030000oooooooo08koool007goool00ol0VOooooooo`0?oooo0P00
08ooool007goool00ol0VOooooooo`0?oooo00<0003oooooool0S_ooo`00OOooo`03o`2Ioooooooo
00ooool00`000?ooooooo`2>oooo001moooo00?o09Woooooool03oooo`030000oooooooo08koool0
07goool00ol0VOooooooo`0?oooo0P0008ooool007goool00ol0VOooooooo`0?oooo00<0003ooooo
ool0S_ooo`00OOooo`03o`2Ioooooooo00Ooool500000oooo`030000oooooooo08koool007goool0
0ol0VOooooooo`09oooo00<0003oooooool00oooo`030000oooooooo08koool007goool00ol0VOoo
ooooo`09oooo00<0003oooooool00oooo`<0002>oooo0029oooo00<0003oooooool0U?ooo`00ROoo
o`030000oooooooo09Coool008Soool20000U_ooo`00ooooob7oool00?oooolQoooo001ioooo00<0
003oooooool0:?ooo`030000oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003ooooo
ool07oooo`030000oooooooo07Soool007Soool00`000?ooooooo`02oooo0P0000Coool00`000?oo
ooooo`0<oooo1@0000;oool200000oooo`<00004oooo00<0003oooooool0N?ooo`00N?ooo`050000
oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01?ooo`@00005oooo00<0
003oooooool01oooo`040000oooooooo00000oooo`030000oooooooo07Soool007Ooool00`000?oo
ooooo`02oooo00<0003oooooool05Oooo`030000oooooooo00Ooool010000?ooooooo`0000Coool0
0`000?ooooooo`1goooo001hoooo00<0003oooooool01@0001Coool00`000?ooooooo`07oooo0`00
00Coool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000005oooo`030000oooooooo
00Soool00`000?ooooooo`03oooo00<0003oooooool0N?ooo`00NOooo`030000oooooooo01Ooool2
00002_ooo`<00002oooo00<0003oooooool0NOooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.55) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.40095 .30902 L
.41127 .30902 L
.42237 .30902 L
.42781 .30902 L
.43049 .30902 L
.43179 .30902 L
.43298 .30902 L
.43413 .30902 L
s
.43413 .30902 m
.43424 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.16408 .30902 L
.18221 .30902 L
.18703 .30902 L
.18957 .30902 L
.19227 .30902 L
.19462 .30902 L
.19527 .30902 L
.19596 .30902 L
.19721 .46353 L
.19844 .46353 L
.1996 .46353 L
.20178 .46353 L
.22272 .46353 L
.26091 .46353 L
.30156 .46353 L
.34068 .46353 L
.38227 .46353 L
.40313 .46353 L
.41229 .46353 L
.42233 .46353 L
.42701 .46353 L
.42959 .46353 L
.43203 .46353 L
.43313 .46353 L
.4343 .46353 L
.43558 .30902 L
.43676 .30902 L
.44108 .30902 L
.46088 .30902 L
.49863 .30902 L
.53884 .30902 L
.57753 .30902 L
.61867 .30902 L
.65829 .30902 L
.6964 .30902 L
.73696 .30902 L
.776 .30902 L
.8175 .30902 L
.85748 .30902 L
.89595 .30902 L
.93687 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.55) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0;oooo00<0I_ooool000003_ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0
003oooooool02_ooo`03o`2I06Ko000000koool00`000?ooooooo`0<oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo
00goool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo01Goool001Koool0
0`000?ooooooo`0Yoooo00<0I_ooooooool03_ooo`030000oooooooo02Soool00ol0V@1Vooooo`0>
oooo00<0003oooooool0>Oooo`030000oooooooo03[oool00`000?ooooooo`0Eoooo0012oooo00<0
I_ooooooool0>Oooo`03o`2I06Kooooo00koool00`000?ooooooo`2>oooo0012oooo00<0I_oooooo
ool0>Oooo`03o`2I06Kooooo00koool20000Soooo`00@_ooo`0306Kooooooooo03Woool00ol0V@1V
ooooo`0>oooo00<0003oooooool0S_ooo`00@_ooo`0306Kooooooooo03Woool00ol0V@1Vooooo`0>
oooo00<0003oooooool0S_ooo`00@_ooo`0306Kooooooooo03Woool00ol0V@1Vooooo`0>oooo00<0
003oooooool0S_ooo`00@_ooo`0306Kooooooooo03Woool00ol0V@1Vooooo`0>oooo0P0008ooool0
04;oool00`1Vooooooooo`0ioooo00?o09T0I_ooool03_ooo`030000oooooooo08koool004;oool0
0`1Vooooooooo`0ioooo00?o09T0I_ooool03_ooo`030000oooooooo08koool004;oool00`1Voooo
ooooo`0ioooo00?o09T0I_ooool03_ooo`030000oooooooo08koool004;oool00`1Vooooooooo`0i
oooo00?o09T0I_ooool03_ooo`80002?oooo0012oooo00<0I_ooooooool0>Oooo`03o`2I06Kooooo
00koool00`000?ooooooo`2>oooo0012oooo00<0I_ooooooool0>Oooo`03o`2I06Kooooo00koool0
0`000?ooooooo`2>oooo0012oooo00<0I_ooooooool0>Oooo`03o`2I06Kooooo00koool00`000?oo
ooooo`2>oooo0012oooo00<0I_ooooooool0>Oooo`03o`2I06Kooooo00koool20000Soooo`00@_oo
o`0306Kooooooooo03Woool00ol0V@1Vooooo`0>oooo00<0003oooooool0S_ooo`00@_ooo`0306Ko
oooooooo037oool200001?ooo`8000000ol0V@1Vooooo`0400000oooo`800005oooo00<0003ooooo
ool0S_ooo`00@_ooo`0306Kooooooooo033oool010000?ooooooo`0000Goool01?l0V@1Vooooo`00
00Goool010000?ooooooo`0000Coool00`000?ooooooo`2>oooo0012oooo00<0I_ooooooool0<?oo
o`040000oooooooo00001Oooo`0506Kooooooooooooo000000Ooool00`000?ooooooo`02oooo0`00
08koool004;oool00`1Vooooooooo`0`oooo00@0003oooooool00005oooo00<0I_ooooooool00_oo
o`030000oooooooo00;oool200001Oooo`030000oooooooo08koool004;oool00`1Vooooooooo`0`
oooo00@0003oooooool00005oooo00@0I_ooooooool00002oooo00D0003oooooooooool000001_oo
o`030000oooooooo08koool004;oool00`1Vooooooooo`0aoooo0P0000Koool0101Voooooooooooo
o`800004oooo0`0000Coool00`000?ooooooo`2>oooo0012oooo00<0I_ooooooool0>Oooo`0306Ko
oooooooo00koool20000Soooo`00@_ooo`0306Kooooooooo03Woool00`1Vooooooooo`0>oooo00<0
003oooooool0S_ooo`00@_ooo`0306Kooooooooo03Woool00`1Vooooooooo`0>oooo00<0003ooooo
ool0S_ooo`00@_ooo`0306Kooooooooo03Woool00`1Vooooooooo`0>oooo00<0003oooooool0S_oo
o`00@_ooo`0306Kooooooooo03Woool00`1Vooooooooo`0>oooo0P0008ooool004;oool00`1Voooo
ooooo`0ioooo00<0I_ooooooool03_ooo`030000oooooooo08koool004;oool00`1Vooooooooo`0i
oooo00<0I_ooooooool03_ooo`030000oooooooo08koool004;oool00`1Vooooooooo`0ioooo00<0
I_ooooooool03_ooo`030000oooooooo08koool004;oool00`1Vooooooooo`0ioooo00<0I_oooooo
ool03_ooo`80002?oooo0012oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00koool00`000?oo
ooooo`2>oooo0012oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00koool00`000?ooooooo`2>
oooo0012oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00koool00`000?ooooooo`2>oooo0012
oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00koool20000Soooo`00@_ooo`0306Kooooooooo
03Woool00`1Vooooooooo`0>oooo00<0003oooooool0S_ooo`00@_ooo`0306Kooooooooo03Ooool2
000000@0I_ooooooooooool200001?ooo`800005oooo00<0003oooooool0S_ooo`00@_ooo`0306Ko
oooooooo03Koool010000?ooooooo`0000Soool010000?ooooooo`0000Coool00`000?ooooooo`2>
oooo0012oooo>@1Vo`04000006Ko06Ko00002oooo`030000oooooooo00;oool30000S_ooo`00Nooo
o`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo
00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001loooo0P000003o`2Ioooooooo
00Ooool300001?ooo`030000oooooooo08koool007koool00ol0VOooooooo`0>oooo0P0008ooool0
07koool00ol0VOooooooo`0>oooo00<0003oooooool0S_ooo`00O_ooo`03o`2Ioooooooo00koool0
0`000?ooooooo`2>oooo001noooo00?o09Woooooool03_ooo`80002?oooo001noooo00?o09Wooooo
ool03_ooo`030000oooooooo08koool007koool00ol0VOooooooo`0>oooo00<0003oooooool0S_oo
o`00O_ooo`03o`2Ioooooooo00koool00`000?ooooooo`2>oooo001noooo00?o09Woooooool03_oo
o`80002?oooo001noooo00?o09Woooooool03_ooo`030000oooooooo08koool007koool00ol0VOoo
ooooo`0>oooo00<0003oooooool0S_ooo`00O_ooo`03o`2Ioooooooo00koool00`000?ooooooo`2>
oooo001noooo00?o09Woooooool03_ooo`80002?oooo001noooo00?o09Woooooool03_ooo`030000
oooooooo08koool007Koool200001?ooo`8000000ol0VOooooooo`02oooo00<0003oooooool00_oo
o`800005oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00001Oooo`03o`2Ioooooooo
00;oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo08koool0
07Goool010000?ooooooo`0000Goool00ol0VOooooooo`02oooo00<0003oooooool01?ooo`030000
oooooooo00;oool30000S_ooo`00MOooo`040000oooooooo00001Oooo`03o`2Ioooooooo00?oool0
10000?ooooooooooo`800005oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00001Ooo
o`04o`2Ioooooooo00000_ooo`050000oooooooooooo000000Koool00`000?ooooooo`2>oooo001f
oooo0P0000Koool00ol0VOooooooo`0400000oooo`<00004oooo00<0003oooooool0S_ooo`00O_oo
o`03o`2Ioooooooo00koool20000Soooo`00O_ooo`03o`2Ioooooooo00koool00`000?ooooooo`2>
oooo001noooo00?o09Woooooool03_ooo`030000oooooooo08koool007koool00ol0VOooooooo`0>
oooo00<0003oooooool0S_ooo`00O_ooo`03o`2Ioooooooo00koool20000Soooo`00O_ooo`03o`2I
oooooooo00koool00`000?ooooooo`2>oooo001noooo00?o09Woooooool03_ooo`030000oooooooo
08koool007koool00ol0VOooooooo`0>oooo00<0003oooooool0S_ooo`00O_ooo`03o`2Ioooooooo
00koool20000Soooo`00O_ooo`03o`2Ioooooooo00koool00`000?ooooooo`2>oooo001noooo00?o
09Woooooool03_ooo`030000oooooooo08koool007koool00ol0VOooooooo`0>oooo00<0003ooooo
ool0S_ooo`00O_ooo`03o`2Ioooooooo00koool20000Soooo`00O_ooo`03o`2Ioooooooo00koool0
0`000?ooooooo`2>oooo001noooo00?o09Woooooool01_ooo`D00003oooo00<0003oooooool0S_oo
o`00O_ooo`03o`2Ioooooooo00Soool00`000?ooooooo`03oooo00<0003oooooool0S_ooo`00O_oo
o`03o`2Ioooooooo00Soool00`000?ooooooo`03oooo0`0008koool008Woool00`000?ooooooo`2D
oooo0029oooo00<0003oooooool0U?ooo`00R?ooo`80002Foooo003ooooo8Oooo`00ooooob7oool0
07Koool00`000?ooooooo`0^oooo00<0003oooooool0M_ooo`00MOooo`030000oooooooo00Soool0
0`000?ooooooo`0Uoooo00<0003oooooool0MOooo`00MOooo`030000oooooooo00;oool200001?oo
o`030000oooooooo00coool500000_ooo`800004oooo0P0000Coool200001?ooo`030000oooooooo
07Goool007Goool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
00Coool400001Oooo`030000oooooooo00Ooool010000?ooooooo`0000;oool010000?ooooooo`00
00?oool00`000?ooooooo`1eoooo001doooo00<0003oooooool00_ooo`030000oooooooo01Goool0
0`000?ooooooo`0:oooo00<0003oooooool00oooo`030000oooooooo00;oool00`000?ooooooo`1d
oooo001eoooo00<0003oooooool01@0001Coool00`000?ooooooo`08oooo0P0000Coool200001?oo
o`030000oooooooo07Goool007Goool01@000?ooooooooooo`00000Goooo00<0003oooooool02?oo
o`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool0MOooo`00M_ooo`030000
oooooooo01Ooool200002_ooo`<00003oooo0`0000;oool00`000?ooooooo`1foooo003ooooo8Ooo
o`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.40095 .30902 L
.41127 .30902 L
.42237 .30902 L
.42781 .30902 L
.43298 .30902 L
.43762 .30902 L
.43889 .30902 L
.43959 .30902 L
.44024 .30902 L
s
.44024 .30902 m
.44037 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.19227 .30902 L
.19721 .30902 L
.19939 .30902 L
.20054 .30902 L
.20178 .30902 L
.2031 .46353 L
.20433 .46353 L
.20704 .46353 L
.21274 .46353 L
.22272 .46353 L
.26394 .46353 L
.30365 .46353 L
.34184 .46353 L
.38249 .46353 L
.40128 .46353 L
.42162 .46353 L
.42704 .46353 L
.43277 .46353 L
.43766 .46353 L
.439 .46353 L
.43974 .46353 L
.44044 .46353 L
.44109 .30902 L
.44179 .30902 L
.44303 .30902 L
.4632 .30902 L
.50398 .30902 L
.54325 .30902 L
.581 .30902 L
.6212 .30902 L
.65989 .30902 L
.70103 .30902 L
.74065 .30902 L
.77876 .30902 L
.81932 .30902 L
.85837 .30902 L
.89987 .30902 L
.93985 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0<oooo00<0I_l0003oool03Oooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0
003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo
00goool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo01Goool001Koool0
0`000?ooooooo`0Zoooo00<0I_ooooooool03Oooo`030000oooooooo02[oool00`1Vooooooooo`0<
oooo00<0003oooooool0>Oooo`030000oooooooo03[oool00`000?ooooooo`0Eoooo0013oooo00<0
I_ooooooool0>_ooo`0306Kooooooooo00coool00`000?ooooooo`2>oooo0013oooo00<0I_oooooo
ool0>_ooo`0306Kooooooooo00coool20000Soooo`00@oooo`0306Kooooooooo03[oool00`1Voooo
ooooo`0<oooo00<0003oooooool0S_ooo`00@oooo`0306Kooooooooo03[oool00`1Vooooooooo`0<
oooo00<0003oooooool0S_ooo`00@oooo`0306Kooooooooo03[oool00`1Vooooooooo`0<oooo00<0
003oooooool0S_ooo`00@oooo`0306Kooooooooo03[oool00`1Vooooooooo`0<oooo0P0008ooool0
04?oool00`1Vooooooooo`0joooo00<0I_ooooooool03?ooo`030000oooooooo08koool004?oool0
0`1Vooooooooo`0joooo00<0I_ooooooool03?ooo`030000oooooooo08koool004?oool00`1Voooo
ooooo`0joooo00<0I_ooooooool03?ooo`030000oooooooo08koool004?oool00`1Vooooooooo`0j
oooo00<0I_ooooooool03?ooo`80002?oooo0013oooo00<0I_ooooooool0>_ooo`0306Kooooooooo
00coool00`000?ooooooo`2>oooo0013oooo00<0I_ooooooool0>_ooo`0306Kooooooooo00coool0
0`000?ooooooo`2>oooo0013oooo00<0I_ooooooool0>_ooo`0306Kooooooooo00coool00`000?oo
ooooo`2>oooo0013oooo00<0I_ooooooool0>_ooo`0306Kooooooooo00coool20000Soooo`00@ooo
o`0306Kooooooooo03[oool00`1Vooooooooo`0<oooo00<0003oooooool0S_ooo`00@oooo`0306Ko
oooooooo033oool200001?ooo`800002oooo00<0I_l0000000000P0000?oool200001Oooo`030000
oooooooo08koool004?oool00`1Vooooooooo`0_oooo00@0003oooooool00007oooo00<0I_l0003o
ool01?ooo`040000oooooooo00001?ooo`030000oooooooo08koool004?oool00`1Vooooooooo`0_
oooo00@0003oooooool00007oooo00<0I_ooool000001oooo`030000oooooooo00;oool30000S_oo
o`00A?ooo`0306Kooooooooo02koool010000?ooooooo`0000Ooool0101Vooooooooo`0000Coool2
00001Oooo`030000oooooooo08koool004Coool00`1Vooooooooo`0^oooo00@0003oooooool00007
oooo00D0I_l0003oooooool000000oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo0014
oooo00<0I_ooooooool0;oooo`800008oooo00@0I_ooool000000004oooo0`0000Coool00`000?oo
ooooo`2>oooo0014oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00coool20000Soooo`00A?oo
o`0306Kooooooooo03Woool00`1Vooooooooo`0<oooo00<0003oooooool0S_ooo`00A?ooo`0306Ko
oooooooo03Woool00`1Vooooooooo`0<oooo00<0003oooooool0S_ooo`00A?ooo`0306Kooooooooo
03Woool00`1Vooooooooo`0<oooo00<0003oooooool0S_ooo`00A?ooo`0306Kooooooooo03Woool0
0`1Vooooooooo`0<oooo0P0008ooool004Coool00`1Vooooooooo`0ioooo00<0I_ooooooool03?oo
o`030000oooooooo08koool004Coool00`1Vooooooooo`0ioooo00<0I_ooooooool03?ooo`030000
oooooooo08koool004Coool00`1Vooooooooo`0ioooo00<0I_ooooooool03?ooo`030000oooooooo
08koool004Coool00`1Vooooooooo`0ioooo00<0I_ooooooool03?ooo`80002?oooo0014oooo00<0
I_ooooooool0>Oooo`0306Kooooooooo00coool00`000?ooooooo`2>oooo0014oooo00<0I_oooooo
ool0>Oooo`0306Kooooooooo00coool00`000?ooooooo`2>oooo0014oooo00<0I_ooooooool0>Ooo
o`0306Kooooooooo00coool00`000?ooooooo`2>oooo0014oooo00<0I_ooooooool0>Oooo`0306Ko
oooooooo00coool20000Soooo`00A?ooo`0306Kooooooooo03Woool00`1Vooooooooo`0<oooo00<0
003oooooool0S_ooo`00A?ooo`0306Kooooooooo03Goool200000_ooo`0406Kooooo000000001?oo
o`800005oooo00<0003oooooool0S_ooo`00A?ooo`0306Kooooooooo03Coool01P000?ooooooo`00
0?ooo`1Vo`Koool010000?ooooooo`0000Coool00`000?ooooooo`2>oooo0014oooo=`1Vo`040000
06Ko06Ko00000P1Vo`Woool00`000?ooooooo`02oooo0`0008koool007_oool01P000?ooooooo`00
0?ooool0V@Ooool200001Oooo`030000oooooooo08koool007_oool01P000?ooooooo`000?ooool0
V@Ooool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00O?ooo`800002oooo00?o09Wooooo
ool01Oooo`<00004oooo00<0003oooooool0S_ooo`00P?ooo`03o`2Ioooooooo00coool20000Sooo
o`00P?ooo`03o`2Ioooooooo00coool00`000?ooooooo`2>oooo0020oooo00?o09Woooooool03?oo
o`030000oooooooo08koool0083oool00ol0VOooooooo`0<oooo0P0008ooool0083oool00ol0VOoo
ooooo`0<oooo00<0003oooooool0S_ooo`00P?ooo`03o`2Ioooooooo00coool00`000?ooooooo`2>
oooo0020oooo00?o09Woooooool03?ooo`030000oooooooo08koool0083oool00ol0VOooooooo`0<
oooo0P0008ooool0083oool00ol0VOooooooo`0<oooo00<0003oooooool0S_ooo`00P?ooo`03o`2I
oooooooo00coool00`000?ooooooo`2>oooo0020oooo00?o09Woooooool03?ooo`030000oooooooo
08koool0083oool00ol0VOooooooo`0<oooo0P0008ooool0083oool00ol0VOooooooo`0<oooo00<0
003oooooool0S_ooo`00M_ooo`800004oooo0P0000;oool01?l0VOooooooo`0000Coool200001Ooo
o`030000oooooooo08koool007Goool010000?ooooooo`0000Ooool01?l0VOooooooo`0000?oool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo001eoooo00@0003oooooool00007oooo00Co
09Woooooool00006oooo00<0003oooooool00_ooo`<0002>oooo001eoooo00@0003oooooool00007
oooo00Go09Woooooooooool000000oooo`800005oooo00<0003oooooool0S_ooo`00MOooo`040000
oooooooo00001oooo`05o`2I0000oooooooo000000?oool00`000?ooooooo`04oooo00<0003ooooo
ool0S_ooo`00M_ooo`800008oooo00?o09T0000000000P0000?oool300001?ooo`030000oooooooo
08koool0083oool00ol0VOooooooo`0<oooo0P0008ooool0083oool00ol0VOooooooo`0<oooo00<0
003oooooool0S_ooo`00P?ooo`03o`2Ioooooooo00coool00`000?ooooooo`2>oooo0020oooo00?o
09Woooooool03?ooo`030000oooooooo08koool0083oool00ol0VOooooooo`0<oooo0P0008ooool0
083oool00ol0VOooooooo`0<oooo00<0003oooooool0S_ooo`00P?ooo`03o`2Ioooooooo00coool0
0`000?ooooooo`2>oooo0020oooo00?o09Woooooool03?ooo`030000oooooooo08koool0083oool0
0ol0VOooooooo`0<oooo0P0008ooool0083oool00ol0VOooooooo`0<oooo00<0003oooooool0S_oo
o`00P?ooo`03o`2Ioooooooo00coool00`000?ooooooo`2>oooo0020oooo00?o09Woooooool03?oo
o`030000oooooooo08koool0083oool00ol0VOooooooo`0<oooo0P0008ooool0083oool00ol0VOoo
ooooo`0<oooo00<0003oooooool0S_ooo`00P?ooo`03o`2Ioooooooo00Coool500000oooo`030000
oooooooo08koool0083oool00ol0VOooooooo`06oooo00<0003oooooool00oooo`030000oooooooo
08koool0083oool00ol0VOooooooo`06oooo00<0003oooooool00oooo`<0002>oooo0029oooo00<0
003oooooool0U?ooo`00ROooo`030000oooooooo09Coool008Soool20000U_ooo`00ooooob7oool0
0?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo07Woool007Soool00`000?oo
ooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool007Soool00`000?ooooooo`02
oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200001?ooo`800004oooo00<0003ooooo
ool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003ooooo
ool01?ooo`@00005oooo00<0003oooooool01oooo`040000oooooooo00000oooo`030000oooooooo
07Soool007Ooool00`000?ooooooo`02oooo00<0003oooooool05Oooo`030000oooooooo00[oool0
0`000?ooooooo`02oooo00<0003oooooool0Moooo`00N?ooo`030000oooooooo00D0000Doooo00<0
003oooooool02?ooo`800004oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo0000
01Ooool00`000?ooooooo`08oooo00<0003oooooool00oooo`030000oooooooo07Soool007Woool0
0`000?ooooooo`0Goooo0P0000[oool300000_ooo`030000oooooooo07Woool00?oooolQoooo003o
oooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.45) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.40095 .30902 L
.42237 .30902 L
.43215 .30902 L
.43755 .30902 L
.44021 .30902 L
.44268 .30902 L
.44498 .30902 L
.44627 .30902 L
s
.44627 .30902 m
.44639 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.19227 .30902 L
.20178 .30902 L
.20433 .30902 L
.20573 .30902 L
.20704 .30902 L
.20772 .30902 L
.20845 .46353 L
.20926 .46353 L
.21 .46353 L
.21274 .46353 L
.22272 .46353 L
.26243 .46353 L
.30062 .46353 L
.34126 .46353 L
.38039 .46353 L
.40037 .46353 L
.42198 .46353 L
.43212 .46353 L
.43767 .46353 L
.44037 .46353 L
.44284 .46353 L
.44393 .46353 L
.44511 .46353 L
.44623 .46353 L
.44726 .30902 L
.44835 .30902 L
.44956 .30902 L
.452 .30902 L
.46204 .30902 L
.50225 .30902 L
.54093 .30902 L
.58207 .30902 L
.6217 .30902 L
.65981 .30902 L
.70037 .30902 L
.73941 .30902 L
.78091 .30902 L
.82089 .30902 L
.85936 .30902 L
.90028 .30902 L
.93968 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.45) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<00000I_ooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0
003oooooool03?ooo`030000o`2I06Ko00coool00`000?ooooooo`0<oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo
00goool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo01Goool001Koool0
0`000?ooooooo`0/oooo00<0I_ooooooool02oooo`030000oooooooo02_oool00ol0V@1Vooooo`0;
oooo00<0003oooooool0>Oooo`030000oooooooo03[oool00`000?ooooooo`0Eoooo0015oooo00<0
I_ooooooool0>Oooo`03o`2I06Kooooo00_oool00`000?ooooooo`2>oooo0015oooo00<0I_oooooo
ool0>Oooo`03o`2I06Kooooo00_oool20000Soooo`00AOooo`0306Kooooooooo03Woool00ol0V@1V
ooooo`0;oooo00<0003oooooool0S_ooo`00AOooo`0306Kooooooooo03Woool00ol0V@1Vooooo`0;
oooo00<0003oooooool0S_ooo`00AOooo`0306Kooooooooo03Woool00ol0V@1Vooooo`0;oooo00<0
003oooooool0S_ooo`00AOooo`0306Kooooooooo03Woool00ol0V@1Vooooo`0;oooo0P0008ooool0
04Goool00`1Vooooooooo`0ioooo00?o09T0I_ooool02oooo`030000oooooooo08koool004Goool0
0`1Vooooooooo`0ioooo00?o09T0I_ooool02oooo`030000oooooooo08koool004Goool00`1Voooo
ooooo`0ioooo00?o09T0I_ooool02oooo`030000oooooooo08koool004Goool00`1Vooooooooo`0i
oooo00?o09T0I_ooool02oooo`80002?oooo0015oooo00<0I_ooooooool0>Oooo`03o`2I06Kooooo
00_oool00`000?ooooooo`2>oooo0015oooo00<0I_ooooooool0>Oooo`03o`2I06Kooooo00_oool0
0`000?ooooooo`2>oooo0015oooo00<0I_ooooooool0>Oooo`03o`2I06Kooooo00_oool00`000?oo
ooooo`2>oooo0015oooo00<0I_ooooooool0>Oooo`03o`2I06Kooooo00_oool20000Soooo`00AOoo
o`0306Kooooooooo03Woool00ol0V@1Vooooo`0;oooo00<0003oooooool0S_ooo`00AOooo`0306Ko
oooooooo02koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo08koool0
04Goool00`1Vooooooooo`0]oooo00@0003oooooool00008oooo00<00000I_ooool00oooo`040000
oooooooo00001?ooo`030000oooooooo08koool004Goool00`1Vooooooooo`0]oooo00@0003ooooo
ool00008oooo00<0I_l0003oool01_ooo`030000oooooooo00;oool30000S_ooo`00AOooo`0306Ko
oooooooo02goool010000?ooooooo`0000Soool00`1Vooooo`000004oooo0P0000Goool00`000?oo
ooooo`2>oooo0015oooo00<0I_ooooooool0;Oooo`040000oooooooo00002?ooo`040000oooooooo
00000oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo0015oooo00<0I_ooooooool0;_oo
o`800009oooo00<0I_l0000000001?ooo`<00004oooo00<0003oooooool0S_ooo`00AOooo`0306Ko
oooooooo03Woool00`1Vooooooooo`0;oooo0P0008ooool004Goool00`1Vooooooooo`0ioooo00<0
I_ooooooool02oooo`030000oooooooo08koool004Goool00`1Vooooooooo`0ioooo00<0I_oooooo
ool02oooo`030000oooooooo08koool004Goool00`1Vooooooooo`0ioooo00<0I_ooooooool02ooo
o`030000oooooooo08koool004Goool00`1Vooooooooo`0ioooo00<0I_ooooooool02oooo`80002?
oooo0015oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00_oool00`000?ooooooo`2>oooo0015
oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00_oool00`000?ooooooo`2>oooo0015oooo00<0
I_ooooooool0>Oooo`0306Kooooooooo00_oool00`000?ooooooo`2>oooo0015oooo00<0I_oooooo
ool0>Oooo`0306Kooooooooo00_oool20000Soooo`00AOooo`0306Kooooooooo03Woool00`1Voooo
ooooo`0;oooo00<0003oooooool0S_ooo`00AOooo`0306Kooooooooo03Woool00`1Vooooooooo`0;
oooo00<0003oooooool0S_ooo`00AOooo`0306Kooooooooo03Woool00`1Vooooooooo`0;oooo00<0
003oooooool0S_ooo`00AOooo`0306Kooooooooo03Woool00`1Vooooooooo`0;oooo0P0008ooool0
04Goool00`1Vooooooooo`0ioooo00<0I_ooooooool02oooo`030000oooooooo08koool004Goool0
0`1Vooooooooo`0doooo0P0000?oool00`1Vo`0000000004oooo0P0000Goool00`000?ooooooo`2>
oooo0015oooo00<0I_ooooooool0<oooo`040000oooooooo00000_ooo`0306Kooooooooo00?oool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo0015oooo=P1Vo`04000006Ko06Ko00000`1V
o`Soool00`000?ooooooo`02oooo0`0008koool007_oool010000?ooooooo`0000;oool00ol0VOoo
ooooo`04oooo0P0000Goool00`000?ooooooo`2>oooo001koooo00@0003oooooool00002oooo00?o
09Woooooool01?ooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001loooo0P0000?oool0
0ol0VOooooooo`04oooo0`0000Coool00`000?ooooooo`2>oooo0021oooo00?o09Woooooool02ooo
o`80002?oooo0021oooo00?o09Woooooool02oooo`030000oooooooo08koool0087oool00ol0VOoo
ooooo`0;oooo00<0003oooooool0S_ooo`00POooo`03o`2Ioooooooo00_oool20000Soooo`00POoo
o`03o`2Ioooooooo00_oool00`000?ooooooo`2>oooo0021oooo00?o09Woooooool02oooo`030000
oooooooo08koool0087oool00ol0VOooooooo`0;oooo00<0003oooooool0S_ooo`00POooo`03o`2I
oooooooo00_oool20000Soooo`00POooo`03o`2Ioooooooo00_oool00`000?ooooooo`2>oooo0021
oooo00?o09Woooooool02oooo`030000oooooooo08koool0087oool00ol0VOooooooo`0;oooo00<0
003oooooool0S_ooo`00POooo`03o`2Ioooooooo00_oool20000Soooo`00POooo`03o`2Ioooooooo
00_oool00`000?ooooooo`2>oooo001foooo0P0000Coool200000oooo`03o`2Ioooo000000Coool2
00001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool00ol0VOooo`000003
oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?oo
o`03o`2Ioooo000000Koool00`000?ooooooo`02oooo0`0008koool007Goool010000?ooooooo`00
00Soool01?l0VOooooooo`0000?oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000Soool010000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_oo
o`00M_ooo`800009oooo100000?oool300001?ooo`030000oooooooo08koool0087oool00ol0VOoo
ooooo`0;oooo0P0008ooool0087oool00ol0VOooooooo`0;oooo00<0003oooooool0S_ooo`00POoo
o`03o`2Ioooooooo00_oool00`000?ooooooo`2>oooo0021oooo00?o09Woooooool02oooo`030000
oooooooo08koool0087oool00ol0VOooooooo`0;oooo0P0008ooool0087oool00ol0VOooooooo`0;
oooo00<0003oooooool0S_ooo`00POooo`03o`2Ioooooooo00_oool00`000?ooooooo`2>oooo0021
oooo00?o09Woooooool02oooo`030000oooooooo08koool0087oool00ol0VOooooooo`0;oooo0P00
08ooool0087oool00ol0VOooooooo`0;oooo00<0003oooooool0S_ooo`00POooo`03o`2Ioooooooo
00_oool00`000?ooooooo`2>oooo0021oooo00?o09Woooooool02oooo`030000oooooooo08koool0
087oool00ol0VOooooooo`0;oooo0P0008ooool0087oool00ol0VOooooooo`0;oooo00<0003ooooo
ool0S_ooo`00POooo`03o`2Ioooooooo00?oool500000oooo`030000oooooooo08koool0087oool0
0ol0VOooooooo`05oooo00<0003oooooool00oooo`030000oooooooo08koool0087oool00ol0VOoo
ooooo`05oooo00<0003oooooool00oooo`<0002>oooo0029oooo00<0003oooooool0U?ooo`00ROoo
o`030000oooooooo09Coool008Soool20000U_ooo`00ooooob7oool00?oooolQoooo001foooo00<0
003oooooool0;_ooo`030000oooooooo07Koool007Goool00`000?ooooooo`08oooo00<0003ooooo
ool09Oooo`030000oooooooo07Goool007Goool00`000?ooooooo`02oooo0P0000Coool00`000?oo
ooooo`0<oooo1@0000;oool200001Oooo`<00002oooo0P0000Coool00`000?ooooooo`1eoooo001e
oooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`04oooo1000
00Goool00`000?ooooooo`0:oooo00@0003oooooool00002oooo00D0003oooooooooool00000Mooo
o`00M?ooo`030000oooooooo00;oool00`000?ooooooo`0Eoooo00<0003oooooool01oooo`D00004
oooo00<0003oooooool00_ooo`030000oooooooo07Coool007Goool00`000?ooooooo`0500005?oo
o`030000oooooooo00Ooool010000?ooooooo`0000?oool200001?ooo`030000oooooooo07Goool0
07Goool01@000?ooooooooooo`00000Goooo00<0003oooooool02?ooo`030000oooo000000?oool0
0`000?ooooooo`03oooo00<0003oooooool0MOooo`00M_ooo`030000oooooooo01Ooool200002ooo
o`800003oooo0`0000;oool00`000?ooooooo`1foooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.40095 .30902 L
.42237 .30902 L
.43215 .30902 L
.43755 .30902 L
.44268 .30902 L
.44744 .30902 L
.44874 .30902 L
.45013 .30902 L
.45143 .30902 L
s
.45143 .30902 m
.45155 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.20178 .30902 L
.20742 .30902 L
.21019 .30902 L
.2114 .30902 L
.21274 .30902 L
.21394 .30902 L
.21506 .46353 L
.21625 .46353 L
.21753 .46353 L
.22272 .46353 L
.26394 .46353 L
.30365 .46353 L
.34184 .46353 L
.38249 .46353 L
.42162 .46353 L
.4319 .46353 L
.43731 .46353 L
.44303 .46353 L
.44804 .46353 L
.44941 .46353 L
.45088 .46353 L
.45159 .46353 L
.45227 .46353 L
.45353 .30902 L
.4547 .30902 L
.45594 .30902 L
.45816 .30902 L
.4632 .30902 L
.50095 .30902 L
.54115 .30902 L
.57984 .30902 L
.62098 .30902 L
.66061 .30902 L
.69871 .30902 L
.73927 .30902 L
.77832 .30902 L
.81982 .30902 L
.8598 .30902 L
.89827 .30902 L
.93918 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oool0I_l03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0
003oooooool03?ooo`040000oooooooo06Ko2oooo`030000oooooooo00coool00`000?ooooooo`0<
oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003ooooo
ool03Oooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool05Oooo`005_oo
o`030000oooooooo02goool00`1Vooooooooo`0:oooo00<0003oooooool0;Oooo`0306Kooooooooo
00Woool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo01Goool004Koool0
0`1Vooooooooo`0joooo00<0I_ooooooool02Oooo`030000oooooooo08koool004Koool00`1Voooo
ooooo`0joooo00<0I_ooooooool02Oooo`80002?oooo0016oooo00<0I_ooooooool0>_ooo`0306Ko
oooooooo00Woool00`000?ooooooo`2>oooo0016oooo00<0I_ooooooool0>_ooo`0306Kooooooooo
00Woool00`000?ooooooo`2>oooo0016oooo00<0I_ooooooool0>_ooo`0306Kooooooooo00Woool0
0`000?ooooooo`2>oooo0016oooo00<0I_ooooooool0>_ooo`0306Kooooooooo00Woool20000Sooo
o`00A_ooo`0306Kooooooooo03[oool00`1Vooooooooo`09oooo00<0003oooooool0S_ooo`00A_oo
o`0306Kooooooooo03[oool00`1Vooooooooo`09oooo00<0003oooooool0S_ooo`00A_ooo`0306Ko
oooooooo03[oool00`1Vooooooooo`09oooo00<0003oooooool0S_ooo`00A_ooo`0306Kooooooooo
03[oool00`1Vooooooooo`09oooo0P0008ooool004Koool00`1Vooooooooo`0joooo00<0I_oooooo
ool02Oooo`030000oooooooo08koool004Koool00`1Vooooooooo`0joooo00<0I_ooooooool02Ooo
o`030000oooooooo08koool004Koool00`1Vooooooooo`0joooo00<0I_ooooooool02Oooo`030000
oooooooo08koool004Koool00`1Vooooooooo`0joooo00<0I_ooooooool02Oooo`80002?oooo0016
oooo00<0I_ooooooool0>_ooo`0306Kooooooooo00Woool00`000?ooooooo`2>oooo0016oooo00<0
I_ooooooool0;Oooo`800004oooo0P0000?oool400000oooo`800005oooo00<0003oooooool0S_oo
o`00A_ooo`0306Kooooooooo02coool010000?ooooooo`0000Soool00`000?ooo`1Vo`03oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00A_ooo`0306Kooooooooo02coool010000?oo
ooooo`0000Woool00`00001Vooooo`05oooo00<0003oooooool00_ooo`<0002>oooo0017oooo00<0
I_ooooooool0:oooo`040000oooooooo00002_ooo`030000oooooooo00;oool200001Oooo`030000
oooooooo08koool004Ooool00`1Vooooooooo`0[oooo00@0003oooooool00008oooo00@0003oool0
I_l00003oooo00<0003oooooool01?ooo`030000oooooooo08koool004Ooool00`1Vooooooooo`0/
oooo0P0000[oool200001?ooo`<00004oooo00<0003oooooool0S_ooo`00Aoooo`0306Kooooooooo
03Woool00`1Vooooooooo`09oooo0P0008ooool004Ooool00`1Vooooooooo`0ioooo00<0I_oooooo
ool02Oooo`030000oooooooo08koool004Ooool00`1Vooooooooo`0ioooo00<0I_ooooooool02Ooo
o`030000oooooooo08koool004Ooool00`1Vooooooooo`0ioooo00<0I_ooooooool02Oooo`030000
oooooooo08koool004Ooool00`1Vooooooooo`0ioooo00<0I_ooooooool02Oooo`80002?oooo0017
oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00Woool00`000?ooooooo`2>oooo0017oooo00<0
I_ooooooool0>Oooo`0306Kooooooooo00Woool00`000?ooooooo`2>oooo0017oooo00<0I_oooooo
ool0>Oooo`0306Kooooooooo00Woool00`000?ooooooo`2>oooo0017oooo00<0I_ooooooool0>Ooo
o`0306Kooooooooo00Woool20000Soooo`00Aoooo`0306Kooooooooo03Woool00`1Vooooooooo`09
oooo00<0003oooooool0S_ooo`00Aoooo`0306Kooooooooo03Woool00`1Vooooooooo`09oooo00<0
003oooooool0S_ooo`00Aoooo`0306Kooooooooo03Woool00`1Vooooooooo`09oooo00<0003ooooo
ool0S_ooo`00Aoooo`0306Kooooooooo03Woool00`1Vooooooooo`09oooo0P0008ooool004Ooool0
0`1Vooooooooo`0ioooo00<0I_ooooooool02Oooo`030000oooooooo08koool004Ooool00`1Voooo
ooooo`0boooo0P0000Coool200001?ooo`800005oooo00<0003oooooool0S_ooo`00Aoooo`0306Ko
oooooooo037oool010000?ooooooo`0000Coool01@1Vooooooooooooo`000002oooo00<0003ooooo
ool00_ooo`030000oooooooo08koool004Oooold06Ko00@00000I_l0I_l0000506Ko1_ooo`030000
oooooooo00;oool30000S_ooo`00Noooo`040000oooooooo00001?ooo`03o`2Ioooooooo00;oool2
00001Oooo`030000oooooooo08koool007_oool010000?ooooooo`0000Coool00ol0VOooooooo`02
oooo00<0003oooooool01?ooo`030000oooooooo08koool007coool200001Oooo`03o`2Ioooooooo
00;oool300001?ooo`030000oooooooo08koool008?oool00ol0VOooooooo`09oooo0P0008ooool0
08?oool00ol0VOooooooo`09oooo00<0003oooooool0S_ooo`00Poooo`03o`2Ioooooooo00Woool0
0`000?ooooooo`2>oooo0023oooo00?o09Woooooool02Oooo`80002?oooo0023oooo00?o09Wooooo
ool02Oooo`030000oooooooo08koool008?oool00ol0VOooooooo`09oooo00<0003oooooool0S_oo
o`00Poooo`03o`2Ioooooooo00Woool00`000?ooooooo`2>oooo0023oooo00?o09Woooooool02Ooo
o`80002?oooo0023oooo00?o09Woooooool02Oooo`030000oooooooo08koool008?oool00ol0VOoo
ooooo`09oooo00<0003oooooool0S_ooo`00Poooo`03o`2Ioooooooo00Woool00`000?ooooooo`2>
oooo0023oooo00?o09Woooooool02Oooo`80002?oooo0023oooo00?o09Woooooool02Oooo`030000
oooooooo08koool007Koool200001?ooo`800005oooo00<0003oooooool00_ooo`800005oooo00<0
003oooooool0S_ooo`00MOooo`040000oooooooo00002_ooo`050000oooooooooooo000000;oool0
0`000?ooooooo`02oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002_ooo`030000
oooooooo00Coool00`000?ooooooo`02oooo0`0008koool007Goool010000?ooooooo`0000[oool0
0ol0V@000?ooo`02oooo0P0000Goool00`000?ooooooo`2>oooo001eoooo00@0003oooooool00008
oooo00@0003ooooo09T00003oooo00<0003oooooool01?ooo`030000oooooooo08koool007Koool2
00002Oooo`@00003oooo0`0000Coool00`000?ooooooo`2>oooo0023oooo00?o09Woooooool02Ooo
o`80002?oooo0023oooo00?o09Woooooool02Oooo`030000oooooooo08koool008?oool00ol0VOoo
ooooo`09oooo00<0003oooooool0S_ooo`00Poooo`03o`2Ioooooooo00Woool00`000?ooooooo`2>
oooo0023oooo00?o09Woooooool02Oooo`80002?oooo0023oooo00?o09Woooooool02Oooo`030000
oooooooo08koool008?oool00ol0VOooooooo`09oooo00<0003oooooool0S_ooo`00Poooo`03o`2I
oooooooo00Woool00`000?ooooooo`2>oooo0023oooo00?o09Woooooool02Oooo`80002?oooo0023
oooo00?o09Woooooool02Oooo`030000oooooooo08koool008?oool00ol0VOooooooo`09oooo00<0
003oooooool0S_ooo`00Poooo`03o`2Ioooooooo00Woool00`000?ooooooo`2>oooo0023oooo00?o
09Woooooool02Oooo`80002?oooo0023oooo00?o09Woooooool02Oooo`030000oooooooo08koool0
08?oool01?l0VOooooooooooo`D00003oooo00<0003oooooool0S_ooo`00Poooo`03o`2Ioooooooo
00?oool00`000?ooooooo`03oooo00<0003oooooool0S_ooo`00Poooo`03o`2Ioooooooo00?oool0
0`000?ooooooo`03oooo0`0008koool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool0U?ooo`00R?ooo`80002Foooo003ooooo8Oooo`00ooooob7oool007Woool00`000?ooooooo`0X
oooo00<0003oooooool0NOooo`00N?ooo`030000oooooooo00Soool00`000?ooooooo`0Ooooo00<0
003oooooool0N?ooo`00N?ooo`030000oooooooo00;oool200001?ooo`030000oooooooo00coool5
00000_ooo`800005oooo0`0000;oool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool0
00000_ooo`030000oooooooo00;oool00`000?ooooooo`04oooo100000Goool00`000?ooooooo`0:
oooo00D0003oooooooooool00000N_ooo`00Moooo`030000oooooooo00;oool00`000?ooooooo`0E
oooo00<0003oooooool01oooo`D00003oooo00<0003oooooool0Moooo`00N?ooo`030000oooooooo
00D0000Doooo00<0003oooooool01oooo`040000oooooooo00000oooo`030000oooooooo07Soool0
07Soool01@000?ooooooooooo`00000Goooo00<0003oooooool02?ooo`030000oooo000000?oool0
0`000?ooooooo`1hoooo001ioooo00<0003oooooool05oooo`80000;oooo0P0000;oool00`000?oo
ooooo`1ioooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.35) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.40095 .30902 L
.42237 .30902 L
.43215 .30902 L
.44268 .30902 L
.44778 .30902 L
.45262 .30902 L
.45473 .30902 L
.45697 .30902 L
.45826 .30902 L
s
.45826 .30902 m
.45838 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.20178 .30902 L
.20742 .30902 L
.21274 .30902 L
.21753 .30902 L
.21884 .30902 L
.21955 .30902 L
.22022 .30902 L
.22141 .46353 L
.22272 .46353 L
.26149 .46353 L
.30271 .46353 L
.34242 .46353 L
.38061 .46353 L
.40193 .46353 L
.42126 .46353 L
.43094 .46353 L
.44141 .46353 L
.44622 .46353 L
.45129 .46353 L
.45563 .46353 L
.45682 .46353 L
.45809 .46353 L
.45929 .30902 L
.46039 .30902 L
.50023 .30902 L
.53856 .30902 L
.57935 .30902 L
.61861 .30902 L
.65636 .30902 L
.69657 .30902 L
.73525 .30902 L
.77639 .30902 L
.81602 .30902 L
.85413 .30902 L
.89469 .30902 L
.93373 .30902 L
.97523 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.35) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00D0003oooooooooool0I_l02_ooo`030000oooooooo00coool00`000?ooooooo`0<
oooo00<0003oooooool03?ooo`060000ooooooooooooo`2I06Ko2Oooo`030000oooooooo00coool0
0`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<
oooo00<0003oooooool03Oooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003ooooo
ool05Oooo`005_ooo`030000oooooooo02ooool00`1Vooooooooo`08oooo00<0003oooooool0;_oo
o`03o`2I06Kooooo00Soool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool004Soool00`1Vooooooooo`0ioooo00?o09T0I_ooool02?ooo`030000oooooooo08koool0
04Soool00`1Vooooooooo`0ioooo00?o09T0I_ooool02?ooo`80002?oooo0018oooo00<0I_oooooo
ool0>Oooo`03o`2I06Kooooo00Soool00`000?ooooooo`2>oooo0018oooo00<0I_ooooooool0>Ooo
o`03o`2I06Kooooo00Soool00`000?ooooooo`2>oooo0018oooo00<0I_ooooooool0>Oooo`03o`2I
06Kooooo00Soool00`000?ooooooo`2>oooo0018oooo00<0I_ooooooool0>Oooo`03o`2I06Kooooo
00Soool20000Soooo`00B?ooo`0306Kooooooooo03Woool00ol0V@1Vooooo`08oooo00<0003ooooo
ool0S_ooo`00B?ooo`0306Kooooooooo03Woool00ol0V@1Vooooo`08oooo00<0003oooooool0S_oo
o`00B?ooo`0306Kooooooooo03Woool00ol0V@1Vooooo`08oooo00<0003oooooool0S_ooo`00B?oo
o`0306Kooooooooo03Woool00ol0V@1Vooooo`08oooo0P0008ooool004Soool00`1Vooooooooo`0i
oooo00?o09T0I_ooool02?ooo`030000oooooooo08koool004Soool00`1Vooooooooo`0ioooo00?o
09T0I_ooool02?ooo`030000oooooooo08koool004Soool00`1Vooooooooo`0ioooo00?o09T0I_oo
ool02?ooo`030000oooooooo08koool004Soool00`1Vooooooooo`0ioooo00?o09T0I_ooool02?oo
o`80002?oooo0018oooo00<0I_ooooooool0>Oooo`03o`2I06Kooooo00Soool00`000?ooooooo`2>
oooo0018oooo00<0I_ooooooool0:oooo`800004oooo0P0000?oool4000000<0I_ooooooool00P00
00Goool00`000?ooooooo`2>oooo0018oooo00<0I_ooooooool0:_ooo`040000oooooooo00002?oo
o`070000ooooooooo`2I06Kooooo000000;oool00`000?ooooooo`02oooo00<0003oooooool0S_oo
o`00B?ooo`0306Kooooooooo02[oool010000?ooooooo`0000Woool00`000?ooo`1Vo`05oooo00<0
003oooooool00_ooo`<0002>oooo0018oooo00<0I_ooooooool0:_ooo`040000oooooooo00002_oo
o`03000006Kooooo00;oool200001Oooo`030000oooooooo08koool004Soool00`1Vooooooooo`0Z
oooo00@0003oooooool00008oooo00@0003oooooool00003oooo00<0003oooooool01?ooo`030000
oooooooo08koool004Soool00`1Vooooooooo`0[oooo0P0000[oool2000000@0I_ooooooooooool3
00001?ooo`030000oooooooo08koool004Soool00`1Vooooooooo`0ioooo00<0I_ooooooool02?oo
o`80002?oooo0018oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00Soool00`000?ooooooo`2>
oooo0018oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00Soool00`000?ooooooo`2>oooo0018
oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00Soool00`000?ooooooo`2>oooo0018oooo00<0
I_ooooooool0>Oooo`0306Kooooooooo00Soool20000Soooo`00B?ooo`0306Kooooooooo03Woool0
0`1Vooooooooo`08oooo00<0003oooooool0S_ooo`00B?ooo`0306Kooooooooo03Woool00`1Voooo
ooooo`08oooo00<0003oooooool0S_ooo`00B?ooo`0306Kooooooooo03Woool00`1Vooooooooo`08
oooo00<0003oooooool0S_ooo`00B?ooo`0306Kooooooooo03Woool00`1Vooooooooo`08oooo0P00
08ooool004Soool00`1Vooooooooo`0ioooo00<0I_ooooooool02?ooo`030000oooooooo08koool0
04Soool00`1Vooooooooo`0ioooo00<0I_ooooooool02?ooo`030000oooooooo08koool004Soool0
0`1Vooooooooo`0ioooo00<0I_ooooooool02?ooo`030000oooooooo08koool004Soool00`1Voooo
ooooo`0ioooo00<0I_ooooooool02?ooo`80002?oooo0018oooo00<0I_ooooooool0>Oooo`0306Ko
oooooooo00Soool00`000?ooooooo`2>oooo0018oooo00<0I_ooooooool0<Oooo`800004oooo0P00
000406Kooooooooooooo0P0000Goool00`000?ooooooo`2>oooo0018oooo00<0I_ooooooool0<?oo
o`040000oooooooo00001Oooo`0406Kooooooooo00000_ooo`030000oooooooo00;oool00`000?oo
ooooo`2>oooo0018oooo<`1Vo`04000006Ko06Ko00001P1Vo`Goool00`000?ooooooo`02oooo0`00
08koool007_oool010000?ooooooo`0000Goool01?l0VOooooooooooo`800005oooo00<0003ooooo
ool0S_ooo`00Noooo`040000oooooooo00001Oooo`05o`2Ioooooooooooo000000Koool00`000?oo
ooooo`2>oooo001loooo0P0000Koool01?l0VOooooooooooo`<00004oooo00<0003oooooool0S_oo
o`00Q?ooo`03o`2Ioooooooo00Soool20000Soooo`00Q?ooo`03o`2Ioooooooo00Soool00`000?oo
ooooo`2>oooo0024oooo00?o09Woooooool02?ooo`030000oooooooo08koool008Coool00ol0VOoo
ooooo`08oooo0P0008ooool008Coool00ol0VOooooooo`08oooo00<0003oooooool0S_ooo`00Q?oo
o`03o`2Ioooooooo00Soool00`000?ooooooo`2>oooo0024oooo00?o09Woooooool02?ooo`030000
oooooooo08koool008Coool00ol0VOooooooo`08oooo0P0008ooool008Coool00ol0VOooooooo`08
oooo00<0003oooooool0S_ooo`00Q?ooo`03o`2Ioooooooo00Soool00`000?ooooooo`2>oooo0024
oooo00?o09Woooooool02?ooo`030000oooooooo08koool008Coool00ol0VOooooooo`08oooo0P00
08ooool008Coool00ol0VOooooooo`08oooo00<0003oooooool0S_ooo`00M_ooo`800004oooo0P00
00Goool00`000?l0VOooo`02oooo0P0000Goool00`000?ooooooo`2>oooo001eoooo00@0003ooooo
ool0000:oooo00D0003o09Woooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`2>
oooo001eoooo00@0003oooooool0000:oooo00<0003o09Woool01?ooo`030000oooooooo00;oool3
0000S_ooo`00MOooo`040000oooooooo00002oooo`040000oooooooooooo0P0000Goool00`000?oo
ooooo`2>oooo001eoooo00@0003oooooool00008oooo00@0003oooooool00003oooo00<0003ooooo
ool01?ooo`030000oooooooo08koool007Koool200002Oooo`@00003oooo0`0000Coool00`000?oo
ooooo`2>oooo0024oooo00?o09Woooooool02?ooo`80002?oooo0024oooo00?o09Woooooool02?oo
o`030000oooooooo08koool008Coool00ol0VOooooooo`08oooo00<0003oooooool0S_ooo`00Q?oo
o`03o`2Ioooooooo00Soool00`000?ooooooo`2>oooo0024oooo00?o09Woooooool02?ooo`80002?
oooo0024oooo00?o09Woooooool02?ooo`030000oooooooo08koool008Coool00ol0VOooooooo`08
oooo00<0003oooooool0S_ooo`00Q?ooo`03o`2Ioooooooo00Soool00`000?ooooooo`2>oooo0024
oooo00?o09Woooooool02?ooo`80002?oooo0024oooo00?o09Woooooool02?ooo`030000oooooooo
08koool008Coool00ol0VOooooooo`08oooo00<0003oooooool0S_ooo`00Q?ooo`03o`2Ioooooooo
00Soool00`000?ooooooo`2>oooo0024oooo00?o09Woooooool02?ooo`80002?oooo0024oooo00?o
09Woooooool02?ooo`030000oooooooo08koool008Coool00ol0VOooooooo`0500000oooo`030000
oooooooo08koool008Coool00ol0VOooooooo`02oooo00<0003oooooool00oooo`030000oooooooo
08koool008Coool00ol0VOooooooo`02oooo00<0003oooooool00oooo`<0002>oooo0029oooo00<0
003oooooool0U?ooo`00ROooo`030000oooooooo09Coool008Soool20000U_ooo`00ooooob7oool0
0?oooolQoooo001foooo00<0003oooooool0;_ooo`030000oooooooo07Koool007Goool00`000?oo
ooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool007Goool00`000?ooooooo`02
oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200001?ooo`800004oooo0P0000Coool0
0`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool0
0`000?ooooooo`04oooo100000Goool00`000?ooooooo`07oooo00@0003oooooool00002oooo00@0
003oooooool00003oooo00<0003oooooool0MOooo`00M?ooo`030000oooooooo00;oool00`000?oo
ooooo`0Eoooo00<0003oooooool02Oooo`030000oooooooo00Coool00`000?ooooooo`02oooo00<0
003oooooool0M?ooo`00MOooo`030000oooooooo00D0000Doooo00<0003oooooool02_ooo`040000
oooooooooooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000005ooo
o`030000oooooooo00Ooool010000?ooooooo`0000?oool00`000?ooooooo`03oooo00<0003ooooo
ool0MOooo`00M_ooo`030000oooooooo01Ooool200002_ooo`800004oooo0`0000;oool00`000?oo
ooooo`1foooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.44268 .30902 L
.45262 .30902 L
.45734 .30902 L
.46172 .30902 L
.46283 .30902 L
.46388 .30902 L
s
.46388 .30902 m
.464 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.20342 .30902 L
.21345 .30902 L
.21786 .30902 L
.22037 .30902 L
.22272 .30902 L
.22387 .30902 L
.22496 .30902 L
.22623 .46353 L
.22738 .46353 L
.23233 .46353 L
.24276 .46353 L
.26171 .46353 L
.2999 .46353 L
.34055 .46353 L
.37968 .46353 L
.42126 .46353 L
.44213 .46353 L
.45128 .46353 L
.45613 .46353 L
.4588 .46353 L
.46133 .46353 L
.4625 .46353 L
.46376 .46353 L
.46441 .30902 L
.46513 .30902 L
.4664 .30902 L
.47102 .30902 L
.48007 .30902 L
.49988 .30902 L
.54008 .30902 L
.57877 .30902 L
.61991 .30902 L
.65953 .30902 L
.69764 .30902 L
.7382 .30902 L
.77725 .30902 L
.81874 .30902 L
.85873 .30902 L
.89719 .30902 L
.93811 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool00_ooo`0306Kooooooooo00Ooool00`000?ooooooo`0<oooo00<0
003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`03oooo00<0I_ooooooool01_oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo
00coool00`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo00coool00`000?oo
ooooo`0<oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo033oool00`1Vooooooooo`07
oooo00<0003oooooool0<?ooo`0306Kooooooooo00Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>_ooo`030000oooooooo01Goool004Woool00`1Vooooooooo`0joooo00<0I_ooooooool01_oo
o`030000oooooooo08koool004Woool00`1Vooooooooo`0joooo00<0I_ooooooool01_ooo`80002?
oooo0019oooo00<0I_ooooooool0>_ooo`0306Kooooooooo00Koool00`000?ooooooo`2>oooo0019
oooo00<0I_ooooooool0>_ooo`0306Kooooooooo00Koool00`000?ooooooo`2>oooo0019oooo00<0
I_ooooooool0>_ooo`0306Kooooooooo00Koool00`000?ooooooo`2>oooo0019oooo00<0I_oooooo
ool0>_ooo`0306Kooooooooo00Koool20000Soooo`00BOooo`0306Kooooooooo03[oool00`1Voooo
ooooo`06oooo00<0003oooooool0S_ooo`00BOooo`0306Kooooooooo03[oool00`1Vooooooooo`06
oooo00<0003oooooool0S_ooo`00BOooo`0306Kooooooooo03[oool00`1Vooooooooo`06oooo00<0
003oooooool0S_ooo`00BOooo`0306Kooooooooo03[oool00`1Vooooooooo`06oooo0P0008ooool0
04Woool00`1Vooooooooo`0joooo00<0I_ooooooool01_ooo`030000oooooooo08koool004Woool0
0`1Vooooooooo`0joooo00<0I_ooooooool01_ooo`030000oooooooo08koool004Woool00`1Voooo
ooooo`0joooo00<0I_ooooooool01_ooo`030000oooooooo08koool004Woool00`1Vooooooooo`0j
oooo00<0I_ooooooool01_ooo`80002?oooo0019oooo00<0I_ooooooool0>_ooo`0306Kooooooooo
00Koool00`000?ooooooo`2>oooo0019oooo00<0I_ooooooool0:_ooo`800004oooo0P0000?oool4
000000?oool0I_ooool00P0000Goool00`000?ooooooo`2>oooo0019oooo00<0I_ooooooool0:Ooo
o`040000oooooooo00002?ooo`030000oooooooo00;oool01@1Vo`000?ooooooo`000004oooo00<0
003oooooool0S_ooo`00BOooo`0306Kooooooooo02Woool010000?ooooooo`0000Woool01@000?oo
ooooooooo`1Vo`03oooo00<0003oooooool00_ooo`<0002>oooo001:oooo00<0I_ooooooool0:?oo
o`040000oooooooo00002_ooo`050000oooooooo06Kooooo00800005oooo00<0003oooooool0S_oo
o`00B_ooo`0306Kooooooooo02Soool010000?ooooooo`0000Soool020000?ooooooo`000?ooo`1V
ooooo`0000Koool00`000?ooooooo`2>oooo001:oooo00<0I_ooooooool0:Oooo`80000:oooo0P00
00;oool00`1Vooooo`00000200001?ooo`030000oooooooo08koool004[oool00`1Vooooooooo`0i
oooo00<0I_ooooooool01_ooo`80002?oooo001:oooo00<0I_ooooooool0>Oooo`0306Kooooooooo
00Koool00`000?ooooooo`2>oooo001:oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00Koool0
0`000?ooooooo`2>oooo001:oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00Koool00`000?oo
ooooo`2>oooo001:oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00Koool20000Soooo`00B_oo
o`0306Kooooooooo03Woool00`1Vooooooooo`06oooo00<0003oooooool0S_ooo`00B_ooo`0306Ko
oooooooo03Woool00`1Vooooooooo`06oooo00<0003oooooool0S_ooo`00B_ooo`0306Kooooooooo
03Woool00`1Vooooooooo`06oooo00<0003oooooool0S_ooo`00B_ooo`0306Kooooooooo03Woool0
0`1Vooooooooo`06oooo0P0008ooool004[oool00`1Vooooooooo`0ioooo00<0I_ooooooool01_oo
o`030000oooooooo08koool004[oool00`1Vooooooooo`0ioooo00<0I_ooooooool01_ooo`030000
oooooooo08koool004[oool00`1Vooooooooo`0ioooo00<0I_ooooooool01_ooo`030000oooooooo
08koool004[oool00`1Vooooooooo`0ioooo00<0I_ooooooool01_ooo`80002?oooo001:oooo00<0
I_ooooooool0>Oooo`0306Kooooooooo00Koool00`000?ooooooo`2>oooo001:oooo00<0I_oooooo
ool0;oooo`800004oooo0P0000;oool0101Vooooo`00000000Goool00`000?ooooooo`2>oooo001:
oooo00<0I_ooooooool0;_ooo`040000oooooooo00001oooo`0506Ko0000oooooooo000000Coool0
0`000?ooooooo`2>oooo001:oooo<@1Vo`04000006Ko06Ko0000201Vo`?oool00`000?ooooooo`02
oooo0`0008koool007_oool010000?ooooooo`0000Ooool01?l0VOooo`00000000Goool00`000?oo
ooooo`2>oooo001koooo00@0003oooooool00007oooo00?o09Woool000001_ooo`030000oooooooo
08koool007coool200002?ooo`03o`2Ioooo000000800004oooo00<0003oooooool0S_ooo`00Q_oo
o`03o`2Ioooooooo00Koool20000Soooo`00Q_ooo`03o`2Ioooooooo00Koool00`000?ooooooo`2>
oooo0026oooo00?o09Woooooool01_ooo`030000oooooooo08koool008Koool00ol0VOooooooo`06
oooo0P0008ooool008Koool00ol0VOooooooo`06oooo00<0003oooooool0S_ooo`00Q_ooo`03o`2I
oooooooo00Koool00`000?ooooooo`2>oooo0026oooo00?o09Woooooool01_ooo`030000oooooooo
08koool008Koool00ol0VOooooooo`06oooo0P0008ooool008Koool00ol0VOooooooo`06oooo00<0
003oooooool0S_ooo`00Q_ooo`03o`2Ioooooooo00Koool00`000?ooooooo`2>oooo0026oooo00?o
09Woooooool01_ooo`030000oooooooo08koool008Koool00ol0VOooooooo`06oooo0P0008ooool0
08Koool00ol0VOooooooo`06oooo00<0003oooooool0S_ooo`00M_ooo`800004oooo0P0000Goool0
1@000?ooooooool0VOooo`0200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`00
00[oool01@000?ooooooool0V@000002oooo00<0003oooooool00_ooo`030000oooooooo08koool0
07Goool010000?ooooooo`0000[oool010000?ooooooool0V@?oool00`000?ooooooo`02oooo0`00
08koool007Goool010000?ooooooo`0000_oool010000?ooool0VOooo`800005oooo00<0003ooooo
ool0S_ooo`00MOooo`040000oooooooo00002?ooo`080000oooooooo0000ooooo`2Ioooo00001_oo
o`030000oooooooo08koool007Koool200002Oooo`@000000oooool0VOooo`0300001?ooo`030000
oooooooo08koool008Koool00ol0VOooooooo`06oooo0P0008ooool008Koool00ol0VOooooooo`06
oooo00<0003oooooool0S_ooo`00Q_ooo`03o`2Ioooooooo00Koool00`000?ooooooo`2>oooo0026
oooo00?o09Woooooool01_ooo`030000oooooooo08koool008Koool00ol0VOooooooo`06oooo0P00
08ooool008Koool00ol0VOooooooo`06oooo00<0003oooooool0S_ooo`00Q_ooo`03o`2Ioooooooo
00Koool00`000?ooooooo`2>oooo0026oooo00?o09Woooooool01_ooo`030000oooooooo08koool0
08Koool00ol0VOooooooo`06oooo0P0008ooool008Koool00ol0VOooooooo`06oooo00<0003ooooo
ool0S_ooo`00Q_ooo`03o`2Ioooooooo00Koool00`000?ooooooo`2>oooo0026oooo00?o09Wooooo
ool01_ooo`030000oooooooo08koool008Koool00ol0VOooooooo`06oooo0P0008ooool008Koool0
0ol0VOooooooo`06oooo00<0003oooooool0S_ooo`00Q_ooo`03o`2I0000000000<00003oooo00<0
003oooooool0S_ooo`00Q_ooo`04o`2Ioooooooo00001Oooo`030000oooooooo08koool008Koool0
1?l0VOooooooo`0000Goool30000S_ooo`00ROooo`030000oooooooo09Coool008Woool00`000?oo
ooooo`2Doooo0028oooo0P0009Koool00?oooolQoooo003ooooo8Oooo`00NOooo`030000oooooooo
02Soool00`000?ooooooo`1ioooo001hoooo00<0003oooooool02?ooo`030000oooooooo01ooool0
0`000?ooooooo`1hoooo001hoooo00<0003oooooool00_ooo`800004oooo00<0003oooooool03?oo
o`D00002oooo0P0000Coool200001?ooo`030000oooooooo07Soool007Soool01@000?oooooooooo
o`000002oooo00<0003oooooool00_ooo`030000oooooooo00Coool400001Oooo`030000oooooooo
00Ooool010000?ooooooo`0000?oool00`000?ooooooo`1hoooo001goooo00<0003oooooool00_oo
o`030000oooooooo01Goool00`000?ooooooo`09oooo00<0003oooooool00oooo`030000oooooooo
07Ooool007Soool00`000?ooooooo`0500005?ooo`030000oooooooo00[oool01@000?oooooooooo
o`00001joooo001hoooo00D0003oooooooooool000005oooo`030000oooooooo00Ooool010000?oo
ooooo`0000?oool00`000?ooooooo`1hoooo001ioooo00<0003oooooool05oooo`80000:oooo0P00
00?oool00`000?ooooooo`1ioooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.25) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.44268 .30902 L
.45262 .30902 L
.46172 .30902 L
.46618 .30902 L
.46741 .30902 L
.46871 .30902 L
.46994 .30902 L
s
.46994 .30902 m
.47006 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.20342 .30902 L
.21345 .30902 L
.22272 .30902 L
.22738 .30902 L
.22974 .30902 L
.23038 .30902 L
.23107 .30902 L
.23233 .46353 L
.23302 .46353 L
.23366 .46353 L
.23512 .46353 L
.23778 .46353 L
.24276 .46353 L
.26171 .46353 L
.30084 .46353 L
.34242 .46353 L
.38249 .46353 L
.42104 .46353 L
.44059 .46353 L
.45094 .46353 L
.45664 .46353 L
.46204 .46353 L
.46716 .46353 L
.46856 .46353 L
.46933 .46353 L
.47005 .46353 L
.47132 .30902 L
.472 .30902 L
.47272 .30902 L
.48246 .30902 L
.50153 .30902 L
.54267 .30902 L
.58229 .30902 L
.6204 .30902 L
.66096 .30902 L
.70001 .30902 L
.74151 .30902 L
.78149 .30902 L
.81995 .30902 L
.86087 .30902 L
.90028 .30902 L
.93816 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.25) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool01?ooo`0306Kooooooooo00Goool00`000?ooooooo`0<oooo00<0
003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`04oooo00?o09T0I_ooool01Ooo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo
00coool00`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo00coool00`000?oo
ooooo`0<oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo03;oool00`1Vooooooooo`05
oooo00<0003oooooool0<Oooo`03o`2I06Kooooo00Goool00`000?ooooooo`0ioooo00<0003ooooo
ool0>_ooo`030000oooooooo01Goool004_oool00`1Vooooooooo`0ioooo00?o09T0I_ooool01Ooo
o`030000oooooooo08koool004_oool00`1Vooooooooo`0ioooo00?o09T0I_ooool01Oooo`80002?
oooo001;oooo00<0I_ooooooool0>Oooo`03o`2I06Kooooo00Goool00`000?ooooooo`2>oooo001;
oooo00<0I_ooooooool0>Oooo`03o`2I06Kooooo00Goool00`000?ooooooo`2>oooo001;oooo00<0
I_ooooooool0>Oooo`03o`2I06Kooooo00Goool00`000?ooooooo`2>oooo001;oooo00<0I_oooooo
ool0>Oooo`03o`2I06Kooooo00Goool20000Soooo`00Boooo`0306Kooooooooo03Woool00ol0V@1V
ooooo`05oooo00<0003oooooool0S_ooo`00Boooo`0306Kooooooooo03Woool00ol0V@1Vooooo`05
oooo00<0003oooooool0S_ooo`00Boooo`0306Kooooooooo03Woool00ol0V@1Vooooo`05oooo00<0
003oooooool0S_ooo`00Boooo`0306Kooooooooo03Woool00ol0V@1Vooooo`05oooo0P0008ooool0
04_oool00`1Vooooooooo`0ioooo00?o09T0I_ooool01Oooo`030000oooooooo08koool004_oool0
0`1Vooooooooo`0ioooo00?o09T0I_ooool01Oooo`030000oooooooo08koool004_oool00`1Voooo
ooooo`0ioooo00?o09T0I_ooool01Oooo`030000oooooooo08koool004_oool00`1Vooooooooo`0i
oooo00?o09T0I_ooool01Oooo`80002?oooo001;oooo00<0I_ooooooool0>Oooo`03o`2I06Kooooo
00Goool00`000?ooooooo`2>oooo001;oooo00<0I_ooooooool0:?ooo`800004oooo0P0000?oool4
00000_ooo`03o`2I0000000000Goool00`000?ooooooo`2>oooo001;oooo00<0I_ooooooool09ooo
o`040000oooooooo00002?ooo`030000oooooooo00?oool01000001Vooooo`0000Coool00`000?oo
ooooo`2>oooo001;oooo00<0I_ooooooool09oooo`040000oooooooo00002Oooo`030000oooooooo
00;oool0101Vooooooooo`0000Coool30000S_ooo`00Boooo`0306Kooooooooo02Ooool010000?oo
ooooo`0000[oool01@000?ooooooooooo`1Vo`0200001Oooo`030000oooooooo08koool004_oool0
0`1Vooooooooo`0Woooo00@0003oooooool00008oooo00@0003oooooool00002oooo00<0I_l0003o
ool01Oooo`030000oooooooo08koool004_oool00`1Vooooooooo`0Xoooo0P0000[oool200000ooo
o`0406Ko0000000000001?ooo`030000oooooooo08koool004_oool00`1Vooooooooo`0ioooo00<0
I_ooooooool01Oooo`80002?oooo001;oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00Goool0
0`000?ooooooo`2>oooo001;oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00Goool00`000?oo
ooooo`2>oooo001;oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00Goool00`000?ooooooo`2>
oooo001;oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00Goool20000Soooo`00Boooo`0306Ko
oooooooo03Woool00`1Vooooooooo`05oooo00<0003oooooool0S_ooo`00Boooo`0306Kooooooooo
03Woool00`1Vooooooooo`05oooo00<0003oooooool0S_ooo`00Boooo`0306Kooooooooo03Woool0
0`1Vooooooooo`05oooo00<0003oooooool0S_ooo`00Boooo`0306Kooooooooo03Woool00`1Voooo
ooooo`05oooo0P0008ooool004_oool00`1Vooooooooo`0ioooo00<0I_ooooooool01Oooo`030000
oooooooo08koool004_oool00`1Vooooooooo`0ioooo00<0I_ooooooool01Oooo`030000oooooooo
08koool004_oool00`1Vooooooooo`0ioooo00<0I_ooooooool01Oooo`030000oooooooo08koool0
04_oool00`1Vooooooooo`0ioooo00<0I_ooooooool01Oooo`80002?oooo001;oooo00<0I_oooooo
ool0>Oooo`0306Kooooooooo00Goool00`000?ooooooo`2>oooo001;oooo00<0I_ooooooool0;_oo
o`800004oooo0P0000?oool00`1Vo`0000000005oooo00<0003oooooool0S_ooo`00Boooo`0306Ko
oooooooo02goool010000?ooooooo`0000Soool010000?ooooooo`0000Coool00`000?ooooooo`2>
oooo001;oooo<01Vo`04000006Ko06Ko00002@1Vo`;oool00`000?ooooooo`02oooo0`0008koool0
07_oool010000?ooooooo`0000Soool00ol0V@0000000005oooo00<0003oooooool0S_ooo`00Nooo
o`040000oooooooo00002?ooo`03o`2I0000oooo00Goool00`000?ooooooo`2>oooo001loooo0P00
00Woool01?l0V@000000000000Coool00`000?ooooooo`2>oooo0027oooo00?o09Woooooool01Ooo
o`80002?oooo0027oooo00?o09Woooooool01Oooo`030000oooooooo08koool008Ooool00ol0VOoo
ooooo`05oooo00<0003oooooool0S_ooo`00Qoooo`03o`2Ioooooooo00Goool20000Soooo`00Qooo
o`03o`2Ioooooooo00Goool00`000?ooooooo`2>oooo0027oooo00?o09Woooooool01Oooo`030000
oooooooo08koool008Ooool00ol0VOooooooo`05oooo00<0003oooooool0S_ooo`00Qoooo`03o`2I
oooooooo00Goool20000Soooo`00Qoooo`03o`2Ioooooooo00Goool00`000?ooooooo`2>oooo0027
oooo00?o09Woooooool01Oooo`030000oooooooo08koool008Ooool00ol0VOooooooo`05oooo00<0
003oooooool0S_ooo`00Qoooo`03o`2Ioooooooo00Goool20000Soooo`00Qoooo`03o`2Ioooooooo
00Goool00`000?ooooooo`2>oooo001foooo0P0000Coool200001Oooo`050000ooooooooooooo`2I
00800005oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002_ooo`050000oooooooo
oooo000000;oool00`000?ooooooo`02oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo
00002_ooo`050000ooooooooooooo`2I00;oool00`000?ooooooo`02oooo0`0008koool007Goool0
10000?ooooooo`0000_oool010000?ooooooool0V@800005oooo00<0003oooooool0S_ooo`00MOoo
o`040000oooooooo00002?ooo`040000oooooooo00000_ooo`03o`2I0000oooo00Goool00`000?oo
ooooo`2>oooo001foooo0P0000Woool400000_ooo`04o`2I0000000000001?ooo`030000oooooooo
08koool008Ooool00ol0VOooooooo`05oooo0P0008ooool008Ooool00ol0VOooooooo`05oooo00<0
003oooooool0S_ooo`00Qoooo`03o`2Ioooooooo00Goool00`000?ooooooo`2>oooo0027oooo00?o
09Woooooool01Oooo`030000oooooooo08koool008Ooool00ol0VOooooooo`05oooo0P0008ooool0
08Ooool00ol0VOooooooo`05oooo00<0003oooooool0S_ooo`00Qoooo`03o`2Ioooooooo00Goool0
0`000?ooooooo`2>oooo0027oooo00?o09Woooooool01Oooo`030000oooooooo08koool008Ooool0
0ol0VOooooooo`05oooo0P0008ooool008Ooool00ol0VOooooooo`05oooo00<0003oooooool0S_oo
o`00Qoooo`03o`2Ioooooooo00Goool00`000?ooooooo`2>oooo0027oooo00?o09Woooooool01Ooo
o`030000oooooooo08koool008Ooool00ol0VOooooooo`05oooo0P0008ooool008Ooool00ol0VOoo
ooooo`05oooo00<0003oooooool0S_ooo`00Qoooo`D00003oooo00<0003oooooool0S_ooo`00Qooo
o`03o`2Ioooo000000Goool00`000?ooooooo`2>oooo0027oooo00?o09Woool000001Oooo`<0002>
oooo0029oooo00<0003oooooool0U?ooo`00ROooo`030000oooooooo09Coool008Soool20000U_oo
o`00ooooob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000oooooooo07Koool0
07Goool00`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool007Goool0
0`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200000oooo`@00003
oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000000_ooo`030000
oooooooo00;oool00`000?ooooooo`04oooo100000Goool00`000?ooooooo`07oooo00<0003ooooo
ool00oooo`040000oooooooo00000oooo`030000oooooooo07Goool007Coool00`000?ooooooo`02
oooo00<0003oooooool05Oooo`030000oooooooo00Soool00`000?ooooooo`05oooo00<0003ooooo
ool00_ooo`030000oooooooo07Coool007Goool00`000?ooooooo`0500005?ooo`030000oooooooo
00Woool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003ooooo
ooooool000005oooo`030000oooooooo00Ooool010000?ooooooo`0000?oool00`000?ooooooo`03
oooo00<0003oooooool0MOooo`00M_ooo`030000oooooooo01Ooool200002_ooo`800004oooo0`00
00;oool00`000?ooooooo`1foooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.44268 .30902 L
.45262 .30902 L
.46172 .30902 L
.46618 .30902 L
.47106 .30902 L
.47329 .30902 L
.47451 .30902 L
.47567 .30902 L
s
.47567 .30902 m
.47578 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.20342 .30902 L
.22272 .30902 L
.23233 .30902 L
.23496 .30902 L
.2364 .30902 L
.23711 .30902 L
.23775 .30902 L
.2389 .46353 L
.24014 .46353 L
.24276 .46353 L
.26171 .46353 L
.30142 .46353 L
.33961 .46353 L
.38026 .46353 L
.41939 .46353 L
.43936 .46353 L
.44987 .46353 L
.46097 .46353 L
.46577 .46353 L
.47092 .46353 L
.47243 .46353 L
.47387 .46353 L
.47516 .46353 L
.47589 .46353 L
.47656 .30902 L
.47778 .30902 L
.47912 .30902 L
.48184 .30902 L
.50104 .30902 L
.54124 .30902 L
.57993 .30902 L
.62107 .30902 L
.66069 .30902 L
.6988 .30902 L
.73936 .30902 L
.7784 .30902 L
.8199 .30902 L
.85988 .30902 L
.89835 .30902 L
.93927 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool01Oooo`0306Kooooooooo00Coool00`000?ooooooo`0<oooo00<0
003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`06oooo00<0I_ooooooool00ooo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo
00coool00`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo00coool00`000?oo
ooooo`0<oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo03?oool00`1Vooooooooo`04
oooo00<0003oooooool0<oooo`0306Kooooooooo00?oool00`000?ooooooo`0ioooo00<0003ooooo
ool0>_ooo`030000oooooooo01Goool004coool00`1Vooooooooo`0joooo00<0I_ooooooool00ooo
o`030000oooooooo08koool004coool00`1Vooooooooo`0joooo00<0I_ooooooool00oooo`80002?
oooo001<oooo00<0I_ooooooool0>_ooo`0306Kooooooooo00?oool00`000?ooooooo`2>oooo001<
oooo00<0I_ooooooool0>_ooo`0306Kooooooooo00?oool00`000?ooooooo`2>oooo001<oooo00<0
I_ooooooool0>_ooo`0306Kooooooooo00?oool00`000?ooooooo`2>oooo001<oooo00<0I_oooooo
ool0>_ooo`0306Kooooooooo00?oool20000Soooo`00C?ooo`0306Kooooooooo03[oool00`1Voooo
ooooo`03oooo00<0003oooooool0S_ooo`00C?ooo`0306Kooooooooo03[oool00`1Vooooooooo`03
oooo00<0003oooooool0S_ooo`00C?ooo`0306Kooooooooo03[oool00`1Vooooooooo`03oooo00<0
003oooooool0S_ooo`00C?ooo`0306Kooooooooo03[oool00`1Vooooooooo`03oooo0P0008ooool0
04coool00`1Vooooooooo`0joooo00<0I_ooooooool00oooo`030000oooooooo08koool004coool0
0`1Vooooooooo`0joooo00<0I_ooooooool00oooo`030000oooooooo08koool004coool00`1Voooo
ooooo`0joooo00<0I_ooooooool00oooo`030000oooooooo08koool004coool00`1Vooooooooo`0j
oooo00<0I_ooooooool00oooo`80002?oooo001<oooo00<0I_ooooooool0>_ooo`0306Kooooooooo
00?oool00`000?ooooooo`2>oooo001<oooo00<0I_ooooooool09oooo`800004oooo0P0000?oool4
00000oooo`800005oooo00<0003oooooool0S_ooo`00C?ooo`0306Kooooooooo02Koool010000?oo
ooooo`0000Soool00`000?ooooooo`03oooo00@0003oool0I_l00004oooo00<0003oooooool0S_oo
o`00C?ooo`0306Kooooooooo02Koool010000?ooooooo`0000Woool00`000?ooooooo`04oooo00<0
I_l0003oool00oooo`<0002>oooo001=oooo00<0I_ooooooool09Oooo`040000oooooooo00002_oo
o`030000oooooooo00;oool200001Oooo`030000oooooooo08koool004goool00`1Vooooooooo`0U
oooo00@0003oooooool00008oooo00@0003oooooool00003oooo00<00000I_ooool01?ooo`030000
oooooooo08koool004goool00`1Vooooooooo`0Voooo0P0000[oool200001?ooo`<00004oooo00<0
003oooooool0S_ooo`00COooo`0306Kooooooooo03Woool00`1Vooooooooo`03oooo0P0008ooool0
04goool00`1Vooooooooo`0ioooo00<0I_ooooooool00oooo`030000oooooooo08koool004goool0
0`1Vooooooooo`0ioooo00<0I_ooooooool00oooo`030000oooooooo08koool004goool00`1Voooo
ooooo`0ioooo00<0I_ooooooool00oooo`030000oooooooo08koool004goool00`1Vooooooooo`0i
oooo00<0I_ooooooool00oooo`80002?oooo001=oooo00<0I_ooooooool0>Oooo`0306Kooooooooo
00?oool00`000?ooooooo`2>oooo001=oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00?oool0
0`000?ooooooo`2>oooo001=oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00?oool00`000?oo
ooooo`2>oooo001=oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00?oool20000Soooo`00COoo
o`0306Kooooooooo03Woool00`1Vooooooooo`03oooo00<0003oooooool0S_ooo`00COooo`0306Ko
oooooooo03Woool00`1Vooooooooo`03oooo00<0003oooooool0S_ooo`00COooo`0306Kooooooooo
03Woool00`1Vooooooooo`03oooo00<0003oooooool0S_ooo`00COooo`0306Kooooooooo03Woool0
0`1Vooooooooo`03oooo0P0008ooool004goool00`1Vooooooooo`0ioooo00<0I_ooooooool00ooo
o`030000oooooooo08koool004goool00`1Vooooooooo`0/oooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00COooo`0306Kooooooooo02_oool010000?ooooooo`0000Soool0
10000?ooo`1Vo`0000Coool00`000?ooooooo`2>oooo001=oooo;P1Vo`04000006Ko06Ko00002`1V
o`030000oooooooo00;oool30000S_ooo`00Noooo`040000oooooooo00002Oooo`800005oooo00<0
003oooooool0S_ooo`00Noooo`040000oooooooo00002Oooo`030000o`2Ioooo00Coool00`000?oo
ooooo`2>oooo001loooo0P0000[oool300001?ooo`030000oooooooo08koool008Woool00ol0VOoo
ooooo`03oooo0P0008ooool008Woool00ol0VOooooooo`03oooo00<0003oooooool0S_ooo`00ROoo
o`03o`2Ioooooooo00?oool00`000?ooooooo`2>oooo0029oooo00?o09Woooooool00oooo`80002?
oooo0029oooo00?o09Woooooool00oooo`030000oooooooo08koool008Woool00ol0VOooooooo`03
oooo00<0003oooooool0S_ooo`00ROooo`03o`2Ioooooooo00?oool00`000?ooooooo`2>oooo0029
oooo00?o09Woooooool00oooo`80002?oooo0029oooo00?o09Woooooool00oooo`030000oooooooo
08koool008Woool00ol0VOooooooo`03oooo00<0003oooooool0S_ooo`00ROooo`03o`2Ioooooooo
00?oool00`000?ooooooo`2>oooo0029oooo00?o09Woooooool00oooo`80002?oooo0029oooo00?o
09Woooooool00oooo`030000oooooooo08koool007Koool200001?ooo`800005oooo00<0003ooooo
ool00_ooo`800005oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002_ooo`080000
oooooooooooo0000ooooo`2I00001?ooo`030000oooooooo08koool007Goool010000?ooooooo`00
00[oool00`000?ooooooo`03oooo00?o09T0003oool00oooo`<0002>oooo001eoooo00@0003ooooo
ool0000;oooo00@0003oooooooooool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000Soool010000?ooooooo`0000?oool00`000?l0VOooo`04oooo00<0003oooooool0S_oo
o`00M_ooo`800009oooo100000?oool300001?ooo`030000oooooooo08koool008Woool00ol0VOoo
ooooo`03oooo0P0008ooool008Woool00ol0VOooooooo`03oooo00<0003oooooool0S_ooo`00ROoo
o`03o`2Ioooooooo00?oool00`000?ooooooo`2>oooo0029oooo00?o09Woooooool00oooo`030000
oooooooo08koool008Woool00ol0VOooooooo`03oooo0P0008ooool008Woool00ol0VOooooooo`03
oooo00<0003oooooool0S_ooo`00ROooo`03o`2Ioooooooo00?oool00`000?ooooooo`2>oooo0029
oooo00?o09Woooooool00oooo`030000oooooooo08koool008Woool00ol0VOooooooo`03oooo0P00
08ooool008Woool00ol0VOooooooo`03oooo00<0003oooooool0S_ooo`00ROooo`03o`2Ioooooooo
00?oool00`000?ooooooo`2>oooo0029oooo00?o09Woooooool00oooo`030000oooooooo08koool0
08Woool00ol0VOooooooo`03oooo0P0008ooool008Woool00ol0VOooooooo`03oooo00<0003ooooo
ool0S_ooo`00Qoooo`D00003oooo00<0003oooooool0S_ooo`00ROooo`030000oooooooo00?oool0
0`000?ooooooo`2>oooo0029oooo00<0003oooooool00oooo`<0002>oooo0029oooo00<0003ooooo
ool0U?ooo`00ROooo`030000oooooooo09Coool008Soool20000U_ooo`00ooooob7oool00?oooolQ
oooo001ioooo00<0003oooooool0:?ooo`030000oooooooo07Woool007Soool00`000?ooooooo`08
oooo00<0003oooooool07oooo`030000oooooooo07Soool007Soool00`000?ooooooo`02oooo0P00
00Coool00`000?ooooooo`0<oooo1@0000;oool200000oooo`@00003oooo00<0003oooooool0N?oo
o`00N?ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01?oo
o`@00005oooo00<0003oooooool01oooo`030000oooooooo00Coool00`000?ooooooo`1hoooo001g
oooo00<0003oooooool00_ooo`030000oooooooo01Goool00`000?ooooooo`08oooo00<0003ooooo
ool01?ooo`030000oooooooo07Ooool007Soool00`000?ooooooo`0500005?ooo`030000oooooooo
00Woool00`000?ooooooo`02oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo0000
01Ooool00`000?ooooooo`07oooo00@0003oooooool00003oooo00<0003oooooool0N?ooo`00NOoo
o`030000oooooooo01Ooool200002_ooo`800003oooo00<0003oooooool0NOooo`00ooooob7oool0
0?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.15) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.44268 .30902 L
.46172 .30902 L
.47106 .30902 L
.47567 .30902 L
.47791 .30902 L
.47994 .30902 L
.48116 .30902 L
s
.48116 .30902 m
.48128 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.20342 .30902 L
.22272 .30902 L
.23233 .30902 L
.23739 .30902 L
.24016 .30902 L
.24152 .30902 L
.24276 .30902 L
.24392 .30902 L
.24502 .46353 L
.24618 .46353 L
.24745 .46353 L
.25261 .46353 L
.26171 .46353 L
.30236 .46353 L
.34148 .46353 L
.38307 .46353 L
.42313 .46353 L
.46168 .46353 L
.472 .46353 L
.47703 .46353 L
.47923 .46353 L
.48039 .46353 L
.48162 .46353 L
.48292 .30902 L
.48411 .30902 L
.48647 .30902 L
.49166 .30902 L
.50269 .30902 L
.54044 .30902 L
.58064 .30902 L
.61933 .30902 L
.66047 .30902 L
.70009 .30902 L
.7382 .30902 L
.77876 .30902 L
.81781 .30902 L
.85931 .30902 L
.89929 .30902 L
.93775 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.15) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool01oooo`0306Kooooooooo00;oool00`000?ooooooo`0<oooo00<0
003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`07oooo00?o09T0I_ooool00_oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo
00coool00`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo00coool00`000?oo
ooooo`0<oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo03Goool00`1Vooooooooo`02
oooo00<0003oooooool0=?ooo`03o`2I06Kooooo00;oool00`000?ooooooo`0ioooo00<0003ooooo
ool0>_ooo`030000oooooooo01Goool004koool00`1Vooooooooo`0ioooo00?o09T0I_ooool00_oo
o`030000oooooooo08koool004koool00`1Vooooooooo`0ioooo00?o09T0I_ooool00_ooo`80002?
oooo001>oooo00<0I_ooooooool0>Oooo`03o`2I06Kooooo00;oool00`000?ooooooo`2>oooo001>
oooo00<0I_ooooooool0>Oooo`03o`2I06Kooooo00;oool00`000?ooooooo`2>oooo001>oooo00<0
I_ooooooool0>Oooo`03o`2I06Kooooo00;oool00`000?ooooooo`2>oooo001>oooo00<0I_oooooo
ool0>Oooo`03o`2I06Kooooo00;oool20000Soooo`00C_ooo`0306Kooooooooo03Woool00ol0V@1V
ooooo`02oooo00<0003oooooool0S_ooo`00C_ooo`0306Kooooooooo03Woool00ol0V@1Vooooo`02
oooo00<0003oooooool0S_ooo`00C_ooo`0306Kooooooooo03Woool00ol0V@1Vooooo`02oooo00<0
003oooooool0S_ooo`00C_ooo`0306Kooooooooo03Woool00ol0V@1Vooooo`02oooo0P0008ooool0
04koool00`1Vooooooooo`0ioooo00?o09T0I_ooool00_ooo`030000oooooooo08koool004koool0
0`1Vooooooooo`0ioooo00?o09T0I_ooool00_ooo`030000oooooooo08koool004koool00`1Voooo
ooooo`0ioooo00?o09T0I_ooool00_ooo`030000oooooooo08koool004koool00`1Vooooooooo`0i
oooo00?o09T0I_ooool00_ooo`80002?oooo001>oooo00<0I_ooooooool0>Oooo`03o`2I06Kooooo
00;oool00`000?ooooooo`2>oooo001>oooo00<0I_ooooooool09Oooo`800004oooo0P0000?oool4
00000oooo`8000000ol0V@1Vooooo`02oooo00<0003oooooool0S_ooo`00C_ooo`0306Kooooooooo
02Coool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00D0003oooooool00000I_l00ooo
o`030000oooooooo08koool004koool00`1Vooooooooo`0Toooo00@0003oooooool00009oooo00<0
003oooooool01Oooo`030000oooooooo00;oool30000S_ooo`00C_ooo`0306Kooooooooo02Coool0
10000?ooooooo`0000[oool00`000?ooooooo`02oooo0P00000306Kooooooooo00;oool00`000?oo
ooooo`2>oooo001>oooo00<0I_ooooooool09?ooo`040000oooooooo00002?ooo`040000oooooooo
00000oooo`030000oooo06Ko00Coool00`000?ooooooo`2>oooo001>oooo00<0I_ooooooool09Ooo
o`80000:oooo0P0000Coool300001?ooo`030000oooooooo08koool004koool00`1Vooooooooo`0i
oooo00<0I_ooooooool00_ooo`80002?oooo001>oooo00<0I_ooooooool0>Oooo`0306Kooooooooo
00;oool00`000?ooooooo`2>oooo001>oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00;oool0
0`000?ooooooo`2>oooo001>oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00;oool00`000?oo
ooooo`2>oooo001>oooo00<0I_ooooooool0>Oooo`0306Kooooooooo00;oool20000Soooo`00C_oo
o`0306Kooooooooo03Woool00`1Vooooooooo`02oooo00<0003oooooool0S_ooo`00C_ooo`0306Ko
oooooooo03Woool00`1Vooooooooo`02oooo00<0003oooooool0S_ooo`00C_ooo`0306Kooooooooo
03Woool00`1Vooooooooo`02oooo00<0003oooooool0S_ooo`00C_ooo`0306Kooooooooo03Woool0
0`1Vooooooooo`02oooo0P0008ooool004koool00`1Vooooooooo`0ioooo00<0I_ooooooool00_oo
o`030000oooooooo08koool004koool00`1Vooooooooo`0ioooo00<0I_ooooooool00_ooo`030000
oooooooo08koool004koool00`1Vooooooooo`0ioooo00<0I_ooooooool00_ooo`030000oooooooo
08koool004koool00`1Vooooooooo`0ioooo00<0I_ooooooool00_ooo`80002?oooo001>oooo00<0
I_ooooooool0>Oooo`0306Kooooooooo00;oool00`000?ooooooo`2>oooo001>oooo00<0I_oooooo
ool0:oooo`800004oooo0P0000Coool2000000<0I_ooooooool00_ooo`030000oooooooo08koool0
04koool00`1Vooooooooo`0Zoooo00@0003oooooool00008oooo00@0003oooooool00004oooo00<0
003oooooool0S_ooo`00C_ooobd0I_l01000001Vo`1Vo`0000/0I_l00`000?ooooooo`02oooo0`00
08koool007_oool010000?ooooooo`0000Woool2000000?o09Woooooool00_ooo`030000oooooooo
08koool007_oool010000?ooooooo`0000Woool00`000?ooool0V@04oooo00<0003oooooool0S_oo
o`00O?ooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo002:oooo00?o09Woooooool00_oo
o`80002?oooo002:oooo00?o09Woooooool00_ooo`030000oooooooo08koool008[oool00ol0VOoo
ooooo`02oooo00<0003oooooool0S_ooo`00R_ooo`03o`2Ioooooooo00;oool20000Soooo`00R_oo
o`03o`2Ioooooooo00;oool00`000?ooooooo`2>oooo002:oooo00?o09Woooooool00_ooo`030000
oooooooo08koool008[oool00ol0VOooooooo`02oooo00<0003oooooool0S_ooo`00R_ooo`03o`2I
oooooooo00;oool20000Soooo`00R_ooo`03o`2Ioooooooo00;oool00`000?ooooooo`2>oooo002:
oooo00?o09Woooooool00_ooo`030000oooooooo08koool008[oool00ol0VOooooooo`02oooo00<0
003oooooool0S_ooo`00R_ooo`03o`2Ioooooooo00;oool20000Soooo`00R_ooo`03o`2Ioooooooo
00;oool00`000?ooooooo`2>oooo001foooo0P0000Coool200001Oooo`030000oooooooo00;oool2
000000?o09Woooooool00_ooo`030000oooooooo08koool007Goool010000?ooooooo`0000[oool0
1@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo08koool007Goool0
10000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_ooo`<0002>oooo001e
oooo00@0003oooooool0000;oooo00@0003oooooooooool2000000?o09Woooooool00_ooo`030000
oooooooo08koool007Goool010000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?oo
ool0V@04oooo00<0003oooooool0S_ooo`00M_ooo`800009oooo100000?oool300001?ooo`030000
oooooooo08koool008[oool00ol0VOooooooo`02oooo0P0008ooool008[oool00ol0VOooooooo`02
oooo00<0003oooooool0S_ooo`00R_ooo`03o`2Ioooooooo00;oool00`000?ooooooo`2>oooo002:
oooo00?o09Woooooool00_ooo`030000oooooooo08koool008[oool00ol0VOooooooo`02oooo0P00
08ooool008[oool00ol0VOooooooo`02oooo00<0003oooooool0S_ooo`00R_ooo`03o`2Ioooooooo
00;oool00`000?ooooooo`2>oooo002:oooo00?o09Woooooool00_ooo`030000oooooooo08koool0
08[oool00ol0VOooooooo`02oooo0P0008ooool008[oool00ol0VOooooooo`02oooo00<0003ooooo
ool0S_ooo`00R_ooo`03o`2Ioooooooo00;oool00`000?ooooooo`2>oooo002:oooo00?o09Wooooo
ool00_ooo`030000oooooooo08koool008[oool00ol0VOooooooo`02oooo0P0008ooool008[oool0
0ol0VOooooooo`02oooo00<0003oooooool0S_ooo`00Qoooo`D00003oooo00<0003oooooool0S_oo
o`00ROooo`030000o`2Ioooo00?oool00`000?ooooooo`2>oooo0029oooo00<0003o09Woool00ooo
o`<0002>oooo0029oooo00<0003oooooool0U?ooo`00ROooo`030000oooooooo09Coool008Soool2
0000U_ooo`00ooooob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000oooooooo
07Koool007Goool00`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool0
07Goool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200000ooo
o`D00002oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000000_oo
o`030000oooooooo00;oool00`000?ooooooo`04oooo100000Goool00`000?ooooooo`09oooo00D0
003oooooooooool000000_ooo`050000oooooooooooo000007Ooool007Coool00`000?ooooooo`02
oooo00<0003oooooool05Oooo`030000oooooooo00Woool00`000?ooooooo`04oooo00<0003ooooo
ool00_ooo`030000oooooooo07Coool007Goool00`000?ooooooo`0500005?ooo`030000oooooooo
00Woool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003ooooo
ooooool000005oooo`030000oooooooo00Woool00`000?ooooooo`02oooo00<0003oooooool00ooo
o`030000oooooooo07Goool007Koool00`000?ooooooo`0Goooo0P0000[oool200001?ooo`<00002
oooo00<0003oooooool0M_ooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.44268 .30902 L
.46172 .30902 L
.47106 .30902 L
.47994 .30902 L
.48484 .30902 L
.48618 .30902 L
.48692 .30902 L
.48761 .30902 L
s
.48761 .30902 m
.48768 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.20342 .30902 L
.22272 .30902 L
.23233 .30902 L
.23739 .30902 L
.24276 .30902 L
.24502 .30902 L
.24745 .30902 L
.24816 .30902 L
.24884 .30902 L
.25012 .46353 L
.25131 .46353 L
.25261 .46353 L
.26171 .46353 L
.30236 .46353 L
.34148 .46353 L
.38307 .46353 L
.42313 .46353 L
.46168 .46353 L
.472 .46353 L
.48162 .46353 L
.48411 .46353 L
.48647 .46353 L
.48777 .46353 L
.48851 .30902 L
.48919 .30902 L
.49166 .30902 L
.50269 .30902 L
.54195 .30902 L
.5797 .30902 L
.61991 .30902 L
.65859 .30902 L
.69973 .30902 L
.73936 .30902 L
.77747 .30902 L
.81803 .30902 L
.85707 .30902 L
.89857 .30902 L
.93855 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool02?ooo`0506Kooooooooooooo000000koool00`000?ooooooo`0<
oooo00<0003oooooool03?ooo`030000oooooooo00Woool0101Vooooooooo`0000koool00`000?oo
ooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0
003oooooool03Oooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool05Ooo
o`005_ooo`030000oooooooo03Koool01@1Vooooooooooooo`00000hoooo00@0I_ooooooool0000k
oooo00<0003oooooool0>_ooo`030000oooooooo01Goool004ooool00`1Vooooooooo`0joooo00@0
I_ooooooool0002@oooo001?oooo00<0I_ooooooool0>_ooo`0306Kooooooooo0080002?oooo001?
oooo00<0I_ooooooool0>_ooo`0406Kooooooooo0000T?ooo`00Coooo`0306Kooooooooo03[oool0
101Vooooooooo`00093oool004ooool00`1Vooooooooo`0joooo00@0I_ooooooool0002@oooo001?
oooo00<0I_ooooooool0>_ooo`0306Kooooooooo0080002?oooo001?oooo00<0I_ooooooool0>_oo
o`0406Kooooooooo0000T?ooo`00Coooo`0306Kooooooooo03[oool0101Vooooooooo`00093oool0
04ooool00`1Vooooooooo`0joooo00@0I_ooooooool0002@oooo001?oooo00<0I_ooooooool0>_oo
o`0306Kooooooooo0080002?oooo001?oooo00<0I_ooooooool0>_ooo`0406Kooooooooo0000T?oo
o`00Coooo`0306Kooooooooo03[oool0101Vooooooooo`00093oool004ooool00`1Vooooooooo`0j
oooo00@0I_ooooooool0002@oooo001?oooo00<0I_ooooooool0>_ooo`0306Kooooooooo0080002?
oooo001?oooo00<0I_ooooooool0>_ooo`0406Kooooooooo0000T?ooo`00Coooo`0306Kooooooooo
02Coool200001?ooo`800003oooo100000?oool200000_ooo`0406Kooooooooo0000T?ooo`00Cooo
o`0306Kooooooooo02?oool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00H0003ooooo
ool0003oool0I_l2oooo00<0003oooooool0S_ooo`00Coooo`0306Kooooooooo02?oool010000?oo
ooooo`0000Woool00`000?ooooooo`05oooo00<0003oool0I_l00_ooo`<0002>oooo001@oooo00<0
I_ooooooool08_ooo`040000oooooooo00002_ooo`030000oooooooo00;oool200000_ooo`0406Ko
oooooooo0000T?ooo`00D?ooo`0306Kooooooooo02;oool010000?ooooooo`0000Soool010000?oo
ooooo`0000?oool01@000?ooooooooooo`1Vo`02oooo00<0003oooooool0S_ooo`00D?ooo`0306Ko
oooooooo02?oool200002_ooo`800004oooo0`000005oooo06Kooooooooo0000093oool0053oool0
0`1Vooooooooo`0ioooo00<0I_ooooooool00P0008ooool0053oool00`1Vooooooooo`0ioooo00@0
I_ooooooool0002@oooo001@oooo00<0I_ooooooool0>Oooo`0406Kooooooooo0000T?ooo`00D?oo
o`0306Kooooooooo03Woool0101Vooooooooo`00093oool0053oool00`1Vooooooooo`0ioooo00<0
I_ooooooool00P0008ooool0053oool00`1Vooooooooo`0ioooo00@0I_ooooooool0002@oooo001@
oooo00<0I_ooooooool0>Oooo`0406Kooooooooo0000T?ooo`00D?ooo`0306Kooooooooo03Woool0
101Vooooooooo`00093oool0053oool00`1Vooooooooo`0ioooo00<0I_ooooooool00P0008ooool0
053oool00`1Vooooooooo`0ioooo00@0I_ooooooool0002@oooo001@oooo00<0I_ooooooool0>Ooo
o`0406Kooooooooo0000T?ooo`00D?ooo`0306Kooooooooo03Woool0101Vooooooooo`00093oool0
053oool00`1Vooooooooo`0ioooo00<0I_ooooooool00P0008ooool0053oool00`1Vooooooooo`0i
oooo00@0I_ooooooool0002@oooo001@oooo00<0I_ooooooool0:Oooo`800004oooo0P0000Coool2
00000_ooo`0406Kooooooooo0000T?ooo`00D?ooo`0306Kooooooooo02Soool010000?ooooooo`00
00Soool01P000?ooooooo`000?ooo`1Vo`;oool00`000?ooooooo`2>oooo001@oooo:`1Vo`040000
06Ko06Ko00002`1Vo`03000006Ko06Ko00;oool30000S_ooo`00Noooo`040000oooooooo00002Ooo
o`800002oooo00Co09Woooooool0002@oooo001koooo00@0003oooooool00009oooo00D0003ooooo
oooooooo09T00_ooo`030000oooooooo08koool007coool200002_ooo`<000001Oooool0VOoooooo
o`00002@oooo002<oooo00?o09Woooooool00P0008ooool008coool01?l0VOooooooo`00093oool0
08coool01?l0VOooooooo`00093oool008coool00ol0VOooooooo`020000Soooo`00S?ooo`04o`2I
oooooooo0000T?ooo`00S?ooo`04o`2Ioooooooo0000T?ooo`00S?ooo`04o`2Ioooooooo0000T?oo
o`00S?ooo`03o`2Ioooooooo0080002?oooo002<oooo00Co09Woooooool0002@oooo002<oooo00Co
09Woooooool0002@oooo002<oooo00Co09Woooooool0002@oooo002<oooo00?o09Woooooool00P00
08ooool008coool01?l0VOooooooo`00093oool007Koool200001?ooo`800005oooo00<0003ooooo
ool00_ooo`800002oooo00Co09Woooooool0002@oooo001eoooo00@0003oooooool0000:oooo00D0
003oooooooooool000000_ooo`030000ooooo`2I00;oool00`000?ooooooo`2>oooo001eoooo00@0
003oooooool0000:oooo00<0003oooooool01?ooo`030000ooooo`2I00;oool30000S_ooo`00MOoo
o`040000oooooooo00002oooo`040000oooooooooooo0P0000;oool01?l0VOooooooo`00093oool0
07Goool010000?ooooooo`0000Soool010000?ooooooo`0000?oool01@000?ooooooooooool0V@02
oooo00<0003oooooool0S_ooo`00M_ooo`800009oooo100000?oool3000000Gooooo09Woooooool0
0000T?ooo`00S?ooo`03o`2Ioooooooo0080002?oooo002<oooo00Co09Woooooool0002@oooo002<
oooo00Co09Woooooool0002@oooo002<oooo00Co09Woooooool0002@oooo002<oooo00?o09Wooooo
ool00P0008ooool008coool01?l0VOooooooo`00093oool008coool01?l0VOooooooo`00093oool0
08coool01?l0VOooooooo`00093oool008coool00ol0VOooooooo`020000Soooo`00S?ooo`04o`2I
oooooooo0000T?ooo`00S?ooo`04o`2Ioooooooo0000T?ooo`00S?ooo`04o`2Ioooooooo0000T?oo
o`00S?ooo`03o`2Ioooooooo0080002?oooo002<oooo00Co09Woooooool0002@oooo0027oooo1@00
0004o`2Ioooooooo0000T?ooo`00ROooo`040000ooooooooo`2I0_ooo`030000oooooooo08koool0
08Woool010000?ooooooool0V@;oool30000S_ooo`00ROooo`030000oooooooo09Coool008Woool0
0`000?ooooooo`2Doooo0028oooo0P0009Koool00?oooolQoooo003ooooo8Oooo`00NOooo`030000
oooooooo02Soool00`000?ooooooo`1ioooo001hoooo00<0003oooooool02?ooo`030000oooooooo
01ooool00`000?ooooooo`1hoooo001hoooo00<0003oooooool00_ooo`800004oooo00<0003ooooo
ool03?ooo`D00002oooo0P0000?oool500000_ooo`030000oooooooo07Soool007Soool01@000?oo
ooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo00Coool400001Oooo`030000
oooooooo00Woool00`000?ooooooo`02oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo
00;oool00`000?ooooooo`0Eoooo00<0003oooooool02Oooo`030000oooooooo00?oool00`000?oo
ooooo`1goooo001hoooo00<0003oooooool01@0001Coool00`000?ooooooo`09oooo00<0003ooooo
ool00_ooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`00000Goooo00<0003ooooo
ool02Oooo`030000oooooooo00;oool00`000?ooooooo`1hoooo001ioooo00<0003oooooool05ooo
o`80000:oooo0P0000?oool00`000?ooooooo`1ioooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.05) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.44268 .30902 L
.46172 .30902 L
.47994 .30902 L
.48519 .30902 L
.48778 .30902 L
.49018 .30902 L
.49235 .30902 L
.49356 .30902 L
s
.49356 .30902 m
.49367 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.20342 .30902 L
.22272 .30902 L
.23233 .30902 L
.24276 .30902 L
.24754 .30902 L
.25016 .30902 L
.25261 .30902 L
.2547 .30902 L
.25587 .30902 L
.25694 .46353 L
.25811 .46353 L
.25939 .46353 L
.26171 .46353 L
.30236 .46353 L
.34148 .46353 L
.38307 .46353 L
.42313 .46353 L
.46168 .46353 L
.48162 .46353 L
.48647 .46353 L
.48914 .46353 L
.49166 .46353 L
.49309 .46353 L
.4939 .46353 L
.49465 .30902 L
.49596 .30902 L
.49737 .30902 L
.50269 .30902 L
.54044 .30902 L
.58064 .30902 L
.61933 .30902 L
.66047 .30902 L
.70009 .30902 L
.7382 .30902 L
.77876 .30902 L
.81781 .30902 L
.85931 .30902 L
.89929 .30902 L
.93775 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.05) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool02_ooo`0306Kooooo000000koool00`000?ooooooo`0<oooo00<0
003oooooool03?ooo`030000oooooooo00[oool00ol0V@1Vo`00000>oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo
00goool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo01Goool001Koool0
0`000?ooooooo`0hoooo00<0I_ooool00000>Oooo`03o`2I06Ko000003_oool00`000?ooooooo`0j
oooo00<0003oooooool05Oooo`00DOooo`0306Kooooooooo03Woool00ol0V@1Vo`00002@oooo001A
oooo00<0I_ooooooool0>Oooo`04o`2I06Ko00000000Soooo`00DOooo`0306Kooooooooo03Woool0
0ol0V@1Vo`00002@oooo001Aoooo00<0I_ooooooool0>Oooo`03o`2I06Ko0000093oool0057oool0
0`1Vooooooooo`0ioooo00?o09T0I_l00000T?ooo`00DOooo`0306Kooooooooo03Woool01?l0V@1V
o`00000008ooool0057oool00`1Vooooooooo`0ioooo00?o09T0I_l00000T?ooo`00DOooo`0306Ko
oooooooo03Woool00ol0V@1Vo`00002@oooo001Aoooo00<0I_ooooooool0>Oooo`03o`2I06Ko0000
093oool0057oool00`1Vooooooooo`0ioooo00Co09T0I_l00000002?oooo001Aoooo00<0I_oooooo
ool0>Oooo`03o`2I06Ko0000093oool0057oool00`1Vooooooooo`0ioooo00?o09T0I_l00000T?oo
o`00DOooo`0306Kooooooooo03Woool00ol0V@1Vo`00002@oooo001Aoooo00<0I_ooooooool0>Ooo
o`04o`2I06Ko00000000Soooo`00DOooo`0306Kooooooooo03Woool00ol0V@1Vo`00002@oooo001A
oooo00<0I_ooooooool08_ooo`800004oooo0P0000?oool400000oooo`800003oooo00?o09T0I_l0
0000T?ooo`00DOooo`0306Kooooooooo027oool010000?ooooooo`0000Soool00`000?ooooooo`03
oooo00@0003oooooool00002oooo00?o09T0I_l00000T?ooo`00DOooo`0306Kooooooooo027oool0
10000?ooooooo`0000Woool00`000?ooooooo`05oooo00D0003oooooool0I_ooool00`0008koool0
057oool00`1Vooooooooo`0Qoooo00@0003oooooool0000:oooo00<0003oooooool00_ooo`800003
oooo00<0I_ooool00000T?ooo`00DOooo`0306Kooooooooo027oool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`02oooo00<0I_ooool00000T?ooo`00DOooo`0306Ko
oooooooo02;oool200002_ooo`800004oooo0`0000;oool00`1Vooooo`00002@oooo001Aoooo00<0
I_ooooooool0>Oooo`0406Kooooo00000000Soooo`00DOooo`0306Kooooooooo03Woool00`1Voooo
o`00002@oooo001Aoooo00<0I_ooooooool0>Oooo`0306Kooooo0000093oool0057oool00`1Voooo
ooooo`0ioooo00<0I_ooool00000T?ooo`00DOooo`0306Kooooooooo03Woool0101Vooooo`000000
08ooool0057oool00`1Vooooooooo`0ioooo00<0I_ooool00000T?ooo`00DOooo`0306Kooooooooo
03Woool00`1Vooooo`00002@oooo001Aoooo00<0I_ooooooool0>Oooo`0306Kooooo0000093oool0
057oool00`1Vooooooooo`0ioooo00@0I_ooool00000002?oooo001Aoooo00<0I_ooooooool0>Ooo
o`0306Kooooo0000093oool0057oool00`1Vooooooooo`0ioooo00<0I_ooool00000T?ooo`00DOoo
o`0306Kooooooooo03Woool00`1Vooooo`00002@oooo001Aoooo00<0I_ooooooool0>Oooo`0406Ko
oooo00000000Soooo`00DOooo`0306Kooooooooo03Woool00`1Vooooo`00002@oooo001Aoooo00<0
I_ooooooool0:?ooo`800004oooo0P0000Coool200000oooo`0306Kooooo0000093oool0057oool0
0`1Vooooooooo`0Woooo00@0003oooooool00008oooo00@0003oooooool00002oooo00<0I_ooool0
0000T?ooo`00DOooobX0I_l01000001Vo`1Vo`0000/0I_l01@00001Vo`1Vo`1Vooooo`030000S_oo
o`00Noooo`040000oooooooo00002Oooo`800003oooo00?o09Woool00000T?ooo`00Noooo`040000
oooooooo00002Oooo`030000oooooooo00;oool00ol0VOooo`00002@oooo001loooo0P0000[oool3
00000_ooo`03o`2Ioooo0000093oool008goool01?l0VOooo`00000008ooool008goool00ol0VOoo
o`00002@oooo002=oooo00?o09Woool00000T?ooo`00SOooo`04o`2Ioooo00000000Soooo`00SOoo
o`03o`2Ioooo0000093oool008goool00ol0VOooo`00002@oooo002=oooo00?o09Woool00000T?oo
o`00SOooo`04o`2Ioooo00000000Soooo`00SOooo`03o`2Ioooo0000093oool008goool00ol0VOoo
o`00002@oooo002=oooo00?o09Woool00000T?ooo`00SOooo`04o`2Ioooo00000000Soooo`00SOoo
o`03o`2Ioooo0000093oool007Koool200001?ooo`800005oooo00<0003oooooool00_ooo`800003
oooo00?o09Woool00000T?ooo`00MOooo`040000oooooooo00002_ooo`050000oooooooooooo0000
00;oool01P000?ooooooool0VOooo`00093oool007Goool010000?ooooooo`0000[oool00`000?oo
ooooo`04oooo00D0003ooooooooo09Woool00`0008koool007Goool010000?ooooooo`0000_oool0
10000?ooooooooooo`800003oooo00?o09Woool00000T?ooo`00MOooo`040000oooooooo00002?oo
o`040000oooooooo00000oooo`030000oooooooo00;oool00ol0VOooo`00002@oooo001foooo0P00
00Woool400000oooo`<00002oooo00?o09Woool00000T?ooo`00SOooo`04o`2Ioooo00000000Sooo
o`00SOooo`03o`2Ioooo0000093oool008goool00ol0VOooo`00002@oooo002=oooo00?o09Woool0
0000T?ooo`00SOooo`04o`2Ioooo00000000Soooo`00SOooo`03o`2Ioooo0000093oool008goool0
0ol0VOooo`00002@oooo002=oooo00?o09Woool00000T?ooo`00SOooo`04o`2Ioooo00000000Sooo
o`00SOooo`03o`2Ioooo0000093oool008goool00ol0VOooo`00002@oooo002=oooo00?o09Woool0
0000T?ooo`00SOooo`04o`2Ioooo00000000Soooo`00SOooo`03o`2Ioooo0000093oool008Ooool5
000000Cooooo09Woool0002@oooo0029oooo00L0003ooooooooooooo09Woool00000T?ooo`00ROoo
o`060000ooooooooooooo`2Ioooo0`0008koool008Woool00`000?ooooooo`2Doooo0029oooo00<0
003oooooool0U?ooo`00R?ooo`80002Foooo003ooooo8Oooo`00ooooob7oool007Koool00`000?oo
ooooo`0^oooo00<0003oooooool0M_ooo`00MOooo`030000oooooooo00Soool00`000?ooooooo`0U
oooo00<0003oooooool0MOooo`00MOooo`030000oooooooo00;oool200001?ooo`030000oooooooo
00coool500000_ooo`800004oooo0P0000Coool200001?ooo`030000oooooooo07Goool007Goool0
1@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo00Coool400001Ooo
o`030000oooooooo00Ooool010000?ooooooo`0000;oool010000?ooooooo`0000?oool00`000?oo
ooooo`1eoooo001doooo00<0003oooooool00_ooo`030000oooooooo01Goool00`000?ooooooo`07
oooo00@0003oooooool00005oooo00<0003oooooool00_ooo`030000oooooooo07Coool007Goool0
0`000?ooooooo`0500005?ooo`030000oooooooo00Ooool010000?ooooooo`0000?oool200001?oo
o`030000oooooooo07Goool007Goool01@000?ooooooooooo`00000Goooo00<0003oooooool01ooo
o`040000oooooooo00000oooo`030000oooooooo00?oool00`000?ooooooo`1eoooo001foooo00<0
003oooooool05oooo`80000:oooo0P0000Coool300000_ooo`030000oooooooo07Koool00?oooolQ
oooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.48147 .30902 L
.49012 .30902 L
.49468 .30902 L
.49719 .30902 L
.49842 .30902 L
.49955 .30902 L
s
.49955 .30902 m
.49968 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.24141 .30902 L
.25127 .30902 L
.25666 .30902 L
.2593 .30902 L
.26045 .30902 L
.26171 .30902 L
.26301 .46353 L
.26425 .46353 L
.26698 .46353 L
.27279 .46353 L
.28302 .46353 L
.30316 .46353 L
.3438 .46353 L
.38293 .46353 L
.42451 .46353 L
.44538 .46353 L
.46458 .46353 L
.48333 .46353 L
.49277 .46353 L
.49535 .46353 L
.49678 .46353 L
.49813 .46353 L
.49938 .46353 L
.50009 .30902 L
.50074 .30902 L
.50313 .30902 L
.5424 .30902 L
.58015 .30902 L
.62035 .30902 L
.65904 .30902 L
.70018 .30902 L
.7398 .30902 L
.77791 .30902 L
.81847 .30902 L
.85752 .30902 L
.89901 .30902 L
.939 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0
003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo
00goool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo01Goool001Koool0
0`000?ooooooo`0joooo00<0003oooooool0>Oooo`030000oooooooo03Woool00`000?ooooooo`0j
oooo00<0003oooooool05Oooo`00Doooo`0306Kooooooooo03Woool00`000?ooooooo`2>oooo001C
oooo00<0I_ooooooool0>Oooo`80002?oooo001Coooo00<0I_ooooooool0>Oooo`030000oooooooo
08koool005?oool00`1Vooooooooo`0ioooo00<0003oooooool0S_ooo`00Doooo`0306Kooooooooo
03Woool00`000?ooooooo`2>oooo001Coooo00<0I_ooooooool0>Oooo`80002?oooo001Coooo00<0
I_ooooooool0>Oooo`030000oooooooo08koool005?oool00`1Vooooooooo`0ioooo00<0003ooooo
ool0S_ooo`00Doooo`0306Kooooooooo03Woool00`000?ooooooo`2>oooo001Coooo00<0I_oooooo
ool0>Oooo`80002?oooo001Coooo00<0I_ooooooool0>Oooo`030000oooooooo08koool005?oool0
0`1Vooooooooo`0ioooo00<0003oooooool0S_ooo`00Doooo`0306Kooooooooo03Woool00`000?oo
ooooo`2>oooo001Coooo00<0I_ooooooool0>Oooo`80002?oooo001Coooo00<0I_ooooooool0>Ooo
o`030000oooooooo08koool005?oool00`1Vooooooooo`0Poooo0P0000Coool200000oooo`@00003
oooo0P0000Goool00`000?ooooooo`2>oooo001Coooo00<0I_ooooooool07oooo`040000oooooooo
00002?ooo`030000oooooooo00?oool010000?ooooooo`0000Coool00`000?ooooooo`2>oooo001C
oooo00<0I_ooooooool07oooo`040000oooooooo00002Oooo`030000oooooooo00Goool00`000?oo
ooooo`02oooo0`0008koool005?oool00`1Vooooooooo`0Ooooo00@0003oooooool0000:oooo00<0
003oooooool00_ooo`800005oooo00<0003oooooool0S_ooo`00Doooo`0306Kooooooooo01ooool0
10000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003ooooo
ool0S_ooo`00Doooo`0306Kooooooooo023oool200002_ooo`800004oooo0`0000Coool00`000?oo
ooooo`2>oooo001Coooo00<0I_ooooooool0>Oooo`80002?oooo001Coooo00<0I_ooooooool0>Ooo
o`030000oooooooo08koool005?oool00`1Vooooooooo`0ioooo00<0003oooooool0S_ooo`00Dooo
o`0306Kooooooooo03Woool00`000?ooooooo`2>oooo001Coooo00<0I_ooooooool0>Oooo`80002?
oooo001Coooo00<0I_ooooooool0>Oooo`030000oooooooo08koool005?oool00`1Vooooooooo`0i
oooo00<0003oooooool0S_ooo`00Doooo`0306Kooooooooo03Woool00`000?ooooooo`2>oooo001C
oooo00<0I_ooooooool0>Oooo`80002?oooo001Coooo00<0I_ooooooool0>Oooo`030000oooooooo
08koool005?oool00`1Vooooooooo`0ioooo00<0003oooooool0S_ooo`00Doooo`0306Kooooooooo
03Woool00`000?ooooooo`2>oooo001Coooo00<0I_ooooooool0>Oooo`80002?oooo001Coooo00<0
I_ooooooool0>Oooo`030000oooooooo08koool005?oool00`1Vooooooooo`0Voooo0P0000Coool2
00001?ooo`800005oooo00<0003oooooool0S_ooo`00Doooo`0306Kooooooooo02Goool010000?oo
ooooo`0000Soool010000?ooooooo`0000Coool00`000?ooooooo`2>oooo001Coooo:01Vo`040000
06Ko06Ko00002`1Vo`03000006Ko06Ko0080I_l30000S_ooo`00Noooo`040000oooooooo00002Ooo
o`800005oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002Oooo`030000oooooooo
00Coool00`000?ooooooo`2>oooo001loooo0P0000[oool300001?ooo`030000oooooooo08koool0
08ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00M_ooo`800004oooo0P0000Goool00`000?ooooooo`02oooo0P0000Goool0
0`000?ooooooo`2>oooo001eoooo00@0003oooooool0000:oooo00D0003oooooooooool000000_oo
o`030000oooooooo00;oool00`000?ooooooo`2>oooo001eoooo00@0003oooooool0000:oooo00<0
003oooooool01?ooo`030000oooooooo00;oool30000S_ooo`00MOooo`040000oooooooo00002ooo
o`040000oooooooooooo0P0000Goool00`000?ooooooo`2>oooo001eoooo00@0003oooooool00008
oooo00@0003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo08koool007Koool2
00002Oooo`@00003oooo0`0000Coool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool0
08ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool0
0`000?ooooooo`2>oooo0027oooo1@0000?oool00`000?ooooooo`2>oooo0029oooo00<0003ooooo
ool00oooo`030000oooooooo08koool008Woool00`000?ooooooo`03oooo0`0008koool008Woool0
0`000?ooooooo`2Doooo0029oooo00<0003oooooool0U?ooo`00R?ooo`80002Foooo003ooooo8Ooo
o`00ooooob7oool007coool00`000?ooooooo`0Roooo00<0003oooooool0O?ooo`00Noooo`030000
oooooooo00Soool00`000?ooooooo`0Ioooo00<0003oooooool0Noooo`00Noooo`030000oooooooo
00;oool200001?ooo`030000oooooooo00coool500000_ooo`800004oooo00<0003oooooool0Nooo
o`00Noooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01?oo
o`@00005oooo00<0003oooooool02?ooo`030000oooooooo07_oool007[oool00`000?ooooooo`02
oooo00<0003oooooool05Oooo`030000oooooooo00Woool00`000?ooooooo`1joooo001koooo00<0
003oooooool01@0001Coool00`000?ooooooo`08oooo00<0003oooooool0Noooo`00Noooo`050000
oooooooooooo000001Ooool00`000?ooooooo`08oooo00<0003oooooool0Noooo`00O?ooo`030000
oooooooo01Ooool200002Oooo`030000oooooooo07coool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.95) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.48147 .30902 L
.49012 .30902 L
.49955 .30902 L
.50205 .30902 L
.50342 .30902 L
.50471 .30902 L
.50592 .30902 L
s
.50592 .30902 m
.50605 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.24141 .30902 L
.25127 .30902 L
.26171 .30902 L
.26425 .30902 L
.26565 .30902 L
.26698 .30902 L
.26773 .30902 L
.26855 .46353 L
.26929 .46353 L
.26998 .46353 L
.27279 .46353 L
.28302 .46353 L
.30316 .46353 L
.34228 .46353 L
.38387 .46353 L
.42393 .46353 L
.46248 .46353 L
.48242 .46353 L
.48727 .46353 L
.48994 .46353 L
.49246 .46353 L
.49316 .46353 L
.49389 .46353 L
.4947 .30902 L
.49545 .30902 L
.49817 .30902 L
.50349 .30902 L
.54124 .30902 L
.58144 .30902 L
.62013 .30902 L
.66127 .30902 L
.70089 .30902 L
.739 .30902 L
.77956 .30902 L
.81861 .30902 L
.86011 .30902 L
.90009 .30902 L
.93855 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.95) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool03?ooo`03000006Kooooo00coool00`000?ooooooo`0<oooo00<0
003oooooool03?ooo`030000oooooooo00_oool00`1Vo`000?l0V@0=oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo
00goool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo01Goool001Koool0
0`000?ooooooo`0joooo00<00000I_ooool0>?ooo`0306Ko0000o`2I03[oool00`000?ooooooo`0j
oooo00<0003oooooool05Oooo`00E?ooo`0306Kooooooooo03Ooool00`1Vo`000?l0V@2?oooo001D
oooo00<0I_ooooooool0=oooo`0306Ko0000000008ooool005Coool00`1Vooooooooo`0goooo00<0
I_l0003o09T0Soooo`00E?ooo`0306Kooooooooo03Ooool00`1Vo`000?l0V@2?oooo001Doooo00<0
I_ooooooool0=oooo`0306Ko0000o`2I08ooool005Coool00`1Vooooooooo`0goooo00<0I_l00000
0000Soooo`00E?ooo`0306Kooooooooo03Ooool00`1Vo`000?l0V@2?oooo001Doooo00<0I_oooooo
ool0=oooo`0306Ko0000o`2I08ooool005Coool00`1Vooooooooo`0goooo00<0I_l0003o09T0Sooo
o`00E?ooo`0306Kooooooooo03Ooool00`1Vo`000000002?oooo001Doooo00<0I_ooooooool0=ooo
o`0306Ko0000o`2I08ooool005Coool00`1Vooooooooo`0goooo00<0I_l0003o09T0Soooo`00E?oo
o`0306Kooooooooo03Ooool00`1Vo`000?l0V@2?oooo001Doooo00<0I_ooooooool0=oooo`0306Ko
0000000008ooool005Coool00`1Vooooooooo`0goooo00<0I_l0003o09T0Soooo`00E?ooo`0306Ko
oooooooo01ooool200001?ooo`800003oooo100000?oool200001?ooo`0306Ko0000o`2I08ooool0
05Coool00`1Vooooooooo`0Noooo00@0003oooooool00008oooo00<0003oooooool00oooo`040000
oooooooo00000oooo`0306Ko0000o`2I08ooool005Coool00`1Vooooooooo`0Noooo00@0003ooooo
ool00009oooo00<0003oooooool01Oooo`050000oooooooo06Kooooo00<0002>oooo001Doooo00<0
I_ooooooool07_ooo`040000oooooooo00002_ooo`030000oooooooo00;oool200000oooo`0406Ko
oooo0000o`2ISoooo`00E?ooo`0306Kooooooooo01koool010000?ooooooo`0000Soool010000?oo
ooooo`0000?oool00`000?ooooooo`02oooo00@0I_ooool0003o09V?oooo001Doooo00<0I_oooooo
ool07oooo`80000:oooo0P0000Coool300000_ooo`0406Kooooo0000o`2ISoooo`00E?ooo`0306Ko
oooooooo03Koool0101Vooooo`00000008ooool005Coool00`1Vooooooooo`0foooo00@0I_ooool0
003o09V?oooo001Doooo00<0I_ooooooool0=_ooo`0406Kooooo0000o`2ISoooo`00E?ooo`0306Ko
oooooooo03Koool0101Vooooo`000?l0VHooool005Coool00`1Vooooooooo`0foooo00@0I_ooool0
0000002?oooo001Doooo00<0I_ooooooool0=_ooo`0406Kooooo0000o`2ISoooo`00E?ooo`0306Ko
oooooooo03Koool0101Vooooo`000?l0VHooool005Coool00`1Vooooooooo`0foooo00@0I_ooool0
003o09V?oooo001Doooo00<0I_ooooooool0=_ooo`0406Kooooo00000000Soooo`00E?ooo`0306Ko
oooooooo03Koool0101Vooooo`000?l0VHooool005Coool00`1Vooooooooo`0foooo00@0I_ooool0
003o09V?oooo001Doooo00<0I_ooooooool0=_ooo`0406Kooooo0000o`2ISoooo`00E?ooo`0306Ko
oooooooo03Koool0101Vooooo`00000008ooool005Coool00`1Vooooooooo`0foooo00@0I_ooool0
003o09V?oooo001Doooo00<0I_ooooooool09Oooo`800004oooo0P0000Coool200000oooo`0406Ko
oooo0000o`2ISoooo`00E?ooo`0306Kooooooooo02Coool010000?ooooooo`0000Soool010000?oo
ooooo`0000;oool0101Vooooo`000?l0VHooool005CooolW06Ko00@00000I_l0I_l0000;06Ko00D0
0000I_l0I_l0I_ooool00`0008koool007_oool010000?ooooooo`0000Woool200001Oooo`030000
ooooo`2I08koool007_oool010000?ooooooo`0000Woool00`000?ooooooo`04oooo00<0003ooooo
09T0S_ooo`00O?ooo`80000:oooo0`0000Coool00`000?ooool0V@2>oooo002?oooo0P000003o`2I
oooooooo08coool008ooool00`000?ooool0V@2>oooo002?oooo00<0003ooooo09T0S_ooo`00Sooo
o`8000000ol0VOooooooo`2<oooo002?oooo00<0003ooooo09T0S_ooo`00Soooo`030000ooooo`2I
08koool008ooool00`000?ooool0V@2>oooo002?oooo0P000003o`2Ioooooooo08coool008ooool0
0`000?ooool0V@2>oooo002?oooo00<0003ooooo09T0S_ooo`00Soooo`030000ooooo`2I08koool0
08ooool2000000?o09Woooooool0S?ooo`00Soooo`030000ooooo`2I08koool007Koool200001?oo
o`800005oooo00<0003oooooool00_ooo`800005oooo00<0003ooooo09T0S_ooo`00MOooo`040000
oooooooo00002_ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003ooooo
09T0S_ooo`00MOooo`040000oooooooo00002_ooo`030000oooooooo00Coool00`000?ooooooo`02
oooo0`0008koool007Goool010000?ooooooo`0000_oool010000?ooooooooooo`800005oooo00<0
003ooooo09T0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000
oooooooo00Coool00`000?ooool0V@2>oooo001foooo0P0000Woool400000oooo`<00004oooo00<0
003ooooo09T0S_ooo`00Soooo`8000000ol0VOooooooo`2<oooo002?oooo00<0003ooooo09T0S_oo
o`00Soooo`030000ooooo`2I08koool008ooool00`000?ooool0V@2>oooo002?oooo0P000003o`2I
oooooooo08coool008ooool00`000?ooool0V@2>oooo002?oooo00<0003ooooo09T0S_ooo`00Sooo
o`030000ooooo`2I08koool008ooool2000000?o09Woooooool0S?ooo`00Soooo`030000ooooo`2I
08koool008ooool00`000?ooool0V@2>oooo002?oooo00<0003ooooo09T0S_ooo`00Soooo`800000
0ol0VOooooooo`2<oooo002?oooo00<0003ooooo09T0S_ooo`00Qoooo`D00003oooo00<0003ooooo
09T0S_ooo`00ROooo`030000oooooooo00?oool00`000?ooool0V@2>oooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0029oooo00<0003oooooool0U?ooo`00ROooo`030000oooooooo09Coool0
08Soool20000U_ooo`00ooooob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000
oooooooo07Koool007Goool00`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo
07Goool007Goool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool2
00000oooo`<00004oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool0
00000_ooo`030000oooooooo00;oool00`000?ooooooo`04oooo100000?oool010000?ooooooo`00
00[oool01@000?ooooooooooo`000002oooo00D0003oooooooooool00000Moooo`00M?ooo`030000
oooooooo00;oool00`000?ooooooo`0Coooo00@0003oooooool00009oooo0`0000Goool00`000?oo
ooooo`02oooo00<0003oooooool0M?ooo`00MOooo`030000oooooooo00D0000Boooo00@0003ooooo
ool00008oooo00@0003oooooool00003oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0
003oooooooooool000005Oooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000
oooooooo00?oool00`000?ooooooo`1eoooo001foooo00<0003oooooool05oooo`80000:oooo0`00
00?oool300000_ooo`030000oooooooo07Koool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.9) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.48147 .30902 L
.49955 .30902 L
.50431 .30902 L
.50682 .30902 L
.5082 .30902 L
.5095 .30902 L
.51074 .30902 L
.51143 .30902 L
s
.51143 .30902 m
.5115 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.24141 .30902 L
.26171 .30902 L
.26709 .30902 L
.27003 .30902 L
.27147 .30902 L
.27279 .30902 L
.27399 .46353 L
.27513 .46353 L
.27765 .46353 L
.28302 .46353 L
.30316 .46353 L
.34135 .46353 L
.38199 .46353 L
.42112 .46353 L
.4411 .46353 L
.46271 .46353 L
.47285 .46353 L
.4784 .46353 L
.48357 .46353 L
.48584 .46353 L
.48696 .46353 L
.48799 .46353 L
.48918 .30902 L
.49047 .30902 L
.49273 .30902 L
.50277 .30902 L
.54204 .30902 L
.57979 .30902 L
.61999 .30902 L
.65868 .30902 L
.69982 .30902 L
.73944 .30902 L
.77755 .30902 L
.81811 .30902 L
.85716 .30902 L
.89866 .30902 L
.93864 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.9) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool03?ooo`030000oooo06Ko00coool00`000?ooooooo`0<oooo00<0
003oooooool03?ooo`030000oooooooo00Woool0101Vooooooooo`0000;oool00ol0VOooooooo`09
oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003ooooo
ool03?ooo`030000oooooooo00goool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000
oooooooo01Goool001Koool00`000?ooooooo`0joooo00<0003oool0I_l0=_ooo`0406Kooooooooo
00000_ooo`03o`2Ioooooooo03Koool00`000?ooooooo`0joooo00<0003oooooool05Oooo`00EOoo
o`0306Kooooooooo03Coool0101Vooooooooo`0000;oool00ol0VOooooooo`2;oooo001Eoooo00<0
I_ooooooool0=?ooo`0306Kooooooooo008000000oooool0VOooo`2<oooo001Eoooo00<0I_oooooo
ool0=?ooo`0406Kooooooooo00000_ooo`03o`2Ioooooooo08_oool005Goool00`1Vooooooooo`0d
oooo00@0I_ooooooool00002oooo00?o09Woooooool0Roooo`00EOooo`0306Kooooooooo03Coool0
101Vooooooooo`0000;oool00ol0VOooooooo`2;oooo001Eoooo00<0I_ooooooool0=?ooo`0306Ko
oooooooo008000000oooool0VOooo`2<oooo001Eoooo00<0I_ooooooool0=?ooo`0406Kooooooooo
00000_ooo`03o`2Ioooooooo08_oool005Goool00`1Vooooooooo`0doooo00@0I_ooooooool00002
oooo00?o09Woooooool0Roooo`00EOooo`0306Kooooooooo03Coool0101Vooooooooo`0000;oool0
0ol0VOooooooo`2;oooo001Eoooo00<0I_ooooooool0=?ooo`0306Kooooooooo008000000oooool0
VOooo`2<oooo001Eoooo00<0I_ooooooool0=?ooo`0406Kooooooooo00000_ooo`03o`2Ioooooooo
08_oool005Goool00`1Vooooooooo`0doooo00@0I_ooooooool00002oooo00?o09Woooooool0Rooo
o`00EOooo`0306Kooooooooo03Coool0101Vooooooooo`0000;oool00ol0VOooooooo`2;oooo001E
oooo00<0I_ooooooool0=?ooo`0306Kooooooooo008000000oooool0VOooo`2<oooo001Eoooo00<0
I_ooooooool0=?ooo`0406Kooooooooo00000_ooo`03o`2Ioooooooo08_oool005Goool00`1Voooo
ooooo`0Noooo0P0000Coool200000oooo`@00003oooo0P0000;oool0101Vooooooooo`0000;oool0
0ol0VOooooooo`2;oooo001Eoooo00<0I_ooooooool07Oooo`040000oooooooo00002?ooo`030000
oooooooo00?oool01P000?ooooooo`000?ooo`1Vo`;oool010000?ooooooool0VHgoool005Goool0
0`1Vooooooooo`0Moooo00@0003oooooool00009oooo00<0003oooooool01Oooo`030000oooo06Ko
00;oool3000000?o09Woooooool0Roooo`00E_ooo`0306Kooooooooo01coool010000?ooooooo`00
00[oool00`000?ooooooo`02oooo0P0000;oool0101Vooooooooo`0000;oool00ol0VOooooooo`2;
oooo001Foooo00<0I_ooooooool07?ooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`050000oooooooooooo06Ko00;oool010000?ooooooool0VHgoool005Koool00`1Vooooooooo`0M
oooo0P0000[oool200001?ooo`<000001Oooo`1Vooooooooo`000002oooo00?o09Woooooool0Rooo
o`00E_ooo`0306Kooooooooo03?oool00`1Vooooooooo`02000000?ooooo09Woool0S?ooo`00E_oo
o`0306Kooooooooo03?oool0101Vooooooooo`0000;oool00ol0VOooooooo`2;oooo001Foooo00<0
I_ooooooool0<oooo`0406Kooooooooo00000_ooo`03o`2Ioooooooo08_oool005Koool00`1Voooo
ooooo`0coooo00@0I_ooooooool00002oooo00?o09Woooooool0Roooo`00E_ooo`0306Kooooooooo
03?oool00`1Vooooooooo`02000000?ooooo09Woool0S?ooo`00E_ooo`0306Kooooooooo03?oool0
101Vooooooooo`0000;oool00ol0VOooooooo`2;oooo001Foooo00<0I_ooooooool0<oooo`0406Ko
oooooooo00000_ooo`03o`2Ioooooooo08_oool005Koool00`1Vooooooooo`0coooo00@0I_oooooo
ool00002oooo00?o09Woooooool0Roooo`00E_ooo`0306Kooooooooo03?oool00`1Vooooooooo`02
000000?ooooo09Woool0S?ooo`00E_ooo`0306Kooooooooo03?oool0101Vooooooooo`0000;oool0
0ol0VOooooooo`2;oooo001Foooo00<0I_ooooooool0<oooo`0406Kooooooooo00000_ooo`03o`2I
oooooooo08_oool005Koool00`1Vooooooooo`0coooo00@0I_ooooooool00002oooo00?o09Wooooo
ool0Roooo`00E_ooo`0306Kooooooooo03?oool00`1Vooooooooo`02000000?ooooo09Woool0S?oo
o`00E_ooo`0306Kooooooooo03?oool0101Vooooooooo`0000;oool00ol0VOooooooo`2;oooo001F
oooo00<0I_ooooooool08oooo`800004oooo0P0000Coool200000_ooo`0406Kooooooooo00000_oo
o`03o`2Ioooooooo08_oool005Koool00`1Vooooooooo`0Roooo00@0003oooooool00008oooo00H0
003oooooool0003oool0I_l2oooo00@0003ooooooooo09V=oooo001Foooo9@1Vo`04000006Ko06Ko
00002`1Vo`03000006Ko06Ko00;oool3000000?o09Woooooool0Roooo`00Noooo`040000oooooooo
00002Oooo`800005oooo00@0003ooooooooo09V=oooo001koooo00@0003oooooool00009oooo00<0
003oooooool01?ooo`040000ooooooooo`2ISOooo`00O?ooo`80000:oooo0`0000Coool010000?oo
ooooool0VHgoool008ooool2000000?ooooo09Woool0S?ooo`00Soooo`040000ooooooooo`2ISOoo
o`00Soooo`040000ooooooooo`2ISOooo`00Soooo`8000000oooool0VOooo`2<oooo002?oooo00@0
003ooooooooo09V=oooo002?oooo00@0003ooooooooo09V=oooo002?oooo00@0003ooooooooo09V=
oooo002?oooo0P000003ooooo`2Ioooo08coool008ooool010000?ooooooool0VHgoool008ooool0
10000?ooooooool0VHgoool008ooool010000?ooooooool0VHgoool008ooool2000000?ooooo09Wo
ool0S?ooo`00Soooo`040000ooooooooo`2ISOooo`00M_ooo`800004oooo0P0000Goool00`000?oo
ooooo`02oooo0P0000Goool010000?ooooooool0VHgoool007Goool010000?ooooooo`0000[oool0
1@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`040000ooooooooo`2ISOooo`00MOoo
o`040000oooooooo00002_ooo`030000oooooooo00Coool00`000?ooooooo`02oooo0`000003o`2I
oooooooo08_oool007Goool010000?ooooooo`0000_oool010000?ooooooooooo`800005oooo00@0
003ooooooooo09V=oooo001eoooo00@0003oooooool00008oooo00@0003oooooool00003oooo00<0
003oooooool01?ooo`040000ooooooooo`2ISOooo`00M_ooo`800009oooo100000?oool300001?oo
o`040000ooooooooo`2ISOooo`00Soooo`8000000oooool0VOooo`2<oooo002?oooo00@0003ooooo
oooo09V=oooo002?oooo00@0003ooooooooo09V=oooo002?oooo00@0003ooooooooo09V=oooo002?
oooo0P000003ooooo`2Ioooo08coool008ooool010000?ooooooool0VHgoool008ooool010000?oo
ooooool0VHgoool008ooool010000?ooooooool0VHgoool008ooool2000000?ooooo09Woool0S?oo
o`00Soooo`040000ooooooooo`2ISOooo`00Soooo`040000ooooooooo`2ISOooo`00Soooo`040000
ooooooooo`2ISOooo`00Soooo`8000000oooool0VOooo`2<oooo002?oooo00@0003ooooooooo09V=
oooo0027oooo1@0000?oool010000?ooooooool0VHgoool008Woool00`000?ooooooo`03oooo00@0
003ooooooooo09V=oooo0029oooo00<0003oooooool00oooo`<000000ol0VOooooooo`2;oooo0029
oooo00<0003oooooool0U?ooo`00ROooo`030000oooooooo09Coool008Soool20000U_ooo`00oooo
ob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo07Woool007Soool0
0`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool007Soool00`000?oo
ooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool200000oooo`<00004oooo00<0
003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0
003oooooool01?ooo`@00003oooo00@0003oooooool0000:oooo00<0003oooooool00_ooo`030000
oooooooo07Soool007Ooool00`000?ooooooo`02oooo00<0003oooooool04oooo`040000oooooooo
00002Oooo`<00004oooo00<0003oooooool0Moooo`00N?ooo`030000oooooooo00D0000Boooo00@0
003oooooool00008oooo00@0003oooooool00003oooo00<0003oooooool0N?ooo`00N?ooo`050000
oooooooooooo000001Goool010000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?oo
ooooo`1hoooo001ioooo00<0003oooooool05oooo`80000:oooo0`0000;oool00`000?ooooooo`1i
oooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.85) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.48147 .30902 L
.49955 .30902 L
.50431 .30902 L
.5095 .30902 L
.51188 .30902 L
.51441 .30902 L
.51564 .30902 L
.5168 .30902 L
.51784 .30902 L
s
.51784 .30902 m
.51795 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.24141 .30902 L
.26171 .30902 L
.26709 .30902 L
.27279 .30902 L
.27513 .30902 L
.27765 .30902 L
.2784 .30902 L
.2791 .30902 L
.28042 .46353 L
.28166 .46353 L
.28302 .46353 L
.30316 .46353 L
.3438 .46353 L
.38293 .46353 L
.42451 .46353 L
.44538 .46353 L
.45453 .46353 L
.46458 .46353 L
.46926 .46353 L
.47427 .46353 L
.47671 .46353 L
.47901 .46353 L
.48001 .46353 L
.48108 .46353 L
.48224 .30902 L
.48333 .30902 L
.50313 .30902 L
.54088 .30902 L
.58108 .30902 L
.61977 .30902 L
.66091 .30902 L
.70054 .30902 L
.73864 .30902 L
.7792 .30902 L
.81825 .30902 L
.85975 .30902 L
.89973 .30902 L
.9382 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.85) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool03?ooo`050000oooooooooooo06Ko00[oool00`000?ooooooo`0<
oooo00<0003oooooool03?ooo`030000oooooooo00Ooool00`1Vooooooooo`02oooo00D0003ooooo
oooooooo09T02_ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo
00coool00`000?ooooooo`0Eoooo000Foooo00<0003oooooool0>_ooo`050000oooooooooooo06Ko
03;oool00`1Vooooooooo`02oooo00D0003ooooooooooooo09T0=oooo`030000oooooooo03[oool0
0`000?ooooooo`0Eoooo001Goooo00<0I_ooooooool0<?ooo`0306Kooooooooo00;oool01@000?oo
ooooooooool0V@2<oooo001Goooo00<0I_ooooooool0<?ooo`0306Kooooooooo00;oool200000_oo
o`03o`2Ioooooooo08[oool005Ooool00`1Vooooooooo`0`oooo00<0I_ooooooool00_ooo`050000
ooooooooooooo`2I08coool005Ooool00`1Vooooooooo`0`oooo00<0I_ooooooool00_ooo`050000
ooooooooooooo`2I08coool005Ooool00`1Vooooooooo`0`oooo00<0I_ooooooool00_ooo`050000
ooooooooooooo`2I08coool005Ooool00`1Vooooooooo`0`oooo00<0I_ooooooool00_ooo`800002
oooo00?o09Woooooool0R_ooo`00Eoooo`0306Kooooooooo033oool00`1Vooooooooo`02oooo00D0
003ooooooooooooo09T0S?ooo`00Eoooo`0306Kooooooooo033oool00`1Vooooooooo`02oooo00D0
003ooooooooooooo09T0S?ooo`00Eoooo`0306Kooooooooo033oool00`1Vooooooooo`02oooo00D0
003ooooooooooooo09T0S?ooo`00Eoooo`0306Kooooooooo033oool00`1Vooooooooo`02oooo0P00
00;oool00ol0VOooooooo`2:oooo001Goooo00<0I_ooooooool0<?ooo`0306Kooooooooo00;oool0
1@000?ooooooooooool0V@2<oooo001Goooo00<0I_ooooooool0<?ooo`0306Kooooooooo00;oool0
1@000?ooooooooooool0V@2<oooo001Goooo00<0I_ooooooool0<?ooo`0306Kooooooooo00;oool0
1@000?ooooooooooool0V@2<oooo001Goooo00<0I_ooooooool0<?ooo`0306Kooooooooo00;oool2
00000_ooo`03o`2Ioooooooo08[oool005Ooool00`1Vooooooooo`0`oooo00<0I_ooooooool00_oo
o`050000ooooooooooooo`2I08coool005Ooool00`1Vooooooooo`0Loooo0P0000Coool200000ooo
o`@00003oooo0P00000306Kooooooooo00;oool01@000?ooooooooooool0V@2<oooo001Goooo00<0
I_ooooooool06oooo`040000oooooooo00002?ooo`030000oooooooo00?oool010000?ooooooo`00
00Coool01@000?ooooooooooool0V@2<oooo001Goooo00<0I_ooooooool06oooo`040000oooooooo
00002Oooo`030000oooooooo00Goool00`000?ooooooo`02oooo0`000003ooooo`2Ioooo08_oool0
05Ooool00`1Vooooooooo`0Koooo00@0003oooooool0000:oooo00<0003oooooool00_ooo`800000
0`1Vooooooooo`02oooo00D0003ooooooooooooo09T0S?ooo`00Eoooo`0306Kooooooooo01_oool0
10000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?ooo`1Vo`04oooo00D0003ooooo
oooooooo09T0S?ooo`00Eoooo`0306Kooooooooo01coool200002_ooo`800004oooo0`0000Coool0
1@000?ooooooooooool0V@2<oooo001Goooo00<0I_ooooooool0<?ooo`0306Kooooooooo00;oool2
00000_ooo`03o`2Ioooooooo08[oool005Ooool00`1Vooooooooo`0`oooo00<0I_ooooooool00_oo
o`050000ooooooooooooo`2I08coool005Ooool00`1Vooooooooo`0`oooo00<0I_ooooooool00_oo
o`050000ooooooooooooo`2I08coool005Ooool00`1Vooooooooo`0`oooo00<0I_ooooooool00_oo
o`050000ooooooooooooo`2I08coool005Ooool00`1Vooooooooo`0`oooo00<0I_ooooooool00_oo
o`800002oooo00?o09Woooooool0R_ooo`00Eoooo`0306Kooooooooo033oool00`1Vooooooooo`02
oooo00D0003ooooooooooooo09T0S?ooo`00Eoooo`0306Kooooooooo033oool00`1Vooooooooo`02
oooo00D0003ooooooooooooo09T0S?ooo`00Eoooo`0306Kooooooooo033oool00`1Vooooooooo`02
oooo00D0003ooooooooooooo09T0S?ooo`00Eoooo`0306Kooooooooo033oool00`1Vooooooooo`02
oooo0P0000;oool00ol0VOooooooo`2:oooo001Goooo00<0I_ooooooool0<?ooo`0306Kooooooooo
00;oool01@000?ooooooooooool0V@2<oooo001Goooo00<0I_ooooooool0<?ooo`0306Kooooooooo
00;oool01@000?ooooooooooool0V@2<oooo001Goooo00<0I_ooooooool0<?ooo`0306Kooooooooo
00;oool01@000?ooooooooooool0V@2<oooo001Goooo00<0I_ooooooool0<?ooo`0306Kooooooooo
00;oool200000_ooo`03o`2Ioooooooo08[oool005Ooool00`1Vooooooooo`0`oooo00<0I_oooooo
ool00_ooo`050000ooooooooooooo`2I08coool005Ooool00`1Vooooooooo`0Roooo0P0000Coool2
00001?ooo`8000000`1Vooooooooo`02oooo00D0003ooooooooooooo09T0S?ooo`00Eoooo`0306Ko
oooooooo027oool010000?ooooooo`0000Soool010000?ooooooo`0000Coool01@000?oooooooooo
ool0V@2<oooo001Goooo901Vo`04000006Ko06Ko00002`1Vo`030000oooooooo00;oool300000_oo
o`03o`2Ioooooooo08Woool007_oool010000?ooooooo`0000Woool200001Oooo`030000oooooooo
00;oool00ol0VOooooooo`29oooo001koooo00@0003oooooool00009oooo00<0003oooooool01?oo
o`030000oooooooo00;oool00ol0VOooooooo`29oooo001loooo0P0000[oool300001?ooo`030000
oooooooo00;oool00ol0VOooooooo`29oooo002?oooo0P0000?oool00ol0VOooooooo`29oooo002?
oooo00<0003oooooool00_ooo`03o`2Ioooooooo08Woool008ooool00`000?ooooooo`02oooo00?o
09Woooooool0ROooo`00Soooo`800003oooo00?o09Woooooool0ROooo`00Soooo`030000oooooooo
00;oool00ol0VOooooooo`29oooo002?oooo00<0003oooooool00_ooo`03o`2Ioooooooo08Woool0
08ooool00`000?ooooooo`02oooo00?o09Woooooool0ROooo`00Soooo`800003oooo00?o09Wooooo
ool0ROooo`00Soooo`030000oooooooo00;oool00ol0VOooooooo`29oooo002?oooo00<0003ooooo
ool00_ooo`03o`2Ioooooooo08Woool008ooool00`000?ooooooo`02oooo00?o09Woooooool0ROoo
o`00Soooo`800003oooo00?o09Woooooool0ROooo`00Soooo`030000oooooooo00;oool00ol0VOoo
ooooo`29oooo001foooo0P0000Coool200001Oooo`030000oooooooo00;oool200001Oooo`030000
oooooooo00;oool00ol0VOooooooo`29oooo001eoooo00@0003oooooool0000:oooo00D0003ooooo
ooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`02oooo00?o09Woooooool0ROoo
o`00MOooo`040000oooooooo00002_ooo`030000oooooooo00Coool00`000?ooooooo`02oooo0`00
00;oool00ol0VOooooooo`29oooo001eoooo00@0003oooooool0000;oooo00@0003oooooooooool2
00001Oooo`030000oooooooo00;oool00ol0VOooooooo`29oooo001eoooo00@0003oooooool00008
oooo00@0003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo00;oool00ol0VOoo
ooooo`29oooo001foooo0P0000Woool400000oooo`<00004oooo00<0003oooooool00_ooo`03o`2I
oooooooo08Woool008ooool200000oooo`03o`2Ioooooooo08Woool008ooool00`000?ooooooo`02
oooo00?o09Woooooool0ROooo`00Soooo`030000oooooooo00;oool00ol0VOooooooo`29oooo002?
oooo00<0003oooooool00_ooo`03o`2Ioooooooo08Woool008ooool200000oooo`03o`2Ioooooooo
08Woool008ooool00`000?ooooooo`02oooo00?o09Woooooool0ROooo`00Soooo`030000oooooooo
00;oool00ol0VOooooooo`29oooo002?oooo00<0003oooooool00_ooo`03o`2Ioooooooo08Woool0
08ooool200000oooo`03o`2Ioooooooo08Woool008ooool00`000?ooooooo`02oooo00?o09Wooooo
ool0ROooo`00Soooo`030000oooooooo00;oool00ol0VOooooooo`29oooo002?oooo00<0003ooooo
ool00_ooo`03o`2Ioooooooo08Woool008ooool200000oooo`03o`2Ioooooooo08Woool008ooool0
0`000?ooooooo`02oooo00?o09Woooooool0ROooo`00Qoooo`D00003oooo00<0003oooooool00_oo
o`03o`2Ioooooooo08Woool008Woool00`000?ooooooo`03oooo00<0003oooooool00_ooo`03o`2I
oooooooo08Woool008Woool00`000?ooooooo`03oooo0`0000;oool00ol0VOooooooo`29oooo0029
oooo00<0003oooooool0U?ooo`00ROooo`030000oooooooo09Coool008Soool20000U_ooo`00oooo
ob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000oooooooo07Koool007Goool0
0`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool007Goool00`000?oo
ooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool200001?ooo`800004oooo0P00
00Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000000_ooo`030000oooooooo
00;oool00`000?ooooooo`04oooo100000?oool010000?ooooooo`0000Soool010000?ooooooo`00
00;oool010000?ooooooo`0000?oool00`000?ooooooo`1eoooo001doooo00<0003oooooool00_oo
o`030000oooooooo01?oool010000?ooooooo`0000Soool010000?ooooooo`0000Goool00`000?oo
ooooo`02oooo00<0003oooooool0M?ooo`00MOooo`030000oooooooo00D0000Boooo00@0003ooooo
ool00009oooo0P0000Coool200001?ooo`030000oooooooo07Goool007Goool01@000?oooooooooo
o`00000Eoooo00@0003oooooool00008oooo00@0003oooooool00003oooo00<0003oooooool00ooo
o`030000oooooooo07Goool007Koool00`000?ooooooo`0Goooo0P0000[oool200001?ooo`<00002
oooo00<0003oooooool0M_ooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.5095 .30902 L
.51441 .30902 L
.51896 .30902 L
.52148 .30902 L
.52221 .30902 L
.52289 .30902 L
s
.52289 .30902 m
.52302 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.27193 .30902 L
.27731 .30902 L
.28025 .30902 L
.28302 .30902 L
.28425 .30902 L
.28542 .30902 L
.28606 .46353 L
.28676 .46353 L
.288 .46353 L
.29349 .46353 L
.30316 .46353 L
.3438 .46353 L
.38293 .46353 L
.42451 .46353 L
.44538 .46353 L
.45453 .46353 L
.46458 .46353 L
.46926 .46353 L
.47183 .46353 L
.4731 .46353 L
.47427 .46353 L
.47537 .46353 L
.47654 .30902 L
.47771 .30902 L
.47901 .30902 L
.48333 .30902 L
.50313 .30902 L
.54333 .30902 L
.58202 .30902 L
.62316 .30902 L
.66278 .30902 L
.70089 .30902 L
.74145 .30902 L
.7805 .30902 L
.822 .30902 L
.86198 .30902 L
.90044 .30902 L
.94136 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00?oool00`1Vooooooooo`06oooo00<0
003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`06oooo00<0I_ooooooool00ooo
o`030000oooooooo00?oool00ol0VOooooooo`06oooo00<0003oooooool03?ooo`030000oooooooo
00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00goool00`000?oo
ooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo01Goool001Koool00`000?ooooooo`0j
oooo00<0003oooooool00oooo`0306Kooooooooo02goool00`1Vooooooooo`03oooo00<0003ooooo
ool00oooo`03o`2Ioooooooo03?oool00`000?ooooooo`0joooo00<0003oooooool05Oooo`00FOoo
o`0306Kooooooooo02goool00`1Vooooooooo`03oooo00<0003oooooool00oooo`03o`2Ioooooooo
08Soool005Woool00`1Vooooooooo`0]oooo00<0I_ooooooool00oooo`800004oooo00?o09Wooooo
ool0R?ooo`00FOooo`0306Kooooooooo02goool00`1Vooooooooo`03oooo00<0003oooooool00ooo
o`03o`2Ioooooooo08Soool005Woool00`1Vooooooooo`0]oooo00<0I_ooooooool00oooo`030000
oooooooo00?oool00ol0VOooooooo`28oooo001Ioooo00<0I_ooooooool0;Oooo`0306Kooooooooo
00?oool00`000?ooooooo`03oooo00?o09Woooooool0R?ooo`00FOooo`0306Kooooooooo02goool0
0`1Vooooooooo`03oooo0P0000Coool00ol0VOooooooo`28oooo001Ioooo00<0I_ooooooool0;Ooo
o`0306Kooooooooo00?oool00`000?ooooooo`03oooo00?o09Woooooool0R?ooo`00FOooo`0306Ko
oooooooo02goool00`1Vooooooooo`03oooo00<0003oooooool00oooo`03o`2Ioooooooo08Soool0
05Woool00`1Vooooooooo`0]oooo00<0I_ooooooool00oooo`030000oooooooo00?oool00ol0VOoo
ooooo`28oooo001Ioooo00<0I_ooooooool0;Oooo`0306Kooooooooo00?oool200001?ooo`03o`2I
oooooooo08Soool005Woool00`1Vooooooooo`0]oooo00<0I_ooooooool00oooo`030000oooooooo
00?oool00ol0VOooooooo`28oooo001Ioooo00<0I_ooooooool0;Oooo`0306Kooooooooo00?oool0
0`000?ooooooo`03oooo00?o09Woooooool0R?ooo`00FOooo`0306Kooooooooo02goool00`1Voooo
ooooo`03oooo00<0003oooooool00oooo`03o`2Ioooooooo08Soool005Woool00`1Vooooooooo`0]
oooo00<0I_ooooooool00oooo`800004oooo00?o09Woooooool0R?ooo`00FOooo`0306Kooooooooo
02goool00`1Vooooooooo`03oooo00<0003oooooool00oooo`03o`2Ioooooooo08Soool005Woool0
0`1Vooooooooo`0Joooo0P0000Coool200000oooo`@00003oooo0P0000Goool00`000?ooooooo`03
oooo00?o09Woooooool0R?ooo`00FOooo`0306Kooooooooo01Woool010000?ooooooo`0000Soool0
0`000?ooooooo`03oooo00@0003oool0I_l00004oooo00<0003oooooool00oooo`03o`2Ioooooooo
08Soool005Woool00`1Vooooooooo`0Ioooo00@0003oooooool00009oooo00<0003oooooool01?oo
o`0306Ko0000oooo00?oool300000oooo`03o`2Ioooooooo08Soool005Woool00`1Vooooooooo`0I
oooo00@0003oooooool0000:oooo00<0003oooooool00_ooo`800005oooo00<0003oooooool00ooo
o`03o`2Ioooooooo08Soool005Woool00`1Vooooooooo`0Ioooo00@0003oooooool00008oooo00@0
003oooooool00003oooo00<00000I_ooool01?ooo`030000oooooooo00?oool00ol0VOooooooo`28
oooo001Ioooo00<0I_ooooooool06_ooo`80000:oooo0P0000Coool300001?ooo`030000oooooooo
00?oool00ol0VOooooooo`28oooo001Ioooo00<0I_ooooooool0;Oooo`0306Kooooooooo00?oool2
00001?ooo`03o`2Ioooooooo08Soool005Woool00`1Vooooooooo`0]oooo00<0I_ooooooool00ooo
o`030000oooooooo00?oool00ol0VOooooooo`28oooo001Ioooo00<0I_ooooooool0;Oooo`0306Ko
oooooooo00?oool00`000?ooooooo`03oooo00?o09Woooooool0R?ooo`00FOooo`0306Kooooooooo
02goool00`1Vooooooooo`03oooo00<0003oooooool00oooo`03o`2Ioooooooo08Soool005Woool0
0`1Vooooooooo`0]oooo00<0I_ooooooool00oooo`800004oooo00?o09Woooooool0R?ooo`00FOoo
o`0306Kooooooooo02goool00`1Vooooooooo`03oooo00<0003oooooool00oooo`03o`2Ioooooooo
08Soool005Woool00`1Vooooooooo`0]oooo00<0I_ooooooool00oooo`030000oooooooo00?oool0
0ol0VOooooooo`28oooo001Ioooo00<0I_ooooooool0;Oooo`0306Kooooooooo00?oool00`000?oo
ooooo`03oooo00?o09Woooooool0R?ooo`00FOooo`0306Kooooooooo02goool00`1Vooooooooo`03
oooo0P0000Coool00ol0VOooooooo`28oooo001Ioooo00<0I_ooooooool0;Oooo`0306Kooooooooo
00?oool00`000?ooooooo`03oooo00?o09Woooooool0R?ooo`00FOooo`0306Kooooooooo02goool0
0`1Vooooooooo`03oooo00<0003oooooool00oooo`03o`2Ioooooooo08Soool005Woool00`1Voooo
ooooo`0]oooo00<0I_ooooooool00oooo`030000oooooooo00?oool00ol0VOooooooo`28oooo001I
oooo00<0I_ooooooool0;Oooo`0306Kooooooooo00?oool200001?ooo`03o`2Ioooooooo08Soool0
05Woool00`1Vooooooooo`0]oooo00<0I_ooooooool00oooo`030000oooooooo00?oool00ol0VOoo
ooooo`28oooo001Ioooo00<0I_ooooooool08?ooo`800004oooo0P0000Coool200001Oooo`030000
oooooooo00?oool00ol0VOooooooo`28oooo001Ioooo00<0I_ooooooool07oooo`040000oooooooo
00002?ooo`040000oooo06Ko00001?ooo`030000oooooooo00?oool00ol0VOooooooo`28oooo001I
oooo8P1Vo`04000006Ko06Ko00002`1Vo`030000oooooooo00;oool300000oooo`03o`2Ioooooooo
08Soool007_oool010000?ooooooo`0000Woool200001Oooo`030000oooooooo00?oool00ol0VOoo
ooooo`28oooo001koooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo
00?oool00ol0VOooooooo`28oooo001loooo0P0000[oool300001?ooo`030000oooooooo00?oool0
0ol0VOooooooo`28oooo002?oooo0P0000Coool00ol0VOooooooo`28oooo002?oooo00<0003ooooo
ool00oooo`03o`2Ioooooooo08Soool008ooool00`000?ooooooo`03oooo00?o09Woooooool0R?oo
o`00Soooo`800004oooo00?o09Woooooool0R?ooo`00Soooo`030000oooooooo00?oool00ol0VOoo
ooooo`28oooo002?oooo00<0003oooooool00oooo`03o`2Ioooooooo08Soool008ooool00`000?oo
ooooo`03oooo00?o09Woooooool0R?ooo`00Soooo`800004oooo00?o09Woooooool0R?ooo`00Sooo
o`030000oooooooo00?oool00ol0VOooooooo`28oooo002?oooo00<0003oooooool00oooo`03o`2I
oooooooo08Soool008ooool00`000?ooooooo`03oooo00?o09Woooooool0R?ooo`00Soooo`800004
oooo00?o09Woooooool0R?ooo`00Soooo`030000oooooooo00?oool00ol0VOooooooo`28oooo001f
oooo0P0000Coool200001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo00?oool0
0ol0VOooooooo`28oooo001eoooo00@0003oooooool0000:oooo00D0003oooooooooool000000_oo
o`030000oooooooo00;oool00`000?ooooooo`03oooo00?o09Woooooool0R?ooo`00MOooo`040000
oooooooo00002_ooo`030000oooooooo00Coool00`000?ooooooo`02oooo0`0000?oool00ol0VOoo
ooooo`28oooo001eoooo00@0003oooooool0000;oooo00@0003oooooooooool200001Oooo`030000
oooooooo00?oool00ol0VOooooooo`28oooo001eoooo00@0003oooooool00008oooo00@0003ooooo
ool00003oooo00<0003oooooool01?ooo`030000oooooooo00?oool00ol0VOooooooo`28oooo001f
oooo0P0000Woool400000oooo`<00004oooo00<0003oooooool00oooo`03o`2Ioooooooo08Soool0
08ooool200001?ooo`03o`2Ioooooooo08Soool008ooool00`000?ooooooo`03oooo00?o09Wooooo
ool0R?ooo`00Soooo`030000oooooooo00?oool00ol0VOooooooo`28oooo002?oooo00<0003ooooo
ool00oooo`03o`2Ioooooooo08Soool008ooool200001?ooo`03o`2Ioooooooo08Soool008ooool0
0`000?ooooooo`03oooo00?o09Woooooool0R?ooo`00Soooo`030000oooooooo00?oool00ol0VOoo
ooooo`28oooo002?oooo00<0003oooooool00oooo`03o`2Ioooooooo08Soool008ooool200001?oo
o`03o`2Ioooooooo08Soool008ooool00`000?ooooooo`03oooo00?o09Woooooool0R?ooo`00Sooo
o`030000oooooooo00?oool00ol0VOooooooo`28oooo002?oooo00<0003oooooool00oooo`03o`2I
oooooooo08Soool008ooool200001?ooo`03o`2Ioooooooo08Soool008ooool00`000?ooooooo`03
oooo00?o09Woooooool0R?ooo`00Qoooo`D00003oooo00<0003oooooool00oooo`03o`2Ioooooooo
08Soool008Woool00`000?ooooooo`03oooo00<0003oooooool00oooo`03o`2Ioooooooo08Soool0
08Woool00`000?ooooooo`03oooo0`0000?oool00ol0VOooooooo`28oooo0029oooo00<0003ooooo
ool0U?ooo`00ROooo`030000oooooooo09Coool008Soool20000U_ooo`00ooooob7oool00?oooolQ
oooo001ioooo00<0003oooooool0:?ooo`030000oooooooo07Woool007Soool00`000?ooooooo`08
oooo00<0003oooooool07oooo`030000oooooooo07Soool007Soool00`000?ooooooo`02oooo0P00
00Coool00`000?ooooooo`0=oooo0P0000Coool200001?ooo`800004oooo00<0003oooooool0N?oo
o`00N?ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01?oo
o`@00003oooo00@0003oooooool00008oooo00@0003oooooool00003oooo00<0003oooooool0N?oo
o`00Moooo`030000oooooooo00;oool00`000?ooooooo`0Coooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0Moooo`00N?ooo`030000oooooooo00D0000Boooo00@0
003oooooool00009oooo0P0000Coool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool0
00005Oooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo07Soool0
07Woool00`000?ooooooo`0Goooo0P0000[oool200000oooo`030000oooooooo07Woool00?oooolQ
oooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.75) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.5095 .30902 L
.51896 .30902 L
.52417 .30902 L
.5256 .30902 L
.52712 .30902 L
.52786 .30902 L
.52856 .30902 L
s
.52856 .30902 m
.52869 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.27193 .30902 L
.27731 .30902 L
.28302 .30902 L
.288 .30902 L
.28936 .30902 L
.29012 .30902 L
.29083 .30902 L
.2915 .30902 L
.29222 .46353 L
.29349 .46353 L
.30316 .46353 L
.3438 .46353 L
.38293 .46353 L
.42451 .46353 L
.44538 .46353 L
.45453 .46353 L
.45938 .46353 L
.46458 .46353 L
.46718 .46353 L
.46846 .46353 L
.46965 .46353 L
.47072 .30902 L
.47186 .30902 L
.47427 .30902 L
.48333 .30902 L
.50313 .30902 L
.54088 .30902 L
.58108 .30902 L
.61977 .30902 L
.66091 .30902 L
.70054 .30902 L
.73864 .30902 L
.7792 .30902 L
.81825 .30902 L
.85975 .30902 L
.89973 .30902 L
.9382 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.75) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00Coool00`1Vooooooooo`05oooo00<0
003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`05oooo00<0I_ooooooool01?oo
o`030000oooooooo00Coool00ol0VOooooooo`05oooo00<0003oooooool03?ooo`030000oooooooo
00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00goool00`000?oo
ooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo01Goool001Koool00`000?ooooooo`0j
oooo00<0003oooooool01?ooo`0306Kooooooooo02_oool00`1Vooooooooo`04oooo00<0003ooooo
ool01?ooo`03o`2Ioooooooo03;oool00`000?ooooooo`0joooo00<0003oooooool05Oooo`00F_oo
o`0306Kooooooooo02_oool00`1Vooooooooo`04oooo00<0003oooooool01?ooo`03o`2Ioooooooo
08Ooool005[oool00`1Vooooooooo`0[oooo00<0I_ooooooool01?ooo`800005oooo00?o09Wooooo
ool0Qoooo`00F_ooo`0306Kooooooooo02_oool00`1Vooooooooo`04oooo00<0003oooooool01?oo
o`03o`2Ioooooooo08Ooool005[oool00`1Vooooooooo`0[oooo00<0I_ooooooool01?ooo`030000
oooooooo00Coool00ol0VOooooooo`27oooo001Joooo00<0I_ooooooool0:oooo`0306Kooooooooo
00Coool00`000?ooooooo`04oooo00?o09Woooooool0Qoooo`00F_ooo`0306Kooooooooo02_oool0
0`1Vooooooooo`04oooo0P0000Goool00ol0VOooooooo`27oooo001Joooo00<0I_ooooooool0:ooo
o`0306Kooooooooo00Coool00`000?ooooooo`04oooo00?o09Woooooool0Qoooo`00F_ooo`0306Ko
oooooooo02_oool00`1Vooooooooo`04oooo00<0003oooooool01?ooo`03o`2Ioooooooo08Ooool0
05[oool00`1Vooooooooo`0[oooo00<0I_ooooooool01?ooo`030000oooooooo00Coool00ol0VOoo
ooooo`27oooo001Joooo00<0I_ooooooool0:oooo`0306Kooooooooo00Coool200001Oooo`03o`2I
oooooooo08Ooool005[oool00`1Vooooooooo`0[oooo00<0I_ooooooool01?ooo`030000oooooooo
00Coool00ol0VOooooooo`27oooo001Joooo00<0I_ooooooool0:oooo`0306Kooooooooo00Coool0
0`000?ooooooo`04oooo00?o09Woooooool0Qoooo`00F_ooo`0306Kooooooooo02_oool00`1Voooo
ooooo`04oooo00<0003oooooool01?ooo`03o`2Ioooooooo08Ooool005[oool00`1Vooooooooo`0[
oooo00<0I_ooooooool01?ooo`800005oooo00?o09Woooooool0Qoooo`00F_ooo`0306Kooooooooo
02_oool00`1Vooooooooo`04oooo00<0003oooooool01?ooo`03o`2Ioooooooo08Ooool005[oool0
0`1Vooooooooo`0Ioooo0P0000Coool200000oooo`@00003oooo0P0000Goool00`000?ooooooo`04
oooo00?o09Woooooool0Qoooo`00F_ooo`0306Kooooooooo01Soool010000?ooooooo`0000Soool0
0`000?ooooooo`03oooo00@00000I_ooool00004oooo00<0003oooooool01?ooo`03o`2Ioooooooo
08Ooool005[oool00`1Vooooooooo`0Hoooo00@0003oooooool00009oooo00<0003oooooool00_oo
o`0406Kooooooooo00001?ooo`<00004oooo00?o09Woooooool0Qoooo`00F_ooo`0306Kooooooooo
01Soool010000?ooooooo`0000[oool01@000?ooooooooooo`1Vo`0200001Oooo`030000oooooooo
00Coool00ol0VOooooooo`27oooo001Joooo00<0I_ooooooool06?ooo`040000oooooooo00002?oo
o`040000oooooooo00000_ooo`0306Ko0000oooo00Goool00`000?ooooooo`04oooo00?o09Wooooo
ool0Qoooo`00F_ooo`0306Kooooooooo01Woool200002_ooo`800003oooo00@0I_l0000000000004
oooo00<0003oooooool01?ooo`03o`2Ioooooooo08Ooool005[oool00`1Vooooooooo`0Zoooo00<0
I_ooooooool01Oooo`800005oooo00?o09Woooooool0Qoooo`00F_ooo`0306Kooooooooo02[oool0
0`1Vooooooooo`05oooo00<0003oooooool01?ooo`03o`2Ioooooooo08Ooool005[oool00`1Voooo
ooooo`0Zoooo00<0I_ooooooool01Oooo`030000oooooooo00Coool00ol0VOooooooo`27oooo001J
oooo00<0I_ooooooool0:_ooo`0306Kooooooooo00Goool00`000?ooooooo`04oooo00?o09Wooooo
ool0Qoooo`00F_ooo`0306Kooooooooo02[oool00`1Vooooooooo`05oooo0P0000Goool00ol0VOoo
ooooo`27oooo001Joooo00<0I_ooooooool0:_ooo`0306Kooooooooo00Goool00`000?ooooooo`04
oooo00?o09Woooooool0Qoooo`00F_ooo`0306Kooooooooo02[oool00`1Vooooooooo`05oooo00<0
003oooooool01?ooo`03o`2Ioooooooo08Ooool005[oool00`1Vooooooooo`0Zoooo00<0I_oooooo
ool01Oooo`030000oooooooo00Coool00ol0VOooooooo`27oooo001Joooo00<0I_ooooooool0:_oo
o`0306Kooooooooo00Goool200001Oooo`03o`2Ioooooooo08Ooool005[oool00`1Vooooooooo`0Z
oooo00<0I_ooooooool01Oooo`030000oooooooo00Coool00ol0VOooooooo`27oooo001Joooo00<0
I_ooooooool0:_ooo`0306Kooooooooo00Goool00`000?ooooooo`04oooo00?o09Woooooool0Qooo
o`00F_ooo`0306Kooooooooo02[oool00`1Vooooooooo`05oooo00<0003oooooool01?ooo`03o`2I
oooooooo08Ooool005[oool00`1Vooooooooo`0Zoooo00<0I_ooooooool01Oooo`800005oooo00?o
09Woooooool0Qoooo`00F_ooo`0306Kooooooooo02[oool00`1Vooooooooo`05oooo00<0003ooooo
ool01?ooo`03o`2Ioooooooo08Ooool005[oool00`1Vooooooooo`0Ooooo0P0000Coool200000ooo
o`0306Ko0000000000Goool00`000?ooooooo`04oooo00?o09Woooooool0Qoooo`00F_ooo`0306Ko
oooooooo01koool010000?ooooooo`0000Soool010000?ooooooo`0000Coool00`000?ooooooo`04
oooo00?o09Woooooool0Qoooo`00F_ooob40I_l01000001Vo`1Vo`0000T0I_l2oooo00<0003ooooo
ool00_ooo`<00004oooo00?o09Woooooool0Qoooo`00Noooo`040000oooooooo00002Oooo`800005
oooo00<0003oooooool01?ooo`03o`2Ioooooooo08Ooool007_oool010000?ooooooo`0000Woool0
0`000?ooooooo`04oooo00<0003oooooool01?ooo`03o`2Ioooooooo08Ooool007coool200002_oo
o`<00004oooo00<0003oooooool01?ooo`03o`2Ioooooooo08Ooool008ooool200001Oooo`03o`2I
oooooooo08Ooool008ooool00`000?ooooooo`04oooo00?o09Woooooool0Qoooo`00Soooo`030000
oooooooo00Coool00ol0VOooooooo`27oooo002?oooo0P0000Goool00ol0VOooooooo`27oooo002?
oooo00<0003oooooool01?ooo`03o`2Ioooooooo08Ooool008ooool00`000?ooooooo`04oooo00?o
09Woooooool0Qoooo`00Soooo`030000oooooooo00Coool00ol0VOooooooo`27oooo002?oooo0P00
00Goool00ol0VOooooooo`27oooo002?oooo00<0003oooooool01?ooo`03o`2Ioooooooo08Ooool0
08ooool00`000?ooooooo`04oooo00?o09Woooooool0Qoooo`00Soooo`030000oooooooo00Coool0
0ol0VOooooooo`27oooo002?oooo0P0000Goool00ol0VOooooooo`27oooo002?oooo00<0003ooooo
ool01?ooo`03o`2Ioooooooo08Ooool007Koool200001?ooo`800005oooo00<0003oooooool00_oo
o`800005oooo00<0003oooooool01?ooo`03o`2Ioooooooo08Ooool007Goool010000?ooooooo`00
00[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo00Coool0
0ol0VOooooooo`27oooo001eoooo00@0003oooooool0000:oooo00<0003oooooool01?ooo`030000
oooooooo00;oool300001?ooo`03o`2Ioooooooo08Ooool007Goool010000?ooooooo`0000_oool0
10000?ooooooooooo`800005oooo00<0003oooooool01?ooo`03o`2Ioooooooo08Ooool007Goool0
10000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003ooooo
ool01?ooo`03o`2Ioooooooo08Ooool007Koool200002Oooo`@00003oooo0`0000Coool00`000?oo
ooooo`04oooo00?o09Woooooool0Qoooo`00Soooo`800005oooo00?o09Woooooool0Qoooo`00Sooo
o`030000oooooooo00Coool00ol0VOooooooo`27oooo002?oooo00<0003oooooool01?ooo`03o`2I
oooooooo08Ooool008ooool00`000?ooooooo`04oooo00?o09Woooooool0Qoooo`00Soooo`800005
oooo00?o09Woooooool0Qoooo`00Soooo`030000oooooooo00Coool00ol0VOooooooo`27oooo002?
oooo00<0003oooooool01?ooo`03o`2Ioooooooo08Ooool008ooool00`000?ooooooo`04oooo00?o
09Woooooool0Qoooo`00Soooo`800005oooo00?o09Woooooool0Qoooo`00Soooo`030000oooooooo
00Coool00ol0VOooooooo`27oooo002?oooo00<0003oooooool01?ooo`03o`2Ioooooooo08Ooool0
08ooool00`000?ooooooo`04oooo00?o09Woooooool0Qoooo`00Soooo`800005oooo00?o09Wooooo
ool0Qoooo`00Soooo`030000oooooooo00Coool00ol0VOooooooo`27oooo0027oooo1@0000?oool0
0`000?ooooooo`04oooo00?o09Woooooool0Qoooo`00ROooo`030000oooooooo00?oool00`000?oo
ooooo`04oooo00?o09Woooooool0Qoooo`00ROooo`030000oooooooo00?oool300001?ooo`03o`2I
oooooooo08Ooool008Woool00`000?ooooooo`2Doooo0029oooo00<0003oooooool0U?ooo`00R?oo
o`80002Foooo003ooooo8Oooo`00ooooob7oool007Koool00`000?ooooooo`0^oooo00<0003ooooo
ool0M_ooo`00MOooo`030000oooooooo00Soool00`000?ooooooo`0Uoooo00<0003oooooool0MOoo
o`00MOooo`030000oooooooo00;oool200001?ooo`030000oooooooo00goool200001?ooo`800005
oooo00<0003oooooool00_ooo`800004oooo00<0003oooooool0MOooo`00MOooo`050000oooooooo
oooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003ooooo
ool0000:oooo00D0003oooooooooool000000_ooo`050000oooooooooooo000007Ooool007Coool0
0`000?ooooooo`02oooo00<0003oooooool04oooo`040000oooooooo00002_ooo`030000oooooooo
00Coool00`000?ooooooo`02oooo00<0003oooooool0M?ooo`00MOooo`030000oooooooo00D0000B
oooo00@0003oooooool0000;oooo00@0003oooooooooool200001?ooo`030000oooooooo07Goool0
07Goool01@000?ooooooooooo`00000Eoooo00@0003oooooool00008oooo00@0003oooooool00003
oooo00<0003oooooool00oooo`030000oooooooo07Goool007Koool00`000?ooooooo`0Goooo0P00
00Woool400000oooo`<00002oooo00<0003oooooool0M_ooo`00ooooob7oool00?oooolQoooo0000
\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.7) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.51896 .30902 L
.52455 .30902 L
.52986 .30902 L
.53217 .30902 L
.53344 .30902 L
.53463 .30902 L
.53531 .30902 L
s
.53531 .30902 m
.53539 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.27193 .30902 L
.28302 .30902 L
.2881 .30902 L
.29088 .30902 L
.29349 .30902 L
.2957 .30902 L
.29695 .30902 L
.29809 .46353 L
.29933 .46353 L
.30069 .46353 L
.30316 .46353 L
.3438 .46353 L
.38293 .46353 L
.40291 .46353 L
.42451 .46353 L
.43466 .46353 L
.44538 .46353 L
.45453 .46353 L
.45704 .46353 L
.45973 .46353 L
.46103 .46353 L
.46227 .46353 L
.46337 .46353 L
.46458 .30902 L
.4658 .30902 L
.46691 .30902 L
.46943 .30902 L
.47398 .30902 L
.48435 .30902 L
.50536 .30902 L
.54499 .30902 L
.58309 .30902 L
.62365 .30902 L
.6627 .30902 L
.7042 .30902 L
.74418 .30902 L
.78265 .30902 L
.82356 .30902 L
.86297 .30902 L
.90085 .30902 L
.94119 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.7) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00Goool00`1Vooooooooo`04oooo00<0
003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`03oooo00<0I_ooooooool01_oo
o`030000oooooooo00Koool00ol0VOooooooo`03oooo00<0003oooooool03?ooo`030000oooooooo
00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00goool00`000?oo
ooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo01Goool001Koool00`000?ooooooo`0j
oooo00<0003oooooool01Oooo`0306Kooooooooo02Soool00`1Vooooooooo`06oooo00<0003ooooo
ool01_ooo`03o`2Ioooooooo033oool00`000?ooooooo`0joooo00<0003oooooool05Oooo`00Fooo
o`0306Kooooooooo02Soool00`1Vooooooooo`06oooo00<0003oooooool01_ooo`03o`2Ioooooooo
08Goool005_oool00`1Vooooooooo`0Xoooo00<0I_ooooooool01_ooo`800007oooo00?o09Wooooo
ool0QOooo`00Foooo`0306Kooooooooo02Soool00`1Vooooooooo`06oooo00<0003oooooool01_oo
o`03o`2Ioooooooo08Goool005_oool00`1Vooooooooo`0Xoooo00<0I_ooooooool01_ooo`030000
oooooooo00Koool00ol0VOooooooo`25oooo001Koooo00<0I_ooooooool0:?ooo`0306Kooooooooo
00Koool00`000?ooooooo`06oooo00?o09Woooooool0QOooo`00Foooo`0306Kooooooooo02Soool0
0`1Vooooooooo`06oooo0P0000Ooool00ol0VOooooooo`25oooo001Koooo00<0I_ooooooool0:?oo
o`0306Kooooooooo00Koool00`000?ooooooo`06oooo00?o09Woooooool0QOooo`00Foooo`0306Ko
oooooooo02Soool00`1Vooooooooo`06oooo00<0003oooooool01_ooo`03o`2Ioooooooo08Goool0
05_oool00`1Vooooooooo`0Xoooo00<0I_ooooooool01_ooo`030000oooooooo00Koool00ol0VOoo
ooooo`25oooo001Koooo00<0I_ooooooool0:?ooo`0306Kooooooooo00Koool200001oooo`03o`2I
oooooooo08Goool005_oool00`1Vooooooooo`0Xoooo00<0I_ooooooool01_ooo`030000oooooooo
00Koool00ol0VOooooooo`25oooo001Koooo00<0I_ooooooool0:?ooo`0306Kooooooooo00Koool0
0`000?ooooooo`06oooo00?o09Woooooool0QOooo`00Foooo`0306Kooooooooo02Soool00`1Voooo
ooooo`06oooo00<0003oooooool01_ooo`03o`2Ioooooooo08Goool005_oool00`1Vooooooooo`0X
oooo00<0I_ooooooool01_ooo`800007oooo00?o09Woooooool0QOooo`00Foooo`0306Kooooooooo
02Soool00`1Vooooooooo`06oooo00<0003oooooool01_ooo`03o`2Ioooooooo08Goool005_oool0
0`1Vooooooooo`0Hoooo0P0000Coool200000oooo`@000000oooo`1Vooooo`0200001Oooo`030000
oooooooo00Koool00ol0VOooooooo`25oooo001Koooo00<0I_ooooooool05oooo`040000oooooooo
00002?ooo`030000oooooooo00;oool01@1Vo`000?ooooooo`000004oooo00<0003oooooool01_oo
o`03o`2Ioooooooo08Goool005_oool00`1Vooooooooo`0Goooo00@0003oooooool00009oooo00D0
003oooooooooool0I_l00oooo`030000oooooooo00;oool300001_ooo`03o`2Ioooooooo08Goool0
05coool00`1Vooooooooo`0Foooo00@0003oooooool0000:oooo00D0003oooooool0I_ooool00P00
00Goool00`000?ooooooo`06oooo00?o09Woooooool0QOooo`00G?ooo`0306Kooooooooo01Koool0
10000?ooooooo`0000Soool020000?ooooooo`000?ooo`1Vooooo`0000Koool00`000?ooooooo`06
oooo00?o09Woooooool0QOooo`00G?ooo`0306Kooooooooo01Ooool200002_ooo`800002oooo00<0
I_ooool000000P0000Coool00`000?ooooooo`06oooo00?o09Woooooool0QOooo`00G?ooo`0306Ko
oooooooo02Ooool00`1Vooooooooo`06oooo0P0000Ooool00ol0VOooooooo`25oooo001Loooo00<0
I_ooooooool09oooo`0306Kooooooooo00Koool00`000?ooooooo`06oooo00?o09Woooooool0QOoo
o`00G?ooo`0306Kooooooooo02Ooool00`1Vooooooooo`06oooo00<0003oooooool01_ooo`03o`2I
oooooooo08Goool005coool00`1Vooooooooo`0Woooo00<0I_ooooooool01_ooo`030000oooooooo
00Koool00ol0VOooooooo`25oooo001Loooo00<0I_ooooooool09oooo`0306Kooooooooo00Koool2
00001oooo`03o`2Ioooooooo08Goool005coool00`1Vooooooooo`0Woooo00<0I_ooooooool01_oo
o`030000oooooooo00Koool00ol0VOooooooo`25oooo001Loooo00<0I_ooooooool09oooo`0306Ko
oooooooo00Koool00`000?ooooooo`06oooo00?o09Woooooool0QOooo`00G?ooo`0306Kooooooooo
02Ooool00`1Vooooooooo`06oooo00<0003oooooool01_ooo`03o`2Ioooooooo08Goool005coool0
0`1Vooooooooo`0Woooo00<0I_ooooooool01_ooo`800007oooo00?o09Woooooool0QOooo`00G?oo
o`0306Kooooooooo02Ooool00`1Vooooooooo`06oooo00<0003oooooool01_ooo`03o`2Ioooooooo
08Goool005coool00`1Vooooooooo`0Woooo00<0I_ooooooool01_ooo`030000oooooooo00Koool0
0ol0VOooooooo`25oooo001Loooo00<0I_ooooooool09oooo`0306Kooooooooo00Koool00`000?oo
ooooo`06oooo00?o09Woooooool0QOooo`00G?ooo`0306Kooooooooo02Ooool00`1Vooooooooo`06
oooo0P0000Ooool00ol0VOooooooo`25oooo001Loooo00<0I_ooooooool09oooo`0306Kooooooooo
00Koool00`000?ooooooo`06oooo00?o09Woooooool0QOooo`00G?ooo`0306Kooooooooo01goool2
00001?ooo`800002oooo00@0I_ooool000000005oooo00<0003oooooool01_ooo`03o`2Ioooooooo
08Goool005coool00`1Vooooooooo`0Loooo00@0003oooooool00007oooo00D0I_l0003oooooool0
00001?ooo`030000oooooooo00Koool00ol0VOooooooo`25oooo001Loooo7`1Vo`04000006Ko06Ko
0000201Vo`?oool00`000?ooooooo`02oooo0`0000Koool00ol0VOooooooo`25oooo001koooo00@0
003oooooool00009oooo0P0000Goool00`000?ooooooo`06oooo00?o09Woooooool0QOooo`00Nooo
o`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`06oooo00?o09Wooooo
ool0QOooo`00O?ooo`80000:oooo0`0000Coool00`000?ooooooo`06oooo00?o09Woooooool0QOoo
o`00Soooo`800007oooo00?o09Woooooool0QOooo`00Soooo`030000oooooooo00Koool00ol0VOoo
ooooo`25oooo002?oooo00<0003oooooool01_ooo`03o`2Ioooooooo08Goool008ooool200001ooo
o`03o`2Ioooooooo08Goool008ooool00`000?ooooooo`06oooo00?o09Woooooool0QOooo`00Sooo
o`030000oooooooo00Koool00ol0VOooooooo`25oooo002?oooo00<0003oooooool01_ooo`03o`2I
oooooooo08Goool008ooool200001oooo`03o`2Ioooooooo08Goool008ooool00`000?ooooooo`06
oooo00?o09Woooooool0QOooo`00Soooo`030000oooooooo00Koool00ol0VOooooooo`25oooo002?
oooo00<0003oooooool01_ooo`03o`2Ioooooooo08Goool008ooool200001oooo`03o`2Ioooooooo
08Goool008ooool00`000?ooooooo`06oooo00?o09Woooooool0QOooo`00M_ooo`800004oooo0P00
00Goool00`000?ooooooo`02oooo0P0000Goool00`000?ooooooo`06oooo00?o09Woooooool0QOoo
o`00MOooo`040000oooooooo00002_ooo`050000oooooooooooo000000;oool00`000?ooooooo`02
oooo00<0003oooooool01_ooo`03o`2Ioooooooo08Goool007Goool010000?ooooooo`0000[oool0
0`000?ooooooo`04oooo00<0003oooooool00_ooo`<00006oooo00?o09Woooooool0QOooo`00MOoo
o`040000oooooooo00002oooo`040000oooooooooooo0P0000Goool00`000?ooooooo`06oooo00?o
09Woooooool0QOooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000
oooooooo00Coool00`000?ooooooo`06oooo00?o09Woooooool0QOooo`00M_ooo`800009oooo1000
00?oool300001?ooo`030000oooooooo00Koool00ol0VOooooooo`25oooo002?oooo0P0000Ooool0
0ol0VOooooooo`25oooo002?oooo00<0003oooooool01_ooo`03o`2Ioooooooo08Goool008ooool0
0`000?ooooooo`06oooo00?o09Woooooool0QOooo`00Soooo`030000oooooooo00Koool00ol0VOoo
ooooo`25oooo002?oooo0P0000Ooool00ol0VOooooooo`25oooo002?oooo00<0003oooooool01_oo
o`03o`2Ioooooooo08Goool008ooool00`000?ooooooo`06oooo00?o09Woooooool0QOooo`00Sooo
o`030000oooooooo00Koool00ol0VOooooooo`25oooo002?oooo0P0000Ooool00ol0VOooooooo`25
oooo002?oooo00<0003oooooool01_ooo`03o`2Ioooooooo08Goool008ooool00`000?ooooooo`06
oooo00?o09Woooooool0QOooo`00Soooo`030000oooooooo00Koool00ol0VOooooooo`25oooo002?
oooo0P0000Ooool00ol0VOooooooo`25oooo002?oooo00<0003oooooool01_ooo`03o`2Ioooooooo
08Goool008Ooool500000oooo`030000oooooooo00Koool00ol0VOooooooo`25oooo0029oooo00<0
003oooooool00oooo`030000oooooooo00Koool00ol0VOooooooo`25oooo0029oooo00<0003ooooo
ool00oooo`<00006oooo00?o09Woooooool0QOooo`00ROooo`030000oooooooo09Coool008Woool0
0`000?ooooooo`2Doooo0028oooo0P0009Koool00?oooolQoooo003ooooo8Oooo`00NOooo`030000
oooooooo02Soool00`000?ooooooo`1ioooo001hoooo00<0003oooooool02?ooo`030000oooooooo
01ooool00`000?ooooooo`1hoooo001hoooo00<0003oooooool00_ooo`800004oooo00<0003ooooo
ool03Oooo`800004oooo0P0000Goool00`000?ooooooo`02oooo00<0003oooooool0N?ooo`00N?oo
o`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01?ooo`@00003
oooo00@0003oooooool0000:oooo00<0003oooooool00_ooo`030000oooooooo07Soool007Ooool0
0`000?ooooooo`02oooo00<0003oooooool04oooo`040000oooooooo00002_ooo`030000oooooooo
00?oool00`000?ooooooo`1goooo001hoooo00<0003oooooool01@0001;oool010000?ooooooo`00
00_oool01@000?ooooooooooo`00001joooo001hoooo00D0003oooooooooool000005Oooo`040000
oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo07Soool007Woool00`000?oo
ooooo`0Goooo0P0000Woool400000_ooo`030000oooooooo07Woool00?oooolQoooo003ooooo8Ooo
o`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.65) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.52059 .30902 L
.53057 .30902 L
.53543 .30902 L
.53755 .30902 L
.53984 .30902 L
.54107 .30902 L
s
.54107 .30902 m
.54119 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.29205 .30902 L
.29779 .30902 L
.30059 .30902 L
.30182 .30902 L
.30246 .30902 L
.30316 .30902 L
.30442 .46353 L
.3056 .46353 L
.30791 .46353 L
.31304 .46353 L
.32392 .46353 L
.34309 .46353 L
.38467 .46353 L
.40553 .46353 L
.42473 .46353 L
.44348 .46353 L
.45292 .46353 L
.45551 .46353 L
.45693 .46353 L
.45763 .46353 L
.45828 .46353 L
.45953 .30902 L
.4602 .30902 L
.4609 .30902 L
.46328 .30902 L
.50104 .30902 L
.54124 .30902 L
.57993 .30902 L
.62107 .30902 L
.66069 .30902 L
.6988 .30902 L
.73936 .30902 L
.7784 .30902 L
.8199 .30902 L
.85988 .30902 L
.89835 .30902 L
.93927 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.65) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00Ooool00`1Vooooooooo`02oooo00<0
003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`02oooo00<0I_ooooooool01ooo
o`030000oooooooo00Ooool00ol0VOooooooo`02oooo00<0003oooooool03?ooo`030000oooooooo
00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00goool00`000?oo
ooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo01Goool001Koool00`000?ooooooo`0j
oooo00<0003oooooool01oooo`0306Kooooooooo02Goool00`1Vooooooooo`07oooo00<0003ooooo
ool01oooo`03o`2Ioooooooo02ooool00`000?ooooooo`0joooo00<0003oooooool05Oooo`00GOoo
o`0306Kooooooooo02Goool00`1Vooooooooo`07oooo00<0003oooooool01oooo`03o`2Ioooooooo
08Coool005goool00`1Vooooooooo`0Uoooo00<0I_ooooooool01oooo`800008oooo00?o09Wooooo
ool0Q?ooo`00GOooo`0306Kooooooooo02Goool00`1Vooooooooo`07oooo00<0003oooooool01ooo
o`03o`2Ioooooooo08Coool005goool00`1Vooooooooo`0Uoooo00<0I_ooooooool01oooo`030000
oooooooo00Ooool00ol0VOooooooo`24oooo001Moooo00<0I_ooooooool09Oooo`0306Kooooooooo
00Ooool00`000?ooooooo`07oooo00?o09Woooooool0Q?ooo`00GOooo`0306Kooooooooo02Goool0
0`1Vooooooooo`07oooo0P0000Soool00ol0VOooooooo`24oooo001Moooo00<0I_ooooooool09Ooo
o`0306Kooooooooo00Ooool00`000?ooooooo`07oooo00?o09Woooooool0Q?ooo`00GOooo`0306Ko
oooooooo02Goool00`1Vooooooooo`07oooo00<0003oooooool01oooo`03o`2Ioooooooo08Coool0
05goool00`1Vooooooooo`0Uoooo00<0I_ooooooool01oooo`030000oooooooo00Ooool00ol0VOoo
ooooo`24oooo001Moooo00<0I_ooooooool09Oooo`0306Kooooooooo00Ooool200002?ooo`03o`2I
oooooooo08Coool005goool00`1Vooooooooo`0Uoooo00<0I_ooooooool01oooo`030000oooooooo
00Ooool00ol0VOooooooo`24oooo001Moooo00<0I_ooooooool09Oooo`0306Kooooooooo00Ooool0
0`000?ooooooo`07oooo00?o09Woooooool0Q?ooo`00GOooo`0306Kooooooooo02Goool00`1Voooo
ooooo`07oooo00<0003oooooool01oooo`03o`2Ioooooooo08Coool005goool00`1Vooooooooo`0U
oooo00<0I_ooooooool01oooo`800008oooo00?o09Woooooool0Q?ooo`00GOooo`0306Kooooooooo
02Goool00`1Vooooooooo`07oooo00<0003oooooool01oooo`03o`2Ioooooooo08Coool005goool0
0`1Vooooooooo`0Foooo0P0000Coool200000oooo`@000000`1Vooooooooo`0200001Oooo`030000
oooooooo00Ooool00ol0VOooooooo`24oooo001Moooo00<0I_ooooooool05Oooo`040000oooooooo
00002?ooo`070000oooooooooooo06Kooooo000000;oool00`000?ooooooo`02oooo00<0003ooooo
ool01oooo`03o`2Ioooooooo08Coool005goool00`1Vooooooooo`0Eoooo00@0003oooooool00009
oooo00<0003oool0I_l01Oooo`030000oooooooo00;oool300001oooo`03o`2Ioooooooo08Coool0
05goool00`1Vooooooooo`0Eoooo00@0003oooooool0000:oooo00<00000I_ooool00_ooo`800005
oooo00<0003oooooool01oooo`03o`2Ioooooooo08Coool005goool00`1Vooooooooo`0Eoooo00@0
003oooooool00008oooo00@0003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo
00Ooool00ol0VOooooooo`24oooo001Moooo00<0I_ooooooool05_ooo`80000:oooo0P00000406Ko
oooooooooooo0`0000Coool00`000?ooooooo`07oooo00?o09Woooooool0Q?ooo`00GOooo`0306Ko
oooooooo02Coool00`1Vooooooooo`08oooo0P0000Soool00ol0VOooooooo`24oooo001Moooo00<0
I_ooooooool09?ooo`0306Kooooooooo00Soool00`000?ooooooo`07oooo00?o09Woooooool0Q?oo
o`00GOooo`0306Kooooooooo02Coool00`1Vooooooooo`08oooo00<0003oooooool01oooo`03o`2I
oooooooo08Coool005goool00`1Vooooooooo`0Toooo00<0I_ooooooool02?ooo`030000oooooooo
00Ooool00ol0VOooooooo`24oooo001Moooo00<0I_ooooooool09?ooo`0306Kooooooooo00Soool2
00002?ooo`03o`2Ioooooooo08Coool005goool00`1Vooooooooo`0Toooo00<0I_ooooooool02?oo
o`030000oooooooo00Ooool00ol0VOooooooo`24oooo001Moooo00<0I_ooooooool09?ooo`0306Ko
oooooooo00Soool00`000?ooooooo`07oooo00?o09Woooooool0Q?ooo`00GOooo`0306Kooooooooo
02Coool00`1Vooooooooo`08oooo00<0003oooooool01oooo`03o`2Ioooooooo08Coool005goool0
0`1Vooooooooo`0Toooo00<0I_ooooooool02?ooo`800008oooo00?o09Woooooool0Q?ooo`00GOoo
o`0306Kooooooooo02Coool00`1Vooooooooo`08oooo00<0003oooooool01oooo`03o`2Ioooooooo
08Coool005goool00`1Vooooooooo`0Toooo00<0I_ooooooool02?ooo`030000oooooooo00Ooool0
0ol0VOooooooo`24oooo001Moooo00<0I_ooooooool09?ooo`0306Kooooooooo00Soool00`000?oo
ooooo`07oooo00?o09Woooooool0Q?ooo`00GOooo`0306Kooooooooo02Coool00`1Vooooooooo`08
oooo0P0000Soool00ol0VOooooooo`24oooo001Moooo00<0I_ooooooool09?ooo`0306Kooooooooo
00Soool00`000?ooooooo`07oooo00?o09Woooooool0Q?ooo`00GOooo`0306Kooooooooo01coool2
00001?ooo`800000101Vooooooooooooo`800005oooo00<0003oooooool01oooo`03o`2Ioooooooo
08Coool005goool00`1Vooooooooo`0Koooo00@0003oooooool00005oooo00@0I_ooooooool00002
oooo00<0003oooooool00_ooo`030000oooooooo00Ooool00ol0VOooooooo`24oooo001Moooo7P1V
o`04000006Ko06Ko00001P1Vo`Goool00`000?ooooooo`02oooo0`0000Ooool00ol0VOooooooo`24
oooo001koooo00@0003oooooool00009oooo0P0000Goool00`000?ooooooo`07oooo00?o09Wooooo
ool0Q?ooo`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`07
oooo00?o09Woooooool0Q?ooo`00O?ooo`80000:oooo0`0000Coool00`000?ooooooo`07oooo00?o
09Woooooool0Q?ooo`00Soooo`800008oooo00?o09Woooooool0Q?ooo`00Soooo`030000oooooooo
00Ooool00ol0VOooooooo`24oooo002?oooo00<0003oooooool01oooo`03o`2Ioooooooo08Coool0
08ooool200002?ooo`03o`2Ioooooooo08Coool008ooool00`000?ooooooo`07oooo00?o09Wooooo
ool0Q?ooo`00Soooo`030000oooooooo00Ooool00ol0VOooooooo`24oooo002?oooo00<0003ooooo
ool01oooo`03o`2Ioooooooo08Coool008ooool200002?ooo`03o`2Ioooooooo08Coool008ooool0
0`000?ooooooo`07oooo00?o09Woooooool0Q?ooo`00Soooo`030000oooooooo00Ooool00ol0VOoo
ooooo`24oooo002?oooo00<0003oooooool01oooo`03o`2Ioooooooo08Coool008ooool200002?oo
o`03o`2Ioooooooo08Coool008ooool00`000?ooooooo`07oooo00?o09Woooooool0Q?ooo`00M_oo
o`800004oooo0P0000Goool00`000?ooooooo`02oooo0P0000Goool00`000?ooooooo`07oooo00?o
09Woooooool0Q?ooo`00MOooo`040000oooooooo00002_ooo`050000oooooooooooo000000;oool0
0`000?ooooooo`02oooo00<0003oooooool01oooo`03o`2Ioooooooo08Coool007Goool010000?oo
ooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_ooo`<00007oooo00?o09Wooooo
ool0Q?ooo`00MOooo`040000oooooooo00002oooo`040000oooooooooooo0P0000Goool00`000?oo
ooooo`07oooo00?o09Woooooool0Q?ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo
00000oooo`030000oooooooo00Coool00`000?ooooooo`07oooo00?o09Woooooool0Q?ooo`00M_oo
o`800009oooo100000?oool300001?ooo`030000oooooooo00Ooool00ol0VOooooooo`24oooo002?
oooo0P0000Soool00ol0VOooooooo`24oooo002?oooo00<0003oooooool01oooo`03o`2Ioooooooo
08Coool008ooool00`000?ooooooo`07oooo00?o09Woooooool0Q?ooo`00Soooo`030000oooooooo
00Ooool00ol0VOooooooo`24oooo002?oooo0P0000Soool00ol0VOooooooo`24oooo002?oooo00<0
003oooooool01oooo`03o`2Ioooooooo08Coool008ooool00`000?ooooooo`07oooo00?o09Wooooo
ool0Q?ooo`00Soooo`030000oooooooo00Ooool00ol0VOooooooo`24oooo002?oooo0P0000Soool0
0ol0VOooooooo`24oooo002?oooo00<0003oooooool01oooo`03o`2Ioooooooo08Coool008ooool0
0`000?ooooooo`07oooo00?o09Woooooool0Q?ooo`00Soooo`030000oooooooo00Ooool00ol0VOoo
ooooo`24oooo002?oooo0P0000Soool00ol0VOooooooo`24oooo002?oooo00<0003oooooool01ooo
o`03o`2Ioooooooo08Coool008Ooool500000oooo`030000oooooooo00Ooool00ol0VOooooooo`24
oooo0029oooo00<0003oooooool00oooo`030000oooooooo00Ooool00ol0VOooooooo`24oooo0029
oooo00<0003oooooool00oooo`<00007oooo00?o09Woooooool0Q?ooo`00ROooo`030000oooooooo
09Coool008Woool00`000?ooooooo`2Doooo0028oooo0P0009Koool00?oooolQoooo003ooooo8Ooo
o`00M_ooo`030000oooooooo02koool00`000?ooooooo`1foooo001eoooo00<0003oooooool02?oo
o`030000oooooooo02Goool00`000?ooooooo`1eoooo001eoooo00<0003oooooool00_ooo`800004
oooo00<0003oooooool03Oooo`800004oooo0P0000?oool300001?ooo`800004oooo00<0003ooooo
ool0MOooo`00MOooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003ooooo
ool01?ooo`@00003oooo00@0003oooooool00008oooo00@0003oooooool00002oooo00@0003ooooo
ool00003oooo00<0003oooooool0MOooo`00M?ooo`030000oooooooo00;oool00`000?ooooooo`0C
oooo00@0003oooooool00008oooo00@0003oooooool00005oooo00<0003oooooool00_ooo`030000
oooooooo07Coool007Goool00`000?ooooooo`0500004_ooo`040000oooooooo00002?ooo`<00004
oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000005Oooo`040000
oooooooo00002Oooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool0MOoo
o`00M_ooo`030000oooooooo01Ooool200002_ooo`<00003oooo0`0000;oool00`000?ooooooo`1f
oooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.52059 .30902 L
.53057 .30902 L
.53984 .30902 L
.54444 .30902 L
.54576 .30902 L
.54701 .30902 L
s
.54701 .30902 m
.54712 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.29205 .30902 L
.29779 .30902 L
.30316 .30902 L
.3056 .30902 L
.30791 .30902 L
.30919 .30902 L
.30992 .46353 L
.31059 .46353 L
.31304 .46353 L
.32392 .46353 L
.34309 .46353 L
.38221 .46353 L
.40219 .46353 L
.4238 .46353 L
.43394 .46353 L
.43949 .46353 L
.44466 .46353 L
.44908 .46353 L
.45035 .46353 L
.45156 .46353 L
.45264 .30902 L
.45382 .30902 L
.46386 .30902 L
.50465 .30902 L
.54391 .30902 L
.58166 .30902 L
.62187 .30902 L
.66055 .30902 L
.70169 .30902 L
.74132 .30902 L
.77943 .30902 L
.81999 .30902 L
.85903 .30902 L
.90053 .30902 L
.94051 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00Woool0101Vooooooooo`0000koool0
0`000?ooooooo`0<oooo00@0003oooooool0I_l;oooo00<0003oooooool02Oooo`04o`2Ioooooooo
00003_ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000
oooooooo00goool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo01Goool0
01Koool00`000?ooooooo`0joooo00<0003oooooool02Oooo`0306Kooooooooo027oool00`1Voooo
ooooo`09oooo00<0003oooooool02Oooo`03o`2Ioooooooo02goool00`000?ooooooo`0joooo00<0
003oooooool05Oooo`00Goooo`0306Kooooooooo027oool00`1Vooooooooo`09oooo00<0003ooooo
ool02Oooo`03o`2Ioooooooo08;oool005ooool00`1Vooooooooo`0Qoooo00<0I_ooooooool02Ooo
o`80000:oooo00?o09Woooooool0P_ooo`00Goooo`0306Kooooooooo027oool00`1Vooooooooo`09
oooo00<0003oooooool02Oooo`03o`2Ioooooooo08;oool005ooool00`1Vooooooooo`0Qoooo00<0
I_ooooooool02Oooo`030000oooooooo00Woool00ol0VOooooooo`22oooo001Ooooo00<0I_oooooo
ool08Oooo`0306Kooooooooo00Woool00`000?ooooooo`09oooo00?o09Woooooool0P_ooo`00Gooo
o`0306Kooooooooo027oool00`1Vooooooooo`09oooo0P0000[oool00ol0VOooooooo`22oooo001O
oooo00<0I_ooooooool08Oooo`0306Kooooooooo00Woool00`000?ooooooo`09oooo00?o09Wooooo
ool0P_ooo`00Goooo`0306Kooooooooo027oool00`1Vooooooooo`09oooo00<0003oooooool02Ooo
o`03o`2Ioooooooo08;oool005ooool00`1Vooooooooo`0Qoooo00<0I_ooooooool02Oooo`030000
oooooooo00Woool00ol0VOooooooo`22oooo001Ooooo00<0I_ooooooool08Oooo`0306Kooooooooo
00Woool200002_ooo`03o`2Ioooooooo08;oool005ooool00`1Vooooooooo`0Qoooo00<0I_oooooo
ool02Oooo`030000oooooooo00Woool00ol0VOooooooo`22oooo001Ooooo00<0I_ooooooool08Ooo
o`0306Kooooooooo00Woool00`000?ooooooo`09oooo00?o09Woooooool0P_ooo`00Goooo`0306Ko
oooooooo027oool00`1Vooooooooo`09oooo00<0003oooooool02Oooo`03o`2Ioooooooo08;oool0
05ooool00`1Vooooooooo`0Qoooo00<0I_ooooooool02Oooo`80000:oooo00?o09Woooooool0P_oo
o`00Goooo`0306Kooooooooo027oool00`1Vooooooooo`09oooo00<0003oooooool02Oooo`03o`2I
oooooooo08;oool005ooool00`1Vooooooooo`0Doooo0P0000Coool200000oooo`@00003oooo0P00
00Goool00`000?ooooooo`09oooo00?o09Woooooool0P_ooo`00Goooo`0306Kooooooooo01?oool0
10000?ooooooo`0000Soool00`000?ooo`1Vo`03oooo00@0003oooooool00004oooo00<0003ooooo
ool02Oooo`03o`2Ioooooooo08;oool005ooool00`1Vooooooooo`0Coooo00@0003oooooool00009
oooo00<00000I_ooool01Oooo`030000oooooooo00;oool300002Oooo`03o`2Ioooooooo08;oool0
05ooool00`1Vooooooooo`0Coooo00@0003oooooool0000:oooo00<0003oooooool00_ooo`800005
oooo00<0003oooooool02Oooo`03o`2Ioooooooo08;oool005ooool00`1Vooooooooo`0Coooo00@0
003oooooool00008oooo00@0003oool0I_l00003oooo00<0003oooooool01?ooo`030000oooooooo
00Woool00ol0VOooooooo`22oooo001Ooooo00<0I_ooooooool05?ooo`80000:oooo0P0000Coool3
00001?ooo`030000oooooooo00Woool00ol0VOooooooo`22oooo001Ooooo00<0I_ooooooool08Ooo
o`0306Kooooooooo00Woool200002_ooo`03o`2Ioooooooo08;oool005ooool00`1Vooooooooo`0Q
oooo00<0I_ooooooool02Oooo`030000oooooooo00Woool00ol0VOooooooo`22oooo001Ooooo00<0
I_ooooooool08Oooo`0306Kooooooooo00Woool00`000?ooooooo`09oooo00?o09Woooooool0P_oo
o`00Goooo`0306Kooooooooo027oool00`1Vooooooooo`09oooo00<0003oooooool02Oooo`03o`2I
oooooooo08;oool005ooool00`1Vooooooooo`0Qoooo00<0I_ooooooool02Oooo`80000:oooo00?o
09Woooooool0P_ooo`00Goooo`0306Kooooooooo027oool00`1Vooooooooo`09oooo00<0003ooooo
ool02Oooo`03o`2Ioooooooo08;oool005ooool00`1Vooooooooo`0Qoooo00<0I_ooooooool02Ooo
o`030000oooooooo00Woool00ol0VOooooooo`22oooo001Ooooo00<0I_ooooooool08Oooo`0306Ko
oooooooo00Woool00`000?ooooooo`09oooo00?o09Woooooool0P_ooo`00Goooo`0306Kooooooooo
027oool00`1Vooooooooo`09oooo0P0000[oool00ol0VOooooooo`22oooo001Ooooo00<0I_oooooo
ool08Oooo`0306Kooooooooo00Woool00`000?ooooooo`09oooo00?o09Woooooool0P_ooo`00Gooo
o`0306Kooooooooo027oool00`1Vooooooooo`09oooo00<0003oooooool02Oooo`03o`2Ioooooooo
08;oool005ooool00`1Vooooooooo`0Qoooo00<0I_ooooooool02Oooo`030000oooooooo00Woool0
0ol0VOooooooo`22oooo001Ooooo00<0I_ooooooool08Oooo`0306Kooooooooo00Woool200002_oo
o`03o`2Ioooooooo08;oool005ooool00`1Vooooooooo`0Qoooo00<0I_ooooooool02Oooo`030000
oooooooo00Woool00ol0VOooooooo`22oooo001Ooooo00<0I_ooooooool06_ooo`800004oooo0P00
00Coool200001Oooo`030000oooooooo00Woool00ol0VOooooooo`22oooo001Ooooo00<0I_oooooo
ool06Oooo`040000oooooooo00001?ooo`0506Kooooooooooooo000000;oool00`000?ooooooo`02
oooo00<0003oooooool02Oooo`03o`2Ioooooooo08;oool005oooolL06Ko00@00000I_l0I_l00005
06Ko1_ooo`030000oooooooo00;oool300002Oooo`03o`2Ioooooooo08;oool007_oool010000?oo
ooooo`0000Woool200001Oooo`030000oooooooo00Woool00ol0VOooooooo`22oooo001koooo00@0
003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo00Woool00ol0VOooooooo`22
oooo001loooo0P0000[oool300001?ooo`030000oooooooo00Woool00ol0VOooooooo`22oooo002?
oooo0P0000[oool00ol0VOooooooo`22oooo002?oooo00<0003oooooool02Oooo`03o`2Ioooooooo
08;oool008ooool00`000?ooooooo`09oooo00?o09Woooooool0P_ooo`00Soooo`80000:oooo00?o
09Woooooool0P_ooo`00Soooo`030000oooooooo00Woool00ol0VOooooooo`22oooo002?oooo00<0
003oooooool02Oooo`03o`2Ioooooooo08;oool008ooool00`000?ooooooo`09oooo00?o09Wooooo
ool0P_ooo`00Soooo`80000:oooo00?o09Woooooool0P_ooo`00Soooo`030000oooooooo00Woool0
0ol0VOooooooo`22oooo002?oooo00<0003oooooool02Oooo`03o`2Ioooooooo08;oool008ooool0
0`000?ooooooo`09oooo00?o09Woooooool0P_ooo`00Soooo`80000:oooo00?o09Woooooool0P_oo
o`00Soooo`030000oooooooo00Woool00ol0VOooooooo`22oooo001foooo0P0000Coool200001Ooo
o`030000oooooooo00;oool200001Oooo`030000oooooooo00Woool00ol0VOooooooo`22oooo001e
oooo00@0003oooooool0000:oooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool0
0`000?ooooooo`09oooo00?o09Woooooool0P_ooo`00MOooo`040000oooooooo00002_ooo`030000
oooooooo00Coool00`000?ooooooo`02oooo0`0000Woool00ol0VOooooooo`22oooo001eoooo00@0
003oooooool0000;oooo00@0003oooooooooool200001Oooo`030000oooooooo00Woool00ol0VOoo
ooooo`22oooo001eoooo00@0003oooooool00008oooo00@0003oooooool00003oooo00<0003ooooo
ool01?ooo`030000oooooooo00Woool00ol0VOooooooo`22oooo001foooo0P0000Woool400000ooo
o`<00004oooo00<0003oooooool02Oooo`03o`2Ioooooooo08;oool008ooool200002_ooo`03o`2I
oooooooo08;oool008ooool00`000?ooooooo`09oooo00?o09Woooooool0P_ooo`00Soooo`030000
oooooooo00Woool00ol0VOooooooo`22oooo002?oooo00<0003oooooool02Oooo`03o`2Ioooooooo
08;oool008ooool200002_ooo`03o`2Ioooooooo08;oool008ooool00`000?ooooooo`09oooo00?o
09Woooooool0P_ooo`00Soooo`030000oooooooo00Woool00ol0VOooooooo`22oooo002?oooo00<0
003oooooool02Oooo`03o`2Ioooooooo08;oool008ooool200002_ooo`03o`2Ioooooooo08;oool0
08ooool00`000?ooooooo`09oooo00?o09Woooooool0P_ooo`00Soooo`030000oooooooo00Woool0
0ol0VOooooooo`22oooo002?oooo00<0003oooooool02Oooo`03o`2Ioooooooo08;oool008ooool2
00002_ooo`03o`2Ioooooooo08;oool008ooool00`000?ooooooo`09oooo00?o09Woooooool0P_oo
o`00Qoooo`D00003oooo00<0003oooooool02Oooo`03o`2Ioooooooo08;oool008Woool00`000?oo
ooooo`03oooo00<0003oooooool02Oooo`03o`2Ioooooooo08;oool008Woool00`000?ooooooo`03
oooo0`0000Woool00ol0VOooooooo`22oooo0029oooo00<0003oooooool0U?ooo`00ROooo`030000
oooooooo09Coool008Soool20000U_ooo`00ooooob7oool00?oooolQoooo001ioooo00<0003ooooo
ool0:?ooo`030000oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07ooo
o`030000oooooooo07Soool007Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=
oooo0P0000Coool200000oooo`<00004oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooo
oooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003ooooo
ool00008oooo00@0003oooooool00003oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo
00;oool00`000?ooooooo`0Coooo00@0003oooooool00008oooo00@0003oooooool00004oooo00<0
003oooooool0Moooo`00N?ooo`030000oooooooo00D0000Boooo00@0003oooooool00008oooo0`00
00Coool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000005Oooo`040000oooooooo
00002Oooo`030000oooooooo00?oool00`000?ooooooo`1hoooo001ioooo00<0003oooooool05ooo
o`80000:oooo0`0000;oool00`000?ooooooo`1ioooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.55) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.52059 .30902 L
.53984 .30902 L
.54444 .30902 L
.54934 .30902 L
.5508 .30902 L
.55216 .30902 L
.55339 .30902 L
s
.55339 .30902 m
.55346 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.29205 .30902 L
.30316 .30902 L
.30791 .30902 L
.31054 .30902 L
.31304 .30902 L
.31444 .30902 L
.31523 .30902 L
.31597 .46353 L
.31727 .46353 L
.31865 .46353 L
.32392 .46353 L
.34309 .46353 L
.38467 .46353 L
.40553 .46353 L
.42473 .46353 L
.43443 .46353 L
.43916 .46353 L
.44348 .46353 L
.4446 .46353 L
.44582 .46353 L
.44697 .30902 L
.44804 .30902 L
.45292 .30902 L
.46328 .30902 L
.50255 .30902 L
.5403 .30902 L
.5805 .30902 L
.61919 .30902 L
.66033 .30902 L
.69996 .30902 L
.73806 .30902 L
.77863 .30902 L
.81767 .30902 L
.85917 .30902 L
.89915 .30902 L
.93762 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.55) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00[oool00`1Vooooo`00000>oooo00<0
003oooooool03?ooo`030000oooo06Ko00coool00`000?ooooooo`0;oooo00?o09T0003oool03Ooo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo
00goool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo01Goool001Koool0
0`000?ooooooo`0joooo00<0003oooooool02_ooo`0306Kooooooooo01ooool00`1Vooooooooo`0:
oooo00<0003oooooool02oooo`03o`2Ioooooooo02_oool00`000?ooooooo`0joooo00<0003ooooo
ool05Oooo`00H?ooo`0306Kooooooooo01ooool00`1Vooooooooo`0:oooo00<0003oooooool02ooo
o`03o`2Ioooooooo083oool0063oool00`1Vooooooooo`0Ooooo00<0I_ooooooool02_ooo`80000<
oooo00?o09Woooooool0P?ooo`00H?ooo`0306Kooooooooo01ooool00`1Vooooooooo`0:oooo00<0
003oooooool02oooo`03o`2Ioooooooo083oool0063oool00`1Vooooooooo`0Ooooo00<0I_oooooo
ool02_ooo`030000oooooooo00_oool00ol0VOooooooo`20oooo001Poooo00<0I_ooooooool07ooo
o`0306Kooooooooo00[oool00`000?ooooooo`0;oooo00?o09Woooooool0P?ooo`00H?ooo`0306Ko
oooooooo01ooool00`1Vooooooooo`0:oooo0P0000coool00ol0VOooooooo`20oooo001Poooo00<0
I_ooooooool07oooo`0306Kooooooooo00[oool00`000?ooooooo`0;oooo00?o09Woooooool0P?oo
o`00H?ooo`0306Kooooooooo01ooool00`1Vooooooooo`0:oooo00<0003oooooool02oooo`03o`2I
oooooooo083oool0063oool00`1Vooooooooo`0Ooooo00<0I_ooooooool02_ooo`030000oooooooo
00_oool00ol0VOooooooo`20oooo001Poooo00<0I_ooooooool07oooo`0306Kooooooooo00[oool2
00003?ooo`03o`2Ioooooooo083oool0063oool00`1Vooooooooo`0Ooooo00<0I_ooooooool02_oo
o`030000oooooooo00_oool00ol0VOooooooo`20oooo001Poooo00<0I_ooooooool07oooo`0306Ko
oooooooo00[oool00`000?ooooooo`0;oooo00?o09Woooooool0P?ooo`00H?ooo`0306Kooooooooo
01ooool00`1Vooooooooo`0:oooo00<0003oooooool02oooo`03o`2Ioooooooo083oool0063oool0
0`1Vooooooooo`0Ooooo00<0I_ooooooool02_ooo`80000<oooo00?o09Woooooool0P?ooo`00H?oo
o`0306Kooooooooo01ooool00`1Vooooooooo`0:oooo00<0003oooooool02oooo`03o`2Ioooooooo
083oool0063oool00`1Vooooooooo`0Coooo0P0000Coool200000oooo`@00003oooo0P0000Goool0
0`000?ooooooo`0;oooo00?o09Woooooool0P?ooo`00H?ooo`0306Kooooooooo01;oool010000?oo
ooooo`0000Soool00`00001Vooooo`03oooo00@0003oooooool00004oooo00<0003oooooool02ooo
o`03o`2Ioooooooo083oool0063oool00`1Vooooooooo`0Boooo00@0003oooooool00008oooo00<0
I_l0003oool01_ooo`030000oooooooo00;oool300002oooo`03o`2Ioooooooo083oool0063oool0
0`1Vooooooooo`0Boooo00@0003oooooool00008oooo00<0I_ooool000001?ooo`800005oooo00<0
003oooooool02oooo`03o`2Ioooooooo083oool0063oool00`1Vooooooooo`0Boooo00@0003ooooo
ool00008oooo00@0003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo00_oool0
0ol0VOooooooo`20oooo001Poooo00<0I_ooooooool04oooo`800009oooo00<0I_l0000000001?oo
o`<00004oooo00<0003oooooool02oooo`03o`2Ioooooooo083oool0063oool00`1Vooooooooo`0N
oooo00<0I_ooooooool02oooo`80000<oooo00?o09Woooooool0P?ooo`00H?ooo`0306Kooooooooo
01koool00`1Vooooooooo`0;oooo00<0003oooooool02oooo`03o`2Ioooooooo083oool0063oool0
0`1Vooooooooo`0Noooo00<0I_ooooooool02oooo`030000oooooooo00_oool00ol0VOooooooo`20
oooo001Poooo00<0I_ooooooool07_ooo`0306Kooooooooo00_oool00`000?ooooooo`0;oooo00?o
09Woooooool0P?ooo`00H?ooo`0306Kooooooooo01koool00`1Vooooooooo`0;oooo0P0000coool0
0ol0VOooooooo`20oooo001Poooo00<0I_ooooooool07_ooo`0306Kooooooooo00_oool00`000?oo
ooooo`0;oooo00?o09Woooooool0P?ooo`00H?ooo`0306Kooooooooo01koool00`1Vooooooooo`0;
oooo00<0003oooooool02oooo`03o`2Ioooooooo083oool0063oool00`1Vooooooooo`0Noooo00<0
I_ooooooool02oooo`030000oooooooo00_oool00ol0VOooooooo`20oooo001Poooo00<0I_oooooo
ool07_ooo`0306Kooooooooo00_oool200003?ooo`03o`2Ioooooooo083oool0063oool00`1Voooo
ooooo`0Noooo00<0I_ooooooool02oooo`030000oooooooo00_oool00ol0VOooooooo`20oooo001P
oooo00<0I_ooooooool07_ooo`0306Kooooooooo00_oool00`000?ooooooo`0;oooo00?o09Wooooo
ool0P?ooo`00H?ooo`0306Kooooooooo01koool00`1Vooooooooo`0;oooo00<0003oooooool02ooo
o`03o`2Ioooooooo083oool0063oool00`1Vooooooooo`0Noooo00<0I_ooooooool02oooo`80000<
oooo00?o09Woooooool0P?ooo`00H?ooo`0306Kooooooooo01koool00`1Vooooooooo`0;oooo00<0
003oooooool02oooo`03o`2Ioooooooo083oool0063oool00`1Vooooooooo`0Ioooo0P0000?oool0
0`1Vo`0000000004oooo0P0000Goool00`000?ooooooo`0;oooo00?o09Woooooool0P?ooo`00H?oo
o`0306Kooooooooo01Soool010000?ooooooo`0000;oool00`1Vooooooooo`03oooo00@0003ooooo
ool00004oooo00<0003oooooool02oooo`03o`2Ioooooooo083oool0063ooolK06Ko00@00000I_l0
I_l0000306Ko2?ooo`030000oooooooo00;oool300002oooo`03o`2Ioooooooo083oool007_oool0
10000?ooooooo`0000Woool200001Oooo`030000oooooooo00_oool00ol0VOooooooo`20oooo001k
oooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo00_oool00ol0VOoo
ooooo`20oooo001loooo0P0000[oool300001?ooo`030000oooooooo00_oool00ol0VOooooooo`20
oooo002?oooo0P0000coool00ol0VOooooooo`20oooo002?oooo00<0003oooooool02oooo`03o`2I
oooooooo083oool008ooool00`000?ooooooo`0;oooo00?o09Woooooool0P?ooo`00Soooo`80000<
oooo00?o09Woooooool0P?ooo`00Soooo`030000oooooooo00_oool00ol0VOooooooo`20oooo002?
oooo00<0003oooooool02oooo`03o`2Ioooooooo083oool008ooool00`000?ooooooo`0;oooo00?o
09Woooooool0P?ooo`00Soooo`80000<oooo00?o09Woooooool0P?ooo`00Soooo`030000oooooooo
00_oool00ol0VOooooooo`20oooo002?oooo00<0003oooooool02oooo`03o`2Ioooooooo083oool0
08ooool00`000?ooooooo`0;oooo00?o09Woooooool0P?ooo`00Soooo`80000<oooo00?o09Wooooo
ool0P?ooo`00Soooo`030000oooooooo00_oool00ol0VOooooooo`20oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo00_oool00ol0VOooooooo`20
oooo001eoooo00@0003oooooool0000:oooo00D0003oooooooooool000000_ooo`030000oooooooo
00;oool00`000?ooooooo`0;oooo00?o09Woooooool0P?ooo`00MOooo`040000oooooooo00002_oo
o`030000oooooooo00Coool00`000?ooooooo`02oooo0`0000_oool00ol0VOooooooo`20oooo001e
oooo00@0003oooooool0000;oooo00@0003oooooooooool200001Oooo`030000oooooooo00_oool0
0ol0VOooooooo`20oooo001eoooo00@0003oooooool00008oooo00@0003oooooool00003oooo00<0
003oooooool01?ooo`030000oooooooo00_oool00ol0VOooooooo`20oooo001foooo0P0000Woool4
00000oooo`<00004oooo00<0003oooooool02oooo`03o`2Ioooooooo083oool008ooool200003?oo
o`03o`2Ioooooooo083oool008ooool00`000?ooooooo`0;oooo00?o09Woooooool0P?ooo`00Sooo
o`030000oooooooo00_oool00ol0VOooooooo`20oooo002?oooo00<0003oooooool02oooo`03o`2I
oooooooo083oool008ooool200003?ooo`03o`2Ioooooooo083oool008ooool00`000?ooooooo`0;
oooo00?o09Woooooool0P?ooo`00Soooo`030000oooooooo00_oool00ol0VOooooooo`20oooo002?
oooo00<0003oooooool02oooo`03o`2Ioooooooo083oool008ooool200003?ooo`03o`2Ioooooooo
083oool008ooool00`000?ooooooo`0;oooo00?o09Woooooool0P?ooo`00Soooo`030000oooooooo
00_oool00ol0VOooooooo`20oooo002?oooo00<0003oooooool02oooo`03o`2Ioooooooo083oool0
08ooool200003?ooo`03o`2Ioooooooo083oool008ooool00`000?ooooooo`0;oooo00?o09Wooooo
ool0P?ooo`00Qoooo`D00003oooo00<0003oooooool02oooo`03o`2Ioooooooo083oool008Woool0
0`000?ooooooo`03oooo00<0003oooooool02oooo`03o`2Ioooooooo083oool008Woool00`000?oo
ooooo`03oooo0`0000_oool00ol0VOooooooo`20oooo0029oooo00<0003oooooool0U?ooo`00ROoo
o`030000oooooooo09Coool008Soool20000U_ooo`00ooooob7oool00?oooolQoooo001foooo00<0
003oooooool0;_ooo`030000oooooooo07Koool007Goool00`000?ooooooo`08oooo00<0003ooooo
ool09Oooo`030000oooooooo07Goool007Goool00`000?ooooooo`02oooo0P0000Coool00`000?oo
ooooo`0=oooo0P0000Coool200001?ooo`800004oooo0P0000Coool00`000?ooooooo`1eoooo001e
oooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`04oooo1000
00?oool010000?ooooooo`0000Soool010000?ooooooo`0000;oool010000?ooooooo`0000?oool0
0`000?ooooooo`1eoooo001doooo00<0003oooooool00_ooo`030000oooooooo01?oool010000?oo
ooooo`0000_oool00`000?ooooooo`03oooo00<0003oooooool00_ooo`030000oooooooo07Coool0
07Goool00`000?ooooooo`0500004_ooo`040000oooooooo00002Oooo`800004oooo0P0000Coool0
0`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000005Oooo`040000oooooooo00002Ooo
o`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool0MOooo`00M_ooo`030000
oooooooo01Ooool200002_ooo`<00003oooo0`0000;oool00`000?ooooooo`1foooo003ooooo8Ooo
o`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.52059 .30902 L
.53984 .30902 L
.54934 .30902 L
.55195 .30902 L
.55472 .30902 L
.55607 .30902 L
.55734 .30902 L
.55848 .30902 L
s
.55848 .30902 m
.55861 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.29205 .30902 L
.30316 .30902 L
.31304 .30902 L
.31574 .30902 L
.31865 .30902 L
.32006 .30902 L
.32076 .30902 L
.3214 .30902 L
.3226 .46353 L
.32392 .46353 L
.34309 .46353 L
.38221 .46353 L
.40219 .46353 L
.4127 .46353 L
.4238 .46353 L
.43374 .46353 L
.43647 .46353 L
.43797 .46353 L
.43871 .46353 L
.43939 .46353 L
.44071 .30902 L
.44141 .30902 L
.44215 .30902 L
.44466 .30902 L
.46386 .30902 L
.50161 .30902 L
.54182 .30902 L
.5805 .30902 L
.62164 .30902 L
.66127 .30902 L
.69938 .30902 L
.73994 .30902 L
.77898 .30902 L
.82048 .30902 L
.86046 .30902 L
.89893 .30902 L
.93985 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0
003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo
00goool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo01Goool001Koool0
0`000?ooooooo`0joooo00<0003oooooool03?ooo`0306Kooooooooo01_oool00`1Vooooooooo`0<
oooo00<0003oooooool03?ooo`03o`2Ioooooooo02[oool00`000?ooooooo`0joooo00<0003ooooo
ool05Oooo`00H_ooo`0306Kooooooooo01_oool00`1Vooooooooo`0<oooo00<0003oooooool03?oo
o`03o`2Ioooooooo07ooool006;oool00`1Vooooooooo`0Koooo00<0I_ooooooool03?ooo`80000=
oooo00?o09Woooooool0Ooooo`00H_ooo`0306Kooooooooo01_oool00`1Vooooooooo`0<oooo00<0
003oooooool03?ooo`03o`2Ioooooooo07ooool006;oool00`1Vooooooooo`0Koooo00<0I_oooooo
ool03?ooo`030000oooooooo00coool00ol0VOooooooo`1ooooo001Roooo00<0I_ooooooool06ooo
o`0306Kooooooooo00coool00`000?ooooooo`0<oooo00?o09Woooooool0Ooooo`00H_ooo`0306Ko
oooooooo01_oool00`1Vooooooooo`0<oooo0P0000goool00ol0VOooooooo`1ooooo001Roooo00<0
I_ooooooool06oooo`0306Kooooooooo00coool00`000?ooooooo`0<oooo00?o09Woooooool0Oooo
o`00H_ooo`0306Kooooooooo01_oool00`1Vooooooooo`0<oooo00<0003oooooool03?ooo`03o`2I
oooooooo07ooool006;oool00`1Vooooooooo`0Koooo00<0I_ooooooool03?ooo`030000oooooooo
00coool00ol0VOooooooo`1ooooo001Roooo00<0I_ooooooool06oooo`0306Kooooooooo00coool2
00003Oooo`03o`2Ioooooooo07ooool006;oool00`1Vooooooooo`0Koooo00<0I_ooooooool03?oo
o`030000oooooooo00coool00ol0VOooooooo`1ooooo001Roooo00<0I_ooooooool06oooo`0306Ko
oooooooo00coool00`000?ooooooo`0<oooo00?o09Woooooool0Ooooo`00H_ooo`0306Kooooooooo
01_oool00`1Vooooooooo`0<oooo00<0003oooooool03?ooo`03o`2Ioooooooo07ooool006;oool0
0`1Vooooooooo`0Koooo00<0I_ooooooool03?ooo`80000=oooo00?o09Woooooool0Ooooo`00H_oo
o`0306Kooooooooo01_oool00`1Vooooooooo`0<oooo00<0003oooooool03?ooo`03o`2Ioooooooo
07ooool006;oool00`1Vooooooooo`0Aoooo0P0000Coool200000_ooo`0306Ko0000000000800003
oooo0P0000Goool00`000?ooooooo`0<oooo00?o09Woooooool0Ooooo`00H_ooo`0306Kooooooooo
013oool010000?ooooooo`0000Ooool00`1Vo`000?ooo`04oooo00@0003oooooool00004oooo00<0
003oooooool03?ooo`03o`2Ioooooooo07ooool006;oool00`1Vooooooooo`0@oooo00@0003ooooo
ool00007oooo00<0I_ooool000001oooo`030000oooooooo00;oool300003?ooo`03o`2Ioooooooo
07ooool006;oool00`1Vooooooooo`0@oooo00@0003oooooool00007oooo00@0I_ooooooool00004
oooo0P0000Goool00`000?ooooooo`0<oooo00?o09Woooooool0Ooooo`00H_ooo`0306Kooooooooo
013oool010000?ooooooo`0000Ooool01@1Vo`000?ooooooo`000003oooo00<0003oooooool01?oo
o`030000oooooooo00coool00ol0VOooooooo`1ooooo001Roooo00<0I_ooooooool04Oooo`800008
oooo00@0I_ooool000000004oooo0`0000Coool00`000?ooooooo`0<oooo00?o09Woooooool0Oooo
o`00H_ooo`0306Kooooooooo01_oool00`1Vooooooooo`0<oooo0P0000goool00ol0VOooooooo`1o
oooo001Roooo00<0I_ooooooool06oooo`0306Kooooooooo00coool00`000?ooooooo`0<oooo00?o
09Woooooool0Ooooo`00H_ooo`0306Kooooooooo01_oool00`1Vooooooooo`0<oooo00<0003ooooo
ool03?ooo`03o`2Ioooooooo07ooool006;oool00`1Vooooooooo`0Koooo00<0I_ooooooool03?oo
o`030000oooooooo00coool00ol0VOooooooo`1ooooo001Roooo00<0I_ooooooool06oooo`0306Ko
oooooooo00coool200003Oooo`03o`2Ioooooooo07ooool006;oool00`1Vooooooooo`0Koooo00<0
I_ooooooool03?ooo`030000oooooooo00coool00ol0VOooooooo`1ooooo001Roooo00<0I_oooooo
ool06oooo`0306Kooooooooo00coool00`000?ooooooo`0<oooo00?o09Woooooool0Ooooo`00H_oo
o`0306Kooooooooo01_oool00`1Vooooooooo`0<oooo00<0003oooooool03?ooo`03o`2Ioooooooo
07ooool006;oool00`1Vooooooooo`0Koooo00<0I_ooooooool03?ooo`80000=oooo00?o09Wooooo
ool0Ooooo`00H_ooo`0306Kooooooooo01_oool00`1Vooooooooo`0<oooo00<0003oooooool03?oo
o`03o`2Ioooooooo07ooool006;oool00`1Vooooooooo`0Koooo00<0I_ooooooool03?ooo`030000
oooooooo00coool00ol0VOooooooo`1ooooo001Roooo00<0I_ooooooool06oooo`0306Kooooooooo
00coool00`000?ooooooo`0<oooo00?o09Woooooool0Ooooo`00H_ooo`0306Kooooooooo01_oool0
0`1Vooooooooo`0<oooo0P0000goool00ol0VOooooooo`1ooooo001Roooo00<0I_ooooooool06ooo
o`0306Kooooooooo00coool00`000?ooooooo`0<oooo00?o09Woooooool0Ooooo`00H_ooo`0306Ko
oooooooo01Ooool200000_ooo`0406Kooooo000000001?ooo`800005oooo00<0003oooooool03?oo
o`03o`2Ioooooooo07ooool006;oool00`1Vooooooooo`0Foooo00H0003oooooool0003oool0I_l6
oooo00@0003oooooool00004oooo00<0003oooooool03?ooo`03o`2Ioooooooo07ooool006;ooolI
06Ko00@00000I_l0I_l0000206Ko2Oooo`030000oooooooo00;oool300003?ooo`03o`2Ioooooooo
07ooool007_oool010000?ooooooo`0000Woool200001Oooo`030000oooooooo00coool00ol0VOoo
ooooo`1ooooo001koooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo
00coool00ol0VOooooooo`1ooooo001loooo0P0000[oool300001?ooo`030000oooooooo00coool0
0ol0VOooooooo`1ooooo002?oooo0P0000goool00ol0VOooooooo`1ooooo002?oooo00<0003ooooo
ool03?ooo`03o`2Ioooooooo07ooool008ooool00`000?ooooooo`0<oooo00?o09Woooooool0Oooo
o`00Soooo`80000=oooo00?o09Woooooool0Ooooo`00Soooo`030000oooooooo00coool00ol0VOoo
ooooo`1ooooo002?oooo00<0003oooooool03?ooo`03o`2Ioooooooo07ooool008ooool00`000?oo
ooooo`0<oooo00?o09Woooooool0Ooooo`00Soooo`80000=oooo00?o09Woooooool0Ooooo`00Sooo
o`030000oooooooo00coool00ol0VOooooooo`1ooooo002?oooo00<0003oooooool03?ooo`03o`2I
oooooooo07ooool008ooool00`000?ooooooo`0<oooo00?o09Woooooool0Ooooo`00Soooo`80000=
oooo00?o09Woooooool0Ooooo`00Soooo`030000oooooooo00coool00ol0VOooooooo`1ooooo001f
oooo0P0000Coool200001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo00coool0
0ol0VOooooooo`1ooooo001eoooo00@0003oooooool0000:oooo00D0003oooooooooool000000_oo
o`030000oooooooo00;oool00`000?ooooooo`0<oooo00?o09Woooooool0Ooooo`00MOooo`040000
oooooooo00002_ooo`030000oooooooo00Coool00`000?ooooooo`02oooo0`0000coool00ol0VOoo
ooooo`1ooooo001eoooo00@0003oooooool0000;oooo00@0003oooooooooool200001Oooo`030000
oooooooo00coool00ol0VOooooooo`1ooooo001eoooo00@0003oooooool00008oooo00@0003ooooo
ool00003oooo00<0003oooooool01?ooo`030000oooooooo00coool00ol0VOooooooo`1ooooo001f
oooo0P0000Woool400000oooo`<00004oooo00<0003oooooool03?ooo`03o`2Ioooooooo07ooool0
08ooool200003Oooo`03o`2Ioooooooo07ooool008ooool00`000?ooooooo`0<oooo00?o09Wooooo
ool0Ooooo`00Soooo`030000oooooooo00coool00ol0VOooooooo`1ooooo002?oooo00<0003ooooo
ool03?ooo`03o`2Ioooooooo07ooool008ooool200003Oooo`03o`2Ioooooooo07ooool008ooool0
0`000?ooooooo`0<oooo00?o09Woooooool0Ooooo`00Soooo`030000oooooooo00coool00ol0VOoo
ooooo`1ooooo002?oooo00<0003oooooool03?ooo`03o`2Ioooooooo07ooool008ooool200003Ooo
o`03o`2Ioooooooo07ooool008ooool00`000?ooooooo`0<oooo00?o09Woooooool0Ooooo`00Sooo
o`030000oooooooo00coool00ol0VOooooooo`1ooooo002?oooo00<0003oooooool03?ooo`03o`2I
oooooooo07ooool008ooool200003Oooo`03o`2Ioooooooo07ooool008ooool00`000?ooooooo`0<
oooo00?o09Woooooool0Ooooo`00Qoooo`D00003oooo00<0003oooooool03?ooo`03o`2Ioooooooo
07ooool008Woool00`000?ooooooo`03oooo00<0003oooooool03?ooo`03o`2Ioooooooo07ooool0
08Woool00`000?ooooooo`03oooo0`0000coool00ol0VOooooooo`1ooooo0029oooo00<0003ooooo
ool0U?ooo`00ROooo`030000oooooooo09Coool008Soool20000U_ooo`00ooooob7oool00?oooolQ
oooo001ioooo00<0003oooooool0:?ooo`030000oooooooo07Woool007Soool00`000?ooooooo`08
oooo00<0003oooooool07oooo`030000oooooooo07Soool007Soool00`000?ooooooo`02oooo0P00
00Coool00`000?ooooooo`0=oooo0P0000Coool200001?ooo`800004oooo00<0003oooooool0N?oo
o`00N?ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01?oo
o`@00003oooo00@0003oooooool00008oooo00@0003oooooool00003oooo00<0003oooooool0N?oo
o`00Moooo`030000oooooooo00;oool00`000?ooooooo`0Coooo00@0003oooooool0000;oooo00<0
003oooooool00_ooo`030000oooooooo07Ooool007Soool00`000?ooooooo`0500004_ooo`040000
oooooooo00002Oooo`800004oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo0000
01Goool010000?ooooooo`0000Woool00`000?ooooooo`03oooo00<0003oooooool0N?ooo`00NOoo
o`030000oooooooo01Ooool200002_ooo`<00002oooo00<0003oooooool0NOooo`00ooooob7oool0
0?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.45) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.52059 .30902 L
.53984 .30902 L
.54934 .30902 L
.55436 .30902 L
.55972 .30902 L
.56236 .30902 L
.56366 .30902 L
.56486 .30902 L
s
.56486 .30902 m
.56496 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.31875 .30902 L
.32145 .30902 L
.32392 .30902 L
.32499 .30902 L
.32617 .30902 L
.32728 .30902 L
.32831 .46353 L
.32951 .46353 L
.3306 .46353 L
.33304 .46353 L
.34309 .46353 L
.38315 .46353 L
.40153 .46353 L
.41196 .46353 L
.4217 .46353 L
.42664 .46353 L
.43133 .46353 L
.43258 .46353 L
.43326 .46353 L
.43391 .46353 L
.4346 .30902 L
.43537 .30902 L
.43672 .30902 L
.44164 .30902 L
.46271 .30902 L
.50139 .30902 L
.54253 .30902 L
.58216 .30902 L
.62027 .30902 L
.66083 .30902 L
.69987 .30902 L
.74137 .30902 L
.78135 .30902 L
.81982 .30902 L
.86074 .30902 L
.90014 .30902 L
.93803 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.45) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00coool00`00001Vooooo`0<oooo00<0
003oooooool02_ooo`0306Kooooo000000koool00`000?ooooooo`0<oooo00<0003o09Woool03?oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo
00goool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo01Goool001Koool0
0`000?ooooooo`0joooo00<0003oooooool03Oooo`0306Kooooooooo01Soool00`1Vooooooooo`0>
oooo00<0003oooooool03Oooo`03o`2Ioooooooo02Woool00`000?ooooooo`0joooo00<0003ooooo
ool05Oooo`00Hoooo`0306Kooooooooo01Soool00`1Vooooooooo`0>oooo00<0003oooooool03Ooo
o`03o`2Ioooooooo07koool006?oool00`1Vooooooooo`0Hoooo00<0I_ooooooool03_ooo`80000>
oooo00?o09Woooooool0O_ooo`00Hoooo`0306Kooooooooo01Soool00`1Vooooooooo`0>oooo00<0
003oooooool03Oooo`03o`2Ioooooooo07koool006?oool00`1Vooooooooo`0Hoooo00<0I_oooooo
ool03_ooo`030000oooooooo00goool00ol0VOooooooo`1noooo001Soooo00<0I_ooooooool06?oo
o`0306Kooooooooo00koool00`000?ooooooo`0=oooo00?o09Woooooool0O_ooo`00Hoooo`0306Ko
oooooooo01Soool00`1Vooooooooo`0>oooo0P0000koool00ol0VOooooooo`1noooo001Soooo00<0
I_ooooooool06?ooo`0306Kooooooooo00koool00`000?ooooooo`0=oooo00?o09Woooooool0O_oo
o`00Hoooo`0306Kooooooooo01Soool00`1Vooooooooo`0>oooo00<0003oooooool03Oooo`03o`2I
oooooooo07koool006?oool00`1Vooooooooo`0Hoooo00<0I_ooooooool03_ooo`030000oooooooo
00goool00ol0VOooooooo`1noooo001Soooo00<0I_ooooooool06?ooo`0306Kooooooooo00koool2
00003_ooo`03o`2Ioooooooo07koool006?oool00`1Vooooooooo`0Hoooo00<0I_ooooooool03_oo
o`030000oooooooo00goool00ol0VOooooooo`1noooo001Soooo00<0I_ooooooool06?ooo`0306Ko
oooooooo00koool00`000?ooooooo`0=oooo00?o09Woooooool0O_ooo`00Hoooo`0306Kooooooooo
01Soool00`1Vooooooooo`0>oooo00<0003oooooool03Oooo`03o`2Ioooooooo07koool006?oool0
0`1Vooooooooo`0Hoooo00<0I_ooooooool03_ooo`80000>oooo00?o09Woooooool0O_ooo`00Hooo
o`0306Kooooooooo01Soool00`1Vooooooooo`0>oooo00<0003oooooool03Oooo`03o`2Ioooooooo
07koool006?oool00`1Vooooooooo`0@oooo0P0000Coool2000000<0I_ooooooool0100000?oool2
00001Oooo`030000oooooooo00goool00ol0VOooooooo`1noooo001Soooo00<0I_ooooooool03ooo
o`040000oooooooo00001Oooo`0406Kooooooooo00001Oooo`040000oooooooo00001?ooo`030000
oooooooo00goool00ol0VOooooooo`1noooo001Soooo00<0I_ooooooool03oooo`040000oooooooo
00001Oooo`0506Kooooooooooooo000000Ooool00`000?ooooooo`02oooo0`0000goool00ol0VOoo
ooooo`1noooo001Soooo00<0I_ooooooool03oooo`040000oooooooo00001Oooo`0306Kooooooooo
00;oool00`000?ooooooo`02oooo0P0000Goool00`000?ooooooo`0=oooo00?o09Woooooool0O_oo
o`00Hoooo`0306Kooooooooo00ooool010000?ooooooo`0000Goool0101Vooooooooo`0000;oool0
1@000?ooooooooooo`000006oooo00<0003oooooool03Oooo`03o`2Ioooooooo07koool006?oool0
0`1Vooooooooo`0@oooo0P0000Koool0101Vooooooooooooo`800004oooo0`0000Coool00`000?oo
ooooo`0=oooo00?o09Woooooool0O_ooo`00Hoooo`0306Kooooooooo01Soool00`1Vooooooooo`0>
oooo0P0000koool00ol0VOooooooo`1noooo001Soooo00<0I_ooooooool06?ooo`0306Kooooooooo
00koool00`000?ooooooo`0=oooo00?o09Woooooool0O_ooo`00Hoooo`0306Kooooooooo01Soool0
0`1Vooooooooo`0>oooo00<0003oooooool03Oooo`03o`2Ioooooooo07koool006?oool00`1Voooo
ooooo`0Hoooo00<0I_ooooooool03_ooo`030000oooooooo00goool00ol0VOooooooo`1noooo001S
oooo00<0I_ooooooool06?ooo`0306Kooooooooo00koool200003_ooo`03o`2Ioooooooo07koool0
06?oool00`1Vooooooooo`0Hoooo00<0I_ooooooool03_ooo`030000oooooooo00goool00ol0VOoo
ooooo`1noooo001Soooo00<0I_ooooooool06?ooo`0306Kooooooooo00koool00`000?ooooooo`0=
oooo00?o09Woooooool0O_ooo`00Hoooo`0306Kooooooooo01Soool00`1Vooooooooo`0>oooo00<0
003oooooool03Oooo`03o`2Ioooooooo07koool006?oool00`1Vooooooooo`0Hoooo00<0I_oooooo
ool03_ooo`80000>oooo00?o09Woooooool0O_ooo`00Hoooo`0306Kooooooooo01Soool00`1Voooo
ooooo`0>oooo00<0003oooooool03Oooo`03o`2Ioooooooo07koool006?oool00`1Vooooooooo`0H
oooo00<0I_ooooooool03_ooo`030000oooooooo00goool00ol0VOooooooo`1noooo001Soooo00<0
I_ooooooool06?ooo`0306Kooooooooo00koool00`000?ooooooo`0=oooo00?o09Woooooool0O_oo
o`00Hoooo`0306Kooooooooo01Soool00`1Vooooooooo`0>oooo0P0000koool00ol0VOooooooo`1n
oooo001Soooo00<0I_ooooooool06?ooo`0306Kooooooooo00koool00`000?ooooooo`0=oooo00?o
09Woooooool0O_ooo`00Hoooo`0306Kooooooooo01Koool2000000@0I_ooooooooooool200001?oo
o`800005oooo00<0003oooooool03Oooo`03o`2Ioooooooo07koool006?oool00`1Vooooooooo`0E
oooo00@0003oooooool00008oooo00@0003oooooool00004oooo00<0003oooooool03Oooo`03o`2I
oooooooo07koool006?ooolH06Ko00@00000I_l0I_l0000;oooo00<0003oooooool00_ooo`<0000=
oooo00?o09Woooooool0O_ooo`00Noooo`040000oooooooo00002Oooo`800005oooo00<0003ooooo
ool03Oooo`03o`2Ioooooooo07koool007_oool010000?ooooooo`0000Woool00`000?ooooooo`04
oooo00<0003oooooool03Oooo`03o`2Ioooooooo07koool007coool200002_ooo`<00004oooo00<0
003oooooool03Oooo`03o`2Ioooooooo07koool008ooool200003_ooo`03o`2Ioooooooo07koool0
08ooool00`000?ooooooo`0=oooo00?o09Woooooool0O_ooo`00Soooo`030000oooooooo00goool0
0ol0VOooooooo`1noooo002?oooo0P0000koool00ol0VOooooooo`1noooo002?oooo00<0003ooooo
ool03Oooo`03o`2Ioooooooo07koool008ooool00`000?ooooooo`0=oooo00?o09Woooooool0O_oo
o`00Soooo`030000oooooooo00goool00ol0VOooooooo`1noooo002?oooo0P0000koool00ol0VOoo
ooooo`1noooo002?oooo00<0003oooooool03Oooo`03o`2Ioooooooo07koool008ooool00`000?oo
ooooo`0=oooo00?o09Woooooool0O_ooo`00Soooo`030000oooooooo00goool00ol0VOooooooo`1n
oooo002?oooo0P0000koool00ol0VOooooooo`1noooo002?oooo00<0003oooooool03Oooo`03o`2I
oooooooo07koool007Koool200001?ooo`800005oooo00<0003oooooool00_ooo`800005oooo00<0
003oooooool03Oooo`03o`2Ioooooooo07koool007Goool010000?ooooooo`0000[oool01@000?oo
ooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo00goool00ol0VOooooooo`1n
oooo001eoooo00@0003oooooool0000:oooo00<0003oooooool01?ooo`030000oooooooo00;oool3
00003Oooo`03o`2Ioooooooo07koool007Goool010000?ooooooo`0000_oool010000?oooooooooo
o`800005oooo00<0003oooooool03Oooo`03o`2Ioooooooo07koool007Goool010000?ooooooo`00
00Soool010000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool03Oooo`03o`2I
oooooooo07koool007Koool200002Oooo`@00003oooo0`0000Coool00`000?ooooooo`0=oooo00?o
09Woooooool0O_ooo`00Soooo`80000>oooo00?o09Woooooool0O_ooo`00Soooo`030000oooooooo
00goool00ol0VOooooooo`1noooo002?oooo00<0003oooooool03Oooo`03o`2Ioooooooo07koool0
08ooool00`000?ooooooo`0=oooo00?o09Woooooool0O_ooo`00Soooo`80000>oooo00?o09Wooooo
ool0O_ooo`00Soooo`030000oooooooo00goool00ol0VOooooooo`1noooo002?oooo00<0003ooooo
ool03Oooo`03o`2Ioooooooo07koool008ooool00`000?ooooooo`0=oooo00?o09Woooooool0O_oo
o`00Soooo`80000>oooo00?o09Woooooool0O_ooo`00Soooo`030000oooooooo00goool00ol0VOoo
ooooo`1noooo002?oooo00<0003oooooool03Oooo`03o`2Ioooooooo07koool008ooool00`000?oo
ooooo`0=oooo00?o09Woooooool0O_ooo`00Soooo`80000>oooo00?o09Woooooool0O_ooo`00Sooo
o`030000oooooooo00goool00ol0VOooooooo`1noooo0027oooo1@0000?oool00`000?ooooooo`0=
oooo00?o09Woooooool0O_ooo`00ROooo`030000oooooooo00?oool00`000?ooooooo`0=oooo00?o
09Woooooool0O_ooo`00ROooo`030000oooooooo00?oool300003Oooo`03o`2Ioooooooo07koool0
08Woool00`000?ooooooo`2Doooo0029oooo00<0003oooooool0U?ooo`00R?ooo`80002Foooo003o
oooo8Oooo`00ooooob7oool007Koool00`000?ooooooo`0^oooo00<0003oooooool0M_ooo`00MOoo
o`030000oooooooo00Soool00`000?ooooooo`0Uoooo00<0003oooooool0MOooo`00MOooo`030000
oooooooo00;oool200001?ooo`030000oooooooo00goool200001?ooo`800005oooo0`0000;oool2
00001?ooo`030000oooooooo07Goool007Goool01@000?ooooooooooo`000002oooo00<0003ooooo
ool00_ooo`030000oooooooo00Coool400000oooo`040000oooooooo00002oooo`040000oooooooo
00000_ooo`050000oooooooooooo000007Ooool007Coool00`000?ooooooo`02oooo00<0003ooooo
ool04oooo`040000oooooooo00002?ooo`D00004oooo00<0003oooooool00_ooo`030000oooooooo
07Coool007Goool00`000?ooooooo`0500004_ooo`040000oooooooo00002?ooo`040000oooooooo
00000oooo`800004oooo00<0003oooooool0MOooo`00MOooo`050000oooooooooooo000001Goool0
10000?ooooooo`0000Woool00`000?ooo`000003oooo00<0003oooooool00oooo`030000oooooooo
07Goool007Koool00`000?ooooooo`0Goooo0P0000_oool200000oooo`<00002oooo00<0003ooooo
ool0M_ooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.52059 .30902 L
.53984 .30902 L
.54934 .30902 L
.55972 .30902 L
.56446 .30902 L
.56706 .30902 L
.56834 .30902 L
.56951 .30902 L
.57063 .30902 L
s
.57063 .30902 m
.57075 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.32831 .30902 L
.33073 .30902 L
.33193 .30902 L
.33304 .30902 L
.33433 .46353 L
.33502 .46353 L
.33575 .46353 L
.33823 .46353 L
.34309 .46353 L
.38467 .46353 L
.40553 .46353 L
.41469 .46353 L
.41954 .46353 L
.42221 .46353 L
.42473 .46353 L
.42716 .46353 L
.42783 .46353 L
.42854 .46353 L
.4298 .30902 L
.43094 .30902 L
.432 .30902 L
.43443 .30902 L
.44348 .30902 L
.46328 .30902 L
.50197 .30902 L
.54311 .30902 L
.58274 .30902 L
.62084 .30902 L
.66141 .30902 L
.70045 .30902 L
.74195 .30902 L
.78193 .30902 L
.8204 .30902 L
.86132 .30902 L
.90072 .30902 L
.93861 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00coool010000?ooooooo`1Vo`_oool0
0`000?ooooooo`09oooo00@0I_ooooooool0000>oooo00<0003oooooool03?ooo`040000oooooooo
o`2I2oooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000
oooooooo00goool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo01Goool0
01Koool00`000?ooooooo`0joooo00<0003oooooool03oooo`0306Kooooooooo01Goool00`1Voooo
ooooo`0?oooo00<0003oooooool03oooo`03o`2Ioooooooo02Ooool00`000?ooooooo`0joooo00<0
003oooooool05Oooo`00IOooo`0306Kooooooooo01Goool00`1Vooooooooo`0?oooo00<0003ooooo
ool03oooo`03o`2Ioooooooo07coool006Goool00`1Vooooooooo`0Eoooo00<0I_ooooooool03ooo
o`80000@oooo00?o09Woooooool0O?ooo`00IOooo`0306Kooooooooo01Goool00`1Vooooooooo`0?
oooo00<0003oooooool03oooo`03o`2Ioooooooo07coool006Goool00`1Vooooooooo`0Eoooo00<0
I_ooooooool03oooo`030000oooooooo00ooool00ol0VOooooooo`1loooo001Uoooo00<0I_oooooo
ool05Oooo`0306Kooooooooo00ooool00`000?ooooooo`0?oooo00?o09Woooooool0O?ooo`00IOoo
o`0306Kooooooooo01Goool00`1Vooooooooo`0?oooo0P00013oool00ol0VOooooooo`1loooo001U
oooo00<0I_ooooooool05Oooo`0306Kooooooooo00ooool00`000?ooooooo`0?oooo00?o09Wooooo
ool0O?ooo`00IOooo`0306Kooooooooo01Goool00`1Vooooooooo`0?oooo00<0003oooooool03ooo
o`03o`2Ioooooooo07coool006Goool00`1Vooooooooo`0Eoooo00<0I_ooooooool03oooo`030000
oooooooo00ooool00ol0VOooooooo`1loooo001Uoooo00<0I_ooooooool05Oooo`0306Kooooooooo
00ooool200004?ooo`03o`2Ioooooooo07coool006Goool00`1Vooooooooo`0Eoooo00<0I_oooooo
ool03oooo`030000oooooooo00ooool00ol0VOooooooo`1loooo001Uoooo00<0I_ooooooool05Ooo
o`0306Kooooooooo00ooool00`000?ooooooo`0?oooo00?o09Woooooool0O?ooo`00IOooo`0306Ko
oooooooo01Goool00`1Vooooooooo`0?oooo00<0003oooooool03oooo`03o`2Ioooooooo07coool0
06Goool00`1Vooooooooo`0Eoooo00<0I_ooooooool03oooo`80000@oooo00?o09Woooooool0O?oo
o`00IOooo`0306Kooooooooo01Goool00`1Vooooooooo`0?oooo00<0003oooooool03oooo`03o`2I
oooooooo07coool006Goool00`1Vooooooooo`0>oooo0P0000Coool200000oooo`@00003oooo0P00
00Goool00`000?ooooooo`0?oooo00?o09Woooooool0O?ooo`00IOooo`0306Kooooooooo00goool0
10000?ooooooo`0000Coool01@1Vooooooooooooo`000005oooo00@0003oooooool00004oooo00<0
003oooooool03oooo`03o`2Ioooooooo07coool006Goool00`1Vooooooooo`0=oooo00@0003ooooo
ool00004oooo00<0I_ooooooool00_ooo`030000oooooooo00Goool00`000?ooooooo`02oooo0`00
00ooool00ol0VOooooooo`1loooo001Uoooo00<0I_ooooooool03Oooo`040000oooooooo00001?oo
o`0306Kooooooooo00?oool00`000?ooooooo`02oooo0P0000Goool00`000?ooooooo`0?oooo00?o
09Woooooool0O?ooo`00IOooo`0306Kooooooooo00goool010000?ooooooo`0000Coool01@1Voooo
ooooooooo`000002oooo00D0003oooooooooool000001_ooo`030000oooooooo00ooool00ol0VOoo
ooooo`1loooo001Uoooo00<0I_ooooooool03_ooo`800005oooo00<0I_ooooooool00_ooo`800004
oooo0`0000Coool00`000?ooooooo`0?oooo00?o09Woooooool0O?ooo`00IOooo`0306Kooooooooo
01Goool00`1Vooooooooo`0?oooo0P00013oool00ol0VOooooooo`1loooo001Uoooo00<0I_oooooo
ool05Oooo`0306Kooooooooo00ooool00`000?ooooooo`0?oooo00?o09Woooooool0O?ooo`00IOoo
o`0306Kooooooooo01Goool00`1Vooooooooo`0?oooo00<0003oooooool03oooo`03o`2Ioooooooo
07coool006Goool00`1Vooooooooo`0Eoooo00<0I_ooooooool03oooo`030000oooooooo00ooool0
0ol0VOooooooo`1loooo001Uoooo00<0I_ooooooool05Oooo`0306Kooooooooo00ooool200004?oo
o`03o`2Ioooooooo07coool006Goool00`1Vooooooooo`0Eoooo00<0I_ooooooool03oooo`030000
oooooooo00ooool00ol0VOooooooo`1loooo001Uoooo00<0I_ooooooool05Oooo`0306Kooooooooo
00ooool00`000?ooooooo`0?oooo00?o09Woooooool0O?ooo`00IOooo`0306Kooooooooo01Goool0
0`1Vooooooooo`0?oooo00<0003oooooool03oooo`03o`2Ioooooooo07coool006Goool00`1Voooo
ooooo`0Eoooo00<0I_ooooooool03oooo`80000@oooo00?o09Woooooool0O?ooo`00IOooo`0306Ko
oooooooo01Goool00`1Vooooooooo`0?oooo00<0003oooooool03oooo`03o`2Ioooooooo07coool0
06Goool00`1Vooooooooo`0Eoooo00<0I_ooooooool03oooo`030000oooooooo00ooool00ol0VOoo
ooooo`1loooo001Uoooo00<0I_ooooooool05Oooo`0306Kooooooooo00ooool00`000?ooooooo`0?
oooo00?o09Woooooool0O?ooo`00IOooo`0306Kooooooooo01Goool00`1Vooooooooo`0?oooo0P00
013oool00ol0VOooooooo`1loooo001Uoooo00<0I_ooooooool05Oooo`0306Kooooooooo00ooool0
0`000?ooooooo`0?oooo00?o09Woooooool0O?ooo`00IOooo`0306Kooooooooo01Coool200001?oo
o`800004oooo0P0000Goool00`000?ooooooo`0?oooo00?o09Woooooool0O?ooo`00IOooo`0306Ko
oooooooo01?oool010000?ooo`1Vo`0000Soool010000?ooooooo`0000Coool00`000?ooooooo`0?
oooo00?o09Woooooool0O?ooo`00IOoooaH0I_l01000001Vo`1Vo`0000_oool00`000?ooooooo`02
oooo0`0000ooool00ol0VOooooooo`1loooo001koooo00@0003oooooool00009oooo0P0000Goool0
0`000?ooooooo`0?oooo00?o09Woooooool0O?ooo`00Noooo`040000oooooooo00002Oooo`030000
oooooooo00Coool00`000?ooooooo`0?oooo00?o09Woooooool0O?ooo`00O?ooo`80000:oooo0`00
00Coool00`000?ooooooo`0?oooo00?o09Woooooool0O?ooo`00Soooo`80000@oooo00?o09Wooooo
ool0O?ooo`00Soooo`030000oooooooo00ooool00ol0VOooooooo`1loooo002?oooo00<0003ooooo
ool03oooo`03o`2Ioooooooo07coool008ooool200004?ooo`03o`2Ioooooooo07coool008ooool0
0`000?ooooooo`0?oooo00?o09Woooooool0O?ooo`00Soooo`030000oooooooo00ooool00ol0VOoo
ooooo`1loooo002?oooo00<0003oooooool03oooo`03o`2Ioooooooo07coool008ooool200004?oo
o`03o`2Ioooooooo07coool008ooool00`000?ooooooo`0?oooo00?o09Woooooool0O?ooo`00Sooo
o`030000oooooooo00ooool00ol0VOooooooo`1loooo002?oooo00<0003oooooool03oooo`03o`2I
oooooooo07coool008ooool200004?ooo`03o`2Ioooooooo07coool008ooool00`000?ooooooo`0?
oooo00?o09Woooooool0O?ooo`00M_ooo`800004oooo0P0000Goool00`000?ooooooo`02oooo0P00
00Goool00`000?ooooooo`0?oooo00?o09Woooooool0O?ooo`00MOooo`040000oooooooo00002_oo
o`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003oooooool03oooo`03o`2I
oooooooo07coool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003ooooo
ool00_ooo`<0000?oooo00?o09Woooooool0O?ooo`00MOooo`040000oooooooo00002oooo`040000
oooooooooooo0P0000Goool00`000?ooooooo`0?oooo00?o09Woooooool0O?ooo`00MOooo`040000
oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo00Coool00`000?ooooooo`0?
oooo00?o09Woooooool0O?ooo`00M_ooo`800009oooo100000?oool300001?ooo`030000oooooooo
00ooool00ol0VOooooooo`1loooo002?oooo0P00013oool00ol0VOooooooo`1loooo002?oooo00<0
003oooooool03oooo`03o`2Ioooooooo07coool008ooool00`000?ooooooo`0?oooo00?o09Wooooo
ool0O?ooo`00Soooo`030000oooooooo00ooool00ol0VOooooooo`1loooo002?oooo0P00013oool0
0ol0VOooooooo`1loooo002?oooo00<0003oooooool03oooo`03o`2Ioooooooo07coool008ooool0
0`000?ooooooo`0?oooo00?o09Woooooool0O?ooo`00Soooo`030000oooooooo00ooool00ol0VOoo
ooooo`1loooo002?oooo0P00013oool00ol0VOooooooo`1loooo002?oooo00<0003oooooool03ooo
o`03o`2Ioooooooo07coool008ooool00`000?ooooooo`0?oooo00?o09Woooooool0O?ooo`00Sooo
o`030000oooooooo00ooool00ol0VOooooooo`1loooo002?oooo0P00013oool00ol0VOooooooo`1l
oooo002?oooo00<0003oooooool03oooo`03o`2Ioooooooo07coool008Ooool500000oooo`030000
oooooooo00ooool00ol0VOooooooo`1loooo0029oooo00<0003oooooool00oooo`030000oooooooo
00ooool00ol0VOooooooo`1loooo0029oooo00<0003oooooool00oooo`<0000?oooo00?o09Wooooo
ool0O?ooo`00ROooo`030000oooooooo09Coool008Woool00`000?ooooooo`2Doooo0028oooo0P00
09Koool00?oooolQoooo003ooooo8Oooo`00NOooo`030000oooooooo02Soool00`000?ooooooo`1i
oooo001hoooo00<0003oooooool02?ooo`030000oooooooo01ooool00`000?ooooooo`1hoooo001h
oooo00<0003oooooool00_ooo`800004oooo00<0003oooooool03Oooo`800004oooo0P0000Goool3
00000_ooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`000002oooo00<0003ooooo
ool00_ooo`030000oooooooo00Coool400000oooo`040000oooooooo00002oooo`050000oooooooo
oooo000007[oool007Ooool00`000?ooooooo`02oooo00<0003oooooool04oooo`040000oooooooo
00002?ooo`D00003oooo00<0003oooooool0Moooo`00N?ooo`030000oooooooo00D0000Boooo00@0
003oooooool00008oooo00@0003oooooool00003oooo00<0003oooooool0N?ooo`00N?ooo`050000
oooooooooooo000001Goool010000?ooooooo`0000Woool00`000?ooo`000003oooo00<0003ooooo
ool0N?ooo`00NOooo`030000oooooooo01Ooool200002oooo`800002oooo00<0003oooooool0NOoo
o`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.35) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.52059 .30902 L
.53984 .30902 L
.54934 .30902 L
.55972 .30902 L
.56446 .30902 L
.56951 .30902 L
.57197 .30902 L
.57429 .30902 L
.5753 .30902 L
.57636 .30902 L
s
.57636 .30902 m
.57648 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.33304 .30902 L
.33554 .30902 L
.33692 .30902 L
.33823 .30902 L
.33944 .46353 L
.34013 .46353 L
.34076 .46353 L
.34309 .46353 L
.38221 .46353 L
.3925 .46353 L
.40363 .46353 L
.40873 .46353 L
.41413 .46353 L
.41874 .46353 L
.42 .46353 L
.4207 .46353 L
.42135 .46353 L
.42263 .30902 L
.4238 .30902 L
.46213 .30902 L
.50291 .30902 L
.54217 .30902 L
.57993 .30902 L
.62013 .30902 L
.65882 .30902 L
.69996 .30902 L
.73958 .30902 L
.77769 .30902 L
.81825 .30902 L
.85729 .30902 L
.89879 .30902 L
.93877 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.35) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00coool01@000?ooooooooooo`1Vo`0:
oooo00<0003oooooool01oooo`0306Kooooooooo00;oool00`000?ooooooo`0<oooo00<0003ooooo
ool03?ooo`050000ooooooooooooo`2I00[oool00`000?ooooooo`0<oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo
00coool00`000?ooooooo`0Eoooo000Foooo00<0003oooooool0>_ooo`030000oooooooo013oool0
0`1Vooooooooo`0Boooo00<0I_ooooooool04Oooo`030000oooooooo013oool00ol0VOooooooo`0V
oooo00<0003oooooool0>_ooo`030000oooooooo01Goool006Koool00`1Vooooooooo`0Boooo00<0
I_ooooooool04Oooo`030000oooooooo013oool00ol0VOooooooo`1koooo001Voooo00<0I_oooooo
ool04_ooo`0306Kooooooooo017oool200004Oooo`03o`2Ioooooooo07_oool006Koool00`1Voooo
ooooo`0Boooo00<0I_ooooooool04Oooo`030000oooooooo013oool00ol0VOooooooo`1koooo001V
oooo00<0I_ooooooool04_ooo`0306Kooooooooo017oool00`000?ooooooo`0@oooo00?o09Wooooo
ool0Noooo`00I_ooo`0306Kooooooooo01;oool00`1Vooooooooo`0Aoooo00<0003oooooool04?oo
o`03o`2Ioooooooo07_oool006Koool00`1Vooooooooo`0Boooo00<0I_ooooooool04Oooo`80000A
oooo00?o09Woooooool0Noooo`00I_ooo`0306Kooooooooo01;oool00`1Vooooooooo`0Aoooo00<0
003oooooool04?ooo`03o`2Ioooooooo07_oool006Koool00`1Vooooooooo`0Boooo00<0I_oooooo
ool04Oooo`030000oooooooo013oool00ol0VOooooooo`1koooo001Voooo00<0I_ooooooool04_oo
o`0306Kooooooooo017oool00`000?ooooooo`0@oooo00?o09Woooooool0Noooo`00I_ooo`0306Ko
oooooooo01;oool00`1Vooooooooo`0Aoooo0P00017oool00ol0VOooooooo`1koooo001Voooo00<0
I_ooooooool04_ooo`0306Kooooooooo017oool00`000?ooooooo`0@oooo00?o09Woooooool0Nooo
o`00I_ooo`0306Kooooooooo01;oool00`1Vooooooooo`0Aoooo00<0003oooooool04?ooo`03o`2I
oooooooo07_oool006Koool00`1Vooooooooo`0Boooo00<0I_ooooooool04Oooo`030000oooooooo
013oool00ol0VOooooooo`1koooo001Voooo00<0I_ooooooool04_ooo`0306Kooooooooo017oool2
00004Oooo`03o`2Ioooooooo07_oool006Koool00`1Vooooooooo`0Boooo00<0I_ooooooool04Ooo
o`030000oooooooo013oool00ol0VOooooooo`1koooo001Voooo00<0I_ooooooool03Oooo`800003
oooo00<0I_l0000000000oooo`@00003oooo0P0000Goool00`000?ooooooo`0@oooo00?o09Wooooo
ool0Noooo`00I_ooo`0306Kooooooooo00coool010000?ooooooo`0000;oool00`1Vooooooooo`03
oooo00<0003oooooool00oooo`040000oooooooo00001?ooo`030000oooooooo013oool00ol0VOoo
ooooo`1koooo001Voooo00<0I_ooooooool03?ooo`040000oooooooo00000_ooo`0306Kooooooooo
00Coool00`000?ooooooo`05oooo00<0003oooooool00_ooo`<0000@oooo00?o09Woooooool0Nooo
o`00I_ooo`0306Kooooooooo00coool010000?ooooooo`0000;oool00`1Vooooooooo`05oooo00<0
003oooooool00_ooo`800005oooo00<0003oooooool04?ooo`03o`2Ioooooooo07_oool006Koool0
0`1Vooooooooo`0<oooo00@0003oooooool00002oooo00<0I_ooooooool00oooo`040000oooooooo
00000oooo`030000oooooooo00Coool00`000?ooooooo`0@oooo00?o09Woooooool0Noooo`00I_oo
o`0306Kooooooooo00goool200000oooo`0306Kooooooooo00Coool200001?ooo`<00004oooo00<0
003oooooool04?ooo`03o`2Ioooooooo07_oool006Koool00`1Vooooooooo`0Boooo00<0I_oooooo
ool04Oooo`80000Aoooo00?o09Woooooool0Noooo`00I_ooo`0306Kooooooooo01;oool00`1Voooo
ooooo`0Aoooo00<0003oooooool04?ooo`03o`2Ioooooooo07_oool006Koool00`1Vooooooooo`0B
oooo00<0I_ooooooool04Oooo`030000oooooooo013oool00ol0VOooooooo`1koooo001Voooo00<0
I_ooooooool04_ooo`0306Kooooooooo017oool00`000?ooooooo`0@oooo00?o09Woooooool0Nooo
o`00I_ooo`0306Kooooooooo01;oool00`1Vooooooooo`0Aoooo0P00017oool00ol0VOooooooo`1k
oooo001Voooo00<0I_ooooooool04_ooo`0306Kooooooooo017oool00`000?ooooooo`0@oooo00?o
09Woooooool0Noooo`00I_ooo`0306Kooooooooo01;oool00`1Vooooooooo`0Aoooo00<0003ooooo
ool04?ooo`03o`2Ioooooooo07_oool006Koool00`1Vooooooooo`0Boooo00<0I_ooooooool04Ooo
o`030000oooooooo013oool00ol0VOooooooo`1koooo001Voooo00<0I_ooooooool04_ooo`0306Ko
oooooooo017oool200004Oooo`03o`2Ioooooooo07_oool006Koool00`1Vooooooooo`0Boooo00<0
I_ooooooool04Oooo`030000oooooooo013oool00ol0VOooooooo`1koooo001Voooo00<0I_oooooo
ool04_ooo`0306Kooooooooo017oool00`000?ooooooo`0@oooo00?o09Woooooool0Noooo`00I_oo
o`0306Kooooooooo01;oool00`1Vooooooooo`0Aoooo00<0003oooooool04?ooo`03o`2Ioooooooo
07_oool006Koool00`1Vooooooooo`0Boooo00<0I_ooooooool04Oooo`80000Aoooo00?o09Wooooo
ool0Noooo`00I_ooo`0306Kooooooooo01;oool00`1Vooooooooo`0Aoooo00<0003oooooool04?oo
o`03o`2Ioooooooo07_oool006Koool00`1Vooooooooo`0Boooo00<0I_l0000000001?ooo`800004
oooo0P0000Goool00`000?ooooooo`0@oooo00?o09Woooooool0Noooo`00I_ooo`0306Kooooooooo
01;oool010000?ooooooo`0000Soool010000?ooooooo`0000Coool00`000?ooooooo`0@oooo00?o
09Woooooool0Noooo`00I_oooaD0I_l010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
013oool00ol0VOooooooo`1koooo001koooo00@0003oooooool00009oooo0P0000Goool00`000?oo
ooooo`0@oooo00?o09Woooooool0Noooo`00Noooo`040000oooooooo00002Oooo`030000oooooooo
00Coool00`000?ooooooo`0@oooo00?o09Woooooool0Noooo`00O?ooo`80000:oooo0`0000Coool0
0`000?ooooooo`0@oooo00?o09Woooooool0Noooo`00Soooo`80000Aoooo00?o09Woooooool0Nooo
o`00Soooo`030000oooooooo013oool00ol0VOooooooo`1koooo002?oooo00<0003oooooool04?oo
o`03o`2Ioooooooo07_oool008ooool200004Oooo`03o`2Ioooooooo07_oool008ooool00`000?oo
ooooo`0@oooo00?o09Woooooool0Noooo`00Soooo`030000oooooooo013oool00ol0VOooooooo`1k
oooo002?oooo00<0003oooooool04?ooo`03o`2Ioooooooo07_oool008ooool200004Oooo`03o`2I
oooooooo07_oool008ooool00`000?ooooooo`0@oooo00?o09Woooooool0Noooo`00Soooo`030000
oooooooo013oool00ol0VOooooooo`1koooo002?oooo00<0003oooooool04?ooo`03o`2Ioooooooo
07_oool008ooool200004Oooo`03o`2Ioooooooo07_oool008ooool00`000?ooooooo`0@oooo00?o
09Woooooool0Noooo`00M_ooo`800004oooo0P0000Goool00`000?ooooooo`02oooo0P0000Goool0
0`000?ooooooo`0@oooo00?o09Woooooool0Noooo`00MOooo`040000oooooooo00002_ooo`050000
oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003oooooool04?ooo`03o`2Ioooooooo
07_oool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0000@oooo00?o09Woooooool0Noooo`00MOooo`040000oooooooo00002oooo`040000oooooooo
oooo0P0000Goool00`000?ooooooo`0@oooo00?o09Woooooool0Noooo`00MOooo`040000oooooooo
00002?ooo`040000oooooooo00000oooo`030000oooooooo00Coool00`000?ooooooo`0@oooo00?o
09Woooooool0Noooo`00M_ooo`800009oooo100000?oool300001?ooo`030000oooooooo013oool0
0ol0VOooooooo`1koooo002?oooo0P00017oool00ol0VOooooooo`1koooo002?oooo00<0003ooooo
ool04?ooo`03o`2Ioooooooo07_oool008ooool00`000?ooooooo`0@oooo00?o09Woooooool0Nooo
o`00Soooo`030000oooooooo013oool00ol0VOooooooo`1koooo002?oooo0P00017oool00ol0VOoo
ooooo`1koooo002?oooo00<0003oooooool04?ooo`03o`2Ioooooooo07_oool008ooool00`000?oo
ooooo`0@oooo00?o09Woooooool0Noooo`00Soooo`030000oooooooo013oool00ol0VOooooooo`1k
oooo002?oooo0P00017oool00ol0VOooooooo`1koooo002?oooo00<0003oooooool04?ooo`03o`2I
oooooooo07_oool008ooool00`000?ooooooo`0@oooo00?o09Woooooool0Noooo`00Soooo`030000
oooooooo013oool00ol0VOooooooo`1koooo002?oooo0P00017oool00ol0VOooooooo`1koooo002?
oooo00<0003oooooool04?ooo`03o`2Ioooooooo07_oool008Ooool500000oooo`030000oooooooo
013oool00ol0VOooooooo`1koooo0029oooo00<0003oooooool00oooo`030000oooooooo013oool0
0ol0VOooooooo`1koooo0029oooo00<0003oooooool00oooo`<0000@oooo00?o09Woooooool0Nooo
o`00ROooo`030000oooooooo09Coool008Woool00`000?ooooooo`2Doooo0028oooo0P0009Koool0
0?oooolQoooo003ooooo8Oooo`00M_ooo`030000oooooooo02koool00`000?ooooooo`1foooo001e
oooo00<0003oooooool02?ooo`030000oooooooo02Goool00`000?ooooooo`1eoooo001eoooo00<0
003oooooool00_ooo`800004oooo00<0003oooooool03Oooo`800004oooo0P0000Coool200001?oo
o`800004oooo00<0003oooooool0MOooo`00MOooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003oooooool00008oooo00@0003ooooo
ool00002oooo00@0003oooooool00003oooo00<0003oooooool0MOooo`00M?ooo`030000oooooooo
00;oool00`000?ooooooo`0Coooo00@0003oooooool0000:oooo00<0003oooooool01?ooo`030000
oooooooo00;oool00`000?ooooooo`1doooo001eoooo00<0003oooooool01@0001;oool010000?oo
ooooo`0000_oool010000?ooooooooooo`800004oooo00<0003oooooool0MOooo`00MOooo`050000
oooooooooooo000001Goool010000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?oo
ooooo`03oooo00<0003oooooool0MOooo`00M_ooo`030000oooooooo01Ooool200002_ooo`800004
oooo0`0000;oool00`000?ooooooo`1foooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.55838 .30902 L
.56817 .30902 L
.57355 .30902 L
.57861 .30902 L
.58137 .30902 L
.58213 .30902 L
.58293 .30902 L
s
.58293 .30902 m
.583 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.32392 .30902 L
.33304 .30902 L
.33788 .30902 L
.34055 .30902 L
.34186 .30902 L
.34309 .30902 L
.34425 .30902 L
.34549 .46353 L
.3462 .46353 L
.34686 .46353 L
.34811 .46353 L
.35271 .46353 L
.36173 .46353 L
.3815 .46353 L
.39126 .46353 L
.40158 .46353 L
.41038 .46353 L
.4128 .46353 L
.41412 .46353 L
.41538 .46353 L
.41655 .46353 L
.41782 .30902 L
.41898 .30902 L
.42005 .30902 L
.45932 .30902 L
.49707 .30902 L
.53727 .30902 L
.57596 .30902 L
.6171 .30902 L
.65672 .30902 L
.69483 .30902 L
.73539 .30902 L
.77444 .30902 L
.81593 .30902 L
.85592 .30902 L
.89438 .30902 L
.9353 .30902 L
.9747 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`02oooo00<0
I_ooooooool01oooo`030000oooooooo00Koool00`1Vooooooooo`03oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`03oooo00?o09Woooooool01_ooo`030000oooooooo
00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00goool00`000?oo
ooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo01Goool001Koool00`000?ooooooo`0j
oooo00<0003oooooool04Oooo`0306Kooooooooo013oool00`1Vooooooooo`0Boooo00<0003ooooo
ool04_ooo`03o`2Ioooooooo02Coool00`000?ooooooo`0joooo00<0003oooooool05Oooo`00Iooo
o`0306Kooooooooo013oool00`1Vooooooooo`0Boooo00<0003oooooool04_ooo`03o`2Ioooooooo
07Woool006Ooool00`1Vooooooooo`0@oooo00<0I_ooooooool04_ooo`80000Coooo00?o09Wooooo
ool0NOooo`00Ioooo`0306Kooooooooo013oool00`1Vooooooooo`0Boooo00<0003oooooool04_oo
o`03o`2Ioooooooo07Woool006Ooool00`1Vooooooooo`0@oooo00<0I_ooooooool04_ooo`030000
oooooooo01;oool00ol0VOooooooo`1ioooo001Woooo00<0I_ooooooool04?ooo`0306Kooooooooo
01;oool00`000?ooooooo`0Boooo00?o09Woooooool0NOooo`00Ioooo`0306Kooooooooo013oool0
0`1Vooooooooo`0Boooo0P0001?oool00ol0VOooooooo`1ioooo001Woooo00<0I_ooooooool04?oo
o`0306Kooooooooo01;oool00`000?ooooooo`0Boooo00?o09Woooooool0NOooo`00Ioooo`0306Ko
oooooooo013oool00`1Vooooooooo`0Boooo00<0003oooooool04_ooo`03o`2Ioooooooo07Woool0
06Ooool00`1Vooooooooo`0@oooo00<0I_ooooooool04_ooo`030000oooooooo01;oool00ol0VOoo
ooooo`1ioooo001Woooo00<0I_ooooooool04?ooo`0306Kooooooooo01;oool200004oooo`03o`2I
oooooooo07Woool006Ooool00`1Vooooooooo`0@oooo00<0I_ooooooool04_ooo`030000oooooooo
01;oool00ol0VOooooooo`1ioooo001Woooo00<0I_ooooooool04?ooo`0306Kooooooooo01;oool0
0`000?ooooooo`0Boooo00?o09Woooooool0NOooo`00Ioooo`0306Kooooooooo013oool00`1Voooo
ooooo`0Boooo00<0003oooooool04_ooo`03o`2Ioooooooo07Woool006Ooool00`1Vooooooooo`0@
oooo00<0I_ooooooool04_ooo`80000Coooo00?o09Woooooool0NOooo`00Ioooo`0306Kooooooooo
013oool00`1Vooooooooo`0Boooo00<0003oooooool04_ooo`03o`2Ioooooooo07Woool006Ooool0
0`1Vooooooooo`0<oooo0P0000;oool0101Vooooo`00000000?oool400000oooo`800005oooo00<0
003oooooool04_ooo`03o`2Ioooooooo07Woool006Ooool00`1Vooooooooo`0;oooo00H0003ooooo
ool0003oool0I_l6oooo00<0003oooooool00oooo`040000oooooooo00001?ooo`030000oooooooo
01;oool00ol0VOooooooo`1ioooo001Woooo00<0I_ooooooool02oooo`060000oooooooo0000oooo
06Ko1oooo`030000oooooooo00Goool00`000?ooooooo`02oooo0`0001;oool00ol0VOooooooo`1i
oooo001Xoooo00<0I_ooooooool02_ooo`060000oooooooo0000oooo06Ko2?ooo`030000oooooooo
00;oool200001Oooo`030000oooooooo01;oool00ol0VOooooooo`1ioooo001Xoooo00<0I_oooooo
ool02_ooo`060000oooooooo0000oooo06Ko1_ooo`040000oooooooo00000oooo`030000oooooooo
00Coool00`000?ooooooo`0Boooo00?o09Woooooool0NOooo`00J?ooo`0306Kooooooooo00_oool2
00000_ooo`0306Kooooooooo00Goool200001?ooo`<00004oooo00<0003oooooool04_ooo`03o`2I
oooooooo07Woool006Soool00`1Vooooooooo`0?oooo00<0I_ooooooool04_ooo`80000Coooo00?o
09Woooooool0NOooo`00J?ooo`0306Kooooooooo00ooool00`1Vooooooooo`0Boooo00<0003ooooo
ool04_ooo`03o`2Ioooooooo07Woool006Soool00`1Vooooooooo`0?oooo00<0I_ooooooool04_oo
o`030000oooooooo01;oool00ol0VOooooooo`1ioooo001Xoooo00<0I_ooooooool03oooo`0306Ko
oooooooo01;oool00`000?ooooooo`0Boooo00?o09Woooooool0NOooo`00J?ooo`0306Kooooooooo
00ooool00`1Vooooooooo`0Boooo0P0001?oool00ol0VOooooooo`1ioooo001Xoooo00<0I_oooooo
ool03oooo`0306Kooooooooo01;oool00`000?ooooooo`0Boooo00?o09Woooooool0NOooo`00J?oo
o`0306Kooooooooo00ooool00`1Vooooooooo`0Boooo00<0003oooooool04_ooo`03o`2Ioooooooo
07Woool006Soool00`1Vooooooooo`0?oooo00<0I_ooooooool04_ooo`030000oooooooo01;oool0
0ol0VOooooooo`1ioooo001Xoooo00<0I_ooooooool03oooo`0306Kooooooooo01;oool200004ooo
o`03o`2Ioooooooo07Woool006Soool00`1Vooooooooo`0?oooo00<0I_ooooooool04_ooo`030000
oooooooo01;oool00ol0VOooooooo`1ioooo001Xoooo00<0I_ooooooool03oooo`0306Kooooooooo
01;oool00`000?ooooooo`0Boooo00?o09Woooooool0NOooo`00J?ooo`0306Kooooooooo00ooool0
0`1Vooooooooo`0Boooo00<0003oooooool04_ooo`03o`2Ioooooooo07Woool006Soool00`1Voooo
ooooo`0?oooo00<0I_ooooooool04_ooo`80000Coooo00?o09Woooooool0NOooo`00J?ooo`0306Ko
oooooooo00ooool00`1Vooooooooo`0Boooo00<0003oooooool04_ooo`03o`2Ioooooooo07Woool0
06Soool00`1Vooooooooo`0?oooo00@0I_ooool000000004oooo0P0000Coool200001Oooo`030000
oooooooo01;oool00ol0VOooooooo`1ioooo001Xoooo00<0I_ooooooool03oooo`0506Ko0000oooo
oooo000000Soool010000?ooooooo`0000Coool00`000?ooooooo`0Boooo00?o09Woooooool0NOoo
o`00J?oooa<0I_l010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`0001;oool00ol0VOoo
ooooo`1ioooo001koooo00@0003oooooool00009oooo0P0000Goool00`000?ooooooo`0Boooo00?o
09Woooooool0NOooo`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?oo
ooooo`0Boooo00?o09Woooooool0NOooo`00O?ooo`80000:oooo0`0000Coool00`000?ooooooo`0B
oooo00?o09Woooooool0NOooo`00Soooo`80000Coooo00?o09Woooooool0NOooo`00Soooo`030000
oooooooo01;oool00ol0VOooooooo`1ioooo002?oooo00<0003oooooool04_ooo`03o`2Ioooooooo
07Woool008ooool200004oooo`03o`2Ioooooooo07Woool008ooool00`000?ooooooo`0Boooo00?o
09Woooooool0NOooo`00Soooo`030000oooooooo01;oool00ol0VOooooooo`1ioooo002?oooo00<0
003oooooool04_ooo`03o`2Ioooooooo07Woool008ooool200004oooo`03o`2Ioooooooo07Woool0
08ooool00`000?ooooooo`0Boooo00?o09Woooooool0NOooo`00Soooo`030000oooooooo01;oool0
0ol0VOooooooo`1ioooo002?oooo00<0003oooooool04_ooo`03o`2Ioooooooo07Woool008ooool2
00004oooo`03o`2Ioooooooo07Woool008ooool00`000?ooooooo`0Boooo00?o09Woooooool0NOoo
o`00M_ooo`800004oooo0P0000Goool00`000?ooooooo`02oooo0P0000Goool00`000?ooooooo`0B
oooo00?o09Woooooool0NOooo`00MOooo`040000oooooooo00002_ooo`050000oooooooooooo0000
00;oool00`000?ooooooo`02oooo00<0003oooooool04_ooo`03o`2Ioooooooo07Woool007Goool0
10000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_ooo`<0000Boooo00?o
09Woooooool0NOooo`00MOooo`040000oooooooo00002oooo`040000oooooooooooo0P0000Goool0
0`000?ooooooo`0Boooo00?o09Woooooool0NOooo`00MOooo`040000oooooooo00002?ooo`040000
oooooooo00000oooo`030000oooooooo00Coool00`000?ooooooo`0Boooo00?o09Woooooool0NOoo
o`00M_ooo`800009oooo100000?oool300001?ooo`030000oooooooo01;oool00ol0VOooooooo`1i
oooo002?oooo0P0001?oool00ol0VOooooooo`1ioooo002?oooo00<0003oooooool04_ooo`03o`2I
oooooooo07Woool008ooool00`000?ooooooo`0Boooo00?o09Woooooool0NOooo`00Soooo`030000
oooooooo01;oool00ol0VOooooooo`1ioooo002?oooo0P0001?oool00ol0VOooooooo`1ioooo002?
oooo00<0003oooooool04_ooo`03o`2Ioooooooo07Woool008ooool00`000?ooooooo`0Boooo00?o
09Woooooool0NOooo`00Soooo`030000oooooooo01;oool00ol0VOooooooo`1ioooo002?oooo0P00
01?oool00ol0VOooooooo`1ioooo002?oooo00<0003oooooool04_ooo`03o`2Ioooooooo07Woool0
08ooool00`000?ooooooo`0Boooo00?o09Woooooool0NOooo`00Soooo`030000oooooooo01;oool0
0ol0VOooooooo`1ioooo002?oooo0P0001?oool00ol0VOooooooo`1ioooo002?oooo00<0003ooooo
ool04_ooo`03o`2Ioooooooo07Woool008Ooool500000oooo`030000oooooooo01;oool00ol0VOoo
ooooo`1ioooo0029oooo00<0003oooooool00oooo`030000oooooooo01;oool00ol0VOooooooo`1i
oooo0029oooo00<0003oooooool00oooo`<0000Boooo00?o09Woooooool0NOooo`00ROooo`030000
oooooooo09Coool008Woool00`000?ooooooo`2Doooo0028oooo0P0009Koool00?oooolQoooo003o
oooo8Oooo`00NOooo`030000oooooooo02Soool00`000?ooooooo`1ioooo001hoooo00<0003ooooo
ool02?ooo`030000oooooooo01ooool00`000?ooooooo`1hoooo001hoooo00<0003oooooool00_oo
o`800004oooo00<0003oooooool03Oooo`800004oooo0P0000Coool200001?ooo`030000oooooooo
07Soool007Soool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
00Coool400000oooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo
07Soool007Ooool00`000?ooooooo`02oooo00<0003oooooool04oooo`040000oooooooo00002_oo
o`030000oooooooo00?oool00`000?ooooooo`1goooo001hoooo00<0003oooooool01@0001;oool0
10000?ooooooo`0000_oool01@000?ooooooooooo`00001joooo001hoooo00D0003oooooooooool0
00005Oooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo07Soool0
07Woool00`000?ooooooo`0Goooo0P0000[oool200000oooo`030000oooooooo07Woool00?oooolQ
oooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.25) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.55838 .30902 L
.56817 .30902 L
.57861 .30902 L
.58157 .30902 L
.58436 .30902 L
.58686 .30902 L
.58755 .30902 L
.58827 .30902 L
s
.58827 .30902 m
.5884 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.32392 .30902 L
.33304 .30902 L
.33788 .30902 L
.34309 .30902 L
.34566 .30902 L
.34811 .30902 L
.34918 .30902 L
.35031 .30902 L
.35156 .46353 L
.35271 .46353 L
.36173 .46353 L
.3815 .46353 L
.39178 .46353 L
.39719 .46353 L
.40291 .46353 L
.40533 .46353 L
.40792 .46353 L
.40868 .46353 L
.40941 .46353 L
.41006 .46353 L
.41076 .30902 L
.41143 .30902 L
.41214 .30902 L
.41342 .30902 L
.42308 .30902 L
.46083 .30902 L
.50104 .30902 L
.53972 .30902 L
.58086 .30902 L
.62049 .30902 L
.65859 .30902 L
.69916 .30902 L
.7382 .30902 L
.7797 .30902 L
.81968 .30902 L
.85815 .30902 L
.89907 .30902 L
.93847 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.25) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`04oooo00<0
I_ooooooool01Oooo`030000oooooooo00Coool00`1Vooooooooo`05oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`04oooo00?o09Woooooool01Oooo`030000oooooooo
00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00goool00`000?oo
ooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo01Goool001Koool00`000?ooooooo`0j
oooo00<0003oooooool04oooo`0306Kooooooooo00coool00`1Vooooooooo`0Doooo00<0003ooooo
ool04oooo`03o`2Ioooooooo02?oool00`000?ooooooo`0joooo00<0003oooooool05Oooo`00JOoo
o`0306Kooooooooo00coool00`1Vooooooooo`0Doooo00<0003oooooool04oooo`03o`2Ioooooooo
07Soool006Woool00`1Vooooooooo`0<oooo00<0I_ooooooool05?ooo`80000Doooo00?o09Wooooo
ool0N?ooo`00JOooo`0306Kooooooooo00coool00`1Vooooooooo`0Doooo00<0003oooooool04ooo
o`03o`2Ioooooooo07Soool006Woool00`1Vooooooooo`0<oooo00<0I_ooooooool05?ooo`030000
oooooooo01?oool00ol0VOooooooo`1hoooo001Yoooo00<0I_ooooooool03?ooo`0306Kooooooooo
01Coool00`000?ooooooo`0Coooo00?o09Woooooool0N?ooo`00JOooo`0306Kooooooooo00coool0
0`1Vooooooooo`0Doooo0P0001Coool00ol0VOooooooo`1hoooo001Yoooo00<0I_ooooooool03?oo
o`0306Kooooooooo01Coool00`000?ooooooo`0Coooo00?o09Woooooool0N?ooo`00JOooo`0306Ko
oooooooo00coool00`1Vooooooooo`0Doooo00<0003oooooool04oooo`03o`2Ioooooooo07Soool0
06Woool00`1Vooooooooo`0<oooo00<0I_ooooooool05?ooo`030000oooooooo01?oool00ol0VOoo
ooooo`1hoooo001Yoooo00<0I_ooooooool03?ooo`0306Kooooooooo01Coool200005?ooo`03o`2I
oooooooo07Soool006Woool00`1Vooooooooo`0<oooo00<0I_ooooooool05?ooo`030000oooooooo
01?oool00ol0VOooooooo`1hoooo001Yoooo00<0I_ooooooool03?ooo`0306Kooooooooo01Coool0
0`000?ooooooo`0Coooo00?o09Woooooool0N?ooo`00JOooo`0306Kooooooooo00coool00`1Voooo
ooooo`0Doooo00<0003oooooool04oooo`03o`2Ioooooooo07Soool006Woool00`1Vooooooooo`0<
oooo00<0I_ooooooool05?ooo`80000Doooo00?o09Woooooool0N?ooo`00JOooo`0306Kooooooooo
00coool00`1Vooooooooo`0Doooo00<0003oooooool04oooo`03o`2Ioooooooo07Soool006Woool0
0`1Vooooooooo`0:oooo0P00000406Kooooooooooooo0P0000?oool400000oooo`800005oooo00<0
003oooooool04oooo`03o`2Ioooooooo07Soool006Woool00`1Vooooooooo`09oooo00@0003ooooo
ool00008oooo00<0003oooooool00oooo`040000oooooooo00001?ooo`030000oooooooo01?oool0
0ol0VOooooooo`1hoooo001Yoooo00<0I_ooooooool02Oooo`040000oooooooo00002Oooo`030000
oooooooo00Goool00`000?ooooooo`02oooo0`0001?oool00ol0VOooooooo`1hoooo001Yoooo00<0
I_ooooooool02Oooo`040000oooooooo00002_ooo`030000oooooooo00;oool200001Oooo`030000
oooooooo01?oool00ol0VOooooooo`1hoooo001Yoooo00<0I_ooooooool02Oooo`040000oooooooo
00002?ooo`040000oooooooo00000oooo`030000oooooooo00Coool00`000?ooooooo`0Coooo00?o
09Woooooool0N?ooo`00JOooo`0306Kooooooooo00[oool2000000<0I_ooooooool01oooo`800004
oooo0`0000Coool00`000?ooooooo`0Coooo00?o09Woooooool0N?ooo`00JOooo`0306Kooooooooo
00coool00`1Vooooooooo`0Doooo0P0001Coool00ol0VOooooooo`1hoooo001Yoooo00<0I_oooooo
ool03?ooo`0306Kooooooooo01Coool00`000?ooooooo`0Coooo00?o09Woooooool0N?ooo`00JOoo
o`0306Kooooooooo00coool00`1Vooooooooo`0Doooo00<0003oooooool04oooo`03o`2Ioooooooo
07Soool006Woool00`1Vooooooooo`0<oooo00<0I_ooooooool05?ooo`030000oooooooo01?oool0
0ol0VOooooooo`1hoooo001Yoooo00<0I_ooooooool03?ooo`0306Kooooooooo01Coool200005?oo
o`03o`2Ioooooooo07Soool006Woool00`1Vooooooooo`0<oooo00<0I_ooooooool05?ooo`030000
oooooooo01?oool00ol0VOooooooo`1hoooo001Yoooo00<0I_ooooooool03?ooo`0306Kooooooooo
01Coool00`000?ooooooo`0Coooo00?o09Woooooool0N?ooo`00JOooo`0306Kooooooooo00coool0
0`1Vooooooooo`0Doooo00<0003oooooool04oooo`03o`2Ioooooooo07Soool006Woool00`1Voooo
ooooo`0<oooo00<0I_ooooooool05?ooo`80000Doooo00?o09Woooooool0N?ooo`00JOooo`0306Ko
oooooooo00coool00`1Vooooooooo`0Doooo00<0003oooooool04oooo`03o`2Ioooooooo07Soool0
06Woool00`1Vooooooooo`0<oooo00<0I_ooooooool05?ooo`030000oooooooo01?oool00ol0VOoo
ooooo`1hoooo001Yoooo00<0I_ooooooool03?ooo`0306Kooooooooo01Coool00`000?ooooooo`0C
oooo00?o09Woooooool0N?ooo`00JOooo`0306Kooooooooo00coool00`1Vooooooooo`0Doooo0P00
01Coool00ol0VOooooooo`1hoooo001Yoooo00<0I_ooooooool03?ooo`0306Kooooooooo01Coool0
0`000?ooooooo`0Coooo00?o09Woooooool0N?ooo`00JOooo`0306Kooooooooo00coool0101Voooo
ooooooooo`800004oooo0P0000Coool200001Oooo`030000oooooooo01?oool00ol0VOooooooo`1h
oooo001Yoooo00<0I_ooooooool03?ooo`0406Kooooooooo00000_ooo`030000oooooooo00Koool0
10000?ooooooo`0000Coool00`000?ooooooo`0Coooo00?o09Woooooool0N?ooo`00JOoooa00I_l2
oooo00@0003oooooool0000;oooo00<0003oooooool00_ooo`<0000Coooo00?o09Woooooool0N?oo
o`00Noooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool04oooo`03o`2Ioooooooo
07Soool007_oool010000?ooooooo`0000Woool00`000?ooooooo`04oooo00<0003oooooool04ooo
o`03o`2Ioooooooo07Soool007coool200002_ooo`<00004oooo00<0003oooooool04oooo`03o`2I
oooooooo07Soool008ooool200005?ooo`03o`2Ioooooooo07Soool008ooool00`000?ooooooo`0C
oooo00?o09Woooooool0N?ooo`00Soooo`030000oooooooo01?oool00ol0VOooooooo`1hoooo002?
oooo0P0001Coool00ol0VOooooooo`1hoooo002?oooo00<0003oooooool04oooo`03o`2Ioooooooo
07Soool008ooool00`000?ooooooo`0Coooo00?o09Woooooool0N?ooo`00Soooo`030000oooooooo
01?oool00ol0VOooooooo`1hoooo002?oooo0P0001Coool00ol0VOooooooo`1hoooo002?oooo00<0
003oooooool04oooo`03o`2Ioooooooo07Soool008ooool00`000?ooooooo`0Coooo00?o09Wooooo
ool0N?ooo`00Soooo`030000oooooooo01?oool00ol0VOooooooo`1hoooo002?oooo0P0001Coool0
0ol0VOooooooo`1hoooo002?oooo00<0003oooooool04oooo`03o`2Ioooooooo07Soool007Koool2
00001?ooo`800005oooo00<0003oooooool00_ooo`800005oooo00<0003oooooool04oooo`03o`2I
oooooooo07Soool007Goool010000?ooooooo`0000[oool01@000?ooooooooooo`000002oooo00<0
003oooooool00_ooo`030000oooooooo01?oool00ol0VOooooooo`1hoooo001eoooo00@0003ooooo
ool0000:oooo00<0003oooooool01?ooo`030000oooooooo00;oool300004oooo`03o`2Ioooooooo
07Soool007Goool010000?ooooooo`0000_oool010000?ooooooooooo`800005oooo00<0003ooooo
ool04oooo`03o`2Ioooooooo07Soool007Goool010000?ooooooo`0000Soool010000?ooooooo`00
00?oool00`000?ooooooo`04oooo00<0003oooooool04oooo`03o`2Ioooooooo07Soool007Koool2
00002Oooo`@00003oooo0`0000Coool00`000?ooooooo`0Coooo00?o09Woooooool0N?ooo`00Sooo
o`80000Doooo00?o09Woooooool0N?ooo`00Soooo`030000oooooooo01?oool00ol0VOooooooo`1h
oooo002?oooo00<0003oooooool04oooo`03o`2Ioooooooo07Soool008ooool00`000?ooooooo`0C
oooo00?o09Woooooool0N?ooo`00Soooo`80000Doooo00?o09Woooooool0N?ooo`00Soooo`030000
oooooooo01?oool00ol0VOooooooo`1hoooo002?oooo00<0003oooooool04oooo`03o`2Ioooooooo
07Soool008ooool00`000?ooooooo`0Coooo00?o09Woooooool0N?ooo`00Soooo`80000Doooo00?o
09Woooooool0N?ooo`00Soooo`030000oooooooo01?oool00ol0VOooooooo`1hoooo002?oooo00<0
003oooooool04oooo`03o`2Ioooooooo07Soool008ooool00`000?ooooooo`0Coooo00?o09Wooooo
ool0N?ooo`00Soooo`80000Doooo00?o09Woooooool0N?ooo`00Soooo`030000oooooooo01?oool0
0ol0VOooooooo`1hoooo0027oooo1@0000?oool00`000?ooooooo`0Coooo00?o09Woooooool0N?oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`0Coooo00?o09Woooooool0N?ooo`00ROoo
o`030000oooooooo00?oool300004oooo`03o`2Ioooooooo07Soool008Woool00`000?ooooooo`2D
oooo0029oooo00<0003oooooool0U?ooo`00R?ooo`80002Foooo003ooooo8Oooo`00ooooob7oool0
07Koool00`000?ooooooo`0^oooo00<0003oooooool0M_ooo`00MOooo`030000oooooooo00Soool0
0`000?ooooooo`0Uoooo00<0003oooooool0MOooo`00MOooo`030000oooooooo00;oool200001?oo
o`030000oooooooo00goool200001?ooo`800003oooo100000?oool200001?ooo`030000oooooooo
07Goool007Goool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
00Coool400000oooo`040000oooooooo00002?ooo`030000oooooooo00?oool010000?ooooooo`00
00?oool00`000?ooooooo`1eoooo001doooo00<0003oooooool00_ooo`030000oooooooo01?oool0
10000?ooooooo`0000Woool00`000?ooooooo`05oooo00<0003oooooool00_ooo`030000oooooooo
07Coool007Goool00`000?ooooooo`0500004_ooo`040000oooooooo00002_ooo`030000oooooooo
00;oool200001?ooo`030000oooooooo07Goool007Goool01@000?ooooooooooo`00000Eoooo00@0
003oooooool00008oooo00@0003oooooool00003oooo00<0003oooooool00oooo`030000oooooooo
07Goool007Koool00`000?ooooooo`0Goooo0P0000[oool200001?ooo`<00002oooo00<0003ooooo
ool0M_ooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.55838 .30902 L
.57861 .30902 L
.58392 .30902 L
.58957 .30902 L
.59232 .30902 L
.59367 .30902 L
.59491 .30902 L
s
.59491 .30902 m
.59502 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.32392 .30902 L
.33304 .30902 L
.34309 .30902 L
.34772 .30902 L
.35028 .30902 L
.35271 .30902 L
.35496 .30902 L
.35624 .30902 L
.35742 .46353 L
.35852 .46353 L
.35951 .46353 L
.36173 .46353 L
.3815 .46353 L
.39086 .46353 L
.39597 .46353 L
.40075 .46353 L
.40324 .46353 L
.40396 .46353 L
.40464 .46353 L
.40592 .30902 L
.4066 .30902 L
.40733 .30902 L
.40863 .30902 L
.41159 .30902 L
.42157 .30902 L
.45932 .30902 L
.49952 .30902 L
.53821 .30902 L
.57935 .30902 L
.61897 .30902 L
.65708 .30902 L
.69764 .30902 L
.73669 .30902 L
.77818 .30902 L
.81817 .30902 L
.85663 .30902 L
.89755 .30902 L
.93695 .30902 L
.97484 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`06oooo00<0
I_ooooooool00oooo`030000oooooooo00?oool00`1Vooooooooo`06oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`06oooo00?o09Woooooool00oooo`030000oooooooo
00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00goool00`000?oo
ooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo01Goool001Koool00`000?ooooooo`0j
oooo00<0003oooooool05Oooo`0306Kooooooooo00Woool00`1Vooooooooo`0Eoooo00<0003ooooo
ool05Oooo`03o`2Ioooooooo027oool00`000?ooooooo`0joooo00<0003oooooool05Oooo`00Jooo
o`0306Kooooooooo00Woool00`1Vooooooooo`0Eoooo00<0003oooooool05Oooo`03o`2Ioooooooo
07Koool006_oool00`1Vooooooooo`09oooo00<0I_ooooooool05Oooo`80000Foooo00?o09Wooooo
ool0M_ooo`00Joooo`0306Kooooooooo00Woool00`1Vooooooooo`0Eoooo00<0003oooooool05Ooo
o`03o`2Ioooooooo07Koool006_oool00`1Vooooooooo`09oooo00<0I_ooooooool05Oooo`030000
oooooooo01Goool00ol0VOooooooo`1foooo001[oooo00<0I_ooooooool02Oooo`0306Kooooooooo
01Goool00`000?ooooooo`0Eoooo00?o09Woooooool0M_ooo`00Joooo`0306Kooooooooo00Woool0
0`1Vooooooooo`0Eoooo0P0001Koool00ol0VOooooooo`1foooo001[oooo00<0I_ooooooool02Ooo
o`0306Kooooooooo01Goool00`000?ooooooo`0Eoooo00?o09Woooooool0M_ooo`00Joooo`0306Ko
oooooooo00Woool00`1Vooooooooo`0Eoooo00<0003oooooool05Oooo`03o`2Ioooooooo07Koool0
06_oool00`1Vooooooooo`09oooo00<0I_ooooooool05Oooo`030000oooooooo01Goool00ol0VOoo
ooooo`1foooo001[oooo00<0I_ooooooool02Oooo`0306Kooooooooo01Goool200005_ooo`03o`2I
oooooooo07Koool006_oool00`1Vooooooooo`09oooo00<0I_ooooooool05Oooo`030000oooooooo
01Goool00ol0VOooooooo`1foooo001[oooo00<0I_ooooooool02Oooo`0306Kooooooooo01Goool0
0`000?ooooooo`0Eoooo00?o09Woooooool0M_ooo`00Joooo`0306Kooooooooo00Woool00`1Voooo
ooooo`0Eoooo00<0003oooooool05Oooo`03o`2Ioooooooo07Koool006_oool00`1Vooooooooo`09
oooo00<0I_ooooooool05Oooo`80000Foooo00?o09Woooooool0M_ooo`00Joooo`0306Kooooooooo
00Woool00`1Vooooooooo`0Eoooo00<0003oooooool05Oooo`03o`2Ioooooooo07Koool006_oool0
0`1Vooooooooo`08oooo0P0000Coool200000oooo`@00003oooo0P0000Goool00`000?ooooooo`0E
oooo00?o09Woooooool0M_ooo`00Joooo`0306Kooooooooo00Ooool010000?ooo`1Vo`0000Soool0
0`000?ooooooo`03oooo00@0003oooooool00004oooo00<0003oooooool05Oooo`03o`2Ioooooooo
07Koool006_oool00`1Vooooooooo`07oooo00@0003oool0I_l00009oooo00<0003oooooool01Ooo
o`030000oooooooo00;oool300005Oooo`03o`2Ioooooooo07Koool006_oool00`1Vooooooooo`07
oooo00@0003oool0I_l0000:oooo00<0003oooooool00_ooo`800005oooo00<0003oooooool05Ooo
o`03o`2Ioooooooo07Koool006_oool00`1Vooooooooo`07oooo00@0003oool0I_l00008oooo00@0
003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo01Goool00ol0VOooooooo`1f
oooo001[oooo00<0I_ooooooool02?ooo`80000:oooo0P0000Coool300001?ooo`030000oooooooo
01Goool00ol0VOooooooo`1foooo001[oooo00<0I_ooooooool02Oooo`0306Kooooooooo01Goool2
00005_ooo`03o`2Ioooooooo07Koool006_oool00`1Vooooooooo`09oooo00<0I_ooooooool05Ooo
o`030000oooooooo01Goool00ol0VOooooooo`1foooo001[oooo00<0I_ooooooool02Oooo`0306Ko
oooooooo01Goool00`000?ooooooo`0Eoooo00?o09Woooooool0M_ooo`00Joooo`0306Kooooooooo
00Woool00`1Vooooooooo`0Eoooo00<0003oooooool05Oooo`03o`2Ioooooooo07Koool006_oool0
0`1Vooooooooo`09oooo00<0I_ooooooool05Oooo`80000Foooo00?o09Woooooool0M_ooo`00Jooo
o`0306Kooooooooo00Woool00`1Vooooooooo`0Eoooo00<0003oooooool05Oooo`03o`2Ioooooooo
07Koool006_oool00`1Vooooooooo`09oooo00<0I_ooooooool05Oooo`030000oooooooo01Goool0
0ol0VOooooooo`1foooo001[oooo00<0I_ooooooool02Oooo`0306Kooooooooo01Goool00`000?oo
ooooo`0Eoooo00?o09Woooooool0M_ooo`00Joooo`0306Kooooooooo00Woool00`1Vooooooooo`0E
oooo0P0001Koool00ol0VOooooooo`1foooo001[oooo00<0I_ooooooool02Oooo`0306Kooooooooo
01Goool00`000?ooooooo`0Eoooo00?o09Woooooool0M_ooo`00Joooo`0306Kooooooooo00Woool0
0`1Vooooooooo`0Eoooo00<0003oooooool05Oooo`03o`2Ioooooooo07Koool006_oool00`1Voooo
ooooo`09oooo00<0I_ooooooool05Oooo`030000oooooooo01Goool00ol0VOooooooo`1foooo001[
oooo00<0I_ooooooool02Oooo`0306Kooooooooo01Goool200005_ooo`03o`2Ioooooooo07Koool0
06_oool00`1Vooooooooo`09oooo00<0I_ooooooool05Oooo`030000oooooooo01Goool00ol0VOoo
ooooo`1foooo001[oooo00<0I_ooooooool02Oooo`0306Kooooooooo00;oool200001?ooo`800004
oooo0P0000Goool00`000?ooooooo`0Eoooo00?o09Woooooool0M_ooo`00Joooo`0306Kooooooooo
00Woool01@1Vooooooooooooo`000002oooo00<0003oooooool01_ooo`040000oooooooo00001?oo
o`030000oooooooo01Goool00ol0VOooooooo`1foooo001[oooo3@1Vo`?oool010000?ooooooo`00
00_oool00`000?ooooooo`02oooo0`0001Goool00ol0VOooooooo`1foooo001koooo00@0003ooooo
ool00009oooo0P0000Goool00`000?ooooooo`0Eoooo00?o09Woooooool0M_ooo`00Noooo`040000
oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`0Eoooo00?o09Woooooool0M_oo
o`00O?ooo`80000:oooo0`0000Coool00`000?ooooooo`0Eoooo00?o09Woooooool0M_ooo`00Sooo
o`80000Foooo00?o09Woooooool0M_ooo`00Soooo`030000oooooooo01Goool00ol0VOooooooo`1f
oooo002?oooo00<0003oooooool05Oooo`03o`2Ioooooooo07Koool008ooool200005_ooo`03o`2I
oooooooo07Koool008ooool00`000?ooooooo`0Eoooo00?o09Woooooool0M_ooo`00Soooo`030000
oooooooo01Goool00ol0VOooooooo`1foooo002?oooo00<0003oooooool05Oooo`03o`2Ioooooooo
07Koool008ooool200005_ooo`03o`2Ioooooooo07Koool008ooool00`000?ooooooo`0Eoooo00?o
09Woooooool0M_ooo`00Soooo`030000oooooooo01Goool00ol0VOooooooo`1foooo002?oooo00<0
003oooooool05Oooo`03o`2Ioooooooo07Koool008ooool200005_ooo`03o`2Ioooooooo07Koool0
08ooool00`000?ooooooo`0Eoooo00?o09Woooooool0M_ooo`00M_ooo`800004oooo0P0000Goool0
0`000?ooooooo`02oooo0P0000Goool00`000?ooooooo`0Eoooo00?o09Woooooool0M_ooo`00MOoo
o`040000oooooooo00002_ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0
003oooooool05Oooo`03o`2Ioooooooo07Koool007Goool010000?ooooooo`0000[oool00`000?oo
ooooo`04oooo00<0003oooooool00_ooo`<0000Eoooo00?o09Woooooool0M_ooo`00MOooo`040000
oooooooo00002oooo`040000oooooooooooo0P0000Goool00`000?ooooooo`0Eoooo00?o09Wooooo
ool0M_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo
00Coool00`000?ooooooo`0Eoooo00?o09Woooooool0M_ooo`00M_ooo`800009oooo100000?oool3
00001?ooo`030000oooooooo01Goool00ol0VOooooooo`1foooo002?oooo0P0001Koool00ol0VOoo
ooooo`1foooo002?oooo00<0003oooooool05Oooo`03o`2Ioooooooo07Koool008ooool00`000?oo
ooooo`0Eoooo00?o09Woooooool0M_ooo`00Soooo`030000oooooooo01Goool00ol0VOooooooo`1f
oooo002?oooo0P0001Koool00ol0VOooooooo`1foooo002?oooo00<0003oooooool05Oooo`03o`2I
oooooooo07Koool008ooool00`000?ooooooo`0Eoooo00?o09Woooooool0M_ooo`00Soooo`030000
oooooooo01Goool00ol0VOooooooo`1foooo002?oooo0P0001Koool00ol0VOooooooo`1foooo002?
oooo00<0003oooooool05Oooo`03o`2Ioooooooo07Koool008ooool00`000?ooooooo`0Eoooo00?o
09Woooooool0M_ooo`00Soooo`030000oooooooo01Goool00ol0VOooooooo`1foooo002?oooo0P00
01Koool00ol0VOooooooo`1foooo002?oooo00<0003oooooool05Oooo`03o`2Ioooooooo07Koool0
08Ooool500000oooo`030000oooooooo01Goool00ol0VOooooooo`1foooo0029oooo00<0003ooooo
ool00oooo`030000oooooooo01Goool00ol0VOooooooo`1foooo0029oooo00<0003oooooool00ooo
o`<0000Eoooo00?o09Woooooool0M_ooo`00ROooo`030000oooooooo09Coool008Woool00`000?oo
ooooo`2Doooo0028oooo0P0009Koool00?oooolQoooo003ooooo8Oooo`00NOooo`030000oooooooo
02Soool00`000?ooooooo`1ioooo001hoooo00<0003oooooool02?ooo`030000oooooooo01ooool0
0`000?ooooooo`1hoooo001hoooo00<0003oooooool00_ooo`800004oooo00<0003oooooool03Ooo
o`800004oooo0P0000?oool400000oooo`030000oooooooo07Soool007Soool01@000?oooooooooo
o`000002oooo00<0003oooooool00_ooo`030000oooooooo00Coool400000oooo`040000oooooooo
00002?ooo`030000oooooooo00Coool00`000?ooooooo`1hoooo001goooo00<0003oooooool00_oo
o`030000oooooooo01?oool010000?ooooooo`0000Woool00`000?ooooooo`04oooo00<0003ooooo
ool0Moooo`00N?ooo`030000oooooooo00D0000Boooo00@0003oooooool0000:oooo00<0003ooooo
ool00_ooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`00000Eoooo00@0003ooooo
ool00008oooo00@0003oooooool00003oooo00<0003oooooool0N?ooo`00NOooo`030000oooooooo
01Ooool200002_ooo`800003oooo00<0003oooooool0NOooo`00ooooob7oool00?oooolQoooo0000
\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.15) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.58872 .30902 L
.59405 .30902 L
.59698 .30902 L
.59842 .30902 L
.59975 .30902 L
.60102 .30902 L
s
.60102 .30902 m
.60109 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.32392 .30902 L
.34309 .30902 L
.35271 .30902 L
.35742 .30902 L
.35948 .30902 L
.36173 .30902 L
.36294 .30902 L
.36405 .46353 L
.36512 .46353 L
.36626 .46353 L
.37114 .46353 L
.3815 .46353 L
.39178 .46353 L
.3946 .46353 L
.39614 .46353 L
.39758 .46353 L
.39881 .46353 L
.40012 .30902 L
.40087 .30902 L
.40158 .30902 L
.40291 .30902 L
.42308 .30902 L
.46141 .30902 L
.50219 .30902 L
.54146 .30902 L
.57921 .30902 L
.61941 .30902 L
.6581 .30902 L
.69924 .30902 L
.73886 .30902 L
.77697 .30902 L
.81753 .30902 L
.85658 .30902 L
.89808 .30902 L
.93806 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.15) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`07oooo00<0
I_ooooooool00_ooo`030000oooooooo00;oool00`1Vooooooooo`07oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`08oooo00Go09Woooooooooool000003_ooo`030000
oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo00coool0
0`000?ooooooo`0<oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo03[oool00`000?oo
ooooo`0Foooo00<0I_ooooooool01oooo`0306Kooooooooo01Koool00`000?ooooooo`0Goooo00?o
09Woooooool07oooo`030000oooooooo03[oool00`000?ooooooo`0Eoooo001/oooo00<0I_oooooo
ool01oooo`0306Kooooooooo01Koool00`000?ooooooo`0Goooo00?o09Woooooool0M?ooo`00K?oo
o`0306Kooooooooo00Ooool00`1Vooooooooo`0Foooo0P0001Soool00ol0VOooooooo`1doooo001/
oooo00<0I_ooooooool01oooo`0306Kooooooooo01Koool00`000?ooooooo`0Goooo00?o09Wooooo
ool0M?ooo`00K?ooo`0306Kooooooooo00Ooool00`1Vooooooooo`0Foooo00<0003oooooool05ooo
o`03o`2Ioooooooo07Coool006coool00`1Vooooooooo`07oooo00<0I_ooooooool05_ooo`030000
oooooooo01Ooool00ol0VOooooooo`1doooo001/oooo00<0I_ooooooool01oooo`0306Kooooooooo
01Koool200006?ooo`03o`2Ioooooooo07Coool006coool00`1Vooooooooo`07oooo00<0I_oooooo
ool05_ooo`030000oooooooo01Ooool00ol0VOooooooo`1doooo001/oooo00<0I_ooooooool01ooo
o`0306Kooooooooo01Koool00`000?ooooooo`0Goooo00?o09Woooooool0M?ooo`00K?ooo`0306Ko
oooooooo00Ooool00`1Vooooooooo`0Foooo00<0003oooooool05oooo`03o`2Ioooooooo07Coool0
06coool00`1Vooooooooo`07oooo00<0I_ooooooool05_ooo`80000Hoooo00?o09Woooooool0M?oo
o`00K?ooo`0306Kooooooooo00Ooool00`1Vooooooooo`0Foooo00<0003oooooool05oooo`03o`2I
oooooooo07Coool006coool00`1Vooooooooo`07oooo00<0I_ooooooool05_ooo`030000oooooooo
01Ooool00ol0VOooooooo`1doooo001/oooo00<0I_ooooooool01oooo`0306Kooooooooo01Koool0
0`000?ooooooo`0Goooo00?o09Woooooool0M?ooo`00K?ooo`0306Kooooooooo00Ooool00`1Voooo
ooooo`0Foooo0P0001Soool00ol0VOooooooo`1doooo001/oooo00<0I_ooooooool01oooo`0306Ko
oooooooo01Koool00`000?ooooooo`0Goooo00?o09Woooooool0M?ooo`00K?ooo`0306Kooooooooo
00Ooool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo01Ooool00ol0VOoo
ooooo`1doooo001/oooo00<0I_ooooooool01_ooo`04000006Kooooo00002?ooo`030000oooooooo
00?oool010000?ooooooo`0000Coool00`000?ooooooo`0Goooo00?o09Woooooool0M?ooo`00K?oo
o`0306Kooooooooo00Koool010000?ooooooo`0000Woool00`000?ooooooo`05oooo00<0003ooooo
ool00_ooo`<0000Goooo00?o09Woooooool0M?ooo`00KOooo`0306Kooooooooo00Goool010000?oo
ooooo`0000[oool00`000?ooooooo`02oooo0P0000Goool00`000?ooooooo`0Goooo00?o09Wooooo
ool0M?ooo`00KOooo`0306Kooooooooo00Goool010000?ooooooo`0000Soool010000?ooooooo`00
00?oool00`000?ooooooo`04oooo00<0003oooooool05oooo`03o`2Ioooooooo07Coool006goool0
0`1Vooooooooo`05oooo00<0I_l0000000002_ooo`800004oooo0`0000Coool00`000?ooooooo`0G
oooo00?o09Woooooool0M?ooo`00KOooo`0306Kooooooooo00Goool00`1Vooooooooo`0Goooo0P00
01Soool00ol0VOooooooo`1doooo001]oooo00<0I_ooooooool01Oooo`0306Kooooooooo01Ooool0
0`000?ooooooo`0Goooo00?o09Woooooool0M?ooo`00KOooo`0306Kooooooooo00Goool00`1Voooo
ooooo`0Goooo00<0003oooooool05oooo`03o`2Ioooooooo07Coool006goool00`1Vooooooooo`05
oooo00<0I_ooooooool05oooo`030000oooooooo01Ooool00ol0VOooooooo`1doooo001]oooo00<0
I_ooooooool01Oooo`0306Kooooooooo01Ooool200006?ooo`03o`2Ioooooooo07Coool006goool0
0`1Vooooooooo`05oooo00<0I_ooooooool05oooo`030000oooooooo01Ooool00ol0VOooooooo`1d
oooo001]oooo00<0I_ooooooool01Oooo`0306Kooooooooo01Ooool00`000?ooooooo`0Goooo00?o
09Woooooool0M?ooo`00KOooo`0306Kooooooooo00Goool00`1Vooooooooo`0Goooo00<0003ooooo
ool05oooo`03o`2Ioooooooo07Coool006goool00`1Vooooooooo`05oooo00<0I_ooooooool05ooo
o`80000Hoooo00?o09Woooooool0M?ooo`00KOooo`0306Kooooooooo00Goool00`1Vooooooooo`0G
oooo00<0003oooooool05oooo`03o`2Ioooooooo07Coool006goool00`1Vooooooooo`05oooo00<0
I_ooooooool05oooo`030000oooooooo01Ooool00ol0VOooooooo`1doooo001]oooo00<0I_oooooo
ool01Oooo`0306Kooooooooo01Ooool00`000?ooooooo`0Goooo00?o09Woooooool0M?ooo`00KOoo
o`0306Kooooooooo00Goool00`1Vooooooooo`0Goooo0P0001Soool00ol0VOooooooo`1doooo001]
oooo00<0I_ooooooool01Oooo`0306Kooooooooo01Ooool00`000?ooooooo`0Goooo00?o09Wooooo
ool0M?ooo`00KOooo`0306Kooooooooo00Goool00`1Vooooooooo`04oooo0P0000Coool200001?oo
o`800005oooo00<0003oooooool05oooo`03o`2Ioooooooo07Coool006goool00`1Vooooooooo`05
oooo00<0I_ooooooool00oooo`040000oooooooo00002?ooo`040000oooooooo00001?ooo`030000
oooooooo01Ooool00ol0VOooooooo`1doooo001]oooo2@1Vo`Goool010000?ooooooo`0000_oool0
0`000?ooooooo`02oooo0`0001Ooool00ol0VOooooooo`1doooo001koooo00@0003oooooool00009
oooo0P0000Goool00`000?ooooooo`0Goooo00?o09Woooooool0M?ooo`00Noooo`040000oooooooo
00002Oooo`030000oooooooo00Coool00`000?ooooooo`0Goooo00?o09Woooooool0M?ooo`00O?oo
o`80000:oooo0`0000Coool00`000?ooooooo`0Goooo00?o09Woooooool0M?ooo`00Soooo`80000H
oooo00?o09Woooooool0M?ooo`00Soooo`030000oooooooo01Ooool00ol0VOooooooo`1doooo002?
oooo00<0003oooooool05oooo`03o`2Ioooooooo07Coool008ooool200006?ooo`03o`2Ioooooooo
07Coool008ooool00`000?ooooooo`0Goooo00?o09Woooooool0M?ooo`00Soooo`030000oooooooo
01Ooool00ol0VOooooooo`1doooo002?oooo00<0003oooooool05oooo`03o`2Ioooooooo07Coool0
08ooool200006?ooo`03o`2Ioooooooo07Coool008ooool00`000?ooooooo`0Goooo00?o09Wooooo
ool0M?ooo`00Soooo`030000oooooooo01Ooool00ol0VOooooooo`1doooo002?oooo00<0003ooooo
ool05oooo`03o`2Ioooooooo07Coool008ooool200006?ooo`03o`2Ioooooooo07Coool008ooool0
0`000?ooooooo`0Goooo00?o09Woooooool0M?ooo`00M_ooo`800004oooo0P0000Goool00`000?oo
ooooo`02oooo0P0000Goool00`000?ooooooo`0Goooo00?o09Woooooool0M?ooo`00MOooo`040000
oooooooo00002_ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003ooooo
ool05oooo`03o`2Ioooooooo07Coool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04
oooo00<0003oooooool00_ooo`<0000Goooo00?o09Woooooool0M?ooo`00MOooo`040000oooooooo
00002oooo`040000oooooooooooo0P0000Goool00`000?ooooooo`0Goooo00?o09Woooooool0M?oo
o`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo00Coool0
0`000?ooooooo`0Goooo00?o09Woooooool0M?ooo`00M_ooo`800009oooo100000?oool300001?oo
o`030000oooooooo01Ooool00ol0VOooooooo`1doooo002?oooo0P0001Soool00ol0VOooooooo`1d
oooo002?oooo00<0003oooooool05oooo`03o`2Ioooooooo07Coool008ooool00`000?ooooooo`0G
oooo00?o09Woooooool0M?ooo`00Soooo`030000oooooooo01Ooool00ol0VOooooooo`1doooo002?
oooo0P0001Soool00ol0VOooooooo`1doooo002?oooo00<0003oooooool05oooo`03o`2Ioooooooo
07Coool008ooool00`000?ooooooo`0Goooo00?o09Woooooool0M?ooo`00Soooo`030000oooooooo
01Ooool00ol0VOooooooo`1doooo002?oooo0P0001Soool00ol0VOooooooo`1doooo002?oooo00<0
003oooooool05oooo`03o`2Ioooooooo07Coool008ooool00`000?ooooooo`0Goooo00?o09Wooooo
ool0M?ooo`00Soooo`030000oooooooo01Ooool00ol0VOooooooo`1doooo002?oooo0P0001Soool0
0ol0VOooooooo`1doooo002?oooo00<0003oooooool05oooo`03o`2Ioooooooo07Coool008Ooool5
00000oooo`030000oooooooo01Ooool00ol0VOooooooo`1doooo0029oooo00<0003oooooool00ooo
o`030000oooooooo01Ooool00ol0VOooooooo`1doooo0029oooo00<0003oooooool00oooo`<0000G
oooo00?o09Woooooool0M?ooo`00ROooo`030000oooooooo09Coool008Woool00`000?ooooooo`2D
oooo0028oooo0P0009Koool00?oooolQoooo003ooooo8Oooo`00M_ooo`030000oooooooo02koool0
0`000?ooooooo`1foooo001eoooo00<0003oooooool02?ooo`030000oooooooo02Goool00`000?oo
ooooo`1eoooo001eoooo00<0003oooooool00_ooo`800004oooo00<0003oooooool03Oooo`800004
oooo0P0000?oool500000_ooo`800004oooo00<0003oooooool0MOooo`00MOooo`050000oooooooo
oooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003ooooo
ool0000:oooo00D0003oooooooooool000000_ooo`050000oooooooooooo000007Ooool007Coool0
0`000?ooooooo`02oooo00<0003oooooool04oooo`040000oooooooo00002_ooo`030000oooooooo
00Coool00`000?ooooooo`02oooo00<0003oooooool0M?ooo`00MOooo`030000oooooooo00D0000B
oooo00@0003oooooool0000:oooo00<0003oooooool00_ooo`800004oooo00<0003oooooool0MOoo
o`00MOooo`050000oooooooooooo000001Goool010000?ooooooo`0000[oool00`000?ooooooo`02
oooo00<0003oooooool00oooo`030000oooooooo07Goool007Koool00`000?ooooooo`0Goooo0P00
00[oool200001?ooo`<00002oooo00<0003oooooool0M_ooo`00ooooob7oool00?oooolQoooo0000
\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.58872 .30902 L
.59405 .30902 L
.59975 .30902 L
.60256 .30902 L
.60394 .30902 L
.60521 .30902 L
.60637 .30902 L
s
.60637 .30902 m
.60649 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.32392 .30902 L
.34309 .30902 L
.35271 .30902 L
.36173 .30902 L
.36626 .30902 L
.36757 .30902 L
.36881 .30902 L
.36992 .46353 L
.37114 .46353 L
.3815 .46353 L
.38681 .46353 L
.38942 .46353 L
.39056 .46353 L
.39182 .46353 L
.39295 .30902 L
.394 .30902 L
.39631 .30902 L
.40117 .30902 L
.42214 .30902 L
.46105 .30902 L
.50241 .30902 L
.54226 .30902 L
.58059 .30902 L
.62137 .30902 L
.66064 .30902 L
.69839 .30902 L
.73859 .30902 L
.77728 .30902 L
.81842 .30902 L
.85804 .30902 L
.89615 .30902 L
.93671 .30902 L
.97576 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`09oooo00@0
I_ooooooool00002oooo00<0I_ooooooool02Oooo`030000oooooooo00coool00`000?ooooooo`0<
oooo00<0003oooooool02Oooo`04o`2Ioooooooo00003_ooo`030000oooooooo00coool00`000?oo
ooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0
003oooooool05Oooo`005_ooo`030000oooooooo03[oool00`000?ooooooo`0Hoooo00<0I_oooooo
ool00oooo`0306Kooooooooo01Soool00`000?ooooooo`0Hoooo00?o09Woooooool07_ooo`030000
oooooooo03[oool00`000?ooooooo`0Eoooo001^oooo00<0I_ooooooool00oooo`0306Kooooooooo
01Soool00`000?ooooooo`0Hoooo00?o09Woooooool0Loooo`00K_ooo`0306Kooooooooo00?oool0
0`1Vooooooooo`0Hoooo0P0001Woool00ol0VOooooooo`1coooo001^oooo00<0I_ooooooool00ooo
o`0306Kooooooooo01Soool00`000?ooooooo`0Hoooo00?o09Woooooool0Loooo`00K_ooo`0306Ko
oooooooo00?oool00`1Vooooooooo`0Hoooo00<0003oooooool06?ooo`03o`2Ioooooooo07?oool0
06koool00`1Vooooooooo`03oooo00<0I_ooooooool06?ooo`030000oooooooo01Soool00ol0VOoo
ooooo`1coooo001^oooo00<0I_ooooooool00oooo`0306Kooooooooo01Soool200006Oooo`03o`2I
oooooooo07?oool006koool00`1Vooooooooo`03oooo00<0I_ooooooool06?ooo`030000oooooooo
01Soool00ol0VOooooooo`1coooo001^oooo00<0I_ooooooool00oooo`0306Kooooooooo01Soool0
0`000?ooooooo`0Hoooo00?o09Woooooool0Loooo`00K_ooo`0306Kooooooooo00?oool00`1Voooo
ooooo`0Hoooo00<0003oooooool06?ooo`03o`2Ioooooooo07?oool006koool00`1Vooooooooo`03
oooo00<0I_ooooooool06?ooo`80000Ioooo00?o09Woooooool0Loooo`00K_ooo`0306Kooooooooo
00?oool00`1Vooooooooo`0Hoooo00<0003oooooool06?ooo`03o`2Ioooooooo07?oool006koool0
0`1Vooooooooo`03oooo00<0I_ooooooool06?ooo`030000oooooooo01Soool00ol0VOooooooo`1c
oooo001^oooo00<0I_ooooooool00oooo`0306Kooooooooo01Soool00`000?ooooooo`0Hoooo00?o
09Woooooool0Loooo`00K_ooo`0306Kooooooooo00?oool00`1Vooooooooo`0Hoooo0P0001Woool0
0ol0VOooooooo`1coooo001^oooo00<0I_ooooooool00oooo`0306Kooooooooo01Soool00`000?oo
ooooo`0Hoooo00?o09Woooooool0Loooo`00K_ooo`0306Kooooooooo00?oool0101Vooooo`000000
00Coool200000oooo`@00003oooo0P0000Goool00`000?ooooooo`0Hoooo00?o09Woooooool0Looo
o`00K_ooo`0306Kooooooooo00?oool01@1Vo`000?ooooooo`000008oooo00<0003oooooool00ooo
o`040000oooooooo00001?ooo`030000oooooooo01Soool00ol0VOooooooo`1coooo001^oooo00<0
I_ooooooool00oooo`0506Ko0000oooooooo000000Woool00`000?ooooooo`05oooo00<0003ooooo
ool00_ooo`<0000Hoooo00?o09Woooooool0Loooo`00K_ooo`0306Kooooooooo00?oool01@1Vo`00
0?ooooooo`00000:oooo00<0003oooooool00_ooo`800005oooo00<0003oooooool06?ooo`03o`2I
oooooooo07?oool006koool00`1Vooooooooo`03oooo00D0I_l0003oooooool000002?ooo`040000
oooooooo00000oooo`030000oooooooo00Coool00`000?ooooooo`0Hoooo00?o09Woooooool0Looo
o`00K_ooo`0306Kooooooooo00?oool0101Vooooo`00000000[oool200001?ooo`<00004oooo00<0
003oooooool06?ooo`03o`2Ioooooooo07?oool006koool00`1Vooooooooo`03oooo00<0I_oooooo
ool06?ooo`80000Ioooo00?o09Woooooool0Loooo`00K_ooo`0306Kooooooooo00?oool00`1Voooo
ooooo`0Hoooo00<0003oooooool06?ooo`03o`2Ioooooooo07?oool006koool00`1Vooooooooo`03
oooo00<0I_ooooooool06?ooo`030000oooooooo01Soool00ol0VOooooooo`1coooo001^oooo00<0
I_ooooooool00oooo`0306Kooooooooo01Soool00`000?ooooooo`0Hoooo00?o09Woooooool0Looo
o`00K_ooo`0306Kooooooooo00?oool00`1Vooooooooo`0Hoooo0P0001Woool00ol0VOooooooo`1c
oooo001^oooo00<0I_ooooooool00oooo`0306Kooooooooo01Soool00`000?ooooooo`0Hoooo00?o
09Woooooool0Loooo`00K_ooo`0306Kooooooooo00?oool00`1Vooooooooo`0Hoooo00<0003ooooo
ool06?ooo`03o`2Ioooooooo07?oool006koool00`1Vooooooooo`03oooo00<0I_ooooooool06?oo
o`030000oooooooo01Soool00ol0VOooooooo`1coooo001^oooo00<0I_ooooooool00oooo`0306Ko
oooooooo01Soool200006Oooo`03o`2Ioooooooo07?oool006koool00`1Vooooooooo`03oooo00<0
I_ooooooool06?ooo`030000oooooooo01Soool00ol0VOooooooo`1coooo001^oooo00<0I_oooooo
ool00oooo`0306Kooooooooo01Soool00`000?ooooooo`0Hoooo00?o09Woooooool0Loooo`00K_oo
o`0306Kooooooooo00?oool00`1Vooooooooo`0Hoooo00<0003oooooool06?ooo`03o`2Ioooooooo
07?oool006koool00`1Vooooooooo`03oooo00<0I_ooooooool06?ooo`80000Ioooo00?o09Wooooo
ool0Loooo`00K_ooo`0306Kooooooooo00?oool00`1Vooooooooo`0Hoooo00<0003oooooool06?oo
o`03o`2Ioooooooo07?oool006koool00`1Vooooooooo`03oooo00<0I_ooooooool01Oooo`800004
oooo0P0000Coool200001Oooo`030000oooooooo01Soool00ol0VOooooooo`1coooo001^oooo00<0
I_ooooooool00oooo`0306Kooooooooo00Coool010000?ooooooo`0000Soool010000?ooooooo`00
00Coool00`000?ooooooo`0Hoooo00?o09Woooooool0Loooo`00K_ooo`L0I_l6oooo00@0003ooooo
ool0000;oooo00<0003oooooool00_ooo`<0000Hoooo00?o09Woooooool0Loooo`00Noooo`040000
oooooooo00002Oooo`800005oooo00<0003oooooool06?ooo`03o`2Ioooooooo07?oool007_oool0
10000?ooooooo`0000Woool00`000?ooooooo`04oooo00<0003oooooool06?ooo`03o`2Ioooooooo
07?oool007coool200002_ooo`<00004oooo00<0003oooooool06?ooo`03o`2Ioooooooo07?oool0
08ooool200006Oooo`03o`2Ioooooooo07?oool008ooool00`000?ooooooo`0Hoooo00?o09Wooooo
ool0Loooo`00Soooo`030000oooooooo01Soool00ol0VOooooooo`1coooo002?oooo0P0001Woool0
0ol0VOooooooo`1coooo002?oooo00<0003oooooool06?ooo`03o`2Ioooooooo07?oool008ooool0
0`000?ooooooo`0Hoooo00?o09Woooooool0Loooo`00Soooo`030000oooooooo01Soool00ol0VOoo
ooooo`1coooo002?oooo0P0001Woool00ol0VOooooooo`1coooo002?oooo00<0003oooooool06?oo
o`03o`2Ioooooooo07?oool008ooool00`000?ooooooo`0Hoooo00?o09Woooooool0Loooo`00Sooo
o`030000oooooooo01Soool00ol0VOooooooo`1coooo002?oooo0P0001Woool00ol0VOooooooo`1c
oooo002?oooo00<0003oooooool06?ooo`03o`2Ioooooooo07?oool007Koool200001?ooo`800005
oooo00<0003oooooool00_ooo`800005oooo00<0003oooooool06?ooo`03o`2Ioooooooo07?oool0
07Goool010000?ooooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_oo
o`030000oooooooo01Soool00ol0VOooooooo`1coooo001eoooo00@0003oooooool0000:oooo00<0
003oooooool01?ooo`030000oooooooo00;oool300006?ooo`03o`2Ioooooooo07?oool007Goool0
10000?ooooooo`0000_oool010000?ooooooooooo`800005oooo00<0003oooooool06?ooo`03o`2I
oooooooo07?oool007Goool010000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?oo
ooooo`04oooo00<0003oooooool06?ooo`03o`2Ioooooooo07?oool007Koool200002Oooo`@00003
oooo0`0000Coool00`000?ooooooo`0Hoooo00?o09Woooooool0Loooo`00Soooo`80000Ioooo00?o
09Woooooool0Loooo`00Soooo`030000oooooooo01Soool00ol0VOooooooo`1coooo002?oooo00<0
003oooooool06?ooo`03o`2Ioooooooo07?oool008ooool00`000?ooooooo`0Hoooo00?o09Wooooo
ool0Loooo`00Soooo`80000Ioooo00?o09Woooooool0Loooo`00Soooo`030000oooooooo01Soool0
0ol0VOooooooo`1coooo002?oooo00<0003oooooool06?ooo`03o`2Ioooooooo07?oool008ooool0
0`000?ooooooo`0Hoooo00?o09Woooooool0Loooo`00Soooo`80000Ioooo00?o09Woooooool0Looo
o`00Soooo`030000oooooooo01Soool00ol0VOooooooo`1coooo002?oooo00<0003oooooool06?oo
o`03o`2Ioooooooo07?oool008ooool00`000?ooooooo`0Hoooo00?o09Woooooool0Loooo`00Sooo
o`80000Ioooo00?o09Woooooool0Loooo`00Soooo`030000oooooooo01Soool00ol0VOooooooo`1c
oooo0027oooo1@0000?oool00`000?ooooooo`0Hoooo00?o09Woooooool0Loooo`00ROooo`030000
oooooooo00?oool00`000?ooooooo`0Hoooo00?o09Woooooool0Loooo`00ROooo`030000oooooooo
00?oool300006?ooo`03o`2Ioooooooo07?oool008Woool00`000?ooooooo`2Doooo0029oooo00<0
003oooooool0U?ooo`00R?ooo`80002Foooo003ooooo8Oooo`00ooooob7oool007Woool00`000?oo
ooooo`0Xoooo00<0003oooooool0NOooo`00N?ooo`030000oooooooo00Soool00`000?ooooooo`0O
oooo00<0003oooooool0N?ooo`00N?ooo`030000oooooooo00;oool200001?ooo`030000oooooooo
00goool200001?ooo`800003oooo1@0000;oool00`000?ooooooo`1hoooo001hoooo00D0003ooooo
ooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`04oooo100000?oool010000?oo
ooooo`0000[oool00`000?ooooooo`02oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo
00;oool00`000?ooooooo`0Coooo00@0003oooooool0000:oooo00<0003oooooool00oooo`030000
oooooooo07Ooool007Soool00`000?ooooooo`0500004_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000005Oooo`040000
oooooooo00002_ooo`030000oooooooo00;oool00`000?ooooooo`1hoooo001ioooo00<0003ooooo
ool05oooo`80000:oooo0P0000?oool00`000?ooooooo`1ioooo003ooooo8Oooo`00ooooob7oool0
0001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.05) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.58872 .30902 L
.59975 .30902 L
.60479 .30902 L
.60756 .30902 L
.61016 .30902 L
.61135 .30902 L
.6126 .30902 L
s
.6126 .30902 m
.61267 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.32392 .30902 L
.34309 .30902 L
.36173 .30902 L
.36626 .30902 L
.37114 .30902 L
.37257 .30902 L
.37328 .30902 L
.37393 .30902 L
.37515 .46353 L
.3758 .46353 L
.37649 .46353 L
.3815 .46353 L
.3841 .46353 L
.38553 .46353 L
.38622 .46353 L
.38686 .46353 L
.38799 .30902 L
.38921 .30902 L
.39178 .30902 L
.40291 .30902 L
.42308 .30902 L
.46293 .30902 L
.50126 .30902 L
.54204 .30902 L
.5813 .30902 L
.61906 .30902 L
.65926 .30902 L
.69795 .30902 L
.73909 .30902 L
.77871 .30902 L
.81682 .30902 L
.85738 .30902 L
.89642 .30902 L
.93792 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.05) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0:oooo00D0
I_ooool0003oool0I_l03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003ooooo
ool02oooo`03o`2I0000oooo00goool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000
oooooooo00goool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo01Goool0
01Koool00`000?ooooooo`0joooo00<0003oooooool06Oooo`0506Kooooooooooooo06Ko01_oool0
0`000?ooooooo`0Joooo00?o09Woooooool07?ooo`030000oooooooo03[oool00`000?ooooooo`0E
oooo001_oooo00D0I_ooooooooooool0I_l06oooo`030000oooooooo01[oool00ol0VOooooooo`1a
oooo001_oooo00D0I_ooooooooooool0I_l06oooo`80000Koooo00?o09Woooooool0LOooo`00Kooo
o`0506Kooooooooooooo06Ko01_oool00`000?ooooooo`0Joooo00?o09Woooooool0LOooo`00Kooo
o`0506Kooooooooooooo06Ko01_oool00`000?ooooooo`0Joooo00?o09Woooooool0LOooo`00Kooo
o`0506Kooooooooooooo06Ko01_oool00`000?ooooooo`0Joooo00?o09Woooooool0LOooo`00Kooo
o`0506Kooooooooooooo06Ko01_oool200006oooo`03o`2Ioooooooo077oool006ooool01@1Voooo
ooooooooo`1Vo`0Koooo00<0003oooooool06_ooo`03o`2Ioooooooo077oool006ooool01@1Voooo
ooooooooo`1Vo`0Koooo00<0003oooooool06_ooo`03o`2Ioooooooo077oool006ooool01@1Voooo
ooooooooo`1Vo`0Koooo00<0003oooooool06_ooo`03o`2Ioooooooo077oool006ooool01@1Voooo
ooooooooo`1Vo`0Koooo0P0001_oool00ol0VOooooooo`1aoooo001_oooo00D0I_ooooooooooool0
I_l06oooo`030000oooooooo01[oool00ol0VOooooooo`1aoooo001_oooo00D0I_ooooooooooool0
I_l06oooo`030000oooooooo01[oool00ol0VOooooooo`1aoooo001_oooo00D0I_ooooooooooool0
I_l06oooo`030000oooooooo01[oool00ol0VOooooooo`1aoooo001_oooo00D0I_ooooooooooool0
I_l06oooo`80000Koooo00?o09Woooooool0LOooo`00Koooo`0506Kooooooooooooo06Ko01_oool0
0`000?ooooooo`0Joooo00?o09Woooooool0LOooo`00Koooo`0506Kooooooooooooo06Ko00;oool2
00001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo01[oool00ol0VOooooooo`1a
oooo001_oooo00L0I_ooooooooooool0I_ooool000000_ooo`030000oooooooo00Koool00`000?oo
ooooo`03oooo00@0003oooooool00004oooo00<0003oooooool06_ooo`03o`2Ioooooooo077oool0
06ooool0101Vooooooooo`1Vo`;oool010000?ooooooo`0000Woool00`000?ooooooo`05oooo00<0
003oooooool00_ooo`<0000Joooo00?o09Woooooool0LOooo`00Koooo`0406Kooooooooo06Ko0_oo
o`040000oooooooo00002_ooo`030000oooooooo00;oool200001Oooo`030000oooooooo01[oool0
0ol0VOooooooo`1aoooo001_oooo00@0I_ooooooool0I_l2oooo00@0003oooooool00008oooo00@0
003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo01[oool00ol0VOooooooo`1a
oooo001_oooo00@0I_ooooooool0I_l3oooo0P0000[oool200001?ooo`<00004oooo00<0003ooooo
ool06_ooo`03o`2Ioooooooo077oool006ooool0101Vooooooooo`1Voacoool200006oooo`03o`2I
oooooooo077oool006ooool0101Vooooooooo`1Voacoool00`000?ooooooo`0Joooo00?o09Wooooo
ool0LOooo`00Koooo`0406Kooooooooo06Ko7?ooo`030000oooooooo01[oool00ol0VOooooooo`1a
oooo001_oooo00@0I_ooooooool0I_lLoooo00<0003oooooool06_ooo`03o`2Ioooooooo077oool0
06ooool0101Vooooooooo`1Voacoool200006oooo`03o`2Ioooooooo077oool006ooool0101Voooo
ooooo`1Voacoool00`000?ooooooo`0Joooo00?o09Woooooool0LOooo`00Koooo`0406Kooooooooo
06Ko7?ooo`030000oooooooo01[oool00ol0VOooooooo`1aoooo001_oooo00@0I_ooooooool0I_lL
oooo00<0003oooooool06_ooo`03o`2Ioooooooo077oool006ooool0101Vooooooooo`1Voacoool2
00006oooo`03o`2Ioooooooo077oool006ooool0101Vooooooooo`1Voacoool00`000?ooooooo`0J
oooo00?o09Woooooool0LOooo`00Koooo`0406Kooooooooo06Ko7?ooo`030000oooooooo01[oool0
0ol0VOooooooo`1aoooo001_oooo00@0I_ooooooool0I_lLoooo00<0003oooooool06_ooo`03o`2I
oooooooo077oool006ooool0101Vooooooooo`1Voacoool200006oooo`03o`2Ioooooooo077oool0
06ooool0101Vooooooooo`1Voacoool00`000?ooooooo`0Joooo00?o09Woooooool0LOooo`00Kooo
o`0406Kooooooooo06Ko2Oooo`800004oooo0P0000Coool200001Oooo`030000oooooooo01[oool0
0ol0VOooooooo`1aoooo001_oooo00@0I_ooooooool0I_l8oooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool06_ooo`03o`2Ioooooooo077oool006ooool406Ko2?oo
o`040000oooooooo00002oooo`030000oooooooo00;oool300006_ooo`03o`2Ioooooooo077oool0
07_oool010000?ooooooo`0000Woool200001Oooo`030000oooooooo01[oool00ol0VOooooooo`1a
oooo001koooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo01[oool0
0ol0VOooooooo`1aoooo001loooo0P0000[oool300001?ooo`030000oooooooo01[oool00ol0VOoo
ooooo`1aoooo002?oooo0P0001_oool00ol0VOooooooo`1aoooo002?oooo00<0003oooooool06_oo
o`03o`2Ioooooooo077oool008ooool00`000?ooooooo`0Joooo00?o09Woooooool0LOooo`00Sooo
o`80000Koooo00?o09Woooooool0LOooo`00Soooo`030000oooooooo01[oool00ol0VOooooooo`1a
oooo002?oooo00<0003oooooool06_ooo`03o`2Ioooooooo077oool008ooool00`000?ooooooo`0J
oooo00?o09Woooooool0LOooo`00Soooo`80000Koooo00?o09Woooooool0LOooo`00Soooo`030000
oooooooo01[oool00ol0VOooooooo`1aoooo002?oooo00<0003oooooool06_ooo`03o`2Ioooooooo
077oool008ooool00`000?ooooooo`0Joooo00?o09Woooooool0LOooo`00Soooo`80000Koooo00?o
09Woooooool0LOooo`00Soooo`030000oooooooo01[oool00ol0VOooooooo`1aoooo001foooo0P00
00Coool200001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo01[oool00ol0VOoo
ooooo`1aoooo001eoooo00@0003oooooool0000:oooo00D0003oooooooooool000000_ooo`030000
oooooooo00;oool00`000?ooooooo`0Joooo00?o09Woooooool0LOooo`00MOooo`040000oooooooo
00002_ooo`030000oooooooo00Coool00`000?ooooooo`02oooo0`0001[oool00ol0VOooooooo`1a
oooo001eoooo00@0003oooooool0000;oooo00@0003oooooooooool200001Oooo`030000oooooooo
01[oool00ol0VOooooooo`1aoooo001eoooo00@0003oooooool00008oooo00@0003oooooool00003
oooo00<0003oooooool01?ooo`030000oooooooo01[oool00ol0VOooooooo`1aoooo001foooo0P00
00Woool400000oooo`<00004oooo00<0003oooooool06_ooo`03o`2Ioooooooo077oool008ooool2
00006oooo`03o`2Ioooooooo077oool008ooool00`000?ooooooo`0Joooo00?o09Woooooool0LOoo
o`00Soooo`030000oooooooo01[oool00ol0VOooooooo`1aoooo002?oooo00<0003oooooool06_oo
o`03o`2Ioooooooo077oool008ooool200006oooo`03o`2Ioooooooo077oool008ooool00`000?oo
ooooo`0Joooo00?o09Woooooool0LOooo`00Soooo`030000oooooooo01[oool00ol0VOooooooo`1a
oooo002?oooo00<0003oooooool06_ooo`03o`2Ioooooooo077oool008ooool200006oooo`03o`2I
oooooooo077oool008ooool00`000?ooooooo`0Joooo00?o09Woooooool0LOooo`00Soooo`030000
oooooooo01[oool00ol0VOooooooo`1aoooo002?oooo00<0003oooooool06_ooo`03o`2Ioooooooo
077oool008ooool200006oooo`03o`2Ioooooooo077oool008ooool00`000?ooooooo`0Joooo00?o
09Woooooool0LOooo`00Qoooo`D00003oooo00<0003oooooool06_ooo`03o`2Ioooooooo077oool0
08Woool00`000?ooooooo`03oooo00<0003oooooool06_ooo`03o`2Ioooooooo077oool008Woool0
0`000?ooooooo`03oooo0`0001[oool00ol0VOooooooo`1aoooo0029oooo00<0003oooooool0U?oo
o`00ROooo`030000oooooooo09Coool008Soool20000U_ooo`00ooooob7oool00?oooolQoooo001f
oooo00<0003oooooool0;_ooo`030000oooooooo07Koool007Goool00`000?ooooooo`08oooo00<0
003oooooool09Oooo`030000oooooooo07Goool007Goool00`000?ooooooo`02oooo0P0000Coool0
0`000?ooooooo`0=oooo0P0000Coool200001?ooo`800004oooo0P0000Coool00`000?ooooooo`1e
oooo001eoooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`04
oooo100000?oool010000?ooooooo`0000Soool010000?ooooooo`0000;oool010000?ooooooo`00
00?oool00`000?ooooooo`1eoooo001doooo00<0003oooooool00_ooo`030000oooooooo01?oool0
10000?ooooooo`0000Soool010000?ooooooo`0000Goool00`000?ooooooo`02oooo00<0003ooooo
ool0M?ooo`00MOooo`030000oooooooo00D0000Boooo00@0003oooooool00008oooo00@0003ooooo
ool00003oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000005Ooo
o`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo00?oool00`000?oo
ooooo`1eoooo001foooo00<0003oooooool05oooo`80000:oooo0P0000Coool300000_ooo`030000
oooooooo07Koool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -21.7813 0 ]
[.5 .63053 21.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -82.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
96.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.58872 .30902 L
.59975 .30902 L
.60479 .30902 L
.61016 .30902 L
.61278 .30902 L
.61524 .30902 L
.61745 .30902 L
.61869 .30902 L
s
.61869 .30902 m
.6188 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -21.7813 0 ]
[.5 .63053 21.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -82.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
96.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006Ooo
o`<0000hoooo100003Ooool20000>?ooo`@0000koooo0`0001Goool001[oool00`000?ooooooo`0g
oooo00<0003oooooool0>?ooo`030000oooooooo03Ooool00`000?ooooooo`0moooo00<0003ooooo
ool05?ooo`005oooo`D0000ioooo00<0003oooooool0=oooo`030000oooooooo03Soool00`000?oo
ooooo`0ioooo1@0001Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0
003oooooool0=_ooo`030000oooooooo03Woool00`000?ooooooo`0hoooo00@0003oooooool0000F
oooo000Hoooo00<0003oool00000>Oooo`040000oooooooo0000=oooo`80000hoooo00@0003ooooo
ool0000joooo00<0003oool000005_ooo`006Oooo`80000joooo0P0003Soool00`000?ooooooo`0h
oooo0P0003coool200005_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`004?ooool0000Aoooo000Foooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?oo
ooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0
003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo
00goool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo01Goool001Koool0
0`000?ooooooo`0joooo00<0003oooooool0>Oooo`030000oooooooo01_oool00ol0VOooooooo`0K
oooo00<0003oooooool0>_ooo`030000oooooooo01Goool008ooool00`000?ooooooo`0Koooo00?o
09Woooooool0L?ooo`00Soooo`80000Loooo00?o09Woooooool0L?ooo`00Soooo`030000oooooooo
01_oool00ol0VOooooooo`1`oooo002?oooo00<0003oooooool06oooo`03o`2Ioooooooo073oool0
08ooool00`000?ooooooo`0Koooo00?o09Woooooool0L?ooo`00Soooo`80000Loooo00?o09Wooooo
ool0L?ooo`00Soooo`030000oooooooo01_oool00ol0VOooooooo`1`oooo002?oooo00<0003ooooo
ool06oooo`03o`2Ioooooooo073oool008ooool00`000?ooooooo`0Koooo00?o09Woooooool0L?oo
o`00Soooo`80000Loooo00?o09Woooooool0L?ooo`00Soooo`030000oooooooo01_oool00ol0VOoo
ooooo`1`oooo002?oooo00<0003oooooool06oooo`03o`2Ioooooooo073oool008ooool00`000?oo
ooooo`0Koooo00?o09Woooooool0L?ooo`00Soooo`80000Loooo00?o09Woooooool0L?ooo`00Sooo
o`030000oooooooo01_oool00ol0VOooooooo`1`oooo001foooo0P0000Coool200000oooo`@00003
oooo0P0000Goool00`000?ooooooo`0Koooo00?o09Woooooool0L?ooo`00MOooo`040000oooooooo
00002?ooo`030000oooooooo00?oool010000?ooooooo`0000Coool00`000?ooooooo`0Koooo00?o
09Woooooool0L?ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool00`000?oo
ooooo`02oooo0`0001_oool00ol0VOooooooo`1`oooo001eoooo00@0003oooooool0000:oooo00<0
003oooooool00_ooo`800005oooo00<0003oooooool06oooo`03o`2Ioooooooo073oool007Goool0
10000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003ooooo
ool06oooo`03o`2Ioooooooo073oool007Koool200002_ooo`800004oooo0`0000Coool00`000?oo
ooooo`0Koooo00?o09Woooooool0L?ooo`00Soooo`80000Loooo00?o09Woooooool0L?ooo`00Sooo
o`030000oooooooo01_oool00ol0VOooooooo`1`oooo002?oooo00<0003oooooool06oooo`03o`2I
oooooooo073oool008ooool00`000?ooooooo`0Koooo00?o09Woooooool0L?ooo`00Soooo`80000L
oooo00?o09Woooooool0L?ooo`00Soooo`030000oooooooo01_oool00ol0VOooooooo`1`oooo002?
oooo00<0003oooooool06oooo`03o`2Ioooooooo073oool008ooool00`000?ooooooo`0Koooo00?o
09Woooooool0L?ooo`00Soooo`80000Loooo00?o09Woooooool0L?ooo`00Soooo`030000oooooooo
01_oool00ol0VOooooooo`1`oooo002?oooo00<0003oooooool06oooo`03o`2Ioooooooo073oool0
08ooool00`000?ooooooo`0Koooo00?o09Woooooool0L?ooo`00Soooo`80000Loooo00?o09Wooooo
ool0L?ooo`00Soooo`030000oooooooo01_oool00ol0VOooooooo`1`oooo001loooo0P0000Coool2
00001?ooo`800005oooo00<0003oooooool06oooo`03o`2Ioooooooo073oool007_oool010000?oo
ooooo`0000Soool010000?ooooooo`0000Coool00`000?ooooooo`0Koooo00?o09Woooooool0L?oo
o`00Noooo`040000oooooooo00002oooo`030000oooooooo00;oool300006oooo`03o`2Ioooooooo
073oool007_oool010000?ooooooo`0000Woool200001Oooo`030000oooooooo01_oool00ol0VOoo
ooooo`1`oooo001koooo00@0003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo
01_oool00ol0VOooooooo`1`oooo001loooo0P0000[oool300001?ooo`030000oooooooo01_oool0
0ol0VOooooooo`1`oooo002?oooo0P0001coool00ol0VOooooooo`1`oooo002?oooo00<0003ooooo
ool06oooo`03o`2Ioooooooo073oool008ooool00`000?ooooooo`0Koooo00?o09Woooooool0L?oo
o`00Soooo`80000Loooo00?o09Woooooool0L?ooo`00Soooo`030000oooooooo01_oool00ol0VOoo
ooooo`1`oooo002?oooo00<0003oooooool06oooo`03o`2Ioooooooo073oool008ooool00`000?oo
ooooo`0Koooo00?o09Woooooool0L?ooo`00Soooo`80000Loooo00?o09Woooooool0L?ooo`00Sooo
o`030000oooooooo01_oool00ol0VOooooooo`1`oooo002?oooo00<0003oooooool06oooo`03o`2I
oooooooo073oool008ooool00`000?ooooooo`0Koooo00?o09Woooooool0L?ooo`00Soooo`80000L
oooo00?o09Woooooool0L?ooo`00Soooo`030000oooooooo01_oool00ol0VOooooooo`1`oooo001f
oooo0P0000Coool200001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo01_oool0
0ol0VOooooooo`1`oooo001eoooo00@0003oooooool0000:oooo00D0003oooooooooool000000_oo
o`030000oooooooo00;oool00`000?ooooooo`0Koooo00?o09Woooooool0L?ooo`00MOooo`040000
oooooooo00002_ooo`030000oooooooo00Coool00`000?ooooooo`02oooo0`0001_oool00ol0VOoo
ooooo`1`oooo001eoooo00@0003oooooool0000;oooo00@0003oooooooooool200001Oooo`030000
oooooooo01_oool00ol0VOooooooo`1`oooo001eoooo00@0003oooooool00008oooo00@0003ooooo
ool00003oooo00<0003oooooool01?ooo`030000oooooooo01_oool00ol0VOooooooo`1`oooo001f
oooo0P0000Woool400000oooo`<00004oooo00<0003oooooool06oooo`03o`2Ioooooooo073oool0
08ooool200007?ooo`03o`2Ioooooooo073oool008ooool00`000?ooooooo`0Koooo00?o09Wooooo
ool0L?ooo`00Soooo`030000oooooooo01_oool00ol0VOooooooo`1`oooo002?oooo00<0003ooooo
ool06oooo`03o`2Ioooooooo073oool008ooool200007?ooo`03o`2Ioooooooo073oool008ooool0
0`000?ooooooo`0Koooo00?o09Woooooool0L?ooo`00Soooo`030000oooooooo01_oool00ol0VOoo
ooooo`1`oooo002?oooo00<0003oooooool06oooo`03o`2Ioooooooo073oool008ooool200007?oo
o`03o`2Ioooooooo073oool008ooool00`000?ooooooo`0Koooo00?o09Woooooool0L?ooo`00Sooo
o`030000oooooooo01_oool00ol0VOooooooo`1`oooo002?oooo00<0003oooooool06oooo`03o`2I
oooooooo073oool008ooool200007?ooo`03o`2Ioooooooo073oool008ooool00`000?ooooooo`0K
oooo00?o09Woooooool0L?ooo`00Qoooo`D00003oooo00<0003oooooool06oooo`03o`2Ioooooooo
073oool008Woool00`000?ooooooo`03oooo00<0003oooooool06oooo`03o`2Ioooooooo073oool0
08Woool00`000?ooooooo`03oooo0`0001_oool00ol0VOooooooo`1`oooo0029oooo00<0003ooooo
ool0U?ooo`00ROooo`030000oooooooo09Coool008Soool20000U_ooo`00ooooob7oool00?oooolQ
oooo001ooooo00<0003oooooool07?ooo`030000oooooooo07ooool007koool00`000?ooooooo`08
oooo00<0003oooooool04oooo`030000oooooooo07koool007koool00`000?ooooooo`02oooo0P00
00Coool00`000?ooooooo`07oooo0P0000Coool200001?ooo`030000oooooooo07koool007koool0
1@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo00Goool010000?oo
ooooo`0000Woool00`000?ooooooo`1noooo001moooo00<0003oooooool00_ooo`030000oooooooo
00goool010000?ooooooo`0000[oool00`000?ooooooo`1moooo001noooo00<0003oooooool01@00
00coool010000?ooooooo`0000Woool00`000?ooooooo`1noooo001noooo00D0003oooooooooool0
00003oooo`040000oooooooo00002Oooo`030000oooooooo07koool007ooool00`000?ooooooo`0A
oooo0P0000Woool00`000?ooooooo`1ooooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.05) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.59832 .30902 L
.60873 .30902 L
.61445 .30902 L
.61726 .30902 L
.61984 .30902 L
.62236 .30902 L
.62363 .30902 L
.62435 .30902 L
s
.62435 .30902 m
.62442 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.32392 .30902 L
.34309 .30902 L
.36173 .30902 L
.36626 .30902 L
.37114 .30902 L
.37257 .30902 L
.37328 .30902 L
.37393 .30902 L
.37515 .15451 L
.3758 .15451 L
.37649 .15451 L
.3815 .15451 L
.3841 .15451 L
.38553 .15451 L
.38622 .15451 L
.38686 .15451 L
.38799 .30902 L
.38921 .30902 L
.39178 .30902 L
.40291 .30902 L
.42308 .30902 L
.46293 .30902 L
.50126 .30902 L
.54204 .30902 L
.5813 .30902 L
.61906 .30902 L
.65926 .30902 L
.69795 .30902 L
.73909 .30902 L
.77871 .30902 L
.81682 .30902 L
.85738 .30902 L
.89642 .30902 L
.93792 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.05) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool006ooool406Ko2?ooo`040000oooooooo00002oooo`030000oooooooo
00;oool30000S_ooo`00Koooo`0406Kooooooooo06Ko0_ooo`@00002oooo00@0003oooooool00009
oooo0P0000Goool00`000?ooooooo`2>oooo001_oooo00@0I_ooooooool0I_l8oooo00@0003ooooo
ool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool006ooool0101Vooooooooo`1V
o`Woool200002_ooo`<00004oooo00<0003oooooool0S_ooo`00Koooo`0406Kooooooooo06Ko7?oo
o`80002?oooo001_oooo00@0I_ooooooool0I_lLoooo00<0003oooooool0S_ooo`00Koooo`0406Ko
oooooooo06Ko7?ooo`030000oooooooo08koool006ooool0101Vooooooooo`1Voacoool00`000?oo
ooooo`2>oooo001_oooo00@0I_ooooooool0I_lLoooo0P0008ooool006ooool0101Vooooooooo`1V
oacoool00`000?ooooooo`2>oooo001_oooo00@0I_ooooooool0I_lLoooo00<0003oooooool0S_oo
o`00Koooo`0406Kooooooooo06Ko7?ooo`030000oooooooo08koool006ooool0101Vooooooooo`1V
oacoool20000Soooo`00Koooo`0406Kooooooooo06Ko7?ooo`030000oooooooo08koool006ooool0
101Vooooooooo`1Voacoool00`000?ooooooo`2>oooo001_oooo00@0I_ooooooool0I_lLoooo00<0
003oooooool0S_ooo`00Koooo`0406Kooooooooo06Ko7?ooo`80002?oooo001_oooo00@0I_oooooo
ool0I_lLoooo00<0003oooooool0S_ooo`00Koooo`0406Kooooooooo06Ko0oooo`800004oooo0P00
00?oool400000oooo`800005oooo00<0003oooooool0S_ooo`00Koooo`0406Kooooooooo06Ko0_oo
o`040000oooooooo00002?ooo`030000oooooooo00?oool010000?ooooooo`0000Coool00`000?oo
ooooo`2>oooo001_oooo00L0I_ooooooooooool0I_ooool000000_ooo`030000oooooooo00Ooool0
0`000?ooooooo`05oooo00<0003oooooool00_ooo`<0002>oooo001_oooo1000000306Kooooo0000
00;oool00`000?ooooooo`08oooo00<0003oooooool00_ooo`800005oooo00<0003oooooool0S_oo
o`00Koooo`0706Kooooooooooooo06Kooooo000000;oool00`000?ooooooo`06oooo00@0003ooooo
ool00003oooo00<0003oooooool01?ooo`030000oooooooo08koool006ooool01@1Voooooooooooo
o`1Vo`02oooo0P0000[oool200001?ooo`<00004oooo00<0003oooooool0S_ooo`00Koooo`0506Ko
oooooooooooo06Ko01_oool20000Soooo`00Koooo`0506Kooooooooooooo06Ko01_oool00`000?oo
ooooo`2>oooo001_oooo00D0I_ooooooooooool0I_l06oooo`030000oooooooo08koool006ooool0
1@1Vooooooooooooo`1Vo`0Koooo00<0003oooooool0S_ooo`006Oooo`<0000hoooo100001Ooool0
1@1Vooooooooooooo`1Vo`0Koooo0P0003Soool40000>oooo`<0000Eoooo000Joooo00<0003ooooo
ool0=oooo`030000oooooooo01Soool01@1Vooooooooooooo`1Vo`0Koooo00<0003oooooool0=ooo
o`030000oooooooo03goool00`000?ooooooo`0Doooo000Goooo1@0003Woool00`000?ooooooo`0G
oooo00D0I_ooooooooooool0I_l06oooo`030000oooooooo03Soool00`000?ooooooo`0ioooo1@00
01Goool0017oool400000_ooo`040000oooooooo0000<oooo`@00004oooo00<0003oooooool05_oo
o`0506Kooooooooooooo06Ko01_oool00`000?ooooooo`0ioooo00<0003oooooool0>?ooo`040000
oooooooo00005_ooo`006?ooo`030000oooo000003Woool010000?ooooooo`0001Ooool01@1Voooo
ooooooooo`1Vo`0Koooo0P0003Soool010000?ooooooo`0003[oool00`000?ooo`00000Foooo000I
oooo0P0003[oool200006?ooo`0506Kooooooooooooo06Ko01_oool00`000?ooooooo`0hoooo0P00
03coool200005_ooo`00Koooo`0506Kooooooooooooo06Ko01_oool00`000?ooooooo`2>oooo001_
oooo00D0I_ooooooooooool0I_l06oooo`80002?oooo001_oooo00D0I_ooooooooooool0I_l06ooo
o`030000oooooooo08koool006ooool01@1Vooooooooooooo`1Vo`0Koooo00<0003oooooool0S_oo
o`00Koooo`0506Kooooooooooooo06Ko01_oool00`000?ooooooo`2>oooo000@ooooo`00017oool0
01Koool00`000?ooooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00goool00`000?oo
ooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0
003oooooool03?ooo`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003ooooo09T03?oo
o`030000oooooooo00coool00`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo
00coool00`000?ooooooo`0<oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo03[oool0
0`000?ooooooo`0ioooo00<0003oooooool07Oooo`03o`2Ioooooooo01Woool00`000?ooooooo`0j
oooo00<0003oooooool05Oooo`00Soooo`030000oooooooo01goool00ol0VOooooooo`1^oooo002?
oooo0P0001koool00ol0VOooooooo`1^oooo002?oooo00<0003oooooool07Oooo`03o`2Ioooooooo
06koool008ooool00`000?ooooooo`0Moooo00?o09Woooooool0K_ooo`00Soooo`030000oooooooo
01goool00ol0VOooooooo`1^oooo002?oooo0P0001koool00ol0VOooooooo`1^oooo002?oooo00<0
003oooooool07Oooo`03o`2Ioooooooo06koool008ooool00`000?ooooooo`0Moooo00?o09Wooooo
ool0K_ooo`00Soooo`030000oooooooo01goool00ol0VOooooooo`1^oooo002?oooo0P0001koool0
0ol0VOooooooo`1^oooo002?oooo00<0003oooooool07Oooo`03o`2Ioooooooo06koool008ooool0
0`000?ooooooo`0Moooo00?o09Woooooool0K_ooo`00Soooo`030000oooooooo01goool00ol0VOoo
ooooo`1^oooo002?oooo0P0001koool00ol0VOooooooo`1^oooo002?oooo00<0003oooooool07Ooo
o`03o`2Ioooooooo06koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000
oooooooo01goool00ol0VOooooooo`1^oooo001eoooo00@0003oooooool00008oooo00<0003ooooo
ool00oooo`040000oooooooo00001?ooo`030000oooooooo01goool00ol0VOooooooo`1^oooo001e
oooo00@0003oooooool00009oooo00<0003oooooool01Oooo`030000oooooooo00;oool300007Ooo
o`03o`2Ioooooooo06koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`02oooo0P00
00Goool00`000?ooooooo`0Moooo00?o09Woooooool0K_ooo`00MOooo`040000oooooooo00002?oo
o`040000oooooooo00000oooo`030000oooooooo00Coool00`000?ooooooo`0Moooo00?o09Wooooo
ool0K_ooo`00M_ooo`80000:oooo0P0000Coool300001?ooo`030000oooooooo01goool00ol0VOoo
ooooo`1^oooo002?oooo0P0001koool00ol0VOooooooo`1^oooo002?oooo00<0003oooooool07Ooo
o`03o`2Ioooooooo06koool008ooool00`000?ooooooo`0Moooo00?o09Woooooool0K_ooo`00Sooo
o`030000oooooooo01goool00ol0VOooooooo`1^oooo002?oooo0P0001koool00ol0VOooooooo`1^
oooo002?oooo00<0003oooooool07Oooo`03o`2Ioooooooo06koool008ooool00`000?ooooooo`0M
oooo00?o09Woooooool0K_ooo`00Soooo`030000oooooooo01goool00ol0VOooooooo`1^oooo002?
oooo0P0001koool00ol0VOooooooo`1^oooo002?oooo00<0003oooooool07Oooo`03o`2Ioooooooo
06koool008ooool00`000?ooooooo`0Moooo00?o09Woooooool0K_ooo`00Soooo`030000oooooooo
01goool00ol0VOooooooo`1^oooo002?oooo0P0001koool00ol0VOooooooo`1^oooo002?oooo00<0
003oooooool07Oooo`03o`2Ioooooooo06koool007coool200001?ooo`800004oooo0P0000Goool0
0`000?ooooooo`0Moooo00?o09Woooooool0K_ooo`00Noooo`040000oooooooo00002?ooo`040000
oooooooo00001?ooo`030000oooooooo01goool00ol0VOooooooo`1^oooo001koooo00@0003ooooo
ool0000;oooo00<0003oooooool00_ooo`<0000Moooo00?o09Woooooool0K_ooo`00Noooo`040000
oooooooo00002Oooo`800005oooo00<0003oooooool07Oooo`03o`2Ioooooooo06koool007_oool0
10000?ooooooo`0000Woool00`000?ooooooo`04oooo00<0003oooooool07Oooo`03o`2Ioooooooo
06koool007coool200002_ooo`<00004oooo00<0003oooooool07Oooo`03o`2Ioooooooo06koool0
08ooool200007_ooo`03o`2Ioooooooo06koool008ooool00`000?ooooooo`0Moooo00?o09Wooooo
ool0K_ooo`00Soooo`030000oooooooo01goool00ol0VOooooooo`1^oooo002?oooo0P0001koool0
0ol0VOooooooo`1^oooo002?oooo00<0003oooooool07Oooo`03o`2Ioooooooo06koool008ooool0
0`000?ooooooo`0Moooo00?o09Woooooool0K_ooo`00Soooo`030000oooooooo01goool00ol0VOoo
ooooo`1^oooo002?oooo0P0001koool00ol0VOooooooo`1^oooo002?oooo00<0003oooooool07Ooo
o`03o`2Ioooooooo06koool008ooool00`000?ooooooo`0Moooo00?o09Woooooool0K_ooo`00Sooo
o`030000oooooooo01goool00ol0VOooooooo`1^oooo002?oooo0P0001koool00ol0VOooooooo`1^
oooo002?oooo00<0003oooooool07Oooo`03o`2Ioooooooo06koool007Koool200001?ooo`800005
oooo00<0003oooooool00_ooo`800005oooo00<0003oooooool07Oooo`03o`2Ioooooooo06koool0
07Goool010000?ooooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_oo
o`030000oooooooo01goool00ol0VOooooooo`1^oooo001eoooo00@0003oooooool0000:oooo00<0
003oooooool01?ooo`030000oooooooo00;oool300007Oooo`03o`2Ioooooooo06koool007Goool0
10000?ooooooo`0000_oool010000?ooooooooooo`800005oooo00<0003oooooool07Oooo`03o`2I
oooooooo06koool007Goool010000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?oo
ooooo`04oooo00<0003oooooool07Oooo`03o`2Ioooooooo06koool007Koool200002Oooo`@00003
oooo0`0000Coool00`000?ooooooo`0Moooo00?o09Woooooool0K_ooo`00Soooo`80000Noooo00?o
09Woooooool0K_ooo`00Soooo`030000oooooooo01goool00ol0VOooooooo`1^oooo002?oooo00<0
003oooooool07Oooo`03o`2Ioooooooo06koool008ooool00`000?ooooooo`0Moooo00?o09Wooooo
ool0K_ooo`00Soooo`80000Noooo00?o09Woooooool0K_ooo`00Soooo`030000oooooooo01goool0
0ol0VOooooooo`1^oooo002?oooo00<0003oooooool07Oooo`03o`2Ioooooooo06koool008ooool0
0`000?ooooooo`0Moooo00?o09Woooooool0K_ooo`00Soooo`80000Noooo00?o09Woooooool0K_oo
o`00Soooo`030000oooooooo01goool00ol0VOooooooo`1^oooo002?oooo00<0003oooooool07Ooo
o`03o`2Ioooooooo06koool008ooool00`000?ooooooo`0Moooo00?o09Woooooool0K_ooo`00Sooo
o`80000Noooo00?o09Woooooool0K_ooo`00Soooo`030000oooooooo01goool00ol0VOooooooo`1^
oooo0027oooo1@0000?oool00`000?ooooooo`0Moooo00?o09Woooooool0K_ooo`00ROooo`030000
oooooooo00?oool00`000?ooooooo`0Moooo00?o09Woooooool0K_ooo`00ROooo`030000oooooooo
00?oool300007Oooo`03o`2Ioooooooo06koool008Woool00`000?ooooooo`2Doooo0029oooo00<0
003oooooool0U?ooo`00R?ooo`80002Foooo003ooooo8Oooo`00ooooob7oool007Woool00`000?oo
ooooo`0Xoooo00<0003oooooool0NOooo`00N?ooo`030000oooooooo00Soool00`000?ooooooo`0O
oooo00<0003oooooool0N?ooo`00N?ooo`030000oooooooo00;oool200001?ooo`030000oooooooo
00Ooool200001?ooo`800004oooo0P0000Coool200001?ooo`030000oooooooo07Soool007Soool0
1@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo00Goool010000?oo
ooooo`0000Soool010000?ooooooo`0000;oool010000?ooooooo`0000?oool00`000?ooooooo`1h
oooo001goooo00<0003oooooool00_ooo`030000oooooooo00goool010000?ooooooo`0000Soool0
10000?ooooooo`0000Goool00`000?ooooooo`02oooo00<0003oooooool0Moooo`00N?ooo`030000
oooooooo00D0000<oooo00@0003oooooool00008oooo00@0003oooooool00003oooo0P0000Coool0
0`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000003oooo`040000oooooooo00002?oo
o`040000oooooooo00000oooo`030000oooooooo00?oool00`000?ooooooo`1hoooo001ioooo00<0
003oooooool04Oooo`80000:oooo0P0000Coool300000_ooo`030000oooooooo07Woool00?oooolQ
oooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-4.75297, \
-1.05744, 0.0331289, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-4.75297, -1.05744, 0.0331289, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.119048 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -6 -9 ]
[.2619 .29652 6 0 ]
[.7381 .29652 -3 -9 ]
[.7381 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-4)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-2)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(2)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(4)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.08333 .30902 m
.08333 .31277 L
s
.14286 .30902 m
.14286 .31277 L
s
.20238 .30902 m
.20238 .31277 L
s
.32143 .30902 m
.32143 .31277 L
s
.38095 .30902 m
.38095 .31277 L
s
.44048 .30902 m
.44048 .31277 L
s
.55952 .30902 m
.55952 .31277 L
s
.61905 .30902 m
.61905 .31277 L
s
.67857 .30902 m
.67857 .31277 L
s
.79762 .30902 m
.79762 .31277 L
s
.85714 .30902 m
.85714 .31277 L
s
.91667 .30902 m
.91667 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.659