(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   2945112,     120788]*)
(*NotebookOutlinePosition[   2945855,     120813]*)
(*  CellTagsIndexPosition[   2945811,     120809]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["FOCUSING IN FRONT OF A POSITIVE DELTA-FUNCTION \
NONHOMOGENEITY", "Text",
  CellFrame->True,
  FontSize->14,
  Background->None]], "Title",
  CellFrame->True,
  Background->GrayLevel[0.849989]],

Cell[TextData[{
  StyleBox["The wavefront  and the tail  are incident from the left.\n\nThe \
nonhomogeneity  v[x]  ",
    FontSize->12],
  StyleBox["is a delta-function of strength  c0, positive or negative, \
located at  x=0.",
    FontSize->12,
    CharacterEncoding->"WindowsANSI"],
  StyleBox["  The potential has one bound state if  c0<0  and no bound states \
if  c0>0.\n\nThe focusing location,  ",
    FontSize->12],
  StyleBox["x0",
    FontSize->12,
    FontVariations->{"CompatibilityType"->0},
    CharacterEncoding->"WindowsANSI"],
  StyleBox[" <0, is in front of  the nonhomogeneity and needs to be \
specified. ",
    FontSize->12],
  StyleBox["\n\nThe transmission coefficient, left reflection coefficient, \
and right reflection coefficient, respectively, are denoted by  T[k],  L[k],  \
R[k].\n\nThe tail of the wave is denoted by  g[x,t].\n\nThe focusing moment \
is chosen as  t=0.",
    FontSize->12,
    CharacterEncoding->"WindowsANSI"]
}], "Text",
  FontSize->18,
  Background->RGBColor[1, 1, 0]],

Cell["\<\
The potential and the scattering coefficients are given next:\
\>", \
"Text",
  Background->RGBColor[1, 1, 0]],

Cell[BoxData[{
    \(\(Clear[v, T, L, R, c0, x0, g];\)\), "\[IndentingNewLine]", 
    \(\(v[x_] = \ c0\ \ DiracDelta[x]\ ;\)\), "\n", 
    \(\(T[k_] = k/\((k + I\ \ c0/2)\);\)\), "\n", 
    \(\(L[k_] = \((\(-I\)\ c0/2)\)/\((k + I\ \ c0/2)\);\)\), "\n", 
    \(\(R[k_] = \((\(-I\)\ c0/2)\)/\((k + I\ \ c0/2)\);\)\)}], "Input",
  CellOpen->False],

Cell["\<\
Specify the strength of the potential, c0, a positive number;
also specify the focusing location  x0, a negative number, next:\
\>", "Text",\

  Background->RGBColor[1, 1, 0]],

Cell[BoxData[
    \(\(\(\(c0 = 1\) \)\(;\)\(\ \ \)\(x0 = \(-1\)\)\(;\)\(\ \)\)\)], "Input"],

Cell["The tail  g[x,t]  of the focusing  wave is evaluated  next:", "Text",
  Background->RGBColor[1, 1, 0]],

Cell[BoxData[
    \(\(\(\n\)\(g[x_, 
          t_] = \ \(-\ \((c0/
                2)\)\)\ \((UnitStep[
                  x]\ \ UnitStep[\(-x\) + x0 + 
                    t]\ E^\((c0 \((x - x0 - t)\)/2)\) + 
              UnitStep[\(-x\)]\ UnitStep[
                  x + x0 + 
                    t]\ \ E^\((\(-c0\) \((x + x0 + t)\)/
                        2)\))\);\)\)\)], "Input",
  CellOpen->False],

Cell[BoxData[
    \(<< Graphics`Animation`\)], "Input",
  CellOpen->False],

Cell[BoxData[
    \(<< Graphics`FilledPlot`\)], "Input",
  CellOpen->False],

Cell[TextData[{
  "The focusing wave is animated  next. The wavefront (",
  StyleBox["magenta",
    FontColor->RGBColor[1, 0, 1]],
  ") and the tail (",
  StyleBox["blue",
    FontColor->RGBColor[0, 0, 1]],
  ") are incident from the left onto the nonhomogeneity (",
  StyleBox["green",
    FontColor->RGBColor[0, 1, 0]],
  "):"
}], "Text",
  Background->RGBColor[1, 1, 0]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Animate[{FilledPlot\[IndentingNewLine][{v[x]}, \ {x, \ \(-3\), \ 
              3}, \ PlotRange -> {\(-1\), 1}, \ 
            Fills \[Rule] {Hue[ .3]}], \[IndentingNewLine]\ \ \ \ \ \ \ \
Plot[{10\ UnitStep[x - x0 - t]}, \ {x, \ \(-3\), \ 3}, \ 
            PlotStyle \[Rule] \ Hue[ .9], 
            PlotRange -> {\(-1\), 
                1}], \[IndentingNewLine]\ \ \ \ \ \ \ Plot[{g[x, 
                t]}, {x, \ \(-3\), \ 3}, \ PlotStyle \[Rule] \ Hue[ .6], \ 
            PlotRange -> {\(-1\), 
                1}]}, \[IndentingNewLine]\ {t, \ \(-1.9\), \ 3.9, 0.05}, 
        PlotLabel \[Rule] {"\<t\>", t}];\)\)], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.9) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.02846 .30902 L
.03279 .30902 L
.03523 .30902 L
.03754 .30902 L
.03881 .30902 L
.03953 .30902 L
s
.03953 .30902 m
.0396 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.9) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool01@000?ooooooooooool0V@03oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Koool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool0
0`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`0Eoooo000Foooo00D0
003ooooooooooooo09T08oooo`030000oooooooo02Koool00`000?ooooooo`0Uoooo00<0003ooooo
ool09Oooo`030000oooooooo02Goool00`000?ooooooo`0Voooo00<0003oooooool05Oooo`006_oo
o`03o`2Ioooooooo07;oool00`000?ooooooo`2>oooo000Joooo00?o09Woooooool0L_ooo`80002?
oooo000Joooo00?o09Woooooool0L_ooo`030000oooooooo08koool001[oool00ol0VOooooooo`1b
oooo00<0003oooooool0S_ooo`006_ooo`03o`2Ioooooooo07;oool00`000?ooooooo`2>oooo000J
oooo00?o09Woooooool0L_ooo`80002?oooo000Joooo00?o09Woooooool0L_ooo`030000oooooooo
08koool001[oool00ol0VOooooooo`1boooo00<0003oooooool0S_ooo`006_ooo`03o`2Ioooooooo
07;oool00`000?ooooooo`2>oooo000Joooo00?o09Woooooool0L_ooo`80002?oooo000Joooo00?o
09Woooooool0L_ooo`030000oooooooo08koool001[oool00ol0VOooooooo`1boooo00<0003ooooo
ool0S_ooo`006_ooo`03o`2Ioooooooo07;oool00`000?ooooooo`2>oooo000Joooo00?o09Wooooo
ool0L_ooo`80002?oooo000Joooo00?o09Woooooool0L_ooo`030000oooooooo08koool001[oool0
0ol0VOooooooo`1Ioooo0P0000Coool200000oooo`@00003oooo0P0000Goool00`000?ooooooo`2>
oooo000Joooo00?o09Woooooool0F?ooo`040000oooooooo00002?ooo`030000oooooooo00?oool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo000Joooo00?o09Woooooool0F?ooo`040000
oooooooo00002Oooo`030000oooooooo00Goool00`000?ooooooo`02oooo0`0008koool001[oool0
0ol0VOooooooo`1Hoooo00@0003oooooool0000:oooo00<0003oooooool00_ooo`800005oooo00<0
003oooooool0S_ooo`006_ooo`03o`2Ioooooooo05Soool010000?ooooooo`0000Soool010000?oo
ooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`006_ooo`03o`2Ioooooooo
05Woool200002_ooo`800004oooo0`0000Coool00`000?ooooooo`2>oooo000Joooo00?o09Wooooo
ool0L_ooo`80002?oooo000Joooo00?o09Woooooool0L_ooo`030000oooooooo08koool001[oool0
0ol0VOooooooo`1boooo00<0003oooooool0S_ooo`006_ooo`03o`2Ioooooooo07;oool00`000?oo
ooooo`2>oooo000Joooo00?o09Woooooool0L_ooo`80002?oooo000Joooo00?o09Woooooool0L_oo
o`030000oooooooo08koool001[oool00ol0VOooooooo`1boooo00<0003oooooool0S_ooo`006_oo
o`03o`2Ioooooooo07;oool00`000?ooooooo`2>oooo000Joooo00?o09Woooooool0L_ooo`80002?
oooo000Joooo00?o09Woooooool0L_ooo`030000oooooooo08koool001[oool00ol0VOooooooo`1b
oooo00<0003oooooool0S_ooo`006_ooo`03o`2Ioooooooo07;oool00`000?ooooooo`2>oooo000J
oooo00?o09Woooooool0L_ooo`80002?oooo000Joooo00?o09Woooooool0L_ooo`030000oooooooo
08koool001[oool00ol0VOooooooo`1Ooooo0P0000Coool200001?ooo`800005oooo00<0003ooooo
ool0S_ooo`006_ooo`03o`2Ioooooooo05koool010000?ooooooo`0000Soool010000?ooooooo`00
00Coool00`000?ooooooo`2>oooo000Joooo00?o09Woooooool0G_ooo`040000oooooooo00002ooo
o`030000oooooooo00;oool30000S_ooo`006_ooo`03o`2Ioooooooo05koool010000?ooooooo`00
00Woool200001Oooo`030000oooooooo08koool001[oool00ol0VOooooooo`1Noooo00@0003ooooo
ool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool001[oool00ol0VOooooooo`1O
oooo0P0000[oool300001?ooo`030000oooooooo08koool001[oool00ol0VOooooooo`1boooo0P00
08ooool001[oool00ol0VOooooooo`1boooo00<0003oooooool0S_ooo`006_ooo`03o`2Ioooooooo
07;oool00`000?ooooooo`2>oooo000Joooo00?o09Woooooool0L_ooo`80002?oooo000Joooo00?o
09Woooooool0L_ooo`030000oooooooo08koool001[oool00ol0VOooooooo`1boooo00<0003ooooo
ool0S_ooo`006_ooo`03o`2Ioooooooo07;oool00`000?ooooooo`2>oooo000Joooo00?o09Wooooo
ool0L_ooo`80002?oooo000Joooo00?o09Woooooool0L_ooo`030000oooooooo08koool001[oool0
0ol0VOooooooo`1boooo00<0003oooooool0S_ooo`006_ooo`03o`2Ioooooooo07;oool00`000?oo
ooooo`2>oooo000Joooo00?o09Woooooool0L_ooo`80002?oooo000Joooo00?o09Woooooool0L_oo
o`030000oooooooo08koool001[oool00ol0VOooooooo`1Ioooo0P0000Coool200001Oooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool001[oool00ol0VOooooooo`1Hoooo00@0
003oooooool0000:oooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?oo
ooooo`2>oooo000Joooo00?o09Woooooool0F?ooo`040000oooooooo00002_ooo`030000oooooooo
00Coool00`000?ooooooo`02oooo0`0008koool001[oool00ol0VOooooooo`1Hoooo00@0003ooooo
ool0000;oooo00@0003oooooooooool200001Oooo`030000oooooooo08koool001[oool00ol0VOoo
ooooo`1Hoooo00@0003oooooool00008oooo00@0003oooooool00003oooo00<0003oooooool01?oo
o`030000oooooooo08koool001[oool00ol0VOooooooo`1Ioooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`006_ooo`03o`2Ioooooooo07;oool20000Soooo`006_ooo`03o`2I
oooooooo07;oool00`000?ooooooo`2>oooo000Joooo00?o09Woooooool0L_ooo`030000oooooooo
08koool001[oool00ol0VOooooooo`1boooo00<0003oooooool0S_ooo`006_ooo`03o`2Ioooooooo
07;oool20000Soooo`006_ooo`03o`2Ioooooooo07;oool00`000?ooooooo`2>oooo000Joooo00?o
09Woooooool0L_ooo`030000oooooooo08koool001[oool00ol0VOooooooo`1boooo00<0003ooooo
ool0S_ooo`006_ooo`03o`2Ioooooooo07;oool20000Soooo`006_ooo`03o`2Ioooooooo07;oool0
0`000?ooooooo`2>oooo000Joooo00?o09Woooooool0L_ooo`030000oooooooo08koool001[oool0
0ol0VOooooooo`1boooo00<0003oooooool0S_ooo`006_ooo`03o`2Ioooooooo07;oool20000Sooo
o`006_ooo`03o`2Ioooooooo07;oool00`000?ooooooo`2>oooo000Joooo00?o09Woooooool0J_oo
o`D00003oooo00<0003oooooool0S_ooo`006_ooo`03o`2Ioooooooo06coool00`000?ooooooo`03
oooo00<0003oooooool0S_ooo`006_ooo`03o`2Ioooooooo06coool00`000?ooooooo`03oooo0`00
08koool008Woool00`000?ooooooo`2Doooo0029oooo00<0003oooooool0U?ooo`00R?ooo`80002F
oooo003ooooo8Oooo`00ooooob7oool007Woool00`000?ooooooo`0Xoooo00<0003oooooool0NOoo
o`00N?ooo`030000oooooooo00Soool00`000?ooooooo`0Ooooo00<0003oooooool0N?ooo`00N?oo
o`030000oooooooo00;oool200001?ooo`030000oooooooo00coool500000_ooo`800003oooo0`00
00Coool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000000_ooo`030000oooooooo
00;oool00`000?ooooooo`04oooo100000Goool00`000?ooooooo`09oooo00<0003oooooool00_oo
o`030000oooooooo07Soool007Ooool00`000?ooooooo`02oooo00<0003oooooool05Oooo`030000
oooooooo00Soool300001?ooo`030000oooooooo07Ooool007Soool00`000?ooooooo`0500005?oo
o`030000oooooooo00Ooool010000?ooooooo`0000?oool00`000?ooooooo`1hoooo001hoooo00D0
003oooooooooool000005oooo`030000oooooooo00Ooool010000?ooooooo`0000?oool00`000?oo
ooooo`1hoooo001ioooo00<0003oooooool05oooo`80000:oooo0`0000;oool00`000?ooooooo`1i
oooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {290.125, 148.813}} -> {-0.349561, \
1.05307, 0.00349883, 0.00566123}, {{79.875, 308.563}, {290.125, 148.813}} -> \
{-6.04337, 1.32095, 0.024893, 0.0127866}, {{79.875, 308.563}, {290.125, \
148.813}} -> {-6.04337, 1.32095, 0.024893, 0.0127866}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.85) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.03279 .30902 L
.04262 .30902 L
.04517 .30902 L
.04642 .30902 L
.04758 .30902 L
s
.04758 .30902 m
.04764 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.85) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`03oooo00?o09Woool000001ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Koool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`0Eoooo000Foooo00<0003ooooo
ool00oooo`03o`2Ioooooooo01ooool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000
oooooooo02Goool00`000?ooooooo`0Uoooo00<0003oooooool09_ooo`030000oooooooo01Goool0
01coool00ol0VOooooooo`1`oooo00<0003oooooool0S_ooo`007?ooo`03o`2Ioooooooo073oool2
0000Soooo`007?ooo`03o`2Ioooooooo073oool00`000?ooooooo`2>oooo000Loooo00?o09Wooooo
ool0L?ooo`030000oooooooo08koool001coool00ol0VOooooooo`1`oooo00<0003oooooool0S_oo
o`007?ooo`03o`2Ioooooooo073oool20000Soooo`007?ooo`03o`2Ioooooooo073oool00`000?oo
ooooo`2>oooo000Loooo00?o09Woooooool0L?ooo`030000oooooooo08koool001coool00ol0VOoo
ooooo`1`oooo00<0003oooooool0S_ooo`007?ooo`03o`2Ioooooooo073oool20000Soooo`007?oo
o`03o`2Ioooooooo073oool00`000?ooooooo`2>oooo000Loooo00?o09Woooooool0L?ooo`030000
oooooooo08koool001coool00ol0VOooooooo`1`oooo00<0003oooooool0S_ooo`007?ooo`03o`2I
oooooooo073oool20000Soooo`007?ooo`03o`2Ioooooooo073oool00`000?ooooooo`2>oooo000L
oooo00?o09Woooooool0Eoooo`800004oooo0P0000?oool400000oooo`800005oooo00<0003ooooo
ool0S_ooo`007?ooo`03o`2Ioooooooo05Koool010000?ooooooo`0000Soool00`000?ooooooo`03
oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`007?ooo`03o`2Ioooooooo05Koool0
10000?ooooooo`0000Woool00`000?ooooooo`05oooo00<0003oooooool00_ooo`<0002>oooo000L
oooo00?o09Woooooool0E_ooo`040000oooooooo00002_ooo`030000oooooooo00;oool200001Ooo
o`030000oooooooo08koool001coool00ol0VOooooooo`1Foooo00@0003oooooool00008oooo00@0
003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo08koool001coool00ol0VOoo
ooooo`1Goooo0P0000[oool200001?ooo`<00004oooo00<0003oooooool0S_ooo`007?ooo`03o`2I
oooooooo073oool20000Soooo`007?ooo`03o`2Ioooooooo073oool00`000?ooooooo`2>oooo000L
oooo00?o09Woooooool0L?ooo`030000oooooooo08koool001coool00ol0VOooooooo`1`oooo00<0
003oooooool0S_ooo`007?ooo`03o`2Ioooooooo073oool20000Soooo`007?ooo`03o`2Ioooooooo
073oool00`000?ooooooo`2>oooo000Loooo00?o09Woooooool0L?ooo`030000oooooooo08koool0
01coool00ol0VOooooooo`1`oooo00<0003oooooool0S_ooo`007?ooo`03o`2Ioooooooo073oool2
0000Soooo`007?ooo`03o`2Ioooooooo073oool00`000?ooooooo`2>oooo000Loooo00?o09Wooooo
ool0L?ooo`030000oooooooo08koool001coool00ol0VOooooooo`1`oooo00<0003oooooool0S_oo
o`007?ooo`03o`2Ioooooooo073oool20000Soooo`007?ooo`03o`2Ioooooooo073oool00`000?oo
ooooo`2>oooo000Loooo00?o09Woooooool0GOooo`800004oooo0P0000Coool200001Oooo`030000
oooooooo08koool001coool00ol0VOooooooo`1Loooo00@0003oooooool00008oooo00@0003ooooo
ool00004oooo00<0003oooooool0S_ooo`007?ooo`03o`2Ioooooooo05coool010000?ooooooo`00
00_oool00`000?ooooooo`02oooo0`0008koool001coool00ol0VOooooooo`1Loooo00@0003ooooo
ool00009oooo0P0000Goool00`000?ooooooo`2>oooo000Loooo00?o09Woooooool0G?ooo`040000
oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo000Loooo00?o09Wooooo
ool0GOooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo000Loooo00?o09Woooooool0L?oo
o`80002?oooo000Loooo00?o09Woooooool0L?ooo`030000oooooooo08koool001coool00ol0VOoo
ooooo`1`oooo00<0003oooooool0S_ooo`007?ooo`03o`2Ioooooooo073oool20000Soooo`007?oo
o`03o`2Ioooooooo073oool00`000?ooooooo`2>oooo000Loooo00?o09Woooooool0L?ooo`030000
oooooooo08koool001coool00ol0VOooooooo`1`oooo00<0003oooooool0S_ooo`007?ooo`03o`2I
oooooooo073oool20000Soooo`007?ooo`03o`2Ioooooooo073oool00`000?ooooooo`2>oooo000L
oooo00?o09Woooooool0L?ooo`030000oooooooo08koool001coool00ol0VOooooooo`1`oooo00<0
003oooooool0S_ooo`007?ooo`03o`2Ioooooooo073oool20000Soooo`007?ooo`03o`2Ioooooooo
073oool00`000?ooooooo`2>oooo000Loooo00?o09Woooooool0Eoooo`800004oooo0P0000Goool0
0`000?ooooooo`02oooo0P0000Goool00`000?ooooooo`2>oooo000Loooo00?o09Woooooool0E_oo
o`040000oooooooo00002_ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0
003oooooool0S_ooo`007?ooo`03o`2Ioooooooo05Koool010000?ooooooo`0000[oool00`000?oo
ooooo`04oooo00<0003oooooool00_ooo`<0002>oooo000Loooo00?o09Woooooool0E_ooo`040000
oooooooo00002oooo`040000oooooooooooo0P0000Goool00`000?ooooooo`2>oooo000Loooo00?o
09Woooooool0E_ooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo
00Coool00`000?ooooooo`2>oooo000Loooo00?o09Woooooool0Eoooo`800009oooo100000?oool3
00001?ooo`030000oooooooo08koool001coool00ol0VOooooooo`1`oooo0P0008ooool001coool0
0ol0VOooooooo`1`oooo00<0003oooooool0S_ooo`007?ooo`03o`2Ioooooooo073oool00`000?oo
ooooo`2>oooo000Loooo00?o09Woooooool0L?ooo`030000oooooooo08koool001coool00ol0VOoo
ooooo`1`oooo0P0008ooool001coool00ol0VOooooooo`1`oooo00<0003oooooool0S_ooo`007?oo
o`03o`2Ioooooooo073oool00`000?ooooooo`2>oooo000Loooo00?o09Woooooool0L?ooo`030000
oooooooo08koool001coool00ol0VOooooooo`1`oooo0P0008ooool001coool00ol0VOooooooo`1`
oooo00<0003oooooool0S_ooo`007?ooo`03o`2Ioooooooo073oool00`000?ooooooo`2>oooo000L
oooo00?o09Woooooool0L?ooo`030000oooooooo08koool001coool00ol0VOooooooo`1`oooo0P00
08ooool001coool00ol0VOooooooo`1`oooo00<0003oooooool0S_ooo`007?ooo`03o`2Ioooooooo
06Soool500000oooo`030000oooooooo08koool001coool00ol0VOooooooo`1Zoooo00<0003ooooo
ool00oooo`030000oooooooo08koool001coool00ol0VOooooooo`1Zoooo00<0003oooooool00ooo
o`<0002>oooo0029oooo00<0003oooooool0U?ooo`00ROooo`030000oooooooo09Coool008Soool2
0000U_ooo`00ooooob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000oooooooo
07Koool007Goool00`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool0
07Goool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200001?oo
o`800004oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000000_oo
o`030000oooooooo00;oool00`000?ooooooo`04oooo100000Goool00`000?ooooooo`07oooo00@0
003oooooool00002oooo00@0003oooooool00003oooo00<0003oooooool0MOooo`00M?ooo`030000
oooooooo00;oool00`000?ooooooo`0Eoooo00<0003oooooool01oooo`040000oooooooo00001Ooo
o`030000oooooooo00;oool00`000?ooooooo`1doooo001eoooo00<0003oooooool01@0001Coool0
0`000?ooooooo`08oooo0P0000Coool200001?ooo`030000oooooooo07Goool007Goool01@000?oo
ooooooooo`00000Goooo00<0003oooooool01oooo`040000oooooooo00000oooo`030000oooooooo
00?oool00`000?ooooooo`1eoooo001foooo00<0003oooooool05oooo`80000:oooo0P0000Coool3
00000_ooo`030000oooooooo07Koool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.03279 .30902 L
.04262 .30902 L
.04758 .30902 L
.0503 .30902 L
.05288 .30902 L
.05405 .30902 L
.05528 .30902 L
s
.05528 .30902 m
.05535 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Koool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`0Eoooo000Foooo00<0003ooooo
ool01Oooo`03o`2Ioooooooo01goool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000
oooooooo02Goool00`000?ooooooo`0Uoooo00<0003oooooool09_ooo`030000oooooooo01Goool0
01koool00ol0VOooooooo`1^oooo00<0003oooooool0S_ooo`007_ooo`03o`2Ioooooooo06koool2
0000Soooo`007_ooo`03o`2Ioooooooo06koool00`000?ooooooo`2>oooo000Noooo00?o09Wooooo
ool0K_ooo`030000oooooooo08koool001koool00ol0VOooooooo`1^oooo00<0003oooooool0S_oo
o`007_ooo`03o`2Ioooooooo06koool20000Soooo`007_ooo`03o`2Ioooooooo06koool00`000?oo
ooooo`2>oooo000Noooo00?o09Woooooool0K_ooo`030000oooooooo08koool001koool00ol0VOoo
ooooo`1^oooo00<0003oooooool0S_ooo`007_ooo`03o`2Ioooooooo06koool20000Soooo`007_oo
o`03o`2Ioooooooo06koool00`000?ooooooo`2>oooo000Noooo00?o09Woooooool0K_ooo`030000
oooooooo08koool001koool00ol0VOooooooo`1^oooo00<0003oooooool0S_ooo`007_ooo`03o`2I
oooooooo06koool20000Soooo`007_ooo`03o`2Ioooooooo06koool00`000?ooooooo`2>oooo000N
oooo00?o09Woooooool0EOooo`800004oooo0P0000?oool400000oooo`800005oooo00<0003ooooo
ool0S_ooo`007_ooo`03o`2Ioooooooo05Coool010000?ooooooo`0000Soool00`000?ooooooo`03
oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`007_ooo`03o`2Ioooooooo05Coool0
10000?ooooooo`0000Woool00`000?ooooooo`05oooo00<0003oooooool00_ooo`<0002>oooo000N
oooo00?o09Woooooool0E?ooo`040000oooooooo00002_ooo`030000oooooooo00;oool200001Ooo
o`030000oooooooo08koool001koool00ol0VOooooooo`1Doooo00@0003oooooool00008oooo00@0
003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo08koool001koool00ol0VOoo
ooooo`1Eoooo0P0000[oool200001?ooo`<00004oooo00<0003oooooool0S_ooo`007_ooo`03o`2I
oooooooo06koool20000Soooo`007_ooo`03o`2Ioooooooo06koool00`000?ooooooo`2>oooo000N
oooo00?o09Woooooool0K_ooo`030000oooooooo08koool001koool00ol0VOooooooo`1^oooo00<0
003oooooool0S_ooo`007_ooo`03o`2Ioooooooo06koool20000Soooo`007_ooo`03o`2Ioooooooo
06koool00`000?ooooooo`2>oooo000Noooo00?o09Woooooool0K_ooo`030000oooooooo08koool0
01koool00ol0VOooooooo`1^oooo00<0003oooooool0S_ooo`007_ooo`03o`2Ioooooooo06koool2
0000Soooo`007_ooo`03o`2Ioooooooo06koool00`000?ooooooo`2>oooo000Noooo00?o09Wooooo
ool0K_ooo`030000oooooooo08koool001koool00ol0VOooooooo`1^oooo00<0003oooooool0S_oo
o`007_ooo`03o`2Ioooooooo06koool20000Soooo`007_ooo`03o`2Ioooooooo06koool00`000?oo
ooooo`2>oooo000Noooo00?o09Woooooool0Foooo`800004oooo0P0000Coool200001Oooo`030000
oooooooo08koool001koool00ol0VOooooooo`1Joooo00@0003oooooool00008oooo00@0003ooooo
ool00004oooo00<0003oooooool0S_ooo`007_ooo`03o`2Ioooooooo05[oool010000?ooooooo`00
00_oool00`000?ooooooo`02oooo0`0008koool001koool00ol0VOooooooo`1Joooo00@0003ooooo
ool00009oooo0P0000Goool00`000?ooooooo`2>oooo000Noooo00?o09Woooooool0F_ooo`040000
oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo000Noooo00?o09Wooooo
ool0Foooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo000Noooo00?o09Woooooool0K_oo
o`80002?oooo000Noooo00?o09Woooooool0K_ooo`030000oooooooo08koool001koool00ol0VOoo
ooooo`1^oooo00<0003oooooool0S_ooo`007_ooo`03o`2Ioooooooo06koool20000Soooo`007_oo
o`03o`2Ioooooooo06koool00`000?ooooooo`2>oooo000Noooo00?o09Woooooool0K_ooo`030000
oooooooo08koool001koool00ol0VOooooooo`1^oooo00<0003oooooool0S_ooo`007_ooo`03o`2I
oooooooo06koool20000Soooo`007_ooo`03o`2Ioooooooo06koool00`000?ooooooo`2>oooo000N
oooo00?o09Woooooool0K_ooo`030000oooooooo08koool001koool00ol0VOooooooo`1^oooo00<0
003oooooool0S_ooo`007_ooo`03o`2Ioooooooo06koool20000Soooo`007_ooo`03o`2Ioooooooo
06koool00`000?ooooooo`2>oooo000Noooo00?o09Woooooool0EOooo`800004oooo0P0000Goool0
0`000?ooooooo`02oooo0P0000Goool00`000?ooooooo`2>oooo000Noooo00?o09Woooooool0E?oo
o`040000oooooooo00002_ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0
003oooooool0S_ooo`007_ooo`03o`2Ioooooooo05Coool010000?ooooooo`0000[oool00`000?oo
ooooo`04oooo00<0003oooooool00_ooo`<0002>oooo000Noooo00?o09Woooooool0E?ooo`040000
oooooooo00002oooo`040000oooooooooooo0P0000Goool00`000?ooooooo`2>oooo000Noooo00?o
09Woooooool0E?ooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo
00Coool00`000?ooooooo`2>oooo000Noooo00?o09Woooooool0EOooo`800009oooo100000?oool3
00001?ooo`030000oooooooo08koool001koool00ol0VOooooooo`1^oooo0P0008ooool001koool0
0ol0VOooooooo`1^oooo00<0003oooooool0S_ooo`007_ooo`03o`2Ioooooooo06koool00`000?oo
ooooo`2>oooo000Noooo00?o09Woooooool0K_ooo`030000oooooooo08koool001koool00ol0VOoo
ooooo`1^oooo0P0008ooool001koool00ol0VOooooooo`1^oooo00<0003oooooool0S_ooo`007_oo
o`03o`2Ioooooooo06koool00`000?ooooooo`2>oooo000Noooo00?o09Woooooool0K_ooo`030000
oooooooo08koool001koool00ol0VOooooooo`1^oooo0P0008ooool001koool00ol0VOooooooo`1^
oooo00<0003oooooool0S_ooo`007_ooo`03o`2Ioooooooo06koool00`000?ooooooo`2>oooo000N
oooo00?o09Woooooool0K_ooo`030000oooooooo08koool001koool00ol0VOooooooo`1^oooo0P00
08ooool001koool00ol0VOooooooo`1^oooo00<0003oooooool0S_ooo`007_ooo`03o`2Ioooooooo
06Koool500000oooo`030000oooooooo08koool001koool00ol0VOooooooo`1Xoooo00<0003ooooo
ool00oooo`030000oooooooo08koool001koool00ol0VOooooooo`1Xoooo00<0003oooooool00ooo
o`<0002>oooo0029oooo00<0003oooooool0U?ooo`00ROooo`030000oooooooo09Coool008Soool2
0000U_ooo`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo
07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool0
07Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200001?oo
o`800004oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool01?ooo`@00005oooo00<0003oooooool01oooo`040000oooooooo
00000oooo`030000oooooooo07Soool007Ooool00`000?ooooooo`02oooo00<0003oooooool05Ooo
o`030000oooooooo00Ooool010000?ooooooo`0000Coool00`000?ooooooo`1goooo001hoooo00<0
003oooooool01@0001Coool00`000?ooooooo`08oooo0P0000Coool00`000?ooooooo`1hoooo001h
oooo00D0003oooooooooool000005oooo`030000oooooooo00Ooool010000?ooooooo`0000?oool0
0`000?ooooooo`1hoooo001ioooo00<0003oooooool05oooo`80000:oooo0P0000?oool00`000?oo
ooooo`1ioooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.75) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.04262 .30902 L
.0522 .30902 L
.05746 .30902 L
.06005 .30902 L
.06119 .30902 L
.06244 .30902 L
s
.06244 .30902 m
.06257 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.75) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003ooooo09T01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Koool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`0Eoooo000Foooo00<0003ooooo
ool01oooo`03o`2Ioooooooo01_oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000
oooooooo02Goool00`000?ooooooo`0Uoooo00<0003oooooool09_ooo`030000oooooooo01Goool0
023oool00ol0VOooooooo`1/oooo00<0003oooooool0S_ooo`008?ooo`03o`2Ioooooooo06coool2
0000Soooo`008?ooo`03o`2Ioooooooo06coool00`000?ooooooo`2>oooo000Poooo00?o09Wooooo
ool0K?ooo`030000oooooooo08koool0023oool00ol0VOooooooo`1/oooo00<0003oooooool0S_oo
o`008?ooo`03o`2Ioooooooo06coool20000Soooo`008?ooo`03o`2Ioooooooo06coool00`000?oo
ooooo`2>oooo000Poooo00?o09Woooooool0K?ooo`030000oooooooo08koool0023oool00ol0VOoo
ooooo`1/oooo00<0003oooooool0S_ooo`008?ooo`03o`2Ioooooooo06coool20000Soooo`008?oo
o`03o`2Ioooooooo06coool00`000?ooooooo`2>oooo000Poooo00?o09Woooooool0K?ooo`030000
oooooooo08koool0023oool00ol0VOooooooo`1/oooo00<0003oooooool0S_ooo`008?ooo`03o`2I
oooooooo06coool20000Soooo`008?ooo`03o`2Ioooooooo06coool00`000?ooooooo`2>oooo000P
oooo00?o09Woooooool0Doooo`800004oooo0P0000?oool400000oooo`800005oooo00<0003ooooo
ool0S_ooo`008?ooo`03o`2Ioooooooo05;oool010000?ooooooo`0000Soool00`000?ooooooo`03
oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`008?ooo`03o`2Ioooooooo05;oool0
10000?ooooooo`0000Woool00`000?ooooooo`05oooo00<0003oooooool00_ooo`<0002>oooo000P
oooo00?o09Woooooool0D_ooo`040000oooooooo00002_ooo`030000oooooooo00;oool200001Ooo
o`030000oooooooo08koool0023oool00ol0VOooooooo`1Boooo00@0003oooooool00008oooo00@0
003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo08koool0023oool00ol0VOoo
ooooo`1Coooo0P0000[oool200001?ooo`<00004oooo00<0003oooooool0S_ooo`008?ooo`03o`2I
oooooooo06coool20000Soooo`008?ooo`03o`2Ioooooooo06coool00`000?ooooooo`2>oooo000P
oooo00?o09Woooooool0K?ooo`030000oooooooo08koool0023oool00ol0VOooooooo`1/oooo00<0
003oooooool0S_ooo`008?ooo`03o`2Ioooooooo06coool20000Soooo`008?ooo`03o`2Ioooooooo
06coool00`000?ooooooo`2>oooo000Poooo00?o09Woooooool0K?ooo`030000oooooooo08koool0
023oool00ol0VOooooooo`1/oooo00<0003oooooool0S_ooo`008?ooo`03o`2Ioooooooo06coool2
0000Soooo`008?ooo`03o`2Ioooooooo06coool00`000?ooooooo`2>oooo000Poooo00?o09Wooooo
ool0K?ooo`030000oooooooo08koool0023oool00ol0VOooooooo`1/oooo00<0003oooooool0S_oo
o`008?ooo`03o`2Ioooooooo06coool20000Soooo`008?ooo`03o`2Ioooooooo06coool00`000?oo
ooooo`2>oooo000Poooo00?o09Woooooool0FOooo`800004oooo0P0000Coool200001Oooo`030000
oooooooo08koool0023oool00ol0VOooooooo`1Hoooo00@0003oooooool00008oooo00@0003ooooo
ool00004oooo00<0003oooooool0S_ooo`008?ooo`03o`2Ioooooooo05Soool010000?ooooooo`00
00_oool00`000?ooooooo`02oooo0`0008koool0023oool00ol0VOooooooo`1Hoooo00@0003ooooo
ool00009oooo0P0000Goool00`000?ooooooo`2>oooo000Poooo00?o09Woooooool0F?ooo`040000
oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo000Poooo00?o09Wooooo
ool0FOooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo000Poooo00?o09Woooooool0K?oo
o`80002?oooo000Poooo00?o09Woooooool0K?ooo`030000oooooooo08koool0023oool00ol0VOoo
ooooo`1/oooo00<0003oooooool0S_ooo`008?ooo`03o`2Ioooooooo06coool20000Soooo`008?oo
o`03o`2Ioooooooo06coool00`000?ooooooo`2>oooo000Poooo00?o09Woooooool0K?ooo`030000
oooooooo08koool0023oool00ol0VOooooooo`1/oooo00<0003oooooool0S_ooo`008?ooo`03o`2I
oooooooo06coool20000Soooo`008?ooo`03o`2Ioooooooo06coool00`000?ooooooo`2>oooo000P
oooo00?o09Woooooool0K?ooo`030000oooooooo08koool0023oool00ol0VOooooooo`1/oooo00<0
003oooooool0S_ooo`008?ooo`03o`2Ioooooooo06coool20000Soooo`008?ooo`03o`2Ioooooooo
06coool00`000?ooooooo`2>oooo000Poooo00?o09Woooooool0Doooo`800004oooo0P0000Goool0
0`000?ooooooo`02oooo0P0000Goool00`000?ooooooo`2>oooo000Poooo00?o09Woooooool0D_oo
o`040000oooooooo00002_ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0
003oooooool0S_ooo`008?ooo`03o`2Ioooooooo05;oool010000?ooooooo`0000[oool00`000?oo
ooooo`04oooo00<0003oooooool00_ooo`<0002>oooo000Poooo00?o09Woooooool0D_ooo`040000
oooooooo00002oooo`040000oooooooooooo0P0000Goool00`000?ooooooo`2>oooo000Poooo00?o
09Woooooool0D_ooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo
00Coool00`000?ooooooo`2>oooo000Poooo00?o09Woooooool0Doooo`800009oooo100000?oool3
00001?ooo`030000oooooooo08koool0023oool00ol0VOooooooo`1/oooo0P0008ooool0023oool0
0ol0VOooooooo`1/oooo00<0003oooooool0S_ooo`008?ooo`03o`2Ioooooooo06coool00`000?oo
ooooo`2>oooo000Poooo00?o09Woooooool0K?ooo`030000oooooooo08koool0023oool00ol0VOoo
ooooo`1/oooo0P0008ooool0023oool00ol0VOooooooo`1/oooo00<0003oooooool0S_ooo`008?oo
o`03o`2Ioooooooo06coool00`000?ooooooo`2>oooo000Poooo00?o09Woooooool0K?ooo`030000
oooooooo08koool0023oool00ol0VOooooooo`1/oooo0P0008ooool0023oool00ol0VOooooooo`1/
oooo00<0003oooooool0S_ooo`008?ooo`03o`2Ioooooooo06coool00`000?ooooooo`2>oooo000P
oooo00?o09Woooooool0K?ooo`030000oooooooo08koool0023oool00ol0VOooooooo`1/oooo0P00
08ooool0023oool00ol0VOooooooo`1/oooo00<0003oooooool0S_ooo`008?ooo`03o`2Ioooooooo
06Coool500000oooo`030000oooooooo08koool0023oool00ol0VOooooooo`1Voooo00<0003ooooo
ool00oooo`030000oooooooo08koool0023oool00ol0VOooooooo`1Voooo00<0003oooooool00ooo
o`<0002>oooo0029oooo00<0003oooooool0U?ooo`00ROooo`030000oooooooo09Coool008Soool2
0000U_ooo`00ooooob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000oooooooo
07Koool007Goool00`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool0
07Goool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200001Ooo
o`030000oooooooo00;oool200001?ooo`030000oooooooo07Goool007Goool01@000?oooooooooo
o`000002oooo00<0003oooooool00_ooo`030000oooooooo00Coool400001Oooo`030000oooooooo
00Woool01@000?ooooooooooo`000002oooo00D0003oooooooooool00000Moooo`00M?ooo`030000
oooooooo00;oool00`000?ooooooo`0Eoooo00<0003oooooool02Oooo`030000oooooooo00Coool0
0`000?ooooooo`02oooo00<0003oooooool0M?ooo`00MOooo`030000oooooooo00D0000Doooo00<0
003oooooool02_ooo`040000oooooooooooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0
003oooooooooool000005oooo`030000oooooooo00Ooool010000?ooooooo`0000?oool00`000?oo
ooooo`03oooo00<0003oooooool0MOooo`00M_ooo`030000oooooooo01Ooool200002Oooo`@00003
oooo0`0000;oool00`000?ooooooo`1foooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.7) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.04262 .30902 L
.0522 .30902 L
.06244 .30902 L
.06525 .30902 L
.0679 .30902 L
.06905 .30902 L
.07027 .30902 L
.07091 .30902 L
s
.07091 .30902 m
.07098 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.7) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00D0003ooooooooooooo
09T00oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Koool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool0
0`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`0Eoooo000Foooo00<0
003oooooool02Oooo`03o`2Ioooooooo01Woool00`000?ooooooo`0Voooo00<0003oooooool09Ooo
o`030000oooooooo02Goool00`000?ooooooo`0Uoooo00<0003oooooool09_ooo`030000oooooooo
01Goool002;oool00ol0VOooooooo`1Zoooo00<0003oooooool0S_ooo`008_ooo`03o`2Ioooooooo
06[oool20000Soooo`008_ooo`03o`2Ioooooooo06[oool00`000?ooooooo`2>oooo000Roooo00?o
09Woooooool0J_ooo`030000oooooooo08koool002;oool00ol0VOooooooo`1Zoooo00<0003ooooo
ool0S_ooo`008_ooo`03o`2Ioooooooo06[oool20000Soooo`008_ooo`03o`2Ioooooooo06[oool0
0`000?ooooooo`2>oooo000Roooo00?o09Woooooool0J_ooo`030000oooooooo08koool002;oool0
0ol0VOooooooo`1Zoooo00<0003oooooool0S_ooo`008_ooo`03o`2Ioooooooo06[oool20000Sooo
o`008_ooo`03o`2Ioooooooo06[oool00`000?ooooooo`2>oooo000Roooo00?o09Woooooool0J_oo
o`030000oooooooo08koool002;oool00ol0VOooooooo`1Zoooo00<0003oooooool0S_ooo`008_oo
o`03o`2Ioooooooo06[oool20000Soooo`008_ooo`03o`2Ioooooooo06[oool00`000?ooooooo`2>
oooo000Roooo00?o09Woooooool0DOooo`800004oooo0P0000?oool400000oooo`800005oooo00<0
003oooooool0S_ooo`008_ooo`03o`2Ioooooooo053oool010000?ooooooo`0000Soool00`000?oo
ooooo`03oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`008_ooo`03o`2Ioooooooo
053oool010000?ooooooo`0000Woool00`000?ooooooo`05oooo00<0003oooooool00_ooo`<0002>
oooo000Roooo00?o09Woooooool0D?ooo`040000oooooooo00002_ooo`030000oooooooo00;oool2
00001Oooo`030000oooooooo08koool002;oool00ol0VOooooooo`1@oooo00@0003oooooool00008
oooo00@0003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo08koool002;oool0
0ol0VOooooooo`1Aoooo0P0000[oool200001?ooo`<00004oooo00<0003oooooool0S_ooo`008_oo
o`03o`2Ioooooooo06[oool20000Soooo`008_ooo`03o`2Ioooooooo06[oool00`000?ooooooo`2>
oooo000Roooo00?o09Woooooool0J_ooo`030000oooooooo08koool002;oool00ol0VOooooooo`1Z
oooo00<0003oooooool0S_ooo`008_ooo`03o`2Ioooooooo06[oool20000Soooo`008_ooo`03o`2I
oooooooo06[oool00`000?ooooooo`2>oooo000Roooo00?o09Woooooool0J_ooo`030000oooooooo
08koool002;oool00ol0VOooooooo`1Zoooo00<0003oooooool0S_ooo`008_ooo`03o`2Ioooooooo
06[oool20000Soooo`008_ooo`03o`2Ioooooooo06[oool00`000?ooooooo`2>oooo000Roooo00?o
09Woooooool0J_ooo`030000oooooooo08koool002;oool00ol0VOooooooo`1Zoooo00<0003ooooo
ool0S_ooo`008_ooo`03o`2Ioooooooo06[oool20000Soooo`008_ooo`03o`2Ioooooooo06[oool0
0`000?ooooooo`2>oooo000Roooo00?o09Woooooool0Eoooo`800004oooo0P0000Coool200001Ooo
o`030000oooooooo08koool002;oool00ol0VOooooooo`1Foooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`008_ooo`03o`2Ioooooooo05Koool010000?oo
ooooo`0000_oool00`000?ooooooo`02oooo0`0008koool002;oool00ol0VOooooooo`1Foooo00@0
003oooooool00009oooo0P0000Goool00`000?ooooooo`2>oooo000Roooo00?o09Woooooool0E_oo
o`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo000Roooo00?o
09Woooooool0Eoooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo000Roooo00?o09Wooooo
ool0J_ooo`80002?oooo000Roooo00?o09Woooooool0J_ooo`030000oooooooo08koool002;oool0
0ol0VOooooooo`1Zoooo00<0003oooooool0S_ooo`008_ooo`03o`2Ioooooooo06[oool20000Sooo
o`008_ooo`03o`2Ioooooooo06[oool00`000?ooooooo`2>oooo000Roooo00?o09Woooooool0J_oo
o`030000oooooooo08koool002;oool00ol0VOooooooo`1Zoooo00<0003oooooool0S_ooo`008_oo
o`03o`2Ioooooooo06[oool20000Soooo`008_ooo`03o`2Ioooooooo06[oool00`000?ooooooo`2>
oooo000Roooo00?o09Woooooool0J_ooo`030000oooooooo08koool002;oool00ol0VOooooooo`1Z
oooo00<0003oooooool0S_ooo`008_ooo`03o`2Ioooooooo06[oool20000Soooo`008_ooo`03o`2I
oooooooo06[oool00`000?ooooooo`2>oooo000Roooo00?o09Woooooool0DOooo`800004oooo0P00
00Goool00`000?ooooooo`02oooo0P0000Goool00`000?ooooooo`2>oooo000Roooo00?o09Wooooo
ool0D?ooo`040000oooooooo00002_ooo`050000oooooooooooo000000;oool00`000?ooooooo`02
oooo00<0003oooooool0S_ooo`008_ooo`03o`2Ioooooooo053oool010000?ooooooo`0000[oool0
0`000?ooooooo`04oooo00<0003oooooool00_ooo`<0002>oooo000Roooo00?o09Woooooool0D?oo
o`040000oooooooo00002oooo`040000oooooooooooo0P0000Goool00`000?ooooooo`2>oooo000R
oooo00?o09Woooooool0D?ooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000
oooooooo00Coool00`000?ooooooo`2>oooo000Roooo00?o09Woooooool0DOooo`800009oooo1000
00?oool300001?ooo`030000oooooooo08koool002;oool00ol0VOooooooo`1Zoooo0P0008ooool0
02;oool00ol0VOooooooo`1Zoooo00<0003oooooool0S_ooo`008_ooo`03o`2Ioooooooo06[oool0
0`000?ooooooo`2>oooo000Roooo00?o09Woooooool0J_ooo`030000oooooooo08koool002;oool0
0ol0VOooooooo`1Zoooo0P0008ooool002;oool00ol0VOooooooo`1Zoooo00<0003oooooool0S_oo
o`008_ooo`03o`2Ioooooooo06[oool00`000?ooooooo`2>oooo000Roooo00?o09Woooooool0J_oo
o`030000oooooooo08koool002;oool00ol0VOooooooo`1Zoooo0P0008ooool002;oool00ol0VOoo
ooooo`1Zoooo00<0003oooooool0S_ooo`008_ooo`03o`2Ioooooooo06[oool00`000?ooooooo`2>
oooo000Roooo00?o09Woooooool0J_ooo`030000oooooooo08koool002;oool00ol0VOooooooo`1Z
oooo0P0008ooool002;oool00ol0VOooooooo`1Zoooo00<0003oooooool0S_ooo`008_ooo`03o`2I
oooooooo06;oool500000oooo`030000oooooooo08koool002;oool00ol0VOooooooo`1Toooo00<0
003oooooool00oooo`030000oooooooo08koool002;oool00ol0VOooooooo`1Toooo00<0003ooooo
ool00oooo`<0002>oooo0029oooo00<0003oooooool0U?ooo`00ROooo`030000oooooooo09Coool0
08Soool20000U_ooo`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000
oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo
07Soool007Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool2
00001Oooo`030000oooooooo00;oool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool0
00000_ooo`030000oooooooo00;oool00`000?ooooooo`04oooo100000Goool00`000?ooooooo`09
oooo00<0003oooooool00_ooo`030000oooooooo07Soool007Ooool00`000?ooooooo`02oooo00<0
003oooooool05Oooo`030000oooooooo00Woool00`000?ooooooo`03oooo00<0003oooooool0Mooo
o`00N?ooo`030000oooooooo00D0000Doooo00<0003oooooool02_ooo`050000oooooooooooo0000
07[oool007Soool01@000?ooooooooooo`00000Goooo00<0003oooooool01oooo`040000oooooooo
00000oooo`030000oooooooo07Soool007Woool00`000?ooooooo`0Goooo0P0000Woool400000_oo
o`030000oooooooo07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.65) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.04262 .30902 L
.06244 .30902 L
.06747 .30902 L
.07286 .30902 L
.07547 .30902 L
.07675 .30902 L
.07793 .30902 L
.07901 .30902 L
s
.07901 .30902 m
.07912 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.65) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003oooooool00ooo
o`03o`2Ioooo000000Ooool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Koool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`0Eoooo000Foooo00<0003ooooo
ool02oooo`03o`2Ioooooooo01Ooool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000
oooooooo02Goool00`000?ooooooo`0Uoooo00<0003oooooool09_ooo`030000oooooooo01Goool0
02Coool00ol0VOooooooo`1Xoooo00<0003oooooool0S_ooo`009?ooo`03o`2Ioooooooo06Soool2
0000Soooo`009?ooo`03o`2Ioooooooo06Soool00`000?ooooooo`2>oooo000Toooo00?o09Wooooo
ool0J?ooo`030000oooooooo08koool002Coool00ol0VOooooooo`1Xoooo00<0003oooooool0S_oo
o`009?ooo`03o`2Ioooooooo06Soool20000Soooo`009?ooo`03o`2Ioooooooo06Soool00`000?oo
ooooo`2>oooo000Toooo00?o09Woooooool0J?ooo`030000oooooooo08koool002Coool00ol0VOoo
ooooo`1Xoooo00<0003oooooool0S_ooo`009?ooo`03o`2Ioooooooo06Soool20000Soooo`009?oo
o`03o`2Ioooooooo06Soool00`000?ooooooo`2>oooo000Toooo00?o09Woooooool0J?ooo`030000
oooooooo08koool002Coool00ol0VOooooooo`1Xoooo00<0003oooooool0S_ooo`009?ooo`03o`2I
oooooooo06Soool20000Soooo`009?ooo`03o`2Ioooooooo06Soool00`000?ooooooo`2>oooo000T
oooo00?o09Woooooool0Coooo`800004oooo0P0000?oool400000oooo`800005oooo00<0003ooooo
ool0S_ooo`009?ooo`03o`2Ioooooooo04koool010000?ooooooo`0000Soool00`000?ooooooo`03
oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`009?ooo`03o`2Ioooooooo04koool0
10000?ooooooo`0000Woool00`000?ooooooo`05oooo00<0003oooooool00_ooo`<0002>oooo000T
oooo00?o09Woooooool0C_ooo`040000oooooooo00002_ooo`030000oooooooo00;oool200001Ooo
o`030000oooooooo08koool002Coool00ol0VOooooooo`1>oooo00@0003oooooool00008oooo00@0
003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo08koool002Coool00ol0VOoo
ooooo`1?oooo0P0000[oool200001?ooo`<00004oooo00<0003oooooool0S_ooo`009?ooo`03o`2I
oooooooo06Soool20000Soooo`009?ooo`03o`2Ioooooooo06Soool00`000?ooooooo`2>oooo000T
oooo00?o09Woooooool0J?ooo`030000oooooooo08koool002Coool00ol0VOooooooo`1Xoooo00<0
003oooooool0S_ooo`009?ooo`03o`2Ioooooooo06Soool20000Soooo`009?ooo`03o`2Ioooooooo
06Soool00`000?ooooooo`2>oooo000Toooo00?o09Woooooool0J?ooo`030000oooooooo08koool0
02Coool00ol0VOooooooo`1Xoooo00<0003oooooool0S_ooo`009?ooo`03o`2Ioooooooo06Soool2
0000Soooo`009?ooo`03o`2Ioooooooo06Soool00`000?ooooooo`2>oooo000Toooo00?o09Wooooo
ool0J?ooo`030000oooooooo08koool002Coool00ol0VOooooooo`1Xoooo00<0003oooooool0S_oo
o`009?ooo`03o`2Ioooooooo06Soool20000Soooo`009?ooo`03o`2Ioooooooo06Soool00`000?oo
ooooo`2>oooo000Toooo00?o09Woooooool0EOooo`800004oooo0P0000Coool200001Oooo`030000
oooooooo08koool002Coool00ol0VOooooooo`1Doooo00@0003oooooool00008oooo00@0003ooooo
ool00004oooo00<0003oooooool0S_ooo`009?ooo`03o`2Ioooooooo05Coool010000?ooooooo`00
00_oool00`000?ooooooo`02oooo0`0008koool002Coool00ol0VOooooooo`1Doooo00@0003ooooo
ool00009oooo0P0000Goool00`000?ooooooo`2>oooo000Toooo00?o09Woooooool0E?ooo`040000
oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo000Toooo00?o09Wooooo
ool0EOooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo000Toooo00?o09Woooooool0J?oo
o`80002?oooo000Toooo00?o09Woooooool0J?ooo`030000oooooooo08koool002Coool00ol0VOoo
ooooo`1Xoooo00<0003oooooool0S_ooo`009?ooo`03o`2Ioooooooo06Soool20000Soooo`009?oo
o`03o`2Ioooooooo06Soool00`000?ooooooo`2>oooo000Toooo00?o09Woooooool0J?ooo`030000
oooooooo08koool002Coool00ol0VOooooooo`1Xoooo00<0003oooooool0S_ooo`009?ooo`03o`2I
oooooooo06Soool20000Soooo`009?ooo`03o`2Ioooooooo06Soool00`000?ooooooo`2>oooo000T
oooo00?o09Woooooool0J?ooo`030000oooooooo08koool002Coool00ol0VOooooooo`1Xoooo00<0
003oooooool0S_ooo`009?ooo`03o`2Ioooooooo06Soool20000Soooo`009?ooo`03o`2Ioooooooo
06Soool00`000?ooooooo`2>oooo000Toooo00?o09Woooooool0Coooo`800004oooo0P0000Goool0
0`000?ooooooo`02oooo0P0000Goool00`000?ooooooo`2>oooo000Toooo00?o09Woooooool0C_oo
o`040000oooooooo00002_ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0
003oooooool0S_ooo`009?ooo`03o`2Ioooooooo04koool010000?ooooooo`0000[oool00`000?oo
ooooo`04oooo00<0003oooooool00_ooo`<0002>oooo000Toooo00?o09Woooooool0C_ooo`040000
oooooooo00002oooo`040000oooooooooooo0P0000Goool00`000?ooooooo`2>oooo000Toooo00?o
09Woooooool0C_ooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo
00Coool00`000?ooooooo`2>oooo000Toooo00?o09Woooooool0Coooo`800009oooo100000?oool3
00001?ooo`030000oooooooo08koool002Coool00ol0VOooooooo`1Xoooo0P0008ooool002Coool0
0ol0VOooooooo`1Xoooo00<0003oooooool0S_ooo`009?ooo`03o`2Ioooooooo06Soool00`000?oo
ooooo`2>oooo000Toooo00?o09Woooooool0J?ooo`030000oooooooo08koool002Coool00ol0VOoo
ooooo`1Xoooo0P0008ooool002Coool00ol0VOooooooo`1Xoooo00<0003oooooool0S_ooo`009?oo
o`03o`2Ioooooooo06Soool00`000?ooooooo`2>oooo000Toooo00?o09Woooooool0J?ooo`030000
oooooooo08koool002Coool00ol0VOooooooo`1Xoooo0P0008ooool002Coool00ol0VOooooooo`1X
oooo00<0003oooooool0S_ooo`009?ooo`03o`2Ioooooooo06Soool00`000?ooooooo`2>oooo000T
oooo00?o09Woooooool0J?ooo`030000oooooooo08koool002Coool00ol0VOooooooo`1Xoooo0P00
08ooool002Coool00ol0VOooooooo`1Xoooo00<0003oooooool0S_ooo`009?ooo`03o`2Ioooooooo
063oool500000oooo`030000oooooooo08koool002Coool00ol0VOooooooo`1Roooo00<0003ooooo
ool00oooo`030000oooooooo08koool002Coool00ol0VOooooooo`1Roooo00<0003oooooool00ooo
o`<0002>oooo0029oooo00<0003oooooool0U?ooo`00ROooo`030000oooooooo09Coool008Soool2
0000U_ooo`00ooooob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000oooooooo
07Koool007Goool00`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool0
07Goool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200000ooo
o`<00004oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000000_oo
o`030000oooooooo00;oool00`000?ooooooo`04oooo100000Goool00`000?ooooooo`07oooo00@0
003oooooool00002oooo00@0003oooooool00003oooo00<0003oooooool0MOooo`00M?ooo`030000
oooooooo00;oool00`000?ooooooo`0Eoooo00<0003oooooool01oooo`040000oooooooo00001Ooo
o`030000oooooooo00;oool00`000?ooooooo`1doooo001eoooo00<0003oooooool01@0001Coool0
0`000?ooooooo`07oooo0`0000Coool200001?ooo`030000oooooooo07Goool007Goool01@000?oo
ooooooooo`00000Goooo00<0003oooooool02?ooo`030000oooooooo00?oool00`000?ooooooo`03
oooo00<0003oooooool0MOooo`00M_ooo`030000oooooooo01Ooool200002_ooo`<00003oooo0`00
00;oool00`000?ooooooo`1foooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.04262 .30902 L
.06244 .30902 L
.07216 .30902 L
.0775 .30902 L
.08255 .30902 L
.08542 .30902 L
.0862 .30902 L
.08703 .30902 L
s
.08703 .30902 m
.0871 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Koool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`0Eoooo000Foooo00<0003ooooo
ool03Oooo`03o`2Ioooooooo01Goool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000
oooooooo02Goool00`000?ooooooo`0Uoooo00<0003oooooool09_ooo`030000oooooooo01Goool0
02Koool00ol0VOooooooo`1Voooo00<0003oooooool0S_ooo`009_ooo`03o`2Ioooooooo06Koool2
0000Soooo`009_ooo`03o`2Ioooooooo06Koool00`000?ooooooo`2>oooo000Voooo00?o09Wooooo
ool0I_ooo`030000oooooooo08koool002Koool00ol0VOooooooo`1Voooo00<0003oooooool0S_oo
o`009_ooo`03o`2Ioooooooo06Koool20000Soooo`009_ooo`03o`2Ioooooooo06Koool00`000?oo
ooooo`2>oooo000Voooo00?o09Woooooool0I_ooo`030000oooooooo08koool002Koool00ol0VOoo
ooooo`1Voooo00<0003oooooool0S_ooo`009_ooo`03o`2Ioooooooo06Koool20000Soooo`009_oo
o`03o`2Ioooooooo06Koool00`000?ooooooo`2>oooo000Voooo00?o09Woooooool0I_ooo`030000
oooooooo08koool002Koool00ol0VOooooooo`1Voooo00<0003oooooool0S_ooo`009_ooo`03o`2I
oooooooo06Koool20000Soooo`009_ooo`03o`2Ioooooooo06Koool00`000?ooooooo`2>oooo000V
oooo00?o09Woooooool0COooo`800004oooo0P0000?oool400000oooo`800005oooo00<0003ooooo
ool0S_ooo`009_ooo`03o`2Ioooooooo04coool010000?ooooooo`0000Soool00`000?ooooooo`03
oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`009_ooo`03o`2Ioooooooo04coool0
10000?ooooooo`0000Woool00`000?ooooooo`05oooo00<0003oooooool00_ooo`<0002>oooo000V
oooo00?o09Woooooool0C?ooo`040000oooooooo00002_ooo`030000oooooooo00;oool200001Ooo
o`030000oooooooo08koool002Koool00ol0VOooooooo`1<oooo00@0003oooooool00008oooo00@0
003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo08koool002Koool00ol0VOoo
ooooo`1=oooo0P0000[oool200001?ooo`<00004oooo00<0003oooooool0S_ooo`009_ooo`03o`2I
oooooooo06Koool20000Soooo`009_ooo`03o`2Ioooooooo06Koool00`000?ooooooo`2>oooo000V
oooo00?o09Woooooool0I_ooo`030000oooooooo08koool002Koool00ol0VOooooooo`1Voooo00<0
003oooooool0S_ooo`009_ooo`03o`2Ioooooooo06Koool20000Soooo`009_ooo`03o`2Ioooooooo
06Koool00`000?ooooooo`2>oooo000Voooo00?o09Woooooool0I_ooo`030000oooooooo08koool0
02Koool00ol0VOooooooo`1Voooo00<0003oooooool0S_ooo`009_ooo`03o`2Ioooooooo06Koool2
0000Soooo`009_ooo`03o`2Ioooooooo06Koool00`000?ooooooo`2>oooo000Voooo00?o09Wooooo
ool0I_ooo`030000oooooooo08koool002Koool00ol0VOooooooo`1Voooo00<0003oooooool0S_oo
o`009_ooo`03o`2Ioooooooo06Koool20000Soooo`009_ooo`03o`2Ioooooooo06Koool00`000?oo
ooooo`2>oooo000Voooo00?o09Woooooool0Doooo`800004oooo0P0000Coool200001Oooo`030000
oooooooo08koool002Koool00ol0VOooooooo`1Boooo00@0003oooooool00008oooo00@0003ooooo
ool00004oooo00<0003oooooool0S_ooo`009_ooo`03o`2Ioooooooo05;oool010000?ooooooo`00
00_oool00`000?ooooooo`02oooo0`0008koool002Koool00ol0VOooooooo`1Boooo00@0003ooooo
ool00009oooo0P0000Goool00`000?ooooooo`2>oooo000Voooo00?o09Woooooool0D_ooo`040000
oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo000Voooo00?o09Wooooo
ool0Doooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo000Voooo00?o09Woooooool0I_oo
o`80002?oooo000Voooo00?o09Woooooool0I_ooo`030000oooooooo08koool002Koool00ol0VOoo
ooooo`1Voooo00<0003oooooool0S_ooo`009_ooo`03o`2Ioooooooo06Koool20000Soooo`009_oo
o`03o`2Ioooooooo06Koool00`000?ooooooo`2>oooo000Voooo00?o09Woooooool0I_ooo`030000
oooooooo08koool002Koool00ol0VOooooooo`1Voooo00<0003oooooool0S_ooo`009_ooo`03o`2I
oooooooo06Koool20000Soooo`009_ooo`03o`2Ioooooooo06Koool00`000?ooooooo`2>oooo000V
oooo00?o09Woooooool0I_ooo`030000oooooooo08koool002Koool00ol0VOooooooo`1Voooo00<0
003oooooool0S_ooo`009_ooo`03o`2Ioooooooo06Koool20000Soooo`009_ooo`03o`2Ioooooooo
06Koool00`000?ooooooo`2>oooo000Voooo00?o09Woooooool0COooo`800004oooo0P0000Goool0
0`000?ooooooo`02oooo0P0000Goool00`000?ooooooo`2>oooo000Voooo00?o09Woooooool0C?oo
o`040000oooooooo00002_ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0
003oooooool0S_ooo`009_ooo`03o`2Ioooooooo04coool010000?ooooooo`0000[oool00`000?oo
ooooo`04oooo00<0003oooooool00_ooo`<0002>oooo000Voooo00?o09Woooooool0C?ooo`040000
oooooooo00002oooo`040000oooooooooooo0P0000Goool00`000?ooooooo`2>oooo000Voooo00?o
09Woooooool0C?ooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo
00Coool00`000?ooooooo`2>oooo000Voooo00?o09Woooooool0COooo`800009oooo100000?oool3
00001?ooo`030000oooooooo08koool002Koool00ol0VOooooooo`1Voooo0P0008ooool002Koool0
0ol0VOooooooo`1Voooo00<0003oooooool0S_ooo`009_ooo`03o`2Ioooooooo06Koool00`000?oo
ooooo`2>oooo000Voooo00?o09Woooooool0I_ooo`030000oooooooo08koool002Koool00ol0VOoo
ooooo`1Voooo0P0008ooool002Koool00ol0VOooooooo`1Voooo00<0003oooooool0S_ooo`009_oo
o`03o`2Ioooooooo06Koool00`000?ooooooo`2>oooo000Voooo00?o09Woooooool0I_ooo`030000
oooooooo08koool002Koool00ol0VOooooooo`1Voooo0P0008ooool002Koool00ol0VOooooooo`1V
oooo00<0003oooooool0S_ooo`009_ooo`03o`2Ioooooooo06Koool00`000?ooooooo`2>oooo000V
oooo00?o09Woooooool0I_ooo`030000oooooooo08koool002Koool00ol0VOooooooo`1Voooo0P00
08ooool002Koool00ol0VOooooooo`1Voooo00<0003oooooool0S_ooo`009_ooo`03o`2Ioooooooo
05koool500000oooo`030000oooooooo08koool002Koool00ol0VOooooooo`1Poooo00<0003ooooo
ool00oooo`030000oooooooo08koool002Koool00ol0VOooooooo`1Poooo00<0003oooooool00ooo
o`<0002>oooo0029oooo00<0003oooooool0U?ooo`00ROooo`030000oooooooo09Coool008Soool2
0000U_ooo`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo
07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool0
07Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200000ooo
o`<00004oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool01?ooo`@00005oooo00<0003oooooool01oooo`040000oooooooo
00000oooo`030000oooooooo07Soool007Ooool00`000?ooooooo`02oooo00<0003oooooool05Ooo
o`030000oooooooo00Ooool010000?ooooooo`0000Coool00`000?ooooooo`1goooo001hoooo00<0
003oooooool01@0001Coool00`000?ooooooo`07oooo0`0000Coool00`000?ooooooo`1hoooo001h
oooo00D0003oooooooooool000005oooo`030000oooooooo00Soool00`000?ooooooo`03oooo00<0
003oooooool0N?ooo`00NOooo`030000oooooooo01Ooool200002_ooo`<00002oooo00<0003ooooo
ool0NOooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.55) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.04262 .30902 L
.06244 .30902 L
.08255 .30902 L
.08806 .30902 L
.09109 .30902 L
.09258 .30902 L
.09324 .30902 L
.09396 .30902 L
s
.09396 .30902 m
.09409 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.55) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000ooooo`2I00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Koool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`0Eoooo000Foooo00<0003ooooo
ool03oooo`03o`2Ioooooooo01?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000
oooooooo02Goool00`000?ooooooo`0Uoooo00<0003oooooool09_ooo`030000oooooooo01Goool0
02Soool00ol0VOooooooo`1Toooo00<0003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo06Coool2
0000Soooo`00:?ooo`03o`2Ioooooooo06Coool00`000?ooooooo`2>oooo000Xoooo00?o09Wooooo
ool0I?ooo`030000oooooooo08koool002Soool00ol0VOooooooo`1Toooo00<0003oooooool0S_oo
o`00:?ooo`03o`2Ioooooooo06Coool20000Soooo`00:?ooo`03o`2Ioooooooo06Coool00`000?oo
ooooo`2>oooo000Xoooo00?o09Woooooool0I?ooo`030000oooooooo08koool002Soool00ol0VOoo
ooooo`1Toooo00<0003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo06Coool20000Soooo`00:?oo
o`03o`2Ioooooooo06Coool00`000?ooooooo`2>oooo000Xoooo00?o09Woooooool0I?ooo`030000
oooooooo08koool002Soool00ol0VOooooooo`1Toooo00<0003oooooool0S_ooo`00:?ooo`03o`2I
oooooooo06Coool20000Soooo`00:?ooo`03o`2Ioooooooo06Coool00`000?ooooooo`2>oooo000X
oooo00?o09Woooooool0Boooo`800004oooo0P0000?oool400000oooo`800005oooo00<0003ooooo
ool0S_ooo`00:?ooo`03o`2Ioooooooo04[oool010000?ooooooo`0000Soool00`000?ooooooo`03
oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo04[oool0
10000?ooooooo`0000Woool00`000?ooooooo`05oooo00<0003oooooool00_ooo`<0002>oooo000X
oooo00?o09Woooooool0B_ooo`040000oooooooo00002_ooo`030000oooooooo00;oool200001Ooo
o`030000oooooooo08koool002Soool00ol0VOooooooo`1:oooo00@0003oooooool00008oooo00@0
003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo08koool002Soool00ol0VOoo
ooooo`1;oooo0P0000[oool200001?ooo`<00004oooo00<0003oooooool0S_ooo`00:?ooo`03o`2I
oooooooo06Coool20000Soooo`00:?ooo`03o`2Ioooooooo06Coool00`000?ooooooo`2>oooo000X
oooo00?o09Woooooool0I?ooo`030000oooooooo08koool002Soool00ol0VOooooooo`1Toooo00<0
003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo06Coool20000Soooo`00:?ooo`03o`2Ioooooooo
06Coool00`000?ooooooo`2>oooo000Xoooo00?o09Woooooool0I?ooo`030000oooooooo08koool0
02Soool00ol0VOooooooo`1Toooo00<0003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo06Coool2
0000Soooo`00:?ooo`03o`2Ioooooooo06Coool00`000?ooooooo`2>oooo000Xoooo00?o09Wooooo
ool0I?ooo`030000oooooooo08koool002Soool00ol0VOooooooo`1Toooo00<0003oooooool0S_oo
o`00:?ooo`03o`2Ioooooooo06Coool20000Soooo`00:?ooo`03o`2Ioooooooo06Coool00`000?oo
ooooo`2>oooo000Xoooo00?o09Woooooool0DOooo`800004oooo0P0000Coool200001Oooo`030000
oooooooo08koool002Soool00ol0VOooooooo`1@oooo00@0003oooooool00008oooo00@0003ooooo
ool00004oooo00<0003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo053oool010000?ooooooo`00
00_oool00`000?ooooooo`02oooo0`0008koool002Soool00ol0VOooooooo`1@oooo00@0003ooooo
ool00009oooo0P0000Goool00`000?ooooooo`2>oooo000Xoooo00?o09Woooooool0D?ooo`040000
oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo000Xoooo00?o09Wooooo
ool0DOooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo000Xoooo00?o09Woooooool0I?oo
o`80002?oooo000Xoooo00?o09Woooooool0I?ooo`030000oooooooo08koool002Soool00ol0VOoo
ooooo`1Toooo00<0003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo06Coool20000Soooo`00:?oo
o`03o`2Ioooooooo06Coool00`000?ooooooo`2>oooo000Xoooo00?o09Woooooool0I?ooo`030000
oooooooo08koool002Soool00ol0VOooooooo`1Toooo00<0003oooooool0S_ooo`00:?ooo`03o`2I
oooooooo06Coool20000Soooo`00:?ooo`03o`2Ioooooooo06Coool00`000?ooooooo`2>oooo000X
oooo00?o09Woooooool0I?ooo`030000oooooooo08koool002Soool00ol0VOooooooo`1Toooo00<0
003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo06Coool20000Soooo`00:?ooo`03o`2Ioooooooo
06Coool00`000?ooooooo`2>oooo000Xoooo00?o09Woooooool0Boooo`800004oooo0P0000Goool0
0`000?ooooooo`02oooo0P0000Goool00`000?ooooooo`2>oooo000Xoooo00?o09Woooooool0B_oo
o`040000oooooooo00002_ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0
003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo04[oool010000?ooooooo`0000[oool00`000?oo
ooooo`04oooo00<0003oooooool00_ooo`<0002>oooo000Xoooo00?o09Woooooool0B_ooo`040000
oooooooo00002oooo`040000oooooooooooo0P0000Goool00`000?ooooooo`2>oooo000Xoooo00?o
09Woooooool0B_ooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo
00Coool00`000?ooooooo`2>oooo000Xoooo00?o09Woooooool0Boooo`800009oooo100000?oool3
00001?ooo`030000oooooooo08koool002Soool00ol0VOooooooo`1Toooo0P0008ooool002Soool0
0ol0VOooooooo`1Toooo00<0003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo06Coool00`000?oo
ooooo`2>oooo000Xoooo00?o09Woooooool0I?ooo`030000oooooooo08koool002Soool00ol0VOoo
ooooo`1Toooo0P0008ooool002Soool00ol0VOooooooo`1Toooo00<0003oooooool0S_ooo`00:?oo
o`03o`2Ioooooooo06Coool00`000?ooooooo`2>oooo000Xoooo00?o09Woooooool0I?ooo`030000
oooooooo08koool002Soool00ol0VOooooooo`1Toooo0P0008ooool002Soool00ol0VOooooooo`1T
oooo00<0003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo06Coool00`000?ooooooo`2>oooo000X
oooo00?o09Woooooool0I?ooo`030000oooooooo08koool002Soool00ol0VOooooooo`1Toooo0P00
08ooool002Soool00ol0VOooooooo`1Toooo00<0003oooooool0S_ooo`00:?ooo`03o`2Ioooooooo
05coool500000oooo`030000oooooooo08koool002Soool00ol0VOooooooo`1Noooo00<0003ooooo
ool00oooo`030000oooooooo08koool002Soool00ol0VOooooooo`1Noooo00<0003oooooool00ooo
o`<0002>oooo0029oooo00<0003oooooool0U?ooo`00ROooo`030000oooooooo09Coool008Soool2
0000U_ooo`00ooooob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000oooooooo
07Koool007Goool00`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool0
07Goool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200001?oo
o`800004oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000000_oo
o`030000oooooooo00;oool00`000?ooooooo`04oooo100000Goool00`000?ooooooo`07oooo00@0
003oooooool00002oooo00@0003oooooool00003oooo00<0003oooooool0MOooo`00M?ooo`030000
oooooooo00;oool00`000?ooooooo`0Eoooo00<0003oooooool02_ooo`030000oooooooo00?oool0
0`000?ooooooo`02oooo00<0003oooooool0M?ooo`00MOooo`030000oooooooo00D0000Doooo00<0
003oooooool02?ooo`800004oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003ooooo
ooooool000005oooo`030000oooooooo00Soool00`000?ooooooo`03oooo00<0003oooooool00ooo
o`030000oooooooo07Goool007Koool00`000?ooooooo`0Goooo0P0000[oool300000oooo`<00002
oooo00<0003oooooool0M_ooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.04262 .30902 L
.06244 .30902 L
.08255 .30902 L
.08806 .30902 L
.09396 .30902 L
.09682 .30902 L
.09952 .30902 L
.1007 .30902 L
.10195 .30902 L
.1026 .30902 L
s
.1026 .30902 m
.10267 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`050000ooooooooooooo`2I00?oool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Koool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool0
0`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`0Eoooo000Foooo00<0
003oooooool04Oooo`03o`2Ioooooooo017oool00`000?ooooooo`0Voooo00<0003oooooool09Ooo
o`030000oooooooo02Goool00`000?ooooooo`0Uoooo00<0003oooooool09_ooo`030000oooooooo
01Goool002[oool00ol0VOooooooo`1Roooo00<0003oooooool0S_ooo`00:_ooo`03o`2Ioooooooo
06;oool20000Soooo`00:_ooo`03o`2Ioooooooo06;oool00`000?ooooooo`2>oooo000Zoooo00?o
09Woooooool0H_ooo`030000oooooooo08koool002[oool00ol0VOooooooo`1Roooo00<0003ooooo
ool0S_ooo`00:_ooo`03o`2Ioooooooo06;oool20000Soooo`00:_ooo`03o`2Ioooooooo06;oool0
0`000?ooooooo`2>oooo000Zoooo00?o09Woooooool0H_ooo`030000oooooooo08koool002[oool0
0ol0VOooooooo`1Roooo00<0003oooooool0S_ooo`00:_ooo`03o`2Ioooooooo06;oool20000Sooo
o`00:_ooo`03o`2Ioooooooo06;oool00`000?ooooooo`2>oooo000Zoooo00?o09Woooooool0H_oo
o`030000oooooooo08koool002[oool00ol0VOooooooo`1Roooo00<0003oooooool0S_ooo`00:_oo
o`03o`2Ioooooooo06;oool20000Soooo`00:_ooo`03o`2Ioooooooo06;oool00`000?ooooooo`2>
oooo000Zoooo00?o09Woooooool0BOooo`800004oooo0P0000?oool400000oooo`800005oooo00<0
003oooooool0S_ooo`00:_ooo`03o`2Ioooooooo04Soool010000?ooooooo`0000Soool00`000?oo
ooooo`03oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00:_ooo`03o`2Ioooooooo
04Soool010000?ooooooo`0000Woool00`000?ooooooo`05oooo00<0003oooooool00_ooo`<0002>
oooo000Zoooo00?o09Woooooool0B?ooo`040000oooooooo00002_ooo`030000oooooooo00;oool2
00001Oooo`030000oooooooo08koool002[oool00ol0VOooooooo`18oooo00@0003oooooool00008
oooo00@0003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo08koool002[oool0
0ol0VOooooooo`19oooo0P0000[oool200001?ooo`<00004oooo00<0003oooooool0S_ooo`00:_oo
o`03o`2Ioooooooo06;oool20000Soooo`00:_ooo`03o`2Ioooooooo06;oool00`000?ooooooo`2>
oooo000Zoooo00?o09Woooooool0H_ooo`030000oooooooo08koool002[oool00ol0VOooooooo`1R
oooo00<0003oooooool0S_ooo`00:_ooo`03o`2Ioooooooo06;oool20000Soooo`00:_ooo`03o`2I
oooooooo06;oool00`000?ooooooo`2>oooo000Zoooo00?o09Woooooool0H_ooo`030000oooooooo
08koool002[oool00ol0VOooooooo`1Roooo00<0003oooooool0S_ooo`00:_ooo`03o`2Ioooooooo
06;oool20000Soooo`00:_ooo`03o`2Ioooooooo06;oool00`000?ooooooo`2>oooo000Zoooo00?o
09Woooooool0H_ooo`030000oooooooo08koool002[oool00ol0VOooooooo`1Roooo00<0003ooooo
ool0S_ooo`00:_ooo`03o`2Ioooooooo06;oool20000Soooo`00:_ooo`03o`2Ioooooooo06;oool0
0`000?ooooooo`2>oooo000Zoooo00?o09Woooooool0Coooo`800004oooo0P0000Coool200001Ooo
o`030000oooooooo08koool002[oool00ol0VOooooooo`1>oooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00:_ooo`03o`2Ioooooooo04koool010000?oo
ooooo`0000_oool00`000?ooooooo`02oooo0`0008koool002[oool00ol0VOooooooo`1>oooo00@0
003oooooool00009oooo0P0000Goool00`000?ooooooo`2>oooo000Zoooo00?o09Woooooool0C_oo
o`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo000Zoooo00?o
09Woooooool0Coooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo000Zoooo00?o09Wooooo
ool0H_ooo`80002?oooo000Zoooo00?o09Woooooool0H_ooo`030000oooooooo08koool002[oool0
0ol0VOooooooo`1Roooo00<0003oooooool0S_ooo`00:_ooo`03o`2Ioooooooo06;oool20000Sooo
o`00:_ooo`03o`2Ioooooooo06;oool00`000?ooooooo`2>oooo000Zoooo00?o09Woooooool0H_oo
o`030000oooooooo08koool002[oool00ol0VOooooooo`1Roooo00<0003oooooool0S_ooo`00:_oo
o`03o`2Ioooooooo06;oool20000Soooo`00:_ooo`03o`2Ioooooooo06;oool00`000?ooooooo`2>
oooo000Zoooo00?o09Woooooool0H_ooo`030000oooooooo08koool002[oool00ol0VOooooooo`1R
oooo00<0003oooooool0S_ooo`00:_ooo`03o`2Ioooooooo06;oool20000Soooo`00:_ooo`03o`2I
oooooooo06;oool00`000?ooooooo`2>oooo000Zoooo00?o09Woooooool0BOooo`800004oooo0P00
00Goool00`000?ooooooo`02oooo0P0000Goool00`000?ooooooo`2>oooo000Zoooo00?o09Wooooo
ool0B?ooo`040000oooooooo00002_ooo`050000oooooooooooo000000;oool00`000?ooooooo`02
oooo00<0003oooooool0S_ooo`00:_ooo`03o`2Ioooooooo04Soool010000?ooooooo`0000[oool0
0`000?ooooooo`04oooo00<0003oooooool00_ooo`<0002>oooo000Zoooo00?o09Woooooool0B?oo
o`040000oooooooo00002oooo`040000oooooooooooo0P0000Goool00`000?ooooooo`2>oooo000Z
oooo00?o09Woooooool0B?ooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000
oooooooo00Coool00`000?ooooooo`2>oooo000Zoooo00?o09Woooooool0BOooo`800009oooo1000
00?oool300001?ooo`030000oooooooo08koool002[oool00ol0VOooooooo`1Roooo0P0008ooool0
02[oool00ol0VOooooooo`1Roooo00<0003oooooool0S_ooo`00:_ooo`03o`2Ioooooooo06;oool0
0`000?ooooooo`2>oooo000Zoooo00?o09Woooooool0H_ooo`030000oooooooo08koool002[oool0
0ol0VOooooooo`1Roooo0P0008ooool002[oool00ol0VOooooooo`1Roooo00<0003oooooool0S_oo
o`00:_ooo`03o`2Ioooooooo06;oool00`000?ooooooo`2>oooo000Zoooo00?o09Woooooool0H_oo
o`030000oooooooo08koool002[oool00ol0VOooooooo`1Roooo0P0008ooool002[oool00ol0VOoo
ooooo`1Roooo00<0003oooooool0S_ooo`00:_ooo`03o`2Ioooooooo06;oool00`000?ooooooo`2>
oooo000Zoooo00?o09Woooooool0H_ooo`030000oooooooo08koool002[oool00ol0VOooooooo`1R
oooo0P0008ooool002[oool00ol0VOooooooo`1Roooo00<0003oooooool0S_ooo`00:_ooo`03o`2I
oooooooo05[oool500000oooo`030000oooooooo08koool002[oool00ol0VOooooooo`1Loooo00<0
003oooooool00oooo`030000oooooooo08koool002[oool00ol0VOooooooo`1Loooo00<0003ooooo
ool00oooo`<0002>oooo0029oooo00<0003oooooool0U?ooo`00ROooo`030000oooooooo09Coool0
08Soool20000U_ooo`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000
oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo
07Soool007Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool2
00001?ooo`800004oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool0
0`000?ooooooo`02oooo00<0003oooooool01?ooo`@00005oooo00<0003oooooool01oooo`040000
oooooooo00000oooo`030000oooooooo07Soool007Ooool00`000?ooooooo`02oooo00<0003ooooo
ool05Oooo`030000oooooooo00[oool00`000?ooooooo`02oooo00<0003oooooool0Moooo`00N?oo
o`030000oooooooo00D0000Doooo00<0003oooooool02?ooo`800004oooo00<0003oooooool0N?oo
o`00N?ooo`050000oooooooooooo000001Ooool00`000?ooooooo`08oooo00<0003oooooool00ooo
o`030000oooooooo07Soool007Woool00`000?ooooooo`0Goooo0P0000[oool300000_ooo`030000
oooooooo07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.45) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.08255 .30902 L
.0932 .30902 L
.09905 .30902 L
.10458 .30902 L
.10708 .30902 L
.10972 .30902 L
.11039 .30902 L
.1111 .30902 L
s
.1111 .30902 m
.11118 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.45) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00?oool00ol0VOooo`000007oooo00<0003oooooool01Oooo`030000oooooooo
00Koool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`0Eoooo000Foooo00<0003ooooo
ool04oooo`03o`2Ioooooooo00ooool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000
oooooooo02Goool00`000?ooooooo`0Uoooo00<0003oooooool09_ooo`030000oooooooo01Goool0
02coool00ol0VOooooooo`1Poooo00<0003oooooool0S_ooo`00;?ooo`03o`2Ioooooooo063oool2
0000Soooo`00;?ooo`03o`2Ioooooooo063oool00`000?ooooooo`2>oooo000/oooo00?o09Wooooo
ool0H?ooo`030000oooooooo08koool002coool00ol0VOooooooo`1Poooo00<0003oooooool0S_oo
o`00;?ooo`03o`2Ioooooooo063oool20000Soooo`00;?ooo`03o`2Ioooooooo063oool00`000?oo
ooooo`2>oooo000/oooo00?o09Woooooool0H?ooo`030000oooooooo08koool002coool00ol0VOoo
ooooo`1Poooo00<0003oooooool0S_ooo`00;?ooo`03o`2Ioooooooo063oool20000Soooo`00;?oo
o`03o`2Ioooooooo063oool00`000?ooooooo`2>oooo000/oooo00?o09Woooooool0H?ooo`030000
oooooooo08koool002coool00ol0VOooooooo`1Poooo00<0003oooooool0S_ooo`00;?ooo`03o`2I
oooooooo063oool20000Soooo`00;?ooo`03o`2Ioooooooo063oool00`000?ooooooo`2>oooo000/
oooo00?o09Woooooool0Aoooo`800004oooo0P0000?oool400000oooo`800005oooo00<0003ooooo
ool0S_ooo`00;?ooo`03o`2Ioooooooo04Koool010000?ooooooo`0000Soool00`000?ooooooo`03
oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00;?ooo`03o`2Ioooooooo04Koool0
10000?ooooooo`0000Woool00`000?ooooooo`05oooo00<0003oooooool00_ooo`<0002>oooo000/
oooo00?o09Woooooool0A_ooo`040000oooooooo00002_ooo`030000oooooooo00;oool200001Ooo
o`030000oooooooo08koool002coool00ol0VOooooooo`16oooo00@0003oooooool00008oooo00@0
003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo08koool002coool00ol0VOoo
ooooo`17oooo0P0000[oool200001?ooo`<00004oooo00<0003oooooool0S_ooo`00;?ooo`03o`2I
oooooooo063oool20000Soooo`00;?ooo`03o`2Ioooooooo063oool00`000?ooooooo`2>oooo000/
oooo00?o09Woooooool0H?ooo`030000oooooooo08koool002coool00ol0VOooooooo`1Poooo00<0
003oooooool0S_ooo`00;?ooo`03o`2Ioooooooo063oool20000Soooo`00;?ooo`03o`2Ioooooooo
063oool00`000?ooooooo`2>oooo000/oooo00?o09Woooooool0H?ooo`030000oooooooo08koool0
02coool00ol0VOooooooo`1Poooo00<0003oooooool0S_ooo`00;?ooo`03o`2Ioooooooo063oool2
0000Soooo`00;?ooo`03o`2Ioooooooo063oool00`000?ooooooo`2>oooo000/oooo00?o09Wooooo
ool0H?ooo`030000oooooooo08koool002coool00ol0VOooooooo`1Poooo00<0003oooooool0S_oo
o`00;?ooo`03o`2Ioooooooo063oool20000Soooo`00;?ooo`03o`2Ioooooooo063oool00`000?oo
ooooo`2>oooo000/oooo00?o09Woooooool0COooo`800004oooo0P0000Coool200001Oooo`030000
oooooooo08koool002coool00ol0VOooooooo`1<oooo00@0003oooooool00008oooo00@0003ooooo
ool00004oooo00<0003oooooool0S_ooo`00;?ooo`03o`2Ioooooooo04coool010000?ooooooo`00
00_oool00`000?ooooooo`02oooo0`0008koool002coool00ol0VOooooooo`1<oooo00@0003ooooo
ool00009oooo0P0000Goool00`000?ooooooo`2>oooo000/oooo00?o09Woooooool0C?ooo`040000
oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo000/oooo00?o09Wooooo
ool0COooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo000/oooo00?o09Woooooool0H?oo
o`80002?oooo000/oooo00?o09Woooooool0H?ooo`030000oooooooo08koool002coool00ol0VOoo
ooooo`1Poooo00<0003oooooool0S_ooo`00;?ooo`03o`2Ioooooooo063oool20000Soooo`00;?oo
o`03o`2Ioooooooo063oool00`000?ooooooo`2>oooo000/oooo00?o09Woooooool0H?ooo`030000
oooooooo08koool002coool00ol0VOooooooo`1Poooo00<0003oooooool0S_ooo`00;?ooo`03o`2I
oooooooo063oool20000Soooo`00;?ooo`03o`2Ioooooooo063oool00`000?ooooooo`2>oooo000/
oooo00?o09Woooooool0H?ooo`030000oooooooo08koool002coool00ol0VOooooooo`1Poooo00<0
003oooooool0S_ooo`00;?ooo`03o`2Ioooooooo063oool20000Soooo`00;?ooo`03o`2Ioooooooo
063oool00`000?ooooooo`2>oooo000/oooo00?o09Woooooool0Aoooo`800004oooo0P0000Goool0
0`000?ooooooo`02oooo0P0000Goool00`000?ooooooo`2>oooo000/oooo00?o09Woooooool0A_oo
o`040000oooooooo00002_ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0
003oooooool0S_ooo`00;?ooo`03o`2Ioooooooo04Koool010000?ooooooo`0000[oool00`000?oo
ooooo`04oooo00<0003oooooool00_ooo`<0002>oooo000/oooo00?o09Woooooool0A_ooo`040000
oooooooo00002oooo`040000oooooooooooo0P0000Goool00`000?ooooooo`2>oooo000/oooo00?o
09Woooooool0A_ooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo
00Coool00`000?ooooooo`2>oooo000/oooo00?o09Woooooool0Aoooo`800009oooo100000?oool3
00001?ooo`030000oooooooo08koool002coool00ol0VOooooooo`1Poooo0P0008ooool002coool0
0ol0VOooooooo`1Poooo00<0003oooooool0S_ooo`00;?ooo`03o`2Ioooooooo063oool00`000?oo
ooooo`2>oooo000/oooo00?o09Woooooool0H?ooo`030000oooooooo08koool002coool00ol0VOoo
ooooo`1Poooo0P0008ooool002coool00ol0VOooooooo`1Poooo00<0003oooooool0S_ooo`00;?oo
o`03o`2Ioooooooo063oool00`000?ooooooo`2>oooo000/oooo00?o09Woooooool0H?ooo`030000
oooooooo08koool002coool00ol0VOooooooo`1Poooo0P0008ooool002coool00ol0VOooooooo`1P
oooo00<0003oooooool0S_ooo`00;?ooo`03o`2Ioooooooo063oool00`000?ooooooo`2>oooo000/
oooo00?o09Woooooool0H?ooo`030000oooooooo08koool002coool00ol0VOooooooo`1Poooo0P00
08ooool002coool00ol0VOooooooo`1Poooo00<0003oooooool0S_ooo`00;?ooo`03o`2Ioooooooo
05Soool500000oooo`030000oooooooo08koool002coool00ol0VOooooooo`1Joooo00<0003ooooo
ool00oooo`030000oooooooo08koool002coool00ol0VOooooooo`1Joooo00<0003oooooool00ooo
o`<0002>oooo0029oooo00<0003oooooool0U?ooo`00ROooo`030000oooooooo09Coool008Soool2
0000U_ooo`00ooooob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000oooooooo
07Koool007Goool00`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool0
07Goool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200001Ooo
o`<00002oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000000_oo
o`030000oooooooo00;oool00`000?ooooooo`04oooo100000Goool00`000?ooooooo`0:oooo00@0
003oooooool00002oooo00D0003oooooooooool00000Moooo`00M?ooo`030000oooooooo00;oool0
0`000?ooooooo`0Eoooo00<0003oooooool01oooo`D00004oooo00<0003oooooool00_ooo`030000
oooooooo07Coool007Goool00`000?ooooooo`0500005?ooo`030000oooooooo00Ooool010000?oo
ooooo`0000?oool200001?ooo`030000oooooooo07Goool007Goool01@000?ooooooooooo`00000G
oooo00<0003oooooool02?ooo`030000oooo000000?oool00`000?ooooooo`03oooo00<0003ooooo
ool0MOooo`00M_ooo`030000oooooooo01Ooool200002oooo`800003oooo0`0000;oool00`000?oo
ooooo`1foooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.08255 .30902 L
.0932 .30902 L
.10458 .30902 L
.11009 .30902 L
.1128 .30902 L
.11531 .30902 L
.11758 .30902 L
.11872 .30902 L
s
.11872 .30902 m
.11885 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Koool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`0Eoooo000Foooo00<0003ooooo
ool05Oooo`03o`2Ioooooooo00goool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000
oooooooo02Goool00`000?ooooooo`0Uoooo00<0003oooooool09_ooo`030000oooooooo01Goool0
02koool00ol0VOooooooo`1Noooo00<0003oooooool0S_ooo`00;_ooo`03o`2Ioooooooo05koool2
0000Soooo`00;_ooo`03o`2Ioooooooo05koool00`000?ooooooo`2>oooo000^oooo00?o09Wooooo
ool0G_ooo`030000oooooooo08koool002koool00ol0VOooooooo`1Noooo00<0003oooooool0S_oo
o`00;_ooo`03o`2Ioooooooo05koool20000Soooo`00;_ooo`03o`2Ioooooooo05koool00`000?oo
ooooo`2>oooo000^oooo00?o09Woooooool0G_ooo`030000oooooooo08koool002koool00ol0VOoo
ooooo`1Noooo00<0003oooooool0S_ooo`00;_ooo`03o`2Ioooooooo05koool20000Soooo`00;_oo
o`03o`2Ioooooooo05koool00`000?ooooooo`2>oooo000^oooo00?o09Woooooool0G_ooo`030000
oooooooo08koool002koool00ol0VOooooooo`1Noooo00<0003oooooool0S_ooo`00;_ooo`03o`2I
oooooooo05koool20000Soooo`00;_ooo`03o`2Ioooooooo05koool00`000?ooooooo`2>oooo000^
oooo00?o09Woooooool0AOooo`800004oooo0P0000?oool400000oooo`800005oooo00<0003ooooo
ool0S_ooo`00;_ooo`03o`2Ioooooooo04Coool010000?ooooooo`0000Soool00`000?ooooooo`03
oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00;_ooo`03o`2Ioooooooo04Coool0
10000?ooooooo`0000Woool00`000?ooooooo`05oooo00<0003oooooool00_ooo`<0002>oooo000^
oooo00?o09Woooooool0A?ooo`040000oooooooo00002_ooo`030000oooooooo00;oool200001Ooo
o`030000oooooooo08koool002koool00ol0VOooooooo`14oooo00@0003oooooool00008oooo00@0
003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo08koool002koool00ol0VOoo
ooooo`15oooo0P0000[oool200001?ooo`<00004oooo00<0003oooooool0S_ooo`00;_ooo`03o`2I
oooooooo05koool20000Soooo`00;_ooo`03o`2Ioooooooo05koool00`000?ooooooo`2>oooo000^
oooo00?o09Woooooool0G_ooo`030000oooooooo08koool002koool00ol0VOooooooo`1Noooo00<0
003oooooool0S_ooo`00;_ooo`03o`2Ioooooooo05koool20000Soooo`00;_ooo`03o`2Ioooooooo
05koool00`000?ooooooo`2>oooo000^oooo00?o09Woooooool0G_ooo`030000oooooooo08koool0
02koool00ol0VOooooooo`1Noooo00<0003oooooool0S_ooo`00;_ooo`03o`2Ioooooooo05koool2
0000Soooo`00;_ooo`03o`2Ioooooooo05koool00`000?ooooooo`2>oooo000^oooo00?o09Wooooo
ool0G_ooo`030000oooooooo08koool002koool00ol0VOooooooo`1Noooo00<0003oooooool0S_oo
o`00;_ooo`03o`2Ioooooooo05koool20000Soooo`00;_ooo`03o`2Ioooooooo05koool00`000?oo
ooooo`2>oooo000^oooo00?o09Woooooool0Boooo`800004oooo0P0000Coool200001Oooo`030000
oooooooo08koool002koool00ol0VOooooooo`1:oooo00@0003oooooool00008oooo00@0003ooooo
ool00004oooo00<0003oooooool0S_ooo`00;_ooo`03o`2Ioooooooo04[oool010000?ooooooo`00
00_oool00`000?ooooooo`02oooo0`0008koool002koool00ol0VOooooooo`1:oooo00@0003ooooo
ool00009oooo0P0000Goool00`000?ooooooo`2>oooo000^oooo00?o09Woooooool0B_ooo`040000
oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo000^oooo00?o09Wooooo
ool0Boooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo000^oooo00?o09Woooooool0G_oo
o`80002?oooo000^oooo00?o09Woooooool0G_ooo`030000oooooooo08koool002koool00ol0VOoo
ooooo`1Noooo00<0003oooooool0S_ooo`00;_ooo`03o`2Ioooooooo05koool20000Soooo`00;_oo
o`03o`2Ioooooooo05koool00`000?ooooooo`2>oooo000^oooo00?o09Woooooool0G_ooo`030000
oooooooo08koool002koool00ol0VOooooooo`1Noooo00<0003oooooool0S_ooo`00;_ooo`03o`2I
oooooooo05koool20000Soooo`00;_ooo`03o`2Ioooooooo05koool00`000?ooooooo`2>oooo000^
oooo00?o09Woooooool0G_ooo`030000oooooooo08koool002koool00ol0VOooooooo`1Noooo00<0
003oooooool0S_ooo`00;_ooo`03o`2Ioooooooo05koool20000Soooo`00;_ooo`03o`2Ioooooooo
05koool00`000?ooooooo`2>oooo000^oooo00?o09Woooooool0AOooo`800004oooo0P0000Goool0
0`000?ooooooo`02oooo0P0000Goool00`000?ooooooo`2>oooo000^oooo00?o09Woooooool0A?oo
o`040000oooooooo00002_ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0
003oooooool0S_ooo`00;_ooo`03o`2Ioooooooo04Coool010000?ooooooo`0000[oool00`000?oo
ooooo`04oooo00<0003oooooool00_ooo`<0002>oooo000^oooo00?o09Woooooool0A?ooo`040000
oooooooo00002oooo`040000oooooooooooo0P0000Goool00`000?ooooooo`2>oooo000^oooo00?o
09Woooooool0A?ooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo
00Coool00`000?ooooooo`2>oooo000^oooo00?o09Woooooool0AOooo`800009oooo100000?oool3
00001?ooo`030000oooooooo08koool002koool00ol0VOooooooo`1Noooo0P0008ooool002koool0
0ol0VOooooooo`1Noooo00<0003oooooool0S_ooo`00;_ooo`03o`2Ioooooooo05koool00`000?oo
ooooo`2>oooo000^oooo00?o09Woooooool0G_ooo`030000oooooooo08koool002koool00ol0VOoo
ooooo`1Noooo0P0008ooool002koool00ol0VOooooooo`1Noooo00<0003oooooool0S_ooo`00;_oo
o`03o`2Ioooooooo05koool00`000?ooooooo`2>oooo000^oooo00?o09Woooooool0G_ooo`030000
oooooooo08koool002koool00ol0VOooooooo`1Noooo0P0008ooool002koool00ol0VOooooooo`1N
oooo00<0003oooooool0S_ooo`00;_ooo`03o`2Ioooooooo05koool00`000?ooooooo`2>oooo000^
oooo00?o09Woooooool0G_ooo`030000oooooooo08koool002koool00ol0VOooooooo`1Noooo0P00
08ooool002koool00ol0VOooooooo`1Noooo00<0003oooooool0S_ooo`00;_ooo`03o`2Ioooooooo
05Koool500000oooo`030000oooooooo08koool002koool00ol0VOooooooo`1Hoooo00<0003ooooo
ool00oooo`030000oooooooo08koool002koool00ol0VOooooooo`1Hoooo00<0003oooooool00ooo
o`<0002>oooo0029oooo00<0003oooooool0U?ooo`00ROooo`030000oooooooo09Coool008Soool2
0000U_ooo`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo
07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool0
07Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200001Ooo
o`<00002oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool01?ooo`@00005oooo00<0003oooooool02_ooo`050000oooooooo
oooo000007[oool007Ooool00`000?ooooooo`02oooo00<0003oooooool05Oooo`030000oooooooo
00Ooool500000oooo`030000oooooooo07Ooool007Soool00`000?ooooooo`0500005?ooo`030000
oooooooo00Ooool010000?ooooooo`0000?oool00`000?ooooooo`1hoooo001hoooo00D0003ooooo
ooooool000005oooo`030000oooooooo00Soool00`000?ooo`000003oooo00<0003oooooool0N?oo
o`00NOooo`030000oooooooo01Ooool200002oooo`800002oooo00<0003oooooool0NOooo`00oooo
ob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.35) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.08255 .30902 L
.10458 .30902 L
.11448 .30902 L
.11992 .30902 L
.1226 .30902 L
.12377 .30902 L
.12507 .30902 L
.12627 .30902 L
s
.12627 .30902 m
.12638 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.35) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooool0V@05oooo00<0003oooooool01Oooo`030000oooooooo
00Koool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`0Eoooo000Foooo00<0003ooooo
ool05oooo`03o`2Ioooooooo00_oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000
oooooooo02Goool00`000?ooooooo`0Uoooo00<0003oooooool09_ooo`030000oooooooo01Goool0
033oool00ol0VOooooooo`1Loooo00<0003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo05coool2
0000Soooo`00<?ooo`03o`2Ioooooooo05coool00`000?ooooooo`2>oooo000`oooo00?o09Wooooo
ool0G?ooo`030000oooooooo08koool0033oool00ol0VOooooooo`1Loooo00<0003oooooool0S_oo
o`00<?ooo`03o`2Ioooooooo05coool20000Soooo`00<?ooo`03o`2Ioooooooo05coool00`000?oo
ooooo`2>oooo000`oooo00?o09Woooooool0G?ooo`030000oooooooo08koool0033oool00ol0VOoo
ooooo`1Loooo00<0003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo05coool20000Soooo`00<?oo
o`03o`2Ioooooooo05coool00`000?ooooooo`2>oooo000`oooo00?o09Woooooool0G?ooo`030000
oooooooo08koool0033oool00ol0VOooooooo`1Loooo00<0003oooooool0S_ooo`00<?ooo`03o`2I
oooooooo05coool20000Soooo`00<?ooo`03o`2Ioooooooo05coool00`000?ooooooo`2>oooo000`
oooo00?o09Woooooool0@oooo`800004oooo0P0000?oool400000oooo`800005oooo00<0003ooooo
ool0S_ooo`00<?ooo`03o`2Ioooooooo04;oool010000?ooooooo`0000Soool00`000?ooooooo`03
oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo04;oool0
10000?ooooooo`0000Woool00`000?ooooooo`05oooo00<0003oooooool00_ooo`<0002>oooo000`
oooo00?o09Woooooool0@_ooo`040000oooooooo00002_ooo`030000oooooooo00;oool200001Ooo
o`030000oooooooo08koool0033oool00ol0VOooooooo`12oooo00@0003oooooool00008oooo00@0
003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo08koool0033oool00ol0VOoo
ooooo`13oooo0P0000[oool200001?ooo`<00004oooo00<0003oooooool0S_ooo`00<?ooo`03o`2I
oooooooo05coool20000Soooo`00<?ooo`03o`2Ioooooooo05coool00`000?ooooooo`2>oooo000`
oooo00?o09Woooooool0G?ooo`030000oooooooo08koool0033oool00ol0VOooooooo`1Loooo00<0
003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo05coool20000Soooo`00<?ooo`03o`2Ioooooooo
05coool00`000?ooooooo`2>oooo000`oooo00?o09Woooooool0G?ooo`030000oooooooo08koool0
033oool00ol0VOooooooo`1Loooo00<0003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo05coool2
0000Soooo`00<?ooo`03o`2Ioooooooo05coool00`000?ooooooo`2>oooo000`oooo00?o09Wooooo
ool0G?ooo`030000oooooooo08koool0033oool00ol0VOooooooo`1Loooo00<0003oooooool0S_oo
o`00<?ooo`03o`2Ioooooooo05coool20000Soooo`00<?ooo`03o`2Ioooooooo05coool00`000?oo
ooooo`2>oooo000`oooo00?o09Woooooool0BOooo`800004oooo0P0000Coool200001Oooo`030000
oooooooo08koool0033oool00ol0VOooooooo`18oooo00@0003oooooool00008oooo00@0003ooooo
ool00004oooo00<0003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo04Soool010000?ooooooo`00
00_oool00`000?ooooooo`02oooo0`0008koool0033oool00ol0VOooooooo`18oooo00@0003ooooo
ool00009oooo0P0000Goool00`000?ooooooo`2>oooo000`oooo00?o09Woooooool0B?ooo`040000
oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo000`oooo00?o09Wooooo
ool0BOooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo000`oooo00?o09Woooooool0G?oo
o`80002?oooo000`oooo00?o09Woooooool0G?ooo`030000oooooooo08koool0033oool00ol0VOoo
ooooo`1Loooo00<0003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo05coool20000Soooo`00<?oo
o`03o`2Ioooooooo05coool00`000?ooooooo`2>oooo000`oooo00?o09Woooooool0G?ooo`030000
oooooooo08koool0033oool00ol0VOooooooo`1Loooo00<0003oooooool0S_ooo`00<?ooo`03o`2I
oooooooo05coool20000Soooo`00<?ooo`03o`2Ioooooooo05coool00`000?ooooooo`2>oooo000`
oooo00?o09Woooooool0G?ooo`030000oooooooo08koool0033oool00ol0VOooooooo`1Loooo00<0
003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo05coool20000Soooo`00<?ooo`03o`2Ioooooooo
05coool00`000?ooooooo`2>oooo000`oooo00?o09Woooooool0@oooo`800004oooo0P0000Goool0
0`000?ooooooo`02oooo0P0000Goool00`000?ooooooo`2>oooo000`oooo00?o09Woooooool0@_oo
o`040000oooooooo00002_ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0
003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo04;oool010000?ooooooo`0000[oool00`000?oo
ooooo`04oooo00<0003oooooool00_ooo`<0002>oooo000`oooo00?o09Woooooool0@_ooo`040000
oooooooo00002oooo`040000oooooooooooo0P0000Goool00`000?ooooooo`2>oooo000`oooo00?o
09Woooooool0@_ooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo
00Coool00`000?ooooooo`2>oooo000`oooo00?o09Woooooool0@oooo`800009oooo100000?oool3
00001?ooo`030000oooooooo08koool0033oool00ol0VOooooooo`1Loooo0P0008ooool0033oool0
0ol0VOooooooo`1Loooo00<0003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo05coool00`000?oo
ooooo`2>oooo000`oooo00?o09Woooooool0G?ooo`030000oooooooo08koool0033oool00ol0VOoo
ooooo`1Loooo0P0008ooool0033oool00ol0VOooooooo`1Loooo00<0003oooooool0S_ooo`00<?oo
o`03o`2Ioooooooo05coool00`000?ooooooo`2>oooo000`oooo00?o09Woooooool0G?ooo`030000
oooooooo08koool0033oool00ol0VOooooooo`1Loooo0P0008ooool0033oool00ol0VOooooooo`1L
oooo00<0003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo05coool00`000?ooooooo`2>oooo000`
oooo00?o09Woooooool0G?ooo`030000oooooooo08koool0033oool00ol0VOooooooo`1Loooo0P00
08ooool0033oool00ol0VOooooooo`1Loooo00<0003oooooool0S_ooo`00<?ooo`03o`2Ioooooooo
05Coool500000oooo`030000oooooooo08koool0033oool00ol0VOooooooo`1Foooo00<0003ooooo
ool00oooo`030000oooooooo08koool0033oool00ol0VOooooooo`1Foooo00<0003oooooool00ooo
o`<0002>oooo0029oooo00<0003oooooool0U?ooo`00ROooo`030000oooooooo09Coool008Soool2
0000U_ooo`00ooooob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000oooooooo
07Koool007Goool00`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool0
07Goool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200001?oo
o`800004oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000000_oo
o`030000oooooooo00;oool00`000?ooooooo`04oooo100000Goool00`000?ooooooo`07oooo00@0
003oooooool00002oooo00@0003oooooool00003oooo00<0003oooooool0MOooo`00M?ooo`030000
oooooooo00;oool00`000?ooooooo`0Eoooo00<0003oooooool02Oooo`030000oooooooo00Coool0
0`000?ooooooo`02oooo00<0003oooooool0M?ooo`00MOooo`030000oooooooo00D0000Doooo00<0
003oooooool02_ooo`040000oooooooooooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0
003oooooooooool000005oooo`030000oooooooo00Ooool010000?ooooooo`0000?oool00`000?oo
ooooo`03oooo00<0003oooooool0MOooo`00M_ooo`030000oooooooo01Ooool200002_ooo`800004
oooo0`0000;oool00`000?ooooooo`1foooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.08255 .30902 L
.10458 .30902 L
.11448 .30902 L
.11992 .30902 L
.12507 .30902 L
.12986 .30902 L
.13117 .30902 L
.13256 .30902 L
.13375 .30902 L
s
.13375 .30902 m
.13388 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool01@000?ooooooooooool0V@03oooo00<0003oooooool01Oooo`030000
oooooooo00Koool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool0
0`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`0Eoooo000Foooo00<0
003oooooool06Oooo`03o`2Ioooooooo00Woool00`000?ooooooo`0Voooo00<0003oooooool09Ooo
o`030000oooooooo02Goool00`000?ooooooo`0Uoooo00<0003oooooool09_ooo`030000oooooooo
01Goool003;oool00ol0VOooooooo`1Joooo00<0003oooooool0S_ooo`00<_ooo`03o`2Ioooooooo
05[oool20000Soooo`00<_ooo`03o`2Ioooooooo05[oool00`000?ooooooo`2>oooo000boooo00?o
09Woooooool0F_ooo`030000oooooooo08koool003;oool00ol0VOooooooo`1Joooo00<0003ooooo
ool0S_ooo`00<_ooo`03o`2Ioooooooo05[oool20000Soooo`00<_ooo`03o`2Ioooooooo05[oool0
0`000?ooooooo`2>oooo000boooo00?o09Woooooool0F_ooo`030000oooooooo08koool003;oool0
0ol0VOooooooo`1Joooo00<0003oooooool0S_ooo`00<_ooo`03o`2Ioooooooo05[oool20000Sooo
o`00<_ooo`03o`2Ioooooooo05[oool00`000?ooooooo`2>oooo000boooo00?o09Woooooool0F_oo
o`030000oooooooo08koool003;oool00ol0VOooooooo`1Joooo00<0003oooooool0S_ooo`00<_oo
o`03o`2Ioooooooo05[oool20000Soooo`00<_ooo`03o`2Ioooooooo05[oool00`000?ooooooo`2>
oooo000boooo00?o09Woooooool0@Oooo`800004oooo0P0000?oool400000oooo`800005oooo00<0
003oooooool0S_ooo`00<_ooo`03o`2Ioooooooo043oool010000?ooooooo`0000Soool00`000?oo
ooooo`03oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00<_ooo`03o`2Ioooooooo
043oool010000?ooooooo`0000Woool00`000?ooooooo`05oooo00<0003oooooool00_ooo`<0002>
oooo000boooo00?o09Woooooool0@?ooo`040000oooooooo00002_ooo`030000oooooooo00;oool2
00001Oooo`030000oooooooo08koool003;oool00ol0VOooooooo`10oooo00@0003oooooool00008
oooo00@0003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo08koool003;oool0
0ol0VOooooooo`11oooo0P0000[oool200001?ooo`<00004oooo00<0003oooooool0S_ooo`00<_oo
o`03o`2Ioooooooo05[oool20000Soooo`00<_ooo`03o`2Ioooooooo05[oool00`000?ooooooo`2>
oooo000boooo00?o09Woooooool0F_ooo`030000oooooooo08koool003;oool00ol0VOooooooo`1J
oooo00<0003oooooool0S_ooo`00<_ooo`03o`2Ioooooooo05[oool20000Soooo`00<_ooo`03o`2I
oooooooo05[oool00`000?ooooooo`2>oooo000boooo00?o09Woooooool0F_ooo`030000oooooooo
08koool003;oool00ol0VOooooooo`1Joooo00<0003oooooool0S_ooo`00<_ooo`03o`2Ioooooooo
05[oool20000Soooo`00<_ooo`03o`2Ioooooooo05[oool00`000?ooooooo`2>oooo000boooo00?o
09Woooooool0F_ooo`030000oooooooo08koool003;oool00ol0VOooooooo`1Joooo00<0003ooooo
ool0S_ooo`00<_ooo`03o`2Ioooooooo05[oool20000Soooo`00<_ooo`03o`2Ioooooooo05[oool0
0`000?ooooooo`2>oooo000boooo00?o09Woooooool0Aoooo`800004oooo0P0000Coool200001Ooo
o`030000oooooooo08koool003;oool00ol0VOooooooo`16oooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00<_ooo`03o`2Ioooooooo04Koool010000?oo
ooooo`0000_oool00`000?ooooooo`02oooo0`0008koool003;oool00ol0VOooooooo`16oooo00@0
003oooooool00009oooo0P0000Goool00`000?ooooooo`2>oooo000boooo00?o09Woooooool0A_oo
o`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo000boooo00?o
09Woooooool0Aoooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo000boooo00?o09Wooooo
ool0F_ooo`80002?oooo000boooo00?o09Woooooool0F_ooo`030000oooooooo08koool003;oool0
0ol0VOooooooo`1Joooo00<0003oooooool0S_ooo`00<_ooo`03o`2Ioooooooo05[oool20000Sooo
o`00<_ooo`03o`2Ioooooooo05[oool00`000?ooooooo`2>oooo000boooo00?o09Woooooool0F_oo
o`030000oooooooo08koool003;oool00ol0VOooooooo`1Joooo00<0003oooooool0S_ooo`00<_oo
o`03o`2Ioooooooo05[oool20000Soooo`00<_ooo`03o`2Ioooooooo05[oool00`000?ooooooo`2>
oooo000boooo00?o09Woooooool0F_ooo`030000oooooooo08koool003;oool00ol0VOooooooo`1J
oooo00<0003oooooool0S_ooo`00<_ooo`03o`2Ioooooooo05[oool20000Soooo`00<_ooo`03o`2I
oooooooo05[oool00`000?ooooooo`2>oooo000boooo00?o09Woooooool0@Oooo`800004oooo0P00
00Goool00`000?ooooooo`02oooo0P0000Goool00`000?ooooooo`2>oooo000boooo00?o09Wooooo
ool0@?ooo`040000oooooooo00002_ooo`050000oooooooooooo000000;oool00`000?ooooooo`02
oooo00<0003oooooool0S_ooo`00<_ooo`03o`2Ioooooooo043oool010000?ooooooo`0000[oool0
0`000?ooooooo`04oooo00<0003oooooool00_ooo`<0002>oooo000boooo00?o09Woooooool0@?oo
o`040000oooooooo00002oooo`040000oooooooooooo0P0000Goool00`000?ooooooo`2>oooo000b
oooo00?o09Woooooool0@?ooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000
oooooooo00Coool00`000?ooooooo`2>oooo000boooo00?o09Woooooool0@Oooo`800009oooo1000
00?oool300001?ooo`030000oooooooo08koool003;oool00ol0VOooooooo`1Joooo0P0008ooool0
03;oool00ol0VOooooooo`1Joooo00<0003oooooool0S_ooo`00<_ooo`03o`2Ioooooooo05[oool0
0`000?ooooooo`2>oooo000boooo00?o09Woooooool0F_ooo`030000oooooooo08koool003;oool0
0ol0VOooooooo`1Joooo0P0008ooool003;oool00ol0VOooooooo`1Joooo00<0003oooooool0S_oo
o`00<_ooo`03o`2Ioooooooo05[oool00`000?ooooooo`2>oooo000boooo00?o09Woooooool0F_oo
o`030000oooooooo08koool003;oool00ol0VOooooooo`1Joooo0P0008ooool003;oool00ol0VOoo
ooooo`1Joooo00<0003oooooool0S_ooo`00<_ooo`03o`2Ioooooooo05[oool00`000?ooooooo`2>
oooo000boooo00?o09Woooooool0F_ooo`030000oooooooo08koool003;oool00ol0VOooooooo`1J
oooo0P0008ooool003;oool00ol0VOooooooo`1Joooo00<0003oooooool0S_ooo`00<_ooo`03o`2I
oooooooo05;oool500000oooo`030000oooooooo08koool003;oool00ol0VOooooooo`1Doooo00<0
003oooooool00oooo`030000oooooooo08koool003;oool00ol0VOooooooo`1Doooo00<0003ooooo
ool00oooo`<0002>oooo0029oooo00<0003oooooool0U?ooo`00ROooo`030000oooooooo09Coool0
08Soool20000U_ooo`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000
oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo
07Soool007Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool2
00001?ooo`800004oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool0
0`000?ooooooo`02oooo00<0003oooooool01?ooo`@00005oooo00<0003oooooool01oooo`040000
oooooooo00000oooo`030000oooooooo07Soool007Ooool00`000?ooooooo`02oooo00<0003ooooo
ool05Oooo`030000oooooooo00Woool00`000?ooooooo`03oooo00<0003oooooool0Moooo`00N?oo
o`030000oooooooo00D0000Doooo00<0003oooooool02_ooo`050000oooooooooooo000007[oool0
07Soool01@000?ooooooooooo`00000Goooo00<0003oooooool01oooo`040000oooooooo00000ooo
o`030000oooooooo07Soool007Woool00`000?ooooooo`0Goooo0P0000[oool200000oooo`030000
oooooooo07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.25) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.08255 .30902 L
.10458 .30902 L
.11448 .30902 L
.12507 .30902 L
.1302 .30902 L
.13506 .30902 L
.13942 .30902 L
.14061 .30902 L
.14188 .30902 L
s
.14188 .30902 m
.14199 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.25) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`03oooo00?o09Woool000001oooo`030000oooooooo
00Koool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`0Eoooo000Foooo00<0003ooooo
ool06oooo`03o`2Ioooooooo00Ooool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000
oooooooo02Goool00`000?ooooooo`0Uoooo00<0003oooooool09_ooo`030000oooooooo01Goool0
03Coool00ol0VOooooooo`1Hoooo00<0003oooooool0S_ooo`00=?ooo`03o`2Ioooooooo05Soool2
0000Soooo`00=?ooo`03o`2Ioooooooo05Soool00`000?ooooooo`2>oooo000doooo00?o09Wooooo
ool0F?ooo`030000oooooooo08koool003Coool00ol0VOooooooo`1Hoooo00<0003oooooool0S_oo
o`00=?ooo`03o`2Ioooooooo05Soool20000Soooo`00=?ooo`03o`2Ioooooooo05Soool00`000?oo
ooooo`2>oooo000doooo00?o09Woooooool0F?ooo`030000oooooooo08koool003Coool00ol0VOoo
ooooo`1Hoooo00<0003oooooool0S_ooo`00=?ooo`03o`2Ioooooooo05Soool20000Soooo`00=?oo
o`03o`2Ioooooooo05Soool00`000?ooooooo`2>oooo000doooo00?o09Woooooool0F?ooo`030000
oooooooo08koool003Coool00ol0VOooooooo`1Hoooo00<0003oooooool0S_ooo`00=?ooo`03o`2I
oooooooo05Soool20000Soooo`00=?ooo`03o`2Ioooooooo05Soool00`000?ooooooo`2>oooo000d
oooo00?o09Woooooool0?oooo`800004oooo0P0000?oool400000oooo`800005oooo00<0003ooooo
ool0S_ooo`00=?ooo`03o`2Ioooooooo03koool010000?ooooooo`0000Soool00`000?ooooooo`03
oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00=?ooo`03o`2Ioooooooo03koool0
10000?ooooooo`0000Woool00`000?ooooooo`05oooo00<0003oooooool00_ooo`<0002>oooo000d
oooo00?o09Woooooool0?_ooo`040000oooooooo00002_ooo`030000oooooooo00;oool200001Ooo
o`030000oooooooo08koool003Coool00ol0VOooooooo`0noooo00@0003oooooool00008oooo00@0
003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo08koool003Coool00ol0VOoo
ooooo`0ooooo0P0000[oool200001?ooo`<00004oooo00<0003oooooool0S_ooo`00=?ooo`03o`2I
oooooooo05Soool20000Soooo`00=?ooo`03o`2Ioooooooo05Soool00`000?ooooooo`2>oooo000d
oooo00?o09Woooooool0F?ooo`030000oooooooo08koool003Coool00ol0VOooooooo`1Hoooo00<0
003oooooool0S_ooo`00=?ooo`03o`2Ioooooooo05Soool20000Soooo`00=?ooo`03o`2Ioooooooo
05Soool00`000?ooooooo`2>oooo000doooo00?o09Woooooool0F?ooo`030000oooooooo08koool0
03Coool00ol0VOooooooo`1Hoooo00<0003oooooool0S_ooo`00=?ooo`03o`2Ioooooooo05Soool2
0000Soooo`00=?ooo`03o`2Ioooooooo05Soool00`000?ooooooo`2>oooo000doooo00?o09Wooooo
ool0F?ooo`030000oooooooo08koool003Coool00ol0VOooooooo`1Hoooo00<0003oooooool0S_oo
o`00=?ooo`03o`2Ioooooooo05Soool20000Soooo`00=?ooo`03o`2Ioooooooo05Soool00`000?oo
ooooo`2>oooo000doooo00?o09Woooooool0AOooo`800004oooo0P0000Coool200001Oooo`030000
oooooooo08koool003Coool00ol0VOooooooo`14oooo00@0003oooooool00008oooo00@0003ooooo
ool00004oooo00<0003oooooool0S_ooo`00=?ooo`03o`2Ioooooooo04Coool010000?ooooooo`00
00_oool00`000?ooooooo`02oooo0`0008koool003Coool00ol0VOooooooo`14oooo00@0003ooooo
ool00009oooo0P0000Goool00`000?ooooooo`2>oooo000doooo00?o09Woooooool0A?ooo`040000
oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo000doooo00?o09Wooooo
ool0AOooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo000doooo00?o09Woooooool0F?oo
o`80002?oooo000doooo00?o09Woooooool0F?ooo`030000oooooooo08koool003Coool00ol0VOoo
ooooo`1Hoooo00<0003oooooool0S_ooo`00=?ooo`03o`2Ioooooooo05Soool20000Soooo`00=?oo
o`03o`2Ioooooooo05Soool00`000?ooooooo`2>oooo000doooo00?o09Woooooool0F?ooo`030000
oooooooo08koool003Coool00ol0VOooooooo`1Hoooo00<0003oooooool0S_ooo`00=?ooo`03o`2I
oooooooo05Soool20000Soooo`00=?ooo`03o`2Ioooooooo05Soool00`000?ooooooo`2>oooo000d
oooo00?o09Woooooool0F?ooo`030000oooooooo08koool003Coool00ol0VOooooooo`1Hoooo00<0
003oooooool0S_ooo`00=?ooo`03o`2Ioooooooo05Soool20000Soooo`00=?ooo`03o`2Ioooooooo
05Soool00`000?ooooooo`2>oooo000doooo00?o09Woooooool0?oooo`800004oooo0P0000Goool0
0`000?ooooooo`02oooo0P0000Goool00`000?ooooooo`2>oooo000doooo00?o09Woooooool0?_oo
o`040000oooooooo00002_ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0
003oooooool0S_ooo`00=?ooo`03o`2Ioooooooo03koool010000?ooooooo`0000[oool00`000?oo
ooooo`04oooo00<0003oooooool00_ooo`<0002>oooo000doooo00?o09Woooooool0?_ooo`040000
oooooooo00002oooo`040000oooooooooooo0P0000Goool00`000?ooooooo`2>oooo000doooo00?o
09Woooooool0?_ooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo
00Coool00`000?ooooooo`2>oooo000doooo00?o09Woooooool0?oooo`800009oooo100000?oool3
00001?ooo`030000oooooooo08koool003Coool00ol0VOooooooo`1Hoooo0P0008ooool003Coool0
0ol0VOooooooo`1Hoooo00<0003oooooool0S_ooo`00=?ooo`03o`2Ioooooooo05Soool00`000?oo
ooooo`2>oooo000doooo00?o09Woooooool0F?ooo`030000oooooooo08koool003Coool00ol0VOoo
ooooo`1Hoooo0P0008ooool003Coool00ol0VOooooooo`1Hoooo00<0003oooooool0S_ooo`00=?oo
o`03o`2Ioooooooo05Soool00`000?ooooooo`2>oooo000doooo00?o09Woooooool0F?ooo`030000
oooooooo08koool003Coool00ol0VOooooooo`1Hoooo0P0008ooool003Coool00ol0VOooooooo`1H
oooo00<0003oooooool0S_ooo`00=?ooo`03o`2Ioooooooo05Soool00`000?ooooooo`2>oooo000d
oooo00?o09Woooooool0F?ooo`030000oooooooo08koool003Coool00ol0VOooooooo`1Hoooo0P00
08ooool003Coool00ol0VOooooooo`1Hoooo00<0003oooooool0S_ooo`00=?ooo`03o`2Ioooooooo
053oool500000oooo`030000oooooooo08koool003Coool00ol0VOooooooo`1Boooo00<0003ooooo
ool00oooo`030000oooooooo08koool003Coool00ol0VOooooooo`1Boooo00<0003oooooool00ooo
o`<0002>oooo0029oooo00<0003oooooool0U?ooo`00ROooo`030000oooooooo09Coool008Soool2
0000U_ooo`00ooooob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000oooooooo
07Koool007Goool00`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool0
07Goool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200000ooo
o`@00003oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000000_oo
o`030000oooooooo00;oool00`000?ooooooo`04oooo100000Goool00`000?ooooooo`07oooo00<0
003oooooool00oooo`040000oooooooo00000oooo`030000oooooooo07Goool007Coool00`000?oo
ooooo`02oooo00<0003oooooool05Oooo`030000oooooooo00Soool00`000?ooooooo`05oooo00<0
003oooooool00_ooo`030000oooooooo07Coool007Goool00`000?ooooooo`0500005?ooo`030000
oooooooo00Woool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0
003oooooooooool000005oooo`030000oooooooo00Ooool010000?ooooooo`0000?oool00`000?oo
ooooo`03oooo00<0003oooooool0MOooo`00M_ooo`030000oooooooo01Ooool200002_ooo`800004
oooo0`0000;oool00`000?ooooooo`1foooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.12507 .30902 L
.13506 .30902 L
.14415 .30902 L
.14635 .30902 L
.14868 .30902 L
.1499 .30902 L
.15059 .30902 L
s
.15059 .30902 m
.15066 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Koool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`0Eoooo000Foooo00<0003ooooo
ool07Oooo`03o`2Ioooooooo00Goool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000
oooooooo02Goool00`000?ooooooo`0Uoooo00<0003oooooool09_ooo`030000oooooooo01Goool0
03Koool00ol0VOooooooo`1Foooo00<0003oooooool0S_ooo`00=_ooo`03o`2Ioooooooo05Koool2
0000Soooo`00=_ooo`03o`2Ioooooooo05Koool00`000?ooooooo`2>oooo000foooo00?o09Wooooo
ool0E_ooo`030000oooooooo08koool003Koool00ol0VOooooooo`1Foooo00<0003oooooool0S_oo
o`00=_ooo`03o`2Ioooooooo05Koool20000Soooo`00=_ooo`03o`2Ioooooooo05Koool00`000?oo
ooooo`2>oooo000foooo00?o09Woooooool0E_ooo`030000oooooooo08koool003Koool00ol0VOoo
ooooo`1Foooo00<0003oooooool0S_ooo`00=_ooo`03o`2Ioooooooo05Koool20000Soooo`00=_oo
o`03o`2Ioooooooo05Koool00`000?ooooooo`2>oooo000foooo00?o09Woooooool0E_ooo`030000
oooooooo08koool003Koool00ol0VOooooooo`1Foooo00<0003oooooool0S_ooo`00=_ooo`03o`2I
oooooooo05Koool20000Soooo`00=_ooo`03o`2Ioooooooo05Koool00`000?ooooooo`2>oooo000f
oooo00?o09Woooooool0?Oooo`800004oooo0P0000?oool400000oooo`800005oooo00<0003ooooo
ool0S_ooo`00=_ooo`03o`2Ioooooooo03coool010000?ooooooo`0000Soool00`000?ooooooo`03
oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00=_ooo`03o`2Ioooooooo03coool0
10000?ooooooo`0000Woool00`000?ooooooo`05oooo00<0003oooooool00_ooo`<0002>oooo000f
oooo00?o09Woooooool0??ooo`040000oooooooo00002_ooo`030000oooooooo00;oool200001Ooo
o`030000oooooooo08koool003Koool00ol0VOooooooo`0loooo00@0003oooooool00008oooo00@0
003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo08koool003Koool00ol0VOoo
ooooo`0moooo0P0000[oool200001?ooo`<00004oooo00<0003oooooool0S_ooo`00=_ooo`03o`2I
oooooooo05Koool20000Soooo`00=_ooo`03o`2Ioooooooo05Koool00`000?ooooooo`2>oooo000f
oooo00?o09Woooooool0E_ooo`030000oooooooo08koool003Koool00ol0VOooooooo`1Foooo00<0
003oooooool0S_ooo`00=_ooo`03o`2Ioooooooo05Koool20000Soooo`00=_ooo`03o`2Ioooooooo
05Koool00`000?ooooooo`2>oooo000foooo00?o09Woooooool0E_ooo`030000oooooooo08koool0
03Koool00ol0VOooooooo`1Foooo00<0003oooooool0S_ooo`00=_ooo`03o`2Ioooooooo05Koool2
0000Soooo`00=_ooo`03o`2Ioooooooo05Koool00`000?ooooooo`2>oooo000foooo00?o09Wooooo
ool0E_ooo`030000oooooooo08koool003Koool00ol0VOooooooo`1Foooo00<0003oooooool0S_oo
o`00=_ooo`03o`2Ioooooooo05Koool20000Soooo`00=_ooo`03o`2Ioooooooo05Koool00`000?oo
ooooo`2>oooo000foooo00?o09Woooooool0@oooo`800004oooo0P0000Coool200001Oooo`030000
oooooooo08koool003Koool00ol0VOooooooo`12oooo00@0003oooooool00008oooo00@0003ooooo
ool00004oooo00<0003oooooool0S_ooo`00=_ooo`03o`2Ioooooooo04;oool010000?ooooooo`00
00_oool00`000?ooooooo`02oooo0`0008koool003Koool00ol0VOooooooo`12oooo00@0003ooooo
ool00009oooo0P0000Goool00`000?ooooooo`2>oooo000foooo00?o09Woooooool0@_ooo`040000
oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo000foooo00?o09Wooooo
ool0@oooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo000foooo00?o09Woooooool0E_oo
o`80002?oooo000foooo00?o09Woooooool0E_ooo`030000oooooooo08koool003Koool00ol0VOoo
ooooo`1Foooo00<0003oooooool0S_ooo`00=_ooo`03o`2Ioooooooo05Koool20000Soooo`00=_oo
o`03o`2Ioooooooo05Koool00`000?ooooooo`2>oooo000foooo00?o09Woooooool0E_ooo`030000
oooooooo08koool003Koool00ol0VOooooooo`1Foooo00<0003oooooool0S_ooo`00=_ooo`03o`2I
oooooooo05Koool20000Soooo`00=_ooo`03o`2Ioooooooo05Koool00`000?ooooooo`2>oooo000f
oooo00?o09Woooooool0E_ooo`030000oooooooo08koool003Koool00ol0VOooooooo`1Foooo00<0
003oooooool0S_ooo`00=_ooo`03o`2Ioooooooo05Koool20000Soooo`00=_ooo`03o`2Ioooooooo
05Koool00`000?ooooooo`2>oooo000foooo00?o09Woooooool0?Oooo`800004oooo0P0000Goool0
0`000?ooooooo`02oooo0P0000Goool00`000?ooooooo`2>oooo000foooo00?o09Woooooool0??oo
o`040000oooooooo00002_ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0
003oooooool0S_ooo`00=_ooo`03o`2Ioooooooo03coool010000?ooooooo`0000[oool00`000?oo
ooooo`04oooo00<0003oooooool00_ooo`<0002>oooo000foooo00?o09Woooooool0??ooo`040000
oooooooo00002oooo`040000oooooooooooo0P0000Goool00`000?ooooooo`2>oooo000foooo00?o
09Woooooool0??ooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo
00Coool00`000?ooooooo`2>oooo000foooo00?o09Woooooool0?Oooo`800009oooo100000?oool3
00001?ooo`030000oooooooo08koool003Koool00ol0VOooooooo`1Foooo0P0008ooool003Koool0
0ol0VOooooooo`1Foooo00<0003oooooool0S_ooo`00=_ooo`03o`2Ioooooooo05Koool00`000?oo
ooooo`2>oooo000foooo00?o09Woooooool0E_ooo`030000oooooooo08koool003Koool00ol0VOoo
ooooo`1Foooo0P0008ooool003Koool00ol0VOooooooo`1Foooo00<0003oooooool0S_ooo`00=_oo
o`03o`2Ioooooooo05Koool00`000?ooooooo`2>oooo000foooo00?o09Woooooool0E_ooo`030000
oooooooo08koool003Koool00ol0VOooooooo`1Foooo0P0008ooool003Koool00ol0VOooooooo`1F
oooo00<0003oooooool0S_ooo`00=_ooo`03o`2Ioooooooo05Koool00`000?ooooooo`2>oooo000f
oooo00?o09Woooooool0E_ooo`030000oooooooo08koool003Koool00ol0VOooooooo`1Foooo0P00
08ooool003Koool00ol0VOooooooo`1Foooo00<0003oooooool0S_ooo`00=_ooo`03o`2Ioooooooo
04koool500000oooo`030000oooooooo08koool003Koool00ol0VOooooooo`1@oooo00<0003ooooo
ool00oooo`030000oooooooo08koool003Koool00ol0VOooooooo`1@oooo00<0003oooooool00ooo
o`<0002>oooo0029oooo00<0003oooooool0U?ooo`00ROooo`030000oooooooo09Coool008Soool2
0000U_ooo`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo
07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool0
07Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200000ooo
o`@00003oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool01?ooo`@00005oooo00<0003oooooool01oooo`030000oooooooo
00Coool00`000?ooooooo`1hoooo001goooo00<0003oooooool00_ooo`030000oooooooo01Goool0
0`000?ooooooo`08oooo00<0003oooooool01?ooo`030000oooooooo07Ooool007Soool00`000?oo
ooooo`0500005?ooo`030000oooooooo00Woool00`000?ooooooo`02oooo00<0003oooooool0N?oo
o`00N?ooo`050000oooooooooooo000001Ooool00`000?ooooooo`07oooo00@0003oooooool00003
oooo00<0003oooooool0N?ooo`00NOooo`030000oooooooo01Ooool200002_ooo`800003oooo00<0
003oooooool0NOooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.15) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.12507 .30902 L
.13506 .30902 L
.14415 .30902 L
.14868 .30902 L
.1536 .30902 L
.15586 .30902 L
.15709 .30902 L
.15825 .30902 L
s
.15825 .30902 m
.15835 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.15) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo09T01Oooo`030000oooooooo
00Koool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`0Eoooo000Foooo00<0003ooooo
ool07oooo`03o`2Ioooooooo00?oool00`000?ooooooo`0Voooo00<0003oooooool09Oooo`030000
oooooooo02Goool00`000?ooooooo`0Uoooo00<0003oooooool09_ooo`030000oooooooo01Goool0
03Soool00ol0VOooooooo`1Doooo00<0003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo05Coool2
0000Soooo`00>?ooo`03o`2Ioooooooo05Coool00`000?ooooooo`2>oooo000hoooo00?o09Wooooo
ool0E?ooo`030000oooooooo08koool003Soool00ol0VOooooooo`1Doooo00<0003oooooool0S_oo
o`00>?ooo`03o`2Ioooooooo05Coool20000Soooo`00>?ooo`03o`2Ioooooooo05Coool00`000?oo
ooooo`2>oooo000hoooo00?o09Woooooool0E?ooo`030000oooooooo08koool003Soool00ol0VOoo
ooooo`1Doooo00<0003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo05Coool20000Soooo`00>?oo
o`03o`2Ioooooooo05Coool00`000?ooooooo`2>oooo000hoooo00?o09Woooooool0E?ooo`030000
oooooooo08koool003Soool00ol0VOooooooo`1Doooo00<0003oooooool0S_ooo`00>?ooo`03o`2I
oooooooo05Coool20000Soooo`00>?ooo`03o`2Ioooooooo05Coool00`000?ooooooo`2>oooo000h
oooo00?o09Woooooool0>oooo`800004oooo0P0000?oool400000oooo`800005oooo00<0003ooooo
ool0S_ooo`00>?ooo`03o`2Ioooooooo03[oool010000?ooooooo`0000Soool00`000?ooooooo`03
oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo03[oool0
10000?ooooooo`0000Woool00`000?ooooooo`05oooo00<0003oooooool00_ooo`<0002>oooo000h
oooo00?o09Woooooool0>_ooo`040000oooooooo00002_ooo`030000oooooooo00;oool200001Ooo
o`030000oooooooo08koool003Soool00ol0VOooooooo`0joooo00@0003oooooool00008oooo00@0
003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo08koool003Soool00ol0VOoo
ooooo`0koooo0P0000[oool200001?ooo`<00004oooo00<0003oooooool0S_ooo`00>?ooo`03o`2I
oooooooo05Coool20000Soooo`00>?ooo`03o`2Ioooooooo05Coool00`000?ooooooo`2>oooo000h
oooo00?o09Woooooool0E?ooo`030000oooooooo08koool003Soool00ol0VOooooooo`1Doooo00<0
003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo05Coool20000Soooo`00>?ooo`03o`2Ioooooooo
05Coool00`000?ooooooo`2>oooo000hoooo00?o09Woooooool0E?ooo`030000oooooooo08koool0
03Soool00ol0VOooooooo`1Doooo00<0003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo05Coool2
0000Soooo`00>?ooo`03o`2Ioooooooo05Coool00`000?ooooooo`2>oooo000hoooo00?o09Wooooo
ool0E?ooo`030000oooooooo08koool003Soool00ol0VOooooooo`1Doooo00<0003oooooool0S_oo
o`00>?ooo`03o`2Ioooooooo05Coool20000Soooo`00>?ooo`03o`2Ioooooooo05Coool00`000?oo
ooooo`2>oooo000hoooo00?o09Woooooool0@Oooo`800004oooo0P0000Coool200001Oooo`030000
oooooooo08koool003Soool00ol0VOooooooo`10oooo00@0003oooooool00008oooo00@0003ooooo
ool00004oooo00<0003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo043oool010000?ooooooo`00
00_oool00`000?ooooooo`02oooo0`0008koool003Soool00ol0VOooooooo`10oooo00@0003ooooo
ool00009oooo0P0000Goool00`000?ooooooo`2>oooo000hoooo00?o09Woooooool0@?ooo`040000
oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo000hoooo00?o09Wooooo
ool0@Oooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo000hoooo00?o09Woooooool0E?oo
o`80002?oooo000hoooo00?o09Woooooool0E?ooo`030000oooooooo08koool003Soool00ol0VOoo
ooooo`1Doooo00<0003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo05Coool20000Soooo`00>?oo
o`03o`2Ioooooooo05Coool00`000?ooooooo`2>oooo000hoooo00?o09Woooooool0E?ooo`030000
oooooooo08koool003Soool00ol0VOooooooo`1Doooo00<0003oooooool0S_ooo`00>?ooo`03o`2I
oooooooo05Coool20000Soooo`00>?ooo`03o`2Ioooooooo05Coool00`000?ooooooo`2>oooo000h
oooo00?o09Woooooool0E?ooo`030000oooooooo08koool003Soool00ol0VOooooooo`1Doooo00<0
003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo05Coool20000Soooo`00>?ooo`03o`2Ioooooooo
05Coool00`000?ooooooo`2>oooo000hoooo00?o09Woooooool0>oooo`800004oooo0P0000Goool0
0`000?ooooooo`02oooo0P0000Goool00`000?ooooooo`2>oooo000hoooo00?o09Woooooool0>_oo
o`040000oooooooo00002_ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0
003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo03[oool010000?ooooooo`0000[oool00`000?oo
ooooo`04oooo00<0003oooooool00_ooo`<0002>oooo000hoooo00?o09Woooooool0>_ooo`040000
oooooooo00002oooo`040000oooooooooooo0P0000Goool00`000?ooooooo`2>oooo000hoooo00?o
09Woooooool0>_ooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo
00Coool00`000?ooooooo`2>oooo000hoooo00?o09Woooooool0>oooo`800009oooo100000?oool3
00001?ooo`030000oooooooo08koool003Soool00ol0VOooooooo`1Doooo0P0008ooool003Soool0
0ol0VOooooooo`1Doooo00<0003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo05Coool00`000?oo
ooooo`2>oooo000hoooo00?o09Woooooool0E?ooo`030000oooooooo08koool003Soool00ol0VOoo
ooooo`1Doooo0P0008ooool003Soool00ol0VOooooooo`1Doooo00<0003oooooool0S_ooo`00>?oo
o`03o`2Ioooooooo05Coool00`000?ooooooo`2>oooo000hoooo00?o09Woooooool0E?ooo`030000
oooooooo08koool003Soool00ol0VOooooooo`1Doooo0P0008ooool003Soool00ol0VOooooooo`1D
oooo00<0003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo05Coool00`000?ooooooo`2>oooo000h
oooo00?o09Woooooool0E?ooo`030000oooooooo08koool003Soool00ol0VOooooooo`1Doooo0P00
08ooool003Soool00ol0VOooooooo`1Doooo00<0003oooooool0S_ooo`00>?ooo`03o`2Ioooooooo
04coool500000oooo`030000oooooooo08koool003Soool00ol0VOooooooo`1>oooo00<0003ooooo
ool00oooo`030000oooooooo08koool003Soool00ol0VOooooooo`1>oooo00<0003oooooool00ooo
o`<0002>oooo0029oooo00<0003oooooool0U?ooo`00ROooo`030000oooooooo09Coool008Soool2
0000U_ooo`00ooooob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000oooooooo
07Koool007Goool00`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool0
07Goool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200000ooo
o`D00002oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000000_oo
o`030000oooooooo00;oool00`000?ooooooo`04oooo100000Goool00`000?ooooooo`09oooo00D0
003oooooooooool000000_ooo`050000oooooooooooo000007Ooool007Coool00`000?ooooooo`02
oooo00<0003oooooool05Oooo`030000oooooooo00Woool00`000?ooooooo`04oooo00<0003ooooo
ool00_ooo`030000oooooooo07Coool007Goool00`000?ooooooo`0500005?ooo`030000oooooooo
00Woool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003ooooo
ooooool000005oooo`030000oooooooo00Woool00`000?ooooooo`02oooo00<0003oooooool00ooo
o`030000oooooooo07Goool007Koool00`000?ooooooo`0Goooo0P0000[oool200001?ooo`<00002
oooo00<0003oooooool0M_ooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.12507 .30902 L
.14415 .30902 L
.1536 .30902 L
.15825 .30902 L
.16254 .30902 L
.16494 .30902 L
.16615 .30902 L
s
.16615 .30902 m
.16621 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00D0003ooooooooooooo09T00oooo`030000
oooooooo00Koool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool0
0`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`0Eoooo000Foooo00<0
003oooooool08Oooo`05o`2Ioooooooooooo000002Soool00`000?ooooooo`0Uoooo00<0003ooooo
ool09Oooo`030000oooooooo02Goool00`000?ooooooo`0Voooo00<0003oooooool05Oooo`00>_oo
o`03o`2Ioooooooo05;oool00`000?ooooooo`2>oooo000joooo00?o09Woooooool0D_ooo`80002?
oooo000joooo00?o09Woooooool0D_ooo`030000oooooooo08koool003[oool00ol0VOooooooo`1B
oooo00<0003oooooool0S_ooo`00>_ooo`03o`2Ioooooooo05;oool00`000?ooooooo`2>oooo000j
oooo00?o09Woooooool0D_ooo`80002?oooo000joooo00?o09Woooooool0D_ooo`030000oooooooo
08koool003[oool00ol0VOooooooo`1Boooo00<0003oooooool0S_ooo`00>_ooo`03o`2Ioooooooo
05;oool00`000?ooooooo`2>oooo000joooo00?o09Woooooool0D_ooo`80002?oooo000joooo00?o
09Woooooool0D_ooo`030000oooooooo08koool003[oool00ol0VOooooooo`1Boooo00<0003ooooo
ool0S_ooo`00>_ooo`03o`2Ioooooooo05;oool00`000?ooooooo`2>oooo000joooo00?o09Wooooo
ool0D_ooo`80002?oooo000joooo00?o09Woooooool0D_ooo`030000oooooooo08koool003[oool0
0ol0VOooooooo`0ioooo0P0000Coool200000oooo`@00003oooo0P0000Goool00`000?ooooooo`2>
oooo000joooo00?o09Woooooool0>?ooo`040000oooooooo00002?ooo`030000oooooooo00?oool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo000joooo00?o09Woooooool0>?ooo`040000
oooooooo00002Oooo`030000oooooooo00Goool00`000?ooooooo`02oooo0`0008koool003[oool0
0ol0VOooooooo`0hoooo00@0003oooooool0000:oooo00<0003oooooool00_ooo`800005oooo00<0
003oooooool0S_ooo`00>_ooo`03o`2Ioooooooo03Soool010000?ooooooo`0000Soool010000?oo
ooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00>_ooo`03o`2Ioooooooo
03Woool200002_ooo`800004oooo0`0000Coool00`000?ooooooo`2>oooo000joooo00?o09Wooooo
ool0D_ooo`80002?oooo000joooo00?o09Woooooool0D_ooo`030000oooooooo08koool003[oool0
0ol0VOooooooo`1Boooo00<0003oooooool0S_ooo`00>_ooo`03o`2Ioooooooo05;oool00`000?oo
ooooo`2>oooo000joooo00?o09Woooooool0D_ooo`80002?oooo000joooo00?o09Woooooool0D_oo
o`030000oooooooo08koool003[oool00ol0VOooooooo`1Boooo00<0003oooooool0S_ooo`00>_oo
o`03o`2Ioooooooo05;oool00`000?ooooooo`2>oooo000joooo00?o09Woooooool0D_ooo`80002?
oooo000joooo00?o09Woooooool0D_ooo`030000oooooooo08koool003[oool00ol0VOooooooo`1B
oooo00<0003oooooool0S_ooo`00>_ooo`03o`2Ioooooooo05;oool00`000?ooooooo`2>oooo000j
oooo00?o09Woooooool0D_ooo`80002?oooo000joooo00?o09Woooooool0D_ooo`030000oooooooo
08koool003[oool00ol0VOooooooo`0ooooo0P0000Coool200001?ooo`800005oooo00<0003ooooo
ool0S_ooo`00>_ooo`03o`2Ioooooooo03koool010000?ooooooo`0000Soool010000?ooooooo`00
00Coool00`000?ooooooo`2>oooo000joooo00?o09Woooooool0?_ooo`040000oooooooo00002ooo
o`030000oooooooo00;oool30000S_ooo`00>_ooo`03o`2Ioooooooo03koool010000?ooooooo`00
00Woool200001Oooo`030000oooooooo08koool003[oool00ol0VOooooooo`0noooo00@0003ooooo
ool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool003[oool00ol0VOooooooo`0o
oooo0P0000[oool300001?ooo`030000oooooooo08koool003[oool00ol0VOooooooo`1Boooo0P00
08ooool003[oool00ol0VOooooooo`1Boooo00<0003oooooool0S_ooo`00>_ooo`03o`2Ioooooooo
05;oool00`000?ooooooo`2>oooo000joooo00?o09Woooooool0D_ooo`80002?oooo000joooo00?o
09Woooooool0D_ooo`030000oooooooo08koool003[oool00ol0VOooooooo`1Boooo00<0003ooooo
ool0S_ooo`00>_ooo`03o`2Ioooooooo05;oool00`000?ooooooo`2>oooo000joooo00?o09Wooooo
ool0D_ooo`80002?oooo000joooo00?o09Woooooool0D_ooo`030000oooooooo08koool003[oool0
0ol0VOooooooo`1Boooo00<0003oooooool0S_ooo`00>_ooo`03o`2Ioooooooo05;oool00`000?oo
ooooo`2>oooo000joooo00?o09Woooooool0D_ooo`80002?oooo000joooo00?o09Woooooool0D_oo
o`030000oooooooo08koool003[oool00ol0VOooooooo`0ioooo0P0000Coool200001Oooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool003[oool00ol0VOooooooo`0hoooo00@0
003oooooool0000:oooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?oo
ooooo`2>oooo000joooo00?o09Woooooool0>?ooo`040000oooooooo00002_ooo`030000oooooooo
00Coool00`000?ooooooo`02oooo0`0008koool003[oool00ol0VOooooooo`0hoooo00@0003ooooo
ool0000;oooo00@0003oooooooooool200001Oooo`030000oooooooo08koool003[oool00ol0VOoo
ooooo`0hoooo00@0003oooooool00008oooo00@0003oooooool00003oooo00<0003oooooool01?oo
o`030000oooooooo08koool003[oool00ol0VOooooooo`0ioooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00>_ooo`03o`2Ioooooooo05;oool20000Soooo`00>_ooo`03o`2I
oooooooo05;oool00`000?ooooooo`2>oooo000joooo00?o09Woooooool0D_ooo`030000oooooooo
08koool003[oool00ol0VOooooooo`1Boooo00<0003oooooool0S_ooo`00>_ooo`03o`2Ioooooooo
05;oool20000Soooo`00>_ooo`03o`2Ioooooooo05;oool00`000?ooooooo`2>oooo000joooo00?o
09Woooooool0D_ooo`030000oooooooo08koool003[oool00ol0VOooooooo`1Boooo00<0003ooooo
ool0S_ooo`00>_ooo`03o`2Ioooooooo05;oool20000Soooo`00>_ooo`03o`2Ioooooooo05;oool0
0`000?ooooooo`2>oooo000joooo00?o09Woooooool0D_ooo`030000oooooooo08koool003[oool0
0ol0VOooooooo`1Boooo00<0003oooooool0S_ooo`00>_ooo`03o`2Ioooooooo05;oool20000Sooo
o`00>_ooo`03o`2Ioooooooo05;oool00`000?ooooooo`2>oooo000joooo00?o09Woooooool0B_oo
o`D00003oooo00<0003oooooool0S_ooo`00>_ooo`03o`2Ioooooooo04coool00`000?ooooooo`03
oooo00<0003oooooool0S_ooo`00>_ooo`03o`2Ioooooooo04coool00`000?ooooooo`03oooo0`00
08koool008Woool00`000?ooooooo`2Doooo0029oooo00<0003oooooool0U?ooo`00R?ooo`80002F
oooo003ooooo8Oooo`00ooooob7oool007Woool00`000?ooooooo`0Xoooo00<0003oooooool0NOoo
o`00N?ooo`030000oooooooo00Soool00`000?ooooooo`0Ooooo00<0003oooooool0N?ooo`00N?oo
o`030000oooooooo00;oool200001?ooo`030000oooooooo00coool500000_ooo`800003oooo1@00
00;oool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000000_ooo`030000oooooooo
00;oool00`000?ooooooo`04oooo100000Goool00`000?ooooooo`09oooo00<0003oooooool00_oo
o`030000oooooooo07Soool007Ooool00`000?ooooooo`02oooo00<0003oooooool05Oooo`030000
oooooooo00Woool00`000?ooooooo`03oooo00<0003oooooool0Moooo`00N?ooo`030000oooooooo
00D0000Doooo00<0003oooooool02Oooo`030000oooooooo00;oool00`000?ooooooo`1hoooo001h
oooo00D0003oooooooooool000005oooo`030000oooooooo00Woool00`000?ooooooo`02oooo00<0
003oooooool0N?ooo`00NOooo`030000oooooooo01Ooool200002_ooo`800003oooo00<0003ooooo
ool0NOooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.05) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.12507 .30902 L
.14415 .30902 L
.16254 .30902 L
.16783 .30902 L
.17044 .30902 L
.17158 .30902 L
.17284 .30902 L
.17396 .30902 L
s
.17396 .30902 m
.17407 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.05) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool00oooo`03o`2Ioooo0000
00Soool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`0Eoooo000Foooo00<0003ooooo
ool08oooo`03o`2Ioooo000002Soool00`000?ooooooo`0Uoooo00<0003oooooool09Oooo`030000
oooooooo02Goool00`000?ooooooo`0Voooo00<0003oooooool05Oooo`00??ooo`03o`2Ioooooooo
053oool00`000?ooooooo`2>oooo000loooo00?o09Woooooool0D?ooo`80002?oooo000loooo00?o
09Woooooool0D?ooo`030000oooooooo08koool003coool00ol0VOooooooo`1@oooo00<0003ooooo
ool0S_ooo`00??ooo`03o`2Ioooooooo053oool00`000?ooooooo`2>oooo000loooo00?o09Wooooo
ool0D?ooo`80002?oooo000loooo00?o09Woooooool0D?ooo`030000oooooooo08koool003coool0
0ol0VOooooooo`1@oooo00<0003oooooool0S_ooo`00??ooo`03o`2Ioooooooo053oool00`000?oo
ooooo`2>oooo000loooo00?o09Woooooool0D?ooo`80002?oooo000loooo00?o09Woooooool0D?oo
o`030000oooooooo08koool003coool00ol0VOooooooo`1@oooo00<0003oooooool0S_ooo`00??oo
o`03o`2Ioooooooo053oool00`000?ooooooo`2>oooo000loooo00?o09Woooooool0D?ooo`80002?
oooo000loooo00?o09Woooooool0D?ooo`030000oooooooo08koool003coool00ol0VOooooooo`0g
oooo0P0000Coool200000oooo`@00003oooo0P0000Goool00`000?ooooooo`2>oooo000loooo00?o
09Woooooool0=_ooo`040000oooooooo00002?ooo`030000oooooooo00?oool010000?ooooooo`00
00Coool00`000?ooooooo`2>oooo000loooo00?o09Woooooool0=_ooo`040000oooooooo00002Ooo
o`030000oooooooo00Goool00`000?ooooooo`02oooo0`0008koool003coool00ol0VOooooooo`0f
oooo00@0003oooooool0000:oooo00<0003oooooool00_ooo`800005oooo00<0003oooooool0S_oo
o`00??ooo`03o`2Ioooooooo03Koool010000?ooooooo`0000Soool010000?ooooooo`0000?oool0
0`000?ooooooo`04oooo00<0003oooooool0S_ooo`00??ooo`03o`2Ioooooooo03Ooool200002_oo
o`800004oooo0`0000Coool00`000?ooooooo`2>oooo000loooo00?o09Woooooool0D?ooo`80002?
oooo000loooo00?o09Woooooool0D?ooo`030000oooooooo08koool003coool00ol0VOooooooo`1@
oooo00<0003oooooool0S_ooo`00??ooo`03o`2Ioooooooo053oool00`000?ooooooo`2>oooo000l
oooo00?o09Woooooool0D?ooo`80002?oooo000loooo00?o09Woooooool0D?ooo`030000oooooooo
08koool003coool00ol0VOooooooo`1@oooo00<0003oooooool0S_ooo`00??ooo`03o`2Ioooooooo
053oool00`000?ooooooo`2>oooo000loooo00?o09Woooooool0D?ooo`80002?oooo000loooo00?o
09Woooooool0D?ooo`030000oooooooo08koool003coool00ol0VOooooooo`1@oooo00<0003ooooo
ool0S_ooo`00??ooo`03o`2Ioooooooo053oool00`000?ooooooo`2>oooo000loooo00?o09Wooooo
ool0D?ooo`80002?oooo000loooo00?o09Woooooool0D?ooo`030000oooooooo08koool003coool0
0ol0VOooooooo`0moooo0P0000Coool200001?ooo`800005oooo00<0003oooooool0S_ooo`00??oo
o`03o`2Ioooooooo03coool010000?ooooooo`0000Soool010000?ooooooo`0000Coool00`000?oo
ooooo`2>oooo000loooo00?o09Woooooool0??ooo`040000oooooooo00002oooo`030000oooooooo
00;oool30000S_ooo`00??ooo`03o`2Ioooooooo03coool010000?ooooooo`0000Woool200001Ooo
o`030000oooooooo08koool003coool00ol0VOooooooo`0loooo00@0003oooooool00009oooo00<0
003oooooool01?ooo`030000oooooooo08koool003coool00ol0VOooooooo`0moooo0P0000[oool3
00001?ooo`030000oooooooo08koool003coool00ol0VOooooooo`1@oooo0P0008ooool003coool0
0ol0VOooooooo`1@oooo00<0003oooooool0S_ooo`00??ooo`03o`2Ioooooooo053oool00`000?oo
ooooo`2>oooo000loooo00?o09Woooooool0D?ooo`80002?oooo000loooo00?o09Woooooool0D?oo
o`030000oooooooo08koool003coool00ol0VOooooooo`1@oooo00<0003oooooool0S_ooo`00??oo
o`03o`2Ioooooooo053oool00`000?ooooooo`2>oooo000loooo00?o09Woooooool0D?ooo`80002?
oooo000loooo00?o09Woooooool0D?ooo`030000oooooooo08koool003coool00ol0VOooooooo`1@
oooo00<0003oooooool0S_ooo`00??ooo`03o`2Ioooooooo053oool00`000?ooooooo`2>oooo000l
oooo00?o09Woooooool0D?ooo`80002?oooo000loooo00?o09Woooooool0D?ooo`030000oooooooo
08koool003coool00ol0VOooooooo`0goooo0P0000Coool200001Oooo`030000oooooooo00;oool2
00001Oooo`030000oooooooo08koool003coool00ol0VOooooooo`0foooo00@0003oooooool0000:
oooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`2>oooo000l
oooo00?o09Woooooool0=_ooo`040000oooooooo00002_ooo`030000oooooooo00Coool00`000?oo
ooooo`02oooo0`0008koool003coool00ol0VOooooooo`0foooo00@0003oooooool0000;oooo00@0
003oooooooooool200001Oooo`030000oooooooo08koool003coool00ol0VOooooooo`0foooo00@0
003oooooool00008oooo00@0003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo
08koool003coool00ol0VOooooooo`0goooo0P0000Woool400000oooo`<00004oooo00<0003ooooo
ool0S_ooo`00??ooo`03o`2Ioooooooo053oool20000Soooo`00??ooo`03o`2Ioooooooo053oool0
0`000?ooooooo`2>oooo000loooo00?o09Woooooool0D?ooo`030000oooooooo08koool003coool0
0ol0VOooooooo`1@oooo00<0003oooooool0S_ooo`00??ooo`03o`2Ioooooooo053oool20000Sooo
o`00??ooo`03o`2Ioooooooo053oool00`000?ooooooo`2>oooo000loooo00?o09Woooooool0D?oo
o`030000oooooooo08koool003coool00ol0VOooooooo`1@oooo00<0003oooooool0S_ooo`00??oo
o`03o`2Ioooooooo053oool20000Soooo`00??ooo`03o`2Ioooooooo053oool00`000?ooooooo`2>
oooo000loooo00?o09Woooooool0D?ooo`030000oooooooo08koool003coool00ol0VOooooooo`1@
oooo00<0003oooooool0S_ooo`00??ooo`03o`2Ioooooooo053oool20000Soooo`00??ooo`03o`2I
oooooooo053oool00`000?ooooooo`2>oooo000loooo00?o09Woooooool0B?ooo`D00003oooo00<0
003oooooool0S_ooo`00??ooo`03o`2Ioooooooo04[oool00`000?ooooooo`03oooo00<0003ooooo
ool0S_ooo`00??ooo`03o`2Ioooooooo04[oool00`000?ooooooo`03oooo0`0008koool008Woool0
0`000?ooooooo`2Doooo0029oooo00<0003oooooool0U?ooo`00R?ooo`80002Foooo003ooooo8Ooo
o`00ooooob7oool007Koool00`000?ooooooo`0^oooo00<0003oooooool0M_ooo`00MOooo`030000
oooooooo00Soool00`000?ooooooo`0Uoooo00<0003oooooool0MOooo`00MOooo`030000oooooooo
00;oool200001?ooo`030000oooooooo00coool500000_ooo`800004oooo0P0000Coool200001?oo
o`030000oooooooo07Goool007Goool01@000?ooooooooooo`000002oooo00<0003oooooool00_oo
o`030000oooooooo00Coool400001Oooo`030000oooooooo00Ooool010000?ooooooo`0000;oool0
10000?ooooooo`0000?oool00`000?ooooooo`1eoooo001doooo00<0003oooooool00_ooo`030000
oooooooo01Goool00`000?ooooooo`07oooo00@0003oooooool00005oooo00<0003oooooool00_oo
o`030000oooooooo07Coool007Goool00`000?ooooooo`0500005?ooo`030000oooooooo00Ooool0
10000?ooooooo`0000?oool200001?ooo`030000oooooooo07Goool007Goool01@000?oooooooooo
o`00000Goooo00<0003oooooool01oooo`040000oooooooo00000oooo`030000oooooooo00?oool0
0`000?ooooooo`1eoooo001foooo00<0003oooooool05oooo`80000:oooo0P0000Coool300000_oo
o`030000oooooooo07Koool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.16408 .30902 L
.17277 .30902 L
.17735 .30902 L
.17986 .30902 L
.18109 .30902 L
.18221 .30902 L
s
.18221 .30902 m
.18233 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Koool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`0Eoooo000Foooo00<0003ooooo
ool09Oooo`030000oooooooo02Koool00`000?ooooooo`0Uoooo00<0003oooooool09Oooo`030000
oooooooo02Goool00`000?ooooooo`0Voooo00<0003oooooool05Oooo`00?_ooo`03o`2Ioooooooo
04koool00`000?ooooooo`2>oooo000noooo00?o09Woooooool0C_ooo`80002?oooo000noooo00?o
09Woooooool0C_ooo`030000oooooooo08koool003koool00ol0VOooooooo`1>oooo00<0003ooooo
ool0S_ooo`00?_ooo`03o`2Ioooooooo04koool00`000?ooooooo`2>oooo000noooo00?o09Wooooo
ool0C_ooo`80002?oooo000noooo00?o09Woooooool0C_ooo`030000oooooooo08koool003koool0
0ol0VOooooooo`1>oooo00<0003oooooool0S_ooo`00?_ooo`03o`2Ioooooooo04koool00`000?oo
ooooo`2>oooo000noooo00?o09Woooooool0C_ooo`80002?oooo000noooo00?o09Woooooool0C_oo
o`030000oooooooo08koool003koool00ol0VOooooooo`1>oooo00<0003oooooool0S_ooo`00?_oo
o`03o`2Ioooooooo04koool00`000?ooooooo`2>oooo000noooo00?o09Woooooool0C_ooo`80002?
oooo000noooo00?o09Woooooool0C_ooo`030000oooooooo08koool003koool00ol0VOooooooo`0e
oooo0P0000Coool200000oooo`@00003oooo0P0000Goool00`000?ooooooo`2>oooo000noooo00?o
09Woooooool0=?ooo`040000oooooooo00002?ooo`030000oooooooo00?oool010000?ooooooo`00
00Coool00`000?ooooooo`2>oooo000noooo00?o09Woooooool0=?ooo`040000oooooooo00002Ooo
o`030000oooooooo00Goool00`000?ooooooo`02oooo0`0008koool003koool00ol0VOooooooo`0d
oooo00@0003oooooool0000:oooo00<0003oooooool00_ooo`800005oooo00<0003oooooool0S_oo
o`00?_ooo`03o`2Ioooooooo03Coool010000?ooooooo`0000Soool010000?ooooooo`0000?oool0
0`000?ooooooo`04oooo00<0003oooooool0S_ooo`00?_ooo`03o`2Ioooooooo03Goool200002_oo
o`800004oooo0`0000Coool00`000?ooooooo`2>oooo000noooo00?o09Woooooool0C_ooo`80002?
oooo000noooo00?o09Woooooool0C_ooo`030000oooooooo08koool003koool00ol0VOooooooo`1>
oooo00<0003oooooool0S_ooo`00?_ooo`03o`2Ioooooooo04koool00`000?ooooooo`2>oooo000n
oooo00?o09Woooooool0C_ooo`80002?oooo000noooo00?o09Woooooool0C_ooo`030000oooooooo
08koool003koool00ol0VOooooooo`1>oooo00<0003oooooool0S_ooo`00?_ooo`03o`2Ioooooooo
04koool00`000?ooooooo`2>oooo000noooo00?o09Woooooool0C_ooo`80002?oooo000noooo00?o
09Woooooool0C_ooo`030000oooooooo08koool003koool00ol0VOooooooo`1>oooo00<0003ooooo
ool0S_ooo`00?_ooo`03o`2Ioooooooo04koool00`000?ooooooo`2>oooo000noooo00?o09Wooooo
ool0C_ooo`80002?oooo000noooo00?o09Woooooool0C_ooo`030000oooooooo08koool003koool0
0ol0VOooooooo`0koooo0P0000Coool200001?ooo`800005oooo00<0003oooooool0S_ooo`00?_oo
o`03o`2Ioooooooo03[oool010000?ooooooo`0000Soool010000?ooooooo`0000Coool00`000?oo
ooooo`2>oooo000noooo00?o09Woooooool0>_ooo`040000oooooooo00002oooo`030000oooooooo
00;oool30000S_ooo`00?_ooo`03o`2Ioooooooo03[oool010000?ooooooo`0000Woool200001Ooo
o`030000oooooooo08koool003koool00ol0VOooooooo`0joooo00@0003oooooool00009oooo00<0
003oooooool01?ooo`030000oooooooo08koool003koool00ol0VOooooooo`0koooo0P0000[oool3
00001?ooo`030000oooooooo08koool003koool00ol0VOooooooo`1>oooo0P0008ooool003koool0
0ol0VOooooooo`1>oooo00<0003oooooool0S_ooo`00?_ooo`03o`2Ioooooooo04koool00`000?oo
ooooo`2>oooo000noooo00?o09Woooooool0C_ooo`80002?oooo000noooo00?o09Woooooool0C_oo
o`030000oooooooo08koool003koool00ol0VOooooooo`1>oooo00<0003oooooool0S_ooo`00?_oo
o`03o`2Ioooooooo04koool00`000?ooooooo`2>oooo000noooo00?o09Woooooool0C_ooo`80002?
oooo000noooo00?o09Woooooool0C_ooo`030000oooooooo08koool003koool00ol0VOooooooo`1>
oooo00<0003oooooool0S_ooo`00?_ooo`03o`2Ioooooooo04koool00`000?ooooooo`2>oooo000n
oooo00?o09Woooooool0C_ooo`80002?oooo000noooo00?o09Woooooool0C_ooo`030000oooooooo
08koool003koool00ol0VOooooooo`0eoooo0P0000Coool200001Oooo`030000oooooooo00;oool2
00001Oooo`030000oooooooo08koool003koool00ol0VOooooooo`0doooo00@0003oooooool0000:
oooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`2>oooo000n
oooo00?o09Woooooool0=?ooo`040000oooooooo00002_ooo`030000oooooooo00Coool00`000?oo
ooooo`02oooo0`0008koool003koool00ol0VOooooooo`0doooo00@0003oooooool0000;oooo00@0
003oooooooooool200001Oooo`030000oooooooo08koool003koool00ol0VOooooooo`0doooo00@0
003oooooool00008oooo00@0003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo
08koool003koool00ol0VOooooooo`0eoooo0P0000Woool400000oooo`<00004oooo00<0003ooooo
ool0S_ooo`00?_ooo`03o`2Ioooooooo04koool20000Soooo`00?_ooo`03o`2Ioooooooo04koool0
0`000?ooooooo`2>oooo000noooo00?o09Woooooool0C_ooo`030000oooooooo08koool003koool0
0ol0VOooooooo`1>oooo00<0003oooooool0S_ooo`00?_ooo`03o`2Ioooooooo04koool20000Sooo
o`00?_ooo`03o`2Ioooooooo04koool00`000?ooooooo`2>oooo000noooo00?o09Woooooool0C_oo
o`030000oooooooo08koool003koool00ol0VOooooooo`1>oooo00<0003oooooool0S_ooo`00?_oo
o`03o`2Ioooooooo04koool20000Soooo`00?_ooo`03o`2Ioooooooo04koool00`000?ooooooo`2>
oooo000noooo00?o09Woooooool0C_ooo`030000oooooooo08koool003koool00ol0VOooooooo`1>
oooo00<0003oooooool0S_ooo`00?_ooo`03o`2Ioooooooo04koool20000Soooo`00?_ooo`03o`2I
oooooooo04koool00`000?ooooooo`2>oooo000noooo00?o09Woooooool0A_ooo`D00003oooo00<0
003oooooool0S_ooo`00?_ooo`03o`2Ioooooooo04Soool00`000?ooooooo`03oooo00<0003ooooo
ool0S_ooo`00?_ooo`03o`2Ioooooooo04Soool00`000?ooooooo`03oooo0`0008koool008Woool0
0`000?ooooooo`2Doooo0029oooo00<0003oooooool0U?ooo`00R?ooo`80002Foooo003ooooo8Ooo
o`00ooooob7oool007coool00`000?ooooooo`0Roooo00<0003oooooool0O?ooo`00Noooo`030000
oooooooo00Soool00`000?ooooooo`0Ioooo00<0003oooooool0Noooo`00Noooo`030000oooooooo
00;oool200001?ooo`030000oooooooo00coool500000_ooo`800004oooo00<0003oooooool0Nooo
o`00Noooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01?oo
o`@00005oooo00<0003oooooool02?ooo`030000oooooooo07_oool007[oool00`000?ooooooo`02
oooo00<0003oooooool05Oooo`030000oooooooo00Woool00`000?ooooooo`1joooo001koooo00<0
003oooooool01@0001Coool00`000?ooooooo`08oooo00<0003oooooool0Noooo`00Noooo`050000
oooooooooooo000001Ooool00`000?ooooooo`08oooo00<0003oooooool0Noooo`00O?ooo`030000
oooooooo01Ooool200002Oooo`030000oooooooo07coool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.95) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.16408 .30902 L
.17277 .30902 L
.18221 .30902 L
.18475 .30902 L
.18744 .30902 L
.18855 .30902 L
.18974 .30902 L
s
.18974 .30902 m
.18987 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.95) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000ooooo`2I
00Koool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`0Eoooo000Foooo00<0003ooooo
ool09Oooo`030000ooooo`2I02Koool00`000?ooooooo`0Uoooo00<0003oooooool09Oooo`030000
oooooooo02Goool00`000?ooooooo`0Voooo00<0003oooooool05Oooo`00@?ooo`03o`2Ioooooooo
04coool00`000?ooooooo`2>oooo0010oooo00?o09Woooooool0C?ooo`80002?oooo0010oooo00?o
09Woooooool0C?ooo`030000oooooooo08koool0043oool00ol0VOooooooo`1<oooo00<0003ooooo
ool0S_ooo`00@?ooo`03o`2Ioooooooo04coool00`000?ooooooo`2>oooo0010oooo00?o09Wooooo
ool0C?ooo`80002?oooo0010oooo00?o09Woooooool0C?ooo`030000oooooooo08koool0043oool0
0ol0VOooooooo`1<oooo00<0003oooooool0S_ooo`00@?ooo`03o`2Ioooooooo04coool00`000?oo
ooooo`2>oooo0010oooo00?o09Woooooool0C?ooo`80002?oooo0010oooo00?o09Woooooool0C?oo
o`030000oooooooo08koool0043oool00ol0VOooooooo`1<oooo00<0003oooooool0S_ooo`00@?oo
o`03o`2Ioooooooo04coool00`000?ooooooo`2>oooo0010oooo00?o09Woooooool0C?ooo`80002?
oooo0010oooo00?o09Woooooool0C?ooo`030000oooooooo08koool0043oool00ol0VOooooooo`0c
oooo0P0000Coool200000oooo`@00003oooo0P0000Goool00`000?ooooooo`2>oooo0010oooo00?o
09Woooooool0<_ooo`040000oooooooo00002?ooo`030000oooooooo00?oool010000?ooooooo`00
00Coool00`000?ooooooo`2>oooo0010oooo00?o09Woooooool0<_ooo`040000oooooooo00002Ooo
o`030000oooooooo00Goool00`000?ooooooo`02oooo0`0008koool0043oool00ol0VOooooooo`0b
oooo00@0003oooooool0000:oooo00<0003oooooool00_ooo`800005oooo00<0003oooooool0S_oo
o`00@?ooo`03o`2Ioooooooo03;oool010000?ooooooo`0000Soool010000?ooooooo`0000?oool0
0`000?ooooooo`04oooo00<0003oooooool0S_ooo`00@?ooo`03o`2Ioooooooo03?oool200002_oo
o`800004oooo0`0000Coool00`000?ooooooo`2>oooo0010oooo00?o09Woooooool0C?ooo`80002?
oooo0010oooo00?o09Woooooool0C?ooo`030000oooooooo08koool0043oool00ol0VOooooooo`1<
oooo00<0003oooooool0S_ooo`00@?ooo`03o`2Ioooooooo04coool00`000?ooooooo`2>oooo0010
oooo00?o09Woooooool0C?ooo`80002?oooo0010oooo00?o09Woooooool0C?ooo`030000oooooooo
08koool0043oool00ol0VOooooooo`1<oooo00<0003oooooool0S_ooo`00@?ooo`03o`2Ioooooooo
04coool00`000?ooooooo`2>oooo0010oooo00?o09Woooooool0C?ooo`80002?oooo0010oooo00?o
09Woooooool0C?ooo`030000oooooooo08koool0043oool00ol0VOooooooo`1<oooo00<0003ooooo
ool0S_ooo`00@?ooo`03o`2Ioooooooo04coool00`000?ooooooo`2>oooo0010oooo00?o09Wooooo
ool0C?ooo`80002?oooo0010oooo00?o09Woooooool0C?ooo`030000oooooooo08koool0043oool0
0ol0VOooooooo`0ioooo0P0000Coool200001?ooo`800005oooo00<0003oooooool0S_ooo`00@?oo
o`03o`2Ioooooooo03Soool010000?ooooooo`0000Soool010000?ooooooo`0000Coool00`000?oo
ooooo`2>oooo0010oooo00?o09Woooooool0>?ooo`040000oooooooo00002oooo`030000oooooooo
00;oool30000S_ooo`00@?ooo`03o`2Ioooooooo03Soool010000?ooooooo`0000Woool200001Ooo
o`030000oooooooo08koool0043oool00ol0VOooooooo`0hoooo00@0003oooooool00009oooo00<0
003oooooool01?ooo`030000oooooooo08koool0043oool00ol0VOooooooo`0ioooo0P0000[oool3
00001?ooo`030000oooooooo08koool0043oool00ol0VOooooooo`1<oooo0P0008ooool0043oool0
0ol0VOooooooo`1<oooo00<0003oooooool0S_ooo`00@?ooo`03o`2Ioooooooo04coool00`000?oo
ooooo`2>oooo0010oooo00?o09Woooooool0C?ooo`80002?oooo0010oooo00?o09Woooooool0C?oo
o`030000oooooooo08koool0043oool00ol0VOooooooo`1<oooo00<0003oooooool0S_ooo`00@?oo
o`03o`2Ioooooooo04coool00`000?ooooooo`2>oooo0010oooo00?o09Woooooool0C?ooo`80002?
oooo0010oooo00?o09Woooooool0C?ooo`030000oooooooo08koool0043oool00ol0VOooooooo`1<
oooo00<0003oooooool0S_ooo`00@?ooo`03o`2Ioooooooo04coool00`000?ooooooo`2>oooo0010
oooo00?o09Woooooool0C?ooo`80002?oooo0010oooo00?o09Woooooool0C?ooo`030000oooooooo
08koool0043oool00ol0VOooooooo`0coooo0P0000Coool200001Oooo`030000oooooooo00;oool2
00001Oooo`030000oooooooo08koool0043oool00ol0VOooooooo`0boooo00@0003oooooool0000:
oooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`2>oooo0010
oooo00?o09Woooooool0<_ooo`040000oooooooo00002_ooo`030000oooooooo00Coool00`000?oo
ooooo`02oooo0`0008koool0043oool00ol0VOooooooo`0boooo00@0003oooooool0000;oooo00@0
003oooooooooool200001Oooo`030000oooooooo08koool0043oool00ol0VOooooooo`0boooo00@0
003oooooool00008oooo00@0003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo
08koool0043oool00ol0VOooooooo`0coooo0P0000Woool400000oooo`<00004oooo00<0003ooooo
ool0S_ooo`00@?ooo`03o`2Ioooooooo04coool20000Soooo`00@?ooo`03o`2Ioooooooo04coool0
0`000?ooooooo`2>oooo0010oooo00?o09Woooooool0C?ooo`030000oooooooo08koool0043oool0
0ol0VOooooooo`1<oooo00<0003oooooool0S_ooo`00@?ooo`03o`2Ioooooooo04coool20000Sooo
o`00@?ooo`03o`2Ioooooooo04coool00`000?ooooooo`2>oooo0010oooo00?o09Woooooool0C?oo
o`030000oooooooo08koool0043oool00ol0VOooooooo`1<oooo00<0003oooooool0S_ooo`00@?oo
o`03o`2Ioooooooo04coool20000Soooo`00@?ooo`03o`2Ioooooooo04coool00`000?ooooooo`2>
oooo0010oooo00?o09Woooooool0C?ooo`030000oooooooo08koool0043oool00ol0VOooooooo`1<
oooo00<0003oooooool0S_ooo`00@?ooo`03o`2Ioooooooo04coool20000Soooo`00@?ooo`03o`2I
oooooooo04coool00`000?ooooooo`2>oooo0010oooo00?o09Woooooool0A?ooo`D00003oooo00<0
003oooooool0S_ooo`00@?ooo`03o`2Ioooooooo04Koool00`000?ooooooo`03oooo00<0003ooooo
ool0S_ooo`00@?ooo`03o`2Ioooooooo04Koool00`000?ooooooo`03oooo0`0008koool008Woool0
0`000?ooooooo`2Doooo0029oooo00<0003oooooool0U?ooo`00R?ooo`80002Foooo003ooooo8Ooo
o`00ooooob7oool007Koool00`000?ooooooo`0^oooo00<0003oooooool0M_ooo`00MOooo`030000
oooooooo00Soool00`000?ooooooo`0Uoooo00<0003oooooool0MOooo`00MOooo`030000oooooooo
00;oool200001?ooo`030000oooooooo00goool200001?ooo`800003oooo0`0000Coool200001?oo
o`030000oooooooo07Goool007Goool01@000?ooooooooooo`000002oooo00<0003oooooool00_oo
o`030000oooooooo00Coool400000oooo`040000oooooooo00002_ooo`050000oooooooooooo0000
00;oool01@000?ooooooooooo`00001goooo001doooo00<0003oooooool00_ooo`030000oooooooo
01?oool010000?ooooooo`0000Woool300001Oooo`030000oooooooo00;oool00`000?ooooooo`1d
oooo001eoooo00<0003oooooool01@0001;oool010000?ooooooo`0000Soool010000?ooooooo`00
00?oool200001?ooo`030000oooooooo07Goool007Goool01@000?ooooooooooo`00000Eoooo00@0
003oooooool00008oooo00@0003oooooool00003oooo00<0003oooooool00oooo`030000oooooooo
07Goool007Koool00`000?ooooooo`0Goooo0P0000[oool300000oooo`<00002oooo00<0003ooooo
ool0M_ooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.9) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.16408 .30902 L
.18221 .30902 L
.18703 .30902 L
.19227 .30902 L
.19467 .30902 L
.19598 .30902 L
.19721 .30902 L
.19826 .30902 L
s
.19826 .30902 m
.19837 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.9) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`050000oooooooo
ooooo`2I00Coool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool0
0`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`0Eoooo000Foooo00<0
003oooooool09Oooo`050000ooooooooooooo`2I02Coool00`000?ooooooo`0Uoooo00<0003ooooo
ool09Oooo`030000oooooooo02Goool00`000?ooooooo`0Voooo00<0003oooooool05Oooo`00@_oo
o`03o`2Ioooooooo04[oool00`000?ooooooo`2>oooo0012oooo00?o09Woooooool0B_ooo`80002?
oooo0012oooo00?o09Woooooool0B_ooo`030000oooooooo08koool004;oool00ol0VOooooooo`1:
oooo00<0003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo04[oool00`000?ooooooo`2>oooo0012
oooo00?o09Woooooool0B_ooo`80002?oooo0012oooo00?o09Woooooool0B_ooo`030000oooooooo
08koool004;oool00ol0VOooooooo`1:oooo00<0003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo
04[oool00`000?ooooooo`2>oooo0012oooo00?o09Woooooool0B_ooo`80002?oooo0012oooo00?o
09Woooooool0B_ooo`030000oooooooo08koool004;oool00ol0VOooooooo`1:oooo00<0003ooooo
ool0S_ooo`00@_ooo`03o`2Ioooooooo04[oool00`000?ooooooo`2>oooo0012oooo00?o09Wooooo
ool0B_ooo`80002?oooo0012oooo00?o09Woooooool0B_ooo`030000oooooooo08koool004;oool0
0ol0VOooooooo`0aoooo0P0000Coool200000oooo`@00003oooo0P0000Goool00`000?ooooooo`2>
oooo0012oooo00?o09Woooooool0<?ooo`040000oooooooo00002?ooo`030000oooooooo00?oool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo0012oooo00?o09Woooooool0<?ooo`040000
oooooooo00002Oooo`030000oooooooo00Goool00`000?ooooooo`02oooo0`0008koool004;oool0
0ol0VOooooooo`0`oooo00@0003oooooool0000:oooo00<0003oooooool00_ooo`800005oooo00<0
003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo033oool010000?ooooooo`0000Soool010000?oo
ooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo
037oool200002_ooo`800004oooo0`0000Coool00`000?ooooooo`2>oooo0012oooo00?o09Wooooo
ool0B_ooo`80002?oooo0012oooo00?o09Woooooool0B_ooo`030000oooooooo08koool004;oool0
0ol0VOooooooo`1:oooo00<0003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo04[oool00`000?oo
ooooo`2>oooo0012oooo00?o09Woooooool0B_ooo`80002?oooo0012oooo00?o09Woooooool0B_oo
o`030000oooooooo08koool004;oool00ol0VOooooooo`1:oooo00<0003oooooool0S_ooo`00@_oo
o`03o`2Ioooooooo04[oool00`000?ooooooo`2>oooo0012oooo00?o09Woooooool0B_ooo`80002?
oooo0012oooo00?o09Woooooool0B_ooo`030000oooooooo08koool004;oool00ol0VOooooooo`1:
oooo00<0003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo04[oool00`000?ooooooo`2>oooo0012
oooo00?o09Woooooool0B_ooo`80002?oooo0012oooo00?o09Woooooool0B_ooo`030000oooooooo
08koool004;oool00ol0VOooooooo`0goooo0P0000Coool200001?ooo`800005oooo00<0003ooooo
ool0S_ooo`00@_ooo`03o`2Ioooooooo03Koool010000?ooooooo`0000Soool010000?ooooooo`00
00Coool00`000?ooooooo`2>oooo0012oooo00?o09Woooooool0=_ooo`040000oooooooo00002ooo
o`030000oooooooo00;oool30000S_ooo`00@_ooo`03o`2Ioooooooo03Koool010000?ooooooo`00
00Woool200001Oooo`030000oooooooo08koool004;oool00ol0VOooooooo`0foooo00@0003ooooo
ool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool004;oool00ol0VOooooooo`0g
oooo0P0000[oool300001?ooo`030000oooooooo08koool004;oool00ol0VOooooooo`1:oooo0P00
08ooool004;oool00ol0VOooooooo`1:oooo00<0003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo
04[oool00`000?ooooooo`2>oooo0012oooo00?o09Woooooool0B_ooo`80002?oooo0012oooo00?o
09Woooooool0B_ooo`030000oooooooo08koool004;oool00ol0VOooooooo`1:oooo00<0003ooooo
ool0S_ooo`00@_ooo`03o`2Ioooooooo04[oool00`000?ooooooo`2>oooo0012oooo00?o09Wooooo
ool0B_ooo`80002?oooo0012oooo00?o09Woooooool0B_ooo`030000oooooooo08koool004;oool0
0ol0VOooooooo`1:oooo00<0003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo04[oool00`000?oo
ooooo`2>oooo0012oooo00?o09Woooooool0B_ooo`80002?oooo0012oooo00?o09Woooooool0B_oo
o`030000oooooooo08koool004;oool00ol0VOooooooo`0aoooo0P0000Coool200001Oooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool004;oool00ol0VOooooooo`0`oooo00@0
003oooooool0000:oooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?oo
ooooo`2>oooo0012oooo00?o09Woooooool0<?ooo`040000oooooooo00002_ooo`030000oooooooo
00Coool00`000?ooooooo`02oooo0`0008koool004;oool00ol0VOooooooo`0`oooo00@0003ooooo
ool0000;oooo00@0003oooooooooool200001Oooo`030000oooooooo08koool004;oool00ol0VOoo
ooooo`0`oooo00@0003oooooool00008oooo00@0003oooooool00003oooo00<0003oooooool01?oo
o`030000oooooooo08koool004;oool00ol0VOooooooo`0aoooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo04[oool20000Soooo`00@_ooo`03o`2I
oooooooo04[oool00`000?ooooooo`2>oooo0012oooo00?o09Woooooool0B_ooo`030000oooooooo
08koool004;oool00ol0VOooooooo`1:oooo00<0003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo
04[oool20000Soooo`00@_ooo`03o`2Ioooooooo04[oool00`000?ooooooo`2>oooo0012oooo00?o
09Woooooool0B_ooo`030000oooooooo08koool004;oool00ol0VOooooooo`1:oooo00<0003ooooo
ool0S_ooo`00@_ooo`03o`2Ioooooooo04[oool20000Soooo`00@_ooo`03o`2Ioooooooo04[oool0
0`000?ooooooo`2>oooo0012oooo00?o09Woooooool0B_ooo`030000oooooooo08koool004;oool0
0ol0VOooooooo`1:oooo00<0003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo04[oool20000Sooo
o`00@_ooo`03o`2Ioooooooo04[oool00`000?ooooooo`2>oooo0012oooo00?o09Woooooool0@_oo
o`D00003oooo00<0003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo04Coool00`000?ooooooo`03
oooo00<0003oooooool0S_ooo`00@_ooo`03o`2Ioooooooo04Coool00`000?ooooooo`03oooo0`00
08koool008Woool00`000?ooooooo`2Doooo0029oooo00<0003oooooool0U?ooo`00R?ooo`80002F
oooo003ooooo8Oooo`00ooooob7oool007Woool00`000?ooooooo`0Xoooo00<0003oooooool0NOoo
o`00N?ooo`030000oooooooo00Soool00`000?ooooooo`0Ooooo00<0003oooooool0N?ooo`00N?oo
o`030000oooooooo00;oool200001?ooo`030000oooooooo00goool200001?ooo`800003oooo0`00
00Coool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000000_ooo`030000oooooooo
00;oool00`000?ooooooo`04oooo100000?oool010000?ooooooo`0000[oool00`000?ooooooo`02
oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo00;oool00`000?ooooooo`0Coooo00@0
003oooooool00009oooo0`0000Coool00`000?ooooooo`1goooo001hoooo00<0003oooooool01@00
01;oool010000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?ooooooo`1hoooo001h
oooo00D0003oooooooooool000005Oooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo07Soool007Woool00`000?ooooooo`0Goooo0P0000[oool300000_ooo`030000
oooooooo07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.85) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.19227 .30902 L
.19721 .30902 L
.20178 .30902 L
.20433 .30902 L
.20562 .30902 L
s
.20562 .30902 m
.20569 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.85) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00?oool01?l0VOooooooo`0000Ooool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Goool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo01Goool001Koool00`000?oo
ooooo`0Uoooo00<0003oooooool00oooo`03o`2Ioooooooo023oool00`000?ooooooo`0Uoooo00<0
003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0Voooo00<0003oooooool05Ooo
o`00A?ooo`03o`2Ioooooooo04Soool00`000?ooooooo`2>oooo0014oooo00?o09Woooooool0B?oo
o`80002?oooo0014oooo00?o09Woooooool0B?ooo`030000oooooooo08koool004Coool00ol0VOoo
ooooo`18oooo00<0003oooooool0S_ooo`00A?ooo`03o`2Ioooooooo04Soool00`000?ooooooo`2>
oooo0014oooo00?o09Woooooool0B?ooo`80002?oooo0014oooo00?o09Woooooool0B?ooo`030000
oooooooo08koool004Coool00ol0VOooooooo`18oooo00<0003oooooool0S_ooo`00A?ooo`03o`2I
oooooooo04Soool00`000?ooooooo`2>oooo0014oooo00?o09Woooooool0B?ooo`80002?oooo0014
oooo00?o09Woooooool0B?ooo`030000oooooooo08koool004Coool00ol0VOooooooo`18oooo00<0
003oooooool0S_ooo`00A?ooo`03o`2Ioooooooo04Soool00`000?ooooooo`2>oooo0014oooo00?o
09Woooooool0B?ooo`80002?oooo0014oooo00?o09Woooooool0B?ooo`030000oooooooo08koool0
04Coool00ol0VOooooooo`0_oooo0P0000Coool200000oooo`@00003oooo0P0000Goool00`000?oo
ooooo`2>oooo0014oooo00?o09Woooooool0;_ooo`040000oooooooo00002?ooo`030000oooooooo
00?oool010000?ooooooo`0000Coool00`000?ooooooo`2>oooo0014oooo00?o09Woooooool0;_oo
o`040000oooooooo00002Oooo`030000oooooooo00Goool00`000?ooooooo`02oooo0`0008koool0
04Coool00ol0VOooooooo`0^oooo00@0003oooooool0000:oooo00<0003oooooool00_ooo`800005
oooo00<0003oooooool0S_ooo`00A?ooo`03o`2Ioooooooo02koool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00A?ooo`03o`2I
oooooooo02ooool200002_ooo`800004oooo0`0000Coool00`000?ooooooo`2>oooo0014oooo00?o
09Woooooool0B?ooo`80002?oooo0014oooo00?o09Woooooool0B?ooo`030000oooooooo08koool0
04Coool00ol0VOooooooo`18oooo00<0003oooooool0S_ooo`00A?ooo`03o`2Ioooooooo04Soool0
0`000?ooooooo`2>oooo0014oooo00?o09Woooooool0B?ooo`80002?oooo0014oooo00?o09Wooooo
ool0B?ooo`030000oooooooo08koool004Coool00ol0VOooooooo`18oooo00<0003oooooool0S_oo
o`00A?ooo`03o`2Ioooooooo04Soool00`000?ooooooo`2>oooo0014oooo00?o09Woooooool0B?oo
o`80002?oooo0014oooo00?o09Woooooool0B?ooo`030000oooooooo08koool004Coool00ol0VOoo
ooooo`18oooo00<0003oooooool0S_ooo`00A?ooo`03o`2Ioooooooo04Soool00`000?ooooooo`2>
oooo0014oooo00?o09Woooooool0B?ooo`80002?oooo0014oooo00?o09Woooooool0B?ooo`030000
oooooooo08koool004Coool00ol0VOooooooo`0eoooo0P0000Coool200001?ooo`800005oooo00<0
003oooooool0S_ooo`00A?ooo`03o`2Ioooooooo03Coool010000?ooooooo`0000Soool010000?oo
ooooo`0000Coool00`000?ooooooo`2>oooo0014oooo00?o09Woooooool0=?ooo`040000oooooooo
00002oooo`030000oooooooo00;oool30000S_ooo`00A?ooo`03o`2Ioooooooo03Coool010000?oo
ooooo`0000Woool200001Oooo`030000oooooooo08koool004Coool00ol0VOooooooo`0doooo00@0
003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool004Coool00ol0VOoo
ooooo`0eoooo0P0000[oool300001?ooo`030000oooooooo08koool004Coool00ol0VOooooooo`18
oooo0P0008ooool004Coool00ol0VOooooooo`18oooo00<0003oooooool0S_ooo`00A?ooo`03o`2I
oooooooo04Soool00`000?ooooooo`2>oooo0014oooo00?o09Woooooool0B?ooo`80002?oooo0014
oooo00?o09Woooooool0B?ooo`030000oooooooo08koool004Coool00ol0VOooooooo`18oooo00<0
003oooooool0S_ooo`00A?ooo`03o`2Ioooooooo04Soool00`000?ooooooo`2>oooo0014oooo00?o
09Woooooool0B?ooo`80002?oooo0014oooo00?o09Woooooool0B?ooo`030000oooooooo08koool0
04Coool00ol0VOooooooo`18oooo00<0003oooooool0S_ooo`00A?ooo`03o`2Ioooooooo04Soool0
0`000?ooooooo`2>oooo0014oooo00?o09Woooooool0B?ooo`80002?oooo0014oooo00?o09Wooooo
ool0B?ooo`030000oooooooo08koool004Coool00ol0VOooooooo`0_oooo0P0000Coool200001Ooo
o`030000oooooooo00;oool200001Oooo`030000oooooooo08koool004Coool00ol0VOooooooo`0^
oooo00@0003oooooool0000:oooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool0
0`000?ooooooo`2>oooo0014oooo00?o09Woooooool0;_ooo`040000oooooooo00002_ooo`030000
oooooooo00Coool00`000?ooooooo`02oooo0`0008koool004Coool00ol0VOooooooo`0^oooo00@0
003oooooool0000;oooo00@0003oooooooooool200001Oooo`030000oooooooo08koool004Coool0
0ol0VOooooooo`0^oooo00@0003oooooool00008oooo00@0003oooooool00003oooo00<0003ooooo
ool01?ooo`030000oooooooo08koool004Coool00ol0VOooooooo`0_oooo0P0000Woool400000ooo
o`<00004oooo00<0003oooooool0S_ooo`00A?ooo`03o`2Ioooooooo04Soool20000Soooo`00A?oo
o`03o`2Ioooooooo04Soool00`000?ooooooo`2>oooo0014oooo00?o09Woooooool0B?ooo`030000
oooooooo08koool004Coool00ol0VOooooooo`18oooo00<0003oooooool0S_ooo`00A?ooo`03o`2I
oooooooo04Soool20000Soooo`00A?ooo`03o`2Ioooooooo04Soool00`000?ooooooo`2>oooo0014
oooo00?o09Woooooool0B?ooo`030000oooooooo08koool004Coool00ol0VOooooooo`18oooo00<0
003oooooool0S_ooo`00A?ooo`03o`2Ioooooooo04Soool20000Soooo`00A?ooo`03o`2Ioooooooo
04Soool00`000?ooooooo`2>oooo0014oooo00?o09Woooooool0B?ooo`030000oooooooo08koool0
04Coool00ol0VOooooooo`18oooo00<0003oooooool0S_ooo`00A?ooo`03o`2Ioooooooo04Soool2
0000Soooo`00A?ooo`03o`2Ioooooooo04Soool00`000?ooooooo`2>oooo0014oooo00?o09Wooooo
ool0@?ooo`D00003oooo00<0003oooooool0S_ooo`00A?ooo`03o`2Ioooooooo04;oool00`000?oo
ooooo`03oooo00<0003oooooool0S_ooo`00A?ooo`03o`2Ioooooooo04;oool00`000?ooooooo`03
oooo0`0008koool008Woool00`000?ooooooo`2Doooo0029oooo00<0003oooooool0U?ooo`00R?oo
o`80002Foooo003ooooo8Oooo`00ooooob7oool007Koool00`000?ooooooo`0^oooo00<0003ooooo
ool0M_ooo`00MOooo`030000oooooooo00Soool00`000?ooooooo`0Uoooo00<0003oooooool0MOoo
o`00MOooo`030000oooooooo00;oool200001?ooo`030000oooooooo00goool200001?ooo`800004
oooo0P0000Coool200001?ooo`030000oooooooo07Goool007Goool01@000?ooooooooooo`000002
oooo00<0003oooooool00_ooo`030000oooooooo00Coool400000oooo`040000oooooooo00002?oo
o`040000oooooooo00000_ooo`040000oooooooo00000oooo`030000oooooooo07Goool007Coool0
0`000?ooooooo`02oooo00<0003oooooool04oooo`040000oooooooo00002?ooo`040000oooooooo
00001Oooo`030000oooooooo00;oool00`000?ooooooo`1doooo001eoooo00<0003oooooool01@00
01;oool010000?ooooooo`0000Woool200001?ooo`800004oooo00<0003oooooool0MOooo`00MOoo
o`050000oooooooooooo000001Goool010000?ooooooo`0000Soool010000?ooooooo`0000?oool0
0`000?ooooooo`03oooo00<0003oooooool0MOooo`00M_ooo`030000oooooooo01Ooool200002_oo
o`800004oooo0`0000;oool00`000?ooooooo`1foooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.20178 .30902 L
.20742 .30902 L
.21019 .30902 L
.2114 .30902 L
.21274 .30902 L
.21394 .30902 L
s
.21394 .30902 m
.21405 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00ol0V@000?ooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`0Eoooo000Foooo00<0003ooooo
ool09Oooo`030000oooooooo00Goool00ol0VOooooooo`0Noooo00<0003oooooool09Oooo`030000
oooooooo02Goool00`000?ooooooo`0Uoooo00<0003oooooool09_ooo`030000oooooooo01Goool0
04Koool00ol0VOooooooo`16oooo00<0003oooooool0S_ooo`00A_ooo`03o`2Ioooooooo04Koool2
0000Soooo`00A_ooo`03o`2Ioooooooo04Koool00`000?ooooooo`2>oooo0016oooo00?o09Wooooo
ool0A_ooo`030000oooooooo08koool004Koool00ol0VOooooooo`16oooo00<0003oooooool0S_oo
o`00A_ooo`03o`2Ioooooooo04Koool20000Soooo`00A_ooo`03o`2Ioooooooo04Koool00`000?oo
ooooo`2>oooo0016oooo00?o09Woooooool0A_ooo`030000oooooooo08koool004Koool00ol0VOoo
ooooo`16oooo00<0003oooooool0S_ooo`00A_ooo`03o`2Ioooooooo04Koool20000Soooo`00A_oo
o`03o`2Ioooooooo04Koool00`000?ooooooo`2>oooo0016oooo00?o09Woooooool0A_ooo`030000
oooooooo08koool004Koool00ol0VOooooooo`16oooo00<0003oooooool0S_ooo`00A_ooo`03o`2I
oooooooo04Koool20000Soooo`00A_ooo`03o`2Ioooooooo04Koool00`000?ooooooo`2>oooo0016
oooo00?o09Woooooool0;Oooo`800004oooo0P0000?oool400000oooo`800005oooo00<0003ooooo
ool0S_ooo`00A_ooo`03o`2Ioooooooo02coool010000?ooooooo`0000Soool00`000?ooooooo`03
oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00A_ooo`03o`2Ioooooooo02coool0
10000?ooooooo`0000Woool00`000?ooooooo`05oooo00<0003oooooool00_ooo`<0002>oooo0016
oooo00?o09Woooooool0;?ooo`040000oooooooo00002_ooo`030000oooooooo00;oool200001Ooo
o`030000oooooooo08koool004Koool00ol0VOooooooo`0/oooo00@0003oooooool00008oooo00@0
003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo08koool004Koool00ol0VOoo
ooooo`0]oooo0P0000[oool200001?ooo`<00004oooo00<0003oooooool0S_ooo`00A_ooo`03o`2I
oooooooo04Koool20000Soooo`00A_ooo`03o`2Ioooooooo04Koool00`000?ooooooo`2>oooo0016
oooo00?o09Woooooool0A_ooo`030000oooooooo08koool004Koool00ol0VOooooooo`16oooo00<0
003oooooool0S_ooo`00A_ooo`03o`2Ioooooooo04Koool20000Soooo`00A_ooo`03o`2Ioooooooo
04Koool00`000?ooooooo`2>oooo0016oooo00?o09Woooooool0A_ooo`030000oooooooo08koool0
04Koool00ol0VOooooooo`16oooo00<0003oooooool0S_ooo`00A_ooo`03o`2Ioooooooo04Koool2
0000Soooo`00A_ooo`03o`2Ioooooooo04Koool00`000?ooooooo`2>oooo0016oooo00?o09Wooooo
ool0A_ooo`030000oooooooo08koool004Koool00ol0VOooooooo`16oooo00<0003oooooool0S_oo
o`00A_ooo`03o`2Ioooooooo04Koool20000Soooo`00A_ooo`03o`2Ioooooooo04Koool00`000?oo
ooooo`2>oooo0016oooo00?o09Woooooool0<oooo`800004oooo0P0000Coool200001Oooo`030000
oooooooo08koool004Koool00ol0VOooooooo`0boooo00@0003oooooool00008oooo00@0003ooooo
ool00004oooo00<0003oooooool0S_ooo`00A_ooo`03o`2Ioooooooo03;oool010000?ooooooo`00
00_oool00`000?ooooooo`02oooo0`0008koool004Koool00ol0VOooooooo`0boooo00@0003ooooo
ool00009oooo0P0000Goool00`000?ooooooo`2>oooo0016oooo00?o09Woooooool0<_ooo`040000
oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo0016oooo00?o09Wooooo
ool0<oooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo0016oooo00?o09Woooooool0A_oo
o`80002?oooo0016oooo00?o09Woooooool0A_ooo`030000oooooooo08koool004Koool00ol0VOoo
ooooo`16oooo00<0003oooooool0S_ooo`00A_ooo`03o`2Ioooooooo04Koool20000Soooo`00A_oo
o`03o`2Ioooooooo04Koool00`000?ooooooo`2>oooo0016oooo00?o09Woooooool0A_ooo`030000
oooooooo08koool004Koool00ol0VOooooooo`16oooo00<0003oooooool0S_ooo`00A_ooo`03o`2I
oooooooo04Koool20000Soooo`00A_ooo`03o`2Ioooooooo04Koool00`000?ooooooo`2>oooo0016
oooo00?o09Woooooool0A_ooo`030000oooooooo08koool004Koool00ol0VOooooooo`16oooo00<0
003oooooool0S_ooo`00A_ooo`03o`2Ioooooooo04Koool20000Soooo`00A_ooo`03o`2Ioooooooo
04Koool00`000?ooooooo`2>oooo0016oooo00?o09Woooooool0;Oooo`800004oooo0P0000Goool0
0`000?ooooooo`02oooo0P0000Goool00`000?ooooooo`2>oooo0016oooo00?o09Woooooool0;?oo
o`040000oooooooo00002_ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0
003oooooool0S_ooo`00A_ooo`03o`2Ioooooooo02coool010000?ooooooo`0000[oool00`000?oo
ooooo`04oooo00<0003oooooool00_ooo`<0002>oooo0016oooo00?o09Woooooool0;?ooo`040000
oooooooo00002oooo`040000oooooooooooo0P0000Goool00`000?ooooooo`2>oooo0016oooo00?o
09Woooooool0;?ooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo
00Coool00`000?ooooooo`2>oooo0016oooo00?o09Woooooool0;Oooo`800009oooo100000?oool3
00001?ooo`030000oooooooo08koool004Koool00ol0VOooooooo`16oooo0P0008ooool004Koool0
0ol0VOooooooo`16oooo00<0003oooooool0S_ooo`00A_ooo`03o`2Ioooooooo04Koool00`000?oo
ooooo`2>oooo0016oooo00?o09Woooooool0A_ooo`030000oooooooo08koool004Koool00ol0VOoo
ooooo`16oooo0P0008ooool004Koool00ol0VOooooooo`16oooo00<0003oooooool0S_ooo`00A_oo
o`03o`2Ioooooooo04Koool00`000?ooooooo`2>oooo0016oooo00?o09Woooooool0A_ooo`030000
oooooooo08koool004Koool00ol0VOooooooo`16oooo0P0008ooool004Koool00ol0VOooooooo`16
oooo00<0003oooooool0S_ooo`00A_ooo`03o`2Ioooooooo04Koool00`000?ooooooo`2>oooo0016
oooo00?o09Woooooool0A_ooo`030000oooooooo08koool004Koool00ol0VOooooooo`16oooo0P00
08ooool004Koool00ol0VOooooooo`16oooo00<0003oooooool0S_ooo`00A_ooo`03o`2Ioooooooo
03koool500000oooo`030000oooooooo08koool004Koool00ol0VOooooooo`10oooo00<0003ooooo
ool00oooo`030000oooooooo08koool004Koool00ol0VOooooooo`10oooo00<0003oooooool00ooo
o`<0002>oooo0029oooo00<0003oooooool0U?ooo`00ROooo`030000oooooooo09Coool008Soool2
0000U_ooo`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo
07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool0
07Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool200001?oo
o`800004oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003oooooool00008oooo00@0003ooooo
ool00003oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo00;oool00`000?ooooooo`0C
oooo00@0003oooooool00008oooo00@0003oooooool00004oooo00<0003oooooool0Moooo`00N?oo
o`030000oooooooo00D0000Boooo00@0003oooooool00009oooo0P0000Coool00`000?ooooooo`1h
oooo001hoooo00D0003oooooooooool000005Oooo`040000oooooooo00002?ooo`040000oooooooo
00000oooo`030000oooooooo07Soool007Woool00`000?ooooooo`0Goooo0P0000[oool200000ooo
o`030000oooooooo07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.75) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.20178 .30902 L
.20742 .30902 L
.21274 .30902 L
.21753 .30902 L
.21884 .30902 L
.22022 .30902 L
.22141 .30902 L
s
.22141 .30902 m
.22154 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.75) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Koool00`000?l0VOooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`0Eoooo000Foooo00<0003ooooo
ool09Oooo`030000oooooooo00Ooool00ol0VOooooooo`0Loooo00<0003oooooool09Oooo`030000
oooooooo02Goool00`000?ooooooo`0Uoooo00<0003oooooool09_ooo`030000oooooooo01Goool0
04Soool00ol0VOooooooo`14oooo00<0003oooooool0S_ooo`00B?ooo`03o`2Ioooooooo04Coool2
0000Soooo`00B?ooo`03o`2Ioooooooo04Coool00`000?ooooooo`2>oooo0018oooo00?o09Wooooo
ool0A?ooo`030000oooooooo08koool004Soool00ol0VOooooooo`14oooo00<0003oooooool0S_oo
o`00B?ooo`03o`2Ioooooooo04Coool20000Soooo`00B?ooo`03o`2Ioooooooo04Coool00`000?oo
ooooo`2>oooo0018oooo00?o09Woooooool0A?ooo`030000oooooooo08koool004Soool00ol0VOoo
ooooo`14oooo00<0003oooooool0S_ooo`00B?ooo`03o`2Ioooooooo04Coool20000Soooo`00B?oo
o`03o`2Ioooooooo04Coool00`000?ooooooo`2>oooo0018oooo00?o09Woooooool0A?ooo`030000
oooooooo08koool004Soool00ol0VOooooooo`14oooo00<0003oooooool0S_ooo`00B?ooo`03o`2I
oooooooo04Coool20000Soooo`00B?ooo`03o`2Ioooooooo04Coool00`000?ooooooo`2>oooo0018
oooo00?o09Woooooool0:oooo`800004oooo0P0000?oool400000oooo`800005oooo00<0003ooooo
ool0S_ooo`00B?ooo`03o`2Ioooooooo02[oool010000?ooooooo`0000Soool00`000?ooooooo`03
oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00B?ooo`03o`2Ioooooooo02[oool0
10000?ooooooo`0000Woool00`000?ooooooo`05oooo00<0003oooooool00_ooo`<0002>oooo0018
oooo00?o09Woooooool0:_ooo`040000oooooooo00002_ooo`030000oooooooo00;oool200001Ooo
o`030000oooooooo08koool004Soool00ol0VOooooooo`0Zoooo00@0003oooooool00008oooo00@0
003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo08koool004Soool00ol0VOoo
ooooo`0[oooo0P0000[oool200001?ooo`<00004oooo00<0003oooooool0S_ooo`00B?ooo`03o`2I
oooooooo04Coool20000Soooo`00B?ooo`03o`2Ioooooooo04Coool00`000?ooooooo`2>oooo0018
oooo00?o09Woooooool0A?ooo`030000oooooooo08koool004Soool00ol0VOooooooo`14oooo00<0
003oooooool0S_ooo`00B?ooo`03o`2Ioooooooo04Coool20000Soooo`00B?ooo`03o`2Ioooooooo
04Coool00`000?ooooooo`2>oooo0018oooo00?o09Woooooool0A?ooo`030000oooooooo08koool0
04Soool00ol0VOooooooo`14oooo00<0003oooooool0S_ooo`00B?ooo`03o`2Ioooooooo04Coool2
0000Soooo`00B?ooo`03o`2Ioooooooo04Coool00`000?ooooooo`2>oooo0018oooo00?o09Wooooo
ool0A?ooo`030000oooooooo08koool004Soool00ol0VOooooooo`14oooo00<0003oooooool0S_oo
o`00B?ooo`03o`2Ioooooooo04Coool20000Soooo`00B?ooo`03o`2Ioooooooo04Coool00`000?oo
ooooo`2>oooo0018oooo00?o09Woooooool0<Oooo`800004oooo0P0000Coool200001Oooo`030000
oooooooo08koool004Soool00ol0VOooooooo`0`oooo00@0003oooooool00008oooo00@0003ooooo
ool00004oooo00<0003oooooool0S_ooo`00B?ooo`03o`2Ioooooooo033oool010000?ooooooo`00
00_oool00`000?ooooooo`02oooo0`0008koool004Soool00ol0VOooooooo`0`oooo00@0003ooooo
ool00009oooo0P0000Goool00`000?ooooooo`2>oooo0018oooo00?o09Woooooool0<?ooo`040000
oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo0018oooo00?o09Wooooo
ool0<Oooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo0018oooo00?o09Woooooool0A?oo
o`80002?oooo0018oooo00?o09Woooooool0A?ooo`030000oooooooo08koool004Soool00ol0VOoo
ooooo`14oooo00<0003oooooool0S_ooo`00B?ooo`03o`2Ioooooooo04Coool20000Soooo`00B?oo
o`03o`2Ioooooooo04Coool00`000?ooooooo`2>oooo0018oooo00?o09Woooooool0A?ooo`030000
oooooooo08koool004Soool00ol0VOooooooo`14oooo00<0003oooooool0S_ooo`00B?ooo`03o`2I
oooooooo04Coool20000Soooo`00B?ooo`03o`2Ioooooooo04Coool00`000?ooooooo`2>oooo0018
oooo00?o09Woooooool0A?ooo`030000oooooooo08koool004Soool00ol0VOooooooo`14oooo00<0
003oooooool0S_ooo`00B?ooo`03o`2Ioooooooo04Coool20000Soooo`00B?ooo`03o`2Ioooooooo
04Coool00`000?ooooooo`2>oooo0018oooo00?o09Woooooool0:oooo`800004oooo0P0000Goool0
0`000?ooooooo`02oooo0P0000Goool00`000?ooooooo`2>oooo0018oooo00?o09Woooooool0:_oo
o`040000oooooooo00002_ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0
003oooooool0S_ooo`00B?ooo`03o`2Ioooooooo02[oool010000?ooooooo`0000[oool00`000?oo
ooooo`04oooo00<0003oooooool00_ooo`<0002>oooo0018oooo00?o09Woooooool0:_ooo`040000
oooooooo00002oooo`040000oooooooooooo0P0000Goool00`000?ooooooo`2>oooo0018oooo00?o
09Woooooool0:_ooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo
00Coool00`000?ooooooo`2>oooo0018oooo00?o09Woooooool0:oooo`800009oooo100000?oool3
00001?ooo`030000oooooooo08koool004Soool00ol0VOooooooo`14oooo0P0008ooool004Soool0
0ol0VOooooooo`14oooo00<0003oooooool0S_ooo`00B?ooo`03o`2Ioooooooo04Coool00`000?oo
ooooo`2>oooo0018oooo00?o09Woooooool0A?ooo`030000oooooooo08koool004Soool00ol0VOoo
ooooo`14oooo0P0008ooool004Soool00ol0VOooooooo`14oooo00<0003oooooool0S_ooo`00B?oo
o`03o`2Ioooooooo04Coool00`000?ooooooo`2>oooo0018oooo00?o09Woooooool0A?ooo`030000
oooooooo08koool004Soool00ol0VOooooooo`14oooo0P0008ooool004Soool00ol0VOooooooo`14
oooo00<0003oooooool0S_ooo`00B?ooo`03o`2Ioooooooo04Coool00`000?ooooooo`2>oooo0018
oooo00?o09Woooooool0A?ooo`030000oooooooo08koool004Soool00ol0VOooooooo`14oooo0P00
08ooool004Soool00ol0VOooooooo`14oooo00<0003oooooool0S_ooo`00B?ooo`03o`2Ioooooooo
03coool500000oooo`030000oooooooo08koool004Soool00ol0VOooooooo`0noooo00<0003ooooo
ool00oooo`030000oooooooo08koool004Soool00ol0VOooooooo`0noooo00<0003oooooool00ooo
o`<0002>oooo0029oooo00<0003oooooool0U?ooo`00ROooo`030000oooooooo09Coool008Soool2
0000U_ooo`00ooooob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000oooooooo
07Koool007Goool00`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool0
07Goool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool200001Ooo
o`030000oooooooo00;oool200001?ooo`030000oooooooo07Goool007Goool01@000?oooooooooo
o`000002oooo00<0003oooooool00_ooo`030000oooooooo00Coool400000oooo`040000oooooooo
00002_ooo`050000oooooooooooo000000;oool01@000?ooooooooooo`00001goooo001doooo00<0
003oooooool00_ooo`030000oooooooo01?oool010000?ooooooo`0000[oool00`000?ooooooo`04
oooo00<0003oooooool00_ooo`030000oooooooo07Coool007Goool00`000?ooooooo`0500004_oo
o`040000oooooooo00002oooo`040000oooooooooooo0P0000Coool00`000?ooooooo`1eoooo001e
oooo00D0003oooooooooool000005Oooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00?oool00`000?ooooooo`1eoooo001foooo00<0003oooooool05oooo`800009
oooo100000?oool300000_ooo`030000oooooooo07Koool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.7) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.20342 .30902 L
.21345 .30902 L
.22272 .30902 L
.22738 .30902 L
.22852 .30902 L
.22974 .30902 L
s
.22974 .30902 m
.22981 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.7) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Koool010000?ooooooool0V@Coool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Goool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo01Goool001Koool00`000?oo
ooooo`0Uoooo00<0003oooooool02Oooo`03o`2Ioooooooo01[oool00`000?ooooooo`0Uoooo00<0
003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0Voooo00<0003oooooool05Ooo
o`00B_ooo`03o`2Ioooooooo04;oool00`000?ooooooo`2>oooo001:oooo00?o09Woooooool0@_oo
o`80002?oooo001:oooo00?o09Woooooool0@_ooo`030000oooooooo08koool004[oool00ol0VOoo
ooooo`12oooo00<0003oooooool0S_ooo`00B_ooo`03o`2Ioooooooo04;oool00`000?ooooooo`2>
oooo001:oooo00?o09Woooooool0@_ooo`80002?oooo001:oooo00?o09Woooooool0@_ooo`030000
oooooooo08koool004[oool00ol0VOooooooo`12oooo00<0003oooooool0S_ooo`00B_ooo`03o`2I
oooooooo04;oool00`000?ooooooo`2>oooo001:oooo00?o09Woooooool0@_ooo`80002?oooo001:
oooo00?o09Woooooool0@_ooo`030000oooooooo08koool004[oool00ol0VOooooooo`12oooo00<0
003oooooool0S_ooo`00B_ooo`03o`2Ioooooooo04;oool00`000?ooooooo`2>oooo001:oooo00?o
09Woooooool0@_ooo`80002?oooo001:oooo00?o09Woooooool0@_ooo`030000oooooooo08koool0
04[oool00ol0VOooooooo`0Yoooo0P0000Coool200000oooo`@00003oooo0P0000Goool00`000?oo
ooooo`2>oooo001:oooo00?o09Woooooool0:?ooo`040000oooooooo00002?ooo`030000oooooooo
00?oool010000?ooooooo`0000Coool00`000?ooooooo`2>oooo001:oooo00?o09Woooooool0:?oo
o`040000oooooooo00002Oooo`030000oooooooo00Goool00`000?ooooooo`02oooo0`0008koool0
04[oool00ol0VOooooooo`0Xoooo00@0003oooooool0000:oooo00<0003oooooool00_ooo`800005
oooo00<0003oooooool0S_ooo`00B_ooo`03o`2Ioooooooo02Soool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00B_ooo`03o`2I
oooooooo02Woool200002_ooo`800004oooo0`0000Coool00`000?ooooooo`2>oooo001:oooo00?o
09Woooooool0@_ooo`80002?oooo001:oooo00?o09Woooooool0@_ooo`030000oooooooo08koool0
04[oool00ol0VOooooooo`12oooo00<0003oooooool0S_ooo`00B_ooo`03o`2Ioooooooo04;oool0
0`000?ooooooo`2>oooo001:oooo00?o09Woooooool0@_ooo`80002?oooo001:oooo00?o09Wooooo
ool0@_ooo`030000oooooooo08koool004[oool00ol0VOooooooo`12oooo00<0003oooooool0S_oo
o`00B_ooo`03o`2Ioooooooo04;oool00`000?ooooooo`2>oooo001:oooo00?o09Woooooool0@_oo
o`80002?oooo001:oooo00?o09Woooooool0@_ooo`030000oooooooo08koool004[oool00ol0VOoo
ooooo`12oooo00<0003oooooool0S_ooo`00B_ooo`03o`2Ioooooooo04;oool00`000?ooooooo`2>
oooo001:oooo00?o09Woooooool0@_ooo`80002?oooo001:oooo00?o09Woooooool0@_ooo`030000
oooooooo08koool004[oool00ol0VOooooooo`0_oooo0P0000Coool200001?ooo`800005oooo00<0
003oooooool0S_ooo`00B_ooo`03o`2Ioooooooo02koool010000?ooooooo`0000Soool010000?oo
ooooo`0000Coool00`000?ooooooo`2>oooo001:oooo00?o09Woooooool0;_ooo`040000oooooooo
00002oooo`030000oooooooo00;oool30000S_ooo`00B_ooo`03o`2Ioooooooo02koool010000?oo
ooooo`0000Woool200001Oooo`030000oooooooo08koool004[oool00ol0VOooooooo`0^oooo00@0
003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool004[oool00ol0VOoo
ooooo`0_oooo0P0000[oool300001?ooo`030000oooooooo08koool004[oool00ol0VOooooooo`12
oooo0P0008ooool004[oool00ol0VOooooooo`12oooo00<0003oooooool0S_ooo`00B_ooo`03o`2I
oooooooo04;oool00`000?ooooooo`2>oooo001:oooo00?o09Woooooool0@_ooo`80002?oooo001:
oooo00?o09Woooooool0@_ooo`030000oooooooo08koool004[oool00ol0VOooooooo`12oooo00<0
003oooooool0S_ooo`00B_ooo`03o`2Ioooooooo04;oool00`000?ooooooo`2>oooo001:oooo00?o
09Woooooool0@_ooo`80002?oooo001:oooo00?o09Woooooool0@_ooo`030000oooooooo08koool0
04[oool00ol0VOooooooo`12oooo00<0003oooooool0S_ooo`00B_ooo`03o`2Ioooooooo04;oool0
0`000?ooooooo`2>oooo001:oooo00?o09Woooooool0@_ooo`80002?oooo001:oooo00?o09Wooooo
ool0@_ooo`030000oooooooo08koool004[oool00ol0VOooooooo`0Yoooo0P0000Coool200001Ooo
o`030000oooooooo00;oool200001Oooo`030000oooooooo08koool004[oool00ol0VOooooooo`0X
oooo00@0003oooooool0000:oooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool0
0`000?ooooooo`2>oooo001:oooo00?o09Woooooool0:?ooo`040000oooooooo00002_ooo`030000
oooooooo00Coool00`000?ooooooo`02oooo0`0008koool004[oool00ol0VOooooooo`0Xoooo00@0
003oooooool0000;oooo00@0003oooooooooool200001Oooo`030000oooooooo08koool004[oool0
0ol0VOooooooo`0Xoooo00@0003oooooool00008oooo00@0003oooooool00003oooo00<0003ooooo
ool01?ooo`030000oooooooo08koool004[oool00ol0VOooooooo`0Yoooo0P0000Woool400000ooo
o`<00004oooo00<0003oooooool0S_ooo`00B_ooo`03o`2Ioooooooo04;oool20000Soooo`00B_oo
o`03o`2Ioooooooo04;oool00`000?ooooooo`2>oooo001:oooo00?o09Woooooool0@_ooo`030000
oooooooo08koool004[oool00ol0VOooooooo`12oooo00<0003oooooool0S_ooo`00B_ooo`03o`2I
oooooooo04;oool20000Soooo`00B_ooo`03o`2Ioooooooo04;oool00`000?ooooooo`2>oooo001:
oooo00?o09Woooooool0@_ooo`030000oooooooo08koool004[oool00ol0VOooooooo`12oooo00<0
003oooooool0S_ooo`00B_ooo`03o`2Ioooooooo04;oool20000Soooo`00B_ooo`03o`2Ioooooooo
04;oool00`000?ooooooo`2>oooo001:oooo00?o09Woooooool0@_ooo`030000oooooooo08koool0
04[oool00ol0VOooooooo`12oooo00<0003oooooool0S_ooo`00B_ooo`03o`2Ioooooooo04;oool2
0000Soooo`00B_ooo`03o`2Ioooooooo04;oool00`000?ooooooo`2>oooo001:oooo00?o09Wooooo
ool0>_ooo`D00003oooo00<0003oooooool0S_ooo`00B_ooo`03o`2Ioooooooo03coool00`000?oo
ooooo`03oooo00<0003oooooool0S_ooo`00B_ooo`03o`2Ioooooooo03coool00`000?ooooooo`03
oooo0`0008koool008Woool00`000?ooooooo`2Doooo0029oooo00<0003oooooool0U?ooo`00R?oo
o`80002Foooo003ooooo8Oooo`00ooooob7oool007Woool00`000?ooooooo`0Xoooo00<0003ooooo
ool0NOooo`00N?ooo`030000oooooooo00Soool00`000?ooooooo`0Ooooo00<0003oooooool0N?oo
o`00N?ooo`030000oooooooo00;oool200001?ooo`030000oooooooo00goool200001?ooo`800005
oooo00<0003oooooool00_ooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`000002
oooo00<0003oooooool00_ooo`030000oooooooo00Coool400000oooo`040000oooooooo00002_oo
o`030000oooooooo00;oool00`000?ooooooo`1hoooo001goooo00<0003oooooool00_ooo`030000
oooooooo01?oool010000?ooooooo`0000[oool00`000?ooooooo`03oooo00<0003oooooool0Mooo
o`00N?ooo`030000oooooooo00D0000Boooo00@0003oooooool0000;oooo00D0003oooooooooool0
0000N_ooo`00N?ooo`050000oooooooooooo000001Goool010000?ooooooo`0000Soool010000?oo
ooooo`0000?oool00`000?ooooooo`1hoooo001ioooo00<0003oooooool05oooo`800009oooo1000
00;oool00`000?ooooooo`1ioooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.65) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.20342 .30902 L
.22272 .30902 L
.23233 .30902 L
.23496 .30902 L
.2364 .30902 L
.23711 .30902 L
.23775 .30902 L
s
.23775 .30902 m
.23787 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.65) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Koool00`000?ooooooo`02oooo00Co09Woooooool00007oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Goool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo01Goool001Koool00`000?oo
ooooo`0Uoooo00<0003oooooool02oooo`03o`2Ioooooooo01Soool00`000?ooooooo`0Uoooo00<0
003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0Voooo00<0003oooooool05Ooo
o`00C?ooo`03o`2Ioooooooo043oool00`000?ooooooo`2>oooo001<oooo00?o09Woooooool0@?oo
o`80002?oooo001<oooo00?o09Woooooool0@?ooo`030000oooooooo08koool004coool00ol0VOoo
ooooo`10oooo00<0003oooooool0S_ooo`00C?ooo`03o`2Ioooooooo043oool00`000?ooooooo`2>
oooo001<oooo00?o09Woooooool0@?ooo`80002?oooo001<oooo00?o09Woooooool0@?ooo`030000
oooooooo08koool004coool00ol0VOooooooo`10oooo00<0003oooooool0S_ooo`00C?ooo`03o`2I
oooooooo043oool00`000?ooooooo`2>oooo001<oooo00?o09Woooooool0@?ooo`80002?oooo001<
oooo00?o09Woooooool0@?ooo`030000oooooooo08koool004coool00ol0VOooooooo`10oooo00<0
003oooooool0S_ooo`00C?ooo`03o`2Ioooooooo043oool00`000?ooooooo`2>oooo001<oooo00?o
09Woooooool0@?ooo`80002?oooo001<oooo00?o09Woooooool0@?ooo`030000oooooooo08koool0
04coool00ol0VOooooooo`0Woooo0P0000Coool200000oooo`@00003oooo0P0000Goool00`000?oo
ooooo`2>oooo001<oooo00?o09Woooooool09_ooo`040000oooooooo00002?ooo`030000oooooooo
00?oool010000?ooooooo`0000Coool00`000?ooooooo`2>oooo001<oooo00?o09Woooooool09_oo
o`040000oooooooo00002Oooo`030000oooooooo00Goool00`000?ooooooo`02oooo0`0008koool0
04coool00ol0VOooooooo`0Voooo00@0003oooooool0000:oooo00<0003oooooool00_ooo`800005
oooo00<0003oooooool0S_ooo`00C?ooo`03o`2Ioooooooo02Koool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00C?ooo`03o`2I
oooooooo02Ooool200002_ooo`800004oooo0`0000Coool00`000?ooooooo`2>oooo001<oooo00?o
09Woooooool0@?ooo`80002?oooo001<oooo00?o09Woooooool0@?ooo`030000oooooooo08koool0
04coool00ol0VOooooooo`10oooo00<0003oooooool0S_ooo`00C?ooo`03o`2Ioooooooo043oool0
0`000?ooooooo`2>oooo001<oooo00?o09Woooooool0@?ooo`80002?oooo001<oooo00?o09Wooooo
ool0@?ooo`030000oooooooo08koool004coool00ol0VOooooooo`10oooo00<0003oooooool0S_oo
o`00C?ooo`03o`2Ioooooooo043oool00`000?ooooooo`2>oooo001<oooo00?o09Woooooool0@?oo
o`80002?oooo001<oooo00?o09Woooooool0@?ooo`030000oooooooo08koool004coool00ol0VOoo
ooooo`10oooo00<0003oooooool0S_ooo`00C?ooo`03o`2Ioooooooo043oool00`000?ooooooo`2>
oooo001<oooo00?o09Woooooool0@?ooo`80002?oooo001<oooo00?o09Woooooool0@?ooo`030000
oooooooo08koool004coool00ol0VOooooooo`0]oooo0P0000Coool200001?ooo`800005oooo00<0
003oooooool0S_ooo`00C?ooo`03o`2Ioooooooo02coool010000?ooooooo`0000Soool010000?oo
ooooo`0000Coool00`000?ooooooo`2>oooo001=oooo00?o09Woooooool0:oooo`040000oooooooo
00002oooo`030000oooooooo00;oool30000S_ooo`00COooo`03o`2Ioooooooo02_oool010000?oo
ooooo`0000Woool200001Oooo`030000oooooooo08koool004goool00ol0VOooooooo`0[oooo00@0
003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool004goool00ol0VOoo
ooooo`0/oooo0P0000[oool300001?ooo`030000oooooooo08koool004goool00ol0VOooooooo`0o
oooo0P0008ooool004goool00ol0VOooooooo`0ooooo00<0003oooooool0S_ooo`00COooo`03o`2I
oooooooo03ooool00`000?ooooooo`2>oooo001=oooo00?o09Woooooool0?oooo`80002?oooo001=
oooo00?o09Woooooool0?oooo`030000oooooooo08koool004goool00ol0VOooooooo`0ooooo00<0
003oooooool0S_ooo`00COooo`03o`2Ioooooooo03ooool00`000?ooooooo`2>oooo001=oooo00?o
09Woooooool0?oooo`80002?oooo001=oooo00?o09Woooooool0?oooo`030000oooooooo08koool0
04goool00ol0VOooooooo`0ooooo00<0003oooooool0S_ooo`00COooo`03o`2Ioooooooo03ooool0
0`000?ooooooo`2>oooo001=oooo00?o09Woooooool0?oooo`80002?oooo001=oooo00?o09Wooooo
ool0?oooo`030000oooooooo08koool004goool00ol0VOooooooo`0Voooo0P0000Coool200001Ooo
o`030000oooooooo00;oool200001Oooo`030000oooooooo08koool004goool00ol0VOooooooo`0U
oooo00@0003oooooool0000:oooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool0
0`000?ooooooo`2>oooo001=oooo00?o09Woooooool09Oooo`040000oooooooo00002_ooo`030000
oooooooo00Coool00`000?ooooooo`02oooo0`0008koool004goool00ol0VOooooooo`0Uoooo00@0
003oooooool0000;oooo00@0003oooooooooool200001Oooo`030000oooooooo08koool004goool0
0ol0VOooooooo`0Uoooo00@0003oooooool00008oooo00@0003oooooool00003oooo00<0003ooooo
ool01?ooo`030000oooooooo08koool004goool00ol0VOooooooo`0Voooo0P0000Woool400000ooo
o`<00004oooo00<0003oooooool0S_ooo`00COooo`03o`2Ioooooooo03ooool20000Soooo`00COoo
o`03o`2Ioooooooo03ooool00`000?ooooooo`2>oooo001=oooo00?o09Woooooool0?oooo`030000
oooooooo08koool004goool00ol0VOooooooo`0ooooo00<0003oooooool0S_ooo`00COooo`03o`2I
oooooooo03ooool20000Soooo`00COooo`03o`2Ioooooooo03ooool00`000?ooooooo`2>oooo001=
oooo00?o09Woooooool0?oooo`030000oooooooo08koool004goool00ol0VOooooooo`0ooooo00<0
003oooooool0S_ooo`00COooo`03o`2Ioooooooo03ooool20000Soooo`00COooo`03o`2Ioooooooo
03ooool00`000?ooooooo`2>oooo001=oooo00?o09Woooooool0?oooo`030000oooooooo08koool0
04goool00ol0VOooooooo`0ooooo00<0003oooooool0S_ooo`00COooo`03o`2Ioooooooo03ooool2
0000Soooo`00COooo`03o`2Ioooooooo03ooool00`000?ooooooo`2>oooo001=oooo00?o09Wooooo
ool0=oooo`D00003oooo00<0003oooooool0S_ooo`00COooo`03o`2Ioooooooo03Woool00`000?oo
ooooo`03oooo00<0003oooooool0S_ooo`00COooo`03o`2Ioooooooo03Woool00`000?ooooooo`03
oooo0`0008koool008Woool00`000?ooooooo`2Doooo0029oooo00<0003oooooool0U?ooo`00R?oo
o`80002Foooo003ooooo8Oooo`00ooooob7oool007Koool00`000?ooooooo`0^oooo00<0003ooooo
ool0M_ooo`00MOooo`030000oooooooo00Soool00`000?ooooooo`0Uoooo00<0003oooooool0MOoo
o`00MOooo`030000oooooooo00;oool200001?ooo`030000oooooooo00goool200001?ooo`800003
oooo0`0000Coool200001?ooo`030000oooooooo07Goool007Goool01@000?ooooooooooo`000002
oooo00<0003oooooool00_ooo`030000oooooooo00Coool400000oooo`040000oooooooo00002?oo
o`040000oooooooo00000_ooo`040000oooooooo00000oooo`030000oooooooo07Goool007Coool0
0`000?ooooooo`02oooo00<0003oooooool04oooo`040000oooooooo00002?ooo`040000oooooooo
00001Oooo`030000oooooooo00;oool00`000?ooooooo`1doooo001eoooo00<0003oooooool01@00
01;oool010000?ooooooo`0000Soool300001?ooo`800004oooo00<0003oooooool0MOooo`00MOoo
o`050000oooooooooooo000001Goool010000?ooooooo`0000Woool00`000?ooooooo`03oooo00<0
003oooooool00oooo`030000oooooooo07Goool007Koool00`000?ooooooo`0Goooo0P0000[oool3
00000oooo`<00002oooo00<0003oooooool0M_ooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.20342 .30902 L
.22272 .30902 L
.23233 .30902 L
.23739 .30902 L
.24016 .30902 L
.24276 .30902 L
.24392 .30902 L
.24502 .30902 L
s
.24502 .30902 m
.24515 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Koool00`000?ooooooo`04oooo00?o09T0003oool01_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`0Eoooo000Foooo00<0003ooooo
ool09Oooo`030000oooooooo00goool00ol0VOooooooo`0Foooo00<0003oooooool09Oooo`030000
oooooooo02Goool00`000?ooooooo`0Uoooo00<0003oooooool09_ooo`030000oooooooo01Goool0
04koool00ol0VOooooooo`0noooo00<0003oooooool0S_ooo`00C_ooo`03o`2Ioooooooo03koool2
0000Soooo`00C_ooo`03o`2Ioooooooo03koool00`000?ooooooo`2>oooo001>oooo00?o09Wooooo
ool0?_ooo`030000oooooooo08koool004koool00ol0VOooooooo`0noooo00<0003oooooool0S_oo
o`00C_ooo`03o`2Ioooooooo03koool20000Soooo`00C_ooo`03o`2Ioooooooo03koool00`000?oo
ooooo`2>oooo001>oooo00?o09Woooooool0?_ooo`030000oooooooo08koool004koool00ol0VOoo
ooooo`0noooo00<0003oooooool0S_ooo`00C_ooo`03o`2Ioooooooo03koool20000Soooo`00C_oo
o`03o`2Ioooooooo03koool00`000?ooooooo`2>oooo001>oooo00?o09Woooooool0?_ooo`030000
oooooooo08koool004koool00ol0VOooooooo`0noooo00<0003oooooool0S_ooo`00C_ooo`03o`2I
oooooooo03koool20000Soooo`00C_ooo`03o`2Ioooooooo03koool00`000?ooooooo`2>oooo001>
oooo00?o09Woooooool09Oooo`800004oooo0P0000?oool400000oooo`800005oooo00<0003ooooo
ool0S_ooo`00C_ooo`03o`2Ioooooooo02Coool010000?ooooooo`0000Soool00`000?ooooooo`03
oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00C_ooo`03o`2Ioooooooo02Coool0
10000?ooooooo`0000Woool00`000?ooooooo`05oooo00<0003oooooool00_ooo`<0002>oooo001>
oooo00?o09Woooooool09?ooo`040000oooooooo00002_ooo`030000oooooooo00;oool200001Ooo
o`030000oooooooo08koool004koool00ol0VOooooooo`0Toooo00@0003oooooool00008oooo00@0
003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo08koool004koool00ol0VOoo
ooooo`0Uoooo0P0000[oool200001?ooo`<00004oooo00<0003oooooool0S_ooo`00C_ooo`03o`2I
oooooooo03koool20000Soooo`00C_ooo`03o`2Ioooooooo03koool00`000?ooooooo`2>oooo001>
oooo00?o09Woooooool0?_ooo`030000oooooooo08koool004koool00ol0VOooooooo`0noooo00<0
003oooooool0S_ooo`00C_ooo`03o`2Ioooooooo03koool20000Soooo`00C_ooo`03o`2Ioooooooo
03koool00`000?ooooooo`2>oooo001>oooo00?o09Woooooool0?_ooo`030000oooooooo08koool0
04koool00ol0VOooooooo`0noooo00<0003oooooool0S_ooo`00C_ooo`03o`2Ioooooooo03koool2
0000Soooo`00C_ooo`03o`2Ioooooooo03koool00`000?ooooooo`2>oooo001>oooo00?o09Wooooo
ool0?_ooo`030000oooooooo08koool004koool00ol0VOooooooo`0noooo00<0003oooooool0S_oo
o`00C_ooo`03o`2Ioooooooo03koool20000Soooo`00C_ooo`03o`2Ioooooooo03koool00`000?oo
ooooo`2>oooo001>oooo00?o09Woooooool0:oooo`800004oooo0P0000Coool200001Oooo`030000
oooooooo08koool004koool00ol0VOooooooo`0Zoooo00@0003oooooool00008oooo00@0003ooooo
ool00004oooo00<0003oooooool0S_ooo`00C_ooo`03o`2Ioooooooo02[oool010000?ooooooo`00
00_oool00`000?ooooooo`02oooo0`0008koool004koool00ol0VOooooooo`0Zoooo00@0003ooooo
ool00009oooo0P0000Goool00`000?ooooooo`2>oooo001>oooo00?o09Woooooool0:_ooo`040000
oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001>oooo00?o09Wooooo
ool0:oooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo001>oooo00?o09Woooooool0?_oo
o`80002?oooo001>oooo00?o09Woooooool0?_ooo`030000oooooooo08koool004koool00ol0VOoo
ooooo`0noooo00<0003oooooool0S_ooo`00C_ooo`03o`2Ioooooooo03koool20000Soooo`00C_oo
o`03o`2Ioooooooo03koool00`000?ooooooo`2>oooo001>oooo00?o09Woooooool0?_ooo`030000
oooooooo08koool004koool00ol0VOooooooo`0noooo00<0003oooooool0S_ooo`00C_ooo`03o`2I
oooooooo03koool20000Soooo`00C_ooo`03o`2Ioooooooo03koool00`000?ooooooo`2>oooo001>
oooo00?o09Woooooool0?_ooo`030000oooooooo08koool004koool00ol0VOooooooo`0noooo00<0
003oooooool0S_ooo`00C_ooo`03o`2Ioooooooo03koool20000Soooo`00C_ooo`03o`2Ioooooooo
03koool00`000?ooooooo`2>oooo001>oooo00?o09Woooooool09Oooo`800004oooo0P0000Goool0
0`000?ooooooo`02oooo0P0000Goool00`000?ooooooo`2>oooo001>oooo00?o09Woooooool09?oo
o`040000oooooooo00002_ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0
003oooooool0S_ooo`00C_ooo`03o`2Ioooooooo02Coool010000?ooooooo`0000[oool00`000?oo
ooooo`04oooo00<0003oooooool00_ooo`<0002>oooo001>oooo00?o09Woooooool09?ooo`040000
oooooooo00002oooo`040000oooooooooooo0P0000Goool00`000?ooooooo`2>oooo001>oooo00?o
09Woooooool09?ooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo
00Coool00`000?ooooooo`2>oooo001>oooo00?o09Woooooool09Oooo`800009oooo100000?oool3
00001?ooo`030000oooooooo08koool004koool00ol0VOooooooo`0noooo0P0008ooool004koool0
0ol0VOooooooo`0noooo00<0003oooooool0S_ooo`00C_ooo`03o`2Ioooooooo03koool00`000?oo
ooooo`2>oooo001>oooo00?o09Woooooool0?_ooo`030000oooooooo08koool004koool00ol0VOoo
ooooo`0noooo0P0008ooool004koool00ol0VOooooooo`0noooo00<0003oooooool0S_ooo`00C_oo
o`03o`2Ioooooooo03koool00`000?ooooooo`2>oooo001>oooo00?o09Woooooool0?_ooo`030000
oooooooo08koool004koool00ol0VOooooooo`0noooo0P0008ooool004koool00ol0VOooooooo`0n
oooo00<0003oooooool0S_ooo`00C_ooo`03o`2Ioooooooo03koool00`000?ooooooo`2>oooo001>
oooo00?o09Woooooool0?_ooo`030000oooooooo08koool004koool00ol0VOooooooo`0noooo0P00
08ooool004koool00ol0VOooooooo`0noooo00<0003oooooool0S_ooo`00C_ooo`03o`2Ioooooooo
03Koool500000oooo`030000oooooooo08koool004koool00ol0VOooooooo`0hoooo00<0003ooooo
ool00oooo`030000oooooooo08koool004koool00ol0VOooooooo`0hoooo00<0003oooooool00ooo
o`<0002>oooo0029oooo00<0003oooooool0U?ooo`00ROooo`030000oooooooo09Coool008Soool2
0000U_ooo`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo
07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool0
07Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool200000ooo
o`<00004oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003oooooool00008oooo00@0003ooooo
ool00003oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo00;oool00`000?ooooooo`0C
oooo00@0003oooooool00008oooo00@0003oooooool00004oooo00<0003oooooool0Moooo`00N?oo
o`030000oooooooo00D0000Boooo00@0003oooooool00008oooo0`0000Coool00`000?ooooooo`1h
oooo001hoooo00D0003oooooooooool000005Oooo`040000oooooooo00002Oooo`030000oooooooo
00?oool00`000?ooooooo`1hoooo001ioooo00<0003oooooool05oooo`80000:oooo0`0000;oool0
0`000?ooooooo`1ioooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.55) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.20342 .30902 L
.22272 .30902 L
.23233 .30902 L
.24276 .30902 L
.24754 .30902 L
.25016 .30902 L
.25144 .30902 L
.25261 .30902 L
.25368 .30902 L
s
.25368 .30902 m
.25378 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.55) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Koool00`000?ooooooo`05oooo00<0003ooooo09T01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`0Eoooo000Foooo00<0003ooooo
ool09Oooo`030000oooooooo013oool00ol0VOooooooo`0Coooo00<0003oooooool09Oooo`030000
oooooooo02Goool00`000?ooooooo`0Uoooo00<0003oooooool09_ooo`030000oooooooo01Goool0
057oool00ol0VOooooooo`0koooo00<0003oooooool0S_ooo`00DOooo`03o`2Ioooooooo03_oool2
0000Soooo`00DOooo`03o`2Ioooooooo03_oool00`000?ooooooo`2>oooo001Aoooo00?o09Wooooo
ool0>oooo`030000oooooooo08koool0057oool00ol0VOooooooo`0koooo00<0003oooooool0S_oo
o`00DOooo`03o`2Ioooooooo03_oool20000Soooo`00DOooo`03o`2Ioooooooo03_oool00`000?oo
ooooo`2>oooo001Aoooo00?o09Woooooool0>oooo`030000oooooooo08koool0057oool00ol0VOoo
ooooo`0koooo00<0003oooooool0S_ooo`00DOooo`03o`2Ioooooooo03_oool20000Soooo`00DOoo
o`03o`2Ioooooooo03_oool00`000?ooooooo`2>oooo001Aoooo00?o09Woooooool0>oooo`030000
oooooooo08koool0057oool00ol0VOooooooo`0koooo00<0003oooooool0S_ooo`00DOooo`03o`2I
oooooooo03_oool20000Soooo`00DOooo`03o`2Ioooooooo03_oool00`000?ooooooo`2>oooo001A
oooo00?o09Woooooool08_ooo`800004oooo0P0000?oool400000oooo`800005oooo00<0003ooooo
ool0S_ooo`00DOooo`03o`2Ioooooooo027oool010000?ooooooo`0000Soool00`000?ooooooo`03
oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00DOooo`03o`2Ioooooooo027oool0
10000?ooooooo`0000Woool00`000?ooooooo`05oooo00<0003oooooool00_ooo`<0002>oooo001A
oooo00?o09Woooooool08Oooo`040000oooooooo00002_ooo`030000oooooooo00;oool200001Ooo
o`030000oooooooo08koool0057oool00ol0VOooooooo`0Qoooo00@0003oooooool00008oooo00@0
003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo08koool0057oool00ol0VOoo
ooooo`0Roooo0P0000[oool200001?ooo`<00004oooo00<0003oooooool0S_ooo`00DOooo`03o`2I
oooooooo03_oool20000Soooo`00DOooo`03o`2Ioooooooo03_oool00`000?ooooooo`2>oooo001A
oooo00?o09Woooooool0>oooo`030000oooooooo08koool0057oool00ol0VOooooooo`0koooo00<0
003oooooool0S_ooo`00DOooo`03o`2Ioooooooo03_oool20000Soooo`00DOooo`03o`2Ioooooooo
03_oool00`000?ooooooo`2>oooo001Aoooo00?o09Woooooool0>oooo`030000oooooooo08koool0
057oool00ol0VOooooooo`0koooo00<0003oooooool0S_ooo`00DOooo`03o`2Ioooooooo03_oool2
0000Soooo`00DOooo`03o`2Ioooooooo03_oool00`000?ooooooo`2>oooo001Aoooo00?o09Wooooo
ool0>oooo`030000oooooooo08koool0057oool00ol0VOooooooo`0koooo00<0003oooooool0S_oo
o`00DOooo`03o`2Ioooooooo03_oool20000Soooo`00DOooo`03o`2Ioooooooo03_oool00`000?oo
ooooo`2>oooo001Aoooo00?o09Woooooool0:?ooo`800004oooo0P0000Coool200001Oooo`030000
oooooooo08koool0057oool00ol0VOooooooo`0Woooo00@0003oooooool00008oooo00@0003ooooo
ool00004oooo00<0003oooooool0S_ooo`00DOooo`03o`2Ioooooooo02Ooool010000?ooooooo`00
00_oool00`000?ooooooo`02oooo0`0008koool0057oool00ol0VOooooooo`0Woooo00@0003ooooo
ool00009oooo0P0000Goool00`000?ooooooo`2>oooo001Aoooo00?o09Woooooool09oooo`040000
oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001Aoooo00?o09Wooooo
ool0:?ooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo001Aoooo00?o09Woooooool0>ooo
o`80002?oooo001Aoooo00?o09Woooooool0>oooo`030000oooooooo08koool0057oool00ol0VOoo
ooooo`0koooo00<0003oooooool0S_ooo`00DOooo`03o`2Ioooooooo03_oool20000Soooo`00DOoo
o`03o`2Ioooooooo03_oool00`000?ooooooo`2>oooo001Aoooo00?o09Woooooool0>oooo`030000
oooooooo08koool0057oool00ol0VOooooooo`0koooo00<0003oooooool0S_ooo`00DOooo`03o`2I
oooooooo03_oool20000Soooo`00DOooo`03o`2Ioooooooo03_oool00`000?ooooooo`2>oooo001A
oooo00?o09Woooooool0>oooo`030000oooooooo08koool0057oool00ol0VOooooooo`0koooo00<0
003oooooool0S_ooo`00DOooo`03o`2Ioooooooo03_oool20000Soooo`00DOooo`03o`2Ioooooooo
03_oool00`000?ooooooo`2>oooo001Aoooo00?o09Woooooool08_ooo`800004oooo0P0000Goool0
0`000?ooooooo`02oooo0P0000Goool00`000?ooooooo`2>oooo001Aoooo00?o09Woooooool08Ooo
o`040000oooooooo00002_ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0
003oooooool0S_ooo`00DOooo`03o`2Ioooooooo027oool010000?ooooooo`0000[oool00`000?oo
ooooo`04oooo00<0003oooooool00_ooo`<0002>oooo001Aoooo00?o09Woooooool08Oooo`040000
oooooooo00002oooo`040000oooooooooooo0P0000Goool00`000?ooooooo`2>oooo001Aoooo00?o
09Woooooool08Oooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo
00Coool00`000?ooooooo`2>oooo001Aoooo00?o09Woooooool08_ooo`800009oooo100000?oool3
00001?ooo`030000oooooooo08koool0057oool00ol0VOooooooo`0koooo0P0008ooool0057oool0
0ol0VOooooooo`0koooo00<0003oooooool0S_ooo`00DOooo`03o`2Ioooooooo03_oool00`000?oo
ooooo`2>oooo001Aoooo00?o09Woooooool0>oooo`030000oooooooo08koool0057oool00ol0VOoo
ooooo`0koooo0P0008ooool0057oool00ol0VOooooooo`0koooo00<0003oooooool0S_ooo`00DOoo
o`03o`2Ioooooooo03_oool00`000?ooooooo`2>oooo001Aoooo00?o09Woooooool0>oooo`030000
oooooooo08koool0057oool00ol0VOooooooo`0koooo0P0008ooool0057oool00ol0VOooooooo`0k
oooo00<0003oooooool0S_ooo`00DOooo`03o`2Ioooooooo03_oool00`000?ooooooo`2>oooo001A
oooo00?o09Woooooool0>oooo`030000oooooooo08koool0057oool00ol0VOooooooo`0koooo0P00
08ooool0057oool00ol0VOooooooo`0koooo00<0003oooooool0S_ooo`00DOooo`03o`2Ioooooooo
03?oool500000oooo`030000oooooooo08koool0057oool00ol0VOooooooo`0eoooo00<0003ooooo
ool00oooo`030000oooooooo08koool0057oool00ol0VOooooooo`0eoooo00<0003oooooool00ooo
o`<0002>oooo0029oooo00<0003oooooool0U?ooo`00ROooo`030000oooooooo09Coool008Soool2
0000U_ooo`00ooooob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000oooooooo
07Koool007Goool00`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool0
07Goool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool200001?oo
o`800004oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000000_oo
o`030000oooooooo00;oool00`000?ooooooo`04oooo100000?oool010000?ooooooo`0000Soool0
10000?ooooooo`0000;oool010000?ooooooo`0000?oool00`000?ooooooo`1eoooo001doooo00<0
003oooooool00_ooo`030000oooooooo01?oool010000?ooooooo`0000_oool00`000?ooooooo`03
oooo00<0003oooooool00_ooo`030000oooooooo07Coool007Goool00`000?ooooooo`0500004_oo
o`040000oooooooo00002Oooo`800004oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0
003oooooooooool000005Oooo`040000oooooooo00002Oooo`030000oooooooo00?oool00`000?oo
ooooo`03oooo00<0003oooooool0MOooo`00M_ooo`030000oooooooo01Ooool200002_ooo`<00003
oooo0`0000;oool00`000?ooooooo`1foooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.24141 .30902 L
.25127 .30902 L
.25666 .30902 L
.2593 .30902 L
.26045 .30902 L
.26171 .30902 L
s
.26171 .30902 m
.26184 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Koool00`000?ooooooo`05oooo00D0003ooooooooooooo09T00oooo`030000oooooooo00Goool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool0
0`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`0Eoooo000Foooo00<0
003oooooool09Oooo`030000oooooooo01;oool00ol0VOooooooo`0Aoooo00<0003oooooool09Ooo
o`030000oooooooo02Goool00`000?ooooooo`0Uoooo00<0003oooooool09_ooo`030000oooooooo
01Goool005?oool00ol0VOooooooo`0ioooo00<0003oooooool0S_ooo`00Doooo`03o`2Ioooooooo
03Woool20000Soooo`00Doooo`03o`2Ioooooooo03Woool00`000?ooooooo`2>oooo001Coooo00?o
09Woooooool0>Oooo`030000oooooooo08koool005?oool00ol0VOooooooo`0ioooo00<0003ooooo
ool0S_ooo`00Doooo`03o`2Ioooooooo03Woool20000Soooo`00Doooo`03o`2Ioooooooo03Woool0
0`000?ooooooo`2>oooo001Coooo00?o09Woooooool0>Oooo`030000oooooooo08koool005?oool0
0ol0VOooooooo`0ioooo00<0003oooooool0S_ooo`00Doooo`03o`2Ioooooooo03Woool20000Sooo
o`00Doooo`03o`2Ioooooooo03Woool00`000?ooooooo`2>oooo001Coooo00?o09Woooooool0>Ooo
o`030000oooooooo08koool005?oool00ol0VOooooooo`0ioooo00<0003oooooool0S_ooo`00Dooo
o`03o`2Ioooooooo03Woool20000Soooo`00Doooo`03o`2Ioooooooo03Woool00`000?ooooooo`2>
oooo001Coooo00?o09Woooooool08?ooo`800004oooo0P0000?oool400000oooo`800005oooo00<0
003oooooool0S_ooo`00Doooo`03o`2Ioooooooo01ooool010000?ooooooo`0000Soool00`000?oo
ooooo`03oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00Doooo`03o`2Ioooooooo
01ooool010000?ooooooo`0000Woool00`000?ooooooo`05oooo00<0003oooooool00_ooo`<0002>
oooo001Coooo00?o09Woooooool07oooo`040000oooooooo00002_ooo`030000oooooooo00;oool2
00001Oooo`030000oooooooo08koool005?oool00ol0VOooooooo`0Ooooo00@0003oooooool00008
oooo00@0003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo08koool005?oool0
0ol0VOooooooo`0Poooo0P0000[oool200001?ooo`<00004oooo00<0003oooooool0S_ooo`00Dooo
o`03o`2Ioooooooo03Woool20000Soooo`00Doooo`03o`2Ioooooooo03Woool00`000?ooooooo`2>
oooo001Coooo00?o09Woooooool0>Oooo`030000oooooooo08koool005?oool00ol0VOooooooo`0i
oooo00<0003oooooool0S_ooo`00Doooo`03o`2Ioooooooo03Woool20000Soooo`00Doooo`03o`2I
oooooooo03Woool00`000?ooooooo`2>oooo001Coooo00?o09Woooooool0>Oooo`030000oooooooo
08koool005?oool00ol0VOooooooo`0ioooo00<0003oooooool0S_ooo`00Doooo`03o`2Ioooooooo
03Woool20000Soooo`00Doooo`03o`2Ioooooooo03Woool00`000?ooooooo`2>oooo001Coooo00?o
09Woooooool0>Oooo`030000oooooooo08koool005?oool00ol0VOooooooo`0ioooo00<0003ooooo
ool0S_ooo`00Doooo`03o`2Ioooooooo03Woool20000Soooo`00Doooo`03o`2Ioooooooo03Woool0
0`000?ooooooo`2>oooo001Coooo00?o09Woooooool09_ooo`800004oooo0P0000Coool200001Ooo
o`030000oooooooo08koool005?oool00ol0VOooooooo`0Uoooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00Doooo`03o`2Ioooooooo02Goool010000?oo
ooooo`0000_oool00`000?ooooooo`02oooo0`0008koool005?oool00ol0VOooooooo`0Uoooo00@0
003oooooool00009oooo0P0000Goool00`000?ooooooo`2>oooo001Coooo00?o09Woooooool09Ooo
o`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001Coooo00?o
09Woooooool09_ooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo001Coooo00?o09Wooooo
ool0>Oooo`80002?oooo001Coooo00?o09Woooooool0>Oooo`030000oooooooo08koool005?oool0
0ol0VOooooooo`0ioooo00<0003oooooool0S_ooo`00Doooo`03o`2Ioooooooo03Woool20000Sooo
o`00Doooo`03o`2Ioooooooo03Woool00`000?ooooooo`2>oooo001Coooo00?o09Woooooool0>Ooo
o`030000oooooooo08koool005?oool00ol0VOooooooo`0ioooo00<0003oooooool0S_ooo`00Dooo
o`03o`2Ioooooooo03Woool20000Soooo`00Doooo`03o`2Ioooooooo03Woool00`000?ooooooo`2>
oooo001Coooo00?o09Woooooool0>Oooo`030000oooooooo08koool005?oool00ol0VOooooooo`0i
oooo00<0003oooooool0S_ooo`00Doooo`03o`2Ioooooooo03Woool20000Soooo`00Doooo`03o`2I
oooooooo03Woool00`000?ooooooo`2>oooo001Coooo00?o09Woooooool08?ooo`800004oooo0P00
00Goool00`000?ooooooo`02oooo0P0000Goool00`000?ooooooo`2>oooo001Coooo00?o09Wooooo
ool07oooo`040000oooooooo00002_ooo`050000oooooooooooo000000;oool00`000?ooooooo`02
oooo00<0003oooooool0S_ooo`00Doooo`03o`2Ioooooooo01ooool010000?ooooooo`0000[oool0
0`000?ooooooo`04oooo00<0003oooooool00_ooo`<0002>oooo001Coooo00?o09Woooooool07ooo
o`040000oooooooo00002oooo`040000oooooooooooo0P0000Goool00`000?ooooooo`2>oooo001C
oooo00?o09Woooooool07oooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000
oooooooo00Coool00`000?ooooooo`2>oooo001Coooo00?o09Woooooool08?ooo`800009oooo1000
00?oool300001?ooo`030000oooooooo08koool005?oool00ol0VOooooooo`0ioooo0P0008ooool0
05?oool00ol0VOooooooo`0ioooo00<0003oooooool0S_ooo`00Doooo`03o`2Ioooooooo03Woool0
0`000?ooooooo`2>oooo001Coooo00?o09Woooooool0>Oooo`030000oooooooo08koool005?oool0
0ol0VOooooooo`0ioooo0P0008ooool005?oool00ol0VOooooooo`0ioooo00<0003oooooool0S_oo
o`00Doooo`03o`2Ioooooooo03Woool00`000?ooooooo`2>oooo001Coooo00?o09Woooooool0>Ooo
o`030000oooooooo08koool005?oool00ol0VOooooooo`0ioooo0P0008ooool005?oool00ol0VOoo
ooooo`0ioooo00<0003oooooool0S_ooo`00Doooo`03o`2Ioooooooo03Woool00`000?ooooooo`2>
oooo001Coooo00?o09Woooooool0>Oooo`030000oooooooo08koool005?oool00ol0VOooooooo`0i
oooo0P0008ooool005?oool00ol0VOooooooo`0ioooo00<0003oooooool0S_ooo`00Doooo`03o`2I
oooooooo037oool500000oooo`030000oooooooo08koool005?oool00ol0VOooooooo`0coooo00<0
003oooooool00oooo`030000oooooooo08koool005?oool00ol0VOooooooo`0coooo00<0003ooooo
ool00oooo`<0002>oooo0029oooo00<0003oooooool0U?ooo`00ROooo`030000oooooooo09Coool0
08Soool20000U_ooo`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000
oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo
07Soool007Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool2
00001?ooo`800004oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool0
0`000?ooooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003oooooool00008oooo00@0
003oooooool00003oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo00;oool00`000?oo
ooooo`0Coooo00@0003oooooool0000;oooo00<0003oooooool00_ooo`030000oooooooo07Ooool0
07Soool00`000?ooooooo`0500004_ooo`040000oooooooo00002Oooo`800004oooo00<0003ooooo
ool0N?ooo`00N?ooo`050000oooooooooooo000001Goool010000?ooooooo`0000Woool00`000?oo
ooooo`03oooo00<0003oooooool0N?ooo`00NOooo`030000oooooooo01Ooool200002_ooo`<00002
oooo00<0003oooooool0NOooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.45) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.24141 .30902 L
.25127 .30902 L
.26171 .30902 L
.26425 .30902 L
.26698 .30902 L
.26778 .30902 L
.26855 .30902 L
.26923 .30902 L
s
.26923 .30902 m
.26931 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.45) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Koool00`000?ooooooo`05oooo00<0003oooooool00_ooo`04o`2Ioooooooo00001oooo`030000
oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Goool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo01Goool001Koool00`000?oo
ooooo`0Uoooo00<0003oooooool04oooo`03o`2Ioooooooo013oool00`000?ooooooo`0Uoooo00<0
003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0Voooo00<0003oooooool05Ooo
o`00E?ooo`03o`2Ioooooooo03Soool00`000?ooooooo`2>oooo001Doooo00?o09Woooooool0>?oo
o`80002?oooo001Doooo00?o09Woooooool0>?ooo`030000oooooooo08koool005Coool00ol0VOoo
ooooo`0hoooo00<0003oooooool0S_ooo`00E?ooo`03o`2Ioooooooo03Soool00`000?ooooooo`2>
oooo001Doooo00?o09Woooooool0>?ooo`80002?oooo001Doooo00?o09Woooooool0>?ooo`030000
oooooooo08koool005Coool00ol0VOooooooo`0hoooo00<0003oooooool0S_ooo`00E?ooo`03o`2I
oooooooo03Soool00`000?ooooooo`2>oooo001Doooo00?o09Woooooool0>?ooo`80002?oooo001D
oooo00?o09Woooooool0>?ooo`030000oooooooo08koool005Coool00ol0VOooooooo`0hoooo00<0
003oooooool0S_ooo`00E?ooo`03o`2Ioooooooo03Soool00`000?ooooooo`2>oooo001Doooo00?o
09Woooooool0>?ooo`80002?oooo001Doooo00?o09Woooooool0>?ooo`030000oooooooo08koool0
05Coool00ol0VOooooooo`0Ooooo0P0000Coool200000oooo`@00003oooo0P0000Goool00`000?oo
ooooo`2>oooo001Doooo00?o09Woooooool07_ooo`040000oooooooo00002?ooo`030000oooooooo
00?oool010000?ooooooo`0000Coool00`000?ooooooo`2>oooo001Doooo00?o09Woooooool07_oo
o`040000oooooooo00002Oooo`030000oooooooo00Goool00`000?ooooooo`02oooo0`0008koool0
05Coool00ol0VOooooooo`0Noooo00@0003oooooool0000:oooo00<0003oooooool00_ooo`800005
oooo00<0003oooooool0S_ooo`00E?ooo`03o`2Ioooooooo01koool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00E?ooo`03o`2I
oooooooo01ooool200002_ooo`800004oooo0`0000Coool00`000?ooooooo`2>oooo001Doooo00?o
09Woooooool0>?ooo`80002?oooo001Doooo00?o09Woooooool0>?ooo`030000oooooooo08koool0
05Coool00ol0VOooooooo`0hoooo00<0003oooooool0S_ooo`00E?ooo`03o`2Ioooooooo03Soool0
0`000?ooooooo`2>oooo001Doooo00?o09Woooooool0>?ooo`80002?oooo001Doooo00?o09Wooooo
ool0>?ooo`030000oooooooo08koool005Coool00ol0VOooooooo`0hoooo00<0003oooooool0S_oo
o`00E?ooo`03o`2Ioooooooo03Soool00`000?ooooooo`2>oooo001Doooo00?o09Woooooool0>?oo
o`80002?oooo001Doooo00?o09Woooooool0>?ooo`030000oooooooo08koool005Coool00ol0VOoo
ooooo`0hoooo00<0003oooooool0S_ooo`00E?ooo`03o`2Ioooooooo03Soool00`000?ooooooo`2>
oooo001Doooo00?o09Woooooool0>?ooo`80002?oooo001Doooo00?o09Woooooool0>?ooo`030000
oooooooo08koool005Coool00ol0VOooooooo`0Uoooo0P0000Coool200001?ooo`800005oooo00<0
003oooooool0S_ooo`00E?ooo`03o`2Ioooooooo02Coool010000?ooooooo`0000Soool010000?oo
ooooo`0000Coool00`000?ooooooo`2>oooo001Doooo00?o09Woooooool09?ooo`040000oooooooo
00002oooo`030000oooooooo00;oool30000S_ooo`00E?ooo`03o`2Ioooooooo02Coool010000?oo
ooooo`0000Woool200001Oooo`030000oooooooo08koool005Coool00ol0VOooooooo`0Toooo00@0
003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool005Coool00ol0VOoo
ooooo`0Uoooo0P0000[oool300001?ooo`030000oooooooo08koool005Coool00ol0VOooooooo`0h
oooo0P0008ooool005Coool00ol0VOooooooo`0hoooo00<0003oooooool0S_ooo`00E?ooo`03o`2I
oooooooo03Soool00`000?ooooooo`2>oooo001Doooo00?o09Woooooool0>?ooo`80002?oooo001D
oooo00?o09Woooooool0>?ooo`030000oooooooo08koool005Coool00ol0VOooooooo`0hoooo00<0
003oooooool0S_ooo`00E?ooo`03o`2Ioooooooo03Soool00`000?ooooooo`2>oooo001Doooo00?o
09Woooooool0>?ooo`80002?oooo001Doooo00?o09Woooooool0>?ooo`030000oooooooo08koool0
05Coool00ol0VOooooooo`0hoooo00<0003oooooool0S_ooo`00E?ooo`03o`2Ioooooooo03Soool0
0`000?ooooooo`2>oooo001Doooo00?o09Woooooool0>?ooo`80002?oooo001Doooo00?o09Wooooo
ool0>?ooo`030000oooooooo08koool005Coool00ol0VOooooooo`0Ooooo0P0000Coool200001Ooo
o`030000oooooooo00;oool200001Oooo`030000oooooooo08koool005Coool00ol0VOooooooo`0N
oooo00@0003oooooool0000:oooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool0
0`000?ooooooo`2>oooo001Doooo00?o09Woooooool07_ooo`040000oooooooo00002_ooo`030000
oooooooo00Coool00`000?ooooooo`02oooo0`0008koool005Coool00ol0VOooooooo`0Noooo00@0
003oooooool0000;oooo00@0003oooooooooool200001Oooo`030000oooooooo08koool005Coool0
0ol0VOooooooo`0Noooo00@0003oooooool00008oooo00@0003oooooool00003oooo00<0003ooooo
ool01?ooo`030000oooooooo08koool005Coool00ol0VOooooooo`0Ooooo0P0000Woool400000ooo
o`<00004oooo00<0003oooooool0S_ooo`00E?ooo`03o`2Ioooooooo03Soool20000Soooo`00E?oo
o`03o`2Ioooooooo03Soool00`000?ooooooo`2>oooo001Doooo00?o09Woooooool0>?ooo`030000
oooooooo08koool005Coool00ol0VOooooooo`0hoooo00<0003oooooool0S_ooo`00E?ooo`03o`2I
oooooooo03Soool20000Soooo`00E?ooo`03o`2Ioooooooo03Soool00`000?ooooooo`2>oooo001D
oooo00?o09Woooooool0>?ooo`030000oooooooo08koool005Coool00ol0VOooooooo`0hoooo00<0
003oooooool0S_ooo`00E?ooo`03o`2Ioooooooo03Soool20000Soooo`00E?ooo`03o`2Ioooooooo
03Soool00`000?ooooooo`2>oooo001Doooo00?o09Woooooool0>?ooo`030000oooooooo08koool0
05Coool00ol0VOooooooo`0hoooo00<0003oooooool0S_ooo`00E?ooo`03o`2Ioooooooo03Soool2
0000Soooo`00E?ooo`03o`2Ioooooooo03Soool00`000?ooooooo`2>oooo001Doooo00?o09Wooooo
ool0<?ooo`D00003oooo00<0003oooooool0S_ooo`00E?ooo`03o`2Ioooooooo03;oool00`000?oo
ooooo`03oooo00<0003oooooool0S_ooo`00E?ooo`03o`2Ioooooooo03;oool00`000?ooooooo`03
oooo0`0008koool008Woool00`000?ooooooo`2Doooo0029oooo00<0003oooooool0U?ooo`00R?oo
o`80002Foooo003ooooo8Oooo`00ooooob7oool007Koool00`000?ooooooo`0^oooo00<0003ooooo
ool0M_ooo`00MOooo`030000oooooooo00Soool00`000?ooooooo`0Uoooo00<0003oooooool0MOoo
o`00MOooo`030000oooooooo00;oool200001?ooo`030000oooooooo00goool200001?ooo`800005
oooo0`0000;oool200001?ooo`030000oooooooo07Goool007Goool01@000?ooooooooooo`000002
oooo00<0003oooooool00_ooo`030000oooooooo00Coool400000oooo`040000oooooooo00002ooo
o`040000oooooooo00000_ooo`050000oooooooooooo000007Ooool007Coool00`000?ooooooo`02
oooo00<0003oooooool04oooo`040000oooooooo00002?ooo`D00004oooo00<0003oooooool00_oo
o`030000oooooooo07Coool007Goool00`000?ooooooo`0500004_ooo`040000oooooooo00002?oo
o`040000oooooooo00000oooo`800004oooo00<0003oooooool0MOooo`00MOooo`050000oooooooo
oooo000001Goool010000?ooooooo`0000Woool00`000?ooo`000003oooo00<0003oooooool00ooo
o`030000oooooooo07Goool007Koool00`000?ooooooo`0Goooo0P0000_oool200000oooo`<00002
oooo00<0003oooooool0M_ooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.24141 .30902 L
.26171 .30902 L
.26709 .30902 L
.27279 .30902 L
.27513 .30902 L
.27643 .30902 L
.27765 .30902 L
s
.27765 .30902 m
.27772 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Koool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`0Eoooo000Foooo00<0003ooooo
ool09Oooo`030000oooooooo01Koool00ol0VOooooooo`0=oooo00<0003oooooool09Oooo`030000
oooooooo02Goool00`000?ooooooo`0Uoooo00<0003oooooool09_ooo`030000oooooooo01Goool0
05Ooool00ol0VOooooooo`0eoooo00<0003oooooool0S_ooo`00Eoooo`03o`2Ioooooooo03Goool2
0000Soooo`00Eoooo`03o`2Ioooooooo03Goool00`000?ooooooo`2>oooo001Goooo00?o09Wooooo
ool0=Oooo`030000oooooooo08koool005Ooool00ol0VOooooooo`0eoooo00<0003oooooool0S_oo
o`00Eoooo`03o`2Ioooooooo03Goool20000Soooo`00Eoooo`03o`2Ioooooooo03Goool00`000?oo
ooooo`2>oooo001Goooo00?o09Woooooool0=Oooo`030000oooooooo08koool005Ooool00ol0VOoo
ooooo`0eoooo00<0003oooooool0S_ooo`00Eoooo`03o`2Ioooooooo03Goool20000Soooo`00Eooo
o`03o`2Ioooooooo03Goool00`000?ooooooo`2>oooo001Goooo00?o09Woooooool0=Oooo`030000
oooooooo08koool005Ooool00ol0VOooooooo`0eoooo00<0003oooooool0S_ooo`00Eoooo`03o`2I
oooooooo03Goool20000Soooo`00Eoooo`03o`2Ioooooooo03Goool00`000?ooooooo`2>oooo001G
oooo00?o09Woooooool07?ooo`800004oooo0P0000?oool400000oooo`800005oooo00<0003ooooo
ool0S_ooo`00Eoooo`03o`2Ioooooooo01_oool010000?ooooooo`0000Soool00`000?ooooooo`03
oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00Eoooo`03o`2Ioooooooo01_oool0
10000?ooooooo`0000Woool00`000?ooooooo`05oooo00<0003oooooool00_ooo`<0002>oooo001G
oooo00?o09Woooooool06oooo`040000oooooooo00002_ooo`030000oooooooo00;oool200001Ooo
o`030000oooooooo08koool005Ooool00ol0VOooooooo`0Koooo00@0003oooooool00008oooo00@0
003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo08koool005Ooool00ol0VOoo
ooooo`0Loooo0P0000[oool200001?ooo`<00004oooo00<0003oooooool0S_ooo`00Eoooo`03o`2I
oooooooo03Goool20000Soooo`00Eoooo`03o`2Ioooooooo03Goool00`000?ooooooo`2>oooo001G
oooo00?o09Woooooool0=Oooo`030000oooooooo08koool005Ooool00ol0VOooooooo`0eoooo00<0
003oooooool0S_ooo`00Eoooo`03o`2Ioooooooo03Goool20000Soooo`00Eoooo`03o`2Ioooooooo
03Goool00`000?ooooooo`2>oooo001Goooo00?o09Woooooool0=Oooo`030000oooooooo08koool0
05Ooool00ol0VOooooooo`0eoooo00<0003oooooool0S_ooo`00Eoooo`03o`2Ioooooooo03Goool2
0000Soooo`00Eoooo`03o`2Ioooooooo03Goool00`000?ooooooo`2>oooo001Goooo00?o09Wooooo
ool0=Oooo`030000oooooooo08koool005Ooool00ol0VOooooooo`0eoooo00<0003oooooool0S_oo
o`00Eoooo`03o`2Ioooooooo03Goool20000Soooo`00Eoooo`03o`2Ioooooooo03Goool00`000?oo
ooooo`2>oooo001Goooo00?o09Woooooool08_ooo`800004oooo0P0000Coool200001Oooo`030000
oooooooo08koool005Ooool00ol0VOooooooo`0Qoooo00@0003oooooool00008oooo00@0003ooooo
ool00004oooo00<0003oooooool0S_ooo`00Eoooo`03o`2Ioooooooo027oool010000?ooooooo`00
00_oool00`000?ooooooo`02oooo0`0008koool005Ooool00ol0VOooooooo`0Qoooo00@0003ooooo
ool00009oooo0P0000Goool00`000?ooooooo`2>oooo001Goooo00?o09Woooooool08Oooo`040000
oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001Goooo00?o09Wooooo
ool08_ooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo001Goooo00?o09Woooooool0=Ooo
o`80002?oooo001Goooo00?o09Woooooool0=Oooo`030000oooooooo08koool005Ooool00ol0VOoo
ooooo`0eoooo00<0003oooooool0S_ooo`00Eoooo`03o`2Ioooooooo03Goool20000Soooo`00Eooo
o`03o`2Ioooooooo03Goool00`000?ooooooo`2>oooo001Goooo00?o09Woooooool0=Oooo`030000
oooooooo08koool005Ooool00ol0VOooooooo`0eoooo00<0003oooooool0S_ooo`00Eoooo`03o`2I
oooooooo03Goool20000Soooo`00Eoooo`03o`2Ioooooooo03Goool00`000?ooooooo`2>oooo001G
oooo00?o09Woooooool0=Oooo`030000oooooooo08koool005Ooool00ol0VOooooooo`0eoooo00<0
003oooooool0S_ooo`00Eoooo`03o`2Ioooooooo03Goool20000Soooo`00Eoooo`03o`2Ioooooooo
03Goool00`000?ooooooo`2>oooo001Goooo00?o09Woooooool07?ooo`800004oooo0P0000Goool0
0`000?ooooooo`02oooo0P0000Goool00`000?ooooooo`2>oooo001Goooo00?o09Woooooool06ooo
o`040000oooooooo00002_ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0
003oooooool0S_ooo`00Eoooo`03o`2Ioooooooo01_oool010000?ooooooo`0000[oool00`000?oo
ooooo`04oooo00<0003oooooool00_ooo`<0002>oooo001Goooo00?o09Woooooool06oooo`040000
oooooooo00002oooo`040000oooooooooooo0P0000Goool00`000?ooooooo`2>oooo001Goooo00?o
09Woooooool06oooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo
00Coool00`000?ooooooo`2>oooo001Goooo00?o09Woooooool07?ooo`800009oooo100000?oool3
00001?ooo`030000oooooooo08koool005Ooool00ol0VOooooooo`0eoooo0P0008ooool005Ooool0
0ol0VOooooooo`0eoooo00<0003oooooool0S_ooo`00Eoooo`03o`2Ioooooooo03Goool00`000?oo
ooooo`2>oooo001Goooo00?o09Woooooool0=Oooo`030000oooooooo08koool005Ooool00ol0VOoo
ooooo`0eoooo0P0008ooool005Ooool00ol0VOooooooo`0eoooo00<0003oooooool0S_ooo`00Eooo
o`03o`2Ioooooooo03Goool00`000?ooooooo`2>oooo001Goooo00?o09Woooooool0=Oooo`030000
oooooooo08koool005Ooool00ol0VOooooooo`0eoooo0P0008ooool005Ooool00ol0VOooooooo`0e
oooo00<0003oooooool0S_ooo`00Eoooo`03o`2Ioooooooo03Goool00`000?ooooooo`2>oooo001G
oooo00?o09Woooooool0=Oooo`030000oooooooo08koool005Ooool00ol0VOooooooo`0eoooo0P00
08ooool005Ooool00ol0VOooooooo`0eoooo00<0003oooooool0S_ooo`00Eoooo`03o`2Ioooooooo
02goool500000oooo`030000oooooooo08koool005Ooool00ol0VOooooooo`0_oooo00<0003ooooo
ool00oooo`030000oooooooo08koool005Ooool00ol0VOooooooo`0_oooo00<0003oooooool00ooo
o`<0002>oooo0029oooo00<0003oooooool0U?ooo`00ROooo`030000oooooooo09Coool008Soool2
0000U_ooo`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo
07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool0
07Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool200001Ooo
o`<00002oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003oooooool0000;oooo00D0003ooooo
ooooool00000N_ooo`00Moooo`030000oooooooo00;oool00`000?ooooooo`0Coooo00@0003ooooo
ool00008oooo1@0000?oool00`000?ooooooo`1goooo001hoooo00<0003oooooool01@0001;oool0
10000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?ooooooo`1hoooo001hoooo00D0
003oooooooooool000005Oooo`040000oooooooo00002Oooo`030000oooo000000?oool00`000?oo
ooooo`1hoooo001ioooo00<0003oooooool05oooo`80000;oooo0P0000;oool00`000?ooooooo`1i
oooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.35) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.27193 .30902 L
.27731 .30902 L
.28025 .30902 L
.28302 .30902 L
.28425 .30902 L
.28542 .30902 L
s
.28542 .30902 m
.28548 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.35) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Koool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000ooooo`2I00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`0Eoooo000Foooo00<0003ooooo
ool09Oooo`030000oooooooo01Soool00ol0VOooooooo`0;oooo00<0003oooooool09Oooo`030000
oooooooo02Goool00`000?ooooooo`0Uoooo00<0003oooooool09_ooo`030000oooooooo01Goool0
05Woool00ol0VOooooooo`0coooo00<0003oooooool0S_ooo`00FOooo`03o`2Ioooooooo03?oool2
0000Soooo`00FOooo`03o`2Ioooooooo03?oool00`000?ooooooo`2>oooo001Ioooo00?o09Wooooo
ool0<oooo`030000oooooooo08koool005Woool00ol0VOooooooo`0coooo00<0003oooooool0S_oo
o`00FOooo`03o`2Ioooooooo03?oool20000Soooo`00FOooo`03o`2Ioooooooo03?oool00`000?oo
ooooo`2>oooo001Ioooo00?o09Woooooool0<oooo`030000oooooooo08koool005Woool00ol0VOoo
ooooo`0coooo00<0003oooooool0S_ooo`00FOooo`03o`2Ioooooooo03?oool20000Soooo`00FOoo
o`03o`2Ioooooooo03?oool00`000?ooooooo`2>oooo001Ioooo00?o09Woooooool0<oooo`030000
oooooooo08koool005Woool00ol0VOooooooo`0coooo00<0003oooooool0S_ooo`00FOooo`03o`2I
oooooooo03?oool20000Soooo`00FOooo`03o`2Ioooooooo03?oool00`000?ooooooo`2>oooo001I
oooo00?o09Woooooool06_ooo`800004oooo0P0000?oool400000oooo`800005oooo00<0003ooooo
ool0S_ooo`00FOooo`03o`2Ioooooooo01Woool010000?ooooooo`0000Soool00`000?ooooooo`03
oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00FOooo`03o`2Ioooooooo01Woool0
10000?ooooooo`0000Woool00`000?ooooooo`05oooo00<0003oooooool00_ooo`<0002>oooo001I
oooo00?o09Woooooool06Oooo`040000oooooooo00002_ooo`030000oooooooo00;oool200001Ooo
o`030000oooooooo08koool005Woool00ol0VOooooooo`0Ioooo00@0003oooooool00008oooo00@0
003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo08koool005Woool00ol0VOoo
ooooo`0Joooo0P0000[oool200001?ooo`<00004oooo00<0003oooooool0S_ooo`00FOooo`03o`2I
oooooooo03?oool20000Soooo`00FOooo`03o`2Ioooooooo03?oool00`000?ooooooo`2>oooo001I
oooo00?o09Woooooool0<oooo`030000oooooooo08koool005Woool00ol0VOooooooo`0coooo00<0
003oooooool0S_ooo`00FOooo`03o`2Ioooooooo03?oool20000Soooo`00FOooo`03o`2Ioooooooo
03?oool00`000?ooooooo`2>oooo001Ioooo00?o09Woooooool0<oooo`030000oooooooo08koool0
05Woool00ol0VOooooooo`0coooo00<0003oooooool0S_ooo`00FOooo`03o`2Ioooooooo03?oool2
0000Soooo`00FOooo`03o`2Ioooooooo03?oool00`000?ooooooo`2>oooo001Ioooo00?o09Wooooo
ool0<oooo`030000oooooooo08koool005Woool00ol0VOooooooo`0coooo00<0003oooooool0S_oo
o`00FOooo`03o`2Ioooooooo03?oool20000Soooo`00FOooo`03o`2Ioooooooo03?oool00`000?oo
ooooo`2>oooo001Ioooo00?o09Woooooool08?ooo`800004oooo0P0000Coool200001Oooo`030000
oooooooo08koool005Woool00ol0VOooooooo`0Ooooo00@0003oooooool00008oooo00@0003ooooo
ool00004oooo00<0003oooooool0S_ooo`00FOooo`03o`2Ioooooooo01ooool010000?ooooooo`00
00_oool00`000?ooooooo`02oooo0`0008koool005Woool00ol0VOooooooo`0Ooooo00@0003ooooo
ool00009oooo0P0000Goool00`000?ooooooo`2>oooo001Ioooo00?o09Woooooool07oooo`040000
oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001Ioooo00?o09Wooooo
ool08?ooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo001Ioooo00?o09Woooooool0<ooo
o`80002?oooo001Ioooo00?o09Woooooool0<oooo`030000oooooooo08koool005Woool00ol0VOoo
ooooo`0coooo00<0003oooooool0S_ooo`00FOooo`03o`2Ioooooooo03?oool20000Soooo`00FOoo
o`03o`2Ioooooooo03?oool00`000?ooooooo`2>oooo001Ioooo00?o09Woooooool0<oooo`030000
oooooooo08koool005Woool00ol0VOooooooo`0coooo00<0003oooooool0S_ooo`00FOooo`03o`2I
oooooooo03?oool20000Soooo`00FOooo`03o`2Ioooooooo03?oool00`000?ooooooo`2>oooo001I
oooo00?o09Woooooool0<oooo`030000oooooooo08koool005Woool00ol0VOooooooo`0coooo00<0
003oooooool0S_ooo`00FOooo`03o`2Ioooooooo03?oool20000Soooo`00FOooo`03o`2Ioooooooo
03?oool00`000?ooooooo`2>oooo001Ioooo00?o09Woooooool06_ooo`800004oooo0P0000Goool0
0`000?ooooooo`02oooo0P0000Goool00`000?ooooooo`2>oooo001Ioooo00?o09Woooooool06Ooo
o`040000oooooooo00002_ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0
003oooooool0S_ooo`00FOooo`03o`2Ioooooooo01Woool010000?ooooooo`0000[oool00`000?oo
ooooo`04oooo00<0003oooooool00_ooo`<0002>oooo001Ioooo00?o09Woooooool06Oooo`040000
oooooooo00002oooo`040000oooooooooooo0P0000Goool00`000?ooooooo`2>oooo001Ioooo00?o
09Woooooool06Oooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo
00Coool00`000?ooooooo`2>oooo001Ioooo00?o09Woooooool06_ooo`800009oooo100000?oool3
00001?ooo`030000oooooooo08koool005Woool00ol0VOooooooo`0coooo0P0008ooool005Woool0
0ol0VOooooooo`0coooo00<0003oooooool0S_ooo`00FOooo`03o`2Ioooooooo03?oool00`000?oo
ooooo`2>oooo001Ioooo00?o09Woooooool0<oooo`030000oooooooo08koool005Woool00ol0VOoo
ooooo`0coooo0P0008ooool005Woool00ol0VOooooooo`0coooo00<0003oooooool0S_ooo`00FOoo
o`03o`2Ioooooooo03?oool00`000?ooooooo`2>oooo001Ioooo00?o09Woooooool0<oooo`030000
oooooooo08koool005Woool00ol0VOooooooo`0coooo0P0008ooool005Woool00ol0VOooooooo`0c
oooo00<0003oooooool0S_ooo`00FOooo`03o`2Ioooooooo03?oool00`000?ooooooo`2>oooo001I
oooo00?o09Woooooool0<oooo`030000oooooooo08koool005Woool00ol0VOooooooo`0coooo0P00
08ooool005Woool00ol0VOooooooo`0coooo00<0003oooooool0S_ooo`00FOooo`03o`2Ioooooooo
02_oool500000oooo`030000oooooooo08koool005Woool00ol0VOooooooo`0]oooo00<0003ooooo
ool00oooo`030000oooooooo08koool005Woool00ol0VOooooooo`0]oooo00<0003oooooool00ooo
o`<0002>oooo0029oooo00<0003oooooool0U?ooo`00ROooo`030000oooooooo09Coool008Soool2
0000U_ooo`00ooooob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000oooooooo
07Koool007Goool00`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool0
07Goool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool200001?oo
o`800004oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000000_oo
o`030000oooooooo00;oool00`000?ooooooo`04oooo100000?oool010000?ooooooo`0000Soool0
10000?ooooooo`0000;oool010000?ooooooo`0000?oool00`000?ooooooo`1eoooo001doooo00<0
003oooooool00_ooo`030000oooooooo01?oool010000?ooooooo`0000[oool00`000?ooooooo`04
oooo00<0003oooooool00_ooo`030000oooooooo07Coool007Goool00`000?ooooooo`0500004_oo
o`040000oooooooo00002oooo`040000oooooooooooo0P0000Coool00`000?ooooooo`1eoooo001e
oooo00D0003oooooooooool000005Oooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00?oool00`000?ooooooo`1eoooo001foooo00<0003oooooool05oooo`80000:
oooo0P0000Coool300000_ooo`030000oooooooo07Koool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.27193 .30902 L
.28302 .30902 L
.2881 .30902 L
.29088 .30902 L
.29224 .30902 L
.29349 .30902 L
s
.29349 .30902 m
.2936 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Koool00`000?ooooooo`05oooo00<0003oooooool01Oooo`050000ooooooooooooo`2I00?oool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool0
0`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`0Eoooo000Foooo00<0
003oooooool09Oooo`030000oooooooo01[oool00ol0VOooooooo`09oooo00<0003oooooool09Ooo
o`030000oooooooo02Goool00`000?ooooooo`0Uoooo00<0003oooooool09_ooo`030000oooooooo
01Goool005_oool00ol0VOooooooo`0aoooo00<0003oooooool0S_ooo`00Foooo`03o`2Ioooooooo
037oool20000Soooo`00Foooo`03o`2Ioooooooo037oool00`000?ooooooo`2>oooo001Koooo00?o
09Woooooool0<Oooo`030000oooooooo08koool005_oool00ol0VOooooooo`0aoooo00<0003ooooo
ool0S_ooo`00Foooo`03o`2Ioooooooo037oool20000Soooo`00Foooo`03o`2Ioooooooo037oool0
0`000?ooooooo`2>oooo001Koooo00?o09Woooooool0<Oooo`030000oooooooo08koool005_oool0
0ol0VOooooooo`0aoooo00<0003oooooool0S_ooo`00Foooo`03o`2Ioooooooo037oool20000Sooo
o`00Foooo`03o`2Ioooooooo037oool00`000?ooooooo`2>oooo001Koooo00?o09Woooooool0<Ooo
o`030000oooooooo08koool005_oool00ol0VOooooooo`0aoooo00<0003oooooool0S_ooo`00Fooo
o`03o`2Ioooooooo037oool20000Soooo`00Foooo`03o`2Ioooooooo037oool00`000?ooooooo`2>
oooo001Koooo00?o09Woooooool06?ooo`800004oooo0P0000?oool400000oooo`800005oooo00<0
003oooooool0S_ooo`00Foooo`03o`2Ioooooooo01Ooool010000?ooooooo`0000Soool00`000?oo
ooooo`03oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00Foooo`03o`2Ioooooooo
01Ooool010000?ooooooo`0000Woool00`000?ooooooo`05oooo00<0003oooooool00_ooo`<0002>
oooo001Koooo00?o09Woooooool05oooo`040000oooooooo00002_ooo`030000oooooooo00;oool2
00001Oooo`030000oooooooo08koool005_oool00ol0VOooooooo`0Goooo00@0003oooooool00008
oooo00@0003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo08koool005_oool0
0ol0VOooooooo`0Hoooo0P0000[oool200001?ooo`<00004oooo00<0003oooooool0S_ooo`00Fooo
o`03o`2Ioooooooo037oool20000Soooo`00Foooo`03o`2Ioooooooo037oool00`000?ooooooo`2>
oooo001Koooo00?o09Woooooool0<Oooo`030000oooooooo08koool005_oool00ol0VOooooooo`0a
oooo00<0003oooooool0S_ooo`00Foooo`03o`2Ioooooooo037oool20000Soooo`00Foooo`03o`2I
oooooooo037oool00`000?ooooooo`2>oooo001Koooo00?o09Woooooool0<Oooo`030000oooooooo
08koool005_oool00ol0VOooooooo`0aoooo00<0003oooooool0S_ooo`00Foooo`03o`2Ioooooooo
037oool20000Soooo`00Foooo`03o`2Ioooooooo037oool00`000?ooooooo`2>oooo001Koooo00?o
09Woooooool0<Oooo`030000oooooooo08koool005_oool00ol0VOooooooo`0aoooo00<0003ooooo
ool0S_ooo`00Foooo`03o`2Ioooooooo037oool20000Soooo`00Foooo`03o`2Ioooooooo037oool0
0`000?ooooooo`2>oooo001Koooo00?o09Woooooool07_ooo`800004oooo0P0000Coool200001Ooo
o`030000oooooooo08koool005_oool00ol0VOooooooo`0Moooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00Foooo`03o`2Ioooooooo01goool010000?oo
ooooo`0000_oool00`000?ooooooo`02oooo0`0008koool005_oool00ol0VOooooooo`0Moooo00@0
003oooooool00009oooo0P0000Goool00`000?ooooooo`2>oooo001Koooo00?o09Woooooool07Ooo
o`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001Koooo00?o
09Woooooool07_ooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo001Koooo00?o09Wooooo
ool0<Oooo`80002?oooo001Koooo00?o09Woooooool0<Oooo`030000oooooooo08koool005_oool0
0ol0VOooooooo`0aoooo00<0003oooooool0S_ooo`00Foooo`03o`2Ioooooooo037oool20000Sooo
o`00Foooo`03o`2Ioooooooo037oool00`000?ooooooo`2>oooo001Koooo00?o09Woooooool0<Ooo
o`030000oooooooo08koool005_oool00ol0VOooooooo`0aoooo00<0003oooooool0S_ooo`00Fooo
o`03o`2Ioooooooo037oool20000Soooo`00Foooo`03o`2Ioooooooo037oool00`000?ooooooo`2>
oooo001Koooo00?o09Woooooool0<Oooo`030000oooooooo08koool005_oool00ol0VOooooooo`0a
oooo00<0003oooooool0S_ooo`00Foooo`03o`2Ioooooooo037oool20000Soooo`00Foooo`03o`2I
oooooooo037oool00`000?ooooooo`2>oooo001Koooo00?o09Woooooool06?ooo`800004oooo0P00
00Goool00`000?ooooooo`02oooo0P0000Goool00`000?ooooooo`2>oooo001Koooo00?o09Wooooo
ool05oooo`040000oooooooo00002_ooo`050000oooooooooooo000000;oool00`000?ooooooo`02
oooo00<0003oooooool0S_ooo`00Foooo`03o`2Ioooooooo01Ooool010000?ooooooo`0000[oool0
0`000?ooooooo`04oooo00<0003oooooool00_ooo`<0002>oooo001Koooo00?o09Woooooool05ooo
o`040000oooooooo00002oooo`040000oooooooooooo0P0000Goool00`000?ooooooo`2>oooo001K
oooo00?o09Woooooool05oooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000
oooooooo00Coool00`000?ooooooo`2>oooo001Koooo00?o09Woooooool06?ooo`800009oooo1000
00?oool300001?ooo`030000oooooooo08koool005_oool00ol0VOooooooo`0aoooo0P0008ooool0
05_oool00ol0VOooooooo`0aoooo00<0003oooooool0S_ooo`00Foooo`03o`2Ioooooooo037oool0
0`000?ooooooo`2>oooo001Koooo00?o09Woooooool0<Oooo`030000oooooooo08koool005_oool0
0ol0VOooooooo`0aoooo0P0008ooool005_oool00ol0VOooooooo`0aoooo00<0003oooooool0S_oo
o`00Foooo`03o`2Ioooooooo037oool00`000?ooooooo`2>oooo001Koooo00?o09Woooooool0<Ooo
o`030000oooooooo08koool005_oool00ol0VOooooooo`0aoooo0P0008ooool005_oool00ol0VOoo
ooooo`0aoooo00<0003oooooool0S_ooo`00Foooo`03o`2Ioooooooo037oool00`000?ooooooo`2>
oooo001Koooo00?o09Woooooool0<Oooo`030000oooooooo08koool005_oool00ol0VOooooooo`0a
oooo0P0008ooool005_oool00ol0VOooooooo`0aoooo00<0003oooooool0S_ooo`00Foooo`03o`2I
oooooooo02Woool500000oooo`030000oooooooo08koool005_oool00ol0VOooooooo`0[oooo00<0
003oooooool00oooo`030000oooooooo08koool005_oool00ol0VOooooooo`0[oooo00<0003ooooo
ool00oooo`<0002>oooo0029oooo00<0003oooooool0U?ooo`00ROooo`030000oooooooo09Coool0
08Soool20000U_ooo`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000
oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo
07Soool007Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool2
00001?ooo`800004oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool0
0`000?ooooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003oooooool00008oooo00@0
003oooooool00003oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo00;oool00`000?oo
ooooo`0Coooo00@0003oooooool0000:oooo00<0003oooooool00oooo`030000oooooooo07Ooool0
07Soool00`000?ooooooo`0500004_ooo`040000oooooooo00002oooo`050000oooooooooooo0000
07[oool007Soool01@000?ooooooooooo`00000Eoooo00@0003oooooool00008oooo00@0003ooooo
ool00003oooo00<0003oooooool0N?ooo`00NOooo`030000oooooooo01Ooool200002_ooo`800003
oooo00<0003oooooool0NOooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.25) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.27193 .30902 L
.28302 .30902 L
.2881 .30902 L
.29349 .30902 L
.29809 .30902 L
.29935 .30902 L
.30004 .30902 L
.3007 .30902 L
s
.3007 .30902 m
.30083 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.25) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Koool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00;oool01?l0VOoo
ooooo`0000Ooool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Goool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo01Goool001Koool00`000?oo
ooooo`0Uoooo00<0003oooooool06oooo`03o`2Ioooooooo00Soool00`000?ooooooo`0Uoooo00<0
003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0Voooo00<0003oooooool05Ooo
o`00G?ooo`03o`2Ioooooooo033oool00`000?ooooooo`2>oooo001Loooo00?o09Woooooool0<?oo
o`80002?oooo001Loooo00?o09Woooooool0<?ooo`030000oooooooo08koool005coool00ol0VOoo
ooooo`0`oooo00<0003oooooool0S_ooo`00G?ooo`03o`2Ioooooooo033oool00`000?ooooooo`2>
oooo001Loooo00?o09Woooooool0<?ooo`80002?oooo001Loooo00?o09Woooooool0<?ooo`030000
oooooooo08koool005coool00ol0VOooooooo`0`oooo00<0003oooooool0S_ooo`00G?ooo`03o`2I
oooooooo033oool00`000?ooooooo`2>oooo001Loooo00?o09Woooooool0<?ooo`80002?oooo001L
oooo00?o09Woooooool0<?ooo`030000oooooooo08koool005coool00ol0VOooooooo`0`oooo00<0
003oooooool0S_ooo`00G?ooo`03o`2Ioooooooo033oool00`000?ooooooo`2>oooo001Loooo00?o
09Woooooool0<?ooo`80002?oooo001Loooo00?o09Woooooool0<?ooo`030000oooooooo08koool0
05coool00ol0VOooooooo`0Goooo0P0000Coool200000oooo`@00003oooo0P0000Goool00`000?oo
ooooo`2>oooo001Loooo00?o09Woooooool05_ooo`040000oooooooo00002?ooo`030000oooooooo
00?oool010000?ooooooo`0000Coool00`000?ooooooo`2>oooo001Loooo00?o09Woooooool05_oo
o`040000oooooooo00002Oooo`030000oooooooo00Goool00`000?ooooooo`02oooo0`0008koool0
05coool00ol0VOooooooo`0Foooo00@0003oooooool0000:oooo00<0003oooooool00_ooo`800005
oooo00<0003oooooool0S_ooo`00G?ooo`03o`2Ioooooooo01Koool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00G?ooo`03o`2I
oooooooo01Ooool200002_ooo`800004oooo0`0000Coool00`000?ooooooo`2>oooo001Loooo00?o
09Woooooool0<?ooo`80002?oooo001Loooo00?o09Woooooool0<?ooo`030000oooooooo08koool0
05coool00ol0VOooooooo`0`oooo00<0003oooooool0S_ooo`00G?ooo`03o`2Ioooooooo033oool0
0`000?ooooooo`2>oooo001Loooo00?o09Woooooool0<?ooo`80002?oooo001Loooo00?o09Wooooo
ool0<?ooo`030000oooooooo08koool005coool00ol0VOooooooo`0`oooo00<0003oooooool0S_oo
o`00G?ooo`03o`2Ioooooooo033oool00`000?ooooooo`2>oooo001Loooo00?o09Woooooool0<?oo
o`80002?oooo001Loooo00?o09Woooooool0<?ooo`030000oooooooo08koool005coool00ol0VOoo
ooooo`0`oooo00<0003oooooool0S_ooo`00G?ooo`03o`2Ioooooooo033oool00`000?ooooooo`2>
oooo001Loooo00?o09Woooooool0<?ooo`80002?oooo001Loooo00?o09Woooooool0<?ooo`030000
oooooooo08koool005coool00ol0VOooooooo`0Moooo0P0000Coool200001?ooo`800005oooo00<0
003oooooool0S_ooo`00G?ooo`03o`2Ioooooooo01coool010000?ooooooo`0000Soool010000?oo
ooooo`0000Coool00`000?ooooooo`2>oooo001Loooo00?o09Woooooool07?ooo`040000oooooooo
00002oooo`030000oooooooo00;oool30000S_ooo`00G?ooo`03o`2Ioooooooo01coool010000?oo
ooooo`0000Woool200001Oooo`030000oooooooo08koool005coool00ol0VOooooooo`0Loooo00@0
003oooooool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool005coool00ol0VOoo
ooooo`0Moooo0P0000[oool300001?ooo`030000oooooooo08koool005coool00ol0VOooooooo`0`
oooo0P0008ooool005coool00ol0VOooooooo`0`oooo00<0003oooooool0S_ooo`00G?ooo`03o`2I
oooooooo033oool00`000?ooooooo`2>oooo001Loooo00?o09Woooooool0<?ooo`80002?oooo001L
oooo00?o09Woooooool0<?ooo`030000oooooooo08koool005coool00ol0VOooooooo`0`oooo00<0
003oooooool0S_ooo`00G?ooo`03o`2Ioooooooo033oool00`000?ooooooo`2>oooo001Loooo00?o
09Woooooool0<?ooo`80002?oooo001Loooo00?o09Woooooool0<?ooo`030000oooooooo08koool0
05coool00ol0VOooooooo`0`oooo00<0003oooooool0S_ooo`00G?ooo`03o`2Ioooooooo033oool0
0`000?ooooooo`2>oooo001Loooo00?o09Woooooool0<?ooo`80002?oooo001Loooo00?o09Wooooo
ool0<?ooo`030000oooooooo08koool005coool00ol0VOooooooo`0Goooo0P0000Coool200001Ooo
o`030000oooooooo00;oool200001Oooo`030000oooooooo08koool005coool00ol0VOooooooo`0F
oooo00@0003oooooool0000:oooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool0
0`000?ooooooo`2>oooo001Loooo00?o09Woooooool05_ooo`040000oooooooo00002_ooo`030000
oooooooo00Coool00`000?ooooooo`02oooo0`0008koool005coool00ol0VOooooooo`0Foooo00@0
003oooooool0000;oooo00@0003oooooooooool200001Oooo`030000oooooooo08koool005coool0
0ol0VOooooooo`0Foooo00@0003oooooool00008oooo00@0003oooooool00003oooo00<0003ooooo
ool01?ooo`030000oooooooo08koool005coool00ol0VOooooooo`0Goooo0P0000Woool400000ooo
o`<00004oooo00<0003oooooool0S_ooo`00G?ooo`03o`2Ioooooooo033oool20000Soooo`00G?oo
o`03o`2Ioooooooo033oool00`000?ooooooo`2>oooo001Loooo00?o09Woooooool0<?ooo`030000
oooooooo08koool005coool00ol0VOooooooo`0`oooo00<0003oooooool0S_ooo`00G?ooo`03o`2I
oooooooo033oool20000Soooo`00G?ooo`03o`2Ioooooooo033oool00`000?ooooooo`2>oooo001L
oooo00?o09Woooooool0<?ooo`030000oooooooo08koool005coool00ol0VOooooooo`0`oooo00<0
003oooooool0S_ooo`00G?ooo`03o`2Ioooooooo033oool20000Soooo`00G?ooo`03o`2Ioooooooo
033oool00`000?ooooooo`2>oooo001Loooo00?o09Woooooool0<?ooo`030000oooooooo08koool0
05coool00ol0VOooooooo`0`oooo00<0003oooooool0S_ooo`00G?ooo`03o`2Ioooooooo033oool2
0000Soooo`00G?ooo`03o`2Ioooooooo033oool00`000?ooooooo`2>oooo001Loooo00?o09Wooooo
ool0:?ooo`D00003oooo00<0003oooooool0S_ooo`00G?ooo`03o`2Ioooooooo02[oool00`000?oo
ooooo`03oooo00<0003oooooool0S_ooo`00G?ooo`03o`2Ioooooooo02[oool00`000?ooooooo`03
oooo0`0008koool008Woool00`000?ooooooo`2Doooo0029oooo00<0003oooooool0U?ooo`00R?oo
o`80002Foooo003ooooo8Oooo`00ooooob7oool007Koool00`000?ooooooo`0^oooo00<0003ooooo
ool0M_ooo`00MOooo`030000oooooooo00Soool00`000?ooooooo`0Uoooo00<0003oooooool0MOoo
o`00MOooo`030000oooooooo00;oool200001?ooo`030000oooooooo00goool200001?ooo`800003
oooo100000?oool200001?ooo`030000oooooooo07Goool007Goool01@000?ooooooooooo`000002
oooo00<0003oooooool00_ooo`030000oooooooo00Coool400000oooo`040000oooooooo00002?oo
o`030000oooooooo00?oool010000?ooooooo`0000?oool00`000?ooooooo`1eoooo001doooo00<0
003oooooool00_ooo`030000oooooooo01?oool010000?ooooooo`0000Woool00`000?ooooooo`05
oooo00<0003oooooool00_ooo`030000oooooooo07Coool007Goool00`000?ooooooo`0500004_oo
o`040000oooooooo00002_ooo`030000oooooooo00;oool200001?ooo`030000oooooooo07Goool0
07Goool01@000?ooooooooooo`00000Eoooo00@0003oooooool00008oooo00@0003oooooool00003
oooo00<0003oooooool00oooo`030000oooooooo07Goool007Koool00`000?ooooooo`0Goooo0P00
00[oool200001?ooo`<00002oooo00<0003oooooool0M_ooo`00ooooob7oool00?oooolQoooo0000
\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.29205 .30902 L
.29779 .30902 L
.30316 .30902 L
.3056 .30902 L
.30791 .30902 L
.30919 .30902 L
s
.30919 .30902 m
.30927 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Koool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`0Eoooo000Foooo00<0003ooooo
ool09Oooo`030000oooooooo01koool00ol0VOooooooo`05oooo00<0003oooooool09Oooo`030000
oooooooo02Goool00`000?ooooooo`0Uoooo00<0003oooooool09_ooo`030000oooooooo01Goool0
05ooool00ol0VOooooooo`0]oooo00<0003oooooool0S_ooo`00Goooo`03o`2Ioooooooo02goool2
0000Soooo`00Goooo`03o`2Ioooooooo02goool00`000?ooooooo`2>oooo001Ooooo00?o09Wooooo
ool0;Oooo`030000oooooooo08koool005ooool00ol0VOooooooo`0]oooo00<0003oooooool0S_oo
o`00Goooo`03o`2Ioooooooo02goool20000Soooo`00Goooo`03o`2Ioooooooo02goool00`000?oo
ooooo`2>oooo001Ooooo00?o09Woooooool0;Oooo`030000oooooooo08koool005ooool00ol0VOoo
ooooo`0]oooo00<0003oooooool0S_ooo`00Goooo`03o`2Ioooooooo02goool20000Soooo`00Gooo
o`03o`2Ioooooooo02goool00`000?ooooooo`2>oooo001Ooooo00?o09Woooooool0;Oooo`030000
oooooooo08koool005ooool00ol0VOooooooo`0]oooo00<0003oooooool0S_ooo`00Goooo`03o`2I
oooooooo02goool20000Soooo`00Goooo`03o`2Ioooooooo02goool00`000?ooooooo`2>oooo001O
oooo00?o09Woooooool05?ooo`800004oooo0P0000?oool400000oooo`800005oooo00<0003ooooo
ool0S_ooo`00Goooo`03o`2Ioooooooo01?oool010000?ooooooo`0000Soool00`000?ooooooo`03
oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00Goooo`03o`2Ioooooooo01?oool0
10000?ooooooo`0000Woool00`000?ooooooo`05oooo00<0003oooooool00_ooo`<0002>oooo001O
oooo00?o09Woooooool04oooo`040000oooooooo00002_ooo`030000oooooooo00;oool200001Ooo
o`030000oooooooo08koool005ooool00ol0VOooooooo`0Coooo00@0003oooooool00008oooo00@0
003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo08koool005ooool00ol0VOoo
ooooo`0Doooo0P0000[oool200001?ooo`<00004oooo00<0003oooooool0S_ooo`00Goooo`03o`2I
oooooooo02goool20000Soooo`00Goooo`03o`2Ioooooooo02goool00`000?ooooooo`2>oooo001O
oooo00?o09Woooooool0;Oooo`030000oooooooo08koool005ooool00ol0VOooooooo`0]oooo00<0
003oooooool0S_ooo`00Goooo`03o`2Ioooooooo02goool20000Soooo`00Goooo`03o`2Ioooooooo
02goool00`000?ooooooo`2>oooo001Ooooo00?o09Woooooool0;Oooo`030000oooooooo08koool0
05ooool00ol0VOooooooo`0]oooo00<0003oooooool0S_ooo`00Goooo`03o`2Ioooooooo02goool2
0000Soooo`00Goooo`03o`2Ioooooooo02goool00`000?ooooooo`2>oooo001Ooooo00?o09Wooooo
ool0;Oooo`030000oooooooo08koool005ooool00ol0VOooooooo`0]oooo00<0003oooooool0S_oo
o`00Goooo`03o`2Ioooooooo02goool20000Soooo`00Goooo`03o`2Ioooooooo02goool00`000?oo
ooooo`2>oooo001Ooooo00?o09Woooooool06_ooo`800004oooo0P0000Coool200001Oooo`030000
oooooooo08koool005ooool00ol0VOooooooo`0Ioooo00@0003oooooool00008oooo00@0003ooooo
ool00004oooo00<0003oooooool0S_ooo`00Goooo`03o`2Ioooooooo01Woool010000?ooooooo`00
00_oool00`000?ooooooo`02oooo0`0008koool005ooool00ol0VOooooooo`0Ioooo00@0003ooooo
ool00009oooo0P0000Goool00`000?ooooooo`2>oooo001Ooooo00?o09Woooooool06Oooo`040000
oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001Ooooo00?o09Wooooo
ool06_ooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo001Ooooo00?o09Woooooool0;Ooo
o`80002?oooo001Ooooo00?o09Woooooool0;Oooo`030000oooooooo08koool005ooool00ol0VOoo
ooooo`0]oooo00<0003oooooool0S_ooo`00Goooo`03o`2Ioooooooo02goool20000Soooo`00Gooo
o`03o`2Ioooooooo02goool00`000?ooooooo`2>oooo001Ooooo00?o09Woooooool0;Oooo`030000
oooooooo08koool005ooool00ol0VOooooooo`0]oooo00<0003oooooool0S_ooo`00Goooo`03o`2I
oooooooo02goool20000Soooo`00Goooo`03o`2Ioooooooo02goool00`000?ooooooo`2>oooo001O
oooo00?o09Woooooool0;Oooo`030000oooooooo08koool005ooool00ol0VOooooooo`0]oooo00<0
003oooooool0S_ooo`00Goooo`03o`2Ioooooooo02goool20000Soooo`00Goooo`03o`2Ioooooooo
02goool00`000?ooooooo`2>oooo001Ooooo00?o09Woooooool05?ooo`800004oooo0P0000Goool0
0`000?ooooooo`02oooo0P0000Goool00`000?ooooooo`2>oooo001Ooooo00?o09Woooooool04ooo
o`040000oooooooo00002_ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0
003oooooool0S_ooo`00Goooo`03o`2Ioooooooo01?oool010000?ooooooo`0000[oool00`000?oo
ooooo`04oooo00<0003oooooool00_ooo`<0002>oooo001Ooooo00?o09Woooooool04oooo`040000
oooooooo00002oooo`040000oooooooooooo0P0000Goool00`000?ooooooo`2>oooo001Ooooo00?o
09Woooooool04oooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo
00Coool00`000?ooooooo`2>oooo001Ooooo00?o09Woooooool05?ooo`800009oooo100000?oool3
00001?ooo`030000oooooooo08koool005ooool00ol0VOooooooo`0]oooo0P0008ooool005ooool0
0ol0VOooooooo`0]oooo00<0003oooooool0S_ooo`00Goooo`03o`2Ioooooooo02goool00`000?oo
ooooo`2>oooo001Ooooo00?o09Woooooool0;Oooo`030000oooooooo08koool005ooool00ol0VOoo
ooooo`0]oooo0P0008ooool005ooool00ol0VOooooooo`0]oooo00<0003oooooool0S_ooo`00Gooo
o`03o`2Ioooooooo02goool00`000?ooooooo`2>oooo001Ooooo00?o09Woooooool0;Oooo`030000
oooooooo08koool005ooool00ol0VOooooooo`0]oooo0P0008ooool005ooool00ol0VOooooooo`0]
oooo00<0003oooooool0S_ooo`00Goooo`03o`2Ioooooooo02goool00`000?ooooooo`2>oooo001O
oooo00?o09Woooooool0;Oooo`030000oooooooo08koool005ooool00ol0VOooooooo`0]oooo0P00
08ooool005ooool00ol0VOooooooo`0]oooo00<0003oooooool0S_ooo`00Goooo`03o`2Ioooooooo
02Goool500000oooo`030000oooooooo08koool005ooool00ol0VOooooooo`0Woooo00<0003ooooo
ool00oooo`030000oooooooo08koool005ooool00ol0VOooooooo`0Woooo00<0003oooooool00ooo
o`<0002>oooo0029oooo00<0003oooooool0U?ooo`00ROooo`030000oooooooo09Coool008Soool2
0000U_ooo`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo
07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool0
07Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool200000ooo
o`@00003oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003oooooool00008oooo00<0003ooooo
ool01?ooo`030000oooooooo07Soool007Ooool00`000?ooooooo`02oooo00<0003oooooool04ooo
o`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`1goooo001hoooo00<0
003oooooool01@0001;oool010000?ooooooo`0000[oool00`000?ooooooo`02oooo00<0003ooooo
ool0N?ooo`00N?ooo`050000oooooooooooo000001Goool010000?ooooooo`0000Soool010000?oo
ooooo`0000?oool00`000?ooooooo`1hoooo001ioooo00<0003oooooool05oooo`80000:oooo0P00
00?oool00`000?ooooooo`1ioooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.15) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.29205 .30902 L
.30316 .30902 L
.30791 .30902 L
.31304 .30902 L
.31454 .30902 L
.31597 .30902 L
.31725 .30902 L
s
.31725 .30902 m
.31733 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.15) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Koool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ool0V@05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`0Eoooo000Foooo00<0003ooooo
ool09Oooo`030000oooooooo023oool00ol0VOooooooo`03oooo00<0003oooooool09Oooo`030000
oooooooo02Goool00`000?ooooooo`0Uoooo00<0003oooooool09_ooo`030000oooooooo01Goool0
067oool00ol0VOooooooo`0[oooo00<0003oooooool0S_ooo`00HOooo`03o`2Ioooooooo02_oool2
0000Soooo`00HOooo`03o`2Ioooooooo02_oool00`000?ooooooo`2>oooo001Qoooo00?o09Wooooo
ool0:oooo`030000oooooooo08koool0067oool00ol0VOooooooo`0[oooo00<0003oooooool0S_oo
o`00HOooo`03o`2Ioooooooo02_oool20000Soooo`00HOooo`03o`2Ioooooooo02_oool00`000?oo
ooooo`2>oooo001Qoooo00?o09Woooooool0:oooo`030000oooooooo08koool0067oool00ol0VOoo
ooooo`0[oooo00<0003oooooool0S_ooo`00HOooo`03o`2Ioooooooo02_oool20000Soooo`00HOoo
o`03o`2Ioooooooo02_oool00`000?ooooooo`2>oooo001Qoooo00?o09Woooooool0:oooo`030000
oooooooo08koool0067oool00ol0VOooooooo`0[oooo00<0003oooooool0S_ooo`00HOooo`03o`2I
oooooooo02_oool20000Soooo`00HOooo`03o`2Ioooooooo02_oool00`000?ooooooo`2>oooo001Q
oooo00?o09Woooooool04_ooo`800004oooo0P0000?oool400000oooo`800005oooo00<0003ooooo
ool0S_ooo`00HOooo`03o`2Ioooooooo017oool010000?ooooooo`0000Soool00`000?ooooooo`03
oooo00@0003oooooool00004oooo00<0003oooooool0S_ooo`00HOooo`03o`2Ioooooooo017oool0
10000?ooooooo`0000Woool00`000?ooooooo`05oooo00<0003oooooool00_ooo`<0002>oooo001Q
oooo00?o09Woooooool04Oooo`040000oooooooo00002_ooo`030000oooooooo00;oool200001Ooo
o`030000oooooooo08koool0067oool00ol0VOooooooo`0Aoooo00@0003oooooool00008oooo00@0
003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo08koool0067oool00ol0VOoo
ooooo`0Boooo0P0000[oool200001?ooo`<00004oooo00<0003oooooool0S_ooo`00HOooo`03o`2I
oooooooo02_oool20000Soooo`00HOooo`03o`2Ioooooooo02_oool00`000?ooooooo`2>oooo001Q
oooo00?o09Woooooool0:oooo`030000oooooooo08koool0067oool00ol0VOooooooo`0[oooo00<0
003oooooool0S_ooo`00HOooo`03o`2Ioooooooo02_oool20000Soooo`00HOooo`03o`2Ioooooooo
02_oool00`000?ooooooo`2>oooo001Qoooo00?o09Woooooool0:oooo`030000oooooooo08koool0
067oool00ol0VOooooooo`0[oooo00<0003oooooool0S_ooo`00HOooo`03o`2Ioooooooo02_oool2
0000Soooo`00HOooo`03o`2Ioooooooo02_oool00`000?ooooooo`2>oooo001Qoooo00?o09Wooooo
ool0:oooo`030000oooooooo08koool0067oool00ol0VOooooooo`0[oooo00<0003oooooool0S_oo
o`00HOooo`03o`2Ioooooooo02_oool20000Soooo`00HOooo`03o`2Ioooooooo02_oool00`000?oo
ooooo`2>oooo001Qoooo00?o09Woooooool06?ooo`800004oooo0P0000Coool200001Oooo`030000
oooooooo08koool0067oool00ol0VOooooooo`0Goooo00@0003oooooool00008oooo00@0003ooooo
ool00004oooo00<0003oooooool0S_ooo`00HOooo`03o`2Ioooooooo01Ooool010000?ooooooo`00
00_oool00`000?ooooooo`02oooo0`0008koool0067oool00ol0VOooooooo`0Goooo00@0003ooooo
ool00009oooo0P0000Goool00`000?ooooooo`2>oooo001Qoooo00?o09Woooooool05oooo`040000
oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001Qoooo00?o09Wooooo
ool06?ooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo001Qoooo00?o09Woooooool0:ooo
o`80002?oooo001Qoooo00?o09Woooooool0:oooo`030000oooooooo08koool0067oool00ol0VOoo
ooooo`0[oooo00<0003oooooool0S_ooo`00HOooo`03o`2Ioooooooo02_oool20000Soooo`00HOoo
o`03o`2Ioooooooo02_oool00`000?ooooooo`2>oooo001Qoooo00?o09Woooooool0:oooo`030000
oooooooo08koool0067oool00ol0VOooooooo`0[oooo00<0003oooooool0S_ooo`00HOooo`03o`2I
oooooooo02_oool20000Soooo`00HOooo`03o`2Ioooooooo02_oool00`000?ooooooo`2>oooo001Q
oooo00?o09Woooooool0:oooo`030000oooooooo08koool0067oool00ol0VOooooooo`0[oooo00<0
003oooooool0S_ooo`00HOooo`03o`2Ioooooooo02_oool20000Soooo`00HOooo`03o`2Ioooooooo
02_oool00`000?ooooooo`2>oooo001Qoooo00?o09Woooooool04_ooo`800004oooo0P0000Goool0
0`000?ooooooo`02oooo0P0000Goool00`000?ooooooo`2>oooo001Qoooo00?o09Woooooool04Ooo
o`040000oooooooo00002_ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0
003oooooool0S_ooo`00HOooo`03o`2Ioooooooo017oool010000?ooooooo`0000[oool00`000?oo
ooooo`04oooo00<0003oooooool00_ooo`<0002>oooo001Qoooo00?o09Woooooool04Oooo`040000
oooooooo00002oooo`040000oooooooooooo0P0000Goool00`000?ooooooo`2>oooo001Qoooo00?o
09Woooooool04Oooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo
00Coool00`000?ooooooo`2>oooo001Qoooo00?o09Woooooool04_ooo`800009oooo100000?oool3
00001?ooo`030000oooooooo08koool0067oool00ol0VOooooooo`0[oooo0P0008ooool0067oool0
0ol0VOooooooo`0[oooo00<0003oooooool0S_ooo`00HOooo`03o`2Ioooooooo02_oool00`000?oo
ooooo`2>oooo001Qoooo00?o09Woooooool0:oooo`030000oooooooo08koool0067oool00ol0VOoo
ooooo`0[oooo0P0008ooool0067oool00ol0VOooooooo`0[oooo00<0003oooooool0S_ooo`00HOoo
o`03o`2Ioooooooo02_oool00`000?ooooooo`2>oooo001Qoooo00?o09Woooooool0:oooo`030000
oooooooo08koool0067oool00ol0VOooooooo`0[oooo0P0008ooool0067oool00ol0VOooooooo`0[
oooo00<0003oooooool0S_ooo`00HOooo`03o`2Ioooooooo02_oool00`000?ooooooo`2>oooo001Q
oooo00?o09Woooooool0:oooo`030000oooooooo08koool0067oool00ol0VOooooooo`0[oooo0P00
08ooool0067oool00ol0VOooooooo`0[oooo00<0003oooooool0S_ooo`00HOooo`03o`2Ioooooooo
02?oool500000oooo`030000oooooooo08koool0067oool00ol0VOooooooo`0Uoooo00<0003ooooo
ool00oooo`030000oooooooo08koool0067oool00ol0VOooooooo`0Uoooo00<0003oooooool00ooo
o`<0002>oooo0029oooo00<0003oooooool0U?ooo`00ROooo`030000oooooooo09Coool008Soool2
0000U_ooo`00ooooob7oool00?oooolQoooo001foooo00<0003oooooool0;_ooo`030000oooooooo
07Koool007Goool00`000?ooooooo`08oooo00<0003oooooool09Oooo`030000oooooooo07Goool0
07Goool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=oooo0P0000Coool200000ooo
o`D00002oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000000_oo
o`030000oooooooo00;oool00`000?ooooooo`04oooo100000?oool010000?ooooooo`0000[oool0
1@000?ooooooooooo`000002oooo00D0003oooooooooool00000Moooo`00M?ooo`030000oooooooo
00;oool00`000?ooooooo`0Coooo00@0003oooooool0000:oooo00<0003oooooool01?ooo`030000
oooooooo00;oool00`000?ooooooo`1doooo001eoooo00<0003oooooool01@0001;oool010000?oo
ooooo`0000[oool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`1eoooo001eoooo00D0
003oooooooooool000005Oooo`040000oooooooo00002_ooo`030000oooooooo00;oool00`000?oo
ooooo`03oooo00<0003oooooool0MOooo`00M_ooo`030000oooooooo01Ooool200002_ooo`800004
oooo0`0000;oool00`000?ooooooo`1foooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.31875 .30902 L
.32145 .30902 L
.32263 .30902 L
.32392 .30902 L
.32509 .30902 L
s
.32509 .30902 m
.32519 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Koool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool01@000?oo
ooooooooool0V@03oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool0
0`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`0Eoooo000Foooo00<0
003oooooool09Oooo`030000oooooooo02;oool01Ol0VOooooooooooo`00000Woooo00<0003ooooo
ool09Oooo`030000oooooooo02Goool00`000?ooooooo`0Voooo00<0003oooooool05Oooo`00Hooo
o`03o`2Ioooooooo02Woool00`000?ooooooo`2>oooo001Soooo00?o09Woooooool0:Oooo`80002?
oooo001Soooo00?o09Woooooool0:Oooo`030000oooooooo08koool006?oool00ol0VOooooooo`0Y
oooo00<0003oooooool0S_ooo`00Hoooo`03o`2Ioooooooo02Woool00`000?ooooooo`2>oooo001S
oooo00?o09Woooooool0:Oooo`80002?oooo001Soooo00?o09Woooooool0:Oooo`030000oooooooo
08koool006?oool00ol0VOooooooo`0Yoooo00<0003oooooool0S_ooo`00Hoooo`03o`2Ioooooooo
02Woool00`000?ooooooo`2>oooo001Soooo00?o09Woooooool0:Oooo`80002?oooo001Soooo00?o
09Woooooool0:Oooo`030000oooooooo08koool006?oool00ol0VOooooooo`0Yoooo00<0003ooooo
ool0S_ooo`00Hoooo`03o`2Ioooooooo02Woool00`000?ooooooo`2>oooo001Soooo00?o09Wooooo
ool0:Oooo`80002?oooo001Soooo00?o09Woooooool0:Oooo`030000oooooooo08koool006?oool0
0ol0VOooooooo`0@oooo0P0000Coool200000oooo`@00003oooo0P0000Goool00`000?ooooooo`2>
oooo001Soooo00?o09Woooooool03oooo`040000oooooooo00002?ooo`030000oooooooo00?oool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo001Soooo00?o09Woooooool03oooo`040000
oooooooo00002Oooo`030000oooooooo00Goool00`000?ooooooo`02oooo0`0008koool006?oool0
0ol0VOooooooo`0?oooo00@0003oooooool0000:oooo00<0003oooooool00_ooo`800005oooo00<0
003oooooool0S_ooo`00Hoooo`03o`2Ioooooooo00ooool010000?ooooooo`0000Soool010000?oo
ooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00Hoooo`03o`2Ioooooooo
013oool200002_ooo`800004oooo0`0000Coool00`000?ooooooo`2>oooo001Soooo00?o09Wooooo
ool0:Oooo`80002?oooo001Soooo00?o09Woooooool0:Oooo`030000oooooooo08koool006?oool0
0ol0VOooooooo`0Yoooo00<0003oooooool0S_ooo`00Hoooo`03o`2Ioooooooo02Woool00`000?oo
ooooo`2>oooo001Soooo00?o09Woooooool0:Oooo`80002?oooo001Soooo00?o09Woooooool0:Ooo
o`030000oooooooo08koool006?oool00ol0VOooooooo`0Yoooo00<0003oooooool0S_ooo`00Hooo
o`03o`2Ioooooooo02Woool00`000?ooooooo`2>oooo001Soooo00?o09Woooooool0:Oooo`80002?
oooo001Soooo00?o09Woooooool0:Oooo`030000oooooooo08koool006?oool00ol0VOooooooo`0Y
oooo00<0003oooooool0S_ooo`00Hoooo`03o`2Ioooooooo02Woool00`000?ooooooo`2>oooo001S
oooo00?o09Woooooool0:Oooo`80002?oooo001Soooo00?o09Woooooool0:Oooo`030000oooooooo
08koool006?oool00ol0VOooooooo`0Foooo0P0000Coool200001?ooo`800005oooo00<0003ooooo
ool0S_ooo`00Hoooo`03o`2Ioooooooo01Goool010000?ooooooo`0000Soool010000?ooooooo`00
00Coool00`000?ooooooo`2>oooo001Soooo00?o09Woooooool05Oooo`040000oooooooo00002ooo
o`030000oooooooo00;oool30000S_ooo`00Hoooo`03o`2Ioooooooo01Goool010000?ooooooo`00
00Woool200001Oooo`030000oooooooo08koool006?oool00ol0VOooooooo`0Eoooo00@0003ooooo
ool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool006?oool00ol0VOooooooo`0F
oooo0P0000[oool300001?ooo`030000oooooooo08koool006?oool00ol0VOooooooo`0Yoooo0P00
08ooool006?oool00ol0VOooooooo`0Yoooo00<0003oooooool0S_ooo`00Hoooo`03o`2Ioooooooo
02Woool00`000?ooooooo`2>oooo001Soooo00?o09Woooooool0:Oooo`80002?oooo001Soooo00?o
09Woooooool0:Oooo`030000oooooooo08koool006?oool00ol0VOooooooo`0Yoooo00<0003ooooo
ool0S_ooo`00Hoooo`03o`2Ioooooooo02Woool00`000?ooooooo`2>oooo001Soooo00?o09Wooooo
ool0:Oooo`80002?oooo001Soooo00?o09Woooooool0:Oooo`030000oooooooo08koool006?oool0
0ol0VOooooooo`0Yoooo00<0003oooooool0S_ooo`00Hoooo`03o`2Ioooooooo02Woool00`000?oo
ooooo`2>oooo001Soooo00?o09Woooooool0:Oooo`80002?oooo001Soooo00?o09Woooooool0:Ooo
o`030000oooooooo08koool006?oool00ol0VOooooooo`0@oooo0P0000Coool200001Oooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool006?oool00ol0VOooooooo`0?oooo00@0
003oooooool0000:oooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?oo
ooooo`2>oooo001Soooo00?o09Woooooool03oooo`040000oooooooo00002_ooo`030000oooooooo
00Coool00`000?ooooooo`02oooo0`0008koool006?oool00ol0VOooooooo`0?oooo00@0003ooooo
ool0000;oooo00@0003oooooooooool200001Oooo`030000oooooooo08koool006?oool00ol0VOoo
ooooo`0?oooo00@0003oooooool00008oooo00@0003oooooool00003oooo00<0003oooooool01?oo
o`030000oooooooo08koool006?oool00ol0VOooooooo`0@oooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Hoooo`03o`2Ioooooooo02Woool20000Soooo`00Hoooo`03o`2I
oooooooo02Woool00`000?ooooooo`2>oooo001Soooo00?o09Woooooool0:Oooo`030000oooooooo
08koool006?oool00ol0VOooooooo`0Yoooo00<0003oooooool0S_ooo`00Hoooo`03o`2Ioooooooo
02Woool20000Soooo`00Hoooo`03o`2Ioooooooo02Woool00`000?ooooooo`2>oooo001Soooo00?o
09Woooooool0:Oooo`030000oooooooo08koool006?oool00ol0VOooooooo`0Yoooo00<0003ooooo
ool0S_ooo`00Hoooo`03o`2Ioooooooo02Woool20000Soooo`00Hoooo`03o`2Ioooooooo02Woool0
0`000?ooooooo`2>oooo001Soooo00?o09Woooooool0:Oooo`030000oooooooo08koool006?oool0
0ol0VOooooooo`0Yoooo00<0003oooooool0S_ooo`00Hoooo`03o`2Ioooooooo02Woool20000Sooo
o`00Hoooo`03o`2Ioooooooo02Woool00`000?ooooooo`2>oooo001Soooo00?o09Woooooool08Ooo
o`D00003oooo00<0003oooooool0S_ooo`00Hoooo`03o`2Ioooooooo02?oool00`000?ooooooo`03
oooo00<0003oooooool0S_ooo`00Hoooo`03o`2Ioooooooo02?oool00`000?ooooooo`03oooo0`00
08koool008Woool00`000?ooooooo`2Doooo0029oooo00<0003oooooool0U?ooo`00R?ooo`80002F
oooo003ooooo8Oooo`00ooooob7oool007Woool00`000?ooooooo`0Xoooo00<0003oooooool0NOoo
o`00N?ooo`030000oooooooo00Soool00`000?ooooooo`0Ooooo00<0003oooooool0N?ooo`00N?oo
o`030000oooooooo00;oool200001?ooo`030000oooooooo00goool200001?ooo`800003oooo1@00
00;oool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000000_ooo`030000oooooooo
00;oool00`000?ooooooo`04oooo100000?oool010000?ooooooo`0000[oool00`000?ooooooo`02
oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo00;oool00`000?ooooooo`0Coooo00@0
003oooooool0000:oooo00<0003oooooool00oooo`030000oooooooo07Ooool007Soool00`000?oo
ooooo`0500004_ooo`040000oooooooo00002_ooo`030000oooooooo00;oool00`000?ooooooo`1h
oooo001hoooo00D0003oooooooooool000005Oooo`040000oooooooo00002_ooo`030000oooooooo
00;oool00`000?ooooooo`1hoooo001ioooo00<0003oooooool05oooo`80000:oooo0P0000?oool0
0`000?ooooooo`1ioooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.05) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.32831 .30902 L
.33073 .30902 L
.33193 .30902 L
.33304 .30902 L
s
.33304 .30902 m
.33317 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.05) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Koool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`03oooo00?o09Woool000001oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`0Eoooo000Foooo00<0003ooooo
ool09Oooo`030000oooooooo02Coool00ol0VOooo`00000Woooo00<0003oooooool09Oooo`030000
oooooooo02Goool00`000?ooooooo`0Voooo00<0003oooooool05Oooo`00IOooo`03o`2Ioooooooo
02Ooool00`000?ooooooo`2>oooo001Uoooo00?o09Woooooool09oooo`80002?oooo001Uoooo00?o
09Woooooool09oooo`030000oooooooo08koool006Goool00ol0VOooooooo`0Woooo00<0003ooooo
ool0S_ooo`00IOooo`03o`2Ioooooooo02Ooool00`000?ooooooo`2>oooo001Uoooo00?o09Wooooo
ool09oooo`80002?oooo001Uoooo00?o09Woooooool09oooo`030000oooooooo08koool006Goool0
0ol0VOooooooo`0Woooo00<0003oooooool0S_ooo`00IOooo`03o`2Ioooooooo02Ooool00`000?oo
ooooo`2>oooo001Uoooo00?o09Woooooool09oooo`80002?oooo001Uoooo00?o09Woooooool09ooo
o`030000oooooooo08koool006Goool00ol0VOooooooo`0Woooo00<0003oooooool0S_ooo`00IOoo
o`03o`2Ioooooooo02Ooool00`000?ooooooo`2>oooo001Uoooo00?o09Woooooool09oooo`80002?
oooo001Uoooo00?o09Woooooool09oooo`030000oooooooo08koool006Goool00ol0VOooooooo`0>
oooo0P0000Coool200000oooo`@00003oooo0P0000Goool00`000?ooooooo`2>oooo001Uoooo00?o
09Woooooool03Oooo`040000oooooooo00002?ooo`030000oooooooo00?oool010000?ooooooo`00
00Coool00`000?ooooooo`2>oooo001Uoooo00?o09Woooooool03Oooo`040000oooooooo00002Ooo
o`030000oooooooo00Goool00`000?ooooooo`02oooo0`0008koool006Goool00ol0VOooooooo`0=
oooo00@0003oooooool0000:oooo00<0003oooooool00_ooo`800005oooo00<0003oooooool0S_oo
o`00IOooo`03o`2Ioooooooo00goool010000?ooooooo`0000Soool010000?ooooooo`0000?oool0
0`000?ooooooo`04oooo00<0003oooooool0S_ooo`00IOooo`03o`2Ioooooooo00koool200002_oo
o`800004oooo0`0000Coool00`000?ooooooo`2>oooo001Uoooo00?o09Woooooool09oooo`80002?
oooo001Uoooo00?o09Woooooool09oooo`030000oooooooo08koool006Goool00ol0VOooooooo`0W
oooo00<0003oooooool0S_ooo`00IOooo`03o`2Ioooooooo02Ooool00`000?ooooooo`2>oooo001U
oooo00?o09Woooooool09oooo`80002?oooo001Uoooo00?o09Woooooool09oooo`030000oooooooo
08koool006Goool00ol0VOooooooo`0Woooo00<0003oooooool0S_ooo`00IOooo`03o`2Ioooooooo
02Ooool00`000?ooooooo`2>oooo001Uoooo00?o09Woooooool09oooo`80002?oooo001Uoooo00?o
09Woooooool09oooo`030000oooooooo08koool006Goool00ol0VOooooooo`0Woooo00<0003ooooo
ool0S_ooo`00IOooo`03o`2Ioooooooo02Ooool00`000?ooooooo`2>oooo001Uoooo00?o09Wooooo
ool09oooo`80002?oooo001Uoooo00?o09Woooooool09oooo`030000oooooooo08koool006Goool0
0ol0VOooooooo`0Doooo0P0000Coool200001?ooo`800005oooo00<0003oooooool0S_ooo`00IOoo
o`03o`2Ioooooooo01?oool010000?ooooooo`0000Soool010000?ooooooo`0000Coool00`000?oo
ooooo`2>oooo001Uoooo00?o09Woooooool04oooo`040000oooooooo00002oooo`030000oooooooo
00;oool30000S_ooo`00IOooo`03o`2Ioooooooo01?oool010000?ooooooo`0000Woool200001Ooo
o`030000oooooooo08koool006Goool00ol0VOooooooo`0Coooo00@0003oooooool00009oooo00<0
003oooooool01?ooo`030000oooooooo08koool006Goool00ol0VOooooooo`0Doooo0P0000[oool3
00001?ooo`030000oooooooo08koool006Goool00ol0VOooooooo`0Woooo0P0008ooool006Goool0
0ol0VOooooooo`0Woooo00<0003oooooool0S_ooo`00IOooo`03o`2Ioooooooo02Ooool00`000?oo
ooooo`2>oooo001Uoooo00?o09Woooooool09oooo`80002?oooo001Uoooo00?o09Woooooool09ooo
o`030000oooooooo08koool006Goool00ol0VOooooooo`0Woooo00<0003oooooool0S_ooo`00IOoo
o`03o`2Ioooooooo02Ooool00`000?ooooooo`2>oooo001Uoooo00?o09Woooooool09oooo`80002?
oooo001Uoooo00?o09Woooooool09oooo`030000oooooooo08koool006Goool00ol0VOooooooo`0W
oooo00<0003oooooool0S_ooo`00IOooo`03o`2Ioooooooo02Ooool00`000?ooooooo`2>oooo001U
oooo00?o09Woooooool09oooo`80002?oooo001Uoooo00?o09Woooooool09oooo`030000oooooooo
08koool006Goool00ol0VOooooooo`0>oooo0P0000Coool200001Oooo`030000oooooooo00;oool2
00001Oooo`030000oooooooo08koool006Goool00ol0VOooooooo`0=oooo00@0003oooooool0000:
oooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`2>oooo001U
oooo00?o09Woooooool03Oooo`040000oooooooo00002_ooo`030000oooooooo00Coool00`000?oo
ooooo`02oooo0`0008koool006Goool00ol0VOooooooo`0=oooo00@0003oooooool0000;oooo00@0
003oooooooooool200001Oooo`030000oooooooo08koool006Goool00ol0VOooooooo`0=oooo00@0
003oooooool00008oooo00@0003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo
08koool006Goool00ol0VOooooooo`0>oooo0P0000Woool400000oooo`<00004oooo00<0003ooooo
ool0S_ooo`00IOooo`03o`2Ioooooooo02Ooool20000Soooo`00IOooo`03o`2Ioooooooo02Ooool0
0`000?ooooooo`2>oooo001Uoooo00?o09Woooooool09oooo`030000oooooooo08koool006Goool0
0ol0VOooooooo`0Woooo00<0003oooooool0S_ooo`00IOooo`03o`2Ioooooooo02Ooool20000Sooo
o`00IOooo`03o`2Ioooooooo02Ooool00`000?ooooooo`2>oooo001Uoooo00?o09Woooooool09ooo
o`030000oooooooo08koool006Goool00ol0VOooooooo`0Woooo00<0003oooooool0S_ooo`00IOoo
o`03o`2Ioooooooo02Ooool20000Soooo`00IOooo`03o`2Ioooooooo02Ooool00`000?ooooooo`2>
oooo001Uoooo00?o09Woooooool09oooo`030000oooooooo08koool006Goool00ol0VOooooooo`0W
oooo00<0003oooooool0S_ooo`00IOooo`03o`2Ioooooooo02Ooool20000Soooo`00IOooo`03o`2I
oooooooo02Ooool00`000?ooooooo`2>oooo001Uoooo00?o09Woooooool07oooo`D00003oooo00<0
003oooooool0S_ooo`00IOooo`03o`2Ioooooooo027oool00`000?ooooooo`03oooo00<0003ooooo
ool0S_ooo`00IOooo`03o`2Ioooooooo027oool00`000?ooooooo`03oooo0`0008koool008Woool0
0`000?ooooooo`2Doooo0029oooo00<0003oooooool0U?ooo`00R?ooo`80002Foooo003ooooo8Ooo
o`00ooooob7oool007Koool00`000?ooooooo`0^oooo00<0003oooooool0M_ooo`00MOooo`030000
oooooooo00Soool00`000?ooooooo`0Uoooo00<0003oooooool0MOooo`00MOooo`030000oooooooo
00;oool200001?ooo`030000oooooooo00goool200001?ooo`800004oooo0P0000Coool200001?oo
o`030000oooooooo07Goool007Goool01@000?ooooooooooo`000002oooo00<0003oooooool00_oo
o`030000oooooooo00Coool400000oooo`040000oooooooo00002?ooo`040000oooooooo00000_oo
o`040000oooooooo00000oooo`030000oooooooo07Goool007Coool00`000?ooooooo`02oooo00<0
003oooooool04oooo`040000oooooooo00002?ooo`040000oooooooo00001Oooo`030000oooooooo
00;oool00`000?ooooooo`1doooo001eoooo00<0003oooooool01@0001;oool010000?ooooooo`00
00Soool010000?ooooooo`0000?oool200001?ooo`030000oooooooo07Goool007Goool01@000?oo
ooooooooo`00000Eoooo00@0003oooooool00008oooo00@0003oooooool00003oooo00<0003ooooo
ool00oooo`030000oooooooo07Goool007Koool00`000?ooooooo`0Goooo0P0000[oool200001?oo
o`<00002oooo00<0003oooooool0M_ooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -54.125 0 ]
[.5 .63053 54.125 13.375 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -115.125 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.375 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 13.625 moveto
(8) show
69.000 13.625 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 13.625 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 13.625 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 13.625 moveto
(,) show
84.563 13.625 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.22045) show
128.375 13.625 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(\\264) show
136.188 13.625 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
148.188 9.438 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
152.375 9.438 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(16) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
161.250 13.625 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.28158 .30902 L
.30316 .30902 L
.31323 .30902 L
.32392 .30902 L
.33304 .30902 L
.33554 .30902 L
.33823 .30902 L
.33953 .30902 L
.34076 .30902 L
s
.34076 .30902 m
.34087 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -54.125 0 ]
[.5 .63053 54.125 13.375 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -115.125 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 21.375 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 13.625 moveto
(8) show
69.000 13.625 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 13.625 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 13.625 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 13.625 moveto
(,) show
84.563 13.625 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.22045) show
128.375 13.625 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(\\264) show
136.188 13.625 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(10) show
148.188 9.438 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
152.375 9.438 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(16) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
161.250 13.625 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo0P0008ooool001Woool200009Ooo
o`@0000Toooo1@0002;oool00`000?ooooooo`0Soooo1@0002?oool400009Oooo`80000Hoooo000H
oooo00@0003oooooool0000Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Goool010000?ooooooo`0001Ooool0
01[oool00`000?ooooooo`0Toooo00<0003oooooool09_ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Koool00`000?ooooooo`0Foooo000B
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Moooo100000Coool0
0`000?ooooooo`0Roooo0P0002Koool00`000?ooooooo`0Uoooo00<0003oooooool09_ooo`030000
oooooooo01Goool001Soool010000?ooooooo`0002Coool010000?ooooooo`0002Koool00`000?oo
ooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02?oool010000?ooooooo`0002Coool0
10000?ooooooo`0001Ooool001Woool200009_ooo`80000Voooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009_ooo`80000Hoooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000Aooooo@0001;oool001Ooool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`0Foooo000Goooo00<0003ooooo
ool09Oooo`030000oooooooo02Goool00`000?ooooooo`0Uoooo00<0003oooooool09Oooo`030000
oooooooo02Goool00`000?ooooooo`0Uoooo00<0003oooooool05_ooo`00Ioooo`03o`2Ioooooooo
02Goool00`000?ooooooo`2>oooo001Woooo00?o09Woooooool09Oooo`80002?oooo001Woooo00?o
09Woooooool09Oooo`030000oooooooo08koool006Ooool00ol0VOooooooo`0Uoooo00<0003ooooo
ool0S_ooo`00Ioooo`03o`2Ioooooooo02Goool00`000?ooooooo`2>oooo001Woooo00?o09Wooooo
ool09Oooo`80002?oooo001Woooo00?o09Woooooool09Oooo`030000oooooooo08koool006Ooool0
0ol0VOooooooo`0Uoooo00<0003oooooool0S_ooo`00Ioooo`03o`2Ioooooooo02Goool00`000?oo
ooooo`2>oooo001Woooo00?o09Woooooool09Oooo`80002?oooo001Woooo00?o09Woooooool09Ooo
o`030000oooooooo08koool006Ooool00ol0VOooooooo`0Uoooo00<0003oooooool0S_ooo`00Iooo
o`03o`2Ioooooooo02Goool00`000?ooooooo`2>oooo001Woooo00?o09Woooooool09Oooo`80002?
oooo001Woooo00?o09Woooooool09Oooo`030000oooooooo08koool006Ooool00ol0VOooooooo`0<
oooo0P0000Coool200000oooo`@00003oooo0P0000Goool00`000?ooooooo`2>oooo001Woooo00?o
09Woooooool02oooo`040000oooooooo00002?ooo`030000oooooooo00?oool010000?ooooooo`00
00Coool00`000?ooooooo`2>oooo001Woooo00?o09Woooooool02oooo`040000oooooooo00002Ooo
o`030000oooooooo00Goool00`000?ooooooo`02oooo0`0008koool006Ooool00ol0VOooooooo`0;
oooo00@0003oooooool0000:oooo00<0003oooooool00_ooo`800005oooo00<0003oooooool0S_oo
o`00Ioooo`03o`2Ioooooooo00_oool010000?ooooooo`0000Soool010000?ooooooo`0000?oool0
0`000?ooooooo`04oooo00<0003oooooool0S_ooo`00Ioooo`03o`2Ioooooooo00coool200002_oo
o`800004oooo0`0000Coool20000Soooo`00Ioooo`03o`2Ioooooooo02Goool00`000?ooooooo`2>
oooo001Woooo00?o09Woooooool09Oooo`030000oooooooo08koool006Ooool00ol0VOooooooo`0U
oooo00<0003oooooool0S_ooo`00Ioooo`03o`2Ioooooooo02Goool20000Soooo`00Ioooo`03o`2I
oooooooo02Goool00`000?ooooooo`2>oooo001Woooo00?o09Woooooool09Oooo`030000oooooooo
08koool006Ooool00ol0VOooooooo`0Uoooo00<0003oooooool0S_ooo`00Ioooo`03o`2Ioooooooo
02Goool20000Soooo`00Ioooo`03o`2Ioooooooo02Goool00`000?ooooooo`2>oooo001Woooo00?o
09Woooooool09Oooo`030000oooooooo08koool006Ooool00ol0VOooooooo`0Uoooo00<0003ooooo
ool0S_ooo`00Ioooo`03o`2Ioooooooo02Goool20000Soooo`00Ioooo`03o`2Ioooooooo02Goool0
0`000?ooooooo`2>oooo001Woooo00?o09Woooooool04_ooo`800004oooo0P0000Coool200001Ooo
o`030000oooooooo08koool006Ooool00ol0VOooooooo`0Aoooo00@0003oooooool00008oooo00@0
003oooooool00004oooo00<0003oooooool0S_ooo`00Ioooo`03o`2Ioooooooo017oool010000?oo
ooooo`0000_oool00`000?ooooooo`02oooo0`0008koool006Ooool00ol0VOooooooo`0Aoooo00@0
003oooooool00009oooo0P0000Goool00`000?ooooooo`2>oooo001Woooo00?o09Woooooool04Ooo
o`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001Woooo00?o
09Woooooool04_ooo`80000:oooo0`0000Coool00`000?ooooooo`2>oooo001Woooo00?o09Wooooo
ool09Oooo`80002?oooo001Woooo00?o09Woooooool09Oooo`030000oooooooo08koool006Ooool0
0ol0VOooooooo`0Uoooo00<0003oooooool0S_ooo`00Ioooo`03o`2Ioooooooo02Goool00`000?oo
ooooo`2>oooo001Woooo00?o09Woooooool09Oooo`80002?oooo001Woooo00?o09Woooooool09Ooo
o`030000oooooooo08koool006Ooool00ol0VOooooooo`0Uoooo00<0003oooooool0S_ooo`00Iooo
o`03o`2Ioooooooo02Goool00`000?ooooooo`2>oooo001Woooo00?o09Woooooool09Oooo`80002?
oooo001Woooo00?o09Woooooool09Oooo`030000oooooooo08koool006Ooool00ol0VOooooooo`0U
oooo00<0003oooooool0S_ooo`00Ioooo`03o`2Ioooooooo02Goool00`000?ooooooo`2>oooo001W
oooo00?o09Woooooool09Oooo`80002?oooo001Woooo00?o09Woooooool03?ooo`800004oooo0P00
00Goool00`000?ooooooo`02oooo0P0000Goool00`000?ooooooo`2>oooo001Woooo00?o09Wooooo
ool02oooo`040000oooooooo00002_ooo`050000oooooooooooo000000;oool00`000?ooooooo`02
oooo00<0003oooooool0S_ooo`00Ioooo`03o`2Ioooooooo00_oool010000?ooooooo`0000[oool0
0`000?ooooooo`04oooo00<0003oooooool00_ooo`<0002>oooo001Woooo00?o09Woooooool02ooo
o`040000oooooooo00002oooo`040000oooooooooooo0P0000Goool00`000?ooooooo`2>oooo001W
oooo00?o09Woooooool02oooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000
oooooooo00Coool00`000?ooooooo`2>oooo001Woooo00?o09Woooooool03?ooo`800009oooo1000
00?oool300001?ooo`030000oooooooo08koool006Ooool00ol0VOooooooo`0Uoooo0P0008ooool0
06Ooool00ol0VOooooooo`0Uoooo00<0003oooooool0S_ooo`00Ioooo`03o`2Ioooooooo02Goool0
0`000?ooooooo`2>oooo001Woooo00?o09Woooooool09Oooo`030000oooooooo08koool006Ooool0
0ol0VOooooooo`0Uoooo0P0008ooool006Ooool00ol0VOooooooo`0Uoooo00<0003oooooool0S_oo
o`00Ioooo`03o`2Ioooooooo02Goool00`000?ooooooo`2>oooo001Woooo00?o09Woooooool09Ooo
o`030000oooooooo08koool006Ooool00ol0VOooooooo`0Uoooo0P0008ooool006Ooool00ol0VOoo
ooooo`0Uoooo00<0003oooooool0S_ooo`00Ioooo`03o`2Ioooooooo02Goool00`000?ooooooo`2>
oooo001Woooo00?o09Woooooool09Oooo`030000oooooooo08koool006Ooool00ol0VOooooooo`0U
oooo0P0008ooool006Ooool00ol0VOooooooo`0Uoooo00<0003oooooool0S_ooo`00Ioooo`03o`2I
oooooooo01goool500000oooo`030000oooooooo08koool006Ooool00ol0VOooooooo`0Ooooo00<0
003oooooool00oooo`030000oooooooo08koool006Ooool00ol0VOooooooo`0Ooooo00<0003ooooo
ool00oooo`<0002>oooo0029oooo00<0003oooooool0U?ooo`00ROooo`030000oooooooo09Coool0
08Soool20000U_ooo`00ooooob7oool00?oooolQoooo001Ooooo00<0003oooooool0G?ooo`030000
oooooooo05ooool005koool00`000?ooooooo`08oooo00<0003oooooool0Doooo`030000oooooooo
05koool005koool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`05oooo100000?oool2
00000oooo`@00002oooo100000?oool200001Oooo`<00002oooo0P0000Goool01@000?oooooooooo
o`000003oooo1@0000;oool200004Oooo`030000oooooooo05koool005koool01@000?oooooooooo
o`000002oooo00<0003oooooool00_ooo`030000oooooooo00Coool00`000?ooooooo`09oooo00<0
003oooooool00oooo`030000oooooooo00?oool010000?ooooooo`0000Goool010000?ooooooo`00
00;oool00`000?ooooooo`03oooo00<0003oool000001_ooo`050000oooooooooooo000000;oool0
0`000?ooooooo`0>oooo00<0003oooooool0G_ooo`00GOooo`030000oooooooo00;oool00`000?oo
ooooo`0=oooo00<0003oooooool02Oooo`030000oooooooo00?oool00`000?ooooooo`02oooo00@0
003oooooool00002oooo1@0000Coool00`000?ooooooo`04oooo00<0003oooooool01Oooo`050000
oooooooooooo000000;oool00`000?ooooooo`0?oooo00<0003oooooool0GOooo`00G_ooo`030000
oooooooo00D0000=oooo00<0003oooooool02Oooo`030000oooooooo00?oool01@000?oooooooooo
o`000002oooo00@0003oooooool00002oooo00@0003oooooooooool200001_ooo`030000oooo0000
00Koool01@000?ooooooooooo`000002oooo00<0003oooooool03_ooo`030000oooooooo05koool0
05koool01@000?ooooooooooo`00000>oooo00@0003oooooool00008oooo00@0003oooooool00002
oooo00@0003oooooool00002oooo00@0003oooooool00003oooo00<0003oool000000oooo`030000
oooooooo00Coool01@000?ooooooooooo`000005oooo00D0003oooooooooool000000_ooo`030000
oooooooo00Coool200000_ooo`<00003oooo00<0003oooooool0G_ooo`00Goooo`030000oooooooo
013oool200002_ooo`800004oooo0P0000Coool200001Oooo`800003oooo0`0000goool200001?oo
o`800003oooo0`0000;oool01P000?ooooooo`000?ooo`0000;oool00`000?ooooooo`1Ooooo002f
oooo00<0003oooooool00P0006Goool00;Goool200000_ooo`<0001Toooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.58295, \
-1.05774, 0.0249737, 0.012828}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.58295, -1.05774, 0.0249737, 0.012828}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.05) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.32392 .30902 L
.33304 .30902 L
.33788 .30902 L
.34309 .30902 L
.34566 .30902 L
.34693 .30902 L
.34811 .30902 L
.34918 .30902 L
s
.34918 .30902 m
.34929 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.05) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Koool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003ooooo09T01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`0Eoooo000Foooo00<0003ooooo
ool09Oooo`030000oooooooo02Koool00`000?ooool0V@0Uoooo00<0003oooooool09Oooo`030000
oooooooo02Goool00`000?ooooooo`0Voooo00<0003oooooool05Oooo`00JOooo`03o`2Ioooooooo
02?oool00`000?ooooooo`2>oooo001Yoooo00?o09Woooooool08oooo`80002?oooo001Yoooo00?o
09Woooooool08oooo`030000oooooooo08koool006Woool00ol0VOooooooo`0Soooo00<0003ooooo
ool0S_ooo`00JOooo`03o`2Ioooooooo02?oool00`000?ooooooo`2>oooo001Yoooo00?o09Wooooo
ool08oooo`80002?oooo001Yoooo00?o09Woooooool08oooo`030000oooooooo08koool006Woool0
0ol0VOooooooo`0Soooo00<0003oooooool0S_ooo`00JOooo`03o`2Ioooooooo02?oool00`000?oo
ooooo`2>oooo001Yoooo00?o09Woooooool08oooo`80002?oooo001Yoooo00?o09Woooooool08ooo
o`030000oooooooo08koool006Woool00ol0VOooooooo`0Soooo00<0003oooooool0S_ooo`00JOoo
o`03o`2Ioooooooo02?oool00`000?ooooooo`2>oooo001Yoooo00?o09Woooooool08oooo`80002?
oooo001Yoooo00?o09Woooooool08oooo`030000oooooooo08koool006Woool00ol0VOooooooo`0:
oooo0P0000Coool200000oooo`@00003oooo0P0000Goool00`000?ooooooo`2>oooo001Yoooo00?o
09Woooooool02Oooo`040000oooooooo00002?ooo`030000oooooooo00?oool010000?ooooooo`00
00Coool00`000?ooooooo`2>oooo001Yoooo00?o09Woooooool02Oooo`040000oooooooo00002Ooo
o`030000oooooooo00Goool00`000?ooooooo`02oooo0`0008koool006Woool00ol0VOooooooo`09
oooo00@0003oooooool0000:oooo00<0003oooooool00_ooo`800005oooo00<0003oooooool0S_oo
o`00JOooo`03o`2Ioooooooo00Woool010000?ooooooo`0000Soool010000?ooooooo`0000?oool0
0`000?ooooooo`04oooo00<0003oooooool0S_ooo`00JOooo`03o`2Ioooooooo00[oool200002_oo
o`800004oooo0`0000Coool00`000?ooooooo`2>oooo001Yoooo00?o09Woooooool08oooo`80002?
oooo001Yoooo00?o09Woooooool08oooo`030000oooooooo08koool006Woool00ol0VOooooooo`0S
oooo00<0003oooooool0S_ooo`00JOooo`03o`2Ioooooooo02?oool00`000?ooooooo`2>oooo001Y
oooo00?o09Woooooool08oooo`80002?oooo001Yoooo00?o09Woooooool08oooo`030000oooooooo
08koool006Woool00ol0VOooooooo`0Soooo00<0003oooooool0S_ooo`00JOooo`03o`2Ioooooooo
02?oool00`000?ooooooo`2>oooo001Yoooo00?o09Woooooool08oooo`80002?oooo001Yoooo00?o
09Woooooool08oooo`030000oooooooo08koool006Woool00ol0VOooooooo`0Soooo00<0003ooooo
ool0S_ooo`00JOooo`03o`2Ioooooooo02?oool00`000?ooooooo`2>oooo001Yoooo00?o09Wooooo
ool08oooo`80002?oooo001Yoooo00?o09Woooooool08oooo`030000oooooooo08koool006Woool0
0ol0VOooooooo`0@oooo0P0000Coool200001?ooo`800005oooo00<0003oooooool0S_ooo`00JOoo
o`03o`2Ioooooooo00ooool010000?ooooooo`0000Soool010000?ooooooo`0000Coool00`000?oo
ooooo`2>oooo001Yoooo00?o09Woooooool03oooo`040000oooooooo00002oooo`030000oooooooo
00;oool30000S_ooo`00JOooo`03o`2Ioooooooo00ooool010000?ooooooo`0000Woool200001Ooo
o`030000oooooooo08koool006Woool00ol0VOooooooo`0?oooo00@0003oooooool00009oooo00<0
003oooooool01?ooo`030000oooooooo08koool006Woool00ol0VOooooooo`0@oooo0P0000[oool3
00001?ooo`030000oooooooo08koool006Woool00ol0VOooooooo`0Soooo0P0008ooool006Woool0
0ol0VOooooooo`0Soooo00<0003oooooool0S_ooo`00JOooo`03o`2Ioooooooo02?oool00`000?oo
ooooo`2>oooo001Yoooo00?o09Woooooool08oooo`80002?oooo001Yoooo00?o09Woooooool08ooo
o`030000oooooooo08koool006Woool00ol0VOooooooo`0Soooo00<0003oooooool0S_ooo`00JOoo
o`03o`2Ioooooooo02?oool00`000?ooooooo`2>oooo001Yoooo00?o09Woooooool08oooo`80002?
oooo001Yoooo00?o09Woooooool08oooo`030000oooooooo08koool006Woool00ol0VOooooooo`0S
oooo00<0003oooooool0S_ooo`00JOooo`03o`2Ioooooooo02?oool00`000?ooooooo`2>oooo001Y
oooo00?o09Woooooool08oooo`80002?oooo001Yoooo00?o09Woooooool08oooo`030000oooooooo
08koool006Woool00ol0VOooooooo`0:oooo0P0000Coool200001Oooo`030000oooooooo00;oool2
00001Oooo`030000oooooooo08koool006Woool00ol0VOooooooo`09oooo00@0003oooooool0000:
oooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`2>oooo001Y
oooo00?o09Woooooool02Oooo`040000oooooooo00002_ooo`030000oooooooo00Coool00`000?oo
ooooo`02oooo0`0008koool006Woool00ol0VOooooooo`09oooo00@0003oooooool0000;oooo00@0
003oooooooooool200001Oooo`030000oooooooo08koool006Woool00ol0VOooooooo`09oooo00@0
003oooooool00008oooo00@0003oooooool00003oooo00<0003oooooool01?ooo`030000oooooooo
08koool006Woool00ol0VOooooooo`0:oooo0P0000Woool400000oooo`<00004oooo00<0003ooooo
ool0S_ooo`00JOooo`03o`2Ioooooooo02?oool20000Soooo`00JOooo`03o`2Ioooooooo02?oool0
0`000?ooooooo`2>oooo001Yoooo00?o09Woooooool08oooo`030000oooooooo08koool006Woool0
0ol0VOooooooo`0Soooo00<0003oooooool0S_ooo`00JOooo`03o`2Ioooooooo02?oool20000Sooo
o`00JOooo`03o`2Ioooooooo02?oool00`000?ooooooo`2>oooo001Yoooo00?o09Woooooool08ooo
o`030000oooooooo08koool006Woool00ol0VOooooooo`0Soooo00<0003oooooool0S_ooo`00JOoo
o`03o`2Ioooooooo02?oool20000Soooo`00JOooo`03o`2Ioooooooo02?oool00`000?ooooooo`2>
oooo001Yoooo00?o09Woooooool08oooo`030000oooooooo08koool006Woool00ol0VOooooooo`0S
oooo00<0003oooooool0S_ooo`00JOooo`03o`2Ioooooooo02?oool20000Soooo`00JOooo`03o`2I
oooooooo02?oool00`000?ooooooo`2>oooo001Yoooo00?o09Woooooool06oooo`D00003oooo00<0
003oooooool0S_ooo`00JOooo`03o`2Ioooooooo01goool00`000?ooooooo`03oooo00<0003ooooo
ool0S_ooo`00JOooo`03o`2Ioooooooo01goool00`000?ooooooo`03oooo0`0008koool008Woool0
0`000?ooooooo`2Doooo0029oooo00<0003oooooool0U?ooo`00R?ooo`80002Foooo003ooooo8Ooo
o`00ooooob7oool007Woool00`000?ooooooo`0Xoooo00<0003oooooool0NOooo`00N?ooo`030000
oooooooo00Soool00`000?ooooooo`0Ooooo00<0003oooooool0N?ooo`00N?ooo`030000oooooooo
00;oool200001?ooo`030000oooooooo00Ooool200001?ooo`800004oooo0P0000Coool200001?oo
o`030000oooooooo07Soool007Soool01@000?ooooooooooo`000002oooo00<0003oooooool00_oo
o`030000oooooooo00Goool010000?ooooooo`0000Soool010000?ooooooo`0000;oool010000?oo
ooooo`0000?oool00`000?ooooooo`1hoooo001goooo00<0003oooooool00_ooo`030000oooooooo
00goool010000?ooooooo`0000Soool010000?ooooooo`0000Goool00`000?ooooooo`02oooo00<0
003oooooool0Moooo`00N?ooo`030000oooooooo00D0000<oooo00@0003oooooool00008oooo00@0
003oooooool00003oooo0P0000Coool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool0
00003oooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo00?oool0
0`000?ooooooo`1hoooo001ioooo00<0003oooooool04Oooo`80000:oooo0P0000Coool300000_oo
o`030000oooooooo07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
.2 1 0 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
.97619 .30902 L
.02381 .30902 L
F
0 g
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
1 0 .6 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.32392 .30902 L
.33304 .30902 L
.34309 .30902 L
.34772 .30902 L
.35028 .30902 L
.35271 .30902 L
.35496 .30902 L
.35624 .30902 L
s
.35624 .30902 m
.35636 .61803 L
s
0 .4 1 r
.02381 .30902 m
.06244 .30902 L
.10458 .30902 L
.14415 .30902 L
.18221 .30902 L
.22272 .30902 L
.26171 .30902 L
.30316 .30902 L
.34309 .30902 L
.3815 .30902 L
.42237 .30902 L
.46172 .30902 L
.49955 .30902 L
.53984 .30902 L
.57861 .30902 L
.61984 .30902 L
.65954 .30902 L
.69774 .30902 L
.73838 .30902 L
.77751 .30902 L
.81909 .30902 L
.85916 .30902 L
.89771 .30902 L
.93871 .30902 L
.97619 .30902 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[(0.5)] .4875 .46353 1 0 Mshowa
.5 .54078 m
.50625 .54078 L
s
[(0.75)] .4875 .54078 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(1)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .01545 m
.50375 .01545 L
s
.5 .0309 m
.50375 .0309 L
s
.5 .04635 m
.50375 .04635 L
s
.5 .0618 m
.50375 .0618 L
s
.5 .09271 m
.50375 .09271 L
s
.5 .10816 m
.50375 .10816 L
s
.5 .12361 m
.50375 .12361 L
s
.5 .13906 m
.50375 .13906 L
s
.5 .16996 m
.50375 .16996 L
s
.5 .18541 m
.50375 .18541 L
s
.5 .20086 m
.50375 .20086 L
s
.5 .21631 m
.50375 .21631 L
s
.5 .24721 m
.50375 .24721 L
s
.5 .26266 m
.50375 .26266 L
s
.5 .27812 m
.50375 .27812 L
s
.5 .29357 m
.50375 .29357 L
s
.5 .32447 m
.50375 .32447 L
s
.5 .33992 m
.50375 .33992 L
s
.5 .35537 m
.50375 .35537 L
s
.5 .37082 m
.50375 .37082 L
s
.5 .40172 m
.50375 .40172 L
s
.5 .41717 m
.50375 .41717 L
s
.5 .43262 m
.50375 .43262 L
s
.5 .44807 m
.50375 .44807 L
s
.5 .47898 m
.50375 .47898 L
s
.5 .49443 m
.50375 .49443 L
s
.5 .50988 m
.50375 .50988 L
s
.5 .52533 m
.50375 .52533 L
s
.5 .55623 m
.50375 .55623 L
s
.5 .57168 m
.50375 .57168 L
s
.5 .58713 m
.50375 .58713 L
s
.5 .60258 m
.50375 .60258 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0003ooooo
ool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001foooo0P0000Coool2
00001Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?oo
ooooo`0000[oool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
08koool007Goool010000?ooooooo`0000[oool00`000?ooooooo`04oooo00<0003oooooool00_oo
o`<0002>oooo001_oooo100000;oool010000?ooooooo`0000_oool010000?ooooooooooo`800005
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo00Coool00`000?ooooooo`2>oooo001foooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo0P0008ooool008ooool00`000?ooooooo`2>oooo001loooo0P0000Coool200001?ooo`800005
oooo00<0003oooooool0S_ooo`00Noooo`040000oooooooo00002?ooo`040000oooooooo00001?oo
o`030000oooooooo08koool007_oool010000?ooooooo`0000_oool00`000?ooooooo`02oooo0`00
08koool007Goool400000_ooo`040000oooooooo00002Oooo`800005oooo00<0003oooooool0S_oo
o`00Noooo`040000oooooooo00002Oooo`030000oooooooo00Coool00`000?ooooooo`2>oooo001l
oooo0P0000[oool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`80002?oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool0
0`000?ooooooo`2>oooo002?oooo0P0008ooool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool007Koool200001?ooo`800003oooo100000?oool200001Oooo`030000oooooooo
08koool007Goool010000?ooooooo`0000Soool00`000?ooooooo`03oooo00@0003oooooool00004
oooo00<0003oooooool0S_ooo`00MOooo`040000oooooooo00002Oooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo0`0008koool006ooool400000_ooo`040000oooooooo00002_ooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool007Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00M_ooo`80000:
oooo0P0000Coool300001?ooo`030000oooooooo08koool008ooool20000Soooo`00Soooo`030000
oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`006?oo
o`80000Uoooo100002Goool500008_ooo`80000Toooo1@0002?oool400009_ooo`80000Goooo000G
oooo00@0003oooooool0000Toooo00<0003oooooool0:?ooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`030000oooooooo02Koool010000?ooooooo`0001Koool0
01Woool00`000?ooooooo`0Toooo00<0003oooooool09oooo`030000oooooooo02;oool00`000?oo
ooooo`0Uoooo00<0003oooooool09?ooo`030000oooooooo02Ooool00`000?ooooooo`0Eoooo000A
oooo100000Goool00`000?ooooooo`0Loooo100000Coool00`000?ooooooo`0Noooo100000Coool0
0`000?ooooooo`0Roooo00<0003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0W
oooo00<0003oooooool05?ooo`005oooo`040000oooooooo00009?ooo`040000oooooooo00009ooo
o`030000oooooooo02;oool200009_ooo`030000oooooooo02?oool010000?ooooooo`0002Goool0
10000?ooooooo`0001Koool001Soool200009_ooo`80000Woooo0P0002Coool00`000?ooooooo`0T
oooo0P0002Koool200009oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`80002?
oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?oo
ooooo`2>oooo000@ooooo`00017oool001Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Koool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00D0003ooooooooooooo09T00oooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool0
0`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`0Eoooo000Foooo00<0
003oooooool09Oooo`030000oooooooo02Koool01@000?ooooooooooool0V@0Soooo00<0003ooooo
ool09Oooo`030000oooooooo02Goool00`000?ooooooo`0Voooo00<0003oooooool05Oooo`00Jooo
o`03o`2Ioooooooo027oool00`000?ooooooo`2>oooo001[oooo00?o09Woooooool08Oooo`80002?
oooo001[oooo00?o09Woooooool08Oooo`030000oooooooo08koool006_oool00ol0VOooooooo`0Q
oooo00<0003oooooool0S_ooo`00Joooo`03o`2Ioooooooo027oool00`000?ooooooo`2>oooo001[
oooo00?o09Woooooool08Oooo`80002?oooo001[oooo00?o09Woooooool08Oooo`030000oooooooo
08koool006_oool00ol0VOooooooo`0Qoooo00<0003oooooool0S_ooo`00Joooo`03o`2Ioooooooo
027oool00`000?ooooooo`2>oooo001[oooo00?o09Woooooool08Oooo`80002?oooo001[oooo00?o
09Woooooool08Oooo`030000oooooooo08koool006_oool00ol0VOooooooo`0Qoooo00<0003ooooo
ool0S_ooo`00Joooo`03o`2Ioooooooo027oool00`000?ooooooo`2>oooo001[oooo00?o09Wooooo
ool08Oooo`80002?oooo001[oooo00?o09Woooooool08Oooo`030000oooooooo08koool006_oool0
0ol0VOooooooo`08oooo0P0000Coool200000oooo`@00003oooo0P0000Goool00`000?ooooooo`2>
oooo001[oooo00?o09Woooooool01oooo`040000oooooooo00002?ooo`030000oooooooo00?oool0
10000?ooooooo`0000Coool00`000?ooooooo`2>oooo001[oooo00?o09Woooooool01oooo`040000
oooooooo00002Oooo`030000oooooooo00Goool00`000?ooooooo`02oooo0`0008koool006_oool0
0ol0VOooooooo`07oooo00@0003oooooool0000:oooo00<0003oooooool00_ooo`800005oooo00<0
003oooooool0S_ooo`00Joooo`03o`2Ioooooooo00Ooool010000?ooooooo`0000Soool010000?oo
ooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0S_ooo`00Joooo`03o`2Ioooooooo
00Soool200002_ooo`800004oooo0`0000Coool00`000?ooooooo`2>oooo001[oooo00?o09Wooooo
ool08Oooo`80002?oooo001[oooo00?o09Woooooool08Oooo`030000oooooooo08koool006_oool0
0ol0VOooooooo`0Qoooo00<0003oooooool0S_ooo`00Joooo`03o`2Ioooooooo027oool00`000?oo
ooooo`2>oooo001[oooo00?o09Woooooool08Oooo`80002?oooo001[oooo00?o09Woooooool08Ooo
o`030000oooooooo08koool006_oool00ol0VOooooooo`0Qoooo00<0003oooooool0S_ooo`00Jooo
o`03o`2Ioooooooo027oool00`000?ooooooo`2>oooo001[oooo00?o09Woooooool08Oooo`80002?
oooo001[oooo00?o09Woooooool08Oooo`030000oooooooo08koool006_oool00ol0VOooooooo`0Q
oooo00<0003oooooool0S_ooo`00Joooo`03o`2Ioooooooo027oool00`000?ooooooo`2>oooo001[
oooo00?o09Woooooool08Oooo`80002?oooo001[oooo00?o09Woooooool08Oooo`030000oooooooo
08koool006_oool00ol0VOooooooo`0>oooo0P0000Coool200001?ooo`800005oooo00<0003ooooo
ool0S_ooo`00Joooo`03o`2Ioooooooo00goool010000?ooooooo`0000Soool010000?ooooooo`00
00Coool00`000?ooooooo`2>oooo001[oooo00?o09Woooooool03Oooo`040000oooooooo00002ooo
o`030000oooooooo00;oool30000S_ooo`00Joooo`03o`2Ioooooooo00goool010000?ooooooo`00
00Woool200001Oooo`030000oooooooo08koool006_oool00ol0VOooooooo`0=oooo00@0003ooooo
ool00009oooo00<0003oooooool01?ooo`030000oooooooo08koool006_oool00ol0VOooooooo`0>
oooo0P0000[oool300001?ooo`030000oooooooo08koool006_oool00ol0VOooooooo`0Qoooo0P00
08ooool006_oool00ol0VOooooooo`0Qoooo00<0003oooooool0S_ooo`00Joooo`03o`2Ioooooooo
027oool00`000?ooooooo`2>oooo001[oooo00?o09Woooooool08Oooo`80002?oooo001[oooo00?o
09Woooooool08Oooo`030000oooooooo08koool006_oool00ol0VOooooooo`0Qoooo00<0003ooooo
ool0S_ooo`00Joooo`03o`2Ioooooooo027oool00`000?ooooooo`2>oooo001[oooo00?o09Wooooo
ool08Oooo`80002?oooo001[oooo00?o09Woooooool08Oooo`030000oooooooo08koool006_oool0
0ol0VOooooooo`0Qoooo00<0003oooooool0S_ooo`00Joooo`03o`2Ioooooooo027oool00`000?oo
ooooo`2>oooo001[oooo00?o09Woooooool08Oooo`80002?oooo001[oooo00?o09Woooooool08Ooo
o`030000oooooooo08koool006_oool00ol0VOooooooo`08oooo0P0000Coool200001Oooo`030000
oooooooo00;oool200001Oooo`030000oooooooo08koool006_oool00ol0VOooooooo`07oooo00@0
003oooooool0000:oooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?oo
ooooo`2>oooo001[oooo00?o09Woooooool01oooo`040000oooooooo00002_ooo`030000oooooooo
00Coool00`000?ooooooo`02oooo0`0008koool006_oool00ol0VOooooooo`07oooo00@0003ooooo
ool0000;oooo00@0003oooooooooool200001Oooo`030000oooooooo08koool006_oool00ol0VOoo
ooooo`07oooo00@0003oooooool00008oooo00@0003oooooool00003oooo00<0003oooooool01?oo
o`030000oooooooo08koool006_oool00ol0VOooooooo`08oooo0P0000Woool400000oooo`<00004
oooo00<0003oooooool0S_ooo`00Joooo`03o`2Ioooooooo027oool20000Soooo`00Joooo`03o`2I
oooooooo027oool00`000?ooooooo`2>oooo001[oooo00?o09Woooooool08Oooo`030000oooooooo
08koool006_oool00ol0VOooooooo`0Qoooo00<0003oooooool0S_ooo`00Joooo`03o`2Ioooooooo
027oool20000Soooo`00Joooo`03o`2Ioooooooo027oool00`000?ooooooo`2>oooo001[oooo00?o
09Woooooool08Oooo`030000oooooooo08koool006_oool00ol0VOooooooo`0Qoooo00<0003ooooo
ool0S_ooo`00Joooo`03o`2Ioooooooo027oool20000Soooo`00Joooo`03o`2Ioooooooo027oool0
0`000?ooooooo`2>oooo001[oooo00?o09Woooooool08Oooo`030000oooooooo08koool006_oool0
0ol0VOooooooo`0Qoooo00<0003oooooool0S_ooo`00Joooo`03o`2Ioooooooo027oool20000Sooo
o`00Joooo`03o`2Ioooooooo027oool00`000?ooooooo`2>oooo001[oooo00?o09Woooooool06Ooo
o`D00003oooo00<0003oooooool0S_ooo`00Joooo`03o`2Ioooooooo01_oool00`000?ooooooo`03
oooo00<0003oooooool0S_ooo`00Joooo`03o`2Ioooooooo01_oool00`000?ooooooo`03oooo0`00
08koool008Woool00`000?ooooooo`2Doooo0029oooo00<0003oooooool0U?ooo`00R?ooo`80002F
oooo003ooooo8Oooo`00ooooob7oool007coool00`000?ooooooo`0Roooo00<0003oooooool0O?oo
o`00Noooo`030000oooooooo00Soool00`000?ooooooo`0Ioooo00<0003oooooool0Noooo`00Nooo
o`030000oooooooo00;oool200001?ooo`030000oooooooo00Ooool200001?ooo`800003oooo1@00
00;oool00`000?ooooooo`1koooo001koooo00D0003oooooooooool000000_ooo`030000oooooooo
00;oool00`000?ooooooo`05oooo00@0003oooooool0000:oooo00<0003oooooool00_ooo`030000
oooooooo07_oool007[oool00`000?ooooooo`02oooo00<0003oooooool03Oooo`040000oooooooo
00002_ooo`030000oooooooo00?oool00`000?ooooooo`1joooo001koooo00<0003oooooool01@00
00coool010000?ooooooo`0000[oool00`000?ooooooo`02oooo00<0003oooooool0Noooo`00Nooo
o`050000oooooooooooo000000ooool010000?ooooooo`0000[oool00`000?ooooooo`02oooo00<0
003oooooool0Noooo`00O?ooo`030000oooooooo017oool200002_ooo`800003oooo00<0003ooooo
ool0O?ooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-3.56474, \
-1.05744, 0.0248468, 0.0127628}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-3.56474, -1.05744, 0.0248468, 0.0127628}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.309017 0.309017 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.18254 .29652 -6 -9 ]
[.18254 .29652 6 0 ]
[.34127 .29652 -6 -9 ]
[.34127 .29652 6 0 ]
[.65873 .29652 -3 -9 ]
[.65873 .29652 3 0 ]
[.81746 .29652 -3 -9 ]
[.81746 .29652 3 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .07725 -30 -4.5 ]
[.4875 .07725 0 4.5 ]
[.4875 .15451 -24 -4.5 ]
[.4875 .15451 0 4.5 ]
[.4875 .23176 -30 -4.5 ]
[.4875 .23176 0 4.5 ]
[.4875 .38627 -24 -4.5 ]
[.4875 .38627 0 4.5 ]
[.4875 .46353 -18 -4.5 ]
[.4875 .46353 0 4.5 ]
[.4875 .54078 -24 -4.5 ]
[.4875 .54078 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-3)] .02381 .29652 0 1 Mshowa
.18254 .30902 m
.18254 .31527 L
s
[(-2)] .18254 .29652 0 1 Mshowa
.34127 .30902 m
.34127 .31527 L
s
[(-1)] .34127 .29652 0 1 Mshowa
.65873 .30902 m
.65873 .31527 L
s
[(1)] .65873 .29652 0 1 Mshowa
.81746 .30902 m
.81746 .31527 L
s
[(2)] .81746 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(3)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.05556 .30902 m
.05556 .31277 L
s
.0873 .30902 m
.0873 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.15079 .30902 m
.15079 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.24603 .30902 m
.24603 .31277 L
s
.27778 .30902 m
.27778 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.37302 .30902 m
.37302 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.43651 .30902 m
.43651 .31277 L
s
.46825 .30902 m
.46825 .31277 L
s
.53175 .30902 m
.53175 .31277 L
s
.56349 .30902 m
.56349 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.62698 .30902 m
.62698 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.72222 .30902 m
.72222 .31277 L
s
.75397 .30902 m
.75397 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.84921 .30902 m
.84921 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.9127 .30902 m
.9127 .31277 L
s
.94444 .30902 m
.94444 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .07725 m
.50625 .07725 L
s
[(-0.75)] .4875 .07725 1 0 Mshowa
.5 .15451 m
.50625 .15451 L
s
[(-0.5)] .4875 .15451 1 0 Mshowa
.5 .23176 m
.50625 .23176 L
s
[(-0.25)] .4875 .23176 1 0 Mshowa
.5 .38627 m
.50625 .38627 L
s
[(0.25)] .4875 .38627 1 0 Mshowa
.5 .46353 m
.50625 .46353 L
s
[