(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   2344077,      98369]*)
(*NotebookOutlinePosition[   2344759,      98392]*)
(*  CellTagsIndexPosition[   2344715,      98388]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["FOCUSING WITH A BOUND STATE", "Text",
  FontSize->14,
  Background->None]], "Title",
  CellFrame->True,
  Background->GrayLevel[0.849989]],

Cell[TextData[{
  StyleBox["The wavefront  and the tail  are incident from the left.\n\nThe \
nonhomogeneity  ",
    FontSize->12],
  StyleBox["is located on the entire ",
    FontSize->12,
    CharacterEncoding->"WindowsANSI"],
  StyleBox["x",
    FontSize->12,
    FontVariations->{"CompatibilityType"->0},
    CharacterEncoding->"WindowsANSI"],
  StyleBox["-axis.",
    FontSize->12,
    CharacterEncoding->"WindowsANSI"],
  StyleBox["  \n\nThe focusing location,  ",
    FontSize->12],
  StyleBox["x0, ",
    FontSize->12,
    FontVariations->{"CompatibilityType"->0},
    CharacterEncoding->"WindowsANSI"],
  StyleBox[" any real number, is in the nonhomogeneity and needs to be \
specified. \n\nThe potential   v[x], which is ",
    FontSize->12],
  StyleBox["the nonhomogeneity, is strictly negative. It corresponds to a \
reflectionless potential with one bound state of norming constant, c>0.\n\n\
The transmission coefficient, left reflection coefficient, and right \
reflection coefficient, respectively, are denoted by  T[k],  L[k],  R[k].\n\n\
The tail of the wave is denoted by  g[x,t].\n\nThe focusing moment is chosen \
as  t=0.",
    FontSize->12,
    CharacterEncoding->"WindowsANSI"]
}], "Text",
  FontSize->18,
  Background->RGBColor[1, 1, 0]],

Cell["\<\
The potential and the scattering coefficients are given next:\
\>", \
"Text",
  Background->RGBColor[1, 1, 0]],

Cell[BoxData[{
    \(\(Clear[v, T, L, R, x0, g, c];\)\), "\[IndentingNewLine]", 
    \(\(v[
          x_] = \(-\ 
            16\)\ c^2\ E^\((2\ x)\)/\((2\ E^\((2\ x)\) + 
                  c^2)\)^2\ ;\)\), "\n", 
    \(\(T[k_] = \((k + I\ )\)/\((k - I)\);\)\), "\n", 
    \(\(L[k_] = 0;\)\), "\n", 
    \(\(R[k_] = 0;\)\)}], "Input",
  CellOpen->False],

Cell["\<\
Specify the focusing location  x0, any real number, and the norming \
constant c, a positive number, next:\
\>", "Text",
  Background->RGBColor[1, 1, 0]],

Cell[BoxData[
    \(\(\(\(c = 1\) \)\(;\)\(\ \)\(\(x0 = 1\) \)\(;\)\(\ \)\)\)], "Input"],

Cell["The tail  g[x,t]  of the focusing  wave is evaluated  next:", "Text",
  Background->RGBColor[1, 1, 0]],

Cell[BoxData[
    \(\(g[x_, t_] = 
        UnitStep[\(-x\) + x0 + 
              t]\ \((4\ c^2\ E^\((x + x0)\)\ \((E^t - 
                    E^\((\(-t\))\))\))\)/\((\((2\ E^\((2\ x)\) + 
                    c^2)\) \((2\ E^\((2\ x0)\) + c^2)\))\);\)\)], "Input",
  CellOpen->False],

Cell[BoxData[
    \(<< Graphics`Animation`\)], "Input",
  CellOpen->False],

Cell[BoxData[
    \(<< Graphics`FilledPlot`\)], "Input",
  CellOpen->False],

Cell[TextData[{
  "The focusing wave is animated  next. The wavefront (",
  StyleBox["magenta",
    FontColor->RGBColor[1, 0, 1]],
  ") and the tail (",
  StyleBox["blue",
    FontColor->RGBColor[0, 0, 1]],
  ") are incident from the left onto the nonhomogeneity (",
  StyleBox["green",
    FontColor->RGBColor[0, 1, 0]],
  "):"
}], "Text",
  Background->RGBColor[1, 1, 0]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Animate[{FilledPlot\[IndentingNewLine][{v[x]}, \ {x, \ \(-5\), \ 
              6}, \ PlotRange -> {\(-3\), 4}, \ 
            Fills \[Rule] {Hue[ .3]}], \[IndentingNewLine]Plot[{10\ UnitStep[
                  x - x0 - t]}, \ {x, \ \(-5\), \ 6}, \ 
            PlotStyle\  \[Rule] \ Hue[0.9], \ 
            PlotRange -> {\(-3\), 4}], \ \[IndentingNewLine]Plot[{g[x, 
                t]}, \ {x, \ \(-5\), \ 6}, 
            PlotStyle\  \[Rule] \ 
              Hue[ .6], \ \ PlotRange -> {\(-3\), 
                4}]}, \ \[IndentingNewLine]{t, \ \(-6\), \ 3, 0.2}, 
        PlotLabel \[Rule] {"\<t\>", t}];\)\)], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -22.0938 0 ]
[.5 .63053 22.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -83.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
97.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
1 0 .6 r
0 .4 1 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.30316 .26487 L
.34309 .26487 L
.3815 .26487 L
.42237 .26487 L
.46172 .26487 L
.49955 .26487 L
.53984 .26487 L
.57861 .26487 L
.61984 .26487 L
.65954 .26487 L
.69774 .26487 L
.73838 .26487 L
.77751 .26487 L
.81909 .26487 L
.85916 .26487 L
.89771 .26487 L
.93871 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -22.0938 0 ]
[.5 .63053 22.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -83.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
97.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001moooo0P000:7oool007coool010000?ooooooo`000:3oool007koool00`000?oo
ooooo`03oooo0`0009Woool007Koool400001Oooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo001loooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007coool200001_ooo`<0002I
oooo001foooo1P000004<ol00000000000001?ooo`030000oooooooo09Woool007Soool01@0003?o
03?o03?o00000002<ol00P0000?oool00`000?ooooooo`2Ioooo001goooo00<0000co`0co`000c?o
00800002<ol00P000003oooo0000oooo09[oool007Koool00`0003?o03?o000:<ol00P0009_oool0
07Goool00`0003?o03?o000<<ol00P0009[oool007Coool00`0003?o03?o000=<ol000<0003ooooo
ool0VOooo`00Loooo`030000<ol0<ol000hco`020000V_ooo`00Loooo`030000<ol0<ol000hco`00
0`0003?o0000002Ioooo001boooo00<0000co`0co`003c?o008000000c?o00000?ooo`2Goooo001b
oooo00<0000co`0co`003c?o00040000<ol0<ol00000V?ooo`00LOooo`030000<ol0<ol0010co`00
1@0003?o03?o03?o0000002Goooo001aoooo00<0000co`0co`0043?o00030000<ol0<ol0008co`00
0`000?ooooooo`2Doooo001`oooo00<0000co`0co`004C?o00030000<ol0<ol0008co`000`000?oo
ooooo`2Doooo001_oooo00<0000co`0co`004S?o00800004<ol000<0003oooooool0Toooo`00K_oo
o`030000<ol0<ol001<co`000`0003?o03?o0004<ol000<0003oooooool0T_ooo`00K_ooo`030000
<ol0<ol001<co`000`0003?o03?o0004<ol000<0003oooooool0T_ooo`00KOooo`030000<ol0<ol0
01@co`000`0003?o03?o0005<ol000<0003oooooool0TOooo`00K?ooo`030000<ol0<ol001Dco`02
00001c?o00030000oooooooo093oool006_oool00`0003?o03?o000F<ol000<0000co`0co`001S?o
00030000oooooooo093oool006_oool00`0003?o03?o000F<ol000<0000co`0co`001c?o00030000
oooooooo08ooool006[oool00`0003?o03?o000?<ol01@0000<co`000`0003?o03?o0008<ol000<0
003oooooool0S_ooo`00JOooo`030000<ol0<ol0018co`000`0003?o03?o0003<ol000<0000co`0c
o`0023?o00030000oooooooo08koool006Soool00`0003?o03?o000C<ol000<0000co`0co`000c?o
00<00009<ol000<0003oooooool0SOooo`00J?ooo`030000<ol0<ol000/co`04000013?o00030000
<ol0<ol000<co`000`0003?o03?o000:<ol000<0003oooooool0S?ooo`00Ioooo`030000<ol0<ol0
01@co`000`0003?o03?o0003<ol000<0000co`0co`002c?o00030000oooooooo08_oool006Koool0
0`0003?o03?o000D<ol00P0000Dco`000`0003?o03?o000;<ol000<0003oooooool0Roooo`00I_oo
o`030000<ol0<ol001/co`0200003C?o00030000oooooooo08[oool006Goool00`0003?o03?o000L
<ol000<0000co`0co`003C?o00030000oooooooo08Woool006Coool00`0003?o03?o000M<ol000<0
000co`0co`003S?o00030000oooooooo08Soool006?oool00`0003?o03?o000N<ol000<0000co`0c
o`003c?o00030000oooooooo08Ooool006?oool00`0003?o03?o000N<ol000<0000co`0co`0043?o
00030000oooooooo08Koool006;oool00`0003?o03?o000O<ol00P00018co`000`000?ooooooo`25
oooo001Qoooo00<0000co`0co`0083?o00030000<ol0<ol0018co`000`000?ooooooo`24oooo000_
oooo0`0002Ooool400000_ooo`80000S<ol000<0000co`0co`004c?o00030000oooooooo017oool4
0000:_ooo`<0000Woooo0`0001Ooool0033oool00`000?ooooooo`0Voooo00<0003oooooool00_oo
o`030000<ol0<ol002<co`000`0003?o03?o000D<ol000<0003oooooool04?ooo`030000oooooooo
02coool00`000?ooooooo`0Voooo00@0003oooooool0000Foooo000]oooo1@0002Soool010000?oo
ooooo`0002Hco`0200005S?o0080000Aoooo00<0003oooooool0:?ooo`D0000Woooo00@0003ooooo
ool0000Foooo000Woooo100000;oool010000?ooooooo`0002;oool400001?ooo`80000W<ol000<0
000co`0co`005c?o00030000oooooooo00ooool00`000?ooooooo`0Woooo00@0003oooooool0000X
oooo0`0001Ooool002koool00`000?ooo`00000Xoooo0P000003<ol00000<ol002Hco`000`0003?o
03?o000H<ol000<0003oooooool03?ooo`040000oooooooo0000:Oooo`030000oooo000002Woool0
0`000?ooooooo`0Foooo000_oooo0P0002Ooool40000:3?o00030000<ol0<ol001Tco`000`000?oo
ooooo`0<oooo0P0002_oool20000:Oooo`<0000Foooo001Foooo0P0002`co`000`0003?o03?o000J
<ol00P0007goool005Coool20000;S?o0080000M<ol00`0007[oool0057oool30000<3?o00030000
<ol0<ol001lco`060000M?ooo`00Boooo`H0000c<ol000<0000co`0co`009C?o00<0001aoooo0011
oooo2P0003Tco`000`0003?o03?o000X<ol02P0006Ooool0013ooooo00004Oooo`005_ooo`030000
oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool0
0`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08
oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003ooooo
ool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000
oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool0
0`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`0E
oooo000/oooo00<0003oooooool0:Oooo`030000oooooooo02Woool00`000?ooooooo`0Yoooo00<0
003oooooool0:Oooo`030000oooooooo02Woool00`000?ooooooo`0Eoooo0024oooo00<0003ooooo
ool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000oooooooo
09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?ooo`80002J
oooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?oo
ooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?ooo`80002Joooo0024oooo00<0003ooooo
ool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo0P00
09[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00O?ooo`D00003
oooo00<0003oooooool0VOooo`00O_ooo`030000oooooooo00?oool00`000?ooooooo`2Ioooo001n
oooo00<0003oooooool00oooo`<0002Ioooo001noooo00<0003oooooool00oooo`030000oooooooo
09Woool007koool00`000?ooooooo`03oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007goool00`000?ooooooo`04
oooo0`0009Woool007koool00`000?ooooooo`03oooo00<0003oooooool0VOooo`00O?ooo`040000
oooooooo00001?ooo`030000oooooooo09Woool007goool200001Oooo`030000oooooooo09Woool0
08Coool20000V_ooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?oo
o`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOoo
o`00Q?ooo`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool0
08Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?ooo`80002Joooo0024
oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0003oooooool0VOooo`00O?ooo`040000
oooooooo00001?ooo`030000oooooooo09Woool007koool00`000?ooooooo`03oooo0`0009Woool0
07ooool00`000?ooooooo`02oooo00<0003oooooool0VOooo`00O?ooo`040000oooooooo00001?oo
o`030000oooooooo09Woool007goool200001Oooo`030000oooooooo09Woool008Coool00`000?oo
ooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003ooooo
ool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000oooooooo
09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000
oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?oo
ooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?ooo`80002Joooo0024oooo00<0003ooooo
ool0VOooo`00Q?ooo`030000oooooooo09Woool007koool300000oooo`030000oooooooo09Woool0
07ooool00`000?ooooooo`02oooo00<0003oooooool0VOooo`00O?ooo`D00003oooo0`0009Woool0
07coool010000?ooooooo`000:3oool007goool00`000?ooo`00002Poooo001noooo0P000:3oool0
0?oooolQoooo003ooooo8Oooo`00Ooooo`030000oooooooo01coool00`000?ooooooo`1ooooo001n
oooo00<0003oooooool02?ooo`030000oooooooo01?oool00`000?ooooooo`1noooo001noooo00<0
003oooooool00_ooo`800004oooo00<0003oooooool03?ooo`<00004oooo00<0003oooooool0O_oo
o`00O_ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01?oo
o`@00003oooo00@0003oooooool00003oooo00<0003oooooool0O_ooo`00OOooo`030000oooooooo
00;oool00`000?ooooooo`0Coooo00@0003oooooool00004oooo00<0003oooooool0OOooo`00O_oo
o`030000oooooooo00D0000Boooo0`0000Coool00`000?ooooooo`1noooo001noooo00D0003ooooo
ooooool000005_ooo`030000oooooooo00?oool00`000?ooooooo`1noooo001ooooo00<0003ooooo
ool05oooo`<00002oooo00<0003oooooool0Ooooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-6.03535, \
-3.20105, 0.0455524, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-6.03535, -3.20105, 0.0455524, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.02846 .26487 L
.03279 .26487 L
.03754 .26487 L
.0389 .26487 L
.0402 .26487 L
s
.0402 .26487 m
.04066 .61803 L
s
0 .4 1 r
.02381 .12948 m
.02846 .12201 L
.03279 .11469 L
.03754 .10622 L
.0389 .10369 L
.0402 .10127 L
.04136 .26487 L
.04262 .26487 L
.06244 .26487 L
.10458 .26487 L
.14545 .26487 L
.1848 .26487 L
.22263 .26487 L
.26292 .26487 L
.30169 .26487 L
.34292 .26487 L
.38262 .26487 L
.42082 .26487 L
.46146 .26487 L
.50059 .26487 L
.54217 .26487 L
.58224 .26487 L
.62079 .26487 L
.6618 .26487 L
.70128 .26487 L
.73925 .26487 L
.77968 .26487 L
.81859 .26487 L
.85995 .26487 L
.89979 .26487 L
.93812 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001moooo0P000:7oool007coool010000?ooooooo`000:3oool007koool00`000?oo
ooooo`03oooo0`0009Woool007Koool400001Oooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo001loooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007coool200001_ooo`<0002I
oooo001foooo1P000004<ol00000000000001?ooo`030000oooooooo09Woool007Soool01@0003?o
03?o03?o00000002<ol00P0000?oool00`000?ooooooo`2Ioooo001goooo00<0000co`0co`000c?o
00800002<ol00P000003oooo0000oooo09[oool001[oool00`1Vooooooooo`1Ioooo00<0000co`0c
o`002S?o0080002Koooo000Joooo00<0I_ooooooool0F?ooo`030000<ol0<ol000`co`020000V_oo
o`006Oooo`80I_mIoooo00<0000co`0co`003C?o00030000oooooooo09Woool001Woool206KoF?oo
o`030000<ol0<ol000hco`020000V_ooo`006?ooo`0306Kooooo06Ko05Soool00`0003?o03?o000>
<ol000<0000co`000000VOooo`005oooo`0406Kooooooooo06KoEoooo`030000<ol0<ol000lco`02
000000<co`00003oool0Uoooo`005_ooo`0506Kooooooooooooo06Ko05Ooool00`0003?o03?o000?
<ol000@0000co`0co`00002Hoooo000Foooo00D0I_ooooooooooool0I_l0E_ooo`030000<ol0<ol0
010co`001@0003?o03?o03?o0000002Goooo000Joooo00<0I_ooooooool0E?ooo`030000<ol0<ol0
010co`000`0003?o03?o0002<ol000<0003oooooool0U?ooo`006_ooo`0306Kooooooooo05?oool0
0`0003?o03?o000A<ol000<0000co`0co`000S?o00030000oooooooo09Coool001[oool00`1Voooo
ooooo`1Boooo00<0000co`0co`004S?o00800004<ol000<0003oooooool0Toooo`006_ooo`0306Ko
oooooooo057oool00`0003?o03?o000C<ol000<0000co`0co`0013?o00030000oooooooo09;oool0
01[oool00`1Vooooooooo`1Aoooo00<0000co`0co`004c?o00030000<ol0<ol000@co`000`000?oo
ooooo`2Boooo000Joooo00<0I_ooooooool0D?ooo`030000<ol0<ol001@co`000`0003?o03?o0005
<ol000<0003oooooool0TOooo`006_ooo`0306Kooooooooo04ooool00`0003?o03?o000E<ol00P00
00Lco`000`000?ooooooo`2@oooo000Joooo00<0I_ooooooool0C_ooo`030000<ol0<ol001Hco`00
0`0003?o03?o0006<ol000<0003oooooool0T?ooo`006_ooo`0306Kooooooooo04koool00`0003?o
03?o000F<ol000<0000co`0co`001c?o00030000oooooooo08ooool001[oool00`1Vooooooooo`1=
oooo00<0000co`0co`003c?o00D00003<ol000<0000co`0co`0023?o00030000oooooooo08koool0
01[oool00`1Vooooooooo`1<oooo00<0000co`0co`004S?o00030000<ol0<ol000<co`000`0003?o
03?o0008<ol000<0003oooooool0S_ooo`006_ooo`0306Kooooooooo04_oool00`0003?o03?o000C
<ol000<0000co`0co`000c?o00<00009<ol000<0003oooooool0SOooo`006_ooo`0306Kooooooooo
04_oool00`0003?o03?o000;<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0co`002S?o
00030000oooooooo08coool001_oool00`1Vooooooooo`19oooo00<0000co`0co`0053?o00030000
<ol0<ol000<co`000`0003?o03?o000;<ol000<0003oooooool0Roooo`006oooo`0306Kooooooooo
04Soool00`0003?o03?o000D<ol00P0000Dco`000`0003?o03?o000;<ol000<0003oooooool0Rooo
o`006oooo`0306Kooooooooo04Soool00`0003?o03?o000K<ol00P0000dco`000`000?ooooooo`2:
oooo000Koooo00<0I_ooooooool0Aoooo`030000<ol0<ol001`co`000`0003?o03?o000=<ol000<0
003oooooool0ROooo`006oooo`0306Kooooooooo04Koool00`0003?o03?o000M<ol000<0000co`0c
o`003S?o00030000oooooooo08Soool001_oool00`1Vooooooooo`15oooo00<0000co`0co`007S?o
00030000<ol0<ol000lco`000`000?ooooooo`27oooo000Koooo00<0I_ooooooool0AOooo`030000
<ol0<ol001hco`000`0003?o03?o000@<ol000<0003oooooool0Q_ooo`006oooo`0306Kooooooooo
04Coool00`0003?o03?o000O<ol00P00018co`000`000?ooooooo`25oooo000Koooo00<0I_oooooo
ool0@oooo`030000<ol0<ol0020co`000`0003?o03?o000B<ol000<0003oooooool0Q?ooo`006ooo
o`0306Kooooooooo017oool300009oooo`@00002oooo0P0002<co`000`0003?o03?o000C<ol000<0
003oooooool04Oooo`@0000Zoooo0`0002Ooool300005oooo`006oooo`0306Kooooooooo01;oool0
0`000?ooooooo`0Voooo00<0003oooooool00_ooo`030000<ol0<ol002<co`000`0003?o03?o000D
<ol000<0003oooooool04?ooo`030000oooooooo02coool00`000?ooooooo`0Voooo00@0003ooooo
ool0000Foooo000Koooo00<0I_ooooooool03oooo`D0000Xoooo00@0003oooooool0000V<ol00P00
01Hco`0200004Oooo`030000oooooooo02Soool500009oooo`040000oooooooo00005_ooo`006ooo
o`0306Kooooooooo00Woool400000_ooo`040000oooooooo00008_ooo`@00004oooo0P0002Lco`00
0`0003?o03?o000G<ol000<0003oooooool03oooo`030000oooooooo02Ooool010000?ooooooo`00
02Soool300005oooo`006oooo`0306Kooooooooo013oool00`000?ooo`00000Xoooo0P000003<ol0
0000<ol002Hco`000`0003?o03?o000H<ol000<0003oooooool03?ooo`040000oooooooo0000:Ooo
o`030000oooo000002Woool00`000?ooooooo`0Foooo000Koooo00<0I_ooooooool04Oooo`80000W
oooo100002Pco`000`0003?o03?o000I<ol000<0003oooooool03?ooo`80000[oooo0P0002Woool3
00005_ooo`006oooo`0306Kooooooooo03Soool20000;3?o00030000<ol0<ol001Xco`020000OOoo
o`006oooo`0306Kooooooooo03Koool20000;S?o0080000M<ol00`0007[oool001_oool00`1Voooo
ooooo`0coooo0`00030co`000`0003?o03?o000O<ol01P0007Coool001_oool00`1Vooooooooo`0]
oooo1P0003<co`000`0003?o03?o000U<ol00`00077oool001_oool00`1Vooooooooo`0Soooo2P00
03Tco`000`0003?o03?o000X<ol02P0006Ooool0013ooooo00004Oooo`005_ooo`050000oooooooo
ooooo`2I00Koool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool0
0`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08
oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003ooooo
ool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000
oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool0
0`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`0E
oooo000Joooo00?o09Woooooool03oooo`030000oooooooo02Woool00`000?ooooooo`0Yoooo00<0
003oooooool0:Oooo`030000oooooooo02Woool00`000?ooooooo`0Yoooo00<0003oooooool05Ooo
o`006_ooo`03o`2Ioooooooo06Ooool00`000?ooooooo`2Ioooo000Joooo00?o09Woooooool0Iooo
o`030000oooooooo09Woool001[oool00ol0VOooooooo`1Woooo0P0009[oool001[oool00ol0VOoo
ooooo`1Woooo00<0003oooooool0VOooo`006_ooo`03o`2Ioooooooo06Ooool00`000?ooooooo`2I
oooo000Joooo00?o09Woooooool0Ioooo`030000oooooooo09Woool001[oool00ol0VOooooooo`1W
oooo0P0009[oool001[oool00ol0VOooooooo`1Woooo00<0003oooooool0VOooo`006_ooo`03o`2I
oooooooo06Ooool00`000?ooooooo`2Ioooo000Joooo00?o09Woooooool0Ioooo`030000oooooooo
09Woool001[oool00ol0VOooooooo`1Woooo00<0003oooooool0VOooo`006_ooo`03o`2Ioooooooo
06Ooool20000V_ooo`006_ooo`03o`2Ioooooooo06Ooool00`000?ooooooo`2Ioooo000Joooo00?o
09Woooooool0Ioooo`030000oooooooo09Woool001[oool00ol0VOooooooo`1Woooo00<0003ooooo
ool0VOooo`006_ooo`03o`2Ioooooooo06Ooool20000V_ooo`006_ooo`03o`2Ioooooooo06Ooool0
0`000?ooooooo`2Ioooo000Joooo00?o09Woooooool0Ioooo`030000oooooooo09Woool001[oool0
0ol0VOooooooo`1Ooooo1@0000?oool00`000?ooooooo`2Ioooo000Joooo00?o09Woooooool0HOoo
o`030000oooooooo00?oool00`000?ooooooo`2Ioooo000Joooo00?o09Woooooool0HOooo`030000
oooooooo00?oool30000VOooo`006_ooo`03o`2Ioooooooo067oool00`000?ooooooo`03oooo00<0
003oooooool0VOooo`006_ooo`03o`2Ioooooooo067oool00`000?ooooooo`03oooo00<0003ooooo
ool0VOooo`006_ooo`03o`2Ioooooooo063oool200001Oooo`030000oooooooo09Woool001[oool0
0ol0VOooooooo`1Woooo0P0009[oool001[oool00ol0VOooooooo`1Woooo00<0003oooooool0VOoo
o`006_ooo`03o`2Ioooooooo06Ooool00`000?ooooooo`2Ioooo000Joooo00?o09Woooooool0Iooo
o`030000oooooooo09Woool001[oool00ol0VOooooooo`1Woooo00<0003oooooool0VOooo`006_oo
o`03o`2Ioooooooo06Ooool20000V_ooo`006_ooo`03o`2Ioooooooo06Ooool00`000?ooooooo`2I
oooo000Joooo00?o09Woooooool0Ioooo`030000oooooooo09Woool001[oool00ol0VOooooooo`1W
oooo00<0003oooooool0VOooo`006_ooo`03o`2Ioooooooo06Ooool20000V_ooo`006_ooo`03o`2I
oooooooo06Ooool00`000?ooooooo`2Ioooo000Joooo00?o09Woooooool0Ioooo`030000oooooooo
09Woool001[oool00ol0VOooooooo`1Woooo00<0003oooooool0VOooo`006_ooo`03o`2Ioooooooo
06Ooool00`000?ooooooo`2Ioooo000Joooo00?o09Woooooool0Ioooo`80002Joooo000Joooo00?o
09Woooooool0Ioooo`030000oooooooo09Woool001[oool00ol0VOooooooo`1Ooooo100000Coool0
0`000?ooooooo`2Ioooo000Joooo00?o09Woooooool0Goooo`030000oooooooo00Goool00`000?oo
ooooo`2Ioooo000Joooo00?o09Woooooool0H?ooo`030000oooooooo00Coool30000VOooo`006ooo
o`03o`2Ioooooooo063oool00`000?ooooooo`03oooo00<0003oooooool0VOooo`006oooo`03o`2I
oooooooo05koool010000?ooooooo`0000Coool00`000?ooooooo`2Ioooo000Koooo00?o09Wooooo
ool0Goooo`800005oooo00<0003oooooool0VOooo`006oooo`03o`2Ioooooooo06Koool20000V_oo
o`006oooo`03o`2Ioooooooo06Koool00`000?ooooooo`2Ioooo000Koooo00?o09Woooooool0I_oo
o`030000oooooooo09Woool001_oool00ol0VOooooooo`1Voooo00<0003oooooool0VOooo`006ooo
o`03o`2Ioooooooo06Koool00`000?ooooooo`2Ioooo000Koooo00?o09Woooooool0I_ooo`80002J
oooo000Koooo00?o09Woooooool0I_ooo`030000oooooooo09Woool001_oool00ol0VOooooooo`1V
oooo00<0003oooooool0VOooo`006oooo`03o`2Ioooooooo06Koool00`000?ooooooo`2Ioooo000K
oooo00?o09Woooooool0I_ooo`80002Joooo000Koooo00?o09Woooooool0I_ooo`030000oooooooo
09Woool001_oool00ol0VOooooooo`1Voooo00<0003oooooool0VOooo`006oooo`03o`2Ioooooooo
06Koool00`000?ooooooo`2Ioooo000Koooo00?o09Woooooool0I_ooo`030000oooooooo09Woool0
01_oool00ol0VOooooooo`1Voooo0P0009[oool001_oool00ol0VOooooooo`1Voooo00<0003ooooo
ool0VOooo`006oooo`03o`2Ioooooooo05ooool200001Oooo`030000oooooooo09Woool001_oool0
0ol0VOooooooo`1Noooo00@0003oooooool00004oooo00<0003oooooool0VOooo`006oooo`03o`2I
oooooooo063oool00`000?ooooooo`03oooo0`0009Woool001_oool00ol0VOooooooo`1Qoooo00<0
003oooooool00_ooo`030000oooooooo09Woool001_oool00ol0VOooooooo`1Noooo00@0003ooooo
ool00004oooo00<0003oooooool0VOooo`006oooo`03o`2Ioooooooo05ooool200001Oooo`030000
oooooooo09Woool001_oool00ol0VOooooooo`1Voooo00<0003oooooool0VOooo`006oooo`03o`2I
oooooooo06Koool20000V_ooo`006oooo`03o`2Ioooooooo06Koool00`000?ooooooo`2Ioooo000K
oooo00?o09Woooooool0I_ooo`030000oooooooo09Woool001_oool00ol0VOooooooo`1Voooo00<0
003oooooool0VOooo`006oooo`03o`2Ioooooooo06Koool20000V_ooo`006oooo`03o`2Ioooooooo
06Koool00`000?ooooooo`2Ioooo000Koooo00?o09Woooooool0I_ooo`030000oooooooo09Woool0
01_oool00ol0VOooooooo`1Voooo00<0003oooooool0VOooo`006oooo`03o`2Ioooooooo06Koool0
0`000?ooooooo`2Ioooo000Koooo00?o09Woooooool0I_ooo`80002Joooo000Koooo00?o09Wooooo
ool0I_ooo`030000oooooooo09Woool001_oool00ol0VOooooooo`1Voooo00<0003oooooool0VOoo
o`006oooo`03o`2Ioooooooo06Koool00`000?ooooooo`2Ioooo000Koooo00?o09Woooooool0I_oo
o`80002Joooo000Koooo00?o09Woooooool0I_ooo`030000oooooooo09Woool001_oool00ol0VOoo
ooooo`1Voooo00<0003oooooool0VOooo`006oooo`03o`2Ioooooooo063oool300000oooo`030000
oooooooo09Woool001_oool00ol0VOooooooo`1Qoooo00<0003oooooool00_ooo`030000oooooooo
09Woool001_oool00ol0VOooooooo`1Noooo1@0000?oool30000VOooo`00O?ooo`040000oooooooo
0000X?ooo`00OOooo`030000oooo00000:3oool007koool20000X?ooo`00ooooob7oool00?oooolQ
oooo001ioooo00<0003oooooool0:?ooo`030000oooooooo07Woool007Soool00`000?ooooooo`08
oooo00<0003oooooool07oooo`030000oooooooo07Soool007Soool00`000?ooooooo`02oooo0P00
00Coool00`000?ooooooo`0=oooo0P0000Coool200001?ooo`800004oooo00<0003oooooool0N?oo
o`00N?ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01?oo
o`@00003oooo00@0003oooooool00008oooo00@0003oooooool00003oooo00<0003oooooool0N?oo
o`00Moooo`030000oooooooo00;oool00`000?ooooooo`0Foooo00<0003oooooool01_ooo`040000
oooooooo00001?ooo`030000oooooooo07Ooool007Soool00`000?ooooooo`0500004oooo`80000:
oooo0P0000Coool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000005_ooo`030000
oooooooo00Soool010000?ooooooo`0000?oool00`000?ooooooo`1hoooo001ioooo00<0003ooooo
ool05oooo`<00009oooo0P0000?oool00`000?ooooooo`1ioooo003ooooo8Oooo`00ooooob7oool0
0001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-6.03535, \
-3.20105, 0.0455524, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-6.03535, -3.20105, 0.0455524, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.03279 .26487 L
.04262 .26487 L
.04758 .26487 L
.05288 .26487 L
.05546 .26487 L
.05672 .26487 L
.05789 .26487 L
s
.05789 .26487 m
.05831 .61803 L
s
0 .4 1 r
.02381 .15402 m
.03279 .14191 L
.04262 .12713 L
.04758 .11901 L
.05288 .1098 L
.05546 .10512 L
.05672 .10277 L
.05789 .10057 L
.05895 .26487 L
.06007 .26487 L
.06244 .26487 L
.10458 .26487 L
.14241 .26487 L
.1827 .26487 L
.22147 .26487 L
.2627 .26487 L
.30241 .26487 L
.3406 .26487 L
.38125 .26487 L
.42038 .26487 L
.46196 .26487 L
.50202 .26487 L
.54057 .26487 L
.58158 .26487 L
.62107 .26487 L
.65904 .26487 L
.69946 .26487 L
.73837 .26487 L
.77973 .26487 L
.81958 .26487 L
.85791 .26487 L
.89869 .26487 L
.93795 .26487 L
.97571 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001moooo0P000:7oool007coool010000?ooooooo`000:3oool007koool00`000?oo
ooooo`03oooo0`0009Woool007Koool400001Oooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo001loooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007coool200001_ooo`<0002I
oooo001foooo1P000004<ol00000000000001?ooo`030000oooooooo09Woool007Soool01@0003?o
03?o03?o00000002<ol00P0000?oool00`000?ooooooo`2Ioooo001goooo00<0000co`0co`000c?o
00800002<ol00P000003oooo0000oooo09[oool001ooool00`1Vooooooooo`1Doooo00<0000co`0c
o`002S?o0080002Koooo000Noooo0P1VoeGoool00`0003?o03?o000<<ol00P0009[oool001koool2
06KoE?ooo`030000<ol0<ol000dco`000`000?ooooooo`2Ioooo000Moooo00<0I_ooool0I_l0Dooo
o`030000<ol0<ol000hco`020000V_ooo`007?ooo`0406Kooooooooo06KoDoooo`030000<ol0<ol0
00hco`000`0003?o0000002Ioooo000Koooo00D0I_ooooooooooool0I_l0D_ooo`030000<ol0<ol0
00lco`02000000<co`00003oool0Uoooo`006oooo`0506Kooooooooooooo06Ko05;oool00`0003?o
03?o000?<ol000@0000co`0co`00002Hoooo000Joooo00<0I_ooooooool00_ooo`0306Kooooooooo
04ooool00`0003?o03?o000@<ol000D0000co`0co`0co`000000Uoooo`006_ooo`0306Kooooooooo
00;oool00`1Vooooooooo`1?oooo00<0000co`0co`0043?o00030000<ol0<ol0008co`000`000?oo
ooooo`2Doooo000Ioooo00<0I_ooooooool00oooo`0306Kooooooooo04koool00`0003?o03?o000A
<ol000<0000co`0co`000S?o00030000oooooooo09Coool001Woool00`1Vooooooooo`03oooo00<0
I_ooooooool0COooo`030000<ol0<ol0018co`02000013?o00030000oooooooo09?oool001Soool0
0`1Vooooooooo`04oooo00<0I_ooooooool0C?ooo`030000<ol0<ol001<co`000`0003?o03?o0004
<ol000<0003oooooool0T_ooo`005oooo`0306Kooooooooo00Goool00`1Vooooooooo`1<oooo00<0
000co`0co`004c?o00030000<ol0<ol000@co`000`000?ooooooo`2Boooo000Foooo00<0I_oooooo
ool01_ooo`0306Kooooooooo04_oool00`0003?o03?o000D<ol000<0000co`0co`001C?o00030000
oooooooo097oool001ooool00`1Vooooooooo`1:oooo00<0000co`0co`005C?o00800007<ol000<0
003oooooool0T?ooo`007oooo`0306Kooooooooo04Woool00`0003?o03?o000F<ol000<0000co`0c
o`001S?o00030000oooooooo093oool001ooool00`1Vooooooooo`19oooo00<0000co`0co`005S?o
00030000<ol0<ol000Lco`000`000?ooooooo`2?oooo000Ooooo00<0I_ooooooool0B?ooo`030000
<ol0<ol000lco`0500000c?o00030000<ol0<ol000Pco`000`000?ooooooo`2>oooo000Ooooo00<0
I_ooooooool0Aoooo`030000<ol0<ol0018co`000`0003?o03?o0003<ol000<0000co`0co`0023?o
00030000oooooooo08koool001ooool00`1Vooooooooo`16oooo00<0000co`0co`004c?o00030000
<ol0<ol000<co`0300002C?o00030000oooooooo08goool001ooool00`1Vooooooooo`16oooo00<0
000co`0co`002c?o00@00004<ol000<0000co`0co`000c?o00030000<ol0<ol000Xco`000`000?oo
ooooo`2<oooo000Ooooo00<0I_ooooooool0AOooo`030000<ol0<ol001@co`000`0003?o03?o0003
<ol000<0000co`0co`002c?o00030000oooooooo08_oool001ooool00`1Vooooooooo`14oooo00<0
000co`0co`0053?o00800005<ol000<0000co`0co`002c?o00030000oooooooo08_oool001ooool0
0`1Vooooooooo`14oooo00<0000co`0co`006c?o0080000=<ol000<0003oooooool0R_ooo`007ooo
o`0306Kooooooooo04?oool00`0003?o03?o000L<ol000<0000co`0co`003C?o00030000oooooooo
08Woool001ooool00`1Vooooooooo`12oooo00<0000co`0co`007C?o00030000<ol0<ol000hco`00
0`000?ooooooo`28oooo000Ooooo00<0I_ooooooool0@Oooo`030000<ol0<ol001hco`000`0003?o
03?o000?<ol000<0003oooooool0Qoooo`007oooo`0306Kooooooooo047oool00`0003?o03?o000N
<ol000<0000co`0co`0043?o00030000oooooooo08Koool001ooool00`1Vooooooooo`10oooo00<0
000co`0co`007c?o0080000B<ol000<0003oooooool0QOooo`007oooo`0306Kooooooooo03ooool0
0`0003?o03?o000P<ol000<0000co`0co`004S?o00030000oooooooo08Coool001ooool00`1Voooo
ooooo`0=oooo0`0002Ooool400000_ooo`80000S<ol000<0000co`0co`004c?o00030000oooooooo
017oool40000:_ooo`<0000Woooo0`0001Ooool001ooool00`1Vooooooooo`0>oooo00<0003ooooo
ool09_ooo`030000oooooooo00;oool00`0003?o03?o000S<ol000<0000co`0co`0053?o00030000
oooooooo013oool00`000?ooooooo`0/oooo00<0003oooooool09_ooo`040000oooooooo00005_oo
o`007oooo`0306Kooooooooo00_oool50000:?ooo`040000oooooooo00009S?o0080000F<ol00P00
017oool00`000?ooooooo`0Xoooo1@0002Ooool010000?ooooooo`0001Koool001ooool00`1Voooo
ooooo`05oooo100000;oool010000?ooooooo`0002;oool400001?ooo`80000W<ol000<0000co`0c
o`005c?o00030000oooooooo00ooool00`000?ooooooo`0Woooo00@0003oooooool0000Xoooo0`00
01Ooool001ooool00`1Vooooooooo`0<oooo00<0003oool00000:?ooo`8000000c?o000003?o000V
<ol000<0000co`0co`0063?o00030000oooooooo00coool010000?ooooooo`0002Woool00`000?oo
o`00000Yoooo00<0003oooooool05_ooo`007oooo`0306Kooooooooo00goool200009oooo`@0000X
<ol000<0000co`0co`006C?o00030000oooooooo00coool20000:oooo`80000Yoooo0`0001Koool0
01ooool00`1Vooooooooo`0doooo0P0002`co`000`0003?o03?o000J<ol00P0007goool001ooool0
0`1Vooooooooo`0boooo0P0002hco`0200007C?o00<0001joooo000Ooooo00<0I_ooooooool0;ooo
o`<0000`<ol000<0000co`0co`007c?o00H0001doooo000Ooooo00<0I_ooooooool0:Oooo`H0000c
<ol000<0000co`0co`009C?o00<0001aoooo000Ooooo00<0I_ooooooool07oooo`X0000i<ol000<0
000co`0co`00:3?o00X0001Woooo000@ooooo`00017oool001Koool00`000?ooooooo`06oooo00?o
09Woool000002_ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?oo
o`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo
00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?oo
ooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0
003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?oo
o`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool05Oooo`007oooo`03o`2I
oooooooo00[oool00`000?ooooooo`0Yoooo00<0003oooooool0:Oooo`030000oooooooo02Woool0
0`000?ooooooo`0Yoooo00<0003oooooool0:Oooo`030000oooooooo01Goool001ooool00ol0VOoo
ooooo`1Roooo00<0003oooooool0VOooo`007oooo`03o`2Ioooooooo06;oool00`000?ooooooo`2I
oooo000Ooooo00?o09Woooooool0H_ooo`80002Joooo000Ooooo00?o09Woooooool0H_ooo`030000
oooooooo09Woool001ooool00ol0VOooooooo`1Roooo00<0003oooooool0VOooo`007oooo`03o`2I
oooooooo06;oool00`000?ooooooo`2Ioooo000Ooooo00?o09Woooooool0H_ooo`80002Joooo000O
oooo00?o09Woooooool0H_ooo`030000oooooooo09Woool001ooool00ol0VOooooooo`1Roooo00<0
003oooooool0VOooo`007oooo`03o`2Ioooooooo06;oool00`000?ooooooo`2Ioooo000Ooooo00?o
09Woooooool0H_ooo`030000oooooooo09Woool001ooool00ol0VOooooooo`1Roooo0P0009[oool0
01ooool00ol0VOooooooo`1Roooo00<0003oooooool0VOooo`007oooo`03o`2Ioooooooo06;oool0
0`000?ooooooo`2Ioooo000Ooooo00?o09Woooooool0H_ooo`030000oooooooo09Woool001ooool0
0ol0VOooooooo`1Roooo0P0009[oool001ooool00ol0VOooooooo`1Roooo00<0003oooooool0VOoo
o`007oooo`03o`2Ioooooooo06;oool00`000?ooooooo`2Ioooo000Ooooo00?o09Woooooool0F_oo
o`D00003oooo00<0003oooooool0VOooo`007oooo`03o`2Ioooooooo05coool00`000?ooooooo`03
oooo00<0003oooooool0VOooo`007oooo`03o`2Ioooooooo05coool00`000?ooooooo`03oooo0`00
09Woool001ooool00ol0VOooooooo`1Loooo00<0003oooooool00oooo`030000oooooooo09Woool0
01ooool00ol0VOooooooo`1Loooo00<0003oooooool00oooo`030000oooooooo09Woool001ooool0
0ol0VOooooooo`1Koooo0P0000Goool00`000?ooooooo`2Ioooo000Ooooo00?o09Woooooool0H_oo
o`80002Joooo000Ooooo00?o09Woooooool0H_ooo`030000oooooooo09Woool001ooool00ol0VOoo
ooooo`1Roooo00<0003oooooool0VOooo`007oooo`03o`2Ioooooooo06;oool00`000?ooooooo`2I
oooo000Ooooo00?o09Woooooool0H_ooo`030000oooooooo09Woool001ooool00ol0VOooooooo`1R
oooo0P0009[oool001ooool00ol0VOooooooo`1Roooo00<0003oooooool0VOooo`007oooo`03o`2I
oooooooo06;oool00`000?ooooooo`2Ioooo000Ooooo00?o09Woooooool0H_ooo`030000oooooooo
09Woool001ooool00ol0VOooooooo`1Roooo0P0009[oool001ooool00ol0VOooooooo`1Roooo00<0
003oooooool0VOooo`007oooo`03o`2Ioooooooo06;oool00`000?ooooooo`2Ioooo000Ooooo00?o
09Woooooool0H_ooo`030000oooooooo09Woool001ooool00ol0VOooooooo`1Roooo00<0003ooooo
ool0VOooo`007oooo`03o`2Ioooooooo06;oool20000V_ooo`007oooo`03o`2Ioooooooo06;oool0
0`000?ooooooo`2Ioooo000Ooooo00?o09Woooooool0F_ooo`@00004oooo00<0003oooooool0VOoo
o`007oooo`03o`2Ioooooooo05[oool00`000?ooooooo`05oooo00<0003oooooool0VOooo`007ooo
o`03o`2Ioooooooo05_oool00`000?ooooooo`04oooo0`0009Woool001ooool00ol0VOooooooo`1L
oooo00<0003oooooool00oooo`030000oooooooo09Woool001ooool00ol0VOooooooo`1Joooo00@0
003oooooool00004oooo00<0003oooooool0VOooo`007oooo`03o`2Ioooooooo05_oool200001Ooo
o`030000oooooooo09Woool001ooool00ol0VOooooooo`1Roooo0P0009[oool001ooool00ol0VOoo
ooooo`1Roooo00<0003oooooool0VOooo`007oooo`03o`2Ioooooooo06;oool00`000?ooooooo`2I
oooo000Ooooo00?o09Woooooool0H_ooo`030000oooooooo09Woool001ooool00ol0VOooooooo`1R
oooo00<0003oooooool0VOooo`007oooo`03o`2Ioooooooo06;oool20000V_ooo`007oooo`03o`2I
oooooooo06;oool00`000?ooooooo`2Ioooo000Ooooo00?o09Woooooool0H_ooo`030000oooooooo
09Woool001ooool00ol0VOooooooo`1Roooo00<0003oooooool0VOooo`007oooo`03o`2Ioooooooo
06;oool20000V_ooo`007oooo`03o`2Ioooooooo06;oool00`000?ooooooo`2Ioooo000Ooooo00?o
09Woooooool0H_ooo`030000oooooooo09Woool001ooool00ol0VOooooooo`1Roooo00<0003ooooo
ool0VOooo`007oooo`03o`2Ioooooooo06;oool00`000?ooooooo`2Ioooo000Ooooo00?o09Wooooo
ool0H_ooo`80002Joooo000Ooooo00?o09Woooooool0H_ooo`030000oooooooo09Woool001ooool0
0ol0VOooooooo`1Koooo0P0000Goool00`000?ooooooo`2Ioooo000Ooooo00?o09Woooooool0F_oo
o`040000oooooooo00001?ooo`030000oooooooo09Woool001ooool00ol0VOooooooo`1Loooo00<0
003oooooool00oooo`<0002Ioooo000Ooooo00?o09Woooooool0GOooo`030000oooooooo00;oool0
0`000?ooooooo`2Ioooo000Ooooo00?o09Woooooool0F_ooo`040000oooooooo00001?ooo`030000
oooooooo09Woool001ooool00ol0VOooooooo`1Koooo0P0000Goool00`000?ooooooo`2Ioooo000O
oooo00?o09Woooooool0H_ooo`030000oooooooo09Woool001ooool00ol0VOooooooo`1Roooo0P00
09[oool001ooool00ol0VOooooooo`1Roooo00<0003oooooool0VOooo`007oooo`03o`2Ioooooooo
06;oool00`000?ooooooo`2Ioooo000Ooooo00?o09Woooooool0H_ooo`030000oooooooo09Woool0
01ooool00ol0VOooooooo`1Roooo0P0009[oool001ooool00ol0VOooooooo`1Roooo00<0003ooooo
ool0VOooo`007oooo`03o`2Ioooooooo06;oool00`000?ooooooo`2Ioooo000Ooooo00?o09Wooooo
ool0H_ooo`030000oooooooo09Woool001ooool00ol0VOooooooo`1Roooo00<0003oooooool0VOoo
o`007oooo`03o`2Ioooooooo06;oool20000V_ooo`007oooo`03o`2Ioooooooo06;oool00`000?oo
ooooo`2Ioooo000Ooooo00?o09Woooooool0H_ooo`030000oooooooo09Woool001ooool00ol0VOoo
ooooo`1Roooo00<0003oooooool0VOooo`007oooo`03o`2Ioooooooo06;oool20000V_ooo`007ooo
o`03o`2Ioooooooo06;oool00`000?ooooooo`2Ioooo000Ooooo00?o09Woooooool0H_ooo`030000
oooooooo09Woool001ooool00ol0VOooooooo`1Loooo0`0000?oool00`000?ooooooo`2Ioooo000O
oooo00?o09Woooooool0GOooo`030000oooooooo00;oool00`000?ooooooo`2Ioooo000Ooooo00?o
09Woooooool0F_ooo`D00003oooo0`0009Woool007coool010000?ooooooo`000:3oool007goool0
0`000?ooo`00002Poooo001noooo0P000:3oool00?oooolQoooo003ooooo8Oooo`00NOooo`030000
oooooooo02Soool00`000?ooooooo`1ioooo001hoooo00<0003oooooool02?ooo`030000oooooooo
01ooool00`000?ooooooo`1hoooo001hoooo00<0003oooooool00_ooo`800004oooo00<0003ooooo
ool03Oooo`800004oooo0P0000?oool300001?ooo`030000oooooooo07Soool007Soool01@000?oo
ooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo00Coool400000oooo`040000
oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo07Soool007Ooool00`000?oo
ooooo`02oooo00<0003oooooool05_ooo`030000oooooooo00Koool010000?ooooooo`0000Coool0
0`000?ooooooo`1goooo001hoooo00<0003oooooool01@0001?oool200002Oooo`<00004oooo00<0
003oooooool0N?ooo`00N?ooo`050000oooooooooooo000001Koool00`000?ooooooo`09oooo00<0
003oooooool00oooo`030000oooooooo07Soool007Woool00`000?ooooooo`0Goooo0`0000Woool3
00000_ooo`030000oooooooo07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-6.03535, \
-3.20105, 0.0455524, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-6.03535, -3.20105, 0.0455524, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.04262 .26487 L
.06244 .26487 L
.06747 .26487 L
.07024 .26487 L
.07286 .26487 L
.07404 .26487 L
.07529 .26487 L
s
.07529 .26487 m
.07555 .61803 L
s
0 .4 1 r
.02381 .17411 m
.04262 .1521 L
.06244 .12309 L
.06747 .11461 L
.07024 .10974 L
.07286 .10498 L
.07404 .10279 L
.07529 .10042 L
.07594 .26487 L
.07666 .26487 L
.07793 .26487 L
.08255 .26487 L
.10458 .26487 L
.14487 .26487 L
.18364 .26487 L
.22486 .26487 L
.26457 .26487 L
.30277 .26487 L
.34341 .26487 L
.38254 .26487 L
.42412 .26487 L
.46419 .26487 L
.50274 .26487 L
.54374 .26487 L
.58323 .26487 L
.6212 .26487 L
.66163 .26487 L
.70054 .26487 L
.7419 .26487 L
.78174 .26487 L
.82007 .26487 L
.86085 .26487 L
.90012 .26487 L
.93787 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001moooo0P000:7oool007coool010000?ooooooo`000:3oool007koool00`000?oo
ooooo`03oooo0`0009Woool007Koool400001Oooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo001loooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007coool200001_ooo`<0002I
oooo001foooo1P000004<ol00000000000001?ooo`030000oooooooo09Woool007Soool01@0003?o
03?o03?o00000002<ol00P0000?oool00`000?ooooooo`2Ioooo001goooo00<0000co`0co`000c?o
00800002<ol00P000003oooo0000oooo09[oool002?oool00`1Vooooooooo`1@oooo00<0000co`0c
o`002S?o0080002Koooo000Soooo00<0I_ooooooool0Coooo`030000<ol0<ol000`co`020000V_oo
o`008_ooo`80I_m@oooo00<0000co`0co`003C?o00030000oooooooo09Woool0027oool00`1Voooo
o`1Vo`1?oooo00<0000co`0co`003S?o0080002Joooo000Poooo00@0I_ooooooool0I_m?oooo00<0
000co`0co`003S?o00030000<ol0000009Woool0023oool0101Vooooooooo`1Vodkoool00`0003?o
03?o000?<ol00P000003<ol00000oooo09Ooool001ooool01@1Vooooooooooooo`1Vo`1>oooo00<0
000co`0co`003c?o00040000<ol0<ol00000V?ooo`007oooo`0506Kooooooooooooo06Ko04goool0
0`0003?o03?o000@<ol000D0000co`0co`0co`000000Uoooo`007_ooo`0306Kooooooooo00;oool0
0`1Vooooooooo`1;oooo00<0000co`0co`0043?o00030000<ol0<ol0008co`000`000?ooooooo`2D
oooo000Moooo00<0I_ooooooool00oooo`0306Kooooooooo04[oool00`0003?o03?o000A<ol000<0
000co`0co`000S?o00030000oooooooo09Coool001goool00`1Vooooooooo`03oooo00<0I_oooooo
ool0BOooo`030000<ol0<ol0018co`02000013?o00030000oooooooo09?oool001coool00`1Voooo
ooooo`04oooo00<0I_ooooooool0B?ooo`030000<ol0<ol001<co`000`0003?o03?o0004<ol000<0
003oooooool0T_ooo`007?ooo`0306Kooooooooo00Coool00`1Vooooooooo`18oooo00<0000co`0c
o`004c?o00030000<ol0<ol000@co`000`000?ooooooo`2Boooo000Koooo00<0I_ooooooool01Ooo
o`0306Kooooooooo04Ooool00`0003?o03?o000D<ol000<0000co`0co`001C?o00030000oooooooo
097oool001[oool00`1Vooooooooo`06oooo00<0I_ooooooool0A_ooo`030000<ol0<ol001Dco`02
00001c?o00030000oooooooo093oool001Woool00`1Vooooooooo`07oooo00<0I_ooooooool0AOoo
o`030000<ol0<ol001Hco`000`0003?o03?o0006<ol000<0003oooooool0T?ooo`006?ooo`0306Ko
oooooooo00Soool00`1Vooooooooo`15oooo00<0000co`0co`005S?o00030000<ol0<ol000Lco`00
0`000?ooooooo`2?oooo000Goooo00<0I_ooooooool02Oooo`0306Kooooooooo04Coool00`0003?o
03?o000?<ol01@0000<co`000`0003?o03?o0008<ol000<0003oooooool0S_ooo`005_ooo`0306Ko
oooooooo00[oool00`1Vooooooooo`13oooo00<0000co`0co`004S?o00030000<ol0<ol000<co`00
0`0003?o03?o0008<ol000<0003oooooool0S_ooo`008oooo`0306Kooooooooo04;oool00`0003?o
03?o000C<ol000<0000co`0co`000c?o00<00009<ol000<0003oooooool0SOooo`008oooo`0306Ko
oooooooo04;oool00`0003?o03?o000;<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`002S?o00030000oooooooo08coool002?oool00`1Vooooooooo`11oooo00<0000co`0co`0053?o
00030000<ol0<ol000<co`000`0003?o03?o000;<ol000<0003oooooool0Roooo`008oooo`0306Ko
oooooooo043oool00`0003?o03?o000D<ol00P0000Dco`000`0003?o03?o000;<ol000<0003ooooo
ool0Roooo`008oooo`0306Kooooooooo043oool00`0003?o03?o000K<ol00P0000dco`000`000?oo
ooooo`2:oooo000Soooo00<0I_ooooooool0?oooo`030000<ol0<ol001`co`000`0003?o03?o000=
<ol000<0003oooooool0ROooo`008oooo`0306Kooooooooo03koool00`0003?o03?o000M<ol000<0
000co`0co`003S?o00030000oooooooo08Soool002?oool00`1Vooooooooo`0moooo00<0000co`0c
o`007S?o00030000<ol0<ol000lco`000`000?ooooooo`27oooo000Soooo00<0I_ooooooool0?Ooo
o`030000<ol0<ol001hco`000`0003?o03?o000@<ol000<0003oooooool0Q_ooo`008oooo`0306Ko
oooooooo03coool00`0003?o03?o000O<ol00P00018co`000`000?ooooooo`25oooo000Soooo00<0
I_ooooooool0>oooo`030000<ol0<ol0020co`000`0003?o03?o000B<ol000<0003oooooool0Q?oo
o`008oooo`0306Kooooooooo00Woool300009oooo`@00002oooo0P0002<co`000`0003?o03?o000C
<ol000<0003oooooool04Oooo`@0000Zoooo0`0002Ooool300005oooo`008oooo`0306Kooooooooo
00[oool00`000?ooooooo`0Voooo00<0003oooooool00_ooo`030000<ol0<ol002<co`000`0003?o
03?o000D<ol000<0003oooooool04?ooo`030000oooooooo02coool00`000?ooooooo`0Voooo00@0
003oooooool0000Foooo000Soooo00<0I_ooooooool01oooo`D0000Xoooo00@0003oooooool0000V
<ol00P0001Hco`0200004Oooo`030000oooooooo02Soool500009oooo`040000oooooooo00005_oo
o`008oooo`0406Kooooooooooooo100000;oool010000?ooooooo`0002;oool400001?ooo`80000W
<ol000<0000co`0co`005c?o00030000oooooooo00ooool00`000?ooooooo`0Woooo00@0003ooooo
ool0000Xoooo0`0001Ooool002?oool00`1Vooooooooo`08oooo00<0003oool00000:?ooo`800000
0c?o000003?o000V<ol000<0000co`0co`0063?o00030000oooooooo00coool010000?ooooooo`00
02Woool00`000?ooo`00000Yoooo00<0003oooooool05_ooo`008oooo`0306Kooooooooo00Woool2
00009oooo`@0000X<ol000<0000co`0co`006C?o00030000oooooooo00coool20000:oooo`80000Y
oooo0`0001Koool002?oool00`1Vooooooooo`0`oooo0P0002`co`000`0003?o03?o000J<ol00P00
07goool002?oool00`1Vooooooooo`0^oooo0P0002hco`0200007C?o00<0001joooo000Soooo00<0
I_ooooooool0:oooo`<0000`<ol000<0000co`0co`007c?o00H0001doooo000Soooo00<0I_oooooo
ool09Oooo`H0000c<ol000<0000co`0co`009C?o00<0001aoooo000Soooo00<0I_ooooooool06ooo
o`X0000i<ol000<0000co`0co`00:3?o00X0001Woooo000@ooooo`00017oool001Koool00`000?oo
ooooo`08oooo00<0003ooooo09T02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0
003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?oo
o`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo
00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?oo
ooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0
003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool05Ooo
o`008oooo`03o`2Ioooooooo00Koool00`000?ooooooo`0Yoooo00<0003oooooool0:Oooo`030000
oooooooo02Woool00`000?ooooooo`0Yoooo00<0003oooooool0:Oooo`030000oooooooo01Goool0
02?oool00ol0VOooooooo`1Noooo00<0003oooooool0VOooo`008oooo`03o`2Ioooooooo05koool0
0`000?ooooooo`2Ioooo000Soooo00?o09Woooooool0G_ooo`80002Joooo000Soooo00?o09Wooooo
ool0G_ooo`030000oooooooo09Woool002?oool00ol0VOooooooo`1Noooo00<0003oooooool0VOoo
o`008oooo`03o`2Ioooooooo05koool00`000?ooooooo`2Ioooo000Soooo00?o09Woooooool0G_oo
o`80002Joooo000Soooo00?o09Woooooool0G_ooo`030000oooooooo09Woool002?oool00ol0VOoo
ooooo`1Noooo00<0003oooooool0VOooo`008oooo`03o`2Ioooooooo05koool00`000?ooooooo`2I
oooo000Soooo00?o09Woooooool0G_ooo`030000oooooooo09Woool002?oool00ol0VOooooooo`1N
oooo0P0009[oool002?oool00ol0VOooooooo`1Noooo00<0003oooooool0VOooo`008oooo`03o`2I
oooooooo05koool00`000?ooooooo`2Ioooo000Soooo00?o09Woooooool0G_ooo`030000oooooooo
09Woool002?oool00ol0VOooooooo`1Noooo0P0009[oool002?oool00ol0VOooooooo`1Noooo00<0
003oooooool0VOooo`008oooo`03o`2Ioooooooo05koool00`000?ooooooo`2Ioooo000Soooo00?o
09Woooooool0E_ooo`D00003oooo00<0003oooooool0VOooo`008oooo`03o`2Ioooooooo05Soool0
0`000?ooooooo`03oooo00<0003oooooool0VOooo`008oooo`03o`2Ioooooooo05Soool00`000?oo
ooooo`03oooo0`0009Woool002?oool00ol0VOooooooo`1Hoooo00<0003oooooool00oooo`030000
oooooooo09Woool002?oool00ol0VOooooooo`1Hoooo00<0003oooooool00oooo`030000oooooooo
09Woool002?oool00ol0VOooooooo`1Goooo0P0000Goool00`000?ooooooo`2Ioooo000Soooo00?o
09Woooooool0G_ooo`80002Joooo000Soooo00?o09Woooooool0G_ooo`030000oooooooo09Woool0
02?oool00ol0VOooooooo`1Noooo00<0003oooooool0VOooo`008oooo`03o`2Ioooooooo05koool0
0`000?ooooooo`2Ioooo000Soooo00?o09Woooooool0G_ooo`030000oooooooo09Woool002?oool0
0ol0VOooooooo`1Noooo0P0009[oool002?oool00ol0VOooooooo`1Noooo00<0003oooooool0VOoo
o`008oooo`03o`2Ioooooooo05koool00`000?ooooooo`2Ioooo000Soooo00?o09Woooooool0G_oo
o`030000oooooooo09Woool002?oool00ol0VOooooooo`1Noooo0P0009[oool002?oool00ol0VOoo
ooooo`1Noooo00<0003oooooool0VOooo`008oooo`03o`2Ioooooooo05koool00`000?ooooooo`2I
oooo000Soooo00?o09Woooooool0G_ooo`030000oooooooo09Woool002?oool00ol0VOooooooo`1N
oooo00<0003oooooool0VOooo`008oooo`03o`2Ioooooooo05koool20000V_ooo`008oooo`03o`2I
oooooooo05koool00`000?ooooooo`2Ioooo000Soooo00?o09Woooooool0E_ooo`@00004oooo00<0
003oooooool0VOooo`008oooo`03o`2Ioooooooo05Koool00`000?ooooooo`05oooo00<0003ooooo
ool0VOooo`008oooo`03o`2Ioooooooo05Ooool00`000?ooooooo`04oooo0`0009Woool002?oool0
0ol0VOooooooo`1Hoooo00<0003oooooool00oooo`030000oooooooo09Woool002?oool00ol0VOoo
ooooo`1Foooo00@0003oooooool00004oooo00<0003oooooool0VOooo`008oooo`03o`2Ioooooooo
05Ooool200001Oooo`030000oooooooo09Woool002?oool00ol0VOooooooo`1Noooo0P0009[oool0
02?oool00ol0VOooooooo`1Noooo00<0003oooooool0VOooo`008oooo`03o`2Ioooooooo05koool0
0`000?ooooooo`2Ioooo000Soooo00?o09Woooooool0G_ooo`030000oooooooo09Woool002?oool0
0ol0VOooooooo`1Noooo00<0003oooooool0VOooo`008oooo`03o`2Ioooooooo05koool20000V_oo
o`008oooo`03o`2Ioooooooo05koool00`000?ooooooo`2Ioooo000Soooo00?o09Woooooool0G_oo
o`030000oooooooo09Woool002?oool00ol0VOooooooo`1Noooo00<0003oooooool0VOooo`008ooo
o`03o`2Ioooooooo05koool20000V_ooo`008oooo`03o`2Ioooooooo05koool00`000?ooooooo`2I
oooo000Soooo00?o09Woooooool0G_ooo`030000oooooooo09Woool002?oool00ol0VOooooooo`1N
oooo00<0003oooooool0VOooo`008oooo`03o`2Ioooooooo05koool00`000?ooooooo`2Ioooo000S
oooo00?o09Woooooool0G_ooo`80002Joooo000Soooo00?o09Woooooool0G_ooo`030000oooooooo
09Woool002?oool00ol0VOooooooo`1Goooo0P0000Goool00`000?ooooooo`2Ioooo000Soooo00?o
09Woooooool0E_ooo`040000oooooooo00001?ooo`030000oooooooo09Woool002?oool00ol0VOoo
ooooo`1Hoooo00<0003oooooool00oooo`<0002Ioooo000Soooo00?o09Woooooool0FOooo`030000
oooooooo00;oool00`000?ooooooo`2Ioooo000Soooo00?o09Woooooool0E_ooo`040000oooooooo
00001?ooo`030000oooooooo09Woool002?oool00ol0VOooooooo`1Goooo0P0000Goool00`000?oo
ooooo`2Ioooo000Soooo00?o09Woooooool0G_ooo`030000oooooooo09Woool002?oool00ol0VOoo
ooooo`1Noooo0P0009[oool002?oool00ol0VOooooooo`1Noooo00<0003oooooool0VOooo`008ooo
o`03o`2Ioooooooo05koool00`000?ooooooo`2Ioooo000Soooo00?o09Woooooool0G_ooo`030000
oooooooo09Woool002?oool00ol0VOooooooo`1Noooo0P0009[oool002?oool00ol0VOooooooo`1N
oooo00<0003oooooool0VOooo`008oooo`03o`2Ioooooooo05koool00`000?ooooooo`2Ioooo000S
oooo00?o09Woooooool0G_ooo`030000oooooooo09Woool002?oool00ol0VOooooooo`1Noooo00<0
003oooooool0VOooo`008oooo`03o`2Ioooooooo05koool20000V_ooo`008oooo`03o`2Ioooooooo
05koool00`000?ooooooo`2Ioooo000Soooo00?o09Woooooool0G_ooo`030000oooooooo09Woool0
02?oool00ol0VOooooooo`1Noooo00<0003oooooool0VOooo`008oooo`03o`2Ioooooooo05koool2
0000V_ooo`008oooo`03o`2Ioooooooo05koool00`000?ooooooo`2Ioooo000Soooo00?o09Wooooo
ool0G_ooo`030000oooooooo09Woool002?oool00ol0VOooooooo`1Hoooo0`0000?oool00`000?oo
ooooo`2Ioooo000Soooo00?o09Woooooool0FOooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo000Soooo00?o09Woooooool0E_ooo`D00003oooo0`0009Woool007coool010000?ooooooo`00
0:3oool007goool00`000?ooo`00002Poooo001noooo0P000:3oool00?oooolQoooo003ooooo8Ooo
o`00NOooo`030000oooooooo02Soool00`000?ooooooo`1ioooo001hoooo00<0003oooooool02?oo
o`030000oooooooo01ooool00`000?ooooooo`1hoooo001hoooo00<0003oooooool00_ooo`800004
oooo00<0003oooooool03Oooo`800004oooo0P0000Goool300000_ooo`030000oooooooo07Soool0
07Soool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo00Coool4
00000oooo`040000oooooooo00002oooo`050000oooooooooooo000007[oool007Ooool00`000?oo
ooooo`02oooo00<0003oooooool05_ooo`030000oooooooo00Koool500000oooo`030000oooooooo
07Ooool007Soool00`000?ooooooo`0500004oooo`800009oooo00@0003oooooool00003oooo00<0
003oooooool0N?ooo`00N?ooo`050000oooooooooooo000001Koool00`000?ooooooo`09oooo00<0
003oool000000oooo`030000oooooooo07Soool007Woool00`000?ooooooo`0Goooo0`0000[oool2
00000_ooo`030000oooooooo07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-6.03535, \
-3.20105, 0.0455524, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-6.03535, -3.20105, 0.0455524, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.04262 .26487 L
.06244 .26487 L
.07216 .26487 L
.08255 .26487 L
.08562 .26487 L
.08852 .26487 L
.09113 .26487 L
.09184 .26487 L
.0926 .26487 L
s
.0926 .26487 m
.09286 .61803 L
s
0 .4 1 r
.02381 .19057 m
.04262 .17254 L
.06244 .14879 L
.07216 .13501 L
.08255 .11846 L
.08562 .11318 L
.08852 .10802 L
.09113 .10323 L
.09184 .10189 L
.0926 .10046 L
.09325 .26487 L
.09396 .26487 L
.10458 .26487 L
.14487 .26487 L
.18364 .26487 L
.22486 .26487 L
.26457 .26487 L
.30277 .26487 L
.34341 .26487 L
.38254 .26487 L
.42412 .26487 L
.46419 .26487 L
.50274 .26487 L
.54374 .26487 L
.58323 .26487 L
.6212 .26487 L
.66163 .26487 L
.70054 .26487 L
.7419 .26487 L
.78174 .26487 L
.82007 .26487 L
.86085 .26487 L
.90012 .26487 L
.93787 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001moooo0P000:7oool007coool010000?ooooooo`000:3oool007koool00`000?oo
ooooo`03oooo0`0009Woool007Koool400001Oooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo001loooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007coool200001_ooo`<0002I
oooo001foooo1P000004<ol00000000000001?ooo`030000oooooooo09Woool007Soool01@0003?o
03?o03?o00000002<ol00P0000?oool00`000?ooooooo`2Ioooo001goooo00<0000co`0co`000c?o
00800002<ol00P000003oooo0000oooo09[oool002Ooool206KoCOooo`030000<ol0<ol000Xco`02
0000Voooo`009oooo`80I_m<oooo00<0000co`0co`0033?o0080002Joooo000Voooo00<0I_ooool0
I_l0Boooo`030000<ol0<ol000dco`000`000?ooooooo`2Ioooo000Voooo00<0I_ooool0I_l0B_oo
o`030000<ol0<ol000hco`020000V_ooo`009Oooo`0406Kooooooooo06KoB_ooo`030000<ol0<ol0
00hco`000`0003?o0000002Ioooo000Toooo00D0I_ooooooooooool0I_l0BOooo`030000<ol0<ol0
00lco`02000000<co`00003oool0Uoooo`008oooo`0306Kooooooooo00;oool00`1Vooooooooo`17
oooo00<0000co`0co`003c?o00040000<ol0<ol00000V?ooo`008oooo`0306Kooooooooo00;oool0
0`1Vooooooooo`16oooo00<0000co`0co`0043?o00050000<ol0<ol0<ol0000009Ooool002;oool0
0`1Vooooooooo`03oooo00<0I_ooooooool0A_ooo`030000<ol0<ol0010co`000`0003?o03?o0002
<ol000<0003oooooool0U?ooo`008Oooo`0306Kooooooooo00Coool00`1Vooooooooo`15oooo00<0
000co`0co`004C?o00030000<ol0<ol0008co`000`000?ooooooo`2Doooo000Qoooo00<0I_oooooo
ool01?ooo`0306Kooooooooo04Coool00`0003?o03?o000B<ol00P0000@co`000`000?ooooooo`2C
oooo000Poooo00<0I_ooooooool01Oooo`0306Kooooooooo04?oool00`0003?o03?o000C<ol000<0
000co`0co`0013?o00030000oooooooo09;oool0023oool00`1Vooooooooo`05oooo00<0I_oooooo
ool0@oooo`030000<ol0<ol001<co`000`0003?o03?o0004<ol000<0003oooooool0T_ooo`007ooo
o`0306Kooooooooo00Koool00`1Vooooooooo`12oooo00<0000co`0co`0053?o00030000<ol0<ol0
00Dco`000`000?ooooooo`2Aoooo000Noooo00<0I_ooooooool01oooo`0306Kooooooooo047oool0
0`0003?o03?o000E<ol00P0000Lco`000`000?ooooooo`2@oooo000Moooo00<0I_ooooooool02?oo
o`0306Kooooooooo043oool00`0003?o03?o000F<ol000<0000co`0co`001S?o00030000oooooooo
093oool001goool00`1Vooooooooo`08oooo00<0I_ooooooool0@?ooo`030000<ol0<ol001Hco`00
0`0003?o03?o0007<ol000<0003oooooool0Soooo`007?ooo`0306Kooooooooo00Woool00`1Voooo
ooooo`0ooooo00<0000co`0co`003c?o00D00003<ol000<0000co`0co`0023?o00030000oooooooo
08koool001_oool00`1Vooooooooo`0:oooo00<0I_ooooooool0?_ooo`030000<ol0<ol0018co`00
0`0003?o03?o0003<ol000<0000co`0co`0023?o00030000oooooooo08koool001[oool00`1Voooo
ooooo`0;oooo00<0I_ooooooool0?Oooo`030000<ol0<ol001<co`000`0003?o03?o0003<ol00`00
00Tco`000`000?ooooooo`2=oooo000Hoooo0P1Vo`koool00`1Vooooooooo`0moooo00<0000co`0c
o`002c?o00@00004<ol000<0000co`0co`000c?o00030000<ol0<ol000Xco`000`000?ooooooo`2<
oooo000Goooo00<0I_ooooooool03_ooo`0306Kooooooooo03coool00`0003?o03?o000D<ol000<0
000co`0co`000c?o00030000<ol0<ol000/co`000`000?ooooooo`2;oooo000Foooo00<0I_oooooo
ool03oooo`0306Kooooooooo03_oool00`0003?o03?o000D<ol00P0000Dco`000`0003?o03?o000;
<ol000<0003oooooool0Roooo`00:?ooo`0306Kooooooooo03_oool00`0003?o03?o000K<ol00P00
00dco`000`000?ooooooo`2:oooo000Xoooo00<0I_ooooooool0>_ooo`030000<ol0<ol001`co`00
0`0003?o03?o000=<ol000<0003oooooool0ROooo`00:?ooo`0306Kooooooooo03Woool00`0003?o
03?o000M<ol000<0000co`0co`003S?o00030000oooooooo08Soool002Soool00`1Vooooooooo`0h
oooo00<0000co`0co`007S?o00030000<ol0<ol000lco`000`000?ooooooo`27oooo000Xoooo00<0
I_ooooooool0>?ooo`030000<ol0<ol001hco`000`0003?o03?o000@<ol000<0003oooooool0Q_oo
o`00:?ooo`0306Kooooooooo03Ooool00`0003?o03?o000O<ol00P00018co`000`000?ooooooo`25
oooo000Xoooo00<0I_ooooooool0=_ooo`030000<ol0<ol0020co`000`0003?o03?o000B<ol000<0
003oooooool0Q?ooo`00:?ooo`0306Kooooooooo00Coool300009oooo`@00002oooo0P0002<co`00
0`0003?o03?o000C<ol000<0003oooooool04Oooo`@0000Zoooo0`0002Ooool300005oooo`00:?oo
o`0306Kooooooooo00Goool00`000?ooooooo`0Voooo00<0003oooooool00_ooo`030000<ol0<ol0
02<co`000`0003?o03?o000D<ol000<0003oooooool04?ooo`030000oooooooo02coool00`000?oo
ooooo`0Voooo00@0003oooooool0000Foooo000Xoooo00<0I_ooooooool00_ooo`D0000Xoooo00@0
003oooooool0000V<ol00P0001Hco`0200004Oooo`030000oooooooo02Soool500009oooo`040000
oooooooo00005_ooo`009oooo`@00002oooo00@0003oooooool0000Roooo100000Coool200009c?o
00030000<ol0<ol001Lco`000`000?ooooooo`0?oooo00<0003oooooool09oooo`040000oooooooo
0000:?ooo`<0000Goooo000Xoooo00<0I_ooooooool00oooo`030000oooo000002Soool2000000<c
o`00000co`009S?o00030000<ol0<ol001Pco`000`000?ooooooo`0<oooo00@0003oooooool0000Y
oooo00<0003oool00000:Oooo`030000oooooooo01Koool002Soool00`1Vooooooooo`04oooo0P00
02Ooool40000:3?o00030000<ol0<ol001Tco`000`000?ooooooo`0<oooo0P0002_oool20000:Ooo
o`<0000Foooo000Xoooo00<0I_ooooooool0:oooo`80000/<ol000<0000co`0co`006S?o0080001m
oooo000Xoooo00<0I_ooooooool0:Oooo`80000^<ol00P0001dco`030000N_ooo`00:?ooo`0306Ko
oooooooo02Koool30000<3?o00030000<ol0<ol001lco`060000M?ooo`00:?ooo`0306Kooooooooo
023oool60000<c?o00030000<ol0<ol002Dco`030000LOooo`00:?ooo`0306Kooooooooo01Koool:
0000>C?o00030000<ol0<ol002Pco`0:0000Ioooo`004?ooool0000Aoooo000Foooo00<0003ooooo
ool02?ooo`030000oooooooo00Coool01Ol0VOooooooooooo`00000:oooo00<0003oooooool02?oo
o`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo
00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?oo
ooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0
003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?oo
o`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo
01Goool002Soool01Ol0VOooooooooooo`00000[oooo00<0003oooooool0:Oooo`030000oooooooo
02Woool00`000?ooooooo`0Yoooo00<0003oooooool0:Oooo`030000oooooooo01Goool002Soool0
0ol0VOooooooo`1Ioooo00<0003oooooool0VOooo`00:?ooo`03o`2Ioooooooo05Woool00`000?oo
ooooo`2Ioooo000Xoooo00?o09Woooooool0FOooo`80002Joooo000Xoooo00?o09Woooooool0FOoo
o`030000oooooooo09Woool002Soool00ol0VOooooooo`1Ioooo00<0003oooooool0VOooo`00:?oo
o`03o`2Ioooooooo05Woool00`000?ooooooo`2Ioooo000Xoooo00?o09Woooooool0FOooo`80002J
oooo000Xoooo00?o09Woooooool0FOooo`030000oooooooo09Woool002Soool00ol0VOooooooo`1I
oooo00<0003oooooool0VOooo`00:?ooo`03o`2Ioooooooo05Woool00`000?ooooooo`2Ioooo000X
oooo00?o09Woooooool0FOooo`030000oooooooo09Woool002Soool00ol0VOooooooo`1Ioooo0P00
09[oool002Soool00ol0VOooooooo`1Ioooo00<0003oooooool0VOooo`00:?ooo`03o`2Ioooooooo
05Woool00`000?ooooooo`2Ioooo000Xoooo00?o09Woooooool0FOooo`030000oooooooo09Woool0
02Soool00ol0VOooooooo`1Ioooo0P0009[oool002Soool00ol0VOooooooo`1Ioooo00<0003ooooo
ool0VOooo`00:?ooo`03o`2Ioooooooo05Woool00`000?ooooooo`2Ioooo000Xoooo00?o09Wooooo
ool0DOooo`D00003oooo00<0003oooooool0VOooo`00:?ooo`03o`2Ioooooooo05?oool00`000?oo
ooooo`03oooo00<0003oooooool0VOooo`00:?ooo`03o`2Ioooooooo05?oool00`000?ooooooo`03
oooo0`0009Woool002Soool00ol0VOooooooo`1Coooo00<0003oooooool00oooo`030000oooooooo
09Woool002Soool00ol0VOooooooo`1Coooo00<0003oooooool00oooo`030000oooooooo09Woool0
02Soool00ol0VOooooooo`1Boooo0P0000Goool00`000?ooooooo`2Ioooo000Xoooo00?o09Wooooo
ool0FOooo`80002Joooo000Xoooo00?o09Woooooool0FOooo`030000oooooooo09Woool002Soool0
0ol0VOooooooo`1Ioooo00<0003oooooool0VOooo`00:?ooo`03o`2Ioooooooo05Woool00`000?oo
ooooo`2Ioooo000Xoooo00?o09Woooooool0FOooo`030000oooooooo09Woool002Soool00ol0VOoo
ooooo`1Ioooo0P0009[oool002Soool00ol0VOooooooo`1Ioooo00<0003oooooool0VOooo`00:?oo
o`03o`2Ioooooooo05Woool00`000?ooooooo`2Ioooo000Xoooo00?o09Woooooool0FOooo`030000
oooooooo09Woool002Soool00ol0VOooooooo`1Ioooo0P0009[oool002Soool00ol0VOooooooo`1I
oooo00<0003oooooool0VOooo`00:?ooo`03o`2Ioooooooo05Woool00`000?ooooooo`2Ioooo000X
oooo00?o09Woooooool0FOooo`030000oooooooo09Woool002Soool00ol0VOooooooo`1Ioooo00<0
003oooooool0VOooo`00:?ooo`03o`2Ioooooooo05Woool20000V_ooo`00:?ooo`03o`2Ioooooooo
05Woool00`000?ooooooo`2Ioooo000Xoooo00?o09Woooooool0DOooo`@00004oooo00<0003ooooo
ool0VOooo`00:?ooo`03o`2Ioooooooo057oool00`000?ooooooo`05oooo00<0003oooooool0VOoo
o`00:?ooo`03o`2Ioooooooo05;oool00`000?ooooooo`04oooo0`0009Woool002Soool00ol0VOoo
ooooo`1Coooo00<0003oooooool00oooo`030000oooooooo09Woool002Soool00ol0VOooooooo`1A
oooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00:?ooo`03o`2Ioooooooo05;oool2
00001Oooo`030000oooooooo09Woool002Soool00ol0VOooooooo`1Ioooo0P0009[oool002Soool0
0ol0VOooooooo`1Ioooo00<0003oooooool0VOooo`00:?ooo`03o`2Ioooooooo05Woool00`000?oo
ooooo`2Ioooo000Xoooo00?o09Woooooool0FOooo`030000oooooooo09Woool002Soool00ol0VOoo
ooooo`1Ioooo00<0003oooooool0VOooo`00:?ooo`03o`2Ioooooooo05Woool20000V_ooo`00:?oo
o`03o`2Ioooooooo05Woool00`000?ooooooo`2Ioooo000Xoooo00?o09Woooooool0FOooo`030000
oooooooo09Woool002Soool00ol0VOooooooo`1Ioooo00<0003oooooool0VOooo`00:?ooo`03o`2I
oooooooo05Woool20000V_ooo`00:?ooo`03o`2Ioooooooo05Woool00`000?ooooooo`2Ioooo000X
oooo00?o09Woooooool0FOooo`030000oooooooo09Woool002Soool00ol0VOooooooo`1Ioooo00<0
003oooooool0VOooo`00:?ooo`03o`2Ioooooooo05Woool00`000?ooooooo`2Ioooo000Xoooo00?o
09Woooooool0FOooo`80002Joooo000Xoooo00?o09Woooooool0FOooo`030000oooooooo09Woool0
02Soool00ol0VOooooooo`1Boooo0P0000Goool00`000?ooooooo`2Ioooo000Xoooo00?o09Wooooo
ool0DOooo`040000oooooooo00001?ooo`030000oooooooo09Woool002Soool00ol0VOooooooo`1C
oooo00<0003oooooool00oooo`<0002Ioooo000Xoooo00?o09Woooooool0E?ooo`030000oooooooo
00;oool00`000?ooooooo`2Ioooo000Xoooo00?o09Woooooool0DOooo`040000oooooooo00001?oo
o`030000oooooooo09Woool002Soool00ol0VOooooooo`1Boooo0P0000Goool00`000?ooooooo`2I
oooo000Xoooo00?o09Woooooool0FOooo`030000oooooooo09Woool002Soool00ol0VOooooooo`1I
oooo0P0009[oool002Soool00ol0VOooooooo`1Ioooo00<0003oooooool0VOooo`00:?ooo`03o`2I
oooooooo05Woool00`000?ooooooo`2Ioooo000Xoooo00?o09Woooooool0FOooo`030000oooooooo
09Woool002Soool00ol0VOooooooo`1Ioooo0P0009[oool002Soool00ol0VOooooooo`1Ioooo00<0
003oooooool0VOooo`00:?ooo`03o`2Ioooooooo05Woool00`000?ooooooo`2Ioooo000Xoooo00?o
09Woooooool0FOooo`030000oooooooo09Woool002Soool00ol0VOooooooo`1Ioooo00<0003ooooo
ool0VOooo`00:?ooo`03o`2Ioooooooo05Woool20000V_ooo`00:?ooo`03o`2Ioooooooo05Woool0
0`000?ooooooo`2Ioooo000Xoooo00?o09Woooooool0FOooo`030000oooooooo09Woool002Soool0
0ol0VOooooooo`1Ioooo00<0003oooooool0VOooo`00:?ooo`03o`2Ioooooooo05Woool20000V_oo
o`00:?ooo`03o`2Ioooooooo05Woool00`000?ooooooo`2Ioooo000Xoooo00?o09Woooooool0FOoo
o`030000oooooooo09Woool002Soool00ol0VOooooooo`1Coooo0`0000?oool00`000?ooooooo`2I
oooo000Xoooo00?o09Woooooool0E?ooo`030000oooooooo00;oool00`000?ooooooo`2Ioooo000X
oooo00?o09Woooooool0DOooo`D00003oooo0`0009Woool007coool010000?ooooooo`000:3oool0
07goool00`000?ooo`00002Poooo001noooo0P000:3oool00?oooolQoooo003ooooo8Oooo`00NOoo
o`030000oooooooo02Soool00`000?ooooooo`1ioooo001hoooo00<0003oooooool02?ooo`030000
oooooooo01ooool00`000?ooooooo`1hoooo001hoooo00<0003oooooool00_ooo`800004oooo00<0
003oooooool03Oooo`800004oooo0P0000?oool400000oooo`030000oooooooo07Soool007Soool0
1@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo00Coool400000ooo
o`040000oooooooo00002?ooo`030000oooooooo00Coool00`000?ooooooo`1hoooo001goooo00<0
003oooooool00_ooo`030000oooooooo01Koool00`000?ooooooo`07oooo00<0003oooooool01?oo
o`030000oooooooo07Ooool007Soool00`000?ooooooo`0500004oooo`80000;oooo00<0003ooooo
ool00_ooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`00000Foooo00<0003ooooo
ool02?ooo`040000oooooooo00000oooo`030000oooooooo07Soool007Woool00`000?ooooooo`0G
oooo0`0000Woool200000oooo`030000oooooooo07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-6.03535, \
-3.20105, 0.0455524, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-6.03535, -3.20105, 0.0455524, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.08255 .26487 L
.0932 .26487 L
.09905 .26487 L
.10458 .26487 L
.10708 .26487 L
.10844 .26487 L
.10972 .26487 L
.11039 .26487 L
s
.11039 .26487 m
.11068 .61803 L
s
0 .4 1 r
.02381 .20404 m
.04262 .18928 L
.06244 .16983 L
.08255 .145 L
.09409 .12794 L
.09912 .11975 L
.10458 .11031 L
.10712 .10572 L
.10851 .10315 L
.10981 .1007 L
.11092 .26487 L
.11211 .26487 L
.11464 .26487 L
.12415 .26487 L
.14509 .26487 L
.18631 .26487 L
.22602 .26487 L
.26421 .26487 L
.30486 .26487 L
.34399 .26487 L
.38557 .26487 L
.42564 .26487 L
.46419 .26487 L
.50519 .26487 L
.54468 .26487 L
.58265 .26487 L
.62308 .26487 L
.66198 .26487 L
.70335 .26487 L
.74319 .26487 L
.78152 .26487 L
.8223 .26487 L
.86157 .26487 L
.89932 .26487 L
.93952 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001moooo0P000:7oool007coool010000?ooooooo`000:3oool007koool00`000?oo
ooooo`03oooo0`0009Woool007Koool400001Oooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo001loooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007coool200001_ooo`<0002I
oooo001foooo1P000004<ol00000000000001?ooo`030000oooooooo09Woool007Soool01@0003?o
03?o03?o00000002<ol00P0000?oool00`000?ooooooo`2Ioooo001goooo00<0000co`0co`000c?o
00800002<ol00P000003oooo0000oooo09[oool002coool00`1Vooooooooo`17oooo00<0000co`0c
o`002S?o0080002Koooo000[oooo0P1VodSoool00`0003?o03?o000<<ol00P0009[oool002_oool2
06KoAoooo`030000<ol0<ol000dco`000`000?ooooooo`2Ioooo000Zoooo00<0I_ooool0I_l0A_oo
o`030000<ol0<ol000hco`020000V_ooo`00:Oooo`0406Kooooooooo06KoA_ooo`030000<ol0<ol0
00hco`000`0003?o0000002Ioooo000Yoooo00@0I_ooooooool0I_m5oooo00<0000co`0co`003c?o
008000000c?o00000?ooo`2Goooo000Xoooo00D0I_ooooooooooool0I_l0AOooo`030000<ol0<ol0
00lco`00100003?o03?o000009Soool002Soool01@1Vooooooooooooo`1Vo`14oooo00<0000co`0c
o`0043?o00050000<ol0<ol0<ol0000009Ooool002Ooool00`1Vooooooooo`02oooo00<0I_oooooo
ool0@_ooo`030000<ol0<ol0010co`000`0003?o03?o0002<ol000<0003oooooool0U?ooo`009_oo
o`0306Kooooooooo00?oool00`1Vooooooooo`11oooo00<0000co`0co`004C?o00030000<ol0<ol0
008co`000`000?ooooooo`2Doooo000Voooo00<0I_ooooooool00oooo`0306Kooooooooo043oool0
0`0003?o03?o000B<ol00P0000@co`000`000?ooooooo`2Coooo000Uoooo00<0I_ooooooool01?oo
o`0306Kooooooooo03ooool00`0003?o03?o000C<ol000<0000co`0co`0013?o00030000oooooooo
09;oool002Coool00`1Vooooooooo`05oooo00<0I_ooooooool0?oooo`030000<ol0<ol001<co`00
0`0003?o03?o0004<ol000<0003oooooool0T_ooo`008oooo`0306Kooooooooo00Koool00`1Voooo
ooooo`0noooo00<0000co`0co`0053?o00030000<ol0<ol000Dco`000`000?ooooooo`2Aoooo000R
oooo00<0I_ooooooool01oooo`0306Kooooooooo03goool00`0003?o03?o000E<ol00P0000Lco`00
0`000?ooooooo`2@oooo000Roooo00<0I_ooooooool01oooo`0306Kooooooooo03coool00`0003?o
03?o000F<ol000<0000co`0co`001S?o00030000oooooooo093oool0027oool00`1Vooooooooo`08
oooo00<0I_ooooooool0??ooo`030000<ol0<ol001Hco`000`0003?o03?o0007<ol000<0003ooooo
ool0Soooo`008?ooo`0306Kooooooooo00Woool00`1Vooooooooo`0koooo00<0000co`0co`003c?o
00D00003<ol000<0000co`0co`0023?o00030000oooooooo08koool001ooool00`1Vooooooooo`0:
oooo00<0I_ooooooool0>_ooo`030000<ol0<ol0018co`000`0003?o03?o0003<ol000<0000co`0c
o`0023?o00030000oooooooo08koool001koool00`1Vooooooooo`0;oooo00<0I_ooooooool0>Ooo
o`030000<ol0<ol001<co`000`0003?o03?o0003<ol00`0000Tco`000`000?ooooooo`2=oooo000M
oooo00<0I_ooooooool03?ooo`0306Kooooooooo03Woool00`0003?o03?o000;<ol0100000@co`00
0`0003?o03?o0003<ol000<0000co`0co`002S?o00030000oooooooo08coool001coool00`1Voooo
ooooo`0=oooo00<0I_ooooooool0>?ooo`030000<ol0<ol001@co`000`0003?o03?o0003<ol000<0
000co`0co`002c?o00030000oooooooo08_oool001_oool00`1Vooooooooo`0>oooo00<0I_oooooo
ool0=oooo`030000<ol0<ol001@co`0200001C?o00030000<ol0<ol000/co`000`000?ooooooo`2;
oooo000Joooo00<0I_ooooooool03oooo`0306Kooooooooo03Ooool00`0003?o03?o000K<ol00P00
00dco`000`000?ooooooo`2:oooo000Hoooo0P1Voa;oool00`1Vooooooooo`0foooo00<0000co`0c
o`0073?o00030000<ol0<ol000dco`000`000?ooooooo`29oooo000Goooo00<0I_ooooooool04_oo
o`0306Kooooooooo03Goool00`0003?o03?o000M<ol000<0000co`0co`003S?o00030000oooooooo
08Soool001Koool00`1Vooooooooo`0Coooo00<0I_ooooooool0=?ooo`030000<ol0<ol001hco`00
0`0003?o03?o000?<ol000<0003oooooool0Qoooo`00;?ooo`0306Kooooooooo03Coool00`0003?o
03?o000N<ol000<0000co`0co`0043?o00030000oooooooo08Koool002coool00`1Vooooooooo`0c
oooo00<0000co`0co`007c?o0080000B<ol000<0003oooooool0QOooo`00;?ooo`0306Kooooooooo
03;oool00`0003?o03?o000P<ol000<0000co`0co`004S?o00030000oooooooo08Coool002coool0
0`1Vooooooooo`0300009oooo`@00002oooo0P0002<co`000`0003?o03?o000C<ol000<0003ooooo
ool04Oooo`@0000Zoooo0`0002Ooool300005oooo`00;?ooo`0506Kooooooooooooo000002Soool0
0`000?ooooooo`02oooo00<0000co`0co`008c?o00030000<ol0<ol001@co`000`000?ooooooo`0@
oooo00<0003oooooool0;?ooo`030000oooooooo02Koool010000?ooooooo`0001Koool002coool0
0`1Vo`00000000030000:?ooo`040000oooooooo00009S?o0080000F<ol00P00017oool00`000?oo
ooooo`0Xoooo1@0002Ooool010000?ooooooo`0001Koool002Ooool4000000?oool0I_l000000_oo
o`030000oooooooo023oool400001?ooo`80000W<ol000<0000co`0co`005c?o00030000oooooooo
00ooool00`000?ooooooo`0Woooo00@0003oooooool0000Xoooo0`0001Ooool002coool01@1Voooo
o`000?ooo`00000Xoooo0P000003<ol00000<ol002Hco`000`0003?o03?o000H<ol000<0003ooooo
ool03?ooo`040000oooooooo0000:Oooo`030000oooo000002Woool00`000?ooooooo`0Foooo000/
oooo00<0I_ooooooool00P0002Ooool40000:3?o00030000<ol0<ol001Tco`000`000?ooooooo`0<
oooo0P0002_oool20000:Oooo`<0000Foooo000/oooo00<0I_ooooooool09oooo`80000/<ol000<0
000co`0co`006S?o0080001moooo000/oooo00<0I_ooooooool09Oooo`80000^<ol00P0001dco`03
0000N_ooo`00;?ooo`0306Kooooooooo02;oool30000<3?o00030000<ol0<ol001lco`060000M?oo
o`00;?ooo`0306Kooooooooo01coool60000<c?o00030000<ol0<ol002Dco`030000LOooo`00;?oo
o`0306Kooooooooo01;oool:0000>C?o00030000<ol0<ol002Pco`0:0000Ioooo`004?ooool0000A
oooo000Foooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0
003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?oo
o`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo
00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?oo
ooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0
003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?oo
o`030000oooooooo01Goool002coool00`000?ooooooo`0Yoooo00<0003oooooool0:Oooo`030000
oooooooo02Woool00`000?ooooooo`0Yoooo00<0003oooooool0:Oooo`030000oooooooo01Goool0
02coool00ol0VOooooooo`1Eoooo00<0003oooooool0VOooo`00;?ooo`03o`2Ioooooooo05Goool0
0`000?ooooooo`2Ioooo000/oooo00?o09Woooooool0EOooo`80002Joooo000/oooo00?o09Wooooo
ool0EOooo`030000oooooooo09Woool002coool00ol0VOooooooo`1Eoooo00<0003oooooool0VOoo
o`00;?ooo`03o`2Ioooooooo05Goool00`000?ooooooo`2Ioooo000/oooo00?o09Woooooool0EOoo
o`80002Joooo000/oooo00?o09Woooooool0EOooo`030000oooooooo09Woool002coool00ol0VOoo
ooooo`1Eoooo00<0003oooooool0VOooo`00;?ooo`03o`2Ioooooooo05Goool00`000?ooooooo`2I
oooo000/oooo00?o09Woooooool0EOooo`030000oooooooo09Woool002coool00ol0VOooooooo`1E
oooo0P0009[oool002coool00ol0VOooooooo`1Eoooo00<0003oooooool0VOooo`00;?ooo`03o`2I
oooooooo05Goool00`000?ooooooo`2Ioooo000/oooo00?o09Woooooool0EOooo`030000oooooooo
09Woool002coool00ol0VOooooooo`1Eoooo0P0009[oool002coool00ol0VOooooooo`1Eoooo00<0
003oooooool0VOooo`00;?ooo`03o`2Ioooooooo05Goool00`000?ooooooo`2Ioooo000/oooo00?o
09Woooooool0COooo`D00003oooo00<0003oooooool0VOooo`00;?ooo`03o`2Ioooooooo04ooool0
0`000?ooooooo`03oooo00<0003oooooool0VOooo`00;?ooo`03o`2Ioooooooo04ooool00`000?oo
ooooo`03oooo0`0009Woool002coool00ol0VOooooooo`1?oooo00<0003oooooool00oooo`030000
oooooooo09Woool002coool00ol0VOooooooo`1?oooo00<0003oooooool00oooo`030000oooooooo
09Woool002coool00ol0VOooooooo`1>oooo0P0000Goool00`000?ooooooo`2Ioooo000/oooo00?o
09Woooooool0EOooo`80002Joooo000/oooo00?o09Woooooool0EOooo`030000oooooooo09Woool0
02coool00ol0VOooooooo`1Eoooo00<0003oooooool0VOooo`00;?ooo`03o`2Ioooooooo05Goool0
0`000?ooooooo`2Ioooo000/oooo00?o09Woooooool0EOooo`030000oooooooo09Woool002coool0
0ol0VOooooooo`1Eoooo0P0009[oool002coool00ol0VOooooooo`1Eoooo00<0003oooooool0VOoo
o`00;?ooo`03o`2Ioooooooo05Goool00`000?ooooooo`2Ioooo000/oooo00?o09Woooooool0EOoo
o`030000oooooooo09Woool002coool00ol0VOooooooo`1Eoooo0P0009[oool002coool00ol0VOoo
ooooo`1Eoooo00<0003oooooool0VOooo`00;?ooo`03o`2Ioooooooo05Goool00`000?ooooooo`2I
oooo000/oooo00?o09Woooooool0EOooo`030000oooooooo09Woool002coool00ol0VOooooooo`1E
oooo00<0003oooooool0VOooo`00;?ooo`03o`2Ioooooooo05Goool20000V_ooo`00;?ooo`03o`2I
oooooooo05Goool00`000?ooooooo`2Ioooo000/oooo00?o09Woooooool0COooo`@00004oooo00<0
003oooooool0VOooo`00;?ooo`03o`2Ioooooooo04goool00`000?ooooooo`05oooo00<0003ooooo
ool0VOooo`00;?ooo`03o`2Ioooooooo04koool00`000?ooooooo`04oooo0`0009Woool002coool0
0ol0VOooooooo`1?oooo00<0003oooooool00oooo`030000oooooooo09Woool002coool00ol0VOoo
ooooo`1=oooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00;?ooo`03o`2Ioooooooo
04koool200001Oooo`030000oooooooo09Woool002coool00ol0VOooooooo`1Eoooo0P0009[oool0
02coool00ol0VOooooooo`1Eoooo00<0003oooooool0VOooo`00;?ooo`03o`2Ioooooooo05Goool0
0`000?ooooooo`2Ioooo000/oooo00?o09Woooooool0EOooo`030000oooooooo09Woool002coool0
0ol0VOooooooo`1Eoooo00<0003oooooool0VOooo`00;?ooo`03o`2Ioooooooo05Goool20000V_oo
o`00;?ooo`03o`2Ioooooooo05Goool00`000?ooooooo`2Ioooo000/oooo00?o09Woooooool0EOoo
o`030000oooooooo09Woool002coool00ol0VOooooooo`1Eoooo00<0003oooooool0VOooo`00;?oo
o`03o`2Ioooooooo05Goool20000V_ooo`00;?ooo`03o`2Ioooooooo05Goool00`000?ooooooo`2I
oooo000/oooo00?o09Woooooool0EOooo`030000oooooooo09Woool002coool00ol0VOooooooo`1E
oooo00<0003oooooool0VOooo`00;?ooo`03o`2Ioooooooo05Goool00`000?ooooooo`2Ioooo000/
oooo00?o09Woooooool0EOooo`80002Joooo000/oooo00?o09Woooooool0EOooo`030000oooooooo
09Woool002coool00ol0VOooooooo`1>oooo0P0000Goool00`000?ooooooo`2Ioooo000/oooo00?o
09Woooooool0COooo`040000oooooooo00001?ooo`030000oooooooo09Woool002coool00ol0VOoo
ooooo`1?oooo00<0003oooooool00oooo`<0002Ioooo000/oooo00?o09Woooooool0D?ooo`030000
oooooooo00;oool00`000?ooooooo`2Ioooo000/oooo00?o09Woooooool0COooo`040000oooooooo
00001?ooo`030000oooooooo09Woool002coool00ol0VOooooooo`1>oooo0P0000Goool00`000?oo
ooooo`2Ioooo000/oooo00?o09Woooooool0EOooo`030000oooooooo09Woool002coool00ol0VOoo
ooooo`1Eoooo0P0009[oool002coool00ol0VOooooooo`1Eoooo00<0003oooooool0VOooo`00;?oo
o`03o`2Ioooooooo05Goool00`000?ooooooo`2Ioooo000/oooo00?o09Woooooool0EOooo`030000
oooooooo09Woool002coool00ol0VOooooooo`1Eoooo0P0009[oool002coool00ol0VOooooooo`1E
oooo00<0003oooooool0VOooo`00;?ooo`03o`2Ioooooooo05Goool00`000?ooooooo`2Ioooo000/
oooo00?o09Woooooool0EOooo`030000oooooooo09Woool002coool00ol0VOooooooo`1Eoooo00<0
003oooooool0VOooo`00;?ooo`03o`2Ioooooooo05Goool20000V_ooo`00;?ooo`03o`2Ioooooooo
05Goool00`000?ooooooo`2Ioooo000/oooo00?o09Woooooool0EOooo`030000oooooooo09Woool0
02coool00ol0VOooooooo`1Eoooo00<0003oooooool0VOooo`00;?ooo`03o`2Ioooooooo05Goool2
0000V_ooo`00;?ooo`03o`2Ioooooooo05Goool00`000?ooooooo`2Ioooo000/oooo00?o09Wooooo
ool0EOooo`030000oooooooo09Woool002coool00ol0VOooooooo`1?oooo0`0000?oool00`000?oo
ooooo`2Ioooo000/oooo00?o09Woooooool0D?ooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo000/oooo00?o09Woooooool0COooo`D00003oooo0`0009Woool007coool010000?ooooooo`00
0:3oool007goool00`000?ooo`00002Poooo001noooo0P000:3oool00?oooolQoooo003ooooo8Ooo
o`00O?ooo`030000oooooooo02;oool00`000?ooooooo`1loooo001koooo00<0003oooooool02?oo
o`030000oooooooo01Woool00`000?ooooooo`1koooo001koooo00<0003oooooool00_ooo`800004
oooo00<0003oooooool03Oooo`800004oooo0P0000Coool00`000?ooooooo`1koooo001koooo00D0
003oooooooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`04oooo100000?oool0
10000?ooooooo`0000Woool00`000?ooooooo`1koooo001joooo00<0003oooooool00_ooo`030000
oooooooo01Koool00`000?ooooooo`08oooo00<0003oooooool0N_ooo`00Noooo`030000oooooooo
00D0000Coooo0P0000[oool00`000?ooooooo`1koooo001koooo00D0003oooooooooool000005_oo
o`030000oooooooo00Woool00`000?ooooooo`1koooo001loooo00<0003oooooool05oooo`<00008
oooo00<0003oooooool0O?ooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-6.03535, \
-3.20105, 0.0455524, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-6.03535, -3.20105, 0.0455524, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.08255 .26487 L
.10458 .26487 L
.11448 .26487 L
.11992 .26487 L
.1226 .26487 L
.12507 .26487 L
.12627 .26487 L
.12739 .26487 L
s
.12739 .26487 m
.12786 .61803 L
s
0 .4 1 r
.02381 .21507 m
.04262 .20298 L
.06244 .18706 L
.08255 .16673 L
.10458 .13833 L
.11464 .12276 L
.11959 .11442 L
.12415 .10629 L
.12547 .10386 L
.1267 .10156 L
.12799 .26487 L
.12867 .26487 L
.12941 .26487 L
.13511 .26487 L
.14509 .26487 L
.18631 .26487 L
.22602 .26487 L
.26421 .26487 L
.30486 .26487 L
.34399 .26487 L
.38557 .26487 L
.42564 .26487 L
.46419 .26487 L
.50519 .26487 L
.54468 .26487 L
.58265 .26487 L
.62308 .26487 L
.66198 .26487 L
.70335 .26487 L
.74319 .26487 L
.78152 .26487 L
.8223 .26487 L
.86157 .26487 L
.89932 .26487 L
.93952 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001moooo0P000:7oool007coool010000?ooooooo`000:3oool007koool00`000?oo
ooooo`03oooo0`0009Woool007Koool400001Oooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo001loooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007coool200001_ooo`<0002I
oooo001foooo1P000004<ol00000000000001?ooo`030000oooooooo09Woool007Soool01@0003?o
03?o03?o00000002<ol00P0000?oool00`000?ooooooo`2Ioooo001goooo00<0000co`0co`000c?o
00800002<ol00P000003oooo0000oooo09[oool0033oool00`1Vooooooooo`13oooo00<0000co`0c
o`002S?o0080002Koooo000`oooo00<0I_ooooooool0@_ooo`030000<ol0<ol000`co`020000V_oo
o`00;oooo`80I_m3oooo00<0000co`0co`003C?o00030000oooooooo09Woool002ooool206Ko@_oo
o`030000<ol0<ol000hco`020000V_ooo`00;_ooo`0306Kooooo06Ko04;oool00`0003?o03?o000>
<ol000<0000co`000000VOooo`00;Oooo`0406Kooooooooo06Ko@Oooo`030000<ol0<ol000lco`02
000000<co`00003oool0Uoooo`00;?ooo`0506Kooooooooooooo06Ko047oool00`0003?o03?o000?
<ol000@0000co`0co`00002Hoooo000/oooo00D0I_ooooooooooool0I_l0@?ooo`030000<ol0<ol0
010co`001@0003?o03?o03?o0000002Goooo000[oooo00<0I_ooooooool00_ooo`0306Kooooooooo
03koool00`0003?o03?o000@<ol000<0000co`0co`000S?o00030000oooooooo09Coool002_oool0
0`1Vooooooooo`02oooo00<0I_ooooooool0?Oooo`030000<ol0<ol0014co`000`0003?o03?o0002
<ol000<0003oooooool0U?ooo`00:_ooo`0306Kooooooooo00?oool00`1Vooooooooo`0loooo00<0
000co`0co`004S?o00800004<ol000<0003oooooool0Toooo`00:Oooo`0306Kooooooooo00Coool0
0`1Vooooooooo`0koooo00<0000co`0co`004c?o00030000<ol0<ol000@co`000`000?ooooooo`2B
oooo000Xoooo00<0I_ooooooool01Oooo`0306Kooooooooo03_oool00`0003?o03?o000C<ol000<0
000co`0co`0013?o00030000oooooooo09;oool002Soool00`1Vooooooooo`05oooo00<0I_oooooo
ool0>_ooo`030000<ol0<ol001@co`000`0003?o03?o0005<ol000<0003oooooool0TOooo`009ooo
o`0306Kooooooooo00Koool00`1Vooooooooo`0ioooo00<0000co`0co`005C?o00800007<ol000<0
003oooooool0T?ooo`009_ooo`0306Kooooooooo00Ooool00`1Vooooooooo`0hoooo00<0000co`0c
o`005S?o00030000<ol0<ol000Hco`000`000?ooooooo`2@oooo000Uoooo00<0I_ooooooool02?oo
o`0306Kooooooooo03Soool00`0003?o03?o000F<ol000<0000co`0co`001c?o00030000oooooooo
08ooool002Coool00`1Vooooooooo`09oooo00<0I_ooooooool0=oooo`030000<ol0<ol000lco`05
00000c?o00030000<ol0<ol000Pco`000`000?ooooooo`2>oooo000Soooo00<0I_ooooooool02_oo
o`0306Kooooooooo03Koool00`0003?o03?o000B<ol000<0000co`0co`000c?o00030000<ol0<ol0
00Pco`000`000?ooooooo`2>oooo000Roooo00<0I_ooooooool02oooo`0306Kooooooooo03Goool0
0`0003?o03?o000C<ol000<0000co`0co`000c?o00<00009<ol000<0003oooooool0SOooo`008Ooo
o`0306Kooooooooo00coool00`1Vooooooooo`0eoooo00<0000co`0co`002c?o00@00004<ol000<0
000co`0co`000c?o00030000<ol0<ol000Xco`000`000?ooooooo`2<oooo000Poooo00<0I_oooooo
ool03_ooo`0306Kooooooooo03?oool00`0003?o03?o000D<ol000<0000co`0co`000c?o00030000
<ol0<ol000/co`000`000?ooooooo`2;oooo000Ooooo00<0I_ooooooool03oooo`0306Kooooooooo
03;oool00`0003?o03?o000D<ol00P0000Dco`000`0003?o03?o000;<ol000<0003oooooool0Rooo
o`007_ooo`0306Kooooooooo013oool00`1Vooooooooo`0boooo00<0000co`0co`006c?o0080000=
<ol000<0003oooooool0R_ooo`007Oooo`0306Kooooooooo017oool00`1Vooooooooo`0aoooo00<0
000co`0co`0073?o00030000<ol0<ol000dco`000`000?ooooooo`29oooo000Loooo00<0I_oooooo
ool04_ooo`0306Kooooooooo033oool00`0003?o03?o000M<ol000<0000co`0co`003S?o00030000
oooooooo08Soool001_oool00`1Vooooooooo`0Coooo00<0I_ooooooool0;oooo`030000<ol0<ol0
01hco`000`0003?o03?o000?<ol000<0003oooooool0Qoooo`006Oooo`80I_lFoooo00<0I_oooooo
ool0;oooo`030000<ol0<ol001hco`000`0003?o03?o000@<ol000<0003oooooool0Q_ooo`005ooo
o`80I_lHoooo00<0I_ooooooool0;_ooo`030000<ol0<ol001lco`0200004S?o00030000oooooooo
08Goool001Koool00`1Vooooooooo`0Hoooo00<0I_ooooooool0;Oooo`030000<ol0<ol0020co`00
0`0003?o03?o000B<ol000<0003oooooool0Q?ooo`00;oooo`<0000Woooo100000;oool200008c?o
00030000<ol0<ol001<co`000`000?ooooooo`0Aoooo100002[oool300009oooo`<0000Goooo000`
oooo00<00000I_ooool09_ooo`030000oooooooo00;oool00`0003?o03?o000S<ol000<0000co`0c
o`0053?o00030000oooooooo013oool00`000?ooooooo`0/oooo00<0003oooooool09_ooo`040000
oooooooo00005_ooo`00;Oooo`D0000Xoooo00@0003oooooool0000V<ol00P0001Hco`0200004Ooo
o`030000oooooooo02Soool500009oooo`040000oooooooo00005_ooo`009oooo`@00002oooo00D0
003oooooool00000I_l08Oooo`@00004oooo0P0002Lco`000`0003?o03?o000G<ol000<0003ooooo
ool03oooo`030000oooooooo02Ooool010000?ooooooo`0002Soool300005oooo`00;_ooo`040000
oooo000006Ko9oooo`8000000c?o000003?o000V<ol000<0000co`0co`0063?o00030000oooooooo
00coool010000?ooooooo`0002Woool00`000?ooo`00000Yoooo00<0003oooooool05_ooo`00;ooo
o`8000000`1Vooooooooo`0Toooo100002Pco`000`0003?o03?o000I<ol000<0003oooooool03?oo
o`80000[oooo0P0002Woool300005_ooo`00<Oooo`0306Kooooooooo02;oool20000;3?o00030000
<ol0<ol001Xco`020000OOooo`00<Oooo`0306Kooooooooo023oool20000;S?o0080000M<ol00`00
07[oool0037oool00`1Vooooooooo`0Moooo0`00030co`000`0003?o03?o000O<ol01P0007Coool0
037oool00`1Vooooooooo`0Goooo1P0003<co`000`0003?o03?o000U<ol00`00077oool0037oool0
0`1Vooooooooo`0=oooo2P0003Tco`000`0003?o03?o000X<ol02P0006Ooool0013ooooo00004Ooo
o`005_ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00D0003ooooooooooooo09T01_oo
o`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo
00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?oo
ooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0
003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?oo
o`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo
00Soool00`000?ooooooo`0Eoooo000/oooo00D0003ooooooooooooo09T09oooo`030000oooooooo
02Woool00`000?ooooooo`0Yoooo00<0003oooooool0:Oooo`030000oooooooo02Woool00`000?oo
ooooo`0Eoooo000`oooo00?o09Woooooool0DOooo`030000oooooooo09Woool0033oool00ol0VOoo
ooooo`1Aoooo00<0003oooooool0VOooo`00<?ooo`03o`2Ioooooooo057oool20000V_ooo`00<?oo
o`03o`2Ioooooooo057oool00`000?ooooooo`2Ioooo000`oooo00?o09Woooooool0DOooo`030000
oooooooo09Woool0033oool00ol0VOooooooo`1Aoooo00<0003oooooool0VOooo`00<?ooo`03o`2I
oooooooo057oool20000V_ooo`00<?ooo`03o`2Ioooooooo057oool00`000?ooooooo`2Ioooo000`
oooo00?o09Woooooool0DOooo`030000oooooooo09Woool0033oool00ol0VOooooooo`1Aoooo00<0
003oooooool0VOooo`00<?ooo`03o`2Ioooooooo057oool00`000?ooooooo`2Ioooo000`oooo00?o
09Woooooool0DOooo`80002Joooo000`oooo00?o09Woooooool0DOooo`030000oooooooo09Woool0
033oool00ol0VOooooooo`1Aoooo00<0003oooooool0VOooo`00<?ooo`03o`2Ioooooooo057oool0
0`000?ooooooo`2Ioooo000`oooo00?o09Woooooool0DOooo`80002Joooo000`oooo00?o09Wooooo
ool0DOooo`030000oooooooo09Woool0033oool00ol0VOooooooo`1Aoooo00<0003oooooool0VOoo
o`00<?ooo`03o`2Ioooooooo04Woool500000oooo`030000oooooooo09Woool0033oool00ol0VOoo
ooooo`1;oooo00<0003oooooool00oooo`030000oooooooo09Woool0033oool00ol0VOooooooo`1;
oooo00<0003oooooool00oooo`<0002Ioooo000`oooo00?o09Woooooool0Boooo`030000oooooooo
00?oool00`000?ooooooo`2Ioooo000`oooo00?o09Woooooool0Boooo`030000oooooooo00?oool0
0`000?ooooooo`2Ioooo000`oooo00?o09Woooooool0B_ooo`800005oooo00<0003oooooool0VOoo
o`00<?ooo`03o`2Ioooooooo057oool20000V_ooo`00<?ooo`03o`2Ioooooooo057oool00`000?oo
ooooo`2Ioooo000`oooo00?o09Woooooool0DOooo`030000oooooooo09Woool0033oool00ol0VOoo
ooooo`1Aoooo00<0003oooooool0VOooo`00<?ooo`03o`2Ioooooooo057oool00`000?ooooooo`2I
oooo000`oooo00?o09Woooooool0DOooo`80002Joooo000`oooo00?o09Woooooool0DOooo`030000
oooooooo09Woool0033oool00ol0VOooooooo`1Aoooo00<0003oooooool0VOooo`00<?ooo`03o`2I
oooooooo057oool00`000?ooooooo`2Ioooo000`oooo00?o09Woooooool0DOooo`80002Joooo000`
oooo00?o09Woooooool0DOooo`030000oooooooo09Woool0033oool00ol0VOooooooo`1Aoooo00<0
003oooooool0VOooo`00<?ooo`03o`2Ioooooooo057oool00`000?ooooooo`2Ioooo000`oooo00?o
09Woooooool0DOooo`030000oooooooo09Woool0033oool00ol0VOooooooo`1Aoooo0P0009[oool0
033oool00ol0VOooooooo`1Aoooo00<0003oooooool0VOooo`00<?ooo`03o`2Ioooooooo04Woool4
00001?ooo`030000oooooooo09Woool0033oool00ol0VOooooooo`19oooo00<0003oooooool01Ooo
o`030000oooooooo09Woool0033oool00ol0VOooooooo`1:oooo00<0003oooooool01?ooo`<0002I
oooo000aoooo00?o09Woooooool0B_ooo`030000oooooooo00?oool00`000?ooooooo`2Ioooo000a
oooo00?o09Woooooool0B?ooo`040000oooooooo00001?ooo`030000oooooooo09Woool0037oool0
0ol0VOooooooo`19oooo0P0000Goool00`000?ooooooo`2Ioooo000aoooo00?o09Woooooool0D?oo
o`80002Joooo000aoooo00?o09Woooooool0D?ooo`030000oooooooo09Woool0037oool00ol0VOoo
ooooo`1@oooo00<0003oooooool0VOooo`00<Oooo`03o`2Ioooooooo053oool00`000?ooooooo`2I
oooo000aoooo00?o09Woooooool0D?ooo`030000oooooooo09Woool0037oool00ol0VOooooooo`1@
oooo0P0009[oool0037oool00ol0VOooooooo`1@oooo00<0003oooooool0VOooo`00<Oooo`03o`2I
oooooooo053oool00`000?ooooooo`2Ioooo000aoooo00?o09Woooooool0D?ooo`030000oooooooo
09Woool0037oool00ol0VOooooooo`1@oooo0P0009[oool0037oool00ol0VOooooooo`1@oooo00<0
003oooooool0VOooo`00<Oooo`03o`2Ioooooooo053oool00`000?ooooooo`2Ioooo000aoooo00?o
09Woooooool0D?ooo`030000oooooooo09Woool0037oool00ol0VOooooooo`1@oooo00<0003ooooo
ool0VOooo`00<Oooo`03o`2Ioooooooo053oool20000V_ooo`00<Oooo`03o`2Ioooooooo053oool0
0`000?ooooooo`2Ioooo000aoooo00?o09Woooooool0BOooo`800005oooo00<0003oooooool0VOoo
o`00<Oooo`03o`2Ioooooooo04Soool010000?ooooooo`0000Coool00`000?ooooooo`2Ioooo000a
oooo00?o09Woooooool0B_ooo`030000oooooooo00?oool30000VOooo`00<Oooo`03o`2Ioooooooo
04_oool00`000?ooooooo`02oooo00<0003oooooool0VOooo`00<Oooo`03o`2Ioooooooo04Soool0
10000?ooooooo`0000Coool00`000?ooooooo`2Ioooo000aoooo00?o09Woooooool0BOooo`800005
oooo00<0003oooooool0VOooo`00<Oooo`03o`2Ioooooooo053oool00`000?ooooooo`2Ioooo000a
oooo00?o09Woooooool0D?ooo`80002Joooo000aoooo00?o09Woooooool0D?ooo`030000oooooooo
09Woool0037oool00ol0VOooooooo`1@oooo00<0003oooooool0VOooo`00<Oooo`03o`2Ioooooooo
053oool00`000?ooooooo`2Ioooo000aoooo00?o09Woooooool0D?ooo`80002Joooo000aoooo00?o
09Woooooool0D?ooo`030000oooooooo09Woool0037oool00ol0VOooooooo`1@oooo00<0003ooooo
ool0VOooo`00<Oooo`03o`2Ioooooooo053oool00`000?ooooooo`2Ioooo000aoooo00?o09Wooooo
ool0D?ooo`030000oooooooo09Woool0037oool00ol0VOooooooo`1@oooo0P0009[oool0037oool0
0ol0VOooooooo`1@oooo00<0003oooooool0VOooo`00<Oooo`03o`2Ioooooooo053oool00`000?oo
ooooo`2Ioooo000aoooo00?o09Woooooool0D?ooo`030000oooooooo09Woool0037oool00ol0VOoo
ooooo`1@oooo0P0009[oool0037oool00ol0VOooooooo`1@oooo00<0003oooooool0VOooo`00<Ooo
o`03o`2Ioooooooo053oool00`000?ooooooo`2Ioooo000aoooo00?o09Woooooool0B_ooo`<00003
oooo00<0003oooooool0VOooo`00<Oooo`03o`2Ioooooooo04_oool00`000?ooooooo`02oooo00<0
003oooooool0VOooo`00<Oooo`03o`2Ioooooooo04Soool500000oooo`<0002Ioooo001loooo00@0
003oooooool0002Poooo001moooo00<0003oool00000X?ooo`00O_ooo`80002Poooo003ooooo8Ooo
o`00ooooob7oool007Woool00`000?ooooooo`0Xoooo00<0003oooooool0NOooo`00N?ooo`030000
oooooooo00Soool00`000?ooooooo`0Ooooo00<0003oooooool0N?ooo`00N?ooo`030000oooooooo
00;oool200001?ooo`030000oooooooo00koool300000_ooo`800004oooo0P0000Coool00`000?oo
ooooo`1hoooo001hoooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?oo
ooooo`04oooo100000Koool00`000?ooooooo`06oooo00@0003oooooool00003oooo00<0003ooooo
ool0N?ooo`00Moooo`030000oooooooo00;oool00`000?ooooooo`0Coooo1@0000Ooool010000?oo
ooooo`0000Coool00`000?ooooooo`1goooo001hoooo00<0003oooooool01@0001;oool010000?oo
ooooo`0000Woool200001?ooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`00000F
oooo00<0003oool000002?ooo`040000oooooooo00000oooo`030000oooooooo07Soool007Woool0
0`000?ooooooo`0Hoooo0P0000Woool200000oooo`030000oooooooo07Woool00?oooolQoooo003o
oooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-6.03535, \
-3.20105, 0.0455524, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-6.03535, -3.20105, 0.0455524, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.12507 .26487 L
.13506 .26487 L
.13979 .26487 L
.14186 .26487 L
.14305 .26487 L
.14415 .26487 L
s
.14415 .26487 m
.14458 .61803 L
s
0 .4 1 r
.02381 .22409 m
.04262 .2142 L
.06244 .20117 L
.08255 .18453 L
.10458 .16127 L
.12415 .13504 L
.12979 .12633 L
.13511 .11755 L
.1399 .10921 L
.14121 .10684 L
.1426 .10429 L
.14378 .10209 L
.14509 .26487 L
.14638 .26487 L
.14757 .26487 L
.15028 .26487 L
.15522 .26487 L
.1645 .26487 L
.18538 .26487 L
.22451 .26487 L
.26609 .26487 L
.30615 .26487 L
.34471 .26487 L
.38571 .26487 L
.4252 .26487 L
.46317 .26487 L
.50359 .26487 L
.5425 .26487 L
.58386 .26487 L
.62371 .26487 L
.66204 .26487 L
.70282 .26487 L
.74208 .26487 L
.77984 .26487 L
.82004 .26487 L
.85873 .26487 L
.89987 .26487 L
.93949 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001moooo0P000:7oool007coool010000?ooooooo`000:3oool007koool00`000?oo
ooooo`03oooo0`0009Woool007Koool400001Oooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo001loooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007coool200001_ooo`<0002I
oooo001foooo1P000004<ol00000000000001?ooo`030000oooooooo09Woool007Soool01@0003?o
03?o03?o00000002<ol00P0000?oool00`000?ooooooo`2Ioooo001goooo00<0000co`0co`000c?o
00800002<ol00P000003oooo0000oooo09[oool003Goool00`1Vooooooooo`0noooo00<0000co`0c
o`002S?o0080002Koooo000doooo0P1Vocooool00`0003?o03?o000<<ol00P0009[oool003Coool2
06Ko?_ooo`030000<ol0<ol000dco`000`000?ooooooo`2Ioooo000coooo00<0I_ooool0I_l0?Ooo
o`030000<ol0<ol000hco`020000V_ooo`00<_ooo`0406Kooooooooo06Ko?Oooo`030000<ol0<ol0
00hco`000`0003?o0000002Ioooo000aoooo00D0I_ooooooooooool0I_l0??ooo`030000<ol0<ol0
00lco`02000000<co`00003oool0Uoooo`00<Oooo`0506Kooooooooooooo06Ko03coool00`0003?o
03?o000?<ol000@0000co`0co`00002Hoooo000`oooo00<0I_ooooooool00_ooo`0306Kooooooooo
03Woool00`0003?o03?o000@<ol000D0000co`0co`0co`000000Uoooo`00<?ooo`0306Kooooooooo
00;oool00`1Vooooooooo`0ioooo00<0000co`0co`0043?o00030000<ol0<ol0008co`000`000?oo
ooooo`2Doooo000_oooo00<0I_ooooooool00oooo`0306Kooooooooo03Soool00`0003?o03?o000A
<ol000<0000co`0co`000S?o00030000oooooooo09Coool002ooool00`1Vooooooooo`03oooo00<0
I_ooooooool0=oooo`030000<ol0<ol0018co`02000013?o00030000oooooooo09?oool002koool0
0`1Vooooooooo`04oooo00<0I_ooooooool0=_ooo`030000<ol0<ol001<co`000`0003?o03?o0004
<ol000<0003oooooool0T_ooo`00;Oooo`0306Kooooooooo00Goool00`1Vooooooooo`0foooo00<0
000co`0co`004c?o00030000<ol0<ol000@co`000`000?ooooooo`2Boooo000/oooo00<0I_oooooo
ool01_ooo`0306Kooooooooo03Goool00`0003?o03?o000D<ol000<0000co`0co`001C?o00030000
oooooooo097oool002coool00`1Vooooooooo`06oooo00<0I_ooooooool0=?ooo`030000<ol0<ol0
01Dco`0200001c?o00030000oooooooo093oool002_oool00`1Vooooooooo`07oooo00<0I_oooooo
ool0<oooo`030000<ol0<ol001Hco`000`0003?o03?o0006<ol000<0003oooooool0T?ooo`00:_oo
o`0306Kooooooooo00Soool00`1Vooooooooo`0coooo00<0000co`0co`005S?o00030000<ol0<ol0
00Lco`000`000?ooooooo`2?oooo000Yoooo00<0I_ooooooool02Oooo`0306Kooooooooo03;oool0
0`0003?o03?o000?<ol01@0000<co`000`0003?o03?o0008<ol000<0003oooooool0S_ooo`00:?oo
o`0306Kooooooooo00[oool00`1Vooooooooo`0aoooo00<0000co`0co`004S?o00030000<ol0<ol0
00<co`000`0003?o03?o0008<ol000<0003oooooool0S_ooo`009oooo`0306Kooooooooo00_oool0
0`1Vooooooooo`0`oooo00<0000co`0co`004c?o00030000<ol0<ol000<co`0300002C?o00030000
oooooooo08goool002Koool00`1Vooooooooo`0<oooo00<0I_ooooooool0<?ooo`030000<ol0<ol0
00/co`04000013?o00030000<ol0<ol000<co`000`0003?o03?o000:<ol000<0003oooooool0S?oo
o`009Oooo`0306Kooooooooo00goool00`1Vooooooooo`0_oooo00<0000co`0co`0053?o00030000
<ol0<ol000<co`000`0003?o03?o000;<ol000<0003oooooool0Roooo`009?ooo`0306Kooooooooo
00koool00`1Vooooooooo`0^oooo00<0000co`0co`0053?o00800005<ol000<0000co`0co`002c?o
00030000oooooooo08_oool002;oool206Ko4Oooo`0306Kooooooooo02koool00`0003?o03?o000K
<ol00P0000dco`000`000?ooooooo`2:oooo000Qoooo00<0I_ooooooool04Oooo`0306Kooooooooo
02goool00`0003?o03?o000L<ol000<0000co`0co`003C?o00030000oooooooo08Woool0023oool0
0`1Vooooooooo`0Boooo00<0I_ooooooool0;?ooo`030000<ol0<ol001dco`000`0003?o03?o000>
<ol000<0003oooooool0R?ooo`007_ooo`80I_lEoooo00<0I_ooooooool0:oooo`030000<ol0<ol0
01hco`000`0003?o03?o000?<ol000<0003oooooool0Qoooo`007?ooo`80I_lGoooo00<0I_oooooo
ool0:oooo`030000<ol0<ol001hco`000`0003?o03?o000@<ol000<0003oooooool0Q_ooo`006ooo
o`0306Kooooooooo01Ooool00`1Vooooooooo`0Zoooo00<0000co`0co`007c?o0080000B<ol000<0
003oooooool0QOooo`006Oooo`80I_lJoooo00<0I_ooooooool0:Oooo`030000<ol0<ol0020co`00
0`0003?o03?o000B<ol000<0003oooooool0Q?ooo`005oooo`80I_lFoooo0`0000?oool00`1Voooo
ooooo`0Qoooo100000;oool200008c?o00030000<ol0<ol001<co`000`000?ooooooo`0Aoooo1000
02[oool300009oooo`<0000Goooo000Foooo00<0I_ooooooool05oooo`030000oooooooo00;oool0
0`1Vooooooooo`0Qoooo00<0003oooooool00_ooo`030000<ol0<ol002<co`000`0003?o03?o000D
<ol000<0003oooooool04?ooo`030000oooooooo02coool00`000?ooooooo`0Voooo00@0003ooooo
ool0000Foooo000]oooo1@0000?oool00`1Vooooooooo`0Roooo00@0003oooooool0000V<ol00P00
01Hco`0200004Oooo`030000oooooooo02Soool500009oooo`040000oooooooo00005_ooo`009ooo
o`@00002oooo00@0003oooooool00004oooo00<0I_ooooooool06oooo`@00004oooo0P0002Lco`00
0`0003?o03?o000G<ol000<0003oooooool03oooo`030000oooooooo02Ooool010000?ooooooo`00
02Soool300005oooo`00;_ooo`030000oooo000000Coool00`1Vooooooooo`0Qoooo0P000003<ol0
0000<ol002Hco`000`0003?o03?o000H<ol000<0003oooooool03?ooo`040000oooooooo0000:Ooo
o`030000oooo000002Woool00`000?ooooooo`0Foooo000_oooo0P0000Coool00`1Vooooooooo`0P
oooo100002Pco`000`0003?o03?o000I<ol000<0003oooooool03?ooo`80000[oooo0P0002Woool3
00005_ooo`00=Oooo`0306Kooooooooo01koool20000;3?o00030000<ol0<ol001Xco`020000OOoo
o`00=Oooo`0306Kooooooooo01coool20000;S?o0080000M<ol00`0007[oool003Goool00`1Voooo
ooooo`0Ioooo0`00030co`000`0003?o03?o000O<ol01P0007Coool003Goool00`1Vooooooooo`0C
oooo1P0003<co`000`0003?o03?o000U<ol00`00077oool003Goool00`1Vooooooooo`09oooo2P00
03Tco`000`0003?o03?o000X<ol02P0006Ooool0013ooooo00004Oooo`005_ooo`030000oooooooo
00Soool00`000?ooooooo`08oooo00<0003oooooool01_ooo`03o`2Ioooo000000[oool00`000?oo
ooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0
003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?oo
o`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo
00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?oo
ooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`0Eoooo000/
oooo00<0003oooooool01_ooo`03o`2Ioooooooo023oool00`000?ooooooo`0Yoooo00<0003ooooo
ool0:Oooo`030000oooooooo02Woool00`000?ooooooo`0Yoooo00<0003oooooool05Oooo`00=Ooo
o`03o`2Ioooooooo04coool00`000?ooooooo`2Ioooo000eoooo00?o09Woooooool0C?ooo`030000
oooooooo09Woool003Goool00ol0VOooooooo`1<oooo0P0009[oool003Goool00ol0VOooooooo`1<
oooo00<0003oooooool0VOooo`00=Oooo`03o`2Ioooooooo04coool00`000?ooooooo`2Ioooo000e
oooo00?o09Woooooool0C?ooo`030000oooooooo09Woool003Goool00ol0VOooooooo`1<oooo0P00
09[oool003Goool00ol0VOooooooo`1<oooo00<0003oooooool0VOooo`00=Oooo`03o`2Ioooooooo
04coool00`000?ooooooo`2Ioooo000eoooo00?o09Woooooool0C?ooo`030000oooooooo09Woool0
03Goool00ol0VOooooooo`1<oooo00<0003oooooool0VOooo`00=Oooo`03o`2Ioooooooo04coool2
0000V_ooo`00=Oooo`03o`2Ioooooooo04coool00`000?ooooooo`2Ioooo000eoooo00?o09Wooooo
ool0C?ooo`030000oooooooo09Woool003Goool00ol0VOooooooo`1<oooo00<0003oooooool0VOoo
o`00=Oooo`03o`2Ioooooooo04coool20000V_ooo`00=Oooo`03o`2Ioooooooo04coool00`000?oo
ooooo`2Ioooo000eoooo00?o09Woooooool0C?ooo`030000oooooooo09Woool003Goool00ol0VOoo
ooooo`14oooo1@0000?oool00`000?ooooooo`2Ioooo000eoooo00?o09Woooooool0A_ooo`030000
oooooooo00?oool00`000?ooooooo`2Ioooo000eoooo00?o09Woooooool0A_ooo`030000oooooooo
00?oool30000VOooo`00=Oooo`03o`2Ioooooooo04Koool00`000?ooooooo`03oooo00<0003ooooo
ool0VOooo`00=Oooo`03o`2Ioooooooo04Koool00`000?ooooooo`03oooo00<0003oooooool0VOoo
o`00=Oooo`03o`2Ioooooooo04Goool200001Oooo`030000oooooooo09Woool003Goool00ol0VOoo
ooooo`1<oooo0P0009[oool003Goool00ol0VOooooooo`1<oooo00<0003oooooool0VOooo`00=Ooo
o`03o`2Ioooooooo04coool00`000?ooooooo`2Ioooo000eoooo00?o09Woooooool0C?ooo`030000
oooooooo09Woool003Goool00ol0VOooooooo`1<oooo00<0003oooooool0VOooo`00=Oooo`03o`2I
oooooooo04coool20000V_ooo`00=Oooo`03o`2Ioooooooo04coool00`000?ooooooo`2Ioooo000e
oooo00?o09Woooooool0C?ooo`030000oooooooo09Woool003Goool00ol0VOooooooo`1<oooo00<0
003oooooool0VOooo`00=Oooo`03o`2Ioooooooo04coool20000V_ooo`00=Oooo`03o`2Ioooooooo
04coool00`000?ooooooo`2Ioooo000eoooo00?o09Woooooool0C?ooo`030000oooooooo09Woool0
03Goool00ol0VOooooooo`1<oooo00<0003oooooool0VOooo`00=Oooo`03o`2Ioooooooo04coool0
0`000?ooooooo`2Ioooo000eoooo00?o09Woooooool0C?ooo`80002Joooo000eoooo00?o09Wooooo
ool0C?ooo`030000oooooooo09Woool003Goool00ol0VOooooooo`14oooo100000Coool00`000?oo
ooooo`2Ioooo000eoooo00?o09Woooooool0A?ooo`030000oooooooo00Goool00`000?ooooooo`2I
oooo000eoooo00?o09Woooooool0AOooo`030000oooooooo00Coool30000VOooo`00=Oooo`03o`2I
oooooooo04Koool00`000?ooooooo`03oooo00<0003oooooool0VOooo`00=Oooo`03o`2Ioooooooo
04Coool010000?ooooooo`0000Coool00`000?ooooooo`2Ioooo000eoooo00?o09Woooooool0AOoo
o`800005oooo00<0003oooooool0VOooo`00=Oooo`03o`2Ioooooooo04coool20000V_ooo`00=Ooo
o`03o`2Ioooooooo04coool00`000?ooooooo`2Ioooo000eoooo00?o09Woooooool0C?ooo`030000
oooooooo09Woool003Goool00ol0VOooooooo`1<oooo00<0003oooooool0VOooo`00=Oooo`03o`2I
oooooooo04coool00`000?ooooooo`2Ioooo000eoooo00?o09Woooooool0C?ooo`80002Joooo000e
oooo00?o09Woooooool0C?ooo`030000oooooooo09Woool003Goool00ol0VOooooooo`1<oooo00<0
003oooooool0VOooo`00=Oooo`03o`2Ioooooooo04coool00`000?ooooooo`2Ioooo000eoooo00?o
09Woooooool0C?ooo`80002Joooo000eoooo00?o09Woooooool0C?ooo`030000oooooooo09Woool0
03Goool00ol0VOooooooo`1<oooo00<0003oooooool0VOooo`00=Oooo`03o`2Ioooooooo04coool0
0`000?ooooooo`2Ioooo000eoooo00?o09Woooooool0C?ooo`030000oooooooo09Woool003Goool0
0ol0VOooooooo`1<oooo0P0009[oool003Goool00ol0VOooooooo`1<oooo00<0003oooooool0VOoo
o`00=Oooo`03o`2Ioooooooo04Goool200001Oooo`030000oooooooo09Woool003Goool00ol0VOoo
ooooo`14oooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00=Oooo`03o`2Ioooooooo
04Koool00`000?ooooooo`03oooo0`0009Woool003Goool00ol0VOooooooo`17oooo00<0003ooooo
ool00_ooo`030000oooooooo09Woool003Goool00ol0VOooooooo`14oooo00@0003oooooool00004
oooo00<0003oooooool0VOooo`00=Oooo`03o`2Ioooooooo04Goool200001Oooo`030000oooooooo
09Woool003Goool00ol0VOooooooo`1<oooo00<0003oooooool0VOooo`00=Oooo`03o`2Ioooooooo
04coool20000V_ooo`00=Oooo`03o`2Ioooooooo04coool00`000?ooooooo`2Ioooo000eoooo00?o
09Woooooool0C?ooo`030000oooooooo09Woool003Goool00ol0VOooooooo`1<oooo00<0003ooooo
ool0VOooo`00=Oooo`03o`2Ioooooooo04coool20000V_ooo`00=Oooo`03o`2Ioooooooo04coool0
0`000?ooooooo`2Ioooo000eoooo00?o09Woooooool0C?ooo`030000oooooooo09Woool003Goool0
0ol0VOooooooo`1<oooo00<0003oooooool0VOooo`00=Oooo`03o`2Ioooooooo04coool00`000?oo
ooooo`2Ioooo000eoooo00?o09Woooooool0C?ooo`80002Joooo000eoooo00?o09Woooooool0C?oo
o`030000oooooooo09Woool003Goool00ol0VOooooooo`1<oooo00<0003oooooool0VOooo`00=Ooo
o`03o`2Ioooooooo04coool00`000?ooooooo`2Ioooo000eoooo00?o09Woooooool0C?ooo`80002J
oooo000eoooo00?o09Woooooool0C?ooo`030000oooooooo09Woool003Goool00ol0VOooooooo`1<
oooo00<0003oooooool0VOooo`00=Oooo`03o`2Ioooooooo04Koool300000oooo`030000oooooooo
09Woool003Goool00ol0VOooooooo`17oooo00<0003oooooool00_ooo`030000oooooooo09Woool0
03Goool00ol0VOooooooo`14oooo1@0000?oool30000VOooo`00O?ooo`040000oooooooo0000X?oo
o`00OOooo`030000oooo00000:3oool007koool20000X?ooo`00ooooob7oool00?oooolQoooo001i
oooo00<0003oooooool0:?ooo`030000oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0
003oooooool07oooo`030000oooooooo07Soool007Soool00`000?ooooooo`02oooo0P0000Coool0
0`000?ooooooo`0>oooo0`0000;oool200000oooo`<00004oooo00<0003oooooool0N?ooo`00N?oo
o`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01?ooo`@00006
oooo00<0003oooooool01_ooo`040000oooooooo00000oooo`030000oooooooo07Soool007Ooool0
0`000?ooooooo`02oooo00<0003oooooool04oooo`D00007oooo00@0003oooooool00004oooo00<0
003oooooool0Moooo`00N?ooo`030000oooooooo00D0000Boooo00@0003oooooool00008oooo0`00
00Coool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000005_ooo`030000oooo0000
00Woool00`000?ooooooo`03oooo00<0003oooooool0N?ooo`00NOooo`030000oooooooo01Soool2
00002Oooo`<00002oooo00<0003oooooool0NOooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-6.03535, \
-3.20105, 0.0455524, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-6.03535, -3.20105, 0.0455524, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.12507 .26487 L
.13506 .26487 L
.14415 .26487 L
.14868 .26487 L
.1536 .26487 L
.15586 .26487 L
.15825 .26487 L
.16029 .26487 L
.16145 .26487 L
s
.16145 .26487 m
.16189 .61803 L
s
0 .4 1 r
.02381 .23149 m
.04262 .22339 L
.06244 .21272 L
.08255 .19909 L
.10458 .18006 L
.12415 .15858 L
.14509 .12958 L
.1553 .1127 L
.1581 .10772 L
.15964 .10492 L
.16107 .10226 L
.16229 .09996 L
.1636 .26487 L
.16435 .26487 L
.16506 .26487 L
.16639 .26487 L
.18653 .26487 L
.22473 .26487 L
.26537 .26487 L
.3045 .26487 L
.34608 .26487 L
.38615 .26487 L
.4247 .26487 L
.4657 .26487 L
.50519 .26487 L
.54316 .26487 L
.58359 .26487 L
.6225 .26487 L
.66386 .26487 L
.7037 .26487 L
.74203 .26487 L
.78281 .26487 L
.82208 .26487 L
.85983 .26487 L
.90003 .26487 L
.93872 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001moooo0P000:7oool007coool010000?ooooooo`000:3oool007koool00`000?oo
ooooo`03oooo0`0009Woool007Koool400001Oooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo001loooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007coool200001_ooo`<0002I
oooo001foooo1P000004<ol00000000000001?ooo`030000oooooooo09Woool007Soool01@0003?o
03?o03?o00000002<ol00P0000?oool00`000?ooooooo`2Ioooo000ioooo00<0I_ooooooool0>ooo
o`030000<ol0<ol000<co`0200000S?o008000000oooo`000?ooo`2Joooo000ioooo00<0I_oooooo
ool0>_ooo`030000<ol0<ol000Xco`020000Voooo`00>?ooo`80I_lkoooo00<0000co`0co`0033?o
0080002Joooo000hoooo0P1Voc[oool00`0003?o03?o000=<ol000<0003oooooool0VOooo`00>?oo
o`80I_lioooo00<0000co`0co`003S?o0080002Joooo000goooo00<0I_ooool0I_l0>Oooo`030000
<ol0<ol000hco`000`0003?o0000002Ioooo000foooo00@0I_ooooooool0I_lhoooo00<0000co`0c
o`003c?o008000000c?o00000?ooo`2Goooo000foooo00@0I_ooooooool0I_lhoooo00<0000co`0c
o`003c?o00040000<ol0<ol00000V?ooo`00=Oooo`0506Kooooooooooooo06Ko03Ooool00`0003?o
03?o000@<ol000D0000co`0co`0co`000000Uoooo`00=?ooo`0306Kooooooooo00;oool00`1Voooo
ooooo`0eoooo00<0000co`0co`0043?o00030000<ol0<ol0008co`000`000?ooooooo`2Doooo000d
oooo00<0I_ooooooool00_ooo`0306Kooooooooo03Coool00`0003?o03?o000A<ol000<0000co`0c
o`000S?o00030000oooooooo09Coool003?oool00`1Vooooooooo`03oooo00<0I_ooooooool0<ooo
o`030000<ol0<ol0018co`02000013?o00030000oooooooo09?oool003;oool00`1Vooooooooo`04
oooo00<0I_ooooooool0<_ooo`030000<ol0<ol001<co`000`0003?o03?o0004<ol000<0003ooooo
ool0T_ooo`00<Oooo`0306Kooooooooo00Goool00`1Vooooooooo`0boooo00<0000co`0co`004c?o
00030000<ol0<ol000@co`000`000?ooooooo`2Boooo000aoooo00<0I_ooooooool01Oooo`0306Ko
oooooooo037oool00`0003?o03?o000D<ol000<0000co`0co`001C?o00030000oooooooo097oool0
033oool00`1Vooooooooo`06oooo00<0I_ooooooool0<?ooo`030000<ol0<ol001Dco`0200001c?o
00030000oooooooo093oool002ooool00`1Vooooooooo`07oooo00<0I_ooooooool0;oooo`030000
<ol0<ol001Hco`000`0003?o03?o0006<ol000<0003oooooool0T?ooo`00;_ooo`0306Kooooooooo
00Soool00`1Vooooooooo`0_oooo00<0000co`0co`005S?o00030000<ol0<ol000Lco`000`000?oo
ooooo`2?oooo000]oooo00<0I_ooooooool02Oooo`0306Kooooooooo02koool00`0003?o03?o000?
<ol01@0000<co`000`0003?o03?o0008<ol000<0003oooooool0S_ooo`00;Oooo`0306Kooooooooo
00Woool00`1Vooooooooo`0]oooo00<0000co`0co`004S?o00030000<ol0<ol000<co`000`0003?o
03?o0008<ol000<0003oooooool0S_ooo`00;?ooo`0306Kooooooooo00[oool00`1Vooooooooo`0/
oooo00<0000co`0co`004c?o00030000<ol0<ol000<co`0300002C?o00030000oooooooo08goool0
02_oool00`1Vooooooooo`0;oooo00<0I_ooooooool0;?ooo`030000<ol0<ol000/co`04000013?o
00030000<ol0<ol000<co`000`0003?o03?o000:<ol000<0003oooooool0S?ooo`00:_ooo`0306Ko
oooooooo00goool00`1Vooooooooo`0Zoooo00<0000co`0co`0053?o00030000<ol0<ol000<co`00
0`0003?o03?o000;<ol000<0003oooooool0Roooo`00:Oooo`0306Kooooooooo00koool00`1Voooo
ooooo`0Yoooo00<0000co`0co`0053?o00800005<ol000<0000co`0co`002c?o00030000oooooooo
08_oool002Ooool206Ko4Oooo`0306Kooooooooo02Woool00`0003?o03?o000K<ol00P0000dco`00
0`000?ooooooo`2:oooo000Voooo00<0I_ooooooool04Oooo`0306Kooooooooo02Soool00`0003?o
03?o000L<ol000<0000co`0co`003C?o00030000oooooooo08Woool002Goool00`1Vooooooooo`0B
oooo00<0I_ooooooool09oooo`030000<ol0<ol001dco`000`0003?o03?o000><ol000<0003ooooo
ool0R?ooo`008oooo`80I_lEoooo00<0I_ooooooool09_ooo`030000<ol0<ol001hco`000`0003?o
03?o000?<ol000<0003oooooool0Qoooo`008Oooo`80I_lGoooo00<0I_ooooooool09_ooo`030000
<ol0<ol001hco`000`0003?o03?o000@<ol000<0003oooooool0Q_ooo`008?ooo`0306Kooooooooo
01Ooool00`1Vooooooooo`0Uoooo00<0000co`0co`007c?o0080000B<ol000<0003oooooool0QOoo
o`007_ooo`80I_lJoooo00<0I_ooooooool09?ooo`030000<ol0<ol0020co`000`0003?o03?o000B
<ol000<0003oooooool0Q?ooo`007?ooo`80I_lAoooo0`0000Soool00`1Vooooooooo`0Loooo1000
00;oool200008c?o00030000<ol0<ol001<co`000`000?ooooooo`0Aoooo100002[oool300009ooo
o`<0000Goooo000Joooo0P1VoaCoool00`000?ooooooo`07oooo00<0I_ooooooool07?ooo`030000
oooooooo00;oool00`0003?o03?o000S<ol000<0000co`0co`0053?o00030000oooooooo013oool0
0`000?ooooooo`0/oooo00<0003oooooool09_ooo`040000oooooooo00005_ooo`006?ooo`80I_lC
oooo1@0000Soool00`1Vooooooooo`0Moooo00@0003oooooool0000V<ol00P0001Hco`0200004Ooo
o`030000oooooooo02Soool500009oooo`040000oooooooo00005_ooo`005_ooo`80I_l?oooo1000
00;oool010000?ooooooo`0000Woool00`1Vooooooooo`0Foooo100000Coool200009c?o00030000
<ol0<ol001Lco`000`000?ooooooo`0?oooo00<0003oooooool09oooo`040000oooooooo0000:?oo
o`<0000Goooo000^oooo00<0003oool000002Oooo`0306Kooooooooo01coool2000000<co`00000c
o`009S?o00030000<ol0<ol001Pco`000`000?ooooooo`0<oooo00@0003oooooool0000Yoooo00<0
003oool00000:Oooo`030000oooooooo01Koool002ooool200002Oooo`0306Kooooooooo01_oool4
0000:3?o00030000<ol0<ol001Tco`000`000?ooooooo`0<oooo0P0002_oool20000:Oooo`<0000F
oooo000joooo00<0I_ooooooool06Oooo`80000/<ol000<0000co`0co`006S?o0080001moooo000j
oooo00<0I_ooooooool05oooo`80000^<ol00P0001dco`030000N_ooo`00>_ooo`0306Kooooooooo
01Coool30000<3?o00030000<ol0<ol001lco`060000M?ooo`00>_ooo`0306Kooooooooo00koool6
0000<c?o00030000<ol0<ol002Dco`030000LOooo`00>_ooo`0306Kooooooooo00Coool:0000>C?o
00030000<ol0<ol002Pco`0:0000Ioooo`004?ooool0000Aoooo000Foooo00<0003oooooool02?oo
o`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003ooooo09T02?ooo`030000oooooooo
00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?oo
ooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0
003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?oo
o`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo
00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo01Goool002coool0
0`000?ooooooo`0:oooo00?o09Woooooool07?ooo`030000oooooooo02Woool00`000?ooooooo`0Y
oooo00<0003oooooool0:Oooo`030000oooooooo02Woool00`000?ooooooo`0Eoooo000ioooo00?o
09Woooooool0B?ooo`030000oooooooo09Woool003Woool00ol0VOooooooo`18oooo00<0003ooooo
ool0VOooo`00>Oooo`03o`2Ioooooooo04Soool20000V_ooo`00>Oooo`03o`2Ioooooooo04Soool0
0`000?ooooooo`2Ioooo000ioooo00?o09Woooooool0B?ooo`030000oooooooo09Woool003Woool0
0ol0VOooooooo`18oooo00<0003oooooool0VOooo`00>Oooo`03o`2Ioooooooo04Soool20000V_oo
o`00>Oooo`03o`2Ioooooooo04Soool00`000?ooooooo`2Ioooo000ioooo00?o09Woooooool0B?oo
o`030000oooooooo09Woool003Woool00ol0VOooooooo`18oooo00<0003oooooool0VOooo`00>Ooo
o`03o`2Ioooooooo04Soool00`000?ooooooo`2Ioooo000ioooo00?o09Woooooool0B?ooo`80002J
oooo000ioooo00?o09Woooooool0B?ooo`030000oooooooo09Woool003Woool00ol0VOooooooo`18
oooo00<0003oooooool0VOooo`00>Oooo`03o`2Ioooooooo04Soool00`000?ooooooo`2Ioooo000i
oooo00?o09Woooooool0B?ooo`80002Joooo000ioooo00?o09Woooooool0B?ooo`030000oooooooo
09Woool003Woool00ol0VOooooooo`18oooo00<0003oooooool0VOooo`00>Oooo`03o`2Ioooooooo
043oool500000oooo`030000oooooooo09Woool003Woool00ol0VOooooooo`12oooo00<0003ooooo
ool00oooo`030000oooooooo09Woool003Woool00ol0VOooooooo`12oooo00<0003oooooool00ooo
o`<0002Ioooo000ioooo00?o09Woooooool0@_ooo`030000oooooooo00?oool00`000?ooooooo`2I
oooo000ioooo00?o09Woooooool0@_ooo`030000oooooooo00?oool00`000?ooooooo`2Ioooo000i
oooo00?o09Woooooool0@Oooo`800005oooo00<0003oooooool0VOooo`00>Oooo`03o`2Ioooooooo
04Soool20000V_ooo`00>Oooo`03o`2Ioooooooo04Soool00`000?ooooooo`2Ioooo000ioooo00?o
09Woooooool0B?ooo`030000oooooooo09Woool003Woool00ol0VOooooooo`18oooo00<0003ooooo
ool0VOooo`00>Oooo`03o`2Ioooooooo04Soool00`000?ooooooo`2Ioooo000ioooo00?o09Wooooo
ool0B?ooo`80002Joooo000ioooo00?o09Woooooool0B?ooo`030000oooooooo09Woool003Woool0
0ol0VOooooooo`18oooo00<0003oooooool0VOooo`00>Oooo`03o`2Ioooooooo04Soool00`000?oo
ooooo`2Ioooo000ioooo00?o09Woooooool0B?ooo`80002Joooo000ioooo00?o09Woooooool0B?oo
o`030000oooooooo09Woool003Woool00ol0VOooooooo`18oooo00<0003oooooool0VOooo`00>Ooo
o`03o`2Ioooooooo04Soool00`000?ooooooo`2Ioooo000ioooo00?o09Woooooool0B?ooo`030000
oooooooo09Woool003Woool00ol0VOooooooo`18oooo0P0009[oool003Woool00ol0VOooooooo`18
oooo00<0003oooooool0VOooo`00>Oooo`03o`2Ioooooooo043oool400001?ooo`030000oooooooo
09Woool003Woool00ol0VOooooooo`10oooo00<0003oooooool01Oooo`030000oooooooo09Woool0
03Woool00ol0VOooooooo`11oooo00<0003oooooool01?ooo`<0002Ioooo000ioooo00?o09Wooooo
ool0@_ooo`030000oooooooo00?oool00`000?ooooooo`2Ioooo000ioooo00?o09Woooooool0@?oo
o`040000oooooooo00001?ooo`030000oooooooo09Woool003Woool00ol0VOooooooo`11oooo0P00
00Goool00`000?ooooooo`2Ioooo000ioooo00?o09Woooooool0B?ooo`80002Joooo000ioooo00?o
09Woooooool0B?ooo`030000oooooooo09Woool003Woool00ol0VOooooooo`18oooo00<0003ooooo
ool0VOooo`00>Oooo`03o`2Ioooooooo04Soool00`000?ooooooo`2Ioooo000ioooo00?o09Wooooo
ool0B?ooo`030000oooooooo09Woool003Woool00ol0VOooooooo`18oooo0P0009[oool003Woool0
0ol0VOooooooo`18oooo00<0003oooooool0VOooo`00>Oooo`03o`2Ioooooooo04Soool00`000?oo
ooooo`2Ioooo000ioooo00?o09Woooooool0B?ooo`030000oooooooo09Woool003Woool00ol0VOoo
ooooo`18oooo0P0009[oool003Woool00ol0VOooooooo`18oooo00<0003oooooool0VOooo`00>Ooo
o`03o`2Ioooooooo04Soool00`000?ooooooo`2Ioooo000ioooo00?o09Woooooool0B?ooo`030000
oooooooo09Woool003Woool00ol0VOooooooo`18oooo00<0003oooooool0VOooo`00>Oooo`03o`2I
oooooooo04Soool20000V_ooo`00>Oooo`03o`2Ioooooooo04Soool00`000?ooooooo`2Ioooo000i
oooo00?o09Woooooool0@Oooo`800005oooo00<0003oooooool0VOooo`00>Oooo`03o`2Ioooooooo
043oool010000?ooooooo`0000Coool00`000?ooooooo`2Ioooo000ioooo00?o09Woooooool0@_oo
o`030000oooooooo00?oool30000VOooo`00>Oooo`03o`2Ioooooooo04?oool00`000?ooooooo`02
oooo00<0003oooooool0VOooo`00>Oooo`03o`2Ioooooooo043oool010000?ooooooo`0000Coool0
0`000?ooooooo`2Ioooo000ioooo00?o09Woooooool0@Oooo`800005oooo00<0003oooooool0VOoo
o`00>Oooo`03o`2Ioooooooo04Soool00`000?ooooooo`2Ioooo000ioooo00?o09Woooooool0B?oo
o`80002Joooo000ioooo00?o09Woooooool0B?ooo`030000oooooooo09Woool003Woool00ol0VOoo
ooooo`18oooo00<0003oooooool0VOooo`00>Oooo`03o`2Ioooooooo04Soool00`000?ooooooo`2I
oooo000ioooo00?o09Woooooool0B?ooo`80002Joooo000ioooo00?o09Woooooool0B?ooo`030000
oooooooo09Woool003Woool00ol0VOooooooo`18oooo00<0003oooooool0VOooo`00>Oooo`03o`2I
oooooooo04Soool00`000?ooooooo`2Ioooo000ioooo00?o09Woooooool0B?ooo`030000oooooooo
09Woool003Woool00ol0VOooooooo`18oooo0P0009[oool003Woool00ol0VOooooooo`18oooo00<0
003oooooool0VOooo`00>Oooo`03o`2Ioooooooo04Soool00`000?ooooooo`2Ioooo000ioooo00?o
09Woooooool0B?ooo`030000oooooooo09Woool003Woool00ol0VOooooooo`18oooo0P0009[oool0
03Woool00ol0VOooooooo`18oooo00<0003oooooool0VOooo`00>Oooo`03o`2Ioooooooo04Soool0
0`000?ooooooo`2Ioooo000ioooo00?o09Woooooool0@_ooo`<00003oooo00<0003oooooool0VOoo
o`00>Oooo`03o`2Ioooooooo04?oool00`000?ooooooo`02oooo00<0003oooooool0VOooo`00>Ooo
o`03o`2Ioooooooo043oool500000oooo`<0002Ioooo001loooo00@0003oooooool0002Poooo001m
oooo00<0003oool00000X?ooo`00O_ooo`80002Poooo003ooooo8Oooo`00ooooob7oool007Woool0
0`000?ooooooo`0Xoooo00<0003oooooool0NOooo`00N?ooo`030000oooooooo00Soool00`000?oo
ooooo`0Ooooo00<0003oooooool0N?ooo`00N?ooo`030000oooooooo00;oool200001?ooo`030000
oooooooo00koool300000_ooo`800005oooo0`0000;oool00`000?ooooooo`1hoooo001hoooo00D0
003oooooooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`04oooo100000Koool0
0`000?ooooooo`09oooo00D0003oooooooooool00000N_ooo`00Moooo`030000oooooooo00;oool0
0`000?ooooooo`0Coooo1@0000Ooool500000oooo`030000oooooooo07Ooool007Soool00`000?oo
ooooo`0500004_ooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo
07Soool007Soool01@000?ooooooooooo`00000Foooo00<0003oool000002Oooo`030000oooo0000
00?oool00`000?ooooooo`1hoooo001ioooo00<0003oooooool06?ooo`80000:oooo0P0000;oool0
0`000?ooooooo`1ioooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-6.03535, \
-3.20105, 0.0455524, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-6.03535, -3.20105, 0.0455524, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.12507 .26487 L
.14415 .26487 L
.16254 .26487 L
.16783 .26487 L
.17284 .26487 L
.17502 .26487 L
.17733 .26487 L
.17854 .26487 L
.17922 .26487 L
s
.17922 .26487 m
.17948 .61803 L
s
0 .4 1 r
.02381 .23754 m
.04262 .23091 L
.06244 .22218 L
.08255 .21102 L
.10458 .19544 L
.12415 .17785 L
.14509 .15411 L
.1553 .14029 L
.16639 .12335 L
.17148 .11483 L
.17426 .10996 L
.17687 .10526 L
.178 .10316 L
.17908 .10114 L
.18033 .26487 L
.18147 .26487 L
.18653 .26487 L
.22473 .26487 L
.26537 .26487 L
.3045 .26487 L
.34608 .26487 L
.38615 .26487 L
.4247 .26487 L
.4657 .26487 L
.50519 .26487 L
.54316 .26487 L
.58359 .26487 L
.6225 .26487 L
.66386 .26487 L
.7037 .26487 L
.74203 .26487 L
.78281 .26487 L
.82208 .26487 L
.85983 .26487 L
.90003 .26487 L
.93872 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001moooo0P000:7oool007coool010000?ooooooo`000:3oool007koool00`000?oo
ooooo`03oooo0`0009Woool007Koool400001Oooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo001loooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007coool200001_ooo`<0002I
oooo001foooo1P000004<ol00000000000001?ooo`030000oooooooo09Woool007Soool01@0003?o
03?o03?o00000002<ol00P0000?oool00`000?ooooooo`2Ioooo001goooo00<0000co`0co`000c?o
00800002<ol00P000003oooo0000oooo09[oool003goool206Ko=oooo`030000<ol0<ol000Xco`02
0000Voooo`00?Oooo`80I_lfoooo00<0000co`0co`0033?o0080002Joooo000loooo00<0I_ooool0
I_l0=Oooo`030000<ol0<ol000dco`000`000?ooooooo`2Ioooo000loooo00<0I_ooool0I_l0=?oo
o`030000<ol0<ol000hco`020000V_ooo`00>oooo`0406Kooooooooo06Ko=?ooo`030000<ol0<ol0
00hco`000`0003?o0000002Ioooo000joooo00D0I_ooooooooooool0I_l0<oooo`030000<ol0<ol0
00lco`02000000<co`00003oool0Uoooo`00>_ooo`0506Kooooooooooooo06Ko03?oool00`0003?o
03?o000?<ol000@0000co`0co`00002Hoooo000ioooo00<0I_ooooooool00_ooo`0306Kooooooooo
033oool00`0003?o03?o000@<ol000D0000co`0co`0co`000000Uoooo`00>Oooo`0306Kooooooooo
00;oool00`1Vooooooooo`0`oooo00<0000co`0co`0043?o00030000<ol0<ol0008co`000`000?oo
ooooo`2Doooo000hoooo00<0I_ooooooool00oooo`0306Kooooooooo02ooool00`0003?o03?o000A
<ol000<0000co`0co`000S?o00030000oooooooo09Coool003Soool00`1Vooooooooo`03oooo00<0
I_ooooooool0;_ooo`030000<ol0<ol0018co`02000013?o00030000oooooooo09?oool003Ooool0
0`1Vooooooooo`04oooo00<0I_ooooooool0;Oooo`030000<ol0<ol001<co`000`0003?o03?o0004
<ol000<0003oooooool0T_ooo`00=_ooo`0306Kooooooooo00Goool00`1Vooooooooo`0]oooo00<0
000co`0co`004c?o00030000<ol0<ol000@co`000`000?ooooooo`2Boooo000eoooo00<0I_oooooo
ool01_ooo`0306Kooooooooo02coool00`0003?o03?o000D<ol000<0000co`0co`001C?o00030000
oooooooo097oool003Coool00`1Vooooooooo`07oooo00<0I_ooooooool0:oooo`030000<ol0<ol0
01Dco`0200001c?o00030000oooooooo093oool003?oool00`1Vooooooooo`08oooo00<0I_oooooo
ool0:_ooo`030000<ol0<ol001Hco`000`0003?o03?o0006<ol000<0003oooooool0T?ooo`00<_oo
o`0306Kooooooooo00Woool00`1Vooooooooo`0Zoooo00<0000co`0co`005S?o00030000<ol0<ol0
00Lco`000`000?ooooooo`2?oooo000boooo00<0I_ooooooool02Oooo`0306Kooooooooo02Woool0
0`0003?o03?o000?<ol01@0000<co`000`0003?o03?o0008<ol000<0003oooooool0S_ooo`00<Ooo
o`0306Kooooooooo00[oool00`1Vooooooooo`0Xoooo00<0000co`0co`004S?o00030000<ol0<ol0
00<co`000`0003?o03?o0008<ol000<0003oooooool0S_ooo`00<?ooo`0306Kooooooooo00_oool0
0`1Vooooooooo`0Woooo00<0000co`0co`004c?o00030000<ol0<ol000<co`0300002C?o00030000
oooooooo08goool002ooool00`1Vooooooooo`0<oooo00<0I_ooooooool09oooo`030000<ol0<ol0
00/co`04000013?o00030000<ol0<ol000<co`000`0003?o03?o000:<ol000<0003oooooool0S?oo
o`00;_ooo`0306Kooooooooo00goool00`1Vooooooooo`0Voooo00<0000co`0co`0053?o00030000
<ol0<ol000<co`000`0003?o03?o000;<ol000<0003oooooool0Roooo`00;Oooo`0306Kooooooooo
00koool00`1Vooooooooo`0Uoooo00<0000co`0co`0053?o00800005<ol000<0000co`0co`002c?o
00030000oooooooo08_oool002coool00`1Vooooooooo`0?oooo00<0I_ooooooool09Oooo`030000
<ol0<ol001/co`0200003C?o00030000oooooooo08[oool002_oool00`1Vooooooooo`0@oooo00<0
I_ooooooool09?ooo`030000<ol0<ol001`co`000`0003?o03?o000=<ol000<0003oooooool0ROoo
o`00:Oooo`80I_lCoooo00<0I_ooooooool08oooo`030000<ol0<ol001dco`000`0003?o03?o000>
<ol000<0003oooooool0R?ooo`00:?ooo`0306Kooooooooo01?oool00`1Vooooooooo`0Roooo00<0
000co`0co`007S?o00030000<ol0<ol000lco`000`000?ooooooo`27oooo000Voooo0P1VoaKoool0
0`1Vooooooooo`0Roooo00<0000co`0co`007S?o00030000<ol0<ol0010co`000`000?ooooooo`26
oooo000Toooo0P1VoaSoool00`1Vooooooooo`0Qoooo00<0000co`0co`007c?o0080000B<ol000<0
003oooooool0QOooo`008_ooo`80I_lJoooo00<0I_ooooooool08?ooo`030000<ol0<ol0020co`00
0`0003?o03?o000B<ol000<0003oooooool0Q?ooo`008?ooo`80I_l=oooo0`0000coool00`1Voooo
ooooo`0Hoooo100000;oool200008c?o00030000<ol0<ol001<co`000`000?ooooooo`0Aoooo1000
02[oool300009oooo`<0000Goooo000Noooo0P1Voa3oool00`000?ooooooo`0;oooo00<0I_oooooo
ool06?ooo`030000oooooooo00;oool00`0003?o03?o000S<ol000<0000co`0co`0053?o00030000
oooooooo013oool00`000?ooooooo`0/oooo00<0003oooooool09_ooo`040000oooooooo00005_oo
o`007?ooo`80I_l?oooo1@0000coool00`1Vooooooooo`0Ioooo00@0003oooooool0000V<ol00P00
01Hco`0200004Oooo`030000oooooooo02Soool500009oooo`040000oooooooo00005_ooo`006Ooo
o`<0I_l;oooo100000;oool010000?ooooooo`0000goool00`1Vooooooooo`0Boooo100000Coool2
00009c?o00030000<ol0<ol001Lco`000`000?ooooooo`0?oooo00<0003oooooool09oooo`040000
oooooooo0000:?ooo`<0000Goooo000Foooo0`1VoaGoool00`000?ooo`00000=oooo00<0I_oooooo
ool06?ooo`8000000c?o000003?o000V<ol000<0000co`0co`0063?o00030000oooooooo00coool0
10000?ooooooo`0002Woool00`000?ooo`00000Yoooo00<0003oooooool05_ooo`00;oooo`80000=
oooo00<0I_ooooooool05oooo`@0000X<ol000<0000co`0co`006C?o00030000oooooooo00coool2
0000:oooo`80000Yoooo0`0001Koool003koool00`1Vooooooooo`0Eoooo0P0002`co`000`0003?o
03?o000J<ol00P0007goool003koool00`1Vooooooooo`0Coooo0P0002hco`0200007C?o00<0001j
oooo000noooo00<0I_ooooooool04?ooo`<0000`<ol000<0000co`0co`007c?o00H0001doooo000n
oooo00<0I_ooooooool02_ooo`H0000c<ol000<0000co`0co`009C?o00<0001aoooo000noooo00<0
I_ooooooool02P0003Tco`000`0003?o03?o000X<ol02P0006Ooool0013ooooo00004Oooo`005_oo
o`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo
00Coool01Ol0VOooooooooooo`00000:oooo00<0003oooooool02?ooo`030000oooooooo00Soool0
0`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08
oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003ooooo
ool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000
oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool0
0`000?ooooooo`0Eoooo000/oooo00<0003oooooool03oooo`03o`2Ioooooooo01Ooool00`000?oo
ooooo`0Yoooo00<0003oooooool0:Oooo`030000oooooooo02Woool00`000?ooooooo`0Yoooo00<0
003oooooool05Oooo`00?_ooo`03o`2Ioooooooo04?oool00`000?ooooooo`2Ioooo000noooo00?o
09Woooooool0@oooo`030000oooooooo09Woool003koool00ol0VOooooooo`13oooo0P0009[oool0
03koool00ol0VOooooooo`13oooo00<0003oooooool0VOooo`00?_ooo`03o`2Ioooooooo04?oool0
0`000?ooooooo`2Ioooo000noooo00?o09Woooooool0@oooo`030000oooooooo09Woool003koool0
0ol0VOooooooo`13oooo0P0009[oool003koool00ol0VOooooooo`13oooo00<0003oooooool0VOoo
o`00?_ooo`03o`2Ioooooooo04?oool00`000?ooooooo`2Ioooo000noooo00?o09Woooooool0@ooo
o`030000oooooooo09Woool003koool00ol0VOooooooo`13oooo00<0003oooooool0VOooo`00?_oo
o`03o`2Ioooooooo04?oool20000V_ooo`00?_ooo`03o`2Ioooooooo04?oool00`000?ooooooo`2I
oooo000noooo00?o09Woooooool0@oooo`030000oooooooo09Woool003koool00ol0VOooooooo`13
oooo00<0003oooooool0VOooo`00?_ooo`03o`2Ioooooooo04?oool20000V_ooo`00?_ooo`03o`2I
oooooooo04?oool00`000?ooooooo`2Ioooo000noooo00?o09Woooooool0@oooo`030000oooooooo
09Woool003koool00ol0VOooooooo`0koooo1@0000?oool00`000?ooooooo`2Ioooo000noooo00?o
09Woooooool0?Oooo`030000oooooooo00?oool00`000?ooooooo`2Ioooo000noooo00?o09Wooooo
ool0?Oooo`030000oooooooo00?oool30000VOooo`00?_ooo`03o`2Ioooooooo03goool00`000?oo
ooooo`03oooo00<0003oooooool0VOooo`00?_ooo`03o`2Ioooooooo03goool00`000?ooooooo`03
oooo00<0003oooooool0VOooo`00?_ooo`03o`2Ioooooooo03coool200001Oooo`030000oooooooo
09Woool003koool00ol0VOooooooo`13oooo0P0009[oool003koool00ol0VOooooooo`13oooo00<0
003oooooool0VOooo`00?_ooo`03o`2Ioooooooo04?oool00`000?ooooooo`2Ioooo000noooo00?o
09Woooooool0@oooo`030000oooooooo09Woool003koool00ol0VOooooooo`13oooo00<0003ooooo
ool0VOooo`00?_ooo`03o`2Ioooooooo04?oool20000V_ooo`00?_ooo`03o`2Ioooooooo04?oool0
0`000?ooooooo`2Ioooo000noooo00?o09Woooooool0@oooo`030000oooooooo09Woool003koool0
0ol0VOooooooo`13oooo00<0003oooooool0VOooo`00?_ooo`03o`2Ioooooooo04?oool20000V_oo
o`00?_ooo`03o`2Ioooooooo04?oool00`000?ooooooo`2Ioooo000noooo00?o09Woooooool0@ooo
o`030000oooooooo09Woool003koool00ol0VOooooooo`13oooo00<0003oooooool0VOooo`00?_oo
o`03o`2Ioooooooo04?oool00`000?ooooooo`2Ioooo000noooo00?o09Woooooool0@oooo`80002J
oooo000noooo00?o09Woooooool0@oooo`030000oooooooo09Woool003koool00ol0VOooooooo`0k
oooo100000Coool00`000?ooooooo`2Ioooo000noooo00?o09Woooooool0>oooo`030000oooooooo
00Goool00`000?ooooooo`2Ioooo000noooo00?o09Woooooool0??ooo`030000oooooooo00Coool3
0000VOooo`00?_ooo`03o`2Ioooooooo03goool00`000?ooooooo`03oooo00<0003oooooool0VOoo
o`00?_ooo`03o`2Ioooooooo03_oool010000?ooooooo`0000Coool00`000?ooooooo`2Ioooo000n
oooo00?o09Woooooool0??ooo`800005oooo00<0003oooooool0VOooo`00?_ooo`03o`2Ioooooooo
04?oool20000V_ooo`00?_ooo`03o`2Ioooooooo04?oool00`000?ooooooo`2Ioooo000noooo00?o
09Woooooool0@oooo`030000oooooooo09Woool003koool00ol0VOooooooo`13oooo00<0003ooooo
ool0VOooo`00?_ooo`03o`2Ioooooooo04?oool00`000?ooooooo`2Ioooo000noooo00?o09Wooooo
ool0@oooo`80002Joooo000noooo00?o09Woooooool0@oooo`030000oooooooo09Woool003koool0
0ol0VOooooooo`13oooo00<0003oooooool0VOooo`00?_ooo`03o`2Ioooooooo04?oool00`000?oo
ooooo`2Ioooo000noooo00?o09Woooooool0@oooo`80002Joooo000noooo00?o09Woooooool0@ooo
o`030000oooooooo09Woool003koool00ol0VOooooooo`13oooo00<0003oooooool0VOooo`00?_oo
o`03o`2Ioooooooo04?oool00`000?ooooooo`2Ioooo000noooo00?o09Woooooool0@oooo`030000
oooooooo09Woool003koool00ol0VOooooooo`13oooo0P0009[oool003koool00ol0VOooooooo`13
oooo00<0003oooooool0VOooo`00?_ooo`03o`2Ioooooooo03coool200001Oooo`030000oooooooo
09Woool003koool00ol0VOooooooo`0koooo00@0003oooooool00004oooo00<0003oooooool0VOoo
o`00?_ooo`03o`2Ioooooooo03goool00`000?ooooooo`03oooo0`0009Woool003koool00ol0VOoo
ooooo`0noooo00<0003oooooool00_ooo`030000oooooooo09Woool003koool00ol0VOooooooo`0k
oooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00?_ooo`03o`2Ioooooooo03coool2
00001Oooo`030000oooooooo09Woool003koool00ol0VOooooooo`13oooo00<0003oooooool0VOoo
o`00?_ooo`03o`2Ioooooooo04?oool20000V_ooo`00?_ooo`03o`2Ioooooooo04?oool00`000?oo
ooooo`2Ioooo000noooo00?o09Woooooool0@oooo`030000oooooooo09Woool003koool00ol0VOoo
ooooo`13oooo00<0003oooooool0VOooo`00?_ooo`03o`2Ioooooooo04?oool20000V_ooo`00?_oo
o`03o`2Ioooooooo04?oool00`000?ooooooo`2Ioooo000noooo00?o09Woooooool0@oooo`030000
oooooooo09Woool003koool00ol0VOooooooo`13oooo00<0003oooooool0VOooo`00?_ooo`03o`2I
oooooooo04?oool00`000?ooooooo`2Ioooo000noooo00?o09Woooooool0@oooo`80002Joooo000n
oooo00?o09Woooooool0@oooo`030000oooooooo09Woool003koool00ol0VOooooooo`13oooo00<0
003oooooool0VOooo`00?_ooo`03o`2Ioooooooo04?oool00`000?ooooooo`2Ioooo000noooo00?o
09Woooooool0@oooo`80002Joooo000noooo00?o09Woooooool0@oooo`030000oooooooo09Woool0
03koool00ol0VOooooooo`13oooo00<0003oooooool0VOooo`00?_ooo`03o`2Ioooooooo03goool3
00000oooo`030000oooooooo09Woool003koool00ol0VOooooooo`0noooo00<0003oooooool00_oo
o`030000oooooooo09Woool003koool00ol0VOooooooo`0koooo1@0000?oool30000VOooo`00O?oo
o`040000oooooooo0000X?ooo`00OOooo`030000oooo00000:3oool007koool20000X?ooo`00oooo
ob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo07Woool007Soool0
0`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool007Soool00`000?oo
ooooo`02oooo0P0000Coool00`000?ooooooo`0>oooo0`0000;oool200000oooo`@00003oooo00<0
003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0
003oooooool01?ooo`@00006oooo00<0003oooooool01_ooo`030000oooooooo00Coool00`000?oo
ooooo`1hoooo001goooo00<0003oooooool00_ooo`030000oooooooo01?oool500002?ooo`030000
oooooooo00Coool00`000?ooooooo`1goooo001hoooo00<0003oooooool01@0001;oool010000?oo
ooooo`0000[oool00`000?ooooooo`02oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooo
oooo000001Koool00`000?ooo`000008oooo00@0003oooooool00003oooo00<0003oooooool0N?oo
o`00NOooo`030000oooooooo01Soool200002Oooo`800003oooo00<0003oooooool0NOooo`00oooo
ob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-6.03535, \
-3.20105, 0.0455524, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-6.03535, -3.20105, 0.0455524, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.16408 .26487 L
.18221 .26487 L
.18703 .26487 L
.18957 .26487 L
.19227 .26487 L
.19462 .26487 L
.19527 .26487 L
.19596 .26487 L
s
.19596 .26487 m
.19646 .61803 L
s
0 .4 1 r
.02381 .2425 m
.04262 .23707 L
.06244 .22992 L
.08255 .22079 L
.10458 .20803 L
.12415 .19364 L
.14509 .1742 L
.16639 .14901 L
.17617 .13524 L
.18653 .11888 L
.19111 .11102 L
.19364 .10651 L
.19488 .10423 L
.19604 .1021 L
.19669 .10087 L
.19739 .26487 L
.19816 .26487 L
.19886 .26487 L
.20144 .26487 L
.20651 .26487 L
.22495 .26487 L
.26501 .26487 L
.30357 .26487 L
.34457 .26487 L
.38406 .26487 L
.42203 .26487 L
.46245 .26487 L
.50136 .26487 L
.54272 .26487 L
.58257 .26487 L
.6209 .26487 L
.66168 .26487 L
.70095 .26487 L
.7387 .26487 L
.7789 .26487 L
.81759 .26487 L
.85873 .26487 L
.89835 .26487 L
.93646 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001moooo0P000:7oool007coool010000?ooooooo`000:3oool007koool00`000?oo
ooooo`03oooo0`0009Woool007Koool400001Oooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo001loooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007coool200001_ooo`<0002I
oooo001foooo1P000004<ol00000000000001?ooo`030000oooooooo09Woool007Soool01@0003?o
03?o03?o00000002<ol00P0000?oool00`000?ooooooo`2Ioooo001goooo00<0000co`0co`000c?o
00800002<ol00P000003oooo0000oooo09[oool004;oool00`1Vooooooooo`0aoooo00<0000co`0c
o`002S?o0080002Koooo0011oooo0P1Voc;oool00`0003?o03?o000<<ol00P0009[oool0047oool2
06Ko<Oooo`030000<ol0<ol000dco`000`000?ooooooo`2Ioooo0010oooo00<0I_ooool0I_l0<?oo
o`030000<ol0<ol000hco`020000V_ooo`00?oooo`0406Kooooooooo06Ko<?ooo`030000<ol0<ol0
00hco`000`0003?o0000002Ioooo000noooo00D0I_ooooooooooool0I_l0;oooo`030000<ol0<ol0
00lco`02000000<co`00003oool0Uoooo`00?_ooo`0506Kooooooooooooo06Ko02ooool00`0003?o
03?o000?<ol000@0000co`0co`00002Hoooo000moooo00<0I_ooooooool00_ooo`0306Kooooooooo
02coool00`0003?o03?o000@<ol000D0000co`0co`0co`000000Uoooo`00?Oooo`0306Kooooooooo
00;oool00`1Vooooooooo`0/oooo00<0000co`0co`0043?o00030000<ol0<ol0008co`000`000?oo
ooooo`2Doooo000loooo00<0I_ooooooool00oooo`0306Kooooooooo02_oool00`0003?o03?o000A
<ol000<0000co`0co`000S?o00030000oooooooo09Coool003_oool00`1Vooooooooo`04oooo00<0
I_ooooooool0:_ooo`030000<ol0<ol0018co`02000013?o00030000oooooooo09?oool003_oool0
0`1Vooooooooo`04oooo00<0I_ooooooool0:Oooo`030000<ol0<ol001<co`000`0003?o03?o0004
<ol000<0003oooooool0T_ooo`00>_ooo`0306Kooooooooo00Goool00`1Vooooooooo`0Yoooo00<0
000co`0co`004c?o00030000<ol0<ol000@co`000`000?ooooooo`2Boooo000ioooo00<0I_oooooo
ool01_ooo`0306Kooooooooo02Soool00`0003?o03?o000D<ol000<0000co`0co`001C?o00030000
oooooooo097oool003Soool00`1Vooooooooo`07oooo00<0I_ooooooool09oooo`030000<ol0<ol0
01Dco`0200001c?o00030000oooooooo093oool003Ooool00`1Vooooooooo`08oooo00<0I_oooooo
ool09_ooo`030000<ol0<ol001Hco`000`0003?o03?o0006<ol000<0003oooooool0T?ooo`00=ooo
o`0306Kooooooooo00Soool00`1Vooooooooo`0Voooo00<0000co`0co`005S?o00030000<ol0<ol0
00Lco`000`000?ooooooo`2?oooo000foooo00<0I_ooooooool02Oooo`0306Kooooooooo02Goool0
0`0003?o03?o000?<ol01@0000<co`000`0003?o03?o0008<ol000<0003oooooool0S_ooo`00=Ooo
o`0306Kooooooooo00[oool00`1Vooooooooo`0Toooo00<0000co`0co`004S?o00030000<ol0<ol0
00<co`000`0003?o03?o0008<ol000<0003oooooool0S_ooo`00=?ooo`0306Kooooooooo00_oool0
0`1Vooooooooo`0Soooo00<0000co`0co`004c?o00030000<ol0<ol000<co`0300002C?o00030000
oooooooo08goool003?oool00`1Vooooooooo`0<oooo00<0I_ooooooool08oooo`030000<ol0<ol0
00/co`04000013?o00030000<ol0<ol000<co`000`0003?o03?o000:<ol000<0003oooooool0S?oo
o`00<_ooo`0306Kooooooooo00goool00`1Vooooooooo`0Roooo00<0000co`0co`0053?o00030000
<ol0<ol000<co`000`0003?o03?o000;<ol000<0003oooooool0Roooo`00<Oooo`0306Kooooooooo
00koool00`1Vooooooooo`0Qoooo00<0000co`0co`0053?o00800005<ol000<0000co`0co`002c?o
00030000oooooooo08_oool0033oool00`1Vooooooooo`0?oooo00<0I_ooooooool08Oooo`030000
<ol0<ol001/co`0200003C?o00030000oooooooo08[oool002ooool00`1Vooooooooo`0@oooo00<0
I_ooooooool08?ooo`030000<ol0<ol001`co`000`0003?o03?o000=<ol000<0003oooooool0ROoo
o`00;Oooo`80I_lCoooo00<0I_ooooooool07oooo`030000<ol0<ol001dco`000`0003?o03?o000>
<ol000<0003oooooool0R?ooo`00;?ooo`0306Kooooooooo01?oool00`1Vooooooooo`0Noooo00<0
000co`0co`007S?o00030000<ol0<ol000lco`000`000?ooooooo`27oooo000[oooo00<0I_oooooo
ool05?ooo`0306Kooooooooo01koool00`0003?o03?o000N<ol000<0000co`0co`0043?o00030000
oooooooo08Koool002Woool206Ko5oooo`0306Kooooooooo01goool00`0003?o03?o000O<ol00P00
018co`000`000?ooooooo`25oooo000Woooo0P1VoaWoool00`1Vooooooooo`0Loooo00<0000co`0c
o`0083?o00030000<ol0<ol0018co`000`000?ooooooo`24oooo000Toooo0`1Vo`Soool300004?oo
o`0306Kooooooooo01Coool400000_ooo`80000S<ol000<0000co`0co`004c?o00030000oooooooo
017oool40000:_ooo`<0000Woooo0`0001Ooool002;oool206Ko3?ooo`030000oooooooo00ooool0
0`1Vooooooooo`0Doooo00<0003oooooool00_ooo`030000<ol0<ol002<co`000`0003?o03?o000D
<ol000<0003oooooool04?ooo`030000oooooooo02coool00`000?ooooooo`0Voooo00@0003ooooo
ool0000Foooo000Ooooo0`1Vo`_oool500004?ooo`0306Kooooooooo01Goool010000?ooooooo`00
02Hco`0200005S?o0080000Aoooo00<0003oooooool0:?ooo`D0000Woooo00@0003oooooool0000F
oooo000Moooo0P1Vo`Soool400000_ooo`040000oooooooo00004Oooo`0306Kooooooooo00koool4
00001?ooo`80000W<ol000<0000co`0co`005c?o00030000oooooooo00ooool00`000?ooooooo`0W
oooo00@0003oooooool0000Xoooo0`0001Ooool001[oool306Ko4Oooo`030000oooo0000017oool0
0`1Vooooooooo`0Doooo0P000003<ol00000<ol002Hco`000`0003?o03?o000H<ol000<0003ooooo
ool03?ooo`040000oooooooo0000:Oooo`030000oooo000002Woool00`000?ooooooo`0Foooo000H
oooo0P1VoaGoool200004Oooo`0306Kooooooooo01?oool40000:3?o00030000<ol0<ol001Tco`00
0`000?ooooooo`0<oooo0P0002_oool20000:Oooo`<0000Foooo000Foooo0P1Vob[oool00`1Voooo
ooooo`0Aoooo0P0002`co`000`0003?o03?o000J<ol00P0007goool004;oool00`1Vooooooooo`0?
oooo0P0002hco`0200007C?o00<0001joooo0012oooo00<0I_ooooooool03?ooo`<0000`<ol000<0
000co`0co`007c?o00H0001doooo0012oooo00<0I_ooooooool01_ooo`H0000c<ol000<0000co`0c
o`009C?o00<0001aoooo0011oooo00<00000I_l000001`0003Tco`000`0003?o03?o000X<ol02P00
06Ooool0013ooooo00004Oooo`005_ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0
003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?oo
o`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo
00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?oo
ooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0
003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?oo
o`030000oooooooo00Soool00`000?ooooooo`0Eoooo000/oooo00<0003oooooool04oooo`03o`2I
oooooooo01?oool00`000?ooooooo`0Yoooo00<0003oooooool0:Oooo`030000oooooooo02Woool0
0`000?ooooooo`0Yoooo00<0003oooooool05Oooo`00@_ooo`03o`2Ioooooooo03ooool00`000?oo
ooooo`2Ioooo0012oooo00?o09Woooooool0?oooo`030000oooooooo09Woool004;oool00ol0VOoo
ooooo`0ooooo0P0009[oool004;oool00ol0VOooooooo`0ooooo00<0003oooooool0VOooo`00@_oo
o`03o`2Ioooooooo03ooool00`000?ooooooo`2Ioooo0012oooo00?o09Woooooool0?oooo`030000
oooooooo09Woool004;oool00ol0VOooooooo`0ooooo0P0009[oool004;oool00ol0VOooooooo`0o
oooo00<0003oooooool0VOooo`00@_ooo`03o`2Ioooooooo03ooool00`000?ooooooo`2Ioooo0012
oooo00?o09Woooooool0?oooo`030000oooooooo09Woool004;oool00ol0VOooooooo`0ooooo00<0
003oooooool0VOooo`00@_ooo`03o`2Ioooooooo03ooool20000V_ooo`00@_ooo`03o`2Ioooooooo
03ooool00`000?ooooooo`2Ioooo0012oooo00?o09Woooooool0?oooo`030000oooooooo09Woool0
04;oool00ol0VOooooooo`0ooooo00<0003oooooool0VOooo`00@_ooo`03o`2Ioooooooo03ooool2
0000V_ooo`00@_ooo`03o`2Ioooooooo03ooool00`000?ooooooo`2Ioooo0012oooo00?o09Wooooo
ool0?oooo`030000oooooooo09Woool004;oool00ol0VOooooooo`0goooo1@0000?oool00`000?oo
ooooo`2Ioooo0012oooo00?o09Woooooool0>Oooo`030000oooooooo00?oool00`000?ooooooo`2I
oooo0012oooo00?o09Woooooool0>Oooo`030000oooooooo00?oool30000VOooo`00@_ooo`03o`2I
oooooooo03Woool00`000?ooooooo`03oooo00<0003oooooool0VOooo`00@_ooo`03o`2Ioooooooo
03Woool00`000?ooooooo`03oooo00<0003oooooool0VOooo`00@_ooo`03o`2Ioooooooo03Soool2
00001Oooo`030000oooooooo09Woool004;oool00ol0VOooooooo`0ooooo0P0009[oool004;oool0
0ol0VOooooooo`0ooooo00<0003oooooool0VOooo`00@_ooo`03o`2Ioooooooo03ooool00`000?oo
ooooo`2Ioooo0012oooo00?o09Woooooool0?oooo`030000oooooooo09Woool004;oool00ol0VOoo
ooooo`0ooooo00<0003oooooool0VOooo`00@_ooo`03o`2Ioooooooo03ooool20000V_ooo`00@_oo
o`03o`2Ioooooooo03ooool00`000?ooooooo`2Ioooo0012oooo00?o09Woooooool0?oooo`030000
oooooooo09Woool004;oool00ol0VOooooooo`0ooooo00<0003oooooool0VOooo`00@_ooo`03o`2I
oooooooo03ooool20000V_ooo`00@_ooo`03o`2Ioooooooo03ooool00`000?ooooooo`2Ioooo0012
oooo00?o09Woooooool0?oooo`030000oooooooo09Woool004;oool00ol0VOooooooo`0ooooo00<0
003oooooool0VOooo`00@_ooo`03o`2Ioooooooo03ooool00`000?ooooooo`2Ioooo0012oooo00?o
09Woooooool0?oooo`80002Joooo0012oooo00?o09Woooooool0?oooo`030000oooooooo09Woool0
04;oool00ol0VOooooooo`0goooo100000Coool00`000?ooooooo`2Ioooo0012oooo00?o09Wooooo
ool0=oooo`030000oooooooo00Goool00`000?ooooooo`2Ioooo0012oooo00?o09Woooooool0>?oo
o`030000oooooooo00Coool30000VOooo`00@_ooo`03o`2Ioooooooo03Woool00`000?ooooooo`03
oooo00<0003oooooool0VOooo`00@_ooo`03o`2Ioooooooo03Ooool010000?ooooooo`0000Coool0
0`000?ooooooo`2Ioooo0012oooo00?o09Woooooool0>?ooo`800005oooo00<0003oooooool0VOoo
o`00@_ooo`03o`2Ioooooooo03ooool20000V_ooo`00@_ooo`03o`2Ioooooooo03ooool00`000?oo
ooooo`2Ioooo0012oooo00?o09Woooooool0?oooo`030000oooooooo09Woool004;oool00ol0VOoo
ooooo`0ooooo00<0003oooooool0VOooo`00@_ooo`03o`2Ioooooooo03ooool00`000?ooooooo`2I
oooo0012oooo00?o09Woooooool0?oooo`80002Joooo0012oooo00?o09Woooooool0?oooo`030000
oooooooo09Woool004;oool00ol0VOooooooo`0ooooo00<0003oooooool0VOooo`00@_ooo`03o`2I
oooooooo03ooool00`000?ooooooo`2Ioooo0012oooo00?o09Woooooool0?oooo`80002Joooo0012
oooo00?o09Woooooool0?oooo`030000oooooooo09Woool004;oool00ol0VOooooooo`0ooooo00<0
003oooooool0VOooo`00@_ooo`03o`2Ioooooooo03ooool00`000?ooooooo`2Ioooo0012oooo00?o
09Woooooool0?oooo`030000oooooooo09Woool004;oool00ol0VOooooooo`0ooooo0P0009[oool0
04;oool00ol0VOooooooo`0ooooo00<0003oooooool0VOooo`00@_ooo`03o`2Ioooooooo03Soool2
00001Oooo`030000oooooooo09Woool004;oool00ol0VOooooooo`0goooo00@0003oooooool00004
oooo00<0003oooooool0VOooo`00@_ooo`03o`2Ioooooooo03Woool00`000?ooooooo`03oooo0`00
09Woool004;oool00ol0VOooooooo`0joooo00<0003oooooool00_ooo`030000oooooooo09Woool0
04;oool00ol0VOooooooo`0goooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00@_oo
o`03o`2Ioooooooo03Soool200001Oooo`030000oooooooo09Woool004;oool00ol0VOooooooo`0o
oooo00<0003oooooool0VOooo`00@_ooo`03o`2Ioooooooo03ooool20000V_ooo`00@_ooo`03o`2I
oooooooo03ooool00`000?ooooooo`2Ioooo0012oooo00?o09Woooooool0?oooo`030000oooooooo
09Woool004;oool00ol0VOooooooo`0ooooo00<0003oooooool0VOooo`00@_ooo`03o`2Ioooooooo
03ooool20000V_ooo`00@_ooo`03o`2Ioooooooo03ooool00`000?ooooooo`2Ioooo0012oooo00?o
09Woooooool0?oooo`030000oooooooo09Woool004;oool00ol0VOooooooo`0ooooo00<0003ooooo
ool0VOooo`00@_ooo`03o`2Ioooooooo03ooool00`000?ooooooo`2Ioooo0012oooo00?o09Wooooo
ool0?oooo`80002Joooo0012oooo00?o09Woooooool0?oooo`030000oooooooo09Woool004;oool0
0ol0VOooooooo`0ooooo00<0003oooooool0VOooo`00@_ooo`03o`2Ioooooooo03ooool00`000?oo
ooooo`2Ioooo0012oooo00?o09Woooooool0?oooo`80002Joooo0012oooo00?o09Woooooool0?ooo
o`030000oooooooo09Woool004;oool00ol0VOooooooo`0ooooo00<0003oooooool0VOooo`00@_oo
o`03o`2Ioooooooo03Woool300000oooo`030000oooooooo09Woool004;oool00ol0VOooooooo`0j
oooo00<0003oooooool00_ooo`030000oooooooo09Woool004;oool00ol0VOooooooo`0goooo1@00
00?oool30000VOooo`00O?ooo`040000oooooooo0000X?ooo`00OOooo`030000oooo00000:3oool0
07koool20000X?ooo`00ooooob7oool00?oooolQoooo001loooo00<0003oooooool08_ooo`030000
oooooooo07coool007_oool00`000?ooooooo`08oooo00<0003oooooool06Oooo`030000oooooooo
07_oool007_oool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0>oooo0`0000;oool2
00001?ooo`030000oooooooo07_oool007_oool01@000?ooooooooooo`000002oooo00<0003ooooo
ool00_ooo`030000oooooooo00Coool400001_ooo`030000oooooooo00Ooool00`000?ooooooo`1k
oooo001joooo00<0003oooooool00_ooo`030000oooooooo01?oool500002Oooo`030000oooooooo
07[oool007_oool00`000?ooooooo`0500004_ooo`040000oooooooo00002Oooo`030000oooooooo
07_oool007_oool01@000?ooooooooooo`00000Foooo00<0003oool000002Oooo`030000oooooooo
07_oool007coool00`000?ooooooo`0Hoooo0P0000Soool00`000?ooooooo`1loooo003ooooo8Ooo
o`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-6.03535, \
-3.20105, 0.0455524, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-6.03535, -3.20105, 0.0455524, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.20178 .26487 L
.20742 .26487 L
.21019 .26487 L
.2114 .26487 L
.21274 .26487 L
.21394 .26487 L
s
.21394 .26487 m
.21439 .61803 L
s
0 .4 1 r
.02381 .24656 m
.04262 .24211 L
.06244 .23626 L
.08255 .22878 L
.10458 .21834 L
.12415 .20656 L
.14509 .19065 L
.16639 .17003 L
.18653 .14536 L
.19623 .13133 L
.20154 .12298 L
.20651 .1147 L
.21074 .10728 L
.21195 .10508 L
.21311 .10296 L
.21415 .10103 L
.21528 .26487 L
.21656 .26487 L
.21771 .26487 L
.22029 .26487 L
.22495 .26487 L
.26501 .26487 L
.30357 .26487 L
.34457 .26487 L
.38406 .26487 L
.42203 .26487 L
.46245 .26487 L
.50136 .26487 L
.54272 .26487 L
.58257 .26487 L
.6209 .26487 L
.66168 .26487 L
.70095 .26487 L
.7387 .26487 L
.7789 .26487 L
.81759 .26487 L
.85873 .26487 L
.89835 .26487 L
.93646 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001moooo0P000:7oool007coool010000?ooooooo`000:3oool007koool00`000?oo
ooooo`03oooo0`0009Woool007Koool400001Oooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo001loooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007coool200001_ooo`<0002I
oooo001foooo1P000004<ol00000000000001?ooo`030000oooooooo09Woool007Soool01@0003?o
03?o03?o00000002<ol00P0000?oool00`000?ooooooo`2Ioooo001goooo00<0000co`0co`000c?o
00800002<ol00P000003oooo0000oooo09[oool004Koool00`1Vooooooooo`0]oooo00<0000co`0c
o`002S?o0080002Koooo0016oooo00<0I_ooooooool0;?ooo`030000<ol0<ol000`co`020000V_oo
o`00AOooo`80I_l]oooo00<0000co`0co`003C?o00030000oooooooo09Woool004Goool206Ko;?oo
o`030000<ol0<ol000hco`020000V_ooo`00A?ooo`0306Kooooo06Ko02coool00`0003?o03?o000>
<ol000<0000co`000000VOooo`00@oooo`0406Kooooooooo06Ko:oooo`030000<ol0<ol000lco`02
000000<co`00003oool0Uoooo`00@_ooo`0506Kooooooooooooo06Ko02_oool00`0003?o03?o000?
<ol000@0000co`0co`00002Hoooo0012oooo00D0I_ooooooooooool0I_l0:_ooo`030000<ol0<ol0
010co`001@0003?o03?o03?o0000002Goooo0011oooo00<0I_ooooooool00_ooo`0306Kooooooooo
02Soool00`0003?o03?o000@<ol000<0000co`0co`000S?o00030000oooooooo09Coool0043oool0
0`1Vooooooooo`03oooo00<0I_ooooooool09oooo`030000<ol0<ol0014co`000`0003?o03?o0002
<ol000<0003oooooool0U?ooo`00@?ooo`0306Kooooooooo00?oool00`1Vooooooooo`0Voooo00<0
000co`0co`004S?o00800004<ol000<0003oooooool0Toooo`00?oooo`0306Kooooooooo00Coool0
0`1Vooooooooo`0Uoooo00<0000co`0co`004c?o00030000<ol0<ol000@co`000`000?ooooooo`2B
oooo000noooo00<0I_ooooooool01Oooo`0306Kooooooooo02Goool00`0003?o03?o000C<ol000<0
000co`0co`0013?o00030000oooooooo09;oool003goool00`1Vooooooooo`06oooo00<0I_oooooo
ool09?ooo`030000<ol0<ol001@co`000`0003?o03?o0005<ol000<0003oooooool0TOooo`00??oo
o`0306Kooooooooo00Ooool00`1Vooooooooo`0Soooo00<0000co`0co`005C?o00800007<ol000<0
003oooooool0T?ooo`00??ooo`0306Kooooooooo00Ooool00`1Vooooooooo`0Roooo00<0000co`0c
o`005S?o00030000<ol0<ol000Hco`000`000?ooooooo`2@oooo000koooo00<0I_ooooooool02?oo
o`0306Kooooooooo02;oool00`0003?o03?o000F<ol000<0000co`0co`001c?o00030000oooooooo
08ooool003[oool00`1Vooooooooo`09oooo00<0I_ooooooool08Oooo`030000<ol0<ol000lco`05
00000c?o00030000<ol0<ol000Pco`000`000?ooooooo`2>oooo000ioooo00<0I_ooooooool02_oo
o`0306Kooooooooo023oool00`0003?o03?o000B<ol000<0000co`0co`000c?o00030000<ol0<ol0
00Pco`000`000?ooooooo`2>oooo000hoooo00<0I_ooooooool02oooo`0306Kooooooooo01ooool0
0`0003?o03?o000C<ol000<0000co`0co`000c?o00<00009<ol000<0003oooooool0SOooo`00=ooo
o`0306Kooooooooo00coool00`1Vooooooooo`0Ooooo00<0000co`0co`002c?o00@00004<ol000<0
000co`0co`000c?o00030000<ol0<ol000Xco`000`000?ooooooo`2<oooo000foooo00<0I_oooooo
ool03_ooo`0306Kooooooooo01goool00`0003?o03?o000D<ol000<0000co`0co`000c?o00030000
<ol0<ol000/co`000`000?ooooooo`2;oooo000eoooo00<0I_ooooooool03oooo`0306Kooooooooo
01coool00`0003?o03?o000D<ol00P0000Dco`000`0003?o03?o000;<ol000<0003oooooool0Rooo
o`00=?ooo`0306Kooooooooo013oool00`1Vooooooooo`0Loooo00<0000co`0co`006c?o0080000=
<ol000<0003oooooool0R_ooo`00<_ooo`80I_lCoooo00<0I_ooooooool06oooo`030000<ol0<ol0
01`co`000`0003?o03?o000=<ol000<0003oooooool0ROooo`00<Oooo`0306Kooooooooo01?oool0
0`1Vooooooooo`0Joooo00<0000co`0co`007C?o00030000<ol0<ol000hco`000`000?ooooooo`28
oooo000`oooo00<0I_ooooooool05?ooo`0306Kooooooooo01Woool00`0003?o03?o000N<ol000<0
000co`0co`003c?o00030000oooooooo08Ooool002koool206Ko5oooo`0306Kooooooooo01Woool0
0`0003?o03?o000N<ol000<0000co`0co`0043?o00030000oooooooo08Koool002coool206Ko6Ooo
o`0306Kooooooooo01Soool00`0003?o03?o000O<ol00P00018co`000`000?ooooooo`25oooo000[
oooo00<0I_ooooooool06Oooo`0306Kooooooooo01Ooool00`0003?o03?o000P<ol000<0000co`0c
o`004S?o00030000oooooooo08Coool002Woool206Ko1?ooo`<0000Eoooo00<0I_ooooooool03ooo
o`@00002oooo0P0002<co`000`0003?o03?o000C<ol000<0003oooooool04Oooo`@0000Zoooo0`00
02Ooool300005oooo`009oooo`80I_l7oooo00<0003oooooool05?ooo`0306Kooooooooo00ooool0
0`000?ooooooo`02oooo00<0000co`0co`008c?o00030000<ol0<ol001@co`000`000?ooooooo`0@
oooo00<0003oooooool0;?ooo`030000oooooooo02Koool010000?ooooooo`0001Koool002Coool3
06Ko1_ooo`D0000Eoooo00<0I_ooooooool04?ooo`040000oooooooo00009S?o0080000F<ol00P00
017oool00`000?ooooooo`0Xoooo1@0002Ooool010000?ooooooo`0001Koool002;oool206Ko0ooo
o`@00002oooo00@0003oooooool0000Foooo00<0I_ooooooool02Oooo`@00004oooo0P0002Lco`00
0`0003?o03?o000G<ol000<0003oooooool03oooo`030000oooooooo02Ooool010000?ooooooo`00
02Soool300005oooo`007_ooo`@0I_l<oooo00<0003oool000005_ooo`0306Kooooooooo00ooool2
000000<co`00000co`009S?o00030000<ol0<ol001Pco`000`000?ooooooo`0<oooo00@0003ooooo
ool0000Yoooo00<0003oool00000:Oooo`030000oooooooo01Koool001[oool406Ko4Oooo`80000F
oooo00<0I_ooooooool03_ooo`@0000X<ol000<0000co`0co`006C?o00030000oooooooo00coool2
0000:oooo`80000Yoooo0`0001Koool001Soool206Ko;Oooo`0306Kooooooooo00coool20000;3?o
00030000<ol0<ol001Xco`020000OOooo`005_ooo`80I_l_oooo00<0I_ooooooool02_ooo`80000^
<ol00P0001dco`030000N_ooo`00Aoooo`0306Kooooooooo00Ooool30000<3?o00030000<ol0<ol0
01lco`060000M?ooo`00Aoooo`0406Kooooooooooooo1P0003<co`000`0003?o03?o000U<ol00`00
077oool0047oool6000000@0I_l000000000000i<ol000<0000co`0co`00:3?o00X0001Woooo000@
ooooo`00017oool001Koool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo
00Soool00`000?ooooooo`08oooo00D0003ooooooooooooo09T01_ooo`030000oooooooo00Soool0
0`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08
oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003ooooo
ool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000
oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool0
0`000?ooooooo`08oooo00<0003oooooool05Oooo`00;?ooo`030000oooooooo01Ooool00ol0VOoo
ooooo`0?oooo00<0003oooooool0:Oooo`030000oooooooo02Woool00`000?ooooooo`0Yoooo00<0
003oooooool0:Oooo`030000oooooooo01Goool004Koool00ol0VOooooooo`0koooo00<0003ooooo
ool0VOooo`00A_ooo`03o`2Ioooooooo03_oool00`000?ooooooo`2Ioooo0016oooo00?o09Wooooo
ool0>oooo`80002Joooo0016oooo00?o09Woooooool0>oooo`030000oooooooo09Woool004Koool0
0ol0VOooooooo`0koooo00<0003oooooool0VOooo`00A_ooo`03o`2Ioooooooo03_oool00`000?oo
ooooo`2Ioooo0016oooo00?o09Woooooool0>oooo`80002Joooo0016oooo00?o09Woooooool0>ooo
o`030000oooooooo09Woool004Koool00ol0VOooooooo`0koooo00<0003oooooool0VOooo`00A_oo
o`03o`2Ioooooooo03_oool00`000?ooooooo`2Ioooo0016oooo00?o09Woooooool0>oooo`030000
oooooooo09Woool004Koool00ol0VOooooooo`0koooo0P0009[oool004Koool00ol0VOooooooo`0k
oooo00<0003oooooool0VOooo`00A_ooo`03o`2Ioooooooo03_oool00`000?ooooooo`2Ioooo0016
oooo00?o09Woooooool0>oooo`030000oooooooo09Woool004Koool00ol0VOooooooo`0koooo0P00
09[oool004Koool00ol0VOooooooo`0koooo00<0003oooooool0VOooo`00A_ooo`03o`2Ioooooooo
03_oool00`000?ooooooo`2Ioooo0016oooo00?o09Woooooool0<oooo`D00003oooo00<0003ooooo
ool0VOooo`00A_ooo`03o`2Ioooooooo03Goool00`000?ooooooo`03oooo00<0003oooooool0VOoo
o`00A_ooo`03o`2Ioooooooo03Goool00`000?ooooooo`03oooo0`0009Woool004Koool00ol0VOoo
ooooo`0eoooo00<0003oooooool00oooo`030000oooooooo09Woool004Koool00ol0VOooooooo`0e
oooo00<0003oooooool00oooo`030000oooooooo09Woool004Koool00ol0VOooooooo`0doooo0P00
00Goool00`000?ooooooo`2Ioooo0016oooo00?o09Woooooool0>oooo`80002Joooo0016oooo00?o
09Woooooool0>oooo`030000oooooooo09Woool004Koool00ol0VOooooooo`0koooo00<0003ooooo
ool0VOooo`00A_ooo`03o`2Ioooooooo03_oool00`000?ooooooo`2Ioooo0016oooo00?o09Wooooo
ool0>oooo`030000oooooooo09Woool004Koool00ol0VOooooooo`0koooo0P0009[oool004Koool0
0ol0VOooooooo`0koooo00<0003oooooool0VOooo`00A_ooo`03o`2Ioooooooo03_oool00`000?oo
ooooo`2Ioooo0016oooo00?o09Woooooool0>oooo`030000oooooooo09Woool004Koool00ol0VOoo
ooooo`0koooo0P0009[oool004Koool00ol0VOooooooo`0koooo00<0003oooooool0VOooo`00A_oo
o`03o`2Ioooooooo03_oool00`000?ooooooo`2Ioooo0016oooo00?o09Woooooool0>oooo`030000
oooooooo09Woool004Koool00ol0VOooooooo`0koooo00<0003oooooool0VOooo`00A_ooo`03o`2I
oooooooo03_oool20000V_ooo`00A_ooo`03o`2Ioooooooo03_oool00`000?ooooooo`2Ioooo0016
oooo00?o09Woooooool0<oooo`@00004oooo00<0003oooooool0VOooo`00A_ooo`03o`2Ioooooooo
03?oool00`000?ooooooo`05oooo00<0003oooooool0VOooo`00A_ooo`03o`2Ioooooooo03Coool0
0`000?ooooooo`04oooo0`0009Woool004Ooool00ol0VOooooooo`0doooo00<0003oooooool00ooo
o`030000oooooooo09Woool004Ooool00ol0VOooooooo`0boooo00@0003oooooool00004oooo00<0
003oooooool0VOooo`00Aoooo`03o`2Ioooooooo03?oool200001Oooo`030000oooooooo09Woool0
04Ooool00ol0VOooooooo`0joooo0P0009[oool004Ooool00ol0VOooooooo`0joooo00<0003ooooo
ool0VOooo`00Aoooo`03o`2Ioooooooo03[oool00`000?ooooooo`2Ioooo0017oooo00?o09Wooooo
ool0>_ooo`030000oooooooo09Woool004Ooool00ol0VOooooooo`0joooo00<0003oooooool0VOoo
o`00Aoooo`03o`2Ioooooooo03[oool20000V_ooo`00Aoooo`03o`2Ioooooooo03[oool00`000?oo
ooooo`2Ioooo0017oooo00?o09Woooooool0>_ooo`030000oooooooo09Woool004Ooool00ol0VOoo
ooooo`0joooo00<0003oooooool0VOooo`00Aoooo`03o`2Ioooooooo03[oool20000V_ooo`00Aooo
o`03o`2Ioooooooo03[oool00`000?ooooooo`2Ioooo0017oooo00?o09Woooooool0>_ooo`030000
oooooooo09Woool004Ooool00ol0VOooooooo`0joooo00<0003oooooool0VOooo`00Aoooo`03o`2I
oooooooo03[oool00`000?ooooooo`2Ioooo0017oooo00?o09Woooooool0>_ooo`80002Joooo0017
oooo00?o09Woooooool0>_ooo`030000oooooooo09Woool004Ooool00ol0VOooooooo`0coooo0P00
00Goool00`000?ooooooo`2Ioooo0017oooo00?o09Woooooool0<_ooo`040000oooooooo00001?oo
o`030000oooooooo09Woool004Ooool00ol0VOooooooo`0doooo00<0003oooooool00oooo`<0002I
oooo0017oooo00?o09Woooooool0=Oooo`030000oooooooo00;oool00`000?ooooooo`2Ioooo0017
oooo00?o09Woooooool0<_ooo`040000oooooooo00001?ooo`030000oooooooo09Woool004Ooool0
0ol0VOooooooo`0coooo0P0000Goool00`000?ooooooo`2Ioooo0017oooo00?o09Woooooool0>_oo
o`030000oooooooo09Woool004Ooool00ol0VOooooooo`0joooo0P0009[oool004Ooool00ol0VOoo
ooooo`0joooo00<0003oooooool0VOooo`00Aoooo`03o`2Ioooooooo03[oool00`000?ooooooo`2I
oooo0017oooo00?o09Woooooool0>_ooo`030000oooooooo09Woool004Ooool00ol0VOooooooo`0j
oooo0P0009[oool004Ooool00ol0VOooooooo`0joooo00<0003oooooool0VOooo`00Aoooo`03o`2I
oooooooo03[oool00`000?ooooooo`2Ioooo0017oooo00?o09Woooooool0>_ooo`030000oooooooo
09Woool004Ooool00ol0VOooooooo`0joooo00<0003oooooool0VOooo`00Aoooo`03o`2Ioooooooo
03[oool20000V_ooo`00Aoooo`03o`2Ioooooooo03[oool00`000?ooooooo`2Ioooo0017oooo00?o
09Woooooool0>_ooo`030000oooooooo09Woool004Ooool00ol0VOooooooo`0joooo00<0003ooooo
ool0VOooo`00Aoooo`03o`2Ioooooooo03[oool20000V_ooo`00Aoooo`03o`2Ioooooooo03[oool0
0`000?ooooooo`2Ioooo0017oooo00?o09Woooooool0>_ooo`030000oooooooo09Woool004Ooool0
0ol0VOooooooo`0doooo0`0000?oool00`000?ooooooo`2Ioooo0017oooo00?o09Woooooool0=Ooo
o`030000oooooooo00;oool00`000?ooooooo`2Ioooo0017oooo00?o09Woooooool0<_ooo`D00003
oooo0`0009Woool007coool010000?ooooooo`000:3oool007goool00`000?ooo`00002Poooo001n
oooo0P000:3oool00?oooolQoooo003ooooo8Oooo`00NOooo`030000oooooooo02Soool00`000?oo
ooooo`1ioooo001hoooo00<0003oooooool02?ooo`030000oooooooo01ooool00`000?ooooooo`1h
oooo001hoooo00<0003oooooool00_ooo`800004oooo00<0003oooooool03Oooo`800004oooo0P00
00Coool200001?ooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`000002oooo00<0
003oooooool00_ooo`030000oooooooo00Coool400000oooo`040000oooooooo00002?ooo`040000
oooooooo00000oooo`030000oooooooo07Soool007Ooool00`000?ooooooo`02oooo00<0003ooooo
ool05Oooo`030000oooooooo00Ooool010000?ooooooo`0000Coool00`000?ooooooo`1goooo001h
oooo00<0003oooooool01@0001Goool00`000?ooooooo`07oooo0P0000Coool00`000?ooooooo`1h
oooo001hoooo00D0003oooooooooool000005Oooo`040000oooooooo00002?ooo`040000oooooooo
00000oooo`030000oooooooo07Soool007Woool00`000?ooooooo`0Goooo0P0000[oool200000ooo
o`030000oooooooo07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-6.03535, \
-3.20105, 0.0455524, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-6.03535, -3.20105, 0.0455524, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.20342 .26487 L
.21345 .26487 L
.22272 .26487 L
.22738 .26487 L
.22974 .26487 L
.23038 .26487 L
.23107 .26487 L
s
.23107 .26487 m
.23158 .61803 L
s
0 .4 1 r
.02381 .24988 m
.04262 .24624 L
.06244 .24145 L
.08255 .23533 L
.10458 .22678 L
.12415 .21714 L
.14509 .20412 L
.16639 .18724 L
.18653 .16705 L
.20481 .1443 L
.21521 .12914 L
.2203 .12106 L
.22495 .11326 L
.22729 .10919 L
.22853 .10699 L
.22985 .10462 L
.23111 .10231 L
.23226 .26487 L
.23342 .26487 L
.2345 .26487 L
.24479 .26487 L
.26581 .26487 L
.30437 .26487 L
.34537 .26487 L
.38486 .26487 L
.42283 .26487 L
.46325 .26487 L
.50216 .26487 L
.54352 .26487 L
.58337 .26487 L
.6217 .26487 L
.66248 .26487 L
.70175 .26487 L
.7395 .26487 L
.7797 .26487 L
.81839 .26487 L
.85953 .26487 L
.89915 .26487 L
.93726 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001moooo0P000:7oool007coool010000?ooooooo`000:3oool007koool00`000?oo
ooooo`03oooo0`0009Woool007Koool400001Oooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo001loooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007coool200001_ooo`<0002I
oooo001foooo1P000004<ol00000000000001?ooo`030000oooooooo09Woool007Soool01@0003?o
03?o03?o00000002<ol00P0000?oool00`000?ooooooo`2Ioooo001goooo00<0000co`0co`000c?o
00800002<ol00P000003oooo0000oooo09[oool004_oool00`1Vooooooooo`0Xoooo00<0000co`0c
o`002S?o0080002Koooo001:oooo0P1VobWoool00`0003?o03?o000<<ol00P0009[oool004[oool2
06Ko:?ooo`030000<ol0<ol000dco`000`000?ooooooo`2Ioooo0019oooo00<0I_ooool0I_l09ooo
o`030000<ol0<ol000hco`020000V_ooo`00B?ooo`0406Kooooooooo06Ko9oooo`030000<ol0<ol0
00hco`000`0003?o0000002Ioooo0018oooo00@0I_ooooooool0I_lVoooo00<0000co`0co`003c?o
008000000c?o00000?ooo`2Goooo0017oooo00D0I_ooooooooooool0I_l09_ooo`030000<ol0<ol0
00lco`00100003?o03?o000009Soool004Ooool01@1Vooooooooooooo`1Vo`0Uoooo00<0000co`0c
o`0043?o00050000<ol0<ol0<ol0000009Ooool004Koool00`1Vooooooooo`02oooo00<0I_oooooo
ool08oooo`030000<ol0<ol0010co`000`0003?o03?o0002<ol000<0003oooooool0U?ooo`00AOoo
o`0306Kooooooooo00?oool00`1Vooooooooo`0Roooo00<0000co`0co`004C?o00030000<ol0<ol0
008co`000`000?ooooooo`2Doooo0015oooo00<0I_ooooooool00oooo`0306Kooooooooo027oool0
0`0003?o03?o000B<ol00P0000@co`000`000?ooooooo`2Coooo0014oooo00<0I_ooooooool01?oo
o`0306Kooooooooo023oool00`0003?o03?o000C<ol000<0000co`0co`0013?o00030000oooooooo
09;oool004?oool00`1Vooooooooo`05oooo00<0I_ooooooool08?ooo`030000<ol0<ol001<co`00
0`0003?o03?o0004<ol000<0003oooooool0T_ooo`00@_ooo`0306Kooooooooo00Koool00`1Voooo
ooooo`0Ooooo00<0000co`0co`0053?o00030000<ol0<ol000Dco`000`000?ooooooo`2Aoooo0011
oooo00<0I_ooooooool01oooo`0306Kooooooooo01koool00`0003?o03?o000E<ol00P0000Lco`00
0`000?ooooooo`2@oooo0010oooo00<0I_ooooooool02?ooo`0306Kooooooooo01goool00`0003?o
03?o000F<ol000<0000co`0co`001S?o00030000oooooooo093oool003ooool00`1Vooooooooo`09
oooo00<0I_ooooooool07Oooo`030000<ol0<ol001Hco`000`0003?o03?o0007<ol000<0003ooooo
ool0Soooo`00?_ooo`0306Kooooooooo00[oool00`1Vooooooooo`0Loooo00<0000co`0co`003c?o
00D00003<ol000<0000co`0co`0023?o00030000oooooooo08koool003goool00`1Vooooooooo`0;
oooo00<0I_ooooooool06oooo`030000<ol0<ol0018co`000`0003?o03?o0003<ol000<0000co`0c
o`0023?o00030000oooooooo08koool003coool00`1Vooooooooo`0<oooo00<0I_ooooooool06_oo
o`030000<ol0<ol001<co`000`0003?o03?o0003<ol00`0000Tco`000`000?ooooooo`2=oooo000l
oooo00<0I_ooooooool03?ooo`0306Kooooooooo01[oool00`0003?o03?o000;<ol0100000@co`00
0`0003?o03?o0003<ol000<0000co`0co`002S?o00030000oooooooo08coool003_oool00`1Voooo
ooooo`0=oooo00<0I_ooooooool06Oooo`030000<ol0<ol001@co`000`0003?o03?o0003<ol000<0
000co`0co`002c?o00030000oooooooo08_oool003[oool00`1Vooooooooo`0>oooo00<0I_oooooo
ool06?ooo`030000<ol0<ol001@co`0200001C?o00030000<ol0<ol000/co`000`000?ooooooo`2;
oooo000ioooo00<0I_ooooooool03oooo`0306Kooooooooo01Soool00`0003?o03?o000K<ol00P00
00dco`000`000?ooooooo`2:oooo000goooo0P1Voa;oool00`1Vooooooooo`0Goooo00<0000co`0c
o`0073?o00030000<ol0<ol000dco`000`000?ooooooo`29oooo000foooo00<0I_ooooooool04_oo
o`0306Kooooooooo01Koool00`0003?o03?o000M<ol000<0000co`0co`003S?o00030000oooooooo
08Soool003Goool00`1Vooooooooo`0Coooo00<0I_ooooooool05Oooo`030000<ol0<ol001hco`00
0`0003?o03?o000?<ol000<0003oooooool0Qoooo`00<oooo`80I_lFoooo00<0I_ooooooool05Ooo
o`030000<ol0<ol001hco`000`0003?o03?o000@<ol000<0003oooooool0Q_ooo`00<Oooo`80I_lH
oooo00<0I_ooooooool05?ooo`030000<ol0<ol001lco`0200004S?o00030000oooooooo08Goool0
033oool00`1Vooooooooo`0Hoooo00<0I_ooooooool04oooo`030000<ol0<ol0020co`000`0003?o
03?o000B<ol000<0003oooooool0Q?ooo`00;_ooo`0406Ko0000000000006Oooo`0306Kooooooooo
00_oool400000_ooo`80000S<ol000<0000co`0co`004c?o00030000oooooooo017oool40000:_oo
o`<0000Woooo0`0001Ooool002coool206Ko0_ooo`030000oooooooo01Soool00`1Vooooooooo`0;
oooo00<0003oooooool00_ooo`030000<ol0<ol002<co`000`0003?o03?o000D<ol000<0003ooooo
ool04?ooo`030000oooooooo02coool00`000?ooooooo`0Voooo00@0003oooooool0000Foooo000Z
oooo0P1Vo`03oooo0000000000<0000Ioooo00<0I_ooooooool03?ooo`040000oooooooo00009S?o
0080000F<ol00P00017oool00`000?ooooooo`0Xoooo1@0002Ooool010000?ooooooo`0001Koool0
02Ooool400000_ooo`040000oooooooo00006_ooo`0306Kooooooooo00Goool400001?ooo`80000W
<ol000<0000co`0co`005c?o00030000oooooooo00ooool00`000?ooooooo`0Woooo00@0003ooooo
ool0000Xoooo0`0001Ooool002?oool406Ko1oooo`030000oooo000001[oool00`1Vooooooooo`0;
oooo0P000003<ol00000<ol002Hco`000`0003?o03?o000H<ol000<0003oooooool03?ooo`040000
oooooooo0000:Oooo`030000oooo000002Woool00`000?ooooooo`0Foooo000Noooo1@1Vo`coool2
00006_ooo`0306Kooooooooo00[oool40000:3?o00030000<ol0<ol001Tco`000`000?ooooooo`0<
oooo0P0002_oool20000:Oooo`<0000Foooo000Ioooo1@1Vobgoool00`1Vooooooooo`08oooo0P00
02`co`000`0003?o03?o000J<ol00P0007goool001Koool306Ko<_ooo`0306Kooooooooo00Koool2
0000;S?o0080000M<ol00`0007[oool004_oool00`1Vooooooooo`03oooo0`00030co`000`0003?o
03?o000O<ol01P0007Coool004_oool00`1Vo`00000000030000<c?o00030000<ol0<ol002Dco`03
0000LOooo`00@Oooo`X000000`1Voc?o03?o000f<ol000<0000co`0co`00:3?o00X0001Woooo000@
ooooo`00017oool001Koool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo
00Soool00`000?ooooooo`08oooo00<0003oooooool01_ooo`03o`2Ioooo000000[oool00`000?oo
ooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0
003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?oo
o`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo
00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?oo
ooooo`08oooo00<0003oooooool05Oooo`00;?ooo`030000oooooooo01coool00ol0VOooooooo`0:
oooo00<0003oooooool0:Oooo`030000oooooooo02Woool00`000?ooooooo`0Yoooo00<0003ooooo
ool0:Oooo`030000oooooooo01Goool004_oool00ol0VOooooooo`0foooo00<0003oooooool0VOoo
o`00Boooo`03o`2Ioooooooo03Koool00`000?ooooooo`2Ioooo001;oooo00?o09Woooooool0=_oo
o`80002Joooo001;oooo00?o09Woooooool0=_ooo`030000oooooooo09Woool004_oool00ol0VOoo
ooooo`0foooo00<0003oooooool0VOooo`00Boooo`03o`2Ioooooooo03Koool00`000?ooooooo`2I
oooo001;oooo00?o09Woooooool0=_ooo`80002Joooo001;oooo00?o09Woooooool0=_ooo`030000
oooooooo09Woool004_oool00ol0VOooooooo`0foooo00<0003oooooool0VOooo`00Boooo`03o`2I
oooooooo03Koool00`000?ooooooo`2Ioooo001;oooo00?o09Woooooool0=_ooo`030000oooooooo
09Woool004_oool00ol0VOooooooo`0foooo0P0009[oool004_oool00ol0VOooooooo`0foooo00<0
003oooooool0VOooo`00Boooo`03o`2Ioooooooo03Koool00`000?ooooooo`2Ioooo001;oooo00?o
09Woooooool0=_ooo`030000oooooooo09Woool004_oool00ol0VOooooooo`0foooo0P0009[oool0
04_oool00ol0VOooooooo`0foooo00<0003oooooool0VOooo`00Boooo`03o`2Ioooooooo03Koool0
0`000?ooooooo`2Ioooo001;oooo00?o09Woooooool0;_ooo`D00003oooo00<0003oooooool0VOoo
o`00Boooo`03o`2Ioooooooo033oool00`000?ooooooo`03oooo00<0003oooooool0VOooo`00Booo
o`03o`2Ioooooooo033oool00`000?ooooooo`03oooo0`0009Woool004_oool00ol0VOooooooo`0`
oooo00<0003oooooool00oooo`030000oooooooo09Woool004_oool00ol0VOooooooo`0`oooo00<0
003oooooool00oooo`030000oooooooo09Woool004_oool00ol0VOooooooo`0_oooo0P0000Goool0
0`000?ooooooo`2Ioooo001;oooo00?o09Woooooool0=_ooo`80002Joooo001;oooo00?o09Wooooo
ool0=_ooo`030000oooooooo09Woool004_oool00ol0VOooooooo`0foooo00<0003oooooool0VOoo
o`00Boooo`03o`2Ioooooooo03Koool00`000?ooooooo`2Ioooo001;oooo00?o09Woooooool0=_oo
o`030000oooooooo09Woool004_oool00ol0VOooooooo`0foooo0P0009[oool004_oool00ol0VOoo
ooooo`0foooo00<0003oooooool0VOooo`00Boooo`03o`2Ioooooooo03Koool00`000?ooooooo`2I
oooo001;oooo00?o09Woooooool0=_ooo`030000oooooooo09Woool004_oool00ol0VOooooooo`0f
oooo0P0009[oool004_oool00ol0VOooooooo`0foooo00<0003oooooool0VOooo`00Boooo`03o`2I
oooooooo03Koool00`000?ooooooo`2Ioooo001;oooo00?o09Woooooool0=_ooo`030000oooooooo
09Woool004_oool00ol0VOooooooo`0foooo00<0003oooooool0VOooo`00Boooo`03o`2Ioooooooo
03Koool20000V_ooo`00Boooo`03o`2Ioooooooo03Koool00`000?ooooooo`2Ioooo001;oooo00?o
09Woooooool0;_ooo`@00004oooo00<0003oooooool0VOooo`00Boooo`03o`2Ioooooooo02koool0
0`000?ooooooo`05oooo00<0003oooooool0VOooo`00Boooo`03o`2Ioooooooo02ooool00`000?oo
ooooo`04oooo0`0009Woool004_oool00ol0VOooooooo`0`oooo00<0003oooooool00oooo`030000
oooooooo09Woool004_oool00ol0VOooooooo`0^oooo00@0003oooooool00004oooo00<0003ooooo
ool0VOooo`00Boooo`03o`2Ioooooooo02ooool200001Oooo`030000oooooooo09Woool004_oool0
0ol0VOooooooo`0foooo0P0009[oool004_oool00ol0VOooooooo`0foooo00<0003oooooool0VOoo
o`00Boooo`03o`2Ioooooooo03Koool00`000?ooooooo`2Ioooo001;oooo00?o09Woooooool0=_oo
o`030000oooooooo09Woool004_oool00ol0VOooooooo`0foooo00<0003oooooool0VOooo`00Booo
o`03o`2Ioooooooo03Koool20000V_ooo`00Boooo`03o`2Ioooooooo03Koool00`000?ooooooo`2I
oooo001;oooo00?o09Woooooool0=_ooo`030000oooooooo09Woool004_oool00ol0VOooooooo`0f
oooo00<0003oooooool0VOooo`00Boooo`03o`2Ioooooooo03Koool20000V_ooo`00Boooo`03o`2I
oooooooo03Koool00`000?ooooooo`2Ioooo001;oooo00?o09Woooooool0=_ooo`030000oooooooo
09Woool004_oool00ol0VOooooooo`0foooo00<0003oooooool0VOooo`00Boooo`03o`2Ioooooooo
03Koool00`000?ooooooo`2Ioooo001;oooo00?o09Woooooool0=_ooo`80002Joooo001;oooo00?o
09Woooooool0=_ooo`030000oooooooo09Woool004_oool00ol0VOooooooo`0_oooo0P0000Goool0
0`000?ooooooo`2Ioooo001;oooo00?o09Woooooool0;_ooo`040000oooooooo00001?ooo`030000
oooooooo09Woool004_oool00ol0VOooooooo`0`oooo00<0003oooooool00oooo`<0002Ioooo001;
oooo00?o09Woooooool0<Oooo`030000oooooooo00;oool00`000?ooooooo`2Ioooo001;oooo00?o
09Woooooool0;_ooo`040000oooooooo00001?ooo`030000oooooooo09Woool004_oool00ol0VOoo
ooooo`0_oooo0P0000Goool00`000?ooooooo`2Ioooo001;oooo00?o09Woooooool0=_ooo`030000
oooooooo09Woool004_oool00ol0VOooooooo`0foooo0P0009[oool004_oool00ol0VOooooooo`0f
oooo00<0003oooooool0VOooo`00Boooo`03o`2Ioooooooo03Koool00`000?ooooooo`2Ioooo001;
oooo00?o09Woooooool0=_ooo`030000oooooooo09Woool004_oool00ol0VOooooooo`0foooo0P00
09[oool004_oool00ol0VOooooooo`0foooo00<0003oooooool0VOooo`00Boooo`03o`2Ioooooooo
03Koool00`000?ooooooo`2Ioooo001;oooo00?o09Woooooool0=_ooo`030000oooooooo09Woool0
04_oool00ol0VOooooooo`0foooo00<0003oooooool0VOooo`00Boooo`03o`2Ioooooooo03Koool2
0000V_ooo`00Boooo`03o`2Ioooooooo03Koool00`000?ooooooo`2Ioooo001;oooo00?o09Wooooo
ool0=_ooo`030000oooooooo09Woool004_oool00ol0VOooooooo`0foooo00<0003oooooool0VOoo
o`00Boooo`03o`2Ioooooooo03Koool20000V_ooo`00Boooo`03o`2Ioooooooo03Koool00`000?oo
ooooo`2Ioooo001;oooo00?o09Woooooool0=_ooo`030000oooooooo09Woool004_oool00ol0VOoo
ooooo`0`oooo0`0000?oool00`000?ooooooo`2Ioooo001;oooo00?o09Woooooool0<Oooo`030000
oooooooo00;oool00`000?ooooooo`2Ioooo001;oooo00?o09Woooooool0;_ooo`D00003oooo0`00
09Woool007coool010000?ooooooo`000:3oool007goool00`000?ooo`00002Poooo001noooo0P00
0:3oool00?oooolQoooo003ooooo8Oooo`00NOooo`030000oooooooo02Soool00`000?ooooooo`1i
oooo001hoooo00<0003oooooool02?ooo`030000oooooooo01ooool00`000?ooooooo`1hoooo001h
oooo00<0003oooooool00_ooo`800004oooo00<0003oooooool03Oooo`800004oooo0P0000?oool3
00001?ooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`000002oooo00<0003ooooo
ool00_ooo`030000oooooooo00Coool400000oooo`040000oooooooo00002?ooo`040000oooooooo
00000oooo`030000oooooooo07Soool007Ooool00`000?ooooooo`02oooo00<0003oooooool05Ooo
o`030000oooooooo00Ooool010000?ooooooo`0000Coool00`000?ooooooo`1goooo001hoooo00<0
003oooooool01@0001Goool00`000?ooooooo`06oooo0`0000Coool00`000?ooooooo`1hoooo001h
oooo00D0003oooooooooool000005Oooo`040000oooooooo00002Oooo`030000oooooooo00?oool0
0`000?ooooooo`1hoooo001ioooo00<0003oooooool05oooo`80000:oooo0`0000;oool00`000?oo
ooooo`1ioooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-6.03535, \
-3.20105, 0.0455524, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-6.03535, -3.20105, 0.0455524, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.20342 .26487 L
.22272 .26487 L
.23233 .26487 L
.23739 .26487 L
.24276 .26487 L
.24502 .26487 L
.24745 .26487 L
.24816 .26487 L
.24884 .26487 L
s
.24884 .26487 m
.24935 .61803 L
s
0 .4 1 r
.02381 .2526 m
.04262 .24963 L
.06244 .2457 L
.08255 .2407 L
.10458 .2337 L
.12415 .22581 L
.14509 .21515 L
.16639 .20134 L
.18653 .18481 L
.22495 .14079 L
.23519 .12556 L
.2402 .11747 L
.24479 .10969 L
.24597 .10762 L
.24726 .10533 L
.24848 .10314 L
.24961 .26487 L
.25092 .26487 L
.25212 .26487 L
.25479 .26487 L
.26581 .26487 L
.30588 .26487 L
.34443 .26487 L
.38544 .26487 L
.42492 .26487 L
.46289 .26487 L
.50332 .26487 L
.54223 .26487 L
.58359 .26487 L
.62343 .26487 L
.66176 .26487 L
.70255 .26487 L
.74181 .26487 L
.77956 .26487 L
.81977 .26487 L
.85845 .26487 L
.89959 .26487 L
.93922 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001moooo0P000:7oool007coool010000?ooooooo`000:3oool007koool00`000?oo
ooooo`03oooo0`0009Woool007Koool400001Oooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo001loooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007coool200001_ooo`<0002I
oooo001foooo1P000004<ol00000000000001?ooo`030000oooooooo09Woool007Soool01@0003?o
03?o03?o00000002<ol00P0000?oool00`000?ooooooo`2Ioooo001goooo00<0000co`0co`000c?o
00800002<ol00P000003oooo0000oooo09[oool004ooool00`1Vooooooooo`0Toooo00<0000co`0c
o`002S?o0080002Koooo001?oooo00<0I_ooooooool08oooo`030000<ol0<ol000`co`020000V_oo
o`00C_ooo`80I_lToooo00<0000co`0co`003C?o00030000oooooooo09Woool004goool00`1Voooo
o`1Vo`0Soooo00<0000co`0co`003S?o0080002Joooo001=oooo00<0I_ooool0I_l08oooo`030000
<ol0<ol000hco`000`0003?o0000002Ioooo001<oooo00@0I_ooooooool0I_lRoooo00<0000co`0c
o`003c?o008000000c?o00000?ooo`2Goooo001<oooo00@0I_ooooooool0I_lRoooo00<0000co`0c
o`003c?o00040000<ol0<ol00000V?ooo`00Boooo`0506Kooooooooooooo06Ko027oool00`0003?o
03?o000@<ol000D0000co`0co`0co`000000Uoooo`00B_ooo`0306Kooooooooo00;oool00`1Voooo
ooooo`0Ooooo00<0000co`0co`0043?o00030000<ol0<ol0008co`000`000?ooooooo`2Doooo001:
oooo00<0I_ooooooool00_ooo`0306Kooooooooo01koool00`0003?o03?o000A<ol000<0000co`0c
o`000S?o00030000oooooooo09Coool004Woool00`1Vooooooooo`03oooo00<0I_ooooooool07Ooo
o`030000<ol0<ol0018co`02000013?o00030000oooooooo09?oool004Soool00`1Vooooooooo`04
oooo00<0I_ooooooool07?ooo`030000<ol0<ol001<co`000`0003?o03?o0004<ol000<0003ooooo
ool0T_ooo`00Aoooo`0306Kooooooooo00Goool00`1Vooooooooo`0Loooo00<0000co`0co`004c?o
00030000<ol0<ol000@co`000`000?ooooooo`2Boooo0016oooo00<0I_ooooooool01_ooo`0306Ko
oooooooo01_oool00`0003?o03?o000D<ol000<0000co`0co`001C?o00030000oooooooo097oool0
04Goool00`1Vooooooooo`07oooo00<0I_ooooooool06_ooo`030000<ol0<ol001Dco`0200001c?o
00030000oooooooo093oool004Coool00`1Vooooooooo`08oooo00<0I_ooooooool06Oooo`030000
<ol0<ol001Hco`000`0003?o03?o0006<ol000<0003oooooool0T?ooo`00A?ooo`0306Kooooooooo
00Soool00`1Vooooooooo`0Ioooo00<0000co`0co`005S?o00030000<ol0<ol000Lco`000`000?oo
ooooo`2?oooo0013oooo00<0I_ooooooool02Oooo`0306Kooooooooo01Soool00`0003?o03?o000?
<ol01@0000<co`000`0003?o03?o0008<ol000<0003oooooool0S_ooo`00@_ooo`0306Kooooooooo
00[oool00`1Vooooooooo`0Goooo00<0000co`0co`004S?o00030000<ol0<ol000<co`000`0003?o
03?o0008<ol000<0003oooooool0S_ooo`00@Oooo`0306Kooooooooo00_oool00`1Vooooooooo`0F
oooo00<0000co`0co`004c?o00030000<ol0<ol000<co`0300002C?o00030000oooooooo08goool0
043oool00`1Vooooooooo`0<oooo00<0I_ooooooool05_ooo`030000<ol0<ol000/co`04000013?o
00030000<ol0<ol000<co`000`0003?o03?o000:<ol000<0003oooooool0S?ooo`00?oooo`0306Ko
oooooooo00goool00`1Vooooooooo`0Eoooo00<0000co`0co`0053?o00030000<ol0<ol000<co`00
0`0003?o03?o000;<ol000<0003oooooool0Roooo`00?_ooo`0306Kooooooooo00koool00`1Voooo
ooooo`0Doooo00<0000co`0co`0053?o00800005<ol000<0000co`0co`002c?o00030000oooooooo
08_oool003coool206Ko4Oooo`0306Kooooooooo01Coool00`0003?o03?o000K<ol00P0000dco`00
0`000?ooooooo`2:oooo000koooo00<0I_ooooooool04Oooo`0306Kooooooooo01?oool00`0003?o
03?o000L<ol000<0000co`0co`003C?o00030000oooooooo08Woool003[oool00`1Vooooooooo`0B
oooo00<0I_ooooooool04_ooo`030000<ol0<ol001dco`000`0003?o03?o000><ol000<0003ooooo
ool0R?ooo`00>Oooo`0306Kooooooooo01?oool00`1Vooooooooo`0Aoooo00<0000co`0co`007S?o
00030000<ol0<ol000lco`000`000?ooooooo`27oooo000goooo0P1VoaKoool00`1Vooooooooo`0A
oooo00<0000co`0co`007S?o00030000<ol0<ol0010co`000`000?ooooooo`26oooo000foooo00<0
I_ooooooool05_ooo`0306Kooooooooo013oool00`0003?o03?o000O<ol00P00018co`000`000?oo
ooooo`25oooo000doooo0P1VoaWoool00`1Vooooooooo`0?oooo00<0000co`0co`0083?o00030000
<ol0<ol0018co`000`000?ooooooo`24oooo000_oooo0`000080I_lKoooo00<0I_ooooooool01ooo
o`@00002oooo0P0002<co`000`0003?o03?o000C<ol000<0003oooooool04Oooo`@0000Zoooo0`00
02Ooool300005oooo`00;oooo`0306Ko000006Ko01goool00`1Vooooooooo`07oooo00<0003ooooo
ool00_ooo`030000<ol0<ol002<co`000`0003?o03?o000D<ol000<0003oooooool04?ooo`030000
oooooooo02coool00`000?ooooooo`0Voooo00@0003oooooool0000Foooo000]oooo1@0001goool0
0`1Vooooooooo`08oooo00@0003oooooool0000V<ol00P0001Hco`0200004Oooo`030000oooooooo
02Soool500009oooo`040000oooooooo00005_ooo`009oooo`@0000206Ko00@0003oooooool0000N
oooo00@0I_ooooooooooool400001?ooo`80000W<ol000<0000co`0co`005c?o00030000oooooooo
00ooool00`000?ooooooo`0Woooo00@0003oooooool0000Xoooo0`0001Ooool002Ooool306Ko1?oo
o`030000oooo000001koool00`1Vooooooooo`07oooo0P000003<ol00000<ol002Hco`000`0003?o
03?o000H<ol000<0003oooooool03?ooo`040000oooooooo0000:Oooo`030000oooo000002Woool0
0`000?ooooooo`0Foooo000Soooo101Vo`Soool200007_ooo`0306Kooooooooo00Koool40000:3?o
00030000<ol0<ol001Tco`000`000?ooooooo`0<oooo0P0002_oool20000:Oooo`<0000Foooo000N
oooo1@1Vobcoool00`1Vooooooooo`04oooo0P0002`co`000`0003?o03?o000J<ol00P0007goool0
01Woool506Ko<Oooo`0306Kooooooooo00;oool20000;S?o0080000M<ol00`0007[oool001Koool3
06Ko=_ooo`0306Kooooo00000080000`<ol000<0000co`0co`007c?o00H0001doooo001;oooo1000
000306Ko0000<ol0038co`000`0003?o03?o000U<ol00`00077oool0047oool:000013?o000306Ko
<ol0<ol0038co`000`0003?o03?o000X<ol02P0006Ooool0013ooooo00004Oooo`005_ooo`030000
oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool0
0`000?ooooooo`08oooo00<0003ooooo09T02?ooo`030000oooooooo00Soool00`000?ooooooo`08
oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003ooooo
ool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000
oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool0
0`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`0E
oooo000/oooo00<0003oooooool08?ooo`03o`2Ioooooooo00Koool00`000?ooooooo`0Yoooo00<0
003oooooool0:Oooo`030000oooooooo02Woool00`000?ooooooo`0Yoooo00<0003oooooool05Ooo
o`00Coooo`03o`2Ioooooooo03;oool00`000?ooooooo`2Ioooo001?oooo00?o09Woooooool0<_oo
o`030000oooooooo09Woool004ooool00ol0VOooooooo`0boooo0P0009[oool004ooool00ol0VOoo
ooooo`0boooo00<0003oooooool0VOooo`00Coooo`03o`2Ioooooooo03;oool00`000?ooooooo`2I
oooo001?oooo00?o09Woooooool0<_ooo`030000oooooooo09Woool004ooool00ol0VOooooooo`0b
oooo0P0009[oool004ooool00ol0VOooooooo`0boooo00<0003oooooool0VOooo`00Coooo`03o`2I
oooooooo03;oool00`000?ooooooo`2Ioooo001?oooo00?o09Woooooool0<_ooo`030000oooooooo
09Woool004ooool00ol0VOooooooo`0boooo00<0003oooooool0VOooo`00Coooo`03o`2Ioooooooo
03;oool20000V_ooo`00Coooo`03o`2Ioooooooo03;oool00`000?ooooooo`2Ioooo001?oooo00?o
09Woooooool0<_ooo`030000oooooooo09Woool004ooool00ol0VOooooooo`0boooo00<0003ooooo
ool0VOooo`00Coooo`03o`2Ioooooooo03;oool20000V_ooo`00Coooo`03o`2Ioooooooo03;oool0
0`000?ooooooo`2Ioooo001?oooo00?o09Woooooool0<_ooo`030000oooooooo09Woool004ooool0
0ol0VOooooooo`0Zoooo1@0000?oool00`000?ooooooo`2Ioooo001?oooo00?o09Woooooool0;?oo
o`030000oooooooo00?oool00`000?ooooooo`2Ioooo001?oooo00?o09Woooooool0;?ooo`030000
oooooooo00?oool30000VOooo`00Coooo`03o`2Ioooooooo02coool00`000?ooooooo`03oooo00<0
003oooooool0VOooo`00Coooo`03o`2Ioooooooo02coool00`000?ooooooo`03oooo00<0003ooooo
ool0VOooo`00Coooo`03o`2Ioooooooo02_oool200001Oooo`030000oooooooo09Woool004ooool0
0ol0VOooooooo`0boooo0P0009[oool004ooool00ol0VOooooooo`0boooo00<0003oooooool0VOoo
o`00Coooo`03o`2Ioooooooo03;oool00`000?ooooooo`2Ioooo001?oooo00?o09Woooooool0<_oo
o`030000oooooooo09Woool004ooool00ol0VOooooooo`0boooo00<0003oooooool0VOooo`00Cooo
o`03o`2Ioooooooo03;oool20000V_ooo`00Coooo`03o`2Ioooooooo03;oool00`000?ooooooo`2I
oooo001?oooo00?o09Woooooool0<_ooo`030000oooooooo09Woool004ooool00ol0VOooooooo`0b
oooo00<0003oooooool0VOooo`00Coooo`03o`2Ioooooooo03;oool20000V_ooo`00Coooo`03o`2I
oooooooo03;oool00`000?ooooooo`2Ioooo001?oooo00?o09Woooooool0<_ooo`030000oooooooo
09Woool004ooool00ol0VOooooooo`0boooo00<0003oooooool0VOooo`00Coooo`03o`2Ioooooooo
03;oool00`000?ooooooo`2Ioooo001?oooo00?o09Woooooool0<_ooo`80002Joooo001?oooo00?o
09Woooooool0<_ooo`030000oooooooo09Woool004ooool00ol0VOooooooo`0Zoooo100000Coool0
0`000?ooooooo`2Ioooo001?oooo00?o09Woooooool0:_ooo`030000oooooooo00Goool00`000?oo
ooooo`2Ioooo001?oooo00?o09Woooooool0:oooo`030000oooooooo00Coool30000VOooo`00Cooo
o`03o`2Ioooooooo02coool00`000?ooooooo`03oooo00<0003oooooool0VOooo`00Coooo`03o`2I
oooooooo02[oool010000?ooooooo`0000Coool00`000?ooooooo`2Ioooo001?oooo00?o09Wooooo
ool0:oooo`800005oooo00<0003oooooool0VOooo`00Coooo`03o`2Ioooooooo03;oool20000V_oo
o`00Coooo`03o`2Ioooooooo03;oool00`000?ooooooo`2Ioooo001?oooo00?o09Woooooool0<_oo
o`030000oooooooo09Woool004ooool00ol0VOooooooo`0boooo00<0003oooooool0VOooo`00Cooo
o`03o`2Ioooooooo03;oool00`000?ooooooo`2Ioooo001?oooo00?o09Woooooool0<_ooo`80002J
oooo001?oooo00?o09Woooooool0<_ooo`030000oooooooo09Woool004ooool00ol0VOooooooo`0b
oooo00<0003oooooool0VOooo`00Coooo`03o`2Ioooooooo03;oool00`000?ooooooo`2Ioooo001?
oooo00?o09Woooooool0<_ooo`80002Joooo001?oooo00?o09Woooooool0<_ooo`030000oooooooo
09Woool004ooool00ol0VOooooooo`0boooo00<0003oooooool0VOooo`00Coooo`03o`2Ioooooooo
03;oool00`000?ooooooo`2Ioooo001?oooo00?o09Woooooool0<_ooo`030000oooooooo09Woool0
04ooool00ol0VOooooooo`0boooo0P0009[oool004ooool00ol0VOooooooo`0boooo00<0003ooooo
ool0VOooo`00Coooo`03o`2Ioooooooo02_oool200001Oooo`030000oooooooo09Woool004ooool0
0ol0VOooooooo`0Zoooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00Coooo`03o`2I
oooooooo02coool00`000?ooooooo`03oooo0`0009Woool004ooool00ol0VOooooooo`0]oooo00<0
003oooooool00_ooo`030000oooooooo09Woool004ooool00ol0VOooooooo`0Zoooo00@0003ooooo
ool00004oooo00<0003oooooool0VOooo`00Coooo`03o`2Ioooooooo02_oool200001Oooo`030000
oooooooo09Woool004ooool00ol0VOooooooo`0boooo00<0003oooooool0VOooo`00Coooo`03o`2I
oooooooo03;oool20000V_ooo`00Coooo`03o`2Ioooooooo03;oool00`000?ooooooo`2Ioooo001?
oooo00?o09Woooooool0<_ooo`030000oooooooo09Woool004ooool00ol0VOooooooo`0boooo00<0
003oooooool0VOooo`00Coooo`03o`2Ioooooooo03;oool20000V_ooo`00Coooo`03o`2Ioooooooo
03;oool00`000?ooooooo`2Ioooo001?oooo00?o09Woooooool0<_ooo`030000oooooooo09Woool0
04ooool00ol0VOooooooo`0boooo00<0003oooooool0VOooo`00Coooo`03o`2Ioooooooo03;oool0
0`000?ooooooo`2Ioooo001?oooo00?o09Woooooool0<_ooo`80002Joooo001?oooo00?o09Wooooo
ool0<_ooo`030000oooooooo09Woool004ooool00ol0VOooooooo`0boooo00<0003oooooool0VOoo
o`00Coooo`03o`2Ioooooooo03;oool00`000?ooooooo`2Ioooo001?oooo00?o09Woooooool0<_oo
o`80002Joooo001?oooo00?o09Woooooool0<_ooo`030000oooooooo09Woool004ooool00ol0VOoo
ooooo`0boooo00<0003oooooool0VOooo`00Coooo`03o`2Ioooooooo02coool300000oooo`030000
oooooooo09Woool004ooool00ol0VOooooooo`0]oooo00<0003oooooool00_ooo`030000oooooooo
09Woool004ooool00ol0VOooooooo`0Zoooo1@0000?oool30000VOooo`00O?ooo`040000oooooooo
0000X?ooo`00OOooo`030000oooo00000:3oool007koool20000X?ooo`00ooooob7oool00?oooolQ
oooo001ioooo00<0003oooooool0:?ooo`030000oooooooo07Woool007Soool00`000?ooooooo`08
oooo00<0003oooooool07oooo`030000oooooooo07Soool007Soool00`000?ooooooo`02oooo0P00
00Coool00`000?ooooooo`0=oooo0P0000Coool200001Oooo`<00002oooo00<0003oooooool0N?oo
o`00N?ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01?oo
o`@00003oooo00@0003oooooool0000;oooo00D0003oooooooooool00000N_ooo`00Moooo`030000
oooooooo00;oool00`000?ooooooo`0Eoooo00<0003oooooool01oooo`D00003oooo00<0003ooooo
ool0Moooo`00N?ooo`030000oooooooo00D0000Eoooo00<0003oooooool01_ooo`040000oooooooo
00000oooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`00000Eoooo00@0003ooooo
ool00009oooo00<0003oool000000oooo`030000oooooooo07Soool007Woool00`000?ooooooo`0G
oooo0P0000_oool200000_ooo`030000oooooooo07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-6.03535, \
-3.20105, 0.0455524, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-6.03535, -3.20105, 0.0455524, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.24141 .26487 L
.25127 .26487 L
.25666 .26487 L
.26171 .26487 L
.26425 .26487 L
.26498 .26487 L
.26568 .26487 L
s
.26568 .26487 m
.2662 .61803 L
s
0 .4 1 r
.02381 .25483 m
.04262 .2524 L
.06244 .24919 L
.08255 .24509 L
.10458 .23936 L
.12415 .23291 L
.14509 .22418 L
.16639 .21288 L
.18653 .19936 L
.22495 .16334 L
.24479 .13789 L
.25492 .12268 L
.2605 .11359 L
.26326 .10891 L
.2646 .10659 L
.26581 .10446 L
.26703 .26487 L
.26818 .26487 L
.27069 .26487 L
.27602 .26487 L
.28535 .26487 L
.30365 .26487 L
.3422 .26487 L
.3832 .26487 L
.42269 .26487 L
.46066 .26487 L
.50109 .26487 L
.54 .26487 L
.58136 .26487 L
.6212 .26487 L
.65953 .26487 L
.70031 .26487 L
.73958 .26487 L
.77733 .26487 L
.81753 .26487 L
.85622 .26487 L
.89736 .26487 L
.93699 .26487 L
.97509 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001moooo0P000:7oool007coool010000?ooooooo`000:3oool007koool00`000?oo
ooooo`03oooo0`0009Woool007Koool400001Oooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo001loooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007coool200001_ooo`<0002I
oooo001foooo1P000004<ol00000000000001?ooo`030000oooooooo09Woool007Soool01@0003?o
03?o03?o00000002<ol00P0000?oool00`000?ooooooo`2Ioooo001goooo00<0000co`0co`000c?o
00800002<ol00P000003oooo0000oooo09[oool007Koool00`0003?o03?o000:<ol00P0009_oool0
05?oool206Ko8?ooo`030000<ol0<ol000`co`020000V_ooo`00Doooo`80I_lOoooo00<0000co`0c
o`003C?o00030000oooooooo09Woool005;oool00`1Vooooo`1Vo`0Noooo00<0000co`0co`003S?o
0080002Joooo001Aoooo00@0I_ooooooool0I_lNoooo00<0000co`0co`003S?o00030000<ol00000
09Woool0057oool0101Vooooooooo`1Voagoool00`0003?o03?o000?<ol00P000003<ol00000oooo
09Ooool0053oool01@1Vooooooooooooo`1Vo`0Moooo00<0000co`0co`003c?o00040000<ol0<ol0
0000V?ooo`00Coooo`0306Kooooooooo00;oool00`1Vooooooooo`0Joooo00<0000co`0co`0043?o
00050000<ol0<ol0<ol0000009Ooool004ooool00`1Vooooooooo`02oooo00<0I_ooooooool06_oo
o`030000<ol0<ol0010co`000`0003?o03?o0002<ol000<0003oooooool0U?ooo`00C_ooo`0306Ko
oooooooo00?oool00`1Vooooooooo`0Ioooo00<0000co`0co`004C?o00030000<ol0<ol0008co`00
0`000?ooooooo`2Doooo001=oooo00<0I_ooooooool01?ooo`0306Kooooooooo01Soool00`0003?o
03?o000B<ol00P0000@co`000`000?ooooooo`2Coooo001<oooo00<0I_ooooooool01Oooo`0306Ko
oooooooo01Ooool00`0003?o03?o000C<ol000<0000co`0co`0013?o00030000oooooooo09;oool0
04_oool00`1Vooooooooo`06oooo00<0I_ooooooool05oooo`030000<ol0<ol001<co`000`0003?o
03?o0004<ol000<0003oooooool0T_ooo`00Boooo`0306Kooooooooo00Koool00`1Vooooooooo`0F
oooo00<0000co`0co`0053?o00030000<ol0<ol000Dco`000`000?ooooooo`2Aoooo001:oooo00<0
I_ooooooool01oooo`0306Kooooooooo01Goool00`0003?o03?o000E<ol00P0000Lco`000`000?oo
ooooo`2@oooo0019oooo00<0I_ooooooool02?ooo`0306Kooooooooo01Coool00`0003?o03?o000F
<ol000<0000co`0co`001S?o00030000oooooooo093oool004Soool00`1Vooooooooo`09oooo00<0
I_ooooooool05?ooo`030000<ol0<ol001Hco`000`0003?o03?o0007<ol000<0003oooooool0Sooo
o`00Aoooo`0306Kooooooooo00[oool00`1Vooooooooo`0Coooo00<0000co`0co`003c?o00D00003
<ol000<0000co`0co`0023?o00030000oooooooo08koool004Koool00`1Vooooooooo`0;oooo00<0
I_ooooooool04_ooo`030000<ol0<ol0018co`000`0003?o03?o0003<ol000<0000co`0co`0023?o
00030000oooooooo08koool004Goool00`1Vooooooooo`0<oooo00<0I_ooooooool04Oooo`030000
<ol0<ol001<co`000`0003?o03?o0003<ol00`0000Tco`000`000?ooooooo`2=oooo0014oooo00<0
I_ooooooool03Oooo`0306Kooooooooo017oool00`0003?o03?o000;<ol0100000@co`000`0003?o
03?o0003<ol000<0000co`0co`002S?o00030000oooooooo08coool004?oool00`1Vooooooooo`0>
oooo00<0I_ooooooool04?ooo`030000<ol0<ol001@co`000`0003?o03?o0003<ol000<0000co`0c
o`002c?o00030000oooooooo08_oool004;oool00`1Vooooooooo`0?oooo00<0I_ooooooool03ooo
o`030000<ol0<ol001@co`0200001C?o00030000<ol0<ol000/co`000`000?ooooooo`2;oooo0011
oooo00<0I_ooooooool04?ooo`0306Kooooooooo00ooool00`0003?o03?o000K<ol00P0000dco`00
0`000?ooooooo`2:oooo0010oooo00<0I_ooooooool04Oooo`0306Kooooooooo00koool00`0003?o
03?o000L<ol000<0000co`0co`003C?o00030000oooooooo08Woool003ooool00`1Vooooooooo`0B
oooo00<0I_ooooooool03Oooo`030000<ol0<ol001dco`000`0003?o03?o000><ol000<0003ooooo
ool0R?ooo`00?Oooo`80I_lEoooo00<0I_ooooooool03?ooo`030000<ol0<ol001hco`000`0003?o
03?o000?<ol000<0003oooooool0Qoooo`00>oooo`80I_lGoooo00<0I_ooooooool03?ooo`030000
<ol0<ol001hco`000`0003?o03?o000@<ol000<0003oooooool0Q_ooo`00>_ooo`0306Kooooooooo
01Ooool00`1Vooooooooo`0;oooo00<0000co`0co`007c?o0080000B<ol000<0003oooooool0QOoo
o`00>?ooo`80I_lJoooo00<0I_ooooooool02_ooo`030000<ol0<ol0020co`000`0003?o03?o000B
<ol000<0003oooooool0Q?ooo`00;oooo`<00004oooo0P1Voacoool00`1Vooooooooo`02oooo1000
00;oool200008c?o00030000<ol0<ol001<co`000`000?ooooooo`0Aoooo100002[oool300009ooo
o`<0000Goooo000`oooo00@0003oooooooooool206Ko7_ooo`0306Kooooooooo00;oool00`000?oo
ooooo`02oooo00<0000co`0co`008c?o00030000<ol0<ol001@co`000`000?ooooooo`0@oooo00<0
003oooooool0;?ooo`030000oooooooo02Koool010000?ooooooo`0001Koool002goool500000P1V
ob3oool00`1Vooooooooo`03oooo00@0003oooooool0000V<ol00P0001Hco`0200004Oooo`030000
oooooooo02Soool500009oooo`040000oooooooo00005_ooo`009oooo`@00002oooo00D0003oool0
I_l00000I_l08Oooo`@00004oooo0P0002Lco`000`0003?o03?o000G<ol000<0003oooooool03ooo
o`030000oooooooo02Ooool010000?ooooooo`0002Soool300005oooo`00;Oooo`0406Ko0000oooo
00008oooo`0306Kooooooooo00;oool2000000<co`00000co`009S?o00030000<ol0<ol001Pco`00
0`000?ooooooo`0<oooo00@0003oooooool0000Yoooo00<0003oool00000:Oooo`030000oooooooo
01Koool002Woool406Ko0_ooo`80000Soooo00@0I_ooooooooooool40000:3?o00030000<ol0<ol0
01Tco`000`000?ooooooo`0<oooo0P0002_oool20000:Oooo`<0000Foooo000Soooo1P1Vob_oool0
101Vooooo`00000002`co`000`0003?o03?o000J<ol00P0007goool001koool506Ko<Oooo`0306Ko
0000<ol002dco`0200007C?o00<0001joooo000Ioooo1@1Voc?oool3000000<0I_lco`0co`00;C?o
00030000<ol0<ol001lco`060000M?ooo`005_ooo`<0I_lboooo1P0000<co`000`1Voc?o03?o000]
<ol000<0000co`0co`009C?o00<0001aoooo0011oooo2P0000Tco`000`1Voc?o03?o000]<ol000<0
000co`0co`00:3?o00X0001Woooo000@ooooo`00017oool001Koool00`000?ooooooo`08oooo00<0
003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?oo
o`030000oooooooo00Coool01Ol0VOooooooooooo`00000:oooo00<0003oooooool02?ooo`030000
oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool0
0`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08
oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003ooooo
ool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool05Oooo`00;?oo
o`030000oooooooo02Goool01Ol0VOooooooooooo`00000[oooo00<0003oooooool0:Oooo`030000
oooooooo02Woool00`000?ooooooo`0Yoooo00<0003oooooool05Oooo`00E?ooo`03o`2Ioooooooo
02goool00`000?ooooooo`2Ioooo001Doooo00?o09Woooooool0;Oooo`030000oooooooo09Woool0
05Coool00ol0VOooooooo`0]oooo0P0009[oool005Coool00ol0VOooooooo`0]oooo00<0003ooooo
ool0VOooo`00E?ooo`03o`2Ioooooooo02goool00`000?ooooooo`2Ioooo001Doooo00?o09Wooooo
ool0;Oooo`030000oooooooo09Woool005Coool00ol0VOooooooo`0]oooo0P0009[oool005Coool0
0ol0VOooooooo`0]oooo00<0003oooooool0VOooo`00E?ooo`03o`2Ioooooooo02goool00`000?oo
ooooo`2Ioooo001Doooo00?o09Woooooool0;Oooo`030000oooooooo09Woool005Coool00ol0VOoo
ooooo`0]oooo00<0003oooooool0VOooo`00E?ooo`03o`2Ioooooooo02goool20000V_ooo`00E?oo
o`03o`2Ioooooooo02goool00`000?ooooooo`2Ioooo001Doooo00?o09Woooooool0;Oooo`030000
oooooooo09Woool005Coool00ol0VOooooooo`0]oooo00<0003oooooool0VOooo`00E?ooo`03o`2I
oooooooo02goool20000V_ooo`00E?ooo`03o`2Ioooooooo02goool00`000?ooooooo`2Ioooo001D
oooo00?o09Woooooool0;Oooo`030000oooooooo09Woool005Coool00ol0VOooooooo`0Uoooo1@00
00?oool00`000?ooooooo`2Ioooo001Doooo00?o09Woooooool09oooo`030000oooooooo00?oool0
0`000?ooooooo`2Ioooo001Doooo00?o09Woooooool09oooo`030000oooooooo00?oool30000VOoo
o`00E?ooo`03o`2Ioooooooo02Ooool00`000?ooooooo`03oooo00<0003oooooool0VOooo`00E?oo
o`03o`2Ioooooooo02Ooool00`000?ooooooo`03oooo00<0003oooooool0VOooo`00E?ooo`03o`2I
oooooooo02Koool200001Oooo`030000oooooooo09Woool005Coool00ol0VOooooooo`0]oooo0P00
09[oool005Coool00ol0VOooooooo`0]oooo00<0003oooooool0VOooo`00E?ooo`03o`2Ioooooooo
02goool00`000?ooooooo`2Ioooo001Doooo00?o09Woooooool0;Oooo`030000oooooooo09Woool0
05Coool00ol0VOooooooo`0]oooo00<0003oooooool0VOooo`00E?ooo`03o`2Ioooooooo02goool2
0000V_ooo`00E?ooo`03o`2Ioooooooo02goool00`000?ooooooo`2Ioooo001Doooo00?o09Wooooo
ool0;Oooo`030000oooooooo09Woool005Coool00ol0VOooooooo`0]oooo00<0003oooooool0VOoo
o`00E?ooo`03o`2Ioooooooo02goool20000V_ooo`00E?ooo`03o`2Ioooooooo02goool00`000?oo
ooooo`2Ioooo001Doooo00?o09Woooooool0;Oooo`030000oooooooo09Woool005Coool00ol0VOoo
ooooo`0]oooo00<0003oooooool0VOooo`00E?ooo`03o`2Ioooooooo02goool00`000?ooooooo`2I
oooo001Doooo00?o09Woooooool0;Oooo`80002Joooo001Doooo00?o09Woooooool0;Oooo`030000
oooooooo09Woool005Coool00ol0VOooooooo`0Uoooo100000Coool00`000?ooooooo`2Ioooo001D
oooo00?o09Woooooool09Oooo`030000oooooooo00Goool00`000?ooooooo`2Ioooo001Doooo00?o
09Woooooool09_ooo`030000oooooooo00Coool30000VOooo`00E?ooo`03o`2Ioooooooo02Ooool0
0`000?ooooooo`03oooo00<0003oooooool0VOooo`00E?ooo`03o`2Ioooooooo02Goool010000?oo
ooooo`0000Coool00`000?ooooooo`2Ioooo001Doooo00?o09Woooooool09_ooo`800005oooo00<0
003oooooool0VOooo`00E?ooo`03o`2Ioooooooo02goool20000V_ooo`00E?ooo`03o`2Ioooooooo
02goool00`000?ooooooo`2Ioooo001Doooo00?o09Woooooool0;Oooo`030000oooooooo09Woool0
05Coool00ol0VOooooooo`0]oooo00<0003oooooool0VOooo`00E?ooo`03o`2Ioooooooo02goool0
0`000?ooooooo`2Ioooo001Doooo00?o09Woooooool0;Oooo`80002Joooo001Doooo00?o09Wooooo
ool0;Oooo`030000oooooooo09Woool005Coool00ol0VOooooooo`0]oooo00<0003oooooool0VOoo
o`00E?ooo`03o`2Ioooooooo02goool00`000?ooooooo`2Ioooo001Doooo00?o09Woooooool0;Ooo
o`80002Joooo001Doooo00?o09Woooooool0;Oooo`030000oooooooo09Woool005Coool00ol0VOoo
ooooo`0]oooo00<0003oooooool0VOooo`00E?ooo`03o`2Ioooooooo02goool00`000?ooooooo`2I
oooo001Doooo00?o09Woooooool0;Oooo`030000oooooooo09Woool005Coool00ol0VOooooooo`0]
oooo0P0009[oool005Coool00ol0VOooooooo`0]oooo00<0003oooooool0VOooo`00E?ooo`03o`2I
oooooooo02Koool200001Oooo`030000oooooooo09Woool005Coool00ol0VOooooooo`0Uoooo00@0
003oooooool00004oooo00<0003oooooool0VOooo`00E?ooo`03o`2Ioooooooo02Ooool00`000?oo
ooooo`03oooo0`0009Woool005Coool00ol0VOooooooo`0Xoooo00<0003oooooool00_ooo`030000
oooooooo09Woool005Coool00ol0VOooooooo`0Uoooo00@0003oooooool00004oooo00<0003ooooo
ool0VOooo`00E?ooo`03o`2Ioooooooo02Koool200001Oooo`030000oooooooo09Woool005Coool0
0ol0VOooooooo`0]oooo00<0003oooooool0VOooo`00E?ooo`03o`2Ioooooooo02goool20000V_oo
o`00E?ooo`03o`2Ioooooooo02goool00`000?ooooooo`2Ioooo001Doooo00?o09Woooooool0;Ooo
o`030000oooooooo09Woool005Coool00ol0VOooooooo`0]oooo00<0003oooooool0VOooo`00E?oo
o`03o`2Ioooooooo02goool20000V_ooo`00E?ooo`03o`2Ioooooooo02goool00`000?ooooooo`2I
oooo001Doooo00?o09Woooooool0;Oooo`030000oooooooo09Woool005Coool00ol0VOooooooo`0]
oooo00<0003oooooool0VOooo`00E?ooo`03o`2Ioooooooo02goool00`000?ooooooo`2Ioooo001D
oooo00?o09Woooooool0;Oooo`80002Joooo001Doooo00?o09Woooooool0;Oooo`030000oooooooo
09Woool005Coool00ol0VOooooooo`0]oooo00<0003oooooool0VOooo`00E?ooo`03o`2Ioooooooo
02goool00`000?ooooooo`2Ioooo001Doooo00?o09Woooooool0;Oooo`80002Joooo001Doooo00?o
09Woooooool0;Oooo`030000oooooooo09Woool005Coool00ol0VOooooooo`0]oooo00<0003ooooo
ool0VOooo`00E?ooo`03o`2Ioooooooo02Ooool300000oooo`030000oooooooo09Woool005Coool0
0ol0VOooooooo`0Xoooo00<0003oooooool00_ooo`030000oooooooo09Woool005Coool00ol0VOoo
ooooo`0Uoooo1@0000?oool30000VOooo`00O?ooo`040000oooooooo0000X?ooo`00OOooo`030000
oooo00000:3oool007koool20000X?ooo`00ooooob7oool00?oooolQoooo001ioooo00<0003ooooo
ool0:?ooo`030000oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07ooo
o`030000oooooooo07Soool007Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0=
oooo0P0000Coool200000oooo`@00003oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooo
oooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003ooooo
ool00008oooo00<0003oooooool01?ooo`030000oooooooo07Soool007Ooool00`000?ooooooo`02
oooo00<0003oooooool05Oooo`030000oooooooo00Soool00`000?ooooooo`04oooo00<0003ooooo
ool0Moooo`00N?ooo`030000oooooooo00D0000Eoooo00<0003oooooool02?ooo`030000oooooooo
00;oool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000005Oooo`040000oooooooo
00002?ooo`040000oooooooo00000oooo`030000oooooooo07Soool007Woool00`000?ooooooo`0G
oooo0P0000[oool200000oooo`030000oooooooo07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-6.03535, \
-3.20105, 0.0455524, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-6.03535, -3.20105, 0.0455524, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.27193 .26487 L
.27731 .26487 L
.28025 .26487 L
.2817 .26487 L
.28302 .26487 L
s
.28302 .26487 m
.28351 .61803 L
s
0 .4 1 r
.02381 .25666 m
.04262 .25467 L
.06244 .25204 L
.08255 .24869 L
.10458 .24401 L
.12415 .23872 L
.14509 .23159 L
.16639 .22234 L
.18653 .21128 L
.22495 .18181 L
.24479 .16099 L
.25492 .14855 L
.26581 .13364 L
.27104 .12589 L
.27602 .11816 L
.28048 .1109 L
.2817 .10885 L
.283 .10665 L
.28423 .26487 L
.28535 .26487 L
.30365 .26487 L
.34372 .26487 L
.38227 .26487 L
.42327 .26487 L
.46276 .26487 L
.50073 .26487 L
.54115 .26487 L
.58006 .26487 L
.62142 .26487 L
.66127 .26487 L
.6996 .26487 L
.74038 .26487 L
.77965 .26487 L
.8174 .26487 L
.8576 .26487 L
.89629 .26487 L
.93743 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001moooo0P000:7oool007coool010000?ooooooo`000:3oool007koool00`000?oo
ooooo`03oooo0`0009Woool007Koool400001Oooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo001loooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007coool200001_ooo`<0002I
oooo001foooo1P000004<ol00000000000001?ooo`030000oooooooo09Woool007Soool01@0003?o
03?o03?o00000002<ol00P0000?oool00`000?ooooooo`2Ioooo001goooo00<0000co`0co`000c?o
00800002<ol00P000003oooo0000oooo09[oool007Koool00`0003?o03?o000:<ol00P0009_oool0
05Soool00`1Vooooooooo`0Joooo00<0000co`0co`0033?o0080002Joooo001Goooo0P1Voa_oool0
0`0003?o03?o000=<ol000<0003oooooool0VOooo`00E_ooo`0306Kooooo06Ko01[oool00`0003?o
03?o000><ol00P0009[oool005Koool00`1Vooooo`1Vo`0Joooo00<0000co`0co`003S?o00030000
<ol0000009Woool005Goool0101Vooooooooo`1VoaWoool00`0003?o03?o000?<ol00P000003<ol0
0000oooo09Ooool005Goool0101Vooooooooo`1VoaWoool00`0003?o03?o000?<ol000@0000co`0c
o`00002Hoooo001Doooo00D0I_ooooooooooool0I_l06?ooo`030000<ol0<ol0010co`001@0003?o
03?o03?o0000002Goooo001Doooo00D0I_ooooooooooool0I_l06?ooo`030000<ol0<ol0010co`00
0`0003?o03?o0002<ol000<0003oooooool0U?ooo`00Doooo`0306Kooooooooo00;oool00`1Voooo
ooooo`0Eoooo00<0000co`0co`004C?o00030000<ol0<ol0008co`000`000?ooooooo`2Doooo001B
oooo00<0I_ooooooool00oooo`0306Kooooooooo01Coool00`0003?o03?o000B<ol00P0000@co`00
0`000?ooooooo`2Coooo001Boooo00<0I_ooooooool00oooo`0306Kooooooooo01?oool00`0003?o
03?o000C<ol000<0000co`0co`0013?o00030000oooooooo09;oool0057oool00`1Vooooooooo`04
oooo00<0I_ooooooool04oooo`030000<ol0<ol001<co`000`0003?o03?o0004<ol000<0003ooooo
ool0T_ooo`00D?ooo`0306Kooooooooo00Goool00`1Vooooooooo`0Boooo00<0000co`0co`0053?o
00030000<ol0<ol000Dco`000`000?ooooooo`2Aoooo001?oooo00<0I_ooooooool01_ooo`0306Ko
oooooooo017oool00`0003?o03?o000E<ol00P0000Lco`000`000?ooooooo`2@oooo001>oooo00<0
I_ooooooool01oooo`0306Kooooooooo013oool00`0003?o03?o000F<ol000<0000co`0co`001S?o
00030000oooooooo093oool004goool00`1Vooooooooo`08oooo00<0I_ooooooool04?ooo`030000
<ol0<ol001Hco`000`0003?o03?o0007<ol000<0003oooooool0Soooo`00C?ooo`0306Kooooooooo
00Woool00`1Vooooooooo`0?oooo00<0000co`0co`003c?o00D00003<ol000<0000co`0co`0023?o
00030000oooooooo08koool004_oool00`1Vooooooooo`0:oooo00<0I_ooooooool03_ooo`030000
<ol0<ol0018co`000`0003?o03?o0003<ol000<0000co`0co`0023?o00030000oooooooo08koool0
04[oool00`1Vooooooooo`0;oooo00<0I_ooooooool03Oooo`030000<ol0<ol001<co`000`0003?o
03?o0003<ol00`0000Tco`000`000?ooooooo`2=oooo0019oooo00<0I_ooooooool03?ooo`0306Ko
oooooooo00goool00`0003?o03?o000;<ol0100000@co`000`0003?o03?o0003<ol000<0000co`0c
o`002S?o00030000oooooooo08coool004Soool00`1Vooooooooo`0=oooo00<0I_ooooooool03?oo
o`030000<ol0<ol001@co`000`0003?o03?o0003<ol000<0000co`0co`002c?o00030000oooooooo
08_oool004Koool206Ko4?ooo`0306Kooooooooo00_oool00`0003?o03?o000D<ol00P0000Dco`00
0`0003?o03?o000;<ol000<0003oooooool0Roooo`00AOooo`0306Kooooooooo013oool00`1Voooo
ooooo`0;oooo00<0000co`0co`006c?o0080000=<ol000<0003oooooool0R_ooo`00A?ooo`0306Ko
oooooooo017oool00`1Vooooooooo`0:oooo00<0000co`0co`0073?o00030000<ol0<ol000dco`00
0`000?ooooooo`29oooo0013oooo00<0I_ooooooool04_ooo`0306Kooooooooo00Woool00`0003?o
03?o000M<ol000<0000co`0co`003S?o00030000oooooooo08Soool0047oool206Ko5Oooo`0306Ko
oooooooo00Soool00`0003?o03?o000N<ol000<0000co`0co`003c?o00030000oooooooo08Ooool0
043oool00`1Vooooooooo`0Eoooo00<0I_ooooooool02?ooo`030000<ol0<ol001hco`000`0003?o
03?o000@<ol000<0003oooooool0Q_ooo`00?_ooo`80I_lHoooo00<0I_ooooooool01oooo`030000
<ol0<ol001lco`0200004S?o00030000oooooooo08Goool003coool206Ko6_ooo`0306Kooooooooo
00Koool00`0003?o03?o000P<ol000<0000co`0co`004S?o00030000oooooooo08Coool002ooool3
00002?ooo`80I_lLoooo00<0I_l0000000000P0000;oool200008c?o00030000<ol0<ol001<co`00
0`000?ooooooo`0Aoooo100002[oool300009oooo`<0000Goooo000`oooo00<0003oooooool01Ooo
o`80I_lNoooo00<0I_l0003oool00oooo`030000<ol0<ol002<co`000`0003?o03?o000D<ol000<0
003oooooool04?ooo`030000oooooooo02coool00`000?ooooooo`0Voooo00@0003oooooool0000F
oooo000]oooo1@0000Coool206Ko8?ooo`0306Kooooo000000;oool00`0003?o03?o000T<ol00P00
01Hco`0200004Oooo`030000oooooooo02Soool500009oooo`040000oooooooo00005_ooo`009ooo
o`@00002oooo00@0003oooooool00003oooo0P1Voagoool4000000Coool0I_ooooooool200009c?o
00030000<ol0<ol001Lco`000`000?ooooooo`0?oooo00<0003oooooool09oooo`040000oooooooo
0000:?ooo`<0000Goooo000^oooo00@0003oool0003oool206Ko9?ooo`0506Ko00000000<ol00000
02Lco`000`0003?o03?o000H<ol000<0003oooooool03?ooo`040000oooooooo0000:Oooo`030000
oooo000002Woool00`000?ooooooo`0Foooo000^oooo00@0I_l000000000I_lVoooo00@0I_l00000
0000000X<ol000<0000co`0co`006C?o00030000oooooooo00coool20000:oooo`80000Yoooo0`00
01Koool002Woool506Ko:?ooo`8000000`1Voc?o03?o000Y<ol000<0000co`0co`006S?o0080001m
oooo000Soooo1P1Vob_oool200000S?o000306Ko<ol0<ol002Tco`0200007C?o00<0001joooo000N
oooo1@1Vobkoool3000013?o000306Ko<ol0<ol002Tco`000`0003?o03?o000O<ol01P0007Coool0
01Koool806Ko;Oooo`H00007<ol000<0I_lco`0co`00:C?o00030000<ol0<ol002Dco`030000LOoo
o`00@Oooo`X0000=<ol000<0I_lco`0co`00:C?o00030000<ol0<ol002Pco`0:0000Ioooo`004?oo
ool0000Aoooo000Foooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08
oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003ooooo
ool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000
oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool0
0`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08
oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003ooooo
ool02?ooo`030000oooooooo01Goool002coool00`000?ooooooo`0Yoooo00<0003oooooool0:Ooo
o`030000oooooooo02Woool00`000?ooooooo`0Yoooo00<0003oooooool0:Oooo`030000oooooooo
01Goool005Soool00ol0VOooooooo`0Yoooo00<0003oooooool0VOooo`00F?ooo`03o`2Ioooooooo
02Woool00`000?ooooooo`2Ioooo001Hoooo00?o09Woooooool0:Oooo`80002Joooo001Hoooo00?o
09Woooooool0:Oooo`030000oooooooo09Woool005Soool00ol0VOooooooo`0Yoooo00<0003ooooo
ool0VOooo`00F?ooo`03o`2Ioooooooo02Woool00`000?ooooooo`2Ioooo001Hoooo00?o09Wooooo
ool0:Oooo`80002Joooo001Hoooo00?o09Woooooool0:Oooo`030000oooooooo09Woool005Soool0
0ol0VOooooooo`0Yoooo00<0003oooooool0VOooo`00F?ooo`03o`2Ioooooooo02Woool00`000?oo
ooooo`2Ioooo001Hoooo00?o09Woooooool0:Oooo`030000oooooooo09Woool005Soool00ol0VOoo
ooooo`0Yoooo0P0009[oool005Soool00ol0VOooooooo`0Yoooo00<0003oooooool0VOooo`00F?oo
o`03o`2Ioooooooo02Woool00`000?ooooooo`2Ioooo001Hoooo00?o09Woooooool0:Oooo`030000
oooooooo09Woool005Soool00ol0VOooooooo`0Yoooo0P0009[oool005Soool00ol0VOooooooo`0Y
oooo00<0003oooooool0VOooo`00F?ooo`03o`2Ioooooooo02Woool00`000?ooooooo`2Ioooo001H
oooo00?o09Woooooool08Oooo`D00003oooo00<0003oooooool0VOooo`00F?ooo`03o`2Ioooooooo
02?oool00`000?ooooooo`03oooo00<0003oooooool0VOooo`00F?ooo`03o`2Ioooooooo02?oool0
0`000?ooooooo`03oooo0`0009Woool005Soool00ol0VOooooooo`0Soooo00<0003oooooool00ooo
o`030000oooooooo09Woool005Soool00ol0VOooooooo`0Soooo00<0003oooooool00oooo`030000
oooooooo09Woool005Soool00ol0VOooooooo`0Roooo0P0000Goool00`000?ooooooo`2Ioooo001H
oooo00?o09Woooooool0:Oooo`80002Joooo001Hoooo00?o09Woooooool0:Oooo`030000oooooooo
09Woool005Soool00ol0VOooooooo`0Yoooo00<0003oooooool0VOooo`00F?ooo`03o`2Ioooooooo
02Woool00`000?ooooooo`2Ioooo001Hoooo00?o09Woooooool0:Oooo`030000oooooooo09Woool0
05Soool00ol0VOooooooo`0Yoooo0P0009[oool005Soool00ol0VOooooooo`0Yoooo00<0003ooooo
ool0VOooo`00F?ooo`03o`2Ioooooooo02Woool00`000?ooooooo`2Ioooo001Hoooo00?o09Wooooo
ool0:Oooo`030000oooooooo09Woool005Soool00ol0VOooooooo`0Yoooo0P0009[oool005Soool0
0ol0VOooooooo`0Yoooo00<0003oooooool0VOooo`00F?ooo`03o`2Ioooooooo02Woool00`000?oo
ooooo`2Ioooo001Hoooo00?o09Woooooool0:Oooo`030000oooooooo09Woool005Soool00ol0VOoo
ooooo`0Yoooo00<0003oooooool0VOooo`00F?ooo`03o`2Ioooooooo02Woool20000V_ooo`00F?oo
o`03o`2Ioooooooo02Woool00`000?ooooooo`2Ioooo001Hoooo00?o09Woooooool08Oooo`@00004
oooo00<0003oooooool0VOooo`00F?ooo`03o`2Ioooooooo027oool00`000?ooooooo`05oooo00<0
003oooooool0VOooo`00F?ooo`03o`2Ioooooooo02;oool00`000?ooooooo`04oooo0`0009Woool0
05Soool00ol0VOooooooo`0Soooo00<0003oooooool00oooo`030000oooooooo09Woool005Soool0
0ol0VOooooooo`0Qoooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00F?ooo`03o`2I
oooooooo02;oool200001Oooo`030000oooooooo09Woool005Soool00ol0VOooooooo`0Yoooo0P00
09[oool005Soool00ol0VOooooooo`0Yoooo00<0003oooooool0VOooo`00F?ooo`03o`2Ioooooooo
02Woool00`000?ooooooo`2Ioooo001Hoooo00?o09Woooooool0:Oooo`030000oooooooo09Woool0
05Soool00ol0VOooooooo`0Yoooo00<0003oooooool0VOooo`00F?ooo`03o`2Ioooooooo02Woool2
0000V_ooo`00F?ooo`03o`2Ioooooooo02Woool00`000?ooooooo`2Ioooo001Hoooo00?o09Wooooo
ool0:Oooo`030000oooooooo09Woool005Soool00ol0VOooooooo`0Yoooo00<0003oooooool0VOoo
o`00F?ooo`03o`2Ioooooooo02Woool20000V_ooo`00F?ooo`03o`2Ioooooooo02Woool00`000?oo
ooooo`2Ioooo001Hoooo00?o09Woooooool0:Oooo`030000oooooooo09Woool005Soool00ol0VOoo
ooooo`0Yoooo00<0003oooooool0VOooo`00F?ooo`03o`2Ioooooooo02Woool00`000?ooooooo`2I
oooo001Hoooo00?o09Woooooool0:Oooo`80002Joooo001Hoooo00?o09Woooooool0:Oooo`030000
oooooooo09Woool005Soool00ol0VOooooooo`0Roooo0P0000Goool00`000?ooooooo`2Ioooo001H
oooo00?o09Woooooool08Oooo`040000oooooooo00001?ooo`030000oooooooo09Woool005Soool0
0ol0VOooooooo`0Soooo00<0003oooooool00oooo`<0002Ioooo001Hoooo00?o09Woooooool09?oo
o`030000oooooooo00;oool00`000?ooooooo`2Ioooo001Hoooo00?o09Woooooool08Oooo`040000
oooooooo00001?ooo`030000oooooooo09Woool005Soool00ol0VOooooooo`0Roooo0P0000Goool0
0`000?ooooooo`2Ioooo001Hoooo00?o09Woooooool0:Oooo`030000oooooooo09Woool005Soool0
0ol0VOooooooo`0Yoooo0P0009[oool005Soool00ol0VOooooooo`0Yoooo00<0003oooooool0VOoo
o`00F?ooo`03o`2Ioooooooo02Woool00`000?ooooooo`2Ioooo001Hoooo00?o09Woooooool0:Ooo
o`030000oooooooo09Woool005Soool00ol0VOooooooo`0Yoooo0P0009[oool005Soool00ol0VOoo
ooooo`0Yoooo00<0003oooooool0VOooo`00F?ooo`03o`2Ioooooooo02Woool00`000?ooooooo`2I
oooo001Hoooo00?o09Woooooool0:Oooo`030000oooooooo09Woool005Soool00ol0VOooooooo`0Y
oooo00<0003oooooool0VOooo`00F?ooo`03o`2Ioooooooo02Woool20000V_ooo`00F?ooo`03o`2I
oooooooo02Woool00`000?ooooooo`2Ioooo001Hoooo00?o09Woooooool0:Oooo`030000oooooooo
09Woool005Soool00ol0VOooooooo`0Yoooo00<0003oooooool0VOooo`00F?ooo`03o`2Ioooooooo
02Woool20000V_ooo`00F?ooo`03o`2Ioooooooo02Woool00`000?ooooooo`2Ioooo001Hoooo00?o
09Woooooool0:Oooo`030000oooooooo09Woool005Soool00ol0VOooooooo`0Soooo0`0000?oool0
0`000?ooooooo`2Ioooo001Hoooo00?o09Woooooool09?ooo`030000oooooooo00;oool00`000?oo
ooooo`2Ioooo001Hoooo00?o09Woooooool08Oooo`D00003oooo0`0009Woool007coool010000?oo
ooooo`000:3oool007goool00`000?ooo`00002Poooo001noooo0P000:3oool00?oooolQoooo003o
oooo8Oooo`00O?ooo`030000oooooooo02;oool00`000?ooooooo`1loooo001koooo00<0003ooooo
ool02?ooo`030000oooooooo01Woool00`000?ooooooo`1koooo001koooo00<0003oooooool00_oo
o`800004oooo00<0003oooooool03Oooo`800004oooo0P0000Coool00`000?ooooooo`1koooo001k
oooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`04oooo1000
00?oool010000?ooooooo`0000Woool00`000?ooooooo`1koooo001joooo00<0003oooooool00_oo
o`030000oooooooo01Goool00`000?ooooooo`09oooo00<0003oooooool0N_ooo`00Noooo`030000
oooooooo00D0000Eoooo00<0003oooooool01oooo`030000oooooooo07_oool007_oool01@000?oo
ooooooooo`00000Eoooo00@0003oooooool00009oooo00<0003oooooool0Noooo`00O?ooo`030000
oooooooo01Ooool200002Oooo`030000oooooooo07coool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-6.03535, \
-3.20105, 0.0455524, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-6.03535, -3.20105, 0.0455524, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.27193 .26487 L
.28302 .26487 L
.2881 .26487 L
.29349 .26487 L
.29809 .26487 L
.29935 .26487 L
.30004 .26487 L
.3007 .26487 L
s
.3007 .26487 m
.30122 .61803 L
s
0 .4 1 r
.02381 .25816 m
.04262 .25653 L
.06244 .25438 L
.08255 .25164 L
.10458 .24781 L
.12415 .24349 L
.14509 .23765 L
.16639 .23009 L
.18653 .22105 L
.22495 .19695 L
.24479 .17993 L
.26581 .15756 L
.27523 .14592 L
.28535 .1322 L
.29025 .12509 L
.29491 .11805 L
.29693 .1149 L
.29909 .11149 L
.30033 .1095 L
.30145 .26487 L
.30258 .26487 L
.30365 .26487 L
.3422 .26487 L
.3832 .26487 L
.42269 .26487 L
.46066 .26487 L
.50109 .26487 L
.54 .26487 L
.58136 .26487 L
.6212 .26487 L
.65953 .26487 L
.70031 .26487 L
.73958 .26487 L
.77733 .26487 L
.81753 .26487 L
.85622 .26487 L
.89736 .26487 L
.93699 .26487 L
.97509 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001moooo0P000:7oool007coool010000?ooooooo`000:3oool007koool00`000?oo
ooooo`03oooo0`0009Woool007Koool400001Oooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo001loooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007coool200001_ooo`<0002I
oooo001foooo1P000004<ol00000000000001?ooo`030000oooooooo09Woool007Soool01@0003?o
03?o03?o00000002<ol00P0000?oool00`000?ooooooo`2Ioooo001goooo00<0000co`0co`000c?o
00800002<ol00P000003oooo0000oooo09[oool007Koool00`0003?o03?o000:<ol00P0009_oool0
07Goool00`0003?o03?o000<<ol00P0009[oool005coool00`1Vooooooooo`0Eoooo00<0000co`0c
o`003C?o00030000oooooooo09Woool005_oool206Ko5_ooo`030000<ol0<ol000hco`020000V_oo
o`00Foooo`80I_lFoooo00<0000co`0co`003S?o00030000<ol0000009Woool005[oool00`1Voooo
o`1Vo`0Eoooo00<0000co`0co`003c?o008000000c?o00000?ooo`2Goooo001Joooo00<0I_ooool0
I_l05Oooo`030000<ol0<ol000lco`00100003?o03?o000009Soool005Woool0101Vooooooooo`1V
oaCoool00`0003?o03?o000@<ol000D0000co`0co`0co`000000Uoooo`00FOooo`0406Kooooooooo
06Ko5?ooo`030000<ol0<ol0010co`000`0003?o03?o0002<ol000<0003oooooool0U?ooo`00F?oo
o`0506Kooooooooooooo06Ko01?oool00`0003?o03?o000A<ol000<0000co`0co`000S?o00030000
oooooooo09Coool005Ooool00`1Vooooooooo`02oooo00<0I_ooooooool04?ooo`030000<ol0<ol0
018co`02000013?o00030000oooooooo09?oool005Koool00`1Vooooooooo`03oooo00<0I_oooooo
ool03oooo`030000<ol0<ol001<co`000`0003?o03?o0004<ol000<0003oooooool0T_ooo`00EOoo
o`0306Kooooooooo00Coool00`1Vooooooooo`0?oooo00<0000co`0co`004c?o00030000<ol0<ol0
00@co`000`000?ooooooo`2Boooo001Eoooo00<0I_ooooooool01?ooo`0306Kooooooooo00koool0
0`0003?o03?o000D<ol000<0000co`0co`001C?o00030000oooooooo097oool005Coool00`1Voooo
ooooo`05oooo00<0I_ooooooool03Oooo`030000<ol0<ol001Dco`0200001c?o00030000oooooooo
093oool005?oool00`1Vooooooooo`06oooo00<0I_ooooooool03?ooo`030000<ol0<ol001Hco`00
0`0003?o03?o0006<ol000<0003oooooool0T?ooo`00D_ooo`0306Kooooooooo00Ooool00`1Voooo
ooooo`0<oooo00<0000co`0co`005S?o00030000<ol0<ol000Lco`000`000?ooooooo`2?oooo001A
oooo00<0I_ooooooool02?ooo`0306Kooooooooo00_oool00`0003?o03?o000?<ol01@0000<co`00
0`0003?o03?o0008<ol000<0003oooooool0S_ooo`00D?ooo`0306Kooooooooo00Woool00`1Voooo
ooooo`0:oooo00<0000co`0co`004S?o00030000<ol0<ol000<co`000`0003?o03?o0008<ol000<0
003oooooool0S_ooo`00Coooo`0306Kooooooooo00[oool00`1Vooooooooo`09oooo00<0000co`0c
o`004c?o00030000<ol0<ol000<co`0300002C?o00030000oooooooo08goool004koool00`1Voooo
ooooo`0;oooo00<0I_ooooooool02Oooo`030000<ol0<ol000/co`04000013?o00030000<ol0<ol0
00<co`000`0003?o03?o000:<ol000<0003oooooool0S?ooo`00COooo`0306Kooooooooo00coool0
0`1Vooooooooo`08oooo00<0000co`0co`0053?o00030000<ol0<ol000<co`000`0003?o03?o000;
<ol000<0003oooooool0Roooo`00Boooo`80I_l@oooo00<0I_ooooooool01_ooo`030000<ol0<ol0
01@co`0200001C?o00030000<ol0<ol000/co`000`000?ooooooo`2;oooo001:oooo00<0I_oooooo
ool04?ooo`0306Kooooooooo00Koool00`0003?o03?o000K<ol00P0000dco`000`000?ooooooo`2:
oooo0019oooo00<0I_ooooooool04Oooo`0306Kooooooooo00Goool00`0003?o03?o000L<ol000<0
000co`0co`003C?o00030000oooooooo08Woool004Ooool206Ko5?ooo`0306Kooooooooo00Coool0
0`0003?o03?o000M<ol000<0000co`0co`003S?o00030000oooooooo08Soool004Goool206Ko5_oo
o`0306Kooooooooo00?oool00`0003?o03?o000N<ol000<0000co`0co`003c?o00030000oooooooo
08Ooool004Coool00`1Vooooooooo`0Foooo00<0I_ooooooool00oooo`030000<ol0<ol001hco`00
0`0003?o03?o000@<ol000<0003oooooool0Q_ooo`00@_ooo`80I_lIoooo00<0I_ooooooool00_oo
o`030000<ol0<ol001lco`0200004S?o00030000oooooooo08Goool0043oool206Ko6oooo`0506Ko
oooooooooooo0000028co`000`0003?o03?o000B<ol000<0003oooooool0Q?ooo`00;oooo`<0000<
oooo0P1VoaWoool4000000@0I_ooool00000000S<ol000<0000co`0co`004c?o00030000oooooooo
017oool40000:_ooo`<0000Woooo0`0001Ooool0033oool00`000?ooooooo`09oooo0P1Voa_oool0
1P000?ooooooooooo`1Vo`0002Dco`000`0003?o03?o000D<ol000<0003oooooool04?ooo`030000
oooooooo02coool00`000?ooooooo`0Voooo00@0003oooooool0000Foooo000]oooo1@0000Ooool3
06Ko7_ooo`040000oooooooo06Ko9S?o0080000F<ol00P00017oool00`000?ooooooo`0Xoooo1@00
02Ooool010000?ooooooo`0001Koool002Ooool400000_ooo`040000oooooooo00001_ooo`80I_lJ
oooo100000Coool2000000<0I_lco`0co`0093?o00030000<ol0<ol001Lco`000`000?ooooooo`0?
oooo00<0003oooooool09oooo`040000oooooooo0000:?ooo`<0000Goooo000^oooo00<0003oool0
00000oooo`<0I_lRoooo0P000003<ol0000006Ko02Hco`000`0003?o03?o000H<ol000<0003ooooo
ool03?ooo`040000oooooooo0000:Oooo`030000oooo000002Woool00`000?ooooooo`0Foooo000_
oooo0P000003oooo06Ko06Ko02Coool4000000<co`00I_lco`009C?o00030000<ol0<ol001Tco`00
0`000?ooooooo`0<oooo0P0002_oool20000:Oooo`<0000Foooo000^oooo101VobCoool200001C?o
000306Ko<ol0<ol002@co`000`0003?o03?o000J<ol00P0007goool002Woool506Ko9_ooo`800007
<ol000<0I_lco`0co`0093?o0080000M<ol00`0007[oool002?oool606Ko:?ooo`<00009<ol000<0
I_lco`0co`0093?o00030000<ol0<ol001lco`060000M?ooo`006Oooo`X0I_lXoooo1P0000`co`00
0`1Voc?o03?o000T<ol000<0000co`0co`009C?o00<0001aoooo000Foooo0`1VobSoool:00004S?o
000306Ko<ol0<ol002@co`000`0003?o03?o000X<ol02P0006Ooool0013ooooo00004Oooo`005_oo
o`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo
00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`050000ooooooooooooo`2I00Koool0
0`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08
oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003ooooo
ool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000
oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool0
0`000?ooooooo`0Eoooo000/oooo00<0003oooooool0:Oooo`050000ooooooooooooo`2I02Ooool0
0`000?ooooooo`0Yoooo00<0003oooooool0:Oooo`030000oooooooo02Woool00`000?ooooooo`0E
oooo001Loooo00?o09Woooooool09Oooo`030000oooooooo09Woool005coool00ol0VOooooooo`0U
oooo00<0003oooooool0VOooo`00G?ooo`03o`2Ioooooooo02Goool20000V_ooo`00G?ooo`03o`2I
oooooooo02Goool00`000?ooooooo`2Ioooo001Loooo00?o09Woooooool09Oooo`030000oooooooo
09Woool005coool00ol0VOooooooo`0Uoooo00<0003oooooool0VOooo`00G?ooo`03o`2Ioooooooo
02Goool20000V_ooo`00G?ooo`03o`2Ioooooooo02Goool00`000?ooooooo`2Ioooo001Loooo00?o
09Woooooool09Oooo`030000oooooooo09Woool005coool00ol0VOooooooo`0Uoooo00<0003ooooo
ool0VOooo`00G?ooo`03o`2Ioooooooo02Goool00`000?ooooooo`2Ioooo001Loooo00?o09Wooooo
ool09Oooo`80002Joooo001Loooo00?o09Woooooool09Oooo`030000oooooooo09Woool005coool0
0ol0VOooooooo`0Uoooo00<0003oooooool0VOooo`00G?ooo`03o`2Ioooooooo02Goool00`000?oo
ooooo`2Ioooo001Loooo00?o09Woooooool09Oooo`80002Joooo001Loooo00?o09Woooooool09Ooo
o`030000oooooooo09Woool005coool00ol0VOooooooo`0Uoooo00<0003oooooool0VOooo`00G?oo
o`03o`2Ioooooooo01goool500000oooo`030000oooooooo09Woool005coool00ol0VOooooooo`0O
oooo00<0003oooooool00oooo`030000oooooooo09Woool005coool00ol0VOooooooo`0Ooooo00<0
003oooooool00oooo`<0002Ioooo001Loooo00?o09Woooooool07oooo`030000oooooooo00?oool0
0`000?ooooooo`2Ioooo001Loooo00?o09Woooooool07oooo`030000oooooooo00?oool00`000?oo
ooooo`2Ioooo001Loooo00?o09Woooooool07_ooo`800005oooo00<0003oooooool0VOooo`00G?oo
o`03o`2Ioooooooo02Goool20000V_ooo`00G?ooo`03o`2Ioooooooo02Goool00`000?ooooooo`2I
oooo001Loooo00?o09Woooooool09Oooo`030000oooooooo09Woool005coool00ol0VOooooooo`0U
oooo00<0003oooooool0VOooo`00G?ooo`03o`2Ioooooooo02Goool00`000?ooooooo`2Ioooo001L
oooo00?o09Woooooool09Oooo`80002Joooo001Loooo00?o09Woooooool09Oooo`030000oooooooo
09Woool005coool00ol0VOooooooo`0Uoooo00<0003oooooool0VOooo`00G?ooo`03o`2Ioooooooo
02Goool00`000?ooooooo`2Ioooo001Loooo00?o09Woooooool09Oooo`80002Joooo001Loooo00?o
09Woooooool09Oooo`030000oooooooo09Woool005coool00ol0VOooooooo`0Uoooo00<0003ooooo
ool0VOooo`00G?ooo`03o`2Ioooooooo02Goool00`000?ooooooo`2Ioooo001Loooo00?o09Wooooo
ool09Oooo`030000oooooooo09Woool005coool00ol0VOooooooo`0Uoooo0P0009[oool005coool0
0ol0VOooooooo`0Uoooo00<0003oooooool0VOooo`00G?ooo`03o`2Ioooooooo01goool400001?oo
o`030000oooooooo09Woool005coool00ol0VOooooooo`0Moooo00<0003oooooool01Oooo`030000
oooooooo09Woool005coool00ol0VOooooooo`0Noooo00<0003oooooool01?ooo`<0002Ioooo001M
oooo00?o09Woooooool07_ooo`030000oooooooo00?oool00`000?ooooooo`2Ioooo001Moooo00?o
09Woooooool07?ooo`040000oooooooo00001?ooo`030000oooooooo09Woool005goool00ol0VOoo
ooooo`0Moooo0P0000Goool00`000?ooooooo`2Ioooo001Moooo00?o09Woooooool09?ooo`80002J
oooo001Moooo00?o09Woooooool09?ooo`030000oooooooo09Woool005goool00ol0VOooooooo`0T
oooo00<0003oooooool0VOooo`00GOooo`03o`2Ioooooooo02Coool00`000?ooooooo`2Ioooo001M
oooo00?o09Woooooool09?ooo`030000oooooooo09Woool005goool00ol0VOooooooo`0Toooo0P00
09[oool005goool00ol0VOooooooo`0Toooo00<0003oooooool0VOooo`00GOooo`03o`2Ioooooooo
02Coool00`000?ooooooo`2Ioooo001Moooo00?o09Woooooool09?ooo`030000oooooooo09Woool0
05goool00ol0VOooooooo`0Toooo0P0009[oool005goool00ol0VOooooooo`0Toooo00<0003ooooo
ool0VOooo`00GOooo`03o`2Ioooooooo02Coool00`000?ooooooo`2Ioooo001Moooo00?o09Wooooo
ool09?ooo`030000oooooooo09Woool005goool00ol0VOooooooo`0Toooo00<0003oooooool0VOoo
o`00GOooo`03o`2Ioooooooo02Coool20000V_ooo`00GOooo`03o`2Ioooooooo02Coool00`000?oo
ooooo`2Ioooo001Moooo00?o09Woooooool07Oooo`800005oooo00<0003oooooool0VOooo`00GOoo
o`03o`2Ioooooooo01coool010000?ooooooo`0000Coool00`000?ooooooo`2Ioooo001Moooo00?o
09Woooooool07_ooo`030000oooooooo00?oool30000VOooo`00GOooo`03o`2Ioooooooo01ooool0
0`000?ooooooo`02oooo00<0003oooooool0VOooo`00GOooo`03o`2Ioooooooo01coool010000?oo
ooooo`0000Coool00`000?ooooooo`2Ioooo001Moooo00?o09Woooooool07Oooo`800005oooo00<0
003oooooool0VOooo`00GOooo`03o`2Ioooooooo02Coool00`000?ooooooo`2Ioooo001Moooo00?o
09Woooooool09?ooo`80002Joooo001Moooo00?o09Woooooool09?ooo`030000oooooooo09Woool0
05goool00ol0VOooooooo`0Toooo00<0003oooooool0VOooo`00GOooo`03o`2Ioooooooo02Coool0
0`000?ooooooo`2Ioooo001Moooo00?o09Woooooool09?ooo`80002Joooo001Moooo00?o09Wooooo
ool09?ooo`030000oooooooo09Woool005goool00ol0VOooooooo`0Toooo00<0003oooooool0VOoo
o`00GOooo`03o`2Ioooooooo02Coool00`000?ooooooo`2Ioooo001Moooo00?o09Woooooool09?oo
o`030000oooooooo09Woool005goool00ol0VOooooooo`0Toooo0P0009[oool005goool00ol0VOoo
ooooo`0Toooo00<0003oooooool0VOooo`00GOooo`03o`2Ioooooooo02Coool00`000?ooooooo`2I
oooo001Moooo00?o09Woooooool09?ooo`030000oooooooo09Woool005goool00ol0VOooooooo`0T
oooo0P0009[oool005goool00ol0VOooooooo`0Toooo00<0003oooooool0VOooo`00GOooo`03o`2I
oooooooo02Coool00`000?ooooooo`2Ioooo001Moooo00?o09Woooooool07_ooo`<00003oooo00<0
003oooooool0VOooo`00GOooo`03o`2Ioooooooo01ooool00`000?ooooooo`02oooo00<0003ooooo
ool0VOooo`00GOooo`03o`2Ioooooooo01coool500000oooo`<0002Ioooo001loooo00@0003ooooo
ool0002Poooo001moooo00<0003oool00000X?ooo`00O_ooo`80002Poooo003ooooo8Oooo`00oooo
ob7oool007Woool00`000?ooooooo`0Xoooo00<0003oooooool0NOooo`00N?ooo`030000oooooooo
00Soool00`000?ooooooo`0Ooooo00<0003oooooool0N?ooo`00N?ooo`030000oooooooo00;oool2
00001?ooo`030000oooooooo00coool400000oooo`800004oooo0P0000Coool00`000?ooooooo`1h
oooo001hoooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`04
oooo100000?oool00`000?ooooooo`09oooo00@0003oooooool00003oooo00<0003oooooool0N?oo
o`00Moooo`030000oooooooo00;oool00`000?ooooooo`0Doooo00<0003oooooool02?ooo`040000
oooooooo00001?ooo`030000oooooooo07Ooool007Soool00`000?ooooooo`0500005?ooo`030000
oooooooo00Soool200001?ooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`00000E
oooo00@0003oooooool00008oooo00@0003oooooool00003oooo00<0003oooooool0N?ooo`00NOoo
o`030000oooooooo01Ooool200002_ooo`800003oooo00<0003oooooool0NOooo`00ooooob7oool0
0?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-6.03535, \
-3.20105, 0.0455524, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-6.03535, -3.20105, 0.0455524, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.28158 .26487 L
.29205 .26487 L
.30316 .26487 L
.30791 .26487 L
.31304 .26487 L
.31454 .26487 L
.31597 .26487 L
.31725 .26487 L
.31798 .26487 L
s
.31798 .26487 m
.31825 .61803 L
s
0 .4 1 r
.02381 .25938 m
.04262 .25805 L
.06244 .2563 L
.08255 .25406 L
.10458 .25093 L
.12415 .2474 L
.14509 .24263 L
.16639 .23645 L
.18653 .22906 L
.22495 .20936 L
.24479 .19545 L
.26581 .17717 L
.28557 .15618 L
.30365 .13347 L
.30841 .12693 L
.31092 .12338 L
.3136 .11953 L
.31492 .1176 L
.31617 .11577 L
.31729 .11411 L
.31851 .26487 L
.31966 .26487 L
.32088 .26487 L
.32306 .26487 L
.34394 .26487 L
.38191 .26487 L
.42233 .26487 L
.46124 .26487 L
.5026 .26487 L
.54245 .26487 L
.58078 .26487 L
.62156 .26487 L
.66083 .26487 L
.69858 .26487 L
.73878 .26487 L
.77747 .26487 L
.81861 .26487 L
.85823 .26487 L
.89634 .26487 L
.9369 .26487 L
.97595 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001moooo0P000:7oool007coool010000?ooooooo`000:3oool007koool00`000?oo
ooooo`03oooo0`0009Woool007Koool400001Oooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo001loooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007coool200001_ooo`<0002I
oooo001foooo1P000004<ol00000000000001?ooo`030000oooooooo09Woool007Soool01@0003?o
03?o03?o00000002<ol00P0000?oool00`000?ooooooo`2Ioooo001goooo00<0000co`0co`000c?o
00800002<ol00P000003oooo0000oooo09[oool007Koool00`0003?o03?o000:<ol00P0009_oool0
07Goool00`0003?o03?o000<<ol00P0009[oool007Coool00`0003?o03?o000=<ol000<0003ooooo
ool0VOooo`00H?ooo`80I_lAoooo00<0000co`0co`003S?o0080002Joooo001Poooo0P1Voa7oool0
0`0003?o03?o000><ol000<0000co`000000VOooo`00Goooo`0306Kooooo06Ko013oool00`0003?o
03?o000?<ol00P000003<ol00000oooo09Ooool005koool0101Vooooooooo`1Voa3oool00`0003?o
03?o000?<ol000@0000co`0co`00002Hoooo001Moooo00D0I_ooooooooooool0I_l03oooo`030000
<ol0<ol0010co`001@0003?o03?o03?o0000002Goooo001Moooo00D0I_ooooooooooool0I_l03ooo
o`030000<ol0<ol0010co`000`0003?o03?o0002<ol000<0003oooooool0U?ooo`00G?ooo`0306Ko
oooooooo00;oool00`1Vooooooooo`0<oooo00<0000co`0co`004C?o00030000<ol0<ol0008co`00
0`000?ooooooo`2Doooo001Loooo00<0I_ooooooool00_ooo`0306Kooooooooo00_oool00`0003?o
03?o000B<ol00P0000@co`000`000?ooooooo`2Coooo001Koooo00<0I_ooooooool00oooo`0306Ko
oooooooo00[oool00`0003?o03?o000C<ol000<0000co`0co`0013?o00030000oooooooo09;oool0
05[oool00`1Vooooooooo`04oooo00<0I_ooooooool02_ooo`030000<ol0<ol001<co`000`0003?o
03?o0004<ol000<0003oooooool0T_ooo`00F_ooo`0306Kooooooooo00Coool00`1Vooooooooo`09
oooo00<0000co`0co`0053?o00030000<ol0<ol000Dco`000`000?ooooooo`2Aoooo001Ioooo00<0
I_ooooooool01Oooo`0306Kooooooooo00Soool00`0003?o03?o000E<ol00P0000Lco`000`000?oo
ooooo`2@oooo001Hoooo00<0I_ooooooool01_ooo`0306Kooooooooo00Ooool00`0003?o03?o000F
<ol000<0000co`0co`001S?o00030000oooooooo093oool005Ooool00`1Vooooooooo`07oooo00<0
I_ooooooool01oooo`030000<ol0<ol001Hco`000`0003?o03?o0007<ol000<0003oooooool0Sooo
o`00E_ooo`0306Kooooooooo00Soool00`1Vooooooooo`06oooo00<0000co`0co`003c?o00D00003
<ol000<0000co`0co`0023?o00030000oooooooo08koool005Goool00`1Vooooooooo`09oooo00<0
I_ooooooool01Oooo`030000<ol0<ol0018co`000`0003?o03?o0003<ol000<0000co`0co`0023?o
00030000oooooooo08koool005Coool00`1Vooooooooo`0:oooo00<0I_ooooooool01?ooo`030000
<ol0<ol001<co`000`0003?o03?o0003<ol00`0000Tco`000`000?ooooooo`2=oooo001Coooo00<0
I_ooooooool02oooo`0306Kooooooooo00Coool00`0003?o03?o000;<ol0100000@co`000`0003?o
03?o0003<ol000<0000co`0co`002S?o00030000oooooooo08coool005;oool00`1Vooooooooo`0<
oooo00<0I_ooooooool00oooo`030000<ol0<ol001@co`000`0003?o03?o0003<ol000<0000co`0c
o`002c?o00030000oooooooo08_oool0053oool206Ko3oooo`0306Kooooooooo00;oool00`0003?o
03?o000D<ol00P0000Dco`000`0003?o03?o000;<ol000<0003oooooool0Roooo`00Coooo`0306Ko
oooooooo00ooool00`1Vooooooooo`02oooo00<0000co`0co`006c?o0080000=<ol000<0003ooooo
ool0R_ooo`00C_ooo`0306Kooooooooo013oool01@1Vooooooooooooo`00000N<ol000<0000co`0c
o`003C?o00030000oooooooo08Woool004coool206Ko4oooo`0406Kooooooooo00007c?o00030000
<ol0<ol000hco`000`000?ooooooo`28oooo001:oooo0P1VoaGoool00`1Vooooo`00000P<ol000<0
000co`0co`003c?o00030000oooooooo08Ooool004Woool00`1Vooooooooo`0Eoooo00<0I_ooool0
000083?o00030000<ol0<ol0010co`000`000?ooooooo`26oooo0017oooo0P1VoaSoool00`1Vo`00
03?o000P<ol00P00018co`000`000?ooooooo`25oooo0015oooo0P1Voa[oool00`1Voc?o03?o000P
<ol000<0000co`0co`004S?o00030000oooooooo08Coool002ooool300004Oooo`80I_lDoooo1000
00;oool2000000<0I_lco`0co`0083?o00030000<ol0<ol001<co`000`000?ooooooo`0Aoooo1000
02[oool300009oooo`<0000Goooo000`oooo00<0003oooooool03_ooo`80I_lFoooo00<0003ooooo
ool00_ooo`040000<ol0<ol006Ko8S?o00030000<ol0<ol001@co`000`000?ooooooo`0@oooo00<0
003oooooool0;?ooo`030000oooooooo02Koool010000?ooooooo`0001Koool002goool500003?oo
o`<0I_lIoooo00@0003oooooool00003<ol000<0I_lco`0co`0083?o0080000F<ol00P00017oool0
0`000?ooooooo`0Xoooo1@0002Ooool010000?ooooooo`0001Koool002Ooool400000_ooo`040000
oooooooo00002oooo`80I_lEoooo100000Coool2000013?o000306Ko<ol0<ol0020co`000`0003?o
03?o000G<ol000<0003oooooool03oooo`030000oooooooo02Ooool010000?ooooooo`0002Soool3
00005oooo`00;_ooo`030000oooo000000Soool306Ko7Oooo`8000000c?o000003?o0003<ol000<0
I_lco`0co`0083?o00030000<ol0<ol001Pco`000`000?ooooooo`0<oooo00@0003oooooool0000Y
oooo00<0003oool00000:Oooo`030000oooooooo01Koool002ooool200001_ooo`80I_lOoooo1000
00Dco`000`1Voc?o03?o000P<ol000<0000co`0co`006C?o00030000oooooooo00coool20000:ooo
o`80000Yoooo0`0001Koool003?oool406Ko7oooo`800009<ol000<0I_lco`0co`0083?o00030000
<ol0<ol001Xco`020000OOooo`00;_ooo`D0I_lQoooo0P0000/co`000`1Voc?o03?o000P<ol00P00
01dco`030000N_ooo`008oooo`/0I_lSoooo0`0000dco`000`1Voc?o03?o000P<ol000<0000co`0c
o`007c?o00H0001doooo000Ioooo2P1VobSoool6000043?o000306Ko<ol0<ol0020co`000`0003?o
03?o000U<ol00`00077oool001Koool306Ko:?ooo`X0000F<ol000<0I_lco`0co`0083?o00030000
<ol0<ol002Pco`0:0000Ioooo`004?ooool0000Aoooo000Foooo00<0003oooooool02?ooo`030000
oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool0
0`000?ooooooo`08oooo00<0003oooooool01_ooo`03o`2Ioooo000000[oool00`000?ooooooo`08
oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003ooooo
ool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000
oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool0
0`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo01Goool002coool00`000?oo
ooooo`0Yoooo00<0003oooooool01_ooo`03o`2Ioooooooo023oool00`000?ooooooo`0Yoooo00<0
003oooooool0:Oooo`030000oooooooo02Woool00`000?ooooooo`0Eoooo001Qoooo00?o09Wooooo
ool08?ooo`030000oooooooo09Woool0067oool00ol0VOooooooo`0Poooo00<0003oooooool0VOoo
o`00HOooo`03o`2Ioooooooo023oool20000V_ooo`00HOooo`03o`2Ioooooooo023oool00`000?oo
ooooo`2Ioooo001Qoooo00?o09Woooooool08?ooo`030000oooooooo09Woool0067oool00ol0VOoo
ooooo`0Poooo00<0003oooooool0VOooo`00HOooo`03o`2Ioooooooo023oool20000V_ooo`00HOoo
o`03o`2Ioooooooo023oool00`000?ooooooo`2Ioooo001Qoooo00?o09Woooooool08?ooo`030000
oooooooo09Woool0067oool00ol0VOooooooo`0Poooo00<0003oooooool0VOooo`00HOooo`03o`2I
oooooooo023oool00`000?ooooooo`2Ioooo001Qoooo00?o09Woooooool08?ooo`80002Joooo001Q
oooo00?o09Woooooool08?ooo`030000oooooooo09Woool0067oool00ol0VOooooooo`0Poooo00<0
003oooooool0VOooo`00HOooo`03o`2Ioooooooo023oool00`000?ooooooo`2Ioooo001Qoooo00?o
09Woooooool08?ooo`80002Joooo001Qoooo00?o09Woooooool08?ooo`030000oooooooo09Woool0
067oool00ol0VOooooooo`0Poooo00<0003oooooool0VOooo`00HOooo`03o`2Ioooooooo01Soool5
00000oooo`030000oooooooo09Woool0067oool00ol0VOooooooo`0Joooo00<0003oooooool00ooo
o`030000oooooooo09Woool0067oool00ol0VOooooooo`0Joooo00<0003oooooool00oooo`<0002I
oooo001Qoooo00?o09Woooooool06_ooo`030000oooooooo00?oool00`000?ooooooo`2Ioooo001Q
oooo00?o09Woooooool06_ooo`030000oooooooo00?oool00`000?ooooooo`2Ioooo001Qoooo00?o
09Woooooool06Oooo`800005oooo00<0003oooooool0VOooo`00HOooo`03o`2Ioooooooo023oool2
0000V_ooo`00HOooo`03o`2Ioooooooo023oool00`000?ooooooo`2Ioooo001Qoooo00?o09Wooooo
ool08?ooo`030000oooooooo09Woool0067oool00ol0VOooooooo`0Poooo00<0003oooooool0VOoo
o`00HOooo`03o`2Ioooooooo023oool00`000?ooooooo`2Ioooo001Qoooo00?o09Woooooool08?oo
o`80002Joooo001Qoooo00?o09Woooooool08?ooo`030000oooooooo09Woool0067oool00ol0VOoo
ooooo`0Poooo00<0003oooooool0VOooo`00HOooo`03o`2Ioooooooo023oool00`000?ooooooo`2I
oooo001Qoooo00?o09Woooooool08?ooo`80002Joooo001Qoooo00?o09Woooooool08?ooo`030000
oooooooo09Woool0067oool00ol0VOooooooo`0Poooo00<0003oooooool0VOooo`00HOooo`03o`2I
oooooooo023oool00`000?ooooooo`2Ioooo001Qoooo00?o09Woooooool08?ooo`030000oooooooo
09Woool0067oool00ol0VOooooooo`0Poooo0P0009[oool0067oool00ol0VOooooooo`0Poooo00<0
003oooooool0VOooo`00HOooo`03o`2Ioooooooo01Soool400001?ooo`030000oooooooo09Woool0
067oool00ol0VOooooooo`0Hoooo00<0003oooooool01Oooo`030000oooooooo09Woool0067oool0
0ol0VOooooooo`0Ioooo00<0003oooooool01?ooo`<0002Ioooo001Qoooo00?o09Woooooool06_oo
o`030000oooooooo00?oool00`000?ooooooo`2Ioooo001Qoooo00?o09Woooooool06?ooo`040000
oooooooo00001?ooo`030000oooooooo09Woool0067oool00ol0VOooooooo`0Ioooo0P0000Goool0
0`000?ooooooo`2Ioooo001Qoooo00?o09Woooooool08?ooo`80002Joooo001Qoooo00?o09Wooooo
ool08?ooo`030000oooooooo09Woool0067oool00ol0VOooooooo`0Poooo00<0003oooooool0VOoo
o`00HOooo`03o`2Ioooooooo023oool00`000?ooooooo`2Ioooo001Qoooo00?o09Woooooool08?oo
o`030000oooooooo09Woool0067oool00ol0VOooooooo`0Poooo0P0009[oool0067oool00ol0VOoo
ooooo`0Poooo00<0003oooooool0VOooo`00HOooo`03o`2Ioooooooo023oool00`000?ooooooo`2I
oooo001Qoooo00?o09Woooooool08?ooo`030000oooooooo09Woool0067oool00ol0VOooooooo`0P
oooo0P0009[oool0067oool00ol0VOooooooo`0Poooo00<0003oooooool0VOooo`00HOooo`03o`2I
oooooooo023oool00`000?ooooooo`2Ioooo001Qoooo00?o09Woooooool08?ooo`030000oooooooo
09Woool0067oool00ol0VOooooooo`0Poooo00<0003oooooool0VOooo`00HOooo`03o`2Ioooooooo
023oool20000V_ooo`00HOooo`03o`2Ioooooooo023oool00`000?ooooooo`2Ioooo001Qoooo00?o
09Woooooool06Oooo`800005oooo00<0003oooooool0VOooo`00HOooo`03o`2Ioooooooo01Soool0
10000?ooooooo`0000Coool00`000?ooooooo`2Ioooo001Qoooo00?o09Woooooool06_ooo`030000
oooooooo00?oool30000VOooo`00HOooo`03o`2Ioooooooo01_oool00`000?ooooooo`02oooo00<0
003oooooool0VOooo`00HOooo`03o`2Ioooooooo01Soool010000?ooooooo`0000Coool00`000?oo
ooooo`2Ioooo001Qoooo00?o09Woooooool06Oooo`800005oooo00<0003oooooool0VOooo`00HOoo
o`03o`2Ioooooooo023oool00`000?ooooooo`2Ioooo001Qoooo00?o09Woooooool08?ooo`80002J
oooo001Qoooo00?o09Woooooool08?ooo`030000oooooooo09Woool0067oool00ol0VOooooooo`0P
oooo00<0003oooooool0VOooo`00HOooo`03o`2Ioooooooo023oool00`000?ooooooo`2Ioooo001Q
oooo00?o09Woooooool08?ooo`80002Joooo001Qoooo00?o09Woooooool08?ooo`030000oooooooo
09Woool0067oool00ol0VOooooooo`0Poooo00<0003oooooool0VOooo`00HOooo`03o`2Ioooooooo
023oool00`000?ooooooo`2Ioooo001Qoooo00?o09Woooooool08?ooo`030000oooooooo09Woool0
067oool00ol0VOooooooo`0Poooo0P0009[oool0067oool00ol0VOooooooo`0Poooo00<0003ooooo
ool0VOooo`00HOooo`03o`2Ioooooooo023oool00`000?ooooooo`2Ioooo001Qoooo00?o09Wooooo
ool08?ooo`030000oooooooo09Woool0067oool00ol0VOooooooo`0Poooo0P0009[oool0067oool0
0ol0VOooooooo`0Poooo00<0003oooooool0VOooo`00HOooo`03o`2Ioooooooo023oool00`000?oo
ooooo`2Ioooo001Qoooo00?o09Woooooool06_ooo`<00003oooo00<0003oooooool0VOooo`00HOoo
o`03o`2Ioooooooo01_oool00`000?ooooooo`02oooo00<0003oooooool0VOooo`00HOooo`03o`2I
oooooooo01Soool500000oooo`<0002Ioooo001loooo00@0003oooooool0002Poooo001moooo00<0
003oool00000X?ooo`00O_ooo`80002Poooo003ooooo8Oooo`00ooooob7oool007Woool00`000?oo
ooooo`0Xoooo00<0003oooooool0NOooo`00N?ooo`030000oooooooo00Soool00`000?ooooooo`0O
oooo00<0003oooooool0N?ooo`00N?ooo`030000oooooooo00;oool200001?ooo`030000oooooooo
00coool400000oooo`800003oooo0`0000Coool00`000?ooooooo`1hoooo001hoooo00D0003ooooo
ooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`04oooo100000?oool00`000?oo
ooooo`09oooo00@0003oooooool00003oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo
00;oool00`000?ooooooo`0Doooo00<0003oooooool02?ooo`040000oooooooo00001?ooo`030000
oooooooo07Ooool007Soool00`000?ooooooo`0500005?ooo`030000oooooooo00Ooool300001?oo
o`030000oooooooo07Soool007Soool01@000?ooooooooooo`00000Eoooo00@0003oooooool00009
oooo00<0003oooooool00oooo`030000oooooooo07Soool007Woool00`000?ooooooo`0Goooo0P00
00[oool300000_ooo`030000oooooooo07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-6.03535, \
-3.20105, 0.0455524, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-6.03535, -3.20105, 0.0455524, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.28158 .26487 L
.30316 .26487 L
.31323 .26487 L
.32392 .26487 L
.32831 .26487 L
.33073 .26487 L
.33304 .26487 L
.33433 .26487 L
.33507 .26487 L
s
.33507 .26487 m
.33534 .61803 L
s
0 .4 1 r
.02381 .26039 m
.04262 .2593 L
.06244 .25787 L
.08255 .25604 L
.10458 .25349 L
.12415 .2506 L
.14509 .24671 L
.16639 .24166 L
.18653 .23563 L
.22495 .21955 L
.24479 .20819 L
.26581 .19327 L
.30365 .15758 L
.32306 .13467 L
.32865 .12757 L
.3314 .12401 L
.33275 .12225 L
.33396 .12066 L
.33515 .11909 L
.33627 .26487 L
.33745 .26487 L
.33873 .26487 L
.34394 .26487 L
.38494 .26487 L
.42443 .26487 L
.4624 .26487 L
.50282 .26487 L
.54173 .26487 L
.58309 .26487 L
.62294 .26487 L
.66127 .26487 L
.70205 .26487 L
.74132 .26487 L
.77907 .26487 L
.81927 .26487 L
.85796 .26487 L
.8991 .26487 L
.93872 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001moooo0P000:7oool007coool010000?ooooooo`000:3oool007koool00`000?oo
ooooo`03oooo0`0009Woool007Koool400001Oooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo001loooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007coool200001_ooo`<0002I
oooo001foooo1P000004<ol00000000000001?ooo`030000oooooooo09Woool007Soool01@0003?o
03?o03?o00000002<ol00P0000?oool00`000?ooooooo`2Ioooo001goooo00<0000co`0co`000c?o
00800002<ol00P000003oooo0000oooo09[oool007Koool00`0003?o03?o000:<ol00P0009_oool0
07Goool00`0003?o03?o000<<ol00P0009[oool007Coool00`0003?o03?o000=<ol000<0003ooooo
ool0VOooo`00Loooo`030000<ol0<ol000hco`020000V_ooo`00IOooo`0306Kooooooooo00_oool0
0`0003?o03?o000><ol000<0000co`000000VOooo`00IOooo`0306Kooooooooo00[oool00`0003?o
03?o000?<ol00P000003<ol00000oooo09Ooool006Coool206Ko3?ooo`030000<ol0<ol000lco`00
100003?o03?o000009Soool006?oool00`1Vooooo`1Vo`0;oooo00<0000co`0co`0043?o00050000
<ol0<ol0<ol0000009Ooool006;oool0101Vooooooooo`1Vo`_oool00`0003?o03?o000@<ol000<0
000co`0co`000S?o00030000oooooooo09Coool0067oool01@1Vooooooooooooo`1Vo`0:oooo00<0
000co`0co`004C?o00030000<ol0<ol0008co`000`000?ooooooo`2Doooo001Poooo00<0I_oooooo
ool00_ooo`0306Kooooooooo00Ooool00`0003?o03?o000B<ol00P0000@co`000`000?ooooooo`2C
oooo001Ooooo00<0I_ooooooool00oooo`0306Kooooooooo00Koool00`0003?o03?o000C<ol000<0
000co`0co`0013?o00030000oooooooo09;oool005ooool00`1Vooooooooo`03oooo00<0I_oooooo
ool01_ooo`030000<ol0<ol001<co`000`0003?o03?o0004<ol000<0003oooooool0T_ooo`00G_oo
o`0306Kooooooooo00Coool00`1Vooooooooo`05oooo00<0000co`0co`0053?o00030000<ol0<ol0
00Dco`000`000?ooooooo`2Aoooo001Moooo00<0I_ooooooool01Oooo`0306Kooooooooo00Coool0
0`0003?o03?o000E<ol00P0000Lco`000`000?ooooooo`2@oooo001Loooo00<0I_ooooooool01_oo
o`0306Kooooooooo00?oool00`0003?o03?o000F<ol000<0000co`0co`001S?o00030000oooooooo
093oool005_oool00`1Vooooooooo`07oooo00<0I_ooooooool00oooo`030000<ol0<ol001Hco`00
0`0003?o03?o0007<ol000<0003oooooool0Soooo`00F_ooo`0306Kooooooooo00Soool00`1Voooo
ooooo`02oooo00<0000co`0co`003c?o00D00003<ol000<0000co`0co`0023?o00030000oooooooo
08koool005Woool00`1Vooooooooo`09oooo00D0I_ooooooooooool0000053?o00030000<ol0<ol0
00<co`000`0003?o03?o0008<ol000<0003oooooool0S_ooo`00F?ooo`0306Kooooooooo00[oool0
101Vooooooooo`0001Dco`000`0003?o03?o0003<ol00`0000Tco`000`000?ooooooo`2=oooo001G
oooo00<0I_ooooooool02oooo`0406Kooooooooo00003C?o00@00004<ol000<0000co`0co`000c?o
00030000<ol0<ol000Xco`000`000?ooooooo`2<oooo001Foooo00<0I_ooooooool03?ooo`0306Ko
oooo000001Hco`000`0003?o03?o0003<ol000<0000co`0co`002c?o00030000oooooooo08_oool0
05Goool00`1Vooooooooo`0=oooo00<0I_l0000co`005C?o00800005<ol000<0000co`0co`002c?o
00030000oooooooo08_oool005Coool00`1Vooooooooo`0>oooo00<0I_l0000co`0073?o0080000=
<ol000<0003oooooool0R_ooo`00D_ooo`80I_lAoooo00<0I_lco`0co`0073?o00030000<ol0<ol0
00dco`000`000?ooooooo`29oooo001Aoooo00<0I_ooooooool04?ooo`03000006Ko<ol001dco`00
0`0003?o03?o000><ol000<0003oooooool0R?ooo`00Coooo`80I_lBoooo00<0000co`00I_l07S?o
00030000<ol0<ol000lco`000`000?ooooooo`27oooo001>oooo00<0I_ooooooool04_ooo`030000
<ol006Ko01hco`000`0003?o03?o000@<ol000<0003oooooool0Q_ooo`00C?ooo`80I_lDoooo00@0
000co`0co`00I_lN<ol00P00018co`000`000?ooooooo`25oooo001:oooo0P1VoaGoool01@0003?o
03?o03?o001Vo`0N<ol000<0000co`0co`004S?o00030000oooooooo08Coool002ooool300005_oo
o`80I_l?oooo100000;oool2000013?o000306Ko<ol0<ol001`co`000`0003?o03?o000C<ol000<0
003oooooool04Oooo`@0000Zoooo0`0002Ooool300005oooo`00<?ooo`030000oooooooo01?oool2
06Ko4Oooo`030000oooooooo00;oool00`0003?o03?o0004<ol000<0I_lco`0co`0073?o00030000
<ol0<ol001@co`000`000?ooooooo`0@oooo00<0003oooooool0;?ooo`030000oooooooo02Koool0
10000?ooooooo`0001Koool002goool500004Oooo`<0I_lDoooo00@0003oooooool00007<ol000<0
I_lco`0co`0073?o0080000F<ol00P00017oool00`000?ooooooo`0Xoooo1@0002Ooool010000?oo
ooooo`0001Koool002Ooool400000_ooo`040000oooooooo00004?ooo`80I_l@oooo100000Coool2
000023?o000306Ko<ol0<ol001`co`000`0003?o03?o000G<ol000<0003oooooool03oooo`030000
oooooooo02Ooool010000?ooooooo`0002Soool300005oooo`00;_ooo`030000oooo000000coool4
06Ko6?ooo`8000000c?o000003?o0007<ol000<0I_lco`0co`0073?o00030000<ol0<ol001Pco`00
0`000?ooooooo`0<oooo00@0003oooooool0000Yoooo00<0003oool00000:Oooo`030000oooooooo
01Koool002ooool200002?ooo`@0I_lKoooo100000Tco`000`1Voc?o03?o000L<ol000<0000co`0c
o`006C?o00030000oooooooo00coool20000:oooo`80000Yoooo0`0001Koool003Ooool206Ko7Ooo
o`80000=<ol000<0I_lco`0co`0073?o00030000<ol0<ol001Xco`020000OOooo`00<oooo`@0I_lM
oooo0P0000lco`000`1Voc?o03?o000L<ol00P0001dco`030000N_ooo`00:Oooo`X0I_lNoooo0`00
014co`000`1Voc?o03?o000L<ol000<0000co`0co`007c?o00H0001doooo000Noooo2`1Vob;oool6
000053?o000306Ko<ol0<ol001`co`000`0003?o03?o000U<ol00`00077oool001Koool806Ko8ooo
o`X0000J<ol000<0I_lco`0co`0073?o00030000<ol0<ol002Pco`0:0000Ioooo`004?ooool0000A
oooo000Foooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0
003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?oo
o`030000ooooo`2I00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo
00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?oo
ooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0
003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?oo
o`030000oooooooo01Goool002coool00`000?ooooooo`0Yoooo00<0003oooooool02_ooo`03o`2I
oooooooo01coool00`000?ooooooo`0Yoooo00<0003oooooool0:Oooo`030000oooooooo02Woool0
0`000?ooooooo`0Eoooo001Uoooo00?o09Woooooool07?ooo`030000oooooooo09Woool006Goool0
0ol0VOooooooo`0Loooo00<0003oooooool0VOooo`00IOooo`03o`2Ioooooooo01coool20000V_oo
o`00IOooo`03o`2Ioooooooo01coool00`000?ooooooo`2Ioooo001Uoooo00?o09Woooooool07?oo
o`030000oooooooo09Woool006Goool00ol0VOooooooo`0Loooo00<0003oooooool0VOooo`00IOoo
o`03o`2Ioooooooo01coool20000V_ooo`00IOooo`03o`2Ioooooooo01coool00`000?ooooooo`2I
oooo001Uoooo00?o09Woooooool07?ooo`030000oooooooo09Woool006Goool00ol0VOooooooo`0L
oooo00<0003oooooool0VOooo`00IOooo`03o`2Ioooooooo01coool00`000?ooooooo`2Ioooo001U
oooo00?o09Woooooool07?ooo`80002Joooo001Uoooo00?o09Woooooool07?ooo`030000oooooooo
09Woool006Goool00ol0VOooooooo`0Loooo00<0003oooooool0VOooo`00IOooo`03o`2Ioooooooo
01coool00`000?ooooooo`2Ioooo001Uoooo00?o09Woooooool07?ooo`80002Joooo001Uoooo00?o
09Woooooool07?ooo`030000oooooooo09Woool006Goool00ol0VOooooooo`0Loooo00<0003ooooo
ool0VOooo`00IOooo`03o`2Ioooooooo01Coool500000oooo`030000oooooooo09Woool006Goool0
0ol0VOooooooo`0Foooo00<0003oooooool00oooo`030000oooooooo09Woool006Goool00ol0VOoo
ooooo`0Foooo00<0003oooooool00oooo`<0002Ioooo001Uoooo00?o09Woooooool05_ooo`030000
oooooooo00?oool00`000?ooooooo`2Ioooo001Uoooo00?o09Woooooool05_ooo`030000oooooooo
00?oool00`000?ooooooo`2Ioooo001Uoooo00?o09Woooooool05Oooo`800005oooo00<0003ooooo
ool0VOooo`00IOooo`03o`2Ioooooooo01coool20000V_ooo`00IOooo`03o`2Ioooooooo01coool0
0`000?ooooooo`2Ioooo001Uoooo00?o09Woooooool07?ooo`030000oooooooo09Woool006Goool0
0ol0VOooooooo`0Loooo00<0003oooooool0VOooo`00IOooo`03o`2Ioooooooo01coool00`000?oo
ooooo`2Ioooo001Uoooo00?o09Woooooool07?ooo`80002Joooo001Uoooo00?o09Woooooool07?oo
o`030000oooooooo09Woool006Goool00ol0VOooooooo`0Loooo00<0003oooooool0VOooo`00IOoo
o`03o`2Ioooooooo01coool00`000?ooooooo`2Ioooo001Uoooo00?o09Woooooool07?ooo`80002J
oooo001Uoooo00?o09Woooooool07?ooo`030000oooooooo09Woool006Goool00ol0VOooooooo`0L
oooo00<0003oooooool0VOooo`00IOooo`03o`2Ioooooooo01coool00`000?ooooooo`2Ioooo001U
oooo00?o09Woooooool07?ooo`030000oooooooo09Woool006Goool00ol0VOooooooo`0Loooo0P00
09[oool006Goool00ol0VOooooooo`0Loooo00<0003oooooool0VOooo`00IOooo`03o`2Ioooooooo
01Coool400001?ooo`030000oooooooo09Woool006Goool00ol0VOooooooo`0Doooo00<0003ooooo
ool01Oooo`030000oooooooo09Woool006Goool00ol0VOooooooo`0Eoooo00<0003oooooool01?oo
o`<0002Ioooo001Uoooo00?o09Woooooool05_ooo`030000oooooooo00?oool00`000?ooooooo`2I
oooo001Uoooo00?o09Woooooool05?ooo`040000oooooooo00001?ooo`030000oooooooo09Woool0
06Goool00ol0VOooooooo`0Eoooo0P0000Goool00`000?ooooooo`2Ioooo001Uoooo00?o09Wooooo
ool07?ooo`80002Joooo001Uoooo00?o09Woooooool07?ooo`030000oooooooo09Woool006Goool0
0ol0VOooooooo`0Loooo00<0003oooooool0VOooo`00IOooo`03o`2Ioooooooo01coool00`000?oo
ooooo`2Ioooo001Uoooo00?o09Woooooool07?ooo`030000oooooooo09Woool006Goool00ol0VOoo
ooooo`0Loooo0P0009[oool006Goool00ol0VOooooooo`0Loooo00<0003oooooool0VOooo`00IOoo
o`03o`2Ioooooooo01coool00`000?ooooooo`2Ioooo001Uoooo00?o09Woooooool07?ooo`030000
oooooooo09Woool006Goool00ol0VOooooooo`0Loooo0P0009[oool006Goool00ol0VOooooooo`0L
oooo00<0003oooooool0VOooo`00IOooo`03o`2Ioooooooo01coool00`000?ooooooo`2Ioooo001U
oooo00?o09Woooooool07?ooo`030000oooooooo09Woool006Goool00ol0VOooooooo`0Loooo00<0
003oooooool0VOooo`00IOooo`03o`2Ioooooooo01coool20000V_ooo`00IOooo`03o`2Ioooooooo
01coool00`000?ooooooo`2Ioooo001Uoooo00?o09Woooooool05Oooo`800005oooo00<0003ooooo
ool0VOooo`00IOooo`03o`2Ioooooooo01Coool010000?ooooooo`0000Coool00`000?ooooooo`2I
oooo001Uoooo00?o09Woooooool05_ooo`030000oooooooo00?oool30000VOooo`00IOooo`03o`2I
oooooooo01Ooool00`000?ooooooo`02oooo00<0003oooooool0VOooo`00IOooo`03o`2Ioooooooo
01Coool010000?ooooooo`0000Coool00`000?ooooooo`2Ioooo001Uoooo00?o09Woooooool05Ooo
o`800005oooo00<0003oooooool0VOooo`00IOooo`03o`2Ioooooooo01coool00`000?ooooooo`2I
oooo001Uoooo00?o09Woooooool07?ooo`80002Joooo001Uoooo00?o09Woooooool07?ooo`030000
oooooooo09Woool006Goool00ol0VOooooooo`0Loooo00<0003oooooool0VOooo`00IOooo`03o`2I
oooooooo01coool00`000?ooooooo`2Ioooo001Uoooo00?o09Woooooool07?ooo`80002Joooo001U
oooo00?o09Woooooool07?ooo`030000oooooooo09Woool006Goool00ol0VOooooooo`0Loooo00<0
003oooooool0VOooo`00IOooo`03o`2Ioooooooo01coool00`000?ooooooo`2Ioooo001Uoooo00?o
09Woooooool07?ooo`030000oooooooo09Woool006Goool00ol0VOooooooo`0Loooo0P0009[oool0
06Goool00ol0VOooooooo`0Loooo00<0003oooooool0VOooo`00IOooo`03o`2Ioooooooo01coool0
0`000?ooooooo`2Ioooo001Uoooo00?o09Woooooool07?ooo`030000oooooooo09Woool006Goool0
0ol0VOooooooo`0Loooo0P0009[oool006Goool00ol0VOooooooo`0Loooo00<0003oooooool0VOoo
o`00IOooo`03o`2Ioooooooo01coool00`000?ooooooo`2Ioooo001Uoooo00?o09Woooooool05_oo
o`<00003oooo00<0003oooooool0VOooo`00IOooo`03o`2Ioooooooo01Ooool00`000?ooooooo`02
oooo00<0003oooooool0VOooo`00IOooo`03o`2Ioooooooo01Coool500000oooo`<0002Ioooo001l
oooo00@0003oooooool0002Poooo001moooo00<0003oool00000X?ooo`00O_ooo`80002Poooo003o
oooo8Oooo`00ooooob7oool007Woool00`000?ooooooo`0Xoooo00<0003oooooool0NOooo`00N?oo
o`030000oooooooo00Soool00`000?ooooooo`0Ooooo00<0003oooooool0N?ooo`00N?ooo`030000
oooooooo00;oool200001?ooo`030000oooooooo00coool400000oooo`800005oooo0`0000;oool0
0`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool0
0`000?ooooooo`04oooo100000?oool00`000?ooooooo`0<oooo00D0003oooooooooool00000N_oo
o`00Moooo`030000oooooooo00;oool00`000?ooooooo`0Doooo00<0003oooooool02?ooo`D00003
oooo00<0003oooooool0Moooo`00N?ooo`030000oooooooo00D0000Doooo00<0003oooooool01ooo
o`040000oooooooo00000oooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`00000E
oooo00@0003oooooool00009oooo00<0003oool000000oooo`030000oooooooo07Soool007Woool0
0`000?ooooooo`0Goooo0P0000_oool200000_ooo`030000oooooooo07Woool00?oooolQoooo003o
oooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-6.03535, \
-3.20105, 0.0455524, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-6.03535, -3.20105, 0.0455524, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.30316 .26487 L
.32392 .26487 L
.33304 .26487 L
.34309 .26487 L
.34772 .26487 L
.35028 .26487 L
.35154 .26487 L
.35271 .26487 L
s
.35271 .26487 m
.35315 .61803 L
s
0 .4 1 r
.02381 .26122 m
.04262 .26033 L
.06244 .25916 L
.08255 .25767 L
.10458 .25559 L
.12415 .25324 L
.14509 .25006 L
.16639 .24595 L
.18653 .24103 L
.22495 .22792 L
.24479 .21865 L
.26581 .20649 L
.30365 .17739 L
.32469 .15704 L
.33467 .14652 L
.34394 .13642 L
.34854 .13133 L
.34986 .12987 L
.35111 .12849 L
.35223 .12725 L
.35344 .26487 L
.35469 .26487 L
.35607 .26487 L
.35884 .26487 L
.36381 .26487 L
.38271 .26487 L
.42313 .26487 L
.46204 .26487 L
.5034 .26487 L
.54325 .26487 L
.58158 .26487 L
.62236 .26487 L
.66163 .26487 L
.69938 .26487 L
.73958 .26487 L
.77827 .26487 L
.81941 .26487 L
.85903 .26487 L
.89714 .26487 L
.9377 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001moooo0P000:7oool007coool010000?ooooooo`000:3oool007koool00`000?oo
ooooo`03oooo0`0009Woool007Koool400001Oooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo001loooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007coool200001_ooo`<0002I
oooo001foooo1P000004<ol00000000000001?ooo`030000oooooooo09Woool007Soool01@0003?o
03?o03?o00000002<ol00P0000?oool00`000?ooooooo`2Ioooo001goooo00<0000co`0co`000c?o
00800002<ol00P000003oooo0000oooo09[oool007Koool00`0003?o03?o000:<ol00P0009_oool0
07Goool00`0003?o03?o000<<ol00P0009[oool007Coool00`0003?o03?o000=<ol000<0003ooooo
ool0VOooo`00Loooo`030000<ol0<ol000hco`020000V_ooo`00Loooo`030000<ol0<ol000hco`00
0`0003?o0000002Ioooo001boooo00<0000co`0co`003c?o008000000c?o00000?ooo`2Goooo001Z
oooo00<0I_ooooooool01Oooo`030000<ol0<ol000lco`00100003?o03?o000009Soool006Woool2
06Ko1_ooo`030000<ol0<ol0010co`001@0003?o03?o03?o0000002Goooo001Xoooo00<0I_ooool0
I_l01_ooo`030000<ol0<ol0010co`000`0003?o03?o0002<ol000<0003oooooool0U?ooo`00Iooo
o`0406Kooooooooo06Ko1Oooo`030000<ol0<ol0014co`000`0003?o03?o0002<ol000<0003ooooo
ool0U?ooo`00I_ooo`0506Kooooooooooooo06Ko00Coool00`0003?o03?o000B<ol00P0000@co`00
0`000?ooooooo`2Coooo001Uoooo00<0I_ooooooool00_ooo`0506Kooooooooooooo000001Dco`00
0`0003?o03?o0004<ol000<0003oooooool0T_ooo`00I?ooo`0306Kooooooooo00?oool01@1Voooo
ooooooooo`00000E<ol000<0000co`0co`0013?o00030000oooooooo09;oool006Coool00`1Voooo
ooooo`03oooo00@0I_ooooooool0000F<ol000<0000co`0co`001C?o00030000oooooooo097oool0
06?oool00`1Vooooooooo`04oooo00<0I_ooool000005c?o00800007<ol000<0003oooooool0T?oo
o`00H_ooo`0306Kooooooooo00Goool00`1Vo`0003?o000G<ol000<0000co`0co`001S?o00030000
oooooooo093oool0067oool00`1Vooooooooo`06oooo00<0I_l0000co`005c?o00030000<ol0<ol0
00Lco`000`000?ooooooo`2?oooo001Ooooo0P1Vo`Woool00`1Voc?o03?o000?<ol01@0000<co`00
0`0003?o03?o0008<ol000<0003oooooool0S_ooo`00G_ooo`0306Kooooooooo00Soool00`00001V
oc?o000B<ol000<0000co`0co`000c?o00030000<ol0<ol000Pco`000`000?ooooooo`2>oooo001M
oooo00<0I_ooooooool02?ooo`030000<ol006Ko01<co`000`0003?o03?o0003<ol00`0000Tco`00
0`000?ooooooo`2=oooo001Loooo00<0I_ooooooool02Oooo`030000<ol006Ko00/co`04000013?o
00030000<ol0<ol000<co`000`0003?o03?o000:<ol000<0003oooooool0S?ooo`00F_ooo`80I_l;
oooo00@0000co`0co`00I_lC<ol000<0000co`0co`000c?o00030000<ol0<ol000/co`000`000?oo
ooooo`2;oooo001Ioooo00<0I_ooooooool02_ooo`050000<ol0<ol0<ol006Ko018co`0200001C?o
00030000<ol0<ol000/co`000`000?ooooooo`2;oooo001Hoooo00<0I_ooooooool02oooo`050000
<ol0<ol0<ol006Ko01Tco`0200003C?o00030000oooooooo08[oool005Koool206Ko3Oooo`030000
<ol0<ol0008co`000`1Voc?o03?o000G<ol000<0000co`0co`003C?o00030000oooooooo08Woool0
05Goool00`1Vooooooooo`0<oooo00<0000co`0co`000c?o000306Ko<ol0<ol001Lco`000`0003?o
03?o000><ol000<0003oooooool0R?ooo`00E?ooo`0306Kooooooooo00coool00`0003?o03?o0004
<ol000<0I_lco`0co`005c?o00030000<ol0<ol000lco`000`000?ooooooo`27oooo001Boooo0P1V
o`ooool00`0003?o03?o0004<ol000<0I_lco`0co`005c?o00030000<ol0<ol0010co`000`000?oo
ooooo`26oooo001Aoooo00<0I_ooooooool03_ooo`030000<ol0<ol000Dco`000`1Voc?o03?o000G
<ol00P00018co`000`000?ooooooo`25oooo001?oooo0P1Voa3oool00`0003?o03?o0006<ol000<0
I_lco`0co`005c?o00030000<ol0<ol0018co`000`000?ooooooo`24oooo000_oooo0`0001_oool2
06Ko2_ooo`@00002oooo0P0000Tco`000`1Voc?o03?o000G<ol000<0000co`0co`004c?o00030000
oooooooo017oool40000:_ooo`<0000Woooo0`0001Ooool0033oool00`000?ooooooo`0Hoooo0P1V
o`coool00`000?ooooooo`02oooo00<0000co`0co`002C?o000306Ko<ol0<ol001Lco`000`0003?o
03?o000D<ol000<0003oooooool04?ooo`030000oooooooo02coool00`000?ooooooo`0Voooo00@0
003oooooool0000Foooo000]oooo1@0001Koool306Ko3oooo`040000oooooooo000033?o000306Ko
<ol0<ol001Lco`0200005S?o0080000Aoooo00<0003oooooool0:?ooo`D0000Woooo00@0003ooooo
ool0000Foooo000Woooo100000;oool010000?ooooooo`0001Coool306Ko2oooo`@00004oooo0P00
00dco`000`1Voc?o03?o000G<ol000<0000co`0co`005c?o00030000oooooooo00ooool00`000?oo
ooooo`0Woooo00@0003oooooool0000Xoooo0`0001Ooool002koool00`000?ooo`00000@oooo101V
oaCoool2000000<co`00000co`0033?o000306Ko<ol0<ol001Lco`000`0003?o03?o000H<ol000<0
003oooooool03?ooo`040000oooooooo0000:Oooo`030000oooo000002Woool00`000?ooooooo`0F
oooo000_oooo0P0000coool406Ko5oooo`@0000><ol000<0I_lco`0co`005c?o00030000<ol0<ol0
01Tco`000`000?ooooooo`0<oooo0P0002_oool20000:Oooo`<0000Foooo000hoooo1@1VoaWoool2
00004S?o000306Ko<ol0<ol001Lco`000`0003?o03?o000J<ol00P0007goool003?oool506Ko7?oo
o`80000D<ol000<0I_lco`0co`005c?o0080000M<ol00`0007[oool002koool506Ko7_ooo`<0000F
<ol000<0I_lco`0co`005c?o00030000<ol0<ol001lco`060000M?ooo`008oooo`/0I_lMoooo1P00
01Tco`000`1Voc?o03?o000G<ol000<0000co`0co`009C?o00<0001aoooo000Foooo3@1Voakoool:
00007c?o000306Ko<ol0<ol001Lco`000`0003?o03?o000X<ol02P0006Ooool0013ooooo00004Ooo
o`005_ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000
oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool0
0`000?ooooooo`04oooo00Go09Woooooooooool000002_ooo`030000oooooooo00Soool00`000?oo
ooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0
003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?oo
o`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo
00Soool00`000?ooooooo`0Eoooo000/oooo00<0003oooooool0:Oooo`030000oooooooo00ooool0
0ol0VOooooooo`0Goooo00<0003oooooool0:Oooo`030000oooooooo02Woool00`000?ooooooo`0Y
oooo00<0003oooooool05Oooo`00J_ooo`03o`2Ioooooooo01Ooool00`000?ooooooo`2Ioooo001Z
oooo00?o09Woooooool05oooo`030000oooooooo09Woool006[oool00ol0VOooooooo`0Goooo0P00
09[oool006[oool00ol0VOooooooo`0Goooo00<0003oooooool0VOooo`00J_ooo`03o`2Ioooooooo
01Ooool00`000?ooooooo`2Ioooo001Zoooo00?o09Woooooool05oooo`030000oooooooo09Woool0
06[oool00ol0VOooooooo`0Goooo0P0009[oool006[oool00ol0VOooooooo`0Goooo00<0003ooooo
ool0VOooo`00J_ooo`03o`2Ioooooooo01Ooool00`000?ooooooo`2Ioooo001Zoooo00?o09Wooooo
ool05oooo`030000oooooooo09Woool006[oool00ol0VOooooooo`0Goooo00<0003oooooool0VOoo
o`00J_ooo`03o`2Ioooooooo01Ooool20000V_ooo`00J_ooo`03o`2Ioooooooo01Ooool00`000?oo
ooooo`2Ioooo001Zoooo00?o09Woooooool05oooo`030000oooooooo09Woool006[oool00ol0VOoo
ooooo`0Goooo00<0003oooooool0VOooo`00J_ooo`03o`2Ioooooooo01Ooool20000V_ooo`00J_oo
o`03o`2Ioooooooo01Ooool00`000?ooooooo`2Ioooo001Zoooo00?o09Woooooool05oooo`030000
oooooooo09Woool006[oool00ol0VOooooooo`0?oooo1@0000?oool00`000?ooooooo`2Ioooo001Z
oooo00?o09Woooooool04Oooo`030000oooooooo00?oool00`000?ooooooo`2Ioooo001Zoooo00?o
09Woooooool04Oooo`030000oooooooo00?oool30000VOooo`00J_ooo`03o`2Ioooooooo017oool0
0`000?ooooooo`03oooo00<0003oooooool0VOooo`00J_ooo`03o`2Ioooooooo017oool00`000?oo
ooooo`03oooo00<0003oooooool0VOooo`00J_ooo`03o`2Ioooooooo013oool200001Oooo`030000
oooooooo09Woool006[oool00ol0VOooooooo`0Goooo0P0009[oool006[oool00ol0VOooooooo`0G
oooo00<0003oooooool0VOooo`00J_ooo`03o`2Ioooooooo01Ooool00`000?ooooooo`2Ioooo001Z
oooo00?o09Woooooool05oooo`030000oooooooo09Woool006[oool00ol0VOooooooo`0Goooo00<0
003oooooool0VOooo`00J_ooo`03o`2Ioooooooo01Ooool20000V_ooo`00J_ooo`03o`2Ioooooooo
01Ooool00`000?ooooooo`2Ioooo001Zoooo00?o09Woooooool05oooo`030000oooooooo09Woool0
06[oool00ol0VOooooooo`0Goooo00<0003oooooool0VOooo`00J_ooo`03o`2Ioooooooo01Ooool2
0000V_ooo`00J_ooo`03o`2Ioooooooo01Ooool00`000?ooooooo`2Ioooo001Zoooo00?o09Wooooo
ool05oooo`030000oooooooo09Woool006[oool00ol0VOooooooo`0Goooo00<0003oooooool0VOoo
o`00J_ooo`03o`2Ioooooooo01Ooool00`000?ooooooo`2Ioooo001Zoooo00?o09Woooooool05ooo
o`80002Joooo001Zoooo00?o09Woooooool05oooo`030000oooooooo09Woool006[oool00ol0VOoo
ooooo`0?oooo100000Coool00`000?ooooooo`2Ioooo001Zoooo00?o09Woooooool03oooo`030000
oooooooo00Goool00`000?ooooooo`2Ioooo001Zoooo00?o09Woooooool04?ooo`030000oooooooo
00Coool30000VOooo`00J_ooo`03o`2Ioooooooo017oool00`000?ooooooo`03oooo00<0003ooooo
ool0VOooo`00J_ooo`03o`2Ioooooooo00ooool010000?ooooooo`0000Coool00`000?ooooooo`2I
oooo001Zoooo00?o09Woooooool04?ooo`800005oooo00<0003oooooool0VOooo`00J_ooo`03o`2I
oooooooo01Ooool20000V_ooo`00J_ooo`03o`2Ioooooooo01Ooool00`000?ooooooo`2Ioooo001Z
oooo00?o09Woooooool05oooo`030000oooooooo09Woool006[oool00ol0VOooooooo`0Goooo00<0
003oooooool0VOooo`00J_ooo`03o`2Ioooooooo01Ooool00`000?ooooooo`2Ioooo001Zoooo00?o
09Woooooool05oooo`80002Joooo001Zoooo00?o09Woooooool05oooo`030000oooooooo09Woool0
06[oool00ol0VOooooooo`0Goooo00<0003oooooool0VOooo`00J_ooo`03o`2Ioooooooo01Ooool0
0`000?ooooooo`2Ioooo001Zoooo00?o09Woooooool05oooo`80002Joooo001Zoooo00?o09Wooooo
ool05oooo`030000oooooooo09Woool006[oool00ol0VOooooooo`0Goooo00<0003oooooool0VOoo
o`00J_ooo`03o`2Ioooooooo01Ooool00`000?ooooooo`2Ioooo001Zoooo00?o09Woooooool05ooo
o`030000oooooooo09Woool006[oool00ol0VOooooooo`0Goooo0P0009[oool006[oool00ol0VOoo
ooooo`0Goooo00<0003oooooool0VOooo`00J_ooo`03o`2Ioooooooo013oool200001Oooo`030000
oooooooo09Woool006[oool00ol0VOooooooo`0?oooo00@0003oooooool00004oooo00<0003ooooo
ool0VOooo`00J_ooo`03o`2Ioooooooo017oool00`000?ooooooo`03oooo0`0009Woool006[oool0
0ol0VOooooooo`0Boooo00<0003oooooool00_ooo`030000oooooooo09Woool006[oool00ol0VOoo
ooooo`0?oooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00J_ooo`03o`2Ioooooooo
013oool200001Oooo`030000oooooooo09Woool006[oool00ol0VOooooooo`0Goooo00<0003ooooo
ool0VOooo`00J_ooo`03o`2Ioooooooo01Ooool20000V_ooo`00J_ooo`03o`2Ioooooooo01Ooool0
0`000?ooooooo`2Ioooo001Zoooo00?o09Woooooool05oooo`030000oooooooo09Woool006[oool0
0ol0VOooooooo`0Goooo00<0003oooooool0VOooo`00J_ooo`03o`2Ioooooooo01Ooool20000V_oo
o`00J_ooo`03o`2Ioooooooo01Ooool00`000?ooooooo`2Ioooo001Zoooo00?o09Woooooool05ooo
o`030000oooooooo09Woool006[oool00ol0VOooooooo`0Goooo00<0003oooooool0VOooo`00J_oo
o`03o`2Ioooooooo01Ooool00`000?ooooooo`2Ioooo001Zoooo00?o09Woooooool05oooo`80002J
oooo001Zoooo00?o09Woooooool05oooo`030000oooooooo09Woool006[oool00ol0VOooooooo`0G
oooo00<0003oooooool0VOooo`00J_ooo`03o`2Ioooooooo01Ooool00`000?ooooooo`2Ioooo001Z
oooo00?o09Woooooool05oooo`80002Joooo001Zoooo00?o09Woooooool05oooo`030000oooooooo
09Woool006[oool00ol0VOooooooo`0Goooo00<0003oooooool0VOooo`00J_ooo`03o`2Ioooooooo
017oool300000oooo`030000oooooooo09Woool006[oool00ol0VOooooooo`0Boooo00<0003ooooo
ool00_ooo`030000oooooooo09Woool006[oool00ol0VOooooooo`0?oooo1@0000?oool30000VOoo
o`00O?ooo`040000oooooooo0000X?ooo`00OOooo`030000oooo00000:3oool007koool20000X?oo
o`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo07Woool0
07Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool007Soool0
0`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo100000?oool200000oooo`@00003
oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?ooooooo`02
oooo00<0003oooooool01?ooo`@00003oooo00<0003oooooool02Oooo`030000oooooooo00Coool0
0`000?ooooooo`1hoooo001goooo00<0003oooooool00_ooo`030000oooooooo01Coool00`000?oo
ooooo`09oooo00<0003oooooool01?ooo`030000oooooooo07Ooool007Soool00`000?ooooooo`05
00005?ooo`030000oooooooo00Woool00`000?ooooooo`02oooo00<0003oooooool0N?ooo`00N?oo
o`050000oooooooooooo000001Goool010000?ooooooo`0000Soool010000?ooooooo`0000?oool0
0`000?ooooooo`1hoooo001ioooo00<0003oooooool05oooo`80000:oooo0P0000?oool00`000?oo
ooooo`1ioooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-6.03535, \
-3.20105, 0.0455524, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-6.03535, -3.20105, 0.0455524, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.30316 .26487 L
.32392 .26487 L
.34309 .26487 L
.35271 .26487 L
.36173 .26487 L
.36626 .26487 L
.36757 .26487 L
.36881 .26487 L
.36992 .26487 L
s
.36992 .26487 m
.37041 .61803 L
s
0 .4 1 r
.02381 .2619 m
.04262 .26118 L
.06244 .26023 L
.08255 .25901 L
.10458 .25732 L
.12415 .2554 L
.14509 .25282 L
.16639 .24947 L
.18653 .24547 L
.22495 .2348 L
.24479 .22726 L
.26581 .21736 L
.30365 .19368 L
.32469 .17713 L
.34394 .16034 L
.35344 .15179 L
.35846 .14729 L
.36381 .14255 L
.36646 .14024 L
.36776 .13912 L
.36895 .1381 L
.37004 .13717 L
.37119 .26487 L
.37235 .26487 L
.37361 .26487 L
.38271 .26487 L
.42313 .26487 L
.46204 .26487 L
.5034 .26487 L
.54325 .26487 L
.58158 .26487 L
.62236 .26487 L
.66163 .26487 L
.69938 .26487 L
.73958 .26487 L
.77827 .26487 L
.81941 .26487 L
.85903 .26487 L
.89714 .26487 L
.9377 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001moooo0P000:7oool007coool010000?ooooooo`000:3oool007koool00`000?oo
ooooo`03oooo0`0009Woool007Koool400001Oooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo001loooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007coool200001_ooo`<0002I
oooo001foooo1P000004<ol00000000000001?ooo`030000oooooooo09Woool007Soool01@0003?o
03?o03?o00000002<ol00P0000?oool00`000?ooooooo`2Ioooo001goooo00<0000co`0co`000c?o
00800002<ol00P000003oooo0000oooo09[oool007Koool00`0003?o03?o000:<ol00P0009_oool0
07Goool00`0003?o03?o000<<ol00P0009[oool007Coool00`0003?o03?o000=<ol000<0003ooooo
ool0VOooo`00Loooo`030000<ol0<ol000hco`020000V_ooo`00Loooo`030000<ol0<ol000hco`00
0`0003?o0000002Ioooo001boooo00<0000co`0co`003c?o008000000c?o00000?ooo`2Goooo001b
oooo00<0000co`0co`003c?o00040000<ol0<ol00000V?ooo`00LOooo`030000<ol0<ol0010co`00
1@0003?o03?o03?o0000002Goooo001aoooo00<0000co`0co`0043?o00030000<ol0<ol0008co`00
0`000?ooooooo`2Doooo001]oooo0P1Vo`03oooo0000<ol0018co`000`0003?o03?o0002<ol000<0
003oooooool0U?ooo`00K?ooo`<0I_l00`0003?o03?o000B<ol00P0000@co`000`000?ooooooo`2C
oooo001[oooo00@0I_ooooooool0I_lE<ol000<0000co`0co`0013?o00030000oooooooo09;oool0
06[oool01@1Vooooooooooooo`1Vo`0E<ol000<0000co`0co`0013?o00030000oooooooo09;oool0
06[oool01@1Vooooooooo`00001Vo`0E<ol000<0000co`0co`001C?o00030000oooooooo097oool0
06Soool206Ko0_ooo`030000<ol006Ko01Dco`0200001c?o00030000oooooooo093oool006Ooool0
1@1Vooooooooooooo`000002<ol000<0I_lco`0co`004c?o00030000<ol0<ol000Hco`000`000?oo
ooooo`2@oooo001Voooo00<0I_ooooooool00_ooo`040000<ol0<ol006Ko5C?o00030000<ol0<ol0
00Lco`000`000?ooooooo`2?oooo001Uoooo00<0I_ooooooool00_ooo`050000<ol0<ol0<ol006Ko
00dco`0500000c?o00030000<ol0<ol000Pco`000`000?ooooooo`2>oooo001Toooo00<0I_oooooo
ool00_ooo`030000<ol0<ol0008co`000`1Voc?o03?o000=<ol000<0000co`0co`000c?o00030000
<ol0<ol000Pco`000`000?ooooooo`2>oooo001Soooo00<0I_ooooooool00_ooo`030000<ol0<ol0
00<co`000`1Voc?o03?o000=<ol000<0000co`0co`000c?o00<00009<ol000<0003oooooool0SOoo
o`00HOooo`80I_l5oooo00<0000co`0co`000c?o000306Ko<ol0<ol000Dco`04000013?o00030000
<ol0<ol000<co`000`0003?o03?o000:<ol000<0003oooooool0S?ooo`00H?ooo`0306Kooooooooo
00Coool00`0003?o03?o0004<ol000<0I_lco`0co`003C?o00030000<ol0<ol000<co`000`0003?o
03?o000;<ol000<0003oooooool0Roooo`00G_ooo`80I_l6oooo00<0000co`0co`001C?o000306Ko
<ol0<ol000`co`0200001C?o00030000<ol0<ol000/co`000`000?ooooooo`2;oooo001Moooo00<0
I_ooooooool01_ooo`030000<ol0<ol000Dco`000`1Voc?o03?o000C<ol00P0000dco`000`000?oo
ooooo`2:oooo001Koooo0P1Vo`Soool00`0003?o03?o0006<ol000<0I_lco`0co`004c?o00030000
<ol0<ol000dco`000`000?ooooooo`29oooo001Joooo00<0I_ooooooool01oooo`030000<ol0<ol0
00Lco`000`1Voc?o03?o000C<ol000<0000co`0co`003S?o00030000oooooooo08Soool005Soool2
06Ko2Oooo`030000<ol0<ol000Pco`000`1Voc?o03?o000C<ol000<0000co`0co`003c?o00030000
oooooooo08Ooool005Ooool00`1Vooooooooo`09oooo00<0000co`0co`0023?o000306Ko<ol0<ol0
01<co`000`0003?o03?o000@<ol000<0003oooooool0Q_ooo`00EOooo`80I_l;oooo00<0000co`0c
o`002C?o000306Ko<ol0<ol001<co`0200004S?o00030000oooooooo08Goool005Coool00`1Voooo
ooooo`0:oooo00<0000co`0co`002S?o000306Ko<ol0<ol001<co`000`0003?o03?o000B<ol000<0
003oooooool0Q?ooo`00;oooo`<0000Poooo0P1Vo`Goool400000_ooo`80000=<ol000<0I_lco`0c
o`004c?o00030000<ol0<ol001<co`000`000?ooooooo`0Aoooo100002[oool300009oooo`<0000G
oooo000`oooo00<0003oooooool07Oooo`80I_l7oooo00<0003oooooool00_ooo`030000<ol0<ol0
00dco`000`1Voc?o03?o000C<ol000<0000co`0co`0053?o00030000oooooooo013oool00`000?oo
ooooo`0/oooo00<0003oooooool09_ooo`040000oooooooo00005_ooo`00;Oooo`D0000Koooo0`1V
o`[oool010000?ooooooo`00010co`000`1Voc?o03?o000C<ol00P0001Hco`0200004Oooo`030000
oooooooo02Soool500009oooo`040000oooooooo00005_ooo`009oooo`@00002oooo00@0003ooooo
ool0000Joooo0P1Vo`Koool400001?ooo`80000A<ol000<0I_lco`0co`004c?o00030000<ol0<ol0
01Lco`000`000?ooooooo`0?oooo00<0003oooooool09oooo`040000oooooooo0000:?ooo`<0000G
oooo000^oooo00<0003oool000005_ooo`@0I_l>oooo0P000003<ol00000<ol0010co`000`1Voc?o
03?o000C<ol000<0000co`0co`0063?o00030000oooooooo00coool010000?ooooooo`0002Woool0
0`000?ooo`00000Yoooo00<0003oooooool05_ooo`00;oooo`80000Aoooo1@1Voa7oool400004S?o
000306Ko<ol0<ol001<co`000`0003?o03?o000I<ol000<0003oooooool03?ooo`80000[oooo0P00
02Woool300005_ooo`00?Oooo`D0I_lDoooo0P0001Hco`000`1Voc?o03?o000C<ol000<0000co`0c
o`006S?o0080001moooo000hoooo1@1VoaOoool2000063?o000306Ko<ol0<ol001<co`0200007C?o
00<0001joooo000coooo1@1VoaWoool300006S?o000306Ko<ol0<ol001<co`000`0003?o03?o000O
<ol01P0007Coool002Woool:06Ko6?ooo`H0000M<ol000<0I_lco`0co`004c?o00030000<ol0<ol0
02Dco`030000LOooo`005_oooa<0I_lHoooo2P0002<co`000`1Voc?o03?o000C<ol000<0000co`0c
o`00:3?o00X0001Woooo000@ooooo`00017oool001Koool00`000?ooooooo`08oooo00<0003ooooo
ool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000
oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool0
0`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08
oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003ooooo
ool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000
oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool05Oooo`00;?ooo`030000oooooooo
02Woool00`000?ooooooo`0Coooo00?o09Woooooool04oooo`030000oooooooo02Woool00`000?oo
ooooo`0Yoooo00<0003oooooool0:Oooo`030000oooooooo01Goool006koool00ol0VOooooooo`0C
oooo00<0003oooooool0VOooo`00K_ooo`03o`2Ioooooooo01?oool00`000?ooooooo`2Ioooo001^
oooo00?o09Woooooool04oooo`80002Joooo001^oooo00?o09Woooooool04oooo`030000oooooooo
09Woool006koool00ol0VOooooooo`0Coooo00<0003oooooool0VOooo`00K_ooo`03o`2Ioooooooo
01?oool00`000?ooooooo`2Ioooo001^oooo00?o09Woooooool04oooo`80002Joooo001^oooo00?o
09Woooooool04oooo`030000oooooooo09Woool006koool00ol0VOooooooo`0Coooo00<0003ooooo
ool0VOooo`00K_ooo`03o`2Ioooooooo01?oool00`000?ooooooo`2Ioooo001^oooo00?o09Wooooo
ool04oooo`030000oooooooo09Woool006koool00ol0VOooooooo`0Coooo0P0009[oool006koool0
0ol0VOooooooo`0Coooo00<0003oooooool0VOooo`00K_ooo`03o`2Ioooooooo01?oool00`000?oo
ooooo`2Ioooo001^oooo00?o09Woooooool04oooo`030000oooooooo09Woool006koool00ol0VOoo
ooooo`0Coooo0P0009[oool006koool00ol0VOooooooo`0Coooo00<0003oooooool0VOooo`00K_oo
o`03o`2Ioooooooo01?oool00`000?ooooooo`2Ioooo001^oooo00?o09Woooooool02oooo`D00003
oooo00<0003oooooool0VOooo`00K_ooo`03o`2Ioooooooo00goool00`000?ooooooo`03oooo00<0
003oooooool0VOooo`00K_ooo`03o`2Ioooooooo00goool00`000?ooooooo`03oooo0`0009Woool0
06koool00ol0VOooooooo`0=oooo00<0003oooooool00oooo`030000oooooooo09Woool006koool0
0ol0VOooooooo`0=oooo00<0003oooooool00oooo`030000oooooooo09Woool006koool00ol0VOoo
ooooo`0<oooo0P0000Goool00`000?ooooooo`2Ioooo001^oooo00?o09Woooooool04oooo`80002J
oooo001^oooo00?o09Woooooool04oooo`030000oooooooo09Woool006koool00ol0VOooooooo`0C
oooo00<0003oooooool0VOooo`00K_ooo`03o`2Ioooooooo01?oool00`000?ooooooo`2Ioooo001^
oooo00?o09Woooooool04oooo`030000oooooooo09Woool006koool00ol0VOooooooo`0Coooo0P00
09[oool006koool00ol0VOooooooo`0Coooo00<0003oooooool0VOooo`00K_ooo`03o`2Ioooooooo
01?oool00`000?ooooooo`2Ioooo001^oooo00?o09Woooooool04oooo`030000oooooooo09Woool0
06koool00ol0VOooooooo`0Coooo0P0009[oool006koool00ol0VOooooooo`0Coooo00<0003ooooo
ool0VOooo`00K_ooo`03o`2Ioooooooo01?oool00`000?ooooooo`2Ioooo001^oooo00?o09Wooooo
ool04oooo`030000oooooooo09Woool006koool00ol0VOooooooo`0Coooo00<0003oooooool0VOoo
o`00K_ooo`03o`2Ioooooooo01?oool20000V_ooo`00K_ooo`03o`2Ioooooooo01?oool00`000?oo
ooooo`2Ioooo001^oooo00?o09Woooooool02oooo`@00004oooo00<0003oooooool0VOooo`00K_oo
o`03o`2Ioooooooo00_oool00`000?ooooooo`05oooo00<0003oooooool0VOooo`00K_ooo`03o`2I
oooooooo00coool00`000?ooooooo`04oooo0`0009Woool006koool00ol0VOooooooo`0=oooo00<0
003oooooool00oooo`030000oooooooo09Woool006koool00ol0VOooooooo`0;oooo00@0003ooooo
ool00004oooo00<0003oooooool0VOooo`00K_ooo`03o`2Ioooooooo00coool200001Oooo`030000
oooooooo09Woool006koool00ol0VOooooooo`0Coooo0P0009[oool006koool00ol0VOooooooo`0C
oooo00<0003oooooool0VOooo`00K_ooo`03o`2Ioooooooo01?oool00`000?ooooooo`2Ioooo001^
oooo00?o09Woooooool04oooo`030000oooooooo09Woool006koool00ol0VOooooooo`0Coooo00<0
003oooooool0VOooo`00K_ooo`03o`2Ioooooooo01?oool20000V_ooo`00K_ooo`03o`2Ioooooooo
01?oool00`000?ooooooo`2Ioooo001^oooo00?o09Woooooool04oooo`030000oooooooo09Woool0
06koool00ol0VOooooooo`0Coooo00<0003oooooool0VOooo`00K_ooo`03o`2Ioooooooo01?oool2
0000V_ooo`00K_ooo`03o`2Ioooooooo01?oool00`000?ooooooo`2Ioooo001^oooo00?o09Wooooo
ool04oooo`030000oooooooo09Woool006koool00ol0VOooooooo`0Coooo00<0003oooooool0VOoo
o`00K_ooo`03o`2Ioooooooo01?oool00`000?ooooooo`2Ioooo001^oooo00?o09Woooooool04ooo
o`80002Joooo001^oooo00?o09Woooooool04oooo`030000oooooooo09Woool006koool00ol0VOoo
ooooo`0<oooo0P0000Goool00`000?ooooooo`2Ioooo001^oooo00?o09Woooooool02oooo`040000
oooooooo00001?ooo`030000oooooooo09Woool006koool00ol0VOooooooo`0=oooo00<0003ooooo
ool00oooo`<0002Ioooo001^oooo00?o09Woooooool03_ooo`030000oooooooo00;oool00`000?oo
ooooo`2Ioooo001^oooo00?o09Woooooool02oooo`040000oooooooo00001?ooo`030000oooooooo
09Woool006koool00ol0VOooooooo`0<oooo0P0000Goool00`000?ooooooo`2Ioooo001^oooo00?o
09Woooooool04oooo`030000oooooooo09Woool006koool00ol0VOooooooo`0Coooo0P0009[oool0
06koool00ol0VOooooooo`0Coooo00<0003oooooool0VOooo`00K_ooo`03o`2Ioooooooo01?oool0
0`000?ooooooo`2Ioooo001^oooo00?o09Woooooool04oooo`030000oooooooo09Woool006koool0
0ol0VOooooooo`0Coooo0P0009[oool006koool00ol0VOooooooo`0Coooo00<0003oooooool0VOoo
o`00K_ooo`03o`2Ioooooooo01?oool00`000?ooooooo`2Ioooo001^oooo00?o09Woooooool04ooo
o`030000oooooooo09Woool006koool00ol0VOooooooo`0Coooo00<0003oooooool0VOooo`00K_oo
o`03o`2Ioooooooo01?oool20000V_ooo`00K_ooo`03o`2Ioooooooo01?oool00`000?ooooooo`2I
oooo001^oooo00?o09Woooooool04oooo`030000oooooooo09Woool006koool00ol0VOooooooo`0C
oooo00<0003oooooool0VOooo`00K_ooo`03o`2Ioooooooo01?oool20000V_ooo`00K_ooo`03o`2I
oooooooo01?oool00`000?ooooooo`2Ioooo001^oooo00?o09Woooooool04oooo`030000oooooooo
09Woool006koool00ol0VOooooooo`0=oooo0`0000?oool00`000?ooooooo`2Ioooo001^oooo00?o
09Woooooool03_ooo`030000oooooooo00;oool00`000?ooooooo`2Ioooo001^oooo00?o09Wooooo
ool02oooo`D00003oooo0`0009Woool007coool010000?ooooooo`000:3oool007goool00`000?oo
o`00002Poooo001noooo0P000:3oool00?oooolQoooo003ooooo8Oooo`00O?ooo`030000oooooooo
02;oool00`000?ooooooo`1loooo001koooo00<0003oooooool02?ooo`030000oooooooo01Woool0
0`000?ooooooo`1koooo001koooo00<0003oooooool00_ooo`800004oooo00<0003oooooool03?oo
o`@00003oooo0P0000Coool00`000?ooooooo`1koooo001koooo00D0003oooooooooool000000_oo
o`030000oooooooo00;oool00`000?ooooooo`04oooo100000?oool00`000?ooooooo`0:oooo00<0
003oooooool0Noooo`00N_ooo`030000oooooooo00;oool00`000?ooooooo`0Doooo00<0003ooooo
ool02_ooo`030000oooooooo07[oool007_oool00`000?ooooooo`0500005?ooo`030000oooooooo
00Soool00`000?ooooooo`1koooo001koooo00D0003oooooooooool000005Oooo`040000oooooooo
00002Oooo`030000oooooooo07_oool007coool00`000?ooooooo`0Goooo0P0000Woool00`000?oo
ooooo`1loooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-6.03535, \
-3.20105, 0.0455524, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-6.03535, -3.20105, 0.0455524, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.30316 .26487 L
.34309 .26487 L
.36136 .26487 L
.37176 .26487 L
.37685 .26487 L
.3815 .26487 L
.38384 .26487 L
.38508 .26487 L
.3864 .26487 L
s
.3864 .26487 m
.38691 .61803 L
s
0 .4 1 r
.02381 .26246 m
.04262 .26187 L
.06244 .2611 L
.08255 .26012 L
.10458 .25874 L
.12415 .25719 L
.14509 .2551 L
.16639 .25238 L
.18653 .24913 L
.22495 .24048 L
.24479 .23436 L
.26581 .22633 L
.30365 .20712 L
.34394 .18008 L
.36247 .1666 L
.37227 .15976 L
.37764 .15621 L
.38271 .15304 L
.38547 .1514 L
.38623 .15097 L
.38703 .15051 L
.38771 .26487 L
.38846 .26487 L
.39367 .26487 L
.40384 .26487 L
.42393 .26487 L
.46436 .26487 L
.50327 .26487 L
.54463 .26487 L
.58447 .26487 L
.6228 .26487 L
.66358 .26487 L
.70285 .26487 L
.7406 .26487 L
.7808 .26487 L
.81949 .26487 L
.86063 .26487 L
.90026 .26487 L
.93836 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001moooo0P000:7oool007coool010000?ooooooo`000:3oool007koool00`000?oo
ooooo`03oooo0`0009Woool007Koool400001Oooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo001loooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007coool200001_ooo`<0002I
oooo001foooo1P000004<ol00000000000001?ooo`030000oooooooo09Woool007Soool01@0003?o
03?o03?o00000002<ol00P0000?oool00`000?ooooooo`2Ioooo001goooo00<0000co`0co`000c?o
00800002<ol00P000003oooo0000oooo09[oool007Koool00`0003?o03?o000:<ol00P0009_oool0
07Goool00`0003?o03?o000<<ol00P0009[oool007Coool00`0003?o03?o000=<ol000<0003ooooo
ool0VOooo`00Loooo`030000<ol0<ol000hco`020000V_ooo`00Loooo`030000<ol0<ol000hco`00
0`0003?o0000002Ioooo001boooo00<0000co`0co`003c?o008000000c?o00000?ooo`2Goooo001b
oooo00<0000co`0co`003c?o00040000<ol0<ol00000V?ooo`00LOooo`030000<ol0<ol0010co`00
1@0003?o03?o03?o0000002Goooo001aoooo00<0000co`0co`0043?o00030000<ol0<ol0008co`00
0`000?ooooooo`2Doooo001`oooo00<0000co`0co`004C?o00030000<ol0<ol0008co`000`000?oo
ooooo`2Doooo001_oooo00<0000co`0co`004S?o00800004<ol000<0003oooooool0Toooo`00K_oo
o`030000<ol0<ol001<co`000`0003?o03?o0004<ol000<0003oooooool0T_ooo`00K_ooo`050000
<ol0<ol0<ol006Ko014co`000`0003?o03?o0004<ol000<0003oooooool0T_ooo`00KOooo`040000
<ol0<ol0<ol00P1Voa4co`000`0003?o03?o0005<ol000<0003oooooool0TOooo`00K?ooo`070000
<ol0<ol0<ol006Ko<ol006Ko014co`0200001c?o00030000oooooooo093oool006_oool00`0003?o
03?o000206Ko0S?o000306Ko<ol0<ol000lco`000`0003?o03?o0006<ol000<0003oooooool0T?oo
o`00Joooo`03000006Ko06Ko00@co`000`1Voc?o03?o000?<ol000<0000co`0co`001c?o00030000
oooooooo08ooool006[oool00`00001Voc?o0005<ol000<0I_lco`0co`001c?o00D00003<ol000<0
000co`0co`0023?o00030000oooooooo08koool006Woool206Ko1c?o000306Ko<ol0<ol000Tco`00
0`0003?o03?o0003<ol000<0000co`0co`0023?o00030000oooooooo08koool006Soool00`1Voc?o
03?o0007<ol000<0I_lco`0co`002C?o00030000<ol0<ol000<co`0300002C?o00030000oooooooo
08goool006Ooool00`1Vo`0003?o0008<ol000@0I_lco`0co`0co`04000013?o00030000<ol0<ol0
00<co`000`0003?o03?o000:<ol000<0003oooooool0S?ooo`00IOooo`80I_l00`0003?o03?o0008
<ol000<0I_lco`0co`002C?o00030000<ol0<ol000<co`000`0003?o03?o000;<ol000<0003ooooo
ool0Roooo`00I?ooo`0306Kooooo000000/co`000`1Voc?o03?o0008<ol00P0000Dco`000`0003?o
03?o000;<ol000<0003oooooool0Roooo`00Hoooo`0406Kooooooooo00002c?o000306Ko<ol0<ol0
00lco`0200003C?o00030000oooooooo08[oool0067oool206Ko0_ooo`030000<ol0<ol000Xco`00
0`1Voc?o03?o000?<ol000<0000co`0co`003C?o00030000oooooooo08Woool0063oool01@1Voooo
ooooooooo`00000=<ol000<0I_lco`0co`003c?o00030000<ol0<ol000hco`000`000?ooooooo`28
oooo001Noooo0P1Vo`?oool00`0003?o03?o000<<ol000<0I_lco`0co`003c?o00030000<ol0<ol0
00lco`000`000?ooooooo`27oooo001Loooo0P1Vo`Goool00`0003?o03?o000<<ol000<0I_lco`0c
o`003c?o00030000<ol0<ol0010co`000`000?ooooooo`26oooo001Joooo0P1Vo`Koool00`0003?o
03?o000=<ol000<0I_lco`0co`003c?o0080000B<ol000<0003oooooool0QOooo`00F?ooo`80I_l7
oooo00<0000co`0co`003S?o000306Ko<ol0<ol000lco`000`0003?o03?o000B<ol000<0003ooooo
ool0Q?ooo`00;oooo`<0000Toooo0P1Vo`03oooo0000000000800002oooo0P00014co`000`1Voc?o
03?o000?<ol000<0000co`0co`004c?o00030000oooooooo017oool40000:_ooo`<0000Woooo0`00
01Ooool0033oool00`000?ooooooo`0Poooo0`1Vo`?oool00`000?ooooooo`02oooo00<0000co`0c
o`004C?o000306Ko<ol0<ol000lco`000`0003?o03?o000D<ol000<0003oooooool04?ooo`030000
oooooooo02coool00`000?ooooooo`0Voooo00@0003oooooool0000Foooo000]oooo1@0001koool3
06Ko1oooo`040000oooooooo000053?o000306Ko<ol0<ol000lco`0200005S?o0080000Aoooo00<0
003oooooool0:?ooo`D0000Woooo00@0003oooooool0000Foooo000Woooo100000;oool010000?oo
ooooo`0001coool306Ko0oooo`@00004oooo0P0001Dco`000`1Voc?o03?o000?<ol000<0000co`0c
o`005c?o00030000oooooooo00ooool00`000?ooooooo`0Woooo00@0003oooooool0000Xoooo0`00
01Ooool002koool00`000?ooo`00000Joooo0P1Vo`coool2000000<co`00000co`0053?o000306Ko
<ol0<ol000lco`000`0003?o03?o000H<ol000<0003oooooool03?ooo`040000oooooooo0000:Ooo
o`030000oooo000002Woool00`000?ooooooo`0Foooo000_oooo0P0001Koool406Ko3Oooo`@0000F
<ol000<0I_lco`0co`003c?o00030000<ol0<ol001Tco`000`000?ooooooo`0<oooo0P0002_oool2
0000:Oooo`<0000Foooo0012oooo1@1Vo`ooool200006S?o000306Ko<ol0<ol000lco`000`0003?o
03?o000J<ol00P0007goool003goool506Ko4_ooo`80000L<ol000<0I_lco`0co`003c?o0080000M
<ol00`0007[oool003Soool506Ko5?ooo`<0000N<ol000<0I_lco`0co`003c?o00030000<ol0<ol0
01lco`060000M?ooo`00;_ooo`X0I_lCoooo1P00024co`000`1Voc?o03?o000?<ol000<0000co`0c
o`009C?o00<0001aoooo000Ioooo5@1Voa?oool:00009c?o000306Ko<ol0<ol000lco`000`0003?o
03?o000X<ol02P0006Ooool0013ooooo00004Oooo`005_ooo`030000oooooooo00Soool00`000?oo
ooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0
003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00D0003ooooooooooooo
09T01_ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000
oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool0
0`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08
oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`0Eoooo000/oooo00<0
003oooooool0:Oooo`030000oooooooo01Ooool00ol0VOooooooo`0?oooo00<0003oooooool0:Ooo
o`030000oooooooo02Woool00`000?ooooooo`0Yoooo00<0003oooooool05Oooo`00L_ooo`03o`2I
oooooooo00ooool00`000?ooooooo`2Ioooo001boooo00?o09Woooooool03oooo`030000oooooooo
09Woool007;oool00ol0VOooooooo`0?oooo0P0009[oool007;oool00ol0VOooooooo`0?oooo00<0
003oooooool0VOooo`00L_ooo`03o`2Ioooooooo00ooool00`000?ooooooo`2Ioooo001boooo00?o
09Woooooool03oooo`030000oooooooo09Woool007;oool00ol0VOooooooo`0?oooo0P0009[oool0
07;oool00ol0VOooooooo`0?oooo00<0003oooooool0VOooo`00L_ooo`03o`2Ioooooooo00ooool0
0`000?ooooooo`2Ioooo001boooo00?o09Woooooool03oooo`030000oooooooo09Woool007;oool0
0ol0VOooooooo`0?oooo00<0003oooooool0VOooo`00L_ooo`03o`2Ioooooooo00ooool20000V_oo
o`00L_ooo`03o`2Ioooooooo00ooool00`000?ooooooo`2Ioooo001boooo00?o09Woooooool03ooo
o`030000oooooooo09Woool007;oool00ol0VOooooooo`0?oooo00<0003oooooool0VOooo`00L_oo
o`03o`2Ioooooooo00ooool20000V_ooo`00L_ooo`03o`2Ioooooooo00ooool00`000?ooooooo`2I
oooo001boooo00?o09Woooooool03oooo`030000oooooooo09Woool007;oool00ol0VOooooooo`07
oooo1@0000?oool00`000?ooooooo`2Ioooo001boooo00?o09Woooooool02Oooo`030000oooooooo
00?oool00`000?ooooooo`2Ioooo001boooo00?o09Woooooool02Oooo`030000oooooooo00?oool3
0000VOooo`00L_ooo`03o`2Ioooooooo00Woool00`000?ooooooo`03oooo00<0003oooooool0VOoo
o`00L_ooo`03o`2Ioooooooo00Woool00`000?ooooooo`03oooo00<0003oooooool0VOooo`00L_oo
o`03o`2Ioooooooo00Soool200001Oooo`030000oooooooo09Woool007;oool00ol0VOooooooo`0?
oooo0P0009[oool007;oool00ol0VOooooooo`0?oooo00<0003oooooool0VOooo`00L_ooo`03o`2I
oooooooo00ooool00`000?ooooooo`2Ioooo001boooo00?o09Woooooool03oooo`030000oooooooo
09Woool007;oool00ol0VOooooooo`0?oooo00<0003oooooool0VOooo`00L_ooo`03o`2Ioooooooo
00ooool20000V_ooo`00L_ooo`03o`2Ioooooooo00ooool00`000?ooooooo`2Ioooo001boooo00?o
09Woooooool03oooo`030000oooooooo09Woool007;oool00ol0VOooooooo`0?oooo00<0003ooooo
ool0VOooo`00L_ooo`03o`2Ioooooooo00ooool20000V_ooo`00L_ooo`03o`2Ioooooooo00ooool0
0`000?ooooooo`2Ioooo001boooo00?o09Woooooool03oooo`030000oooooooo09Woool007;oool0
0ol0VOooooooo`0?oooo00<0003oooooool0VOooo`00L_ooo`03o`2Ioooooooo00ooool00`000?oo
ooooo`2Ioooo001boooo00?o09Woooooool03oooo`80002Joooo001boooo00?o09Woooooool03ooo
o`030000oooooooo09Woool007;oool00ol0VOooooooo`07oooo100000Coool00`000?ooooooo`2I
oooo001boooo00?o09Woooooool01oooo`030000oooooooo00Goool00`000?ooooooo`2Ioooo001b
oooo00?o09Woooooool02?ooo`030000oooooooo00Coool30000VOooo`00L_ooo`03o`2Ioooooooo
00Woool00`000?ooooooo`03oooo00<0003oooooool0VOooo`00L_ooo`03o`2Ioooooooo00Ooool0
10000?ooooooo`0000Coool00`000?ooooooo`2Ioooo001boooo00?o09Woooooool02?ooo`800005
oooo00<0003oooooool0VOooo`00L_ooo`03o`2Ioooooooo00ooool20000V_ooo`00L_ooo`03o`2I
oooooooo00ooool00`000?ooooooo`2Ioooo001boooo00?o09Woooooool03oooo`030000oooooooo
09Woool007;oool00ol0VOooooooo`0?oooo00<0003oooooool0VOooo`00L_ooo`03o`2Ioooooooo
00ooool00`000?ooooooo`2Ioooo001boooo00?o09Woooooool03oooo`80002Joooo001boooo00?o
09Woooooool03oooo`030000oooooooo09Woool007;oool00ol0VOooooooo`0?oooo00<0003ooooo
ool0VOooo`00L_ooo`03o`2Ioooooooo00ooool00`000?ooooooo`2Ioooo001boooo00?o09Wooooo
ool03oooo`80002Joooo001boooo00?o09Woooooool03oooo`030000oooooooo09Woool007;oool0
0ol0VOooooooo`0?oooo00<0003oooooool0VOooo`00L_ooo`03o`2Ioooooooo00ooool00`000?oo
ooooo`2Ioooo001boooo00?o09Woooooool03oooo`030000oooooooo09Woool007;oool00ol0VOoo
ooooo`0?oooo0P0009[oool007;oool00ol0VOooooooo`0?oooo00<0003oooooool0VOooo`00L_oo
o`03o`2Ioooooooo00Soool200001Oooo`030000oooooooo09Woool007;oool00ol0VOooooooo`07
oooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00L_ooo`03o`2Ioooooooo00Woool0
0`000?ooooooo`03oooo0`0009Woool007;oool00ol0VOooooooo`0:oooo00<0003oooooool00_oo
o`030000oooooooo09Woool007;oool00ol0VOooooooo`07oooo00@0003oooooool00004oooo00<0
003oooooool0VOooo`00L_ooo`03o`2Ioooooooo00Soool200001Oooo`030000oooooooo09Woool0
07;oool00ol0VOooooooo`0?oooo00<0003oooooool0VOooo`00L_ooo`03o`2Ioooooooo00ooool2
0000V_ooo`00L_ooo`03o`2Ioooooooo00ooool00`000?ooooooo`2Ioooo001boooo00?o09Wooooo
ool03oooo`030000oooooooo09Woool007;oool00ol0VOooooooo`0?oooo00<0003oooooool0VOoo
o`00L_ooo`03o`2Ioooooooo00ooool20000V_ooo`00L_ooo`03o`2Ioooooooo00ooool00`000?oo
ooooo`2Ioooo001boooo00?o09Woooooool03oooo`030000oooooooo09Woool007;oool00ol0VOoo
ooooo`0?oooo00<0003oooooool0VOooo`00L_ooo`03o`2Ioooooooo00ooool00`000?ooooooo`2I
oooo001boooo00?o09Woooooool03oooo`80002Joooo001boooo00?o09Woooooool03oooo`030000
oooooooo09Woool007;oool00ol0VOooooooo`0?oooo00<0003oooooool0VOooo`00L_ooo`03o`2I
oooooooo00ooool00`000?ooooooo`2Ioooo001boooo00?o09Woooooool03oooo`80002Joooo001b
oooo00?o09Woooooool03oooo`030000oooooooo09Woool007;oool00ol0VOooooooo`0?oooo00<0
003oooooool0VOooo`00L_ooo`03o`2Ioooooooo00Woool300000oooo`030000oooooooo09Woool0
07;oool00ol0VOooooooo`0:oooo00<0003oooooool00_ooo`030000oooooooo09Woool007;oool0
0ol0VOooooooo`07oooo1@0000?oool30000VOooo`00O?ooo`040000oooooooo0000X?ooo`00OOoo
o`030000oooo00000:3oool007koool20000X?ooo`00ooooob7oool00?oooolQoooo001ioooo00<0
003oooooool0:?ooo`030000oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003ooooo
ool07oooo`030000oooooooo07Soool007Soool00`000?ooooooo`02oooo0P0000Coool00`000?oo
ooooo`0<oooo1@0000;oool200001?ooo`800004oooo00<0003oooooool0N?ooo`00N?ooo`050000
oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01?ooo`@00005oooo00<0
003oooooool01oooo`040000oooooooo00000oooo`030000oooooooo07Soool007Ooool00`000?oo
ooooo`02oooo00<0003oooooool05Oooo`030000oooooooo00Ooool010000?ooooooo`0000Coool0
0`000?ooooooo`1goooo001hoooo00<0003oooooool01@0001Coool00`000?ooooooo`08oooo0P00
00Coool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000005oooo`030000oooooooo
00Ooool010000?ooooooo`0000?oool00`000?ooooooo`1hoooo001ioooo00<0003oooooool05ooo
o`80000:oooo0P0000?oool00`000?ooooooo`1ioooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-6.03535, \
-3.20105, 0.0455524, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-6.03535, -3.20105, 0.0455524, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.30316 .26487 L
.34309 .26487 L
.3815 .26487 L
.39174 .26487 L
.39675 .26487 L
.40134 .26487 L
.40252 .26487 L
.40381 .26487 L
s
.40381 .26487 m
.4043 .61803 L
s
0 .4 1 r
.02381 .26292 m
.04262 .26245 L
.06244 .26183 L
.08255 .26103 L
.10458 .25992 L
.12415 .25867 L
.14509 .25698 L
.16639 .25479 L
.18653 .25216 L
.22495 .24518 L
.24479 .24024 L
.26581 .23375 L
.30365 .21824 L
.34394 .19641 L
.38271 .17458 L
.39281 .17003 L
.39815 .16798 L
.40108 .16699 L
.40252 .16653 L
.40315 .16634 L
.40384 .16613 L
.40512 .26487 L
.40582 .26487 L
.40647 .26487 L
.40931 .26487 L
.41426 .26487 L
.42393 .26487 L
.46284 .26487 L
.5042 .26487 L
.54405 .26487 L
.58238 .26487 L
.62316 .26487 L
.66243 .26487 L
.70018 .26487 L
.74038 .26487 L
.77907 .26487 L
.82021 .26487 L
.85983 .26487 L
.89794 .26487 L
.9385 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001moooo0P000:7oool007coool010000?ooooooo`000:3oool007koool00`000?oo
ooooo`03oooo0`0009Woool007Koool400001Oooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo001loooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007coool200001_ooo`<0002I
oooo001foooo1P000004<ol00000000000001?ooo`030000oooooooo09Woool007Soool01@0003?o
03?o03?o00000002<ol00P0000?oool00`000?ooooooo`2Ioooo001goooo00<0000co`0co`000c?o
00800002<ol00P000003oooo0000oooo09[oool007Koool00`0003?o03?o000:<ol00P0009_oool0
07Goool00`0003?o03?o000<<ol00P0009[oool007Coool00`0003?o03?o000=<ol000<0003ooooo
ool0VOooo`00Loooo`030000<ol0<ol000hco`020000V_ooo`00Loooo`030000<ol0<ol000hco`00
0`0003?o0000002Ioooo001boooo00<0000co`0co`003c?o008000000c?o00000?ooo`2Goooo001b
oooo00<0000co`0co`003c?o00040000<ol0<ol00000V?ooo`00LOooo`030000<ol0<ol0010co`00
1@0003?o03?o03?o0000002Goooo001aoooo00<0000co`0co`0043?o00030000<ol0<ol0008co`00
0`000?ooooooo`2Doooo001`oooo00<0000co`0co`004C?o00030000<ol0<ol0008co`000`000?oo
ooooo`2Doooo001_oooo00<0000co`0co`004S?o00800004<ol000<0003oooooool0Toooo`00K_oo
o`030000<ol0<ol001<co`000`0003?o03?o0004<ol000<0003oooooool0T_ooo`00K_ooo`030000
<ol0<ol001<co`000`0003?o03?o0004<ol000<0003oooooool0T_ooo`00KOooo`030000<ol0<ol0
01@co`000`0003?o03?o0005<ol000<0003oooooool0TOooo`00K?ooo`030000<ol0<ol001Dco`02
00001c?o00030000oooooooo093oool006_oool00`0003?o03?o000F<ol000<0000co`0co`001S?o
00030000oooooooo093oool006_oool00`0003?o03?o0008<ol00P1Vo``co`000`0003?o03?o0007
<ol000<0003oooooool0Soooo`00J_ooo`030000<ol0<ol000Hco`0306Ko00<co`00I_lco`000c?o
00D00003<ol000<0000co`0co`0023?o00030000oooooooo08koool006Woool00`0003?o03?o0005
<ol00P1Vo`@co`000`1Voc?o03?o0004<ol000<0000co`0co`000c?o00030000<ol0<ol000Pco`00
0`000?ooooooo`2>oooo001Xoooo00<0000co`0co`0013?o0080I_l6<ol000<0I_lco`0co`0013?o
00030000<ol0<ol000<co`0300002C?o00030000oooooooo08goool006Soool00`0003?o03?o0002
<ol00P1Vo`Lco`04000013?o00030000<ol0<ol000<co`000`0003?o03?o000:<ol000<0003ooooo
ool0S?ooo`00Ioooo`030000<ol0<ol0008co`000`1Voc?o03?o0008<ol000<0I_lco`0co`0013?o
00030000<ol0<ol000<co`000`0003?o03?o000;<ol000<0003oooooool0Roooo`00I_ooo`040000
<ol0<ol0<ol00P1Vo`/co`000`1Voc?o03?o0003<ol00P0000Dco`000`0003?o03?o000;<ol000<0
003oooooool0Roooo`00I_ooo`040000<ol006Ko06Ko3C?o000306Ko<ol0<ol000Xco`0200003C?o
00030000oooooooo08[oool006Goool00`0003?o001Vo`0?<ol000<0I_lco`0co`002S?o00030000
<ol0<ol000dco`000`000?ooooooo`29oooo001Toooo00<00000I_l0I_l043?o000306Ko<ol0<ol0
00Xco`000`0003?o03?o000><ol000<0003oooooool0R?ooo`00Hoooo`80I_lB<ol000<0I_lco`0c
o`002S?o00030000<ol0<ol000lco`000`000?ooooooo`27oooo001Qoooo0P1Vo`030000<ol0<ol0
014co`000`1Voc?o03?o000:<ol000<0000co`0co`0043?o00030000oooooooo08Koool005ooool2
06Ko00?oool0000co`004c?o000306Ko<ol0<ol000Xco`0200004S?o00030000oooooooo08Goool0
05coool306Ko0_ooo`030000<ol0<ol001<co`000`1Voc?o03?o000:<ol000<0000co`0co`004S?o
00030000oooooooo08Coool002ooool300009oooo`@00002oooo0P0001Hco`000`1Voc?o03?o000:
<ol000<0000co`0co`004c?o00030000oooooooo017oool40000:_ooo`<0000Woooo0`0001Ooool0
033oool00`000?ooooooo`0Uoooo00<0I_l0003oool00oooo`030000<ol0<ol001Hco`000`1Voc?o
03?o000:<ol000<0000co`0co`0053?o00030000oooooooo013oool00`000?ooooooo`0/oooo00<0
003oooooool09_ooo`040000oooooooo00005_ooo`00;Oooo`D0000Toooo0P1Vo`;oool010000?oo
ooooo`0001Tco`000`1Voc?o03?o000:<ol00P0001Hco`0200004Oooo`030000oooooooo02Soool5
00009oooo`040000oooooooo00005_ooo`009oooo`@00002oooo00@0003oooooool0000Roooo1000
00Coool200006S?o000306Ko<ol0<ol000Xco`000`0003?o03?o000G<ol000<0003oooooool03ooo
o`030000oooooooo02Ooool010000?ooooooo`0002Soool300005oooo`00;_ooo`030000oooo0000
01ooool306Ko1_ooo`8000000c?o000003?o000I<ol000<0I_lco`0co`002S?o00030000<ol0<ol0
01Pco`000`000?ooooooo`0<oooo00@0003oooooool0000Yoooo00<0003oool00000:Oooo`030000
oooooooo01Koool002ooool200006oooo`@0I_l8oooo100001/co`000`1Voc?o03?o000:<ol000<0
000co`0co`006C?o00030000oooooooo00coool20000:oooo`80000Yoooo0`0001Koool004Ooool5
06Ko2_ooo`80000O<ol000<0I_lco`0co`002S?o00030000<ol0<ol001Xco`020000OOooo`00@_oo
o`D0I_l=oooo0P00024co`000`1Voc?o03?o000:<ol00P0001dco`030000N_ooo`00?Oooo`D0I_l?
oooo0`0002<co`000`1Voc?o03?o000:<ol000<0000co`0co`007c?o00H0001doooo000coooo2P1V
o`koool600009S?o000306Ko<ol0<ol000Xco`000`0003?o03?o000U<ol00`00077oool001kooolE
06Ko3_ooo`X0000/<ol000<0I_lco`0co`002S?o00030000<ol0<ol002Pco`0:0000Ioooo`004?oo
ool0000Aoooo000Foooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08
oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003ooooo
ool02?ooo`030000oooooooo00Soool00`000?ooooooo`06oooo00?o09Woool000002_ooo`030000
oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool0
0`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08
oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003ooooo
ool02?ooo`030000oooooooo01Goool002coool00`000?ooooooo`0Yoooo00<0003oooooool07?oo
o`03o`2Ioooooooo00[oool00`000?ooooooo`0Yoooo00<0003oooooool0:Oooo`030000oooooooo
02Woool00`000?ooooooo`0Eoooo001goooo00?o09Woooooool02_ooo`030000oooooooo09Woool0
07Ooool00ol0VOooooooo`0:oooo00<0003oooooool0VOooo`00Moooo`03o`2Ioooooooo00[oool2
0000V_ooo`00Moooo`03o`2Ioooooooo00[oool00`000?ooooooo`2Ioooo001goooo00?o09Wooooo
ool02_ooo`030000oooooooo09Woool007Ooool00ol0VOooooooo`0:oooo00<0003oooooool0VOoo
o`00Moooo`03o`2Ioooooooo00[oool20000V_ooo`00Moooo`03o`2Ioooooooo00[oool00`000?oo
ooooo`2Ioooo001goooo00?o09Woooooool02_ooo`030000oooooooo09Woool007Ooool00ol0VOoo
ooooo`0:oooo00<0003oooooool0VOooo`00Moooo`03o`2Ioooooooo00[oool00`000?ooooooo`2I
oooo001goooo00?o09Woooooool02_ooo`80002Joooo001goooo00?o09Woooooool02_ooo`030000
oooooooo09Woool007Ooool00ol0VOooooooo`0:oooo00<0003oooooool0VOooo`00Moooo`03o`2I
oooooooo00[oool00`000?ooooooo`2Ioooo001goooo00?o09Woooooool02_ooo`80002Joooo001g
oooo00?o09Woooooool02_ooo`030000oooooooo09Woool007Ooool00ol0VOooooooo`0:oooo00<0
003oooooool0VOooo`00Moooo`03o`2Ioooooooo00;oool500000oooo`030000oooooooo09Woool0
07Ooool00ol0VOooooooo`04oooo00<0003oooooool00oooo`030000oooooooo09Woool007Ooool0
0ol0VOooooooo`04oooo00<0003oooooool00oooo`<0002Ioooo001goooo00?o09Woooooool01?oo
o`030000oooooooo00?oool00`000?ooooooo`2Ioooo001goooo00?o09Woooooool01?ooo`030000
oooooooo00?oool00`000?ooooooo`2Ioooo001goooo00?o09Woooooool00oooo`800005oooo00<0
003oooooool0VOooo`00Moooo`03o`2Ioooooooo00[oool20000V_ooo`00Moooo`03o`2Ioooooooo
00[oool00`000?ooooooo`2Ioooo001goooo00?o09Woooooool02_ooo`030000oooooooo09Woool0
07Ooool00ol0VOooooooo`0:oooo00<0003oooooool0VOooo`00Moooo`03o`2Ioooooooo00[oool0
0`000?ooooooo`2Ioooo001goooo00?o09Woooooool02_ooo`80002Joooo001goooo00?o09Wooooo
ool02_ooo`030000oooooooo09Woool007Ooool00ol0VOooooooo`0:oooo00<0003oooooool0VOoo
o`00Moooo`03o`2Ioooooooo00[oool00`000?ooooooo`2Ioooo001goooo00?o09Woooooool02_oo
o`80002Joooo001goooo00?o09Woooooool02_ooo`030000oooooooo09Woool007Ooool00ol0VOoo
ooooo`0:oooo00<0003oooooool0VOooo`00Moooo`03o`2Ioooooooo00[oool00`000?ooooooo`2I
oooo001goooo00?o09Woooooool02_ooo`030000oooooooo09Woool007Ooool00ol0VOooooooo`0:
oooo0P0009[oool007Ooool00ol0VOooooooo`0:oooo00<0003oooooool0VOooo`00Moooo`03o`2I
oooooooo00;oool400001?ooo`030000oooooooo09Woool007Ooool00ol0VOooooooo`02oooo00<0
003oooooool01Oooo`030000oooooooo09Woool007Ooool00ol0VOooooooo`03oooo00<0003ooooo
ool01?ooo`<0002Ioooo001goooo00?o09Woooooool01?ooo`030000oooooooo00?oool00`000?oo
ooooo`2Ioooo001goooo00?o09Woooooool00_ooo`040000oooooooo00001?ooo`030000oooooooo
09Woool007Ooool00ol0VOooooooo`03oooo0P0000Goool00`000?ooooooo`2Ioooo001goooo00?o
09Woooooool02_ooo`80002Joooo001goooo00?o09Woooooool02_ooo`030000oooooooo09Woool0
07Ooool00ol0VOooooooo`0:oooo00<0003oooooool0VOooo`00Moooo`03o`2Ioooooooo00[oool0
0`000?ooooooo`2Ioooo001goooo00?o09Woooooool02_ooo`030000oooooooo09Woool007Ooool0
0ol0VOooooooo`0:oooo0P0009[oool007Ooool00ol0VOooooooo`0:oooo00<0003oooooool0VOoo
o`00Moooo`03o`2Ioooooooo00[oool00`000?ooooooo`2Ioooo001goooo00?o09Woooooool02_oo
o`030000oooooooo09Woool007Ooool00ol0VOooooooo`0:oooo0P0009[oool007Ooool00ol0VOoo
ooooo`0:oooo00<0003oooooool0VOooo`00Moooo`03o`2Ioooooooo00[oool00`000?ooooooo`2I
oooo001goooo00?o09Woooooool02_ooo`030000oooooooo09Woool007Ooool00ol0VOooooooo`0:
oooo00<0003oooooool0VOooo`00Moooo`03o`2Ioooooooo00[oool20000V_ooo`00Moooo`03o`2I
oooooooo00[oool00`000?ooooooo`2Ioooo001goooo00?o09Woooooool00oooo`800005oooo00<0
003oooooool0VOooo`00Moooo`03o`2Ioooooooo00;oool010000?ooooooo`0000Coool00`000?oo
ooooo`2Ioooo001goooo00?o09Woooooool01?ooo`030000oooooooo00?oool30000VOooo`00Mooo
o`03o`2Ioooooooo00Goool00`000?ooooooo`02oooo00<0003oooooool0VOooo`00Moooo`03o`2I
oooooooo00;oool010000?ooooooo`0000Coool00`000?ooooooo`2Ioooo001goooo00?o09Wooooo
ool00oooo`800005oooo00<0003oooooool0VOooo`00Moooo`03o`2Ioooooooo00[oool00`000?oo
ooooo`2Ioooo001goooo00?o09Woooooool02_ooo`80002Joooo001goooo00?o09Woooooool02_oo
o`030000oooooooo09Woool007Ooool00ol0VOooooooo`0:oooo00<0003oooooool0VOooo`00Mooo
o`03o`2Ioooooooo00[oool00`000?ooooooo`2Ioooo001goooo00?o09Woooooool02_ooo`80002J
oooo001goooo00?o09Woooooool02_ooo`030000oooooooo09Woool007Ooool00ol0VOooooooo`0:
oooo00<0003oooooool0VOooo`00Moooo`03o`2Ioooooooo00[oool00`000?ooooooo`2Ioooo001g
oooo00?o09Woooooool02_ooo`030000oooooooo09Woool007Ooool00ol0VOooooooo`0:oooo0P00
09[oool007Ooool00ol0VOooooooo`0:oooo00<0003oooooool0VOooo`00Moooo`03o`2Ioooooooo
00[oool00`000?ooooooo`2Ioooo001goooo00?o09Woooooool02_ooo`030000oooooooo09Woool0
07Ooool00ol0VOooooooo`0:oooo0P0009[oool007Ooool00ol0VOooooooo`0:oooo00<0003ooooo
ool0VOooo`00Moooo`03o`2Ioooooooo00[oool00`000?ooooooo`2Ioooo001goooo00?o09Wooooo
ool01?ooo`<00003oooo00<0003oooooool0VOooo`00Moooo`03o`2Ioooooooo00Goool00`000?oo
ooooo`02oooo00<0003oooooool0VOooo`00Moooo`03o`2Ioooooooo00;oool500000oooo`<0002I
oooo001loooo00@0003oooooool0002Poooo001moooo00<0003oool00000X?ooo`00O_ooo`80002P
oooo003ooooo8Oooo`00ooooob7oool007Woool00`000?ooooooo`0Xoooo00<0003oooooool0NOoo
o`00N?ooo`030000oooooooo00Soool00`000?ooooooo`0Ooooo00<0003oooooool0N?ooo`00N?oo
o`030000oooooooo00;oool200001?ooo`030000oooooooo00coool500000_ooo`800003oooo0`00
00Coool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000000_ooo`030000oooooooo
00;oool00`000?ooooooo`04oooo100000Goool00`000?ooooooo`07oooo00@0003oooooool00003
oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo00;oool00`000?ooooooo`0Eoooo00<0
003oooooool01oooo`040000oooooooo00001?ooo`030000oooooooo07Ooool007Soool00`000?oo
ooooo`0500005?ooo`030000oooooooo00Ooool300001?ooo`030000oooooooo07Soool007Soool0
1@000?ooooooooooo`00000Goooo00<0003oooooool02?ooo`030000oooooooo00?oool00`000?oo
ooooo`1hoooo001ioooo00<0003oooooool05oooo`80000:oooo0`0000;oool00`000?ooooooo`1i
oooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-6.03535, \
-3.20105, 0.0455524, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-6.03535, -3.20105, 0.0455524, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.30316 .26487 L
.34309 .26487 L
.3815 .26487 L
.40134 .26487 L
.41134 .26487 L
.41408 .26487 L
.41703 .26487 L
.41846 .26487 L
.41982 .26487 L
.42104 .26487 L
.42173 .26487 L
s
.42173 .26487 m
.42198 .61803 L
s
0 .4 1 r
.02381 .26331 m
.04262 .26293 L
.06244 .26243 L
.08255 .2618 L
.10458 .26091 L
.12415 .2599 L
.14509 .25854 L
.16639 .25679 L
.18653 .25468 L
.22495 .24908 L
.24479 .24513 L
.26581 .23993 L
.30365 .22749 L
.34394 .20999 L
.38271 .19249 L
.39281 .18884 L
.39815 .1872 L
.40384 .18572 L
.40931 .18457 L
.41426 .18378 L
.41665 .18349 L
.41924 .18325 L
.42043 .18316 L
.42169 .18308 L
.42276 .26487 L
.42393 .26487 L
.46436 .26487 L
.50327 .26487 L
.54463 .26487 L
.58447 .26487 L
.6228 .26487 L
.66358 .26487 L
.70285 .26487 L
.7406 .26487 L
.7808 .26487 L
.81949 .26487 L
.86063 .26487 L
.90026 .26487 L
.93836 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001moooo0P000:7oool007coool010000?ooooooo`000:3oool007koool00`000?oo
ooooo`03oooo0`0009Woool007Koool400001Oooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo001loooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007coool200001_ooo`<0002I
oooo001foooo1P000004<ol00000000000001?ooo`030000oooooooo09Woool007Soool01@0003?o
03?o03?o00000002<ol00P0000?oool00`000?ooooooo`2Ioooo001goooo00<0000co`0co`000c?o
00800002<ol00P000003oooo0000oooo09[oool007Koool00`0003?o03?o000:<ol00P0009_oool0
07Goool00`0003?o03?o000<<ol00P0009[oool007Coool00`0003?o03?o000=<ol000<0003ooooo
ool0VOooo`00Loooo`030000<ol0<ol000hco`020000V_ooo`00Loooo`030000<ol0<ol000hco`00
0`0003?o0000002Ioooo001boooo00<0000co`0co`003c?o008000000c?o00000?ooo`2Goooo001b
oooo00<0000co`0co`003c?o00040000<ol0<ol00000V?ooo`00LOooo`030000<ol0<ol0010co`00
1@0003?o03?o03?o0000002Goooo001aoooo00<0000co`0co`0043?o00030000<ol0<ol0008co`00
0`000?ooooooo`2Doooo001`oooo00<0000co`0co`004C?o00030000<ol0<ol0008co`000`000?oo
ooooo`2Doooo001_oooo00<0000co`0co`004S?o00800004<ol000<0003oooooool0Toooo`00K_oo
o`030000<ol0<ol001<co`000`0003?o03?o0004<ol000<0003oooooool0T_ooo`00K_ooo`030000
<ol0<ol001<co`000`0003?o03?o0004<ol000<0003oooooool0T_ooo`00KOooo`030000<ol0<ol0
01@co`000`0003?o03?o0005<ol000<0003oooooool0TOooo`00K?ooo`030000<ol0<ol001Dco`02
00001c?o00030000oooooooo093oool006_oool00`0003?o03?o000F<ol000<0000co`0co`001S?o
00030000oooooooo093oool006_oool00`0003?o03?o000F<ol000<0000co`0co`001c?o00030000
oooooooo08ooool006[oool00`0003?o03?o000?<ol01@0000<co`000`0003?o03?o0008<ol000<0
003oooooool0S_ooo`00JOooo`030000<ol0<ol0018co`000`0003?o03?o0003<ol000<0000co`0c
o`0023?o00030000oooooooo08koool006Soool00`0003?o03?o000C<ol000<0000co`0co`000c?o
00<00009<ol000<0003oooooool0SOooo`00J?ooo`030000<ol0<ol000/co`04000000Dco`00I_lc
o`0co`0000001C?o00030000<ol0<ol000Xco`000`000?ooooooo`2<oooo001Woooo00<0000co`0c
o`003C?o00D0I_l2<ol000<0000co`0co`000c?o00030000<ol0<ol000/co`000`000?ooooooo`2;
oooo001Voooo00<0000co`0co`002S?o00@0I_l4<ol000@0I_lco`0000000005<ol000<0000co`0c
o`002c?o00030000oooooooo08_oool006Koool00`0003?o03?o0007<ol00`1Vo`Pco`000`1Voc?o
03?o0006<ol00P0000dco`000`000?ooooooo`2:oooo001Uoooo00<0000co`0co`001S?o0080I_l;
<ol000<0I_lco`0co`001S?o00030000<ol0<ol000dco`000`000?ooooooo`29oooo001Toooo00<0
000co`0co`0013?o00<0I_l=<ol000<0I_lco`0co`001S?o00030000<ol0<ol000hco`000`000?oo
ooooo`28oooo001Soooo00<0000co`0co`000c?o0080I_l@<ol000<0I_lco`0co`001S?o00030000
<ol0<ol000lco`000`000?ooooooo`27oooo001Soooo00@0000co`0co`0co`0206Ko4S?o000306Ko
<ol0<ol000Hco`000`0003?o03?o000@<ol000<0003oooooool0Q_ooo`00H_ooo`030000<ol0<ol0
0080I_lD<ol000<0I_lco`0co`001S?o0080000B<ol000<0003oooooool0QOooo`00HOooo`040000
<ol006Ko06Ko5S?o000306Ko<ol0<ol000Hco`000`0003?o03?o000B<ol000<0003oooooool0Q?oo
o`00;oooo`<0000Woooo100000;oool200000P1VoaPco`000`1Voc?o03?o0006<ol000<0000co`0c
o`004c?o00030000oooooooo017oool40000:_ooo`<0000Woooo0`0001Ooool0033oool00`000?oo
ooooo`0Voooo00<0003oooooool00_ooo`03000006Ko06Ko01Xco`000`1Voc?o03?o0006<ol000<0
000co`0co`0053?o00030000oooooooo013oool00`000?ooooooo`0/oooo00<0003oooooool09_oo
o`040000oooooooo00005_ooo`00;Oooo`D0000Xoooo00<0003oool0I_l00P1Voa`co`000`1Voc?o
03?o0006<ol00P0001Hco`0200004Oooo`030000oooooooo02Soool500009oooo`040000oooooooo
00005_ooo`009oooo`@00002oooo00@0003oooooool0000Roooo100000;oool206Ko0P0001hco`00
0`1Voc?o03?o0006<ol000<0000co`0co`005c?o00030000oooooooo00ooool00`000?ooooooo`0W
oooo00@0003oooooool0000Xoooo0`0001Ooool002koool00`000?ooo`00000Uoooo0`1Vo`800000
0c?o000003?o000M<ol000<0I_lco`0co`001S?o00030000<ol0<ol001Pco`000`000?ooooooo`0<
oooo00@0003oooooool0000Yoooo00<0003oool00000:Oooo`030000oooooooo01Koool002ooool2
00008Oooo`@0I_l2oooo100001lco`000`1Voc?o03?o0006<ol000<0000co`0co`006C?o00030000
oooooooo00coool20000:oooo`80000Yoooo0`0001Koool004coool606Ko1?ooo`80000S<ol000<0
I_lco`0co`001S?o00030000<ol0<ol001Xco`020000OOooo`00Aoooo`D0I_l8oooo0P0002Dco`00
0`1Voc?o03?o0006<ol00P0001dco`030000N_ooo`00@_ooo`D0I_l:oooo0`0002Lco`000`1Voc?o
03?o0006<ol000<0000co`0co`007c?o00H0001doooo000hoooo2P1Vo`Woool60000:S?o000306Ko
<ol0<ol000Hco`000`0003?o03?o000U<ol00`00077oool002?ooolE06Ko2Oooo`X0000`<ol000<0
I_lco`0co`001S?o00030000<ol0<ol002Pco`0:0000Ioooo`004?ooool0000Aoooo000Foooo00<0
003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?oo
o`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo
00Soool00`000?ooooooo`08oooo00<0003ooooo09T02?ooo`030000oooooooo00Soool00`000?oo
ooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0
003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?oo
o`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo
01Goool002coool00`000?ooooooo`0Yoooo00<0003oooooool08?ooo`03o`2Ioooooooo00Koool0
0`000?ooooooo`0Yoooo00<0003oooooool0:Oooo`030000oooooooo02Woool00`000?ooooooo`0E
oooo001koooo00?o09Woooooool01_ooo`030000oooooooo09Woool007_oool00ol0VOooooooo`06
oooo00<0003oooooool0VOooo`00Noooo`03o`2Ioooooooo00Koool20000V_ooo`00Noooo`03o`2I
oooooooo00Koool00`000?ooooooo`2Ioooo001koooo00?o09Woooooool01_ooo`030000oooooooo
09Woool007_oool00ol0VOooooooo`06oooo00<0003oooooool0VOooo`00Noooo`03o`2Ioooooooo
00Koool20000V_ooo`00Noooo`03o`2Ioooooooo00Koool00`000?ooooooo`2Ioooo001koooo00?o
09Woooooool01_ooo`030000oooooooo09Woool007_oool00ol0VOooooooo`06oooo00<0003ooooo
ool0VOooo`00Noooo`03o`2Ioooooooo00Koool00`000?ooooooo`2Ioooo001koooo00?o09Wooooo
ool01_ooo`80002Joooo001koooo00?o09Woooooool01_ooo`030000oooooooo09Woool007_oool0
0ol0VOooooooo`06oooo00<0003oooooool0VOooo`00Noooo`03o`2Ioooooooo00Koool00`000?oo
ooooo`2Ioooo001koooo00?o09Woooooool01_ooo`80002Joooo001koooo00?o09Woooooool01_oo
o`030000oooooooo09Woool007_oool00ol0VOooooooo`06oooo00<0003oooooool0VOooo`00Nooo
o`03o`2I0000000000<00003oooo00<0003oooooool0VOooo`00Noooo`04o`2Ioooooooo00001Ooo
o`030000oooooooo09Woool007_oool01?l0VOooooooo`0000Goool30000VOooo`00Noooo`04o`2I
oooooooo00001Oooo`030000oooooooo09Woool007_oool01?l0VOooooooo`0000Goool00`000?oo
ooooo`2Ioooo001koooo00Co09Woool000000005oooo00<0003oooooool0VOooo`00Noooo`03o`2I
oooooooo00Koool20000V_ooo`00Noooo`03o`2Ioooooooo00Koool00`000?ooooooo`2Ioooo001k
oooo00?o09Woooooool01_ooo`030000oooooooo09Woool007_oool00ol0VOooooooo`06oooo00<0
003oooooool0VOooo`00Noooo`03o`2Ioooooooo00Koool00`000?ooooooo`2Ioooo001koooo00?o
09Woooooool01_ooo`80002Joooo001koooo00?o09Woooooool01_ooo`030000oooooooo09Woool0
07_oool00ol0VOooooooo`06oooo00<0003oooooool0VOooo`00Noooo`03o`2Ioooooooo00Koool0
0`000?ooooooo`2Ioooo001koooo00?o09Woooooool01_ooo`80002Joooo001koooo00?o09Wooooo
ool01_ooo`030000oooooooo09Woool007_oool00ol0VOooooooo`06oooo00<0003oooooool0VOoo
o`00Noooo`03o`2Ioooooooo00Koool00`000?ooooooo`2Ioooo001koooo00?o09Woooooool01_oo
o`030000oooooooo09Woool007_oool00ol0VOooooooo`06oooo0P0009[oool007_oool00ol0VOoo
ooooo`06oooo00<0003oooooool0VOooo`00Noooo`03o`2I0000000000800004oooo00<0003ooooo
ool0VOooo`00Noooo`03o`2I0000oooo00Koool00`000?ooooooo`2Ioooo001koooo00?o09Woool0
00001_ooo`<0002Ioooo001koooo00Co09Woooooool00005oooo00<0003oooooool0VOooo`00Nooo
o`05o`2I0000oooooooo000000Coool00`000?ooooooo`2Ioooo001koooo00Co09Woool000000005
oooo00<0003oooooool0VOooo`00Noooo`03o`2Ioooooooo00Koool20000V_ooo`00Noooo`03o`2I
oooooooo00Koool00`000?ooooooo`2Ioooo001koooo00?o09Woooooool01_ooo`030000oooooooo
09Woool007_oool00ol0VOooooooo`06oooo00<0003oooooool0VOooo`00Noooo`03o`2Ioooooooo
00Koool00`000?ooooooo`2Ioooo001koooo00?o09Woooooool01_ooo`80002Joooo001koooo00?o
09Woooooool01_ooo`030000oooooooo09Woool007_oool00ol0VOooooooo`06oooo00<0003ooooo
ool0VOooo`00Noooo`03o`2Ioooooooo00Koool00`000?ooooooo`2Ioooo001koooo00?o09Wooooo
ool01_ooo`80002Joooo001koooo00?o09Woooooool01_ooo`030000oooooooo09Woool007_oool0
0ol0VOooooooo`06oooo00<0003oooooool0VOooo`00Noooo`03o`2Ioooooooo00Koool00`000?oo
ooooo`2Ioooo001koooo00?o09Woooooool01_ooo`030000oooooooo09Woool007_oool00ol0VOoo
ooooo`06oooo0P0009[oool007_oool00ol0VOooooooo`06oooo00<0003oooooool0VOooo`00Nooo
o`04o`2Ioooo000000001Oooo`030000oooooooo09Woool007_oool01Ol0V@000?ooooooo`000004
oooo00<0003oooooool0VOooo`00Noooo`04o`2Ioooooooo00001Oooo`<0002Ioooo001koooo00Go
09Woooooooooool000001?ooo`030000oooooooo09Woool007_oool01Ol0V@000?ooooooo`000004
oooo00<0003oooooool0VOooo`00Noooo`04o`2Ioooo000000001Oooo`030000oooooooo09Woool0
07_oool00ol0VOooooooo`06oooo00<0003oooooool0VOooo`00Noooo`03o`2Ioooooooo00Koool2
0000V_ooo`00Noooo`03o`2Ioooooooo00Koool00`000?ooooooo`2Ioooo001koooo00?o09Wooooo
ool01_ooo`030000oooooooo09Woool007_oool00ol0VOooooooo`06oooo00<0003oooooool0VOoo
o`00Noooo`03o`2Ioooooooo00Koool20000V_ooo`00Noooo`03o`2Ioooooooo00Koool00`000?oo
ooooo`2Ioooo001koooo00?o09Woooooool01_ooo`030000oooooooo09Woool007_oool00ol0VOoo
ooooo`06oooo00<0003oooooool0VOooo`00Noooo`03o`2Ioooooooo00Koool00`000?ooooooo`2I
oooo001koooo00?o09Woooooool01_ooo`80002Joooo001koooo00?o09Woooooool01_ooo`030000
oooooooo09Woool007_oool00ol0VOooooooo`06oooo00<0003oooooool0VOooo`00Noooo`03o`2I
oooooooo00Koool00`000?ooooooo`2Ioooo001koooo00?o09Woooooool01_ooo`80002Joooo001k
oooo00?o09Woooooool01_ooo`030000oooooooo09Woool007_oool00ol0VOooooooo`06oooo00<0
003oooooool0VOooo`00Noooo`03o`2Ioooooooo00<00003oooo00<0003oooooool0VOooo`00Nooo
o`05o`2Ioooooooooooo000000Coool00`000?ooooooo`2Ioooo001koooo00?o09T0000000000`00
00?oool30000VOooo`00O?ooo`040000oooooooo0000X?ooo`00OOooo`030000oooo00000:3oool0
07koool20000X?ooo`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000
oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo
07Soool007Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool2
00001Oooo`<00002oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool0
0`000?ooooooo`02oooo00<0003oooooool01?ooo`@00005oooo00<0003oooooool02_ooo`050000
oooooooooooo000007[oool007Ooool00`000?ooooooo`02oooo00<0003oooooool05Oooo`030000
oooooooo00Ooool500000oooo`030000oooooooo07Ooool007Soool00`000?ooooooo`0500005?oo
o`030000oooooooo00Ooool010000?ooooooo`0000?oool00`000?ooooooo`1hoooo001hoooo00D0
003oooooooooool000005oooo`030000oooooooo00Soool00`000?ooo`000003oooo00<0003ooooo
ool0N?ooo`00NOooo`030000oooooooo01Ooool200002oooo`800002oooo00<0003oooooool0NOoo
o`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-6.03535, \
-3.20105, 0.0455524, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-6.03535, -3.20105, 0.0455524, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.30316 .26487 L
.34309 .26487 L
.3815 .26487 L
.40095 .26487 L
.41127 .26487 L
.42237 .26487 L
.42781 .26487 L
.43298 .26487 L
.43522 .26487 L
.43762 .26487 L
.43833 .26487 L
.43899 .26487 L
s
.43899 .26487 m
.43949 .61803 L
s
0 .4 1 r
.02381 .26363 m
.04262 .26333 L
.06244 .26294 L
.08255 .26243 L
.10458 .26173 L
.12415 .26093 L
.14509 .25986 L
.16639 .25846 L
.18653 .2568 L
.22495 .25236 L
.24479 .24922 L
.26581 .2451 L
.30365 .23524 L
.34394 .22137 L
.38271 .2075 L
.39281 .20461 L
.39815 .20331 L
.40384 .20213 L
.40931 .20122 L
.41426 .2006 L
.41665 .20037 L
.41924 .20017 L
.42043 .2001 L
.42169 .20004 L
.42276 .2 L
.42393 .19996 L
.42524 .19994 L
.42644 .19993 L
.42707 .19993 L
.42777 .19994 L
.42849 .19994 L
.42917 .19996 L
.43042 .19999 L
.43156 .20003 L
.43282 .20009 L
.43414 .20017 L
.43629 .20033 L
.43747 .20043 L
.43858 .20054 L
.4399 .26487 L
.4411 .26487 L
.44344 .26487 L
.46436 .26487 L
.50282 .26487 L
.54374 .26487 L
.58315 .26487 L
.62103 .26487 L
.66137 .26487 L
.7002 .26487 L
.74147 .26487 L
Mistroke
.78123 .26487 L
.81948 .26487 L
.86018 .26487 L
.89936 .26487 L
.94099 .26487 L
.97619 .26487 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001moooo0P000:7oool007coool010000?ooooooo`000:3oool007koool00`000?oo
ooooo`03oooo0`0009Woool007Koool400001Oooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo001loooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007coool200001_ooo`<0002I
oooo001foooo1P000004<ol00000000000001?ooo`030000oooooooo09Woool007Soool01@0003?o
03?o03?o00000002<ol00P0000?oool00`000?ooooooo`2Ioooo001goooo00<0000co`0co`000c?o
00800002<ol00P000003oooo0000oooo09[oool007Koool00`0003?o03?o000:<ol00P0009_oool0
07Goool00`0003?o03?o000<<ol00P0009[oool007Coool00`0003?o03?o000=<ol000<0003ooooo
ool0VOooo`00Loooo`030000<ol0<ol000hco`020000V_ooo`00Loooo`030000<ol0<ol000hco`00
0`0003?o0000002Ioooo001boooo00<0000co`0co`003c?o008000000c?o00000?ooo`2Goooo001b
oooo00<0000co`0co`003c?o00040000<ol0<ol00000V?ooo`00LOooo`030000<ol0<ol0010co`00
1@0003?o03?o03?o0000002Goooo001aoooo00<0000co`0co`0043?o00030000<ol0<ol0008co`00
0`000?ooooooo`2Doooo001`oooo00<0000co`0co`004C?o00030000<ol0<ol0008co`000`000?oo
ooooo`2Doooo001_oooo00<0000co`0co`004S?o00800004<ol000<0003oooooool0Toooo`00K_oo
o`030000<ol0<ol001<co`000`0003?o03?o0004<ol000<0003oooooool0T_ooo`00K_ooo`030000
<ol0<ol001<co`000`0003?o03?o0004<ol000<0003oooooool0T_ooo`00KOooo`030000<ol0<ol0
01@co`000`0003?o03?o0005<ol000<0003oooooool0TOooo`00K?ooo`030000<ol0<ol001Dco`02
00001c?o00030000oooooooo093oool006_oool00`0003?o03?o000F<ol000<0000co`0co`001S?o
00030000oooooooo093oool006_oool00`0003?o03?o000F<ol000<0000co`0co`001c?o00030000
oooooooo08ooool006[oool00`0003?o03?o000?<ol01@0000<co`000`0003?o03?o0008<ol000<0
003oooooool0S_ooo`00JOooo`030000<ol0<ol0018co`000`0003?o03?o0003<ol000<0000co`0c
o`0023?o00030000oooooooo08koool006Soool00`0003?o03?o000C<ol000<0000co`0co`000c?o
00<00009<ol000<0003oooooool0SOooo`00J?ooo`030000<ol0<ol000/co`04000013?o00030000
<ol0<ol000<co`000`0003?o03?o000:<ol000<0003oooooool0S?ooo`00Ioooo`030000<ol0<ol0
01@co`000`0003?o03?o0003<ol000<0000co`0co`002c?o00030000oooooooo08_oool006Koool0
0`0003?o03?o000D<ol00P0000Dco`000`0003?o03?o000;<ol000<0003oooooool0Roooo`00I_oo
o`030000<ol0<ol001/co`0200003C?o00030000oooooooo08[oool006Goool00`0003?o03?o000L
<ol000<0000co`0co`003C?o00030000oooooooo08Woool006Coool00`0003?o03?o000@<ol02@1V
o`@co`000`0003?o03?o000><ol000<0003oooooool0R?ooo`00Hoooo`030000<ol0<ol000dco`04
06Ko23?o000306Ko<ol0<ol0008co`000`0003?o03?o000?<ol000<0003oooooool0Qoooo`00Hooo
o`030000<ol0<ol000Xco`0306Ko33?o000306Ko<ol0<ol0008co`000`0003?o03?o000@<ol000<0
003oooooool0Q_ooo`00H_ooo`030000<ol0<ol000Pco`0306Ko3c?o000306Ko<ol0<ol0008co`02
00004S?o00030000oooooooo08Goool0067oool00`0003?o03?o0005<ol0101Voa8co`000`1Voc?o
03?o0002<ol000<0000co`0co`004S?o00030000oooooooo08Coool002ooool300009oooo`@00002
oooo0P0000Dco`0306Ko5S?o000306Ko<ol0<ol0008co`000`0003?o03?o000C<ol000<0003ooooo
ool04Oooo`@0000Zoooo0`0002Ooool300005oooo`00<?ooo`030000oooooooo02Koool00`000?oo
ooooo`02oooo00<0000co`0co`000c?o0080I_lI<ol000<0I_lco`0co`000S?o00030000<ol0<ol0
01@co`000`000?ooooooo`0@oooo00<0003oooooool0;?ooo`030000oooooooo02Koool010000?oo
ooooo`0001Koool002goool50000:?ooo`040000oooooooo00000c?o00<0I_lK<ol000<0I_lco`0c
o`000S?o0080000F<ol00P00017oool00`000?ooooooo`0Xoooo1@0002Ooool010000?ooooooo`00
01Koool002Ooool400000_ooo`040000oooooooo00008_ooo`@00004oooo0P00008co`0206Ko7S?o
000306Ko<ol0<ol0008co`000`0003?o03?o000G<ol000<0003oooooool03oooo`030000oooooooo
02Ooool010000?ooooooo`0002Soool300005oooo`00;_ooo`030000oooo000002Soool2000000@0
I_l00000I_l0I_lQ<ol000D0I_lco`0co`0co`0000006S?o00030000oooooooo00coool010000?oo
ooooo`0002Woool00`000?ooo`00000Yoooo00<0003oooooool05_ooo`00;oooo`80000Voooo0`1V
o`80000T<ol000D0I_lco`0co`0co`0000006c?o00030000oooooooo00coool20000:oooo`80000Y
oooo0`0001Koool005;oool506Ko00<0000co`0co`009S?o000506Ko<ol0<ol0<ol0000001`co`02
0000OOooo`00C?ooo`H0I_l2oooo0P0002Xco`00101Voc?o03?o03?o0080000M<ol00`0007[oool0
04Goool706Ko1Oooo`<0000/<ol000D0I_lco`0co`0co`0000008C?o00H0001doooo000moooo201V
o`Koool60000;c?o000506Ko<ol0<ol0<ol0000002Lco`030000LOooo`00:Ooooa@0I_l4oooo2P00
03Dco`001@1Voc?o03?o03?o0000000Z<ol02P0006Ooool0013ooooo00004Oooo`005_ooo`030000
oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool0
0`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08
oooo00<0003oooooool02?ooo`030000oooooooo00Coool01Ol0VOooooooooooo`00000:oooo00<0
003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?oo
o`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo
00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?oo
ooooo`0Eoooo000/oooo00<0003oooooool0:Oooo`030000oooooooo02Goool01Ol0VOoooooooooo
o`00000[oooo00<0003oooooool0:Oooo`030000oooooooo02Woool00`000?ooooooo`0Eoooo0020
oooo00Go09Woooooooooool00000Voooo`00P?ooo`05o`2Ioooooooooooo000009_oool0083oool0
1?l0VOooooooooooo`80002Joooo0020oooo00Go09Woooooooooool00000Voooo`00P?ooo`05o`2I
oooooooooooo000009_oool0083oool01Ol0VOooooooooooo`00002Koooo0020oooo00Co09Wooooo
ooooool20000V_ooo`00P?ooo`05o`2Ioooooooooooo000009_oool0083oool01Ol0VOoooooooooo
o`00002Koooo0020oooo00Go09Woooooooooool00000Voooo`00P?ooo`05o`2Ioooooooooooo0000
09_oool0083oool01?l0VOooooooooooo`80002Joooo0020oooo00Go09Woooooooooool00000Vooo
o`00P?ooo`05o`2Ioooooooooooo000009_oool0083oool01Ol0VOooooooooooo`00002Koooo0020
oooo00Co09Woooooooooool20000V_ooo`00P?ooo`05o`2Ioooooooooooo000009_oool0083oool0
1Ol0VOooooooooooo`00002Koooo001loooo1@0000?oool00`000?ooooooo`2Ioooo001noooo00<0
003ooooo09T00oooo`030000oooooooo09Woool007koool00`000?ooool0V@03oooo0`0009Woool0
07koool00`000?ooool0V@03oooo00<0003oooooool0VOooo`00O_ooo`030000ooooo`2I00?oool0
0`000?ooooooo`2Ioooo001moooo0P000003ooooo`2Ioooo00;oool00`000?ooooooo`2Ioooo0020
oooo00Co09Woooooooooool20000V_ooo`00P?ooo`05o`2Ioooooooooooo000009_oool0083oool0
1Ol0VOooooooooooo`00002Koooo0020oooo00Go09Woooooooooool00000Voooo`00P?ooo`05o`2I
oooooooooooo000009_oool0083oool01?l0VOooooooooooo`80002Joooo0020oooo00Go09Wooooo
ooooool00000Voooo`00P?ooo`05o`2Ioooooooooooo000009_oool0083oool01Ol0VOoooooooooo
o`00002Koooo0020oooo00Co09Woooooooooool20000V_ooo`00P?ooo`05o`2Ioooooooooooo0000
09_oool0083oool01Ol0VOooooooooooo`00002Koooo0020oooo00Go09Woooooooooool00000Vooo
o`00P?ooo`05o`2Ioooooooooooo000009_oool0083oool01?l0VOooooooooooo`80002Joooo0020
oooo00Go09Woooooooooool00000Voooo`00O?ooo`@000001Ol0VOooooooooooo`00002Koooo001l
oooo00D0003ooooooooooooo09T00oooo`030000oooooooo09Woool007goool010000?ooooooool0
V@?oool30000VOooo`00O_ooo`030000ooooo`2I00?oool00`000?ooooooo`2Ioooo001loooo00D0
003oooooool0003o09T00oooo`030000oooooooo09Woool007goool2000000?ooooo09Woool00_oo
o`030000oooooooo09Woool0083oool01?l0VOooooooooooo`80002Joooo0020oooo00Go09Wooooo
ooooool00000Voooo`00P?ooo`05o`2Ioooooooooooo000009_oool0083oool01Ol0VOoooooooooo
o`00002Koooo0020oooo00Go09Woooooooooool00000Voooo`00P?ooo`04o`2Ioooooooooooo0P00
09[oool0083oool01Ol0VOooooooooooo`00002Koooo0020oooo00Go09Woooooooooool00000Vooo
o`00P?ooo`05o`2Ioooooooooooo000009_oool0083oool01?l0VOooooooooooo`80002Joooo0020
oooo00Go09Woooooooooool00000Voooo`00P?ooo`05o`2Ioooooooooooo000009_oool0083oool0
1Ol0VOooooooooooo`00002Koooo0020oooo00Go09Woooooooooool00000Voooo`00P?ooo`04o`2I
oooooooooooo0P0009[oool0083oool01Ol0VOooooooooooo`00002Koooo001moooo0P000003oooo
o`2Ioooo00;oool00`000?ooooooo`2Ioooo001loooo00D0003oooooool0003o09T00oooo`030000
oooooooo09Woool007koool00`000?ooool0V@03oooo0`0009Woool007ooool00`000?l0VOooo`02
oooo00<0003oooooool0VOooo`00O?ooo`050000oooooooo0000o`2I00?oool00`000?ooooooo`2I
oooo001moooo0P000003ooooo`2Ioooo00;oool00`000?ooooooo`2Ioooo0020oooo00Go09Wooooo
ooooool00000Voooo`00P?ooo`04o`2Ioooooooooooo0P0009[oool0083oool01Ol0VOoooooooooo
o`00002Koooo0020oooo00Go09Woooooooooool00000Voooo`00P?ooo`05o`2Ioooooooooooo0000
09_oool0083oool01?l0VOooooooooooo`80002Joooo0020oooo00Go09Woooooooooool00000Vooo
o`00P?ooo`05o`2Ioooooooooooo000009_oool0083oool01Ol0VOooooooooooo`00002Koooo0020
oooo00Go09Woooooooooool00000Voooo`00P?ooo`04o`2Ioooooooooooo0P0009[oool0083oool0
1Ol0VOooooooooooo`00002Koooo0020oooo00Go09Woooooooooool00000Voooo`00P?ooo`05o`2I
oooooooooooo000009_oool0083oool01?l0VOooooooooooo`80002Joooo0020oooo00Go09Wooooo
ooooool00000Voooo`00P?ooo`05o`2Ioooooooooooo000009_oool007koool300000oooo`030000
oooooooo09Woool007ooool00`000?l0VOooo`02oooo00<0003oooooool0VOooo`00O?ooo`D00003
oooo0`0009Woool007coool010000?ooooooo`000:3oool007goool00`000?ooo`00002Poooo001n
oooo0P000:3oool00?oooolQoooo003ooooo8Oooo`00NOooo`030000oooooooo02Soool00`000?oo
ooooo`1ioooo001hoooo00<0003oooooool02?ooo`030000oooooooo01ooool00`000?ooooooo`1h
oooo001hoooo00<0003oooooool00_ooo`800004oooo00<0003oooooool03?ooo`D00002oooo0P00
00?oool400000oooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`000002oooo00<0
003oooooool00_ooo`030000oooooooo00Coool400001Oooo`030000oooooooo00Ooool00`000?oo
ooooo`04oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo00;oool00`000?ooooooo`0E
oooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?ooooooo`1goooo001hoooo00<0
003oooooool01@0001Coool00`000?ooooooo`09oooo00<0003oooooool00_ooo`030000oooooooo
07Soool007Soool01@000?ooooooooooo`00000Goooo00<0003oooooool01oooo`040000oooooooo
00000oooo`030000oooooooo07Soool007Woool00`000?ooooooo`0Goooo0P0000[oool200000ooo
o`030000oooooooo07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-6.03535, \
-3.20105, 0.0455524, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-6.03535, -3.20105, 0.0455524, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.30316 .26487 L
.34309 .26487 L
.3815 .26487 L
.40095 .26487 L
.42237 .26487 L
.43215 .26487 L
.44268 .26487 L
.44778 .26487 L
.45029 .26487 L
.45262 .26487 L
.45473 .26487 L
.4559 .26487 L
s
.4559 .26487 m
.45633 .61803 L
s
0 .4 1 r
.02381 .26391 m
.04262 .26367 L
.06244 .26337 L
.08255 .26297 L
.10458 .26242 L
.12415 .2618 L
.14509 .26097 L
.16639 .25988 L
.18653 .25858 L
.22495 .25513 L
.24479 .25269 L
.26581 .24948 L
.30365 .2418 L
.34394 .231 L
.38271 .2202 L
.39281 .21795 L
.39815 .21694 L
.40384 .21602 L
.40931 .21531 L
.41426 .21483 L
.41665 .21465 L
.41924 .2145 L
.42043 .21444 L
.42169 .2144 L
.42276 .21436 L
.42393 .21434 L
.42524 .21432 L
.42644 .21431 L
.42707 .21431 L
.42777 .21432 L
.42849 .21432 L
.42917 .21433 L
.43042 .21436 L
.43156 .21439 L
.43282 .21444 L
.43414 .2145 L
.43858 .21478 L
.4411 .215 L
.44344 .21524 L
.44864 .21589 L
.45356 .21665 L
.45487 .21687 L
.4556 .217 L
.45627 .21712 L
.457 .26487 L
.4578 .26487 L
.45922 .26487 L
.46436 .26487 L
.50318 .26487 L
.54446 .26487 L
Mistroke
.58422 .26487 L
.62246 .26487 L
.66316 .26487 L
.70234 .26487 L
.74398 .26487 L
.7841 .26487 L
.8227 .26487 L
.86376 .26487 L
.9033 .26487 L
.94132 .26487 L
.97619 .26487 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001moooo0P000:7oool007coool010000?ooooooo`000:3oool007koool00`000?oo
ooooo`03oooo0`0009Woool007Koool400001Oooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo001loooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007coool200001_ooo`<0002I
oooo001foooo1P000004<ol00000000000001?ooo`030000oooooooo09Woool007Soool01@0003?o
03?o03?o00000002<ol00P0000?oool00`000?ooooooo`2Ioooo001goooo00<0000co`0co`000c?o
00800002<ol00P000003oooo0000oooo09[oool007Koool00`0003?o03?o000:<ol00P0009_oool0
07Goool00`0003?o03?o000<<ol00P0009[oool007Coool00`0003?o03?o000=<ol000<0003ooooo
ool0VOooo`00Loooo`030000<ol0<ol000hco`020000V_ooo`00Loooo`030000<ol0<ol000hco`00
0`0003?o0000002Ioooo001boooo00<0000co`0co`003c?o008000000c?o00000?ooo`2Goooo001b
oooo00<0000co`0co`003c?o00040000<ol0<ol00000V?ooo`00LOooo`030000<ol0<ol0010co`00
1@0003?o03?o03?o0000002Goooo001aoooo00<0000co`0co`0043?o00030000<ol0<ol0008co`00
0`000?ooooooo`2Doooo001`oooo00<0000co`0co`004C?o00030000<ol0<ol0008co`000`000?oo
ooooo`2Doooo001_oooo00<0000co`0co`004S?o00800004<ol000<0003oooooool0Toooo`00K_oo
o`030000<ol0<ol001<co`000`0003?o03?o0004<ol000<0003oooooool0T_ooo`00K_ooo`030000
<ol0<ol001<co`000`0003?o03?o0004<ol000<0003oooooool0T_ooo`00KOooo`030000<ol0<ol0
01@co`000`0003?o03?o0005<ol000<0003oooooool0TOooo`00K?ooo`030000<ol0<ol001Dco`02
00001c?o00030000oooooooo093oool006_oool00`0003?o03?o000F<ol000<0000co`0co`001S?o
00030000oooooooo093oool006_oool00`0003?o03?o000F<ol000<0000co`0co`001c?o00030000
oooooooo08ooool006[oool00`0003?o03?o000?<ol01@0000<co`000`0003?o03?o0008<ol000<0
003oooooool0S_ooo`00JOooo`030000<ol0<ol0018co`000`0003?o03?o0003<ol000<0000co`0c
o`0023?o00030000oooooooo08koool006Soool00`0003?o03?o000C<ol000<0000co`0co`000c?o
00<00009<ol000<0003oooooool0SOooo`00J?ooo`030000<ol0<ol000/co`04000013?o00030000
<ol0<ol000<co`000`0003?o03?o000:<ol000<0003oooooool0S?ooo`00Ioooo`030000<ol0<ol0
01@co`000`0003?o03?o0003<ol000<0000co`0co`002c?o00030000oooooooo08_oool006Koool0
0`0003?o03?o000D<ol00P0000Dco`000`0003?o03?o000;<ol000<0003oooooool0Roooo`00I_oo
o`030000<ol0<ol001/co`0200003C?o00030000oooooooo08[oool006Goool00`0003?o03?o000L
<ol000<0000co`0co`003C?o00030000oooooooo08Woool006Coool00`0003?o03?o000M<ol000<0
000co`0co`003S?o00030000oooooooo08Soool006?oool00`0003?o03?o000N<ol000<0000co`0c
o`003c?o00030000oooooooo08Ooool006?oool00`0003?o03?o000N<ol000<0000co`0co`0043?o
00030000oooooooo08Koool006;oool00`0003?o03?o000E<ol01@1Vo`Dco`0200004S?o00030000
oooooooo08Goool0067oool00`0003?o03?o000?<ol01`1Vo`Dco`0506Ko00<0000co`0co`004S?o
00030000oooooooo08Coool002ooool300009oooo`@00002oooo0P0000lco`0306Ko4C?o00030000
<ol0<ol001<co`000`000?ooooooo`0Aoooo100002[oool300009oooo`<0000Goooo000`oooo00<0
003oooooool09_ooo`030000oooooooo00;oool00`0003?o03?o000<<ol00`1Voa@co`000`0003?o
03?o000D<ol000<0003oooooool04?ooo`030000oooooooo02coool00`000?ooooooo`0Voooo00@0
003oooooool0000Foooo000]oooo1@0002Soool010000?ooooooo`0000/co`0406Ko5c?o0080000F
<ol00P00017oool00`000?ooooooo`0Xoooo1@0002Ooool010000?ooooooo`0001Koool002Ooool4
00000_ooo`040000oooooooo00008_ooo`@00004oooo0P0000Pco`0406Ko6c?o00030000<ol0<ol0
01Lco`000`000?ooooooo`0?oooo00<0003oooooool09oooo`040000oooooooo0000:?ooo`<0000G
oooo000^oooo00<0003oool00000:?ooo`8000000c?o000003?o0002<ol01@1Voalco`000`0003?o
03?o000H<ol000<0003oooooool03?ooo`040000oooooooo0000:Oooo`030000oooo000002Woool0
0`000?ooooooo`0Foooo000_oooo0P0002Ooool40000101Vob@co`000`0003?o03?o000I<ol000<0
003oooooool03?ooo`80000[oooo0P0002Woool300005_ooo`00E_ooo`03000006Ko06Ko0080I_lY
<ol000<0000co`0co`006S?o0080001moooo001Boooo1@1Vobdco`0200007C?o00<0001joooo001<
oooo1P1Vo`80000`<ol000<0000co`0co`007c?o00H0001doooo0015oooo1`1Vo`D0000c<ol000<0
000co`0co`009C?o00<0001aoooo000^oooo5`1Vo`H0000i<ol000<0000co`0co`00:3?o00X0001W
oooo000@ooooo`00017oool001Koool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000
oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool0
0`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08
oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003ooooo
ool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000
oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool0
0`000?ooooooo`08oooo00<0003oooooool05Oooo`00;?ooo`030000oooooooo02Woool00`000?oo
ooooo`0Yoooo00<0003oooooool0:Oooo`030000oooooooo02Woool00`000?ooooooo`0Yoooo00<0
003oooooool05Oooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool0
08Coool20000V_ooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo00<0003oooooool0VOooo`00Q?ooo`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`030000oooooooo09Woool007coool500000oooo`030000oooooooo09Woool007koool00`000?oo
ooooo`03oooo00<0003oooooool0VOooo`00O_ooo`030000oooooooo00?oool30000VOooo`00O_oo
o`030000oooooooo00?oool00`000?ooooooo`2Ioooo001noooo00<0003oooooool00oooo`030000
oooooooo09Woool007goool200001Oooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?oo
o`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOoo
o`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000oooooooo09Woool0
08Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?ooo`80002Joooo0024
oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2I
oooo0024oooo00<0003oooooool0VOooo`00Q?ooo`80002Joooo0024oooo00<0003oooooool0VOoo
o`00O?ooo`@00004oooo00<0003oooooool0VOooo`00O?ooo`030000oooooooo00Goool00`000?oo
ooooo`2Ioooo001moooo00<0003oooooool01?ooo`<0002Ioooo001noooo00<0003oooooool00ooo
o`030000oooooooo09Woool007coool010000?ooooooo`0000Coool00`000?ooooooo`2Ioooo001m
oooo0P0000Goool00`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2I
oooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?oo
ooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003ooooo
ool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000oooooooo
09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000
oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000oooooooo09Woool007goool200001Ooo
o`030000oooooooo09Woool007coool010000?ooooooo`0000Coool00`000?ooooooo`2Ioooo001n
oooo00<0003oooooool00oooo`<0002Ioooo001ooooo00<0003oooooool00_ooo`030000oooooooo
09Woool007coool010000?ooooooo`0000Coool00`000?ooooooo`2Ioooo001moooo0P0000Goool0
0`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?ooo`80002Joooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool0
0`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool0
08Coool20000V_ooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo001n
oooo0`0000?oool00`000?ooooooo`2Ioooo001ooooo00<0003oooooool00_ooo`030000oooooooo
09Woool007coool500000oooo`<0002Ioooo001loooo00@0003oooooool0002Poooo001moooo00<0
003oool00000X?ooo`00O_ooo`80002Poooo003ooooo8Oooo`00ooooob7oool007coool00`000?oo
ooooo`0Roooo00<0003oooooool0O?ooo`00Noooo`030000oooooooo00Soool00`000?ooooooo`0I
oooo00<0003oooooool0Noooo`00Noooo`030000oooooooo00;oool200001?ooo`030000oooooooo
00coool500000_ooo`800004oooo00<0003oooooool0Noooo`00Noooo`050000oooooooooooo0000
00;oool00`000?ooooooo`02oooo00<0003oooooool01?ooo`@00005oooo00<0003oooooool02?oo
o`030000oooooooo07_oool007[oool00`000?ooooooo`02oooo00<0003oooooool05Oooo`030000
oooooooo00Woool00`000?ooooooo`1joooo001koooo00<0003oooooool01@0001Coool00`000?oo
ooooo`08oooo00<0003oooooool0Noooo`00Noooo`050000oooooooooooo000001Ooool00`000?oo
ooooo`08oooo00<0003oooooool0Noooo`00O?ooo`030000oooooooo01Ooool200002Oooo`030000
oooooooo07coool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-6.03535, \
-3.20105, 0.0455524, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-6.03535, -3.20105, 0.0455524, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.30316 .26487 L
.34309 .26487 L
.3815 .26487 L
.42237 .26487 L
.44268 .26487 L
.45262 .26487 L
.46172 .26487 L
.46618 .26487 L
.46854 .26487 L
.47106 .26487 L
.47231 .26487 L
.47348 .26487 L
s
.47348 .26487 m
.4739 .61803 L
s
0 .4 1 r
.02381 .26414 m
.04262 .26397 L
.06244 .26373 L
.08255 .26344 L
.10458 .26302 L
.12415 .26255 L
.14509 .26192 L
.16639 .2611 L
.18653 .26012 L
.22495 .25751 L
.24479 .25566 L
.26581 .25324 L
.30365 .24744 L
.34394 .23928 L
.38271 .23112 L
.39281 .22941 L
.39815 .22865 L
.40384 .22796 L
.40931 .22742 L
.41426 .22705 L
.41665 .22692 L
.41924 .2268 L
.42043 .22676 L
.42169 .22673 L
.42276 .2267 L
.42393 .22668 L
.42524 .22667 L
.42644 .22666 L
.42707 .22666 L
.42777 .22667 L
.42849 .22667 L
.42917 .22668 L
.43042 .2267 L
.43156 .22672 L
.43282 .22676 L
.43414 .2268 L
.43858 .22702 L
.4411 .22719 L
.44344 .22737 L
.45356 .22843 L
.45918 .2292 L
.46436 .23001 L
.46933 .23087 L
.47184 .23133 L
.47253 .23145 L
.47327 .23159 L
.47396 .23172 L
.4746 .26487 L
.47529 .26487 L
.47601 .26487 L
Mistroke
.47733 .26487 L
.4803 .26487 L
.4857 .26487 L
.50586 .26487 L
.54749 .26487 L
.58761 .26487 L
.62621 .26487 L
.66727 .26487 L
.70681 .26487 L
.74483 .26487 L
.78531 .26487 L
.82427 .26487 L
.86568 .26487 L
.90558 .26487 L
.94396 .26487 L
.97619 .26487 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001moooo0P000:7oool007coool010000?ooooooo`000:3oool007koool00`000?oo
ooooo`03oooo0`0009Woool007Koool400001Oooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo001loooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007coool200001_ooo`<0002I
oooo001foooo1P000004<ol00000000000001?ooo`030000oooooooo09Woool007Soool01@0003?o
03?o03?o00000002<ol00P0000?oool00`000?ooooooo`2Ioooo001goooo00<0000co`0co`000c?o
00800002<ol00P000003oooo0000oooo09[oool007Koool00`0003?o03?o000:<ol00P0009_oool0
07Goool00`0003?o03?o000<<ol00P0009[oool007Coool00`0003?o03?o000=<ol000<0003ooooo
ool0VOooo`00Loooo`030000<ol0<ol000hco`020000V_ooo`00Loooo`030000<ol0<ol000hco`00
0`0003?o0000002Ioooo001boooo00<0000co`0co`003c?o008000000c?o00000?ooo`2Goooo001b
oooo00<0000co`0co`003c?o00040000<ol0<ol00000V?ooo`00LOooo`030000<ol0<ol0010co`00
1@0003?o03?o03?o0000002Goooo001aoooo00<0000co`0co`0043?o00030000<ol0<ol0008co`00
0`000?ooooooo`2Doooo001`oooo00<0000co`0co`004C?o00030000<ol0<ol0008co`000`000?oo
ooooo`2Doooo001_oooo00<0000co`0co`004S?o00800004<ol000<0003oooooool0Toooo`00K_oo
o`030000<ol0<ol001<co`000`0003?o03?o0004<ol000<0003oooooool0T_ooo`00K_ooo`030000
<ol0<ol001<co`000`0003?o03?o0004<ol000<0003oooooool0T_ooo`00KOooo`030000<ol0<ol0
01@co`000`0003?o03?o0005<ol000<0003oooooool0TOooo`00K?ooo`030000<ol0<ol001Dco`02
00001c?o00030000oooooooo093oool006_oool00`0003?o03?o000F<ol000<0000co`0co`001S?o
00030000oooooooo093oool006_oool00`0003?o03?o000F<ol000<0000co`0co`001c?o00030000
oooooooo08ooool006[oool00`0003?o03?o000?<ol01@0000<co`000`0003?o03?o0008<ol000<0
003oooooool0S_ooo`00JOooo`030000<ol0<ol0018co`000`0003?o03?o0003<ol000<0000co`0c
o`0023?o00030000oooooooo08koool006Soool00`0003?o03?o000C<ol000<0000co`0co`000c?o
00<00009<ol000<0003oooooool0SOooo`00J?ooo`030000<ol0<ol000/co`04000013?o00030000
<ol0<ol000<co`000`0003?o03?o000:<ol000<0003oooooool0S?ooo`00Ioooo`030000<ol0<ol0
01@co`000`0003?o03?o0003<ol000<0000co`0co`002c?o00030000oooooooo08_oool006Koool0
0`0003?o03?o000D<ol00P0000Dco`000`0003?o03?o000;<ol000<0003oooooool0Roooo`00I_oo
o`030000<ol0<ol001/co`0200003C?o00030000oooooooo08[oool006Goool00`0003?o03?o000L
<ol000<0000co`0co`003C?o00030000oooooooo08Woool006Coool00`0003?o03?o000M<ol000<0
000co`0co`003S?o00030000oooooooo08Soool006?oool00`0003?o03?o000N<ol000<0000co`0c
o`003c?o00030000oooooooo08Ooool006?oool00`0003?o03?o000N<ol000<0000co`0co`0043?o
00030000oooooooo08Koool006;oool00`0003?o03?o000O<ol00P00018co`000`000?ooooooo`25
oooo001Qoooo00<0000co`0co`0083?o00030000<ol0<ol0018co`000`000?ooooooo`24oooo000_
oooo0`0002Ooool400000_ooo`80000S<ol000<0000co`0co`004c?o00030000oooooooo017oool4
0000:_ooo`<0000Woooo0`0001Ooool0033oool00`000?ooooooo`0Voooo00<0003oooooool00_oo
o`030000<ol0<ol002<co`000`0003?o03?o000D<ol000<0003oooooool04?ooo`030000oooooooo
02coool00`000?ooooooo`0Voooo00@0003oooooool0000Foooo000]oooo1@0002Soool010000?oo
ooooo`0001Dco`0A06Ko0P00000306Ko<ol0<ol001<co`0200004Oooo`030000oooooooo02Soool5
00009oooo`040000oooooooo00005_ooo`009oooo`@00002oooo00@0003oooooool0000Roooo1000
00Coool200004S?o00@0I_lA<ol000<0000co`0co`000P1VoaDco`000`000?ooooooo`0?oooo00<0
003oooooool09oooo`040000oooooooo0000:?ooo`<0000Goooo000^oooo00<0003oool00000:?oo
o`8000000c?o000003?o000<<ol01@1VoaDco`001@0003?o03?o03?o001Vo`0F<ol000<0003ooooo
ool03?ooo`040000oooooooo0000:Oooo`030000oooo000002Woool00`000?ooooooo`0Foooo000_
oooo0P0002Ooool400002C?o00D0I_lJ<ol000D0000co`0co`0co`00I_l05c?o00030000oooooooo
00coool20000:oooo`80000Yoooo0`0001Koool005Koool2000023?o00D0I_lO<ol000D0000co`0c
o`0co`00I_l063?o0080001moooo001Doooo0P0000<co`0706Ko93?o00800002<ol000<0I_lco`0c
o`0063?o00<0001joooo001Aoooo00<00000I_l0I_l01@1Vob/co`000`0003?o03?o0002<ol000<0
I_lco`0co`006S?o00H0001doooo0015oooo3@1Voc8co`000`0003?o03?o0002<ol000<0I_lco`0c
o`0083?o00<0001aoooo000coooo4P1Vo`H0000i<ol000<0000co`0co`000S?o000306Ko<ol0<ol0
02<co`0:0000Ioooo`004?ooool0000Aoooo000Foooo00<0003oooooool02?ooo`030000oooooooo
00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?oo
ooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0
003oooooool02?ooo`050000ooooooooooooo`2I00Koool00`000?ooooooo`08oooo00<0003ooooo
ool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000
oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool0
0`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo01Goool002coool00`000?oo
ooooo`0Yoooo00<0003oooooool0:Oooo`050000ooooooooooooo`2I02Ooool00`000?ooooooo`0Y
oooo00<0003oooooool0:Oooo`030000oooooooo01Goool008Coool01@000?ooooooooooool0V@2G
oooo0024oooo00D0003ooooooooooooo09T0Uoooo`00Q?ooo`800002oooo00?o09Woooooool0UOoo
o`00Q?ooo`050000ooooooooooooo`2I09Ooool008Coool01@000?ooooooooooool0V@2Goooo0024
oooo00D0003ooooooooooooo09T0Uoooo`00Q?ooo`800002oooo00?o09Woooooool0UOooo`00Q?oo
o`050000ooooooooooooo`2I09Ooool008Coool01@000?ooooooooooool0V@2Goooo0024oooo00D0
003ooooooooooooo09T0Uoooo`00Q?ooo`050000ooooooooooooo`2I09Ooool008Coool200000_oo
o`03o`2Ioooooooo09Goool008Coool01@000?ooooooooooool0V@2Goooo0024oooo00D0003ooooo
oooooooo09T0Uoooo`00Q?ooo`050000ooooooooooooo`2I09Ooool008Coool200000_ooo`03o`2I
oooooooo09Goool008Coool01@000?ooooooooooool0V@2Goooo0024oooo00D0003ooooooooooooo
09T0Uoooo`00O?ooo`D00003oooo00D0003ooooooooooooo09T0Uoooo`00O_ooo`030000oooooooo
00?oool01@000?ooooooooooool0V@2Goooo001noooo00<0003oooooool00oooo`<000000oooool0
VOooo`2Foooo001noooo00<0003oooooool00oooo`050000ooooooooooooo`2I09Ooool007koool0
0`000?ooooooo`03oooo00D0003ooooooooooooo09T0Uoooo`00OOooo`800005oooo00D0003ooooo
oooooooo09T0Uoooo`00Q?ooo`800002oooo00?o09Woooooool0UOooo`00Q?ooo`050000oooooooo
ooooo`2I09Ooool008Coool01@000?ooooooooooool0V@2Goooo0024oooo00D0003ooooooooooooo
09T0Uoooo`00Q?ooo`050000ooooooooooooo`2I09Ooool008Coool200000_ooo`03o`2Ioooooooo
09Goool008Coool01@000?ooooooooooool0V@2Goooo0024oooo00D0003ooooooooooooo09T0Uooo
o`00Q?ooo`050000ooooooooooooo`2I09Ooool008Coool200000_ooo`03o`2Ioooooooo09Goool0
08Coool01@000?ooooooooooool0V@2Goooo0024oooo00D0003ooooooooooooo09T0Uoooo`00Q?oo
o`050000ooooooooooooo`2I09Ooool008Coool01@000?ooooooooooool0V@2Goooo0024oooo0P00
00;oool00ol0VOooooooo`2Eoooo0024oooo00D0003ooooooooooooo09T0Uoooo`00O?ooo`@00004
oooo00D0003ooooooooooooo09T0Uoooo`00O?ooo`030000oooooooo00Goool01@000?oooooooooo
ool0V@2Goooo001moooo00<0003oooooool01?ooo`<000000oooool0VOooo`2Foooo001noooo00<0
003oooooool00oooo`050000ooooooooooooo`2I09Ooool007coool010000?ooooooo`0000Coool0
1@000?ooooooooooool0V@2Goooo001moooo0P0000Goool01@000?ooooooooooool0V@2Goooo0024
oooo0P0000;oool00ol0VOooooooo`2Eoooo0024oooo00D0003ooooooooooooo09T0Uoooo`00Q?oo
o`050000ooooooooooooo`2I09Ooool008Coool01@000?ooooooooooool0V@2Goooo0024oooo00D0
003ooooooooooooo09T0Uoooo`00Q?ooo`800002oooo00?o09Woooooool0UOooo`00Q?ooo`050000
ooooooooooooo`2I09Ooool008Coool01@000?ooooooooooool0V@2Goooo0024oooo00D0003ooooo
oooooooo09T0Uoooo`00Q?ooo`800002oooo00?o09Woooooool0UOooo`00Q?ooo`050000oooooooo
ooooo`2I09Ooool008Coool01@000?ooooooooooool0V@2Goooo0024oooo00D0003ooooooooooooo
09T0Uoooo`00Q?ooo`050000ooooooooooooo`2I09Ooool008Coool200000_ooo`03o`2Ioooooooo
09Goool008Coool01@000?ooooooooooool0V@2Goooo001moooo0P0000Goool01@000?oooooooooo
ool0V@2Goooo001loooo00@0003oooooool00004oooo00D0003ooooooooooooo09T0Uoooo`00O_oo
o`030000oooooooo00?oool3000000?ooooo09Woool0U_ooo`00Ooooo`030000oooooooo00;oool0
1@000?ooooooooooool0V@2Goooo001loooo00@0003oooooool00004oooo00D0003ooooooooooooo
09T0Uoooo`00OOooo`800005oooo00D0003ooooooooooooo09T0Uoooo`00Q?ooo`050000oooooooo
ooooo`2I09Ooool008Coool200000_ooo`03o`2Ioooooooo09Goool008Coool01@000?oooooooooo
ool0V@2Goooo0024oooo00D0003ooooooooooooo09T0Uoooo`00Q?ooo`050000ooooooooooooo`2I
09Ooool008Coool200000_ooo`03o`2Ioooooooo09Goool008Coool01@000?ooooooooooool0V@2G
oooo0024oooo00D0003ooooooooooooo09T0Uoooo`00Q?ooo`050000ooooooooooooo`2I09Ooool0
08Coool01@000?ooooooooooool0V@2Goooo0024oooo0P0000;oool00ol0VOooooooo`2Eoooo0024
oooo00D0003ooooooooooooo09T0Uoooo`00Q?ooo`050000ooooooooooooo`2I09Ooool008Coool0
1@000?ooooooooooool0V@2Goooo0024oooo0P0000;oool00ol0VOooooooo`2Eoooo0024oooo00D0
003ooooooooooooo09T0Uoooo`00Q?ooo`050000ooooooooooooo`2I09Ooool007koool300000ooo
o`050000ooooooooooooo`2I09Ooool007ooool00`000?ooooooo`02oooo00D0003ooooooooooooo
09T0Uoooo`00O?ooo`D00003oooo0`000003ooooo`2Ioooo09Koool007coool010000?ooooooo`00
0:3oool007goool00`000?ooo`00002Poooo001noooo0P000:3oool00?oooolQoooo003ooooo8Ooo
o`00NOooo`030000oooooooo02Soool00`000?ooooooo`1ioooo001hoooo00<0003oooooool02?oo
o`030000oooooooo01ooool00`000?ooooooo`1hoooo001hoooo00<0003oooooool00_ooo`800004
oooo00<0003oooooool03Oooo`800004oooo0P0000Coool200001?ooo`030000oooooooo07Soool0
07Soool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo00Coool4
00000oooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo07Soool0
07Ooool00`000?ooooooo`02oooo00<0003oooooool04oooo`040000oooooooo00002?ooo`040000
oooooooo00001?ooo`030000oooooooo07Ooool007Soool00`000?ooooooo`0500004_ooo`040000
oooooooo00002Oooo`800004oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo0000
01Goool010000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?ooooooo`1hoooo001i
oooo00<0003oooooool05oooo`80000:oooo0P0000?oool00`000?ooooooo`1ioooo003ooooo8Ooo
o`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-6.03535, \
-3.20105, 0.0455524, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-6.03535, -3.20105, 0.0455524, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.30316 .26487 L
.34309 .26487 L
.3815 .26487 L
.42237 .26487 L
.44268 .26487 L
.46172 .26487 L
.47994 .26487 L
.48519 .26487 L
.48778 .26487 L
.48904 .26487 L
.49018 .26487 L
.4913 .26487 L
s
.4913 .26487 m
.49172 .61803 L
s
0 .4 1 r
.02381 .26435 m
.04262 .26422 L
.06244 .26406 L
.08255 .26384 L
.10458 .26355 L
.12415 .26321 L
.14509 .26276 L
.16639 .26217 L
.18653 .26147 L
.22495 .25959 L
.24479 .25827 L
.26581 .25653 L
.30365 .25238 L
.34394 .24652 L
.38271 .24067 L
.39281 .23945 L
.39815 .23891 L
.40384 .23841 L
.40931 .23802 L
.41426 .23776 L
.41665 .23766 L
.41924 .23758 L
.42043 .23755 L
.42169 .23753 L
.42276 .23751 L
.42393 .2375 L
.42524 .23749 L
.42644 .23748 L
.42707 .23748 L
.42777 .23748 L
.42849 .23749 L
.42917 .23749 L
.43042 .23751 L
.43156 .23752 L
.43282 .23755 L
.43414 .23758 L
.43858 .23774 L
.4411 .23786 L
.44344 .23799 L
.45356 .23875 L
.46436 .23988 L
.4746 .2412 L
.47999 .24196 L
.4857 .24281 L
.48811 .24317 L
.48944 .24338 L
.4907 .24357 L
.49141 .26487 L
.49218 .26487 L
.49353 .26487 L
Mistroke
.49619 .26487 L
.50586 .26487 L
.54655 .26487 L
.58574 .26487 L
.62737 .26487 L
.66749 .26487 L
.70609 .26487 L
.74715 .26487 L
.78669 .26487 L
.82471 .26487 L
.86519 .26487 L
.90415 .26487 L
.94556 .26487 L
.97619 .26487 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001moooo0P000:7oool007coool010000?ooooooo`000:3oool007koool00`000?oo
ooooo`03oooo0`0009Woool007Koool400001Oooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo001loooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007coool200001_ooo`<0002I
oooo001foooo1P000004<ol00000000000001?ooo`030000oooooooo09Woool007Soool01@0003?o
03?o03?o00000002<ol00P0000?oool00`000?ooooooo`2Ioooo001goooo00<0000co`0co`000c?o
00800002<ol00P000003oooo0000oooo09[oool007Koool00`0003?o03?o000:<ol00P0009_oool0
07Goool00`0003?o03?o000<<ol00P0009[oool007Coool00`0003?o03?o000=<ol000<0003ooooo
ool0VOooo`00Loooo`030000<ol0<ol000hco`020000V_ooo`00Loooo`030000<ol0<ol000hco`00
0`0003?o0000002Ioooo001boooo00<0000co`0co`003c?o008000000c?o00000?ooo`2Goooo001b
oooo00<0000co`0co`003c?o00040000<ol0<ol00000V?ooo`00LOooo`030000<ol0<ol0010co`00
1@0003?o03?o03?o0000002Goooo001aoooo00<0000co`0co`0043?o00030000<ol0<ol0008co`00
0`000?ooooooo`2Doooo001`oooo00<0000co`0co`004C?o00030000<ol0<ol0008co`000`000?oo
ooooo`2Doooo001_oooo00<0000co`0co`004S?o00800004<ol000<0003oooooool0Toooo`00K_oo
o`030000<ol0<ol001<co`000`0003?o03?o0004<ol000<0003oooooool0T_ooo`00K_ooo`030000
<ol0<ol001<co`000`0003?o03?o0004<ol000<0003oooooool0T_ooo`00KOooo`030000<ol0<ol0
01@co`000`0003?o03?o0005<ol000<0003oooooool0TOooo`00K?ooo`030000<ol0<ol001Dco`02
00001c?o00030000oooooooo093oool006_oool00`0003?o03?o000F<ol000<0000co`0co`001S?o
00030000oooooooo093oool006_oool00`0003?o03?o000F<ol000<0000co`0co`001c?o00030000
oooooooo08ooool006[oool00`0003?o03?o000?<ol01@0000<co`000`0003?o03?o0008<ol000<0
003oooooool0S_ooo`00JOooo`030000<ol0<ol0018co`000`0003?o03?o0003<ol000<0000co`0c
o`0023?o00030000oooooooo08koool006Soool00`0003?o03?o000C<ol000<0000co`0co`000c?o
00<00009<ol000<0003oooooool0SOooo`00J?ooo`030000<ol0<ol000/co`04000013?o00030000
<ol0<ol000<co`000`0003?o03?o000:<ol000<0003oooooool0S?ooo`00Ioooo`030000<ol0<ol0
01@co`000`0003?o03?o0003<ol000<0000co`0co`002c?o00030000oooooooo08_oool006Koool0
0`0003?o03?o000D<ol00P0000Dco`000`0003?o03?o000;<ol000<0003oooooool0Roooo`00I_oo
o`030000<ol0<ol001/co`0200003C?o00030000oooooooo08[oool006Goool00`0003?o03?o000L
<ol000<0000co`0co`003C?o00030000oooooooo08Woool006Coool00`0003?o03?o000M<ol000<0
000co`0co`003S?o00030000oooooooo08Soool006?oool00`0003?o03?o000N<ol000<0000co`0c
o`003c?o00030000oooooooo08Ooool006?oool00`0003?o03?o000N<ol000<0000co`0co`0043?o
00030000oooooooo08Koool006;oool00`0003?o03?o000O<ol00P00018co`000`000?ooooooo`25
oooo001Qoooo00<0000co`0co`0083?o00030000<ol0<ol0018co`000`000?ooooooo`24oooo000_
oooo0`0002Ooool400000_ooo`80000S<ol000<0000co`0co`004c?o00030000oooooooo017oool4
0000:_ooo`<0000Woooo0`0001Ooool0033oool00`000?ooooooo`0Voooo00<0003oooooool00_oo
o`030000<ol0<ol002<co`000`0003?o03?o000D<ol000<0003oooooool04?ooo`030000oooooooo
02coool00`000?ooooooo`0Voooo00@0003oooooool0000Foooo000]oooo1@0002Soool010000?oo
ooooo`0002Hco`0200005S?o0080000Aoooo00<0003oooooool0:?ooo`D0000Woooo00@0003ooooo
ool0000Foooo000Woooo100000;oool010000?ooooooo`0002;oool400001?ooo`80000W<ol000<0
000co`0co`005c?o00030000oooooooo00ooool00`000?ooooooo`0Woooo00@0003oooooool0000X
oooo0`0001Ooool002koool00`000?ooo`00000Xoooo0P000003<ol00000<ol001Xco`0:06Ko0S?o
00030000<ol0<ol001Pco`000`000?ooooooo`0<oooo00@0003oooooool0000Yoooo00<0003oool0
0000:Oooo`030000oooooooo01Koool002ooool200009oooo`@0000C<ol02@1Vo`Xco`0206Ko00<0
0000I_l0I_l0101VoaDco`000`000?ooooooo`0<oooo0P0002_oool20000:Oooo`<0000Foooo001F
oooo0P00018co`0506Ko5C?o00030000<ol0<ol000@co`0306Ko4c?o0080001moooo001Doooo0P00
00dco`0706Ko6S?o00800007<ol000<0I_lco`0co`004c?o00<0001joooo001Aoooo0`0000Dco`0:
06Ko8C?o00030000<ol0<ol000Hco`000`1Voc?o03?o000F<ol01P0007Coool004_oool6000000<c
o`00I_l0I_l01@1Vob/co`000`0003?o03?o0006<ol000<0I_lco`0co`0073?o00<0001aoooo000m
oooo5@1Voc8co`000`0003?o03?o0006<ol000<0I_lco`0co`007c?o00X0001Woooo000@ooooo`00
017oool001Koool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool0
0`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08
oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003ooooo
ool01_ooo`03o`2Ioooo000000[oool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000
oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool0
0`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08
oooo00<0003oooooool05Oooo`00;?ooo`030000oooooooo02Woool00`000?ooooooo`0Yoooo00<0
003oooooool01_ooo`03o`2Ioooooooo023oool00`000?ooooooo`0Yoooo00<0003oooooool0:Ooo
o`030000oooooooo01Goool008Coool00`000?ooooooo`06oooo00?o09Woooooool0T?ooo`00Q?oo
o`030000oooooooo00Koool00ol0VOooooooo`2@oooo0024oooo0P0000Ooool00ol0VOooooooo`2@
oooo0024oooo00<0003oooooool01_ooo`03o`2Ioooooooo093oool008Coool00`000?ooooooo`06
oooo00?o09Woooooool0T?ooo`00Q?ooo`030000oooooooo00Koool00ol0VOooooooo`2@oooo0024
oooo0P0000Ooool00ol0VOooooooo`2@oooo0024oooo00<0003oooooool01_ooo`03o`2Ioooooooo
093oool008Coool00`000?ooooooo`06oooo00?o09Woooooool0T?ooo`00Q?ooo`030000oooooooo
00Koool00ol0VOooooooo`2@oooo0024oooo00<0003oooooool01_ooo`03o`2Ioooooooo093oool0
08Coool200001oooo`03o`2Ioooooooo093oool008Coool00`000?ooooooo`06oooo00?o09Wooooo
ool0T?ooo`00Q?ooo`030000oooooooo00Koool00ol0VOooooooo`2@oooo0024oooo00<0003ooooo
ool01_ooo`03o`2Ioooooooo093oool008Coool200001oooo`03o`2Ioooooooo093oool008Coool0
0`000?ooooooo`06oooo00?o09Woooooool0T?ooo`00Q?ooo`030000oooooooo00Koool00ol0VOoo
ooooo`2@oooo001loooo1@0000?oool00`000?ooooooo`06oooo00?o09Woooooool0T?ooo`00O_oo
o`030000oooooooo00?oool00`000?ooooooo`06oooo00?o09Woooooool0T?ooo`00O_ooo`030000
oooooooo00?oool300001_ooo`03o`2Ioooooooo093oool007koool00`000?ooooooo`03oooo00<0
003oooooool01_ooo`03o`2Ioooooooo093oool007koool00`000?ooooooo`03oooo00<0003ooooo
ool01_ooo`03o`2Ioooooooo093oool007goool200001Oooo`030000oooooooo00Koool00ol0VOoo
ooooo`2@oooo0024oooo0P0000Ooool00ol0VOooooooo`2@oooo0024oooo00<0003oooooool01_oo
o`03o`2Ioooooooo093oool008Coool00`000?ooooooo`06oooo00?o09Woooooool0T?ooo`00Q?oo
o`030000oooooooo00Koool00ol0VOooooooo`2@oooo0024oooo00<0003oooooool01_ooo`03o`2I
oooooooo093oool008Coool200001oooo`03o`2Ioooooooo093oool008Coool00`000?ooooooo`06
oooo00?o09Woooooool0T?ooo`00Q?ooo`030000oooooooo00Koool00ol0VOooooooo`2@oooo0024
oooo00<0003oooooool01_ooo`03o`2Ioooooooo093oool008Coool200001oooo`03o`2Ioooooooo
093oool008Coool00`000?ooooooo`06oooo00?o09Woooooool0T?ooo`00Q?ooo`030000oooooooo
00Koool00ol0VOooooooo`2@oooo0024oooo00<0003oooooool01_ooo`03o`2Ioooooooo093oool0
08Coool00`000?ooooooo`06oooo00?o09Woooooool0T?ooo`00Q?ooo`800007oooo00?o09Wooooo
ool0T?ooo`00Q?ooo`030000oooooooo00Koool00ol0VOooooooo`2@oooo001loooo100000Coool0
0`000?ooooooo`06oooo00?o09Woooooool0T?ooo`00O?ooo`030000oooooooo00Goool00`000?oo
ooooo`06oooo00?o09Woooooool0T?ooo`00OOooo`030000oooooooo00Coool300001_ooo`03o`2I
oooooooo093oool007koool00`000?ooooooo`03oooo00<0003oooooool01_ooo`03o`2Ioooooooo
093oool007coool010000?ooooooo`0000Coool00`000?ooooooo`06oooo00?o09Woooooool0T?oo
o`00OOooo`800005oooo00<0003oooooool01_ooo`03o`2Ioooooooo093oool008Coool200001ooo
o`03o`2Ioooooooo093oool008Coool00`000?ooooooo`06oooo00?o09Woooooool0T?ooo`00Q?oo
o`030000oooooooo00Koool00ol0VOooooooo`2@oooo0024oooo00<0003oooooool01_ooo`03o`2I
oooooooo093oool008Coool00`000?ooooooo`06oooo00?o09Woooooool0T?ooo`00Q?ooo`800007
oooo00?o09Woooooool0T?ooo`00Q?ooo`030000oooooooo00Koool00ol0VOooooooo`2@oooo0024
oooo00<0003oooooool01_ooo`03o`2Ioooooooo093oool008Coool00`000?ooooooo`06oooo00?o
09Woooooool0T?ooo`00Q?ooo`800007oooo00?o09Woooooool0T?ooo`00Q?ooo`030000oooooooo
00Koool00ol0VOooooooo`2@oooo0024oooo00<0003oooooool01_ooo`03o`2Ioooooooo093oool0
08Coool00`000?ooooooo`06oooo00?o09Woooooool0T?ooo`00Q?ooo`030000oooooooo00Koool0
0ol0VOooooooo`2@oooo0024oooo0P0000Ooool00ol0VOooooooo`2@oooo0024oooo00<0003ooooo
ool01_ooo`03o`2Ioooooooo093oool007goool200001Oooo`030000oooooooo00Koool00ol0VOoo
ooooo`2@oooo001loooo00@0003oooooool00004oooo00<0003oooooool01_ooo`03o`2Ioooooooo
093oool007koool00`000?ooooooo`03oooo0`0000Koool00ol0VOooooooo`2@oooo001ooooo00<0
003oooooool00_ooo`030000oooooooo00Koool00ol0VOooooooo`2@oooo001loooo00@0003ooooo
ool00004oooo00<0003oooooool01_ooo`03o`2Ioooooooo093oool007goool200001Oooo`030000
oooooooo00Koool00ol0VOooooooo`2@oooo0024oooo00<0003oooooool01_ooo`03o`2Ioooooooo
093oool008Coool200001oooo`03o`2Ioooooooo093oool008Coool00`000?ooooooo`06oooo00?o
09Woooooool0T?ooo`00Q?ooo`030000oooooooo00Koool00ol0VOooooooo`2@oooo0024oooo00<0
003oooooool01_ooo`03o`2Ioooooooo093oool008Coool200001oooo`03o`2Ioooooooo093oool0
08Coool00`000?ooooooo`06oooo00?o09Woooooool0T?ooo`00Q?ooo`030000oooooooo00Koool0
0ol0VOooooooo`2@oooo0024oooo00<0003oooooool01_ooo`03o`2Ioooooooo093oool008Coool0
0`000?ooooooo`06oooo00?o09Woooooool0T?ooo`00Q?ooo`800007oooo00?o09Woooooool0T?oo
o`00Q?ooo`030000oooooooo00Koool00ol0VOooooooo`2@oooo0024oooo00<0003oooooool01_oo
o`03o`2Ioooooooo093oool008Coool00`000?ooooooo`06oooo00?o09Woooooool0T?ooo`00Q?oo
o`800007oooo00?o09Woooooool0T?ooo`00Q?ooo`030000oooooooo00Koool00ol0VOooooooo`2@
oooo0024oooo00<0003oooooool01_ooo`03o`2Ioooooooo093oool007koool300000oooo`030000
oooooooo00Koool00ol0VOooooooo`2@oooo001ooooo00<0003oooooool00_ooo`030000oooooooo
00Koool00ol0VOooooooo`2@oooo001loooo1@0000?oool300001_ooo`03o`2Ioooooooo093oool0
07coool010000?ooooooo`000:3oool007goool00`000?ooo`00002Poooo001noooo0P000:3oool0
0?oooolQoooo003ooooo8Oooo`00NOooo`030000oooooooo02Soool00`000?ooooooo`1ioooo001h
oooo00<0003oooooool02?ooo`030000oooooooo01ooool00`000?ooooooo`1hoooo001hoooo00<0
003oooooool00_ooo`800004oooo00<0003oooooool03Oooo`800004oooo0P0000?oool300001?oo
o`030000oooooooo07Soool007Soool01@000?ooooooooooo`000002oooo00<0003oooooool00_oo
o`030000oooooooo00Coool400000oooo`040000oooooooo00002?ooo`040000oooooooo00000ooo
o`030000oooooooo07Soool007Ooool00`000?ooooooo`02oooo00<0003oooooool04oooo`040000
oooooooo00002?ooo`040000oooooooo00001?ooo`030000oooooooo07Ooool007Soool00`000?oo
ooooo`0500004_ooo`040000oooooooo00002?ooo`<00004oooo00<0003oooooool0N?ooo`00N?oo
o`050000oooooooooooo000001Goool010000?ooooooo`0000Woool00`000?ooooooo`03oooo00<0
003oooooool0N?ooo`00NOooo`030000oooooooo01Ooool200002_ooo`<00002oooo00<0003ooooo
ool0NOooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-6.03535, \
-3.20105, 0.0455524, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-6.03535, -3.20105, 0.0455524, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.30316 .26487 L
.34309 .26487 L
.3815 .26487 L
.42237 .26487 L
.46172 .26487 L
.48147 .26487 L
.49012 .26487 L
.49955 .26487 L
.50205 .26487 L
.50471 .26487 L
.50601 .26487 L
.50722 .26487 L
.50832 .26487 L
s
.50832 .26487 m
.50879 .61803 L
s
0 .4 1 r
.02381 .26453 m
.04262 .26445 L
.06244 .26435 L
.08255 .26421 L
.10458 .26402 L
.12415 .2638 L
.14509 .26351 L
.16639 .26313 L
.18653 .26267 L
.22495 .26147 L
.24479 .26061 L
.26581 .25949 L
.30365 .25681 L
.34394 .25303 L
.38271 .24926 L
.39281 .24847 L
.39815 .24812 L
.40384 .2478 L
.40931 .24755 L
.41426 .24738 L
.41665 .24732 L
.41924 .24727 L
.42043 .24725 L
.42169 .24723 L
.42276 .24722 L
.42393 .24721 L
.42524 .2472 L
.42644 .2472 L
.42707 .2472 L
.42777 .2472 L
.42849 .2472 L
.42917 .24721 L
.43042 .24722 L
.43156 .24723 L
.43282 .24724 L
.43414 .24726 L
.43858 .24737 L
.4411 .24744 L
.44344 .24753 L
.45356 .24802 L
.46436 .24875 L
.48427 .2505 L
.49476 .25154 L
.50049 .25212 L
.50329 .2524 L
.50586 .25267 L
.50703 .25279 L
.50831 .25292 L
.50951 .26487 L
.51063 .26487 L
Mistroke
.51576 .26487 L
.52666 .26487 L
.54584 .26487 L
.58502 .26487 L
.62665 .26487 L
.66677 .26487 L
.70538 .26487 L
.74643 .26487 L
.78597 .26487 L
.82399 .26487 L
.86447 .26487 L
.90343 .26487 L
.94485 .26487 L
.97619 .26487 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001moooo0P000:7oool007coool010000?ooooooo`000:3oool007koool00`000?oo
ooooo`03oooo0`0009Woool007Koool400001Oooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo001loooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007coool200001_ooo`<0002I
oooo001foooo1P000004<ol00000000000001?ooo`030000oooooooo09Woool007Soool01@0003?o
03?o03?o00000002<ol00P0000?oool00`000?ooooooo`2Ioooo001goooo00<0000co`0co`000c?o
00800002<ol00P000003oooo0000oooo09[oool007Koool00`0003?o03?o000:<ol00P0009_oool0
07Goool00`0003?o03?o000<<ol00P0009[oool007Coool00`0003?o03?o000=<ol000<0003ooooo
ool0VOooo`00Loooo`030000<ol0<ol000hco`020000V_ooo`00Loooo`030000<ol0<ol000hco`00
0`0003?o0000002Ioooo001boooo00<0000co`0co`003c?o008000000c?o00000?ooo`2Goooo001b
oooo00<0000co`0co`003c?o00040000<ol0<ol00000V?ooo`00LOooo`030000<ol0<ol0010co`00
1@0003?o03?o03?o0000002Goooo001aoooo00<0000co`0co`0043?o00030000<ol0<ol0008co`00
0`000?ooooooo`2Doooo001`oooo00<0000co`0co`004C?o00030000<ol0<ol0008co`000`000?oo
ooooo`2Doooo001_oooo00<0000co`0co`004S?o00800004<ol000<0003oooooool0Toooo`00K_oo
o`030000<ol0<ol001<co`000`0003?o03?o0004<ol000<0003oooooool0T_ooo`00K_ooo`030000
<ol0<ol001<co`000`0003?o03?o0004<ol000<0003oooooool0T_ooo`00KOooo`030000<ol0<ol0
01@co`000`0003?o03?o0005<ol000<0003oooooool0TOooo`00K?ooo`030000<ol0<ol001Dco`02
00001c?o00030000oooooooo093oool006_oool00`0003?o03?o000F<ol000<0000co`0co`001S?o
00030000oooooooo093oool006_oool00`0003?o03?o000F<ol000<0000co`0co`001c?o00030000
oooooooo08ooool006[oool00`0003?o03?o000?<ol01@0000<co`000`0003?o03?o0008<ol000<0
003oooooool0S_ooo`00JOooo`030000<ol0<ol0018co`000`0003?o03?o0003<ol000<0000co`0c
o`0023?o00030000oooooooo08koool006Soool00`0003?o03?o000C<ol000<0000co`0co`000c?o
00<00009<ol000<0003oooooool0SOooo`00J?ooo`030000<ol0<ol000/co`04000013?o00030000
<ol0<ol000<co`000`0003?o03?o000:<ol000<0003oooooool0S?ooo`00Ioooo`030000<ol0<ol0
01@co`000`0003?o03?o0003<ol000<0000co`0co`002c?o00030000oooooooo08_oool006Koool0
0`0003?o03?o000D<ol00P0000Dco`000`0003?o03?o000;<ol000<0003oooooool0Roooo`00I_oo
o`030000<ol0<ol001/co`0200003C?o00030000oooooooo08[oool006Goool00`0003?o03?o000L
<ol000<0000co`0co`003C?o00030000oooooooo08Woool006Coool00`0003?o03?o000M<ol000<0
000co`0co`003S?o00030000oooooooo08Soool006?oool00`0003?o03?o000N<ol000<0000co`0c
o`003c?o00030000oooooooo08Ooool006?oool00`0003?o03?o000N<ol000<0000co`0co`0043?o
00030000oooooooo08Koool006;oool00`0003?o03?o000O<ol00P00018co`000`000?ooooooo`25
oooo001Qoooo00<0000co`0co`0083?o00030000<ol0<ol0018co`000`000?ooooooo`24oooo000_
oooo0`0002Ooool400000_ooo`80000S<ol000<0000co`0co`004c?o00030000oooooooo017oool4
0000:_ooo`<0000Woooo0`0001Ooool0033oool00`000?ooooooo`0Voooo00<0003oooooool00_oo
o`030000<ol0<ol002<co`000`0003?o03?o000D<ol000<0003oooooool04?ooo`030000oooooooo
02coool00`000?ooooooo`0Voooo00@0003oooooool0000Foooo000]oooo1@0002Soool010000?oo
ooooo`0002Hco`0200005S?o0080000Aoooo00<0003oooooool0:?ooo`D0000Woooo00@0003ooooo
ool0000Foooo000Woooo100000;oool010000?ooooooo`0002;oool400001?ooo`80000W<ol000<0
000co`0co`005c?o00030000oooooooo00ooool00`000?ooooooo`0Woooo00@0003oooooool0000X
oooo0`0001Ooool002koool00`000?ooo`00000Xoooo0P000003<ol00000<ol002Hco`000`0003?o
03?o000H<ol000<0003oooooool03?ooo`040000oooooooo0000:Oooo`030000oooo000002Woool0
0`000?ooooooo`0Foooo000_oooo0P0002Ooool40000:3?o00030000<ol0<ol001Tco`000`000?oo
ooooo`0<oooo0P0002_oool20000:Oooo`<0000Foooo001Foooo0P0002`co`000`0003?o03?o000J
<ol00P0007goool005Coool200005c?o01L0I_l200000`1VoaXco`030000N_ooo`00DOooo`<0000?
<ol02P1VoaLco`000`0003?o03?o0002<ol02@1Voa@co`060000M?ooo`00Boooo`H00008<ol02P1V
ob4co`000`0003?o03?o000:<ol000<0I_lco`0co`0063?o00<0001aoooo0011oooo100001@0I_l[
<ol000<0000co`0co`002S?o000306Ko<ol0<ol001/co`0:0000Ioooo`004?ooool0000Aoooo000F
oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003ooooo
ool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000
oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool0
0`000?ooool0V@08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08
oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003ooooo
ool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000
oooooooo01Goool002coool00`000?ooooooo`0Yoooo00<0003oooooool0:Oooo`030000oooooooo
00[oool00ol0VOooooooo`0Loooo00<0003oooooool0:Oooo`030000oooooooo02Woool00`000?oo
ooooo`0Eoooo0024oooo00<0003oooooool02_ooo`03o`2Ioooooooo08coool008Coool00`000?oo
ooooo`0:oooo00?o09Woooooool0S?ooo`00Q?ooo`80000;oooo00?o09Woooooool0S?ooo`00Q?oo
o`030000oooooooo00[oool00ol0VOooooooo`2<oooo0024oooo00<0003oooooool02_ooo`03o`2I
oooooooo08coool008Coool00`000?ooooooo`0:oooo00?o09Woooooool0S?ooo`00Q?ooo`80000;
oooo00?o09Woooooool0S?ooo`00Q?ooo`030000oooooooo00[oool00ol0VOooooooo`2<oooo0024
oooo00<0003oooooool02_ooo`03o`2Ioooooooo08coool008Coool00`000?ooooooo`0:oooo00?o
09Woooooool0S?ooo`00Q?ooo`030000oooooooo00[oool00ol0VOooooooo`2<oooo0024oooo0P00
00_oool00ol0VOooooooo`2<oooo0024oooo00<0003oooooool02_ooo`03o`2Ioooooooo08coool0
08Coool00`000?ooooooo`0:oooo00?o09Woooooool0S?ooo`00Q?ooo`030000oooooooo00[oool0
0ol0VOooooooo`2<oooo0024oooo0P0000_oool00ol0VOooooooo`2<oooo0024oooo00<0003ooooo
ool02_ooo`03o`2Ioooooooo08coool008Coool00`000?ooooooo`0:oooo00?o09Woooooool0S?oo
o`00O?ooo`D00003oooo00<0003oooooool02_ooo`03o`2Ioooooooo08coool007koool00`000?oo
ooooo`03oooo00<0003oooooool02_ooo`03o`2Ioooooooo08coool007koool00`000?ooooooo`03
oooo0`0000[oool00ol0VOooooooo`2<oooo001noooo00<0003oooooool00oooo`030000oooooooo
00[oool00ol0VOooooooo`2<oooo001noooo00<0003oooooool00oooo`030000oooooooo00[oool0
0ol0VOooooooo`2<oooo001moooo0P0000Goool00`000?ooooooo`0:oooo00?o09Woooooool0S?oo
o`00Q?ooo`80000;oooo00?o09Woooooool0S?ooo`00Q?ooo`030000oooooooo00[oool00ol0VOoo
ooooo`2<oooo0024oooo00<0003oooooool02_ooo`03o`2Ioooooooo08coool008Coool00`000?oo
ooooo`0:oooo00?o09Woooooool0S?ooo`00Q?ooo`030000oooooooo00[oool00ol0VOooooooo`2<
oooo0024oooo0P0000_oool00ol0VOooooooo`2<oooo0024oooo00<0003oooooool02_ooo`03o`2I
oooooooo08coool008Coool00`000?ooooooo`0:oooo00?o09Woooooool0S?ooo`00Q?ooo`030000
oooooooo00[oool00ol0VOooooooo`2<oooo0024oooo0P0000_oool00ol0VOooooooo`2<oooo0024
oooo00<0003oooooool02_ooo`03o`2Ioooooooo08coool008Coool00`000?ooooooo`0:oooo00?o
09Woooooool0S?ooo`00Q?ooo`030000oooooooo00[oool00ol0VOooooooo`2<oooo0024oooo00<0
003oooooool02_ooo`03o`2Ioooooooo08coool008Coool200002oooo`03o`2Ioooooooo08coool0
08Coool00`000?ooooooo`0:oooo00?o09Woooooool0S?ooo`00O?ooo`@00004oooo00<0003ooooo
ool02_ooo`03o`2Ioooooooo08coool007coool00`000?ooooooo`05oooo00<0003oooooool02_oo
o`03o`2Ioooooooo08coool007goool00`000?ooooooo`04oooo0`0000[oool00ol0VOooooooo`2<
oooo001noooo00<0003oooooool00oooo`030000oooooooo00[oool00ol0VOooooooo`2<oooo001l
oooo00@0003oooooool00004oooo00<0003oooooool02_ooo`03o`2Ioooooooo08coool007goool2
00001Oooo`030000oooooooo00[oool00ol0VOooooooo`2<oooo0024oooo0P0000_oool00ol0VOoo
ooooo`2<oooo0024oooo00<0003oooooool02_ooo`03o`2Ioooooooo08coool008Coool00`000?oo
ooooo`0:oooo00?o09Woooooool0S?ooo`00Q?ooo`030000oooooooo00[oool00ol0VOooooooo`2<
oooo0024oooo00<0003oooooool02_ooo`03o`2Ioooooooo08coool008Coool200002oooo`03o`2I
oooooooo08coool008Coool00`000?ooooooo`0:oooo00?o09Woooooool0S?ooo`00Q?ooo`030000
oooooooo00[oool00ol0VOooooooo`2<oooo0024oooo00<0003oooooool02_ooo`03o`2Ioooooooo
08coool008Coool200002oooo`03o`2Ioooooooo08coool008Coool00`000?ooooooo`0:oooo00?o
09Woooooool0S?ooo`00Q?ooo`030000oooooooo00[oool00ol0VOooooooo`2<oooo0024oooo00<0
003oooooool02_ooo`03o`2Ioooooooo08coool008Coool00`000?ooooooo`0:oooo00?o09Wooooo
ool0S?ooo`00Q?ooo`80000;oooo00?o09Woooooool0S?ooo`00Q?ooo`030000oooooooo00[oool0
0ol0VOooooooo`2<oooo001moooo0P0000Goool00`000?ooooooo`0:oooo00?o09Woooooool0S?oo
o`00O?ooo`040000oooooooo00001?ooo`030000oooooooo00[oool00ol0VOooooooo`2<oooo001n
oooo00<0003oooooool00oooo`<0000:oooo00?o09Woooooool0S?ooo`00Ooooo`030000oooooooo
00;oool00`000?ooooooo`0:oooo00?o09Woooooool0S?ooo`00O?ooo`040000oooooooo00001?oo
o`030000oooooooo00[oool00ol0VOooooooo`2<oooo001moooo0P0000Goool00`000?ooooooo`0:
oooo00?o09Woooooool0S?ooo`00Q?ooo`030000oooooooo00[oool00ol0VOooooooo`2<oooo0024
oooo0P0000_oool00ol0VOooooooo`2<oooo0024oooo00<0003oooooool02_ooo`03o`2Ioooooooo
08coool008Coool00`000?ooooooo`0:oooo00?o09Woooooool0S?ooo`00Q?ooo`030000oooooooo
00[oool00ol0VOooooooo`2<oooo0024oooo0P0000_oool00ol0VOooooooo`2<oooo0024oooo00<0
003oooooool02_ooo`03o`2Ioooooooo08coool008Coool00`000?ooooooo`0:oooo00?o09Wooooo
ool0S?ooo`00Q?ooo`030000oooooooo00[oool00ol0VOooooooo`2<oooo0024oooo00<0003ooooo
ool02_ooo`03o`2Ioooooooo08coool008Coool200002oooo`03o`2Ioooooooo08coool008Coool0
0`000?ooooooo`0:oooo00?o09Woooooool0S?ooo`00Q?ooo`030000oooooooo00[oool00ol0VOoo
ooooo`2<oooo0024oooo00<0003oooooool02_ooo`03o`2Ioooooooo08coool008Coool200002ooo
o`03o`2Ioooooooo08coool008Coool00`000?ooooooo`0:oooo00?o09Woooooool0S?ooo`00Q?oo
o`030000oooooooo00[oool00ol0VOooooooo`2<oooo001noooo0`0000?oool00`000?ooooooo`0:
oooo00?o09Woooooool0S?ooo`00Ooooo`030000oooooooo00;oool00`000?ooooooo`0:oooo00?o
09Woooooool0S?ooo`00O?ooo`D00003oooo0`0000[oool00ol0VOooooooo`2<oooo001loooo00@0
003oooooool0002Poooo001moooo00<0003oool00000X?ooo`00O_ooo`80002Poooo003ooooo8Ooo
o`00ooooob7oool007Woool00`000?ooooooo`0Xoooo00<0003oooooool0NOooo`00N?ooo`030000
oooooooo00Soool00`000?ooooooo`0Ooooo00<0003oooooool0N?ooo`00N?ooo`030000oooooooo
00;oool200001?ooo`030000oooooooo00goool200001?ooo`800005oooo0`0000;oool00`000?oo
ooooo`1hoooo001hoooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?oo
ooooo`04oooo100000?oool010000?ooooooo`0000_oool01@000?ooooooooooo`00001joooo001g
oooo00<0003oooooool00_ooo`030000oooooooo01?oool010000?ooooooo`0000Soool500000ooo
o`030000oooooooo07Ooool007Soool00`000?ooooooo`0500004_ooo`040000oooooooo00002?oo
o`040000oooooooo00000oooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`00000E
oooo00@0003oooooool00009oooo00<0003oool000000oooo`030000oooooooo07Soool007Woool0
0`000?ooooooo`0Goooo0P0000_oool200000_ooo`030000oooooooo07Woool00?oooolQoooo003o
oooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-6.03535, \
-3.20105, 0.0455524, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-6.03535, -3.20105, 0.0455524, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.30316 .26487 L
.34309 .26487 L
.3815 .26487 L
.42237 .26487 L
.46172 .26487 L
.49955 .26487 L
.5095 .26487 L
.51896 .26487 L
.52148 .26487 L
.52417 .26487 L
.52497 .26487 L
.52572 .26487 L
s
.52572 .26487 m
.52599 .61803 L
s
0 .4 1 r
.02381 .26471 m
.04262 .26467 L
.06244 .26461 L
.08255 .26455 L
.10458 .26445 L
.12415 .26435 L
.14509 .2642 L
.16639 .26402 L
.18653 .26379 L
.22495 .2632 L
.24479 .26278 L
.26581 .26223 L
.30365 .26092 L
.34394 .25907 L
.38271 .25722 L
.39281 .25683 L
.39815 .25666 L
.40384 .2565 L
.40931 .25638 L
.41426 .2563 L
.41665 .25627 L
.41924 .25624 L
.42043 .25623 L
.42169 .25622 L
.42276 .25622 L
.42393 .25621 L
.42524 .25621 L
.42644 .25621 L
.42707 .25621 L
.42777 .25621 L
.42849 .25621 L
.42917 .25621 L
.43042 .25622 L
.43156 .25622 L
.43282 .25623 L
.43414 .25624 L
.43858 .25629 L
.4411 .25633 L
.44344 .25637 L
.45356 .25661 L
.46436 .25697 L
.48427 .25783 L
.49476 .25833 L
.50586 .25889 L
.51576 .25938 L
.51848 .25951 L
.52139 .25965 L
.5228 .25972 L
.52414 .25979 L
.52535 .25984 L
Mistroke
.52666 .26487 L
.52796 .26487 L
.52919 .26487 L
.53148 .26487 L
.53661 .26487 L
.54584 .26487 L
.58444 .26487 L
.6255 .26487 L
.66504 .26487 L
.70306 .26487 L
.74354 .26487 L
.7825 .26487 L
.82391 .26487 L
.86381 .26487 L
.90219 .26487 L
.94302 .26487 L
.97619 .26487 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001moooo0P000:7oool007coool010000?ooooooo`000:3oool007koool00`000?oo
ooooo`03oooo0`0009Woool007Koool400001Oooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo001loooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007coool200001_ooo`<0002I
oooo001foooo1P000004<ol00000000000001?ooo`030000oooooooo09Woool007Soool01@0003?o
03?o03?o00000002<ol00P0000?oool00`000?ooooooo`2Ioooo001goooo00<0000co`0co`000c?o
00800002<ol00P000003oooo0000oooo09[oool007Koool00`0003?o03?o000:<ol00P0009_oool0
07Goool00`0003?o03?o000<<ol00P0009[oool007Coool00`0003?o03?o000=<ol000<0003ooooo
ool0VOooo`00Loooo`030000<ol0<ol000hco`020000V_ooo`00Loooo`030000<ol0<ol000hco`00
0`0003?o0000002Ioooo001boooo00<0000co`0co`003c?o008000000c?o00000?ooo`2Goooo001b
oooo00<0000co`0co`003c?o00040000<ol0<ol00000V?ooo`00LOooo`030000<ol0<ol0010co`00
1@0003?o03?o03?o0000002Goooo001aoooo00<0000co`0co`0043?o00030000<ol0<ol0008co`00
0`000?ooooooo`2Doooo001`oooo00<0000co`0co`004C?o00030000<ol0<ol0008co`000`000?oo
ooooo`2Doooo001_oooo00<0000co`0co`004S?o00800004<ol000<0003oooooool0Toooo`00K_oo
o`030000<ol0<ol001<co`000`0003?o03?o0004<ol000<0003oooooool0T_ooo`00K_ooo`030000
<ol0<ol001<co`000`0003?o03?o0004<ol000<0003oooooool0T_ooo`00KOooo`030000<ol0<ol0
01@co`000`0003?o03?o0005<ol000<0003oooooool0TOooo`00K?ooo`030000<ol0<ol001Dco`02
00001c?o00030000oooooooo093oool006_oool00`0003?o03?o000F<ol000<0000co`0co`001S?o
00030000oooooooo093oool006_oool00`0003?o03?o000F<ol000<0000co`0co`001c?o00030000
oooooooo08ooool006[oool00`0003?o03?o000?<ol01@0000<co`000`0003?o03?o0008<ol000<0
003oooooool0S_ooo`00JOooo`030000<ol0<ol0018co`000`0003?o03?o0003<ol000<0000co`0c
o`0023?o00030000oooooooo08koool006Soool00`0003?o03?o000C<ol000<0000co`0co`000c?o
00<00009<ol000<0003oooooool0SOooo`00J?ooo`030000<ol0<ol000/co`04000013?o00030000
<ol0<ol000<co`000`0003?o03?o000:<ol000<0003oooooool0S?ooo`00Ioooo`030000<ol0<ol0
01@co`000`0003?o03?o0003<ol000<0000co`0co`002c?o00030000oooooooo08_oool006Koool0
0`0003?o03?o000D<ol00P0000Dco`000`0003?o03?o000;<ol000<0003oooooool0Roooo`00I_oo
o`030000<ol0<ol001/co`0200003C?o00030000oooooooo08[oool006Goool00`0003?o03?o000L
<ol000<0000co`0co`003C?o00030000oooooooo08Woool006Coool00`0003?o03?o000M<ol000<0
000co`0co`003S?o00030000oooooooo08Soool006?oool00`0003?o03?o000N<ol000<0000co`0c
o`003c?o00030000oooooooo08Ooool006?oool00`0003?o03?o000N<ol000<0000co`0co`0043?o
00030000oooooooo08Koool006;oool00`0003?o03?o000O<ol00P00018co`000`000?ooooooo`25
oooo001Qoooo00<0000co`0co`0083?o00030000<ol0<ol0018co`000`000?ooooooo`24oooo000_
oooo0`0002Ooool400000_ooo`80000S<ol000<0000co`0co`004c?o00030000oooooooo017oool4
0000:_ooo`<0000Woooo0`0001Ooool0033oool00`000?ooooooo`0Voooo00<0003oooooool00_oo
o`030000<ol0<ol002<co`000`0003?o03?o000D<ol000<0003oooooool04?ooo`030000oooooooo
02coool00`000?ooooooo`0Voooo00@0003oooooool0000Foooo000]oooo1@0002Soool010000?oo
ooooo`0002Hco`0200005S?o0080000Aoooo00<0003oooooool0:?ooo`D0000Woooo00@0003ooooo
ool0000Foooo000Woooo100000;oool010000?ooooooo`0002;oool400001?ooo`80000W<ol000<0
000co`0co`005c?o00030000oooooooo00ooool00`000?ooooooo`0Woooo00@0003oooooool0000X
oooo0`0001Ooool002koool00`000?ooo`00000Xoooo0P000003<ol00000<ol002Hco`000`0003?o
03?o000H<ol000<0003oooooool03?ooo`040000oooooooo0000:Oooo`030000oooo000002Woool0
0`000?ooooooo`0Foooo000_oooo0P0002Ooool40000:3?o00030000<ol0<ol001Tco`000`000?oo
ooooo`0<oooo0P0002_oool20000:Oooo`<0000Foooo001Foooo0P0002`co`000`0003?o03?o000J
<ol00P0007goool005Coool20000;S?o0080000M<ol00`0007[oool0057oool30000<3?o00030000
<ol0<ol001lco`060000M?ooo`00Boooo`H0000L<ol05`1Vo`03000006Ko06Ko00H0I_lO<ol00`00
077oool0047oool:00003S?o01@0I_lG<ol000<0000co`0co`001S?o00T0I_lI<ol02P0006Ooool0
013ooooo00004Oooo`005_ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003ooooo
ool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000
oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool0
0`000?ooooooo`08oooo00<0003oooooool00oooo`03o`2Ioooooooo00;oool00`000?ooooooo`08
oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003ooooo
ool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000
oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool05Oooo`00;?ooo`030000oooooooo
02Woool00`000?ooooooo`0Yoooo00<0003oooooool03_ooo`03o`2Ioooooooo01Soool00`000?oo
ooooo`0Yoooo00<0003oooooool0:Oooo`030000oooooooo01Goool008Coool00`000?ooooooo`0>
oooo00?o09Woooooool0R?ooo`00Q?ooo`030000oooooooo00koool00ol0VOooooooo`28oooo0024
oooo0P0000ooool00ol0VOooooooo`28oooo0024oooo00<0003oooooool03_ooo`03o`2Ioooooooo
08Soool008Coool00`000?ooooooo`0>oooo00?o09Woooooool0R?ooo`00Q?ooo`030000oooooooo
00koool00ol0VOooooooo`28oooo0024oooo0P0000ooool00ol0VOooooooo`28oooo0024oooo00<0
003oooooool03_ooo`03o`2Ioooooooo08Soool008Coool00`000?ooooooo`0>oooo00?o09Wooooo
ool0R?ooo`00Q?ooo`030000oooooooo00koool00ol0VOooooooo`28oooo0024oooo00<0003ooooo
ool03_ooo`03o`2Ioooooooo08Soool008Coool200003oooo`03o`2Ioooooooo08Soool008Coool0
0`000?ooooooo`0>oooo00?o09Woooooool0R?ooo`00Q?ooo`030000oooooooo00koool00ol0VOoo
ooooo`28oooo0024oooo00<0003oooooool03_ooo`03o`2Ioooooooo08Soool008Coool200003ooo
o`03o`2Ioooooooo08Soool008Coool00`000?ooooooo`0>oooo00?o09Woooooool0R?ooo`00Q?oo
o`030000oooooooo00koool00ol0VOooooooo`28oooo001loooo1@0000?oool00`000?ooooooo`0>
oooo00?o09Woooooool0R?ooo`00O_ooo`030000oooooooo00?oool00`000?ooooooo`0>oooo00?o
09Woooooool0R?ooo`00O_ooo`030000oooooooo00?oool300003_ooo`03o`2Ioooooooo08Soool0
07koool00`000?ooooooo`03oooo00<0003oooooool03_ooo`03o`2Ioooooooo08Soool007koool0
0`000?ooooooo`03oooo00<0003oooooool03_ooo`03o`2Ioooooooo08Soool007goool200001Ooo
o`030000oooooooo00koool00ol0VOooooooo`28oooo0024oooo0P0000ooool00ol0VOooooooo`28
oooo0024oooo00<0003oooooool03_ooo`03o`2Ioooooooo08Soool008Coool00`000?ooooooo`0>
oooo00?o09Woooooool0R?ooo`00Q?ooo`030000oooooooo00koool00ol0VOooooooo`28oooo0024
oooo00<0003oooooool03_ooo`03o`2Ioooooooo08Soool008Coool200003oooo`03o`2Ioooooooo
08Soool008Coool00`000?ooooooo`0>oooo00?o09Woooooool0R?ooo`00Q?ooo`030000oooooooo
00koool00ol0VOooooooo`28oooo0024oooo00<0003oooooool03_ooo`03o`2Ioooooooo08Soool0
08Coool200003oooo`03o`2Ioooooooo08Soool008Coool00`000?ooooooo`0>oooo00?o09Wooooo
ool0R?ooo`00Q?ooo`030000oooooooo00koool00ol0VOooooooo`28oooo0024oooo00<0003ooooo
ool03_ooo`03o`2Ioooooooo08Soool008Coool00`000?ooooooo`0>oooo00?o09Woooooool0R?oo
o`00Q?ooo`80000?oooo00?o09Woooooool0R?ooo`00Q?ooo`030000oooooooo00koool00ol0VOoo
ooooo`28oooo001loooo100000Coool00`000?ooooooo`0>oooo00?o09Woooooool0R?ooo`00O?oo
o`030000oooooooo00Goool00`000?ooooooo`0>oooo00?o09Woooooool0R?ooo`00OOooo`030000
oooooooo00Coool300003_ooo`03o`2Ioooooooo08Soool007koool00`000?ooooooo`03oooo00<0
003oooooool03oooo`03o`2Ioooooooo08Ooool007coool010000?ooooooo`0000Coool00`000?oo
ooooo`0?oooo00?o09Woooooool0Qoooo`00OOooo`800005oooo00<0003oooooool03oooo`03o`2I
oooooooo08Ooool008Coool200004?ooo`03o`2Ioooooooo08Ooool008Coool00`000?ooooooo`0?
oooo00?o09Woooooool0Qoooo`00Q?ooo`030000oooooooo00ooool00ol0VOooooooo`27oooo0024
oooo00<0003oooooool03oooo`03o`2Ioooooooo08Ooool008Coool00`000?ooooooo`0?oooo00?o
09Woooooool0Qoooo`00Q?ooo`80000@oooo00?o09Woooooool0Qoooo`00Q?ooo`030000oooooooo
00ooool00ol0VOooooooo`27oooo0024oooo00<0003oooooool03oooo`03o`2Ioooooooo08Ooool0
08Coool00`000?ooooooo`0?oooo00?o09Woooooool0Qoooo`00Q?ooo`80000@oooo00?o09Wooooo
ool0Qoooo`00Q?ooo`030000oooooooo00ooool00ol0VOooooooo`27oooo0024oooo00<0003ooooo
ool03oooo`03o`2Ioooooooo08Ooool008Coool00`000?ooooooo`0?oooo00?o09Woooooool0Qooo
o`00Q?ooo`030000oooooooo00ooool00ol0VOooooooo`27oooo0024oooo0P00013oool00ol0VOoo
ooooo`27oooo0024oooo00<0003oooooool03oooo`03o`2Ioooooooo08Ooool007goool200001Ooo
o`030000oooooooo00ooool00ol0VOooooooo`27oooo001loooo00@0003oooooool00004oooo00<0
003oooooool03oooo`03o`2Ioooooooo08Ooool007koool00`000?ooooooo`03oooo0`0000ooool0
0ol0VOooooooo`27oooo001ooooo00<0003oooooool00_ooo`030000oooooooo00ooool00ol0VOoo
ooooo`27oooo001loooo00@0003oooooool00004oooo00<0003oooooool03oooo`03o`2Ioooooooo
08Ooool007goool200001Oooo`030000oooooooo00ooool00ol0VOooooooo`27oooo0024oooo00<0
003oooooool03oooo`03o`2Ioooooooo08Ooool008Coool200004?ooo`03o`2Ioooooooo08Ooool0
08Coool00`000?ooooooo`0?oooo00?o09Woooooool0Qoooo`00Q?ooo`030000oooooooo00ooool0
0ol0VOooooooo`27oooo0024oooo00<0003oooooool03oooo`03o`2Ioooooooo08Ooool008Coool2
00004?ooo`03o`2Ioooooooo08Ooool008Coool00`000?ooooooo`0?oooo00?o09Woooooool0Qooo
o`00Q?ooo`030000oooooooo00ooool00ol0VOooooooo`27oooo0024oooo00<0003oooooool03ooo
o`03o`2Ioooooooo08Ooool008Coool00`000?ooooooo`0?oooo00?o09Woooooool0Qoooo`00Q?oo
o`80000@oooo00?o09Woooooool0Qoooo`00Q?ooo`030000oooooooo00ooool00ol0VOooooooo`27
oooo0024oooo00<0003oooooool03oooo`03o`2Ioooooooo08Ooool008Coool00`000?ooooooo`0?
oooo00?o09Woooooool0Qoooo`00Q?ooo`80000@oooo00?o09Woooooool0Qoooo`00Q?ooo`030000
oooooooo00ooool00ol0VOooooooo`27oooo0024oooo00<0003oooooool03oooo`03o`2Ioooooooo
08Ooool007koool300000oooo`030000oooooooo00ooool00ol0VOooooooo`27oooo001ooooo00<0
003oooooool00_ooo`030000oooooooo00ooool00ol0VOooooooo`27oooo001loooo1@0000?oool3
00003oooo`03o`2Ioooooooo08Ooool007coool010000?ooooooo`000:3oool007goool00`000?oo
o`00002Poooo001noooo0P000:3oool00?oooolQoooo003ooooo8Oooo`00NOooo`030000oooooooo
02Soool00`000?ooooooo`1ioooo001hoooo00<0003oooooool02?ooo`030000oooooooo01ooool0
0`000?ooooooo`1hoooo001hoooo00<0003oooooool00_ooo`800004oooo00<0003oooooool03Ooo
o`800004oooo0P0000?oool400000oooo`030000oooooooo07Soool007Soool01@000?oooooooooo
o`000002oooo00<0003oooooool00_ooo`030000oooooooo00Coool400000oooo`040000oooooooo
00002?ooo`030000oooooooo00Coool00`000?ooooooo`1hoooo001goooo00<0003oooooool00_oo
o`030000oooooooo01?oool010000?ooooooo`0000Woool00`000?ooooooo`04oooo00<0003ooooo
ool0Moooo`00N?ooo`030000oooooooo00D0000Boooo00@0003oooooool0000:oooo00<0003ooooo
ool00_ooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`00000Eoooo00@0003ooooo
ool00008oooo00@0003oooooool00003oooo00<0003oooooool0N?ooo`00NOooo`030000oooooooo
01Ooool200002_ooo`800003oooo00<0003oooooool0NOooo`00ooooob7oool00?oooolQoooo0000
\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-6.03535, \
-3.20105, 0.0455524, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-6.03535, -3.20105, 0.0455524, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -21.7813 0 ]
[.5 .63053 21.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -82.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
96.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.30316 .26487 L
.34309 .26487 L
.3815 .26487 L
.42237 .26487 L
.46172 .26487 L
.49955 .26487 L
.52059 .26487 L
.53057 .26487 L
.53543 .26487 L
.53984 .26487 L
.54098 .26487 L
.54221 .26487 L
s
.54221 .26487 m
.54267 .61803 L
s
0 .4 1 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.30316 .26487 L
.34309 .26487 L
.3815 .26487 L
.42237 .26487 L
.46172 .26487 L
.49955 .26487 L
.53984 .26487 L
.57861 .26487 L
.61984 .26487 L
.65954 .26487 L
.69774 .26487 L
.73838 .26487 L
.77751 .26487 L
.81909 .26487 L
.85916 .26487 L
.89771 .26487 L
.93871 .26487 L
.97619 .26487 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -21.7813 0 ]
[.5 .63053 21.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -82.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
96.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001moooo0P000:7oool007coool010000?ooooooo`000:3oool007koool00`000?oo
ooooo`03oooo0`0009Woool007Koool400001Oooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo001loooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007coool200001_ooo`<0002I
oooo001foooo1P000004<ol00000000000001?ooo`030000oooooooo09Woool007Soool01@0003?o
03?o03?o00000002<ol00P0000?oool00`000?ooooooo`2Ioooo001goooo00<0000co`0co`000c?o
00800002<ol00P000003oooo0000oooo09[oool007Koool00`0003?o03?o000:<ol00P0009_oool0
07Goool00`0003?o03?o000<<ol00P0009[oool007Coool00`0003?o03?o000=<ol000<0003ooooo
ool0VOooo`00Loooo`030000<ol0<ol000hco`020000V_ooo`00Loooo`030000<ol0<ol000hco`00
0`0003?o0000002Ioooo001boooo00<0000co`0co`003c?o008000000c?o00000?ooo`2Goooo001b
oooo00<0000co`0co`003c?o00040000<ol0<ol00000V?ooo`00LOooo`030000<ol0<ol0010co`00
1@0003?o03?o03?o0000002Goooo001aoooo00<0000co`0co`0043?o00030000<ol0<ol0008co`00
0`000?ooooooo`2Doooo001`oooo00<0000co`0co`004C?o00030000<ol0<ol0008co`000`000?oo
ooooo`2Doooo001_oooo00<0000co`0co`004S?o00800004<ol000<0003oooooool0Toooo`00K_oo
o`030000<ol0<ol001<co`000`0003?o03?o0004<ol000<0003oooooool0T_ooo`00K_ooo`030000
<ol0<ol001<co`000`0003?o03?o0004<ol000<0003oooooool0T_ooo`00KOooo`030000<ol0<ol0
01@co`000`0003?o03?o0005<ol000<0003oooooool0TOooo`00K?ooo`030000<ol0<ol001Dco`02
00001c?o00030000oooooooo093oool006_oool00`0003?o03?o000F<ol000<0000co`0co`001S?o
00030000oooooooo093oool006_oool00`0003?o03?o000F<ol000<0000co`0co`001c?o00030000
oooooooo08ooool006[oool00`0003?o03?o000?<ol01@0000<co`000`0003?o03?o0008<ol000<0
003oooooool0S_ooo`00JOooo`030000<ol0<ol0018co`000`0003?o03?o0003<ol000<0000co`0c
o`0023?o00030000oooooooo08koool006Soool00`0003?o03?o000C<ol000<0000co`0co`000c?o
00<00009<ol000<0003oooooool0SOooo`00J?ooo`030000<ol0<ol000/co`04000013?o00030000
<ol0<ol000<co`000`0003?o03?o000:<ol000<0003oooooool0S?ooo`00Ioooo`030000<ol0<ol0
01@co`000`0003?o03?o0003<ol000<0000co`0co`002c?o00030000oooooooo08_oool006Koool0
0`0003?o03?o000D<ol00P0000Dco`000`0003?o03?o000;<ol000<0003oooooool0Roooo`00I_oo
o`030000<ol0<ol001/co`0200003C?o00030000oooooooo08[oool006Goool00`0003?o03?o000L
<ol000<0000co`0co`003C?o00030000oooooooo08Woool006Coool00`0003?o03?o000M<ol000<0
000co`0co`003S?o00030000oooooooo08Soool006?oool00`0003?o03?o000N<ol000<0000co`0c
o`003c?o00030000oooooooo08Ooool006?oool00`0003?o03?o000N<ol000<0000co`0co`0043?o
00030000oooooooo08Koool006;oool00`0003?o03?o000O<ol00P00018co`000`000?ooooooo`25
oooo001Qoooo00<0000co`0co`0083?o00030000<ol0<ol0018co`000`000?ooooooo`24oooo000_
oooo0`0002Ooool400000_ooo`80000S<ol000<0000co`0co`004c?o00030000oooooooo017oool4
0000:_ooo`<0000Woooo0`0001Ooool0033oool00`000?ooooooo`0Voooo00<0003oooooool00_oo
o`030000<ol0<ol002<co`000`0003?o03?o000D<ol000<0003oooooool04?ooo`030000oooooooo
02coool00`000?ooooooo`0Voooo00@0003oooooool0000Foooo000]oooo1@0002Soool010000?oo
ooooo`0002Hco`0200005S?o0080000Aoooo00<0003oooooool0:?ooo`D0000Woooo00@0003ooooo
ool0000Foooo000Woooo100000;oool010000?ooooooo`0002;oool400001?ooo`80000W<ol000<0
000co`0co`005c?o00030000oooooooo00ooool00`000?ooooooo`0Woooo00@0003oooooool0000X
oooo0`0001Ooool002koool00`000?ooo`00000Xoooo0P000003<ol00000<ol002Hco`000`0003?o
03?o000H<ol000<0003oooooool03?ooo`040000oooooooo0000:Oooo`030000oooo000002Woool0
0`000?ooooooo`0Foooo000_oooo0P0002Ooool40000:3?o00030000<ol0<ol001Tco`000`000?oo
ooooo`0<oooo0P0002_oool20000:Oooo`<0000Foooo001Foooo0P0002`co`000`0003?o03?o000J
<ol00P0007goool005Coool20000;S?o0080000M<ol00`0007[oool0057oool30000<3?o00030000
<ol0<ol001lco`060000M?ooo`00Boooo`H0000c<ol000<0000co`0co`009C?o00<0001aoooo0011
oooo2P0003Tco`000`0003?o03?o000X<ol02P0006Ooool0013ooooo00004Oooo`005_ooo`030000
oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool0
0`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08
oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003ooooo
ool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000
oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool0
0`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`0E
oooo000/oooo00<0003oooooool0:Oooo`030000oooooooo02Woool00`000?ooooooo`0Coooo00?o
09Woooooool04oooo`030000oooooooo02Woool00`000?ooooooo`0Yoooo00<0003oooooool05Ooo
o`00Q?ooo`030000oooooooo01?oool00ol0VOooooooo`23oooo0024oooo00<0003oooooool04ooo
o`03o`2Ioooooooo08?oool008Coool200005?ooo`03o`2Ioooooooo08?oool008Coool00`000?oo
ooooo`0Coooo00?o09Woooooool0Poooo`00Q?ooo`030000oooooooo01?oool00ol0VOooooooo`23
oooo0024oooo00<0003oooooool04oooo`03o`2Ioooooooo08?oool008Coool200005?ooo`03o`2I
oooooooo08?oool008Coool00`000?ooooooo`0Coooo00?o09Woooooool0Poooo`00Q?ooo`030000
oooooooo01?oool00ol0VOooooooo`23oooo0024oooo00<0003oooooool04oooo`03o`2Ioooooooo
08?oool008Coool00`000?ooooooo`0Coooo00?o09Woooooool0Poooo`00Q?ooo`80000Doooo00?o
09Woooooool0Poooo`00Q?ooo`030000oooooooo01?oool00ol0VOooooooo`23oooo0024oooo00<0
003oooooool04oooo`03o`2Ioooooooo08?oool008Coool00`000?ooooooo`0Coooo00?o09Wooooo
ool0Poooo`00Q?ooo`80000Doooo00?o09Woooooool0Poooo`00Q?ooo`030000oooooooo01?oool0
0ol0VOooooooo`23oooo0024oooo00<0003oooooool04oooo`03o`2Ioooooooo08?oool007coool5
00000oooo`030000oooooooo01?oool00ol0VOooooooo`23oooo001noooo00<0003oooooool00ooo
o`030000oooooooo01?oool00ol0VOooooooo`23oooo001noooo00<0003oooooool00oooo`<0000C
oooo00?o09Woooooool0Poooo`00O_ooo`030000oooooooo00?oool00`000?ooooooo`0Coooo00?o
09Woooooool0Poooo`00O_ooo`030000oooooooo00?oool00`000?ooooooo`0Coooo00?o09Wooooo
ool0Poooo`00OOooo`800005oooo00<0003oooooool04oooo`03o`2Ioooooooo08?oool008Coool2
00005?ooo`03o`2Ioooooooo08?oool008Coool00`000?ooooooo`0Coooo00?o09Woooooool0Pooo
o`00Q?ooo`030000oooooooo01?oool00ol0VOooooooo`23oooo0024oooo00<0003oooooool04ooo
o`03o`2Ioooooooo08?oool008Coool00`000?ooooooo`0Coooo00?o09Woooooool0Poooo`00Q?oo
o`80000Doooo00?o09Woooooool0Poooo`00Q?ooo`030000oooooooo01?oool00ol0VOooooooo`23
oooo0024oooo00<0003oooooool04oooo`03o`2Ioooooooo08?oool008Coool00`000?ooooooo`0C
oooo00?o09Woooooool0Poooo`00Q?ooo`80000Doooo00?o09Woooooool0Poooo`00Q?ooo`030000
oooooooo01?oool00ol0VOooooooo`23oooo0024oooo00<0003oooooool04oooo`03o`2Ioooooooo
08?oool008Coool00`000?ooooooo`0Coooo00?o09Woooooool0Poooo`00Q?ooo`030000oooooooo
01?oool00ol0VOooooooo`23oooo0024oooo0P0001Coool00ol0VOooooooo`23oooo0024oooo00<0
003oooooool04oooo`03o`2Ioooooooo08?oool007coool400001?ooo`030000oooooooo01?oool0
0ol0VOooooooo`23oooo001loooo00<0003oooooool01Oooo`030000oooooooo01?oool00ol0VOoo
ooooo`23oooo001moooo00<0003oooooool01?ooo`<0000Coooo00?o09Woooooool0Poooo`00O_oo
o`030000oooooooo00?oool00`000?ooooooo`0Coooo00?o09Woooooool0Poooo`00O?ooo`040000
oooooooo00001?ooo`030000oooooooo01?oool00ol0VOooooooo`23oooo001moooo0P0000Goool0
0`000?ooooooo`0Coooo00?o09Woooooool0Poooo`00Q?ooo`80000Doooo00?o09Woooooool0Pooo
o`00Q?ooo`030000oooooooo01?oool00ol0VOooooooo`23oooo0024oooo00<0003oooooool04ooo
o`03o`2Ioooooooo08?oool008Coool00`000?ooooooo`0Coooo00?o09Woooooool0Poooo`00Q?oo
o`030000oooooooo01?oool00ol0VOooooooo`23oooo0024oooo0P0001Coool00ol0VOooooooo`23
oooo0024oooo00<0003oooooool04oooo`03o`2Ioooooooo08?oool008Coool00`000?ooooooo`0C
oooo00?o09Woooooool0Poooo`00Q?ooo`030000oooooooo01?oool00ol0VOooooooo`23oooo0024
oooo0P0001Coool00ol0VOooooooo`23oooo0024oooo00<0003oooooool04oooo`03o`2Ioooooooo
08?oool008Coool00`000?ooooooo`0Coooo00?o09Woooooool0Poooo`00Q?ooo`030000oooooooo
01?oool00ol0VOooooooo`23oooo0024oooo00<0003oooooool04oooo`03o`2Ioooooooo08?oool0
08Coool200005?ooo`03o`2Ioooooooo08?oool008Coool00`000?ooooooo`0Coooo00?o09Wooooo
ool0Poooo`00OOooo`800005oooo00<0003oooooool04oooo`03o`2Ioooooooo08?oool007coool0
10000?ooooooo`0000Coool00`000?ooooooo`0Coooo00?o09Woooooool0Poooo`00O_ooo`030000
oooooooo00?oool300004oooo`03o`2Ioooooooo08?oool007ooool00`000?ooooooo`02oooo00<0
003oooooool04oooo`03o`2Ioooooooo08?oool007coool010000?ooooooo`0000Coool00`000?oo
ooooo`0Coooo00?o09Woooooool0Poooo`00OOooo`800005oooo00<0003oooooool04oooo`03o`2I
oooooooo08?oool008Coool00`000?ooooooo`0Coooo00?o09Woooooool0Poooo`00Q?ooo`80000D
oooo00?o09Woooooool0Poooo`00Q?ooo`030000oooooooo01?oool00ol0VOooooooo`23oooo0024
oooo00<0003oooooool04oooo`03o`2Ioooooooo08?oool008Coool00`000?ooooooo`0Coooo00?o
09Woooooool0Poooo`00Q?ooo`80000Doooo00?o09Woooooool0Poooo`00Q?ooo`030000oooooooo
01?oool00ol0VOooooooo`23oooo0024oooo00<0003oooooool04oooo`03o`2Ioooooooo08?oool0
08Coool00`000?ooooooo`0Coooo00?o09Woooooool0Poooo`00Q?ooo`030000oooooooo01?oool0
0ol0VOooooooo`23oooo0024oooo0P0001Coool00ol0VOooooooo`23oooo0024oooo00<0003ooooo
ool04oooo`03o`2Ioooooooo08?oool008Coool00`000?ooooooo`0Coooo00?o09Woooooool0Pooo
o`00Q?ooo`030000oooooooo01?oool00ol0VOooooooo`23oooo0024oooo0P0001Coool00ol0VOoo
ooooo`23oooo0024oooo00<0003oooooool04oooo`03o`2Ioooooooo08?oool008Coool00`000?oo
ooooo`0Coooo00?o09Woooooool0Poooo`00O_ooo`<00003oooo00<0003oooooool04oooo`03o`2I
oooooooo08?oool007ooool00`000?ooooooo`02oooo00<0003oooooool04oooo`03o`2Ioooooooo
08?oool007coool500000oooo`<0000Coooo00?o09Woooooool0Poooo`00O?ooo`040000oooooooo
0000X?ooo`00OOooo`030000oooo00000:3oool007koool20000X?ooo`00ooooob7oool00?oooolQ
oooo001ooooo00<0003oooooool07?ooo`030000oooooooo07ooool007koool00`000?ooooooo`08
oooo00<0003oooooool04oooo`030000oooooooo07koool007koool00`000?ooooooo`02oooo0P00
00Coool00`000?ooooooo`07oooo0P0000Coool200001?ooo`030000oooooooo07koool007koool0
1@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo00Goool010000?oo
ooooo`0000Woool00`000?ooooooo`1noooo001moooo00<0003oooooool00_ooo`030000oooooooo
00goool010000?ooooooo`0000[oool00`000?ooooooo`1moooo001noooo00<0003oooooool01@00
00coool010000?ooooooo`0000Woool00`000?ooooooo`1noooo001noooo00D0003oooooooooool0
00003oooo`040000oooooooo00002Oooo`030000oooooooo07koool007ooool00`000?ooooooo`0A
oooo0P0000Woool00`000?ooooooo`1ooooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-6.03535, \
-3.20105, 0.0455524, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-6.03535, -3.20105, 0.0455524, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.30316 .26487 L
.34309 .26487 L
.3815 .26487 L
.42237 .26487 L
.46172 .26487 L
.49955 .26487 L
.52059 .26487 L
.53984 .26487 L
.54934 .26487 L
.55436 .26487 L
.55712 .26487 L
.55847 .26487 L
.55972 .26487 L
s
.55972 .26487 m
.5602 .61803 L
s
0 .4 1 r
.02381 .26504 m
.04262 .26508 L
.06244 .26513 L
.08255 .2652 L
.10458 .26529 L
.12415 .2654 L
.14509 .26554 L
.16639 .26573 L
.18653 .26595 L
.22495 .26654 L
.24479 .26696 L
.26581 .26751 L
.30365 .26882 L
.34394 .27067 L
.38271 .27252 L
.39281 .27291 L
.39815 .27308 L
.40384 .27324 L
.40931 .27336 L
.41426 .27345 L
.41665 .27348 L
.41924 .2735 L
.42043 .27351 L
.42169 .27352 L
.42276 .27352 L
.42393 .27353 L
.42524 .27353 L
.42644 .27353 L
.42707 .27353 L
.42777 .27353 L
.42849 .27353 L
.42917 .27353 L
.43042 .27353 L
.43156 .27352 L
.43282 .27351 L
.43414 .2735 L
.43858 .27345 L
.4411 .27342 L
.44344 .27337 L
.45356 .27313 L
.46436 .27277 L
.50586 .27085 L
.52666 .26984 L
.53579 .26942 L
.54584 .26899 L
.55049 .26879 L
.55549 .2686 L
.55791 .2685 L
.5591 .26846 L
.56021 .26842 L
Mistroke
.56121 .26487 L
.56227 .26487 L
.56452 .26487 L
.5843 .26487 L
.62594 .26487 L
.66606 .26487 L
.70466 .26487 L
.74572 .26487 L
.78526 .26487 L
.82328 .26487 L
.86376 .26487 L
.90272 .26487 L
.94413 .26487 L
.97619 .26487 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001moooo0P000:7oool007coool010000?ooooooo`000:3oool007koool00`000?oo
ooooo`03oooo0`0009Woool007Koool400001Oooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo001loooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007coool200001_ooo`<0002I
oooo001foooo1P000004<ol00000000000001?ooo`030000oooooooo09Woool007Soool01@0003?o
03?o03?o00000002<ol00P0000?oool00`000?ooooooo`2Ioooo001goooo00<0000co`0co`000c?o
00800002<ol00P000003oooo0000oooo09[oool007Koool00`0003?o03?o000:<ol00P0009_oool0
07Goool00`0003?o03?o000<<ol00P0009[oool007Coool00`0003?o03?o000=<ol000<0003ooooo
ool0VOooo`00Loooo`030000<ol0<ol000hco`020000V_ooo`00Loooo`030000<ol0<ol000hco`00
0`0003?o0000002Ioooo001boooo00<0000co`0co`003c?o008000000c?o00000?ooo`2Goooo001b
oooo00<0000co`0co`003c?o00040000<ol0<ol00000V?ooo`00LOooo`030000<ol0<ol0010co`00
1@0003?o03?o03?o0000002Goooo001aoooo00<0000co`0co`0043?o00030000<ol0<ol0008co`00
0`000?ooooooo`2Doooo001`oooo00<0000co`0co`004C?o00030000<ol0<ol0008co`000`000?oo
ooooo`2Doooo001_oooo00<0000co`0co`004S?o00800004<ol000<0003oooooool0Toooo`00K_oo
o`030000<ol0<ol001<co`000`0003?o03?o0004<ol000<0003oooooool0T_ooo`00K_ooo`030000
<ol0<ol001<co`000`0003?o03?o0004<ol000<0003oooooool0T_ooo`00KOooo`030000<ol0<ol0
01@co`000`0003?o03?o0005<ol000<0003oooooool0TOooo`00K?ooo`030000<ol0<ol001Dco`02
00001c?o00030000oooooooo093oool006_oool00`0003?o03?o000F<ol000<0000co`0co`001S?o
00030000oooooooo093oool006_oool00`0003?o03?o000F<ol000<0000co`0co`001c?o00030000
oooooooo08ooool006[oool00`0003?o03?o000?<ol01@0000<co`000`0003?o03?o0008<ol000<0
003oooooool0S_ooo`00JOooo`030000<ol0<ol0018co`000`0003?o03?o0003<ol000<0000co`0c
o`0023?o00030000oooooooo08koool006Soool00`0003?o03?o000C<ol000<0000co`0co`000c?o
00<00009<ol000<0003oooooool0SOooo`00J?ooo`030000<ol0<ol000/co`04000013?o00030000
<ol0<ol000<co`000`0003?o03?o000:<ol000<0003oooooool0S?ooo`00Ioooo`030000<ol0<ol0
01@co`000`0003?o03?o0003<ol000<0000co`0co`002c?o00030000oooooooo08_oool006Koool0
0`0003?o03?o000D<ol00P0000Dco`000`0003?o03?o000;<ol000<0003oooooool0Roooo`00I_oo
o`030000<ol0<ol001/co`0200003C?o00030000oooooooo08[oool006Goool00`0003?o03?o000L
<ol000<0000co`0co`003C?o00030000oooooooo08Woool006Coool00`0003?o03?o000M<ol000<0
000co`0co`003S?o00030000oooooooo08Soool006?oool00`0003?o03?o000N<ol000<0000co`0c
o`003c?o00030000oooooooo08Ooool006?oool00`0003?o03?o000N<ol000<0000co`0co`0043?o
00030000oooooooo08Koool006;oool00`0003?o03?o000O<ol00P00018co`000`000?ooooooo`25
oooo001Qoooo00<0000co`0co`0083?o00030000<ol0<ol0018co`000`000?ooooooo`24oooo000_
oooo0`0002Ooool400000_ooo`80000S<ol000<0000co`0co`004c?o00030000oooooooo017oool4
0000:_ooo`<0000Woooo0`0001Ooool0033oool00`000?ooooooo`0Voooo00<0003oooooool00_oo
o`030000<ol0<ol002<co`000`0003?o03?o000D<ol000<0003oooooool04?ooo`030000oooooooo
02coool00`000?ooooooo`0Voooo00@0003oooooool0000Foooo000]oooo1@0002Soool010000?oo
ooooo`0002Hco`0200005S?o0080000Aoooo00<0003oooooool0:?ooo`D0000Woooo00@0003ooooo
ool0000Foooo000Woooo100000;oool010000?ooooooo`0002;oool400001?ooo`80000W<ol000<0
000co`0co`005c?o00030000oooooooo00ooool00`000?ooooooo`0Woooo00@0003oooooool0000X
oooo0`0001Ooool002koool00`000?ooo`00000Xoooo0P000003<ol00000<ol002Hco`000`0003?o
03?o000H<ol000<0003oooooool03?ooo`040000oooooooo0000:Oooo`030000oooo000002Woool0
0`000?ooooooo`0Foooo000_oooo0P0002Ooool40000:3?o00030000<ol0<ol001Tco`000`000?oo
ooooo`0<oooo0P0002_oool20000:Oooo`<0000Foooo001Foooo0P0002`co`000`0003?o03?o000J
<ol00P0007goool005Coool20000;S?o0080000M<ol00`0007[oool0057oool30000<3?o00030000
<ol0<ol001lco`060000M?ooo`00Boooo`H0000c<ol000<0000co`0co`009C?o00<0001aoooo0011
oooo2P0003Tco`000`0003?o03?o000X<ol02P0006Ooool0013ooooo00004Oooo`005_ooo`030000
oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool0
0`000?ooo`1Vo`0806Ko00<00000I_l0I_l0201Vo`03000006Ko06Ko00L0I_l00oooo`000?ooo`09
oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003ooooo
ool00_ooo`H0I_l00`00001Vo`1Vo`0206Ko1_ooo`030000oooooooo00Soool00`000?ooooooo`08
oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003ooooo
ool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000
oooooooo01Goool002coool00`000?ooooooo`0Yoooo00<0003oooooool01oooob80I_l00`00001V
o`1Vo`0=06Ko2_ooo`03o`2Ioooooooo00ooool00`000?ooooooo`0Yoooo00<0003oooooool0:Ooo
o`030000oooooooo01Goool008Coool00`000?ooooooo`0Goooo00?o09Woooooool0Ooooo`00Q?oo
o`030000oooooooo01Ooool00ol0VOooooooo`1ooooo0024oooo0P0001Soool00ol0VOooooooo`1o
oooo0024oooo00<0003oooooool05oooo`03o`2Ioooooooo07ooool008Coool00`000?ooooooo`0G
oooo00?o09Woooooool0Ooooo`00Q?ooo`030000oooooooo01Ooool00ol0VOooooooo`1ooooo0024
oooo0P0001Soool00ol0VOooooooo`1ooooo0024oooo00<0003oooooool05oooo`03o`2Ioooooooo
07ooool008Coool00`000?ooooooo`0Goooo00?o09Woooooool0Ooooo`00Q?ooo`030000oooooooo
01Ooool00ol0VOooooooo`1ooooo0024oooo00<0003oooooool05oooo`03o`2Ioooooooo07ooool0
08Coool200006?ooo`03o`2Ioooooooo07ooool008Coool00`000?ooooooo`0Goooo00?o09Wooooo
ool0Ooooo`00Q?ooo`030000oooooooo01Ooool00ol0VOooooooo`1ooooo0024oooo00<0003ooooo
ool05oooo`03o`2Ioooooooo07ooool008Coool200006?ooo`03o`2Ioooooooo07ooool008Coool0
0`000?ooooooo`0Goooo00?o09Woooooool0Ooooo`00Q?ooo`030000oooooooo01Ooool00ol0VOoo
ooooo`1ooooo001loooo1@0000?oool00`000?ooooooo`0Goooo00?o09Woooooool0Ooooo`00O_oo
o`030000oooooooo00?oool00`000?ooooooo`0Goooo00?o09Woooooool0Ooooo`00O_ooo`030000
oooooooo00?oool300005oooo`03o`2Ioooooooo07ooool007koool00`000?ooooooo`03oooo00<0
003oooooool05oooo`03o`2Ioooooooo07ooool007koool00`000?ooooooo`03oooo00<0003ooooo
ool05oooo`03o`2Ioooooooo07ooool007goool200001Oooo`030000oooooooo01Ooool00ol0VOoo
ooooo`1ooooo0024oooo0P0001Soool00ol0VOooooooo`1ooooo0024oooo00<0003oooooool05ooo
o`03o`2Ioooooooo07ooool008Coool00`000?ooooooo`0Goooo00?o09Woooooool0Ooooo`00Q?oo
o`030000oooooooo01Ooool00ol0VOooooooo`1ooooo0024oooo00<0003oooooool05oooo`03o`2I
oooooooo07ooool008Coool200006?ooo`03o`2Ioooooooo07ooool008Coool00`000?ooooooo`0G
oooo00?o09Woooooool0Ooooo`00Q?ooo`030000oooooooo01Ooool00ol0VOooooooo`1ooooo0024
oooo00<0003oooooool05oooo`03o`2Ioooooooo07ooool008Coool200006?ooo`03o`2Ioooooooo
07ooool008Coool00`000?ooooooo`0Goooo00?o09Woooooool0Ooooo`00Q?ooo`030000oooooooo
01Ooool00ol0VOooooooo`1ooooo0024oooo00<0003oooooool05oooo`03o`2Ioooooooo07ooool0
08Coool00`000?ooooooo`0Goooo00?o09Woooooool0Ooooo`00Q?ooo`80000Hoooo00?o09Wooooo
ool0Ooooo`00Q?ooo`030000oooooooo01Ooool00ol0VOooooooo`1ooooo001loooo100000Coool0
0`000?ooooooo`0Goooo00?o09Woooooool0Ooooo`00O?ooo`030000oooooooo00Goool00`000?oo
ooooo`0Goooo00?o09Woooooool0Ooooo`00OOooo`030000oooooooo00Coool300005oooo`03o`2I
oooooooo07ooool007koool00`000?ooooooo`03oooo00<0003oooooool05oooo`03o`2Ioooooooo
07ooool007coool010000?ooooooo`0000Coool00`000?ooooooo`0Goooo00?o09Woooooool0Oooo
o`00OOooo`800005oooo00<0003oooooool05oooo`03o`2Ioooooooo07ooool008Coool200006?oo
o`03o`2Ioooooooo07ooool008Coool00`000?ooooooo`0Goooo00?o09Woooooool0Ooooo`00Q?oo
o`030000oooooooo01Ooool00ol0VOooooooo`1ooooo0024oooo00<0003oooooool05oooo`03o`2I
oooooooo07ooool008Coool00`000?ooooooo`0Goooo00?o09Woooooool0Ooooo`00Q?ooo`80000H
oooo00?o09Woooooool0Ooooo`00Q?ooo`030000oooooooo01Ooool00ol0VOooooooo`1ooooo0024
oooo00<0003oooooool05oooo`03o`2Ioooooooo07ooool008Coool00`000?ooooooo`0Goooo00?o
09Woooooool0Ooooo`00Q?ooo`80000Hoooo00?o09Woooooool0Ooooo`00Q?ooo`030000oooooooo
01Ooool00ol0VOooooooo`1ooooo0024oooo00<0003oooooool05oooo`03o`2Ioooooooo07ooool0
08Coool00`000?ooooooo`0Goooo00?o09Woooooool0Ooooo`00Q?ooo`030000oooooooo01Ooool0
0ol0VOooooooo`1ooooo0024oooo0P0001Soool00ol0VOooooooo`1ooooo0024oooo00<0003ooooo
ool05oooo`03o`2Ioooooooo07ooool007goool200001Oooo`030000oooooooo01Ooool00ol0VOoo
ooooo`1ooooo001loooo00@0003oooooool00004oooo00<0003oooooool05oooo`03o`2Ioooooooo
07ooool007koool00`000?ooooooo`03oooo0`0001Ooool00ol0VOooooooo`1ooooo001ooooo00<0
003oooooool00_ooo`030000oooooooo01Ooool00ol0VOooooooo`1ooooo001loooo00@0003ooooo
ool00004oooo00<0003oooooool05oooo`03o`2Ioooooooo07ooool007goool200001Oooo`030000
oooooooo01Ooool00ol0VOooooooo`1ooooo0024oooo00<0003oooooool05oooo`03o`2Ioooooooo
07ooool008Coool200006?ooo`03o`2Ioooooooo07ooool008Coool00`000?ooooooo`0Goooo00?o
09Woooooool0Ooooo`00Q?ooo`030000oooooooo01Ooool00ol0VOooooooo`1ooooo0024oooo00<0
003oooooool05oooo`03o`2Ioooooooo07ooool008Coool200006?ooo`03o`2Ioooooooo07ooool0
08Coool00`000?ooooooo`0Goooo00?o09Woooooool0Ooooo`00Q?ooo`030000oooooooo01Ooool0
0ol0VOooooooo`1ooooo0024oooo00<0003oooooool05oooo`03o`2Ioooooooo07ooool008Coool0
0`000?ooooooo`0Goooo00?o09Woooooool0Ooooo`00Q?ooo`80000Hoooo00?o09Woooooool0Oooo
o`00Q?ooo`030000oooooooo01Ooool00ol0VOooooooo`1ooooo0024oooo00<0003oooooool05ooo
o`03o`2Ioooooooo07ooool008Coool00`000?ooooooo`0Goooo00?o09Woooooool0Ooooo`00Q?oo
o`80000Hoooo00?o09Woooooool0Ooooo`00Q?ooo`030000oooooooo01Ooool00ol0VOooooooo`1o
oooo0024oooo00<0003oooooool05oooo`03o`2Ioooooooo07ooool007koool300000oooo`030000
oooooooo01Ooool00ol0VOooooooo`1ooooo001ooooo00<0003oooooool00_ooo`030000oooooooo
01Ooool00ol0VOooooooo`1ooooo001loooo1@0000?oool300005oooo`03o`2Ioooooooo07ooool0
07coool010000?ooooooo`000:3oool007goool00`000?ooo`00002Poooo001noooo0P000:3oool0
0?oooolQoooo003ooooo8Oooo`00O?ooo`030000oooooooo02;oool00`000?ooooooo`1loooo001k
oooo00<0003oooooool02?ooo`030000oooooooo01Woool00`000?ooooooo`1koooo001koooo00<0
003oooooool00_ooo`800004oooo00<0003oooooool01oooo`800004oooo0P0000?oool400000ooo
o`030000oooooooo07_oool007_oool01@000?ooooooooooo`000002oooo00<0003oooooool00_oo
o`030000oooooooo00Goool010000?ooooooo`0000Soool00`000?ooooooo`04oooo00<0003ooooo
ool0Noooo`00N_ooo`030000oooooooo00;oool00`000?ooooooo`0=oooo00@0003oooooool00009
oooo00<0003oooooool01?ooo`030000oooooooo07[oool007_oool00`000?ooooooo`0500003?oo
o`040000oooooooo00002_ooo`030000oooooooo00;oool00`000?ooooooo`1koooo001koooo00D0
003oooooooooool000003oooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000
oooooooo07_oool007coool00`000?ooooooo`0Aoooo0P0000[oool200000oooo`030000oooooooo
07coool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-6.03535, \
-3.20105, 0.0455524, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-6.03535, -3.20105, 0.0455524, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.30316 .26487 L
.34309 .26487 L
.3815 .26487 L
.42237 .26487 L
.46172 .26487 L
.49955 .26487 L
.52059 .26487 L
.53984 .26487 L
.54934 .26487 L
.55972 .26487 L
.56446 .26487 L
.56951 .26487 L
.57197 .26487 L
.57429 .26487 L
.57636 .26487 L
.57753 .26487 L
s
.57753 .26487 m
.57796 .61803 L
s
0 .4 1 r
.02381 .26521 m
.04262 .26529 L
.06244 .2654 L
.08255 .26554 L
.10458 .26573 L
.12415 .26594 L
.14509 .26624 L
.16639 .26662 L
.18653 .26707 L
.22495 .26828 L
.24479 .26913 L
.26581 .27025 L
.30365 .27293 L
.34394 .27671 L
.38271 .28048 L
.39281 .28127 L
.39815 .28162 L
.40384 .28194 L
.40931 .28219 L
.41426 .28236 L
.41665 .28243 L
.41924 .28248 L
.42043 .2825 L
.42169 .28251 L
.42276 .28253 L
.42393 .28253 L
.42524 .28254 L
.42644 .28254 L
.42707 .28254 L
.42777 .28254 L
.42849 .28254 L
.42917 .28254 L
.43042 .28253 L
.43156 .28252 L
.43282 .2825 L
.43414 .28248 L
.43858 .28238 L
.4411 .2823 L
.44344 .28222 L
.45356 .28173 L
.46436 .28099 L
.50586 .27708 L
.52666 .27501 L
.54584 .27326 L
.56452 .27178 L
.56906 .27145 L
.57394 .27112 L
.57538 .27102 L
.57608 .27097 L
.57674 .27093 L
Mistroke
.57796 .26487 L
.57861 .26487 L
.5793 .26487 L
.5843 .26487 L
.62594 .26487 L
.66606 .26487 L
.70466 .26487 L
.74572 .26487 L
.78526 .26487 L
.82328 .26487 L
.86376 .26487 L
.90272 .26487 L
.94413 .26487 L
.97619 .26487 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001moooo0P000:7oool007coool010000?ooooooo`000:3oool007koool00`000?oo
ooooo`03oooo0`0009Woool007Koool400001Oooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo001loooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007coool200001_ooo`<0002I
oooo001foooo1P000004<ol00000000000001?ooo`030000oooooooo09Woool007Soool01@0003?o
03?o03?o00000002<ol00P0000?oool00`000?ooooooo`2Ioooo001goooo00<0000co`0co`000c?o
00800002<ol00P000003oooo0000oooo09[oool007Koool00`0003?o03?o000:<ol00P0009_oool0
07Goool00`0003?o03?o000<<ol00P0009[oool007Coool00`0003?o03?o000=<ol000<0003ooooo
ool0VOooo`00Loooo`030000<ol0<ol000hco`020000V_ooo`00Loooo`030000<ol0<ol000hco`00
0`0003?o0000002Ioooo001boooo00<0000co`0co`003c?o008000000c?o00000?ooo`2Goooo001b
oooo00<0000co`0co`003c?o00040000<ol0<ol00000V?ooo`00LOooo`030000<ol0<ol0010co`00
1@0003?o03?o03?o0000002Goooo001aoooo00<0000co`0co`0043?o00030000<ol0<ol0008co`00
0`000?ooooooo`2Doooo001`oooo00<0000co`0co`004C?o00030000<ol0<ol0008co`000`000?oo
ooooo`2Doooo001_oooo00<0000co`0co`004S?o00800004<ol000<0003oooooool0Toooo`00K_oo
o`030000<ol0<ol001<co`000`0003?o03?o0004<ol000<0003oooooool0T_ooo`00K_ooo`030000
<ol0<ol001<co`000`0003?o03?o0004<ol000<0003oooooool0T_ooo`00KOooo`030000<ol0<ol0
01@co`000`0003?o03?o0005<ol000<0003oooooool0TOooo`00K?ooo`030000<ol0<ol001Dco`02
00001c?o00030000oooooooo093oool006_oool00`0003?o03?o000F<ol000<0000co`0co`001S?o
00030000oooooooo093oool006_oool00`0003?o03?o000F<ol000<0000co`0co`001c?o00030000
oooooooo08ooool006[oool00`0003?o03?o000?<ol01@0000<co`000`0003?o03?o0008<ol000<0
003oooooool0S_ooo`00JOooo`030000<ol0<ol0018co`000`0003?o03?o0003<ol000<0000co`0c
o`0023?o00030000oooooooo08koool006Soool00`0003?o03?o000C<ol000<0000co`0co`000c?o
00<00009<ol000<0003oooooool0SOooo`00J?ooo`030000<ol0<ol000/co`04000013?o00030000
<ol0<ol000<co`000`0003?o03?o000:<ol000<0003oooooool0S?ooo`00Ioooo`030000<ol0<ol0
01@co`000`0003?o03?o0003<ol000<0000co`0co`002c?o00030000oooooooo08_oool006Koool0
0`0003?o03?o000D<ol00P0000Dco`000`0003?o03?o000;<ol000<0003oooooool0Roooo`00I_oo
o`030000<ol0<ol001/co`0200003C?o00030000oooooooo08[oool006Goool00`0003?o03?o000L
<ol000<0000co`0co`003C?o00030000oooooooo08Woool006Coool00`0003?o03?o000M<ol000<0
000co`0co`003S?o00030000oooooooo08Soool006?oool00`0003?o03?o000N<ol000<0000co`0c
o`003c?o00030000oooooooo08Ooool006?oool00`0003?o03?o000N<ol000<0000co`0co`0043?o
00030000oooooooo08Koool006;oool00`0003?o03?o000O<ol00P00018co`000`000?ooooooo`25
oooo001Qoooo00<0000co`0co`0083?o00030000<ol0<ol0018co`000`000?ooooooo`24oooo000_
oooo0`0002Ooool400000_ooo`80000S<ol000<0000co`0co`004c?o00030000oooooooo017oool4
0000:_ooo`<0000Woooo0`0001Ooool0033oool00`000?ooooooo`0Voooo00<0003oooooool00_oo
o`030000<ol0<ol002<co`000`0003?o03?o000D<ol000<0003oooooool04?ooo`030000oooooooo
02coool00`000?ooooooo`0Voooo00@0003oooooool0000Foooo000]oooo1@0002Soool010000?oo
ooooo`0002Hco`0200005S?o0080000Aoooo00<0003oooooool0:?ooo`D0000Woooo00@0003ooooo
ool0000Foooo000Woooo100000;oool010000?ooooooo`0002;oool400001?ooo`80000W<ol000<0
000co`0co`005c?o00030000oooooooo00ooool00`000?ooooooo`0Woooo00@0003oooooool0000X
oooo0`0001Ooool002koool00`000?ooo`00000Xoooo0P000003<ol00000<ol002Hco`000`0003?o
03?o000H<ol000<0003oooooool03?ooo`040000oooooooo0000:Oooo`030000oooo000002Woool0
0`000?ooooooo`0Foooo000_oooo0P0002Ooool40000:3?o00030000<ol0<ol001Tco`000`000?oo
ooooo`0<oooo0P0002_oool20000:Oooo`<0000Foooo001Foooo0P0002`co`000`0003?o03?o000J
<ol00P0007goool005Coool20000;S?o0080000M<ol00`0007[oool0057oool30000<3?o00030000
<ol0<ol001lco`060000M?ooo`00Boooo`H0000c<ol000<0000co`0co`009C?o00<0001aoooo0011
oooo2P0003Tco`000`0003?o03?o000X<ol02P0006Ooool0013ooooo00004Oooo`005_ooo`030000
oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool01?ooo`@0I_l00`00001Vo`1Vo`08
06Ko00<00000I_l0I_l0201Vo`04000006Ko06Ko06Ko1oooo`030000oooooooo00Soool00`000?oo
ooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0
003oooooool02?ooo`030000oooooooo00Goool0101Vool0VOooo`0000[oool00`000?ooooooo`08
oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003ooooo
ool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000
oooooooo01Goool002coool00`000?ooooooo`0Roooo1`1Vo`03000006Ko06Ko00L0I_lRoooo00<0
003oooooool04_ooo`X0I_l00ol0VOooooooo`0:oooo00<0003oooooool0:Oooo`030000oooooooo
02Woool00`000?ooooooo`0Eoooo001Roooo2P1VoaSoool00`000?ooooooo`05oooo3@1Vo`[oool0
0ol0VOooooooo`1joooo001/oooo2P1Vo`goool00`1Vo`00001Vo`0606Ko5oooo`03o`2Ioooooooo
07[oool007Koool=06Ko00?oool0000000007Oooo`03o`2Ioooooooo07[oool008Coool00`000?oo
ooooo`0Loooo00?o09Woooooool0N_ooo`00Q?ooo`030000oooooooo01coool00ol0VOooooooo`1j
oooo0024oooo00<0003oooooool07?ooo`03o`2Ioooooooo07[oool008Coool200007Oooo`03o`2I
oooooooo07[oool008Coool00`000?ooooooo`0Loooo00?o09Woooooool0N_ooo`00Q?ooo`030000
oooooooo01coool00ol0VOooooooo`1joooo0024oooo00<0003oooooool07?ooo`03o`2Ioooooooo
07[oool008Coool00`000?ooooooo`0Loooo00?o09Woooooool0N_ooo`00Q?ooo`80000Moooo00?o
09Woooooool0N_ooo`00Q?ooo`030000oooooooo01coool00ol0VOooooooo`1joooo0024oooo00<0
003oooooool07?ooo`03o`2Ioooooooo07[oool008Coool00`000?ooooooo`0Loooo00?o09Wooooo
ool0N_ooo`00Q?ooo`80000Moooo00?o09Woooooool0N_ooo`00Q?ooo`030000oooooooo01coool0
0ol0VOooooooo`1joooo0024oooo00<0003oooooool07?ooo`03o`2Ioooooooo07[oool007coool5
00000oooo`030000oooooooo01coool00ol0VOooooooo`1joooo001noooo00<0003oooooool00ooo
o`030000oooooooo01coool00ol0VOooooooo`1joooo001noooo00<0003oooooool00oooo`<0000L
oooo00?o09Woooooool0N_ooo`00O_ooo`030000oooooooo00?oool00`000?ooooooo`0Loooo00?o
09Woooooool0N_ooo`00O_ooo`030000oooooooo00?oool00`000?ooooooo`0Loooo00?o09Wooooo
ool0N_ooo`00OOooo`800005oooo00<0003oooooool07?ooo`03o`2Ioooooooo07[oool008Coool2
00007Oooo`03o`2Ioooooooo07[oool008Coool00`000?ooooooo`0Loooo00?o09Woooooool0N_oo
o`00Q?ooo`030000oooooooo01coool00ol0VOooooooo`1joooo0024oooo00<0003oooooool07?oo
o`03o`2Ioooooooo07[oool008Coool00`000?ooooooo`0Loooo00?o09Woooooool0N_ooo`00Q?oo
o`80000Moooo00?o09Woooooool0N_ooo`00Q?ooo`030000oooooooo01coool00ol0VOooooooo`1j
oooo0024oooo00<0003oooooool07?ooo`03o`2Ioooooooo07[oool008Coool00`000?ooooooo`0L
oooo00?o09Woooooool0N_ooo`00Q?ooo`80000Moooo00?o09Woooooool0N_ooo`00Q?ooo`030000
oooooooo01coool00ol0VOooooooo`1joooo0024oooo00<0003oooooool07?ooo`03o`2Ioooooooo
07[oool008Coool00`000?ooooooo`0Loooo00?o09Woooooool0N_ooo`00Q?ooo`030000oooooooo
01coool00ol0VOooooooo`1joooo0024oooo0P0001goool00ol0VOooooooo`1joooo0024oooo00<0
003oooooool07?ooo`03o`2Ioooooooo07[oool007coool400001?ooo`030000oooooooo01coool0
0ol0VOooooooo`1joooo001loooo00<0003oooooool01Oooo`030000oooooooo01coool00ol0VOoo
ooooo`1joooo001moooo00<0003oooooool01?ooo`<0000Loooo00?o09Woooooool0N_ooo`00O_oo
o`030000oooooooo00?oool00`000?ooooooo`0Loooo00?o09Woooooool0N_ooo`00O?ooo`040000
oooooooo00001?ooo`030000oooooooo01coool00ol0VOooooooo`1joooo001moooo0P0000Goool0
0`000?ooooooo`0Loooo00?o09Woooooool0N_ooo`00Q?ooo`80000Moooo00?o09Woooooool0N_oo
o`00Q?ooo`030000oooooooo01coool00ol0VOooooooo`1joooo0024oooo00<0003oooooool07?oo
o`03o`2Ioooooooo07[oool008Coool00`000?ooooooo`0Loooo00?o09Woooooool0N_ooo`00Q?oo
o`030000oooooooo01coool00ol0VOooooooo`1joooo0024oooo0P0001goool00ol0VOooooooo`1j
oooo0024oooo00<0003oooooool07?ooo`03o`2Ioooooooo07[oool008Coool00`000?ooooooo`0L
oooo00?o09Woooooool0N_ooo`00Q?ooo`030000oooooooo01coool00ol0VOooooooo`1joooo0024
oooo0P0001goool00ol0VOooooooo`1joooo0024oooo00<0003oooooool07?ooo`03o`2Ioooooooo
07[oool008Coool00`000?ooooooo`0Loooo00?o09Woooooool0N_ooo`00Q?ooo`030000oooooooo
01coool00ol0VOooooooo`1joooo0024oooo00<0003oooooool07?ooo`03o`2Ioooooooo07[oool0
08Coool200007Oooo`03o`2Ioooooooo07[oool008Coool00`000?ooooooo`0Loooo00?o09Wooooo
ool0N_ooo`00OOooo`800005oooo00<0003oooooool07?ooo`03o`2Ioooooooo07[oool007coool0
10000?ooooooo`0000Coool00`000?ooooooo`0Loooo00?o09Woooooool0N_ooo`00O_ooo`030000
oooooooo00?oool300007?ooo`03o`2Ioooooooo07[oool007ooool00`000?ooooooo`02oooo00<0
003oooooool07?ooo`03o`2Ioooooooo07[oool007coool010000?ooooooo`0000Coool00`000?oo
ooooo`0Loooo00?o09Woooooool0N_ooo`00OOooo`800005oooo00<0003oooooool07?ooo`03o`2I
oooooooo07[oool008Coool00`000?ooooooo`0Loooo00?o09Woooooool0N_ooo`00Q?ooo`80000M
oooo00?o09Woooooool0N_ooo`00Q?ooo`030000oooooooo01coool00ol0VOooooooo`1joooo0024
oooo00<0003oooooool07?ooo`03o`2Ioooooooo07[oool008Coool00`000?ooooooo`0Loooo00?o
09Woooooool0N_ooo`00Q?ooo`80000Moooo00?o09Woooooool0N_ooo`00Q?ooo`030000oooooooo
01coool00ol0VOooooooo`1joooo0024oooo00<0003oooooool07?ooo`03o`2Ioooooooo07[oool0
08Coool00`000?ooooooo`0Loooo00?o09Woooooool0N_ooo`00Q?ooo`030000oooooooo01coool0
0ol0VOooooooo`1joooo0024oooo0P0001goool00ol0VOooooooo`1joooo0024oooo00<0003ooooo
ool07?ooo`03o`2Ioooooooo07[oool008Coool00`000?ooooooo`0Loooo00?o09Woooooool0N_oo
o`00Q?ooo`030000oooooooo01coool00ol0VOooooooo`1joooo0024oooo0P0001goool00ol0VOoo
ooooo`1joooo0024oooo00<0003oooooool07?ooo`03o`2Ioooooooo07[oool008Coool00`000?oo
ooooo`0Loooo00?o09Woooooool0N_ooo`00O_ooo`<00003oooo00<0003oooooool07?ooo`03o`2I
oooooooo07[oool007ooool00`000?ooooooo`02oooo00<0003oooooool07?ooo`03o`2Ioooooooo
07[oool007coool500000oooo`<0000Loooo00?o09Woooooool0N_ooo`00O?ooo`040000oooooooo
0000X?ooo`00OOooo`030000oooo00000:3oool007koool20000X?ooo`00ooooob7oool00?oooolQ
oooo001loooo00<0003oooooool08_ooo`030000oooooooo07coool007_oool00`000?ooooooo`08
oooo00<0003oooooool06Oooo`030000oooooooo07_oool007_oool00`000?ooooooo`02oooo0P00
00Coool00`000?ooooooo`07oooo0P0000Coool200001Oooo`<00002oooo00<0003oooooool0Nooo
o`00Noooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01Ooo
o`040000oooooooo00002oooo`050000oooooooooooo000007goool007[oool00`000?ooooooo`02
oooo00<0003oooooool03Oooo`040000oooooooo00002?ooo`D00003oooo00<0003oooooool0N_oo
o`00Noooo`030000oooooooo00D0000<oooo00@0003oooooool00008oooo00@0003oooooool00003
oooo00<0003oooooool0Noooo`00Noooo`050000oooooooooooo000000ooool010000?ooooooo`00
00Woool00`000?ooo`000003oooo00<0003oooooool0Noooo`00O?ooo`030000oooooooo017oool2
00002oooo`800002oooo00<0003oooooool0O?ooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-6.03535, \
-3.20105, 0.0455524, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-6.03535, -3.20105, 0.0455524, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.30316 .26487 L
.34309 .26487 L
.3815 .26487 L
.42237 .26487 L
.46172 .26487 L
.49955 .26487 L
.53984 .26487 L
.55838 .26487 L
.57861 .26487 L
.58392 .26487 L
.58957 .26487 L
.59232 .26487 L
.59367 .26487 L
.59491 .26487 L
s
.59491 .26487 m
.59536 .61803 L
s
0 .4 1 r
.02381 .26539 m
.04262 .26552 L
.06244 .26569 L
.08255 .2659 L
.10458 .2662 L
.12415 .26653 L
.14509 .26699 L
.16639 .26757 L
.18653 .26828 L
.22495 .27015 L
.24479 .27147 L
.26581 .27321 L
.30365 .27737 L
.34394 .28322 L
.38271 .28907 L
.39281 .29029 L
.39815 .29084 L
.40384 .29133 L
.40931 .29172 L
.41426 .29198 L
.41665 .29208 L
.41924 .29216 L
.42043 .29219 L
.42169 .29222 L
.42276 .29223 L
.42393 .29225 L
.42524 .29226 L
.42644 .29226 L
.42707 .29226 L
.42777 .29226 L
.42849 .29226 L
.42917 .29225 L
.43042 .29224 L
.43156 .29222 L
.43282 .29219 L
.43414 .29216 L
.43858 .29201 L
.4411 .29189 L
.44344 .29176 L
.45356 .291 L
.46436 .28986 L
.50586 .28379 L
.54584 .27788 L
.56415 .27562 L
.57456 .27449 L
.5843 .27352 L
.58922 .27306 L
.59164 .27285 L
.59389 .27265 L
.59513 .27255 L
Mistroke
.59583 .26487 L
.59646 .26487 L
.59926 .26487 L
.60418 .26487 L
.62522 .26487 L
.66534 .26487 L
.70394 .26487 L
.745 .26487 L
.78454 .26487 L
.82256 .26487 L
.86304 .26487 L
.902 .26487 L
.94341 .26487 L
.97619 .26487 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001moooo0P000:7oool007coool010000?ooooooo`000:3oool007koool00`000?oo
ooooo`03oooo0`0009Woool007Koool400001Oooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo001loooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007coool200001_ooo`<0002I
oooo001foooo1P000004<ol00000000000001?ooo`030000oooooooo09Woool007Soool01@0003?o
03?o03?o00000002<ol00P0000?oool00`000?ooooooo`2Ioooo001goooo00<0000co`0co`000c?o
00800002<ol00P000003oooo0000oooo09[oool007Koool00`0003?o03?o000:<ol00P0009_oool0
07Goool00`0003?o03?o000<<ol00P0009[oool007Coool00`0003?o03?o000=<ol000<0003ooooo
ool0VOooo`00Loooo`030000<ol0<ol000hco`020000V_ooo`00Loooo`030000<ol0<ol000hco`00
0`0003?o0000002Ioooo001boooo00<0000co`0co`003c?o008000000c?o00000?ooo`2Goooo001b
oooo00<0000co`0co`003c?o00040000<ol0<ol00000V?ooo`00LOooo`030000<ol0<ol0010co`00
1@0003?o03?o03?o0000002Goooo001aoooo00<0000co`0co`0043?o00030000<ol0<ol0008co`00
0`000?ooooooo`2Doooo001`oooo00<0000co`0co`004C?o00030000<ol0<ol0008co`000`000?oo
ooooo`2Doooo001_oooo00<0000co`0co`004S?o00800004<ol000<0003oooooool0Toooo`00K_oo
o`030000<ol0<ol001<co`000`0003?o03?o0004<ol000<0003oooooool0T_ooo`00K_ooo`030000
<ol0<ol001<co`000`0003?o03?o0004<ol000<0003oooooool0T_ooo`00KOooo`030000<ol0<ol0
01@co`000`0003?o03?o0005<ol000<0003oooooool0TOooo`00K?ooo`030000<ol0<ol001Dco`02
00001c?o00030000oooooooo093oool006_oool00`0003?o03?o000F<ol000<0000co`0co`001S?o
00030000oooooooo093oool006_oool00`0003?o03?o000F<ol000<0000co`0co`001c?o00030000
oooooooo08ooool006[oool00`0003?o03?o000?<ol01@0000<co`000`0003?o03?o0008<ol000<0
003oooooool0S_ooo`00JOooo`030000<ol0<ol0018co`000`0003?o03?o0003<ol000<0000co`0c
o`0023?o00030000oooooooo08koool006Soool00`0003?o03?o000C<ol000<0000co`0co`000c?o
00<00009<ol000<0003oooooool0SOooo`00J?ooo`030000<ol0<ol000/co`04000013?o00030000
<ol0<ol000<co`000`0003?o03?o000:<ol000<0003oooooool0S?ooo`00Ioooo`030000<ol0<ol0
01@co`000`0003?o03?o0003<ol000<0000co`0co`002c?o00030000oooooooo08_oool006Koool0
0`0003?o03?o000D<ol00P0000Dco`000`0003?o03?o000;<ol000<0003oooooool0Roooo`00I_oo
o`030000<ol0<ol001/co`0200003C?o00030000oooooooo08[oool006Goool00`0003?o03?o000L
<ol000<0000co`0co`003C?o00030000oooooooo08Woool006Coool00`0003?o03?o000M<ol000<0
000co`0co`003S?o00030000oooooooo08Soool006?oool00`0003?o03?o000N<ol000<0000co`0c
o`003c?o00030000oooooooo08Ooool006?oool00`0003?o03?o000N<ol000<0000co`0co`0043?o
00030000oooooooo08Koool006;oool00`0003?o03?o000O<ol00P00018co`000`000?ooooooo`25
oooo001Qoooo00<0000co`0co`0083?o00030000<ol0<ol0018co`000`000?ooooooo`24oooo000_
oooo0`0002Ooool400000_ooo`80000S<ol000<0000co`0co`004c?o00030000oooooooo017oool4
0000:_ooo`<0000Woooo0`0001Ooool0033oool00`000?ooooooo`0Voooo00<0003oooooool00_oo
o`030000<ol0<ol002<co`000`0003?o03?o000D<ol000<0003oooooool04?ooo`030000oooooooo
02coool00`000?ooooooo`0Voooo00@0003oooooool0000Foooo000]oooo1@0002Soool010000?oo
ooooo`0002Hco`0200005S?o0080000Aoooo00<0003oooooool0:?ooo`D0000Woooo00@0003ooooo
ool0000Foooo000Woooo100000;oool010000?ooooooo`0002;oool400001?ooo`80000W<ol000<0
000co`0co`005c?o00030000oooooooo00ooool00`000?ooooooo`0Woooo00@0003oooooool0000X
oooo0`0001Ooool002koool00`000?ooo`00000Xoooo0P000003<ol00000<ol002Hco`000`0003?o
03?o000H<ol000<0003oooooool03?ooo`040000oooooooo0000:Oooo`030000oooo000002Woool0
0`000?ooooooo`0Foooo000_oooo0P0002Ooool40000:3?o00030000<ol0<ol001Tco`000`000?oo
ooooo`0<oooo0P0002_oool20000:Oooo`<0000Foooo001Foooo0P0002`co`000`0003?o03?o000J
<ol00P0007goool005Coool20000;S?o0080000M<ol00`0007[oool0057oool30000<3?o00030000
<ol0<ol001lco`060000M?ooo`00Boooo`H0000c<ol000<0000co`0co`009C?o00<0001aoooo0011
oooo2P0003Tco`000`0003?o03?o000X<ol02P0006Ooool0013ooooo00004Oooo`005_ooo`030000
oooooooo00Soool00`000?ooooooo`04oooo101Vo`03000006Ko06Ko00P0I_l00`00001Vo`1Vo`08
06Ko00<00000I_ooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003ooooo
ool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000
oooooooo00Soool00`000?ooooooo`08oooo00<0003oool0I_l02?ooo`030000oooooooo00Soool0
0`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08
oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003ooooo
ool05Oooo`00;?ooo`030000oooooooo01GooolD06Ko00<0003oooooool0:Oooo`030000oooooooo
01goool406Ko2?ooo`030000oooooooo02Woool00`000?ooooooo`0Yoooo00<0003oooooool05Ooo
o`00FOooo`L0I_lToooo00<0003oooooool05oooo`H0I_l3oooo00?o09Woooooool0M_ooo`00H?oo
o`D0I_lOoooo00<0003oooooool03oooo`P0I_l9oooo00?o09Woooooool0M_ooo`00IOooo`L0I_lH
oooo0P0000Soool806Ko4Oooo`03o`2Ioooooooo07Koool006coool706Ko4Oooo`030000oooooooo
00;oool506Ko6Oooo`03o`2Ioooooooo07Koool007?ooolA06Ko00<00000I_l0I_l00P1Voakoool0
0ol0VOooooooo`1foooo0024oooo00<0003oooooool08?ooo`03o`2Ioooooooo07Koool008Coool2
00008Oooo`03o`2Ioooooooo07Koool008Coool00`000?ooooooo`0Poooo00?o09Woooooool0M_oo
o`00Q?ooo`030000oooooooo023oool00ol0VOooooooo`1foooo0024oooo00<0003oooooool08?oo
o`03o`2Ioooooooo07Koool008Coool00`000?ooooooo`0Poooo00?o09Woooooool0M_ooo`00Q?oo
o`80000Qoooo00?o09Woooooool0M_ooo`00Q?ooo`030000oooooooo023oool00ol0VOooooooo`1f
oooo0024oooo00<0003oooooool08?ooo`03o`2Ioooooooo07Koool008Coool00`000?ooooooo`0P
oooo00?o09Woooooool0M_ooo`00Q?ooo`80000Qoooo00?o09Woooooool0M_ooo`00Q?ooo`030000
oooooooo023oool00ol0VOooooooo`1foooo0024oooo00<0003oooooool08?ooo`03o`2Ioooooooo
07Koool007coool500000oooo`030000oooooooo023oool00ol0VOooooooo`1foooo001noooo00<0
003oooooool00oooo`030000oooooooo023oool00ol0VOooooooo`1foooo001noooo00<0003ooooo
ool00oooo`<0000Poooo00?o09Woooooool0M_ooo`00O_ooo`030000oooooooo00?oool00`000?oo
ooooo`0Poooo00?o09Woooooool0M_ooo`00O_ooo`030000oooooooo00?oool00`000?ooooooo`0P
oooo00?o09Woooooool0M_ooo`00OOooo`800005oooo00<0003oooooool08?ooo`03o`2Ioooooooo
07Koool008Coool200008Oooo`03o`2Ioooooooo07Koool008Coool00`000?ooooooo`0Poooo00?o
09Woooooool0M_ooo`00Q?ooo`030000oooooooo023oool00ol0VOooooooo`1foooo0024oooo00<0
003oooooool08?ooo`03o`2Ioooooooo07Koool008Coool00`000?ooooooo`0Poooo00?o09Wooooo
ool0M_ooo`00Q?ooo`80000Qoooo00?o09Woooooool0M_ooo`00Q?ooo`030000oooooooo023oool0
0ol0VOooooooo`1foooo0024oooo00<0003oooooool08?ooo`03o`2Ioooooooo07Koool008Coool0
0`000?ooooooo`0Poooo00?o09Woooooool0M_ooo`00Q?ooo`80000Qoooo00?o09Woooooool0M_oo
o`00Q?ooo`030000oooooooo023oool00ol0VOooooooo`1foooo0024oooo00<0003oooooool08?oo
o`03o`2Ioooooooo07Koool008Coool00`000?ooooooo`0Poooo00?o09Woooooool0M_ooo`00Q?oo
o`030000oooooooo023oool00ol0VOooooooo`1foooo0024oooo0P00027oool00ol0VOooooooo`1f
oooo0024oooo00<0003oooooool08?ooo`03o`2Ioooooooo07Koool007coool400001?ooo`030000
oooooooo023oool00ol0VOooooooo`1foooo001loooo00<0003oooooool01Oooo`030000oooooooo
023oool00ol0VOooooooo`1foooo001moooo00<0003oooooool01?ooo`<0000Poooo00?o09Wooooo
ool0M_ooo`00O_ooo`030000oooooooo00?oool00`000?ooooooo`0Poooo00?o09Woooooool0M_oo
o`00O?ooo`040000oooooooo00001?ooo`030000oooooooo023oool00ol0VOooooooo`1foooo001m
oooo0P0000Goool00`000?ooooooo`0Poooo00?o09Woooooool0M_ooo`00Q?ooo`80000Qoooo00?o
09Woooooool0M_ooo`00Q?ooo`030000oooooooo023oool00ol0VOooooooo`1foooo0024oooo00<0
003oooooool08?ooo`03o`2Ioooooooo07Koool008Coool00`000?ooooooo`0Poooo00?o09Wooooo
ool0M_ooo`00Q?ooo`030000oooooooo023oool00ol0VOooooooo`1foooo0024oooo0P00027oool0
0ol0VOooooooo`1foooo0024oooo00<0003oooooool08?ooo`03o`2Ioooooooo07Koool008Coool0
0`000?ooooooo`0Poooo00?o09Woooooool0M_ooo`00Q?ooo`030000oooooooo023oool00ol0VOoo
ooooo`1foooo0024oooo0P00027oool00ol0VOooooooo`1foooo0024oooo00<0003oooooool08?oo
o`03o`2Ioooooooo07Koool008Coool00`000?ooooooo`0Poooo00?o09Woooooool0M_ooo`00Q?oo
o`030000oooooooo023oool00ol0VOooooooo`1foooo0024oooo00<0003oooooool08?ooo`03o`2I
oooooooo07Koool008Coool200008Oooo`03o`2Ioooooooo07Koool008Coool00`000?ooooooo`0P
oooo00?o09Woooooool0M_ooo`00OOooo`800005oooo00<0003oooooool08?ooo`03o`2Ioooooooo
07Koool007coool010000?ooooooo`0000Coool00`000?ooooooo`0Poooo00?o09Woooooool0M_oo
o`00O_ooo`030000oooooooo00?oool300008?ooo`03o`2Ioooooooo07Koool007ooool00`000?oo
ooooo`02oooo00<0003oooooool08?ooo`03o`2Ioooooooo07Koool007coool010000?ooooooo`00
00Coool00`000?ooooooo`0Poooo00?o09Woooooool0M_ooo`00OOooo`800005oooo00<0003ooooo
ool08?ooo`03o`2Ioooooooo07Koool008Coool00`000?ooooooo`0Poooo00?o09Woooooool0M_oo
o`00Q?ooo`80000Qoooo00?o09Woooooool0M_ooo`00Q?ooo`030000oooooooo023oool00ol0VOoo
ooooo`1foooo0024oooo00<0003oooooool08?ooo`03o`2Ioooooooo07Koool008Coool00`000?oo
ooooo`0Poooo00?o09Woooooool0M_ooo`00Q?ooo`80000Qoooo00?o09Woooooool0M_ooo`00Q?oo
o`030000oooooooo023oool00ol0VOooooooo`1foooo0024oooo00<0003oooooool08?ooo`03o`2I
oooooooo07Koool008Coool00`000?ooooooo`0Poooo00?o09Woooooool0M_ooo`00Q?ooo`030000
oooooooo023oool00ol0VOooooooo`1foooo0024oooo0P00027oool00ol0VOooooooo`1foooo0024
oooo00<0003oooooool08?ooo`03o`2Ioooooooo07Koool008Coool00`000?ooooooo`0Poooo00?o
09Woooooool0M_ooo`00Q?ooo`030000oooooooo023oool00ol0VOooooooo`1foooo0024oooo0P00
027oool00ol0VOooooooo`1foooo0024oooo00<0003oooooool08?ooo`03o`2Ioooooooo07Koool0
08Coool00`000?ooooooo`0Poooo00?o09Woooooool0M_ooo`00O_ooo`<00003oooo00<0003ooooo
ool08?ooo`03o`2Ioooooooo07Koool007ooool00`000?ooooooo`02oooo00<0003oooooool08?oo
o`03o`2Ioooooooo07Koool007coool500000oooo`<0000Poooo00?o09Woooooool0M_ooo`00O?oo
o`040000oooooooo0000X?ooo`00OOooo`030000oooo00000:3oool007koool20000X?ooo`00oooo
ob7oool00?oooolQoooo001loooo00<0003oooooool08_ooo`030000oooooooo07coool007_oool0
0`000?ooooooo`08oooo00<0003oooooool06Oooo`030000oooooooo07_oool007_oool00`000?oo
ooooo`02oooo0P0000Coool00`000?ooooooo`07oooo0P0000Coool200000oooo`<00004oooo00<0
003oooooool0Noooo`00Noooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0
003oooooool01Oooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo
07_oool007[oool00`000?ooooooo`02oooo00<0003oooooool03Oooo`040000oooooooo00002?oo
o`040000oooooooo00001?ooo`030000oooooooo07[oool007_oool00`000?ooooooo`0500003?oo
o`040000oooooooo00002?ooo`<00004oooo00<0003oooooool0Noooo`00Noooo`050000oooooooo
oooo000000ooool010000?ooooooo`0000Woool00`000?ooooooo`03oooo00<0003oooooool0Nooo
o`00O?ooo`030000oooooooo017oool200002_ooo`<00002oooo00<0003oooooool0O?ooo`00oooo
ob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-6.03535, \
-3.20105, 0.0455524, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-6.03535, -3.20105, 0.0455524, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.30316 .26487 L
.34309 .26487 L
.3815 .26487 L
.42237 .26487 L
.46172 .26487 L
.49955 .26487 L
.53984 .26487 L
.57861 .26487 L
.58872 .26487 L
.59975 .26487 L
.60479 .26487 L
.60756 .26487 L
.60891 .26487 L
.61016 .26487 L
.61135 .26487 L
s
.61135 .26487 m
.61185 .61803 L
s
0 .4 1 r
.02381 .2656 m
.04262 .26578 L
.06244 .26601 L
.08255 .26631 L
.10458 .26672 L
.12415 .26719 L
.14509 .26782 L
.16639 .26864 L
.18653 .26962 L
.22495 .27224 L
.24479 .27408 L
.26581 .27651 L
.30365 .2823 L
.34394 .29047 L
.38271 .29863 L
.39281 .30033 L
.39815 .30109 L
.40384 .30179 L
.40931 .30232 L
.41426 .30269 L
.41665 .30282 L
.41924 .30294 L
.42043 .30298 L
.42169 .30302 L
.42276 .30304 L
.42393 .30306 L
.42524 .30308 L
.42644 .30308 L
.42707 .30308 L
.42777 .30308 L
.42849 .30307 L
.42917 .30306 L
.43042 .30305 L
.43156 .30302 L
.43282 .30299 L
.43414 .30294 L
.43858 .30272 L
.4411 .30256 L
.44344 .30238 L
.45356 .30131 L
.46436 .29973 L
.50586 .29126 L
.54584 .28302 L
.5843 .27693 L
.59457 .27564 L
.60418 .27455 L
.60901 .27404 L
.6104 .2739 L
.61172 .27377 L
.61291 .26487 L
Mistroke
.6142 .26487 L
.62522 .26487 L
.66592 .26487 L
.7051 .26487 L
.74674 .26487 L
.78686 .26487 L
.82546 .26487 L
.86651 .26487 L
.90605 .26487 L
.94408 .26487 L
.97619 .26487 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001moooo0P000:7oool007coool010000?ooooooo`000:3oool007koool00`000?oo
ooooo`03oooo0`0009Woool007Koool400001Oooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo001loooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007coool200001_ooo`<0002I
oooo001foooo1P000004<ol00000000000001?ooo`030000oooooooo09Woool007Soool01@0003?o
03?o03?o00000002<ol00P0000?oool00`000?ooooooo`2Ioooo001goooo00<0000co`0co`000c?o
00800002<ol00P000003oooo0000oooo09[oool007Koool00`0003?o03?o000:<ol00P0009_oool0
07Goool00`0003?o03?o000<<ol00P0009[oool007Coool00`0003?o03?o000=<ol000<0003ooooo
ool0VOooo`00Loooo`030000<ol0<ol000hco`020000V_ooo`00Loooo`030000<ol0<ol000hco`00
0`0003?o0000002Ioooo001boooo00<0000co`0co`003c?o008000000c?o00000?ooo`2Goooo001b
oooo00<0000co`0co`003c?o00040000<ol0<ol00000V?ooo`00LOooo`030000<ol0<ol0010co`00
1@0003?o03?o03?o0000002Goooo001aoooo00<0000co`0co`0043?o00030000<ol0<ol0008co`00
0`000?ooooooo`2Doooo001`oooo00<0000co`0co`004C?o00030000<ol0<ol0008co`000`000?oo
ooooo`2Doooo001_oooo00<0000co`0co`004S?o00800004<ol000<0003oooooool0Toooo`00K_oo
o`030000<ol0<ol001<co`000`0003?o03?o0004<ol000<0003oooooool0T_ooo`00K_ooo`030000
<ol0<ol001<co`000`0003?o03?o0004<ol000<0003oooooool0T_ooo`00KOooo`030000<ol0<ol0
01@co`000`0003?o03?o0005<ol000<0003oooooool0TOooo`00K?ooo`030000<ol0<ol001Dco`02
00001c?o00030000oooooooo093oool006_oool00`0003?o03?o000F<ol000<0000co`0co`001S?o
00030000oooooooo093oool006_oool00`0003?o03?o000F<ol000<0000co`0co`001c?o00030000
oooooooo08ooool006[oool00`0003?o03?o000?<ol01@0000<co`000`0003?o03?o0008<ol000<0
003oooooool0S_ooo`00JOooo`030000<ol0<ol0018co`000`0003?o03?o0003<ol000<0000co`0c
o`0023?o00030000oooooooo08koool006Soool00`0003?o03?o000C<ol000<0000co`0co`000c?o
00<00009<ol000<0003oooooool0SOooo`00J?ooo`030000<ol0<ol000/co`04000013?o00030000
<ol0<ol000<co`000`0003?o03?o000:<ol000<0003oooooool0S?ooo`00Ioooo`030000<ol0<ol0
01@co`000`0003?o03?o0003<ol000<0000co`0co`002c?o00030000oooooooo08_oool006Koool0
0`0003?o03?o000D<ol00P0000Dco`000`0003?o03?o000;<ol000<0003oooooool0Roooo`00I_oo
o`030000<ol0<ol001/co`0200003C?o00030000oooooooo08[oool006Goool00`0003?o03?o000L
<ol000<0000co`0co`003C?o00030000oooooooo08Woool006Coool00`0003?o03?o000M<ol000<0
000co`0co`003S?o00030000oooooooo08Soool006?oool00`0003?o03?o000N<ol000<0000co`0c
o`003c?o00030000oooooooo08Ooool006?oool00`0003?o03?o000N<ol000<0000co`0co`0043?o
00030000oooooooo08Koool006;oool00`0003?o03?o000O<ol00P00018co`000`000?ooooooo`25
oooo001Qoooo00<0000co`0co`0083?o00030000<ol0<ol0018co`000`000?ooooooo`24oooo000_
oooo0`0002Ooool400000_ooo`80000S<ol000<0000co`0co`004c?o00030000oooooooo017oool4
0000:_ooo`<0000Woooo0`0001Ooool0033oool00`000?ooooooo`0Voooo00<0003oooooool00_oo
o`030000<ol0<ol002<co`000`0003?o03?o000D<ol000<0003oooooool04?ooo`030000oooooooo
02coool00`000?ooooooo`0Voooo00@0003oooooool0000Foooo000]oooo1@0002Soool010000?oo
ooooo`0002Hco`0200005S?o0080000Aoooo00<0003oooooool0:?ooo`D0000Woooo00@0003ooooo
ool0000Foooo000Woooo100000;oool010000?ooooooo`0002;oool400001?ooo`80000W<ol000<0
000co`0co`005c?o00030000oooooooo00ooool00`000?ooooooo`0Woooo00@0003oooooool0000X
oooo0`0001Ooool002koool00`000?ooo`00000Xoooo0P000003<ol00000<ol002Hco`000`0003?o
03?o000H<ol000<0003oooooool03?ooo`040000oooooooo0000:Oooo`030000oooo000002Woool0
0`000?ooooooo`0Foooo000_oooo0P0002Ooool40000:3?o00030000<ol0<ol001Tco`000`000?oo
ooooo`0<oooo0P0002_oool20000:Oooo`<0000Foooo001Foooo0P0002`co`000`0003?o03?o000J
<ol00P0007goool005Coool20000;S?o0080000M<ol00`0007[oool0057oool30000<3?o00030000
<ol0<ol001lco`060000M?ooo`00Boooo`H0000c<ol000<0000co`0co`009C?o00<0001aoooo0011
oooo2P0003Tco`000`0003?o03?o000X<ol02P0006Ooool0013ooooo00004Oooo`005_ooo`030000
oooooooo00Goool306Ko00<00000I_l0I_l0201Vo`03000006Ko06Ko00P0I_l00`00001Vo`1Vo`08
06Ko00<00000I_ooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003ooooo
ool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000
oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool00oooo`0306Kooooooooo00;oool0
0`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08
oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003ooooo
ool02?ooo`030000oooooooo01Goool002coool00`000?ooooooo`0Eoooo201Vo`coool00`000?oo
ooooo`0Yoooo00<0003oooooool09?ooo`0306Kooooooooo00;oool00`000?ooooooo`0Yoooo00<0
003oooooool0:Oooo`030000oooooooo01Goool004coool;06Ko;Oooo`030000oooooooo01_oool:
06KoM?ooo`00Eoooo`@0I_lYoooo00<0003oooooool05oooo`@0I_l9oooo00?o09Woooooool0L_oo
o`00Foooo`D0I_lToooo0P0001?oool506Ko3Oooo`03o`2Ioooooooo07;oool0063oool506Ko7ooo
o`030000oooooooo00coool606Ko4_ooo`03o`2Ioooooooo07;oool006Goool506Ko6_ooo`030000
oooooooo00Ooool506Ko6?ooo`03o`2Ioooooooo07;oool006[oool506Ko5Oooo`030000oooooooo
00;oool506Ko7Oooo`03o`2Ioooooooo07;oool006ooool706Ko3Oooo`0306Ko0000000000<0I_lR
oooo00?o09Woooooool0L_ooo`00M_ooo`d0I_l00oooo`000?ooo`0Uoooo00?o09Woooooool0L_oo
o`00Q?ooo`030000oooooooo02Coool00ol0VOooooooo`1boooo0024oooo00<0003oooooool09?oo
o`03o`2Ioooooooo07;oool008Coool00`000?ooooooo`0Toooo00?o09Woooooool0L_ooo`00Q?oo
o`80000Uoooo00?o09Woooooool0L_ooo`00Q?ooo`030000oooooooo02Coool00ol0VOooooooo`1b
oooo0024oooo00<0003oooooool09?ooo`03o`2Ioooooooo07;oool008Coool00`000?ooooooo`0T
oooo00?o09Woooooool0L_ooo`00Q?ooo`80000Uoooo00?o09Woooooool0L_ooo`00Q?ooo`030000
oooooooo02Coool00ol0VOooooooo`1boooo0024oooo00<0003oooooool09?ooo`03o`2Ioooooooo
07;oool007coool500000oooo`030000oooooooo02Coool00ol0VOooooooo`1boooo001noooo00<0
003oooooool00oooo`030000oooooooo02Coool00ol0VOooooooo`1boooo001noooo00<0003ooooo
ool00oooo`<0000Toooo00?o09Woooooool0L_ooo`00O_ooo`030000oooooooo00?oool00`000?oo
ooooo`0Toooo00?o09Woooooool0L_ooo`00O_ooo`030000oooooooo00?oool00`000?ooooooo`0T
oooo00?o09Woooooool0L_ooo`00OOooo`800005oooo00<0003oooooool09?ooo`03o`2Ioooooooo
07;oool008Coool200009Oooo`03o`2Ioooooooo07;oool008Coool00`000?ooooooo`0Toooo00?o
09Woooooool0L_ooo`00Q?ooo`030000oooooooo02Coool00ol0VOooooooo`1boooo0024oooo00<0
003oooooool09?ooo`03o`2Ioooooooo07;oool008Coool00`000?ooooooo`0Toooo00?o09Wooooo
ool0L_ooo`00Q?ooo`80000Uoooo00?o09Woooooool0L_ooo`00Q?ooo`030000oooooooo02Coool0
0ol0VOooooooo`1boooo0024oooo00<0003oooooool09?ooo`03o`2Ioooooooo07;oool008Coool0
0`000?ooooooo`0Toooo00?o09Woooooool0L_ooo`00Q?ooo`80000Uoooo00?o09Woooooool0L_oo
o`00Q?ooo`030000oooooooo02Coool00ol0VOooooooo`1boooo0024oooo00<0003oooooool09?oo
o`03o`2Ioooooooo07;oool008Coool00`000?ooooooo`0Toooo00?o09Woooooool0L_ooo`00Q?oo
o`030000oooooooo02Coool00ol0VOooooooo`1boooo0024oooo0P0002Goool00ol0VOooooooo`1b
oooo0024oooo00<0003oooooool09?ooo`03o`2Ioooooooo07;oool007coool400001?ooo`030000
oooooooo02Coool00ol0VOooooooo`1boooo001loooo00<0003oooooool01Oooo`030000oooooooo
02Coool00ol0VOooooooo`1boooo001moooo00<0003oooooool01?ooo`<0000Toooo00?o09Wooooo
ool0L_ooo`00O_ooo`030000oooooooo00?oool00`000?ooooooo`0Toooo00?o09Woooooool0L_oo
o`00O?ooo`040000oooooooo00001?ooo`030000oooooooo02Coool00ol0VOooooooo`1boooo001m
oooo0P0000Goool00`000?ooooooo`0Toooo00?o09Woooooool0L_ooo`00Q?ooo`80000Uoooo00?o
09Woooooool0L_ooo`00Q?ooo`030000oooooooo02Coool00ol0VOooooooo`1boooo0024oooo00<0
003oooooool09?ooo`03o`2Ioooooooo07;oool008Coool00`000?ooooooo`0Toooo00?o09Wooooo
ool0L_ooo`00Q?ooo`030000oooooooo02Coool00ol0VOooooooo`1boooo0024oooo0P0002Goool0
0ol0VOooooooo`1boooo0024oooo00<0003oooooool09?ooo`03o`2Ioooooooo07;oool008Coool0
0`000?ooooooo`0Toooo00?o09Woooooool0L_ooo`00Q?ooo`030000oooooooo02Coool00ol0VOoo
ooooo`1boooo0024oooo0P0002Goool00ol0VOooooooo`1boooo0024oooo00<0003oooooool09?oo
o`03o`2Ioooooooo07;oool008Coool00`000?ooooooo`0Toooo00?o09Woooooool0L_ooo`00Q?oo
o`030000oooooooo02Coool00ol0VOooooooo`1boooo0024oooo00<0003oooooool09?ooo`03o`2I
oooooooo07;oool008Coool200009Oooo`03o`2Ioooooooo07;oool008Coool00`000?ooooooo`0T
oooo00?o09Woooooool0L_ooo`00OOooo`800005oooo00<0003oooooool09?ooo`03o`2Ioooooooo
07;oool007coool010000?ooooooo`0000Coool00`000?ooooooo`0Toooo00?o09Woooooool0L_oo
o`00O_ooo`030000oooooooo00?oool300009?ooo`03o`2Ioooooooo07;oool007ooool00`000?oo
ooooo`02oooo00<0003oooooool09?ooo`03o`2Ioooooooo07;oool007coool010000?ooooooo`00
00Coool00`000?ooooooo`0Toooo00?o09Woooooool0L_ooo`00OOooo`800005oooo00<0003ooooo
ool09?ooo`03o`2Ioooooooo07;oool008Coool00`000?ooooooo`0Toooo00?o09Woooooool0L_oo
o`00Q?ooo`80000Uoooo00?o09Woooooool0L_ooo`00Q?ooo`030000oooooooo02Coool00ol0VOoo
ooooo`1boooo0024oooo00<0003oooooool09?ooo`03o`2Ioooooooo07;oool008Coool00`000?oo
ooooo`0Toooo00?o09Woooooool0L_ooo`00Q?ooo`80000Uoooo00?o09Woooooool0L_ooo`00Q?oo
o`030000oooooooo02Coool00ol0VOooooooo`1boooo0024oooo00<0003oooooool09?ooo`03o`2I
oooooooo07;oool008Coool00`000?ooooooo`0Toooo00?o09Woooooool0L_ooo`00Q?ooo`030000
oooooooo02Coool00ol0VOooooooo`1boooo0024oooo0P0002Goool00ol0VOooooooo`1boooo0024
oooo00<0003oooooool09?ooo`03o`2Ioooooooo07;oool008Coool00`000?ooooooo`0Toooo00?o
09Woooooool0L_ooo`00Q?ooo`030000oooooooo02Coool00ol0VOooooooo`1boooo0024oooo0P00
02Goool00ol0VOooooooo`1boooo0024oooo00<0003oooooool09?ooo`03o`2Ioooooooo07;oool0
08Coool00`000?ooooooo`0Toooo00?o09Woooooool0L_ooo`00O_ooo`<00003oooo00<0003ooooo
ool09?ooo`03o`2Ioooooooo07;oool007ooool00`000?ooooooo`02oooo00<0003oooooool09?oo
o`03o`2Ioooooooo07;oool007coool500000oooo`<0000Toooo00?o09Woooooool0L_ooo`00O?oo
o`040000oooooooo0000X?ooo`00OOooo`030000oooo00000:3oool007koool20000X?ooo`00oooo
ob7oool00?oooolQoooo001loooo00<0003oooooool08_ooo`030000oooooooo07coool007_oool0
0`000?ooooooo`08oooo00<0003oooooool06Oooo`030000oooooooo07_oool007_oool00`000?oo
ooooo`02oooo0P0000Coool00`000?ooooooo`07oooo0P0000Coool200001?ooo`800004oooo00<0
003oooooool0Noooo`00Noooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0
003oooooool01Oooo`040000oooooooo00002?ooo`040000oooooooo00000oooo`030000oooooooo
07_oool007[oool00`000?ooooooo`02oooo00<0003oooooool03Oooo`040000oooooooo00002?oo
o`040000oooooooo00001?ooo`030000oooooooo07[oool007_oool00`000?ooooooo`0500003?oo
o`040000oooooooo00002Oooo`800004oooo00<0003oooooool0Noooo`00Noooo`050000oooooooo
oooo000000ooool010000?ooooooo`0000Soool010000?ooooooo`0000?oool00`000?ooooooo`1k
oooo001loooo00<0003oooooool04Oooo`80000:oooo0P0000?oool00`000?ooooooo`1loooo003o
oooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-6.03535, \
-3.20105, 0.0455524, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-6.03535, -3.20105, 0.0455524, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -21.7813 0 ]
[.5 .63053 21.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -82.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
96.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
.2 1 0 r
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
.97619 .26487 L
.02381 .26487 L
F
0 g
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .09826 L
.4525 .10308 L
.4633 .11644 L
.50342 .17717 L
.52184 .20132 L
.54203 .22186 L
.562 .23641 L
.57291 .24233 L
.58308 .2468 L
.59356 .25052 L
.60347 .25336 L
.62204 .25729 L
.63172 .25878 L
.64199 .26005 L
.66042 .26171 L
.66982 .26232 L
.67993 .26285 L
.69823 .26354 L
.70782 .26381 L
.71831 .26404 L
.72925 .26422 L
.73942 .26436 L
.74997 .26447 L
.75992 .26455 L
.77852 .26466 L
.78826 .26471 L
.79857 .26474 L
.81703 .26479 L
.8265 .2648 L
.83665 .26482 L
.85497 .26484 L
.86513 .26484 L
.87619 .26485 L
.88663 .26485 L
.8963 .26486 L
.91494 .26486 L
.92556 .26486 L
.93554 .26487 L
.94535 .26487 L
.95569 .26487 L
.97419 .26487 L
.97619 .26487 L
Mfstroke
1 0 .6 r
.02381 .26487 m
.06244 .26487 L
.10458 .26487 L
.14415 .26487 L
.18221 .26487 L
.22272 .26487 L
.26171 .26487 L
.30316 .26487 L
.34309 .26487 L
.3815 .26487 L
.42237 .26487 L
.46172 .26487 L
.49955 .26487 L
.53984 .26487 L
.57861 .26487 L
.59832 .26487 L
.60873 .26487 L
.61445 .26487 L
.61984 .26487 L
.62502 .26487 L
.62644 .26487 L
.62795 .26487 L
.62923 .26487 L
s
.62923 .26487 m
.62952 .61803 L
s
0 .4 1 r
.02381 .26584 m
.04262 .26607 L
.06244 .26638 L
.08255 .26677 L
.10458 .26732 L
.12415 .26794 L
.14509 .26878 L
.16639 .26986 L
.18653 .27116 L
.22495 .27462 L
.24479 .27706 L
.26581 .28027 L
.30365 .28794 L
.34394 .29874 L
.38271 .30954 L
.39281 .31179 L
.39815 .3128 L
.40384 .31372 L
.40931 .31443 L
.41426 .31491 L
.41665 .31509 L
.41924 .31524 L
.42043 .3153 L
.42169 .31535 L
.42276 .31538 L
.42393 .31541 L
.42524 .31542 L
.42644 .31543 L
.42707 .31543 L
.42777 .31543 L
.42849 .31542 L
.42917 .31541 L
.43042 .31539 L
.43156 .31535 L
.43282 .31531 L
.43414 .31525 L
.43858 .31496 L
.4411 .31474 L
.44344 .3145 L
.45356 .31309 L
.46436 .311 L
.50586 .29979 L
.54584 .28888 L
.5843 .28083 L
.60418 .27768 L
.61432 .2763 L
.61992 .2756 L
.62267 .27528 L
.62522 .27498 L
.62759 .27471 L
Mistroke
.62828 .27464 L
.62892 .27456 L
.63012 .26487 L
.63077 .26487 L
.63145 .26487 L
.63268 .26487 L
.63545 .26487 L
.6448 .26487 L
.66311 .26487 L
.70113 .26487 L
.74161 .26487 L
.78057 .26487 L
.82198 .26487 L
.86188 .26487 L
.90026 .26487 L
.9411 .26487 L
.97619 .26487 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -21.7813 0 ]
[.5 .63053 21.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -82.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
96.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo001moooo0P000:7oool007coool010000?ooooooo`000:3oool007koool00`000?oo
ooooo`03oooo0`0009Woool007Koool400001Oooo`030000oooooooo00;oool00`000?ooooooo`2I
oooo001loooo00@0003oooooool00004oooo00<0003oooooool0VOooo`00OOooo`800005oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool20000V_ooo`00Q?ooo`030000
oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024oooo00<0003oooooool0VOooo`00Q?oo
o`80002Joooo0024oooo00<0003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool0
0`000?ooooooo`2Ioooo0024oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo0024oooo00<0
003oooooool0VOooo`00Q?ooo`030000oooooooo09Woool008Coool00`000?ooooooo`2Ioooo0024
oooo0P0009[oool008Coool00`000?ooooooo`2Ioooo001loooo100000Coool00`000?ooooooo`2I
oooo001loooo00<0003oooooool01Oooo`030000oooooooo09Woool007coool200001_ooo`<0002I
oooo001foooo1P000004<ol00000000000001?ooo`030000oooooooo09Woool007Soool01@0003?o
03?o03?o00000002<ol00P0000?oool00`000?ooooooo`2Ioooo001goooo00<0000co`0co`000c?o
00800002<ol00P000003oooo0000oooo09[oool007Koool00`0003?o03?o000:<ol00P0009_oool0
07Goool00`0003?o03?o000<<ol00P0009[oool007Coool00`0003?o03?o000=<ol000<0003ooooo
ool0VOooo`00Loooo`030000<ol0<ol000hco`020000V_ooo`00Loooo`030000<ol0<ol000hco`00
0`0003?o0000002Ioooo001boooo00<0000co`0co`003c?o008000000c?o00000?ooo`2Goooo001b
oooo00<0000co`0co`003c?o00040000<ol0<ol00000V?ooo`00LOooo`030000<ol0<ol0010co`00
1@0003?o03?o03?o0000002Goooo001aoooo00<0000co`0co`0043?o00030000<ol0<ol0008co`00
0`000?ooooooo`2Doooo001`oooo00<0000co`0co`004C?o00030000<ol0<ol0008co`000`000?oo
ooooo`2Doooo001_oooo00<0000co`0co`004S?o00800004<ol000<0003oooooool0Toooo`00K_oo
o`030000<ol0<ol001<co`000`0003?o03?o0004<ol000<0003oooooool0T_ooo`00K_ooo`030000
<ol0<ol001<co`000`0003?o03?o0004<ol000<0003oooooool0T_ooo`00KOooo`030000<ol0<ol0
01@co`000`0003?o03?o0005<ol000<0003oooooool0TOooo`00K?ooo`030000<ol0<ol001Dco`02
00001c?o00030000oooooooo093oool006_oool00`0003?o03?o000F<ol000<0000co`0co`001S?o
00030000oooooooo093oool006_oool00`0003?o03?o000F<ol000<0000co`0co`001c?o00030000
oooooooo08ooool006[oool00`0003?o03?o000?<ol01@0000<co`000`0003?o03?o0008<ol000<0
003oooooool0S_ooo`00JOooo`030000<ol0<ol0018co`000`0003?o03?o0003<ol000<0000co`0c
o`0023?o00030000oooooooo08koool006Soool00`0003?o03?o000C<ol000<0000co`0co`000c?o
00<00009<ol000<0003oooooool0SOooo`00J?ooo`030000<ol0<ol000/co`04000013?o00030000
<ol0<ol000<co`000`0003?o03?o000:<ol000<0003oooooool0S?ooo`00Ioooo`030000<ol0<ol0
01@co`000`0003?o03?o0003<ol000<0000co`0co`002c?o00030000oooooooo08_oool006Koool0
0`0003?o03?o000D<ol00P0000Dco`000`0003?o03?o000;<ol000<0003oooooool0Roooo`00I_oo
o`030000<ol0<ol001/co`0200003C?o00030000oooooooo08[oool006Goool00`0003?o03?o000L
<ol000<0000co`0co`003C?o00030000oooooooo08Woool006Coool00`0003?o03?o000M<ol000<0
000co`0co`003S?o00030000oooooooo08Soool006?oool00`0003?o03?o000N<ol000<0000co`0c
o`003c?o00030000oooooooo08Ooool006?oool00`0003?o03?o000N<ol000<0000co`0co`0043?o
00030000oooooooo08Koool006;oool00`0003?o03?o000O<ol00P00018co`000`000?ooooooo`25
oooo001Qoooo00<0000co`0co`0083?o00030000<ol0<ol0018co`000`000?ooooooo`24oooo000_
oooo0`0002Ooool400000_ooo`80000S<ol000<0000co`0co`004c?o00030000oooooooo017oool4
0000:_ooo`<0000Woooo0`0001Ooool0033oool00`000?ooooooo`0Voooo00<0003oooooool00_oo
o`030000<ol0<ol002<co`000`0003?o03?o000D<ol000<0003oooooool04?ooo`030000oooooooo
02coool00`000?ooooooo`0Voooo00@0003oooooool0000Foooo000]oooo1@0002Soool010000?oo
ooooo`0002Hco`0200005S?o0080000Aoooo00<0003oooooool0:?ooo`D0000Woooo00@0003ooooo
ool0000Foooo000Woooo100000;oool010000?ooooooo`0002;oool400001?ooo`80000W<ol000<0
000co`0co`005c?o00030000oooooooo00ooool00`000?ooooooo`0Woooo00@0003oooooool0000X
oooo0`0001Ooool002koool00`000?ooo`00000Xoooo0P000003<ol00000<ol002Hco`000`0003?o
03?o000H<ol000<0003oooooool03?ooo`040000oooooooo0000:Oooo`030000oooo000002Woool0
0`000?ooooooo`0Foooo000_oooo0P0002Ooool40000:3?o00030000<ol0<ol001Tco`000`000?oo
ooooo`0<oooo0P0002_oool20000:Oooo`<0000Foooo001Foooo0P0002`co`000`0003?o03?o000J
<ol00P0007goool005Coool20000;S?o0080000M<ol00`0007[oool0057oool30000<3?o00030000
<ol0<ol001lco`060000M?ooo`00Boooo`H0000c<ol000<0000co`0co`009C?o00<0001aoooo0011
oooo2P0003Tco`000`0003?o03?o000X<ol02P0006Ooool0013ooooo00004Oooo`005_ooo`030000
oooooooo00P0I_l00`00001Vo`1Vo`0806Ko00<00000I_l0I_l0201Vo`03000006Ko06Ko00<0I_l5
oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003ooooo
ool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000
oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool0
0`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08
oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003ooooo
ool05Oooo`00;?ooo`030000oooooooo00koool706Ko5?ooo`030000oooooooo02Woool00`000?oo
ooooo`0Yoooo00<0003oooooool0:Oooo`030000oooooooo02Woool00`000?ooooooo`0Eoooo0014
oooo3@1Voc?oool00`000?ooooooo`0Poooo2P1Vofooool0057oool606Ko;Oooo`030000oooooooo
01_oool506Ko2Oooo`03o`2Ioooooooo06goool005Ooool406Ko:Oooo`80000Hoooo101Vo`koool0
0ol0VOooooooo`1]oooo001Koooo101VobGoool00`000?ooooooo`0Coooo101Voa;oool00ol0VOoo
ooooo`1]oooo001Ooooo0`1Vob;oool00`000?ooooooo`0?oooo101VoaKoool00ol0VOooooooo`1]
oooo001Roooo101Voakoool00`000?ooooooo`0;oooo101Voa[oool00ol0VOooooooo`1]oooo001V
oooo0`1Voa_oool200002Oooo`<0I_lNoooo00?o09Woooooool0KOooo`00JOooo`<0I_lHoooo00<0
003oooooool01Oooo`<0I_lQoooo00?o09Woooooool0KOooo`00K?ooo`@0I_lDoooo00@0003ooooo
ooooool406Ko9?ooo`03o`2Ioooooooo06goool0073oool606Ko3Oooo`0306Ko000006Ko0080I_lX
oooo00?o09Woooooool0KOooo`00M_ooo`d0I_l00oooo`000?ooo`0Zoooo00?o09Woooooool0KOoo
o`00Q?ooo`80000Zoooo00?o09Woooooool0KOooo`00Q?ooo`030000oooooooo02Woool00ol0VOoo
ooooo`1]oooo0024oooo00<0003oooooool0:Oooo`03o`2Ioooooooo06goool008Coool00`000?oo
ooooo`0Yoooo00?o09Woooooool0KOooo`00Q?ooo`80000Zoooo00?o09Woooooool0KOooo`00Q?oo
o`030000oooooooo02Woool00ol0VOooooooo`1]oooo0024oooo00<0003oooooool0:Oooo`03o`2I
oooooooo06goool007coool500000oooo`030000oooooooo02Woool00ol0VOooooooo`1]oooo001n
oooo00<0003oooooool00oooo`030000oooooooo02Woool00ol0VOooooooo`1]oooo001noooo00<0
003oooooool00oooo`<0000Yoooo00?o09Woooooool0KOooo`00O_ooo`030000oooooooo00?oool0
0`000?ooooooo`0Yoooo00?o09Woooooool0KOooo`00O_ooo`030000oooooooo00?oool00`000?oo
ooooo`0Yoooo00?o09Woooooool0KOooo`00OOooo`800005oooo00<0003oooooool0:Oooo`03o`2I
oooooooo06goool008Coool20000:_ooo`03o`2Ioooooooo06goool008Coool00`000?ooooooo`0Y
oooo00?o09Woooooool0KOooo`00Q?ooo`030000oooooooo02Woool00ol0VOooooooo`1]oooo0024
oooo00<0003oooooool0:Oooo`03o`2Ioooooooo06goool008Coool00`000?ooooooo`0Yoooo00?o
09Woooooool0KOooo`00Q?ooo`80000Zoooo00?o09Woooooool0KOooo`00Q?ooo`030000oooooooo
02Woool00ol0VOooooooo`1]oooo0024oooo00<0003oooooool0:Oooo`03o`2Ioooooooo06goool0
08Coool00`000?ooooooo`0Yoooo00?o09Woooooool0KOooo`00Q?ooo`80000Zoooo00?o09Wooooo
ool0KOooo`00Q?ooo`030000oooooooo02Woool00ol0VOooooooo`1]oooo0024oooo00<0003ooooo
ool0:Oooo`03o`2Ioooooooo06goool008Coool00`000?ooooooo`0Yoooo00?o09Woooooool0KOoo
o`00Q?ooo`030000oooooooo02Woool00ol0VOooooooo`1]oooo0024oooo0P0002[oool00ol0VOoo
ooooo`1]oooo0024oooo00<0003oooooool0:Oooo`03o`2Ioooooooo06goool007coool400001?oo
o`030000oooooooo02Woool00ol0VOooooooo`1]oooo001loooo00<0003oooooool01Oooo`030000
oooooooo02Woool00ol0VOooooooo`1]oooo001moooo00<0003oooooool01?ooo`<0000Yoooo00?o
09Woooooool0KOooo`00O_ooo`030000oooooooo00?oool00`000?ooooooo`0Yoooo00?o09Wooooo
ool0KOooo`00O?ooo`040000oooooooo00001?ooo`030000oooooooo02Woool00ol0VOooooooo`1]
oooo001moooo0P0000Goool00`000?ooooooo`0Yoooo00?o09Woooooool0KOooo`00Q?ooo`80000Z
oooo00?o09Woooooool0KOooo`00Q?ooo`030000oooooooo02Woool00ol0VOooooooo`1]oooo0024
oooo00<0003oooooool0:Oooo`03o`2Ioooooooo06goool008Coool00`000?ooooooo`0Yoooo00?o
09Woooooool0KOooo`00Q?ooo`030000oooooooo02Woool00ol0VOooooooo`1]oooo0024oooo0P00
02[oool00ol0VOooooooo`1]oooo0024oooo00<0003oooooool0:Oooo`03o`2Ioooooooo06goool0
08Coool00`000?ooooooo`0Yoooo00?o09Woooooool0KOooo`00Q?ooo`030000oooooooo02Woool0
0ol0VOooooooo`1]oooo0024oooo0P0002[oool00ol0VOooooooo`1]oooo0024oooo00<0003ooooo
ool0:Oooo`03o`2Ioooooooo06goool008Coool00`000?ooooooo`0Yoooo00?o09Woooooool0KOoo
o`00Q?ooo`030000oooooooo02Woool00ol0VOooooooo`1]oooo0024oooo00<0003oooooool0:Ooo
o`03o`2Ioooooooo06goool008Coool20000:_ooo`03o`2Ioooooooo06goool008Coool00`000?oo
ooooo`0Yoooo00?o09Woooooool0KOooo`00OOooo`800005oooo00<0003oooooool0:Oooo`03o`2I
oooooooo06goool007coool010000?ooooooo`0000Coool00`000?ooooooo`0Yoooo00?o09Wooooo
ool0KOooo`00O_ooo`030000oooooooo00?oool30000:Oooo`03o`2Ioooooooo06goool007ooool0
0`000?ooooooo`02oooo00<0003oooooool0:Oooo`03o`2Ioooooooo06goool007coool010000?oo
ooooo`0000Coool00`000?ooooooo`0Yoooo00?o09Woooooool0KOooo`00OOooo`800005oooo00<0
003oooooool0:Oooo`03o`2Ioooooooo06goool008Coool00`000?ooooooo`0Yoooo00?o09Wooooo
ool0KOooo`00Q?ooo`80000Zoooo00?o09Woooooool0KOooo`00Q?ooo`030000oooooooo02Woool0
0ol0VOooooooo`1]oooo0024oooo00<0003oooooool0:Oooo`03o`2Ioooooooo06goool008Coool0
0`000?ooooooo`0Yoooo00?o09Woooooool0KOooo`00Q?ooo`80000Zoooo00?o09Woooooool0KOoo
o`00Q?ooo`030000oooooooo02Woool00ol0VOooooooo`1]oooo0024oooo00<0003oooooool0:Ooo
o`03o`2Ioooooooo06goool008Coool00`000?ooooooo`0Yoooo00?o09Woooooool0KOooo`00Q?oo
o`030000oooooooo02Woool00ol0VOooooooo`1]oooo0024oooo0P0002[oool00ol0VOooooooo`1]
oooo0024oooo00<0003oooooool0:Oooo`03o`2Ioooooooo06goool008Coool00`000?ooooooo`0Y
oooo00?o09Woooooool0KOooo`00Q?ooo`030000oooooooo02Woool00ol0VOooooooo`1]oooo0024
oooo0P0002[oool00ol0VOooooooo`1]oooo0024oooo00<0003oooooool0:Oooo`03o`2Ioooooooo
06goool008Coool00`000?ooooooo`0Yoooo00?o09Woooooool0KOooo`00O_ooo`<00003oooo00<0
003oooooool0:Oooo`03o`2Ioooooooo06goool007ooool00`000?ooooooo`02oooo00<0003ooooo
ool0:Oooo`03o`2Ioooooooo06goool007coool500000oooo`<0000Yoooo00?o09Woooooool0KOoo
o`00O?ooo`040000oooooooo0000X?ooo`00OOooo`030000oooo00000:3oool007koool20000X?oo
o`00ooooob7oool00?oooolQoooo001ooooo00<0003oooooool07?ooo`030000oooooooo07ooool0
07koool00`000?ooooooo`08oooo00<0003oooooool04oooo`030000oooooooo07koool007koool0
0`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`06oooo1@0000;oool200001?ooo`030000
oooooooo07koool007koool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000
oooooooo00Ooool00`000?ooooooo`08oooo00<0003oooooool0O_ooo`00OOooo`030000oooooooo
00;oool00`000?ooooooo`0?oooo00<0003oooooool02Oooo`030000oooooooo07goool007koool0
0`000?ooooooo`0500003_ooo`030000oooooooo00Soool00`000?ooooooo`1noooo001noooo00D0
003oooooooooool000004Oooo`030000oooooooo00Soool00`000?ooooooo`1noooo001ooooo00<0
003oooooool04Oooo`800009oooo00<0003oooooool0Ooooo`00ooooob7oool00?oooolQoooo0000
\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-6.03535, \
-3.20105, 0.0455524, 0.0446699}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-6.03535, -3.20105, 0.0455524, 0.0446699}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.45671 0.0865801 0.264872 0.0882906 [
[.11039 .25237 -6 -9 ]
[.11039 .25237 6 0 ]
[.28355 .25237 -6 -9 ]
[.28355 .25237 6 0 ]
[.62987 .25237 -3 -9 ]
[.62987 .25237 3 0 ]
[.80303 .25237 -3 -9 ]
[.80303 .25237 3 0 ]
[.97619 .25237 -3 -9 ]
[.97619 .25237 3 0 ]
[.44421 0 -12 -4.5 ]
[.44421 0 0 4.5 ]
[.44421 .08829 -12 -4.5 ]
[.44421 .08829 0 4.5 ]
[.44421 .17658 -12 -4.5 ]
[.44421 .17658 0 4.5 ]
[.44421 .35316 -6 -4.5 ]
[.44421 .35316 0 4.5 ]
[.44421 .44145 -6 -4.5 ]
[.44421 .44145 0 4.5 ]
[.44421 .52974 -6 -4.5 ]
[.44421 .52974 0 4.5 ]
[.44421 .61803 -6 -4.5 ]
[.44421 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .26487 m
.11039 .27112 L
s
[(-4)] .11039 .25237 0 1 Mshowa
.28355 .26487 m
.28355 .27112 L
s
[(-2)] .28355 .25237 0 1 Mshowa
.62987 .26487 m
.62987 .27112 L
s
[(2)] .62987 .25237 0 1 Mshowa
.80303 .26487 m
.80303 .27112 L
s
[(4)] .80303 .25237 0 1 Mshowa
.97619 .26487 m
.97619 .27112 L
s
[(6)] .97619 .25237 0 1 Mshowa
.125 Mabswid
.15368 .26487 m
.15368 .26862 L
s
.19697 .26487 m
.19697 .26862 L
s
.24026 .26487 m
.24026 .26862 L
s
.32684 .26487 m
.32684 .26862 L
s
.37013 .26487 m
.37013 .26862 L
s
.41342 .26487 m
.41342 .26862 L
s
.5 .26487 m
.5 .26862 L
s
.54329 .26487 m
.54329 .26862 L
s
.58658 .26487 m
.58658 .26862 L
s
.67316 .26487 m
.67316 .26862 L
s
.71645 .26487 m
.71645 .26862 L
s
.75974 .26487 m
.75974 .26862 L
s
.84632 .26487 m
.84632 .26862 L
s
.88961 .26487 m
.88961 .26862 L
s
.9329 .26487 m
.9329 .26862 L
s
.0671 .26487 m
.0671 .26862 L
s
.02381 .26487 m
.02381 .26862 L
s
.25 Mabswid
0 .26487 m
1 .26487 L
s
.45671 0 m
.46296 0 L
s
[(-3)] .44421 0 1 0 Mshowa
.45671 .08829 m
.46296 .08829 L
s
[(-2)] .44421 .08829 1 0 Mshowa
.45671 .17658 m
.46296 .17658 L
s
[(-1)] .44421 .17658 1 0 Mshowa
.45671 .35316 m
.46296 .35316 L
s
[(1)] .44421 .35316 1 0 Mshowa
.45671 .44145 m
.46296 .44145 L
s
[(2)] .44421 .44145 1 0 Mshowa
.45671 .52974 m
.46296 .52974 L
s
[(3)] .44421 .52974 1 0 Mshowa
.45671 .61803 m
.46296 .61803 L
s
[(4)] .44421 .61803 1 0 Mshowa
.125 Mabswid
.45671 .01766 m
.46046 .01766 L
s
.45671 .03532 m
.46046 .03532 L
s
.45671 .05297 m
.46046 .05297 L
s
.45671 .07063 m
.46046 .07063 L
s
.45671 .10595 m
.46046 .10595 L
s
.45671 .12361 m
.46046 .12361 L
s
.45671 .14126 m
.46046 .14126 L
s
.45671 .15892 m
.46046 .15892 L
s
.45671 .19424 m
.46046 .19424 L
s
.45671 .2119 m
.46046 .2119 L
s
.45671 .22956 m
.46046 .22956 L
s
.45671 .24721 m
.46046 .24721 L
s
.45671 .28253 m
.46046 .28253 L
s
.45671 .30019 m
.46046 .30019 L
s
.45671 .31785 m
.46046 .31785 L
s
.45671 .3355 m
.46046 .3355 L
s
.45671 .37082 m
.46046 .37082 L
s
.45671 .38848 m
.46046 .38848 L
s
.45671 .40614 m
.46046 .40614 L
s
.45671 .42379 m
.46046 .42379 L
s
.45671 .45911 m
.46046 .45911 L
s
.45671 .47677 m
.46046 .47677 L
s
.45671 .49443 m
.46046 .49443 L
s
.45671 .51209 m
.46046 .51209 L
s
.45671 .5474 m
.46046 .5474 L
s
.45671 .56506 m
.46046 .56506 L
s
.45671 .58272 m
.46046 .58272 L
s
.45671 .60038 m
.46046 .60038 L
s
.25 Mabswid
.45671 0 m
.45671 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .26481 m
.03279 .26479 L
.04262 .26477 L
.06244 .26472 L
.07298 .26467 L
.08426 .26461 L
.0949 .26454 L
.10458 .26446 L
.12373 .26423 L
.13453 .26405 L
.14451 .26383 L
.16324 .26327 L
.17388 .26283 L
.18386 .2623 L
.19424 .26161 L
.20411 .26079 L
.22263 .25865 L
.23222 .25714 L
.24244 .25514 L
.26083 .25021 L
.27111 .24648 L
.28224 .24146 L
.29185 .23613 L
.30241 .22905 L
.32235 .21149 L
.34341 .18635 L
.36456 .1552 L
.38383 .12538 L
.39341 .11203 L
.39845 .10583 L
.40382 .10008 L
.40849 .09588 L
.41097 .094 L
.41365 .09225 L
.41609 .09092 L
.41834 .08993 L
.42048 .0892 L
.42156 .08891 L
.42274 .08866 L
.42406 .08845 L
.42528 .08834 L
.42592 .08831 L
.42661 .08829 L
.42735 .0883 L
.42803 .08833 L
.42929 .08845 L
.43043 .08862 L
.43176 .08889 L
.43302 .08923 L
.43534 .09003 L
Mistroke
.43748 .091 L
.44235 .09394 L
.44768 .0982