(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   4027242,     155005]*)
(*NotebookOutlinePosition[   4027984,     155030]*)
(*  CellTagsIndexPosition[   4027940,     155026]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["FOCUSING IN FRONT OF NONHOMOGENEITY", "Text",
  FontSize->14,
  Background->None]], "Title",
  CellFrame->True,
  Background->GrayLevel[0.849989]],

Cell[TextData[{
  StyleBox["The wavefront  and the tail  are incident from the left.\n\nThe \
nonhomogeneity  ",
    FontSize->12],
  StyleBox["is located on the positive ",
    FontSize->12,
    CharacterEncoding->"WindowsANSI"],
  StyleBox["x",
    FontSize->12,
    FontSlant->"Italic",
    CharacterEncoding->"WindowsANSI"],
  StyleBox["-axis.",
    FontSize->12,
    CharacterEncoding->"WindowsANSI"],
  StyleBox["  \n\nThe focusing location,  ",
    FontSize->12],
  StyleBox["x0",
    FontSize->12,
    FontVariations->{"CompatibilityType"->0},
    CharacterEncoding->"WindowsANSI"],
  StyleBox[" <0, is in front of the nonhomogeneity and needs to be specified. \
\n\nThe potential   v[x], which is ",
    FontSize->12],
  StyleBox["the nonhomogeneity, is strictly positive.  \n\nThe transmission \
coefficient, left reflection coefficient, and right reflection coefficient, \
respectively, are denoted by  T[k],  L[k],  R[k].\n\nThe tail of the wave is \
denoted by  g[x,t].\n\nThe focusing moment is chosen as  t=0.",
    FontSize->12,
    CharacterEncoding->"WindowsANSI"]
}], "Text",
  FontSize->18,
  Background->RGBColor[1, 1, 0]],

Cell["\<\
The potential and the scattering coefficients are given next:\
\>", \
"Text",
  Background->RGBColor[1, 1, 0]],

Cell[BoxData[{
    \(Clear[v, T, L, R, x0, g, e]; 
    v[x_] = \ UnitStep[
          x]\ 80\ \((Sqrt[5] + 1)\) \((Sqrt[5] + 
            2)\)\ E^\((2\ Sqrt[
                  5]\ x)\)/\((\((1 + Sqrt[5])\) \((2 + 
                      Sqrt[5])\)\ E^\((2\ Sqrt[5]\ x)\) - 2)\)^2;\), "\n", 
    \(\(T[k_] = 
        k \((k + I\ Sqrt[5])\)/\((\((k + I)\) \((k + 2\ I)\))\);\)\), "\n", 
    \(\(L[k_] = 2/\((\((k + I)\) \((k + 2\ I)\))\);\)\), "\n", 
    \(\(R[
          k_] = \(-2\)\ \((k + 
                I\ Sqrt[5])\)/\((\((k + I)\) \((k + 2\ I)\) \((k - 
                    I\ Sqrt[5])\))\);\)\)}], "Input",
  CellOpen->False],

Cell["\<\
Specify the focusing location  x0, a nonpositive number, \
next:\
\>", "Text",
  Background->RGBColor[1, 1, 0]],

Cell[BoxData[
    \(\(\(x0 = \(-1\);\)\(\ \)\)\)], "Input"],

Cell["The tail  g[x,t]  of the focusing  wave is evaluated  next:", "Text",
  Background->RGBColor[1, 1, 0]],

Cell[BoxData[{
    \(\(e[x_] = 
        4\ Sqrt[5]/\((\((1 + Sqrt[5])\) \((2 + 
                      Sqrt[5])\)\ E^\((2\ Sqrt[5]\ x)\) - 
                2)\);\)\n\t\t\), "\n", 
    \(\(q25[x_, t_] = \ 
        2 \((Sqrt[5] - 2 + 
                e[x])\)\ E^\((2 \((\ x - x0 - t)\))\)\  - \((Sqrt[5] - 1 + 
                e[x])\)\ E^\((x - x0 - t)\);\)\n\t\), "\n", 
    \(\t\(q26[x_, t_] = 
        2 \((E^\((\(-2\) \((\ x + x0 + t)\))\)\  - 
              E^\((\(-\((\ x + x0 + t)\)\))\))\)\ ;\)\n\n\), "\n", 
    \(\(g[x_, t_] = \ 
        UnitStep[x]\ \ \ UnitStep[\(-x\) + x0 + t]\ q25[x, t] + 
          UnitStep[\(-x\)]\ \ \ UnitStep[x + x0 + t]\ q26[x, 
              t];\)\)}], "Input",
  CellOpen->False],

Cell[BoxData[
    \(<< Graphics`Animation`\)], "Input",
  CellOpen->False],

Cell[BoxData[
    \(<< Graphics`FilledPlot`\)], "Input",
  CellOpen->False],

Cell[TextData[{
  "The focusing wave is animated  next. The wavefront (",
  StyleBox["magenta",
    FontColor->RGBColor[1, 0, 1]],
  ") and the tail (",
  StyleBox["blue",
    FontColor->RGBColor[0, 0, 1]],
  ") are incident from the left onto the nonhomogeneity (",
  StyleBox["green",
    FontColor->RGBColor[0, 1, 0]],
  "):"
}], "Text",
  Background->RGBColor[1, 1, 0]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Animate[{FilledPlot\[IndentingNewLine][{v[x]}, \ {x, \ \(-2\), \ 
              2}, \ PlotRange -> {\(-1\), 4}, \ 
            Fills \[Rule] {Hue[ .3]}], \[IndentingNewLine]\ \ \ \ \ \ \ \
Plot[{10\ UnitStep[x - x0 - t]}, \ {x, \ \(-2\), \ 2}, \ 
            PlotStyle \[Rule] \ Hue[ .9], 
            PlotRange -> {\(-1\), 
                1}], \[IndentingNewLine]\ \ \ \ \ \ \ Plot[{g[x, 
                t]}, {x, \ \(-2\), \ 2}, \ PlotStyle \[Rule] \ Hue[ .6], \ 
            PlotRange -> {\(-1\), 
                1}]}, \[IndentingNewLine]\ {t, \ \(-0.2\), \ 2.9,  .02}, 
        PlotLabel \[Rule] {"\<t\>", t}];\)\)], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.20178 .12361 L
.20742 .12361 L
.21019 .12361 L
.2114 .12361 L
.21274 .12361 L
.21394 .12361 L
s
.21394 .12361 m
.21439 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00Woool00ol0V@000?ooo`0:oooo00<0003ooooo
ool02Oooo`030000oooooooo00Woool00`000?ooooooo`09oooo00<0003oooooool02Oooo`030000
oooooooo00Woool00`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Tco`00
0`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Hco`0R00001_ooo`030000
oooooooo00Woool00`000?ooooooo`0Eoooo000Foooo00<0003oooooool0;Oooo`03o`2Ioooooooo
00[oool00`000?ooooooo`0ioooo00<0000co`0co`00>C?o00T0000doooo00<0003oooooool05Ooo
o`00A_ooo`03o`2Ioooooooo04Koool00`0003?o03?o000c<ol01P0005Goool004Koool00ol0VOoo
ooooo`16oooo00<0000co`0co`00<C?o0080001Koooo0016oooo00?o09Woooooool0A_ooo`030000
<ol0<ol002lco`020000GOooo`00A_ooo`03o`2Ioooooooo04Koool00`0003?o03?o000/<ol00`00
05ooool004Koool00ol0VOooooooo`16oooo0P0002Xco`030000H_ooo`00A_ooo`03o`2Ioooooooo
04Koool00`0003?o03?o000W<ol00P0006Goool004Koool00ol0VOooooooo`16oooo00<0000co`0c
o`009S?o00030000oooooooo06Goool004Koool00ol0VOooooooo`16oooo00<0000co`0co`009C?o
00030000oooooooo06Koool004Koool00ol0VOooooooo`16oooo00<0000co`0co`0093?o00030000
oooooooo06Ooool004Koool00ol0VOooooooo`16oooo00<0000co`0co`008S?o0080001Zoooo0016
oooo00?o09Woooooool0A_ooo`80000R<ol000<0003oooooool0J_ooo`00A_ooo`03o`2Ioooooooo
04Koool00`0003?o03?o000P<ol000<0003oooooool0Joooo`00A_ooo`03o`2Ioooooooo04Koool0
0`0003?o03?o000O<ol000<0003oooooool0K?ooo`00A_ooo`03o`2Ioooooooo04Koool00`0003?o
03?o000O<ol000<0003oooooool0K?ooo`00A_ooo`03o`2Ioooooooo04Koool00`0003?o03?o000N
<ol000<0003oooooool0KOooo`00A_ooo`03o`2Ioooooooo04Koool00`0003?o03?o000M<ol000<0
003oooooool0K_ooo`00A_ooo`03o`2Ioooooooo04Koool200007C?o00030000oooooooo06ooool0
04Koool00ol0VOooooooo`16oooo00<0000co`0co`006c?o00030000oooooooo073oool004Koool0
0ol0VOooooooo`16oooo00<0000co`0co`006c?o00030000oooooooo073oool004Koool00ol0VOoo
ooooo`16oooo00<0000co`0co`006S?o00030000oooooooo077oool004Koool00ol0VOooooooo`16
oooo00<0000co`0co`006S?o00030000oooooooo077oool004Koool00ol0VOooooooo`16oooo00<0
000co`0co`006C?o00030000oooooooo07;oool004Koool00ol0VOooooooo`16oooo0P0001Xco`00
0`000?ooooooo`1boooo0016oooo00?o09Woooooool0A_ooo`030000<ol0<ol001Pco`000`000?oo
ooooo`1coooo0016oooo00?o09Woooooool0A_ooo`030000<ol0<ol001Pco`000`000?ooooooo`1c
oooo0016oooo00?o09Woooooool0A_ooo`030000<ol0<ol001Lco`000`000?ooooooo`1doooo0016
oooo00?o09Woooooool0A_ooo`030000<ol0<ol001Lco`000`000?ooooooo`1doooo0016oooo00?o
09Woooooool0?_ooo`D00003oooo00<0000co`0co`005S?o00030000oooooooo07Goool004Koool0
0ol0VOooooooo`10oooo00<0003oooooool00oooo`030000<ol0<ol001Hco`000`000?ooooooo`1e
oooo0016oooo00?o09Woooooool0@?ooo`030000oooooooo00?oool300005C?o00030000oooooooo
07Koool004Koool00ol0VOooooooo`10oooo00<0003oooooool00oooo`030000<ol0<ol001Dco`00
0`000?ooooooo`1foooo0016oooo00?o09Woooooool0@?ooo`030000oooooooo00?oool00`0003?o
03?o000E<ol000<0003oooooool0M_ooo`00A_ooo`03o`2Ioooooooo03ooool200001Oooo`030000
<ol0<ol001@co`000`000?ooooooo`1goooo0016oooo00?o09Woooooool0A_ooo`030000<ol0<ol0
01@co`000`000?ooooooo`1goooo0016oooo00?o09Woooooool0A_ooo`030000<ol0<ol001<co`00
0`000?ooooooo`1hoooo0016oooo00?o09Woooooool0A_ooo`80000D<ol000<0003oooooool0N?oo
o`00A_ooo`03o`2Ioooooooo04Koool00`0003?o03?o000C<ol000<0003oooooool0N?ooo`00A_oo
o`03o`2Ioooooooo04Koool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00A_ooo`03o`2I
oooooooo04Koool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00A_ooo`03o`2Ioooooooo
04Koool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00A_ooo`03o`2Ioooooooo04Koool0
0`0003?o03?o000A<ol000<0003oooooool0N_ooo`00A_ooo`03o`2Ioooooooo04Koool200004S?o
00030000oooooooo07[oool004Koool00ol0VOooooooo`16oooo00<0000co`0co`004C?o00030000
oooooooo07[oool004Koool00ol0VOooooooo`16oooo00<0000co`0co`004C?o00030000oooooooo
07[oool004Koool00ol0VOooooooo`16oooo00<0000co`0co`0043?o00030000oooooooo07_oool0
04Koool00ol0VOooooooo`16oooo00<0000co`0co`0043?o00030000oooooooo07_oool004Koool0
0ol0VOooooooo`16oooo00<0000co`0co`0043?o00030000oooooooo07_oool004Koool00ol0VOoo
ooooo`16oooo00<0000co`0co`0043?o00030000oooooooo07_oool004Koool00ol0VOooooooo`16
oooo0P00010co`000`000?ooooooo`1loooo0016oooo00?o09Woooooool0A_ooo`030000<ol0<ol0
00lco`000`000?ooooooo`1loooo0016oooo00?o09Woooooool0A_ooo`030000<ol0<ol000lco`00
0`000?ooooooo`1loooo0016oooo00?o09Woooooool0A_ooo`030000<ol0<ol000lco`000`000?oo
ooooo`1loooo0016oooo00?o09Woooooool0A_ooo`030000<ol0<ol000lco`000`000?ooooooo`1l
oooo0016oooo00?o09Woooooool0A_ooo`030000<ol0<ol000hco`000`000?ooooooo`1moooo0016
oooo00?o09Woooooool0A_ooo`80000?<ol000<0003oooooool0OOooo`00A_ooo`03o`2Ioooooooo
04Koool00`0003?o03?o000><ol000<0003oooooool0OOooo`00A_ooo`03o`2Ioooooooo04Koool0
0`0003?o03?o000><ol000<0003oooooool0OOooo`00A_ooo`03o`2Ioooooooo04Koool00`0003?o
03?o000=<ol000<0003oooooool0O_ooo`00A_ooo`03o`2Ioooooooo03koool400001?ooo`030000
<ol0<ol000dco`000`000?ooooooo`1noooo0016oooo00?o09Woooooool0?_ooo`030000oooooooo
00Goool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00A_ooo`03o`2Ioooooooo03ooool0
0`000?ooooooo`04oooo0`0000dco`000`000?ooooooo`1noooo0017oooo00?o09Woooooool0?ooo
o`030000oooooooo00?oool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00Aoooo`03o`2I
oooooooo03goool010000?ooooooo`0000Coool00`0003?o03?o000<<ol000<0003oooooool0Oooo
o`00Aoooo`03o`2Ioooooooo03koool200001Oooo`030000<ol0<ol000`co`000`000?ooooooo`1o
oooo0017oooo00?o09Woooooool0AOooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo0017
oooo00?o09Woooooool0AOooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo0017oooo00?o
09Woooooool0AOooo`80000=<ol000<0003oooooool0Ooooo`00Aoooo`03o`2Ioooooooo04Goool0
0`0003?o03?o000<<ol000<0003oooooool0Ooooo`00Aoooo`03o`2Ioooooooo04Goool00`0003?o
03?o000;<ol000<0003oooooool0P?ooo`00Aoooo`03o`2Ioooooooo04Goool00`0003?o03?o000;
<ol000<0003oooooool0P?ooo`00Aoooo`03o`2Ioooooooo04Goool00`0003?o03?o000;<ol000<0
003oooooool0P?ooo`00Aoooo`03o`2Ioooooooo04Goool00`0003?o03?o000;<ol000<0003ooooo
ool0P?ooo`00Aoooo`03o`2Ioooooooo04Goool00`0003?o03?o000;<ol000<0003oooooool0P?oo
o`00Aoooo`03o`2Ioooooooo04Goool2000033?o00030000oooooooo083oool004Ooool00ol0VOoo
ooooo`15oooo00<0000co`0co`002c?o00030000oooooooo083oool004Ooool00ol0VOooooooo`15
oooo00<0000co`0co`002S?o00030000oooooooo087oool004Ooool00ol0VOooooooo`15oooo00<0
000co`0co`002S?o00030000oooooooo087oool004Ooool00ol0VOooooooo`15oooo00<0000co`0c
o`002S?o00030000oooooooo087oool004Ooool00ol0VOooooooo`15oooo00<0000co`0co`002S?o
00030000oooooooo087oool004Ooool00ol0VOooooooo`15oooo0P0000/co`000`000?ooooooo`21
oooo0017oooo00?o09Woooooool0AOooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo0017
oooo00?o09Woooooool0AOooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo0017oooo00?o
09Woooooool0AOooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo0017oooo00?o09Wooooo
ool0AOooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo0017oooo00?o09Woooooool0AOoo
o`030000<ol0<ol000Tco`000`000?ooooooo`22oooo0017oooo00?o09Woooooool0AOooo`80000:
<ol000<0003oooooool0P_ooo`00Aoooo`03o`2Ioooooooo04Goool00`0003?o03?o0009<ol000<0
003oooooool0P_ooo`00Aoooo`03o`2Ioooooooo04Goool00`0003?o03?o0009<ol000<0003ooooo
ool0P_ooo`00Aoooo`03o`2Ioooooooo04Goool00`0003?o03?o0008<ol000<0003oooooool0Pooo
o`00Aoooo`03o`2Ioooooooo03koool200001Oooo`030000<ol0<ol000Pco`000`000?ooooooo`23
oooo0017oooo00?o09Woooooool0?Oooo`040000oooooooo00001?ooo`030000<ol0<ol000Pco`00
0`000?ooooooo`23oooo0017oooo00?o09Woooooool0?oooo`030000oooooooo00?oool3000023?o
00030000oooooooo08?oool004Ooool00ol0VOooooooo`10oooo00<0003oooooool00_ooo`030000
<ol0<ol000Pco`000`000?ooooooo`23oooo0017oooo00?o09Woooooool0?Oooo`040000oooooooo
00001?ooo`030000<ol0<ol000Pco`000`000?ooooooo`23oooo0017oooo00?o09Woooooool0?_oo
o`800005oooo00<0000co`0co`001c?o00030000oooooooo08Coool004Ooool00ol0VOooooooo`15
oooo00<0000co`0co`001c?o00030000oooooooo08Coool004Ooool00ol0VOooooooo`15oooo00<0
000co`0co`001c?o00030000oooooooo08Coool004Ooool00ol0VOooooooo`15oooo00<0000co`0c
o`001c?o00030000oooooooo08Coool004Ooool00ol0VOooooooo`15oooo0P0000Pco`000`000?oo
ooooo`24oooo0017oooo00?o09Woooooool0AOooo`030000<ol0<ol000Lco`000`000?ooooooo`24
oooo0017oooo00?o09Woooooool0AOooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo0017
oooo00?o09Woooooool0AOooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo0017oooo00?o
09Woooooool0AOooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo0017oooo00?o09Wooooo
ool0AOooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo0017oooo00?o09Woooooool0AOoo
o`800007<ol000<0003oooooool0QOooo`00Aoooo`03o`2Ioooooooo04Goool00`0003?o03?o0006
<ol000<0003oooooool0QOooo`00Aoooo`03o`2Ioooooooo04Goool00`0003?o03?o0006<ol000<0
003oooooool0QOooo`00Aoooo`03o`2Ioooooooo04Goool00`0003?o03?o0006<ol000<0003ooooo
ool0QOooo`00Aoooo`03o`2Ioooooooo04Goool00`0003?o03?o0006<ol000<0003oooooool0QOoo
o`00Aoooo`03o`2Ioooooooo04Goool00`0003?o03?o0006<ol000<0003oooooool0QOooo`00Aooo
o`03o`2Ioooooooo04Goool200001S?o00030000oooooooo08Koool004Ooool00ol0VOooooooo`15
oooo00<0000co`0co`001C?o00030000oooooooo08Koool004Ooool00ol0VOooooooo`15oooo00<0
000co`0co`001C?o00030000oooooooo08Koool004Ooool00ol0VOooooooo`15oooo00<0000co`0c
o`001C?o00030000oooooooo08Koool004Ooool00ol0VOooooooo`15oooo00<0000co`0co`001C?o
00030000oooooooo08Koool004Ooool00ol0VOooooooo`15oooo00<0000co`0co`001C?o00030000
oooooooo08Koool004Ooool00ol0VOooooooo`15oooo0P0000Hco`000`000?ooooooo`26oooo0017
oooo00?o09Woooooool0AOooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo0017oooo00?o
09Woooooool0AOooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo0017oooo00?o09Wooooo
ool0AOooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo0017oooo00?o09Woooooool0AOoo
o`030000<ol0<ol000@co`000`000?ooooooo`27oooo0017oooo00?o09Woooooool0?oooo`<00003
oooo00<0000co`0co`0013?o00030000oooooooo08Ooool004Ooool00ol0VOooooooo`10oooo00<0
003oooooool00_ooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo0017oooo00?o09Wooooo
ool0?Oooo`D00003oooo0`0000@co`000`000?ooooooo`27oooo0027oooo00@0003oooooool00004
oooo1c?o08[oool008Soool00`000?ooo`000004oooo1c?o08[oool008Woool200001?ooo`Lco`2:
oooo002?oooo1c?o08[oool008ooool7<ol0R_ooo`00NOooo`030000oooooooo01?oool7<ol03_oo
o`030000oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool02Oooo`Lco`0?
oooo00<0003oooooool0N?ooo`00N?ooo`030000oooooooo00;oool200001?ooo`030000oooooooo
00Woool4<ol00P000004<ol0oooooooooooo0P0000?oool400000oooo`030000oooooooo07Soool0
07Soool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo00Coool4
00000c?o00040000<ol0<ol000002?ooo`030000oooooooo00Coool00`000?ooooooo`1hoooo001g
oooo00<0003oooooool00_ooo`030000oooooooo013oool3<ol000@0000co`0co`000009oooo00<0
003oooooool01?ooo`030000oooooooo07Ooool007Soool00`000?ooooooo`0500003oooo`<co`00
100003?o03?o000000[oool00`000?ooooooo`02oooo00<0003oooooool0N?ooo`00N?ooo`050000
oooooooooooo000001;oool3<ol000@0000co`0co`000008oooo00@0003oooooool00003oooo00<0
003oooooool0N?ooo`00NOooo`030000oooooooo01?oool4<ol00P000003<ol0oooooooo00Ooool2
00000oooo`030000oooooooo07Woool008ooool7<ol0R_ooo`00Soooo`Lco`2:oooo0000\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {290.125, 148.813}} -> {-0.349561, \
1.05307, 0.00349883, 0.00566123}, {{79.875, 308.563}, {290.125, 148.813}} -> \
{-4.02891, 4.80237, 0.0165954, 0.0319664}, {{79.875, 308.563}, {290.125, \
148.813}} -> {-4.02891, 4.80237, 0.0165954, 0.0319664}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.18) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.20178 .12361 L
.20742 .12361 L
.21274 .12361 L
.21506 .12361 L
.21753 .12361 L
.21881 .12361 L
s
.21881 .12361 m
.2191 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.18) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?l0VOooo`09oooo00<0003ooooo
ool02Oooo`030000oooooooo00Woool00`000?ooooooo`09oooo00<0003oooooool02Oooo`030000
oooooooo00Woool00`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Tco`00
0`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Hco`0R00001_ooo`030000
oooooooo00Woool00`000?ooooooo`0Eoooo000Foooo00<0003oooooool0;oooo`03o`2Ioooooooo
00Soool00`000?ooooooo`0ioooo00<0000co`0co`00>C?o00T0000doooo00<0003oooooool05Ooo
o`00B?ooo`03o`2Ioooooooo04Coool00`0003?o03?o000c<ol01P0005Goool004Soool00ol0VOoo
ooooo`14oooo00<0000co`0co`00<C?o0080001Koooo0018oooo00?o09Woooooool0A?ooo`030000
<ol0<ol002lco`020000GOooo`00B?ooo`03o`2Ioooooooo04Coool00`0003?o03?o000/<ol00`00
05ooool004Soool00ol0VOooooooo`14oooo0P0002Xco`030000H_ooo`00B?ooo`03o`2Ioooooooo
04Coool00`0003?o03?o000W<ol00P0006Goool004Soool00ol0VOooooooo`14oooo00<0000co`0c
o`009S?o00030000oooooooo06Goool004Soool00ol0VOooooooo`14oooo00<0000co`0co`009C?o
00030000oooooooo06Koool004Soool00ol0VOooooooo`14oooo00<0000co`0co`0093?o00030000
oooooooo06Ooool004Soool00ol0VOooooooo`14oooo00<0000co`0co`008S?o0080001Zoooo0018
oooo00?o09Woooooool0A?ooo`80000R<ol000<0003oooooool0J_ooo`00B?ooo`03o`2Ioooooooo
04Coool00`0003?o03?o000P<ol000<0003oooooool0Joooo`00B?ooo`03o`2Ioooooooo04Coool0
0`0003?o03?o000O<ol000<0003oooooool0K?ooo`00B?ooo`03o`2Ioooooooo04Coool00`0003?o
03?o000O<ol000<0003oooooool0K?ooo`00B?ooo`03o`2Ioooooooo04Coool00`0003?o03?o000N
<ol000<0003oooooool0KOooo`00B?ooo`03o`2Ioooooooo04Coool00`0003?o03?o000M<ol000<0
003oooooool0K_ooo`00B?ooo`03o`2Ioooooooo04Coool200007C?o00030000oooooooo06ooool0
04Soool00ol0VOooooooo`14oooo00<0000co`0co`006c?o00030000oooooooo073oool004Soool0
0ol0VOooooooo`14oooo00<0000co`0co`006c?o00030000oooooooo073oool004Soool00ol0VOoo
ooooo`14oooo00<0000co`0co`006S?o00030000oooooooo077oool004Soool00ol0VOooooooo`14
oooo00<0000co`0co`006S?o00030000oooooooo077oool004Soool00ol0VOooooooo`14oooo00<0
000co`0co`006C?o00030000oooooooo07;oool004Soool00ol0VOooooooo`14oooo0P0001Xco`00
0`000?ooooooo`1boooo0018oooo00?o09Woooooool0A?ooo`030000<ol0<ol001Pco`000`000?oo
ooooo`1coooo0018oooo00?o09Woooooool0A?ooo`030000<ol0<ol001Pco`000`000?ooooooo`1c
oooo0018oooo00?o09Woooooool0A?ooo`030000<ol0<ol001Lco`000`000?ooooooo`1doooo0018
oooo00?o09Woooooool0A?ooo`030000<ol0<ol001Lco`000`000?ooooooo`1doooo0018oooo00?o
09Woooooool0??ooo`D00003oooo00<0000co`0co`005S?o00030000oooooooo07Goool004Soool0
0ol0VOooooooo`0noooo00<0003oooooool00oooo`030000<ol0<ol001Hco`000`000?ooooooo`1e
oooo0018oooo00?o09Woooooool0?_ooo`030000oooooooo00?oool300005C?o00030000oooooooo
07Koool004Soool00ol0VOooooooo`0noooo00<0003oooooool00oooo`030000<ol0<ol001Dco`00
0`000?ooooooo`1foooo0018oooo00?o09Woooooool0?_ooo`030000oooooooo00?oool00`0003?o
03?o000E<ol000<0003oooooool0M_ooo`00B?ooo`03o`2Ioooooooo03goool200001Oooo`030000
<ol0<ol001@co`000`000?ooooooo`1goooo0018oooo00?o09Woooooool0A?ooo`030000<ol0<ol0
01@co`000`000?ooooooo`1goooo0018oooo00?o09Woooooool0A?ooo`030000<ol0<ol001<co`00
0`000?ooooooo`1hoooo0018oooo00?o09Woooooool0A?ooo`80000D<ol000<0003oooooool0N?oo
o`00B?ooo`03o`2Ioooooooo04Coool00`0003?o03?o000C<ol000<0003oooooool0N?ooo`00B?oo
o`03o`2Ioooooooo04Coool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00B?ooo`03o`2I
oooooooo04Coool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00B?ooo`03o`2Ioooooooo
04Coool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00B?ooo`03o`2Ioooooooo04Coool0
0`0003?o03?o000A<ol000<0003oooooool0N_ooo`00B?ooo`03o`2Ioooooooo04Coool200004S?o
00030000oooooooo07[oool004Soool00ol0VOooooooo`14oooo00<0000co`0co`004C?o00030000
oooooooo07[oool004Soool00ol0VOooooooo`14oooo00<0000co`0co`004C?o00030000oooooooo
07[oool004Soool00ol0VOooooooo`14oooo00<0000co`0co`0043?o00030000oooooooo07_oool0
04Soool00ol0VOooooooo`14oooo00<0000co`0co`0043?o00030000oooooooo07_oool004Soool0
0ol0VOooooooo`14oooo00<0000co`0co`0043?o00030000oooooooo07_oool004Soool00ol0VOoo
ooooo`14oooo00<0000co`0co`0043?o00030000oooooooo07_oool004Soool00ol0VOooooooo`14
oooo0P00010co`000`000?ooooooo`1loooo0018oooo00?o09Woooooool0A?ooo`030000<ol0<ol0
00lco`000`000?ooooooo`1loooo0018oooo00?o09Woooooool0A?ooo`030000<ol0<ol000lco`00
0`000?ooooooo`1loooo0018oooo00?o09Woooooool0A?ooo`030000<ol0<ol000lco`000`000?oo
ooooo`1loooo0018oooo00?o09Woooooool0A?ooo`030000<ol0<ol000lco`000`000?ooooooo`1l
oooo0018oooo00?o09Woooooool0A?ooo`030000<ol0<ol000hco`000`000?ooooooo`1moooo0018
oooo00?o09Woooooool0A?ooo`80000?<ol000<0003oooooool0OOooo`00B?ooo`03o`2Ioooooooo
04Coool00`0003?o03?o000><ol000<0003oooooool0OOooo`00B?ooo`03o`2Ioooooooo04Coool0
0`0003?o03?o000><ol000<0003oooooool0OOooo`00B?ooo`03o`2Ioooooooo04Coool00`0003?o
03?o000=<ol000<0003oooooool0O_ooo`00B?ooo`03o`2Ioooooooo03coool400001?ooo`030000
<ol0<ol000dco`000`000?ooooooo`1noooo0018oooo00?o09Woooooool0??ooo`030000oooooooo
00Goool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00B?ooo`03o`2Ioooooooo03goool0
0`000?ooooooo`04oooo0`0000dco`000`000?ooooooo`1noooo0018oooo00?o09Woooooool0?_oo
o`030000oooooooo00?oool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00B?ooo`03o`2I
oooooooo03coool010000?ooooooo`0000Coool00`0003?o03?o000<<ol000<0003oooooool0Oooo
o`00B?ooo`03o`2Ioooooooo03goool200001Oooo`030000<ol0<ol000`co`000`000?ooooooo`1o
oooo0018oooo00?o09Woooooool0A?ooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo0018
oooo00?o09Woooooool0A?ooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo0018oooo00?o
09Woooooool0A?ooo`80000=<ol000<0003oooooool0Ooooo`00B?ooo`03o`2Ioooooooo04Coool0
0`0003?o03?o000<<ol000<0003oooooool0Ooooo`00B?ooo`03o`2Ioooooooo04Coool00`0003?o
03?o000;<ol000<0003oooooool0P?ooo`00B?ooo`03o`2Ioooooooo04Coool00`0003?o03?o000;
<ol000<0003oooooool0P?ooo`00B?ooo`03o`2Ioooooooo04Coool00`0003?o03?o000;<ol000<0
003oooooool0P?ooo`00B?ooo`03o`2Ioooooooo04Coool00`0003?o03?o000;<ol000<0003ooooo
ool0P?ooo`00B?ooo`03o`2Ioooooooo04Coool00`0003?o03?o000;<ol000<0003oooooool0P?oo
o`00B?ooo`03o`2Ioooooooo04Coool2000033?o00030000oooooooo083oool004Soool00ol0VOoo
ooooo`14oooo00<0000co`0co`002c?o00030000oooooooo083oool004Soool00ol0VOooooooo`14
oooo00<0000co`0co`002S?o00030000oooooooo087oool004Soool00ol0VOooooooo`14oooo00<0
000co`0co`002S?o00030000oooooooo087oool004Soool00ol0VOooooooo`14oooo00<0000co`0c
o`002S?o00030000oooooooo087oool004Soool00ol0VOooooooo`14oooo00<0000co`0co`002S?o
00030000oooooooo087oool004Soool00ol0VOooooooo`14oooo0P0000/co`000`000?ooooooo`21
oooo0018oooo00?o09Woooooool0A?ooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo0018
oooo00?o09Woooooool0A?ooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo0018oooo00?o
09Woooooool0A?ooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo0018oooo00?o09Wooooo
ool0A?ooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo0018oooo00?o09Woooooool0A?oo
o`030000<ol0<ol000Tco`000`000?ooooooo`22oooo0018oooo00?o09Woooooool0A?ooo`80000:
<ol000<0003oooooool0P_ooo`00B?ooo`03o`2Ioooooooo04Coool00`0003?o03?o0009<ol000<0
003oooooool0P_ooo`00B?ooo`03o`2Ioooooooo04Coool00`0003?o03?o0009<ol000<0003ooooo
ool0P_ooo`00B?ooo`03o`2Ioooooooo04Coool00`0003?o03?o0008<ol000<0003oooooool0Pooo
o`00B?ooo`03o`2Ioooooooo03goool200001Oooo`030000<ol0<ol000Pco`000`000?ooooooo`23
oooo0018oooo00?o09Woooooool0??ooo`040000oooooooo00001?ooo`030000<ol0<ol000Pco`00
0`000?ooooooo`23oooo0018oooo00?o09Woooooool0?_ooo`030000oooooooo00?oool3000023?o
00030000oooooooo08?oool004Soool00ol0VOooooooo`0ooooo00<0003oooooool00_ooo`030000
<ol0<ol000Pco`000`000?ooooooo`23oooo0018oooo00?o09Woooooool0??ooo`040000oooooooo
00001?ooo`030000<ol0<ol000Pco`000`000?ooooooo`23oooo0018oooo00?o09Woooooool0?Ooo
o`800005oooo00<0000co`0co`001c?o00030000oooooooo08Coool004Soool00ol0VOooooooo`14
oooo00<0000co`0co`001c?o00030000oooooooo08Coool004Soool00ol0VOooooooo`14oooo00<0
000co`0co`001c?o00030000oooooooo08Coool004Soool00ol0VOooooooo`14oooo00<0000co`0c
o`001c?o00030000oooooooo08Coool004Soool00ol0VOooooooo`14oooo0P0000Pco`000`000?oo
ooooo`24oooo0018oooo00?o09Woooooool0A?ooo`030000<ol0<ol000Lco`000`000?ooooooo`24
oooo0018oooo00?o09Woooooool0A?ooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo0018
oooo00?o09Woooooool0A?ooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo0018oooo00?o
09Woooooool0A?ooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo0018oooo00?o09Wooooo
ool0A?ooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo0018oooo00?o09Woooooool0A?oo
o`800007<ol000<0003oooooool0QOooo`00B?ooo`03o`2Ioooooooo04Coool00`0003?o03?o0006
<ol000<0003oooooool0QOooo`00B?ooo`03o`2Ioooooooo04Coool00`0003?o03?o0006<ol000<0
003oooooool0QOooo`00B?ooo`03o`2Ioooooooo04Coool00`0003?o03?o0006<ol000<0003ooooo
ool0QOooo`00B?ooo`03o`2Ioooooooo04Coool00`0003?o03?o0006<ol000<0003oooooool0QOoo
o`00B?ooo`03o`2Ioooooooo04Coool00`0003?o03?o0006<ol000<0003oooooool0QOooo`00B?oo
o`03o`2Ioooooooo04Coool200001S?o00030000oooooooo08Koool004Soool00ol0VOooooooo`14
oooo00<0000co`0co`001C?o00030000oooooooo08Koool004Soool00ol0VOooooooo`14oooo00<0
000co`0co`001C?o00030000oooooooo08Koool004Soool00ol0VOooooooo`14oooo00<0000co`0c
o`001C?o00030000oooooooo08Koool004Soool00ol0VOooooooo`14oooo00<0000co`0co`001C?o
00030000oooooooo08Koool004Soool00ol0VOooooooo`14oooo00<0000co`0co`001C?o00030000
oooooooo08Koool004Soool00ol0VOooooooo`14oooo0P0000Hco`000`000?ooooooo`26oooo0018
oooo00?o09Woooooool0A?ooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo0018oooo00?o
09Woooooool0A?ooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo0018oooo00?o09Wooooo
ool0A?ooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo0018oooo00?o09Woooooool0A?oo
o`030000<ol0<ol000@co`000`000?ooooooo`27oooo0018oooo00?o09Woooooool0?_ooo`<00003
oooo00<0000co`0co`0013?o00030000oooooooo08Ooool004Soool00ol0VOooooooo`0ooooo00<0
003oooooool00_ooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo0018oooo00?o09Wooooo
ool0??ooo`D00003oooo0`0000@co`000`000?ooooooo`27oooo0027oooo00@0003oooooool00004
oooo1c?o08[oool008Soool00`000?ooo`000004oooo1c?o08[oool008Woool200001?ooo`Lco`2:
oooo002?oooo1c?o08[oool008ooool7<ol0R_ooo`00M_ooo`030000oooooooo01Koool7<ol04Ooo
o`030000oooooooo07Koool007Goool00`000?ooooooo`08oooo00<0003oooooool03?ooo`Lco`0B
oooo00<0003oooooool0MOooo`00MOooo`030000oooooooo00;oool200001?ooo`030000oooooooo
00coool00c?o000000000004<ol00P0000?oool500000_ooo`800004oooo00<0003oooooool0MOoo
o`00MOooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01?oo
o`@00003oooo00@0000co`0co`000003<ol01oooo`050000oooooooooooo000000;oool01@000?oo
ooooooooo`00001goooo001doooo00<0003oooooool00_ooo`030000oooooooo01?oool0100003?o
03?o000000<co`07oooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?oo
ooooo`1doooo001eoooo00<0003oooooool01@0001;oool0100003?o03?o000000<co`07oooo00<0
003oooooool00_ooo`800004oooo00<0003oooooool0MOooo`00MOooo`050000oooooooooooo0000
01Goool0100003?o03?o000000<co`07oooo00D0003oooooooooool000000_ooo`050000oooooooo
oooo000007Ooool007Koool00`000?ooooooo`0Foooo00<co`000000000013?o00Koool200001?oo
o`800003oooo00<0003oooooool0M_ooo`00Soooo`Lco`2:oooo002?oooo1c?o08[oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.16) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.20342 .12361 L
.21345 .12361 L
.21786 .12361 L
.22037 .12361 L
.22159 .12361 L
.22272 .12361 L
s
.22272 .12361 m
.22318 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.16) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooool0V@09oooo00<0003ooooo
ool02Oooo`030000oooooooo00Woool00`000?ooooooo`09oooo00<0003oooooool02Oooo`030000
oooooooo00Woool00`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Tco`00
0`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Hco`0R00001_ooo`030000
oooooooo00Woool00`000?ooooooo`0Eoooo000Foooo00<0003oooooool0<?ooo`03o`2Ioooooooo
00Ooool00`000?ooooooo`0ioooo00<0000co`0co`00>C?o00T0000doooo00<0003oooooool05Ooo
o`00BOooo`03o`2Ioooooooo04?oool00`0003?o03?o000c<ol01P0005Goool004Woool00ol0VOoo
ooooo`13oooo00<0000co`0co`00<C?o0080001Koooo0019oooo00?o09Woooooool0@oooo`030000
<ol0<ol002lco`020000GOooo`00BOooo`03o`2Ioooooooo04?oool00`0003?o03?o000/<ol00`00
05ooool004Woool00ol0VOooooooo`13oooo0P0002Xco`030000H_ooo`00BOooo`03o`2Ioooooooo
04?oool00`0003?o03?o000W<ol00P0006Goool004Woool00ol0VOooooooo`13oooo00<0000co`0c
o`009S?o00030000oooooooo06Goool004Woool00ol0VOooooooo`13oooo00<0000co`0co`009C?o
00030000oooooooo06Koool004Woool00ol0VOooooooo`13oooo00<0000co`0co`0093?o00030000
oooooooo06Ooool004Woool00ol0VOooooooo`13oooo00<0000co`0co`008S?o0080001Zoooo0019
oooo00?o09Woooooool0@oooo`80000R<ol000<0003oooooool0J_ooo`00BOooo`03o`2Ioooooooo
04?oool00`0003?o03?o000P<ol000<0003oooooool0Joooo`00BOooo`03o`2Ioooooooo04?oool0
0`0003?o03?o000O<ol000<0003oooooool0K?ooo`00BOooo`03o`2Ioooooooo04?oool00`0003?o
03?o000O<ol000<0003oooooool0K?ooo`00BOooo`03o`2Ioooooooo04?oool00`0003?o03?o000N
<ol000<0003oooooool0KOooo`00BOooo`03o`2Ioooooooo04?oool00`0003?o03?o000M<ol000<0
003oooooool0K_ooo`00BOooo`03o`2Ioooooooo04?oool200007C?o00030000oooooooo06ooool0
04Woool00ol0VOooooooo`13oooo00<0000co`0co`006c?o00030000oooooooo073oool004Woool0
0ol0VOooooooo`13oooo00<0000co`0co`006c?o00030000oooooooo073oool004Woool00ol0VOoo
ooooo`13oooo00<0000co`0co`006S?o00030000oooooooo077oool004Woool00ol0VOooooooo`13
oooo00<0000co`0co`006S?o00030000oooooooo077oool004Woool00ol0VOooooooo`13oooo00<0
000co`0co`006C?o00030000oooooooo07;oool004Woool00ol0VOooooooo`13oooo0P0001Xco`00
0`000?ooooooo`1boooo0019oooo00?o09Woooooool0@oooo`030000<ol0<ol001Pco`000`000?oo
ooooo`1coooo0019oooo00?o09Woooooool0@oooo`030000<ol0<ol001Pco`000`000?ooooooo`1c
oooo0019oooo00?o09Woooooool0@oooo`030000<ol0<ol001Lco`000`000?ooooooo`1doooo0019
oooo00?o09Woooooool0@oooo`030000<ol0<ol001Lco`000`000?ooooooo`1doooo0019oooo00?o
09Woooooool0>oooo`D00003oooo00<0000co`0co`005S?o00030000oooooooo07Goool004Woool0
0ol0VOooooooo`0moooo00<0003oooooool00oooo`030000<ol0<ol001Hco`000`000?ooooooo`1e
oooo0019oooo00?o09Woooooool0?Oooo`030000oooooooo00?oool300005C?o00030000oooooooo
07Koool004Woool00ol0VOooooooo`0moooo00<0003oooooool00oooo`030000<ol0<ol001Dco`00
0`000?ooooooo`1foooo0019oooo00?o09Woooooool0?Oooo`030000oooooooo00?oool00`0003?o
03?o000E<ol000<0003oooooool0M_ooo`00BOooo`03o`2Ioooooooo03coool200001Oooo`030000
<ol0<ol001@co`000`000?ooooooo`1goooo0019oooo00?o09Woooooool0@oooo`030000<ol0<ol0
01@co`000`000?ooooooo`1goooo0019oooo00?o09Woooooool0@oooo`030000<ol0<ol001<co`00
0`000?ooooooo`1hoooo0019oooo00?o09Woooooool0@oooo`80000D<ol000<0003oooooool0N?oo
o`00BOooo`03o`2Ioooooooo04?oool00`0003?o03?o000C<ol000<0003oooooool0N?ooo`00BOoo
o`03o`2Ioooooooo04?oool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00BOooo`03o`2I
oooooooo04?oool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00BOooo`03o`2Ioooooooo
04?oool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00BOooo`03o`2Ioooooooo04?oool0
0`0003?o03?o000A<ol000<0003oooooool0N_ooo`00BOooo`03o`2Ioooooooo04?oool200004S?o
00030000oooooooo07[oool004Woool00ol0VOooooooo`13oooo00<0000co`0co`004C?o00030000
oooooooo07[oool004Woool00ol0VOooooooo`13oooo00<0000co`0co`004C?o00030000oooooooo
07[oool004Woool00ol0VOooooooo`13oooo00<0000co`0co`0043?o00030000oooooooo07_oool0
04Woool00ol0VOooooooo`13oooo00<0000co`0co`0043?o00030000oooooooo07_oool004Woool0
0ol0VOooooooo`13oooo00<0000co`0co`0043?o00030000oooooooo07_oool004Woool00ol0VOoo
ooooo`13oooo00<0000co`0co`0043?o00030000oooooooo07_oool004Woool00ol0VOooooooo`13
oooo0P00010co`000`000?ooooooo`1loooo0019oooo00?o09Woooooool0@oooo`030000<ol0<ol0
00lco`000`000?ooooooo`1loooo0019oooo00?o09Woooooool0@oooo`030000<ol0<ol000lco`00
0`000?ooooooo`1loooo0019oooo00?o09Woooooool0@oooo`030000<ol0<ol000lco`000`000?oo
ooooo`1loooo0019oooo00?o09Woooooool0@oooo`030000<ol0<ol000lco`000`000?ooooooo`1l
oooo0019oooo00?o09Woooooool0@oooo`030000<ol0<ol000hco`000`000?ooooooo`1moooo0019
oooo00?o09Woooooool0@oooo`80000?<ol000<0003oooooool0OOooo`00BOooo`03o`2Ioooooooo
04?oool00`0003?o03?o000><ol000<0003oooooool0OOooo`00BOooo`03o`2Ioooooooo04?oool0
0`0003?o03?o000><ol000<0003oooooool0OOooo`00BOooo`03o`2Ioooooooo04?oool00`0003?o
03?o000=<ol000<0003oooooool0O_ooo`00BOooo`03o`2Ioooooooo03_oool400001?ooo`030000
<ol0<ol000dco`000`000?ooooooo`1noooo0019oooo00?o09Woooooool0>oooo`030000oooooooo
00Goool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00BOooo`03o`2Ioooooooo03coool0
0`000?ooooooo`04oooo0`0000dco`000`000?ooooooo`1noooo0019oooo00?o09Woooooool0?Ooo
o`030000oooooooo00?oool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00BOooo`03o`2I
oooooooo03_oool010000?ooooooo`0000Coool00`0003?o03?o000<<ol000<0003oooooool0Oooo
o`00BOooo`03o`2Ioooooooo03coool200001Oooo`030000<ol0<ol000`co`000`000?ooooooo`1o
oooo0019oooo00?o09Woooooool0@oooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo0019
oooo00?o09Woooooool0@oooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo0019oooo00?o
09Woooooool0@oooo`80000=<ol000<0003oooooool0Ooooo`00BOooo`03o`2Ioooooooo04?oool0
0`0003?o03?o000<<ol000<0003oooooool0Ooooo`00BOooo`03o`2Ioooooooo04?oool00`0003?o
03?o000;<ol000<0003oooooool0P?ooo`00BOooo`03o`2Ioooooooo04?oool00`0003?o03?o000;
<ol000<0003oooooool0P?ooo`00BOooo`03o`2Ioooooooo04?oool00`0003?o03?o000;<ol000<0
003oooooool0P?ooo`00BOooo`03o`2Ioooooooo04?oool00`0003?o03?o000;<ol000<0003ooooo
ool0P?ooo`00BOooo`03o`2Ioooooooo04?oool00`0003?o03?o000;<ol000<0003oooooool0P?oo
o`00BOooo`03o`2Ioooooooo04?oool2000033?o00030000oooooooo083oool004Woool00ol0VOoo
ooooo`13oooo00<0000co`0co`002c?o00030000oooooooo083oool004Woool00ol0VOooooooo`13
oooo00<0000co`0co`002S?o00030000oooooooo087oool004Woool00ol0VOooooooo`13oooo00<0
000co`0co`002S?o00030000oooooooo087oool004Woool00ol0VOooooooo`13oooo00<0000co`0c
o`002S?o00030000oooooooo087oool004Woool00ol0VOooooooo`13oooo00<0000co`0co`002S?o
00030000oooooooo087oool004Woool00ol0VOooooooo`13oooo0P0000/co`000`000?ooooooo`21
oooo0019oooo00?o09Woooooool0@oooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo0019
oooo00?o09Woooooool0@oooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo0019oooo00?o
09Woooooool0@oooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo0019oooo00?o09Wooooo
ool0@oooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo0019oooo00?o09Woooooool0@ooo
o`030000<ol0<ol000Tco`000`000?ooooooo`22oooo0019oooo00?o09Woooooool0@oooo`80000:
<ol000<0003oooooool0P_ooo`00BOooo`03o`2Ioooooooo04?oool00`0003?o03?o0009<ol000<0
003oooooool0P_ooo`00BOooo`03o`2Ioooooooo04?oool00`0003?o03?o0009<ol000<0003ooooo
ool0P_ooo`00BOooo`03o`2Ioooooooo04?oool00`0003?o03?o0008<ol000<0003oooooool0Pooo
o`00BOooo`03o`2Ioooooooo03coool200001Oooo`030000<ol0<ol000Pco`000`000?ooooooo`23
oooo0019oooo00?o09Woooooool0>oooo`040000oooooooo00001?ooo`030000<ol0<ol000Pco`00
0`000?ooooooo`23oooo0019oooo00?o09Woooooool0?Oooo`030000oooooooo00?oool3000023?o
00030000oooooooo08?oool004Woool00ol0VOooooooo`0noooo00<0003oooooool00_ooo`030000
<ol0<ol000Pco`000`000?ooooooo`23oooo0019oooo00?o09Woooooool0>oooo`040000oooooooo
00001?ooo`030000<ol0<ol000Pco`000`000?ooooooo`23oooo0019oooo00?o09Woooooool0??oo
o`800005oooo00<0000co`0co`001c?o00030000oooooooo08Coool004Woool00ol0VOooooooo`13
oooo00<0000co`0co`001c?o00030000oooooooo08Coool004Woool00ol0VOooooooo`13oooo00<0
000co`0co`001c?o00030000oooooooo08Coool004Woool00ol0VOooooooo`13oooo00<0000co`0c
o`001c?o00030000oooooooo08Coool004Woool00ol0VOooooooo`13oooo0P0000Pco`000`000?oo
ooooo`24oooo0019oooo00?o09Woooooool0@oooo`030000<ol0<ol000Lco`000`000?ooooooo`24
oooo0019oooo00?o09Woooooool0@oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo0019
oooo00?o09Woooooool0@oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo0019oooo00?o
09Woooooool0@oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo0019oooo00?o09Wooooo
ool0@oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo0019oooo00?o09Woooooool0@ooo
o`800007<ol000<0003oooooool0QOooo`00BOooo`03o`2Ioooooooo04?oool00`0003?o03?o0006
<ol000<0003oooooool0QOooo`00BOooo`03o`2Ioooooooo04?oool00`0003?o03?o0006<ol000<0
003oooooool0QOooo`00BOooo`03o`2Ioooooooo04?oool00`0003?o03?o0006<ol000<0003ooooo
ool0QOooo`00BOooo`03o`2Ioooooooo04?oool00`0003?o03?o0006<ol000<0003oooooool0QOoo
o`00BOooo`03o`2Ioooooooo04?oool00`0003?o03?o0006<ol000<0003oooooool0QOooo`00BOoo
o`03o`2Ioooooooo04?oool200001S?o00030000oooooooo08Koool004Woool00ol0VOooooooo`13
oooo00<0000co`0co`001C?o00030000oooooooo08Koool004Woool00ol0VOooooooo`13oooo00<0
000co`0co`001C?o00030000oooooooo08Koool004Woool00ol0VOooooooo`13oooo00<0000co`0c
o`001C?o00030000oooooooo08Koool004Woool00ol0VOooooooo`13oooo00<0000co`0co`001C?o
00030000oooooooo08Koool004Woool00ol0VOooooooo`13oooo00<0000co`0co`001C?o00030000
oooooooo08Koool004Woool00ol0VOooooooo`13oooo0P0000Hco`000`000?ooooooo`26oooo0019
oooo00?o09Woooooool0@oooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo0019oooo00?o
09Woooooool0@oooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo0019oooo00?o09Wooooo
ool0@oooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo0019oooo00?o09Woooooool0@ooo
o`030000<ol0<ol000@co`000`000?ooooooo`27oooo0019oooo00?o09Woooooool0?Oooo`<00003
oooo00<0000co`0co`0013?o00030000oooooooo08Ooool004Woool00ol0VOooooooo`0noooo00<0
003oooooool00_ooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo0019oooo00?o09Wooooo
ool0>oooo`D00003oooo0`0000@co`000`000?ooooooo`27oooo0027oooo00@0003oooooool00004
oooo1c?o08[oool008Soool00`000?ooo`000004oooo1c?o08[oool008Woool200001?ooo`Lco`2:
oooo002?oooo1c?o08[oool008ooool7<ol0R_ooo`00M_ooo`030000oooooooo01Koool7<ol04Ooo
o`030000oooooooo07Koool007Goool00`000?ooooooo`08oooo00<0003oooooool03?ooo`Lco`0B
oooo00<0003oooooool0MOooo`00MOooo`030000oooooooo00;oool200001?ooo`030000oooooooo
00coool00c?o000000000004<ol00P0000?oool5000000Coool0000000000004oooo00<0003ooooo
ool0MOooo`00MOooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003ooooo
ool01?ooo`@00003oooo00@0000co`0co`000003<ol01oooo`050000oooooooooooo000000;oool0
1@000?ooooooooooo`00001goooo001doooo00<0003oooooool00_ooo`030000oooooooo01?oool0
100003?o03?o000000<co`07oooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool0
0`000?ooooooo`1doooo001eoooo00<0003oooooool01@0001;oool0100003?o03?o000000<co`07
oooo00@0003oooooooooool300001?ooo`030000oooooooo07Goool007Goool01@000?oooooooooo
o`00000Eoooo00@0000co`0co`000003<ol01oooo`030000oooooooo00;oool00`000?ooooooo`03
oooo00<0003oooooool0MOooo`00M_ooo`030000oooooooo01Koool00c?o000000000004<ol01_oo
o`800004oooo0`0000;oool00`000?ooooooo`1foooo002?oooo1c?o08[oool008ooool7<ol0R_oo
o`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.14) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.20342 .12361 L
.21345 .12361 L
.22272 .12361 L
.22513 .12361 L
.22738 .12361 L
.22852 .12361 L
s
.22852 .12361 m
.229 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.14) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool010000?ooooooool0V@Soool00`000?oo
ooooo`09oooo00<0003oooooool02Oooo`030000oooooooo00Woool00`000?ooooooo`09oooo00<0
003oooooool02Oooo`030000<ol0<ol000Tco`000`0003?o03?o0009<ol000<0000co`0co`002C?o
00030000<ol0<ol000Tco`000`0003?o03?o0009<ol000<0000co`0co`001S?o02800006oooo00<0
003oooooool02Oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0aoooo00?o09Wooooo
ool01_ooo`030000oooooooo03Woool00`0003?o03?o000i<ol02@0003Coool00`000?ooooooo`0E
oooo001:oooo00?o09Woooooool0@_ooo`030000<ol0<ol003<co`060000EOooo`00B_ooo`03o`2I
oooooooo04;oool00`0003?o03?o000a<ol00P0005_oool004[oool00ol0VOooooooo`12oooo00<0
000co`0co`00;c?o0080001Moooo001:oooo00?o09Woooooool0@_ooo`030000<ol0<ol002`co`03
0000Goooo`00B_ooo`03o`2Ioooooooo04;oool20000:S?o00<0001Roooo001:oooo00?o09Wooooo
ool0@_ooo`030000<ol0<ol002Lco`020000IOooo`00B_ooo`03o`2Ioooooooo04;oool00`0003?o
03?o000V<ol000<0003oooooool0IOooo`00B_ooo`03o`2Ioooooooo04;oool00`0003?o03?o000U
<ol000<0003oooooool0I_ooo`00B_ooo`03o`2Ioooooooo04;oool00`0003?o03?o000T<ol000<0
003oooooool0Ioooo`00B_ooo`03o`2Ioooooooo04;oool00`0003?o03?o000R<ol00P0006[oool0
04[oool00ol0VOooooooo`12oooo0P00028co`000`000?ooooooo`1Zoooo001:oooo00?o09Wooooo
ool0@_ooo`030000<ol0<ol0020co`000`000?ooooooo`1[oooo001:oooo00?o09Woooooool0@_oo
o`030000<ol0<ol001lco`000`000?ooooooo`1/oooo001:oooo00?o09Woooooool0@_ooo`030000
<ol0<ol001lco`000`000?ooooooo`1/oooo001:oooo00?o09Woooooool0@_ooo`030000<ol0<ol0
01hco`000`000?ooooooo`1]oooo001:oooo00?o09Woooooool0@_ooo`030000<ol0<ol001dco`00
0`000?ooooooo`1^oooo001:oooo00?o09Woooooool0@_ooo`80000M<ol000<0003oooooool0Kooo
o`00B_ooo`03o`2Ioooooooo04;oool00`0003?o03?o000K<ol000<0003oooooool0L?ooo`00B_oo
o`03o`2Ioooooooo04;oool00`0003?o03?o000K<ol000<0003oooooool0L?ooo`00B_ooo`03o`2I
oooooooo04;oool00`0003?o03?o000J<ol000<0003oooooool0LOooo`00B_ooo`03o`2Ioooooooo
04;oool00`0003?o03?o000J<ol000<0003oooooool0LOooo`00B_ooo`03o`2Ioooooooo04;oool0
0`0003?o03?o000I<ol000<0003oooooool0L_ooo`00B_ooo`03o`2Ioooooooo04;oool200006S?o
00030000oooooooo07;oool004[oool00ol0VOooooooo`12oooo00<0000co`0co`0063?o00030000
oooooooo07?oool004[oool00ol0VOooooooo`12oooo00<0000co`0co`0063?o00030000oooooooo
07?oool004[oool00ol0VOooooooo`12oooo00<0000co`0co`005c?o00030000oooooooo07Coool0
04[oool00ol0VOooooooo`12oooo00<0000co`0co`005c?o00030000oooooooo07Coool004[oool0
0ol0VOooooooo`0joooo1@0000?oool00`0003?o03?o000F<ol000<0003oooooool0MOooo`00B_oo
o`03o`2Ioooooooo03coool00`000?ooooooo`03oooo00<0000co`0co`005S?o00030000oooooooo
07Goool004[oool00ol0VOooooooo`0loooo00<0003oooooool00oooo`<0000E<ol000<0003ooooo
ool0M_ooo`00B_ooo`03o`2Ioooooooo03coool00`000?ooooooo`03oooo00<0000co`0co`005C?o
00030000oooooooo07Koool004[oool00ol0VOooooooo`0loooo00<0003oooooool00oooo`030000
<ol0<ol001Dco`000`000?ooooooo`1foooo001:oooo00?o09Woooooool0>oooo`800005oooo00<0
000co`0co`0053?o00030000oooooooo07Ooool004[oool00ol0VOooooooo`12oooo00<0000co`0c
o`0053?o00030000oooooooo07Ooool004[oool00ol0VOooooooo`12oooo00<0000co`0co`004c?o
00030000oooooooo07Soool004[oool00ol0VOooooooo`12oooo0P0001@co`000`000?ooooooo`1h
oooo001:oooo00?o09Woooooool0@_ooo`030000<ol0<ol001<co`000`000?ooooooo`1hoooo001:
oooo00?o09Woooooool0@_ooo`030000<ol0<ol0018co`000`000?ooooooo`1ioooo001:oooo00?o
09Woooooool0@_ooo`030000<ol0<ol0018co`000`000?ooooooo`1ioooo001:oooo00?o09Wooooo
ool0@_ooo`030000<ol0<ol0018co`000`000?ooooooo`1ioooo001:oooo00?o09Woooooool0@_oo
o`030000<ol0<ol0014co`000`000?ooooooo`1joooo001:oooo00?o09Woooooool0@_ooo`80000B
<ol000<0003oooooool0N_ooo`00B_ooo`03o`2Ioooooooo04;oool00`0003?o03?o000A<ol000<0
003oooooool0N_ooo`00B_ooo`03o`2Ioooooooo04;oool00`0003?o03?o000A<ol000<0003ooooo
ool0N_ooo`00B_ooo`03o`2Ioooooooo04;oool00`0003?o03?o000@<ol000<0003oooooool0Nooo
o`00B_ooo`03o`2Ioooooooo04;oool00`0003?o03?o000@<ol000<0003oooooool0Noooo`00B_oo
o`03o`2Ioooooooo04;oool00`0003?o03?o000@<ol000<0003oooooool0Noooo`00B_ooo`03o`2I
oooooooo04;oool00`0003?o03?o000@<ol000<0003oooooool0Noooo`00B_ooo`03o`2Ioooooooo
04;oool2000043?o00030000oooooooo07coool004[oool00ol0VOooooooo`12oooo00<0000co`0c
o`003c?o00030000oooooooo07coool004[oool00ol0VOooooooo`12oooo00<0000co`0co`003c?o
00030000oooooooo07coool004[oool00ol0VOooooooo`12oooo00<0000co`0co`003c?o00030000
oooooooo07coool004[oool00ol0VOooooooo`12oooo00<0000co`0co`003c?o00030000oooooooo
07coool004[oool00ol0VOooooooo`12oooo00<0000co`0co`003S?o00030000oooooooo07goool0
04[oool00ol0VOooooooo`12oooo0P0000lco`000`000?ooooooo`1moooo001:oooo00?o09Wooooo
ool0@_ooo`030000<ol0<ol000hco`000`000?ooooooo`1moooo001:oooo00?o09Woooooool0@_oo
o`030000<ol0<ol000hco`000`000?ooooooo`1moooo001:oooo00?o09Woooooool0@_ooo`030000
<ol0<ol000dco`000`000?ooooooo`1noooo001:oooo00?o09Woooooool0>_ooo`@00004oooo00<0
000co`0co`003C?o00030000oooooooo07koool004[oool00ol0VOooooooo`0joooo00<0003ooooo
ool01Oooo`030000<ol0<ol000dco`000`000?ooooooo`1noooo001:oooo00?o09Woooooool0>ooo
o`030000oooooooo00Coool300003C?o00030000oooooooo07koool004[oool00ol0VOooooooo`0l
oooo00<0003oooooool00oooo`030000<ol0<ol000dco`000`000?ooooooo`1noooo001:oooo00?o
09Woooooool0>_ooo`040000oooooooo00001?ooo`030000<ol0<ol000`co`000`000?ooooooo`1o
oooo001:oooo00?o09Woooooool0>oooo`800005oooo00<0000co`0co`0033?o00030000oooooooo
07ooool004[oool00ol0VOooooooo`12oooo00<0000co`0co`0033?o00030000oooooooo07ooool0
04[oool00ol0VOooooooo`12oooo00<0000co`0co`0033?o00030000oooooooo07ooool004[oool0
0ol0VOooooooo`12oooo0P0000dco`000`000?ooooooo`1ooooo001:oooo00?o09Woooooool0@_oo
o`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001:oooo00?o09Woooooool0@_ooo`030000
<ol0<ol000/co`000`000?ooooooo`20oooo001:oooo00?o09Woooooool0@_ooo`030000<ol0<ol0
00/co`000`000?ooooooo`20oooo001:oooo00?o09Woooooool0@_ooo`030000<ol0<ol000/co`00
0`000?ooooooo`20oooo001:oooo00?o09Woooooool0@_ooo`030000<ol0<ol000/co`000`000?oo
ooooo`20oooo001:oooo00?o09Woooooool0@_ooo`030000<ol0<ol000/co`000`000?ooooooo`20
oooo001:oooo00?o09Woooooool0@_ooo`80000<<ol000<0003oooooool0P?ooo`00B_ooo`03o`2I
oooooooo04;oool00`0003?o03?o000;<ol000<0003oooooool0P?ooo`00B_ooo`03o`2Ioooooooo
04;oool00`0003?o03?o000:<ol000<0003oooooool0POooo`00B_ooo`03o`2Ioooooooo04;oool0
0`0003?o03?o000:<ol000<0003oooooool0POooo`00B_ooo`03o`2Ioooooooo04;oool00`0003?o
03?o000:<ol000<0003oooooool0POooo`00B_ooo`03o`2Ioooooooo04;oool00`0003?o03?o000:
<ol000<0003oooooool0POooo`00B_ooo`03o`2Ioooooooo04;oool200002c?o00030000oooooooo
087oool004[oool00ol0VOooooooo`12oooo00<0000co`0co`002S?o00030000oooooooo087oool0
04[oool00ol0VOooooooo`12oooo00<0000co`0co`002S?o00030000oooooooo087oool004[oool0
0ol0VOooooooo`12oooo00<0000co`0co`002C?o00030000oooooooo08;oool004[oool00ol0VOoo
ooooo`12oooo00<0000co`0co`002C?o00030000oooooooo08;oool004[oool00ol0VOooooooo`12
oooo00<0000co`0co`002C?o00030000oooooooo08;oool004[oool00ol0VOooooooo`12oooo0P00
00Xco`000`000?ooooooo`22oooo001:oooo00?o09Woooooool0@_ooo`030000<ol0<ol000Tco`00
0`000?ooooooo`22oooo001:oooo00?o09Woooooool0@_ooo`030000<ol0<ol000Tco`000`000?oo
ooooo`22oooo001:oooo00?o09Woooooool0@_ooo`030000<ol0<ol000Pco`000`000?ooooooo`23
oooo001:oooo00?o09Woooooool0>oooo`800005oooo00<0000co`0co`0023?o00030000oooooooo
08?oool004[oool00ol0VOooooooo`0joooo00@0003oooooool00004oooo00<0000co`0co`0023?o
00030000oooooooo08?oool004[oool00ol0VOooooooo`0loooo00<0003oooooool00oooo`<00008
<ol000<0003oooooool0Poooo`00B_ooo`03o`2Ioooooooo03goool00`000?ooooooo`02oooo00<0
000co`0co`0023?o00030000oooooooo08?oool004[oool00ol0VOooooooo`0joooo00@0003ooooo
ool00004oooo00<0000co`0co`0023?o00030000oooooooo08?oool004[oool00ol0VOooooooo`0k
oooo0P0000Goool00`0003?o03?o0007<ol000<0003oooooool0Q?ooo`00B_ooo`03o`2Ioooooooo
04;oool00`0003?o03?o0007<ol000<0003oooooool0Q?ooo`00B_ooo`03o`2Ioooooooo04;oool0
0`0003?o03?o0007<ol000<0003oooooool0Q?ooo`00B_ooo`03o`2Ioooooooo04;oool00`0003?o
03?o0007<ol000<0003oooooool0Q?ooo`00B_ooo`03o`2Ioooooooo04;oool2000023?o00030000
oooooooo08Coool004[oool00ol0VOooooooo`12oooo00<0000co`0co`001c?o00030000oooooooo
08Coool004[oool00ol0VOooooooo`12oooo00<0000co`0co`001c?o00030000oooooooo08Coool0
04[oool00ol0VOooooooo`12oooo00<0000co`0co`001c?o00030000oooooooo08Coool004[oool0
0ol0VOooooooo`12oooo00<0000co`0co`001S?o00030000oooooooo08Goool004[oool00ol0VOoo
ooooo`12oooo00<0000co`0co`001S?o00030000oooooooo08Goool004[oool00ol0VOooooooo`12
oooo0P0000Lco`000`000?ooooooo`25oooo001:oooo00?o09Woooooool0@_ooo`030000<ol0<ol0
00Hco`000`000?ooooooo`25oooo001:oooo00?o09Woooooool0@_ooo`030000<ol0<ol000Hco`00
0`000?ooooooo`25oooo001:oooo00?o09Woooooool0@_ooo`030000<ol0<ol000Hco`000`000?oo
ooooo`25oooo001:oooo00?o09Woooooool0@_ooo`030000<ol0<ol000Hco`000`000?ooooooo`25
oooo001:oooo00?o09Woooooool0@_ooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001:
oooo00?o09Woooooool0@_ooo`800006<ol000<0003oooooool0Q_ooo`00B_ooo`03o`2Ioooooooo
04;oool00`0003?o03?o0005<ol000<0003oooooool0Q_ooo`00B_ooo`03o`2Ioooooooo04;oool0
0`0003?o03?o0005<ol000<0003oooooool0Q_ooo`00B_ooo`03o`2Ioooooooo04;oool00`0003?o
03?o0005<ol000<0003oooooool0Q_ooo`00B_ooo`03o`2Ioooooooo04;oool00`0003?o03?o0005
<ol000<0003oooooool0Q_ooo`00B_ooo`03o`2Ioooooooo04;oool00`0003?o03?o0005<ol000<0
003oooooool0Q_ooo`00B_ooo`03o`2Ioooooooo04;oool200001S?o00030000oooooooo08Koool0
04[oool00ol0VOooooooo`12oooo00<0000co`0co`001C?o00030000oooooooo08Koool004[oool0
0ol0VOooooooo`12oooo00<0000co`0co`001C?o00030000oooooooo08Koool004[oool00ol0VOoo
ooooo`12oooo00<0000co`0co`0013?o00030000oooooooo08Ooool004[oool00ol0VOooooooo`12
oooo00<0000co`0co`0013?o00030000oooooooo08Ooool004[oool00ol0VOooooooo`0loooo0`00
00?oool00`0003?o03?o0004<ol000<0003oooooool0Qoooo`00B_ooo`03o`2Ioooooooo03goool0
0`000?ooooooo`02oooo00<0000co`0co`0013?o00030000oooooooo08Ooool004[oool00ol0VOoo
ooooo`0joooo1@0000?oool3000013?o00030000oooooooo08Ooool008Ooool010000?ooooooo`00
00Coool7<ol0R_ooo`00R?ooo`030000oooo000000Coool7<ol0R_ooo`00ROooo`800004oooo1c?o
08[oool008ooool7<ol0R_ooo`00Soooo`Lco`2:oooo001foooo00<0003oooooool05_ooo`Lco`0A
oooo00<0003oooooool0M_ooo`00MOooo`030000oooooooo00Soool00`000?ooooooo`0<oooo1c?o
01;oool00`000?ooooooo`1eoooo001eoooo00<0003oooooool00_ooo`800004oooo00<0003ooooo
ool03?ooo`03<ol00000000000@co`0200000oooo`D00003oooo0`0000;oool00`000?ooooooo`1e
oooo001eoooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`04
oooo100000?oool0100003?o03?o000000<co`07oooo00<0003oooooool01?ooo`050000oooooooo
oooo000007Ooool007Coool00`000?ooooooo`02oooo00<0003oooooool04oooo`040000<ol0<ol0
00000c?o00Ooool010000?ooooooooooo`D00003oooo00<0003oooooool0M?ooo`00MOooo`030000
oooooooo00D0000Boooo00@0000co`0co`000003<ol01oooo`050000oooooooooooo000000;oool0
1@000?ooooooooooo`00001goooo001eoooo00D0003oooooooooool000005Oooo`040000<ol0<ol0
00000c?o00Ooool00`000?ooooooo`02oooo00<0003oool000000oooo`030000oooooooo07Goool0
07Koool00`000?ooooooo`0Foooo00<co`000000000013?o00Koool200001Oooo`800002oooo00<0
003oooooool0M_ooo`00Soooo`Lco`2:oooo002?oooo1c?o08[oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.12) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.20342 .12361 L
.22272 .12361 L
.22738 .12361 L
.22994 .12361 L
.23119 .12361 L
.23233 .12361 L
s
.23233 .12361 m
.23283 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.12) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool01@000?ooooooooooool0V@07oooo00<0
003oooooool02Oooo`030000oooooooo00Woool00`000?ooooooo`09oooo00<0003oooooool02Ooo
o`030000oooooooo00Woool00`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol0
00Tco`000`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Hco`0R00001_oo
o`030000oooooooo00Woool00`000?ooooooo`0Eoooo000Foooo00<0003oooooool0<_ooo`03o`2I
oooooooo00Goool00`000?ooooooo`0ioooo00<0000co`0co`00>C?o00T0000doooo00<0003ooooo
ool05Oooo`00Boooo`03o`2Ioooooooo047oool00`0003?o03?o000c<ol01P0005Goool004_oool0
0ol0VOooooooo`11oooo00<0000co`0co`00<C?o0080001Koooo001;oooo00?o09Woooooool0@Ooo
o`030000<ol0<ol002lco`020000GOooo`00Boooo`03o`2Ioooooooo047oool00`0003?o03?o000/
<ol00`0005ooool004_oool00ol0VOooooooo`11oooo0P0002Xco`030000H_ooo`00Boooo`03o`2I
oooooooo047oool00`0003?o03?o000W<ol00P0006Goool004_oool00ol0VOooooooo`11oooo00<0
000co`0co`009S?o00030000oooooooo06Goool004_oool00ol0VOooooooo`11oooo00<0000co`0c
o`009C?o00030000oooooooo06Koool004_oool00ol0VOooooooo`11oooo00<0000co`0co`0093?o
00030000oooooooo06Ooool004_oool00ol0VOooooooo`11oooo00<0000co`0co`008S?o0080001Z
oooo001;oooo00?o09Woooooool0@Oooo`80000R<ol000<0003oooooool0J_ooo`00Boooo`03o`2I
oooooooo047oool00`0003?o03?o000P<ol000<0003oooooool0Joooo`00Boooo`03o`2Ioooooooo
047oool00`0003?o03?o000O<ol000<0003oooooool0K?ooo`00Boooo`03o`2Ioooooooo047oool0
0`0003?o03?o000O<ol000<0003oooooool0K?ooo`00Boooo`03o`2Ioooooooo047oool00`0003?o
03?o000N<ol000<0003oooooool0KOooo`00Boooo`03o`2Ioooooooo047oool00`0003?o03?o000M
<ol000<0003oooooool0K_ooo`00Boooo`03o`2Ioooooooo047oool200007C?o00030000oooooooo
06ooool004_oool00ol0VOooooooo`11oooo00<0000co`0co`006c?o00030000oooooooo073oool0
04_oool00ol0VOooooooo`11oooo00<0000co`0co`006c?o00030000oooooooo073oool004_oool0
0ol0VOooooooo`11oooo00<0000co`0co`006S?o00030000oooooooo077oool004_oool00ol0VOoo
ooooo`11oooo00<0000co`0co`006S?o00030000oooooooo077oool004_oool00ol0VOooooooo`11
oooo00<0000co`0co`006C?o00030000oooooooo07;oool004_oool00ol0VOooooooo`11oooo0P00
01Xco`000`000?ooooooo`1boooo001;oooo00?o09Woooooool0@Oooo`030000<ol0<ol001Pco`00
0`000?ooooooo`1coooo001;oooo00?o09Woooooool0@Oooo`030000<ol0<ol001Pco`000`000?oo
ooooo`1coooo001;oooo00?o09Woooooool0@Oooo`030000<ol0<ol001Lco`000`000?ooooooo`1d
oooo001;oooo00?o09Woooooool0@Oooo`030000<ol0<ol001Lco`000`000?ooooooo`1doooo001;
oooo00?o09Woooooool0>Oooo`D00003oooo00<0000co`0co`005S?o00030000oooooooo07Goool0
04_oool00ol0VOooooooo`0koooo00<0003oooooool00oooo`030000<ol0<ol001Hco`000`000?oo
ooooo`1eoooo001;oooo00?o09Woooooool0>oooo`030000oooooooo00?oool300005C?o00030000
oooooooo07Koool004_oool00ol0VOooooooo`0koooo00<0003oooooool00oooo`030000<ol0<ol0
01Dco`000`000?ooooooo`1foooo001;oooo00?o09Woooooool0>oooo`030000oooooooo00?oool0
0`0003?o03?o000E<ol000<0003oooooool0M_ooo`00Boooo`03o`2Ioooooooo03[oool200001Ooo
o`030000<ol0<ol001@co`000`000?ooooooo`1goooo001;oooo00?o09Woooooool0@Oooo`030000
<ol0<ol001@co`000`000?ooooooo`1goooo001;oooo00?o09Woooooool0@Oooo`030000<ol0<ol0
01<co`000`000?ooooooo`1hoooo001;oooo00?o09Woooooool0@Oooo`80000D<ol000<0003ooooo
ool0N?ooo`00Boooo`03o`2Ioooooooo047oool00`0003?o03?o000C<ol000<0003oooooool0N?oo
o`00Boooo`03o`2Ioooooooo047oool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00Booo
o`03o`2Ioooooooo047oool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00Boooo`03o`2I
oooooooo047oool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00Boooo`03o`2Ioooooooo
047oool00`0003?o03?o000A<ol000<0003oooooool0N_ooo`00Boooo`03o`2Ioooooooo047oool2
00004S?o00030000oooooooo07[oool004_oool00ol0VOooooooo`11oooo00<0000co`0co`004C?o
00030000oooooooo07[oool004_oool00ol0VOooooooo`11oooo00<0000co`0co`004C?o00030000
oooooooo07[oool004_oool00ol0VOooooooo`11oooo00<0000co`0co`0043?o00030000oooooooo
07_oool004_oool00ol0VOooooooo`11oooo00<0000co`0co`0043?o00030000oooooooo07_oool0
04_oool00ol0VOooooooo`11oooo00<0000co`0co`0043?o00030000oooooooo07_oool004_oool0
0ol0VOooooooo`11oooo00<0000co`0co`0043?o00030000oooooooo07_oool004_oool00ol0VOoo
ooooo`11oooo0P00010co`000`000?ooooooo`1loooo001;oooo00?o09Woooooool0@Oooo`030000
<ol0<ol000lco`000`000?ooooooo`1loooo001;oooo00?o09Woooooool0@Oooo`030000<ol0<ol0
00lco`000`000?ooooooo`1loooo001;oooo00?o09Woooooool0@Oooo`030000<ol0<ol000lco`00
0`000?ooooooo`1loooo001;oooo00?o09Woooooool0@Oooo`030000<ol0<ol000lco`000`000?oo
ooooo`1loooo001;oooo00?o09Woooooool0@Oooo`030000<ol0<ol000hco`000`000?ooooooo`1m
oooo001;oooo00?o09Woooooool0@Oooo`80000?<ol000<0003oooooool0OOooo`00Boooo`03o`2I
oooooooo047oool00`0003?o03?o000><ol000<0003oooooool0OOooo`00Boooo`03o`2Ioooooooo
047oool00`0003?o03?o000><ol000<0003oooooool0OOooo`00Boooo`03o`2Ioooooooo047oool0
0`0003?o03?o000=<ol000<0003oooooool0O_ooo`00Boooo`03o`2Ioooooooo03Woool400001?oo
o`030000<ol0<ol000dco`000`000?ooooooo`1noooo001;oooo00?o09Woooooool0>Oooo`030000
oooooooo00Goool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00Boooo`03o`2Ioooooooo
03[oool00`000?ooooooo`04oooo0`0000dco`000`000?ooooooo`1noooo001;oooo00?o09Wooooo
ool0>oooo`030000oooooooo00?oool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00Booo
o`03o`2Ioooooooo03Woool010000?ooooooo`0000Coool00`0003?o03?o000<<ol000<0003ooooo
ool0Ooooo`00Boooo`03o`2Ioooooooo03[oool200001Oooo`030000<ol0<ol000`co`000`000?oo
ooooo`1ooooo001;oooo00?o09Woooooool0@Oooo`030000<ol0<ol000`co`000`000?ooooooo`1o
oooo001;oooo00?o09Woooooool0@Oooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001;
oooo00?o09Woooooool0@Oooo`80000=<ol000<0003oooooool0Ooooo`00Boooo`03o`2Ioooooooo
047oool00`0003?o03?o000<<ol000<0003oooooool0Ooooo`00Boooo`03o`2Ioooooooo047oool0
0`0003?o03?o000;<ol000<0003oooooool0P?ooo`00Boooo`03o`2Ioooooooo047oool00`0003?o
03?o000;<ol000<0003oooooool0P?ooo`00Boooo`03o`2Ioooooooo047oool00`0003?o03?o000;
<ol000<0003oooooool0P?ooo`00Boooo`03o`2Ioooooooo047oool00`0003?o03?o000;<ol000<0
003oooooool0P?ooo`00Boooo`03o`2Ioooooooo047oool00`0003?o03?o000;<ol000<0003ooooo
ool0P?ooo`00Boooo`03o`2Ioooooooo047oool2000033?o00030000oooooooo083oool004_oool0
0ol0VOooooooo`11oooo00<0000co`0co`002c?o00030000oooooooo083oool004_oool00ol0VOoo
ooooo`11oooo00<0000co`0co`002S?o00030000oooooooo087oool004_oool00ol0VOooooooo`11
oooo00<0000co`0co`002S?o00030000oooooooo087oool004_oool00ol0VOooooooo`11oooo00<0
000co`0co`002S?o00030000oooooooo087oool004_oool00ol0VOooooooo`11oooo00<0000co`0c
o`002S?o00030000oooooooo087oool004_oool00ol0VOooooooo`11oooo0P0000/co`000`000?oo
ooooo`21oooo001;oooo00?o09Woooooool0@Oooo`030000<ol0<ol000Xco`000`000?ooooooo`21
oooo001;oooo00?o09Woooooool0@Oooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001;
oooo00?o09Woooooool0@Oooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001;oooo00?o
09Woooooool0@Oooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001;oooo00?o09Wooooo
ool0@Oooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001;oooo00?o09Woooooool0@Ooo
o`80000:<ol000<0003oooooool0P_ooo`00Boooo`03o`2Ioooooooo047oool00`0003?o03?o0009
<ol000<0003oooooool0P_ooo`00Boooo`03o`2Ioooooooo047oool00`0003?o03?o0009<ol000<0
003oooooool0P_ooo`00Boooo`03o`2Ioooooooo047oool00`0003?o03?o0008<ol000<0003ooooo
ool0Poooo`00Boooo`03o`2Ioooooooo03[oool200001Oooo`030000<ol0<ol000Pco`000`000?oo
ooooo`23oooo001;oooo00?o09Woooooool0>Oooo`040000oooooooo00001?ooo`030000<ol0<ol0
00Pco`000`000?ooooooo`23oooo001;oooo00?o09Woooooool0>oooo`030000oooooooo00?oool3
000023?o00030000oooooooo08?oool004_oool00ol0VOooooooo`0loooo00<0003oooooool00_oo
o`030000<ol0<ol000Pco`000`000?ooooooo`23oooo001;oooo00?o09Woooooool0>Oooo`040000
oooooooo00001?ooo`030000<ol0<ol000Pco`000`000?ooooooo`23oooo001;oooo00?o09Wooooo
ool0>_ooo`800005oooo00<0000co`0co`001c?o00030000oooooooo08Coool004_oool00ol0VOoo
ooooo`11oooo00<0000co`0co`001c?o00030000oooooooo08Coool004_oool00ol0VOooooooo`11
oooo00<0000co`0co`001c?o00030000oooooooo08Coool004_oool00ol0VOooooooo`11oooo00<0
000co`0co`001c?o00030000oooooooo08Coool004_oool00ol0VOooooooo`11oooo0P0000Pco`00
0`000?ooooooo`24oooo001;oooo00?o09Woooooool0@Oooo`030000<ol0<ol000Lco`000`000?oo
ooooo`24oooo001;oooo00?o09Woooooool0@Oooo`030000<ol0<ol000Lco`000`000?ooooooo`24
oooo001;oooo00?o09Woooooool0@Oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001;
oooo00?o09Woooooool0@Oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001;oooo00?o
09Woooooool0@Oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001;oooo00?o09Wooooo
ool0@Oooo`800007<ol000<0003oooooool0QOooo`00Boooo`03o`2Ioooooooo047oool00`0003?o
03?o0006<ol000<0003oooooool0QOooo`00Boooo`03o`2Ioooooooo047oool00`0003?o03?o0006
<ol000<0003oooooool0QOooo`00Boooo`03o`2Ioooooooo047oool00`0003?o03?o0006<ol000<0
003oooooool0QOooo`00Boooo`03o`2Ioooooooo047oool00`0003?o03?o0006<ol000<0003ooooo
ool0QOooo`00Boooo`03o`2Ioooooooo047oool00`0003?o03?o0006<ol000<0003oooooool0QOoo
o`00Boooo`03o`2Ioooooooo047oool200001S?o00030000oooooooo08Koool004_oool00ol0VOoo
ooooo`11oooo00<0000co`0co`001C?o00030000oooooooo08Koool004_oool00ol0VOooooooo`11
oooo00<0000co`0co`001C?o00030000oooooooo08Koool004_oool00ol0VOooooooo`11oooo00<0
000co`0co`001C?o00030000oooooooo08Koool004_oool00ol0VOooooooo`11oooo00<0000co`0c
o`001C?o00030000oooooooo08Koool004_oool00ol0VOooooooo`11oooo00<0000co`0co`001C?o
00030000oooooooo08Koool004_oool00ol0VOooooooo`11oooo0P0000Hco`000`000?ooooooo`26
oooo001;oooo00?o09Woooooool0@Oooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001;
oooo00?o09Woooooool0@Oooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001;oooo00?o
09Woooooool0@Oooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001;oooo00?o09Wooooo
ool0@Oooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001;oooo00?o09Woooooool0>ooo
o`<00003oooo00<0000co`0co`0013?o00030000oooooooo08Ooool004_oool00ol0VOooooooo`0l
oooo00<0003oooooool00_ooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001;oooo00?o
09Woooooool0>Oooo`D00003oooo0`0000@co`000`000?ooooooo`27oooo0027oooo00@0003ooooo
ool00004oooo1c?o08[oool008Soool00`000?ooo`000004oooo1c?o08[oool008Woool200001?oo
o`Lco`2:oooo002?oooo1c?o08[oool008ooool7<ol0R_ooo`00M_ooo`030000oooooooo01Koool7
<ol04Oooo`030000oooooooo07Koool007Goool00`000?ooooooo`08oooo00<0003oooooool03?oo
o`Lco`0Boooo00<0003oooooool0MOooo`00MOooo`030000oooooooo00;oool200001?ooo`030000
oooooooo00coool00c?o000000000004<ol00P0000?oool5000000?oool0000000000P0000?oool0
0`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool0
0`000?ooooooo`04oooo100000?oool0100003?o03?o000000<co`07oooo00D0003oooooooooool0
00001_ooo`030000oooooooo07Goool007Coool00`000?ooooooo`02oooo00<0003oooooool04ooo
o`040000<ol0<ol000000c?o00Ooool00`000?ooooooo`02oooo00<0003oooooool01?ooo`030000
oooooooo07Coool007Goool00`000?ooooooo`0500004_ooo`040000<ol0<ol000000c?o00Ooool0
0`000?ooooooo`03oooo00<0003oooooool00_ooo`030000oooooooo07Goool007Goool01@000?oo
ooooooooo`00000Eoooo00@0000co`0co`000003<ol01oooo`050000oooooooooooo000000;oool0
1@000?ooooooooooo`00001goooo001foooo00<0003oooooool05_ooo`03<ol00000000000@co`06
oooo0P0000Coool200000oooo`030000oooooooo07Koool008ooool7<ol0R_ooo`00Soooo`Lco`2:
oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.20342 .12361 L
.22272 .12361 L
.23233 .12361 L
.23496 .12361 L
.2364 .12361 L
.23711 .12361 L
.23775 .12361 L
s
.23775 .12361 m
.23821 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`02oooo00?o09Wooooo
ool01?ooo`030000oooooooo00Woool00`000?ooooooo`09oooo00<0003oooooool02Oooo`030000
oooooooo00Woool00`000?ooooooo`09oooo00<0000co`0co`002C?o00030000<ol0<ol000Tco`00
0`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Tco`000`0003?o03?o0006
<ol08P0000Koool00`000?ooooooo`09oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo
03?oool00ol0VOooooooo`04oooo00<0003oooooool0>Oooo`030000<ol0<ol003Tco`090000=?oo
o`030000oooooooo01Goool004coool00ol0VOooooooo`10oooo00<0000co`0co`00<c?o00H0001E
oooo001<oooo00?o09Woooooool0@?ooo`030000<ol0<ol0034co`020000Foooo`00C?ooo`03o`2I
oooooooo043oool00`0003?o03?o000_<ol00P0005goool004coool00ol0VOooooooo`10oooo00<0
000co`0co`00;3?o00<0001Ooooo001<oooo00?o09Woooooool0@?ooo`80000Z<ol00`0006;oool0
04coool00ol0VOooooooo`10oooo00<0000co`0co`009c?o0080001Uoooo001<oooo00?o09Wooooo
ool0@?ooo`030000<ol0<ol002Hco`000`000?ooooooo`1Uoooo001<oooo00?o09Woooooool0@?oo
o`030000<ol0<ol002Dco`000`000?ooooooo`1Voooo001<oooo00?o09Woooooool0@?ooo`030000
<ol0<ol002@co`000`000?ooooooo`1Woooo001<oooo00?o09Woooooool0@?ooo`030000<ol0<ol0
028co`020000J_ooo`00C?ooo`03o`2Ioooooooo043oool200008S?o00030000oooooooo06[oool0
04coool00ol0VOooooooo`10oooo00<0000co`0co`0083?o00030000oooooooo06_oool004coool0
0ol0VOooooooo`10oooo00<0000co`0co`007c?o00030000oooooooo06coool004coool00ol0VOoo
ooooo`10oooo00<0000co`0co`007c?o00030000oooooooo06coool004coool00ol0VOooooooo`10
oooo00<0000co`0co`007S?o00030000oooooooo06goool004coool00ol0VOooooooo`10oooo00<0
000co`0co`007C?o00030000oooooooo06koool004coool00ol0VOooooooo`10oooo0P0001dco`00
0`000?ooooooo`1_oooo001<oooo00?o09Woooooool0@?ooo`030000<ol0<ol001/co`000`000?oo
ooooo`1`oooo001<oooo00?o09Woooooool0@?ooo`030000<ol0<ol001/co`000`000?ooooooo`1`
oooo001<oooo00?o09Woooooool0@?ooo`030000<ol0<ol001Xco`000`000?ooooooo`1aoooo001<
oooo00?o09Woooooool0@?ooo`030000<ol0<ol001Xco`000`000?ooooooo`1aoooo001<oooo00?o
09Woooooool0@?ooo`030000<ol0<ol001Tco`000`000?ooooooo`1boooo001<oooo00?o09Wooooo
ool0@?ooo`80000J<ol000<0003oooooool0L_ooo`00C?ooo`03o`2Ioooooooo043oool00`0003?o
03?o000H<ol000<0003oooooool0Loooo`00C?ooo`03o`2Ioooooooo043oool00`0003?o03?o000H
<ol000<0003oooooool0Loooo`00C?ooo`03o`2Ioooooooo043oool00`0003?o03?o000G<ol000<0
003oooooool0M?ooo`00C?ooo`03o`2Ioooooooo043oool00`0003?o03?o000G<ol000<0003ooooo
ool0M?ooo`00C?ooo`03o`2Ioooooooo03Soool500000oooo`030000<ol0<ol001Hco`000`000?oo
ooooo`1eoooo001<oooo00?o09Woooooool0>_ooo`030000oooooooo00?oool00`0003?o03?o000F
<ol000<0003oooooool0MOooo`00C?ooo`03o`2Ioooooooo03[oool00`000?ooooooo`03oooo0`00
01Dco`000`000?ooooooo`1foooo001<oooo00?o09Woooooool0>_ooo`030000oooooooo00?oool0
0`0003?o03?o000E<ol000<0003oooooool0M_ooo`00C?ooo`03o`2Ioooooooo03[oool00`000?oo
ooooo`03oooo00<0000co`0co`005C?o00030000oooooooo07Koool004coool00ol0VOooooooo`0i
oooo0P0000Goool00`0003?o03?o000D<ol000<0003oooooool0Moooo`00C?ooo`03o`2Ioooooooo
043oool00`0003?o03?o000D<ol000<0003oooooool0Moooo`00C?ooo`03o`2Ioooooooo043oool0
0`0003?o03?o000C<ol000<0003oooooool0N?ooo`00C?ooo`03o`2Ioooooooo043oool2000053?o
00030000oooooooo07Soool004coool00ol0VOooooooo`10oooo00<0000co`0co`004c?o00030000
oooooooo07Soool004coool00ol0VOooooooo`10oooo00<0000co`0co`004S?o00030000oooooooo
07Woool004coool00ol0VOooooooo`10oooo00<0000co`0co`004S?o00030000oooooooo07Woool0
04coool00ol0VOooooooo`10oooo00<0000co`0co`004S?o00030000oooooooo07Woool004coool0
0ol0VOooooooo`10oooo00<0000co`0co`004C?o00030000oooooooo07[oool004coool00ol0VOoo
ooooo`10oooo0P00018co`000`000?ooooooo`1joooo001<oooo00?o09Woooooool0@?ooo`030000
<ol0<ol0014co`000`000?ooooooo`1joooo001<oooo00?o09Woooooool0@?ooo`030000<ol0<ol0
014co`000`000?ooooooo`1joooo001<oooo00?o09Woooooool0@?ooo`030000<ol0<ol0010co`00
0`000?ooooooo`1koooo001<oooo00?o09Woooooool0@?ooo`030000<ol0<ol0010co`000`000?oo
ooooo`1koooo001<oooo00?o09Woooooool0@?ooo`030000<ol0<ol0010co`000`000?ooooooo`1k
oooo001<oooo00?o09Woooooool0@?ooo`030000<ol0<ol0010co`000`000?ooooooo`1koooo001<
oooo00?o09Woooooool0@?ooo`80000@<ol000<0003oooooool0O?ooo`00C?ooo`03o`2Ioooooooo
043oool00`0003?o03?o000?<ol000<0003oooooool0O?ooo`00C?ooo`03o`2Ioooooooo043oool0
0`0003?o03?o000?<ol000<0003oooooool0O?ooo`00C?ooo`03o`2Ioooooooo043oool00`0003?o
03?o000?<ol000<0003oooooool0O?ooo`00C?ooo`03o`2Ioooooooo043oool00`0003?o03?o000?
<ol000<0003oooooool0O?ooo`00C?ooo`03o`2Ioooooooo043oool00`0003?o03?o000><ol000<0
003oooooool0OOooo`00C?ooo`03o`2Ioooooooo043oool200003c?o00030000oooooooo07goool0
04coool00ol0VOooooooo`10oooo00<0000co`0co`003S?o00030000oooooooo07goool004coool0
0ol0VOooooooo`10oooo00<0000co`0co`003S?o00030000oooooooo07goool004coool00ol0VOoo
ooooo`10oooo00<0000co`0co`003C?o00030000oooooooo07koool004coool00ol0VOooooooo`0h
oooo100000Coool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00C?ooo`03o`2Ioooooooo
03Soool00`000?ooooooo`05oooo00<0000co`0co`003C?o00030000oooooooo07koool004coool0
0ol0VOooooooo`0ioooo00<0003oooooool01?ooo`<0000=<ol000<0003oooooool0O_ooo`00COoo
o`03o`2Ioooooooo03Woool00`000?ooooooo`03oooo00<0000co`0co`003C?o00030000oooooooo
07koool004goool00ol0VOooooooo`0goooo00@0003oooooool00004oooo00<0000co`0co`0033?o
00030000oooooooo07ooool004goool00ol0VOooooooo`0hoooo0P0000Goool00`0003?o03?o000<
<ol000<0003oooooool0Ooooo`00COooo`03o`2Ioooooooo03ooool00`0003?o03?o000<<ol000<0
003oooooool0Ooooo`00COooo`03o`2Ioooooooo03ooool00`0003?o03?o000<<ol000<0003ooooo
ool0Ooooo`00COooo`03o`2Ioooooooo03ooool200003C?o00030000oooooooo07ooool004goool0
0ol0VOooooooo`0ooooo00<0000co`0co`0033?o00030000oooooooo07ooool004goool00ol0VOoo
ooooo`0ooooo00<0000co`0co`002c?o00030000oooooooo083oool004goool00ol0VOooooooo`0o
oooo00<0000co`0co`002c?o00030000oooooooo083oool004goool00ol0VOooooooo`0ooooo00<0
000co`0co`002c?o00030000oooooooo083oool004goool00ol0VOooooooo`0ooooo00<0000co`0c
o`002c?o00030000oooooooo083oool004goool00ol0VOooooooo`0ooooo00<0000co`0co`002c?o
00030000oooooooo083oool004goool00ol0VOooooooo`0ooooo0P0000`co`000`000?ooooooo`20
oooo001=oooo00?o09Woooooool0?oooo`030000<ol0<ol000/co`000`000?ooooooo`20oooo001=
oooo00?o09Woooooool0?oooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001=oooo00?o
09Woooooool0?oooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001=oooo00?o09Wooooo
ool0?oooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001=oooo00?o09Woooooool0?ooo
o`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001=oooo00?o09Woooooool0?oooo`80000;
<ol000<0003oooooool0POooo`00COooo`03o`2Ioooooooo03ooool00`0003?o03?o000:<ol000<0
003oooooool0POooo`00COooo`03o`2Ioooooooo03ooool00`0003?o03?o000:<ol000<0003ooooo
ool0POooo`00COooo`03o`2Ioooooooo03ooool00`0003?o03?o0009<ol000<0003oooooool0P_oo
o`00COooo`03o`2Ioooooooo03ooool00`0003?o03?o0009<ol000<0003oooooool0P_ooo`00COoo
o`03o`2Ioooooooo03ooool00`0003?o03?o0009<ol000<0003oooooool0P_ooo`00COooo`03o`2I
oooooooo03ooool200002S?o00030000oooooooo08;oool004goool00ol0VOooooooo`0ooooo00<0
000co`0co`002C?o00030000oooooooo08;oool004goool00ol0VOooooooo`0ooooo00<0000co`0c
o`002C?o00030000oooooooo08;oool004goool00ol0VOooooooo`0ooooo00<0000co`0co`0023?o
00030000oooooooo08?oool004goool00ol0VOooooooo`0hoooo0P0000Goool00`0003?o03?o0008
<ol000<0003oooooool0Poooo`00COooo`03o`2Ioooooooo03Ooool010000?ooooooo`0000Coool0
0`0003?o03?o0008<ol000<0003oooooool0Poooo`00COooo`03o`2Ioooooooo03Woool00`000?oo
ooooo`03oooo0`0000Pco`000`000?ooooooo`23oooo001=oooo00?o09Woooooool0>_ooo`030000
oooooooo00;oool00`0003?o03?o0008<ol000<0003oooooool0Poooo`00COooo`03o`2Ioooooooo
03Ooool010000?ooooooo`0000Coool00`0003?o03?o0008<ol000<0003oooooool0Poooo`00COoo
o`03o`2Ioooooooo03Soool200001Oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001=
oooo00?o09Woooooool0?oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001=oooo00?o
09Woooooool0?oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001=oooo00?o09Wooooo
ool0?oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001=oooo00?o09Woooooool0?ooo
o`800008<ol000<0003oooooool0Q?ooo`00COooo`03o`2Ioooooooo03ooool00`0003?o03?o0007
<ol000<0003oooooool0Q?ooo`00COooo`03o`2Ioooooooo03ooool00`0003?o03?o0007<ol000<0
003oooooool0Q?ooo`00COooo`03o`2Ioooooooo03ooool00`0003?o03?o0007<ol000<0003ooooo
ool0Q?ooo`00COooo`03o`2Ioooooooo03ooool00`0003?o03?o0006<ol000<0003oooooool0QOoo
o`00COooo`03o`2Ioooooooo03ooool00`0003?o03?o0006<ol000<0003oooooool0QOooo`00COoo
o`03o`2Ioooooooo03ooool200001c?o00030000oooooooo08Goool004goool00ol0VOooooooo`0o
oooo00<0000co`0co`001S?o00030000oooooooo08Goool004goool00ol0VOooooooo`0ooooo00<0
000co`0co`001S?o00030000oooooooo08Goool004goool00ol0VOooooooo`0ooooo00<0000co`0c
o`001S?o00030000oooooooo08Goool004goool00ol0VOooooooo`0ooooo00<0000co`0co`001S?o
00030000oooooooo08Goool004goool00ol0VOooooooo`0ooooo00<0000co`0co`001S?o00030000
oooooooo08Goool004goool00ol0VOooooooo`0ooooo0P0000Hco`000`000?ooooooo`26oooo001=
oooo00?o09Woooooool0?oooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001=oooo00?o
09Woooooool0?oooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001=oooo00?o09Wooooo
ool0?oooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001=oooo00?o09Woooooool0?ooo
o`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001=oooo00?o09Woooooool0?oooo`030000
<ol0<ol000Dco`000`000?ooooooo`26oooo001=oooo00?o09Woooooool0?oooo`800006<ol000<0
003oooooool0Q_ooo`00COooo`03o`2Ioooooooo03ooool00`0003?o03?o0005<ol000<0003ooooo
ool0Q_ooo`00COooo`03o`2Ioooooooo03ooool00`0003?o03?o0005<ol000<0003oooooool0Q_oo
o`00COooo`03o`2Ioooooooo03ooool00`0003?o03?o0004<ol000<0003oooooool0Qoooo`00COoo
o`03o`2Ioooooooo03ooool00`0003?o03?o0004<ol000<0003oooooool0Qoooo`00COooo`03o`2I
oooooooo03Woool300000oooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001=oooo00?o
09Woooooool0>_ooo`030000oooooooo00;oool00`0003?o03?o0004<ol000<0003oooooool0Qooo
o`00COooo`03o`2Ioooooooo03Ooool500000oooo`<00004<ol000<0003oooooool0Qoooo`00Qooo
o`040000oooooooo00001?ooo`Lco`2:oooo0028oooo00<0003oool000001?ooo`Lco`2:oooo0029
oooo0P0000Coool7<ol0R_ooo`00Soooo`Lco`2:oooo002?oooo1c?o08[oool007Woool00`000?oo
ooooo`0Coooo1c?o00koool00`000?ooooooo`1ioooo001hoooo00<0003oooooool02?ooo`030000
oooooooo00Woool7<ol03oooo`030000oooooooo07Soool007Soool00`000?ooooooo`02oooo0P00
00Coool00`000?ooooooo`09oooo13?o0080000013?o0?ooooooooooo`800003oooo1@0000;oool0
0`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool0
0`000?ooooooo`04oooo100000<co`00100003?o03?o000000[oool00`000?ooooooo`02oooo00<0
003oooooool0N?ooo`00Moooo`030000oooooooo00;oool00`000?ooooooo`0@oooo0c?o00040000
<ol0<ol000002_ooo`030000oooooooo00?oool00`000?ooooooo`1goooo001hoooo00<0003ooooo
ool01@0000ooool3<ol000@0000co`0co`00000:oooo00<0003oooooool00_ooo`030000oooooooo
07Soool007Soool01@000?ooooooooooo`00000Boooo0c?o00040000<ol0<ol000002_ooo`030000
oooooooo00;oool00`000?ooooooo`1hoooo001ioooo00<0003oooooool04oooo`@co`02000000<c
o`3oooooool01oooo`800003oooo00<0003oooooool0NOooo`00Soooo`Lco`2:oooo002?oooo1c?o
08[oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.08) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.20342 .12361 L
.22272 .12361 L
.23233 .12361 L
.23739 .12361 L
.24016 .12361 L
.24152 .12361 L
.24276 .12361 L
s
.24276 .12361 m
.24322 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.08) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`04oooo00?o09Wooooo
ool00_ooo`030000oooooooo00Woool00`000?ooooooo`09oooo00<0003oooooool02Oooo`030000
oooooooo00Woool00`000?ooooooo`09oooo00<0000co`0co`002C?o00030000<ol0<ol000Tco`00
0`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Tco`000`0003?o03?o0006
<ol08P0000Koool00`000?ooooooo`09oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo
03Goool00ol0VOooooooo`02oooo00<0003oooooool0>Oooo`030000<ol0<ol003Tco`090000=?oo
o`030000oooooooo01Goool004koool00ol0VOooooooo`0noooo00<0000co`0co`00<c?o00H0001E
oooo001>oooo00?o09Woooooool0?_ooo`030000<ol0<ol0034co`020000Foooo`00C_ooo`03o`2I
oooooooo03koool00`0003?o03?o000_<ol00P0005goool004koool00ol0VOooooooo`0noooo00<0
000co`0co`00;3?o00<0001Ooooo001>oooo00?o09Woooooool0?_ooo`80000Z<ol00`0006;oool0
04koool00ol0VOooooooo`0noooo00<0000co`0co`009c?o0080001Uoooo001>oooo00?o09Wooooo
ool0?_ooo`030000<ol0<ol002Hco`000`000?ooooooo`1Uoooo001>oooo00?o09Woooooool0?_oo
o`030000<ol0<ol002Dco`000`000?ooooooo`1Voooo001>oooo00?o09Woooooool0?_ooo`030000
<ol0<ol002@co`000`000?ooooooo`1Woooo001>oooo00?o09Woooooool0?_ooo`030000<ol0<ol0
028co`020000J_ooo`00C_ooo`03o`2Ioooooooo03koool200008S?o00030000oooooooo06[oool0
04koool00ol0VOooooooo`0noooo00<0000co`0co`0083?o00030000oooooooo06_oool004koool0
0ol0VOooooooo`0noooo00<0000co`0co`007c?o00030000oooooooo06coool004koool00ol0VOoo
ooooo`0noooo00<0000co`0co`007c?o00030000oooooooo06coool004koool00ol0VOooooooo`0n
oooo00<0000co`0co`007S?o00030000oooooooo06goool004koool00ol0VOooooooo`0noooo00<0
000co`0co`007C?o00030000oooooooo06koool004koool00ol0VOooooooo`0noooo0P0001dco`00
0`000?ooooooo`1_oooo001>oooo00?o09Woooooool0?_ooo`030000<ol0<ol001/co`000`000?oo
ooooo`1`oooo001>oooo00?o09Woooooool0?_ooo`030000<ol0<ol001/co`000`000?ooooooo`1`
oooo001>oooo00?o09Woooooool0?_ooo`030000<ol0<ol001Xco`000`000?ooooooo`1aoooo001>
oooo00?o09Woooooool0?_ooo`030000<ol0<ol001Xco`000`000?ooooooo`1aoooo001>oooo00?o
09Woooooool0?_ooo`030000<ol0<ol001Tco`000`000?ooooooo`1boooo001>oooo00?o09Wooooo
ool0?_ooo`80000J<ol000<0003oooooool0L_ooo`00C_ooo`03o`2Ioooooooo03koool00`0003?o
03?o000H<ol000<0003oooooool0Loooo`00C_ooo`03o`2Ioooooooo03koool00`0003?o03?o000H
<ol000<0003oooooool0Loooo`00C_ooo`03o`2Ioooooooo03koool00`0003?o03?o000G<ol000<0
003oooooool0M?ooo`00C_ooo`03o`2Ioooooooo03koool00`0003?o03?o000G<ol000<0003ooooo
ool0M?ooo`00C_ooo`03o`2Ioooooooo03Koool500000oooo`030000<ol0<ol001Hco`000`000?oo
ooooo`1eoooo001>oooo00?o09Woooooool0>?ooo`030000oooooooo00?oool00`0003?o03?o000F
<ol000<0003oooooool0MOooo`00C_ooo`03o`2Ioooooooo03Soool00`000?ooooooo`03oooo0`00
01Dco`000`000?ooooooo`1foooo001>oooo00?o09Woooooool0>?ooo`030000oooooooo00?oool0
0`0003?o03?o000E<ol000<0003oooooool0M_ooo`00C_ooo`03o`2Ioooooooo03Soool00`000?oo
ooooo`03oooo00<0000co`0co`005C?o00030000oooooooo07Koool004koool00ol0VOooooooo`0g
oooo0P0000Goool00`0003?o03?o000D<ol000<0003oooooool0Moooo`00C_ooo`03o`2Ioooooooo
03koool00`0003?o03?o000D<ol000<0003oooooool0Moooo`00C_ooo`03o`2Ioooooooo03koool0
0`0003?o03?o000C<ol000<0003oooooool0N?ooo`00C_ooo`03o`2Ioooooooo03koool2000053?o
00030000oooooooo07Soool004koool00ol0VOooooooo`0noooo00<0000co`0co`004c?o00030000
oooooooo07Soool004koool00ol0VOooooooo`0noooo00<0000co`0co`004S?o00030000oooooooo
07Woool004koool00ol0VOooooooo`0noooo00<0000co`0co`004S?o00030000oooooooo07Woool0
04koool00ol0VOooooooo`0noooo00<0000co`0co`004S?o00030000oooooooo07Woool004koool0
0ol0VOooooooo`0noooo00<0000co`0co`004C?o00030000oooooooo07[oool004koool00ol0VOoo
ooooo`0noooo0P00018co`000`000?ooooooo`1joooo001>oooo00?o09Woooooool0?_ooo`030000
<ol0<ol0014co`000`000?ooooooo`1joooo001>oooo00?o09Woooooool0?_ooo`030000<ol0<ol0
014co`000`000?ooooooo`1joooo001>oooo00?o09Woooooool0?_ooo`030000<ol0<ol0010co`00
0`000?ooooooo`1koooo001>oooo00?o09Woooooool0?_ooo`030000<ol0<ol0010co`000`000?oo
ooooo`1koooo001>oooo00?o09Woooooool0?_ooo`030000<ol0<ol0010co`000`000?ooooooo`1k
oooo001>oooo00?o09Woooooool0?_ooo`030000<ol0<ol0010co`000`000?ooooooo`1koooo001>
oooo00?o09Woooooool0?_ooo`80000@<ol000<0003oooooool0O?ooo`00C_ooo`03o`2Ioooooooo
03koool00`0003?o03?o000?<ol000<0003oooooool0O?ooo`00C_ooo`03o`2Ioooooooo03koool0
0`0003?o03?o000?<ol000<0003oooooool0O?ooo`00C_ooo`03o`2Ioooooooo03koool00`0003?o
03?o000?<ol000<0003oooooool0O?ooo`00C_ooo`03o`2Ioooooooo03koool00`0003?o03?o000?
<ol000<0003oooooool0O?ooo`00C_ooo`03o`2Ioooooooo03koool00`0003?o03?o000><ol000<0
003oooooool0OOooo`00C_ooo`03o`2Ioooooooo03koool200003c?o00030000oooooooo07goool0
04koool00ol0VOooooooo`0noooo00<0000co`0co`003S?o00030000oooooooo07goool004koool0
0ol0VOooooooo`0noooo00<0000co`0co`003S?o00030000oooooooo07goool004koool00ol0VOoo
ooooo`0noooo00<0000co`0co`003C?o00030000oooooooo07koool004koool00ol0VOooooooo`0f
oooo100000Coool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00C_ooo`03o`2Ioooooooo
03Koool00`000?ooooooo`05oooo00<0000co`0co`003C?o00030000oooooooo07koool004koool0
0ol0VOooooooo`0goooo00<0003oooooool01?ooo`<0000=<ol000<0003oooooool0O_ooo`00C_oo
o`03o`2Ioooooooo03Soool00`000?ooooooo`03oooo00<0000co`0co`003C?o00030000oooooooo
07koool004koool00ol0VOooooooo`0foooo00@0003oooooool00004oooo00<0000co`0co`0033?o
00030000oooooooo07ooool004koool00ol0VOooooooo`0goooo0P0000Goool00`0003?o03?o000<
<ol000<0003oooooool0Ooooo`00C_ooo`03o`2Ioooooooo03koool00`0003?o03?o000<<ol000<0
003oooooool0Ooooo`00C_ooo`03o`2Ioooooooo03koool00`0003?o03?o000<<ol000<0003ooooo
ool0Ooooo`00C_ooo`03o`2Ioooooooo03koool200003C?o00030000oooooooo07ooool004koool0
0ol0VOooooooo`0noooo00<0000co`0co`0033?o00030000oooooooo07ooool004koool00ol0VOoo
ooooo`0noooo00<0000co`0co`002c?o00030000oooooooo083oool004koool00ol0VOooooooo`0n
oooo00<0000co`0co`002c?o00030000oooooooo083oool004koool00ol0VOooooooo`0noooo00<0
000co`0co`002c?o00030000oooooooo083oool004koool00ol0VOooooooo`0noooo00<0000co`0c
o`002c?o00030000oooooooo083oool004koool00ol0VOooooooo`0noooo00<0000co`0co`002c?o
00030000oooooooo083oool004koool00ol0VOooooooo`0noooo0P0000`co`000`000?ooooooo`20
oooo001>oooo00?o09Woooooool0?_ooo`030000<ol0<ol000/co`000`000?ooooooo`20oooo001>
oooo00?o09Woooooool0?_ooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001>oooo00?o
09Woooooool0?_ooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001>oooo00?o09Wooooo
ool0?_ooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001>oooo00?o09Woooooool0?_oo
o`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001>oooo00?o09Woooooool0?_ooo`80000;
<ol000<0003oooooool0POooo`00C_ooo`03o`2Ioooooooo03koool00`0003?o03?o000:<ol000<0
003oooooool0POooo`00C_ooo`03o`2Ioooooooo03koool00`0003?o03?o000:<ol000<0003ooooo
ool0POooo`00C_ooo`03o`2Ioooooooo03koool00`0003?o03?o0009<ol000<0003oooooool0P_oo
o`00C_ooo`03o`2Ioooooooo03koool00`0003?o03?o0009<ol000<0003oooooool0P_ooo`00C_oo
o`03o`2Ioooooooo03koool00`0003?o03?o0009<ol000<0003oooooool0P_ooo`00C_ooo`03o`2I
oooooooo03koool200002S?o00030000oooooooo08;oool004koool00ol0VOooooooo`0noooo00<0
000co`0co`002C?o00030000oooooooo08;oool004koool00ol0VOooooooo`0noooo00<0000co`0c
o`002C?o00030000oooooooo08;oool004koool00ol0VOooooooo`0noooo00<0000co`0co`0023?o
00030000oooooooo08?oool004koool00ol0VOooooooo`0goooo0P0000Goool00`0003?o03?o0008
<ol000<0003oooooool0Poooo`00C_ooo`03o`2Ioooooooo03Koool010000?ooooooo`0000Coool0
0`0003?o03?o0008<ol000<0003oooooool0Poooo`00C_ooo`03o`2Ioooooooo03Soool00`000?oo
ooooo`03oooo0`0000Pco`000`000?ooooooo`23oooo001>oooo00?o09Woooooool0>Oooo`030000
oooooooo00;oool00`0003?o03?o0008<ol000<0003oooooool0Poooo`00C_ooo`03o`2Ioooooooo
03Koool010000?ooooooo`0000Coool00`0003?o03?o0008<ol000<0003oooooool0Poooo`00C_oo
o`03o`2Ioooooooo03Ooool200001Oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001>
oooo00?o09Woooooool0?_ooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001>oooo00?o
09Woooooool0?_ooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001>oooo00?o09Wooooo
ool0?_ooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001>oooo00?o09Woooooool0?_oo
o`800008<ol000<0003oooooool0Q?ooo`00C_ooo`03o`2Ioooooooo03koool00`0003?o03?o0007
<ol000<0003oooooool0Q?ooo`00C_ooo`03o`2Ioooooooo03koool00`0003?o03?o0007<ol000<0
003oooooool0Q?ooo`00C_ooo`03o`2Ioooooooo03koool00`0003?o03?o0007<ol000<0003ooooo
ool0Q?ooo`00C_ooo`03o`2Ioooooooo03koool00`0003?o03?o0006<ol000<0003oooooool0QOoo
o`00C_ooo`03o`2Ioooooooo03koool00`0003?o03?o0006<ol000<0003oooooool0QOooo`00C_oo
o`03o`2Ioooooooo03koool200001c?o00030000oooooooo08Goool004koool00ol0VOooooooo`0n
oooo00<0000co`0co`001S?o00030000oooooooo08Goool004koool00ol0VOooooooo`0noooo00<0
000co`0co`001S?o00030000oooooooo08Goool004koool00ol0VOooooooo`0noooo00<0000co`0c
o`001S?o00030000oooooooo08Goool004koool00ol0VOooooooo`0noooo00<0000co`0co`001S?o
00030000oooooooo08Goool004koool00ol0VOooooooo`0noooo00<0000co`0co`001S?o00030000
oooooooo08Goool004koool00ol0VOooooooo`0noooo0P0000Hco`000`000?ooooooo`26oooo001>
oooo00?o09Woooooool0?_ooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001>oooo00?o
09Woooooool0?_ooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001>oooo00?o09Wooooo
ool0?_ooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001>oooo00?o09Woooooool0?_oo
o`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001>oooo00?o09Woooooool0?_ooo`030000
<ol0<ol000Dco`000`000?ooooooo`26oooo001>oooo00?o09Woooooool0?_ooo`800006<ol000<0
003oooooool0Q_ooo`00C_ooo`03o`2Ioooooooo03koool00`0003?o03?o0005<ol000<0003ooooo
ool0Q_ooo`00C_ooo`03o`2Ioooooooo03koool00`0003?o03?o0005<ol000<0003oooooool0Q_oo
o`00C_ooo`03o`2Ioooooooo03koool00`0003?o03?o0004<ol000<0003oooooool0Qoooo`00C_oo
o`03o`2Ioooooooo03koool00`0003?o03?o0004<ol000<0003oooooool0Qoooo`00C_ooo`03o`2I
oooooooo03Soool300000oooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001>oooo00?o
09Woooooool0>Oooo`030000oooooooo00;oool00`0003?o03?o0004<ol000<0003oooooool0Qooo
o`00C_ooo`03o`2Ioooooooo03Koool500000oooo`<00004<ol000<0003oooooool0Qoooo`00Qooo
o`040000oooooooo00001?ooo`Lco`2:oooo0028oooo00<0003oool000001?ooo`Lco`2:oooo0029
oooo0P0000Coool7<ol0R_ooo`00Soooo`Lco`2:oooo002?oooo1c?o08[oool007Koool00`000?oo
ooooo`0Foooo1c?o017oool00`000?ooooooo`1foooo001eoooo00<0003oooooool02?ooo`030000
oooooooo00coool7<ol04_ooo`030000oooooooo07Goool007Goool00`000?ooooooo`02oooo0P00
00Coool00`000?ooooooo`0<oooo00<co`000000000013?o00800004oooo0P0000Coool200001?oo
o`030000oooooooo07Goool007Goool01@000?ooooooooooo`000002oooo00<0003oooooool00_oo
o`030000oooooooo00Coool400000oooo`040000<ol0<ol000000c?o00Goool010000?ooooooo`00
00;oool010000?ooooooo`0000?oool00`000?ooooooo`1eoooo001doooo00<0003oooooool00_oo
o`030000oooooooo01?oool0100003?o03?o000000<co`05oooo00@0003oooooool00002oooo00@0
003oooooool00004oooo00<0003oooooool0M?ooo`00MOooo`030000oooooooo00D0000Boooo00@0
000co`0co`000003<ol01Oooo`040000oooooooo00000oooo`800004oooo00<0003oooooool0MOoo
o`00MOooo`050000oooooooooooo000001Goool0100003?o03?o000000<co`05oooo00@0003ooooo
ool00002oooo00@0003oooooool00003oooo00<0003oooooool0MOooo`00M_ooo`030000oooooooo
01Koool00c?o000000000004<ol01_ooo`800004oooo0P0000?oool00`000?ooooooo`1foooo002?
oooo1c?o08[oool008ooool7<ol0R_ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.06) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.20342 .12361 L
.22272 .12361 L
.23233 .12361 L
.23739 .12361 L
.24276 .12361 L
.24502 .12361 L
.24627 .12361 L
.24745 .12361 L
s
.24745 .12361 m
.24772 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.06) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`05oooo00Go09Wooooo
ooooool000002oooo`030000oooooooo00Woool00`000?ooooooo`09oooo00<0003oooooool02Ooo
o`030000oooooooo00Woool00`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol0
00Tco`000`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Hco`0R00001_oo
o`030000oooooooo00Woool00`000?ooooooo`0Eoooo000Foooo00<0003oooooool0=_ooo`05o`2I
oooooooooooo000003_oool00`0003?o03?o000i<ol02@0003Coool00`000?ooooooo`0Eoooo001?
oooo00?o09Woooooool0?Oooo`030000<ol0<ol003<co`060000EOooo`00Coooo`03o`2Ioooooooo
03goool00`0003?o03?o000a<ol00P0005_oool004ooool00ol0VOooooooo`0moooo00<0000co`0c
o`00;c?o0080001Moooo001?oooo00?o09Woooooool0?Oooo`030000<ol0<ol002`co`030000Gooo
o`00Coooo`03o`2Ioooooooo03goool20000:S?o00<0001Roooo001?oooo00?o09Woooooool0?Ooo
o`030000<ol0<ol002Lco`020000IOooo`00Coooo`03o`2Ioooooooo03goool00`0003?o03?o000V
<ol000<0003oooooool0IOooo`00Coooo`03o`2Ioooooooo03goool00`0003?o03?o000U<ol000<0
003oooooool0I_ooo`00Coooo`03o`2Ioooooooo03goool00`0003?o03?o000T<ol000<0003ooooo
ool0Ioooo`00Coooo`03o`2Ioooooooo03goool00`0003?o03?o000R<ol00P0006[oool004ooool0
0ol0VOooooooo`0moooo0P00028co`000`000?ooooooo`1Zoooo001?oooo00?o09Woooooool0?Ooo
o`030000<ol0<ol0020co`000`000?ooooooo`1[oooo001?oooo00?o09Woooooool0?Oooo`030000
<ol0<ol001lco`000`000?ooooooo`1/oooo001?oooo00?o09Woooooool0?Oooo`030000<ol0<ol0
01lco`000`000?ooooooo`1/oooo001?oooo00?o09Woooooool0?Oooo`030000<ol0<ol001hco`00
0`000?ooooooo`1]oooo001?oooo00?o09Woooooool0?Oooo`030000<ol0<ol001dco`000`000?oo
ooooo`1^oooo001?oooo00?o09Woooooool0?Oooo`80000M<ol000<0003oooooool0Koooo`00Cooo
o`03o`2Ioooooooo03goool00`0003?o03?o000K<ol000<0003oooooool0L?ooo`00Coooo`03o`2I
oooooooo03goool00`0003?o03?o000K<ol000<0003oooooool0L?ooo`00Coooo`03o`2Ioooooooo
03goool00`0003?o03?o000J<ol000<0003oooooool0LOooo`00Coooo`03o`2Ioooooooo03goool0
0`0003?o03?o000J<ol000<0003oooooool0LOooo`00Coooo`03o`2Ioooooooo03goool00`0003?o
03?o000I<ol000<0003oooooool0L_ooo`00Coooo`03o`2Ioooooooo03goool200006S?o00030000
oooooooo07;oool004ooool00ol0VOooooooo`0moooo00<0000co`0co`0063?o00030000oooooooo
07?oool004ooool00ol0VOooooooo`0moooo00<0000co`0co`0063?o00030000oooooooo07?oool0
04ooool00ol0VOooooooo`0moooo00<0000co`0co`005c?o00030000oooooooo07Coool004ooool0
0ol0VOooooooo`0moooo00<0000co`0co`005c?o00030000oooooooo07Coool004ooool00ol0VOoo
ooooo`0eoooo1@0000?oool00`0003?o03?o000F<ol000<0003oooooool0MOooo`00Coooo`03o`2I
oooooooo03Ooool00`000?ooooooo`03oooo00<0000co`0co`005S?o00030000oooooooo07Goool0
04ooool00ol0VOooooooo`0goooo00<0003oooooool00oooo`<0000E<ol000<0003oooooool0M_oo
o`00Coooo`03o`2Ioooooooo03Ooool00`000?ooooooo`03oooo00<0000co`0co`005C?o00030000
oooooooo07Koool004ooool00ol0VOooooooo`0goooo00<0003oooooool00oooo`030000<ol0<ol0
01Dco`000`000?ooooooo`1foooo001?oooo00?o09Woooooool0=_ooo`800005oooo00<0000co`0c
o`0053?o00030000oooooooo07Ooool004ooool00ol0VOooooooo`0moooo00<0000co`0co`0053?o
00030000oooooooo07Ooool004ooool00ol0VOooooooo`0moooo00<0000co`0co`004c?o00030000
oooooooo07Soool004ooool00ol0VOooooooo`0moooo0P0001@co`000`000?ooooooo`1hoooo001?
oooo00?o09Woooooool0?Oooo`030000<ol0<ol001<co`000`000?ooooooo`1hoooo001?oooo00?o
09Woooooool0?Oooo`030000<ol0<ol0018co`000`000?ooooooo`1ioooo001?oooo00?o09Wooooo
ool0?Oooo`030000<ol0<ol0018co`000`000?ooooooo`1ioooo001?oooo00?o09Woooooool0?Ooo
o`030000<ol0<ol0018co`000`000?ooooooo`1ioooo001?oooo00?o09Woooooool0?Oooo`030000
<ol0<ol0014co`000`000?ooooooo`1joooo001?oooo00?o09Woooooool0?Oooo`80000B<ol000<0
003oooooool0N_ooo`00Coooo`03o`2Ioooooooo03goool00`0003?o03?o000A<ol000<0003ooooo
ool0N_ooo`00Coooo`03o`2Ioooooooo03goool00`0003?o03?o000A<ol000<0003oooooool0N_oo
o`00Coooo`03o`2Ioooooooo03goool00`0003?o03?o000@<ol000<0003oooooool0Noooo`00Cooo
o`03o`2Ioooooooo03goool00`0003?o03?o000@<ol000<0003oooooool0Noooo`00Coooo`03o`2I
oooooooo03goool00`0003?o03?o000@<ol000<0003oooooool0Noooo`00Coooo`03o`2Ioooooooo
03goool00`0003?o03?o000@<ol000<0003oooooool0Noooo`00Coooo`03o`2Ioooooooo03goool2
000043?o00030000oooooooo07coool004ooool00ol0VOooooooo`0moooo00<0000co`0co`003c?o
00030000oooooooo07coool004ooool00ol0VOooooooo`0moooo00<0000co`0co`003c?o00030000
oooooooo07coool004ooool00ol0VOooooooo`0moooo00<0000co`0co`003c?o00030000oooooooo
07coool004ooool00ol0VOooooooo`0moooo00<0000co`0co`003c?o00030000oooooooo07coool0
04ooool00ol0VOooooooo`0moooo00<0000co`0co`003S?o00030000oooooooo07goool004ooool0
0ol0VOooooooo`0moooo0P0000lco`000`000?ooooooo`1moooo001?oooo00?o09Woooooool0?Ooo
o`030000<ol0<ol000hco`000`000?ooooooo`1moooo001?oooo00?o09Woooooool0?Oooo`030000
<ol0<ol000hco`000`000?ooooooo`1moooo001?oooo00?o09Woooooool0?Oooo`030000<ol0<ol0
00dco`000`000?ooooooo`1noooo001?oooo00?o09Woooooool0=Oooo`@00004oooo00<0000co`0c
o`003C?o00030000oooooooo07koool004ooool00ol0VOooooooo`0eoooo00<0003oooooool01Ooo
o`030000<ol0<ol000dco`000`000?ooooooo`1noooo001?oooo00?o09Woooooool0=_ooo`030000
oooooooo00Coool300003C?o00030000oooooooo07koool004ooool00ol0VOooooooo`0goooo00<0
003oooooool00oooo`030000<ol0<ol000dco`000`000?ooooooo`1noooo001?oooo00?o09Wooooo
ool0=Oooo`040000oooooooo00001?ooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001?
oooo00?o09Woooooool0=_ooo`800005oooo00<0000co`0co`0033?o00030000oooooooo07ooool0
04ooool00ol0VOooooooo`0moooo00<0000co`0co`0033?o00030000oooooooo07ooool004ooool0
0ol0VOooooooo`0moooo00<0000co`0co`0033?o00030000oooooooo07ooool004ooool00ol0VOoo
ooooo`0moooo0P0000dco`000`000?ooooooo`1ooooo001?oooo00?o09Woooooool0?Oooo`030000
<ol0<ol000`co`000`000?ooooooo`1ooooo001?oooo00?o09Woooooool0?Oooo`030000<ol0<ol0
00/co`000`000?ooooooo`20oooo001?oooo00?o09Woooooool0?Oooo`030000<ol0<ol000/co`00
0`000?ooooooo`20oooo001?oooo00?o09Woooooool0?Oooo`030000<ol0<ol000/co`000`000?oo
ooooo`20oooo001?oooo00?o09Woooooool0?Oooo`030000<ol0<ol000/co`000`000?ooooooo`20
oooo001?oooo00?o09Woooooool0?Oooo`030000<ol0<ol000/co`000`000?ooooooo`20oooo001?
oooo00?o09Woooooool0?Oooo`80000<<ol000<0003oooooool0P?ooo`00Coooo`03o`2Ioooooooo
03goool00`0003?o03?o000;<ol000<0003oooooool0P?ooo`00Coooo`03o`2Ioooooooo03goool0
0`0003?o03?o000:<ol000<0003oooooool0POooo`00Coooo`03o`2Ioooooooo03goool00`0003?o
03?o000:<ol000<0003oooooool0POooo`00Coooo`03o`2Ioooooooo03goool00`0003?o03?o000:
<ol000<0003oooooool0POooo`00Coooo`03o`2Ioooooooo03goool00`0003?o03?o000:<ol000<0
003oooooool0POooo`00Coooo`03o`2Ioooooooo03goool200002c?o00030000oooooooo087oool0
04ooool00ol0VOooooooo`0moooo00<0000co`0co`002S?o00030000oooooooo087oool004ooool0
0ol0VOooooooo`0moooo00<0000co`0co`002S?o00030000oooooooo087oool004ooool00ol0VOoo
ooooo`0moooo00<0000co`0co`002C?o00030000oooooooo08;oool004ooool00ol0VOooooooo`0m
oooo00<0000co`0co`002C?o00030000oooooooo08;oool004ooool00ol0VOooooooo`0moooo00<0
000co`0co`002C?o00030000oooooooo08;oool004ooool00ol0VOooooooo`0moooo0P0000Xco`00
0`000?ooooooo`22oooo001?oooo00?o09Woooooool0?Oooo`030000<ol0<ol000Tco`000`000?oo
ooooo`22oooo001?oooo00?o09Woooooool0?Oooo`030000<ol0<ol000Tco`000`000?ooooooo`22
oooo001?oooo00?o09Woooooool0?Oooo`030000<ol0<ol000Pco`000`000?ooooooo`23oooo001?
oooo00?o09Woooooool0=_ooo`800005oooo00<0000co`0co`0023?o00030000oooooooo08?oool0
04ooool00ol0VOooooooo`0eoooo00@0003oooooool00004oooo00<0000co`0co`0023?o00030000
oooooooo08?oool004ooool00ol0VOooooooo`0goooo00<0003oooooool00oooo`<00008<ol000<0
003oooooool0Poooo`00Coooo`03o`2Ioooooooo03Soool00`000?ooooooo`02oooo00<0000co`0c
o`0023?o00030000oooooooo08?oool004ooool00ol0VOooooooo`0eoooo00@0003oooooool00004
oooo00<0000co`0co`0023?o00030000oooooooo08?oool004ooool00ol0VOooooooo`0foooo0P00
00Goool00`0003?o03?o0007<ol000<0003oooooool0Q?ooo`00Coooo`03o`2Ioooooooo03goool0
0`0003?o03?o0007<ol000<0003oooooool0Q?ooo`00Coooo`03o`2Ioooooooo03goool00`0003?o
03?o0007<ol000<0003oooooool0Q?ooo`00Coooo`03o`2Ioooooooo03goool00`0003?o03?o0007
<ol000<0003oooooool0Q?ooo`00Coooo`03o`2Ioooooooo03goool2000023?o00030000oooooooo
08Coool004ooool00ol0VOooooooo`0moooo00<0000co`0co`001c?o00030000oooooooo08Coool0
04ooool00ol0VOooooooo`0moooo00<0000co`0co`001c?o00030000oooooooo08Coool004ooool0
0ol0VOooooooo`0moooo00<0000co`0co`001c?o00030000oooooooo08Coool004ooool00ol0VOoo
ooooo`0moooo00<0000co`0co`001S?o00030000oooooooo08Goool004ooool00ol0VOooooooo`0m
oooo00<0000co`0co`001S?o00030000oooooooo08Goool004ooool00ol0VOooooooo`0moooo0P00
00Lco`000`000?ooooooo`25oooo001?oooo00?o09Woooooool0?Oooo`030000<ol0<ol000Hco`00
0`000?ooooooo`25oooo001?oooo00?o09Woooooool0?Oooo`030000<ol0<ol000Hco`000`000?oo
ooooo`25oooo001?oooo00?o09Woooooool0?Oooo`030000<ol0<ol000Hco`000`000?ooooooo`25
oooo001?oooo00?o09Woooooool0?Oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001?
oooo00?o09Woooooool0?Oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001?oooo00?o
09Woooooool0?Oooo`800006<ol000<0003oooooool0Q_ooo`00Coooo`03o`2Ioooooooo03goool0
0`0003?o03?o0005<ol000<0003oooooool0Q_ooo`00Coooo`03o`2Ioooooooo03goool00`0003?o
03?o0005<ol000<0003oooooool0Q_ooo`00Coooo`03o`2Ioooooooo03goool00`0003?o03?o0005
<ol000<0003oooooool0Q_ooo`00Coooo`03o`2Ioooooooo03goool00`0003?o03?o0005<ol000<0
003oooooool0Q_ooo`00Coooo`03o`2Ioooooooo03goool00`0003?o03?o0005<ol000<0003ooooo
ool0Q_ooo`00Coooo`03o`2Ioooooooo03goool200001S?o00030000oooooooo08Koool004ooool0
0ol0VOooooooo`0moooo00<0000co`0co`001C?o00030000oooooooo08Koool004ooool00ol0VOoo
ooooo`0moooo00<0000co`0co`001C?o00030000oooooooo08Koool004ooool00ol0VOooooooo`0m
oooo00<0000co`0co`0013?o00030000oooooooo08Ooool004ooool00ol0VOooooooo`0moooo00<0
000co`0co`0013?o00030000oooooooo08Ooool004ooool00ol0VOooooooo`0goooo0`0000?oool0
0`0003?o03?o0004<ol000<0003oooooool0Qoooo`00Coooo`03o`2Ioooooooo03Soool00`000?oo
ooooo`02oooo00<0000co`0co`0013?o00030000oooooooo08Ooool004ooool00ol0VOooooooo`0e
oooo1@0000?oool3000013?o00030000oooooooo08Ooool008Ooool010000?ooooooo`0000Coool7
<ol0R_ooo`00R?ooo`030000oooo000000Coool7<ol0R_ooo`00ROooo`800004oooo1c?o08[oool0
08ooool7<ol0R_ooo`00Soooo`Lco`2:oooo001foooo00<0003oooooool05_ooo`Lco`0Aoooo00<0
003oooooool0M_ooo`00MOooo`030000oooooooo00Soool00`000?ooooooo`0<oooo1c?o01;oool0
0`000?ooooooo`1eoooo001eoooo00<0003oooooool00_ooo`800004oooo00<0003oooooool03?oo
o`03<ol00000000000@co`0200001?ooo`800003oooo0`0000Coool00`000?ooooooo`1eoooo001e
oooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`04oooo1000
00?oool0100003?o03?o000000<co`05oooo00@0003oooooool00002oooo00@0003oooooool00003
oooo00<0003oooooool0MOooo`00M?ooo`030000oooooooo00;oool00`000?ooooooo`0Coooo00@0
000co`0co`000003<ol01Oooo`040000oooooooo00000_ooo`040000oooooooo00001?ooo`030000
oooooooo07Coool007Goool00`000?ooooooo`0500004_ooo`040000<ol0<ol000000c?o00Goool0
10000?ooooooo`0000;oool300001?ooo`030000oooooooo07Goool007Goool01@000?oooooooooo
o`00000Eoooo00@0000co`0co`000003<ol01Oooo`040000oooooooo00000oooo`030000oooooooo
00?oool00`000?ooooooo`1eoooo001foooo00<0003oooooool05_ooo`03<ol00000000000@co`06
oooo0P0000Coool300000_ooo`030000oooooooo07Koool008ooool7<ol0R_ooo`00Soooo`Lco`2:
oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.04) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.20342 .12361 L
.22272 .12361 L
.23233 .12361 L
.23739 .12361 L
.24276 .12361 L
.24745 .12361 L
.24873 .12361 L
.25012 .12361 L
.25142 .12361 L
s
.25142 .12361 m
.2519 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.04) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`06oooo00Co09Wooooo
ool0000;oooo00<0003oooooool02Oooo`030000oooooooo00Woool00`000?ooooooo`09oooo00<0
003oooooool02Oooo`030000<ol0<ol000Tco`000`0003?o03?o0009<ol000<0000co`0co`002C?o
00030000<ol0<ol000Tco`000`0003?o03?o0009<ol000<0000co`0co`001S?o02800006oooo00<0
003oooooool02Oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0goooo00Co09Wooooo
ool0000koooo00<0000co`0co`00>C?o00T0000doooo00<0003oooooool05Oooo`00D?ooo`03o`2I
oooooooo03coool00`0003?o03?o000c<ol01P0005Goool0053oool00ol0VOooooooo`0loooo00<0
000co`0co`00<C?o0080001Koooo001@oooo00?o09Woooooool0??ooo`030000<ol0<ol002lco`02
0000GOooo`00D?ooo`03o`2Ioooooooo03coool00`0003?o03?o000/<ol00`0005ooool0053oool0
0ol0VOooooooo`0loooo0P0002Xco`030000H_ooo`00D?ooo`03o`2Ioooooooo03coool00`0003?o
03?o000W<ol00P0006Goool0053oool00ol0VOooooooo`0loooo00<0000co`0co`009S?o00030000
oooooooo06Goool0053oool00ol0VOooooooo`0loooo00<0000co`0co`009C?o00030000oooooooo
06Koool0053oool00ol0VOooooooo`0loooo00<0000co`0co`0093?o00030000oooooooo06Ooool0
053oool00ol0VOooooooo`0loooo00<0000co`0co`008S?o0080001Zoooo001@oooo00?o09Wooooo
ool0??ooo`80000R<ol000<0003oooooool0J_ooo`00D?ooo`03o`2Ioooooooo03coool00`0003?o
03?o000P<ol000<0003oooooool0Joooo`00D?ooo`03o`2Ioooooooo03coool00`0003?o03?o000O
<ol000<0003oooooool0K?ooo`00D?ooo`03o`2Ioooooooo03coool00`0003?o03?o000O<ol000<0
003oooooool0K?ooo`00D?ooo`03o`2Ioooooooo03coool00`0003?o03?o000N<ol000<0003ooooo
ool0KOooo`00D?ooo`03o`2Ioooooooo03coool00`0003?o03?o000M<ol000<0003oooooool0K_oo
o`00D?ooo`03o`2Ioooooooo03coool200007C?o00030000oooooooo06ooool0053oool00ol0VOoo
ooooo`0loooo00<0000co`0co`006c?o00030000oooooooo073oool0053oool00ol0VOooooooo`0l
oooo00<0000co`0co`006c?o00030000oooooooo073oool0053oool00ol0VOooooooo`0loooo00<0
000co`0co`006S?o00030000oooooooo077oool0053oool00ol0VOooooooo`0loooo00<0000co`0c
o`006S?o00030000oooooooo077oool0053oool00ol0VOooooooo`0loooo00<0000co`0co`006C?o
00030000oooooooo07;oool0053oool00ol0VOooooooo`0loooo0P0001Xco`000`000?ooooooo`1b
oooo001@oooo00?o09Woooooool0??ooo`030000<ol0<ol001Pco`000`000?ooooooo`1coooo001@
oooo00?o09Woooooool0??ooo`030000<ol0<ol001Pco`000`000?ooooooo`1coooo001@oooo00?o
09Woooooool0??ooo`030000<ol0<ol001Lco`000`000?ooooooo`1doooo001@oooo00?o09Wooooo
ool0??ooo`030000<ol0<ol001Lco`000`000?ooooooo`1doooo001@oooo00?o09Woooooool0=?oo
o`D00003oooo00<0000co`0co`005S?o00030000oooooooo07Goool0053oool00ol0VOooooooo`0f
oooo00<0003oooooool00oooo`030000<ol0<ol001Hco`000`000?ooooooo`1eoooo001@oooo00?o
09Woooooool0=_ooo`030000oooooooo00?oool300005C?o00030000oooooooo07Koool0053oool0
0ol0VOooooooo`0foooo00<0003oooooool00oooo`030000<ol0<ol001Dco`000`000?ooooooo`1f
oooo001@oooo00?o09Woooooool0=_ooo`030000oooooooo00?oool00`0003?o03?o000E<ol000<0
003oooooool0M_ooo`00D?ooo`03o`2Ioooooooo03Goool200001Oooo`030000<ol0<ol001@co`00
0`000?ooooooo`1goooo001@oooo00?o09Woooooool0??ooo`030000<ol0<ol001@co`000`000?oo
ooooo`1goooo001@oooo00?o09Woooooool0??ooo`030000<ol0<ol001<co`000`000?ooooooo`1h
oooo001@oooo00?o09Woooooool0??ooo`80000D<ol000<0003oooooool0N?ooo`00D?ooo`03o`2I
oooooooo03coool00`0003?o03?o000C<ol000<0003oooooool0N?ooo`00D?ooo`03o`2Ioooooooo
03coool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00D?ooo`03o`2Ioooooooo03coool0
0`0003?o03?o000B<ol000<0003oooooool0NOooo`00D?ooo`03o`2Ioooooooo03coool00`0003?o
03?o000B<ol000<0003oooooool0NOooo`00D?ooo`03o`2Ioooooooo03coool00`0003?o03?o000A
<ol000<0003oooooool0N_ooo`00D?ooo`03o`2Ioooooooo03coool200004S?o00030000oooooooo
07[oool0053oool00ol0VOooooooo`0loooo00<0000co`0co`004C?o00030000oooooooo07[oool0
053oool00ol0VOooooooo`0loooo00<0000co`0co`004C?o00030000oooooooo07[oool0053oool0
0ol0VOooooooo`0loooo00<0000co`0co`0043?o00030000oooooooo07_oool0053oool00ol0VOoo
ooooo`0loooo00<0000co`0co`0043?o00030000oooooooo07_oool0053oool00ol0VOooooooo`0l
oooo00<0000co`0co`0043?o00030000oooooooo07_oool0053oool00ol0VOooooooo`0loooo00<0
000co`0co`0043?o00030000oooooooo07_oool0053oool00ol0VOooooooo`0loooo0P00010co`00
0`000?ooooooo`1loooo001@oooo00?o09Woooooool0??ooo`030000<ol0<ol000lco`000`000?oo
ooooo`1loooo001@oooo00?o09Woooooool0??ooo`030000<ol0<ol000lco`000`000?ooooooo`1l
oooo001@oooo00?o09Woooooool0??ooo`030000<ol0<ol000lco`000`000?ooooooo`1loooo001@
oooo00?o09Woooooool0??ooo`030000<ol0<ol000lco`000`000?ooooooo`1loooo001@oooo00?o
09Woooooool0??ooo`030000<ol0<ol000hco`000`000?ooooooo`1moooo001@oooo00?o09Wooooo
ool0??ooo`80000?<ol000<0003oooooool0OOooo`00D?ooo`03o`2Ioooooooo03coool00`0003?o
03?o000><ol000<0003oooooool0OOooo`00D?ooo`03o`2Ioooooooo03coool00`0003?o03?o000>
<ol000<0003oooooool0OOooo`00D?ooo`03o`2Ioooooooo03coool00`0003?o03?o000=<ol000<0
003oooooool0O_ooo`00D?ooo`03o`2Ioooooooo03Coool400001?ooo`030000<ol0<ol000dco`00
0`000?ooooooo`1noooo001@oooo00?o09Woooooool0=?ooo`030000oooooooo00Goool00`0003?o
03?o000=<ol000<0003oooooool0O_ooo`00D?ooo`03o`2Ioooooooo03Goool00`000?ooooooo`04
oooo0`0000dco`000`000?ooooooo`1noooo001@oooo00?o09Woooooool0=_ooo`030000oooooooo
00?oool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00D?ooo`03o`2Ioooooooo03Coool0
10000?ooooooo`0000Coool00`0003?o03?o000<<ol000<0003oooooool0Ooooo`00D?ooo`03o`2I
oooooooo03Goool200001Oooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001@oooo00?o
09Woooooool0??ooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001@oooo00?o09Wooooo
ool0??ooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001@oooo00?o09Woooooool0??oo
o`80000=<ol000<0003oooooool0Ooooo`00D?ooo`03o`2Ioooooooo03coool00`0003?o03?o000<
<ol000<0003oooooool0Ooooo`00D?ooo`03o`2Ioooooooo03coool00`0003?o03?o000;<ol000<0
003oooooool0P?ooo`00D?ooo`03o`2Ioooooooo03coool00`0003?o03?o000;<ol000<0003ooooo
ool0P?ooo`00D?ooo`03o`2Ioooooooo03coool00`0003?o03?o000;<ol000<0003oooooool0P?oo
o`00D?ooo`03o`2Ioooooooo03coool00`0003?o03?o000;<ol000<0003oooooool0P?ooo`00D?oo
o`03o`2Ioooooooo03coool00`0003?o03?o000;<ol000<0003oooooool0P?ooo`00D?ooo`03o`2I
oooooooo03coool2000033?o00030000oooooooo083oool0053oool00ol0VOooooooo`0loooo00<0
000co`0co`002c?o00030000oooooooo083oool0053oool00ol0VOooooooo`0loooo00<0000co`0c
o`002S?o00030000oooooooo087oool0053oool00ol0VOooooooo`0loooo00<0000co`0co`002S?o
00030000oooooooo087oool0053oool00ol0VOooooooo`0loooo00<0000co`0co`002S?o00030000
oooooooo087oool0053oool00ol0VOooooooo`0loooo00<0000co`0co`002S?o00030000oooooooo
087oool0053oool00ol0VOooooooo`0loooo0P0000/co`000`000?ooooooo`21oooo001@oooo00?o
09Woooooool0??ooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001@oooo00?o09Wooooo
ool0??ooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001@oooo00?o09Woooooool0??oo
o`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001@oooo00?o09Woooooool0??ooo`030000
<ol0<ol000Tco`000`000?ooooooo`22oooo001@oooo00?o09Woooooool0??ooo`030000<ol0<ol0
00Tco`000`000?ooooooo`22oooo001@oooo00?o09Woooooool0??ooo`80000:<ol000<0003ooooo
ool0P_ooo`00D?ooo`03o`2Ioooooooo03coool00`0003?o03?o0009<ol000<0003oooooool0P_oo
o`00D?ooo`03o`2Ioooooooo03coool00`0003?o03?o0009<ol000<0003oooooool0P_ooo`00D?oo
o`03o`2Ioooooooo03coool00`0003?o03?o0008<ol000<0003oooooool0Poooo`00D?ooo`03o`2I
oooooooo03Goool200001Oooo`030000<ol0<ol000Pco`000`000?ooooooo`23oooo001@oooo00?o
09Woooooool0=?ooo`040000oooooooo00001?ooo`030000<ol0<ol000Pco`000`000?ooooooo`23
oooo001@oooo00?o09Woooooool0=_ooo`030000oooooooo00?oool3000023?o00030000oooooooo
08?oool0053oool00ol0VOooooooo`0goooo00<0003oooooool00_ooo`030000<ol0<ol000Pco`00
0`000?ooooooo`23oooo001@oooo00?o09Woooooool0=?ooo`040000oooooooo00001?ooo`030000
<ol0<ol000Pco`000`000?ooooooo`23oooo001@oooo00?o09Woooooool0=Oooo`800005oooo00<0
000co`0co`001c?o00030000oooooooo08Coool0053oool00ol0VOooooooo`0loooo00<0000co`0c
o`001c?o00030000oooooooo08Coool0053oool00ol0VOooooooo`0loooo00<0000co`0co`001c?o
00030000oooooooo08Coool0053oool00ol0VOooooooo`0loooo00<0000co`0co`001c?o00030000
oooooooo08Coool0053oool00ol0VOooooooo`0loooo0P0000Pco`000`000?ooooooo`24oooo001@
oooo00?o09Woooooool0??ooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001@oooo00?o
09Woooooool0??ooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001@oooo00?o09Wooooo
ool0??ooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001@oooo00?o09Woooooool0??oo
o`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001@oooo00?o09Woooooool0??ooo`030000
<ol0<ol000Hco`000`000?ooooooo`25oooo001@oooo00?o09Woooooool0??ooo`800007<ol000<0
003oooooool0QOooo`00D?ooo`03o`2Ioooooooo03coool00`0003?o03?o0006<ol000<0003ooooo
ool0QOooo`00D?ooo`03o`2Ioooooooo03coool00`0003?o03?o0006<ol000<0003oooooool0QOoo
o`00D?ooo`03o`2Ioooooooo03coool00`0003?o03?o0006<ol000<0003oooooool0QOooo`00D?oo
o`03o`2Ioooooooo03coool00`0003?o03?o0006<ol000<0003oooooool0QOooo`00D?ooo`03o`2I
oooooooo03coool00`0003?o03?o0006<ol000<0003oooooool0QOooo`00D?ooo`03o`2Ioooooooo
03coool200001S?o00030000oooooooo08Koool0053oool00ol0VOooooooo`0loooo00<0000co`0c
o`001C?o00030000oooooooo08Koool0053oool00ol0VOooooooo`0loooo00<0000co`0co`001C?o
00030000oooooooo08Koool0053oool00ol0VOooooooo`0loooo00<0000co`0co`001C?o00030000
oooooooo08Koool0053oool00ol0VOooooooo`0loooo00<0000co`0co`001C?o00030000oooooooo
08Koool0053oool00ol0VOooooooo`0loooo00<0000co`0co`001C?o00030000oooooooo08Koool0
053oool00ol0VOooooooo`0loooo0P0000Hco`000`000?ooooooo`26oooo001@oooo00?o09Wooooo
ool0??ooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001@oooo00?o09Woooooool0??oo
o`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001@oooo00?o09Woooooool0??ooo`030000
<ol0<ol000@co`000`000?ooooooo`27oooo001@oooo00?o09Woooooool0??ooo`030000<ol0<ol0
00@co`000`000?ooooooo`27oooo001@oooo00?o09Woooooool0=_ooo`<00003oooo00<0000co`0c
o`0013?o00030000oooooooo08Ooool0053oool00ol0VOooooooo`0goooo00<0003oooooool00_oo
o`030000<ol0<ol000@co`000`000?ooooooo`27oooo001@oooo00?o09Woooooool0=?ooo`D00003
oooo0`0000@co`000`000?ooooooo`27oooo0027oooo00@0003oooooool00004oooo1c?o08[oool0
08Soool00`000?ooo`000004oooo1c?o08[oool008Woool200001?ooo`Lco`2:oooo002?oooo1c?o
08[oool008ooool7<ol0R_ooo`00M_ooo`030000oooooooo01Koool7<ol04Oooo`030000oooooooo
07Koool007Goool00`000?ooooooo`08oooo00<0003oooooool03?ooo`Lco`0Boooo00<0003ooooo
ool0MOooo`00MOooo`030000oooooooo00;oool200001?ooo`030000oooooooo00coool00c?o0000
00000004<ol00P0000Coool200001Oooo`<00002oooo00<0003oooooool0MOooo`00MOooo`050000
oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0
000co`0co`000003<ol01Oooo`040000oooooooo00001Oooo`050000oooooooooooo000007Ooool0
07Coool00`000?ooooooo`02oooo00<0003oooooool04oooo`040000<ol0<ol000000c?o00Goool0
10000?ooooooo`0000;oool500000oooo`030000oooooooo07Coool007Goool00`000?ooooooo`05
00004_ooo`040000<ol0<ol000000c?o00Goool010000?ooooooo`0000;oool010000?ooooooo`00
00?oool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000005Oooo`040000<ol0<ol0
00000c?o00Goool010000?ooooooo`0000?oool00`000?ooo`000003oooo00<0003oooooool0MOoo
o`00M_ooo`030000oooooooo01Koool00c?o000000000004<ol01_ooo`800005oooo0P0000;oool0
0`000?ooooooo`1foooo002?oooo1c?o08[oool008ooool7<ol0R_ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.02) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.20342 .12361 L
.22272 .12361 L
.23233 .12361 L
.24276 .12361 L
.24754 .12361 L
.25261 .12361 L
.2547 .12361 L
.25585 .12361 L
.25694 .12361 L
s
.25694 .12361 m
.25746 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -31.0938 0 ]
[.5 .63053 31.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -92.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.02) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
115.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`07oooo00?o09Woool0
00002oooo`030000oooooooo00Woool00`000?ooooooo`09oooo00<0003oooooool02Oooo`030000
oooooooo00Woool00`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Tco`00
0`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Hco`0R00001_ooo`030000
oooooooo00Woool00`000?ooooooo`0Eoooo000Foooo00<0003oooooool0>?ooo`03o`2Ioooo0000
03_oool00`0003?o03?o000i<ol02@0003Coool00`000?ooooooo`0Eoooo001Aoooo00?o09Wooooo
ool0>oooo`030000<ol0<ol003<co`060000EOooo`00DOooo`03o`2Ioooooooo03_oool00`0003?o
03?o000a<ol00P0005_oool0057oool00ol0VOooooooo`0koooo00<0000co`0co`00;c?o0080001M
oooo001Aoooo00?o09Woooooool0>oooo`030000<ol0<ol002`co`030000Goooo`00DOooo`03o`2I
oooooooo03_oool20000:S?o00<0001Roooo001Aoooo00?o09Woooooool0>oooo`030000<ol0<ol0
02Lco`020000IOooo`00DOooo`03o`2Ioooooooo03_oool00`0003?o03?o000V<ol000<0003ooooo
ool0IOooo`00DOooo`03o`2Ioooooooo03_oool00`0003?o03?o000U<ol000<0003oooooool0I_oo
o`00DOooo`03o`2Ioooooooo03_oool00`0003?o03?o000T<ol000<0003oooooool0Ioooo`00DOoo
o`03o`2Ioooooooo03_oool00`0003?o03?o000R<ol00P0006[oool0057oool00ol0VOooooooo`0k
oooo0P00028co`000`000?ooooooo`1Zoooo001Aoooo00?o09Woooooool0>oooo`030000<ol0<ol0
020co`000`000?ooooooo`1[oooo001Aoooo00?o09Woooooool0>oooo`030000<ol0<ol001lco`00
0`000?ooooooo`1/oooo001Aoooo00?o09Woooooool0>oooo`030000<ol0<ol001lco`000`000?oo
ooooo`1/oooo001Aoooo00?o09Woooooool0>oooo`030000<ol0<ol001hco`000`000?ooooooo`1]
oooo001Aoooo00?o09Woooooool0>oooo`030000<ol0<ol001dco`000`000?ooooooo`1^oooo001A
oooo00?o09Woooooool0>oooo`80000M<ol000<0003oooooool0Koooo`00DOooo`03o`2Ioooooooo
03_oool00`0003?o03?o000K<ol000<0003oooooool0L?ooo`00DOooo`03o`2Ioooooooo03_oool0
0`0003?o03?o000K<ol000<0003oooooool0L?ooo`00DOooo`03o`2Ioooooooo03_oool00`0003?o
03?o000J<ol000<0003oooooool0LOooo`00DOooo`03o`2Ioooooooo03_oool00`0003?o03?o000J
<ol000<0003oooooool0LOooo`00DOooo`03o`2Ioooooooo03_oool00`0003?o03?o000I<ol000<0
003oooooool0L_ooo`00DOooo`03o`2Ioooooooo03_oool200006S?o00030000oooooooo07;oool0
057oool00ol0VOooooooo`0koooo00<0000co`0co`0063?o00030000oooooooo07?oool0057oool0
0ol0VOooooooo`0koooo00<0000co`0co`0063?o00030000oooooooo07?oool0057oool00ol0VOoo
ooooo`0koooo00<0000co`0co`005c?o00030000oooooooo07Coool0057oool00ol0VOooooooo`0k
oooo00<0000co`0co`005c?o00030000oooooooo07Coool0057oool00ol0VOooooooo`0coooo1@00
00?oool00`0003?o03?o000F<ol000<0003oooooool0MOooo`00DOooo`03o`2Ioooooooo03Goool0
0`000?ooooooo`03oooo00<0000co`0co`005S?o00030000oooooooo07Goool0057oool00ol0VOoo
ooooo`0eoooo00<0003oooooool00oooo`<0000E<ol000<0003oooooool0M_ooo`00DOooo`03o`2I
oooooooo03Goool00`000?ooooooo`03oooo00<0000co`0co`005C?o00030000oooooooo07Koool0
057oool00ol0VOooooooo`0eoooo00<0003oooooool00oooo`030000<ol0<ol001Dco`000`000?oo
ooooo`1foooo001Aoooo00?o09Woooooool0=?ooo`800005oooo00<0000co`0co`0053?o00030000
oooooooo07Ooool0057oool00ol0VOooooooo`0koooo00<0000co`0co`0053?o00030000oooooooo
07Ooool0057oool00ol0VOooooooo`0koooo00<0000co`0co`004c?o00030000oooooooo07Soool0
057oool00ol0VOooooooo`0koooo0P0001@co`000`000?ooooooo`1hoooo001Aoooo00?o09Wooooo
ool0>oooo`030000<ol0<ol001<co`000`000?ooooooo`1hoooo001Aoooo00?o09Woooooool0>ooo
o`030000<ol0<ol0018co`000`000?ooooooo`1ioooo001Aoooo00?o09Woooooool0>oooo`030000
<ol0<ol0018co`000`000?ooooooo`1ioooo001Aoooo00?o09Woooooool0>oooo`030000<ol0<ol0
018co`000`000?ooooooo`1ioooo001Aoooo00?o09Woooooool0>oooo`030000<ol0<ol0014co`00
0`000?ooooooo`1joooo001Aoooo00?o09Woooooool0>oooo`80000B<ol000<0003oooooool0N_oo
o`00DOooo`03o`2Ioooooooo03_oool00`0003?o03?o000A<ol000<0003oooooool0N_ooo`00DOoo
o`03o`2Ioooooooo03_oool00`0003?o03?o000A<ol000<0003oooooool0N_ooo`00DOooo`03o`2I
oooooooo03_oool00`0003?o03?o000@<ol000<0003oooooool0Noooo`00DOooo`03o`2Ioooooooo
03_oool00`0003?o03?o000@<ol000<0003oooooool0Noooo`00DOooo`03o`2Ioooooooo03_oool0
0`0003?o03?o000@<ol000<0003oooooool0Noooo`00DOooo`03o`2Ioooooooo03_oool00`0003?o
03?o000@<ol000<0003oooooool0Noooo`00DOooo`03o`2Ioooooooo03_oool2000043?o00030000
oooooooo07coool0057oool00ol0VOooooooo`0koooo00<0000co`0co`003c?o00030000oooooooo
07coool0057oool00ol0VOooooooo`0koooo00<0000co`0co`003c?o00030000oooooooo07coool0
057oool00ol0VOooooooo`0koooo00<0000co`0co`003c?o00030000oooooooo07coool0057oool0
0ol0VOooooooo`0koooo00<0000co`0co`003c?o00030000oooooooo07coool0057oool00ol0VOoo
ooooo`0koooo00<0000co`0co`003S?o00030000oooooooo07goool0057oool00ol0VOooooooo`0k
oooo0P0000lco`000`000?ooooooo`1moooo001Aoooo00?o09Woooooool0>oooo`030000<ol0<ol0
00hco`000`000?ooooooo`1moooo001Aoooo00?o09Woooooool0>oooo`030000<ol0<ol000hco`00
0`000?ooooooo`1moooo001Aoooo00?o09Woooooool0>oooo`030000<ol0<ol000dco`000`000?oo
ooooo`1noooo001Aoooo00?o09Woooooool0<oooo`@00004oooo00<0000co`0co`003C?o00030000
oooooooo07koool0057oool00ol0VOooooooo`0coooo00<0003oooooool01Oooo`030000<ol0<ol0
00dco`000`000?ooooooo`1noooo001Aoooo00?o09Woooooool0=?ooo`030000oooooooo00Coool3
00003C?o00030000oooooooo07koool0057oool00ol0VOooooooo`0eoooo00<0003oooooool00ooo
o`030000<ol0<ol000dco`000`000?ooooooo`1noooo001Aoooo00?o09Woooooool0<oooo`040000
oooooooo00001?ooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001Aoooo00?o09Wooooo
ool0=?ooo`800005oooo00<0000co`0co`0033?o00030000oooooooo07ooool0057oool00ol0VOoo
ooooo`0koooo00<0000co`0co`0033?o00030000oooooooo07ooool0057oool00ol0VOooooooo`0k
oooo00<0000co`0co`0033?o00030000oooooooo07ooool0057oool00ol0VOooooooo`0koooo0P00
00dco`000`000?ooooooo`1ooooo001Aoooo00?o09Woooooool0>oooo`030000<ol0<ol000`co`00
0`000?ooooooo`1ooooo001Aoooo00?o09Woooooool0>oooo`030000<ol0<ol000/co`000`000?oo
ooooo`20oooo001Aoooo00?o09Woooooool0>oooo`030000<ol0<ol000/co`000`000?ooooooo`20
oooo001Aoooo00?o09Woooooool0>oooo`030000<ol0<ol000/co`000`000?ooooooo`20oooo001A
oooo00?o09Woooooool0>oooo`030000<ol0<ol000/co`000`000?ooooooo`20oooo001Aoooo00?o
09Woooooool0>oooo`030000<ol0<ol000/co`000`000?ooooooo`20oooo001Aoooo00?o09Wooooo
ool0>oooo`80000<<ol000<0003oooooool0P?ooo`00DOooo`03o`2Ioooooooo03_oool00`0003?o
03?o000;<ol000<0003oooooool0P?ooo`00DOooo`03o`2Ioooooooo03_oool00`0003?o03?o000:
<ol000<0003oooooool0POooo`00DOooo`03o`2Ioooooooo03_oool00`0003?o03?o000:<ol000<0
003oooooool0POooo`00DOooo`03o`2Ioooooooo03_oool00`0003?o03?o000:<ol000<0003ooooo
ool0POooo`00DOooo`03o`2Ioooooooo03_oool00`0003?o03?o000:<ol000<0003oooooool0POoo
o`00DOooo`03o`2Ioooooooo03_oool200002c?o00030000oooooooo087oool0057oool00ol0VOoo
ooooo`0koooo00<0000co`0co`002S?o00030000oooooooo087oool0057oool00ol0VOooooooo`0k
oooo00<0000co`0co`002S?o00030000oooooooo087oool0057oool00ol0VOooooooo`0koooo00<0
000co`0co`002C?o00030000oooooooo08;oool0057oool00ol0VOooooooo`0koooo00<0000co`0c
o`002C?o00030000oooooooo08;oool0057oool00ol0VOooooooo`0koooo00<0000co`0co`002C?o
00030000oooooooo08;oool0057oool00ol0VOooooooo`0koooo0P0000Xco`000`000?ooooooo`22
oooo001Aoooo00?o09Woooooool0>oooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001A
oooo00?o09Woooooool0>oooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001Aoooo00?o
09Woooooool0>oooo`030000<ol0<ol000Pco`000`000?ooooooo`23oooo001Aoooo00?o09Wooooo
ool0=?ooo`800005oooo00<0000co`0co`0023?o00030000oooooooo08?oool0057oool00ol0VOoo
ooooo`0coooo00@0003oooooool00004oooo00<0000co`0co`0023?o00030000oooooooo08?oool0
057oool00ol0VOooooooo`0eoooo00<0003oooooool00oooo`<00008<ol000<0003oooooool0Pooo
o`00DOooo`03o`2Ioooooooo03Koool00`000?ooooooo`02oooo00<0000co`0co`0023?o00030000
oooooooo08?oool0057oool00ol0VOooooooo`0coooo00@0003oooooool00004oooo00<0000co`0c
o`0023?o00030000oooooooo08?oool0057oool00ol0VOooooooo`0doooo0P0000Goool00`0003?o
03?o0007<ol000<0003oooooool0Q?ooo`00DOooo`03o`2Ioooooooo03_oool00`0003?o03?o0007
<ol000<0003oooooool0Q?ooo`00DOooo`03o`2Ioooooooo03_oool00`0003?o03?o0007<ol000<0
003oooooool0Q?ooo`00DOooo`03o`2Ioooooooo03_oool00`0003?o03?o0007<ol000<0003ooooo
ool0Q?ooo`00DOooo`03o`2Ioooooooo03_oool2000023?o00030000oooooooo08Coool0057oool0
0ol0VOooooooo`0koooo00<0000co`0co`001c?o00030000oooooooo08Coool0057oool00ol0VOoo
ooooo`0koooo00<0000co`0co`001c?o00030000oooooooo08Coool0057oool00ol0VOooooooo`0k
oooo00<0000co`0co`001c?o00030000oooooooo08Coool0057oool00ol0VOooooooo`0koooo00<0
000co`0co`001S?o00030000oooooooo08Goool0057oool00ol0VOooooooo`0koooo00<0000co`0c
o`001S?o00030000oooooooo08Goool0057oool00ol0VOooooooo`0koooo0P0000Lco`000`000?oo
ooooo`25oooo001Aoooo00?o09Woooooool0>oooo`030000<ol0<ol000Hco`000`000?ooooooo`25
oooo001Aoooo00?o09Woooooool0>oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001A
oooo00?o09Woooooool0>oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001Aoooo00?o
09Woooooool0>oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001Aoooo00?o09Wooooo
ool0>oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001Aoooo00?o09Woooooool0>ooo
o`800006<ol000<0003oooooool0Q_ooo`00DOooo`03o`2Ioooooooo03_oool00`0003?o03?o0005
<ol000<0003oooooool0Q_ooo`00DOooo`03o`2Ioooooooo03_oool00`0003?o03?o0005<ol000<0
003oooooool0Q_ooo`00DOooo`03o`2Ioooooooo03_oool00`0003?o03?o0005<ol000<0003ooooo
ool0Q_ooo`00DOooo`03o`2Ioooooooo03_oool00`0003?o03?o0005<ol000<0003oooooool0Q_oo
o`00DOooo`03o`2Ioooooooo03_oool00`0003?o03?o0005<ol000<0003oooooool0Q_ooo`00DOoo
o`03o`2Ioooooooo03_oool200001S?o00030000oooooooo08Koool0057oool00ol0VOooooooo`0k
oooo00<0000co`0co`001C?o00030000oooooooo08Koool0057oool00ol0VOooooooo`0koooo00<0
000co`0co`001C?o00030000oooooooo08Koool0057oool00ol0VOooooooo`0koooo00<0000co`0c
o`0013?o00030000oooooooo08Ooool0057oool00ol0VOooooooo`0koooo00<0000co`0co`0013?o
00030000oooooooo08Ooool0057oool00ol0VOooooooo`0eoooo0`0000?oool00`0003?o03?o0004
<ol000<0003oooooool0Qoooo`00DOooo`03o`2Ioooooooo03Koool00`000?ooooooo`02oooo00<0
000co`0co`0013?o00030000oooooooo08Ooool0057oool00ol0VOooooooo`0coooo1@0000?oool3
000013?o00030000oooooooo08Ooool008Ooool010000?ooooooo`0000Coool7<ol0R_ooo`00R?oo
o`030000oooo000000Coool7<ol0R_ooo`00ROooo`800004oooo1c?o08[oool008ooool7<ol0R_oo
o`00Soooo`Lco`2:oooo001foooo00<0003oooooool05_ooo`Lco`0Aoooo00<0003oooooool0M_oo
o`00MOooo`030000oooooooo00Soool00`000?ooooooo`0<oooo1c?o01;oool00`000?ooooooo`1e
oooo001eoooo00<0003oooooool00_ooo`800004oooo00<0003oooooool03?ooo`03<ol000000000
00@co`0200001?ooo`800003oooo100000?oool00`000?ooooooo`1eoooo001eoooo00D0003ooooo
ooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`04oooo100000?oool0100003?o
03?o000000<co`05oooo00@0003oooooool00002oooo00<0003oooooool01?ooo`030000oooooooo
07Goool007Coool00`000?ooooooo`02oooo00<0003oooooool04oooo`040000<ol0<ol000000c?o
00Goool010000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0M?ooo`00MOoo
o`030000oooooooo00D0000Boooo00@0000co`0co`000003<ol01Oooo`040000oooooooo00001?oo
o`030000oooooooo00;oool00`000?ooooooo`1eoooo001eoooo00D0003oooooooooool000005Ooo
o`040000<ol0<ol000000c?o00Goool010000?ooooooo`0000;oool010000?ooooooo`0000?oool0
0`000?ooooooo`1eoooo001foooo00<0003oooooool05_ooo`03<ol00000000000@co`06oooo0P00
00Coool200000oooo`030000oooooooo07Koool008ooool7<ol0R_ooo`00Soooo`Lco`2:oooo0000
\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -21.7813 0 ]
[.5 .63053 21.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -82.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
96.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.24141 .12361 L
.25127 .12361 L
.25666 .12361 L
.2593 .12361 L
.26045 .12361 L
.26171 .12361 L
s
.26171 .12361 m
.26223 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -21.7813 0 ]
[.5 .63053 21.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -82.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
96.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`09oooo00<0003ooooo
ool02Oooo`030000oooooooo00Woool00`000?ooooooo`09oooo00<0003oooooool02Oooo`030000
oooooooo00Woool00`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Tco`00
0`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Hco`0R00001_ooo`030000
oooooooo00Woool00`000?ooooooo`0Eoooo000Foooo00<0003oooooool0>_ooo`030000oooooooo
03Woool00`0003?o03?o000i<ol02@0003Coool00`000?ooooooo`0Eoooo001Coooo00?o09Wooooo
ool0>Oooo`030000<ol0<ol003<co`060000EOooo`00Doooo`03o`2Ioooooooo03Woool00`0003?o
03?o000a<ol00P0005_oool005?oool00ol0VOooooooo`0ioooo00<0000co`0co`00;c?o0080001M
oooo001Coooo00?o09Woooooool0>Oooo`030000<ol0<ol002`co`030000Goooo`00Doooo`03o`2I
oooooooo03Woool20000:S?o00<0001Roooo001Coooo00?o09Woooooool0>Oooo`030000<ol0<ol0
02Lco`020000IOooo`00Doooo`03o`2Ioooooooo03Woool00`0003?o03?o000V<ol000<0003ooooo
ool0IOooo`00Doooo`03o`2Ioooooooo03Woool00`0003?o03?o000U<ol000<0003oooooool0I_oo
o`00Doooo`03o`2Ioooooooo03Woool00`0003?o03?o000T<ol000<0003oooooool0Ioooo`00Dooo
o`03o`2Ioooooooo03Woool00`0003?o03?o000R<ol00P0006[oool005?oool00ol0VOooooooo`0i
oooo0P00028co`000`000?ooooooo`1Zoooo001Coooo00?o09Woooooool0>Oooo`030000<ol0<ol0
020co`000`000?ooooooo`1[oooo001Coooo00?o09Woooooool0>Oooo`030000<ol0<ol001lco`00
0`000?ooooooo`1/oooo001Coooo00?o09Woooooool0>Oooo`030000<ol0<ol001lco`000`000?oo
ooooo`1/oooo001Coooo00?o09Woooooool0>Oooo`030000<ol0<ol001hco`000`000?ooooooo`1]
oooo001Coooo00?o09Woooooool0>Oooo`030000<ol0<ol001dco`000`000?ooooooo`1^oooo001C
oooo00?o09Woooooool0>Oooo`80000M<ol000<0003oooooool0Koooo`00Doooo`03o`2Ioooooooo
03Woool00`0003?o03?o000K<ol000<0003oooooool0L?ooo`00Doooo`03o`2Ioooooooo03Woool0
0`0003?o03?o000K<ol000<0003oooooool0L?ooo`00Doooo`03o`2Ioooooooo03Woool00`0003?o
03?o000J<ol000<0003oooooool0LOooo`00Doooo`03o`2Ioooooooo03Woool00`0003?o03?o000J
<ol000<0003oooooool0LOooo`00Doooo`03o`2Ioooooooo03Woool00`0003?o03?o000I<ol000<0
003oooooool0L_ooo`00Doooo`03o`2Ioooooooo03Woool200006S?o00030000oooooooo07;oool0
05?oool00ol0VOooooooo`0ioooo00<0000co`0co`0063?o00030000oooooooo07?oool005?oool0
0ol0VOooooooo`0ioooo00<0000co`0co`0063?o00030000oooooooo07?oool005?oool00ol0VOoo
ooooo`0ioooo00<0000co`0co`005c?o00030000oooooooo07Coool005?oool00ol0VOooooooo`0i
oooo00<0000co`0co`005c?o00030000oooooooo07Coool005?oool00ol0VOooooooo`0aoooo1@00
00?oool00`0003?o03?o000F<ol000<0003oooooool0MOooo`00Doooo`03o`2Ioooooooo03?oool0
0`000?ooooooo`03oooo00<0000co`0co`005S?o00030000oooooooo07Goool005?oool00ol0VOoo
ooooo`0coooo00<0003oooooool00oooo`<0000E<ol000<0003oooooool0M_ooo`00Doooo`03o`2I
oooooooo03?oool00`000?ooooooo`03oooo00<0000co`0co`005C?o00030000oooooooo07Koool0
05?oool00ol0VOooooooo`0coooo00<0003oooooool00oooo`030000<ol0<ol001Dco`000`000?oo
ooooo`1foooo001Coooo00?o09Woooooool0<_ooo`800005oooo00<0000co`0co`0053?o00030000
oooooooo07Ooool005?oool00ol0VOooooooo`0ioooo00<0000co`0co`0053?o00030000oooooooo
07Ooool005?oool00ol0VOooooooo`0ioooo00<0000co`0co`004c?o00030000oooooooo07Soool0
05?oool00ol0VOooooooo`0ioooo0P0001@co`000`000?ooooooo`1hoooo001Coooo00?o09Wooooo
ool0>Oooo`030000<ol0<ol001<co`000`000?ooooooo`1hoooo001Coooo00?o09Woooooool0>Ooo
o`030000<ol0<ol0018co`000`000?ooooooo`1ioooo001Coooo00?o09Woooooool0>Oooo`030000
<ol0<ol0018co`000`000?ooooooo`1ioooo001Coooo00?o09Woooooool0>Oooo`030000<ol0<ol0
018co`000`000?ooooooo`1ioooo001Coooo00?o09Woooooool0>Oooo`030000<ol0<ol0014co`00
0`000?ooooooo`1joooo001Coooo00?o09Woooooool0>Oooo`80000B<ol000<0003oooooool0N_oo
o`00Doooo`03o`2Ioooooooo03Woool00`0003?o03?o000A<ol000<0003oooooool0N_ooo`00Dooo
o`03o`2Ioooooooo03Woool00`0003?o03?o000A<ol000<0003oooooool0N_ooo`00Doooo`03o`2I
oooooooo03Woool00`0003?o03?o000@<ol000<0003oooooool0Noooo`00Doooo`03o`2Ioooooooo
03Woool00`0003?o03?o000@<ol000<0003oooooool0Noooo`00Doooo`03o`2Ioooooooo03Woool0
0`0003?o03?o000@<ol000<0003oooooool0Noooo`00Doooo`03o`2Ioooooooo03Woool00`0003?o
03?o000@<ol000<0003oooooool0Noooo`00Doooo`03o`2Ioooooooo03Woool2000043?o00030000
oooooooo07coool005?oool00ol0VOooooooo`0ioooo00<0000co`0co`003c?o00030000oooooooo
07coool005?oool00ol0VOooooooo`0ioooo00<0000co`0co`003c?o00030000oooooooo07coool0
05?oool00ol0VOooooooo`0ioooo00<0000co`0co`003c?o00030000oooooooo07coool005?oool0
0ol0VOooooooo`0ioooo00<0000co`0co`003c?o00030000oooooooo07coool005?oool00ol0VOoo
ooooo`0ioooo00<0000co`0co`003S?o00030000oooooooo07goool005?oool00ol0VOooooooo`0i
oooo0P0000lco`000`000?ooooooo`1moooo001Coooo00?o09Woooooool0>Oooo`030000<ol0<ol0
00hco`000`000?ooooooo`1moooo001Coooo00?o09Woooooool0>Oooo`030000<ol0<ol000hco`00
0`000?ooooooo`1moooo001Coooo00?o09Woooooool0>Oooo`030000<ol0<ol000dco`000`000?oo
ooooo`1noooo001Coooo00?o09Woooooool0<Oooo`@00004oooo00<0000co`0co`003C?o00030000
oooooooo07koool005?oool00ol0VOooooooo`0aoooo00<0003oooooool01Oooo`030000<ol0<ol0
00dco`000`000?ooooooo`1noooo001Coooo00?o09Woooooool0<_ooo`030000oooooooo00Coool3
00003C?o00030000oooooooo07koool005?oool00ol0VOooooooo`0coooo00<0003oooooool00ooo
o`030000<ol0<ol000dco`000`000?ooooooo`1noooo001Coooo00?o09Woooooool0<Oooo`040000
oooooooo00001?ooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001Coooo00?o09Wooooo
ool0<_ooo`800005oooo00<0000co`0co`0033?o00030000oooooooo07ooool005?oool00ol0VOoo
ooooo`0ioooo00<0000co`0co`0033?o00030000oooooooo07ooool005?oool00ol0VOooooooo`0i
oooo00<0000co`0co`0033?o00030000oooooooo07ooool005?oool00ol0VOooooooo`0ioooo0P00
00dco`000`000?ooooooo`1ooooo001Coooo00?o09Woooooool0>Oooo`030000<ol0<ol000`co`00
0`000?ooooooo`1ooooo001Coooo00?o09Woooooool0>Oooo`030000<ol0<ol000/co`000`000?oo
ooooo`20oooo001Coooo00?o09Woooooool0>Oooo`030000<ol0<ol000/co`000`000?ooooooo`20
oooo001Coooo00?o09Woooooool0>Oooo`030000<ol0<ol000/co`000`000?ooooooo`20oooo001C
oooo00?o09Woooooool0>Oooo`030000<ol0<ol000/co`000`000?ooooooo`20oooo001Coooo00?o
09Woooooool0>Oooo`030000<ol0<ol000/co`000`000?ooooooo`20oooo001Coooo00?o09Wooooo
ool0>Oooo`80000<<ol000<0003oooooool0P?ooo`00Doooo`03o`2Ioooooooo03Woool00`0003?o
03?o000;<ol000<0003oooooool0P?ooo`00Doooo`03o`2Ioooooooo03Woool00`0003?o03?o000:
<ol000<0003oooooool0POooo`00Doooo`03o`2Ioooooooo03Woool00`0003?o03?o000:<ol000<0
003oooooool0POooo`00Doooo`03o`2Ioooooooo03Woool00`0003?o03?o000:<ol000<0003ooooo
ool0POooo`00Doooo`03o`2Ioooooooo03Woool00`0003?o03?o000:<ol000<0003oooooool0POoo
o`00Doooo`03o`2Ioooooooo03Woool200002c?o00030000oooooooo087oool005?oool00ol0VOoo
ooooo`0ioooo00<0000co`0co`002S?o00030000oooooooo087oool005?oool00ol0VOooooooo`0i
oooo00<0000co`0co`002S?o00030000oooooooo087oool005?oool00ol0VOooooooo`0ioooo00<0
000co`0co`002C?o00030000oooooooo08;oool005?oool00ol0VOooooooo`0ioooo00<0000co`0c
o`002C?o00030000oooooooo08;oool005?oool00ol0VOooooooo`0ioooo00<0000co`0co`002C?o
00030000oooooooo08;oool005?oool00ol0VOooooooo`0ioooo0P0000Xco`000`000?ooooooo`22
oooo001Coooo00?o09Woooooool0>Oooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001C
oooo00?o09Woooooool0>Oooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001Coooo00?o
09Woooooool0>Oooo`030000<ol0<ol000Pco`000`000?ooooooo`23oooo001Coooo00?o09Wooooo
ool0<_ooo`800005oooo00<0000co`0co`0023?o00030000oooooooo08?oool005?oool00ol0VOoo
ooooo`0aoooo00@0003oooooool00004oooo00<0000co`0co`0023?o00030000oooooooo08?oool0
05?oool00ol0VOooooooo`0coooo00<0003oooooool00oooo`<00008<ol000<0003oooooool0Pooo
o`00Doooo`03o`2Ioooooooo03Coool00`000?ooooooo`02oooo00<0000co`0co`0023?o00030000
oooooooo08?oool005?oool00ol0VOooooooo`0aoooo00@0003oooooool00004oooo00<0000co`0c
o`0023?o00030000oooooooo08?oool005?oool00ol0VOooooooo`0boooo0P0000Goool00`0003?o
03?o0007<ol000<0003oooooool0Q?ooo`00Doooo`03o`2Ioooooooo03Woool00`0003?o03?o0007
<ol000<0003oooooool0Q?ooo`00Doooo`03o`2Ioooooooo03Woool00`0003?o03?o0007<ol000<0
003oooooool0Q?ooo`00Doooo`03o`2Ioooooooo03Woool00`0003?o03?o0007<ol000<0003ooooo
ool0Q?ooo`00Doooo`03o`2Ioooooooo03Woool2000023?o00030000oooooooo08Coool005?oool0
0ol0VOooooooo`0ioooo00<0000co`0co`001c?o00030000oooooooo08Coool005?oool00ol0VOoo
ooooo`0ioooo00<0000co`0co`001c?o00030000oooooooo08Coool005?oool00ol0VOooooooo`0i
oooo00<0000co`0co`001c?o00030000oooooooo08Coool005?oool00ol0VOooooooo`0ioooo00<0
000co`0co`001S?o00030000oooooooo08Goool005?oool00ol0VOooooooo`0ioooo00<0000co`0c
o`001S?o00030000oooooooo08Goool005?oool00ol0VOooooooo`0ioooo0P0000Lco`000`000?oo
ooooo`25oooo001Coooo00?o09Woooooool0>Oooo`030000<ol0<ol000Hco`000`000?ooooooo`25
oooo001Coooo00?o09Woooooool0>Oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001C
oooo00?o09Woooooool0>Oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001Coooo00?o
09Woooooool0>Oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001Coooo00?o09Wooooo
ool0>Oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001Coooo00?o09Woooooool0>Ooo
o`800006<ol000<0003oooooool0Q_ooo`00Doooo`03o`2Ioooooooo03Woool00`0003?o03?o0005
<ol000<0003oooooool0Q_ooo`00Doooo`03o`2Ioooooooo03Woool00`0003?o03?o0005<ol000<0
003oooooool0Q_ooo`00Doooo`03o`2Ioooooooo03Woool00`0003?o03?o0005<ol000<0003ooooo
ool0Q_ooo`00Doooo`03o`2Ioooooooo03Woool00`0003?o03?o0005<ol000<0003oooooool0Q_oo
o`00Doooo`03o`2Ioooooooo03Woool00`0003?o03?o0005<ol000<0003oooooool0Q_ooo`00Dooo
o`03o`2Ioooooooo03Woool200001S?o00030000oooooooo08Koool005?oool00ol0VOooooooo`0i
oooo00<0000co`0co`001C?o00030000oooooooo08Koool005?oool00ol0VOooooooo`0ioooo00<0
000co`0co`001C?o00030000oooooooo08Koool005?oool00ol0VOooooooo`0ioooo00<0000co`0c
o`0013?o00030000oooooooo08Ooool005?oool00ol0VOooooooo`0ioooo00<0000co`0co`0013?o
00030000oooooooo08Ooool005?oool00ol0VOooooooo`0coooo0`0000?oool00`0003?o03?o0004
<ol000<0003oooooool0Qoooo`00Doooo`03o`2Ioooooooo03Coool00`000?ooooooo`02oooo00<0
000co`0co`0013?o00030000oooooooo08Ooool005?oool00ol0VOooooooo`0aoooo1@0000?oool3
000013?o00030000oooooooo08Ooool008Ooool010000?ooooooo`0000Coool7<ol0R_ooo`00R?oo
o`030000oooo000000Coool7<ol0R_ooo`00ROooo`800004oooo1c?o08[oool008ooool7<ol0R_oo
o`00Soooo`Lco`2:oooo001ooooo00<0003oooooool03Oooo`Lco`08oooo00<0003oooooool0Oooo
o`00O_ooo`030000oooooooo00Soool00`000?ooooooo`03oooo1c?o00Woool00`000?ooooooo`1n
oooo001noooo00<0003oooooool00_ooo`800004oooo00<0003oooooool00oooo`@co`02000000@c
o`3oooooooooool200001?ooo`030000oooooooo07koool007koool01@000?ooooooooooo`000002
oooo00<0003oooooool00_ooo`030000oooooooo00;oool3<ol000@0000co`0co`000009oooo00<0
003oooooool0O_ooo`00OOooo`030000oooooooo00;oool00`000?ooooooo`0:oooo0c?o00040000
<ol0<ol000002_ooo`030000oooooooo07goool007koool00`000?ooooooo`0500002Oooo`<co`00
100003?o03?o000000Woool00`000?ooooooo`1noooo001noooo00D0003oooooooooool000003?oo
o`<co`00100003?o03?o000000Woool00`000?ooooooo`1noooo001ooooo00<0003oooooool03Ooo
o`@co`02000000<co`3oooooool01_ooo`030000oooooooo07ooool008ooool7<ol0R_ooo`00Sooo
o`Lco`2:oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.02) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.24141 .12361 L
.25127 .12361 L
.25666 .12361 L
.26171 .12361 L
.26425 .12361 L
.26498 .12361 L
.26568 .12361 L
s
.26568 .12361 m
.2662 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.02) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`09oooo00<0003o09Wo
ool02Oooo`030000oooooooo00Woool00`000?ooooooo`09oooo00<0003oooooool02Oooo`030000
oooooooo00Woool00`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Tco`00
0`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Hco`0R00001_ooo`030000
oooooooo00Woool00`000?ooooooo`0Eoooo000Foooo00<0003oooooool0>_ooo`030000o`2Ioooo
03Woool00`0003?o03?o000i<ol02@0003Coool00`000?ooooooo`0Eoooo001Doooo00?o09Wooooo
ool0>?ooo`030000<ol0<ol003<co`060000EOooo`00E?ooo`03o`2Ioooooooo03Soool00`0003?o
03?o000a<ol00P0005_oool005Coool00ol0VOooooooo`0hoooo00<0000co`0co`00;c?o0080001M
oooo001Doooo00?o09Woooooool0>?ooo`030000<ol0<ol002`co`030000Goooo`00E?ooo`03o`2I
oooooooo03Soool20000:S?o00<0001Roooo001Doooo00?o09Woooooool0>?ooo`030000<ol0<ol0
02Lco`020000IOooo`00E?ooo`03o`2Ioooooooo03Soool00`0003?o03?o000V<ol000<0003ooooo
ool0IOooo`00E?ooo`03o`2Ioooooooo03Soool00`0003?o03?o000U<ol000<0003oooooool0I_oo
o`00E?ooo`03o`2Ioooooooo03Soool00`0003?o03?o000T<ol000<0003oooooool0Ioooo`00E?oo
o`03o`2Ioooooooo03Soool00`0003?o03?o000R<ol00P0006[oool005Coool00ol0VOooooooo`0h
oooo0P00028co`000`000?ooooooo`1Zoooo001Doooo00?o09Woooooool0>?ooo`030000<ol0<ol0
020co`000`000?ooooooo`1[oooo001Doooo00?o09Woooooool0>?ooo`030000<ol0<ol001lco`00
0`000?ooooooo`1/oooo001Doooo00?o09Woooooool0>?ooo`030000<ol0<ol001lco`000`000?oo
ooooo`1/oooo001Doooo00?o09Woooooool0>?ooo`030000<ol0<ol001hco`000`000?ooooooo`1]
oooo001Doooo00?o09Woooooool0>?ooo`030000<ol0<ol001dco`000`000?ooooooo`1^oooo001D
oooo00?o09Woooooool0>?ooo`80000M<ol000<0003oooooool0Koooo`00E?ooo`03o`2Ioooooooo
03Soool00`0003?o03?o000K<ol000<0003oooooool0L?ooo`00E?ooo`03o`2Ioooooooo03Soool0
0`0003?o03?o000K<ol000<0003oooooool0L?ooo`00E?ooo`03o`2Ioooooooo03Soool00`0003?o
03?o000J<ol000<0003oooooool0LOooo`00E?ooo`03o`2Ioooooooo03Soool00`0003?o03?o000J
<ol000<0003oooooool0LOooo`00E?ooo`03o`2Ioooooooo03Soool00`0003?o03?o000I<ol000<0
003oooooool0L_ooo`00E?ooo`03o`2Ioooooooo03Soool200006S?o00030000oooooooo07;oool0
05Coool00ol0VOooooooo`0hoooo00<0000co`0co`0063?o00030000oooooooo07?oool005Coool0
0ol0VOooooooo`0hoooo00<0000co`0co`0063?o00030000oooooooo07?oool005Coool00ol0VOoo
ooooo`0hoooo00<0000co`0co`005c?o00030000oooooooo07Coool005Coool00ol0VOooooooo`0h
oooo00<0000co`0co`005c?o00030000oooooooo07Coool005Coool00ol0VOooooooo`0`oooo1@00
00?oool00`0003?o03?o000F<ol000<0003oooooool0MOooo`00E?ooo`03o`2Ioooooooo03;oool0
0`000?ooooooo`03oooo00<0000co`0co`005S?o00030000oooooooo07Goool005Coool00ol0VOoo
ooooo`0boooo00<0003oooooool00oooo`<0000E<ol000<0003oooooool0M_ooo`00E?ooo`03o`2I
oooooooo03;oool00`000?ooooooo`03oooo00<0000co`0co`005C?o00030000oooooooo07Koool0
05Coool00ol0VOooooooo`0boooo00<0003oooooool00oooo`030000<ol0<ol001Dco`000`000?oo
ooooo`1foooo001Doooo00?o09Woooooool0<Oooo`800005oooo00<0000co`0co`0053?o00030000
oooooooo07Ooool005Coool00ol0VOooooooo`0hoooo00<0000co`0co`0053?o00030000oooooooo
07Ooool005Coool00ol0VOooooooo`0hoooo00<0000co`0co`004c?o00030000oooooooo07Soool0
05Coool00ol0VOooooooo`0hoooo0P0001@co`000`000?ooooooo`1hoooo001Doooo00?o09Wooooo
ool0>?ooo`030000<ol0<ol001<co`000`000?ooooooo`1hoooo001Doooo00?o09Woooooool0>?oo
o`030000<ol0<ol0018co`000`000?ooooooo`1ioooo001Doooo00?o09Woooooool0>?ooo`030000
<ol0<ol0018co`000`000?ooooooo`1ioooo001Doooo00?o09Woooooool0>?ooo`030000<ol0<ol0
018co`000`000?ooooooo`1ioooo001Doooo00?o09Woooooool0>?ooo`030000<ol0<ol0014co`00
0`000?ooooooo`1joooo001Doooo00?o09Woooooool0>?ooo`80000B<ol000<0003oooooool0N_oo
o`00E?ooo`03o`2Ioooooooo03Soool00`0003?o03?o000A<ol000<0003oooooool0N_ooo`00E?oo
o`03o`2Ioooooooo03Soool00`0003?o03?o000A<ol000<0003oooooool0N_ooo`00E?ooo`03o`2I
oooooooo03Soool00`0003?o03?o000@<ol000<0003oooooool0Noooo`00E?ooo`03o`2Ioooooooo
03Soool00`0003?o03?o000@<ol000<0003oooooool0Noooo`00E?ooo`03o`2Ioooooooo03Soool0
0`0003?o03?o000@<ol000<0003oooooool0Noooo`00E?ooo`03o`2Ioooooooo03Soool00`0003?o
03?o000@<ol000<0003oooooool0Noooo`00E?ooo`03o`2Ioooooooo03Soool2000043?o00030000
oooooooo07coool005Coool00ol0VOooooooo`0hoooo00<0000co`0co`003c?o00030000oooooooo
07coool005Coool00ol0VOooooooo`0hoooo00<0000co`0co`003c?o00030000oooooooo07coool0
05Coool00ol0VOooooooo`0hoooo00<0000co`0co`003c?o00030000oooooooo07coool005Coool0
0ol0VOooooooo`0hoooo00<0000co`0co`003c?o00030000oooooooo07coool005Coool00ol0VOoo
ooooo`0hoooo00<0000co`0co`003S?o00030000oooooooo07goool005Coool00ol0VOooooooo`0h
oooo0P0000lco`000`000?ooooooo`1moooo001Doooo00?o09Woooooool0>?ooo`030000<ol0<ol0
00hco`000`000?ooooooo`1moooo001Doooo00?o09Woooooool0>?ooo`030000<ol0<ol000hco`00
0`000?ooooooo`1moooo001Doooo00?o09Woooooool0>?ooo`030000<ol0<ol000dco`000`000?oo
ooooo`1noooo001Doooo00?o09Woooooool0<?ooo`@00004oooo00<0000co`0co`003C?o00030000
oooooooo07koool005Coool00ol0VOooooooo`0`oooo00<0003oooooool01Oooo`030000<ol0<ol0
00dco`000`000?ooooooo`1noooo001Doooo00?o09Woooooool0<Oooo`030000oooooooo00Coool3
00003C?o00030000oooooooo07koool005Coool00ol0VOooooooo`0boooo00<0003oooooool00ooo
o`030000<ol0<ol000dco`000`000?ooooooo`1noooo001Doooo00?o09Woooooool0<?ooo`040000
oooooooo00001?ooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001Doooo00?o09Wooooo
ool0<Oooo`800005oooo00<0000co`0co`0033?o00030000oooooooo07ooool005Coool00ol0VOoo
ooooo`0hoooo00<0000co`0co`0033?o00030000oooooooo07ooool005Coool00ol0VOooooooo`0h
oooo00<0000co`0co`0033?o00030000oooooooo07ooool005Coool00ol0VOooooooo`0hoooo0P00
00dco`000`000?ooooooo`1ooooo001Doooo00?o09Woooooool0>?ooo`030000<ol0<ol000`co`00
0`000?ooooooo`1ooooo001Doooo00?o09Woooooool0>?ooo`030000<ol0<ol000/co`000`000?oo
ooooo`20oooo001Doooo00?o09Woooooool0>?ooo`030000<ol0<ol000/co`000`000?ooooooo`20
oooo001Doooo00?o09Woooooool0>?ooo`030000<ol0<ol000/co`000`000?ooooooo`20oooo001D
oooo00?o09Woooooool0>?ooo`030000<ol0<ol000/co`000`000?ooooooo`20oooo001Doooo00?o
09Woooooool0>?ooo`030000<ol0<ol000/co`000`000?ooooooo`20oooo001Doooo00?o09Wooooo
ool0>?ooo`80000<<ol000<0003oooooool0P?ooo`00E?ooo`03o`2Ioooooooo03Soool00`0003?o
03?o000;<ol000<0003oooooool0P?ooo`00E?ooo`03o`2Ioooooooo03Soool00`0003?o03?o000:
<ol000<0003oooooool0POooo`00E?ooo`03o`2Ioooooooo03Soool00`0003?o03?o000:<ol000<0
003oooooool0POooo`00E?ooo`03o`2Ioooooooo03Soool00`0003?o03?o000:<ol000<0003ooooo
ool0POooo`00E?ooo`03o`2Ioooooooo03Soool00`0003?o03?o000:<ol000<0003oooooool0POoo
o`00E?ooo`03o`2Ioooooooo03Soool200002c?o00030000oooooooo087oool005Coool00ol0VOoo
ooooo`0hoooo00<0000co`0co`002S?o00030000oooooooo087oool005Coool00ol0VOooooooo`0h
oooo00<0000co`0co`002S?o00030000oooooooo087oool005Coool00ol0VOooooooo`0hoooo00<0
000co`0co`002C?o00030000oooooooo08;oool005Coool00ol0VOooooooo`0hoooo00<0000co`0c
o`002C?o00030000oooooooo08;oool005Coool00ol0VOooooooo`0hoooo00<0000co`0co`002C?o
00030000oooooooo08;oool005Coool00ol0VOooooooo`0hoooo0P0000Xco`000`000?ooooooo`22
oooo001Doooo00?o09Woooooool0>?ooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001D
oooo00?o09Woooooool0>?ooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001Doooo00?o
09Woooooool0>?ooo`030000<ol0<ol000Pco`000`000?ooooooo`23oooo001Doooo00?o09Wooooo
ool0<Oooo`800005oooo00<0000co`0co`0023?o00030000oooooooo08?oool005Coool00ol0VOoo
ooooo`0`oooo00@0003oooooool00004oooo00<0000co`0co`0023?o00030000oooooooo08?oool0
05Coool00ol0VOooooooo`0boooo00<0003oooooool00oooo`<00008<ol000<0003oooooool0Pooo
o`00E?ooo`03o`2Ioooooooo03?oool00`000?ooooooo`02oooo00<0000co`0co`0023?o00030000
oooooooo08?oool005Coool00ol0VOooooooo`0`oooo00@0003oooooool00004oooo00<0000co`0c
o`0023?o00030000oooooooo08?oool005Coool00ol0VOooooooo`0aoooo0P0000Goool00`0003?o
03?o0007<ol000<0003oooooool0Q?ooo`00E?ooo`03o`2Ioooooooo03Soool00`0003?o03?o0007
<ol000<0003oooooool0Q?ooo`00E?ooo`03o`2Ioooooooo03Soool00`0003?o03?o0007<ol000<0
003oooooool0Q?ooo`00E?ooo`03o`2Ioooooooo03Soool00`0003?o03?o0007<ol000<0003ooooo
ool0Q?ooo`00E?ooo`03o`2Ioooooooo03Soool2000023?o00030000oooooooo08Coool005Coool0
0ol0VOooooooo`0hoooo00<0000co`0co`001c?o00030000oooooooo08Coool005Coool00ol0VOoo
ooooo`0hoooo00<0000co`0co`001c?o00030000oooooooo08Coool005Coool00ol0VOooooooo`0h
oooo00<0000co`0co`001c?o00030000oooooooo08Coool005Coool00ol0VOooooooo`0hoooo00<0
000co`0co`001S?o00030000oooooooo08Goool005Coool00ol0VOooooooo`0hoooo00<0000co`0c
o`001S?o00030000oooooooo08Goool005Coool00ol0VOooooooo`0hoooo0P0000Lco`000`000?oo
ooooo`25oooo001Doooo00?o09Woooooool0>?ooo`030000<ol0<ol000Hco`000`000?ooooooo`25
oooo001Doooo00?o09Woooooool0>?ooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001D
oooo00?o09Woooooool0>?ooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001Doooo00?o
09Woooooool0>?ooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001Doooo00?o09Wooooo
ool0>?ooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001Doooo00?o09Woooooool0>?oo
o`800006<ol000<0003oooooool0Q_ooo`00E?ooo`03o`2Ioooooooo03Soool00`0003?o03?o0005
<ol000<0003oooooool0Q_ooo`00E?ooo`03o`2Ioooooooo03Soool00`0003?o03?o0005<ol000<0
003oooooool0Q_ooo`00E?ooo`03o`2Ioooooooo03Soool00`0003?o03?o0005<ol000<0003ooooo
ool0Q_ooo`00E?ooo`03o`2Ioooooooo03Soool00`0003?o03?o0005<ol000<0003oooooool0Q_oo
o`00E?ooo`03o`2Ioooooooo03Soool00`0003?o03?o0005<ol000<0003oooooool0Q_ooo`00E?oo
o`03o`2Ioooooooo03Soool200001S?o00030000oooooooo08Koool005Coool00ol0VOooooooo`0h
oooo00<0000co`0co`001C?o00030000oooooooo08Koool005Coool00ol0VOooooooo`0hoooo00<0
000co`0co`001C?o00030000oooooooo08Koool005Coool00ol0VOooooooo`0hoooo00<0000co`0c
o`0013?o00030000oooooooo08Ooool005Coool00ol0VOooooooo`0hoooo00<0000co`0co`0013?o
00030000oooooooo08Ooool005Coool00ol0VOooooooo`0boooo0`0000?oool00`0003?o03?o0004
<ol000<0003oooooool0Qoooo`00E?ooo`03o`2Ioooooooo03?oool00`000?ooooooo`02oooo00<0
000co`0co`0013?o00030000oooooooo08Ooool005Coool00ol0VOooooooo`0`oooo1@0000?oool3
000013?o00030000oooooooo08Ooool008Ooool010000?ooooooo`0000Coool7<ol0R_ooo`00R?oo
o`030000oooo000000Coool7<ol0R_ooo`00ROooo`800004oooo1c?o08[oool008ooool7<ol0R_oo
o`00Soooo`Lco`2:oooo001ioooo00<0003oooooool04oooo`Lco`0>oooo00<0003oooooool0NOoo
o`00N?ooo`030000oooooooo00Soool00`000?ooooooo`09oooo1c?o00ooool00`000?ooooooo`1h
oooo001hoooo00<0003oooooool00_ooo`800004oooo00<0003oooooool01oooo`800004<ol00P00
0004<ol0oooooooooooo0P0000?oool400000oooo`030000oooooooo07Soool007Soool01@000?oo
ooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo00Goool010000?ooooooo`00
00Hco`02oooo00@0003oooooool00002oooo00<0003oooooool01?ooo`030000oooooooo07Soool0
07Ooool00`000?ooooooo`02oooo00<0003oooooool03Oooo`040000oooooooo00001S?o00;oool0
10000?ooooooo`0000?oool00`000?ooooooo`04oooo00<0003oooooool0Moooo`00N?ooo`030000
oooooooo00D0000<oooo00@0003oooooool00006<ol00_ooo`040000oooooooo00001?ooo`030000
oooooooo00;oool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000003oooo`040000
oooooooo00001S?o00;oool010000?ooooooo`0000;oool010000?ooooooo`0000?oool00`000?oo
ooooo`1hoooo001ioooo00<0003oooooool04Oooo`800007<ol00oooo`800004oooo0P0000?oool0
0`000?ooooooo`1ioooo002?oooo1c?o08[oool008ooool7<ol0R_ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.04) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.24141 .12361 L
.25127 .12361 L
.26171 .12361 L
.26698 .12361 L
.26843 .12361 L
.26922 .12361 L
.26998 .12361 L
.27068 .12361 L
s
.27068 .12361 m
.27099 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.04) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`09oooo00<0003ooooo
09T02Oooo`030000oooooooo00Woool00`000?ooooooo`09oooo00<0003oooooool02Oooo`030000
oooooooo00Woool00`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Tco`00
0`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Hco`0R00001_ooo`030000
oooooooo00Woool00`000?ooooooo`0Eoooo000Foooo00<0003oooooool0>_ooo`030000ooooo`2I
03Woool00`0003?o03?o000i<ol02@0003Coool00`000?ooooooo`0Eoooo001Eoooo00?o09Wooooo
ool0=oooo`030000<ol0<ol003<co`060000EOooo`00EOooo`03o`2Ioooooooo03Ooool00`0003?o
03?o000a<ol00P0005_oool005Goool00ol0VOooooooo`0goooo00<0000co`0co`00;c?o0080001M
oooo001Eoooo00?o09Woooooool0=oooo`030000<ol0<ol002`co`030000Goooo`00EOooo`03o`2I
oooooooo03Ooool20000:S?o00<0001Roooo001Eoooo00?o09Woooooool0=oooo`030000<ol0<ol0
02Lco`020000IOooo`00EOooo`03o`2Ioooooooo03Ooool00`0003?o03?o000V<ol000<0003ooooo
ool0IOooo`00EOooo`03o`2Ioooooooo03Ooool00`0003?o03?o000U<ol000<0003oooooool0I_oo
o`00EOooo`03o`2Ioooooooo03Ooool00`0003?o03?o000T<ol000<0003oooooool0Ioooo`00EOoo
o`03o`2Ioooooooo03Ooool00`0003?o03?o000R<ol00P0006[oool005Goool00ol0VOooooooo`0g
oooo0P00028co`000`000?ooooooo`1Zoooo001Eoooo00?o09Woooooool0=oooo`030000<ol0<ol0
020co`000`000?ooooooo`1[oooo001Eoooo00?o09Woooooool0=oooo`030000<ol0<ol001lco`00
0`000?ooooooo`1/oooo001Eoooo00?o09Woooooool0=oooo`030000<ol0<ol001lco`000`000?oo
ooooo`1/oooo001Eoooo00?o09Woooooool0=oooo`030000<ol0<ol001hco`000`000?ooooooo`1]
oooo001Eoooo00?o09Woooooool0=oooo`030000<ol0<ol001dco`000`000?ooooooo`1^oooo001E
oooo00?o09Woooooool0=oooo`80000M<ol000<0003oooooool0Koooo`00EOooo`03o`2Ioooooooo
03Ooool00`0003?o03?o000K<ol000<0003oooooool0L?ooo`00EOooo`03o`2Ioooooooo03Ooool0
0`0003?o03?o000K<ol000<0003oooooool0L?ooo`00EOooo`03o`2Ioooooooo03Ooool00`0003?o
03?o000J<ol000<0003oooooool0LOooo`00EOooo`03o`2Ioooooooo03Ooool00`0003?o03?o000J
<ol000<0003oooooool0LOooo`00EOooo`03o`2Ioooooooo03Ooool00`0003?o03?o000I<ol000<0
003oooooool0L_ooo`00EOooo`03o`2Ioooooooo03Ooool200006S?o00030000oooooooo07;oool0
05Goool00ol0VOooooooo`0goooo00<0000co`0co`0063?o00030000oooooooo07?oool005Goool0
0ol0VOooooooo`0goooo00<0000co`0co`0063?o00030000oooooooo07?oool005Goool00ol0VOoo
ooooo`0goooo00<0000co`0co`005c?o00030000oooooooo07Coool005Goool00ol0VOooooooo`0g
oooo00<0000co`0co`005c?o00030000oooooooo07Coool005Goool00ol0VOooooooo`0_oooo1@00
00?oool00`0003?o03?o000F<ol000<0003oooooool0MOooo`00EOooo`03o`2Ioooooooo037oool0
0`000?ooooooo`03oooo00<0000co`0co`005S?o00030000oooooooo07Goool005Goool00ol0VOoo
ooooo`0aoooo00<0003oooooool00oooo`<0000E<ol000<0003oooooool0M_ooo`00EOooo`03o`2I
oooooooo037oool00`000?ooooooo`03oooo00<0000co`0co`005C?o00030000oooooooo07Koool0
05Goool00ol0VOooooooo`0aoooo00<0003oooooool00oooo`030000<ol0<ol001Dco`000`000?oo
ooooo`1foooo001Eoooo00?o09Woooooool0<?ooo`800005oooo00<0000co`0co`0053?o00030000
oooooooo07Ooool005Goool00ol0VOooooooo`0goooo00<0000co`0co`0053?o00030000oooooooo
07Ooool005Goool00ol0VOooooooo`0goooo00<0000co`0co`004c?o00030000oooooooo07Soool0
05Goool00ol0VOooooooo`0goooo0P0001@co`000`000?ooooooo`1hoooo001Eoooo00?o09Wooooo
ool0=oooo`030000<ol0<ol001<co`000`000?ooooooo`1hoooo001Eoooo00?o09Woooooool0=ooo
o`030000<ol0<ol0018co`000`000?ooooooo`1ioooo001Eoooo00?o09Woooooool0=oooo`030000
<ol0<ol0018co`000`000?ooooooo`1ioooo001Eoooo00?o09Woooooool0=oooo`030000<ol0<ol0
018co`000`000?ooooooo`1ioooo001Eoooo00?o09Woooooool0=oooo`030000<ol0<ol0014co`00
0`000?ooooooo`1joooo001Eoooo00?o09Woooooool0=oooo`80000B<ol000<0003oooooool0N_oo
o`00EOooo`03o`2Ioooooooo03Ooool00`0003?o03?o000A<ol000<0003oooooool0N_ooo`00EOoo
o`03o`2Ioooooooo03Ooool00`0003?o03?o000A<ol000<0003oooooool0N_ooo`00EOooo`03o`2I
oooooooo03Ooool00`0003?o03?o000@<ol000<0003oooooool0Noooo`00EOooo`03o`2Ioooooooo
03Ooool00`0003?o03?o000@<ol000<0003oooooool0Noooo`00EOooo`03o`2Ioooooooo03Ooool0
0`0003?o03?o000@<ol000<0003oooooool0Noooo`00EOooo`03o`2Ioooooooo03Ooool00`0003?o
03?o000@<ol000<0003oooooool0Noooo`00EOooo`03o`2Ioooooooo03Ooool2000043?o00030000
oooooooo07coool005Goool00ol0VOooooooo`0goooo00<0000co`0co`003c?o00030000oooooooo
07coool005Goool00ol0VOooooooo`0goooo00<0000co`0co`003c?o00030000oooooooo07coool0
05Goool00ol0VOooooooo`0goooo00<0000co`0co`003c?o00030000oooooooo07coool005Goool0
0ol0VOooooooo`0goooo00<0000co`0co`003c?o00030000oooooooo07coool005Goool00ol0VOoo
ooooo`0goooo00<0000co`0co`003S?o00030000oooooooo07goool005Goool00ol0VOooooooo`0g
oooo0P0000lco`000`000?ooooooo`1moooo001Eoooo00?o09Woooooool0=oooo`030000<ol0<ol0
00hco`000`000?ooooooo`1moooo001Eoooo00?o09Woooooool0=oooo`030000<ol0<ol000hco`00
0`000?ooooooo`1moooo001Eoooo00?o09Woooooool0=oooo`030000<ol0<ol000dco`000`000?oo
ooooo`1noooo001Eoooo00?o09Woooooool0;oooo`@00004oooo00<0000co`0co`003C?o00030000
oooooooo07koool005Goool00ol0VOooooooo`0_oooo00<0003oooooool01Oooo`030000<ol0<ol0
00dco`000`000?ooooooo`1noooo001Eoooo00?o09Woooooool0<?ooo`030000oooooooo00Coool3
00003C?o00030000oooooooo07koool005Goool00ol0VOooooooo`0aoooo00<0003oooooool00ooo
o`030000<ol0<ol000dco`000`000?ooooooo`1noooo001Eoooo00?o09Woooooool0;oooo`040000
oooooooo00001?ooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001Eoooo00?o09Wooooo
ool0<?ooo`800005oooo00<0000co`0co`0033?o00030000oooooooo07ooool005Goool00ol0VOoo
ooooo`0goooo00<0000co`0co`0033?o00030000oooooooo07ooool005Goool00ol0VOooooooo`0g
oooo00<0000co`0co`0033?o00030000oooooooo07ooool005Goool00ol0VOooooooo`0goooo0P00
00dco`000`000?ooooooo`1ooooo001Eoooo00?o09Woooooool0=oooo`030000<ol0<ol000`co`00
0`000?ooooooo`1ooooo001Eoooo00?o09Woooooool0=oooo`030000<ol0<ol000/co`000`000?oo
ooooo`20oooo001Eoooo00?o09Woooooool0=oooo`030000<ol0<ol000/co`000`000?ooooooo`20
oooo001Eoooo00?o09Woooooool0=oooo`030000<ol0<ol000/co`000`000?ooooooo`20oooo001E
oooo00?o09Woooooool0=oooo`030000<ol0<ol000/co`000`000?ooooooo`20oooo001Eoooo00?o
09Woooooool0=oooo`030000<ol0<ol000/co`000`000?ooooooo`20oooo001Eoooo00?o09Wooooo
ool0=oooo`80000<<ol000<0003oooooool0P?ooo`00EOooo`03o`2Ioooooooo03Ooool00`0003?o
03?o000;<ol000<0003oooooool0P?ooo`00EOooo`03o`2Ioooooooo03Ooool00`0003?o03?o000:
<ol000<0003oooooool0POooo`00EOooo`03o`2Ioooooooo03Ooool00`0003?o03?o000:<ol000<0
003oooooool0POooo`00EOooo`03o`2Ioooooooo03Ooool00`0003?o03?o000:<ol000<0003ooooo
ool0POooo`00EOooo`03o`2Ioooooooo03Ooool00`0003?o03?o000:<ol000<0003oooooool0POoo
o`00EOooo`03o`2Ioooooooo03Ooool200002c?o00030000oooooooo087oool005Goool00ol0VOoo
ooooo`0goooo00<0000co`0co`002S?o00030000oooooooo087oool005Goool00ol0VOooooooo`0g
oooo00<0000co`0co`002S?o00030000oooooooo087oool005Goool00ol0VOooooooo`0goooo00<0
000co`0co`002C?o00030000oooooooo08;oool005Goool00ol0VOooooooo`0goooo00<0000co`0c
o`002C?o00030000oooooooo08;oool005Goool00ol0VOooooooo`0goooo00<0000co`0co`002C?o
00030000oooooooo08;oool005Goool00ol0VOooooooo`0goooo0P0000Xco`000`000?ooooooo`22
oooo001Eoooo00?o09Woooooool0=oooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001E
oooo00?o09Woooooool0=oooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001Eoooo00?o
09Woooooool0=oooo`030000<ol0<ol000Pco`000`000?ooooooo`23oooo001Eoooo00?o09Wooooo
ool0<?ooo`800005oooo00<0000co`0co`0023?o00030000oooooooo08?oool005Goool00ol0VOoo
ooooo`0_oooo00@0003oooooool00004oooo00<0000co`0co`0023?o00030000oooooooo08?oool0
05Goool00ol0VOooooooo`0aoooo00<0003oooooool00oooo`<00008<ol000<0003oooooool0Pooo
o`00EOooo`03o`2Ioooooooo03;oool00`000?ooooooo`02oooo00<0000co`0co`0023?o00030000
oooooooo08?oool005Goool00ol0VOooooooo`0_oooo00@0003oooooool00004oooo00<0000co`0c
o`0023?o00030000oooooooo08?oool005Goool00ol0VOooooooo`0`oooo0P0000Goool00`0003?o
03?o0007<ol000<0003oooooool0Q?ooo`00EOooo`03o`2Ioooooooo03Ooool00`0003?o03?o0007
<ol000<0003oooooool0Q?ooo`00EOooo`03o`2Ioooooooo03Ooool00`0003?o03?o0007<ol000<0
003oooooool0Q?ooo`00EOooo`03o`2Ioooooooo03Ooool00`0003?o03?o0007<ol000<0003ooooo
ool0Q?ooo`00EOooo`03o`2Ioooooooo03Ooool2000023?o00030000oooooooo08Coool005Goool0
0ol0VOooooooo`0goooo00<0000co`0co`001c?o00030000oooooooo08Coool005Goool00ol0VOoo
ooooo`0goooo00<0000co`0co`001c?o00030000oooooooo08Coool005Goool00ol0VOooooooo`0g
oooo00<0000co`0co`001c?o00030000oooooooo08Coool005Goool00ol0VOooooooo`0goooo00<0
000co`0co`001S?o00030000oooooooo08Goool005Goool00ol0VOooooooo`0goooo00<0000co`0c
o`001S?o00030000oooooooo08Goool005Goool00ol0VOooooooo`0goooo0P0000Lco`000`000?oo
ooooo`25oooo001Eoooo00?o09Woooooool0=oooo`030000<ol0<ol000Hco`000`000?ooooooo`25
oooo001Eoooo00?o09Woooooool0=oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001E
oooo00?o09Woooooool0=oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001Eoooo00?o
09Woooooool0=oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001Eoooo00?o09Wooooo
ool0=oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001Eoooo00?o09Woooooool0=ooo
o`800006<ol000<0003oooooool0Q_ooo`00EOooo`03o`2Ioooooooo03Ooool00`0003?o03?o0005
<ol000<0003oooooool0Q_ooo`00EOooo`03o`2Ioooooooo03Ooool00`0003?o03?o0005<ol000<0
003oooooool0Q_ooo`00EOooo`03o`2Ioooooooo03Ooool00`0003?o03?o0005<ol000<0003ooooo
ool0Q_ooo`00EOooo`03o`2Ioooooooo03Ooool00`0003?o03?o0005<ol000<0003oooooool0Q_oo
o`00EOooo`03o`2Ioooooooo03Ooool00`0003?o03?o0005<ol000<0003oooooool0Q_ooo`00EOoo
o`03o`2Ioooooooo03Ooool200001S?o00030000oooooooo08Koool005Goool00ol0VOooooooo`0g
oooo00<0000co`0co`001C?o00030000oooooooo08Koool005Goool00ol0VOooooooo`0goooo00<0
000co`0co`001C?o00030000oooooooo08Koool005Goool00ol0VOooooooo`0goooo00<0000co`0c
o`0013?o00030000oooooooo08Ooool005Goool00ol0VOooooooo`0goooo00<0000co`0co`0013?o
00030000oooooooo08Ooool005Goool00ol0VOooooooo`0aoooo0`0000?oool00`0003?o03?o0004
<ol000<0003oooooool0Qoooo`00EOooo`03o`2Ioooooooo03;oool00`000?ooooooo`02oooo00<0
000co`0co`0013?o00030000oooooooo08Ooool005Goool00ol0VOooooooo`0_oooo1@0000?oool3
000013?o00030000oooooooo08Ooool008Ooool010000?ooooooo`0000Coool7<ol0R_ooo`00R?oo
o`030000oooo000000Coool7<ol0R_ooo`00ROooo`800004oooo1c?o08[oool008ooool7<ol0R_oo
o`00Soooo`Lco`2:oooo001ioooo00<0003oooooool04oooo`Lco`0>oooo00<0003oooooool0NOoo
o`00N?ooo`030000oooooooo00Soool00`000?ooooooo`09oooo1c?o00ooool00`000?ooooooo`1h
oooo001hoooo00<0003oooooool00_ooo`800004oooo00<0003oooooool01oooo`800004<ol00P00
0004<ol0oooooooooooo0P0000Goool300000_ooo`030000oooooooo07Soool007Soool01@000?oo
ooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo00Goool010000?ooooooo`00
00Hco`02oooo00@0003oooooool00005oooo00D0003oooooooooool00000N_ooo`00Moooo`030000
oooooooo00;oool00`000?ooooooo`0=oooo00@0003oooooool00006<ol00_ooo`040000oooooooo
00000_ooo`D00003oooo00<0003oooooool0Moooo`00N?ooo`030000oooooooo00D0000<oooo00@0
003oooooool00006<ol00_ooo`040000oooooooo00000_ooo`040000oooooooo00000oooo`030000
oooooooo07Soool007Soool01@000?ooooooooooo`00000?oooo00@0003oooooool00006<ol00_oo
o`040000oooooooo00000oooo`030000oooo000000?oool00`000?ooooooo`1hoooo001ioooo00<0
003oooooool04Oooo`800007<ol00oooo`800005oooo0P0000;oool00`000?ooooooo`1ioooo002?
oooo1c?o08[oool008ooool7<ol0R_ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.06) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.24141 .12361 L
.26171 .12361 L
.26709 .12361 L
.27003 .12361 L
.27279 .12361 L
.27399 .12361 L
.27513 .12361 L
s
.27513 .12361 m
.27566 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.06) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`09oooo00@0003ooooo
oooo09T8oooo00<0003oooooool02Oooo`030000oooooooo00Woool00`000?ooooooo`09oooo00<0
003oooooool02Oooo`030000<ol0<ol000Tco`000`0003?o03?o0009<ol000<0000co`0co`002C?o
00030000<ol0<ol000Tco`000`0003?o03?o0009<ol000<0000co`0co`001S?o02800006oooo00<0
003oooooool02Oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0joooo00@0003ooooo
oooo09Thoooo00<0000co`0co`00>C?o00T0000doooo00<0003oooooool05Oooo`00E_ooo`03o`2I
oooooooo03Koool00`0003?o03?o000c<ol01P0005Goool005Koool00ol0VOooooooo`0foooo00<0
000co`0co`00<C?o0080001Koooo001Foooo00?o09Woooooool0=_ooo`030000<ol0<ol002lco`02
0000GOooo`00E_ooo`03o`2Ioooooooo03Koool00`0003?o03?o000/<ol00`0005ooool005Koool0
0ol0VOooooooo`0foooo0P0002Xco`030000H_ooo`00E_ooo`03o`2Ioooooooo03Koool00`0003?o
03?o000W<ol00P0006Goool005Koool00ol0VOooooooo`0foooo00<0000co`0co`009S?o00030000
oooooooo06Goool005Koool00ol0VOooooooo`0foooo00<0000co`0co`009C?o00030000oooooooo
06Koool005Koool00ol0VOooooooo`0foooo00<0000co`0co`0093?o00030000oooooooo06Ooool0
05Koool00ol0VOooooooo`0foooo00<0000co`0co`008S?o0080001Zoooo001Foooo00?o09Wooooo
ool0=_ooo`80000R<ol000<0003oooooool0J_ooo`00E_ooo`03o`2Ioooooooo03Koool00`0003?o
03?o000P<ol000<0003oooooool0Joooo`00E_ooo`03o`2Ioooooooo03Koool00`0003?o03?o000O
<ol000<0003oooooool0K?ooo`00E_ooo`03o`2Ioooooooo03Koool00`0003?o03?o000O<ol000<0
003oooooool0K?ooo`00E_ooo`03o`2Ioooooooo03Koool00`0003?o03?o000N<ol000<0003ooooo
ool0KOooo`00E_ooo`03o`2Ioooooooo03Koool00`0003?o03?o000M<ol000<0003oooooool0K_oo
o`00E_ooo`03o`2Ioooooooo03Koool200007C?o00030000oooooooo06ooool005Koool00ol0VOoo
ooooo`0foooo00<0000co`0co`006c?o00030000oooooooo073oool005Koool00ol0VOooooooo`0f
oooo00<0000co`0co`006c?o00030000oooooooo073oool005Koool00ol0VOooooooo`0foooo00<0
000co`0co`006S?o00030000oooooooo077oool005Koool00ol0VOooooooo`0foooo00<0000co`0c
o`006S?o00030000oooooooo077oool005Koool00ol0VOooooooo`0foooo00<0000co`0co`006C?o
00030000oooooooo07;oool005Koool00ol0VOooooooo`0foooo0P0001Xco`000`000?ooooooo`1b
oooo001Foooo00?o09Woooooool0=_ooo`030000<ol0<ol001Pco`000`000?ooooooo`1coooo001F
oooo00?o09Woooooool0=_ooo`030000<ol0<ol001Pco`000`000?ooooooo`1coooo001Foooo00?o
09Woooooool0=_ooo`030000<ol0<ol001Lco`000`000?ooooooo`1doooo001Foooo00?o09Wooooo
ool0=_ooo`030000<ol0<ol001Lco`000`000?ooooooo`1doooo001Foooo00?o09Woooooool0;_oo
o`D00003oooo00<0000co`0co`005S?o00030000oooooooo07Goool005Koool00ol0VOooooooo`0`
oooo00<0003oooooool00oooo`030000<ol0<ol001Hco`000`000?ooooooo`1eoooo001Foooo00?o
09Woooooool0<?ooo`030000oooooooo00?oool300005C?o00030000oooooooo07Koool005Koool0
0ol0VOooooooo`0`oooo00<0003oooooool00oooo`030000<ol0<ol001Dco`000`000?ooooooo`1f
oooo001Foooo00?o09Woooooool0<?ooo`030000oooooooo00?oool00`0003?o03?o000E<ol000<0
003oooooool0M_ooo`00E_ooo`03o`2Ioooooooo02ooool200001Oooo`030000<ol0<ol001@co`00
0`000?ooooooo`1goooo001Foooo00?o09Woooooool0=_ooo`030000<ol0<ol001@co`000`000?oo
ooooo`1goooo001Foooo00?o09Woooooool0=_ooo`030000<ol0<ol001<co`000`000?ooooooo`1h
oooo001Foooo00?o09Woooooool0=_ooo`80000D<ol000<0003oooooool0N?ooo`00E_ooo`03o`2I
oooooooo03Koool00`0003?o03?o000C<ol000<0003oooooool0N?ooo`00E_ooo`03o`2Ioooooooo
03Koool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00E_ooo`03o`2Ioooooooo03Koool0
0`0003?o03?o000B<ol000<0003oooooool0NOooo`00E_ooo`03o`2Ioooooooo03Koool00`0003?o
03?o000B<ol000<0003oooooool0NOooo`00E_ooo`03o`2Ioooooooo03Koool00`0003?o03?o000A
<ol000<0003oooooool0N_ooo`00E_ooo`03o`2Ioooooooo03Koool200004S?o00030000oooooooo
07[oool005Koool00ol0VOooooooo`0foooo00<0000co`0co`004C?o00030000oooooooo07[oool0
05Koool00ol0VOooooooo`0foooo00<0000co`0co`004C?o00030000oooooooo07[oool005Koool0
0ol0VOooooooo`0foooo00<0000co`0co`0043?o00030000oooooooo07_oool005Koool00ol0VOoo
ooooo`0foooo00<0000co`0co`0043?o00030000oooooooo07_oool005Koool00ol0VOooooooo`0f
oooo00<0000co`0co`0043?o00030000oooooooo07_oool005Koool00ol0VOooooooo`0foooo00<0
000co`0co`0043?o00030000oooooooo07_oool005Koool00ol0VOooooooo`0foooo0P00010co`00
0`000?ooooooo`1loooo001Foooo00?o09Woooooool0=_ooo`030000<ol0<ol000lco`000`000?oo
ooooo`1loooo001Foooo00?o09Woooooool0=_ooo`030000<ol0<ol000lco`000`000?ooooooo`1l
oooo001Foooo00?o09Woooooool0=_ooo`030000<ol0<ol000lco`000`000?ooooooo`1loooo001F
oooo00?o09Woooooool0=_ooo`030000<ol0<ol000lco`000`000?ooooooo`1loooo001Foooo00?o
09Woooooool0=_ooo`030000<ol0<ol000hco`000`000?ooooooo`1moooo001Foooo00?o09Wooooo
ool0=_ooo`80000?<ol000<0003oooooool0OOooo`00E_ooo`03o`2Ioooooooo03Koool00`0003?o
03?o000><ol000<0003oooooool0OOooo`00E_ooo`03o`2Ioooooooo03Koool00`0003?o03?o000>
<ol000<0003oooooool0OOooo`00E_ooo`03o`2Ioooooooo03Koool00`0003?o03?o000=<ol000<0
003oooooool0O_ooo`00E_ooo`03o`2Ioooooooo02koool400001?ooo`030000<ol0<ol000dco`00
0`000?ooooooo`1noooo001Foooo00?o09Woooooool0;_ooo`030000oooooooo00Goool00`0003?o
03?o000=<ol000<0003oooooool0O_ooo`00E_ooo`03o`2Ioooooooo02ooool00`000?ooooooo`04
oooo0`0000dco`000`000?ooooooo`1noooo001Foooo00?o09Woooooool0<?ooo`030000oooooooo
00?oool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00E_ooo`03o`2Ioooooooo02koool0
10000?ooooooo`0000Coool00`0003?o03?o000<<ol000<0003oooooool0Ooooo`00E_ooo`03o`2I
oooooooo02ooool200001Oooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001Foooo00?o
09Woooooool0=_ooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001Foooo00?o09Wooooo
ool0=_ooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001Foooo00?o09Woooooool0=_oo
o`80000=<ol000<0003oooooool0Ooooo`00E_ooo`03o`2Ioooooooo03Koool00`0003?o03?o000<
<ol000<0003oooooool0Ooooo`00E_ooo`03o`2Ioooooooo03Koool00`0003?o03?o000;<ol000<0
003oooooool0P?ooo`00E_ooo`03o`2Ioooooooo03Koool00`0003?o03?o000;<ol000<0003ooooo
ool0P?ooo`00E_ooo`03o`2Ioooooooo03Koool00`0003?o03?o000;<ol000<0003oooooool0P?oo
o`00E_ooo`03o`2Ioooooooo03Koool00`0003?o03?o000;<ol000<0003oooooool0P?ooo`00E_oo
o`03o`2Ioooooooo03Koool00`0003?o03?o000;<ol000<0003oooooool0P?ooo`00E_ooo`03o`2I
oooooooo03Koool2000033?o00030000oooooooo083oool005Koool00ol0VOooooooo`0foooo00<0
000co`0co`002c?o00030000oooooooo083oool005Koool00ol0VOooooooo`0foooo00<0000co`0c
o`002S?o00030000oooooooo087oool005Koool00ol0VOooooooo`0foooo00<0000co`0co`002S?o
00030000oooooooo087oool005Koool00ol0VOooooooo`0foooo00<0000co`0co`002S?o00030000
oooooooo087oool005Koool00ol0VOooooooo`0foooo00<0000co`0co`002S?o00030000oooooooo
087oool005Koool00ol0VOooooooo`0foooo0P0000/co`000`000?ooooooo`21oooo001Foooo00?o
09Woooooool0=_ooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001Foooo00?o09Wooooo
ool0=_ooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001Foooo00?o09Woooooool0=_oo
o`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001Foooo00?o09Woooooool0=_ooo`030000
<ol0<ol000Tco`000`000?ooooooo`22oooo001Foooo00?o09Woooooool0=_ooo`030000<ol0<ol0
00Tco`000`000?ooooooo`22oooo001Foooo00?o09Woooooool0=_ooo`80000:<ol000<0003ooooo
ool0P_ooo`00E_ooo`03o`2Ioooooooo03Koool00`0003?o03?o0009<ol000<0003oooooool0P_oo
o`00E_ooo`03o`2Ioooooooo03Koool00`0003?o03?o0009<ol000<0003oooooool0P_ooo`00E_oo
o`03o`2Ioooooooo03Koool00`0003?o03?o0008<ol000<0003oooooool0Poooo`00E_ooo`03o`2I
oooooooo02ooool200001Oooo`030000<ol0<ol000Pco`000`000?ooooooo`23oooo001Foooo00?o
09Woooooool0;_ooo`040000oooooooo00001?ooo`030000<ol0<ol000Pco`000`000?ooooooo`23
oooo001Foooo00?o09Woooooool0<?ooo`030000oooooooo00?oool3000023?o00030000oooooooo
08?oool005Koool00ol0VOooooooo`0aoooo00<0003oooooool00_ooo`030000<ol0<ol000Pco`00
0`000?ooooooo`23oooo001Foooo00?o09Woooooool0;_ooo`040000oooooooo00001?ooo`030000
<ol0<ol000Pco`000`000?ooooooo`23oooo001Foooo00?o09Woooooool0;oooo`800005oooo00<0
000co`0co`001c?o00030000oooooooo08Coool005Koool00ol0VOooooooo`0foooo00<0000co`0c
o`001c?o00030000oooooooo08Coool005Koool00ol0VOooooooo`0foooo00<0000co`0co`001c?o
00030000oooooooo08Coool005Koool00ol0VOooooooo`0foooo00<0000co`0co`001c?o00030000
oooooooo08Coool005Koool00ol0VOooooooo`0foooo0P0000Pco`000`000?ooooooo`24oooo001F
oooo00?o09Woooooool0=_ooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001Foooo00?o
09Woooooool0=_ooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001Foooo00?o09Wooooo
ool0=_ooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001Foooo00?o09Woooooool0=_oo
o`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001Foooo00?o09Woooooool0=_ooo`030000
<ol0<ol000Hco`000`000?ooooooo`25oooo001Foooo00?o09Woooooool0=_ooo`800007<ol000<0
003oooooool0QOooo`00E_ooo`03o`2Ioooooooo03Koool00`0003?o03?o0006<ol000<0003ooooo
ool0QOooo`00E_ooo`03o`2Ioooooooo03Koool00`0003?o03?o0006<ol000<0003oooooool0QOoo
o`00E_ooo`03o`2Ioooooooo03Koool00`0003?o03?o0006<ol000<0003oooooool0QOooo`00E_oo
o`03o`2Ioooooooo03Koool00`0003?o03?o0006<ol000<0003oooooool0QOooo`00E_ooo`03o`2I
oooooooo03Koool00`0003?o03?o0006<ol000<0003oooooool0QOooo`00E_ooo`03o`2Ioooooooo
03Koool200001S?o00030000oooooooo08Koool005Koool00ol0VOooooooo`0foooo00<0000co`0c
o`001C?o00030000oooooooo08Koool005Koool00ol0VOooooooo`0foooo00<0000co`0co`001C?o
00030000oooooooo08Koool005Koool00ol0VOooooooo`0foooo00<0000co`0co`001C?o00030000
oooooooo08Koool005Koool00ol0VOooooooo`0foooo00<0000co`0co`001C?o00030000oooooooo
08Koool005Koool00ol0VOooooooo`0foooo00<0000co`0co`001C?o00030000oooooooo08Koool0
05Koool00ol0VOooooooo`0foooo0P0000Hco`000`000?ooooooo`26oooo001Foooo00?o09Wooooo
ool0=_ooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001Foooo00?o09Woooooool0=_oo
o`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001Foooo00?o09Woooooool0=_ooo`030000
<ol0<ol000@co`000`000?ooooooo`27oooo001Foooo00?o09Woooooool0=_ooo`030000<ol0<ol0
00@co`000`000?ooooooo`27oooo001Foooo00?o09Woooooool0<?ooo`<00003oooo00<0000co`0c
o`0013?o00030000oooooooo08Ooool005Koool00ol0VOooooooo`0aoooo00<0003oooooool00_oo
o`030000<ol0<ol000@co`000`000?ooooooo`27oooo001Foooo00?o09Woooooool0;_ooo`D00003
oooo0`0000@co`000`000?ooooooo`27oooo0027oooo00@0003oooooool00004oooo1c?o08[oool0
08Soool00`000?ooo`000004oooo1c?o08[oool008Woool200001?ooo`Lco`2:oooo002?oooo1c?o
08[oool008ooool7<ol0R_ooo`00NOooo`030000oooooooo01?oool7<ol03_ooo`030000oooooooo
07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool02Oooo`Lco`0?oooo00<0003ooooo
ool0N?ooo`00N?ooo`030000oooooooo00;oool200001?ooo`030000oooooooo00Ooool2000013?o
0080000013?o0?ooooooooooo`800003oooo0`0000Coool00`000?ooooooo`1hoooo001hoooo00D0
003oooooooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`05oooo00@0003ooooo
ool00006<ol00_ooo`040000oooooooo00000_ooo`040000oooooooo00000oooo`030000oooooooo
07Soool007Ooool00`000?ooooooo`02oooo00<0003oooooool03Oooo`040000oooooooo00001S?o
00;oool010000?ooooooo`0000;oool010000?ooooooo`0000Coool00`000?ooooooo`1goooo001h
oooo00<0003oooooool01@0000coool010000?ooooooo`0000Hco`02oooo00@0003oooooool00002
oooo0`0000Coool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000003oooo`040000
oooooooo00001S?o00;oool010000?ooooooo`0000?oool00`000?ooooooo`03oooo00<0003ooooo
ool0N?ooo`00NOooo`030000oooooooo017oool200001c?o00?oool200001?ooo`<00002oooo00<0
003oooooool0NOooo`00Soooo`Lco`2:oooo002?oooo1c?o08[oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.08) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.24141 .12361 L
.26171 .12361 L
.26709 .12361 L
.27279 .12361 L
.27765 .12361 L
.27899 .12361 L
.27972 .12361 L
.28042 .12361 L
s
.28042 .12361 m
.28068 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.08) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`09oooo00D0003ooooo
oooooooo09T01oooo`030000oooooooo00Woool00`000?ooooooo`09oooo00<0003oooooool02Ooo
o`030000oooooooo00Woool00`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol0
00Tco`000`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Hco`0R00001_oo
o`030000oooooooo00Woool00`000?ooooooo`0Eoooo000Foooo00<0003oooooool0>_ooo`050000
ooooooooooooo`2I03Ooool00`0003?o03?o000i<ol02@0003Coool00`000?ooooooo`0Eoooo001G
oooo00?o09Woooooool0=Oooo`030000<ol0<ol003<co`060000EOooo`00Eoooo`03o`2Ioooooooo
03Goool00`0003?o03?o000a<ol00P0005_oool005Ooool00ol0VOooooooo`0eoooo00<0000co`0c
o`00;c?o0080001Moooo001Goooo00?o09Woooooool0=Oooo`030000<ol0<ol002`co`030000Gooo
o`00Eoooo`03o`2Ioooooooo03Goool20000:S?o00<0001Roooo001Goooo00?o09Woooooool0=Ooo
o`030000<ol0<ol002Lco`020000IOooo`00Eoooo`03o`2Ioooooooo03Goool00`0003?o03?o000V
<ol000<0003oooooool0IOooo`00Eoooo`03o`2Ioooooooo03Goool00`0003?o03?o000U<ol000<0
003oooooool0I_ooo`00Eoooo`03o`2Ioooooooo03Goool00`0003?o03?o000T<ol000<0003ooooo
ool0Ioooo`00Eoooo`03o`2Ioooooooo03Goool00`0003?o03?o000R<ol00P0006[oool005Ooool0
0ol0VOooooooo`0eoooo0P00028co`000`000?ooooooo`1Zoooo001Goooo00?o09Woooooool0=Ooo
o`030000<ol0<ol0020co`000`000?ooooooo`1[oooo001Goooo00?o09Woooooool0=Oooo`030000
<ol0<ol001lco`000`000?ooooooo`1/oooo001Goooo00?o09Woooooool0=Oooo`030000<ol0<ol0
01lco`000`000?ooooooo`1/oooo001Goooo00?o09Woooooool0=Oooo`030000<ol0<ol001hco`00
0`000?ooooooo`1]oooo001Goooo00?o09Woooooool0=Oooo`030000<ol0<ol001dco`000`000?oo
ooooo`1^oooo001Goooo00?o09Woooooool0=Oooo`80000M<ol000<0003oooooool0Koooo`00Eooo
o`03o`2Ioooooooo03Goool00`0003?o03?o000K<ol000<0003oooooool0L?ooo`00Eoooo`03o`2I
oooooooo03Goool00`0003?o03?o000K<ol000<0003oooooool0L?ooo`00Eoooo`03o`2Ioooooooo
03Goool00`0003?o03?o000J<ol000<0003oooooool0LOooo`00Eoooo`03o`2Ioooooooo03Goool0
0`0003?o03?o000J<ol000<0003oooooool0LOooo`00Eoooo`03o`2Ioooooooo03Goool00`0003?o
03?o000I<ol000<0003oooooool0L_ooo`00Eoooo`03o`2Ioooooooo03Goool200006S?o00030000
oooooooo07;oool005Ooool00ol0VOooooooo`0eoooo00<0000co`0co`0063?o00030000oooooooo
07?oool005Ooool00ol0VOooooooo`0eoooo00<0000co`0co`0063?o00030000oooooooo07?oool0
05Ooool00ol0VOooooooo`0eoooo00<0000co`0co`005c?o00030000oooooooo07Coool005Ooool0
0ol0VOooooooo`0eoooo00<0000co`0co`005c?o00030000oooooooo07Coool005Ooool00ol0VOoo
ooooo`0]oooo1@0000?oool00`0003?o03?o000F<ol000<0003oooooool0MOooo`00Eoooo`03o`2I
oooooooo02ooool00`000?ooooooo`03oooo00<0000co`0co`005S?o00030000oooooooo07Goool0
05Ooool00ol0VOooooooo`0_oooo00<0003oooooool00oooo`<0000E<ol000<0003oooooool0M_oo
o`00Eoooo`03o`2Ioooooooo02ooool00`000?ooooooo`03oooo00<0000co`0co`005C?o00030000
oooooooo07Koool005Ooool00ol0VOooooooo`0_oooo00<0003oooooool00oooo`030000<ol0<ol0
01Dco`000`000?ooooooo`1foooo001Goooo00?o09Woooooool0;_ooo`800005oooo00<0000co`0c
o`0053?o00030000oooooooo07Ooool005Ooool00ol0VOooooooo`0eoooo00<0000co`0co`0053?o
00030000oooooooo07Ooool005Ooool00ol0VOooooooo`0eoooo00<0000co`0co`004c?o00030000
oooooooo07Soool005Ooool00ol0VOooooooo`0eoooo0P0001@co`000`000?ooooooo`1hoooo001G
oooo00?o09Woooooool0=Oooo`030000<ol0<ol001<co`000`000?ooooooo`1hoooo001Goooo00?o
09Woooooool0=Oooo`030000<ol0<ol0018co`000`000?ooooooo`1ioooo001Goooo00?o09Wooooo
ool0=Oooo`030000<ol0<ol0018co`000`000?ooooooo`1ioooo001Goooo00?o09Woooooool0=Ooo
o`030000<ol0<ol0018co`000`000?ooooooo`1ioooo001Goooo00?o09Woooooool0=Oooo`030000
<ol0<ol0014co`000`000?ooooooo`1joooo001Goooo00?o09Woooooool0=Oooo`80000B<ol000<0
003oooooool0N_ooo`00Eoooo`03o`2Ioooooooo03Goool00`0003?o03?o000A<ol000<0003ooooo
ool0N_ooo`00Eoooo`03o`2Ioooooooo03Goool00`0003?o03?o000A<ol000<0003oooooool0N_oo
o`00Eoooo`03o`2Ioooooooo03Goool00`0003?o03?o000@<ol000<0003oooooool0Noooo`00Eooo
o`03o`2Ioooooooo03Goool00`0003?o03?o000@<ol000<0003oooooool0Noooo`00Eoooo`03o`2I
oooooooo03Goool00`0003?o03?o000@<ol000<0003oooooool0Noooo`00Eoooo`03o`2Ioooooooo
03Goool00`0003?o03?o000@<ol000<0003oooooool0Noooo`00Eoooo`03o`2Ioooooooo03Goool2
000043?o00030000oooooooo07coool005Ooool00ol0VOooooooo`0eoooo00<0000co`0co`003c?o
00030000oooooooo07coool005Ooool00ol0VOooooooo`0eoooo00<0000co`0co`003c?o00030000
oooooooo07coool005Ooool00ol0VOooooooo`0eoooo00<0000co`0co`003c?o00030000oooooooo
07coool005Ooool00ol0VOooooooo`0eoooo00<0000co`0co`003c?o00030000oooooooo07coool0
05Ooool00ol0VOooooooo`0eoooo00<0000co`0co`003S?o00030000oooooooo07goool005Ooool0
0ol0VOooooooo`0eoooo0P0000lco`000`000?ooooooo`1moooo001Goooo00?o09Woooooool0=Ooo
o`030000<ol0<ol000hco`000`000?ooooooo`1moooo001Goooo00?o09Woooooool0=Oooo`030000
<ol0<ol000hco`000`000?ooooooo`1moooo001Goooo00?o09Woooooool0=Oooo`030000<ol0<ol0
00dco`000`000?ooooooo`1noooo001Goooo00?o09Woooooool0;Oooo`@00004oooo00<0000co`0c
o`003C?o00030000oooooooo07koool005Ooool00ol0VOooooooo`0]oooo00<0003oooooool01Ooo
o`030000<ol0<ol000dco`000`000?ooooooo`1noooo001Goooo00?o09Woooooool0;_ooo`030000
oooooooo00Coool300003C?o00030000oooooooo07koool005Ooool00ol0VOooooooo`0_oooo00<0
003oooooool00oooo`030000<ol0<ol000dco`000`000?ooooooo`1noooo001Goooo00?o09Wooooo
ool0;Oooo`040000oooooooo00001?ooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001G
oooo00?o09Woooooool0;_ooo`800005oooo00<0000co`0co`0033?o00030000oooooooo07ooool0
05Ooool00ol0VOooooooo`0eoooo00<0000co`0co`0033?o00030000oooooooo07ooool005Ooool0
0ol0VOooooooo`0eoooo00<0000co`0co`0033?o00030000oooooooo07ooool005Ooool00ol0VOoo
ooooo`0eoooo0P0000dco`000`000?ooooooo`1ooooo001Goooo00?o09Woooooool0=Oooo`030000
<ol0<ol000`co`000`000?ooooooo`1ooooo001Goooo00?o09Woooooool0=Oooo`030000<ol0<ol0
00/co`000`000?ooooooo`20oooo001Goooo00?o09Woooooool0=Oooo`030000<ol0<ol000/co`00
0`000?ooooooo`20oooo001Goooo00?o09Woooooool0=Oooo`030000<ol0<ol000/co`000`000?oo
ooooo`20oooo001Goooo00?o09Woooooool0=Oooo`030000<ol0<ol000/co`000`000?ooooooo`20
oooo001Goooo00?o09Woooooool0=Oooo`030000<ol0<ol000/co`000`000?ooooooo`20oooo001G
oooo00?o09Woooooool0=Oooo`80000<<ol000<0003oooooool0P?ooo`00Eoooo`03o`2Ioooooooo
03Goool00`0003?o03?o000;<ol000<0003oooooool0P?ooo`00Eoooo`03o`2Ioooooooo03Goool0
0`0003?o03?o000:<ol000<0003oooooool0POooo`00Eoooo`03o`2Ioooooooo03Goool00`0003?o
03?o000:<ol000<0003oooooool0POooo`00Eoooo`03o`2Ioooooooo03Goool00`0003?o03?o000:
<ol000<0003oooooool0POooo`00Eoooo`03o`2Ioooooooo03Goool00`0003?o03?o000:<ol000<0
003oooooool0POooo`00Eoooo`03o`2Ioooooooo03Goool200002c?o00030000oooooooo087oool0
05Ooool00ol0VOooooooo`0eoooo00<0000co`0co`002S?o00030000oooooooo087oool005Ooool0
0ol0VOooooooo`0eoooo00<0000co`0co`002S?o00030000oooooooo087oool005Ooool00ol0VOoo
ooooo`0eoooo00<0000co`0co`002C?o00030000oooooooo08;oool005Ooool00ol0VOooooooo`0e
oooo00<0000co`0co`002C?o00030000oooooooo08;oool005Ooool00ol0VOooooooo`0eoooo00<0
000co`0co`002C?o00030000oooooooo08;oool005Ooool00ol0VOooooooo`0eoooo0P0000Xco`00
0`000?ooooooo`22oooo001Goooo00?o09Woooooool0=Oooo`030000<ol0<ol000Tco`000`000?oo
ooooo`22oooo001Goooo00?o09Woooooool0=Oooo`030000<ol0<ol000Tco`000`000?ooooooo`22
oooo001Goooo00?o09Woooooool0=Oooo`030000<ol0<ol000Pco`000`000?ooooooo`23oooo001G
oooo00?o09Woooooool0;_ooo`800005oooo00<0000co`0co`0023?o00030000oooooooo08?oool0
05Ooool00ol0VOooooooo`0]oooo00@0003oooooool00004oooo00<0000co`0co`0023?o00030000
oooooooo08?oool005Ooool00ol0VOooooooo`0_oooo00<0003oooooool00oooo`<00008<ol000<0
003oooooool0Poooo`00Eoooo`03o`2Ioooooooo033oool00`000?ooooooo`02oooo00<0000co`0c
o`0023?o00030000oooooooo08?oool005Ooool00ol0VOooooooo`0]oooo00@0003oooooool00004
oooo00<0000co`0co`0023?o00030000oooooooo08?oool005Ooool00ol0VOooooooo`0^oooo0P00
00Goool00`0003?o03?o0007<ol000<0003oooooool0Q?ooo`00Eoooo`03o`2Ioooooooo03Goool0
0`0003?o03?o0007<ol000<0003oooooool0Q?ooo`00Eoooo`03o`2Ioooooooo03Goool00`0003?o
03?o0007<ol000<0003oooooool0Q?ooo`00Eoooo`03o`2Ioooooooo03Goool00`0003?o03?o0007
<ol000<0003oooooool0Q?ooo`00Eoooo`03o`2Ioooooooo03Goool2000023?o00030000oooooooo
08Coool005Ooool00ol0VOooooooo`0eoooo00<0000co`0co`001c?o00030000oooooooo08Coool0
05Ooool00ol0VOooooooo`0eoooo00<0000co`0co`001c?o00030000oooooooo08Coool005Ooool0
0ol0VOooooooo`0eoooo00<0000co`0co`001c?o00030000oooooooo08Coool005Ooool00ol0VOoo
ooooo`0eoooo00<0000co`0co`001S?o00030000oooooooo08Goool005Ooool00ol0VOooooooo`0e
oooo00<0000co`0co`001S?o00030000oooooooo08Goool005Ooool00ol0VOooooooo`0eoooo0P00
00Lco`000`000?ooooooo`25oooo001Goooo00?o09Woooooool0=Oooo`030000<ol0<ol000Hco`00
0`000?ooooooo`25oooo001Goooo00?o09Woooooool0=Oooo`030000<ol0<ol000Hco`000`000?oo
ooooo`25oooo001Goooo00?o09Woooooool0=Oooo`030000<ol0<ol000Hco`000`000?ooooooo`25
oooo001Goooo00?o09Woooooool0=Oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001G
oooo00?o09Woooooool0=Oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001Goooo00?o
09Woooooool0=Oooo`800006<ol000<0003oooooool0Q_ooo`00Eoooo`03o`2Ioooooooo03Goool0
0`0003?o03?o0005<ol000<0003oooooool0Q_ooo`00Eoooo`03o`2Ioooooooo03Goool00`0003?o
03?o0005<ol000<0003oooooool0Q_ooo`00Eoooo`03o`2Ioooooooo03Goool00`0003?o03?o0005
<ol000<0003oooooool0Q_ooo`00Eoooo`03o`2Ioooooooo03Goool00`0003?o03?o0005<ol000<0
003oooooool0Q_ooo`00Eoooo`03o`2Ioooooooo03Goool00`0003?o03?o0005<ol000<0003ooooo
ool0Q_ooo`00Eoooo`03o`2Ioooooooo03Goool200001S?o00030000oooooooo08Koool005Ooool0
0ol0VOooooooo`0eoooo00<0000co`0co`001C?o00030000oooooooo08Koool005Ooool00ol0VOoo
ooooo`0eoooo00<0000co`0co`001C?o00030000oooooooo08Koool005Ooool00ol0VOooooooo`0e
oooo00<0000co`0co`0013?o00030000oooooooo08Ooool005Ooool00ol0VOooooooo`0eoooo00<0
000co`0co`0013?o00030000oooooooo08Ooool005Ooool00ol0VOooooooo`0_oooo0`0000?oool0
0`0003?o03?o0004<ol000<0003oooooool0Qoooo`00Eoooo`03o`2Ioooooooo033oool00`000?oo
ooooo`02oooo00<0000co`0co`0013?o00030000oooooooo08Ooool005Ooool00ol0VOooooooo`0]
oooo1@0000?oool3000013?o00030000oooooooo08Ooool008Ooool010000?ooooooo`0000Coool7
<ol0R_ooo`00R?ooo`030000oooo000000Coool7<ol0R_ooo`00ROooo`800004oooo1c?o08[oool0
08ooool7<ol0R_ooo`00Soooo`Lco`2:oooo001ioooo00<0003oooooool04oooo`Lco`0>oooo00<0
003oooooool0NOooo`00N?ooo`030000oooooooo00Soool00`000?ooooooo`09oooo1c?o00ooool0
0`000?ooooooo`1hoooo001hoooo00<0003oooooool00_ooo`800004oooo00<0003oooooool01ooo
o`800004<ol00P000004<ol0oooooooooooo0P0000Coool200001?ooo`030000oooooooo07Soool0
07Soool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo00Goool0
10000?ooooooo`0000Hco`02oooo00@0003oooooool00002oooo00@0003oooooool00003oooo00<0
003oooooool0N?ooo`00Moooo`030000oooooooo00;oool00`000?ooooooo`0=oooo00@0003ooooo
ool00006<ol00_ooo`040000oooooooo00000_ooo`040000oooooooo00001?ooo`030000oooooooo
07Ooool007Soool00`000?ooooooo`0500003?ooo`040000oooooooo00001S?o00;oool010000?oo
ooooo`0000?oool200001?ooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`00000?
oooo00@0003oooooool00006<ol00_ooo`040000oooooooo00000_ooo`040000oooooooo00000ooo
o`030000oooooooo07Soool007Woool00`000?ooooooo`0Aoooo0P0000Lco`03oooo0P0000Coool2
00000oooo`030000oooooooo07Woool008ooool7<ol0R_ooo`00Soooo`Lco`2:oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.27193 .12361 L
.27731 .12361 L
.28025 .12361 L
.28302 .12361 L
.28425 .12361 L
.28542 .12361 L
s
.28542 .12361 m
.28567 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`09oooo00<0003ooooo
ool00oooo`03o`2Ioooooooo00?oool00`000?ooooooo`09oooo00<0003oooooool02Oooo`030000
oooooooo00Woool00`000?ooooooo`09oooo00<0000co`0co`002C?o00030000<ol0<ol000Tco`00
0`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Tco`000`0003?o03?o0006
<ol08P0000Koool00`000?ooooooo`09oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo
03[oool00`000?ooooooo`03oooo00?o09Woooooool0<oooo`030000<ol0<ol003Tco`090000=?oo
o`030000oooooooo01Goool005Woool00ol0VOooooooo`0coooo00<0000co`0co`00<c?o00H0001E
oooo001Ioooo00?o09Woooooool0<oooo`030000<ol0<ol0034co`020000Foooo`00FOooo`03o`2I
oooooooo03?oool00`0003?o03?o000_<ol00P0005goool005Woool00ol0VOooooooo`0coooo00<0
000co`0co`00;3?o00<0001Ooooo001Ioooo00?o09Woooooool0<oooo`80000Z<ol00`0006;oool0
05Woool00ol0VOooooooo`0coooo00<0000co`0co`009c?o0080001Uoooo001Ioooo00?o09Wooooo
ool0<oooo`030000<ol0<ol002Hco`000`000?ooooooo`1Uoooo001Ioooo00?o09Woooooool0<ooo
o`030000<ol0<ol002Dco`000`000?ooooooo`1Voooo001Ioooo00?o09Woooooool0<oooo`030000
<ol0<ol002@co`000`000?ooooooo`1Woooo001Ioooo00?o09Woooooool0<oooo`030000<ol0<ol0
028co`020000J_ooo`00FOooo`03o`2Ioooooooo03?oool200008S?o00030000oooooooo06[oool0
05Woool00ol0VOooooooo`0coooo00<0000co`0co`0083?o00030000oooooooo06_oool005Woool0
0ol0VOooooooo`0coooo00<0000co`0co`007c?o00030000oooooooo06coool005Woool00ol0VOoo
ooooo`0coooo00<0000co`0co`007c?o00030000oooooooo06coool005Woool00ol0VOooooooo`0c
oooo00<0000co`0co`007S?o00030000oooooooo06goool005Woool00ol0VOooooooo`0coooo00<0
000co`0co`007C?o00030000oooooooo06koool005Woool00ol0VOooooooo`0coooo0P0001dco`00
0`000?ooooooo`1_oooo001Ioooo00?o09Woooooool0<oooo`030000<ol0<ol001/co`000`000?oo
ooooo`1`oooo001Ioooo00?o09Woooooool0<oooo`030000<ol0<ol001/co`000`000?ooooooo`1`
oooo001Ioooo00?o09Woooooool0<oooo`030000<ol0<ol001Xco`000`000?ooooooo`1aoooo001I
oooo00?o09Woooooool0<oooo`030000<ol0<ol001Xco`000`000?ooooooo`1aoooo001Ioooo00?o
09Woooooool0<oooo`030000<ol0<ol001Tco`000`000?ooooooo`1boooo001Ioooo00?o09Wooooo
ool0<oooo`80000J<ol000<0003oooooool0L_ooo`00FOooo`03o`2Ioooooooo03?oool00`0003?o
03?o000H<ol000<0003oooooool0Loooo`00FOooo`03o`2Ioooooooo03?oool00`0003?o03?o000H
<ol000<0003oooooool0Loooo`00FOooo`03o`2Ioooooooo03?oool00`0003?o03?o000G<ol000<0
003oooooool0M?ooo`00FOooo`03o`2Ioooooooo03?oool00`0003?o03?o000G<ol000<0003ooooo
ool0M?ooo`00FOooo`03o`2Ioooooooo02_oool500000oooo`030000<ol0<ol001Hco`000`000?oo
ooooo`1eoooo001Ioooo00?o09Woooooool0;Oooo`030000oooooooo00?oool00`0003?o03?o000F
<ol000<0003oooooool0MOooo`00FOooo`03o`2Ioooooooo02goool00`000?ooooooo`03oooo0`00
01Dco`000`000?ooooooo`1foooo001Ioooo00?o09Woooooool0;Oooo`030000oooooooo00?oool0
0`0003?o03?o000E<ol000<0003oooooool0M_ooo`00FOooo`03o`2Ioooooooo02goool00`000?oo
ooooo`03oooo00<0000co`0co`005C?o00030000oooooooo07Koool005Woool00ol0VOooooooo`0/
oooo0P0000Goool00`0003?o03?o000D<ol000<0003oooooool0Moooo`00FOooo`03o`2Ioooooooo
03?oool00`0003?o03?o000D<ol000<0003oooooool0Moooo`00FOooo`03o`2Ioooooooo03?oool0
0`0003?o03?o000C<ol000<0003oooooool0N?ooo`00FOooo`03o`2Ioooooooo03?oool2000053?o
00030000oooooooo07Soool005Woool00ol0VOooooooo`0coooo00<0000co`0co`004c?o00030000
oooooooo07Soool005Woool00ol0VOooooooo`0coooo00<0000co`0co`004S?o00030000oooooooo
07Woool005Woool00ol0VOooooooo`0coooo00<0000co`0co`004S?o00030000oooooooo07Woool0
05Woool00ol0VOooooooo`0coooo00<0000co`0co`004S?o00030000oooooooo07Woool005Woool0
0ol0VOooooooo`0coooo00<0000co`0co`004C?o00030000oooooooo07[oool005Woool00ol0VOoo
ooooo`0coooo0P00018co`000`000?ooooooo`1joooo001Ioooo00?o09Woooooool0<oooo`030000
<ol0<ol0014co`000`000?ooooooo`1joooo001Ioooo00?o09Woooooool0<oooo`030000<ol0<ol0
014co`000`000?ooooooo`1joooo001Ioooo00?o09Woooooool0<oooo`030000<ol0<ol0010co`00
0`000?ooooooo`1koooo001Ioooo00?o09Woooooool0<oooo`030000<ol0<ol0010co`000`000?oo
ooooo`1koooo001Ioooo00?o09Woooooool0<oooo`030000<ol0<ol0010co`000`000?ooooooo`1k
oooo001Ioooo00?o09Woooooool0<oooo`030000<ol0<ol0010co`000`000?ooooooo`1koooo001I
oooo00?o09Woooooool0<oooo`80000@<ol000<0003oooooool0O?ooo`00FOooo`03o`2Ioooooooo
03?oool00`0003?o03?o000?<ol000<0003oooooool0O?ooo`00FOooo`03o`2Ioooooooo03?oool0
0`0003?o03?o000?<ol000<0003oooooool0O?ooo`00FOooo`03o`2Ioooooooo03?oool00`0003?o
03?o000?<ol000<0003oooooool0O?ooo`00FOooo`03o`2Ioooooooo03?oool00`0003?o03?o000?
<ol000<0003oooooool0O?ooo`00FOooo`03o`2Ioooooooo03?oool00`0003?o03?o000><ol000<0
003oooooool0OOooo`00FOooo`03o`2Ioooooooo03?oool200003c?o00030000oooooooo07goool0
05Woool00ol0VOooooooo`0coooo00<0000co`0co`003S?o00030000oooooooo07goool005Woool0
0ol0VOooooooo`0coooo00<0000co`0co`003S?o00030000oooooooo07goool005Woool00ol0VOoo
ooooo`0coooo00<0000co`0co`003C?o00030000oooooooo07koool005Woool00ol0VOooooooo`0[
oooo100000Coool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00FOooo`03o`2Ioooooooo
02_oool00`000?ooooooo`05oooo00<0000co`0co`003C?o00030000oooooooo07koool005Woool0
0ol0VOooooooo`0/oooo00<0003oooooool01?ooo`<0000=<ol000<0003oooooool0O_ooo`00FOoo
o`03o`2Ioooooooo02goool00`000?ooooooo`03oooo00<0000co`0co`003C?o00030000oooooooo
07koool005Woool00ol0VOooooooo`0[oooo00@0003oooooool00004oooo00<0000co`0co`0033?o
00030000oooooooo07ooool005Woool00ol0VOooooooo`0/oooo0P0000Goool00`0003?o03?o000<
<ol000<0003oooooool0Ooooo`00FOooo`03o`2Ioooooooo03?oool00`0003?o03?o000<<ol000<0
003oooooool0Ooooo`00FOooo`03o`2Ioooooooo03?oool00`0003?o03?o000<<ol000<0003ooooo
ool0Ooooo`00FOooo`03o`2Ioooooooo03?oool200003C?o00030000oooooooo07ooool005Woool0
0ol0VOooooooo`0coooo00<0000co`0co`0033?o00030000oooooooo07ooool005Woool00ol0VOoo
ooooo`0coooo00<0000co`0co`002c?o00030000oooooooo083oool005Woool00ol0VOooooooo`0c
oooo00<0000co`0co`002c?o00030000oooooooo083oool005Woool00ol0VOooooooo`0coooo00<0
000co`0co`002c?o00030000oooooooo083oool005Woool00ol0VOooooooo`0coooo00<0000co`0c
o`002c?o00030000oooooooo083oool005Woool00ol0VOooooooo`0coooo00<0000co`0co`002c?o
00030000oooooooo083oool005Woool00ol0VOooooooo`0coooo0P0000`co`000`000?ooooooo`20
oooo001Ioooo00?o09Woooooool0<oooo`030000<ol0<ol000/co`000`000?ooooooo`20oooo001I
oooo00?o09Woooooool0<oooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001Ioooo00?o
09Woooooool0<oooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001Ioooo00?o09Wooooo
ool0<oooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001Ioooo00?o09Woooooool0<ooo
o`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001Ioooo00?o09Woooooool0<oooo`80000;
<ol000<0003oooooool0POooo`00FOooo`03o`2Ioooooooo03?oool00`0003?o03?o000:<ol000<0
003oooooool0POooo`00FOooo`03o`2Ioooooooo03?oool00`0003?o03?o000:<ol000<0003ooooo
ool0POooo`00FOooo`03o`2Ioooooooo03?oool00`0003?o03?o0009<ol000<0003oooooool0P_oo
o`00FOooo`03o`2Ioooooooo03?oool00`0003?o03?o0009<ol000<0003oooooool0P_ooo`00FOoo
o`03o`2Ioooooooo03?oool00`0003?o03?o0009<ol000<0003oooooool0P_ooo`00FOooo`03o`2I
oooooooo03?oool200002S?o00030000oooooooo08;oool005Woool00ol0VOooooooo`0coooo00<0
000co`0co`002C?o00030000oooooooo08;oool005Woool00ol0VOooooooo`0coooo00<0000co`0c
o`002C?o00030000oooooooo08;oool005Woool00ol0VOooooooo`0coooo00<0000co`0co`0023?o
00030000oooooooo08?oool005Woool00ol0VOooooooo`0/oooo0P0000Goool00`0003?o03?o0008
<ol000<0003oooooool0Poooo`00FOooo`03o`2Ioooooooo02_oool010000?ooooooo`0000Coool0
0`0003?o03?o0008<ol000<0003oooooool0Poooo`00FOooo`03o`2Ioooooooo02goool00`000?oo
ooooo`03oooo0`0000Pco`000`000?ooooooo`23oooo001Ioooo00?o09Woooooool0;_ooo`030000
oooooooo00;oool00`0003?o03?o0008<ol000<0003oooooool0Poooo`00FOooo`03o`2Ioooooooo
02_oool010000?ooooooo`0000Coool00`0003?o03?o0008<ol000<0003oooooool0Poooo`00FOoo
o`03o`2Ioooooooo02coool200001Oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001I
oooo00?o09Woooooool0<oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001Ioooo00?o
09Woooooool0<oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001Ioooo00?o09Wooooo
ool0<oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001Ioooo00?o09Woooooool0<ooo
o`800008<ol000<0003oooooool0Q?ooo`00FOooo`03o`2Ioooooooo03?oool00`0003?o03?o0007
<ol000<0003oooooool0Q?ooo`00FOooo`03o`2Ioooooooo03?oool00`0003?o03?o0007<ol000<0
003oooooool0Q?ooo`00FOooo`03o`2Ioooooooo03?oool00`0003?o03?o0007<ol000<0003ooooo
ool0Q?ooo`00FOooo`03o`2Ioooooooo03?oool00`0003?o03?o0006<ol000<0003oooooool0QOoo
o`00FOooo`03o`2Ioooooooo03?oool00`0003?o03?o0006<ol000<0003oooooool0QOooo`00FOoo
o`03o`2Ioooooooo03?oool200001c?o00030000oooooooo08Goool005Woool00ol0VOooooooo`0c
oooo00<0000co`0co`001S?o00030000oooooooo08Goool005Woool00ol0VOooooooo`0coooo00<0
000co`0co`001S?o00030000oooooooo08Goool005Woool00ol0VOooooooo`0coooo00<0000co`0c
o`001S?o00030000oooooooo08Goool005Woool00ol0VOooooooo`0coooo00<0000co`0co`001S?o
00030000oooooooo08Goool005Woool00ol0VOooooooo`0coooo00<0000co`0co`001S?o00030000
oooooooo08Goool005Woool00ol0VOooooooo`0coooo0P0000Hco`000`000?ooooooo`26oooo001I
oooo00?o09Woooooool0<oooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001Ioooo00?o
09Woooooool0<oooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001Ioooo00?o09Wooooo
ool0<oooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001Ioooo00?o09Woooooool0<ooo
o`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001Ioooo00?o09Woooooool0<oooo`030000
<ol0<ol000Dco`000`000?ooooooo`26oooo001Ioooo00?o09Woooooool0<oooo`800006<ol000<0
003oooooool0Q_ooo`00FOooo`03o`2Ioooooooo03?oool00`0003?o03?o0005<ol000<0003ooooo
ool0Q_ooo`00FOooo`03o`2Ioooooooo03?oool00`0003?o03?o0005<ol000<0003oooooool0Q_oo
o`00FOooo`03o`2Ioooooooo03?oool00`0003?o03?o0004<ol000<0003oooooool0Qoooo`00FOoo
o`03o`2Ioooooooo03?oool00`0003?o03?o0004<ol000<0003oooooool0Qoooo`00FOooo`03o`2I
oooooooo02goool300000oooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001Ioooo00?o
09Woooooool0;_ooo`030000oooooooo00;oool00`0003?o03?o0004<ol000<0003oooooool0Qooo
o`00FOooo`03o`2Ioooooooo02_oool500000oooo`<00004<ol000<0003oooooool0Qoooo`00Qooo
o`040000oooooooo00001?ooo`Lco`2:oooo0028oooo00<0003oool000001?ooo`Lco`2:oooo0029
oooo0P0000Coool7<ol0R_ooo`00Soooo`Lco`2:oooo002?oooo1c?o08[oool007coool00`000?oo
ooooo`0@oooo1c?o00_oool00`000?ooooooo`1loooo001koooo00<0003oooooool02?ooo`030000
oooooooo00Koool7<ol03?ooo`030000oooooooo07_oool007_oool00`000?ooooooo`02oooo0P00
00Coool00`000?ooooooo`06oooo00<co`000000000013?o00800003oooo1@0000;oool00`000?oo
ooooo`1koooo001koooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?oo
ooooo`05oooo00@0000co`0co`000003<ol01oooo`030000oooooooo00;oool00`000?ooooooo`1k
oooo001joooo00<0003oooooool00_ooo`030000oooooooo00goool0100003?o03?o000000<co`07
oooo00<0003oooooool00oooo`030000oooooooo07[oool007_oool00`000?ooooooo`0500003?oo
o`040000<ol0<ol000000c?o00Ooool00`000?ooooooo`02oooo00<0003oooooool0Noooo`00Nooo
o`050000oooooooooooo000000ooool0100003?o03?o000000<co`07oooo00<0003oooooool00_oo
o`030000oooooooo07_oool007coool00`000?ooooooo`0@oooo00<co`000000000013?o00Koool2
00000oooo`030000oooooooo07coool008ooool7<ol0R_ooo`00Soooo`Lco`2:oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.12) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.27193 .12361 L
.27731 .12361 L
.28302 .12361 L
.28542 .12361 L
.288 .12361 L
.28876 .12361 L
.28948 .12361 L
.29013 .12361 L
s
.29013 .12361 m
.29041 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.12) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`09oooo00<0003ooooo
ool01?ooo`03o`2Ioooooooo00;oool00`000?ooooooo`09oooo00<0003oooooool02Oooo`030000
oooooooo00Woool00`000?ooooooo`09oooo00<0000co`0co`002C?o00030000<ol0<ol000Tco`00
0`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Tco`000`0003?o03?o0006
<ol08P0000Koool00`000?ooooooo`09oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo
03[oool00`000?ooooooo`04oooo00?o09Woooooool0<_ooo`030000<ol0<ol003Tco`090000=?oo
o`030000oooooooo01Goool005[oool00ol0VOooooooo`0boooo00<0000co`0co`00<c?o00H0001E
oooo001Joooo00?o09Woooooool0<_ooo`030000<ol0<ol0034co`020000Foooo`00F_ooo`03o`2I
oooooooo03;oool00`0003?o03?o000_<ol00P0005goool005[oool00ol0VOooooooo`0boooo00<0
000co`0co`00;3?o00<0001Ooooo001Joooo00?o09Woooooool0<_ooo`80000Z<ol00`0006;oool0
05[oool00ol0VOooooooo`0boooo00<0000co`0co`009c?o0080001Uoooo001Joooo00?o09Wooooo
ool0<_ooo`030000<ol0<ol002Hco`000`000?ooooooo`1Uoooo001Joooo00?o09Woooooool0<_oo
o`030000<ol0<ol002Dco`000`000?ooooooo`1Voooo001Joooo00?o09Woooooool0<_ooo`030000
<ol0<ol002@co`000`000?ooooooo`1Woooo001Joooo00?o09Woooooool0<_ooo`030000<ol0<ol0
028co`020000J_ooo`00F_ooo`03o`2Ioooooooo03;oool200008S?o00030000oooooooo06[oool0
05[oool00ol0VOooooooo`0boooo00<0000co`0co`0083?o00030000oooooooo06_oool005[oool0
0ol0VOooooooo`0boooo00<0000co`0co`007c?o00030000oooooooo06coool005[oool00ol0VOoo
ooooo`0boooo00<0000co`0co`007c?o00030000oooooooo06coool005[oool00ol0VOooooooo`0b
oooo00<0000co`0co`007S?o00030000oooooooo06goool005[oool00ol0VOooooooo`0boooo00<0
000co`0co`007C?o00030000oooooooo06koool005[oool00ol0VOooooooo`0boooo0P0001dco`00
0`000?ooooooo`1_oooo001Joooo00?o09Woooooool0<_ooo`030000<ol0<ol001/co`000`000?oo
ooooo`1`oooo001Joooo00?o09Woooooool0<_ooo`030000<ol0<ol001/co`000`000?ooooooo`1`
oooo001Joooo00?o09Woooooool0<_ooo`030000<ol0<ol001Xco`000`000?ooooooo`1aoooo001J
oooo00?o09Woooooool0<_ooo`030000<ol0<ol001Xco`000`000?ooooooo`1aoooo001Joooo00?o
09Woooooool0<_ooo`030000<ol0<ol001Tco`000`000?ooooooo`1boooo001Joooo00?o09Wooooo
ool0<_ooo`80000J<ol000<0003oooooool0L_ooo`00F_ooo`03o`2Ioooooooo03;oool00`0003?o
03?o000H<ol000<0003oooooool0Loooo`00F_ooo`03o`2Ioooooooo03;oool00`0003?o03?o000H
<ol000<0003oooooool0Loooo`00F_ooo`03o`2Ioooooooo03;oool00`0003?o03?o000G<ol000<0
003oooooool0M?ooo`00F_ooo`03o`2Ioooooooo03;oool00`0003?o03?o000G<ol000<0003ooooo
ool0M?ooo`00F_ooo`03o`2Ioooooooo02[oool500000oooo`030000<ol0<ol001Hco`000`000?oo
ooooo`1eoooo001Joooo00?o09Woooooool0;?ooo`030000oooooooo00?oool00`0003?o03?o000F
<ol000<0003oooooool0MOooo`00F_ooo`03o`2Ioooooooo02coool00`000?ooooooo`03oooo0`00
01Dco`000`000?ooooooo`1foooo001Joooo00?o09Woooooool0;?ooo`030000oooooooo00?oool0
0`0003?o03?o000E<ol000<0003oooooool0M_ooo`00F_ooo`03o`2Ioooooooo02coool00`000?oo
ooooo`03oooo00<0000co`0co`005C?o00030000oooooooo07Koool005[oool00ol0VOooooooo`0[
oooo0P0000Goool00`0003?o03?o000D<ol000<0003oooooool0Moooo`00F_ooo`03o`2Ioooooooo
03;oool00`0003?o03?o000D<ol000<0003oooooool0Moooo`00F_ooo`03o`2Ioooooooo03;oool0
0`0003?o03?o000C<ol000<0003oooooool0N?ooo`00F_ooo`03o`2Ioooooooo03;oool2000053?o
00030000oooooooo07Soool005[oool00ol0VOooooooo`0boooo00<0000co`0co`004c?o00030000
oooooooo07Soool005[oool00ol0VOooooooo`0boooo00<0000co`0co`004S?o00030000oooooooo
07Woool005[oool00ol0VOooooooo`0boooo00<0000co`0co`004S?o00030000oooooooo07Woool0
05[oool00ol0VOooooooo`0boooo00<0000co`0co`004S?o00030000oooooooo07Woool005[oool0
0ol0VOooooooo`0boooo00<0000co`0co`004C?o00030000oooooooo07[oool005[oool00ol0VOoo
ooooo`0boooo0P00018co`000`000?ooooooo`1joooo001Joooo00?o09Woooooool0<_ooo`030000
<ol0<ol0014co`000`000?ooooooo`1joooo001Joooo00?o09Woooooool0<_ooo`030000<ol0<ol0
014co`000`000?ooooooo`1joooo001Joooo00?o09Woooooool0<_ooo`030000<ol0<ol0010co`00
0`000?ooooooo`1koooo001Joooo00?o09Woooooool0<_ooo`030000<ol0<ol0010co`000`000?oo
ooooo`1koooo001Joooo00?o09Woooooool0<_ooo`030000<ol0<ol0010co`000`000?ooooooo`1k
oooo001Joooo00?o09Woooooool0<_ooo`030000<ol0<ol0010co`000`000?ooooooo`1koooo001J
oooo00?o09Woooooool0<_ooo`80000@<ol000<0003oooooool0O?ooo`00F_ooo`03o`2Ioooooooo
03;oool00`0003?o03?o000?<ol000<0003oooooool0O?ooo`00F_ooo`03o`2Ioooooooo03;oool0
0`0003?o03?o000?<ol000<0003oooooool0O?ooo`00F_ooo`03o`2Ioooooooo03;oool00`0003?o
03?o000?<ol000<0003oooooool0O?ooo`00F_ooo`03o`2Ioooooooo03;oool00`0003?o03?o000?
<ol000<0003oooooool0O?ooo`00F_ooo`03o`2Ioooooooo03;oool00`0003?o03?o000><ol000<0
003oooooool0OOooo`00F_ooo`03o`2Ioooooooo03;oool200003c?o00030000oooooooo07goool0
05[oool00ol0VOooooooo`0boooo00<0000co`0co`003S?o00030000oooooooo07goool005[oool0
0ol0VOooooooo`0boooo00<0000co`0co`003S?o00030000oooooooo07goool005[oool00ol0VOoo
ooooo`0boooo00<0000co`0co`003C?o00030000oooooooo07koool005[oool00ol0VOooooooo`0Z
oooo100000Coool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00F_ooo`03o`2Ioooooooo
02[oool00`000?ooooooo`05oooo00<0000co`0co`003C?o00030000oooooooo07koool005[oool0
0ol0VOooooooo`0[oooo00<0003oooooool01?ooo`<0000=<ol000<0003oooooool0O_ooo`00F_oo
o`03o`2Ioooooooo02coool00`000?ooooooo`03oooo00<0000co`0co`003C?o00030000oooooooo
07koool005[oool00ol0VOooooooo`0Zoooo00@0003oooooool00004oooo00<0000co`0co`0033?o
00030000oooooooo07ooool005[oool00ol0VOooooooo`0[oooo0P0000Goool00`0003?o03?o000<
<ol000<0003oooooool0Ooooo`00F_ooo`03o`2Ioooooooo03;oool00`0003?o03?o000<<ol000<0
003oooooool0Ooooo`00F_ooo`03o`2Ioooooooo03;oool00`0003?o03?o000<<ol000<0003ooooo
ool0Ooooo`00F_ooo`03o`2Ioooooooo03;oool200003C?o00030000oooooooo07ooool005[oool0
0ol0VOooooooo`0boooo00<0000co`0co`0033?o00030000oooooooo07ooool005[oool00ol0VOoo
ooooo`0boooo00<0000co`0co`002c?o00030000oooooooo083oool005[oool00ol0VOooooooo`0b
oooo00<0000co`0co`002c?o00030000oooooooo083oool005[oool00ol0VOooooooo`0boooo00<0
000co`0co`002c?o00030000oooooooo083oool005[oool00ol0VOooooooo`0boooo00<0000co`0c
o`002c?o00030000oooooooo083oool005[oool00ol0VOooooooo`0boooo00<0000co`0co`002c?o
00030000oooooooo083oool005[oool00ol0VOooooooo`0boooo0P0000`co`000`000?ooooooo`20
oooo001Joooo00?o09Woooooool0<_ooo`030000<ol0<ol000/co`000`000?ooooooo`20oooo001J
oooo00?o09Woooooool0<_ooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001Joooo00?o
09Woooooool0<_ooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001Joooo00?o09Wooooo
ool0<_ooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001Joooo00?o09Woooooool0<_oo
o`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001Joooo00?o09Woooooool0<_ooo`80000;
<ol000<0003oooooool0POooo`00F_ooo`03o`2Ioooooooo03;oool00`0003?o03?o000:<ol000<0
003oooooool0POooo`00F_ooo`03o`2Ioooooooo03;oool00`0003?o03?o000:<ol000<0003ooooo
ool0POooo`00F_ooo`03o`2Ioooooooo03;oool00`0003?o03?o0009<ol000<0003oooooool0P_oo
o`00F_ooo`03o`2Ioooooooo03;oool00`0003?o03?o0009<ol000<0003oooooool0P_ooo`00F_oo
o`03o`2Ioooooooo03;oool00`0003?o03?o0009<ol000<0003oooooool0P_ooo`00F_ooo`03o`2I
oooooooo03;oool200002S?o00030000oooooooo08;oool005[oool00ol0VOooooooo`0boooo00<0
000co`0co`002C?o00030000oooooooo08;oool005[oool00ol0VOooooooo`0boooo00<0000co`0c
o`002C?o00030000oooooooo08;oool005[oool00ol0VOooooooo`0boooo00<0000co`0co`0023?o
00030000oooooooo08?oool005[oool00ol0VOooooooo`0[oooo0P0000Goool00`0003?o03?o0008
<ol000<0003oooooool0Poooo`00F_ooo`03o`2Ioooooooo02[oool010000?ooooooo`0000Coool0
0`0003?o03?o0008<ol000<0003oooooool0Poooo`00F_ooo`03o`2Ioooooooo02coool00`000?oo
ooooo`03oooo0`0000Pco`000`000?ooooooo`23oooo001Joooo00?o09Woooooool0;Oooo`030000
oooooooo00;oool00`0003?o03?o0008<ol000<0003oooooool0Poooo`00F_ooo`03o`2Ioooooooo
02[oool010000?ooooooo`0000Coool00`0003?o03?o0008<ol000<0003oooooool0Poooo`00F_oo
o`03o`2Ioooooooo02_oool200001Oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001J
oooo00?o09Woooooool0<_ooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001Joooo00?o
09Woooooool0<_ooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001Joooo00?o09Wooooo
ool0<_ooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001Joooo00?o09Woooooool0<_oo
o`800008<ol000<0003oooooool0Q?ooo`00F_ooo`03o`2Ioooooooo03;oool00`0003?o03?o0007
<ol000<0003oooooool0Q?ooo`00F_ooo`03o`2Ioooooooo03;oool00`0003?o03?o0007<ol000<0
003oooooool0Q?ooo`00F_ooo`03o`2Ioooooooo03;oool00`0003?o03?o0007<ol000<0003ooooo
ool0Q?ooo`00F_ooo`03o`2Ioooooooo03;oool00`0003?o03?o0006<ol000<0003oooooool0QOoo
o`00F_ooo`03o`2Ioooooooo03;oool00`0003?o03?o0006<ol000<0003oooooool0QOooo`00F_oo
o`03o`2Ioooooooo03;oool200001c?o00030000oooooooo08Goool005[oool00ol0VOooooooo`0b
oooo00<0000co`0co`001S?o00030000oooooooo08Goool005[oool00ol0VOooooooo`0boooo00<0
000co`0co`001S?o00030000oooooooo08Goool005[oool00ol0VOooooooo`0boooo00<0000co`0c
o`001S?o00030000oooooooo08Goool005[oool00ol0VOooooooo`0boooo00<0000co`0co`001S?o
00030000oooooooo08Goool005[oool00ol0VOooooooo`0boooo00<0000co`0co`001S?o00030000
oooooooo08Goool005[oool00ol0VOooooooo`0boooo0P0000Hco`000`000?ooooooo`26oooo001J
oooo00?o09Woooooool0<_ooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001Joooo00?o
09Woooooool0<_ooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001Joooo00?o09Wooooo
ool0<_ooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001Joooo00?o09Woooooool0<_oo
o`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001Joooo00?o09Woooooool0<_ooo`030000
<ol0<ol000Dco`000`000?ooooooo`26oooo001Joooo00?o09Woooooool0<_ooo`800006<ol000<0
003oooooool0Q_ooo`00F_ooo`03o`2Ioooooooo03;oool00`0003?o03?o0005<ol000<0003ooooo
ool0Q_ooo`00F_ooo`03o`2Ioooooooo03;oool00`0003?o03?o0005<ol000<0003oooooool0Q_oo
o`00F_ooo`03o`2Ioooooooo03;oool00`0003?o03?o0004<ol000<0003oooooool0Qoooo`00F_oo
o`03o`2Ioooooooo03;oool00`0003?o03?o0004<ol000<0003oooooool0Qoooo`00F_ooo`03o`2I
oooooooo02coool300000oooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001Joooo00?o
09Woooooool0;Oooo`030000oooooooo00;oool00`0003?o03?o0004<ol000<0003oooooool0Qooo
o`00F_ooo`03o`2Ioooooooo02[oool500000oooo`<00004<ol000<0003oooooool0Qoooo`00Qooo
o`040000oooooooo00001?ooo`Lco`2:oooo0028oooo00<0003oool000001?ooo`Lco`2:oooo0029
oooo0P0000Coool7<ol0R_ooo`00Soooo`Lco`2:oooo002?oooo1c?o08[oool007Woool00`000?oo
ooooo`0Coooo1c?o00koool00`000?ooooooo`1ioooo001hoooo00<0003oooooool02?ooo`030000
oooooooo00Woool7<ol03oooo`030000oooooooo07Soool007Soool00`000?ooooooo`02oooo0P00
00Coool00`000?ooooooo`07oooo0P0000@co`02000000<co`3oooooool01@000003oooo00000000
00800003oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool01Oooo`040000oooooooo00001S?o00Coool01@000?oooooooooo
o`000006oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo00;oool00`000?ooooooo`0=
oooo00@0003oooooool00006<ol01?ooo`030000oooooooo00;oool00`000?ooooooo`04oooo00<0
003oooooool0Moooo`00N?ooo`030000oooooooo00D0000<oooo00@0003oooooool00006<ol01?oo
o`030000oooooooo00?oool00`000?ooooooo`02oooo00<0003oooooool0N?ooo`00N?ooo`050000
oooooooooooo000000ooool010000?ooooooo`0000Hco`04oooo00D0003oooooooooool000000_oo
o`050000oooooooooooo000007[oool007Woool00`000?ooooooo`0Aoooo0P0000Lco`03oooo0P00
00Coool200000oooo`030000oooooooo07Woool008ooool7<ol0R_ooo`00Soooo`Lco`2:oooo0000
\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.14) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.27193 .12361 L
.28302 .12361 L
.2881 .12361 L
.29088 .12361 L
.29224 .12361 L
.29349 .12361 L
.29462 .12361 L
s
.29462 .12361 m
.29506 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.14) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`09oooo00<0003ooooo
ool01Oooo`05o`2Ioooooooooooo000000_oool00`000?ooooooo`09oooo00<0003oooooool02Ooo
o`030000oooooooo00Woool00`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol0
00Tco`000`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Hco`0R00001_oo
o`030000oooooooo00Woool00`000?ooooooo`0Eoooo000Foooo00<0003oooooool0>_ooo`030000
oooooooo00Goool00ol0VOooooooo`0aoooo00<0000co`0co`00>C?o00T0000doooo00<0003ooooo
ool05Oooo`00Foooo`03o`2Ioooooooo037oool00`0003?o03?o000c<ol01P0005Goool005_oool0
0ol0VOooooooo`0aoooo00<0000co`0co`00<C?o0080001Koooo001Koooo00?o09Woooooool0<Ooo
o`030000<ol0<ol002lco`020000GOooo`00Foooo`03o`2Ioooooooo037oool00`0003?o03?o000/
<ol00`0005ooool005_oool00ol0VOooooooo`0aoooo0P0002Xco`030000H_ooo`00Foooo`03o`2I
oooooooo037oool00`0003?o03?o000W<ol00P0006Goool005_oool00ol0VOooooooo`0aoooo00<0
000co`0co`009S?o00030000oooooooo06Goool005_oool00ol0VOooooooo`0aoooo00<0000co`0c
o`009C?o00030000oooooooo06Koool005_oool00ol0VOooooooo`0aoooo00<0000co`0co`0093?o
00030000oooooooo06Ooool005_oool00ol0VOooooooo`0aoooo00<0000co`0co`008S?o0080001Z
oooo001Koooo00?o09Woooooool0<Oooo`80000R<ol000<0003oooooool0J_ooo`00Foooo`03o`2I
oooooooo037oool00`0003?o03?o000P<ol000<0003oooooool0Joooo`00Foooo`03o`2Ioooooooo
037oool00`0003?o03?o000O<ol000<0003oooooool0K?ooo`00Foooo`03o`2Ioooooooo037oool0
0`0003?o03?o000O<ol000<0003oooooool0K?ooo`00Foooo`03o`2Ioooooooo037oool00`0003?o
03?o000N<ol000<0003oooooool0KOooo`00Foooo`03o`2Ioooooooo037oool00`0003?o03?o000M
<ol000<0003oooooool0K_ooo`00Foooo`03o`2Ioooooooo037oool200007C?o00030000oooooooo
06ooool005_oool00ol0VOooooooo`0aoooo00<0000co`0co`006c?o00030000oooooooo073oool0
05_oool00ol0VOooooooo`0aoooo00<0000co`0co`006c?o00030000oooooooo073oool005_oool0
0ol0VOooooooo`0aoooo00<0000co`0co`006S?o00030000oooooooo077oool005_oool00ol0VOoo
ooooo`0aoooo00<0000co`0co`006S?o00030000oooooooo077oool005_oool00ol0VOooooooo`0a
oooo00<0000co`0co`006C?o00030000oooooooo07;oool005_oool00ol0VOooooooo`0aoooo0P00
01Xco`000`000?ooooooo`1boooo001Koooo00?o09Woooooool0<Oooo`030000<ol0<ol001Pco`00
0`000?ooooooo`1coooo001Koooo00?o09Woooooool0<Oooo`030000<ol0<ol001Pco`000`000?oo
ooooo`1coooo001Koooo00?o09Woooooool0<Oooo`030000<ol0<ol001Lco`000`000?ooooooo`1d
oooo001Koooo00?o09Woooooool0<Oooo`030000<ol0<ol001Lco`000`000?ooooooo`1doooo001K
oooo00?o09Woooooool0:Oooo`D00003oooo00<0000co`0co`005S?o00030000oooooooo07Goool0
05_oool00ol0VOooooooo`0[oooo00<0003oooooool00oooo`030000<ol0<ol001Hco`000`000?oo
ooooo`1eoooo001Koooo00?o09Woooooool0:oooo`030000oooooooo00?oool300005C?o00030000
oooooooo07Koool005_oool00ol0VOooooooo`0[oooo00<0003oooooool00oooo`030000<ol0<ol0
01Dco`000`000?ooooooo`1foooo001Koooo00?o09Woooooool0:oooo`030000oooooooo00?oool0
0`0003?o03?o000E<ol000<0003oooooool0M_ooo`00Foooo`03o`2Ioooooooo02[oool200001Ooo
o`030000<ol0<ol001@co`000`000?ooooooo`1goooo001Koooo00?o09Woooooool0<Oooo`030000
<ol0<ol001@co`000`000?ooooooo`1goooo001Koooo00?o09Woooooool0<Oooo`030000<ol0<ol0
01<co`000`000?ooooooo`1hoooo001Koooo00?o09Woooooool0<Oooo`80000D<ol000<0003ooooo
ool0N?ooo`00Foooo`03o`2Ioooooooo037oool00`0003?o03?o000C<ol000<0003oooooool0N?oo
o`00Foooo`03o`2Ioooooooo037oool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00Fooo
o`03o`2Ioooooooo037oool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00Foooo`03o`2I
oooooooo037oool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00Foooo`03o`2Ioooooooo
037oool00`0003?o03?o000A<ol000<0003oooooool0N_ooo`00Foooo`03o`2Ioooooooo037oool2
00004S?o00030000oooooooo07[oool005_oool00ol0VOooooooo`0aoooo00<0000co`0co`004C?o
00030000oooooooo07[oool005_oool00ol0VOooooooo`0aoooo00<0000co`0co`004C?o00030000
oooooooo07[oool005_oool00ol0VOooooooo`0aoooo00<0000co`0co`0043?o00030000oooooooo
07_oool005_oool00ol0VOooooooo`0aoooo00<0000co`0co`0043?o00030000oooooooo07_oool0
05_oool00ol0VOooooooo`0aoooo00<0000co`0co`0043?o00030000oooooooo07_oool005_oool0
0ol0VOooooooo`0aoooo00<0000co`0co`0043?o00030000oooooooo07_oool005_oool00ol0VOoo
ooooo`0aoooo0P00010co`000`000?ooooooo`1loooo001Koooo00?o09Woooooool0<Oooo`030000
<ol0<ol000lco`000`000?ooooooo`1loooo001Koooo00?o09Woooooool0<Oooo`030000<ol0<ol0
00lco`000`000?ooooooo`1loooo001Koooo00?o09Woooooool0<Oooo`030000<ol0<ol000lco`00
0`000?ooooooo`1loooo001Koooo00?o09Woooooool0<Oooo`030000<ol0<ol000lco`000`000?oo
ooooo`1loooo001Koooo00?o09Woooooool0<Oooo`030000<ol0<ol000hco`000`000?ooooooo`1m
oooo001Koooo00?o09Woooooool0<Oooo`80000?<ol000<0003oooooool0OOooo`00Foooo`03o`2I
oooooooo037oool00`0003?o03?o000><ol000<0003oooooool0OOooo`00Foooo`03o`2Ioooooooo
037oool00`0003?o03?o000><ol000<0003oooooool0OOooo`00Foooo`03o`2Ioooooooo037oool0
0`0003?o03?o000=<ol000<0003oooooool0O_ooo`00Foooo`03o`2Ioooooooo02Woool400001?oo
o`030000<ol0<ol000dco`000`000?ooooooo`1noooo001Koooo00?o09Woooooool0:Oooo`030000
oooooooo00Goool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00Foooo`03o`2Ioooooooo
02[oool00`000?ooooooo`04oooo0`0000dco`000`000?ooooooo`1noooo001Koooo00?o09Wooooo
ool0:oooo`030000oooooooo00?oool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00Fooo
o`03o`2Ioooooooo02Woool010000?ooooooo`0000Coool00`0003?o03?o000<<ol000<0003ooooo
ool0Ooooo`00Foooo`03o`2Ioooooooo02[oool200001Oooo`030000<ol0<ol000`co`000`000?oo
ooooo`1ooooo001Koooo00?o09Woooooool0<Oooo`030000<ol0<ol000`co`000`000?ooooooo`1o
oooo001Koooo00?o09Woooooool0<Oooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001K
oooo00?o09Woooooool0<Oooo`80000=<ol000<0003oooooool0Ooooo`00Foooo`03o`2Ioooooooo
037oool00`0003?o03?o000<<ol000<0003oooooool0Ooooo`00Foooo`03o`2Ioooooooo037oool0
0`0003?o03?o000;<ol000<0003oooooool0P?ooo`00Foooo`03o`2Ioooooooo037oool00`0003?o
03?o000;<ol000<0003oooooool0P?ooo`00Foooo`03o`2Ioooooooo037oool00`0003?o03?o000;
<ol000<0003oooooool0P?ooo`00Foooo`03o`2Ioooooooo037oool00`0003?o03?o000;<ol000<0
003oooooool0P?ooo`00Foooo`03o`2Ioooooooo037oool00`0003?o03?o000;<ol000<0003ooooo
ool0P?ooo`00Foooo`03o`2Ioooooooo037oool2000033?o00030000oooooooo083oool005_oool0
0ol0VOooooooo`0aoooo00<0000co`0co`002c?o00030000oooooooo083oool005_oool00ol0VOoo
ooooo`0aoooo00<0000co`0co`002S?o00030000oooooooo087oool005_oool00ol0VOooooooo`0a
oooo00<0000co`0co`002S?o00030000oooooooo087oool005_oool00ol0VOooooooo`0aoooo00<0
000co`0co`002S?o00030000oooooooo087oool005_oool00ol0VOooooooo`0aoooo00<0000co`0c
o`002S?o00030000oooooooo087oool005_oool00ol0VOooooooo`0aoooo0P0000/co`000`000?oo
ooooo`21oooo001Koooo00?o09Woooooool0<Oooo`030000<ol0<ol000Xco`000`000?ooooooo`21
oooo001Koooo00?o09Woooooool0<Oooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001K
oooo00?o09Woooooool0<Oooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001Koooo00?o
09Woooooool0<Oooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001Koooo00?o09Wooooo
ool0<Oooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001Koooo00?o09Woooooool0<Ooo
o`80000:<ol000<0003oooooool0P_ooo`00Foooo`03o`2Ioooooooo037oool00`0003?o03?o0009
<ol000<0003oooooool0P_ooo`00Foooo`03o`2Ioooooooo037oool00`0003?o03?o0009<ol000<0
003oooooool0P_ooo`00Foooo`03o`2Ioooooooo037oool00`0003?o03?o0008<ol000<0003ooooo
ool0Poooo`00Foooo`03o`2Ioooooooo02[oool200001Oooo`030000<ol0<ol000Pco`000`000?oo
ooooo`23oooo001Koooo00?o09Woooooool0:Oooo`040000oooooooo00001?ooo`030000<ol0<ol0
00Pco`000`000?ooooooo`23oooo001Koooo00?o09Woooooool0:oooo`030000oooooooo00?oool3
000023?o00030000oooooooo08?oool005_oool00ol0VOooooooo`0/oooo00<0003oooooool00_oo
o`030000<ol0<ol000Pco`000`000?ooooooo`23oooo001Koooo00?o09Woooooool0:Oooo`040000
oooooooo00001?ooo`030000<ol0<ol000Pco`000`000?ooooooo`23oooo001Koooo00?o09Wooooo
ool0:_ooo`800005oooo00<0000co`0co`001c?o00030000oooooooo08Coool005_oool00ol0VOoo
ooooo`0aoooo00<0000co`0co`001c?o00030000oooooooo08Coool005_oool00ol0VOooooooo`0a
oooo00<0000co`0co`001c?o00030000oooooooo08Coool005_oool00ol0VOooooooo`0aoooo00<0
000co`0co`001c?o00030000oooooooo08Coool005_oool00ol0VOooooooo`0aoooo0P0000Pco`00
0`000?ooooooo`24oooo001Koooo00?o09Woooooool0<Oooo`030000<ol0<ol000Lco`000`000?oo
ooooo`24oooo001Koooo00?o09Woooooool0<Oooo`030000<ol0<ol000Lco`000`000?ooooooo`24
oooo001Koooo00?o09Woooooool0<Oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001K
oooo00?o09Woooooool0<Oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001Koooo00?o
09Woooooool0<Oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001Koooo00?o09Wooooo
ool0<Oooo`800007<ol000<0003oooooool0QOooo`00Foooo`03o`2Ioooooooo037oool00`0003?o
03?o0006<ol000<0003oooooool0QOooo`00Foooo`03o`2Ioooooooo037oool00`0003?o03?o0006
<ol000<0003oooooool0QOooo`00Foooo`03o`2Ioooooooo037oool00`0003?o03?o0006<ol000<0
003oooooool0QOooo`00Foooo`03o`2Ioooooooo037oool00`0003?o03?o0006<ol000<0003ooooo
ool0QOooo`00Foooo`03o`2Ioooooooo037oool00`0003?o03?o0006<ol000<0003oooooool0QOoo
o`00Foooo`03o`2Ioooooooo037oool200001S?o00030000oooooooo08Koool005_oool00ol0VOoo
ooooo`0aoooo00<0000co`0co`001C?o00030000oooooooo08Koool005_oool00ol0VOooooooo`0a
oooo00<0000co`0co`001C?o00030000oooooooo08Koool005_oool00ol0VOooooooo`0aoooo00<0
000co`0co`001C?o00030000oooooooo08Koool005_oool00ol0VOooooooo`0aoooo00<0000co`0c
o`001C?o00030000oooooooo08Koool005_oool00ol0VOooooooo`0aoooo00<0000co`0co`001C?o
00030000oooooooo08Koool005_oool00ol0VOooooooo`0aoooo0P0000Hco`000`000?ooooooo`26
oooo001Koooo00?o09Woooooool0<Oooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001K
oooo00?o09Woooooool0<Oooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001Koooo00?o
09Woooooool0<Oooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001Koooo00?o09Wooooo
ool0<Oooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001Koooo00?o09Woooooool0:ooo
o`<00003oooo00<0000co`0co`0013?o00030000oooooooo08Ooool005_oool00ol0VOooooooo`0/
oooo00<0003oooooool00_ooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001Koooo00?o
09Woooooool0:Oooo`D00003oooo0`0000@co`000`000?ooooooo`27oooo0027oooo00@0003ooooo
ool00004oooo1c?o08[oool008Soool00`000?ooo`000004oooo1c?o08[oool008Woool200001?oo
o`Lco`2:oooo002?oooo1c?o08[oool008ooool7<ol0R_ooo`00NOooo`030000oooooooo01?oool7
<ol03_ooo`030000oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool02Ooo
o`Lco`0?oooo00<0003oooooool0N?ooo`00N?ooo`030000oooooooo00;oool200001?ooo`030000
oooooooo00Ooool2000013?o008000000c?o0?ooooooo`0500000oooo`<00002oooo00<0003ooooo
ool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003ooooo
ool01Oooo`040000oooooooo00001S?o00Coool00`000?ooooooo`04oooo00D0003oooooooooool0
0000N_ooo`00Moooo`030000oooooooo00;oool00`000?ooooooo`0=oooo00@0003oooooool00006
<ol01?ooo`040000oooooooooooo1@0000?oool00`000?ooooooo`1goooo001hoooo00<0003ooooo
ool01@0000coool010000?ooooooo`0000Hco`04oooo00D0003oooooooooool000000_ooo`050000
oooooooooooo000007[oool007Soool01@000?ooooooooooo`00000?oooo00@0003oooooool00006
<ol01?ooo`030000oooooooo00;oool00`000?ooo`000003oooo00<0003oooooool0N?ooo`00NOoo
o`030000oooooooo017oool200001c?o00?oool200001Oooo`800002oooo00<0003oooooool0NOoo
o`00Soooo`Lco`2:oooo002?oooo1c?o08[oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.16) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.27193 .12361 L
.28302 .12361 L
.2881 .12361 L
.29349 .12361 L
.2957 .12361 L
.29809 .12361 L
.29879 .12361 L
.29945 .12361 L
s
.29945 .12361 m
.29995 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.16) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`09oooo00<0003ooooo
ool01_ooo`04o`2Ioooooooo00002oooo`030000oooooooo00Woool00`000?ooooooo`09oooo00<0
003oooooool02Oooo`030000<ol0<ol000Tco`000`0003?o03?o0009<ol000<0000co`0co`002C?o
00030000<ol0<ol000Tco`000`0003?o03?o0009<ol000<0000co`0co`001S?o02800006oooo00<0
003oooooool02Oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0joooo00<0003ooooo
ool01_ooo`03o`2Ioooooooo033oool00`0003?o03?o000i<ol02@0003Coool00`000?ooooooo`0E
oooo001Loooo00?o09Woooooool0<?ooo`030000<ol0<ol003<co`060000EOooo`00G?ooo`03o`2I
oooooooo033oool00`0003?o03?o000a<ol00P0005_oool005coool00ol0VOooooooo`0`oooo00<0
000co`0co`00;c?o0080001Moooo001Loooo00?o09Woooooool0<?ooo`030000<ol0<ol002`co`03
0000Goooo`00G?ooo`03o`2Ioooooooo033oool20000:S?o00<0001Roooo001Loooo00?o09Wooooo
ool0<?ooo`030000<ol0<ol002Lco`020000IOooo`00G?ooo`03o`2Ioooooooo033oool00`0003?o
03?o000V<ol000<0003oooooool0IOooo`00G?ooo`03o`2Ioooooooo033oool00`0003?o03?o000U
<ol000<0003oooooool0I_ooo`00G?ooo`03o`2Ioooooooo033oool00`0003?o03?o000T<ol000<0
003oooooool0Ioooo`00G?ooo`03o`2Ioooooooo033oool00`0003?o03?o000R<ol00P0006[oool0
05coool00ol0VOooooooo`0`oooo0P00028co`000`000?ooooooo`1Zoooo001Loooo00?o09Wooooo
ool0<?ooo`030000<ol0<ol0020co`000`000?ooooooo`1[oooo001Loooo00?o09Woooooool0<?oo
o`030000<ol0<ol001lco`000`000?ooooooo`1/oooo001Loooo00?o09Woooooool0<?ooo`030000
<ol0<ol001lco`000`000?ooooooo`1/oooo001Loooo00?o09Woooooool0<?ooo`030000<ol0<ol0
01hco`000`000?ooooooo`1]oooo001Loooo00?o09Woooooool0<?ooo`030000<ol0<ol001dco`00
0`000?ooooooo`1^oooo001Loooo00?o09Woooooool0<?ooo`80000M<ol000<0003oooooool0Kooo
o`00G?ooo`03o`2Ioooooooo033oool00`0003?o03?o000K<ol000<0003oooooool0L?ooo`00G?oo
o`03o`2Ioooooooo033oool00`0003?o03?o000K<ol000<0003oooooool0L?ooo`00G?ooo`03o`2I
oooooooo033oool00`0003?o03?o000J<ol000<0003oooooool0LOooo`00G?ooo`03o`2Ioooooooo
033oool00`0003?o03?o000J<ol000<0003oooooool0LOooo`00G?ooo`03o`2Ioooooooo033oool0
0`0003?o03?o000I<ol000<0003oooooool0L_ooo`00G?ooo`03o`2Ioooooooo033oool200006S?o
00030000oooooooo07;oool005coool00ol0VOooooooo`0`oooo00<0000co`0co`0063?o00030000
oooooooo07?oool005coool00ol0VOooooooo`0`oooo00<0000co`0co`0063?o00030000oooooooo
07?oool005coool00ol0VOooooooo`0`oooo00<0000co`0co`005c?o00030000oooooooo07Coool0
05coool00ol0VOooooooo`0`oooo00<0000co`0co`005c?o00030000oooooooo07Coool005coool0
0ol0VOooooooo`0Xoooo1@0000?oool00`0003?o03?o000F<ol000<0003oooooool0MOooo`00G?oo
o`03o`2Ioooooooo02[oool00`000?ooooooo`03oooo00<0000co`0co`005S?o00030000oooooooo
07Goool005coool00ol0VOooooooo`0Zoooo00<0003oooooool00oooo`<0000E<ol000<0003ooooo
ool0M_ooo`00G?ooo`03o`2Ioooooooo02[oool00`000?ooooooo`03oooo00<0000co`0co`005C?o
00030000oooooooo07Koool005coool00ol0VOooooooo`0Zoooo00<0003oooooool00oooo`030000
<ol0<ol001Dco`000`000?ooooooo`1foooo001Loooo00?o09Woooooool0:Oooo`800005oooo00<0
000co`0co`0053?o00030000oooooooo07Ooool005coool00ol0VOooooooo`0`oooo00<0000co`0c
o`0053?o00030000oooooooo07Ooool005coool00ol0VOooooooo`0`oooo00<0000co`0co`004c?o
00030000oooooooo07Soool005coool00ol0VOooooooo`0`oooo0P0001@co`000`000?ooooooo`1h
oooo001Loooo00?o09Woooooool0<?ooo`030000<ol0<ol001<co`000`000?ooooooo`1hoooo001L
oooo00?o09Woooooool0<?ooo`030000<ol0<ol0018co`000`000?ooooooo`1ioooo001Loooo00?o
09Woooooool0<?ooo`030000<ol0<ol0018co`000`000?ooooooo`1ioooo001Loooo00?o09Wooooo
ool0<?ooo`030000<ol0<ol0018co`000`000?ooooooo`1ioooo001Loooo00?o09Woooooool0<?oo
o`030000<ol0<ol0014co`000`000?ooooooo`1joooo001Loooo00?o09Woooooool0<?ooo`80000B
<ol000<0003oooooool0N_ooo`00G?ooo`03o`2Ioooooooo033oool00`0003?o03?o000A<ol000<0
003oooooool0N_ooo`00G?ooo`03o`2Ioooooooo033oool00`0003?o03?o000A<ol000<0003ooooo
ool0N_ooo`00G?ooo`03o`2Ioooooooo033oool00`0003?o03?o000@<ol000<0003oooooool0Nooo
o`00G?ooo`03o`2Ioooooooo033oool00`0003?o03?o000@<ol000<0003oooooool0Noooo`00G?oo
o`03o`2Ioooooooo033oool00`0003?o03?o000@<ol000<0003oooooool0Noooo`00G?ooo`03o`2I
oooooooo033oool00`0003?o03?o000@<ol000<0003oooooool0Noooo`00G?ooo`03o`2Ioooooooo
033oool2000043?o00030000oooooooo07coool005coool00ol0VOooooooo`0`oooo00<0000co`0c
o`003c?o00030000oooooooo07coool005coool00ol0VOooooooo`0`oooo00<0000co`0co`003c?o
00030000oooooooo07coool005coool00ol0VOooooooo`0`oooo00<0000co`0co`003c?o00030000
oooooooo07coool005coool00ol0VOooooooo`0`oooo00<0000co`0co`003c?o00030000oooooooo
07coool005coool00ol0VOooooooo`0`oooo00<0000co`0co`003S?o00030000oooooooo07goool0
05coool00ol0VOooooooo`0`oooo0P0000lco`000`000?ooooooo`1moooo001Loooo00?o09Wooooo
ool0<?ooo`030000<ol0<ol000hco`000`000?ooooooo`1moooo001Loooo00?o09Woooooool0<?oo
o`030000<ol0<ol000hco`000`000?ooooooo`1moooo001Loooo00?o09Woooooool0<?ooo`030000
<ol0<ol000dco`000`000?ooooooo`1noooo001Loooo00?o09Woooooool0:?ooo`@00004oooo00<0
000co`0co`003C?o00030000oooooooo07koool005coool00ol0VOooooooo`0Xoooo00<0003ooooo
ool01Oooo`030000<ol0<ol000dco`000`000?ooooooo`1noooo001Loooo00?o09Woooooool0:Ooo
o`030000oooooooo00Coool300003C?o00030000oooooooo07koool005coool00ol0VOooooooo`0Z
oooo00<0003oooooool00oooo`030000<ol0<ol000dco`000`000?ooooooo`1noooo001Loooo00?o
09Woooooool0:?ooo`040000oooooooo00001?ooo`030000<ol0<ol000`co`000`000?ooooooo`1o
oooo001Loooo00?o09Woooooool0:Oooo`800005oooo00<0000co`0co`0033?o00030000oooooooo
07ooool005coool00ol0VOooooooo`0`oooo00<0000co`0co`0033?o00030000oooooooo07ooool0
05coool00ol0VOooooooo`0`oooo00<0000co`0co`0033?o00030000oooooooo07ooool005coool0
0ol0VOooooooo`0`oooo0P0000dco`000`000?ooooooo`1ooooo001Loooo00?o09Woooooool0<?oo
o`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001Loooo00?o09Woooooool0<?ooo`030000
<ol0<ol000/co`000`000?ooooooo`20oooo001Loooo00?o09Woooooool0<?ooo`030000<ol0<ol0
00/co`000`000?ooooooo`20oooo001Loooo00?o09Woooooool0<?ooo`030000<ol0<ol000/co`00
0`000?ooooooo`20oooo001Loooo00?o09Woooooool0<?ooo`030000<ol0<ol000/co`000`000?oo
ooooo`20oooo001Loooo00?o09Woooooool0<?ooo`030000<ol0<ol000/co`000`000?ooooooo`20
oooo001Loooo00?o09Woooooool0<?ooo`80000<<ol000<0003oooooool0P?ooo`00G?ooo`03o`2I
oooooooo033oool00`0003?o03?o000;<ol000<0003oooooool0P?ooo`00G?ooo`03o`2Ioooooooo
033oool00`0003?o03?o000:<ol000<0003oooooool0POooo`00G?ooo`03o`2Ioooooooo033oool0
0`0003?o03?o000:<ol000<0003oooooool0POooo`00G?ooo`03o`2Ioooooooo033oool00`0003?o
03?o000:<ol000<0003oooooool0POooo`00G?ooo`03o`2Ioooooooo033oool00`0003?o03?o000:
<ol000<0003oooooool0POooo`00G?ooo`03o`2Ioooooooo033oool200002c?o00030000oooooooo
087oool005coool00ol0VOooooooo`0`oooo00<0000co`0co`002S?o00030000oooooooo087oool0
05coool00ol0VOooooooo`0`oooo00<0000co`0co`002S?o00030000oooooooo087oool005coool0
0ol0VOooooooo`0`oooo00<0000co`0co`002C?o00030000oooooooo08;oool005coool00ol0VOoo
ooooo`0`oooo00<0000co`0co`002C?o00030000oooooooo08;oool005coool00ol0VOooooooo`0`
oooo00<0000co`0co`002C?o00030000oooooooo08;oool005coool00ol0VOooooooo`0`oooo0P00
00Xco`000`000?ooooooo`22oooo001Loooo00?o09Woooooool0<?ooo`030000<ol0<ol000Tco`00
0`000?ooooooo`22oooo001Loooo00?o09Woooooool0<?ooo`030000<ol0<ol000Tco`000`000?oo
ooooo`22oooo001Loooo00?o09Woooooool0<?ooo`030000<ol0<ol000Pco`000`000?ooooooo`23
oooo001Loooo00?o09Woooooool0:Oooo`800005oooo00<0000co`0co`0023?o00030000oooooooo
08?oool005coool00ol0VOooooooo`0Xoooo00@0003oooooool00004oooo00<0000co`0co`0023?o
00030000oooooooo08?oool005coool00ol0VOooooooo`0Zoooo00<0003oooooool00oooo`<00008
<ol000<0003oooooool0Poooo`00G?ooo`03o`2Ioooooooo02_oool00`000?ooooooo`02oooo00<0
000co`0co`0023?o00030000oooooooo08?oool005coool00ol0VOooooooo`0Xoooo00@0003ooooo
ool00004oooo00<0000co`0co`0023?o00030000oooooooo08?oool005coool00ol0VOooooooo`0Y
oooo0P0000Goool00`0003?o03?o0007<ol000<0003oooooool0Q?ooo`00G?ooo`03o`2Ioooooooo
033oool00`0003?o03?o0007<ol000<0003oooooool0Q?ooo`00G?ooo`03o`2Ioooooooo033oool0
0`0003?o03?o0007<ol000<0003oooooool0Q?ooo`00G?ooo`03o`2Ioooooooo033oool00`0003?o
03?o0007<ol000<0003oooooool0Q?ooo`00G?ooo`03o`2Ioooooooo033oool2000023?o00030000
oooooooo08Coool005coool00ol0VOooooooo`0`oooo00<0000co`0co`001c?o00030000oooooooo
08Coool005coool00ol0VOooooooo`0`oooo00<0000co`0co`001c?o00030000oooooooo08Coool0
05coool00ol0VOooooooo`0`oooo00<0000co`0co`001c?o00030000oooooooo08Coool005coool0
0ol0VOooooooo`0`oooo00<0000co`0co`001S?o00030000oooooooo08Goool005coool00ol0VOoo
ooooo`0`oooo00<0000co`0co`001S?o00030000oooooooo08Goool005coool00ol0VOooooooo`0`
oooo0P0000Lco`000`000?ooooooo`25oooo001Loooo00?o09Woooooool0<?ooo`030000<ol0<ol0
00Hco`000`000?ooooooo`25oooo001Loooo00?o09Woooooool0<?ooo`030000<ol0<ol000Hco`00
0`000?ooooooo`25oooo001Loooo00?o09Woooooool0<?ooo`030000<ol0<ol000Hco`000`000?oo
ooooo`25oooo001Loooo00?o09Woooooool0<?ooo`030000<ol0<ol000Hco`000`000?ooooooo`25
oooo001Loooo00?o09Woooooool0<?ooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001L
oooo00?o09Woooooool0<?ooo`800006<ol000<0003oooooool0Q_ooo`00G?ooo`03o`2Ioooooooo
033oool00`0003?o03?o0005<ol000<0003oooooool0Q_ooo`00G?ooo`03o`2Ioooooooo033oool0
0`0003?o03?o0005<ol000<0003oooooool0Q_ooo`00G?ooo`03o`2Ioooooooo033oool00`0003?o
03?o0005<ol000<0003oooooool0Q_ooo`00G?ooo`03o`2Ioooooooo033oool00`0003?o03?o0005
<ol000<0003oooooool0Q_ooo`00G?ooo`03o`2Ioooooooo033oool00`0003?o03?o0005<ol000<0
003oooooool0Q_ooo`00G?ooo`03o`2Ioooooooo033oool200001S?o00030000oooooooo08Koool0
05coool00ol0VOooooooo`0`oooo00<0000co`0co`001C?o00030000oooooooo08Koool005coool0
0ol0VOooooooo`0`oooo00<0000co`0co`001C?o00030000oooooooo08Koool005coool00ol0VOoo
ooooo`0`oooo00<0000co`0co`0013?o00030000oooooooo08Ooool005coool00ol0VOooooooo`0`
oooo00<0000co`0co`0013?o00030000oooooooo08Ooool005coool00ol0VOooooooo`0Zoooo0`00
00?oool00`0003?o03?o0004<ol000<0003oooooool0Qoooo`00G?ooo`03o`2Ioooooooo02_oool0
0`000?ooooooo`02oooo00<0000co`0co`0013?o00030000oooooooo08Ooool005coool00ol0VOoo
ooooo`0Xoooo1@0000?oool3000013?o00030000oooooooo08Ooool008Ooool010000?ooooooo`00
00Coool7<ol0R_ooo`00R?ooo`030000oooo000000Coool7<ol0R_ooo`00ROooo`800004oooo1c?o
08[oool008ooool7<ol0R_ooo`00Soooo`Lco`2:oooo001ioooo00<0003oooooool04oooo`Lco`0>
oooo00<0003oooooool0NOooo`00N?ooo`030000oooooooo00Soool00`000?ooooooo`09oooo1c?o
00ooool00`000?ooooooo`1hoooo001hoooo00<0003oooooool00_ooo`800004oooo00<0003ooooo
ool01oooo`800004<ol00P000003<ol0oooooooo00D000001?ooo`000000000000Coool00`000?oo
ooooo`1hoooo001hoooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?oo
ooooo`05oooo00@0003oooooool00006<ol01?ooo`050000oooooooooooo000000;oool01@000?oo
ooooooooo`00001joooo001goooo00<0003oooooool00_ooo`030000oooooooo00goool010000?oo
ooooo`0000Hco`04oooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?oo
ooooo`1goooo001hoooo00<0003oooooool01@0000coool010000?ooooooo`0000Hco`04oooo00@0
003oooooooooool300001?ooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`00000?
oooo00@0003oooooool00006<ol01?ooo`030000oooooooo00;oool00`000?ooooooo`03oooo00<0
003oooooool0N?ooo`00NOooo`030000oooooooo017oool200001c?o00?oool200001?ooo`<00002
oooo00<0003oooooool0NOooo`00Soooo`Lco`2:oooo002?oooo1c?o08[oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.18) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.29205 .12361 L
.29779 .12361 L
.30059 .12361 L
.30182 .12361 L
.30316 .12361 L
.30442 .12361 L
s
.30442 .12361 m
.30489 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.18) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`09oooo00<0003ooooo
ool01oooo`03o`2Ioooo000000_oool00`000?ooooooo`09oooo00<0003oooooool02Oooo`030000
oooooooo00Woool00`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Tco`00
0`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Hco`0R00001_ooo`030000
oooooooo00Woool00`000?ooooooo`0Eoooo000Foooo00<0003oooooool0>_ooo`030000oooooooo
00Ooool00ol0VOooooooo`0_oooo00<0000co`0co`00>C?o00T0000doooo00<0003oooooool05Ooo
o`00GOooo`03o`2Ioooooooo02ooool00`0003?o03?o000c<ol01P0005Goool005goool00ol0VOoo
ooooo`0_oooo00<0000co`0co`00<C?o0080001Koooo001Moooo00?o09Woooooool0;oooo`030000
<ol0<ol002lco`020000GOooo`00GOooo`03o`2Ioooooooo02ooool00`0003?o03?o000/<ol00`00
05ooool005goool00ol0VOooooooo`0_oooo0P0002Xco`030000H_ooo`00GOooo`03o`2Ioooooooo
02ooool00`0003?o03?o000W<ol00P0006Goool005goool00ol0VOooooooo`0_oooo00<0000co`0c
o`009S?o00030000oooooooo06Goool005goool00ol0VOooooooo`0_oooo00<0000co`0co`009C?o
00030000oooooooo06Koool005goool00ol0VOooooooo`0_oooo00<0000co`0co`0093?o00030000
oooooooo06Ooool005goool00ol0VOooooooo`0_oooo00<0000co`0co`008S?o0080001Zoooo001M
oooo00?o09Woooooool0;oooo`80000R<ol000<0003oooooool0J_ooo`00GOooo`03o`2Ioooooooo
02ooool00`0003?o03?o000P<ol000<0003oooooool0Joooo`00GOooo`03o`2Ioooooooo02ooool0
0`0003?o03?o000O<ol000<0003oooooool0K?ooo`00GOooo`03o`2Ioooooooo02ooool00`0003?o
03?o000O<ol000<0003oooooool0K?ooo`00GOooo`03o`2Ioooooooo02ooool00`0003?o03?o000N
<ol000<0003oooooool0KOooo`00GOooo`03o`2Ioooooooo02ooool00`0003?o03?o000M<ol000<0
003oooooool0K_ooo`00GOooo`03o`2Ioooooooo02ooool200007C?o00030000oooooooo06ooool0
05goool00ol0VOooooooo`0_oooo00<0000co`0co`006c?o00030000oooooooo073oool005goool0
0ol0VOooooooo`0_oooo00<0000co`0co`006c?o00030000oooooooo073oool005goool00ol0VOoo
ooooo`0_oooo00<0000co`0co`006S?o00030000oooooooo077oool005goool00ol0VOooooooo`0_
oooo00<0000co`0co`006S?o00030000oooooooo077oool005goool00ol0VOooooooo`0_oooo00<0
000co`0co`006C?o00030000oooooooo07;oool005goool00ol0VOooooooo`0_oooo0P0001Xco`00
0`000?ooooooo`1boooo001Moooo00?o09Woooooool0;oooo`030000<ol0<ol001Pco`000`000?oo
ooooo`1coooo001Moooo00?o09Woooooool0;oooo`030000<ol0<ol001Pco`000`000?ooooooo`1c
oooo001Moooo00?o09Woooooool0;oooo`030000<ol0<ol001Lco`000`000?ooooooo`1doooo001M
oooo00?o09Woooooool0;oooo`030000<ol0<ol001Lco`000`000?ooooooo`1doooo001Moooo00?o
09Woooooool09oooo`D00003oooo00<0000co`0co`005S?o00030000oooooooo07Goool005goool0
0ol0VOooooooo`0Yoooo00<0003oooooool00oooo`030000<ol0<ol001Hco`000`000?ooooooo`1e
oooo001Moooo00?o09Woooooool0:Oooo`030000oooooooo00?oool300005C?o00030000oooooooo
07Koool005goool00ol0VOooooooo`0Yoooo00<0003oooooool00oooo`030000<ol0<ol001Dco`00
0`000?ooooooo`1foooo001Moooo00?o09Woooooool0:Oooo`030000oooooooo00?oool00`0003?o
03?o000E<ol000<0003oooooool0M_ooo`00GOooo`03o`2Ioooooooo02Soool200001Oooo`030000
<ol0<ol001@co`000`000?ooooooo`1goooo001Moooo00?o09Woooooool0;oooo`030000<ol0<ol0
01@co`000`000?ooooooo`1goooo001Moooo00?o09Woooooool0;oooo`030000<ol0<ol001<co`00
0`000?ooooooo`1hoooo001Moooo00?o09Woooooool0;oooo`80000D<ol000<0003oooooool0N?oo
o`00GOooo`03o`2Ioooooooo02ooool00`0003?o03?o000C<ol000<0003oooooool0N?ooo`00GOoo
o`03o`2Ioooooooo02ooool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00GOooo`03o`2I
oooooooo02ooool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00GOooo`03o`2Ioooooooo
02ooool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00GOooo`03o`2Ioooooooo02ooool0
0`0003?o03?o000A<ol000<0003oooooool0N_ooo`00GOooo`03o`2Ioooooooo02ooool200004S?o
00030000oooooooo07[oool005goool00ol0VOooooooo`0_oooo00<0000co`0co`004C?o00030000
oooooooo07[oool005goool00ol0VOooooooo`0_oooo00<0000co`0co`004C?o00030000oooooooo
07[oool005goool00ol0VOooooooo`0_oooo00<0000co`0co`0043?o00030000oooooooo07_oool0
05goool00ol0VOooooooo`0_oooo00<0000co`0co`0043?o00030000oooooooo07_oool005goool0
0ol0VOooooooo`0_oooo00<0000co`0co`0043?o00030000oooooooo07_oool005goool00ol0VOoo
ooooo`0_oooo00<0000co`0co`0043?o00030000oooooooo07_oool005goool00ol0VOooooooo`0_
oooo0P00010co`000`000?ooooooo`1loooo001Moooo00?o09Woooooool0;oooo`030000<ol0<ol0
00lco`000`000?ooooooo`1loooo001Moooo00?o09Woooooool0;oooo`030000<ol0<ol000lco`00
0`000?ooooooo`1loooo001Moooo00?o09Woooooool0;oooo`030000<ol0<ol000lco`000`000?oo
ooooo`1loooo001Moooo00?o09Woooooool0;oooo`030000<ol0<ol000lco`000`000?ooooooo`1l
oooo001Moooo00?o09Woooooool0;oooo`030000<ol0<ol000hco`000`000?ooooooo`1moooo001M
oooo00?o09Woooooool0;oooo`80000?<ol000<0003oooooool0OOooo`00GOooo`03o`2Ioooooooo
02ooool00`0003?o03?o000><ol000<0003oooooool0OOooo`00GOooo`03o`2Ioooooooo02ooool0
0`0003?o03?o000><ol000<0003oooooool0OOooo`00GOooo`03o`2Ioooooooo02ooool00`0003?o
03?o000=<ol000<0003oooooool0O_ooo`00GOooo`03o`2Ioooooooo02Ooool400001?ooo`030000
<ol0<ol000dco`000`000?ooooooo`1noooo001Moooo00?o09Woooooool09oooo`030000oooooooo
00Goool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00GOooo`03o`2Ioooooooo02Soool0
0`000?ooooooo`04oooo0`0000dco`000`000?ooooooo`1noooo001Moooo00?o09Woooooool0:Ooo
o`030000oooooooo00?oool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00GOooo`03o`2I
oooooooo02Ooool010000?ooooooo`0000Coool00`0003?o03?o000<<ol000<0003oooooool0Oooo
o`00GOooo`03o`2Ioooooooo02Soool200001Oooo`030000<ol0<ol000`co`000`000?ooooooo`1o
oooo001Moooo00?o09Woooooool0;oooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001M
oooo00?o09Woooooool0;oooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001Moooo00?o
09Woooooool0;oooo`80000=<ol000<0003oooooool0Ooooo`00GOooo`03o`2Ioooooooo02ooool0
0`0003?o03?o000<<ol000<0003oooooool0Ooooo`00GOooo`03o`2Ioooooooo02ooool00`0003?o
03?o000;<ol000<0003oooooool0P?ooo`00GOooo`03o`2Ioooooooo02ooool00`0003?o03?o000;
<ol000<0003oooooool0P?ooo`00GOooo`03o`2Ioooooooo02ooool00`0003?o03?o000;<ol000<0
003oooooool0P?ooo`00GOooo`03o`2Ioooooooo02ooool00`0003?o03?o000;<ol000<0003ooooo
ool0P?ooo`00GOooo`03o`2Ioooooooo02ooool00`0003?o03?o000;<ol000<0003oooooool0P?oo
o`00GOooo`03o`2Ioooooooo02ooool2000033?o00030000oooooooo083oool005goool00ol0VOoo
ooooo`0_oooo00<0000co`0co`002c?o00030000oooooooo083oool005goool00ol0VOooooooo`0_
oooo00<0000co`0co`002S?o00030000oooooooo087oool005goool00ol0VOooooooo`0_oooo00<0
000co`0co`002S?o00030000oooooooo087oool005goool00ol0VOooooooo`0_oooo00<0000co`0c
o`002S?o00030000oooooooo087oool005goool00ol0VOooooooo`0_oooo00<0000co`0co`002S?o
00030000oooooooo087oool005goool00ol0VOooooooo`0_oooo0P0000/co`000`000?ooooooo`21
oooo001Moooo00?o09Woooooool0;oooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001M
oooo00?o09Woooooool0;oooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001Moooo00?o
09Woooooool0;oooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001Moooo00?o09Wooooo
ool0;oooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001Moooo00?o09Woooooool0;ooo
o`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001Moooo00?o09Woooooool0;oooo`80000:
<ol000<0003oooooool0P_ooo`00GOooo`03o`2Ioooooooo02ooool00`0003?o03?o0009<ol000<0
003oooooool0P_ooo`00GOooo`03o`2Ioooooooo02ooool00`0003?o03?o0009<ol000<0003ooooo
ool0P_ooo`00GOooo`03o`2Ioooooooo02ooool00`0003?o03?o0008<ol000<0003oooooool0Pooo
o`00GOooo`03o`2Ioooooooo02Soool200001Oooo`030000<ol0<ol000Pco`000`000?ooooooo`23
oooo001Moooo00?o09Woooooool09oooo`040000oooooooo00001?ooo`030000<ol0<ol000Pco`00
0`000?ooooooo`23oooo001Moooo00?o09Woooooool0:Oooo`030000oooooooo00?oool3000023?o
00030000oooooooo08?oool005goool00ol0VOooooooo`0Zoooo00<0003oooooool00_ooo`030000
<ol0<ol000Pco`000`000?ooooooo`23oooo001Moooo00?o09Woooooool09oooo`040000oooooooo
00001?ooo`030000<ol0<ol000Pco`000`000?ooooooo`23oooo001Moooo00?o09Woooooool0:?oo
o`800005oooo00<0000co`0co`001c?o00030000oooooooo08Coool005goool00ol0VOooooooo`0_
oooo00<0000co`0co`001c?o00030000oooooooo08Coool005goool00ol0VOooooooo`0_oooo00<0
000co`0co`001c?o00030000oooooooo08Coool005goool00ol0VOooooooo`0_oooo00<0000co`0c
o`001c?o00030000oooooooo08Coool005goool00ol0VOooooooo`0_oooo0P0000Pco`000`000?oo
ooooo`24oooo001Moooo00?o09Woooooool0;oooo`030000<ol0<ol000Lco`000`000?ooooooo`24
oooo001Moooo00?o09Woooooool0;oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001M
oooo00?o09Woooooool0;oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001Moooo00?o
09Woooooool0;oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001Moooo00?o09Wooooo
ool0;oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001Moooo00?o09Woooooool0;ooo
o`800007<ol000<0003oooooool0QOooo`00GOooo`03o`2Ioooooooo02ooool00`0003?o03?o0006
<ol000<0003oooooool0QOooo`00GOooo`03o`2Ioooooooo02ooool00`0003?o03?o0006<ol000<0
003oooooool0QOooo`00GOooo`03o`2Ioooooooo02ooool00`0003?o03?o0006<ol000<0003ooooo
ool0QOooo`00GOooo`03o`2Ioooooooo02ooool00`0003?o03?o0006<ol000<0003oooooool0QOoo
o`00GOooo`03o`2Ioooooooo02ooool00`0003?o03?o0006<ol000<0003oooooool0QOooo`00GOoo
o`03o`2Ioooooooo02ooool200001S?o00030000oooooooo08Koool005goool00ol0VOooooooo`0_
oooo00<0000co`0co`001C?o00030000oooooooo08Koool005goool00ol0VOooooooo`0_oooo00<0
000co`0co`001C?o00030000oooooooo08Koool005goool00ol0VOooooooo`0_oooo00<0000co`0c
o`001C?o00030000oooooooo08Koool005goool00ol0VOooooooo`0_oooo00<0000co`0co`001C?o
00030000oooooooo08Koool005goool00ol0VOooooooo`0_oooo00<0000co`0co`001C?o00030000
oooooooo08Koool005goool00ol0VOooooooo`0_oooo0P0000Hco`000`000?ooooooo`26oooo001M
oooo00?o09Woooooool0;oooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001Moooo00?o
09Woooooool0;oooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001Moooo00?o09Wooooo
ool0;oooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001Moooo00?o09Woooooool0;ooo
o`030000<ol0<ol000@co`000`000?ooooooo`27oooo001Moooo00?o09Woooooool0:Oooo`<00003
oooo00<0000co`0co`0013?o00030000oooooooo08Ooool005goool00ol0VOooooooo`0Zoooo00<0
003oooooool00_ooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001Moooo00?o09Wooooo
ool09oooo`D00003oooo0`0000@co`000`000?ooooooo`27oooo0027oooo00@0003oooooool00004
oooo1c?o08[oool008Soool00`000?ooo`000004oooo1c?o08[oool008Woool200001?ooo`Lco`2:
oooo002?oooo1c?o08[oool008ooool7<ol0R_ooo`00NOooo`030000oooooooo01?oool7<ol03_oo
o`030000oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool02Oooo`Lco`0?
oooo00<0003oooooool0N?ooo`00N?ooo`030000oooooooo00;oool200001?ooo`030000oooooooo
00Ooool2000013?o008000000c?o0?ooooooo`0500000_ooo`800004oooo00<0003oooooool0N?oo
o`00N?ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01Ooo
o`040000oooooooo00001S?o00Coool01@000?ooooooooooo`000002oooo00D0003oooooooooool0
0000N_ooo`00Moooo`030000oooooooo00;oool00`000?ooooooo`0=oooo00@0003oooooool00006
<ol01?ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003oooooool0Mooo
o`00N?ooo`030000oooooooo00D0000<oooo00@0003oooooool00006<ol01?ooo`030000oooooooo
00;oool200001?ooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`00000?oooo00@0
003oooooool00006<ol01?ooo`050000oooooooooooo000000;oool01@000?ooooooooooo`00001j
oooo001ioooo00<0003oooooool04Oooo`800007<ol00oooo`800004oooo0P0000?oool00`000?oo
ooooo`1ioooo002?oooo1c?o08[oool008ooool7<ol0R_ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.29205 .12361 L
.29779 .12361 L
.30316 .12361 L
.3056 .12361 L
.30791 .12361 L
.30919 .12361 L
s
.30919 .12361 m
.30948 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`09oooo00<0003ooooo
ool02Oooo`030000oooooooo00Woool00`000?ooooooo`09oooo00<0003oooooool02Oooo`030000
oooooooo00Woool00`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Tco`00
0`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Hco`0R00001_ooo`030000
oooooooo00Woool00`000?ooooooo`0Eoooo000Foooo00<0003oooooool0>_ooo`030000oooooooo
00Woool00ol0VOooooooo`0]oooo00<0000co`0co`00>C?o00T0000doooo00<0003oooooool05Ooo
o`00Goooo`03o`2Ioooooooo02goool00`0003?o03?o000c<ol01P0005Goool005ooool00ol0VOoo
ooooo`0]oooo00<0000co`0co`00<C?o0080001Koooo001Ooooo00?o09Woooooool0;Oooo`030000
<ol0<ol002lco`020000GOooo`00Goooo`03o`2Ioooooooo02goool00`0003?o03?o000/<ol00`00
05ooool005ooool00ol0VOooooooo`0]oooo0P0002Xco`030000H_ooo`00Goooo`03o`2Ioooooooo
02goool00`0003?o03?o000W<ol00P0006Goool005ooool00ol0VOooooooo`0]oooo00<0000co`0c
o`009S?o00030000oooooooo06Goool005ooool00ol0VOooooooo`0]oooo00<0000co`0co`009C?o
00030000oooooooo06Koool005ooool00ol0VOooooooo`0]oooo00<0000co`0co`0093?o00030000
oooooooo06Ooool005ooool00ol0VOooooooo`0]oooo00<0000co`0co`008S?o0080001Zoooo001O
oooo00?o09Woooooool0;Oooo`80000R<ol000<0003oooooool0J_ooo`00Goooo`03o`2Ioooooooo
02goool00`0003?o03?o000P<ol000<0003oooooool0Joooo`00Goooo`03o`2Ioooooooo02goool0
0`0003?o03?o000O<ol000<0003oooooool0K?ooo`00Goooo`03o`2Ioooooooo02goool00`0003?o
03?o000O<ol000<0003oooooool0K?ooo`00Goooo`03o`2Ioooooooo02goool00`0003?o03?o000N
<ol000<0003oooooool0KOooo`00Goooo`03o`2Ioooooooo02goool00`0003?o03?o000M<ol000<0
003oooooool0K_ooo`00Goooo`03o`2Ioooooooo02goool200007C?o00030000oooooooo06ooool0
05ooool00ol0VOooooooo`0]oooo00<0000co`0co`006c?o00030000oooooooo073oool005ooool0
0ol0VOooooooo`0]oooo00<0000co`0co`006c?o00030000oooooooo073oool005ooool00ol0VOoo
ooooo`0]oooo00<0000co`0co`006S?o00030000oooooooo077oool005ooool00ol0VOooooooo`0]
oooo00<0000co`0co`006S?o00030000oooooooo077oool005ooool00ol0VOooooooo`0]oooo00<0
000co`0co`006C?o00030000oooooooo07;oool005ooool00ol0VOooooooo`0]oooo0P0001Xco`00
0`000?ooooooo`1boooo001Ooooo00?o09Woooooool0;Oooo`030000<ol0<ol001Pco`000`000?oo
ooooo`1coooo001Ooooo00?o09Woooooool0;Oooo`030000<ol0<ol001Pco`000`000?ooooooo`1c
oooo001Ooooo00?o09Woooooool0;Oooo`030000<ol0<ol001Lco`000`000?ooooooo`1doooo001O
oooo00?o09Woooooool0;Oooo`030000<ol0<ol001Lco`000`000?ooooooo`1doooo001Ooooo00?o
09Woooooool09Oooo`D00003oooo00<0000co`0co`005S?o00030000oooooooo07Goool005ooool0
0ol0VOooooooo`0Woooo00<0003oooooool00oooo`030000<ol0<ol001Hco`000`000?ooooooo`1e
oooo001Ooooo00?o09Woooooool09oooo`030000oooooooo00?oool300005C?o00030000oooooooo
07Koool005ooool00ol0VOooooooo`0Woooo00<0003oooooool00oooo`030000<ol0<ol001Dco`00
0`000?ooooooo`1foooo001Ooooo00?o09Woooooool09oooo`030000oooooooo00?oool00`0003?o
03?o000E<ol000<0003oooooool0M_ooo`00Goooo`03o`2Ioooooooo02Koool200001Oooo`030000
<ol0<ol001@co`000`000?ooooooo`1goooo001Ooooo00?o09Woooooool0;Oooo`030000<ol0<ol0
01@co`000`000?ooooooo`1goooo001Ooooo00?o09Woooooool0;Oooo`030000<ol0<ol001<co`00
0`000?ooooooo`1hoooo001Ooooo00?o09Woooooool0;Oooo`80000D<ol000<0003oooooool0N?oo
o`00Goooo`03o`2Ioooooooo02goool00`0003?o03?o000C<ol000<0003oooooool0N?ooo`00Gooo
o`03o`2Ioooooooo02goool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00Goooo`03o`2I
oooooooo02goool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00Goooo`03o`2Ioooooooo
02goool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00Goooo`03o`2Ioooooooo02goool0
0`0003?o03?o000A<ol000<0003oooooool0N_ooo`00Goooo`03o`2Ioooooooo02goool200004S?o
00030000oooooooo07[oool005ooool00ol0VOooooooo`0]oooo00<0000co`0co`004C?o00030000
oooooooo07[oool005ooool00ol0VOooooooo`0]oooo00<0000co`0co`004C?o00030000oooooooo
07[oool005ooool00ol0VOooooooo`0]oooo00<0000co`0co`0043?o00030000oooooooo07_oool0
05ooool00ol0VOooooooo`0]oooo00<0000co`0co`0043?o00030000oooooooo07_oool005ooool0
0ol0VOooooooo`0]oooo00<0000co`0co`0043?o00030000oooooooo07_oool005ooool00ol0VOoo
ooooo`0]oooo00<0000co`0co`0043?o00030000oooooooo07_oool005ooool00ol0VOooooooo`0]
oooo0P00010co`000`000?ooooooo`1loooo001Ooooo00?o09Woooooool0;Oooo`030000<ol0<ol0
00lco`000`000?ooooooo`1loooo001Ooooo00?o09Woooooool0;Oooo`030000<ol0<ol000lco`00
0`000?ooooooo`1loooo001Ooooo00?o09Woooooool0;Oooo`030000<ol0<ol000lco`000`000?oo
ooooo`1loooo001Ooooo00?o09Woooooool0;Oooo`030000<ol0<ol000lco`000`000?ooooooo`1l
oooo001Ooooo00?o09Woooooool0;Oooo`030000<ol0<ol000hco`000`000?ooooooo`1moooo001O
oooo00?o09Woooooool0;Oooo`80000?<ol000<0003oooooool0OOooo`00Goooo`03o`2Ioooooooo
02goool00`0003?o03?o000><ol000<0003oooooool0OOooo`00Goooo`03o`2Ioooooooo02goool0
0`0003?o03?o000><ol000<0003oooooool0OOooo`00Goooo`03o`2Ioooooooo02goool00`0003?o
03?o000=<ol000<0003oooooool0O_ooo`00Goooo`03o`2Ioooooooo02Goool400001?ooo`030000
<ol0<ol000dco`000`000?ooooooo`1noooo001Ooooo00?o09Woooooool09Oooo`030000oooooooo
00Goool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00Goooo`03o`2Ioooooooo02Koool0
0`000?ooooooo`04oooo0`0000dco`000`000?ooooooo`1noooo001Ooooo00?o09Woooooool09ooo
o`030000oooooooo00?oool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00Goooo`03o`2I
oooooooo02Goool010000?ooooooo`0000Coool00`0003?o03?o000<<ol000<0003oooooool0Oooo
o`00Goooo`03o`2Ioooooooo02Koool200001Oooo`030000<ol0<ol000`co`000`000?ooooooo`1o
oooo001Ooooo00?o09Woooooool0;Oooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001O
oooo00?o09Woooooool0;Oooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001Ooooo00?o
09Woooooool0;Oooo`80000=<ol000<0003oooooool0Ooooo`00Goooo`03o`2Ioooooooo02goool0
0`0003?o03?o000<<ol000<0003oooooool0Ooooo`00Goooo`03o`2Ioooooooo02goool00`0003?o
03?o000;<ol000<0003oooooool0P?ooo`00Goooo`03o`2Ioooooooo02goool00`0003?o03?o000;
<ol000<0003oooooool0P?ooo`00Goooo`03o`2Ioooooooo02goool00`0003?o03?o000;<ol000<0
003oooooool0P?ooo`00Goooo`03o`2Ioooooooo02goool00`0003?o03?o000;<ol000<0003ooooo
ool0P?ooo`00Goooo`03o`2Ioooooooo02goool00`0003?o03?o000;<ol000<0003oooooool0P?oo
o`00Goooo`03o`2Ioooooooo02goool2000033?o00030000oooooooo083oool005ooool00ol0VOoo
ooooo`0]oooo00<0000co`0co`002c?o00030000oooooooo083oool005ooool00ol0VOooooooo`0]
oooo00<0000co`0co`002S?o00030000oooooooo087oool005ooool00ol0VOooooooo`0]oooo00<0
000co`0co`002S?o00030000oooooooo087oool005ooool00ol0VOooooooo`0]oooo00<0000co`0c
o`002S?o00030000oooooooo087oool005ooool00ol0VOooooooo`0]oooo00<0000co`0co`002S?o
00030000oooooooo087oool005ooool00ol0VOooooooo`0]oooo0P0000/co`000`000?ooooooo`21
oooo001Ooooo00?o09Woooooool0;Oooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001O
oooo00?o09Woooooool0;Oooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001Ooooo00?o
09Woooooool0;Oooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001Ooooo00?o09Wooooo
ool0;Oooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001Ooooo00?o09Woooooool0;Ooo
o`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001Ooooo00?o09Woooooool0;Oooo`80000:
<ol000<0003oooooool0P_ooo`00Goooo`03o`2Ioooooooo02goool00`0003?o03?o0009<ol000<0
003oooooool0P_ooo`00Goooo`03o`2Ioooooooo02goool00`0003?o03?o0009<ol000<0003ooooo
ool0P_ooo`00Goooo`03o`2Ioooooooo02goool00`0003?o03?o0008<ol000<0003oooooool0Pooo
o`00Goooo`03o`2Ioooooooo02Koool200001Oooo`030000<ol0<ol000Pco`000`000?ooooooo`23
oooo001Ooooo00?o09Woooooool09Oooo`040000oooooooo00001?ooo`030000<ol0<ol000Pco`00
0`000?ooooooo`23oooo001Ooooo00?o09Woooooool09oooo`030000oooooooo00?oool3000023?o
00030000oooooooo08?oool005ooool00ol0VOooooooo`0Xoooo00<0003oooooool00_ooo`030000
<ol0<ol000Pco`000`000?ooooooo`23oooo001Ooooo00?o09Woooooool09Oooo`040000oooooooo
00001?ooo`030000<ol0<ol000Pco`000`000?ooooooo`23oooo001Ooooo00?o09Woooooool09_oo
o`800005oooo00<0000co`0co`001c?o00030000oooooooo08Coool005ooool00ol0VOooooooo`0]
oooo00<0000co`0co`001c?o00030000oooooooo08Coool005ooool00ol0VOooooooo`0]oooo00<0
000co`0co`001c?o00030000oooooooo08Coool005ooool00ol0VOooooooo`0]oooo00<0000co`0c
o`001c?o00030000oooooooo08Coool005ooool00ol0VOooooooo`0]oooo0P0000Pco`000`000?oo
ooooo`24oooo001Ooooo00?o09Woooooool0;Oooo`030000<ol0<ol000Lco`000`000?ooooooo`24
oooo001Ooooo00?o09Woooooool0;Oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001O
oooo00?o09Woooooool0;Oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001Ooooo00?o
09Woooooool0;Oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001Ooooo00?o09Wooooo
ool0;Oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001Ooooo00?o09Woooooool0;Ooo
o`800007<ol000<0003oooooool0QOooo`00Goooo`03o`2Ioooooooo02goool00`0003?o03?o0006
<ol000<0003oooooool0QOooo`00Goooo`03o`2Ioooooooo02goool00`0003?o03?o0006<ol000<0
003oooooool0QOooo`00Goooo`03o`2Ioooooooo02goool00`0003?o03?o0006<ol000<0003ooooo
ool0QOooo`00Goooo`03o`2Ioooooooo02goool00`0003?o03?o0006<ol000<0003oooooool0QOoo
o`00Goooo`03o`2Ioooooooo02goool00`0003?o03?o0006<ol000<0003oooooool0QOooo`00Gooo
o`03o`2Ioooooooo02goool200001S?o00030000oooooooo08Koool005ooool00ol0VOooooooo`0]
oooo00<0000co`0co`001C?o00030000oooooooo08Koool005ooool00ol0VOooooooo`0]oooo00<0
000co`0co`001C?o00030000oooooooo08Koool005ooool00ol0VOooooooo`0]oooo00<0000co`0c
o`001C?o00030000oooooooo08Koool005ooool00ol0VOooooooo`0]oooo00<0000co`0co`001C?o
00030000oooooooo08Koool005ooool00ol0VOooooooo`0]oooo00<0000co`0co`001C?o00030000
oooooooo08Koool005ooool00ol0VOooooooo`0]oooo0P0000Hco`000`000?ooooooo`26oooo001O
oooo00?o09Woooooool0;Oooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001Ooooo00?o
09Woooooool0;Oooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001Ooooo00?o09Wooooo
ool0;Oooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001Ooooo00?o09Woooooool0;Ooo
o`030000<ol0<ol000@co`000`000?ooooooo`27oooo001Ooooo00?o09Woooooool09oooo`<00003
oooo00<0000co`0co`0013?o00030000oooooooo08Ooool005ooool00ol0VOooooooo`0Xoooo00<0
003oooooool00_ooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001Ooooo00?o09Wooooo
ool09Oooo`D00003oooo0`0000@co`000`000?ooooooo`27oooo0027oooo00@0003oooooool00004
oooo1c?o08[oool008Soool00`000?ooo`000004oooo1c?o08[oool008Woool200001?ooo`Lco`2:
oooo002?oooo1c?o08[oool008ooool7<ol0R_ooo`00O?ooo`030000oooooooo013oool7<ol02ooo
o`030000oooooooo07coool007_oool00`000?ooooooo`08oooo00<0003oooooool01_ooo`Lco`0<
oooo00<0003oooooool0Noooo`00Noooo`030000oooooooo00;oool200001?ooo`030000oooooooo
00Koool00c?o000000000004<ol00P0000?oool400000oooo`030000oooooooo07_oool007_oool0
1@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo00Goool0100003?o
03?o000000<co`05oooo00<0003oooooool01?ooo`030000oooooooo07_oool007[oool00`000?oo
ooooo`02oooo00<0003oooooool03Oooo`040000<ol0<ol000000c?o00Koool00`000?ooooooo`04
oooo00<0003oooooool0N_ooo`00Noooo`030000oooooooo00D0000<oooo00@0000co`0co`000003
<ol01oooo`030000oooooooo00;oool00`000?ooooooo`1koooo001koooo00D0003oooooooooool0
00003oooo`040000<ol0<ol000000c?o00Goool010000?ooooooo`0000?oool00`000?ooooooo`1k
oooo001loooo00<0003oooooool04?ooo`03<ol00000000000@co`06oooo0P0000?oool00`000?oo
ooooo`1loooo002?oooo1c?o08[oool008ooool7<ol0R_ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.22) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.29205 .12361 L
.30316 .12361 L
.30791 .12361 L
.31054 .12361 L
.31183 .12361 L
.31304 .12361 L
.31371 .12361 L
s
.31371 .12361 m
.314 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.22) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`09oooo00<0003ooooo
ool02Oooo`030000o`2Ioooo00Woool00`000?ooooooo`09oooo00<0003oooooool02Oooo`030000
oooooooo00Woool00`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Tco`00
0`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Hco`0R00001_ooo`030000
oooooooo00Woool00`000?ooooooo`0Eoooo000Foooo00<0003oooooool0>_ooo`030000oooooooo
00[oool00ol0VOooooooo`0/oooo00<0000co`0co`00>C?o00T0000doooo00<0003oooooool05Ooo
o`00H?ooo`03o`2Ioooooooo02coool00`0003?o03?o000c<ol01P0005Goool0063oool00ol0VOoo
ooooo`0/oooo00<0000co`0co`00<C?o0080001Koooo001Poooo00?o09Woooooool0;?ooo`030000
<ol0<ol002lco`020000GOooo`00H?ooo`03o`2Ioooooooo02coool00`0003?o03?o000/<ol00`00
05ooool0063oool00ol0VOooooooo`0/oooo0P0002Xco`030000H_ooo`00H?ooo`03o`2Ioooooooo
02coool00`0003?o03?o000W<ol00P0006Goool0063oool00ol0VOooooooo`0/oooo00<0000co`0c
o`009S?o00030000oooooooo06Goool0063oool00ol0VOooooooo`0/oooo00<0000co`0co`009C?o
00030000oooooooo06Koool0063oool00ol0VOooooooo`0/oooo00<0000co`0co`0093?o00030000
oooooooo06Ooool0063oool00ol0VOooooooo`0/oooo00<0000co`0co`008S?o0080001Zoooo001P
oooo00?o09Woooooool0;?ooo`80000R<ol000<0003oooooool0J_ooo`00H?ooo`03o`2Ioooooooo
02coool00`0003?o03?o000P<ol000<0003oooooool0Joooo`00H?ooo`03o`2Ioooooooo02coool0
0`0003?o03?o000O<ol000<0003oooooool0K?ooo`00H?ooo`03o`2Ioooooooo02coool00`0003?o
03?o000O<ol000<0003oooooool0K?ooo`00H?ooo`03o`2Ioooooooo02coool00`0003?o03?o000N
<ol000<0003oooooool0KOooo`00H?ooo`03o`2Ioooooooo02coool00`0003?o03?o000M<ol000<0
003oooooool0K_ooo`00H?ooo`03o`2Ioooooooo02coool200007C?o00030000oooooooo06ooool0
063oool00ol0VOooooooo`0/oooo00<0000co`0co`006c?o00030000oooooooo073oool0063oool0
0ol0VOooooooo`0/oooo00<0000co`0co`006c?o00030000oooooooo073oool0063oool00ol0VOoo
ooooo`0/oooo00<0000co`0co`006S?o00030000oooooooo077oool0063oool00ol0VOooooooo`0/
oooo00<0000co`0co`006S?o00030000oooooooo077oool0063oool00ol0VOooooooo`0/oooo00<0
000co`0co`006C?o00030000oooooooo07;oool0063oool00ol0VOooooooo`0/oooo0P0001Xco`00
0`000?ooooooo`1boooo001Poooo00?o09Woooooool0;?ooo`030000<ol0<ol001Pco`000`000?oo
ooooo`1coooo001Poooo00?o09Woooooool0;?ooo`030000<ol0<ol001Pco`000`000?ooooooo`1c
oooo001Poooo00?o09Woooooool0;?ooo`030000<ol0<ol001Lco`000`000?ooooooo`1doooo001P
oooo00?o09Woooooool0;?ooo`030000<ol0<ol001Lco`000`000?ooooooo`1doooo001Poooo00?o
09Woooooool09?ooo`D00003oooo00<0000co`0co`005S?o00030000oooooooo07Goool0063oool0
0ol0VOooooooo`0Voooo00<0003oooooool00oooo`030000<ol0<ol001Hco`000`000?ooooooo`1e
oooo001Poooo00?o09Woooooool09_ooo`030000oooooooo00?oool300005C?o00030000oooooooo
07Koool0063oool00ol0VOooooooo`0Voooo00<0003oooooool00oooo`030000<ol0<ol001Dco`00
0`000?ooooooo`1foooo001Poooo00?o09Woooooool09_ooo`030000oooooooo00?oool00`0003?o
03?o000E<ol000<0003oooooool0M_ooo`00H?ooo`03o`2Ioooooooo02Goool200001Oooo`030000
<ol0<ol001@co`000`000?ooooooo`1goooo001Poooo00?o09Woooooool0;?ooo`030000<ol0<ol0
01@co`000`000?ooooooo`1goooo001Poooo00?o09Woooooool0;?ooo`030000<ol0<ol001<co`00
0`000?ooooooo`1hoooo001Poooo00?o09Woooooool0;?ooo`80000D<ol000<0003oooooool0N?oo
o`00H?ooo`03o`2Ioooooooo02coool00`0003?o03?o000C<ol000<0003oooooool0N?ooo`00H?oo
o`03o`2Ioooooooo02coool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00H?ooo`03o`2I
oooooooo02coool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00H?ooo`03o`2Ioooooooo
02coool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00H?ooo`03o`2Ioooooooo02coool0
0`0003?o03?o000A<ol000<0003oooooool0N_ooo`00H?ooo`03o`2Ioooooooo02coool200004S?o
00030000oooooooo07[oool0063oool00ol0VOooooooo`0/oooo00<0000co`0co`004C?o00030000
oooooooo07[oool0063oool00ol0VOooooooo`0/oooo00<0000co`0co`004C?o00030000oooooooo
07[oool0063oool00ol0VOooooooo`0/oooo00<0000co`0co`0043?o00030000oooooooo07_oool0
063oool00ol0VOooooooo`0/oooo00<0000co`0co`0043?o00030000oooooooo07_oool0063oool0
0ol0VOooooooo`0/oooo00<0000co`0co`0043?o00030000oooooooo07_oool0063oool00ol0VOoo
ooooo`0/oooo00<0000co`0co`0043?o00030000oooooooo07_oool0063oool00ol0VOooooooo`0/
oooo0P00010co`000`000?ooooooo`1loooo001Poooo00?o09Woooooool0;?ooo`030000<ol0<ol0
00lco`000`000?ooooooo`1loooo001Poooo00?o09Woooooool0;?ooo`030000<ol0<ol000lco`00
0`000?ooooooo`1loooo001Poooo00?o09Woooooool0;?ooo`030000<ol0<ol000lco`000`000?oo
ooooo`1loooo001Poooo00?o09Woooooool0;?ooo`030000<ol0<ol000lco`000`000?ooooooo`1l
oooo001Poooo00?o09Woooooool0;?ooo`030000<ol0<ol000hco`000`000?ooooooo`1moooo001P
oooo00?o09Woooooool0;?ooo`80000?<ol000<0003oooooool0OOooo`00H?ooo`03o`2Ioooooooo
02coool00`0003?o03?o000><ol000<0003oooooool0OOooo`00H?ooo`03o`2Ioooooooo02coool0
0`0003?o03?o000><ol000<0003oooooool0OOooo`00H?ooo`03o`2Ioooooooo02coool00`0003?o
03?o000=<ol000<0003oooooool0O_ooo`00H?ooo`03o`2Ioooooooo02Coool400001?ooo`030000
<ol0<ol000dco`000`000?ooooooo`1noooo001Poooo00?o09Woooooool09?ooo`030000oooooooo
00Goool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00H?ooo`03o`2Ioooooooo02Goool0
0`000?ooooooo`04oooo0`0000dco`000`000?ooooooo`1noooo001Poooo00?o09Woooooool09_oo
o`030000oooooooo00?oool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00H?ooo`03o`2I
oooooooo02Coool010000?ooooooo`0000Coool00`0003?o03?o000<<ol000<0003oooooool0Oooo
o`00H?ooo`03o`2Ioooooooo02Goool200001Oooo`030000<ol0<ol000`co`000`000?ooooooo`1o
oooo001Poooo00?o09Woooooool0;?ooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001P
oooo00?o09Woooooool0;?ooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001Poooo00?o
09Woooooool0;?ooo`80000=<ol000<0003oooooool0Ooooo`00H?ooo`03o`2Ioooooooo02coool0
0`0003?o03?o000<<ol000<0003oooooool0Ooooo`00H?ooo`03o`2Ioooooooo02coool00`0003?o
03?o000;<ol000<0003oooooool0P?ooo`00H?ooo`03o`2Ioooooooo02coool00`0003?o03?o000;
<ol000<0003oooooool0P?ooo`00H?ooo`03o`2Ioooooooo02coool00`0003?o03?o000;<ol000<0
003oooooool0P?ooo`00H?ooo`03o`2Ioooooooo02coool00`0003?o03?o000;<ol000<0003ooooo
ool0P?ooo`00H?ooo`03o`2Ioooooooo02coool00`0003?o03?o000;<ol000<0003oooooool0P?oo
o`00H?ooo`03o`2Ioooooooo02coool2000033?o00030000oooooooo083oool0063oool00ol0VOoo
ooooo`0/oooo00<0000co`0co`002c?o00030000oooooooo083oool0063oool00ol0VOooooooo`0/
oooo00<0000co`0co`002S?o00030000oooooooo087oool0063oool00ol0VOooooooo`0/oooo00<0
000co`0co`002S?o00030000oooooooo087oool0063oool00ol0VOooooooo`0/oooo00<0000co`0c
o`002S?o00030000oooooooo087oool0063oool00ol0VOooooooo`0/oooo00<0000co`0co`002S?o
00030000oooooooo087oool0063oool00ol0VOooooooo`0/oooo0P0000/co`000`000?ooooooo`21
oooo001Poooo00?o09Woooooool0;?ooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001P
oooo00?o09Woooooool0;?ooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001Poooo00?o
09Woooooool0;?ooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001Poooo00?o09Wooooo
ool0;?ooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001Poooo00?o09Woooooool0;?oo
o`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001Poooo00?o09Woooooool0;?ooo`80000:
<ol000<0003oooooool0P_ooo`00H?ooo`03o`2Ioooooooo02coool00`0003?o03?o0009<ol000<0
003oooooool0P_ooo`00H?ooo`03o`2Ioooooooo02coool00`0003?o03?o0009<ol000<0003ooooo
ool0P_ooo`00H?ooo`03o`2Ioooooooo02coool00`0003?o03?o0008<ol000<0003oooooool0Pooo
o`00H?ooo`03o`2Ioooooooo02Goool200001Oooo`030000<ol0<ol000Pco`000`000?ooooooo`23
oooo001Poooo00?o09Woooooool09?ooo`040000oooooooo00001?ooo`030000<ol0<ol000Pco`00
0`000?ooooooo`23oooo001Poooo00?o09Woooooool09_ooo`030000oooooooo00?oool3000023?o
00030000oooooooo08?oool0063oool00ol0VOooooooo`0Woooo00<0003oooooool00_ooo`030000
<ol0<ol000Pco`000`000?ooooooo`23oooo001Poooo00?o09Woooooool09?ooo`040000oooooooo
00001?ooo`030000<ol0<ol000Pco`000`000?ooooooo`23oooo001Poooo00?o09Woooooool09Ooo
o`800005oooo00<0000co`0co`001c?o00030000oooooooo08Coool0063oool00ol0VOooooooo`0/
oooo00<0000co`0co`001c?o00030000oooooooo08Coool0063oool00ol0VOooooooo`0/oooo00<0
000co`0co`001c?o00030000oooooooo08Coool0063oool00ol0VOooooooo`0/oooo00<0000co`0c
o`001c?o00030000oooooooo08Coool0063oool00ol0VOooooooo`0/oooo0P0000Pco`000`000?oo
ooooo`24oooo001Poooo00?o09Woooooool0;?ooo`030000<ol0<ol000Lco`000`000?ooooooo`24
oooo001Poooo00?o09Woooooool0;?ooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001P
oooo00?o09Woooooool0;?ooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001Poooo00?o
09Woooooool0;?ooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001Poooo00?o09Wooooo
ool0;?ooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001Poooo00?o09Woooooool0;?oo
o`800007<ol000<0003oooooool0QOooo`00H?ooo`03o`2Ioooooooo02coool00`0003?o03?o0006
<ol000<0003oooooool0QOooo`00H?ooo`03o`2Ioooooooo02coool00`0003?o03?o0006<ol000<0
003oooooool0QOooo`00H?ooo`03o`2Ioooooooo02coool00`0003?o03?o0006<ol000<0003ooooo
ool0QOooo`00H?ooo`03o`2Ioooooooo02coool00`0003?o03?o0006<ol000<0003oooooool0QOoo
o`00H?ooo`03o`2Ioooooooo02coool00`0003?o03?o0006<ol000<0003oooooool0QOooo`00H?oo
o`03o`2Ioooooooo02coool200001S?o00030000oooooooo08Koool0063oool00ol0VOooooooo`0/
oooo00<0000co`0co`001C?o00030000oooooooo08Koool0063oool00ol0VOooooooo`0/oooo00<0
000co`0co`001C?o00030000oooooooo08Koool0063oool00ol0VOooooooo`0/oooo00<0000co`0c
o`001C?o00030000oooooooo08Koool0063oool00ol0VOooooooo`0/oooo00<0000co`0co`001C?o
00030000oooooooo08Koool0063oool00ol0VOooooooo`0/oooo00<0000co`0co`001C?o00030000
oooooooo08Koool0063oool00ol0VOooooooo`0/oooo0P0000Hco`000`000?ooooooo`26oooo001P
oooo00?o09Woooooool0;?ooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001Poooo00?o
09Woooooool0;?ooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001Poooo00?o09Wooooo
ool0;?ooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001Poooo00?o09Woooooool0;?oo
o`030000<ol0<ol000@co`000`000?ooooooo`27oooo001Poooo00?o09Woooooool09_ooo`<00003
oooo00<0000co`0co`0013?o00030000oooooooo08Ooool0063oool00ol0VOooooooo`0Woooo00<0
003oooooool00_ooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001Poooo00?o09Wooooo
ool09?ooo`D00003oooo0`0000@co`000`000?ooooooo`27oooo0027oooo00@0003oooooool00004
oooo1c?o08[oool008Soool00`000?ooo`000004oooo1c?o08[oool008Woool200001?ooo`Lco`2:
oooo002?oooo1c?o08[oool008ooool7<ol0R_ooo`00NOooo`030000oooooooo01?oool7<ol03_oo
o`030000oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool02Oooo`Lco`0?
oooo00<0003oooooool0N?ooo`00N?ooo`030000oooooooo00;oool200001?ooo`030000oooooooo
00Ooool2000013?o008000000c?o0?ooooooo`0400000_ooo`@00003oooo00<0003oooooool0N?oo
o`00N?ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01Ooo
o`040000oooooooo00001S?o00;oool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000
oooooooo07Soool007Ooool00`000?ooooooo`02oooo00<0003oooooool03Oooo`040000oooooooo
00001S?o00?oool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo07Ooool0
07Soool00`000?ooooooo`0500003?ooo`040000oooooooo00001S?o00Coool00`000?ooooooo`03
oooo00<0003oooooool00_ooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`00000?
oooo00@0003oooooool00006<ol00_ooo`040000oooooooo00000_ooo`040000oooooooo00000ooo
o`030000oooooooo07Soool007Woool00`000?ooooooo`0Aoooo0P0000Lco`03oooo0P0000Coool2
00000oooo`030000oooooooo07Woool008ooool7<ol0R_ooo`00Soooo`Lco`2:oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.24) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.29205 .12361 L
.30316 .12361 L
.31304 .12361 L
.31574 .12361 L
.31723 .12361 L
.31797 .12361 L
.31865 .12361 L
s
.31865 .12361 m
.31918 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.24) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`09oooo00<0003ooooo
ool02Oooo`030000ooooo`2I00Woool00`000?ooooooo`09oooo00<0003oooooool02Oooo`030000
oooooooo00Woool00`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Tco`00
0`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Hco`0R00001_ooo`030000
oooooooo00Woool00`000?ooooooo`0Eoooo000Foooo00<0003oooooool0>_ooo`030000oooooooo
00_oool00ol0VOooooooo`0[oooo00<0000co`0co`00>C?o00T0000doooo00<0003oooooool05Ooo
o`00HOooo`03o`2Ioooooooo02_oool00`0003?o03?o000c<ol01P0005Goool0067oool00ol0VOoo
ooooo`0[oooo00<0000co`0co`00<C?o0080001Koooo001Qoooo00?o09Woooooool0:oooo`030000
<ol0<ol002lco`020000GOooo`00HOooo`03o`2Ioooooooo02_oool00`0003?o03?o000/<ol00`00
05ooool0067oool00ol0VOooooooo`0[oooo0P0002Xco`030000H_ooo`00HOooo`03o`2Ioooooooo
02_oool00`0003?o03?o000W<ol00P0006Goool0067oool00ol0VOooooooo`0[oooo00<0000co`0c
o`009S?o00030000oooooooo06Goool0067oool00ol0VOooooooo`0[oooo00<0000co`0co`009C?o
00030000oooooooo06Koool0067oool00ol0VOooooooo`0[oooo00<0000co`0co`0093?o00030000
oooooooo06Ooool0067oool00ol0VOooooooo`0[oooo00<0000co`0co`008S?o0080001Zoooo001Q
oooo00?o09Woooooool0:oooo`80000R<ol000<0003oooooool0J_ooo`00HOooo`03o`2Ioooooooo
02_oool00`0003?o03?o000P<ol000<0003oooooool0Joooo`00HOooo`03o`2Ioooooooo02_oool0
0`0003?o03?o000O<ol000<0003oooooool0K?ooo`00HOooo`03o`2Ioooooooo02_oool00`0003?o
03?o000O<ol000<0003oooooool0K?ooo`00HOooo`03o`2Ioooooooo02_oool00`0003?o03?o000N
<ol000<0003oooooool0KOooo`00HOooo`03o`2Ioooooooo02_oool00`0003?o03?o000M<ol000<0
003oooooool0K_ooo`00HOooo`03o`2Ioooooooo02_oool200007C?o00030000oooooooo06ooool0
067oool00ol0VOooooooo`0[oooo00<0000co`0co`006c?o00030000oooooooo073oool0067oool0
0ol0VOooooooo`0[oooo00<0000co`0co`006c?o00030000oooooooo073oool0067oool00ol0VOoo
ooooo`0[oooo00<0000co`0co`006S?o00030000oooooooo077oool0067oool00ol0VOooooooo`0[
oooo00<0000co`0co`006S?o00030000oooooooo077oool0067oool00ol0VOooooooo`0[oooo00<0
000co`0co`006C?o00030000oooooooo07;oool0067oool00ol0VOooooooo`0[oooo0P0001Xco`00
0`000?ooooooo`1boooo001Qoooo00?o09Woooooool0:oooo`030000<ol0<ol001Pco`000`000?oo
ooooo`1coooo001Qoooo00?o09Woooooool0:oooo`030000<ol0<ol001Pco`000`000?ooooooo`1c
oooo001Qoooo00?o09Woooooool0:oooo`030000<ol0<ol001Lco`000`000?ooooooo`1doooo001Q
oooo00?o09Woooooool0:oooo`030000<ol0<ol001Lco`000`000?ooooooo`1doooo001Qoooo00?o
09Woooooool08oooo`D00003oooo00<0000co`0co`005S?o00030000oooooooo07Goool0067oool0
0ol0VOooooooo`0Uoooo00<0003oooooool00oooo`030000<ol0<ol001Hco`000`000?ooooooo`1e
oooo001Qoooo00?o09Woooooool09Oooo`030000oooooooo00?oool300005C?o00030000oooooooo
07Koool0067oool00ol0VOooooooo`0Uoooo00<0003oooooool00oooo`030000<ol0<ol001Dco`00
0`000?ooooooo`1foooo001Qoooo00?o09Woooooool09Oooo`030000oooooooo00?oool00`0003?o
03?o000E<ol000<0003oooooool0M_ooo`00HOooo`03o`2Ioooooooo02Coool200001Oooo`030000
<ol0<ol001@co`000`000?ooooooo`1goooo001Qoooo00?o09Woooooool0:oooo`030000<ol0<ol0
01@co`000`000?ooooooo`1goooo001Qoooo00?o09Woooooool0:oooo`030000<ol0<ol001<co`00
0`000?ooooooo`1hoooo001Qoooo00?o09Woooooool0:oooo`80000D<ol000<0003oooooool0N?oo
o`00HOooo`03o`2Ioooooooo02_oool00`0003?o03?o000C<ol000<0003oooooool0N?ooo`00HOoo
o`03o`2Ioooooooo02_oool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00HOooo`03o`2I
oooooooo02_oool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00HOooo`03o`2Ioooooooo
02_oool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00HOooo`03o`2Ioooooooo02_oool0
0`0003?o03?o000A<ol000<0003oooooool0N_ooo`00HOooo`03o`2Ioooooooo02_oool200004S?o
00030000oooooooo07[oool0067oool00ol0VOooooooo`0[oooo00<0000co`0co`004C?o00030000
oooooooo07[oool0067oool00ol0VOooooooo`0[oooo00<0000co`0co`004C?o00030000oooooooo
07[oool0067oool00ol0VOooooooo`0[oooo00<0000co`0co`0043?o00030000oooooooo07_oool0
067oool00ol0VOooooooo`0[oooo00<0000co`0co`0043?o00030000oooooooo07_oool0067oool0
0ol0VOooooooo`0[oooo00<0000co`0co`0043?o00030000oooooooo07_oool0067oool00ol0VOoo
ooooo`0[oooo00<0000co`0co`0043?o00030000oooooooo07_oool0067oool00ol0VOooooooo`0[
oooo0P00010co`000`000?ooooooo`1loooo001Qoooo00?o09Woooooool0:oooo`030000<ol0<ol0
00lco`000`000?ooooooo`1loooo001Qoooo00?o09Woooooool0:oooo`030000<ol0<ol000lco`00
0`000?ooooooo`1loooo001Qoooo00?o09Woooooool0:oooo`030000<ol0<ol000lco`000`000?oo
ooooo`1loooo001Qoooo00?o09Woooooool0:oooo`030000<ol0<ol000lco`000`000?ooooooo`1l
oooo001Qoooo00?o09Woooooool0:oooo`030000<ol0<ol000hco`000`000?ooooooo`1moooo001Q
oooo00?o09Woooooool0:oooo`80000?<ol000<0003oooooool0OOooo`00HOooo`03o`2Ioooooooo
02_oool00`0003?o03?o000><ol000<0003oooooool0OOooo`00HOooo`03o`2Ioooooooo02_oool0
0`0003?o03?o000><ol000<0003oooooool0OOooo`00HOooo`03o`2Ioooooooo02_oool00`0003?o
03?o000=<ol000<0003oooooool0O_ooo`00HOooo`03o`2Ioooooooo02?oool400001?ooo`030000
<ol0<ol000dco`000`000?ooooooo`1noooo001Qoooo00?o09Woooooool08oooo`030000oooooooo
00Goool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00HOooo`03o`2Ioooooooo02Coool0
0`000?ooooooo`04oooo0`0000dco`000`000?ooooooo`1noooo001Qoooo00?o09Woooooool09Ooo
o`030000oooooooo00?oool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00HOooo`03o`2I
oooooooo02?oool010000?ooooooo`0000Coool00`0003?o03?o000<<ol000<0003oooooool0Oooo
o`00HOooo`03o`2Ioooooooo02Coool200001Oooo`030000<ol0<ol000`co`000`000?ooooooo`1o
oooo001Qoooo00?o09Woooooool0:oooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001Q
oooo00?o09Woooooool0:oooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001Qoooo00?o
09Woooooool0:oooo`80000=<ol000<0003oooooool0Ooooo`00HOooo`03o`2Ioooooooo02_oool0
0`0003?o03?o000<<ol000<0003oooooool0Ooooo`00HOooo`03o`2Ioooooooo02_oool00`0003?o
03?o000;<ol000<0003oooooool0P?ooo`00HOooo`03o`2Ioooooooo02_oool00`0003?o03?o000;
<ol000<0003oooooool0P?ooo`00HOooo`03o`2Ioooooooo02_oool00`0003?o03?o000;<ol000<0
003oooooool0P?ooo`00HOooo`03o`2Ioooooooo02_oool00`0003?o03?o000;<ol000<0003ooooo
ool0P?ooo`00HOooo`03o`2Ioooooooo02_oool00`0003?o03?o000;<ol000<0003oooooool0P?oo
o`00HOooo`03o`2Ioooooooo02_oool2000033?o00030000oooooooo083oool0067oool00ol0VOoo
ooooo`0[oooo00<0000co`0co`002c?o00030000oooooooo083oool0067oool00ol0VOooooooo`0[
oooo00<0000co`0co`002S?o00030000oooooooo087oool0067oool00ol0VOooooooo`0[oooo00<0
000co`0co`002S?o00030000oooooooo087oool0067oool00ol0VOooooooo`0[oooo00<0000co`0c
o`002S?o00030000oooooooo087oool0067oool00ol0VOooooooo`0[oooo00<0000co`0co`002S?o
00030000oooooooo087oool0067oool00ol0VOooooooo`0[oooo0P0000/co`000`000?ooooooo`21
oooo001Qoooo00?o09Woooooool0:oooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001Q
oooo00?o09Woooooool0:oooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001Qoooo00?o
09Woooooool0:oooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001Qoooo00?o09Wooooo
ool0:oooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001Qoooo00?o09Woooooool0:ooo
o`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001Qoooo00?o09Woooooool0:oooo`80000:
<ol000<0003oooooool0P_ooo`00HOooo`03o`2Ioooooooo02_oool00`0003?o03?o0009<ol000<0
003oooooool0P_ooo`00HOooo`03o`2Ioooooooo02_oool00`0003?o03?o0009<ol000<0003ooooo
ool0P_ooo`00HOooo`03o`2Ioooooooo02_oool00`0003?o03?o0008<ol000<0003oooooool0Pooo
o`00HOooo`03o`2Ioooooooo02Coool200001Oooo`030000<ol0<ol000Pco`000`000?ooooooo`23
oooo001Qoooo00?o09Woooooool08oooo`040000oooooooo00001?ooo`030000<ol0<ol000Pco`00
0`000?ooooooo`23oooo001Qoooo00?o09Woooooool09Oooo`030000oooooooo00?oool3000023?o
00030000oooooooo08?oool0067oool00ol0VOooooooo`0Voooo00<0003oooooool00_ooo`030000
<ol0<ol000Pco`000`000?ooooooo`23oooo001Qoooo00?o09Woooooool08oooo`040000oooooooo
00001?ooo`030000<ol0<ol000Pco`000`000?ooooooo`23oooo001Qoooo00?o09Woooooool09?oo
o`800005oooo00<0000co`0co`001c?o00030000oooooooo08Coool0067oool00ol0VOooooooo`0[
oooo00<0000co`0co`001c?o00030000oooooooo08Coool0067oool00ol0VOooooooo`0[oooo00<0
000co`0co`001c?o00030000oooooooo08Coool0067oool00ol0VOooooooo`0[oooo00<0000co`0c
o`001c?o00030000oooooooo08Coool0067oool00ol0VOooooooo`0[oooo0P0000Pco`000`000?oo
ooooo`24oooo001Qoooo00?o09Woooooool0:oooo`030000<ol0<ol000Lco`000`000?ooooooo`24
oooo001Qoooo00?o09Woooooool0:oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001Q
oooo00?o09Woooooool0:oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001Qoooo00?o
09Woooooool0:oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001Qoooo00?o09Wooooo
ool0:oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001Qoooo00?o09Woooooool0:ooo
o`800007<ol000<0003oooooool0QOooo`00HOooo`03o`2Ioooooooo02_oool00`0003?o03?o0006
<ol000<0003oooooool0QOooo`00HOooo`03o`2Ioooooooo02_oool00`0003?o03?o0006<ol000<0
003oooooool0QOooo`00HOooo`03o`2Ioooooooo02_oool00`0003?o03?o0006<ol000<0003ooooo
ool0QOooo`00HOooo`03o`2Ioooooooo02_oool00`0003?o03?o0006<ol000<0003oooooool0QOoo
o`00HOooo`03o`2Ioooooooo02_oool00`0003?o03?o0006<ol000<0003oooooool0QOooo`00HOoo
o`03o`2Ioooooooo02_oool200001S?o00030000oooooooo08Koool0067oool00ol0VOooooooo`0[
oooo00<0000co`0co`001C?o00030000oooooooo08Koool0067oool00ol0VOooooooo`0[oooo00<0
000co`0co`001C?o00030000oooooooo08Koool0067oool00ol0VOooooooo`0[oooo00<0000co`0c
o`001C?o00030000oooooooo08Koool0067oool00ol0VOooooooo`0[oooo00<0000co`0co`001C?o
00030000oooooooo08Koool0067oool00ol0VOooooooo`0[oooo00<0000co`0co`001C?o00030000
oooooooo08Koool0067oool00ol0VOooooooo`0[oooo0P0000Hco`000`000?ooooooo`26oooo001Q
oooo00?o09Woooooool0:oooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001Qoooo00?o
09Woooooool0:oooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001Qoooo00?o09Wooooo
ool0:oooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001Qoooo00?o09Woooooool0:ooo
o`030000<ol0<ol000@co`000`000?ooooooo`27oooo001Qoooo00?o09Woooooool09Oooo`<00003
oooo00<0000co`0co`0013?o00030000oooooooo08Ooool0067oool00ol0VOooooooo`0Voooo00<0
003oooooool00_ooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001Qoooo00?o09Wooooo
ool08oooo`D00003oooo0`0000@co`000`000?ooooooo`27oooo0027oooo00@0003oooooool00004
oooo1c?o08[oool008Soool00`000?ooo`000004oooo1c?o08[oool008Woool200001?ooo`Lco`2:
oooo002?oooo1c?o08[oool008ooool7<ol0R_ooo`00NOooo`030000oooooooo01?oool7<ol03_oo
o`030000oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool02Oooo`Lco`0?
oooo00<0003oooooool0N?ooo`00N?ooo`030000oooooooo00;oool200001?ooo`030000oooooooo
00Ooool2000013?o008000000c?o0?ooooooo`0400001?ooo`<00002oooo00<0003oooooool0N?oo
o`00N?ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01Ooo
o`040000oooooooo00001S?o00;oool00`000?ooooooo`06oooo00D0003oooooooooool00000N_oo
o`00Moooo`030000oooooooo00;oool00`000?ooooooo`0=oooo00@0003oooooool00006<ol00ooo
o`030000oooooooo00;oool500000oooo`030000oooooooo07Ooool007Soool00`000?ooooooo`05
00003?ooo`040000oooooooo00001S?o00Coool01@000?ooooooooooo`000002oooo00D0003ooooo
ooooool00000N_ooo`00N?ooo`050000oooooooooooo000000ooool010000?ooooooo`0000Hco`02
oooo00@0003oooooool00003oooo00<0003oool000000oooo`030000oooooooo07Soool007Woool0
0`000?ooooooo`0Aoooo0P0000Lco`03oooo0P0000Goool200000_ooo`030000oooooooo07Woool0
08ooool7<ol0R_ooo`00Soooo`Lco`2:oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.26) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.29205 .12361 L
.30316 .12361 L
.31304 .12361 L
.31574 .12361 L
.31865 .12361 L
.32006 .12361 L
.3214 .12361 L
.3226 .12361 L
s
.3226 .12361 m
.32313 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.26) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`09oooo00<0003ooooo
ool02Oooo`040000ooooooooo`2I2?ooo`030000oooooooo00Woool00`000?ooooooo`09oooo00<0
003oooooool02Oooo`030000<ol0<ol000Tco`000`0003?o03?o0009<ol000<0000co`0co`002C?o
00030000<ol0<ol000Tco`000`0003?o03?o0009<ol000<0000co`0co`001S?o02800006oooo00<0
003oooooool02Oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0joooo00<0003ooooo
ool03?ooo`03o`2Ioooooooo02[oool00`0003?o03?o000i<ol02@0003Coool00`000?ooooooo`0E
oooo001Roooo00?o09Woooooool0:_ooo`030000<ol0<ol003<co`060000EOooo`00H_ooo`03o`2I
oooooooo02[oool00`0003?o03?o000a<ol00P0005_oool006;oool00ol0VOooooooo`0Zoooo00<0
000co`0co`00;c?o0080001Moooo001Roooo00?o09Woooooool0:_ooo`030000<ol0<ol002`co`03
0000Goooo`00H_ooo`03o`2Ioooooooo02[oool20000:S?o00<0001Roooo001Roooo00?o09Wooooo
ool0:_ooo`030000<ol0<ol002Lco`020000IOooo`00H_ooo`03o`2Ioooooooo02[oool00`0003?o
03?o000V<ol000<0003oooooool0IOooo`00H_ooo`03o`2Ioooooooo02[oool00`0003?o03?o000U
<ol000<0003oooooool0I_ooo`00H_ooo`03o`2Ioooooooo02[oool00`0003?o03?o000T<ol000<0
003oooooool0Ioooo`00H_ooo`03o`2Ioooooooo02[oool00`0003?o03?o000R<ol00P0006[oool0
06;oool00ol0VOooooooo`0Zoooo0P00028co`000`000?ooooooo`1Zoooo001Roooo00?o09Wooooo
ool0:_ooo`030000<ol0<ol0020co`000`000?ooooooo`1[oooo001Roooo00?o09Woooooool0:_oo
o`030000<ol0<ol001lco`000`000?ooooooo`1/oooo001Roooo00?o09Woooooool0:_ooo`030000
<ol0<ol001lco`000`000?ooooooo`1/oooo001Roooo00?o09Woooooool0:_ooo`030000<ol0<ol0
01hco`000`000?ooooooo`1]oooo001Roooo00?o09Woooooool0:_ooo`030000<ol0<ol001dco`00
0`000?ooooooo`1^oooo001Roooo00?o09Woooooool0:_ooo`80000M<ol000<0003oooooool0Kooo
o`00H_ooo`03o`2Ioooooooo02[oool00`0003?o03?o000K<ol000<0003oooooool0L?ooo`00H_oo
o`03o`2Ioooooooo02[oool00`0003?o03?o000K<ol000<0003oooooool0L?ooo`00H_ooo`03o`2I
oooooooo02[oool00`0003?o03?o000J<ol000<0003oooooool0LOooo`00H_ooo`03o`2Ioooooooo
02[oool00`0003?o03?o000J<ol000<0003oooooool0LOooo`00H_ooo`03o`2Ioooooooo02[oool0
0`0003?o03?o000I<ol000<0003oooooool0L_ooo`00H_ooo`03o`2Ioooooooo02[oool200006S?o
00030000oooooooo07;oool006;oool00ol0VOooooooo`0Zoooo00<0000co`0co`0063?o00030000
oooooooo07?oool006;oool00ol0VOooooooo`0Zoooo00<0000co`0co`0063?o00030000oooooooo
07?oool006;oool00ol0VOooooooo`0Zoooo00<0000co`0co`005c?o00030000oooooooo07Coool0
06;oool00ol0VOooooooo`0Zoooo00<0000co`0co`005c?o00030000oooooooo07Coool006;oool0
0ol0VOooooooo`0Roooo1@0000?oool00`0003?o03?o000F<ol000<0003oooooool0MOooo`00H_oo
o`03o`2Ioooooooo02Coool00`000?ooooooo`03oooo00<0000co`0co`005S?o00030000oooooooo
07Goool006;oool00ol0VOooooooo`0Toooo00<0003oooooool00oooo`<0000E<ol000<0003ooooo
ool0M_ooo`00H_ooo`03o`2Ioooooooo02Coool00`000?ooooooo`03oooo00<0000co`0co`005C?o
00030000oooooooo07Koool006;oool00ol0VOooooooo`0Toooo00<0003oooooool00oooo`030000
<ol0<ol001Dco`000`000?ooooooo`1foooo001Roooo00?o09Woooooool08oooo`800005oooo00<0
000co`0co`0053?o00030000oooooooo07Ooool006;oool00ol0VOooooooo`0Zoooo00<0000co`0c
o`0053?o00030000oooooooo07Ooool006;oool00ol0VOooooooo`0Zoooo00<0000co`0co`004c?o
00030000oooooooo07Soool006;oool00ol0VOooooooo`0Zoooo0P0001@co`000`000?ooooooo`1h
oooo001Roooo00?o09Woooooool0:_ooo`030000<ol0<ol001<co`000`000?ooooooo`1hoooo001R
oooo00?o09Woooooool0:_ooo`030000<ol0<ol0018co`000`000?ooooooo`1ioooo001Roooo00?o
09Woooooool0:_ooo`030000<ol0<ol0018co`000`000?ooooooo`1ioooo001Roooo00?o09Wooooo
ool0:_ooo`030000<ol0<ol0018co`000`000?ooooooo`1ioooo001Roooo00?o09Woooooool0:_oo
o`030000<ol0<ol0014co`000`000?ooooooo`1joooo001Roooo00?o09Woooooool0:_ooo`80000B
<ol000<0003oooooool0N_ooo`00H_ooo`03o`2Ioooooooo02[oool00`0003?o03?o000A<ol000<0
003oooooool0N_ooo`00H_ooo`03o`2Ioooooooo02[oool00`0003?o03?o000A<ol000<0003ooooo
ool0N_ooo`00H_ooo`03o`2Ioooooooo02[oool00`0003?o03?o000@<ol000<0003oooooool0Nooo
o`00H_ooo`03o`2Ioooooooo02[oool00`0003?o03?o000@<ol000<0003oooooool0Noooo`00H_oo
o`03o`2Ioooooooo02[oool00`0003?o03?o000@<ol000<0003oooooool0Noooo`00H_ooo`03o`2I
oooooooo02[oool00`0003?o03?o000@<ol000<0003oooooool0Noooo`00H_ooo`03o`2Ioooooooo
02[oool2000043?o00030000oooooooo07coool006;oool00ol0VOooooooo`0Zoooo00<0000co`0c
o`003c?o00030000oooooooo07coool006;oool00ol0VOooooooo`0Zoooo00<0000co`0co`003c?o
00030000oooooooo07coool006;oool00ol0VOooooooo`0Zoooo00<0000co`0co`003c?o00030000
oooooooo07coool006;oool00ol0VOooooooo`0Zoooo00<0000co`0co`003c?o00030000oooooooo
07coool006;oool00ol0VOooooooo`0Zoooo00<0000co`0co`003S?o00030000oooooooo07goool0
06;oool00ol0VOooooooo`0Zoooo0P0000lco`000`000?ooooooo`1moooo001Roooo00?o09Wooooo
ool0:_ooo`030000<ol0<ol000hco`000`000?ooooooo`1moooo001Roooo00?o09Woooooool0:_oo
o`030000<ol0<ol000hco`000`000?ooooooo`1moooo001Roooo00?o09Woooooool0:_ooo`030000
<ol0<ol000dco`000`000?ooooooo`1noooo001Roooo00?o09Woooooool08_ooo`@00004oooo00<0
000co`0co`003C?o00030000oooooooo07koool006;oool00ol0VOooooooo`0Roooo00<0003ooooo
ool01Oooo`030000<ol0<ol000dco`000`000?ooooooo`1noooo001Roooo00?o09Woooooool08ooo
o`030000oooooooo00Coool300003C?o00030000oooooooo07koool006;oool00ol0VOooooooo`0T
oooo00<0003oooooool00oooo`030000<ol0<ol000dco`000`000?ooooooo`1noooo001Roooo00?o
09Woooooool08_ooo`040000oooooooo00001?ooo`030000<ol0<ol000`co`000`000?ooooooo`1o
oooo001Roooo00?o09Woooooool08oooo`800005oooo00<0000co`0co`0033?o00030000oooooooo
07ooool006;oool00ol0VOooooooo`0Zoooo00<0000co`0co`0033?o00030000oooooooo07ooool0
06;oool00ol0VOooooooo`0Zoooo00<0000co`0co`0033?o00030000oooooooo07ooool006;oool0
0ol0VOooooooo`0Zoooo0P0000dco`000`000?ooooooo`1ooooo001Roooo00?o09Woooooool0:_oo
o`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001Roooo00?o09Woooooool0:_ooo`030000
<ol0<ol000/co`000`000?ooooooo`20oooo001Roooo00?o09Woooooool0:_ooo`030000<ol0<ol0
00/co`000`000?ooooooo`20oooo001Roooo00?o09Woooooool0:_ooo`030000<ol0<ol000/co`00
0`000?ooooooo`20oooo001Roooo00?o09Woooooool0:_ooo`030000<ol0<ol000/co`000`000?oo
ooooo`20oooo001Roooo00?o09Woooooool0:_ooo`030000<ol0<ol000/co`000`000?ooooooo`20
oooo001Roooo00?o09Woooooool0:_ooo`80000<<ol000<0003oooooool0P?ooo`00H_ooo`03o`2I
oooooooo02[oool00`0003?o03?o000;<ol000<0003oooooool0P?ooo`00H_ooo`03o`2Ioooooooo
02[oool00`0003?o03?o000:<ol000<0003oooooool0POooo`00H_ooo`03o`2Ioooooooo02[oool0
0`0003?o03?o000:<ol000<0003oooooool0POooo`00H_ooo`03o`2Ioooooooo02[oool00`0003?o
03?o000:<ol000<0003oooooool0POooo`00H_ooo`03o`2Ioooooooo02[oool00`0003?o03?o000:
<ol000<0003oooooool0POooo`00H_ooo`03o`2Ioooooooo02[oool200002c?o00030000oooooooo
087oool006;oool00ol0VOooooooo`0Zoooo00<0000co`0co`002S?o00030000oooooooo087oool0
06;oool00ol0VOooooooo`0Zoooo00<0000co`0co`002S?o00030000oooooooo087oool006;oool0
0ol0VOooooooo`0Zoooo00<0000co`0co`002C?o00030000oooooooo08;oool006;oool00ol0VOoo
ooooo`0Zoooo00<0000co`0co`002C?o00030000oooooooo08;oool006;oool00ol0VOooooooo`0Z
oooo00<0000co`0co`002C?o00030000oooooooo08;oool006;oool00ol0VOooooooo`0Zoooo0P00
00Xco`000`000?ooooooo`22oooo001Roooo00?o09Woooooool0:_ooo`030000<ol0<ol000Tco`00
0`000?ooooooo`22oooo001Roooo00?o09Woooooool0:_ooo`030000<ol0<ol000Tco`000`000?oo
ooooo`22oooo001Roooo00?o09Woooooool0:_ooo`030000<ol0<ol000Pco`000`000?ooooooo`23
oooo001Roooo00?o09Woooooool08oooo`800005oooo00<0000co`0co`0023?o00030000oooooooo
08?oool006;oool00ol0VOooooooo`0Roooo00@0003oooooool00004oooo00<0000co`0co`0023?o
00030000oooooooo08?oool006;oool00ol0VOooooooo`0Toooo00<0003oooooool00oooo`<00008
<ol000<0003oooooool0Poooo`00H_ooo`03o`2Ioooooooo02Goool00`000?ooooooo`02oooo00<0
000co`0co`0023?o00030000oooooooo08?oool006;oool00ol0VOooooooo`0Roooo00@0003ooooo
ool00004oooo00<0000co`0co`0023?o00030000oooooooo08?oool006;oool00ol0VOooooooo`0S
oooo0P0000Goool00`0003?o03?o0007<ol000<0003oooooool0Q?ooo`00H_ooo`03o`2Ioooooooo
02[oool00`0003?o03?o0007<ol000<0003oooooool0Q?ooo`00H_ooo`03o`2Ioooooooo02[oool0
0`0003?o03?o0007<ol000<0003oooooool0Q?ooo`00H_ooo`03o`2Ioooooooo02[oool00`0003?o
03?o0007<ol000<0003oooooool0Q?ooo`00H_ooo`03o`2Ioooooooo02[oool2000023?o00030000
oooooooo08Coool006;oool00ol0VOooooooo`0Zoooo00<0000co`0co`001c?o00030000oooooooo
08Coool006;oool00ol0VOooooooo`0Zoooo00<0000co`0co`001c?o00030000oooooooo08Coool0
06;oool00ol0VOooooooo`0Zoooo00<0000co`0co`001c?o00030000oooooooo08Coool006;oool0
0ol0VOooooooo`0Zoooo00<0000co`0co`001S?o00030000oooooooo08Goool006;oool00ol0VOoo
ooooo`0Zoooo00<0000co`0co`001S?o00030000oooooooo08Goool006;oool00ol0VOooooooo`0Z
oooo0P0000Lco`000`000?ooooooo`25oooo001Roooo00?o09Woooooool0:_ooo`030000<ol0<ol0
00Hco`000`000?ooooooo`25oooo001Roooo00?o09Woooooool0:_ooo`030000<ol0<ol000Hco`00
0`000?ooooooo`25oooo001Roooo00?o09Woooooool0:_ooo`030000<ol0<ol000Hco`000`000?oo
ooooo`25oooo001Roooo00?o09Woooooool0:_ooo`030000<ol0<ol000Hco`000`000?ooooooo`25
oooo001Roooo00?o09Woooooool0:_ooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001R
oooo00?o09Woooooool0:_ooo`800006<ol000<0003oooooool0Q_ooo`00H_ooo`03o`2Ioooooooo
02[oool00`0003?o03?o0005<ol000<0003oooooool0Q_ooo`00H_ooo`03o`2Ioooooooo02[oool0
0`0003?o03?o0005<ol000<0003oooooool0Q_ooo`00H_ooo`03o`2Ioooooooo02[oool00`0003?o
03?o0005<ol000<0003oooooool0Q_ooo`00H_ooo`03o`2Ioooooooo02[oool00`0003?o03?o0005
<ol000<0003oooooool0Q_ooo`00H_ooo`03o`2Ioooooooo02[oool00`0003?o03?o0005<ol000<0
003oooooool0Q_ooo`00H_ooo`03o`2Ioooooooo02[oool200001S?o00030000oooooooo08Koool0
06;oool00ol0VOooooooo`0Zoooo00<0000co`0co`001C?o00030000oooooooo08Koool006;oool0
0ol0VOooooooo`0Zoooo00<0000co`0co`001C?o00030000oooooooo08Koool006;oool00ol0VOoo
ooooo`0Zoooo00<0000co`0co`0013?o00030000oooooooo08Ooool006;oool00ol0VOooooooo`0Z
oooo00<0000co`0co`0013?o00030000oooooooo08Ooool006;oool00ol0VOooooooo`0Toooo0`00
00?oool00`0003?o03?o0004<ol000<0003oooooool0Qoooo`00H_ooo`03o`2Ioooooooo02Goool0
0`000?ooooooo`02oooo00<0000co`0co`0013?o00030000oooooooo08Ooool006;oool00ol0VOoo
ooooo`0Roooo1@0000?oool3000013?o00030000oooooooo08Ooool008Ooool010000?ooooooo`00
00Coool7<ol0R_ooo`00R?ooo`030000oooo000000Coool7<ol0R_ooo`00ROooo`800004oooo1c?o
08[oool008ooool7<ol0R_ooo`00Soooo`Lco`2:oooo001ioooo00<0003oooooool04oooo`Lco`0>
oooo00<0003oooooool0NOooo`00N?ooo`030000oooooooo00Soool00`000?ooooooo`09oooo1c?o
00ooool00`000?ooooooo`1hoooo001hoooo00<0003oooooool00_ooo`800004oooo00<0003ooooo
ool01oooo`800004<ol00P000003<ol0oooooooo00@00002oooo0`0000Coool00`000?ooooooo`1h
oooo001hoooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`05
oooo00@0003oooooool00006<ol00_ooo`030000oooooooo00?oool010000?ooooooo`0000?oool0
0`000?ooooooo`1hoooo001goooo00<0003oooooool00_ooo`030000oooooooo00goool010000?oo
ooooo`0000Hco`03oooo00<0003oooooool00_ooo`040000oooooooo00001?ooo`030000oooooooo
07Ooool007Soool00`000?ooooooo`0500003?ooo`040000oooooooo00001S?o00Coool010000?oo
ooooooooo`<00004oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000ooool0
10000?ooooooo`0000Hco`02oooo00@0003oooooool00003oooo00<0003oooooool00oooo`030000
oooooooo07Soool007Woool00`000?ooooooo`0Aoooo0P0000Lco`03oooo0P0000Coool300000_oo
o`030000oooooooo07Woool008ooool7<ol0R_ooo`00Soooo`Lco`2:oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.28) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.31875 .12361 L
.32392 .12361 L
.32617 .12361 L
.32728 .12361 L
.32831 .12361 L
s
.32831 .12361 m
.32878 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.28) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`09oooo00<0003ooooo
ool02Oooo`050000ooooooooooooo`2I00Ooool00`000?ooooooo`09oooo00<0003oooooool02Ooo
o`030000oooooooo00Woool00`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol0
00Tco`000`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Hco`0R00001_oo
o`030000oooooooo00Woool00`000?ooooooo`0Eoooo000Foooo00<0003oooooool0>_ooo`030000
oooooooo00goool00ol0VOooooooo`0Yoooo00<0000co`0co`00>C?o00T0000doooo00<0003ooooo
ool05Oooo`00Hoooo`03o`2Ioooooooo02Woool00`0003?o03?o000c<ol01P0005Goool006?oool0
0ol0VOooooooo`0Yoooo00<0000co`0co`00<C?o0080001Koooo001Soooo00?o09Woooooool0:Ooo
o`030000<ol0<ol002lco`020000GOooo`00Hoooo`03o`2Ioooooooo02Woool00`0003?o03?o000/
<ol00`0005ooool006?oool00ol0VOooooooo`0Yoooo0P0002Xco`030000H_ooo`00Hoooo`03o`2I
oooooooo02Woool00`0003?o03?o000W<ol00P0006Goool006?oool00ol0VOooooooo`0Yoooo00<0
000co`0co`009S?o00030000oooooooo06Goool006?oool00ol0VOooooooo`0Yoooo00<0000co`0c
o`009C?o00030000oooooooo06Koool006?oool00ol0VOooooooo`0Yoooo00<0000co`0co`0093?o
00030000oooooooo06Ooool006?oool00ol0VOooooooo`0Yoooo00<0000co`0co`008S?o0080001Z
oooo001Soooo00?o09Woooooool0:Oooo`80000R<ol000<0003oooooool0J_ooo`00Hoooo`03o`2I
oooooooo02Woool00`0003?o03?o000P<ol000<0003oooooool0Joooo`00Hoooo`03o`2Ioooooooo
02Woool00`0003?o03?o000O<ol000<0003oooooool0K?ooo`00Hoooo`03o`2Ioooooooo02Woool0
0`0003?o03?o000O<ol000<0003oooooool0K?ooo`00Hoooo`03o`2Ioooooooo02Woool00`0003?o
03?o000N<ol000<0003oooooool0KOooo`00Hoooo`03o`2Ioooooooo02Woool00`0003?o03?o000M
<ol000<0003oooooool0K_ooo`00Hoooo`03o`2Ioooooooo02Woool200007C?o00030000oooooooo
06ooool006?oool00ol0VOooooooo`0Yoooo00<0000co`0co`006c?o00030000oooooooo073oool0
06?oool00ol0VOooooooo`0Yoooo00<0000co`0co`006c?o00030000oooooooo073oool006?oool0
0ol0VOooooooo`0Yoooo00<0000co`0co`006S?o00030000oooooooo077oool006?oool00ol0VOoo
ooooo`0Yoooo00<0000co`0co`006S?o00030000oooooooo077oool006?oool00ol0VOooooooo`0Y
oooo00<0000co`0co`006C?o00030000oooooooo07;oool006?oool00ol0VOooooooo`0Yoooo0P00
01Xco`000`000?ooooooo`1boooo001Soooo00?o09Woooooool0:Oooo`030000<ol0<ol001Pco`00
0`000?ooooooo`1coooo001Soooo00?o09Woooooool0:Oooo`030000<ol0<ol001Pco`000`000?oo
ooooo`1coooo001Soooo00?o09Woooooool0:Oooo`030000<ol0<ol001Lco`000`000?ooooooo`1d
oooo001Soooo00?o09Woooooool0:Oooo`030000<ol0<ol001Lco`000`000?ooooooo`1doooo001S
oooo00?o09Woooooool08Oooo`D00003oooo00<0000co`0co`005S?o00030000oooooooo07Goool0
06?oool00ol0VOooooooo`0Soooo00<0003oooooool00oooo`030000<ol0<ol001Hco`000`000?oo
ooooo`1eoooo001Soooo00?o09Woooooool08oooo`030000oooooooo00?oool300005C?o00030000
oooooooo07Koool006?oool00ol0VOooooooo`0Soooo00<0003oooooool00oooo`030000<ol0<ol0
01Dco`000`000?ooooooo`1foooo001Soooo00?o09Woooooool08oooo`030000oooooooo00?oool0
0`0003?o03?o000E<ol000<0003oooooool0M_ooo`00Hoooo`03o`2Ioooooooo02;oool200001Ooo
o`030000<ol0<ol001@co`000`000?ooooooo`1goooo001Soooo00?o09Woooooool0:Oooo`030000
<ol0<ol001@co`000`000?ooooooo`1goooo001Soooo00?o09Woooooool0:Oooo`030000<ol0<ol0
01<co`000`000?ooooooo`1hoooo001Soooo00?o09Woooooool0:Oooo`80000D<ol000<0003ooooo
ool0N?ooo`00Hoooo`03o`2Ioooooooo02Woool00`0003?o03?o000C<ol000<0003oooooool0N?oo
o`00Hoooo`03o`2Ioooooooo02Woool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00Hooo
o`03o`2Ioooooooo02Woool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00Hoooo`03o`2I
oooooooo02Woool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00Hoooo`03o`2Ioooooooo
02Woool00`0003?o03?o000A<ol000<0003oooooool0N_ooo`00Hoooo`03o`2Ioooooooo02Woool2
00004S?o00030000oooooooo07[oool006?oool00ol0VOooooooo`0Yoooo00<0000co`0co`004C?o
00030000oooooooo07[oool006?oool00ol0VOooooooo`0Yoooo00<0000co`0co`004C?o00030000
oooooooo07[oool006?oool00ol0VOooooooo`0Yoooo00<0000co`0co`0043?o00030000oooooooo
07_oool006?oool00ol0VOooooooo`0Yoooo00<0000co`0co`0043?o00030000oooooooo07_oool0
06?oool00ol0VOooooooo`0Yoooo00<0000co`0co`0043?o00030000oooooooo07_oool006?oool0
0ol0VOooooooo`0Yoooo00<0000co`0co`0043?o00030000oooooooo07_oool006?oool00ol0VOoo
ooooo`0Yoooo0P00010co`000`000?ooooooo`1loooo001Soooo00?o09Woooooool0:Oooo`030000
<ol0<ol000lco`000`000?ooooooo`1loooo001Soooo00?o09Woooooool0:Oooo`030000<ol0<ol0
00lco`000`000?ooooooo`1loooo001Soooo00?o09Woooooool0:Oooo`030000<ol0<ol000lco`00
0`000?ooooooo`1loooo001Soooo00?o09Woooooool0:Oooo`030000<ol0<ol000lco`000`000?oo
ooooo`1loooo001Soooo00?o09Woooooool0:Oooo`030000<ol0<ol000hco`000`000?ooooooo`1m
oooo001Soooo00?o09Woooooool0:Oooo`80000?<ol000<0003oooooool0OOooo`00Hoooo`03o`2I
oooooooo02Woool00`0003?o03?o000><ol000<0003oooooool0OOooo`00Hoooo`03o`2Ioooooooo
02Woool00`0003?o03?o000><ol000<0003oooooool0OOooo`00Hoooo`03o`2Ioooooooo02Woool0
0`0003?o03?o000=<ol000<0003oooooool0O_ooo`00Hoooo`03o`2Ioooooooo027oool400001?oo
o`030000<ol0<ol000dco`000`000?ooooooo`1noooo001Soooo00?o09Woooooool08Oooo`030000
oooooooo00Goool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00Hoooo`03o`2Ioooooooo
02;oool00`000?ooooooo`04oooo0`0000dco`000`000?ooooooo`1noooo001Toooo00?o09Wooooo
ool08_ooo`030000oooooooo00?oool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00I?oo
o`03o`2Ioooooooo023oool010000?ooooooo`0000Coool00`0003?o03?o000<<ol000<0003ooooo
ool0Ooooo`00I?ooo`03o`2Ioooooooo027oool200001Oooo`030000<ol0<ol000`co`000`000?oo
ooooo`1ooooo001Toooo00?o09Woooooool0:?ooo`030000<ol0<ol000`co`000`000?ooooooo`1o
oooo001Toooo00?o09Woooooool0:?ooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001T
oooo00?o09Woooooool0:?ooo`80000=<ol000<0003oooooool0Ooooo`00I?ooo`03o`2Ioooooooo
02Soool00`0003?o03?o000<<ol000<0003oooooool0Ooooo`00I?ooo`03o`2Ioooooooo02Soool0
0`0003?o03?o000;<ol000<0003oooooool0P?ooo`00I?ooo`03o`2Ioooooooo02Soool00`0003?o
03?o000;<ol000<0003oooooool0P?ooo`00I?ooo`03o`2Ioooooooo02Soool00`0003?o03?o000;
<ol000<0003oooooool0P?ooo`00I?ooo`03o`2Ioooooooo02Soool00`0003?o03?o000;<ol000<0
003oooooool0P?ooo`00I?ooo`03o`2Ioooooooo02Soool00`0003?o03?o000;<ol000<0003ooooo
ool0P?ooo`00I?ooo`03o`2Ioooooooo02Soool2000033?o00030000oooooooo083oool006Coool0
0ol0VOooooooo`0Xoooo00<0000co`0co`002c?o00030000oooooooo083oool006Coool00ol0VOoo
ooooo`0Xoooo00<0000co`0co`002S?o00030000oooooooo087oool006Coool00ol0VOooooooo`0X
oooo00<0000co`0co`002S?o00030000oooooooo087oool006Coool00ol0VOooooooo`0Xoooo00<0
000co`0co`002S?o00030000oooooooo087oool006Coool00ol0VOooooooo`0Xoooo00<0000co`0c
o`002S?o00030000oooooooo087oool006Coool00ol0VOooooooo`0Xoooo0P0000/co`000`000?oo
ooooo`21oooo001Toooo00?o09Woooooool0:?ooo`030000<ol0<ol000Xco`000`000?ooooooo`21
oooo001Toooo00?o09Woooooool0:?ooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001T
oooo00?o09Woooooool0:?ooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001Toooo00?o
09Woooooool0:?ooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001Toooo00?o09Wooooo
ool0:?ooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001Toooo00?o09Woooooool0:?oo
o`80000:<ol000<0003oooooool0P_ooo`00I?ooo`03o`2Ioooooooo02Soool00`0003?o03?o0009
<ol000<0003oooooool0P_ooo`00I?ooo`03o`2Ioooooooo02Soool00`0003?o03?o0009<ol000<0
003oooooool0P_ooo`00I?ooo`03o`2Ioooooooo02Soool00`0003?o03?o0008<ol000<0003ooooo
ool0Poooo`00I?ooo`03o`2Ioooooooo027oool200001Oooo`030000<ol0<ol000Pco`000`000?oo
ooooo`23oooo001Toooo00?o09Woooooool08?ooo`040000oooooooo00001?ooo`030000<ol0<ol0
00Pco`000`000?ooooooo`23oooo001Toooo00?o09Woooooool08_ooo`030000oooooooo00?oool3
000023?o00030000oooooooo08?oool006Coool00ol0VOooooooo`0Soooo00<0003oooooool00_oo
o`030000<ol0<ol000Pco`000`000?ooooooo`23oooo001Toooo00?o09Woooooool08?ooo`040000
oooooooo00001?ooo`030000<ol0<ol000Pco`000`000?ooooooo`23oooo001Toooo00?o09Wooooo
ool08Oooo`800005oooo00<0000co`0co`001c?o00030000oooooooo08Coool006Coool00ol0VOoo
ooooo`0Xoooo00<0000co`0co`001c?o00030000oooooooo08Coool006Coool00ol0VOooooooo`0X
oooo00<0000co`0co`001c?o00030000oooooooo08Coool006Coool00ol0VOooooooo`0Xoooo00<0
000co`0co`001c?o00030000oooooooo08Coool006Coool00ol0VOooooooo`0Xoooo0P0000Pco`00
0`000?ooooooo`24oooo001Toooo00?o09Woooooool0:?ooo`030000<ol0<ol000Lco`000`000?oo
ooooo`24oooo001Toooo00?o09Woooooool0:?ooo`030000<ol0<ol000Lco`000`000?ooooooo`24
oooo001Toooo00?o09Woooooool0:?ooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001T
oooo00?o09Woooooool0:?ooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001Toooo00?o
09Woooooool0:?ooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001Toooo00?o09Wooooo
ool0:?ooo`800007<ol000<0003oooooool0QOooo`00I?ooo`03o`2Ioooooooo02Soool00`0003?o
03?o0006<ol000<0003oooooool0QOooo`00I?ooo`03o`2Ioooooooo02Soool00`0003?o03?o0006
<ol000<0003oooooool0QOooo`00I?ooo`03o`2Ioooooooo02Soool00`0003?o03?o0006<ol000<0
003oooooool0QOooo`00I?ooo`03o`2Ioooooooo02Soool00`0003?o03?o0006<ol000<0003ooooo
ool0QOooo`00I?ooo`03o`2Ioooooooo02Soool00`0003?o03?o0006<ol000<0003oooooool0QOoo
o`00I?ooo`03o`2Ioooooooo02Soool200001S?o00030000oooooooo08Koool006Coool00ol0VOoo
ooooo`0Xoooo00<0000co`0co`001C?o00030000oooooooo08Koool006Coool00ol0VOooooooo`0X
oooo00<0000co`0co`001C?o00030000oooooooo08Koool006Coool00ol0VOooooooo`0Xoooo00<0
000co`0co`001C?o00030000oooooooo08Koool006Coool00ol0VOooooooo`0Xoooo00<0000co`0c
o`001C?o00030000oooooooo08Koool006Coool00ol0VOooooooo`0Xoooo00<0000co`0co`001C?o
00030000oooooooo08Koool006Coool00ol0VOooooooo`0Xoooo0P0000Hco`000`000?ooooooo`26
oooo001Toooo00?o09Woooooool0:?ooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001T
oooo00?o09Woooooool0:?ooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001Toooo00?o
09Woooooool0:?ooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001Toooo00?o09Wooooo
ool0:?ooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001Toooo00?o09Woooooool08_oo
o`<00003oooo00<0000co`0co`0013?o00030000oooooooo08Ooool006Coool00ol0VOooooooo`0S
oooo00<0003oooooool00_ooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001Toooo00?o
09Woooooool08?ooo`D00003oooo0`0000@co`000`000?ooooooo`27oooo0027oooo00@0003ooooo
ool00004oooo1c?o08[oool008Soool00`000?ooo`000004oooo1c?o08[oool008Woool200001?oo
o`Lco`2:oooo002?oooo1c?o08[oool008ooool7<ol0R_ooo`00NOooo`030000oooooooo01?oool7
<ol03_ooo`030000oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool02Ooo
o`Lco`0?oooo00<0003oooooool0N?ooo`00N?ooo`030000oooooooo00;oool200001?ooo`030000
oooooooo00Ooool2000013?o008000000c?o0?ooooooo`0400000oooo`800004oooo00<0003ooooo
ool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003ooooo
ool01Oooo`040000oooooooo00001S?o00;oool00`000?ooooooo`03oooo00@0003oooooool00003
oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo00;oool00`000?ooooooo`0=oooo00@0
003oooooool00006<ol00oooo`030000oooooooo00;oool010000?ooooooo`0000Coool00`000?oo
ooooo`1goooo001hoooo00<0003oooooool01@0000coool010000?ooooooo`0000Hco`04oooo00<0
003oooooool00_ooo`800004oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo0000
00ooool010000?ooooooo`0000Hco`02oooo00@0003oooooool00002oooo00@0003oooooool00003
oooo00<0003oooooool0N?ooo`00NOooo`030000oooooooo017oool200001c?o00?oool200001?oo
o`800003oooo00<0003oooooool0NOooo`00Soooo`Lco`2:oooo002?oooo1c?o08[oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.32831 .12361 L
.33073 .12361 L
.33193 .12361 L
.33304 .12361 L
s
.33304 .12361 m
.33356 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`09oooo00<0003ooooo
ool02Oooo`030000oooooooo00?oool00ol0VOooooooo`03oooo00<0003oooooool02Oooo`030000
oooooooo00Woool00`000?ooooooo`09oooo00<0000co`0co`002C?o00030000<ol0<ol000Tco`00
0`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Tco`000`0003?o03?o0006
<ol08P0000Koool00`000?ooooooo`09oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo
03[oool00`000?ooooooo`0?oooo00?o09Woooooool09oooo`030000<ol0<ol003Tco`090000=?oo
o`030000oooooooo01Goool006Goool00ol0VOooooooo`0Woooo00<0000co`0co`00<c?o00H0001E
oooo001Uoooo00?o09Woooooool09oooo`030000<ol0<ol0034co`020000Foooo`00IOooo`03o`2I
oooooooo02Ooool00`0003?o03?o000_<ol00P0005goool006Goool00ol0VOooooooo`0Woooo00<0
000co`0co`00;3?o00<0001Ooooo001Uoooo00?o09Woooooool09oooo`80000Z<ol00`0006;oool0
06Goool00ol0VOooooooo`0Woooo00<0000co`0co`009c?o0080001Uoooo001Uoooo00?o09Wooooo
ool09oooo`030000<ol0<ol002Hco`000`000?ooooooo`1Uoooo001Uoooo00?o09Woooooool09ooo
o`030000<ol0<ol002Dco`000`000?ooooooo`1Voooo001Uoooo00?o09Woooooool09oooo`030000
<ol0<ol002@co`000`000?ooooooo`1Woooo001Uoooo00?o09Woooooool09oooo`030000<ol0<ol0
028co`020000J_ooo`00IOooo`03o`2Ioooooooo02Ooool200008S?o00030000oooooooo06[oool0
06Goool00ol0VOooooooo`0Woooo00<0000co`0co`0083?o00030000oooooooo06_oool006Goool0
0ol0VOooooooo`0Woooo00<0000co`0co`007c?o00030000oooooooo06coool006Goool00ol0VOoo
ooooo`0Woooo00<0000co`0co`007c?o00030000oooooooo06coool006Goool00ol0VOooooooo`0W
oooo00<0000co`0co`007S?o00030000oooooooo06goool006Goool00ol0VOooooooo`0Woooo00<0
000co`0co`007C?o00030000oooooooo06koool006Goool00ol0VOooooooo`0Woooo0P0001dco`00
0`000?ooooooo`1_oooo001Uoooo00?o09Woooooool09oooo`030000<ol0<ol001/co`000`000?oo
ooooo`1`oooo001Uoooo00?o09Woooooool09oooo`030000<ol0<ol001/co`000`000?ooooooo`1`
oooo001Uoooo00?o09Woooooool09oooo`030000<ol0<ol001Xco`000`000?ooooooo`1aoooo001U
oooo00?o09Woooooool09oooo`030000<ol0<ol001Xco`000`000?ooooooo`1aoooo001Uoooo00?o
09Woooooool09oooo`030000<ol0<ol001Tco`000`000?ooooooo`1boooo001Uoooo00?o09Wooooo
ool09oooo`80000J<ol000<0003oooooool0L_ooo`00IOooo`03o`2Ioooooooo02Ooool00`0003?o
03?o000H<ol000<0003oooooool0Loooo`00IOooo`03o`2Ioooooooo02Ooool00`0003?o03?o000H
<ol000<0003oooooool0Loooo`00IOooo`03o`2Ioooooooo02Ooool00`0003?o03?o000G<ol000<0
003oooooool0M?ooo`00IOooo`03o`2Ioooooooo02Ooool00`0003?o03?o000G<ol000<0003ooooo
ool0M?ooo`00IOooo`03o`2Ioooooooo01ooool500000oooo`030000<ol0<ol001Hco`000`000?oo
ooooo`1eoooo001Uoooo00?o09Woooooool08Oooo`030000oooooooo00?oool00`0003?o03?o000F
<ol000<0003oooooool0MOooo`00IOooo`03o`2Ioooooooo027oool00`000?ooooooo`03oooo0`00
01Dco`000`000?ooooooo`1foooo001Uoooo00?o09Woooooool08Oooo`030000oooooooo00?oool0
0`0003?o03?o000E<ol000<0003oooooool0M_ooo`00IOooo`03o`2Ioooooooo027oool00`000?oo
ooooo`03oooo00<0000co`0co`005C?o00030000oooooooo07Koool006Goool00ol0VOooooooo`0P
oooo0P0000Goool00`0003?o03?o000D<ol000<0003oooooool0Moooo`00IOooo`03o`2Ioooooooo
02Ooool00`0003?o03?o000D<ol000<0003oooooool0Moooo`00IOooo`03o`2Ioooooooo02Ooool0
0`0003?o03?o000C<ol000<0003oooooool0N?ooo`00IOooo`03o`2Ioooooooo02Ooool2000053?o
00030000oooooooo07Soool006Goool00ol0VOooooooo`0Woooo00<0000co`0co`004c?o00030000
oooooooo07Soool006Goool00ol0VOooooooo`0Woooo00<0000co`0co`004S?o00030000oooooooo
07Woool006Goool00ol0VOooooooo`0Woooo00<0000co`0co`004S?o00030000oooooooo07Woool0
06Goool00ol0VOooooooo`0Woooo00<0000co`0co`004S?o00030000oooooooo07Woool006Goool0
0ol0VOooooooo`0Woooo00<0000co`0co`004C?o00030000oooooooo07[oool006Goool00ol0VOoo
ooooo`0Woooo0P00018co`000`000?ooooooo`1joooo001Uoooo00?o09Woooooool09oooo`030000
<ol0<ol0014co`000`000?ooooooo`1joooo001Uoooo00?o09Woooooool09oooo`030000<ol0<ol0
014co`000`000?ooooooo`1joooo001Uoooo00?o09Woooooool09oooo`030000<ol0<ol0010co`00
0`000?ooooooo`1koooo001Uoooo00?o09Woooooool09oooo`030000<ol0<ol0010co`000`000?oo
ooooo`1koooo001Uoooo00?o09Woooooool09oooo`030000<ol0<ol0010co`000`000?ooooooo`1k
oooo001Uoooo00?o09Woooooool09oooo`030000<ol0<ol0010co`000`000?ooooooo`1koooo001U
oooo00?o09Woooooool09oooo`80000@<ol000<0003oooooool0O?ooo`00IOooo`03o`2Ioooooooo
02Ooool00`0003?o03?o000?<ol000<0003oooooool0O?ooo`00IOooo`03o`2Ioooooooo02Ooool0
0`0003?o03?o000?<ol000<0003oooooool0O?ooo`00IOooo`03o`2Ioooooooo02Ooool00`0003?o
03?o000?<ol000<0003oooooool0O?ooo`00IOooo`03o`2Ioooooooo02Ooool00`0003?o03?o000?
<ol000<0003oooooool0O?ooo`00IOooo`03o`2Ioooooooo02Ooool00`0003?o03?o000><ol000<0
003oooooool0OOooo`00IOooo`03o`2Ioooooooo02Ooool200003c?o00030000oooooooo07goool0
06Goool00ol0VOooooooo`0Woooo00<0000co`0co`003S?o00030000oooooooo07goool006Goool0
0ol0VOooooooo`0Woooo00<0000co`0co`003S?o00030000oooooooo07goool006Goool00ol0VOoo
ooooo`0Woooo00<0000co`0co`003C?o00030000oooooooo07koool006Goool00ol0VOooooooo`0O
oooo100000Coool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00IOooo`03o`2Ioooooooo
01ooool00`000?ooooooo`05oooo00<0000co`0co`003C?o00030000oooooooo07koool006Goool0
0ol0VOooooooo`0Poooo00<0003oooooool01?ooo`<0000=<ol000<0003oooooool0O_ooo`00IOoo
o`03o`2Ioooooooo027oool00`000?ooooooo`03oooo00<0000co`0co`003C?o00030000oooooooo
07koool006Goool00ol0VOooooooo`0Ooooo00@0003oooooool00004oooo00<0000co`0co`0033?o
00030000oooooooo07ooool006Goool00ol0VOooooooo`0Poooo0P0000Goool00`0003?o03?o000<
<ol000<0003oooooool0Ooooo`00IOooo`03o`2Ioooooooo02Ooool00`0003?o03?o000<<ol000<0
003oooooool0Ooooo`00IOooo`03o`2Ioooooooo02Ooool00`0003?o03?o000<<ol000<0003ooooo
ool0Ooooo`00IOooo`03o`2Ioooooooo02Ooool200003C?o00030000oooooooo07ooool006Goool0
0ol0VOooooooo`0Woooo00<0000co`0co`0033?o00030000oooooooo07ooool006Goool00ol0VOoo
ooooo`0Woooo00<0000co`0co`002c?o00030000oooooooo083oool006Goool00ol0VOooooooo`0W
oooo00<0000co`0co`002c?o00030000oooooooo083oool006Goool00ol0VOooooooo`0Woooo00<0
000co`0co`002c?o00030000oooooooo083oool006Goool00ol0VOooooooo`0Woooo00<0000co`0c
o`002c?o00030000oooooooo083oool006Goool00ol0VOooooooo`0Woooo00<0000co`0co`002c?o
00030000oooooooo083oool006Goool00ol0VOooooooo`0Woooo0P0000`co`000`000?ooooooo`20
oooo001Uoooo00?o09Woooooool09oooo`030000<ol0<ol000/co`000`000?ooooooo`20oooo001U
oooo00?o09Woooooool09oooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001Uoooo00?o
09Woooooool09oooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001Uoooo00?o09Wooooo
ool09oooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001Uoooo00?o09Woooooool09ooo
o`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001Uoooo00?o09Woooooool09oooo`80000;
<ol000<0003oooooool0POooo`00IOooo`03o`2Ioooooooo02Ooool00`0003?o03?o000:<ol000<0
003oooooool0POooo`00IOooo`03o`2Ioooooooo02Ooool00`0003?o03?o000:<ol000<0003ooooo
ool0POooo`00IOooo`03o`2Ioooooooo02Ooool00`0003?o03?o0009<ol000<0003oooooool0P_oo
o`00IOooo`03o`2Ioooooooo02Ooool00`0003?o03?o0009<ol000<0003oooooool0P_ooo`00IOoo
o`03o`2Ioooooooo02Ooool00`0003?o03?o0009<ol000<0003oooooool0P_ooo`00IOooo`03o`2I
oooooooo02Ooool200002S?o00030000oooooooo08;oool006Goool00ol0VOooooooo`0Woooo00<0
000co`0co`002C?o00030000oooooooo08;oool006Goool00ol0VOooooooo`0Woooo00<0000co`0c
o`002C?o00030000oooooooo08;oool006Goool00ol0VOooooooo`0Woooo00<0000co`0co`0023?o
00030000oooooooo08?oool006Goool00ol0VOooooooo`0Poooo0P0000Goool00`0003?o03?o0008
<ol000<0003oooooool0Poooo`00IOooo`03o`2Ioooooooo01ooool010000?ooooooo`0000Coool0
0`0003?o03?o0008<ol000<0003oooooool0Poooo`00IOooo`03o`2Ioooooooo027oool00`000?oo
ooooo`03oooo0`0000Pco`000`000?ooooooo`23oooo001Uoooo00?o09Woooooool08_ooo`030000
oooooooo00;oool00`0003?o03?o0008<ol000<0003oooooool0Poooo`00IOooo`03o`2Ioooooooo
01ooool010000?ooooooo`0000Coool00`0003?o03?o0008<ol000<0003oooooool0Poooo`00IOoo
o`03o`2Ioooooooo023oool200001Oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001U
oooo00?o09Woooooool09oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001Uoooo00?o
09Woooooool09oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001Uoooo00?o09Wooooo
ool09oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001Uoooo00?o09Woooooool09ooo
o`800008<ol000<0003oooooool0Q?ooo`00IOooo`03o`2Ioooooooo02Ooool00`0003?o03?o0007
<ol000<0003oooooool0Q?ooo`00IOooo`03o`2Ioooooooo02Ooool00`0003?o03?o0007<ol000<0
003oooooool0Q?ooo`00IOooo`03o`2Ioooooooo02Ooool00`0003?o03?o0007<ol000<0003ooooo
ool0Q?ooo`00IOooo`03o`2Ioooooooo02Ooool00`0003?o03?o0006<ol000<0003oooooool0QOoo
o`00IOooo`03o`2Ioooooooo02Ooool00`0003?o03?o0006<ol000<0003oooooool0QOooo`00IOoo
o`03o`2Ioooooooo02Ooool200001c?o00030000oooooooo08Goool006Goool00ol0VOooooooo`0W
oooo00<0000co`0co`001S?o00030000oooooooo08Goool006Goool00ol0VOooooooo`0Woooo00<0
000co`0co`001S?o00030000oooooooo08Goool006Goool00ol0VOooooooo`0Woooo00<0000co`0c
o`001S?o00030000oooooooo08Goool006Goool00ol0VOooooooo`0Woooo00<0000co`0co`001S?o
00030000oooooooo08Goool006Goool00ol0VOooooooo`0Woooo00<0000co`0co`001S?o00030000
oooooooo08Goool006Goool00ol0VOooooooo`0Woooo0P0000Hco`000`000?ooooooo`26oooo001U
oooo00?o09Woooooool09oooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001Uoooo00?o
09Woooooool09oooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001Uoooo00?o09Wooooo
ool09oooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001Uoooo00?o09Woooooool09ooo
o`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001Uoooo00?o09Woooooool09oooo`030000
<ol0<ol000Dco`000`000?ooooooo`26oooo001Uoooo00?o09Woooooool09oooo`800006<ol000<0
003oooooool0Q_ooo`00IOooo`03o`2Ioooooooo02Ooool00`0003?o03?o0005<ol000<0003ooooo
ool0Q_ooo`00IOooo`03o`2Ioooooooo02Ooool00`0003?o03?o0005<ol000<0003oooooool0Q_oo
o`00IOooo`03o`2Ioooooooo02Ooool00`0003?o03?o0004<ol000<0003oooooool0Qoooo`00IOoo
o`03o`2Ioooooooo02Ooool00`0003?o03?o0004<ol000<0003oooooool0Qoooo`00IOooo`03o`2I
oooooooo027oool300000oooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001Uoooo00?o
09Woooooool08_ooo`030000oooooooo00;oool00`0003?o03?o0004<ol000<0003oooooool0Qooo
o`00IOooo`03o`2Ioooooooo01ooool500000oooo`<00004<ol000<0003oooooool0Qoooo`00Qooo
o`040000oooooooo00001?ooo`Lco`2:oooo0028oooo00<0003oool000001?ooo`Lco`2:oooo0029
oooo0P0000Coool7<ol0R_ooo`00Soooo`Lco`2:oooo002?oooo1c?o08[oool007coool00`000?oo
ooooo`0@oooo1c?o00_oool00`000?ooooooo`1loooo001koooo00<0003oooooool02?ooo`030000
oooooooo00Koool7<ol03?ooo`030000oooooooo07_oool007_oool00`000?ooooooo`02oooo0P00
00Coool00`000?ooooooo`06oooo00<co`000000000013?o00800004oooo0P0000Coool00`000?oo
ooooo`1koooo001koooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?oo
ooooo`05oooo00@0000co`0co`000003<ol01Oooo`040000oooooooo00000oooo`030000oooooooo
07_oool007[oool00`000?ooooooo`02oooo00<0003oooooool03Oooo`040000<ol0<ol000000c?o
00Ooool00`000?ooooooo`03oooo00<0003oooooool0N_ooo`00Noooo`030000oooooooo00D0000<
oooo00@0000co`0co`000003<ol02?ooo`050000oooooooooooo000007goool007_oool01@000?oo
ooooooooo`00000?oooo00@0000co`0co`000003<ol01Oooo`040000oooooooo00000oooo`030000
oooooooo07_oool007coool00`000?ooooooo`0@oooo00<co`000000000013?o00Koool200000ooo
o`030000oooooooo07coool008ooool7<ol0R_ooo`00Soooo`Lco`2:oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.32) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.32831 .12361 L
.33304 .12361 L
.33443 .12361 L
.33575 .12361 L
.33693 .12361 L
s
.33693 .12361 m
.33745 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.32) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`09oooo00<0003ooooo
ool02Oooo`030000oooooooo00Coool00ol0VOooooooo`02oooo00<0003oooooool02Oooo`030000
oooooooo00Woool00`000?ooooooo`09oooo00<0000co`0co`002C?o00030000<ol0<ol000Tco`00
0`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Tco`000`0003?o03?o0006
<ol08P0000Koool00`000?ooooooo`09oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo
03[oool00`000?ooooooo`0@oooo00?o09Woooooool09_ooo`030000<ol0<ol003Tco`090000=?oo
o`030000oooooooo01Goool006Koool00ol0VOooooooo`0Voooo00<0000co`0co`00<c?o00H0001E
oooo001Voooo00?o09Woooooool09_ooo`030000<ol0<ol0034co`020000Foooo`00I_ooo`03o`2I
oooooooo02Koool00`0003?o03?o000_<ol00P0005goool006Koool00ol0VOooooooo`0Voooo00<0
000co`0co`00;3?o00<0001Ooooo001Voooo00?o09Woooooool09_ooo`80000Z<ol00`0006;oool0
06Koool00ol0VOooooooo`0Voooo00<0000co`0co`009c?o0080001Uoooo001Voooo00?o09Wooooo
ool09_ooo`030000<ol0<ol002Hco`000`000?ooooooo`1Uoooo001Voooo00?o09Woooooool09_oo
o`030000<ol0<ol002Dco`000`000?ooooooo`1Voooo001Voooo00?o09Woooooool09_ooo`030000
<ol0<ol002@co`000`000?ooooooo`1Woooo001Voooo00?o09Woooooool09_ooo`030000<ol0<ol0
028co`020000J_ooo`00I_ooo`03o`2Ioooooooo02Koool200008S?o00030000oooooooo06[oool0
06Koool00ol0VOooooooo`0Voooo00<0000co`0co`0083?o00030000oooooooo06_oool006Koool0
0ol0VOooooooo`0Voooo00<0000co`0co`007c?o00030000oooooooo06coool006Koool00ol0VOoo
ooooo`0Voooo00<0000co`0co`007c?o00030000oooooooo06coool006Koool00ol0VOooooooo`0V
oooo00<0000co`0co`007S?o00030000oooooooo06goool006Koool00ol0VOooooooo`0Voooo00<0
000co`0co`007C?o00030000oooooooo06koool006Koool00ol0VOooooooo`0Voooo0P0001dco`00
0`000?ooooooo`1_oooo001Voooo00?o09Woooooool09_ooo`030000<ol0<ol001/co`000`000?oo
ooooo`1`oooo001Voooo00?o09Woooooool09_ooo`030000<ol0<ol001/co`000`000?ooooooo`1`
oooo001Voooo00?o09Woooooool09_ooo`030000<ol0<ol001Xco`000`000?ooooooo`1aoooo001V
oooo00?o09Woooooool09_ooo`030000<ol0<ol001Xco`000`000?ooooooo`1aoooo001Voooo00?o
09Woooooool09_ooo`030000<ol0<ol001Tco`000`000?ooooooo`1boooo001Voooo00?o09Wooooo
ool09_ooo`80000J<ol000<0003oooooool0L_ooo`00I_ooo`03o`2Ioooooooo02Koool00`0003?o
03?o000H<ol000<0003oooooool0Loooo`00I_ooo`03o`2Ioooooooo02Koool00`0003?o03?o000H
<ol000<0003oooooool0Loooo`00I_ooo`03o`2Ioooooooo02Koool00`0003?o03?o000G<ol000<0
003oooooool0M?ooo`00I_ooo`03o`2Ioooooooo02Koool00`0003?o03?o000G<ol000<0003ooooo
ool0M?ooo`00I_ooo`03o`2Ioooooooo01koool500000oooo`030000<ol0<ol001Hco`000`000?oo
ooooo`1eoooo001Voooo00?o09Woooooool08?ooo`030000oooooooo00?oool00`0003?o03?o000F
<ol000<0003oooooool0MOooo`00I_ooo`03o`2Ioooooooo023oool00`000?ooooooo`03oooo0`00
01Dco`000`000?ooooooo`1foooo001Voooo00?o09Woooooool08?ooo`030000oooooooo00?oool0
0`0003?o03?o000E<ol000<0003oooooool0M_ooo`00I_ooo`03o`2Ioooooooo023oool00`000?oo
ooooo`03oooo00<0000co`0co`005C?o00030000oooooooo07Koool006Koool00ol0VOooooooo`0O
oooo0P0000Goool00`0003?o03?o000D<ol000<0003oooooool0Moooo`00I_ooo`03o`2Ioooooooo
02Koool00`0003?o03?o000D<ol000<0003oooooool0Moooo`00I_ooo`03o`2Ioooooooo02Koool0
0`0003?o03?o000C<ol000<0003oooooool0N?ooo`00I_ooo`03o`2Ioooooooo02Koool2000053?o
00030000oooooooo07Soool006Koool00ol0VOooooooo`0Voooo00<0000co`0co`004c?o00030000
oooooooo07Soool006Koool00ol0VOooooooo`0Voooo00<0000co`0co`004S?o00030000oooooooo
07Woool006Koool00ol0VOooooooo`0Voooo00<0000co`0co`004S?o00030000oooooooo07Woool0
06Koool00ol0VOooooooo`0Voooo00<0000co`0co`004S?o00030000oooooooo07Woool006Koool0
0ol0VOooooooo`0Voooo00<0000co`0co`004C?o00030000oooooooo07[oool006Koool00ol0VOoo
ooooo`0Voooo0P00018co`000`000?ooooooo`1joooo001Voooo00?o09Woooooool09_ooo`030000
<ol0<ol0014co`000`000?ooooooo`1joooo001Voooo00?o09Woooooool09_ooo`030000<ol0<ol0
014co`000`000?ooooooo`1joooo001Voooo00?o09Woooooool09_ooo`030000<ol0<ol0010co`00
0`000?ooooooo`1koooo001Voooo00?o09Woooooool09_ooo`030000<ol0<ol0010co`000`000?oo
ooooo`1koooo001Voooo00?o09Woooooool09_ooo`030000<ol0<ol0010co`000`000?ooooooo`1k
oooo001Voooo00?o09Woooooool09_ooo`030000<ol0<ol0010co`000`000?ooooooo`1koooo001V
oooo00?o09Woooooool09_ooo`80000@<ol000<0003oooooool0O?ooo`00I_ooo`03o`2Ioooooooo
02Koool00`0003?o03?o000?<ol000<0003oooooool0O?ooo`00I_ooo`03o`2Ioooooooo02Koool0
0`0003?o03?o000?<ol000<0003oooooool0O?ooo`00I_ooo`03o`2Ioooooooo02Koool00`0003?o
03?o000?<ol000<0003oooooool0O?ooo`00I_ooo`03o`2Ioooooooo02Koool00`0003?o03?o000?
<ol000<0003oooooool0O?ooo`00I_ooo`03o`2Ioooooooo02Koool00`0003?o03?o000><ol000<0
003oooooool0OOooo`00I_ooo`03o`2Ioooooooo02Koool200003c?o00030000oooooooo07goool0
06Koool00ol0VOooooooo`0Voooo00<0000co`0co`003S?o00030000oooooooo07goool006Koool0
0ol0VOooooooo`0Voooo00<0000co`0co`003S?o00030000oooooooo07goool006Koool00ol0VOoo
ooooo`0Voooo00<0000co`0co`003C?o00030000oooooooo07koool006Koool00ol0VOooooooo`0N
oooo100000Coool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00I_ooo`03o`2Ioooooooo
01koool00`000?ooooooo`05oooo00<0000co`0co`003C?o00030000oooooooo07koool006Koool0
0ol0VOooooooo`0Ooooo00<0003oooooool01?ooo`<0000=<ol000<0003oooooool0O_ooo`00I_oo
o`03o`2Ioooooooo023oool00`000?ooooooo`03oooo00<0000co`0co`003C?o00030000oooooooo
07koool006Koool00ol0VOooooooo`0Noooo00@0003oooooool00004oooo00<0000co`0co`0033?o
00030000oooooooo07ooool006Koool00ol0VOooooooo`0Ooooo0P0000Goool00`0003?o03?o000<
<ol000<0003oooooool0Ooooo`00I_ooo`03o`2Ioooooooo02Koool00`0003?o03?o000<<ol000<0
003oooooool0Ooooo`00I_ooo`03o`2Ioooooooo02Koool00`0003?o03?o000<<ol000<0003ooooo
ool0Ooooo`00I_ooo`03o`2Ioooooooo02Koool200003C?o00030000oooooooo07ooool006Koool0
0ol0VOooooooo`0Voooo00<0000co`0co`0033?o00030000oooooooo07ooool006Koool00ol0VOoo
ooooo`0Voooo00<0000co`0co`002c?o00030000oooooooo083oool006Koool00ol0VOooooooo`0V
oooo00<0000co`0co`002c?o00030000oooooooo083oool006Koool00ol0VOooooooo`0Voooo00<0
000co`0co`002c?o00030000oooooooo083oool006Koool00ol0VOooooooo`0Voooo00<0000co`0c
o`002c?o00030000oooooooo083oool006Koool00ol0VOooooooo`0Voooo00<0000co`0co`002c?o
00030000oooooooo083oool006Koool00ol0VOooooooo`0Voooo0P0000`co`000`000?ooooooo`20
oooo001Voooo00?o09Woooooool09_ooo`030000<ol0<ol000/co`000`000?ooooooo`20oooo001V
oooo00?o09Woooooool09_ooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001Voooo00?o
09Woooooool09_ooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001Voooo00?o09Wooooo
ool09_ooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001Voooo00?o09Woooooool09_oo
o`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001Voooo00?o09Woooooool09_ooo`80000;
<ol000<0003oooooool0POooo`00I_ooo`03o`2Ioooooooo02Koool00`0003?o03?o000:<ol000<0
003oooooool0POooo`00I_ooo`03o`2Ioooooooo02Koool00`0003?o03?o000:<ol000<0003ooooo
ool0POooo`00I_ooo`03o`2Ioooooooo02Koool00`0003?o03?o0009<ol000<0003oooooool0P_oo
o`00I_ooo`03o`2Ioooooooo02Koool00`0003?o03?o0009<ol000<0003oooooool0P_ooo`00I_oo
o`03o`2Ioooooooo02Koool00`0003?o03?o0009<ol000<0003oooooool0P_ooo`00I_ooo`03o`2I
oooooooo02Koool200002S?o00030000oooooooo08;oool006Koool00ol0VOooooooo`0Voooo00<0
000co`0co`002C?o00030000oooooooo08;oool006Koool00ol0VOooooooo`0Voooo00<0000co`0c
o`002C?o00030000oooooooo08;oool006Koool00ol0VOooooooo`0Voooo00<0000co`0co`0023?o
00030000oooooooo08?oool006Koool00ol0VOooooooo`0Ooooo0P0000Goool00`0003?o03?o0008
<ol000<0003oooooool0Poooo`00I_ooo`03o`2Ioooooooo01koool010000?ooooooo`0000Coool0
0`0003?o03?o0008<ol000<0003oooooool0Poooo`00I_ooo`03o`2Ioooooooo023oool00`000?oo
ooooo`03oooo0`0000Pco`000`000?ooooooo`23oooo001Voooo00?o09Woooooool08Oooo`030000
oooooooo00;oool00`0003?o03?o0008<ol000<0003oooooool0Poooo`00I_ooo`03o`2Ioooooooo
01koool010000?ooooooo`0000Coool00`0003?o03?o0008<ol000<0003oooooool0Poooo`00I_oo
o`03o`2Ioooooooo01ooool200001Oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001V
oooo00?o09Woooooool09_ooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001Voooo00?o
09Woooooool09_ooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001Voooo00?o09Wooooo
ool09_ooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001Voooo00?o09Woooooool09_oo
o`800008<ol000<0003oooooool0Q?ooo`00I_ooo`03o`2Ioooooooo02Koool00`0003?o03?o0007
<ol000<0003oooooool0Q?ooo`00I_ooo`03o`2Ioooooooo02Koool00`0003?o03?o0007<ol000<0
003oooooool0Q?ooo`00I_ooo`03o`2Ioooooooo02Koool00`0003?o03?o0007<ol000<0003ooooo
ool0Q?ooo`00I_ooo`03o`2Ioooooooo02Koool00`0003?o03?o0006<ol000<0003oooooool0QOoo
o`00I_ooo`03o`2Ioooooooo02Koool00`0003?o03?o0006<ol000<0003oooooool0QOooo`00I_oo
o`03o`2Ioooooooo02Koool200001c?o00030000oooooooo08Goool006Koool00ol0VOooooooo`0V
oooo00<0000co`0co`001S?o00030000oooooooo08Goool006Koool00ol0VOooooooo`0Voooo00<0
000co`0co`001S?o00030000oooooooo08Goool006Koool00ol0VOooooooo`0Voooo00<0000co`0c
o`001S?o00030000oooooooo08Goool006Koool00ol0VOooooooo`0Voooo00<0000co`0co`001S?o
00030000oooooooo08Goool006Koool00ol0VOooooooo`0Voooo00<0000co`0co`001S?o00030000
oooooooo08Goool006Koool00ol0VOooooooo`0Voooo0P0000Hco`000`000?ooooooo`26oooo001V
oooo00?o09Woooooool09_ooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001Voooo00?o
09Woooooool09_ooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001Voooo00?o09Wooooo
ool09_ooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001Voooo00?o09Woooooool09_oo
o`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001Voooo00?o09Woooooool09_ooo`030000
<ol0<ol000Dco`000`000?ooooooo`26oooo001Voooo00?o09Woooooool09_ooo`800006<ol000<0
003oooooool0Q_ooo`00I_ooo`03o`2Ioooooooo02Koool00`0003?o03?o0005<ol000<0003ooooo
ool0Q_ooo`00I_ooo`03o`2Ioooooooo02Koool00`0003?o03?o0005<ol000<0003oooooool0Q_oo
o`00I_ooo`03o`2Ioooooooo02Koool00`0003?o03?o0004<ol000<0003oooooool0Qoooo`00I_oo
o`03o`2Ioooooooo02Koool00`0003?o03?o0004<ol000<0003oooooool0Qoooo`00I_ooo`03o`2I
oooooooo023oool300000oooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001Voooo00?o
09Woooooool08Oooo`030000oooooooo00;oool00`0003?o03?o0004<ol000<0003oooooool0Qooo
o`00I_ooo`03o`2Ioooooooo01koool500000oooo`<00004<ol000<0003oooooool0Qoooo`00Qooo
o`040000oooooooo00001?ooo`Lco`2:oooo0028oooo00<0003oool000001?ooo`Lco`2:oooo0029
oooo0P0000Coool7<ol0R_ooo`00Soooo`Lco`2:oooo002?oooo1c?o08[oool007Woool00`000?oo
ooooo`0Coooo1c?o00koool00`000?ooooooo`1ioooo001hoooo00<0003oooooool02?ooo`030000
oooooooo00Woool7<ol03oooo`030000oooooooo07Soool007Soool00`000?ooooooo`02oooo0P00
00Coool00`000?ooooooo`07oooo0P0000@co`02000000@co`3oooooooooool200000oooo`@00003
oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?ooooooo`02
oooo00<0003oooooool01Oooo`040000oooooooo00001S?o00;oool010000?ooooooo`0000;oool0
0`000?ooooooo`04oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo00;oool00`000?oo
ooooo`0=oooo00@0003oooooool00006<ol01?ooo`030000oooooooo00;oool00`000?ooooooo`04
oooo00<0003oooooool0Moooo`00N?ooo`030000oooooooo00D0000<oooo00@0003oooooool00006
<ol01Oooo`030000oooooooo00;oool00`000?ooooooo`02oooo00<0003oooooool0N?ooo`00N?oo
o`050000oooooooooooo000000ooool010000?ooooooo`0000Hco`02oooo00@0003oooooool00002
oooo00@0003oooooool00003oooo00<0003oooooool0N?ooo`00NOooo`030000oooooooo017oool2
00001c?o00?oool200001?ooo`800003oooo00<0003oooooool0NOooo`00Soooo`Lco`2:oooo002?
oooo1c?o08[oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.34) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
.34187 .12361 L
s
.34187 .12361 m
.34236 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.34) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`09oooo00<0003ooooo
ool02Oooo`030000oooooooo00Goool01Ol0VOooooooooooo`00000;oooo00<0003oooooool02Ooo
o`030000oooooooo00Woool00`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol0
00Tco`000`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Hco`0R00001_oo
o`030000oooooooo00Woool00`000?ooooooo`0Eoooo000Foooo00<0003oooooool0>_ooo`030000
oooooooo017oool00ol0VOooooooo`0Uoooo00<0000co`0co`00>C?o00T0000doooo00<0003ooooo
ool05Oooo`00Ioooo`03o`2Ioooooooo02Goool00`0003?o03?o000c<ol01P0005Goool006Ooool0
0ol0VOooooooo`0Uoooo00<0000co`0co`00<C?o0080001Koooo001Woooo00?o09Woooooool09Ooo
o`030000<ol0<ol002lco`020000GOooo`00Ioooo`03o`2Ioooooooo02Goool00`0003?o03?o000/
<ol00`0005ooool006Ooool00ol0VOooooooo`0Uoooo0P0002Xco`030000H_ooo`00Ioooo`03o`2I
oooooooo02Goool00`0003?o03?o000W<ol00P0006Goool006Ooool00ol0VOooooooo`0Uoooo00<0
000co`0co`009S?o00030000oooooooo06Goool006Ooool00ol0VOooooooo`0Uoooo00<0000co`0c
o`009C?o00030000oooooooo06Koool006Ooool00ol0VOooooooo`0Uoooo00<0000co`0co`0093?o
00030000oooooooo06Ooool006Ooool00ol0VOooooooo`0Uoooo00<0000co`0co`008S?o0080001Z
oooo001Woooo00?o09Woooooool09Oooo`80000R<ol000<0003oooooool0J_ooo`00Ioooo`03o`2I
oooooooo02Goool00`0003?o03?o000P<ol000<0003oooooool0Joooo`00Ioooo`03o`2Ioooooooo
02Goool00`0003?o03?o000O<ol000<0003oooooool0K?ooo`00Ioooo`03o`2Ioooooooo02Goool0
0`0003?o03?o000O<ol000<0003oooooool0K?ooo`00Ioooo`03o`2Ioooooooo02Goool00`0003?o
03?o000N<ol000<0003oooooool0KOooo`00Ioooo`03o`2Ioooooooo02Goool00`0003?o03?o000M
<ol000<0003oooooool0K_ooo`00Ioooo`03o`2Ioooooooo02Goool200007C?o00030000oooooooo
06ooool006Ooool00ol0VOooooooo`0Uoooo00<0000co`0co`006c?o00030000oooooooo073oool0
06Ooool00ol0VOooooooo`0Uoooo00<0000co`0co`006c?o00030000oooooooo073oool006Ooool0
0ol0VOooooooo`0Uoooo00<0000co`0co`006S?o00030000oooooooo077oool006Ooool00ol0VOoo
ooooo`0Uoooo00<0000co`0co`006S?o00030000oooooooo077oool006Ooool00ol0VOooooooo`0U
oooo00<0000co`0co`006C?o00030000oooooooo07;oool006Ooool00ol0VOooooooo`0Uoooo0P00
01Xco`000`000?ooooooo`1boooo001Woooo00?o09Woooooool09Oooo`030000<ol0<ol001Pco`00
0`000?ooooooo`1coooo001Woooo00?o09Woooooool09Oooo`030000<ol0<ol001Pco`000`000?oo
ooooo`1coooo001Woooo00?o09Woooooool09Oooo`030000<ol0<ol001Lco`000`000?ooooooo`1d
oooo001Woooo00?o09Woooooool09Oooo`030000<ol0<ol001Lco`000`000?ooooooo`1doooo001W
oooo00?o09Woooooool07Oooo`D00003oooo00<0000co`0co`005S?o00030000oooooooo07Goool0
06Ooool00ol0VOooooooo`0Ooooo00<0003oooooool00oooo`030000<ol0<ol001Hco`000`000?oo
ooooo`1eoooo001Woooo00?o09Woooooool07oooo`030000oooooooo00?oool300005C?o00030000
oooooooo07Koool006Ooool00ol0VOooooooo`0Ooooo00<0003oooooool00oooo`030000<ol0<ol0
01Dco`000`000?ooooooo`1foooo001Woooo00?o09Woooooool07oooo`030000oooooooo00?oool0
0`0003?o03?o000E<ol000<0003oooooool0M_ooo`00Ioooo`03o`2Ioooooooo01koool200001Ooo
o`030000<ol0<ol001@co`000`000?ooooooo`1goooo001Woooo00?o09Woooooool09Oooo`030000
<ol0<ol001@co`000`000?ooooooo`1goooo001Woooo00?o09Woooooool09Oooo`030000<ol0<ol0
01<co`000`000?ooooooo`1hoooo001Woooo00?o09Woooooool09Oooo`80000D<ol000<0003ooooo
ool0N?ooo`00Ioooo`03o`2Ioooooooo02Goool00`0003?o03?o000C<ol000<0003oooooool0N?oo
o`00Ioooo`03o`2Ioooooooo02Goool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00Iooo
o`03o`2Ioooooooo02Goool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00Ioooo`03o`2I
oooooooo02Goool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00Ioooo`03o`2Ioooooooo
02Goool00`0003?o03?o000A<ol000<0003oooooool0N_ooo`00Ioooo`03o`2Ioooooooo02Goool2
00004S?o00030000oooooooo07[oool006Ooool00ol0VOooooooo`0Uoooo00<0000co`0co`004C?o
00030000oooooooo07[oool006Ooool00ol0VOooooooo`0Uoooo00<0000co`0co`004C?o00030000
oooooooo07[oool006Ooool00ol0VOooooooo`0Uoooo00<0000co`0co`0043?o00030000oooooooo
07_oool006Ooool00ol0VOooooooo`0Uoooo00<0000co`0co`0043?o00030000oooooooo07_oool0
06Ooool00ol0VOooooooo`0Uoooo00<0000co`0co`0043?o00030000oooooooo07_oool006Ooool0
0ol0VOooooooo`0Uoooo00<0000co`0co`0043?o00030000oooooooo07_oool006Ooool00ol0VOoo
ooooo`0Uoooo0P00010co`000`000?ooooooo`1loooo001Woooo00?o09Woooooool09Oooo`030000
<ol0<ol000lco`000`000?ooooooo`1loooo001Woooo00?o09Woooooool09Oooo`030000<ol0<ol0
00lco`000`000?ooooooo`1loooo001Woooo00?o09Woooooool09Oooo`030000<ol0<ol000lco`00
0`000?ooooooo`1loooo001Woooo00?o09Woooooool09Oooo`030000<ol0<ol000lco`000`000?oo
ooooo`1loooo001Woooo00?o09Woooooool09Oooo`030000<ol0<ol000hco`000`000?ooooooo`1m
oooo001Woooo00?o09Woooooool09Oooo`80000?<ol000<0003oooooool0OOooo`00Ioooo`03o`2I
oooooooo02Goool00`0003?o03?o000><ol000<0003oooooool0OOooo`00Ioooo`03o`2Ioooooooo
02Goool00`0003?o03?o000><ol000<0003oooooool0OOooo`00Ioooo`03o`2Ioooooooo02Goool0
0`0003?o03?o000=<ol000<0003oooooool0O_ooo`00Ioooo`03o`2Ioooooooo01goool400001?oo
o`030000<ol0<ol000dco`000`000?ooooooo`1noooo001Woooo00?o09Woooooool07Oooo`030000
oooooooo00Goool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00Ioooo`03o`2Ioooooooo
01koool00`000?ooooooo`04oooo0`0000dco`000`000?ooooooo`1noooo001Woooo00?o09Wooooo
ool07oooo`030000oooooooo00?oool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00Iooo
o`03o`2Ioooooooo01goool010000?ooooooo`0000Coool00`0003?o03?o000<<ol000<0003ooooo
ool0Ooooo`00Ioooo`03o`2Ioooooooo01koool200001Oooo`030000<ol0<ol000`co`000`000?oo
ooooo`1ooooo001Woooo00?o09Woooooool09Oooo`030000<ol0<ol000`co`000`000?ooooooo`1o
oooo001Woooo00?o09Woooooool09Oooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001W
oooo00?o09Woooooool09Oooo`80000=<ol000<0003oooooool0Ooooo`00Ioooo`03o`2Ioooooooo
02Goool00`0003?o03?o000<<ol000<0003oooooool0Ooooo`00Ioooo`03o`2Ioooooooo02Goool0
0`0003?o03?o000;<ol000<0003oooooool0P?ooo`00Ioooo`03o`2Ioooooooo02Goool00`0003?o
03?o000;<ol000<0003oooooool0P?ooo`00Ioooo`03o`2Ioooooooo02Goool00`0003?o03?o000;
<ol000<0003oooooool0P?ooo`00Ioooo`03o`2Ioooooooo02Goool00`0003?o03?o000;<ol000<0
003oooooool0P?ooo`00Ioooo`03o`2Ioooooooo02Goool00`0003?o03?o000;<ol000<0003ooooo
ool0P?ooo`00Ioooo`03o`2Ioooooooo02Goool2000033?o00030000oooooooo083oool006Ooool0
0ol0VOooooooo`0Uoooo00<0000co`0co`002c?o00030000oooooooo083oool006Ooool00ol0VOoo
ooooo`0Uoooo00<0000co`0co`002S?o00030000oooooooo087oool006Ooool00ol0VOooooooo`0U
oooo00<0000co`0co`002S?o00030000oooooooo087oool006Ooool00ol0VOooooooo`0Uoooo00<0
000co`0co`002S?o00030000oooooooo087oool006Ooool00ol0VOooooooo`0Uoooo00<0000co`0c
o`002S?o00030000oooooooo087oool006Ooool00ol0VOooooooo`0Uoooo0P0000/co`000`000?oo
ooooo`21oooo001Woooo00?o09Woooooool09Oooo`030000<ol0<ol000Xco`000`000?ooooooo`21
oooo001Woooo00?o09Woooooool09Oooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001W
oooo00?o09Woooooool09Oooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001Woooo00?o
09Woooooool09Oooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001Woooo00?o09Wooooo
ool09Oooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001Woooo00?o09Woooooool09Ooo
o`80000:<ol000<0003oooooool0P_ooo`00Ioooo`03o`2Ioooooooo02Goool00`0003?o03?o0009
<ol000<0003oooooool0P_ooo`00Ioooo`03o`2Ioooooooo02Goool00`0003?o03?o0009<ol000<0
003oooooool0P_ooo`00Ioooo`03o`2Ioooooooo02Goool00`0003?o03?o0008<ol000<0003ooooo
ool0Poooo`00Ioooo`03o`2Ioooooooo01koool200001Oooo`030000<ol0<ol000Pco`000`000?oo
ooooo`23oooo001Woooo00?o09Woooooool07Oooo`040000oooooooo00001?ooo`030000<ol0<ol0
00Pco`000`000?ooooooo`23oooo001Woooo00?o09Woooooool07oooo`030000oooooooo00?oool3
000023?o00030000oooooooo08?oool006Ooool00ol0VOooooooo`0Poooo00<0003oooooool00_oo
o`030000<ol0<ol000Pco`000`000?ooooooo`23oooo001Woooo00?o09Woooooool07Oooo`040000
oooooooo00001?ooo`030000<ol0<ol000Pco`000`000?ooooooo`23oooo001Woooo00?o09Wooooo
ool07_ooo`800005oooo00<0000co`0co`001c?o00030000oooooooo08Coool006Ooool00ol0VOoo
ooooo`0Uoooo00<0000co`0co`001c?o00030000oooooooo08Coool006Ooool00ol0VOooooooo`0U
oooo00<0000co`0co`001c?o00030000oooooooo08Coool006Ooool00ol0VOooooooo`0Uoooo00<0
000co`0co`001c?o00030000oooooooo08Coool006Ooool00ol0VOooooooo`0Uoooo0P0000Pco`00
0`000?ooooooo`24oooo001Woooo00?o09Woooooool09Oooo`030000<ol0<ol000Lco`000`000?oo
ooooo`24oooo001Woooo00?o09Woooooool09Oooo`030000<ol0<ol000Lco`000`000?ooooooo`24
oooo001Woooo00?o09Woooooool09Oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001W
oooo00?o09Woooooool09Oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001Woooo00?o
09Woooooool09Oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001Woooo00?o09Wooooo
ool09Oooo`800007<ol000<0003oooooool0QOooo`00Ioooo`03o`2Ioooooooo02Goool00`0003?o
03?o0006<ol000<0003oooooool0QOooo`00Ioooo`03o`2Ioooooooo02Goool00`0003?o03?o0006
<ol000<0003oooooool0QOooo`00Ioooo`03o`2Ioooooooo02Goool00`0003?o03?o0006<ol000<0
003oooooool0QOooo`00Ioooo`03o`2Ioooooooo02Goool00`0003?o03?o0006<ol000<0003ooooo
ool0QOooo`00Ioooo`03o`2Ioooooooo02Goool00`0003?o03?o0006<ol000<0003oooooool0QOoo
o`00Ioooo`03o`2Ioooooooo02Goool200001S?o00030000oooooooo08Koool006Ooool00ol0VOoo
ooooo`0Uoooo00<0000co`0co`001C?o00030000oooooooo08Koool006Ooool00ol0VOooooooo`0U
oooo00<0000co`0co`001C?o00030000oooooooo08Koool006Ooool00ol0VOooooooo`0Uoooo00<0
000co`0co`001C?o00030000oooooooo08Koool006Ooool00ol0VOooooooo`0Uoooo00<0000co`0c
o`001C?o00030000oooooooo08Koool006Ooool00ol0VOooooooo`0Uoooo00<0000co`0co`001C?o
00030000oooooooo08Koool006Ooool00ol0VOooooooo`0Uoooo0P0000Hco`000`000?ooooooo`26
oooo001Woooo00?o09Woooooool09Oooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001W
oooo00?o09Woooooool09Oooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001Woooo00?o
09Woooooool09Oooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001Woooo00?o09Wooooo
ool09Oooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001Woooo00?o09Woooooool07ooo
o`<00003oooo00<0000co`0co`0013?o00030000oooooooo08Ooool006Ooool00ol0VOooooooo`0P
oooo00<0003oooooool00_ooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001Woooo00?o
09Woooooool07Oooo`D00003oooo0`0000@co`000`000?ooooooo`27oooo0027oooo00@0003ooooo
ool00004oooo1c?o08[oool008Soool00`000?ooo`000004oooo1c?o08[oool008Woool200001?oo
o`Lco`2:oooo002?oooo1c?o08[oool008ooool7<ol0R_ooo`00NOooo`030000oooooooo01?oool7
<ol03_ooo`030000oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool02Ooo
o`Lco`0?oooo00<0003oooooool0N?ooo`00N?ooo`030000oooooooo00;oool200001?ooo`030000
oooooooo00Ooool2000013?o0080000013?o0?ooooooooooo`800005oooo0`0000;oool00`000?oo
ooooo`1hoooo001hoooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?oo
ooooo`05oooo00@0003oooooool00006<ol00_ooo`040000oooooooo00001Oooo`050000oooooooo
oooo000007[oool007Ooool00`000?ooooooo`02oooo00<0003oooooool03Oooo`040000oooooooo
00001S?o00Coool010000?ooooooooooo`D00003oooo00<0003oooooool0Moooo`00N?ooo`030000
oooooooo00D0000<oooo00@0003oooooool00006<ol01Oooo`040000oooooooo00000_ooo`050000
oooooooooooo000007[oool007Soool01@000?ooooooooooo`00000?oooo00@0003oooooool00006
<ol00_ooo`040000oooooooo00000oooo`030000oooo000000?oool00`000?ooooooo`1hoooo001i
oooo00<0003oooooool04Oooo`800007<ol00oooo`800005oooo0P0000;oool00`000?ooooooo`1i
oooo002?oooo1c?o08[oool008ooool7<ol0R_ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.36) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.32392 .12361 L
.33304 .12361 L
.33788 .12361 L
.34055 .12361 L
.34309 .12361 L
.34549 .12361 L
.34615 .12361 L
.34685 .12361 L
s
.34685 .12361 m
.34735 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.36) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`09oooo00<0003ooooo
ool02Oooo`030000oooooooo00Koool01?l0VOooooooo`0000_oool00`000?ooooooo`09oooo00<0
003oooooool02Oooo`030000<ol0<ol000Tco`000`0003?o03?o0009<ol000<0000co`0co`002C?o
00030000<ol0<ol000Tco`000`0003?o03?o0009<ol000<0000co`0co`001S?o02800006oooo00<0
003oooooool02Oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0joooo00<0003ooooo
ool04_ooo`03o`2Ioooooooo02Coool00`0003?o03?o000i<ol02@0003Coool00`000?ooooooo`0E
oooo001Xoooo00?o09Woooooool09?ooo`030000<ol0<ol003<co`060000EOooo`00J?ooo`03o`2I
oooooooo02Coool00`0003?o03?o000a<ol00P0005_oool006Soool00ol0VOooooooo`0Toooo00<0
000co`0co`00;c?o0080001Moooo001Xoooo00?o09Woooooool09?ooo`030000<ol0<ol002`co`03
0000Goooo`00J?ooo`03o`2Ioooooooo02Coool20000:S?o00<0001Roooo001Xoooo00?o09Wooooo
ool09?ooo`030000<ol0<ol002Lco`020000IOooo`00J?ooo`03o`2Ioooooooo02Coool00`0003?o
03?o000V<ol000<0003oooooool0IOooo`00J?ooo`03o`2Ioooooooo02Coool00`0003?o03?o000U
<ol000<0003oooooool0I_ooo`00J?ooo`03o`2Ioooooooo02Coool00`0003?o03?o000T<ol000<0
003oooooool0Ioooo`00J?ooo`03o`2Ioooooooo02Coool00`0003?o03?o000R<ol00P0006[oool0
06Soool00ol0VOooooooo`0Toooo0P00028co`000`000?ooooooo`1Zoooo001Xoooo00?o09Wooooo
ool09?ooo`030000<ol0<ol0020co`000`000?ooooooo`1[oooo001Xoooo00?o09Woooooool09?oo
o`030000<ol0<ol001lco`000`000?ooooooo`1/oooo001Xoooo00?o09Woooooool09?ooo`030000
<ol0<ol001lco`000`000?ooooooo`1/oooo001Xoooo00?o09Woooooool09?ooo`030000<ol0<ol0
01hco`000`000?ooooooo`1]oooo001Xoooo00?o09Woooooool09?ooo`030000<ol0<ol001dco`00
0`000?ooooooo`1^oooo001Xoooo00?o09Woooooool09?ooo`80000M<ol000<0003oooooool0Kooo
o`00J?ooo`03o`2Ioooooooo02Coool00`0003?o03?o000K<ol000<0003oooooool0L?ooo`00J?oo
o`03o`2Ioooooooo02Coool00`0003?o03?o000K<ol000<0003oooooool0L?ooo`00J?ooo`03o`2I
oooooooo02Coool00`0003?o03?o000J<ol000<0003oooooool0LOooo`00J?ooo`03o`2Ioooooooo
02Coool00`0003?o03?o000J<ol000<0003oooooool0LOooo`00J?ooo`03o`2Ioooooooo02Coool0
0`0003?o03?o000I<ol000<0003oooooool0L_ooo`00J?ooo`03o`2Ioooooooo02Coool200006S?o
00030000oooooooo07;oool006Soool00ol0VOooooooo`0Toooo00<0000co`0co`0063?o00030000
oooooooo07?oool006Soool00ol0VOooooooo`0Toooo00<0000co`0co`0063?o00030000oooooooo
07?oool006Soool00ol0VOooooooo`0Toooo00<0000co`0co`005c?o00030000oooooooo07Coool0
06Soool00ol0VOooooooo`0Toooo00<0000co`0co`005c?o00030000oooooooo07Coool006Soool0
0ol0VOooooooo`0Loooo1@0000?oool00`0003?o03?o000F<ol000<0003oooooool0MOooo`00J?oo
o`03o`2Ioooooooo01koool00`000?ooooooo`03oooo00<0000co`0co`005S?o00030000oooooooo
07Goool006Soool00ol0VOooooooo`0Noooo00<0003oooooool00oooo`<0000E<ol000<0003ooooo
ool0M_ooo`00J?ooo`03o`2Ioooooooo01koool00`000?ooooooo`03oooo00<0000co`0co`005C?o
00030000oooooooo07Koool006Soool00ol0VOooooooo`0Noooo00<0003oooooool00oooo`030000
<ol0<ol001Dco`000`000?ooooooo`1foooo001Xoooo00?o09Woooooool07Oooo`800005oooo00<0
000co`0co`0053?o00030000oooooooo07Ooool006Soool00ol0VOooooooo`0Toooo00<0000co`0c
o`0053?o00030000oooooooo07Ooool006Soool00ol0VOooooooo`0Toooo00<0000co`0co`004c?o
00030000oooooooo07Soool006Soool00ol0VOooooooo`0Toooo0P0001@co`000`000?ooooooo`1h
oooo001Xoooo00?o09Woooooool09?ooo`030000<ol0<ol001<co`000`000?ooooooo`1hoooo001X
oooo00?o09Woooooool09?ooo`030000<ol0<ol0018co`000`000?ooooooo`1ioooo001Xoooo00?o
09Woooooool09?ooo`030000<ol0<ol0018co`000`000?ooooooo`1ioooo001Xoooo00?o09Wooooo
ool09?ooo`030000<ol0<ol0018co`000`000?ooooooo`1ioooo001Xoooo00?o09Woooooool09?oo
o`030000<ol0<ol0014co`000`000?ooooooo`1joooo001Xoooo00?o09Woooooool09?ooo`80000B
<ol000<0003oooooool0N_ooo`00J?ooo`03o`2Ioooooooo02Coool00`0003?o03?o000A<ol000<0
003oooooool0N_ooo`00J?ooo`03o`2Ioooooooo02Coool00`0003?o03?o000A<ol000<0003ooooo
ool0N_ooo`00J?ooo`03o`2Ioooooooo02Coool00`0003?o03?o000@<ol000<0003oooooool0Nooo
o`00J?ooo`03o`2Ioooooooo02Coool00`0003?o03?o000@<ol000<0003oooooool0Noooo`00J?oo
o`03o`2Ioooooooo02Coool00`0003?o03?o000@<ol000<0003oooooool0Noooo`00J?ooo`03o`2I
oooooooo02Coool00`0003?o03?o000@<ol000<0003oooooool0Noooo`00J?ooo`03o`2Ioooooooo
02Coool2000043?o00030000oooooooo07coool006Soool00ol0VOooooooo`0Toooo00<0000co`0c
o`003c?o00030000oooooooo07coool006Soool00ol0VOooooooo`0Toooo00<0000co`0co`003c?o
00030000oooooooo07coool006Soool00ol0VOooooooo`0Toooo00<0000co`0co`003c?o00030000
oooooooo07coool006Soool00ol0VOooooooo`0Toooo00<0000co`0co`003c?o00030000oooooooo
07coool006Soool00ol0VOooooooo`0Toooo00<0000co`0co`003S?o00030000oooooooo07goool0
06Soool00ol0VOooooooo`0Toooo0P0000lco`000`000?ooooooo`1moooo001Xoooo00?o09Wooooo
ool09?ooo`030000<ol0<ol000hco`000`000?ooooooo`1moooo001Xoooo00?o09Woooooool09?oo
o`030000<ol0<ol000hco`000`000?ooooooo`1moooo001Xoooo00?o09Woooooool09?ooo`030000
<ol0<ol000dco`000`000?ooooooo`1noooo001Xoooo00?o09Woooooool07?ooo`@00004oooo00<0
000co`0co`003C?o00030000oooooooo07koool006Soool00ol0VOooooooo`0Loooo00<0003ooooo
ool01Oooo`030000<ol0<ol000dco`000`000?ooooooo`1noooo001Xoooo00?o09Woooooool07Ooo
o`030000oooooooo00Coool300003C?o00030000oooooooo07koool006Soool00ol0VOooooooo`0N
oooo00<0003oooooool00oooo`030000<ol0<ol000dco`000`000?ooooooo`1noooo001Xoooo00?o
09Woooooool07?ooo`040000oooooooo00001?ooo`030000<ol0<ol000`co`000`000?ooooooo`1o
oooo001Xoooo00?o09Woooooool07Oooo`800005oooo00<0000co`0co`0033?o00030000oooooooo
07ooool006Soool00ol0VOooooooo`0Toooo00<0000co`0co`0033?o00030000oooooooo07ooool0
06Soool00ol0VOooooooo`0Toooo00<0000co`0co`0033?o00030000oooooooo07ooool006Soool0
0ol0VOooooooo`0Toooo0P0000dco`000`000?ooooooo`1ooooo001Xoooo00?o09Woooooool09?oo
o`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001Xoooo00?o09Woooooool09?ooo`030000
<ol0<ol000/co`000`000?ooooooo`20oooo001Xoooo00?o09Woooooool09?ooo`030000<ol0<ol0
00/co`000`000?ooooooo`20oooo001Xoooo00?o09Woooooool09?ooo`030000<ol0<ol000/co`00
0`000?ooooooo`20oooo001Xoooo00?o09Woooooool09?ooo`030000<ol0<ol000/co`000`000?oo
ooooo`20oooo001Xoooo00?o09Woooooool09?ooo`030000<ol0<ol000/co`000`000?ooooooo`20
oooo001Xoooo00?o09Woooooool09?ooo`80000<<ol000<0003oooooool0P?ooo`00J?ooo`03o`2I
oooooooo02Coool00`0003?o03?o000;<ol000<0003oooooool0P?ooo`00J?ooo`03o`2Ioooooooo
02Coool00`0003?o03?o000:<ol000<0003oooooool0POooo`00J?ooo`03o`2Ioooooooo02Coool0
0`0003?o03?o000:<ol000<0003oooooool0POooo`00J?ooo`03o`2Ioooooooo02Coool00`0003?o
03?o000:<ol000<0003oooooool0POooo`00J?ooo`03o`2Ioooooooo02Coool00`0003?o03?o000:
<ol000<0003oooooool0POooo`00J?ooo`03o`2Ioooooooo02Coool200002c?o00030000oooooooo
087oool006Soool00ol0VOooooooo`0Toooo00<0000co`0co`002S?o00030000oooooooo087oool0
06Soool00ol0VOooooooo`0Toooo00<0000co`0co`002S?o00030000oooooooo087oool006Soool0
0ol0VOooooooo`0Toooo00<0000co`0co`002C?o00030000oooooooo08;oool006Soool00ol0VOoo
ooooo`0Toooo00<0000co`0co`002C?o00030000oooooooo08;oool006Soool00ol0VOooooooo`0T
oooo00<0000co`0co`002C?o00030000oooooooo08;oool006Soool00ol0VOooooooo`0Toooo0P00
00Xco`000`000?ooooooo`22oooo001Xoooo00?o09Woooooool09?ooo`030000<ol0<ol000Tco`00
0`000?ooooooo`22oooo001Xoooo00?o09Woooooool09?ooo`030000<ol0<ol000Tco`000`000?oo
ooooo`22oooo001Xoooo00?o09Woooooool09?ooo`030000<ol0<ol000Pco`000`000?ooooooo`23
oooo001Xoooo00?o09Woooooool07Oooo`800005oooo00<0000co`0co`0023?o00030000oooooooo
08?oool006Soool00ol0VOooooooo`0Loooo00@0003oooooool00004oooo00<0000co`0co`0023?o
00030000oooooooo08?oool006Soool00ol0VOooooooo`0Noooo00<0003oooooool00oooo`<00008
<ol000<0003oooooool0Poooo`00J?ooo`03o`2Ioooooooo01ooool00`000?ooooooo`02oooo00<0
000co`0co`0023?o00030000oooooooo08?oool006Soool00ol0VOooooooo`0Loooo00@0003ooooo
ool00004oooo00<0000co`0co`0023?o00030000oooooooo08?oool006Soool00ol0VOooooooo`0M
oooo0P0000Goool00`0003?o03?o0007<ol000<0003oooooool0Q?ooo`00J?ooo`03o`2Ioooooooo
02Coool00`0003?o03?o0007<ol000<0003oooooool0Q?ooo`00J?ooo`03o`2Ioooooooo02Coool0
0`0003?o03?o0007<ol000<0003oooooool0Q?ooo`00J?ooo`03o`2Ioooooooo02Coool00`0003?o
03?o0007<ol000<0003oooooool0Q?ooo`00J?ooo`03o`2Ioooooooo02Coool2000023?o00030000
oooooooo08Coool006Soool00ol0VOooooooo`0Toooo00<0000co`0co`001c?o00030000oooooooo
08Coool006Soool00ol0VOooooooo`0Toooo00<0000co`0co`001c?o00030000oooooooo08Coool0
06Soool00ol0VOooooooo`0Toooo00<0000co`0co`001c?o00030000oooooooo08Coool006Soool0
0ol0VOooooooo`0Toooo00<0000co`0co`001S?o00030000oooooooo08Goool006Soool00ol0VOoo
ooooo`0Toooo00<0000co`0co`001S?o00030000oooooooo08Goool006Soool00ol0VOooooooo`0T
oooo0P0000Lco`000`000?ooooooo`25oooo001Xoooo00?o09Woooooool09?ooo`030000<ol0<ol0
00Hco`000`000?ooooooo`25oooo001Xoooo00?o09Woooooool09?ooo`030000<ol0<ol000Hco`00
0`000?ooooooo`25oooo001Xoooo00?o09Woooooool09?ooo`030000<ol0<ol000Hco`000`000?oo
ooooo`25oooo001Xoooo00?o09Woooooool09?ooo`030000<ol0<ol000Hco`000`000?ooooooo`25
oooo001Xoooo00?o09Woooooool09?ooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001X
oooo00?o09Woooooool09?ooo`800006<ol000<0003oooooool0Q_ooo`00J?ooo`03o`2Ioooooooo
02Coool00`0003?o03?o0005<ol000<0003oooooool0Q_ooo`00J?ooo`03o`2Ioooooooo02Coool0
0`0003?o03?o0005<ol000<0003oooooool0Q_ooo`00J?ooo`03o`2Ioooooooo02Coool00`0003?o
03?o0005<ol000<0003oooooool0Q_ooo`00J?ooo`03o`2Ioooooooo02Coool00`0003?o03?o0005
<ol000<0003oooooool0Q_ooo`00J?ooo`03o`2Ioooooooo02Coool00`0003?o03?o0005<ol000<0
003oooooool0Q_ooo`00J?ooo`03o`2Ioooooooo02Coool200001S?o00030000oooooooo08Koool0
06Soool00ol0VOooooooo`0Toooo00<0000co`0co`001C?o00030000oooooooo08Koool006Soool0
0ol0VOooooooo`0Toooo00<0000co`0co`001C?o00030000oooooooo08Koool006Soool00ol0VOoo
ooooo`0Toooo00<0000co`0co`0013?o00030000oooooooo08Ooool006Soool00ol0VOooooooo`0T
oooo00<0000co`0co`0013?o00030000oooooooo08Ooool006Soool00ol0VOooooooo`0Noooo0`00
00?oool00`0003?o03?o0004<ol000<0003oooooool0Qoooo`00J?ooo`03o`2Ioooooooo01ooool0
0`000?ooooooo`02oooo00<0000co`0co`0013?o00030000oooooooo08Ooool006Soool00ol0VOoo
ooooo`0Loooo1@0000?oool3000013?o00030000oooooooo08Ooool008Ooool010000?ooooooo`00
00Coool7<ol0R_ooo`00R?ooo`030000oooo000000Coool7<ol0R_ooo`00ROooo`800004oooo1c?o
08[oool008ooool7<ol0R_ooo`00Soooo`Lco`2:oooo001ioooo00<0003oooooool04oooo`Lco`0>
oooo00<0003oooooool0NOooo`00N?ooo`030000oooooooo00Soool00`000?ooooooo`09oooo1c?o
00ooool00`000?ooooooo`1hoooo001hoooo00<0003oooooool00_ooo`800004oooo00<0003ooooo
ool01oooo`800004<ol00P000004<ol0oooooooooooo0P0000?oool300001?ooo`030000oooooooo
07Soool007Soool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
00Goool010000?ooooooo`0000Hco`02oooo00@0003oooooool00002oooo00@0003oooooool00003
oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo00;oool00`000?ooooooo`0=oooo00@0
003oooooool00006<ol01?ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0
003oooooool0Moooo`00N?ooo`030000oooooooo00D0000<oooo00@0003oooooool00006<ol01Ooo
o`030000oooooooo00<00004oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo0000
00ooool010000?ooooooo`0000Hco`02oooo00@0003oooooool00003oooo00<0003oooooool00ooo
o`030000oooooooo07Soool007Woool00`000?ooooooo`0Aoooo0P0000Lco`03oooo0P0000Coool3
00000_ooo`030000oooooooo07Woool008ooool7<ol0R_ooo`00Soooo`Lco`2:oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.38) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.32392 .12361 L
.33304 .12361 L
.33788 .12361 L
.34309 .12361 L
.34566 .12361 L
.34811 .12361 L
.35031 .12361 L
.35156 .12361 L
s
.35156 .12361 m
.35202 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.38) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`09oooo00<0003ooooo
ool02Oooo`030000oooooooo00Ooool00ol0VOooo`00000;oooo00<0003oooooool02Oooo`030000
oooooooo00Woool00`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Tco`00
0`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Hco`0R00001_ooo`030000
oooooooo00Woool00`000?ooooooo`0Eoooo000Foooo00<0003oooooool0>_ooo`030000oooooooo
01?oool00ol0VOooooooo`0Soooo00<0000co`0co`00>C?o00T0000doooo00<0003oooooool05Ooo
o`00JOooo`03o`2Ioooooooo02?oool00`0003?o03?o000c<ol01P0005Goool006Woool00ol0VOoo
ooooo`0Soooo00<0000co`0co`00<C?o0080001Koooo001Yoooo00?o09Woooooool08oooo`030000
<ol0<ol002lco`020000GOooo`00JOooo`03o`2Ioooooooo02?oool00`0003?o03?o000/<ol00`00
05ooool006Woool00ol0VOooooooo`0Soooo0P0002Xco`030000H_ooo`00JOooo`03o`2Ioooooooo
02?oool00`0003?o03?o000W<ol00P0006Goool006Woool00ol0VOooooooo`0Soooo00<0000co`0c
o`009S?o00030000oooooooo06Goool006Woool00ol0VOooooooo`0Soooo00<0000co`0co`009C?o
00030000oooooooo06Koool006Woool00ol0VOooooooo`0Soooo00<0000co`0co`0093?o00030000
oooooooo06Ooool006Woool00ol0VOooooooo`0Soooo00<0000co`0co`008S?o0080001Zoooo001Y
oooo00?o09Woooooool08oooo`80000R<ol000<0003oooooool0J_ooo`00JOooo`03o`2Ioooooooo
02?oool00`0003?o03?o000P<ol000<0003oooooool0Joooo`00JOooo`03o`2Ioooooooo02?oool0
0`0003?o03?o000O<ol000<0003oooooool0K?ooo`00JOooo`03o`2Ioooooooo02?oool00`0003?o
03?o000O<ol000<0003oooooool0K?ooo`00JOooo`03o`2Ioooooooo02?oool00`0003?o03?o000N
<ol000<0003oooooool0KOooo`00JOooo`03o`2Ioooooooo02?oool00`0003?o03?o000M<ol000<0
003oooooool0K_ooo`00JOooo`03o`2Ioooooooo02?oool200007C?o00030000oooooooo06ooool0
06Woool00ol0VOooooooo`0Soooo00<0000co`0co`006c?o00030000oooooooo073oool006Woool0
0ol0VOooooooo`0Soooo00<0000co`0co`006c?o00030000oooooooo073oool006Woool00ol0VOoo
ooooo`0Soooo00<0000co`0co`006S?o00030000oooooooo077oool006Woool00ol0VOooooooo`0S
oooo00<0000co`0co`006S?o00030000oooooooo077oool006Woool00ol0VOooooooo`0Soooo00<0
000co`0co`006C?o00030000oooooooo07;oool006Woool00ol0VOooooooo`0Soooo0P0001Xco`00
0`000?ooooooo`1boooo001Yoooo00?o09Woooooool08oooo`030000<ol0<ol001Pco`000`000?oo
ooooo`1coooo001Yoooo00?o09Woooooool08oooo`030000<ol0<ol001Pco`000`000?ooooooo`1c
oooo001Yoooo00?o09Woooooool08oooo`030000<ol0<ol001Lco`000`000?ooooooo`1doooo001Y
oooo00?o09Woooooool08oooo`030000<ol0<ol001Lco`000`000?ooooooo`1doooo001Yoooo00?o
09Woooooool06oooo`D00003oooo00<0000co`0co`005S?o00030000oooooooo07Goool006Woool0
0ol0VOooooooo`0Moooo00<0003oooooool00oooo`030000<ol0<ol001Hco`000`000?ooooooo`1e
oooo001Yoooo00?o09Woooooool07Oooo`030000oooooooo00?oool300005C?o00030000oooooooo
07Koool006Woool00ol0VOooooooo`0Moooo00<0003oooooool00oooo`030000<ol0<ol001Dco`00
0`000?ooooooo`1foooo001Yoooo00?o09Woooooool07Oooo`030000oooooooo00?oool00`0003?o
03?o000E<ol000<0003oooooool0M_ooo`00JOooo`03o`2Ioooooooo01coool200001Oooo`030000
<ol0<ol001@co`000`000?ooooooo`1goooo001Yoooo00?o09Woooooool08oooo`030000<ol0<ol0
01@co`000`000?ooooooo`1goooo001Yoooo00?o09Woooooool08oooo`030000<ol0<ol001<co`00
0`000?ooooooo`1hoooo001Yoooo00?o09Woooooool08oooo`80000D<ol000<0003oooooool0N?oo
o`00JOooo`03o`2Ioooooooo02?oool00`0003?o03?o000C<ol000<0003oooooool0N?ooo`00JOoo
o`03o`2Ioooooooo02?oool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00JOooo`03o`2I
oooooooo02?oool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00JOooo`03o`2Ioooooooo
02?oool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00JOooo`03o`2Ioooooooo02?oool0
0`0003?o03?o000A<ol000<0003oooooool0N_ooo`00JOooo`03o`2Ioooooooo02?oool200004S?o
00030000oooooooo07[oool006Woool00ol0VOooooooo`0Soooo00<0000co`0co`004C?o00030000
oooooooo07[oool006Woool00ol0VOooooooo`0Soooo00<0000co`0co`004C?o00030000oooooooo
07[oool006Woool00ol0VOooooooo`0Soooo00<0000co`0co`0043?o00030000oooooooo07_oool0
06Woool00ol0VOooooooo`0Soooo00<0000co`0co`0043?o00030000oooooooo07_oool006Woool0
0ol0VOooooooo`0Soooo00<0000co`0co`0043?o00030000oooooooo07_oool006Woool00ol0VOoo
ooooo`0Soooo00<0000co`0co`0043?o00030000oooooooo07_oool006Woool00ol0VOooooooo`0S
oooo0P00010co`000`000?ooooooo`1loooo001Yoooo00?o09Woooooool08oooo`030000<ol0<ol0
00lco`000`000?ooooooo`1loooo001Yoooo00?o09Woooooool08oooo`030000<ol0<ol000lco`00
0`000?ooooooo`1loooo001Yoooo00?o09Woooooool08oooo`030000<ol0<ol000lco`000`000?oo
ooooo`1loooo001Yoooo00?o09Woooooool08oooo`030000<ol0<ol000lco`000`000?ooooooo`1l
oooo001Yoooo00?o09Woooooool08oooo`030000<ol0<ol000hco`000`000?ooooooo`1moooo001Y
oooo00?o09Woooooool08oooo`80000?<ol000<0003oooooool0OOooo`00JOooo`03o`2Ioooooooo
02?oool00`0003?o03?o000><ol000<0003oooooool0OOooo`00JOooo`03o`2Ioooooooo02?oool0
0`0003?o03?o000><ol000<0003oooooool0OOooo`00JOooo`03o`2Ioooooooo02?oool00`0003?o
03?o000=<ol000<0003oooooool0O_ooo`00JOooo`03o`2Ioooooooo01_oool400001?ooo`030000
<ol0<ol000dco`000`000?ooooooo`1noooo001Yoooo00?o09Woooooool06oooo`030000oooooooo
00Goool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00JOooo`03o`2Ioooooooo01coool0
0`000?ooooooo`04oooo0`0000dco`000`000?ooooooo`1noooo001Yoooo00?o09Woooooool07Ooo
o`030000oooooooo00?oool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00JOooo`03o`2I
oooooooo01_oool010000?ooooooo`0000Coool00`0003?o03?o000<<ol000<0003oooooool0Oooo
o`00JOooo`03o`2Ioooooooo01coool200001Oooo`030000<ol0<ol000`co`000`000?ooooooo`1o
oooo001Yoooo00?o09Woooooool08oooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001Y
oooo00?o09Woooooool08oooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001Yoooo00?o
09Woooooool08oooo`80000=<ol000<0003oooooool0Ooooo`00JOooo`03o`2Ioooooooo02?oool0
0`0003?o03?o000<<ol000<0003oooooool0Ooooo`00JOooo`03o`2Ioooooooo02?oool00`0003?o
03?o000;<ol000<0003oooooool0P?ooo`00JOooo`03o`2Ioooooooo02?oool00`0003?o03?o000;
<ol000<0003oooooool0P?ooo`00JOooo`03o`2Ioooooooo02?oool00`0003?o03?o000;<ol000<0
003oooooool0P?ooo`00JOooo`03o`2Ioooooooo02?oool00`0003?o03?o000;<ol000<0003ooooo
ool0P?ooo`00JOooo`03o`2Ioooooooo02?oool00`0003?o03?o000;<ol000<0003oooooool0P?oo
o`00JOooo`03o`2Ioooooooo02?oool2000033?o00030000oooooooo083oool006Woool00ol0VOoo
ooooo`0Soooo00<0000co`0co`002c?o00030000oooooooo083oool006Woool00ol0VOooooooo`0S
oooo00<0000co`0co`002S?o00030000oooooooo087oool006Woool00ol0VOooooooo`0Soooo00<0
000co`0co`002S?o00030000oooooooo087oool006Woool00ol0VOooooooo`0Soooo00<0000co`0c
o`002S?o00030000oooooooo087oool006Woool00ol0VOooooooo`0Soooo00<0000co`0co`002S?o
00030000oooooooo087oool006Woool00ol0VOooooooo`0Soooo0P0000/co`000`000?ooooooo`21
oooo001Yoooo00?o09Woooooool08oooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001Y
oooo00?o09Woooooool08oooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001Yoooo00?o
09Woooooool08oooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001Yoooo00?o09Wooooo
ool08oooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001Yoooo00?o09Woooooool08ooo
o`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001Yoooo00?o09Woooooool08oooo`80000:
<ol000<0003oooooool0P_ooo`00JOooo`03o`2Ioooooooo02?oool00`0003?o03?o0009<ol000<0
003oooooool0P_ooo`00JOooo`03o`2Ioooooooo02?oool00`0003?o03?o0009<ol000<0003ooooo
ool0P_ooo`00JOooo`03o`2Ioooooooo02?oool00`0003?o03?o0008<ol000<0003oooooool0Pooo
o`00JOooo`03o`2Ioooooooo01coool200001Oooo`030000<ol0<ol000Pco`000`000?ooooooo`23
oooo001Yoooo00?o09Woooooool06oooo`040000oooooooo00001?ooo`030000<ol0<ol000Pco`00
0`000?ooooooo`23oooo001Yoooo00?o09Woooooool07Oooo`030000oooooooo00?oool3000023?o
00030000oooooooo08?oool006Woool00ol0VOooooooo`0Noooo00<0003oooooool00_ooo`030000
<ol0<ol000Pco`000`000?ooooooo`23oooo001Yoooo00?o09Woooooool06oooo`040000oooooooo
00001?ooo`030000<ol0<ol000Pco`000`000?ooooooo`23oooo001Yoooo00?o09Woooooool07?oo
o`800005oooo00<0000co`0co`001c?o00030000oooooooo08Coool006Woool00ol0VOooooooo`0S
oooo00<0000co`0co`001c?o00030000oooooooo08Coool006Woool00ol0VOooooooo`0Soooo00<0
000co`0co`001c?o00030000oooooooo08Coool006Woool00ol0VOooooooo`0Soooo00<0000co`0c
o`001c?o00030000oooooooo08Coool006Woool00ol0VOooooooo`0Soooo0P0000Pco`000`000?oo
ooooo`24oooo001Yoooo00?o09Woooooool08oooo`030000<ol0<ol000Lco`000`000?ooooooo`24
oooo001Yoooo00?o09Woooooool08oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001Y
oooo00?o09Woooooool08oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001Yoooo00?o
09Woooooool08oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001Yoooo00?o09Wooooo
ool08oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001Yoooo00?o09Woooooool08ooo
o`800007<ol000<0003oooooool0QOooo`00JOooo`03o`2Ioooooooo02?oool00`0003?o03?o0006
<ol000<0003oooooool0QOooo`00JOooo`03o`2Ioooooooo02?oool00`0003?o03?o0006<ol000<0
003oooooool0QOooo`00JOooo`03o`2Ioooooooo02?oool00`0003?o03?o0006<ol000<0003ooooo
ool0QOooo`00JOooo`03o`2Ioooooooo02?oool00`0003?o03?o0006<ol000<0003oooooool0QOoo
o`00JOooo`03o`2Ioooooooo02?oool00`0003?o03?o0006<ol000<0003oooooool0QOooo`00JOoo
o`03o`2Ioooooooo02?oool200001S?o00030000oooooooo08Koool006Woool00ol0VOooooooo`0S
oooo00<0000co`0co`001C?o00030000oooooooo08Koool006Woool00ol0VOooooooo`0Soooo00<0
000co`0co`001C?o00030000oooooooo08Koool006Woool00ol0VOooooooo`0Soooo00<0000co`0c
o`001C?o00030000oooooooo08Koool006Woool00ol0VOooooooo`0Soooo00<0000co`0co`001C?o
00030000oooooooo08Koool006Woool00ol0VOooooooo`0Soooo00<0000co`0co`001C?o00030000
oooooooo08Koool006Woool00ol0VOooooooo`0Soooo0P0000Hco`000`000?ooooooo`26oooo001Y
oooo00?o09Woooooool08oooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001Yoooo00?o
09Woooooool08oooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001Yoooo00?o09Wooooo
ool08oooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001Yoooo00?o09Woooooool08ooo
o`030000<ol0<ol000@co`000`000?ooooooo`27oooo001Yoooo00?o09Woooooool07Oooo`<00003
oooo00<0000co`0co`0013?o00030000oooooooo08Ooool006Woool00ol0VOooooooo`0Noooo00<0
003oooooool00_ooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001Yoooo00?o09Wooooo
ool06oooo`D00003oooo0`0000@co`000`000?ooooooo`27oooo0027oooo00@0003oooooool00004
oooo1c?o08[oool008Soool00`000?ooo`000004oooo1c?o08[oool008Woool200001?ooo`Lco`2:
oooo002?oooo1c?o08[oool008ooool7<ol0R_ooo`00NOooo`030000oooooooo01?oool7<ol03_oo
o`030000oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool02Oooo`Lco`0?
oooo00<0003oooooool0N?ooo`00N?ooo`030000oooooooo00;oool200001?ooo`030000oooooooo
00Ooool2000013?o0080000013?o0?ooooooooooo`800004oooo0P0000Coool00`000?ooooooo`1h
oooo001hoooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`05
oooo00@0003oooooool00006<ol00_ooo`040000oooooooo00000_ooo`040000oooooooo00000ooo
o`030000oooooooo07Soool007Ooool00`000?ooooooo`02oooo00<0003oooooool03Oooo`040000
oooooooo00001S?o00Coool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000
oooooooo07Ooool007Soool00`000?ooooooo`0500003?ooo`040000oooooooo00001S?o00Goool0
10000?ooooooooooo`800004oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo0000
00ooool010000?ooooooo`0000Hco`02oooo00@0003oooooool00002oooo00@0003oooooool00003
oooo00<0003oooooool0N?ooo`00NOooo`030000oooooooo017oool200001c?o00?oool200001?oo
o`800003oooo00<0003oooooool0NOooo`00Soooo`Lco`2:oooo002?oooo1c?o08[oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.32392 .12361 L
.33304 .12361 L
.34309 .12361 L
.34772 .12361 L
.35028 .12361 L
.35271 .12361 L
.35496 .12361 L
.35624 .12361 L
s
.35624 .12361 m
.35671 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`09oooo00<0003ooooo
ool02Oooo`030000oooooooo00Woool00`000?ooooooo`09oooo00<0003oooooool02Oooo`030000
oooooooo00Woool00`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Tco`00
0`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Hco`0R00001_ooo`030000
oooooooo00Woool00`000?ooooooo`0Eoooo000Foooo00<0003oooooool0>_ooo`030000oooooooo
01Goool00ol0VOooooooo`0Qoooo00<0000co`0co`00>C?o00T0000doooo00<0003oooooool05Ooo
o`00Joooo`03o`2Ioooooooo027oool00`0003?o03?o000c<ol01P0005Goool006_oool00ol0VOoo
ooooo`0Qoooo00<0000co`0co`00<C?o0080001Koooo001[oooo00?o09Woooooool08Oooo`030000
<ol0<ol002lco`020000GOooo`00Joooo`03o`2Ioooooooo027oool00`0003?o03?o000/<ol00`00
05ooool006_oool00ol0VOooooooo`0Qoooo0P0002Xco`030000H_ooo`00Joooo`03o`2Ioooooooo
027oool00`0003?o03?o000W<ol00P0006Goool006_oool00ol0VOooooooo`0Qoooo00<0000co`0c
o`009S?o00030000oooooooo06Goool006_oool00ol0VOooooooo`0Qoooo00<0000co`0co`009C?o
00030000oooooooo06Koool006_oool00ol0VOooooooo`0Qoooo00<0000co`0co`0093?o00030000
oooooooo06Ooool006_oool00ol0VOooooooo`0Qoooo00<0000co`0co`008S?o0080001Zoooo001[
oooo00?o09Woooooool08Oooo`80000R<ol000<0003oooooool0J_ooo`00Joooo`03o`2Ioooooooo
027oool00`0003?o03?o000P<ol000<0003oooooool0Joooo`00Joooo`03o`2Ioooooooo027oool0
0`0003?o03?o000O<ol000<0003oooooool0K?ooo`00Joooo`03o`2Ioooooooo027oool00`0003?o
03?o000O<ol000<0003oooooool0K?ooo`00Joooo`03o`2Ioooooooo027oool00`0003?o03?o000N
<ol000<0003oooooool0KOooo`00Joooo`03o`2Ioooooooo027oool00`0003?o03?o000M<ol000<0
003oooooool0K_ooo`00Joooo`03o`2Ioooooooo027oool200007C?o00030000oooooooo06ooool0
06_oool00ol0VOooooooo`0Qoooo00<0000co`0co`006c?o00030000oooooooo073oool006_oool0
0ol0VOooooooo`0Qoooo00<0000co`0co`006c?o00030000oooooooo073oool006_oool00ol0VOoo
ooooo`0Qoooo00<0000co`0co`006S?o00030000oooooooo077oool006_oool00ol0VOooooooo`0Q
oooo00<0000co`0co`006S?o00030000oooooooo077oool006_oool00ol0VOooooooo`0Qoooo00<0
000co`0co`006C?o00030000oooooooo07;oool006_oool00ol0VOooooooo`0Qoooo0P0001Xco`00
0`000?ooooooo`1boooo001[oooo00?o09Woooooool08Oooo`030000<ol0<ol001Pco`000`000?oo
ooooo`1coooo001[oooo00?o09Woooooool08Oooo`030000<ol0<ol001Pco`000`000?ooooooo`1c
oooo001[oooo00?o09Woooooool08Oooo`030000<ol0<ol001Lco`000`000?ooooooo`1doooo001[
oooo00?o09Woooooool08Oooo`030000<ol0<ol001Lco`000`000?ooooooo`1doooo001[oooo00?o
09Woooooool06Oooo`D00003oooo00<0000co`0co`005S?o00030000oooooooo07Goool006_oool0
0ol0VOooooooo`0Koooo00<0003oooooool00oooo`030000<ol0<ol001Hco`000`000?ooooooo`1e
oooo001[oooo00?o09Woooooool06oooo`030000oooooooo00?oool300005C?o00030000oooooooo
07Koool006_oool00ol0VOooooooo`0Koooo00<0003oooooool00oooo`030000<ol0<ol001Dco`00
0`000?ooooooo`1foooo001[oooo00?o09Woooooool06oooo`030000oooooooo00?oool00`0003?o
03?o000E<ol000<0003oooooool0M_ooo`00Joooo`03o`2Ioooooooo01[oool200001Oooo`030000
<ol0<ol001@co`000`000?ooooooo`1goooo001[oooo00?o09Woooooool08Oooo`030000<ol0<ol0
01@co`000`000?ooooooo`1goooo001[oooo00?o09Woooooool08Oooo`030000<ol0<ol001<co`00
0`000?ooooooo`1hoooo001[oooo00?o09Woooooool08Oooo`80000D<ol000<0003oooooool0N?oo
o`00Joooo`03o`2Ioooooooo027oool00`0003?o03?o000C<ol000<0003oooooool0N?ooo`00Jooo
o`03o`2Ioooooooo027oool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00Joooo`03o`2I
oooooooo027oool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00Joooo`03o`2Ioooooooo
027oool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00Joooo`03o`2Ioooooooo027oool0
0`0003?o03?o000A<ol000<0003oooooool0N_ooo`00Joooo`03o`2Ioooooooo027oool200004S?o
00030000oooooooo07[oool006_oool00ol0VOooooooo`0Qoooo00<0000co`0co`004C?o00030000
oooooooo07[oool006_oool00ol0VOooooooo`0Qoooo00<0000co`0co`004C?o00030000oooooooo
07[oool006_oool00ol0VOooooooo`0Qoooo00<0000co`0co`0043?o00030000oooooooo07_oool0
06_oool00ol0VOooooooo`0Qoooo00<0000co`0co`0043?o00030000oooooooo07_oool006_oool0
0ol0VOooooooo`0Qoooo00<0000co`0co`0043?o00030000oooooooo07_oool006_oool00ol0VOoo
ooooo`0Qoooo00<0000co`0co`0043?o00030000oooooooo07_oool006_oool00ol0VOooooooo`0Q
oooo0P00010co`000`000?ooooooo`1loooo001[oooo00?o09Woooooool08Oooo`030000<ol0<ol0
00lco`000`000?ooooooo`1loooo001[oooo00?o09Woooooool08Oooo`030000<ol0<ol000lco`00
0`000?ooooooo`1loooo001[oooo00?o09Woooooool08Oooo`030000<ol0<ol000lco`000`000?oo
ooooo`1loooo001[oooo00?o09Woooooool08Oooo`030000<ol0<ol000lco`000`000?ooooooo`1l
oooo001[oooo00?o09Woooooool08Oooo`030000<ol0<ol000hco`000`000?ooooooo`1moooo001[
oooo00?o09Woooooool08Oooo`80000?<ol000<0003oooooool0OOooo`00Joooo`03o`2Ioooooooo
027oool00`0003?o03?o000><ol000<0003oooooool0OOooo`00Joooo`03o`2Ioooooooo027oool0
0`0003?o03?o000><ol000<0003oooooool0OOooo`00Joooo`03o`2Ioooooooo027oool00`0003?o
03?o000=<ol000<0003oooooool0O_ooo`00Joooo`03o`2Ioooooooo01Woool400001?ooo`030000
<ol0<ol000dco`000`000?ooooooo`1noooo001[oooo00?o09Woooooool06Oooo`030000oooooooo
00Goool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00Joooo`03o`2Ioooooooo01[oool0
0`000?ooooooo`04oooo0`0000dco`000`000?ooooooo`1noooo001[oooo00?o09Woooooool06ooo
o`030000oooooooo00?oool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00Joooo`03o`2I
oooooooo01Woool010000?ooooooo`0000Coool00`0003?o03?o000<<ol000<0003oooooool0Oooo
o`00Joooo`03o`2Ioooooooo01[oool200001Oooo`030000<ol0<ol000`co`000`000?ooooooo`1o
oooo001[oooo00?o09Woooooool08Oooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001[
oooo00?o09Woooooool08Oooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001[oooo00?o
09Woooooool08Oooo`80000=<ol000<0003oooooool0Ooooo`00Joooo`03o`2Ioooooooo027oool0
0`0003?o03?o000<<ol000<0003oooooool0Ooooo`00Joooo`03o`2Ioooooooo027oool00`0003?o
03?o000;<ol000<0003oooooool0P?ooo`00Joooo`03o`2Ioooooooo027oool00`0003?o03?o000;
<ol000<0003oooooool0P?ooo`00Joooo`03o`2Ioooooooo027oool00`0003?o03?o000;<ol000<0
003oooooool0P?ooo`00Joooo`03o`2Ioooooooo027oool00`0003?o03?o000;<ol000<0003ooooo
ool0P?ooo`00Joooo`03o`2Ioooooooo027oool00`0003?o03?o000;<ol000<0003oooooool0P?oo
o`00Joooo`03o`2Ioooooooo027oool2000033?o00030000oooooooo083oool006_oool00ol0VOoo
ooooo`0Qoooo00<0000co`0co`002c?o00030000oooooooo083oool006_oool00ol0VOooooooo`0Q
oooo00<0000co`0co`002S?o00030000oooooooo087oool006_oool00ol0VOooooooo`0Qoooo00<0
000co`0co`002S?o00030000oooooooo087oool006_oool00ol0VOooooooo`0Qoooo00<0000co`0c
o`002S?o00030000oooooooo087oool006_oool00ol0VOooooooo`0Qoooo00<0000co`0co`002S?o
00030000oooooooo087oool006_oool00ol0VOooooooo`0Qoooo0P0000/co`000`000?ooooooo`21
oooo001[oooo00?o09Woooooool08Oooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001[
oooo00?o09Woooooool08Oooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001[oooo00?o
09Woooooool08Oooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001[oooo00?o09Wooooo
ool08Oooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001[oooo00?o09Woooooool08Ooo
o`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001[oooo00?o09Woooooool08Oooo`80000:
<ol000<0003oooooool0P_ooo`00Joooo`03o`2Ioooooooo027oool00`0003?o03?o0009<ol000<0
003oooooool0P_ooo`00Joooo`03o`2Ioooooooo027oool00`0003?o03?o0009<ol000<0003ooooo
ool0P_ooo`00Joooo`03o`2Ioooooooo027oool00`0003?o03?o0008<ol000<0003oooooool0Pooo
o`00Joooo`03o`2Ioooooooo01[oool200001Oooo`030000<ol0<ol000Pco`000`000?ooooooo`23
oooo001[oooo00?o09Woooooool06Oooo`040000oooooooo00001?ooo`030000<ol0<ol000Pco`00
0`000?ooooooo`23oooo001[oooo00?o09Woooooool06oooo`030000oooooooo00?oool3000023?o
00030000oooooooo08?oool006_oool00ol0VOooooooo`0Loooo00<0003oooooool00_ooo`030000
<ol0<ol000Pco`000`000?ooooooo`23oooo001[oooo00?o09Woooooool06Oooo`040000oooooooo
00001?ooo`030000<ol0<ol000Pco`000`000?ooooooo`23oooo001[oooo00?o09Woooooool06_oo
o`800005oooo00<0000co`0co`001c?o00030000oooooooo08Coool006_oool00ol0VOooooooo`0Q
oooo00<0000co`0co`001c?o00030000oooooooo08Coool006_oool00ol0VOooooooo`0Qoooo00<0
000co`0co`001c?o00030000oooooooo08Coool006_oool00ol0VOooooooo`0Qoooo00<0000co`0c
o`001c?o00030000oooooooo08Coool006_oool00ol0VOooooooo`0Qoooo0P0000Pco`000`000?oo
ooooo`24oooo001[oooo00?o09Woooooool08Oooo`030000<ol0<ol000Lco`000`000?ooooooo`24
oooo001[oooo00?o09Woooooool08Oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001[
oooo00?o09Woooooool08Oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001[oooo00?o
09Woooooool08Oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001[oooo00?o09Wooooo
ool08Oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001[oooo00?o09Woooooool08Ooo
o`800007<ol000<0003oooooool0QOooo`00Joooo`03o`2Ioooooooo027oool00`0003?o03?o0006
<ol000<0003oooooool0QOooo`00Joooo`03o`2Ioooooooo027oool00`0003?o03?o0006<ol000<0
003oooooool0QOooo`00Joooo`03o`2Ioooooooo027oool00`0003?o03?o0006<ol000<0003ooooo
ool0QOooo`00Joooo`03o`2Ioooooooo027oool00`0003?o03?o0006<ol000<0003oooooool0QOoo
o`00Joooo`03o`2Ioooooooo027oool00`0003?o03?o0006<ol000<0003oooooool0QOooo`00Jooo
o`03o`2Ioooooooo027oool200001S?o00030000oooooooo08Koool006_oool00ol0VOooooooo`0Q
oooo00<0000co`0co`001C?o00030000oooooooo08Koool006_oool00ol0VOooooooo`0Qoooo00<0
000co`0co`001C?o00030000oooooooo08Koool006_oool00ol0VOooooooo`0Qoooo00<0000co`0c
o`001C?o00030000oooooooo08Koool006_oool00ol0VOooooooo`0Qoooo00<0000co`0co`001C?o
00030000oooooooo08Koool006_oool00ol0VOooooooo`0Qoooo00<0000co`0co`001C?o00030000
oooooooo08Koool006_oool00ol0VOooooooo`0Qoooo0P0000Hco`000`000?ooooooo`26oooo001[
oooo00?o09Woooooool08Oooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001[oooo00?o
09Woooooool08Oooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001[oooo00?o09Wooooo
ool08Oooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001[oooo00?o09Woooooool08Ooo
o`030000<ol0<ol000@co`000`000?ooooooo`27oooo001[oooo00?o09Woooooool06oooo`<00003
oooo00<0000co`0co`0013?o00030000oooooooo08Ooool006_oool00ol0VOooooooo`0Loooo00<0
003oooooool00_ooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001[oooo00?o09Wooooo
ool06Oooo`D00003oooo0`0000@co`000`000?ooooooo`27oooo0027oooo00@0003oooooool00004
oooo1c?o08[oool008Soool00`000?ooo`000004oooo1c?o08[oool008Woool200001?ooo`Lco`2:
oooo002?oooo1c?o08[oool008ooool7<ol0R_ooo`00O?ooo`030000oooooooo013oool7<ol02ooo
o`030000oooooooo07coool007_oool00`000?ooooooo`08oooo00<0003oooooool01_ooo`Lco`0<
oooo00<0003oooooool0Noooo`00Noooo`030000oooooooo00;oool200001?ooo`030000oooooooo
00Koool00c?o000000000004<ol00P0000Goool300000_ooo`030000oooooooo07_oool007_oool0
1@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo00Goool0100003?o
03?o000000<co`08oooo00D0003oooooooooool00000OOooo`00N_ooo`030000oooooooo00;oool0
0`000?ooooooo`0=oooo00@0000co`0co`000003<ol01Oooo`D00003oooo00<0003oooooool0N_oo
o`00Noooo`030000oooooooo00D0000<oooo00@0000co`0co`000003<ol01Oooo`040000oooooooo
00000oooo`030000oooooooo07_oool007_oool01@000?ooooooooooo`00000?oooo00@0000co`0c
o`000003<ol01_ooo`030000oooo000000?oool00`000?ooooooo`1koooo001loooo00<0003ooooo
ool04?ooo`03<ol00000000000@co`07oooo0P0000;oool00`000?ooooooo`1loooo002?oooo1c?o
08[oool008ooool7<ol0R_ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.42) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.32392 .12361 L
.34309 .12361 L
.35271 .12361 L
.35742 .12361 L
.35948 .12361 L
.36057 .12361 L
.36173 .12361 L
s
.36173 .12361 m
.36221 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.42) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`09oooo00<0003ooooo
ool02Oooo`030000oooooooo00Woool00`000?l0VOooo`09oooo00<0003oooooool02Oooo`030000
oooooooo00Woool00`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Tco`00
0`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Hco`0R00001_ooo`030000
oooooooo00Woool00`000?ooooooo`0Eoooo000Foooo00<0003oooooool0>_ooo`030000oooooooo
01Koool00ol0VOooooooo`0Poooo00<0000co`0co`00>C?o00T0000doooo00<0003oooooool05Ooo
o`00K?ooo`03o`2Ioooooooo023oool00`0003?o03?o000c<ol01P0005Goool006coool00ol0VOoo
ooooo`0Poooo00<0000co`0co`00<C?o0080001Koooo001/oooo00?o09Woooooool08?ooo`030000
<ol0<ol002lco`020000GOooo`00K?ooo`03o`2Ioooooooo023oool00`0003?o03?o000/<ol00`00
05ooool006coool00ol0VOooooooo`0Poooo0P0002Xco`030000H_ooo`00K?ooo`03o`2Ioooooooo
023oool00`0003?o03?o000W<ol00P0006Goool006coool00ol0VOooooooo`0Poooo00<0000co`0c
o`009S?o00030000oooooooo06Goool006coool00ol0VOooooooo`0Poooo00<0000co`0co`009C?o
00030000oooooooo06Koool006coool00ol0VOooooooo`0Poooo00<0000co`0co`0093?o00030000
oooooooo06Ooool006coool00ol0VOooooooo`0Poooo00<0000co`0co`008S?o0080001Zoooo001/
oooo00?o09Woooooool08?ooo`80000R<ol000<0003oooooool0J_ooo`00K?ooo`03o`2Ioooooooo
023oool00`0003?o03?o000P<ol000<0003oooooool0Joooo`00K?ooo`03o`2Ioooooooo023oool0
0`0003?o03?o000O<ol000<0003oooooool0K?ooo`00K?ooo`03o`2Ioooooooo023oool00`0003?o
03?o000O<ol000<0003oooooool0K?ooo`00K?ooo`03o`2Ioooooooo023oool00`0003?o03?o000N
<ol000<0003oooooool0KOooo`00K?ooo`03o`2Ioooooooo023oool00`0003?o03?o000M<ol000<0
003oooooool0K_ooo`00K?ooo`03o`2Ioooooooo023oool200007C?o00030000oooooooo06ooool0
06coool00ol0VOooooooo`0Poooo00<0000co`0co`006c?o00030000oooooooo073oool006coool0
0ol0VOooooooo`0Poooo00<0000co`0co`006c?o00030000oooooooo073oool006coool00ol0VOoo
ooooo`0Poooo00<0000co`0co`006S?o00030000oooooooo077oool006coool00ol0VOooooooo`0P
oooo00<0000co`0co`006S?o00030000oooooooo077oool006coool00ol0VOooooooo`0Poooo00<0
000co`0co`006C?o00030000oooooooo07;oool006coool00ol0VOooooooo`0Poooo0P0001Xco`00
0`000?ooooooo`1boooo001/oooo00?o09Woooooool08?ooo`030000<ol0<ol001Pco`000`000?oo
ooooo`1coooo001/oooo00?o09Woooooool08?ooo`030000<ol0<ol001Pco`000`000?ooooooo`1c
oooo001/oooo00?o09Woooooool08?ooo`030000<ol0<ol001Lco`000`000?ooooooo`1doooo001/
oooo00?o09Woooooool08?ooo`030000<ol0<ol001Lco`000`000?ooooooo`1doooo001/oooo00?o
09Woooooool06?ooo`D00003oooo00<0000co`0co`005S?o00030000oooooooo07Goool006coool0
0ol0VOooooooo`0Joooo00<0003oooooool00oooo`030000<ol0<ol001Hco`000`000?ooooooo`1e
oooo001/oooo00?o09Woooooool06_ooo`030000oooooooo00?oool300005C?o00030000oooooooo
07Koool006coool00ol0VOooooooo`0Joooo00<0003oooooool00oooo`030000<ol0<ol001Dco`00
0`000?ooooooo`1foooo001/oooo00?o09Woooooool06_ooo`030000oooooooo00?oool00`0003?o
03?o000E<ol000<0003oooooool0M_ooo`00K?ooo`03o`2Ioooooooo01Woool200001Oooo`030000
<ol0<ol001@co`000`000?ooooooo`1goooo001/oooo00?o09Woooooool08?ooo`030000<ol0<ol0
01@co`000`000?ooooooo`1goooo001/oooo00?o09Woooooool08?ooo`030000<ol0<ol001<co`00
0`000?ooooooo`1hoooo001/oooo00?o09Woooooool08?ooo`80000D<ol000<0003oooooool0N?oo
o`00K?ooo`03o`2Ioooooooo023oool00`0003?o03?o000C<ol000<0003oooooool0N?ooo`00K?oo
o`03o`2Ioooooooo023oool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00K?ooo`03o`2I
oooooooo023oool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00K?ooo`03o`2Ioooooooo
023oool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00K?ooo`03o`2Ioooooooo023oool0
0`0003?o03?o000A<ol000<0003oooooool0N_ooo`00K?ooo`03o`2Ioooooooo023oool200004S?o
00030000oooooooo07[oool006coool00ol0VOooooooo`0Poooo00<0000co`0co`004C?o00030000
oooooooo07[oool006coool00ol0VOooooooo`0Poooo00<0000co`0co`004C?o00030000oooooooo
07[oool006coool00ol0VOooooooo`0Poooo00<0000co`0co`0043?o00030000oooooooo07_oool0
06coool00ol0VOooooooo`0Poooo00<0000co`0co`0043?o00030000oooooooo07_oool006coool0
0ol0VOooooooo`0Poooo00<0000co`0co`0043?o00030000oooooooo07_oool006coool00ol0VOoo
ooooo`0Poooo00<0000co`0co`0043?o00030000oooooooo07_oool006coool00ol0VOooooooo`0P
oooo0P00010co`000`000?ooooooo`1loooo001/oooo00?o09Woooooool08?ooo`030000<ol0<ol0
00lco`000`000?ooooooo`1loooo001/oooo00?o09Woooooool08?ooo`030000<ol0<ol000lco`00
0`000?ooooooo`1loooo001/oooo00?o09Woooooool08?ooo`030000<ol0<ol000lco`000`000?oo
ooooo`1loooo001/oooo00?o09Woooooool08?ooo`030000<ol0<ol000lco`000`000?ooooooo`1l
oooo001/oooo00?o09Woooooool08?ooo`030000<ol0<ol000hco`000`000?ooooooo`1moooo001/
oooo00?o09Woooooool08?ooo`80000?<ol000<0003oooooool0OOooo`00K?ooo`03o`2Ioooooooo
023oool00`0003?o03?o000><ol000<0003oooooool0OOooo`00K?ooo`03o`2Ioooooooo023oool0
0`0003?o03?o000><ol000<0003oooooool0OOooo`00K?ooo`03o`2Ioooooooo023oool00`0003?o
03?o000=<ol000<0003oooooool0O_ooo`00K?ooo`03o`2Ioooooooo01Soool400001?ooo`030000
<ol0<ol000dco`000`000?ooooooo`1noooo001/oooo00?o09Woooooool06?ooo`030000oooooooo
00Goool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00K?ooo`03o`2Ioooooooo01Woool0
0`000?ooooooo`04oooo0`0000dco`000`000?ooooooo`1noooo001/oooo00?o09Woooooool06_oo
o`030000oooooooo00?oool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00K?ooo`03o`2I
oooooooo01Soool010000?ooooooo`0000Coool00`0003?o03?o000<<ol000<0003oooooool0Oooo
o`00K?ooo`03o`2Ioooooooo01Woool200001Oooo`030000<ol0<ol000`co`000`000?ooooooo`1o
oooo001/oooo00?o09Woooooool08?ooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001/
oooo00?o09Woooooool08?ooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001/oooo00?o
09Woooooool08?ooo`80000=<ol000<0003oooooool0Ooooo`00K?ooo`03o`2Ioooooooo023oool0
0`0003?o03?o000<<ol000<0003oooooool0Ooooo`00K?ooo`03o`2Ioooooooo023oool00`0003?o
03?o000;<ol000<0003oooooool0P?ooo`00K?ooo`03o`2Ioooooooo023oool00`0003?o03?o000;
<ol000<0003oooooool0P?ooo`00K?ooo`03o`2Ioooooooo023oool00`0003?o03?o000;<ol000<0
003oooooool0P?ooo`00K?ooo`03o`2Ioooooooo023oool00`0003?o03?o000;<ol000<0003ooooo
ool0P?ooo`00K?ooo`03o`2Ioooooooo023oool00`0003?o03?o000;<ol000<0003oooooool0P?oo
o`00K?ooo`03o`2Ioooooooo023oool2000033?o00030000oooooooo083oool006coool00ol0VOoo
ooooo`0Poooo00<0000co`0co`002c?o00030000oooooooo083oool006coool00ol0VOooooooo`0P
oooo00<0000co`0co`002S?o00030000oooooooo087oool006coool00ol0VOooooooo`0Poooo00<0
000co`0co`002S?o00030000oooooooo087oool006coool00ol0VOooooooo`0Poooo00<0000co`0c
o`002S?o00030000oooooooo087oool006coool00ol0VOooooooo`0Poooo00<0000co`0co`002S?o
00030000oooooooo087oool006coool00ol0VOooooooo`0Poooo0P0000/co`000`000?ooooooo`21
oooo001/oooo00?o09Woooooool08?ooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001/
oooo00?o09Woooooool08?ooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001/oooo00?o
09Woooooool08?ooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001/oooo00?o09Wooooo
ool08?ooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001/oooo00?o09Woooooool08?oo
o`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001/oooo00?o09Woooooool08?ooo`80000:
<ol000<0003oooooool0P_ooo`00K?ooo`03o`2Ioooooooo023oool00`0003?o03?o0009<ol000<0
003oooooool0P_ooo`00K?ooo`03o`2Ioooooooo023oool00`0003?o03?o0009<ol000<0003ooooo
ool0P_ooo`00K?ooo`03o`2Ioooooooo023oool00`0003?o03?o0008<ol000<0003oooooool0Pooo
o`00K?ooo`03o`2Ioooooooo01Woool200001Oooo`030000<ol0<ol000Pco`000`000?ooooooo`23
oooo001/oooo00?o09Woooooool06?ooo`040000oooooooo00001?ooo`030000<ol0<ol000Pco`00
0`000?ooooooo`23oooo001/oooo00?o09Woooooool06_ooo`030000oooooooo00?oool3000023?o
00030000oooooooo08?oool006coool00ol0VOooooooo`0Koooo00<0003oooooool00_ooo`030000
<ol0<ol000Pco`000`000?ooooooo`23oooo001/oooo00?o09Woooooool06?ooo`040000oooooooo
00001?ooo`030000<ol0<ol000Pco`000`000?ooooooo`23oooo001/oooo00?o09Woooooool06Ooo
o`800005oooo00<0000co`0co`001c?o00030000oooooooo08Coool006coool00ol0VOooooooo`0P
oooo00<0000co`0co`001c?o00030000oooooooo08Coool006coool00ol0VOooooooo`0Poooo00<0
000co`0co`001c?o00030000oooooooo08Coool006coool00ol0VOooooooo`0Poooo00<0000co`0c
o`001c?o00030000oooooooo08Coool006coool00ol0VOooooooo`0Poooo0P0000Pco`000`000?oo
ooooo`24oooo001/oooo00?o09Woooooool08?ooo`030000<ol0<ol000Lco`000`000?ooooooo`24
oooo001/oooo00?o09Woooooool08?ooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001/
oooo00?o09Woooooool08?ooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001/oooo00?o
09Woooooool08?ooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001/oooo00?o09Wooooo
ool08?ooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001/oooo00?o09Woooooool08?oo
o`800007<ol000<0003oooooool0QOooo`00K?ooo`03o`2Ioooooooo023oool00`0003?o03?o0006
<ol000<0003oooooool0QOooo`00K?ooo`03o`2Ioooooooo023oool00`0003?o03?o0006<ol000<0
003oooooool0QOooo`00K?ooo`03o`2Ioooooooo023oool00`0003?o03?o0006<ol000<0003ooooo
ool0QOooo`00K?ooo`03o`2Ioooooooo023oool00`0003?o03?o0006<ol000<0003oooooool0QOoo
o`00K?ooo`03o`2Ioooooooo023oool00`0003?o03?o0006<ol000<0003oooooool0QOooo`00K?oo
o`03o`2Ioooooooo023oool200001S?o00030000oooooooo08Koool006coool00ol0VOooooooo`0P
oooo00<0000co`0co`001C?o00030000oooooooo08Koool006coool00ol0VOooooooo`0Poooo00<0
000co`0co`001C?o00030000oooooooo08Koool006coool00ol0VOooooooo`0Poooo00<0000co`0c
o`001C?o00030000oooooooo08Koool006coool00ol0VOooooooo`0Poooo00<0000co`0co`001C?o
00030000oooooooo08Koool006coool00ol0VOooooooo`0Poooo00<0000co`0co`001C?o00030000
oooooooo08Koool006coool00ol0VOooooooo`0Poooo0P0000Hco`000`000?ooooooo`26oooo001/
oooo00?o09Woooooool08?ooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001/oooo00?o
09Woooooool08?ooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001/oooo00?o09Wooooo
ool08?ooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001/oooo00?o09Woooooool08?oo
o`030000<ol0<ol000@co`000`000?ooooooo`27oooo001/oooo00?o09Woooooool06_ooo`<00003
oooo00<0000co`0co`0013?o00030000oooooooo08Ooool006coool00ol0VOooooooo`0Koooo00<0
003oooooool00_ooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001/oooo00?o09Wooooo
ool06?ooo`D00003oooo0`0000@co`000`000?ooooooo`27oooo0027oooo00@0003oooooool00004
oooo1c?o08[oool008Soool00`000?ooo`000004oooo1c?o08[oool008Woool200001?ooo`Lco`2:
oooo002?oooo1c?o08[oool008ooool7<ol0R_ooo`00NOooo`030000oooooooo01?oool7<ol03_oo
o`030000oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool02Oooo`Lco`0?
oooo00<0003oooooool0N?ooo`00N?ooo`030000oooooooo00;oool200001?ooo`030000oooooooo
00Ooool2000013?o008000000c?o0?ooooooo`02oooo0`000003oooo0000000000800003oooo00<0
003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0
003oooooool01Oooo`040000oooooooo00001S?o00Goool010000?ooooooo`0000Koool00`000?oo
ooooo`1hoooo001goooo00<0003oooooool00_ooo`030000oooooooo00goool010000?ooooooo`00
00Hco`02oooo1@0000;oool00`000?ooooooo`04oooo00<0003oooooool0Moooo`00N?ooo`030000
oooooooo00D0000<oooo00@0003oooooool00006<ol00_ooo`040000oooooooo00001?ooo`030000
oooooooo00;oool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000003oooo`040000
oooooooo00001S?o00?oool00`000?ooo`000002oooo00@0003oooooool00003oooo00<0003ooooo
ool0N?ooo`00NOooo`030000oooooooo017oool200001c?o00Coool200000oooo`800003oooo00<0
003oooooool0NOooo`00Soooo`Lco`2:oooo002?oooo1c?o08[oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.44) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.32392 .12361 L
.34309 .12361 L
.35271 .12361 L
.36173 .12361 L
.36405 .12361 L
.3652 .12361 L
.36626 .12361 L
s
.36626 .12361 m
.36675 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.44) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`09oooo00<0003ooooo
ool02Oooo`030000oooooooo00Woool00`000?ooool0V@09oooo00<0003oooooool02Oooo`030000
oooooooo00Woool00`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Tco`00
0`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Hco`0R00001_ooo`030000
oooooooo00Woool00`000?ooooooo`0Eoooo000Foooo00<0003oooooool0>_ooo`030000oooooooo
01Ooool00ol0VOooooooo`0Ooooo00<0000co`0co`00>C?o00T0000doooo00<0003oooooool05Ooo
o`00KOooo`03o`2Ioooooooo01ooool00`0003?o03?o000c<ol01P0005Goool006goool00ol0VOoo
ooooo`0Ooooo00<0000co`0co`00<C?o0080001Koooo001]oooo00?o09Woooooool07oooo`030000
<ol0<ol002lco`020000GOooo`00KOooo`03o`2Ioooooooo01ooool00`0003?o03?o000/<ol00`00
05ooool006goool00ol0VOooooooo`0Ooooo0P0002Xco`030000H_ooo`00KOooo`03o`2Ioooooooo
01ooool00`0003?o03?o000W<ol00P0006Goool006goool00ol0VOooooooo`0Ooooo00<0000co`0c
o`009S?o00030000oooooooo06Goool006goool00ol0VOooooooo`0Ooooo00<0000co`0co`009C?o
00030000oooooooo06Koool006goool00ol0VOooooooo`0Ooooo00<0000co`0co`0093?o00030000
oooooooo06Ooool006goool00ol0VOooooooo`0Ooooo00<0000co`0co`008S?o0080001Zoooo001]
oooo00?o09Woooooool07oooo`80000R<ol000<0003oooooool0J_ooo`00KOooo`03o`2Ioooooooo
01ooool00`0003?o03?o000P<ol000<0003oooooool0Joooo`00KOooo`03o`2Ioooooooo01ooool0
0`0003?o03?o000O<ol000<0003oooooool0K?ooo`00KOooo`03o`2Ioooooooo01ooool00`0003?o
03?o000O<ol000<0003oooooool0K?ooo`00KOooo`03o`2Ioooooooo01ooool00`0003?o03?o000N
<ol000<0003oooooool0KOooo`00KOooo`03o`2Ioooooooo01ooool00`0003?o03?o000M<ol000<0
003oooooool0K_ooo`00KOooo`03o`2Ioooooooo01ooool200007C?o00030000oooooooo06ooool0
06goool00ol0VOooooooo`0Ooooo00<0000co`0co`006c?o00030000oooooooo073oool006goool0
0ol0VOooooooo`0Ooooo00<0000co`0co`006c?o00030000oooooooo073oool006goool00ol0VOoo
ooooo`0Ooooo00<0000co`0co`006S?o00030000oooooooo077oool006goool00ol0VOooooooo`0O
oooo00<0000co`0co`006S?o00030000oooooooo077oool006goool00ol0VOooooooo`0Ooooo00<0
000co`0co`006C?o00030000oooooooo07;oool006goool00ol0VOooooooo`0Ooooo0P0001Xco`00
0`000?ooooooo`1boooo001]oooo00?o09Woooooool07oooo`030000<ol0<ol001Pco`000`000?oo
ooooo`1coooo001]oooo00?o09Woooooool07oooo`030000<ol0<ol001Pco`000`000?ooooooo`1c
oooo001]oooo00?o09Woooooool07oooo`030000<ol0<ol001Lco`000`000?ooooooo`1doooo001]
oooo00?o09Woooooool07oooo`030000<ol0<ol001Lco`000`000?ooooooo`1doooo001]oooo00?o
09Woooooool05oooo`D00003oooo00<0000co`0co`005S?o00030000oooooooo07Goool006goool0
0ol0VOooooooo`0Ioooo00<0003oooooool00oooo`030000<ol0<ol001Hco`000`000?ooooooo`1e
oooo001]oooo00?o09Woooooool06Oooo`030000oooooooo00?oool300005C?o00030000oooooooo
07Koool006goool00ol0VOooooooo`0Ioooo00<0003oooooool00oooo`030000<ol0<ol001Dco`00
0`000?ooooooo`1foooo001]oooo00?o09Woooooool06Oooo`030000oooooooo00?oool00`0003?o
03?o000E<ol000<0003oooooool0M_ooo`00KOooo`03o`2Ioooooooo01Soool200001Oooo`030000
<ol0<ol001@co`000`000?ooooooo`1goooo001]oooo00?o09Woooooool07oooo`030000<ol0<ol0
01@co`000`000?ooooooo`1goooo001]oooo00?o09Woooooool07oooo`030000<ol0<ol001<co`00
0`000?ooooooo`1hoooo001]oooo00?o09Woooooool07oooo`80000D<ol000<0003oooooool0N?oo
o`00KOooo`03o`2Ioooooooo01ooool00`0003?o03?o000C<ol000<0003oooooool0N?ooo`00KOoo
o`03o`2Ioooooooo01ooool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00KOooo`03o`2I
oooooooo01ooool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00KOooo`03o`2Ioooooooo
01ooool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00KOooo`03o`2Ioooooooo01ooool0
0`0003?o03?o000A<ol000<0003oooooool0N_ooo`00KOooo`03o`2Ioooooooo01ooool200004S?o
00030000oooooooo07[oool006goool00ol0VOooooooo`0Ooooo00<0000co`0co`004C?o00030000
oooooooo07[oool006goool00ol0VOooooooo`0Ooooo00<0000co`0co`004C?o00030000oooooooo
07[oool006goool00ol0VOooooooo`0Ooooo00<0000co`0co`0043?o00030000oooooooo07_oool0
06goool00ol0VOooooooo`0Ooooo00<0000co`0co`0043?o00030000oooooooo07_oool006goool0
0ol0VOooooooo`0Ooooo00<0000co`0co`0043?o00030000oooooooo07_oool006goool00ol0VOoo
ooooo`0Ooooo00<0000co`0co`0043?o00030000oooooooo07_oool006goool00ol0VOooooooo`0O
oooo0P00010co`000`000?ooooooo`1loooo001]oooo00?o09Woooooool07oooo`030000<ol0<ol0
00lco`000`000?ooooooo`1loooo001]oooo00?o09Woooooool07oooo`030000<ol0<ol000lco`00
0`000?ooooooo`1loooo001]oooo00?o09Woooooool07oooo`030000<ol0<ol000lco`000`000?oo
ooooo`1loooo001]oooo00?o09Woooooool07oooo`030000<ol0<ol000lco`000`000?ooooooo`1l
oooo001]oooo00?o09Woooooool07oooo`030000<ol0<ol000hco`000`000?ooooooo`1moooo001]
oooo00?o09Woooooool07oooo`80000?<ol000<0003oooooool0OOooo`00KOooo`03o`2Ioooooooo
01ooool00`0003?o03?o000><ol000<0003oooooool0OOooo`00KOooo`03o`2Ioooooooo01ooool0
0`0003?o03?o000><ol000<0003oooooool0OOooo`00KOooo`03o`2Ioooooooo01ooool00`0003?o
03?o000=<ol000<0003oooooool0O_ooo`00KOooo`03o`2Ioooooooo01Ooool400001?ooo`030000
<ol0<ol000dco`000`000?ooooooo`1noooo001]oooo00?o09Woooooool05oooo`030000oooooooo
00Goool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00KOooo`03o`2Ioooooooo01Soool0
0`000?ooooooo`04oooo0`0000dco`000`000?ooooooo`1noooo001]oooo00?o09Woooooool06Ooo
o`030000oooooooo00?oool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00KOooo`03o`2I
oooooooo01Ooool010000?ooooooo`0000Coool00`0003?o03?o000<<ol000<0003oooooool0Oooo
o`00KOooo`03o`2Ioooooooo01Soool200001Oooo`030000<ol0<ol000`co`000`000?ooooooo`1o
oooo001]oooo00?o09Woooooool07oooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001]
oooo00?o09Woooooool07oooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001]oooo00?o
09Woooooool07oooo`80000=<ol000<0003oooooool0Ooooo`00KOooo`03o`2Ioooooooo01ooool0
0`0003?o03?o000<<ol000<0003oooooool0Ooooo`00KOooo`03o`2Ioooooooo01ooool00`0003?o
03?o000;<ol000<0003oooooool0P?ooo`00KOooo`03o`2Ioooooooo01ooool00`0003?o03?o000;
<ol000<0003oooooool0P?ooo`00KOooo`03o`2Ioooooooo01ooool00`0003?o03?o000;<ol000<0
003oooooool0P?ooo`00KOooo`03o`2Ioooooooo01ooool00`0003?o03?o000;<ol000<0003ooooo
ool0P?ooo`00KOooo`03o`2Ioooooooo01ooool00`0003?o03?o000;<ol000<0003oooooool0P?oo
o`00KOooo`03o`2Ioooooooo01ooool2000033?o00030000oooooooo083oool006goool00ol0VOoo
ooooo`0Ooooo00<0000co`0co`002c?o00030000oooooooo083oool006goool00ol0VOooooooo`0O
oooo00<0000co`0co`002S?o00030000oooooooo087oool006goool00ol0VOooooooo`0Ooooo00<0
000co`0co`002S?o00030000oooooooo087oool006goool00ol0VOooooooo`0Ooooo00<0000co`0c
o`002S?o00030000oooooooo087oool006goool00ol0VOooooooo`0Ooooo00<0000co`0co`002S?o
00030000oooooooo087oool006goool00ol0VOooooooo`0Ooooo0P0000/co`000`000?ooooooo`21
oooo001]oooo00?o09Woooooool07oooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001]
oooo00?o09Woooooool07oooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001]oooo00?o
09Woooooool07oooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001]oooo00?o09Wooooo
ool07oooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001]oooo00?o09Woooooool07ooo
o`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001]oooo00?o09Woooooool07oooo`80000:
<ol000<0003oooooool0P_ooo`00KOooo`03o`2Ioooooooo01ooool00`0003?o03?o0009<ol000<0
003oooooool0P_ooo`00KOooo`03o`2Ioooooooo01ooool00`0003?o03?o0009<ol000<0003ooooo
ool0P_ooo`00KOooo`03o`2Ioooooooo01ooool00`0003?o03?o0008<ol000<0003oooooool0Pooo
o`00KOooo`03o`2Ioooooooo01Soool200001Oooo`030000<ol0<ol000Pco`000`000?ooooooo`23
oooo001]oooo00?o09Woooooool05oooo`040000oooooooo00001?ooo`030000<ol0<ol000Pco`00
0`000?ooooooo`23oooo001]oooo00?o09Woooooool06Oooo`030000oooooooo00?oool3000023?o
00030000oooooooo08?oool006goool00ol0VOooooooo`0Joooo00<0003oooooool00_ooo`030000
<ol0<ol000Pco`000`000?ooooooo`23oooo001]oooo00?o09Woooooool05oooo`040000oooooooo
00001?ooo`030000<ol0<ol000Pco`000`000?ooooooo`23oooo001]oooo00?o09Woooooool06?oo
o`800005oooo00<0000co`0co`001c?o00030000oooooooo08Coool006goool00ol0VOooooooo`0O
oooo00<0000co`0co`001c?o00030000oooooooo08Coool006goool00ol0VOooooooo`0Ooooo00<0
000co`0co`001c?o00030000oooooooo08Coool006goool00ol0VOooooooo`0Ooooo00<0000co`0c
o`001c?o00030000oooooooo08Coool006goool00ol0VOooooooo`0Ooooo0P0000Pco`000`000?oo
ooooo`24oooo001]oooo00?o09Woooooool07oooo`030000<ol0<ol000Lco`000`000?ooooooo`24
oooo001]oooo00?o09Woooooool07oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001]
oooo00?o09Woooooool07oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001]oooo00?o
09Woooooool07oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001]oooo00?o09Wooooo
ool07oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001]oooo00?o09Woooooool07ooo
o`800007<ol000<0003oooooool0QOooo`00KOooo`03o`2Ioooooooo01ooool00`0003?o03?o0006
<ol000<0003oooooool0QOooo`00KOooo`03o`2Ioooooooo01ooool00`0003?o03?o0006<ol000<0
003oooooool0QOooo`00KOooo`03o`2Ioooooooo01ooool00`0003?o03?o0006<ol000<0003ooooo
ool0QOooo`00KOooo`03o`2Ioooooooo01ooool00`0003?o03?o0006<ol000<0003oooooool0QOoo
o`00KOooo`03o`2Ioooooooo01ooool00`0003?o03?o0006<ol000<0003oooooool0QOooo`00KOoo
o`03o`2Ioooooooo01ooool200001S?o00030000oooooooo08Koool006goool00ol0VOooooooo`0O
oooo00<0000co`0co`001C?o00030000oooooooo08Koool006goool00ol0VOooooooo`0Ooooo00<0
000co`0co`001C?o00030000oooooooo08Koool006goool00ol0VOooooooo`0Ooooo00<0000co`0c
o`001C?o00030000oooooooo08Koool006goool00ol0VOooooooo`0Ooooo00<0000co`0co`001C?o
00030000oooooooo08Koool006goool00ol0VOooooooo`0Ooooo00<0000co`0co`001C?o00030000
oooooooo08Koool006goool00ol0VOooooooo`0Ooooo0P0000Hco`000`000?ooooooo`26oooo001]
oooo00?o09Woooooool07oooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001]oooo00?o
09Woooooool07oooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001]oooo00?o09Wooooo
ool07oooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001]oooo00?o09Woooooool07ooo
o`030000<ol0<ol000@co`000`000?ooooooo`27oooo001]oooo00?o09Woooooool06Oooo`<00003
oooo00<0000co`0co`0013?o00030000oooooooo08Ooool006goool00ol0VOooooooo`0Joooo00<0
003oooooool00_ooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001]oooo00?o09Wooooo
ool05oooo`D00003oooo0`0000@co`000`000?ooooooo`27oooo0027oooo00@0003oooooool00004
oooo1c?o08[oool008Soool00`000?ooo`000004oooo1c?o08[oool008Woool200001?ooo`Lco`2:
oooo002?oooo1c?o08[oool008ooool7<ol0R_ooo`00NOooo`030000oooooooo01?oool7<ol03_oo
o`030000oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool02Oooo`Lco`0?
oooo00<0003oooooool0N?ooo`00N?ooo`030000oooooooo00;oool200001?ooo`030000oooooooo
00Ooool2000013?o008000000c?o0?ooooooo`02oooo0`0000?oool300000_ooo`030000oooooooo
07Soool007Soool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
00Goool010000?ooooooo`0000Hco`05oooo00<0003oooooool00oooo`050000oooooooooooo0000
07[oool007Ooool00`000?ooooooo`02oooo00<0003oooooool03Oooo`040000oooooooo00001S?o
00;oool5000000?oool0000000000`0000?oool00`000?ooooooo`1goooo001hoooo00<0003ooooo
ool01@0000coool010000?ooooooo`0000Hco`02oooo00@0003oooooool00002oooo00@0003ooooo
ool00003oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000ooool010000?oo
ooooo`0000Hco`03oooo00<0003oool000000oooo`030000oooo000000?oool00`000?ooooooo`1h
oooo001ioooo00<0003oooooool04Oooo`800007<ol01?ooo`800004oooo0P0000;oool00`000?oo
ooooo`1ioooo002?oooo1c?o08[oool008ooool7<ol0R_ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.46) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.32392 .12361 L
.34309 .12361 L
.36173 .12361 L
.36626 .12361 L
.36876 .12361 L
.36999 .12361 L
.37114 .12361 L
s
.37114 .12361 m
.3714 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.46) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`09oooo00<0003ooooo
ool02Oooo`030000oooooooo00Woool010000?ooooooool0V@Soool00`000?ooooooo`09oooo00<0
003oooooool02Oooo`030000<ol0<ol000Tco`000`0003?o03?o0009<ol000<0000co`0co`002C?o
00030000<ol0<ol000Tco`000`0003?o03?o0009<ol000<0000co`0co`001S?o02800006oooo00<0
003oooooool02Oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0joooo00<0003ooooo
ool06?ooo`03o`2Ioooooooo01koool00`0003?o03?o000i<ol02@0003Coool00`000?ooooooo`0E
oooo001^oooo00?o09Woooooool07_ooo`030000<ol0<ol003<co`060000EOooo`00K_ooo`03o`2I
oooooooo01koool00`0003?o03?o000a<ol00P0005_oool006koool00ol0VOooooooo`0Noooo00<0
000co`0co`00;c?o0080001Moooo001^oooo00?o09Woooooool07_ooo`030000<ol0<ol002`co`03
0000Goooo`00K_ooo`03o`2Ioooooooo01koool20000:S?o00<0001Roooo001^oooo00?o09Wooooo
ool07_ooo`030000<ol0<ol002Lco`020000IOooo`00K_ooo`03o`2Ioooooooo01koool00`0003?o
03?o000V<ol000<0003oooooool0IOooo`00K_ooo`03o`2Ioooooooo01koool00`0003?o03?o000U
<ol000<0003oooooool0I_ooo`00K_ooo`03o`2Ioooooooo01koool00`0003?o03?o000T<ol000<0
003oooooool0Ioooo`00K_ooo`03o`2Ioooooooo01koool00`0003?o03?o000R<ol00P0006[oool0
06koool00ol0VOooooooo`0Noooo0P00028co`000`000?ooooooo`1Zoooo001^oooo00?o09Wooooo
ool07_ooo`030000<ol0<ol0020co`000`000?ooooooo`1[oooo001^oooo00?o09Woooooool07_oo
o`030000<ol0<ol001lco`000`000?ooooooo`1/oooo001^oooo00?o09Woooooool07_ooo`030000
<ol0<ol001lco`000`000?ooooooo`1/oooo001^oooo00?o09Woooooool07_ooo`030000<ol0<ol0
01hco`000`000?ooooooo`1]oooo001^oooo00?o09Woooooool07_ooo`030000<ol0<ol001dco`00
0`000?ooooooo`1^oooo001^oooo00?o09Woooooool07_ooo`80000M<ol000<0003oooooool0Kooo
o`00K_ooo`03o`2Ioooooooo01koool00`0003?o03?o000K<ol000<0003oooooool0L?ooo`00K_oo
o`03o`2Ioooooooo01koool00`0003?o03?o000K<ol000<0003oooooool0L?ooo`00K_ooo`03o`2I
oooooooo01koool00`0003?o03?o000J<ol000<0003oooooool0LOooo`00K_ooo`03o`2Ioooooooo
01koool00`0003?o03?o000J<ol000<0003oooooool0LOooo`00K_ooo`03o`2Ioooooooo01koool0
0`0003?o03?o000I<ol000<0003oooooool0L_ooo`00K_ooo`03o`2Ioooooooo01koool200006S?o
00030000oooooooo07;oool006koool00ol0VOooooooo`0Noooo00<0000co`0co`0063?o00030000
oooooooo07?oool006koool00ol0VOooooooo`0Noooo00<0000co`0co`0063?o00030000oooooooo
07?oool006koool00ol0VOooooooo`0Noooo00<0000co`0co`005c?o00030000oooooooo07Coool0
06koool00ol0VOooooooo`0Noooo00<0000co`0co`005c?o00030000oooooooo07Coool006koool0
0ol0VOooooooo`0Foooo1@0000?oool00`0003?o03?o000F<ol000<0003oooooool0MOooo`00K_oo
o`03o`2Ioooooooo01Soool00`000?ooooooo`03oooo00<0000co`0co`005S?o00030000oooooooo
07Goool006koool00ol0VOooooooo`0Hoooo00<0003oooooool00oooo`<0000E<ol000<0003ooooo
ool0M_ooo`00K_ooo`03o`2Ioooooooo01Soool00`000?ooooooo`03oooo00<0000co`0co`005C?o
00030000oooooooo07Koool006koool00ol0VOooooooo`0Hoooo00<0003oooooool00oooo`030000
<ol0<ol001Dco`000`000?ooooooo`1foooo001^oooo00?o09Woooooool05oooo`800005oooo00<0
000co`0co`0053?o00030000oooooooo07Ooool006koool00ol0VOooooooo`0Noooo00<0000co`0c
o`0053?o00030000oooooooo07Ooool006koool00ol0VOooooooo`0Noooo00<0000co`0co`004c?o
00030000oooooooo07Soool006koool00ol0VOooooooo`0Noooo0P0001@co`000`000?ooooooo`1h
oooo001^oooo00?o09Woooooool07_ooo`030000<ol0<ol001<co`000`000?ooooooo`1hoooo001^
oooo00?o09Woooooool07_ooo`030000<ol0<ol0018co`000`000?ooooooo`1ioooo001^oooo00?o
09Woooooool07_ooo`030000<ol0<ol0018co`000`000?ooooooo`1ioooo001^oooo00?o09Wooooo
ool07_ooo`030000<ol0<ol0018co`000`000?ooooooo`1ioooo001^oooo00?o09Woooooool07_oo
o`030000<ol0<ol0014co`000`000?ooooooo`1joooo001^oooo00?o09Woooooool07_ooo`80000B
<ol000<0003oooooool0N_ooo`00K_ooo`03o`2Ioooooooo01koool00`0003?o03?o000A<ol000<0
003oooooool0N_ooo`00K_ooo`03o`2Ioooooooo01koool00`0003?o03?o000A<ol000<0003ooooo
ool0N_ooo`00K_ooo`03o`2Ioooooooo01koool00`0003?o03?o000@<ol000<0003oooooool0Nooo
o`00K_ooo`03o`2Ioooooooo01koool00`0003?o03?o000@<ol000<0003oooooool0Noooo`00K_oo
o`03o`2Ioooooooo01koool00`0003?o03?o000@<ol000<0003oooooool0Noooo`00K_ooo`03o`2I
oooooooo01koool00`0003?o03?o000@<ol000<0003oooooool0Noooo`00K_ooo`03o`2Ioooooooo
01koool2000043?o00030000oooooooo07coool006koool00ol0VOooooooo`0Noooo00<0000co`0c
o`003c?o00030000oooooooo07coool006koool00ol0VOooooooo`0Noooo00<0000co`0co`003c?o
00030000oooooooo07coool006koool00ol0VOooooooo`0Noooo00<0000co`0co`003c?o00030000
oooooooo07coool006koool00ol0VOooooooo`0Noooo00<0000co`0co`003c?o00030000oooooooo
07coool006koool00ol0VOooooooo`0Noooo00<0000co`0co`003S?o00030000oooooooo07goool0
06koool00ol0VOooooooo`0Noooo0P0000lco`000`000?ooooooo`1moooo001^oooo00?o09Wooooo
ool07_ooo`030000<ol0<ol000hco`000`000?ooooooo`1moooo001^oooo00?o09Woooooool07_oo
o`030000<ol0<ol000hco`000`000?ooooooo`1moooo001^oooo00?o09Woooooool07_ooo`030000
<ol0<ol000dco`000`000?ooooooo`1noooo001^oooo00?o09Woooooool05_ooo`@00004oooo00<0
000co`0co`003C?o00030000oooooooo07koool006koool00ol0VOooooooo`0Foooo00<0003ooooo
ool01Oooo`030000<ol0<ol000dco`000`000?ooooooo`1noooo001^oooo00?o09Woooooool05ooo
o`030000oooooooo00Coool300003C?o00030000oooooooo07koool006koool00ol0VOooooooo`0H
oooo00<0003oooooool00oooo`030000<ol0<ol000dco`000`000?ooooooo`1noooo001^oooo00?o
09Woooooool05_ooo`040000oooooooo00001?ooo`030000<ol0<ol000`co`000`000?ooooooo`1o
oooo001^oooo00?o09Woooooool05oooo`800005oooo00<0000co`0co`0033?o00030000oooooooo
07ooool006koool00ol0VOooooooo`0Noooo00<0000co`0co`0033?o00030000oooooooo07ooool0
06koool00ol0VOooooooo`0Noooo00<0000co`0co`0033?o00030000oooooooo07ooool006koool0
0ol0VOooooooo`0Noooo0P0000dco`000`000?ooooooo`1ooooo001^oooo00?o09Woooooool07_oo
o`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001^oooo00?o09Woooooool07_ooo`030000
<ol0<ol000/co`000`000?ooooooo`20oooo001^oooo00?o09Woooooool07_ooo`030000<ol0<ol0
00/co`000`000?ooooooo`20oooo001^oooo00?o09Woooooool07_ooo`030000<ol0<ol000/co`00
0`000?ooooooo`20oooo001^oooo00?o09Woooooool07_ooo`030000<ol0<ol000/co`000`000?oo
ooooo`20oooo001^oooo00?o09Woooooool07_ooo`030000<ol0<ol000/co`000`000?ooooooo`20
oooo001^oooo00?o09Woooooool07_ooo`80000<<ol000<0003oooooool0P?ooo`00K_ooo`03o`2I
oooooooo01koool00`0003?o03?o000;<ol000<0003oooooool0P?ooo`00K_ooo`03o`2Ioooooooo
01koool00`0003?o03?o000:<ol000<0003oooooool0POooo`00K_ooo`03o`2Ioooooooo01koool0
0`0003?o03?o000:<ol000<0003oooooool0POooo`00K_ooo`03o`2Ioooooooo01koool00`0003?o
03?o000:<ol000<0003oooooool0POooo`00K_ooo`03o`2Ioooooooo01koool00`0003?o03?o000:
<ol000<0003oooooool0POooo`00K_ooo`03o`2Ioooooooo01koool200002c?o00030000oooooooo
087oool006koool00ol0VOooooooo`0Noooo00<0000co`0co`002S?o00030000oooooooo087oool0
06koool00ol0VOooooooo`0Noooo00<0000co`0co`002S?o00030000oooooooo087oool006koool0
0ol0VOooooooo`0Noooo00<0000co`0co`002C?o00030000oooooooo08;oool006koool00ol0VOoo
ooooo`0Noooo00<0000co`0co`002C?o00030000oooooooo08;oool006koool00ol0VOooooooo`0N
oooo00<0000co`0co`002C?o00030000oooooooo08;oool006koool00ol0VOooooooo`0Noooo0P00
00Xco`000`000?ooooooo`22oooo001^oooo00?o09Woooooool07_ooo`030000<ol0<ol000Tco`00
0`000?ooooooo`22oooo001^oooo00?o09Woooooool07_ooo`030000<ol0<ol000Tco`000`000?oo
ooooo`22oooo001^oooo00?o09Woooooool07_ooo`030000<ol0<ol000Pco`000`000?ooooooo`23
oooo001^oooo00?o09Woooooool05oooo`800005oooo00<0000co`0co`0023?o00030000oooooooo
08?oool006koool00ol0VOooooooo`0Foooo00@0003oooooool00004oooo00<0000co`0co`0023?o
00030000oooooooo08?oool006koool00ol0VOooooooo`0Hoooo00<0003oooooool00oooo`<00008
<ol000<0003oooooool0Poooo`00K_ooo`03o`2Ioooooooo01Woool00`000?ooooooo`02oooo00<0
000co`0co`0023?o00030000oooooooo08?oool006koool00ol0VOooooooo`0Foooo00@0003ooooo
ool00004oooo00<0000co`0co`0023?o00030000oooooooo08?oool006koool00ol0VOooooooo`0G
oooo0P0000Goool00`0003?o03?o0007<ol000<0003oooooool0Q?ooo`00K_ooo`03o`2Ioooooooo
01koool00`0003?o03?o0007<ol000<0003oooooool0Q?ooo`00K_ooo`03o`2Ioooooooo01koool0
0`0003?o03?o0007<ol000<0003oooooool0Q?ooo`00K_ooo`03o`2Ioooooooo01koool00`0003?o
03?o0007<ol000<0003oooooool0Q?ooo`00K_ooo`03o`2Ioooooooo01koool2000023?o00030000
oooooooo08Coool006koool00ol0VOooooooo`0Noooo00<0000co`0co`001c?o00030000oooooooo
08Coool006koool00ol0VOooooooo`0Noooo00<0000co`0co`001c?o00030000oooooooo08Coool0
06koool00ol0VOooooooo`0Noooo00<0000co`0co`001c?o00030000oooooooo08Coool006koool0
0ol0VOooooooo`0Noooo00<0000co`0co`001S?o00030000oooooooo08Goool006koool00ol0VOoo
ooooo`0Noooo00<0000co`0co`001S?o00030000oooooooo08Goool006koool00ol0VOooooooo`0N
oooo0P0000Lco`000`000?ooooooo`25oooo001^oooo00?o09Woooooool07_ooo`030000<ol0<ol0
00Hco`000`000?ooooooo`25oooo001^oooo00?o09Woooooool07_ooo`030000<ol0<ol000Hco`00
0`000?ooooooo`25oooo001^oooo00?o09Woooooool07_ooo`030000<ol0<ol000Hco`000`000?oo
ooooo`25oooo001^oooo00?o09Woooooool07_ooo`030000<ol0<ol000Hco`000`000?ooooooo`25
oooo001^oooo00?o09Woooooool07_ooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001^
oooo00?o09Woooooool07_ooo`800006<ol000<0003oooooool0Q_ooo`00K_ooo`03o`2Ioooooooo
01koool00`0003?o03?o0005<ol000<0003oooooool0Q_ooo`00K_ooo`03o`2Ioooooooo01koool0
0`0003?o03?o0005<ol000<0003oooooool0Q_ooo`00K_ooo`03o`2Ioooooooo01koool00`0003?o
03?o0005<ol000<0003oooooool0Q_ooo`00K_ooo`03o`2Ioooooooo01koool00`0003?o03?o0005
<ol000<0003oooooool0Q_ooo`00K_ooo`03o`2Ioooooooo01koool00`0003?o03?o0005<ol000<0
003oooooool0Q_ooo`00K_ooo`03o`2Ioooooooo01koool200001S?o00030000oooooooo08Koool0
06koool00ol0VOooooooo`0Noooo00<0000co`0co`001C?o00030000oooooooo08Koool006koool0
0ol0VOooooooo`0Noooo00<0000co`0co`001C?o00030000oooooooo08Koool006koool00ol0VOoo
ooooo`0Noooo00<0000co`0co`0013?o00030000oooooooo08Ooool006koool00ol0VOooooooo`0N
oooo00<0000co`0co`0013?o00030000oooooooo08Ooool006koool00ol0VOooooooo`0Hoooo0`00
00?oool00`0003?o03?o0004<ol000<0003oooooool0Qoooo`00K_ooo`03o`2Ioooooooo01Woool0
0`000?ooooooo`02oooo00<0000co`0co`0013?o00030000oooooooo08Ooool006koool00ol0VOoo
ooooo`0Foooo1@0000?oool3000013?o00030000oooooooo08Ooool008Ooool010000?ooooooo`00
00Coool7<ol0R_ooo`00R?ooo`030000oooo000000Coool7<ol0R_ooo`00ROooo`800004oooo1c?o
08[oool008ooool7<ol0R_ooo`00Soooo`Lco`2:oooo001ioooo00<0003oooooool04oooo`Lco`0>
oooo00<0003oooooool0NOooo`00N?ooo`030000oooooooo00Soool00`000?ooooooo`09oooo1c?o
00ooool00`000?ooooooo`1hoooo001hoooo00<0003oooooool00_ooo`800004oooo00<0003ooooo
ool01oooo`800004<ol00P000003<ol0oooooooo00;oool3000000Coool0000000000004oooo00<0
003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?ooooooo`02oooo00<0
003oooooool01Oooo`040000oooooooo00001S?o00Goool010000?ooooooo`0000;oool01@000?oo
ooooooooo`00001joooo001goooo00<0003oooooool00_ooo`030000oooooooo00goool010000?oo
ooooo`0000Hco`02oooo1@000005oooo0000oooooooo000000Coool00`000?ooooooo`1goooo001h
oooo00<0003oooooool01@0000coool010000?ooooooo`0000Hco`02oooo00@0003oooooool00002
oooo0`0000Coool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000003oooo`040000
oooooooo00001S?o00?oool00`000?ooo`000003oooo00<0003oooooool00oooo`030000oooooooo
07Soool007Woool00`000?ooooooo`0Aoooo0P0000Lco`04oooo0P0000?oool300000_ooo`030000
oooooooo07Woool008ooool7<ol0R_ooo`00Soooo`Lco`2:oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.48) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.32392 .12361 L
.34309 .12361 L
.36173 .12361 L
.36626 .12361 L
.37114 .12361 L
.37257 .12361 L
.37393 .12361 L
.37515 .12361 L
.37585 .12361 L
s
.37585 .12361 m
.3761 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.48) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`09oooo00<0003ooooo
ool02Oooo`030000oooooooo00Woool01@000?ooooooooooool0V@07oooo00<0003oooooool02Ooo
o`030000oooooooo00Woool00`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol0
00Tco`000`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Hco`0R00001_oo
o`030000oooooooo00Woool00`000?ooooooo`0Eoooo000Foooo00<0003oooooool0>_ooo`030000
oooooooo01Woool00ol0VOooooooo`0Moooo00<0000co`0co`00>C?o00T0000doooo00<0003ooooo
ool05Oooo`00Koooo`03o`2Ioooooooo01goool00`0003?o03?o000c<ol01P0005Goool006ooool0
0ol0VOooooooo`0Moooo00<0000co`0co`00<C?o0080001Koooo001_oooo00?o09Woooooool07Ooo
o`030000<ol0<ol002lco`020000GOooo`00Koooo`03o`2Ioooooooo01goool00`0003?o03?o000/
<ol00`0005ooool006ooool00ol0VOooooooo`0Moooo0P0002Xco`030000H_ooo`00Koooo`03o`2I
oooooooo01goool00`0003?o03?o000W<ol00P0006Goool006ooool00ol0VOooooooo`0Moooo00<0
000co`0co`009S?o00030000oooooooo06Goool006ooool00ol0VOooooooo`0Moooo00<0000co`0c
o`009C?o00030000oooooooo06Koool006ooool00ol0VOooooooo`0Moooo00<0000co`0co`0093?o
00030000oooooooo06Ooool006ooool00ol0VOooooooo`0Moooo00<0000co`0co`008S?o0080001Z
oooo001_oooo00?o09Woooooool07Oooo`80000R<ol000<0003oooooool0J_ooo`00Koooo`03o`2I
oooooooo01goool00`0003?o03?o000P<ol000<0003oooooool0Joooo`00Koooo`03o`2Ioooooooo
01goool00`0003?o03?o000O<ol000<0003oooooool0K?ooo`00Koooo`03o`2Ioooooooo01goool0
0`0003?o03?o000O<ol000<0003oooooool0K?ooo`00Koooo`03o`2Ioooooooo01goool00`0003?o
03?o000N<ol000<0003oooooool0KOooo`00Koooo`03o`2Ioooooooo01goool00`0003?o03?o000M
<ol000<0003oooooool0K_ooo`00Koooo`03o`2Ioooooooo01goool200007C?o00030000oooooooo
06ooool006ooool00ol0VOooooooo`0Moooo00<0000co`0co`006c?o00030000oooooooo073oool0
06ooool00ol0VOooooooo`0Moooo00<0000co`0co`006c?o00030000oooooooo073oool006ooool0
0ol0VOooooooo`0Moooo00<0000co`0co`006S?o00030000oooooooo077oool006ooool00ol0VOoo
ooooo`0Moooo00<0000co`0co`006S?o00030000oooooooo077oool006ooool00ol0VOooooooo`0M
oooo00<0000co`0co`006C?o00030000oooooooo07;oool006ooool00ol0VOooooooo`0Moooo0P00
01Xco`000`000?ooooooo`1boooo001_oooo00?o09Woooooool07Oooo`030000<ol0<ol001Pco`00
0`000?ooooooo`1coooo001_oooo00?o09Woooooool07Oooo`030000<ol0<ol001Pco`000`000?oo
ooooo`1coooo001_oooo00?o09Woooooool07Oooo`030000<ol0<ol001Lco`000`000?ooooooo`1d
oooo001_oooo00?o09Woooooool07Oooo`030000<ol0<ol001Lco`000`000?ooooooo`1doooo001_
oooo00?o09Woooooool05Oooo`D00003oooo00<0000co`0co`005S?o00030000oooooooo07Goool0
06ooool00ol0VOooooooo`0Goooo00<0003oooooool00oooo`030000<ol0<ol001Hco`000`000?oo
ooooo`1eoooo001_oooo00?o09Woooooool05oooo`030000oooooooo00?oool300005C?o00030000
oooooooo07Koool006ooool00ol0VOooooooo`0Goooo00<0003oooooool00oooo`030000<ol0<ol0
01Dco`000`000?ooooooo`1foooo001_oooo00?o09Woooooool05oooo`030000oooooooo00?oool0
0`0003?o03?o000E<ol000<0003oooooool0M_ooo`00Koooo`03o`2Ioooooooo01Koool200001Ooo
o`030000<ol0<ol001@co`000`000?ooooooo`1goooo001_oooo00?o09Woooooool07Oooo`030000
<ol0<ol001@co`000`000?ooooooo`1goooo001_oooo00?o09Woooooool07Oooo`030000<ol0<ol0
01<co`000`000?ooooooo`1hoooo001_oooo00?o09Woooooool07Oooo`80000D<ol000<0003ooooo
ool0N?ooo`00Koooo`03o`2Ioooooooo01goool00`0003?o03?o000C<ol000<0003oooooool0N?oo
o`00Koooo`03o`2Ioooooooo01goool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00Kooo
o`03o`2Ioooooooo01goool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00Koooo`03o`2I
oooooooo01goool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00Koooo`03o`2Ioooooooo
01goool00`0003?o03?o000A<ol000<0003oooooool0N_ooo`00Koooo`03o`2Ioooooooo01goool2
00004S?o00030000oooooooo07[oool006ooool00ol0VOooooooo`0Moooo00<0000co`0co`004C?o
00030000oooooooo07[oool006ooool00ol0VOooooooo`0Moooo00<0000co`0co`004C?o00030000
oooooooo07[oool006ooool00ol0VOooooooo`0Moooo00<0000co`0co`0043?o00030000oooooooo
07_oool006ooool00ol0VOooooooo`0Moooo00<0000co`0co`0043?o00030000oooooooo07_oool0
06ooool00ol0VOooooooo`0Moooo00<0000co`0co`0043?o00030000oooooooo07_oool006ooool0
0ol0VOooooooo`0Moooo00<0000co`0co`0043?o00030000oooooooo07_oool006ooool00ol0VOoo
ooooo`0Moooo0P00010co`000`000?ooooooo`1loooo001_oooo00?o09Woooooool07Oooo`030000
<ol0<ol000lco`000`000?ooooooo`1loooo001_oooo00?o09Woooooool07Oooo`030000<ol0<ol0
00lco`000`000?ooooooo`1loooo001_oooo00?o09Woooooool07Oooo`030000<ol0<ol000lco`00
0`000?ooooooo`1loooo001_oooo00?o09Woooooool07Oooo`030000<ol0<ol000lco`000`000?oo
ooooo`1loooo001_oooo00?o09Woooooool07Oooo`030000<ol0<ol000hco`000`000?ooooooo`1m
oooo001_oooo00?o09Woooooool07Oooo`80000?<ol000<0003oooooool0OOooo`00Koooo`03o`2I
oooooooo01goool00`0003?o03?o000><ol000<0003oooooool0OOooo`00Koooo`03o`2Ioooooooo
01goool00`0003?o03?o000><ol000<0003oooooool0OOooo`00Koooo`03o`2Ioooooooo01goool0
0`0003?o03?o000=<ol000<0003oooooool0O_ooo`00Koooo`03o`2Ioooooooo01Goool400001?oo
o`030000<ol0<ol000dco`000`000?ooooooo`1noooo001_oooo00?o09Woooooool05Oooo`030000
oooooooo00Goool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00Koooo`03o`2Ioooooooo
01Koool00`000?ooooooo`04oooo0`0000dco`000`000?ooooooo`1noooo001`oooo00?o09Wooooo
ool05_ooo`030000oooooooo00?oool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00L?oo
o`03o`2Ioooooooo01Coool010000?ooooooo`0000Coool00`0003?o03?o000<<ol000<0003ooooo
ool0Ooooo`00L?ooo`03o`2Ioooooooo01Goool200001Oooo`030000<ol0<ol000`co`000`000?oo
ooooo`1ooooo001`oooo00?o09Woooooool07?ooo`030000<ol0<ol000`co`000`000?ooooooo`1o
oooo001`oooo00?o09Woooooool07?ooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001`
oooo00?o09Woooooool07?ooo`80000=<ol000<0003oooooool0Ooooo`00L?ooo`03o`2Ioooooooo
01coool00`0003?o03?o000<<ol000<0003oooooool0Ooooo`00L?ooo`03o`2Ioooooooo01coool0
0`0003?o03?o000;<ol000<0003oooooool0P?ooo`00L?ooo`03o`2Ioooooooo01coool00`0003?o
03?o000;<ol000<0003oooooool0P?ooo`00L?ooo`03o`2Ioooooooo01coool00`0003?o03?o000;
<ol000<0003oooooool0P?ooo`00L?ooo`03o`2Ioooooooo01coool00`0003?o03?o000;<ol000<0
003oooooool0P?ooo`00L?ooo`03o`2Ioooooooo01coool00`0003?o03?o000;<ol000<0003ooooo
ool0P?ooo`00L?ooo`03o`2Ioooooooo01coool2000033?o00030000oooooooo083oool0073oool0
0ol0VOooooooo`0Loooo00<0000co`0co`002c?o00030000oooooooo083oool0073oool00ol0VOoo
ooooo`0Loooo00<0000co`0co`002S?o00030000oooooooo087oool0073oool00ol0VOooooooo`0L
oooo00<0000co`0co`002S?o00030000oooooooo087oool0073oool00ol0VOooooooo`0Loooo00<0
000co`0co`002S?o00030000oooooooo087oool0073oool00ol0VOooooooo`0Loooo00<0000co`0c
o`002S?o00030000oooooooo087oool0073oool00ol0VOooooooo`0Loooo0P0000/co`000`000?oo
ooooo`21oooo001`oooo00?o09Woooooool07?ooo`030000<ol0<ol000Xco`000`000?ooooooo`21
oooo001`oooo00?o09Woooooool07?ooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001`
oooo00?o09Woooooool07?ooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001`oooo00?o
09Woooooool07?ooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001`oooo00?o09Wooooo
ool07?ooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001`oooo00?o09Woooooool07?oo
o`80000:<ol000<0003oooooool0P_ooo`00L?ooo`03o`2Ioooooooo01coool00`0003?o03?o0009
<ol000<0003oooooool0P_ooo`00L?ooo`03o`2Ioooooooo01coool00`0003?o03?o0009<ol000<0
003oooooool0P_ooo`00L?ooo`03o`2Ioooooooo01coool00`0003?o03?o0008<ol000<0003ooooo
ool0Poooo`00L?ooo`03o`2Ioooooooo01Goool200001Oooo`030000<ol0<ol000Pco`000`000?oo
ooooo`23oooo001`oooo00?o09Woooooool05?ooo`040000oooooooo00001?ooo`030000<ol0<ol0
00Pco`000`000?ooooooo`23oooo001`oooo00?o09Woooooool05_ooo`030000oooooooo00?oool3
000023?o00030000oooooooo08?oool0073oool00ol0VOooooooo`0Goooo00<0003oooooool00_oo
o`030000<ol0<ol000Pco`000`000?ooooooo`23oooo001`oooo00?o09Woooooool05?ooo`040000
oooooooo00001?ooo`030000<ol0<ol000Pco`000`000?ooooooo`23oooo001`oooo00?o09Wooooo
ool05Oooo`800005oooo00<0000co`0co`001c?o00030000oooooooo08Coool0073oool00ol0VOoo
ooooo`0Loooo00<0000co`0co`001c?o00030000oooooooo08Coool0073oool00ol0VOooooooo`0L
oooo00<0000co`0co`001c?o00030000oooooooo08Coool0073oool00ol0VOooooooo`0Loooo00<0
000co`0co`001c?o00030000oooooooo08Coool0073oool00ol0VOooooooo`0Loooo0P0000Pco`00
0`000?ooooooo`24oooo001`oooo00?o09Woooooool07?ooo`030000<ol0<ol000Lco`000`000?oo
ooooo`24oooo001`oooo00?o09Woooooool07?ooo`030000<ol0<ol000Lco`000`000?ooooooo`24
oooo001`oooo00?o09Woooooool07?ooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001`
oooo00?o09Woooooool07?ooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001`oooo00?o
09Woooooool07?ooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001`oooo00?o09Wooooo
ool07?ooo`800007<ol000<0003oooooool0QOooo`00L?ooo`03o`2Ioooooooo01coool00`0003?o
03?o0006<ol000<0003oooooool0QOooo`00L?ooo`03o`2Ioooooooo01coool00`0003?o03?o0006
<ol000<0003oooooool0QOooo`00L?ooo`03o`2Ioooooooo01coool00`0003?o03?o0006<ol000<0
003oooooool0QOooo`00L?ooo`03o`2Ioooooooo01coool00`0003?o03?o0006<ol000<0003ooooo
ool0QOooo`00L?ooo`03o`2Ioooooooo01coool00`0003?o03?o0006<ol000<0003oooooool0QOoo
o`00L?ooo`03o`2Ioooooooo01coool200001S?o00030000oooooooo08Koool0073oool00ol0VOoo
ooooo`0Loooo00<0000co`0co`001C?o00030000oooooooo08Koool0073oool00ol0VOooooooo`0L
oooo00<0000co`0co`001C?o00030000oooooooo08Koool0073oool00ol0VOooooooo`0Loooo00<0
000co`0co`001C?o00030000oooooooo08Koool0073oool00ol0VOooooooo`0Loooo00<0000co`0c
o`001C?o00030000oooooooo08Koool0073oool00ol0VOooooooo`0Loooo00<0000co`0co`001C?o
00030000oooooooo08Koool0073oool00ol0VOooooooo`0Loooo0P0000Hco`000`000?ooooooo`26
oooo001`oooo00?o09Woooooool07?ooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001`
oooo00?o09Woooooool07?ooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001`oooo00?o
09Woooooool07?ooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001`oooo00?o09Wooooo
ool07?ooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001`oooo00?o09Woooooool05_oo
o`<00003oooo00<0000co`0co`0013?o00030000oooooooo08Ooool0073oool00ol0VOooooooo`0G
oooo00<0003oooooool00_ooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001`oooo00?o
09Woooooool05?ooo`D00003oooo0`0000@co`000`000?ooooooo`27oooo0027oooo00@0003ooooo
ool00004oooo1c?o08[oool008Soool00`000?ooo`000004oooo1c?o08[oool008Woool200001?oo
o`Lco`2:oooo002?oooo1c?o08[oool008ooool7<ol0R_ooo`00NOooo`030000oooooooo01?oool7
<ol03_ooo`030000oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool02Ooo
o`Lco`0?oooo00<0003oooooool0N?ooo`00N?ooo`030000oooooooo00;oool200001?ooo`030000
oooooooo00Ooool2000013?o008000000c?o0?ooooooo`02oooo0`0000;oool200001?ooo`030000
oooooooo07Soool007Soool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000
oooooooo00Goool010000?ooooooo`0000Hco`05oooo00@0003oooooool00002oooo00D0003ooooo
ooooool00000N_ooo`00Moooo`030000oooooooo00;oool00`000?ooooooo`0=oooo00@0003ooooo
ool00006<ol00_ooo`D000001Oooo`000?ooooooo`000004oooo00<0003oooooool0Moooo`00N?oo
o`030000oooooooo00D0000<oooo00@0003oooooool00006<ol00_ooo`040000oooooooo00000ooo
o`800004oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000ooool010000?oo
ooooo`0000Hco`03oooo00<0003oool000000_ooo`040000oooooooo00000oooo`030000oooooooo
07Soool007Woool00`000?ooooooo`0Aoooo0P0000Lco`04oooo0P0000?oool200000oooo`030000
oooooooo07Woool008ooool7<ol0R_ooo`00Soooo`Lco`2:oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.32392 .12361 L
.34309 .12361 L
.36173 .12361 L
.37114 .12361 L
.37372 .12361 L
.37649 .12361 L
.37783 .12361 L
.3791 .12361 L
.38025 .12361 L
s
.38025 .12361 m
.38075 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -24.7813 0 ]
[.5 .63053 24.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -85.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
102.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`09oooo00<0003ooooo
ool02Oooo`030000oooooooo00Woool00`000?ooooooo`03oooo00?o09Woooooool00oooo`030000
oooooooo00Woool00`000?ooooooo`09oooo00<0000co`0co`002C?o00030000<ol0<ol000Tco`00
0`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Tco`000`0003?o03?o0006
<ol08P0000Koool00`000?ooooooo`09oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo
03[oool00`000?ooooooo`0Koooo00?o09Woooooool06oooo`030000<ol0<ol003Tco`090000=?oo
o`030000oooooooo01Goool0077oool00ol0VOooooooo`0Koooo00<0000co`0co`00<c?o00H0001E
oooo001aoooo00?o09Woooooool06oooo`030000<ol0<ol0034co`020000Foooo`00LOooo`03o`2I
oooooooo01_oool00`0003?o03?o000_<ol00P0005goool0077oool00ol0VOooooooo`0Koooo00<0
000co`0co`00;3?o00<0001Ooooo001aoooo00?o09Woooooool06oooo`80000Z<ol00`0006;oool0
077oool00ol0VOooooooo`0Koooo00<0000co`0co`009c?o0080001Uoooo001aoooo00?o09Wooooo
ool06oooo`030000<ol0<ol002Hco`000`000?ooooooo`1Uoooo001aoooo00?o09Woooooool06ooo
o`030000<ol0<ol002Dco`000`000?ooooooo`1Voooo001aoooo00?o09Woooooool06oooo`030000
<ol0<ol002@co`000`000?ooooooo`1Woooo001aoooo00?o09Woooooool06oooo`030000<ol0<ol0
028co`020000J_ooo`00LOooo`03o`2Ioooooooo01_oool200008S?o00030000oooooooo06[oool0
077oool00ol0VOooooooo`0Koooo00<0000co`0co`0083?o00030000oooooooo06_oool0077oool0
0ol0VOooooooo`0Koooo00<0000co`0co`007c?o00030000oooooooo06coool0077oool00ol0VOoo
ooooo`0Koooo00<0000co`0co`007c?o00030000oooooooo06coool0077oool00ol0VOooooooo`0K
oooo00<0000co`0co`007S?o00030000oooooooo06goool0077oool00ol0VOooooooo`0Koooo00<0
000co`0co`007C?o00030000oooooooo06koool0077oool00ol0VOooooooo`0Koooo0P0001dco`00
0`000?ooooooo`1_oooo001aoooo00?o09Woooooool06oooo`030000<ol0<ol001/co`000`000?oo
ooooo`1`oooo001aoooo00?o09Woooooool06oooo`030000<ol0<ol001/co`000`000?ooooooo`1`
oooo001aoooo00?o09Woooooool06oooo`030000<ol0<ol001Xco`000`000?ooooooo`1aoooo001a
oooo00?o09Woooooool06oooo`030000<ol0<ol001Xco`000`000?ooooooo`1aoooo001aoooo00?o
09Woooooool06oooo`030000<ol0<ol001Tco`000`000?ooooooo`1boooo001aoooo00?o09Wooooo
ool06oooo`80000J<ol000<0003oooooool0L_ooo`00LOooo`03o`2Ioooooooo01_oool00`0003?o
03?o000H<ol000<0003oooooool0Loooo`00LOooo`03o`2Ioooooooo01_oool00`0003?o03?o000H
<ol000<0003oooooool0Loooo`00LOooo`03o`2Ioooooooo01_oool00`0003?o03?o000G<ol000<0
003oooooool0M?ooo`00LOooo`03o`2Ioooooooo01_oool00`0003?o03?o000G<ol000<0003ooooo
ool0M?ooo`00LOooo`03o`2Ioooooooo01?oool500000oooo`030000<ol0<ol001Hco`000`000?oo
ooooo`1eoooo001aoooo00?o09Woooooool05Oooo`030000oooooooo00?oool00`0003?o03?o000F
<ol000<0003oooooool0MOooo`00LOooo`03o`2Ioooooooo01Goool00`000?ooooooo`03oooo0`00
01Dco`000`000?ooooooo`1foooo001aoooo00?o09Woooooool05Oooo`030000oooooooo00?oool0
0`0003?o03?o000E<ol000<0003oooooool0M_ooo`00LOooo`03o`2Ioooooooo01Goool00`000?oo
ooooo`03oooo00<0000co`0co`005C?o00030000oooooooo07Koool0077oool00ol0VOooooooo`0D
oooo0P0000Goool00`0003?o03?o000D<ol000<0003oooooool0Moooo`00LOooo`03o`2Ioooooooo
01_oool00`0003?o03?o000D<ol000<0003oooooool0Moooo`00LOooo`03o`2Ioooooooo01_oool0
0`0003?o03?o000C<ol000<0003oooooool0N?ooo`00LOooo`03o`2Ioooooooo01_oool2000053?o
00030000oooooooo07Soool0077oool00ol0VOooooooo`0Koooo00<0000co`0co`004c?o00030000
oooooooo07Soool0077oool00ol0VOooooooo`0Koooo00<0000co`0co`004S?o00030000oooooooo
07Woool0077oool00ol0VOooooooo`0Koooo00<0000co`0co`004S?o00030000oooooooo07Woool0
077oool00ol0VOooooooo`0Koooo00<0000co`0co`004S?o00030000oooooooo07Woool0077oool0
0ol0VOooooooo`0Koooo00<0000co`0co`004C?o00030000oooooooo07[oool0077oool00ol0VOoo
ooooo`0Koooo0P00018co`000`000?ooooooo`1joooo001aoooo00?o09Woooooool06oooo`030000
<ol0<ol0014co`000`000?ooooooo`1joooo001aoooo00?o09Woooooool06oooo`030000<ol0<ol0
014co`000`000?ooooooo`1joooo001aoooo00?o09Woooooool06oooo`030000<ol0<ol0010co`00
0`000?ooooooo`1koooo001aoooo00?o09Woooooool06oooo`030000<ol0<ol0010co`000`000?oo
ooooo`1koooo001aoooo00?o09Woooooool06oooo`030000<ol0<ol0010co`000`000?ooooooo`1k
oooo001aoooo00?o09Woooooool06oooo`030000<ol0<ol0010co`000`000?ooooooo`1koooo001a
oooo00?o09Woooooool06oooo`80000@<ol000<0003oooooool0O?ooo`00LOooo`03o`2Ioooooooo
01_oool00`0003?o03?o000?<ol000<0003oooooool0O?ooo`00LOooo`03o`2Ioooooooo01_oool0
0`0003?o03?o000?<ol000<0003oooooool0O?ooo`00LOooo`03o`2Ioooooooo01_oool00`0003?o
03?o000?<ol000<0003oooooool0O?ooo`00LOooo`03o`2Ioooooooo01_oool00`0003?o03?o000?
<ol000<0003oooooool0O?ooo`00LOooo`03o`2Ioooooooo01_oool00`0003?o03?o000><ol000<0
003oooooool0OOooo`00LOooo`03o`2Ioooooooo01_oool200003c?o00030000oooooooo07goool0
077oool00ol0VOooooooo`0Koooo00<0000co`0co`003S?o00030000oooooooo07goool0077oool0
0ol0VOooooooo`0Koooo00<0000co`0co`003S?o00030000oooooooo07goool0077oool00ol0VOoo
ooooo`0Koooo00<0000co`0co`003C?o00030000oooooooo07koool0077oool00ol0VOooooooo`0C
oooo100000Coool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00LOooo`03o`2Ioooooooo
01?oool00`000?ooooooo`05oooo00<0000co`0co`003C?o00030000oooooooo07koool0077oool0
0ol0VOooooooo`0Doooo00<0003oooooool01?ooo`<0000=<ol000<0003oooooool0O_ooo`00LOoo
o`03o`2Ioooooooo01Goool00`000?ooooooo`03oooo00<0000co`0co`003C?o00030000oooooooo
07koool0077oool00ol0VOooooooo`0Coooo00@0003oooooool00004oooo00<0000co`0co`0033?o
00030000oooooooo07ooool0077oool00ol0VOooooooo`0Doooo0P0000Goool00`0003?o03?o000<
<ol000<0003oooooool0Ooooo`00LOooo`03o`2Ioooooooo01_oool00`0003?o03?o000<<ol000<0
003oooooool0Ooooo`00LOooo`03o`2Ioooooooo01_oool00`0003?o03?o000<<ol000<0003ooooo
ool0Ooooo`00LOooo`03o`2Ioooooooo01_oool200003C?o00030000oooooooo07ooool0077oool0
0ol0VOooooooo`0Koooo00<0000co`0co`0033?o00030000oooooooo07ooool0077oool00ol0VOoo
ooooo`0Koooo00<0000co`0co`002c?o00030000oooooooo083oool0077oool00ol0VOooooooo`0K
oooo00<0000co`0co`002c?o00030000oooooooo083oool0077oool00ol0VOooooooo`0Koooo00<0
000co`0co`002c?o00030000oooooooo083oool0077oool00ol0VOooooooo`0Koooo00<0000co`0c
o`002c?o00030000oooooooo083oool0077oool00ol0VOooooooo`0Koooo00<0000co`0co`002c?o
00030000oooooooo083oool0077oool00ol0VOooooooo`0Koooo0P0000`co`000`000?ooooooo`20
oooo001aoooo00?o09Woooooool06oooo`030000<ol0<ol000/co`000`000?ooooooo`20oooo001a
oooo00?o09Woooooool06oooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001aoooo00?o
09Woooooool06oooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001aoooo00?o09Wooooo
ool06oooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001aoooo00?o09Woooooool06ooo
o`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001aoooo00?o09Woooooool06oooo`80000;
<ol000<0003oooooool0POooo`00LOooo`03o`2Ioooooooo01_oool00`0003?o03?o000:<ol000<0
003oooooool0POooo`00LOooo`03o`2Ioooooooo01_oool00`0003?o03?o000:<ol000<0003ooooo
ool0POooo`00LOooo`03o`2Ioooooooo01_oool00`0003?o03?o0009<ol000<0003oooooool0P_oo
o`00LOooo`03o`2Ioooooooo01_oool00`0003?o03?o0009<ol000<0003oooooool0P_ooo`00LOoo
o`03o`2Ioooooooo01_oool00`0003?o03?o0009<ol000<0003oooooool0P_ooo`00LOooo`03o`2I
oooooooo01_oool200002S?o00030000oooooooo08;oool0077oool00ol0VOooooooo`0Koooo00<0
000co`0co`002C?o00030000oooooooo08;oool0077oool00ol0VOooooooo`0Koooo00<0000co`0c
o`002C?o00030000oooooooo08;oool0077oool00ol0VOooooooo`0Koooo00<0000co`0co`0023?o
00030000oooooooo08?oool0077oool00ol0VOooooooo`0Doooo0P0000Goool00`0003?o03?o0008
<ol000<0003oooooool0Poooo`00LOooo`03o`2Ioooooooo01?oool010000?ooooooo`0000Coool0
0`0003?o03?o0008<ol000<0003oooooool0Poooo`00LOooo`03o`2Ioooooooo01Goool00`000?oo
ooooo`03oooo0`0000Pco`000`000?ooooooo`23oooo001aoooo00?o09Woooooool05_ooo`030000
oooooooo00;oool00`0003?o03?o0008<ol000<0003oooooool0Poooo`00LOooo`03o`2Ioooooooo
01?oool010000?ooooooo`0000Coool00`0003?o03?o0008<ol000<0003oooooool0Poooo`00LOoo
o`03o`2Ioooooooo01Coool200001Oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001a
oooo00?o09Woooooool06oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001aoooo00?o
09Woooooool06oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001aoooo00?o09Wooooo
ool06oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001aoooo00?o09Woooooool06ooo
o`800008<ol000<0003oooooool0Q?ooo`00LOooo`03o`2Ioooooooo01_oool00`0003?o03?o0007
<ol000<0003oooooool0Q?ooo`00LOooo`03o`2Ioooooooo01_oool00`0003?o03?o0007<ol000<0
003oooooool0Q?ooo`00LOooo`03o`2Ioooooooo01_oool00`0003?o03?o0007<ol000<0003ooooo
ool0Q?ooo`00LOooo`03o`2Ioooooooo01_oool00`0003?o03?o0006<ol000<0003oooooool0QOoo
o`00LOooo`03o`2Ioooooooo01_oool00`0003?o03?o0006<ol000<0003oooooool0QOooo`00LOoo
o`03o`2Ioooooooo01_oool200001c?o00030000oooooooo08Goool0077oool00ol0VOooooooo`0K
oooo00<0000co`0co`001S?o00030000oooooooo08Goool0077oool00ol0VOooooooo`0Koooo00<0
000co`0co`001S?o00030000oooooooo08Goool0077oool00ol0VOooooooo`0Koooo00<0000co`0c
o`001S?o00030000oooooooo08Goool0077oool00ol0VOooooooo`0Koooo00<0000co`0co`001S?o
00030000oooooooo08Goool0077oool00ol0VOooooooo`0Koooo00<0000co`0co`001S?o00030000
oooooooo08Goool0077oool00ol0VOooooooo`0Koooo0P0000Hco`000`000?ooooooo`26oooo001a
oooo00?o09Woooooool06oooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001aoooo00?o
09Woooooool06oooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001aoooo00?o09Wooooo
ool06oooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001aoooo00?o09Woooooool06ooo
o`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001aoooo00?o09Woooooool06oooo`030000
<ol0<ol000Dco`000`000?ooooooo`26oooo001aoooo00?o09Woooooool06oooo`800006<ol000<0
003oooooool0Q_ooo`00LOooo`03o`2Ioooooooo01_oool00`0003?o03?o0005<ol000<0003ooooo
ool0Q_ooo`00LOooo`03o`2Ioooooooo01_oool00`0003?o03?o0005<ol000<0003oooooool0Q_oo
o`00LOooo`03o`2Ioooooooo01_oool00`0003?o03?o0004<ol000<0003oooooool0Qoooo`00LOoo
o`03o`2Ioooooooo01_oool00`0003?o03?o0004<ol000<0003oooooool0Qoooo`00LOooo`03o`2I
oooooooo01Goool300000oooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001aoooo00?o
09Woooooool05_ooo`030000oooooooo00;oool00`0003?o03?o0004<ol000<0003oooooool0Qooo
o`00LOooo`03o`2Ioooooooo01?oool500000oooo`<00004<ol000<0003oooooool0Qoooo`00Qooo
o`040000oooooooo00001?ooo`Lco`2:oooo0028oooo00<0003oool000001?ooo`Lco`2:oooo0029
oooo0P0000Coool7<ol0R_ooo`00Soooo`Lco`2:oooo002?oooo1c?o08[oool007coool00`000?oo
ooooo`0@oooo1c?o00_oool00`000?ooooooo`1loooo001koooo00<0003oooooool02?ooo`030000
oooooooo00Koool7<ol03?ooo`030000oooooooo07_oool007_oool00`000?ooooooo`02oooo0P00
00Coool00`000?ooooooo`06oooo00<co`000000000013?o00800004oooo0P0000Coool00`000?oo
ooooo`1koooo001koooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?oo
ooooo`05oooo00@0000co`0co`000003<ol01Oooo`040000oooooooo00000oooo`030000oooooooo
07_oool007[oool00`000?ooooooo`02oooo00<0003oooooool03Oooo`040000<ol0<ol000000c?o
00Soool00`000?ooooooo`02oooo00<0003oooooool0N_ooo`00Noooo`030000oooooooo00D0000<
oooo00@0000co`0co`000003<ol01_ooo`800004oooo00<0003oooooool0Noooo`00Noooo`050000
oooooooooooo000000ooool0100003?o03?o000000<co`06oooo00<0003oooooool00oooo`030000
oooooooo07_oool007coool00`000?ooooooo`0@oooo00<co`000000000013?o00Koool300000_oo
o`030000oooooooo07coool008ooool7<ol0R_ooo`00Soooo`Lco`2:oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.52) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.36136 .12361 L
.37176 .12361 L
.37685 .12361 L
.3815 .12361 L
.38384 .12361 L
.38448 .12361 L
.38517 .12361 L
s
.38517 .12361 m
.38566 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.52) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`09oooo00<0003ooooo
ool02Oooo`030000oooooooo00Woool00`000?ooooooo`04oooo00?o09Woooooool00_ooo`030000
oooooooo00Woool00`000?ooooooo`09oooo00<0000co`0co`002C?o00030000<ol0<ol000Tco`00
0`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Tco`000`0003?o03?o0006
<ol08P0000Koool00`000?ooooooo`09oooo00<0003oooooool05Oooo`005_ooo`030000oooooooo
03[oool00`000?ooooooo`0Loooo00?o09Woooooool06_ooo`030000<ol0<ol003Tco`090000=?oo
o`030000oooooooo01Goool007;oool00ol0VOooooooo`0Joooo00<0000co`0co`00<c?o00H0001E
oooo001boooo00?o09Woooooool06_ooo`030000<ol0<ol0034co`020000Foooo`00L_ooo`03o`2I
oooooooo01[oool00`0003?o03?o000_<ol00P0005goool007;oool00ol0VOooooooo`0Joooo00<0
000co`0co`00;3?o00<0001Ooooo001boooo00?o09Woooooool06_ooo`80000Z<ol00`0006;oool0
07;oool00ol0VOooooooo`0Joooo00<0000co`0co`009c?o0080001Uoooo001boooo00?o09Wooooo
ool06_ooo`030000<ol0<ol002Hco`000`000?ooooooo`1Uoooo001boooo00?o09Woooooool06_oo
o`030000<ol0<ol002Dco`000`000?ooooooo`1Voooo001boooo00?o09Woooooool06_ooo`030000
<ol0<ol002@co`000`000?ooooooo`1Woooo001boooo00?o09Woooooool06_ooo`030000<ol0<ol0
028co`020000J_ooo`00L_ooo`03o`2Ioooooooo01[oool200008S?o00030000oooooooo06[oool0
07;oool00ol0VOooooooo`0Joooo00<0000co`0co`0083?o00030000oooooooo06_oool007;oool0
0ol0VOooooooo`0Joooo00<0000co`0co`007c?o00030000oooooooo06coool007;oool00ol0VOoo
ooooo`0Joooo00<0000co`0co`007c?o00030000oooooooo06coool007;oool00ol0VOooooooo`0J
oooo00<0000co`0co`007S?o00030000oooooooo06goool007;oool00ol0VOooooooo`0Joooo00<0
000co`0co`007C?o00030000oooooooo06koool007;oool00ol0VOooooooo`0Joooo0P0001dco`00
0`000?ooooooo`1_oooo001boooo00?o09Woooooool06_ooo`030000<ol0<ol001/co`000`000?oo
ooooo`1`oooo001boooo00?o09Woooooool06_ooo`030000<ol0<ol001/co`000`000?ooooooo`1`
oooo001boooo00?o09Woooooool06_ooo`030000<ol0<ol001Xco`000`000?ooooooo`1aoooo001b
oooo00?o09Woooooool06_ooo`030000<ol0<ol001Xco`000`000?ooooooo`1aoooo001boooo00?o
09Woooooool06_ooo`030000<ol0<ol001Tco`000`000?ooooooo`1boooo001boooo00?o09Wooooo
ool06_ooo`80000J<ol000<0003oooooool0L_ooo`00L_ooo`03o`2Ioooooooo01[oool00`0003?o
03?o000H<ol000<0003oooooool0Loooo`00L_ooo`03o`2Ioooooooo01[oool00`0003?o03?o000H
<ol000<0003oooooool0Loooo`00L_ooo`03o`2Ioooooooo01[oool00`0003?o03?o000G<ol000<0
003oooooool0M?ooo`00L_ooo`03o`2Ioooooooo01[oool00`0003?o03?o000G<ol000<0003ooooo
ool0M?ooo`00L_ooo`03o`2Ioooooooo01;oool500000oooo`030000<ol0<ol001Hco`000`000?oo
ooooo`1eoooo001boooo00?o09Woooooool05?ooo`030000oooooooo00?oool00`0003?o03?o000F
<ol000<0003oooooool0MOooo`00L_ooo`03o`2Ioooooooo01Coool00`000?ooooooo`03oooo0`00
01Dco`000`000?ooooooo`1foooo001boooo00?o09Woooooool05?ooo`030000oooooooo00?oool0
0`0003?o03?o000E<ol000<0003oooooool0M_ooo`00L_ooo`03o`2Ioooooooo01Coool00`000?oo
ooooo`03oooo00<0000co`0co`005C?o00030000oooooooo07Koool007;oool00ol0VOooooooo`0C
oooo0P0000Goool00`0003?o03?o000D<ol000<0003oooooool0Moooo`00L_ooo`03o`2Ioooooooo
01[oool00`0003?o03?o000D<ol000<0003oooooool0Moooo`00L_ooo`03o`2Ioooooooo01[oool0
0`0003?o03?o000C<ol000<0003oooooool0N?ooo`00L_ooo`03o`2Ioooooooo01[oool2000053?o
00030000oooooooo07Soool007;oool00ol0VOooooooo`0Joooo00<0000co`0co`004c?o00030000
oooooooo07Soool007;oool00ol0VOooooooo`0Joooo00<0000co`0co`004S?o00030000oooooooo
07Woool007;oool00ol0VOooooooo`0Joooo00<0000co`0co`004S?o00030000oooooooo07Woool0
07;oool00ol0VOooooooo`0Joooo00<0000co`0co`004S?o00030000oooooooo07Woool007;oool0
0ol0VOooooooo`0Joooo00<0000co`0co`004C?o00030000oooooooo07[oool007;oool00ol0VOoo
ooooo`0Joooo0P00018co`000`000?ooooooo`1joooo001boooo00?o09Woooooool06_ooo`030000
<ol0<ol0014co`000`000?ooooooo`1joooo001boooo00?o09Woooooool06_ooo`030000<ol0<ol0
014co`000`000?ooooooo`1joooo001boooo00?o09Woooooool06_ooo`030000<ol0<ol0010co`00
0`000?ooooooo`1koooo001boooo00?o09Woooooool06_ooo`030000<ol0<ol0010co`000`000?oo
ooooo`1koooo001boooo00?o09Woooooool06_ooo`030000<ol0<ol0010co`000`000?ooooooo`1k
oooo001boooo00?o09Woooooool06_ooo`030000<ol0<ol0010co`000`000?ooooooo`1koooo001b
oooo00?o09Woooooool06_ooo`80000@<ol000<0003oooooool0O?ooo`00L_ooo`03o`2Ioooooooo
01[oool00`0003?o03?o000?<ol000<0003oooooool0O?ooo`00L_ooo`03o`2Ioooooooo01[oool0
0`0003?o03?o000?<ol000<0003oooooool0O?ooo`00L_ooo`03o`2Ioooooooo01[oool00`0003?o
03?o000?<ol000<0003oooooool0O?ooo`00L_ooo`03o`2Ioooooooo01[oool00`0003?o03?o000?
<ol000<0003oooooool0O?ooo`00L_ooo`03o`2Ioooooooo01[oool00`0003?o03?o000><ol000<0
003oooooool0OOooo`00L_ooo`03o`2Ioooooooo01[oool200003c?o00030000oooooooo07goool0
07;oool00ol0VOooooooo`0Joooo00<0000co`0co`003S?o00030000oooooooo07goool007;oool0
0ol0VOooooooo`0Joooo00<0000co`0co`003S?o00030000oooooooo07goool007;oool00ol0VOoo
ooooo`0Joooo00<0000co`0co`003C?o00030000oooooooo07koool007;oool00ol0VOooooooo`0B
oooo100000Coool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00L_ooo`03o`2Ioooooooo
01;oool00`000?ooooooo`05oooo00<0000co`0co`003C?o00030000oooooooo07koool007;oool0
0ol0VOooooooo`0Coooo00<0003oooooool01?ooo`<0000=<ol000<0003oooooool0O_ooo`00L_oo
o`03o`2Ioooooooo01Coool00`000?ooooooo`03oooo00<0000co`0co`003C?o00030000oooooooo
07koool007;oool00ol0VOooooooo`0Boooo00@0003oooooool00004oooo00<0000co`0co`0033?o
00030000oooooooo07ooool007;oool00ol0VOooooooo`0Coooo0P0000Goool00`0003?o03?o000<
<ol000<0003oooooool0Ooooo`00L_ooo`03o`2Ioooooooo01[oool00`0003?o03?o000<<ol000<0
003oooooool0Ooooo`00L_ooo`03o`2Ioooooooo01[oool00`0003?o03?o000<<ol000<0003ooooo
ool0Ooooo`00L_ooo`03o`2Ioooooooo01[oool200003C?o00030000oooooooo07ooool007;oool0
0ol0VOooooooo`0Joooo00<0000co`0co`0033?o00030000oooooooo07ooool007;oool00ol0VOoo
ooooo`0Joooo00<0000co`0co`002c?o00030000oooooooo083oool007;oool00ol0VOooooooo`0J
oooo00<0000co`0co`002c?o00030000oooooooo083oool007;oool00ol0VOooooooo`0Joooo00<0
000co`0co`002c?o00030000oooooooo083oool007;oool00ol0VOooooooo`0Joooo00<0000co`0c
o`002c?o00030000oooooooo083oool007;oool00ol0VOooooooo`0Joooo00<0000co`0co`002c?o
00030000oooooooo083oool007;oool00ol0VOooooooo`0Joooo0P0000`co`000`000?ooooooo`20
oooo001boooo00?o09Woooooool06_ooo`030000<ol0<ol000/co`000`000?ooooooo`20oooo001b
oooo00?o09Woooooool06_ooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001boooo00?o
09Woooooool06_ooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001boooo00?o09Wooooo
ool06_ooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001boooo00?o09Woooooool06_oo
o`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001boooo00?o09Woooooool06_ooo`80000;
<ol000<0003oooooool0POooo`00L_ooo`03o`2Ioooooooo01[oool00`0003?o03?o000:<ol000<0
003oooooool0POooo`00L_ooo`03o`2Ioooooooo01[oool00`0003?o03?o000:<ol000<0003ooooo
ool0POooo`00L_ooo`03o`2Ioooooooo01[oool00`0003?o03?o0009<ol000<0003oooooool0P_oo
o`00L_ooo`03o`2Ioooooooo01[oool00`0003?o03?o0009<ol000<0003oooooool0P_ooo`00L_oo
o`03o`2Ioooooooo01[oool00`0003?o03?o0009<ol000<0003oooooool0P_ooo`00L_ooo`03o`2I
oooooooo01[oool200002S?o00030000oooooooo08;oool007;oool00ol0VOooooooo`0Joooo00<0
000co`0co`002C?o00030000oooooooo08;oool007;oool00ol0VOooooooo`0Joooo00<0000co`0c
o`002C?o00030000oooooooo08;oool007;oool00ol0VOooooooo`0Joooo00<0000co`0co`0023?o
00030000oooooooo08?oool007;oool00ol0VOooooooo`0Coooo0P0000Goool00`0003?o03?o0008
<ol000<0003oooooool0Poooo`00L_ooo`03o`2Ioooooooo01;oool010000?ooooooo`0000Coool0
0`0003?o03?o0008<ol000<0003oooooool0Poooo`00L_ooo`03o`2Ioooooooo01Coool00`000?oo
ooooo`03oooo0`0000Pco`000`000?ooooooo`23oooo001boooo00?o09Woooooool05Oooo`030000
oooooooo00;oool00`0003?o03?o0008<ol000<0003oooooool0Poooo`00L_ooo`03o`2Ioooooooo
01;oool010000?ooooooo`0000Coool00`0003?o03?o0008<ol000<0003oooooool0Poooo`00L_oo
o`03o`2Ioooooooo01?oool200001Oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001b
oooo00?o09Woooooool06_ooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001boooo00?o
09Woooooool06_ooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001boooo00?o09Wooooo
ool06_ooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001boooo00?o09Woooooool06_oo
o`800008<ol000<0003oooooool0Q?ooo`00L_ooo`03o`2Ioooooooo01[oool00`0003?o03?o0007
<ol000<0003oooooool0Q?ooo`00L_ooo`03o`2Ioooooooo01[oool00`0003?o03?o0007<ol000<0
003oooooool0Q?ooo`00L_ooo`03o`2Ioooooooo01[oool00`0003?o03?o0007<ol000<0003ooooo
ool0Q?ooo`00L_ooo`03o`2Ioooooooo01[oool00`0003?o03?o0006<ol000<0003oooooool0QOoo
o`00L_ooo`03o`2Ioooooooo01[oool00`0003?o03?o0006<ol000<0003oooooool0QOooo`00L_oo
o`03o`2Ioooooooo01[oool200001c?o00030000oooooooo08Goool007;oool00ol0VOooooooo`0J
oooo00<0000co`0co`001S?o00030000oooooooo08Goool007;oool00ol0VOooooooo`0Joooo00<0
000co`0co`001S?o00030000oooooooo08Goool007;oool00ol0VOooooooo`0Joooo00<0000co`0c
o`001S?o00030000oooooooo08Goool007;oool00ol0VOooooooo`0Joooo00<0000co`0co`001S?o
00030000oooooooo08Goool007;oool00ol0VOooooooo`0Joooo00<0000co`0co`001S?o00030000
oooooooo08Goool007;oool00ol0VOooooooo`0Joooo0P0000Hco`000`000?ooooooo`26oooo001b
oooo00?o09Woooooool06_ooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001boooo00?o
09Woooooool06_ooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001boooo00?o09Wooooo
ool06_ooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001boooo00?o09Woooooool06_oo
o`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001boooo00?o09Woooooool06_ooo`030000
<ol0<ol000Dco`000`000?ooooooo`26oooo001boooo00?o09Woooooool06_ooo`800006<ol000<0
003oooooool0Q_ooo`00L_ooo`03o`2Ioooooooo01[oool00`0003?o03?o0005<ol000<0003ooooo
ool0Q_ooo`00L_ooo`03o`2Ioooooooo01[oool00`0003?o03?o0005<ol000<0003oooooool0Q_oo
o`00L_ooo`03o`2Ioooooooo01[oool00`0003?o03?o0004<ol000<0003oooooool0Qoooo`00L_oo
o`03o`2Ioooooooo01[oool00`0003?o03?o0004<ol000<0003oooooool0Qoooo`00L_ooo`03o`2I
oooooooo01Coool300000oooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001boooo00?o
09Woooooool05Oooo`030000oooooooo00;oool00`0003?o03?o0004<ol000<0003oooooool0Qooo
o`00L_ooo`03o`2Ioooooooo01;oool500000oooo`<00004<ol000<0003oooooool0Qoooo`00Qooo
o`040000oooooooo00001?ooo`Lco`2:oooo0028oooo00<0003oool000001?ooo`Lco`2:oooo0029
oooo0P0000Coool7<ol0R_ooo`00Soooo`Lco`2:oooo002?oooo1c?o08[oool007Woool00`000?oo
ooooo`0Coooo1c?o00koool00`000?ooooooo`1ioooo001hoooo00<0003oooooool02?ooo`030000
oooooooo00Woool7<ol03oooo`030000oooooooo07Soool007Soool00`000?ooooooo`02oooo0P00
00Coool00`000?ooooooo`07oooo0P0000@co`02000000@co`3oooooooooool200000oooo`@00003
oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?ooooooo`02
oooo00<0003oooooool01Oooo`040000oooooooo00001S?o00;oool010000?ooooooo`0000;oool0
0`000?ooooooo`04oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo00;oool00`000?oo
ooooo`0=oooo00@0003oooooool00006<ol01Oooo`050000oooooooooooo000000Koool00`000?oo
ooooo`1goooo001hoooo00<0003oooooool01@0000coool010000?ooooooo`0000Hco`03oooo0P00
00Goool00`000?ooooooo`02oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo0000
00ooool010000?ooooooo`0000Hco`03oooo00<0003oooooool00_ooo`040000oooooooo00000ooo
o`030000oooooooo07Soool007Woool00`000?ooooooo`0Aoooo0P0000Lco`03oooo0`0000?oool2
00000oooo`030000oooooooo07Woool008ooool7<ol0R_ooo`00Soooo`Lco`2:oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.54) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.36136 .12361 L
.37176 .12361 L
.37685 .12361 L
.3815 .12361 L
.38384 .12361 L
.3864 .12361 L
.38757 .12361 L
.38881 .12361 L
.38999 .12361 L
s
.38999 .12361 m
.39042 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.54) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`09oooo00<0003ooooo
ool02Oooo`030000oooooooo00Woool00`000?ooooooo`05oooo00Go09Woooooooooool000002ooo
o`030000oooooooo00Woool00`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol0
00Tco`000`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Hco`0R00001_oo
o`030000oooooooo00Woool00`000?ooooooo`0Eoooo000Foooo00<0003oooooool0>_ooo`030000
oooooooo01goool00ol0VOooooooo`0Ioooo00<0000co`0co`00>C?o00T0000doooo00<0003ooooo
ool05Oooo`00Loooo`03o`2Ioooooooo01Woool00`0003?o03?o000c<ol01P0005Goool007?oool0
0ol0VOooooooo`0Ioooo00<0000co`0co`00<C?o0080001Koooo001coooo00?o09Woooooool06Ooo
o`030000<ol0<ol002lco`020000GOooo`00Loooo`03o`2Ioooooooo01Woool00`0003?o03?o000/
<ol00`0005ooool007?oool00ol0VOooooooo`0Ioooo0P0002Xco`030000H_ooo`00Loooo`03o`2I
oooooooo01Woool00`0003?o03?o000W<ol00P0006Goool007?oool00ol0VOooooooo`0Ioooo00<0
000co`0co`009S?o00030000oooooooo06Goool007?oool00ol0VOooooooo`0Ioooo00<0000co`0c
o`009C?o00030000oooooooo06Koool007?oool00ol0VOooooooo`0Ioooo00<0000co`0co`0093?o
00030000oooooooo06Ooool007?oool00ol0VOooooooo`0Ioooo00<0000co`0co`008S?o0080001Z
oooo001coooo00?o09Woooooool06Oooo`80000R<ol000<0003oooooool0J_ooo`00Loooo`03o`2I
oooooooo01Woool00`0003?o03?o000P<ol000<0003oooooool0Joooo`00Loooo`03o`2Ioooooooo
01Woool00`0003?o03?o000O<ol000<0003oooooool0K?ooo`00Loooo`03o`2Ioooooooo01Woool0
0`0003?o03?o000O<ol000<0003oooooool0K?ooo`00Loooo`03o`2Ioooooooo01Woool00`0003?o
03?o000N<ol000<0003oooooool0KOooo`00Loooo`03o`2Ioooooooo01Woool00`0003?o03?o000M
<ol000<0003oooooool0K_ooo`00Loooo`03o`2Ioooooooo01Woool200007C?o00030000oooooooo
06ooool007?oool00ol0VOooooooo`0Ioooo00<0000co`0co`006c?o00030000oooooooo073oool0
07?oool00ol0VOooooooo`0Ioooo00<0000co`0co`006c?o00030000oooooooo073oool007?oool0
0ol0VOooooooo`0Ioooo00<0000co`0co`006S?o00030000oooooooo077oool007?oool00ol0VOoo
ooooo`0Ioooo00<0000co`0co`006S?o00030000oooooooo077oool007?oool00ol0VOooooooo`0I
oooo00<0000co`0co`006C?o00030000oooooooo07;oool007?oool00ol0VOooooooo`0Ioooo0P00
01Xco`000`000?ooooooo`1boooo001coooo00?o09Woooooool06Oooo`030000<ol0<ol001Pco`00
0`000?ooooooo`1coooo001coooo00?o09Woooooool06Oooo`030000<ol0<ol001Pco`000`000?oo
ooooo`1coooo001coooo00?o09Woooooool06Oooo`030000<ol0<ol001Lco`000`000?ooooooo`1d
oooo001coooo00?o09Woooooool06Oooo`030000<ol0<ol001Lco`000`000?ooooooo`1doooo001c
oooo00?o09Woooooool04Oooo`D00003oooo00<0000co`0co`005S?o00030000oooooooo07Goool0
07?oool00ol0VOooooooo`0Coooo00<0003oooooool00oooo`030000<ol0<ol001Hco`000`000?oo
ooooo`1eoooo001coooo00?o09Woooooool04oooo`030000oooooooo00?oool300005C?o00030000
oooooooo07Koool007?oool00ol0VOooooooo`0Coooo00<0003oooooool00oooo`030000<ol0<ol0
01Dco`000`000?ooooooo`1foooo001coooo00?o09Woooooool04oooo`030000oooooooo00?oool0
0`0003?o03?o000E<ol000<0003oooooool0M_ooo`00Loooo`03o`2Ioooooooo01;oool200001Ooo
o`030000<ol0<ol001@co`000`000?ooooooo`1goooo001coooo00?o09Woooooool06Oooo`030000
<ol0<ol001@co`000`000?ooooooo`1goooo001coooo00?o09Woooooool06Oooo`030000<ol0<ol0
01<co`000`000?ooooooo`1hoooo001coooo00?o09Woooooool06Oooo`80000D<ol000<0003ooooo
ool0N?ooo`00Loooo`03o`2Ioooooooo01Woool00`0003?o03?o000C<ol000<0003oooooool0N?oo
o`00Loooo`03o`2Ioooooooo01Woool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00Looo
o`03o`2Ioooooooo01Woool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00Loooo`03o`2I
oooooooo01Woool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00Loooo`03o`2Ioooooooo
01Woool00`0003?o03?o000A<ol000<0003oooooool0N_ooo`00Loooo`03o`2Ioooooooo01Woool2
00004S?o00030000oooooooo07[oool007?oool00ol0VOooooooo`0Ioooo00<0000co`0co`004C?o
00030000oooooooo07[oool007?oool00ol0VOooooooo`0Ioooo00<0000co`0co`004C?o00030000
oooooooo07[oool007?oool00ol0VOooooooo`0Ioooo00<0000co`0co`0043?o00030000oooooooo
07_oool007?oool00ol0VOooooooo`0Ioooo00<0000co`0co`0043?o00030000oooooooo07_oool0
07?oool00ol0VOooooooo`0Ioooo00<0000co`0co`0043?o00030000oooooooo07_oool007?oool0
0ol0VOooooooo`0Ioooo00<0000co`0co`0043?o00030000oooooooo07_oool007?oool00ol0VOoo
ooooo`0Ioooo0P00010co`000`000?ooooooo`1loooo001coooo00?o09Woooooool06Oooo`030000
<ol0<ol000lco`000`000?ooooooo`1loooo001coooo00?o09Woooooool06Oooo`030000<ol0<ol0
00lco`000`000?ooooooo`1loooo001coooo00?o09Woooooool06Oooo`030000<ol0<ol000lco`00
0`000?ooooooo`1loooo001coooo00?o09Woooooool06Oooo`030000<ol0<ol000lco`000`000?oo
ooooo`1loooo001coooo00?o09Woooooool06Oooo`030000<ol0<ol000hco`000`000?ooooooo`1m
oooo001coooo00?o09Woooooool06Oooo`80000?<ol000<0003oooooool0OOooo`00Loooo`03o`2I
oooooooo01Woool00`0003?o03?o000><ol000<0003oooooool0OOooo`00Loooo`03o`2Ioooooooo
01Woool00`0003?o03?o000><ol000<0003oooooool0OOooo`00Loooo`03o`2Ioooooooo01Woool0
0`0003?o03?o000=<ol000<0003oooooool0O_ooo`00Loooo`03o`2Ioooooooo017oool400001?oo
o`030000<ol0<ol000dco`000`000?ooooooo`1noooo001coooo00?o09Woooooool04Oooo`030000
oooooooo00Goool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00Loooo`03o`2Ioooooooo
01;oool00`000?ooooooo`04oooo0`0000dco`000`000?ooooooo`1noooo001coooo00?o09Wooooo
ool04oooo`030000oooooooo00?oool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00Looo
o`03o`2Ioooooooo017oool010000?ooooooo`0000Coool00`0003?o03?o000<<ol000<0003ooooo
ool0Ooooo`00Loooo`03o`2Ioooooooo01;oool200001Oooo`030000<ol0<ol000`co`000`000?oo
ooooo`1ooooo001coooo00?o09Woooooool06Oooo`030000<ol0<ol000`co`000`000?ooooooo`1o
oooo001coooo00?o09Woooooool06Oooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001c
oooo00?o09Woooooool06Oooo`80000=<ol000<0003oooooool0Ooooo`00Loooo`03o`2Ioooooooo
01Woool00`0003?o03?o000<<ol000<0003oooooool0Ooooo`00Loooo`03o`2Ioooooooo01Woool0
0`0003?o03?o000;<ol000<0003oooooool0P?ooo`00Loooo`03o`2Ioooooooo01Woool00`0003?o
03?o000;<ol000<0003oooooool0P?ooo`00Loooo`03o`2Ioooooooo01Woool00`0003?o03?o000;
<ol000<0003oooooool0P?ooo`00Loooo`03o`2Ioooooooo01Woool00`0003?o03?o000;<ol000<0
003oooooool0P?ooo`00Loooo`03o`2Ioooooooo01Woool00`0003?o03?o000;<ol000<0003ooooo
ool0P?ooo`00Loooo`03o`2Ioooooooo01Woool2000033?o00030000oooooooo083oool007?oool0
0ol0VOooooooo`0Ioooo00<0000co`0co`002c?o00030000oooooooo083oool007?oool00ol0VOoo
ooooo`0Ioooo00<0000co`0co`002S?o00030000oooooooo087oool007?oool00ol0VOooooooo`0I
oooo00<0000co`0co`002S?o00030000oooooooo087oool007?oool00ol0VOooooooo`0Ioooo00<0
000co`0co`002S?o00030000oooooooo087oool007?oool00ol0VOooooooo`0Ioooo00<0000co`0c
o`002S?o00030000oooooooo087oool007?oool00ol0VOooooooo`0Ioooo0P0000/co`000`000?oo
ooooo`21oooo001coooo00?o09Woooooool06Oooo`030000<ol0<ol000Xco`000`000?ooooooo`21
oooo001coooo00?o09Woooooool06Oooo`030000<ol0<ol000Xco`000`000?ooooooo`21oooo001c
oooo00?o09Woooooool06Oooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001coooo00?o
09Woooooool06Oooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001coooo00?o09Wooooo
ool06Oooo`030000<ol0<ol000Tco`000`000?ooooooo`22oooo001coooo00?o09Woooooool06Ooo
o`80000:<ol000<0003oooooool0P_ooo`00Loooo`03o`2Ioooooooo01Woool00`0003?o03?o0009
<ol000<0003oooooool0P_ooo`00Loooo`03o`2Ioooooooo01Woool00`0003?o03?o0009<ol000<0
003oooooool0P_ooo`00Loooo`03o`2Ioooooooo01Woool00`0003?o03?o0008<ol000<0003ooooo
ool0Poooo`00Loooo`03o`2Ioooooooo01;oool200001Oooo`030000<ol0<ol000Pco`000`000?oo
ooooo`23oooo001coooo00?o09Woooooool04Oooo`040000oooooooo00001?ooo`030000<ol0<ol0
00Pco`000`000?ooooooo`23oooo001coooo00?o09Woooooool04oooo`030000oooooooo00?oool3
000023?o00030000oooooooo08?oool007?oool00ol0VOooooooo`0Doooo00<0003oooooool00_oo
o`030000<ol0<ol000Pco`000`000?ooooooo`23oooo001coooo00?o09Woooooool04Oooo`040000
oooooooo00001?ooo`030000<ol0<ol000Pco`000`000?ooooooo`23oooo001coooo00?o09Wooooo
ool04_ooo`800005oooo00<0000co`0co`001c?o00030000oooooooo08Coool007?oool00ol0VOoo
ooooo`0Ioooo00<0000co`0co`001c?o00030000oooooooo08Coool007?oool00ol0VOooooooo`0I
oooo00<0000co`0co`001c?o00030000oooooooo08Coool007?oool00ol0VOooooooo`0Ioooo00<0
000co`0co`001c?o00030000oooooooo08Coool007?oool00ol0VOooooooo`0Ioooo0P0000Pco`00
0`000?ooooooo`24oooo001coooo00?o09Woooooool06Oooo`030000<ol0<ol000Lco`000`000?oo
ooooo`24oooo001coooo00?o09Woooooool06Oooo`030000<ol0<ol000Lco`000`000?ooooooo`24
oooo001coooo00?o09Woooooool06Oooo`030000<ol0<ol000Lco`000`000?ooooooo`24oooo001c
oooo00?o09Woooooool06Oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001coooo00?o
09Woooooool06Oooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001coooo00?o09Wooooo
ool06Oooo`800007<ol000<0003oooooool0QOooo`00Loooo`03o`2Ioooooooo01Woool00`0003?o
03?o0006<ol000<0003oooooool0QOooo`00Loooo`03o`2Ioooooooo01Woool00`0003?o03?o0006
<ol000<0003oooooool0QOooo`00Loooo`03o`2Ioooooooo01Woool00`0003?o03?o0006<ol000<0
003oooooool0QOooo`00Loooo`03o`2Ioooooooo01Woool00`0003?o03?o0006<ol000<0003ooooo
ool0QOooo`00Loooo`03o`2Ioooooooo01Woool00`0003?o03?o0006<ol000<0003oooooool0QOoo
o`00Loooo`03o`2Ioooooooo01Woool200001S?o00030000oooooooo08Koool007?oool00ol0VOoo
ooooo`0Ioooo00<0000co`0co`001C?o00030000oooooooo08Koool007?oool00ol0VOooooooo`0I
oooo00<0000co`0co`001C?o00030000oooooooo08Koool007?oool00ol0VOooooooo`0Ioooo00<0
000co`0co`001C?o00030000oooooooo08Koool007?oool00ol0VOooooooo`0Ioooo00<0000co`0c
o`001C?o00030000oooooooo08Koool007?oool00ol0VOooooooo`0Ioooo00<0000co`0co`001C?o
00030000oooooooo08Koool007?oool00ol0VOooooooo`0Ioooo0P0000Hco`000`000?ooooooo`26
oooo001coooo00?o09Woooooool06Oooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001c
oooo00?o09Woooooool06Oooo`030000<ol0<ol000Dco`000`000?ooooooo`26oooo001coooo00?o
09Woooooool06Oooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001coooo00?o09Wooooo
ool06Oooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001coooo00?o09Woooooool04ooo
o`<00003oooo00<0000co`0co`0013?o00030000oooooooo08Ooool007?oool00ol0VOooooooo`0D
oooo00<0003oooooool00_ooo`030000<ol0<ol000@co`000`000?ooooooo`27oooo001coooo00?o
09Woooooool04Oooo`D00003oooo0`0000@co`000`000?ooooooo`27oooo0027oooo00@0003ooooo
ool00004oooo1c?o08[oool008Soool00`000?ooo`000004oooo1c?o08[oool008Woool200001?oo
o`Lco`2:oooo002?oooo1c?o08[oool008ooool7<ol0R_ooo`00NOooo`030000oooooooo01?oool7
<ol03_ooo`030000oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool02Ooo
o`Lco`0?oooo00<0003oooooool0N?ooo`00N?ooo`030000oooooooo00;oool200001?ooo`030000
oooooooo00Ooool2000013?o0080000013?o0?ooooooooooo`800005oooo0`0000;oool00`000?oo
ooooo`1hoooo001hoooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool00`000?oo
ooooo`05oooo00@0003oooooool00006<ol00_ooo`040000oooooooo00001Oooo`050000oooooooo
oooo000007[oool007Ooool00`000?ooooooo`02oooo00<0003oooooool03Oooo`040000oooooooo
00001S?o00Goool00`000?ooooooo`0500000oooo`030000oooooooo07Ooool007Soool00`000?oo
ooooo`0500003?ooo`040000oooooooo00001S?o00?oool200000oooo`040000oooooooo00000ooo
o`030000oooooooo07Soool007Soool01@000?ooooooooooo`00000?oooo00@0003oooooool00006
<ol00oooo`030000oooooooo00?oool00`000?ooo`000003oooo00<0003oooooool0N?ooo`00NOoo
o`030000oooooooo017oool200001c?o00?oool300001?ooo`800002oooo00<0003oooooool0NOoo
o`00Soooo`Lco`2:oooo002?oooo1c?o08[oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.56) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.36136 .12361 L
.37176 .12361 L
.3815 .12361 L
.3864 .12361 L
.39106 .12361 L
.39362 .12361 L
.39433 .12361 L
.39508 .12361 L
s
.39508 .12361 m
.39536 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.56) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`09oooo00<0003ooooo
ool02Oooo`030000oooooooo00Woool00`000?ooooooo`06oooo00Co09Woooooool0000;oooo00<0
003oooooool02Oooo`030000<ol0<ol000Tco`000`0003?o03?o0009<ol000<0000co`0co`002C?o
00030000<ol0<ol000Tco`000`0003?o03?o0009<ol000<0000co`0co`001S?o02800006oooo00<0
003oooooool02Oooo`030000oooooooo01Goool001Koool00`000?ooooooo`0joooo00<0003ooooo
ool07_ooo`03o`2Ioooooooo01Soool00`0003?o03?o000i<ol02@0003Coool00`000?ooooooo`0E
oooo001doooo00?o09Woooooool06?ooo`030000<ol0<ol003<co`060000EOooo`00M?ooo`03o`2I
oooooooo01Soool00`0003?o03?o000a<ol00P0005_oool007Coool00ol0VOooooooo`0Hoooo00<0
000co`0co`00;c?o0080001Moooo001doooo00?o09Woooooool06?ooo`030000<ol0<ol002`co`03
0000Goooo`00M?ooo`03o`2Ioooooooo01Soool20000:S?o00<0001Roooo001doooo00?o09Wooooo
ool06?ooo`030000<ol0<ol002Lco`020000IOooo`00M?ooo`03o`2Ioooooooo01Soool00`0003?o
03?o000V<ol000<0003oooooool0IOooo`00M?ooo`03o`2Ioooooooo01Soool00`0003?o03?o000U
<ol000<0003oooooool0I_ooo`00M?ooo`03o`2Ioooooooo01Soool00`0003?o03?o000T<ol000<0
003oooooool0Ioooo`00M?ooo`03o`2Ioooooooo01Soool00`0003?o03?o000R<ol00P0006[oool0
07Coool00ol0VOooooooo`0Hoooo0P00028co`000`000?ooooooo`1Zoooo001doooo00?o09Wooooo
ool06?ooo`030000<ol0<ol0020co`000`000?ooooooo`1[oooo001doooo00?o09Woooooool06?oo
o`030000<ol0<ol001lco`000`000?ooooooo`1/oooo001doooo00?o09Woooooool06?ooo`030000
<ol0<ol001lco`000`000?ooooooo`1/oooo001doooo00?o09Woooooool06?ooo`030000<ol0<ol0
01hco`000`000?ooooooo`1]oooo001doooo00?o09Woooooool06?ooo`030000<ol0<ol001dco`00
0`000?ooooooo`1^oooo001doooo00?o09Woooooool06?ooo`80000M<ol000<0003oooooool0Kooo
o`00M?ooo`03o`2Ioooooooo01Soool00`0003?o03?o000K<ol000<0003oooooool0L?ooo`00M?oo
o`03o`2Ioooooooo01Soool00`0003?o03?o000K<ol000<0003oooooool0L?ooo`00M?ooo`03o`2I
oooooooo01Soool00`0003?o03?o000J<ol000<0003oooooool0LOooo`00M?ooo`03o`2Ioooooooo
01Soool00`0003?o03?o000J<ol000<0003oooooool0LOooo`00M?ooo`03o`2Ioooooooo01Soool0
0`0003?o03?o000I<ol000<0003oooooool0L_ooo`00M?ooo`03o`2Ioooooooo01Soool200006S?o
00030000oooooooo07;oool007Coool00ol0VOooooooo`0Hoooo00<0000co`0co`0063?o00030000
oooooooo07?oool007Coool00ol0VOooooooo`0Hoooo00<0000co`0co`0063?o00030000oooooooo
07?oool007Coool00ol0VOooooooo`0Hoooo00<0000co`0co`005c?o00030000oooooooo07Coool0
07Coool00ol0VOooooooo`0Hoooo00<0000co`0co`005c?o00030000oooooooo07Coool007Coool0
0ol0VOooooooo`0@oooo1@0000?oool00`0003?o03?o000F<ol000<0003oooooool0MOooo`00M?oo
o`03o`2Ioooooooo01;oool00`000?ooooooo`03oooo00<0000co`0co`005S?o00030000oooooooo
07Goool007Coool00ol0VOooooooo`0Boooo00<0003oooooool00oooo`<0000E<ol000<0003ooooo
ool0M_ooo`00M?ooo`03o`2Ioooooooo01;oool00`000?ooooooo`03oooo00<0000co`0co`005C?o
00030000oooooooo07Koool007Coool00ol0VOooooooo`0Boooo00<0003oooooool00oooo`030000
<ol0<ol001Dco`000`000?ooooooo`1foooo001doooo00?o09Woooooool04Oooo`800005oooo00<0
000co`0co`0053?o00030000oooooooo07Ooool007Coool00ol0VOooooooo`0Hoooo00<0000co`0c
o`0053?o00030000oooooooo07Ooool007Coool00ol0VOooooooo`0Hoooo00<0000co`0co`004c?o
00030000oooooooo07Soool007Coool00ol0VOooooooo`0Hoooo0P0001@co`000`000?ooooooo`1h
oooo001doooo00?o09Woooooool06?ooo`030000<ol0<ol001<co`000`000?ooooooo`1hoooo001d
oooo00?o09Woooooool06?ooo`030000<ol0<ol0018co`000`000?ooooooo`1ioooo001doooo00?o
09Woooooool06?ooo`030000<ol0<ol0018co`000`000?ooooooo`1ioooo001doooo00?o09Wooooo
ool06?ooo`030000<ol0<ol0018co`000`000?ooooooo`1ioooo001doooo00?o09Woooooool06?oo
o`030000<ol0<ol0014co`000`000?ooooooo`1joooo001doooo00?o09Woooooool06?ooo`80000B
<ol000<0003oooooool0N_ooo`00M?ooo`03o`2Ioooooooo01Soool00`0003?o03?o000A<ol000<0
003oooooool0N_ooo`00M?ooo`03o`2Ioooooooo01Soool00`0003?o03?o000A<ol000<0003ooooo
ool0N_ooo`00M?ooo`03o`2Ioooooooo01Soool00`0003?o03?o000@<ol000<0003oooooool0Nooo
o`00M?ooo`03o`2Ioooooooo01Soool00`0003?o03?o000@<ol000<0003oooooool0Noooo`00M?oo
o`03o`2Ioooooooo01Soool00`0003?o03?o000@<ol000<0003oooooool0Noooo`00M?ooo`03o`2I
oooooooo01Soool00`0003?o03?o000@<ol000<0003oooooool0Noooo`00M?ooo`03o`2Ioooooooo
01Soool2000043?o00030000oooooooo07coool007Coool00ol0VOooooooo`0Hoooo00<0000co`0c
o`003c?o00030000oooooooo07coool007Coool00ol0VOooooooo`0Hoooo00<0000co`0co`003c?o
00030000oooooooo07coool007Coool00ol0VOooooooo`0Hoooo00<0000co`0co`003c?o00030000
oooooooo07coool007Coool00ol0VOooooooo`0Hoooo00<0000co`0co`003c?o00030000oooooooo
07coool007Coool00ol0VOooooooo`0Hoooo00<0000co`0co`003S?o00030000oooooooo07goool0
07Coool00ol0VOooooooo`0Hoooo0P0000lco`000`000?ooooooo`1moooo001doooo00?o09Wooooo
ool06?ooo`030000<ol0<ol000hco`000`000?ooooooo`1moooo001doooo00?o09Woooooool06?oo
o`030000<ol0<ol000hco`000`000?ooooooo`1moooo001doooo00?o09Woooooool06?ooo`030000
<ol0<ol000dco`000`000?ooooooo`1noooo001doooo00?o09Woooooool04?ooo`@00004oooo00<0
000co`0co`003C?o00030000oooooooo07koool007Coool00ol0VOooooooo`0@oooo00<0003ooooo
ool01Oooo`030000<ol0<ol000dco`000`000?ooooooo`1noooo001doooo00?o09Woooooool04Ooo
o`030000oooooooo00Coool300003C?o00030000oooooooo07koool007Coool00ol0VOooooooo`0B
oooo00<0003oooooool00oooo`030000<ol0<ol000dco`000`000?ooooooo`1noooo001doooo00?o
09Woooooool04?ooo`040000oooooooo00001?ooo`030000<ol0<ol000`co`000`000?ooooooo`1o
oooo001doooo00?o09Woooooool04Oooo`800005oooo00<0000co`0co`0033?o00030000oooooooo
07ooool007Coool00ol0VOooooooo`0Hoooo00<0000co`0co`0033?o00030000oooooooo07ooool0
07Coool00ol0VOooooooo`0Hoooo00<0000co`0co`0033?o00030000oooooooo07ooool007Coool0
0ol0VOooooooo`0Hoooo0P0000dco`000`000?ooooooo`1ooooo001doooo00?o09Woooooool06?oo
o`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001doooo00?o09Woooooool06?ooo`030000
<ol0<ol000/co`000`000?ooooooo`20oooo001doooo00?o09Woooooool06?ooo`030000<ol0<ol0
00/co`000`000?ooooooo`20oooo001doooo00?o09Woooooool06?ooo`030000<ol0<ol000/co`00
0`000?ooooooo`20oooo001doooo00?o09Woooooool06?ooo`030000<ol0<ol000/co`000`000?oo
ooooo`20oooo001doooo00?o09Woooooool06?ooo`030000<ol0<ol000/co`000`000?ooooooo`20
oooo001doooo00?o09Woooooool06?ooo`80000<<ol000<0003oooooool0P?ooo`00M?ooo`03o`2I
oooooooo01Soool00`0003?o03?o000;<ol000<0003oooooool0P?ooo`00M?ooo`03o`2Ioooooooo
01Soool00`0003?o03?o000:<ol000<0003oooooool0POooo`00M?ooo`03o`2Ioooooooo01Soool0
0`0003?o03?o000:<ol000<0003oooooool0POooo`00M?ooo`03o`2Ioooooooo01Soool00`0003?o
03?o000:<ol000<0003oooooool0POooo`00M?ooo`03o`2Ioooooooo01Soool00`0003?o03?o000:
<ol000<0003oooooool0POooo`00M?ooo`03o`2Ioooooooo01Soool200002c?o00030000oooooooo
087oool007Coool00ol0VOooooooo`0Hoooo00<0000co`0co`002S?o00030000oooooooo087oool0
07Coool00ol0VOooooooo`0Hoooo00<0000co`0co`002S?o00030000oooooooo087oool007Coool0
0ol0VOooooooo`0Hoooo00<0000co`0co`002C?o00030000oooooooo08;oool007Coool00ol0VOoo
ooooo`0Hoooo00<0000co`0co`002C?o00030000oooooooo08;oool007Coool00ol0VOooooooo`0H
oooo00<0000co`0co`002C?o00030000oooooooo08;oool007Coool00ol0VOooooooo`0Hoooo0P00
00Xco`000`000?ooooooo`22oooo001doooo00?o09Woooooool06?ooo`030000<ol0<ol000Tco`00
0`000?ooooooo`22oooo001doooo00?o09Woooooool06?ooo`030000<ol0<ol000Tco`000`000?oo
ooooo`22oooo001doooo00?o09Woooooool06?ooo`030000<ol0<ol000Pco`000`000?ooooooo`23
oooo001doooo00?o09Woooooool04Oooo`800005oooo00<0000co`0co`0023?o00030000oooooooo
08?oool007Coool00ol0VOooooooo`0@oooo00@0003oooooool00004oooo00<0000co`0co`0023?o
00030000oooooooo08?oool007Coool00ol0VOooooooo`0Boooo00<0003oooooool00oooo`<00008
<ol000<0003oooooool0Poooo`00M?ooo`03o`2Ioooooooo01?oool00`000?ooooooo`02oooo00<0
000co`0co`0023?o00030000oooooooo08?oool007Coool00ol0VOooooooo`0@oooo00@0003ooooo
ool00004oooo00<0000co`0co`0023?o00030000oooooooo08?oool007Coool00ol0VOooooooo`0A
oooo0P0000Goool00`0003?o03?o0007<ol000<0003oooooool0Q?ooo`00M?ooo`03o`2Ioooooooo
01Soool00`0003?o03?o0007<ol000<0003oooooool0Q?ooo`00M?ooo`03o`2Ioooooooo01Soool0
0`0003?o03?o0007<ol000<0003oooooool0Q?ooo`00M?ooo`03o`2Ioooooooo01Soool00`0003?o
03?o0007<ol000<0003oooooool0Q?ooo`00M?ooo`03o`2Ioooooooo01Soool2000023?o00030000
oooooooo08Coool007Coool00ol0VOooooooo`0Hoooo00<0000co`0co`001c?o00030000oooooooo
08Coool007Coool00ol0VOooooooo`0Hoooo00<0000co`0co`001c?o00030000oooooooo08Coool0
07Coool00ol0VOooooooo`0Hoooo00<0000co`0co`001c?o00030000oooooooo08Coool007Coool0
0ol0VOooooooo`0Hoooo00<0000co`0co`001S?o00030000oooooooo08Goool007Coool00ol0VOoo
ooooo`0Hoooo00<0000co`0co`001S?o00030000oooooooo08Goool007Coool00ol0VOooooooo`0H
oooo0P0000Lco`000`000?ooooooo`25oooo001doooo00?o09Woooooool06?ooo`030000<ol0<ol0
00Hco`000`000?ooooooo`25oooo001doooo00?o09Woooooool06?ooo`030000<ol0<ol000Hco`00
0`000?ooooooo`25oooo001doooo00?o09Woooooool06?ooo`030000<ol0<ol000Hco`000`000?oo
ooooo`25oooo001doooo00?o09Woooooool06?ooo`030000<ol0<ol000Hco`000`000?ooooooo`25
oooo001doooo00?o09Woooooool06?ooo`030000<ol0<ol000Hco`000`000?ooooooo`25oooo001d
oooo00?o09Woooooool06?ooo`800006<ol000<0003oooooool0Q_ooo`00M?ooo`03o`2Ioooooooo
01Soool00`0003?o03?o0005<ol000<0003oooooool0Q_ooo`00M?ooo`03o`2Ioooooooo01Soool0
0`0003?o03?o0005<ol000<0003oooooool0Q_ooo`00M?ooo`03o`2Ioooooooo01Soool00`0003?o
03?o0005<ol000<0003oooooool0Q_ooo`00M?ooo`03o`2Ioooooooo01Soool00`0003?o03?o0005
<ol000<0003oooooool0Q_ooo`00M?ooo`03o`2Ioooooooo01Soool00`0003?o03?o0005<ol000<0
003oooooool0Q_ooo`00M?ooo`03o`2Ioooooooo01Soool200001S?o00030000oooooooo08Koool0
07Coool00ol0VOooooooo`0Hoooo00<0000co`0co`001C?o00030000oooooooo08Koool007Coool0
0ol0VOooooooo`0Hoooo00<0000co`0co`001C?o00030000oooooooo08Koool007Coool00ol0VOoo
ooooo`0Hoooo00<0000co`0co`0013?o00030000oooooooo08Ooool007Coool00ol0VOooooooo`0H
oooo00<0000co`0co`0013?o00030000oooooooo08Ooool007Coool00ol0VOooooooo`0Boooo0`00
00?oool00`0003?o03?o0004<ol000<0003oooooool0Qoooo`00M?ooo`03o`2Ioooooooo01?oool0
0`000?ooooooo`02oooo00<0000co`0co`0013?o00030000oooooooo08Ooool007Coool00ol0VOoo
ooooo`0@oooo1@0000?oool3000013?o00030000oooooooo08Ooool008Ooool010000?ooooooo`00
00Coool7<ol0R_ooo`00R?ooo`030000oooo000000Coool7<ol0R_ooo`00ROooo`800004oooo1c?o
08[oool008ooool7<ol0R_ooo`00Soooo`Lco`2:oooo001ioooo00<0003oooooool04oooo`Lco`0>
oooo00<0003oooooool0NOooo`00N?ooo`030000oooooooo00Soool00`000?ooooooo`09oooo1c?o
00ooool00`000?ooooooo`1hoooo001hoooo00<0003oooooool00_ooo`800004oooo00<0003ooooo
ool01oooo`800004<ol00P000004<ol0oooooooooooo0P0000?oool300001?ooo`030000oooooooo
07Soool007Soool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo
00Goool010000?ooooooo`0000Hco`02oooo00@0003oooooool00002oooo00@0003oooooool00003
oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo00;oool00`000?ooooooo`0=oooo00@0
003oooooool00006<ol01Oooo`040000oooooooo00000_ooo`030000oooooooo00;oool00`000?oo
ooooo`1goooo001hoooo00<0003oooooool01@0000coool010000?ooooooo`0000Hco`03oooo0P00
00?oool300001?ooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`00000?oooo00@0
003oooooool00006<ol00oooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003ooooo
ool0N?ooo`00NOooo`030000oooooooo017oool200001c?o00?oool300000oooo`<00002oooo00<0
003oooooool0NOooo`00Soooo`Lco`2:oooo002?oooo1c?o08[oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-2.37649, \
-1.14361, 0.0165645, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-2.37649, -1.14361, 0.0165645, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.58) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
.2 1 0 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
.50085 1.09152 L
.50154 1.07509 L
.50226 1.0581 L
.50471 1.00308 L
.5095 .9065 L
.51896 .75038 L
.52891 .6239 L
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50022 .61803 L
s
.52952 .61803 m
.53984 .51743 L
.55004 .44049 L
.55935 .38459 L
.57021 .33253 L
.58026 .29419 L
.59935 .24044 L
.60941 .21955 L
.62011 .20155 L
.62948 .18864 L
.63958 .17716 L
.65786 .16136 L
.66743 .15507 L
.6779 .1494 L
.68895 .14452 L
.699 .1409 L
.71861 .13555 L
.72939 .13335 L
.73956 .13165 L
.74928 .1303 L
.75957 .12912 L
.77803 .12751 L
.78746 .12687 L
.7976 .1263 L
.81591 .12552 L
.82604 .12519 L
.83709 .12489 L
.84764 .12466 L
.85719 .12449 L
.8769 .12421 L
.88772 .1241 L
.89789 .12402 L
.90768 .12395 L
.91801 .12389 L
.93649 .12381 L
.94599 .12377 L
.95617 .12374 L
.97451 .1237 L
.97619 .1237 L
s
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.36136 .12361 L
.37176 .12361 L
.3815 .12361 L
.39106 .12361 L
.39381 .12361 L
.39642 .12361 L
.39756 .12361 L
.39877 .12361 L
.39947 .12361 L
s
.39947 .12361 m
.39972 .61803 L
s
0 .4 1 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.49955 .12361 L
.53984 .12361 L
.57861 .12361 L
.61984 .12361 L
.65954 .12361 L
.69774 .12361 L
.73838 .12361 L
.77751 .12361 L
.81909 .12361 L
.85916 .12361 L
.89771 .12361 L
.93871 .12361 L
.97619 .12361 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.123607 0.123607 [
[.02381 .11111 -6 -9 ]
[.02381 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.97619 .11111 -3 -9 ]
[.97619 .11111 3 0 ]
[.4875 0 -12 -4.5 ]
[.4875 0 0 4.5 ]
[.4875 .24721 -6 -4.5 ]
[.4875 .24721 0 4.5 ]
[.4875 .37082 -6 -4.5 ]
[.4875 .37082 0 4.5 ]
[.4875 .49443 -6 -4.5 ]
[.4875 .49443 0 4.5 ]
[.4875 .61803 -6 -4.5 ]
[.4875 .61803 0 4.5 ]
[.5 .63053 -27.7813 0 ]
[.5 .63053 27.7813 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .12361 m
.02381 .12986 L
s
[(-2)] .02381 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-1)] .2619 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(1)] .7381 .11111 0 1 Mshowa
.97619 .12361 m
.97619 .12986 L
s
[(2)] .97619 .11111 0 1 Mshowa
.125 Mabswid
.07143 .12361 m
.07143 .12736 L
s
.11905 .12361 m
.11905 .12736 L
s
.16667 .12361 m
.16667 .12736 L
s
.21429 .12361 m
.21429 .12736 L
s
.30952 .12361 m
.30952 .12736 L
s
.35714 .12361 m
.35714 .12736 L
s
.40476 .12361 m
.40476 .12736 L
s
.45238 .12361 m
.45238 .12736 L
s
.54762 .12361 m
.54762 .12736 L
s
.59524 .12361 m
.59524 .12736 L
s
.64286 .12361 m
.64286 .12736 L
s
.69048 .12361 m
.69048 .12736 L
s
.78571 .12361 m
.78571 .12736 L
s
.83333 .12361 m
.83333 .12736 L
s
.88095 .12361 m
.88095 .12736 L
s
.92857 .12361 m
.92857 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.5 0 m
.50625 0 L
s
[(-1)] .4875 0 1 0 Mshowa
.5 .24721 m
.50625 .24721 L
s
[(1)] .4875 .24721 1 0 Mshowa
.5 .37082 m
.50625 .37082 L
s
[(2)] .4875 .37082 1 0 Mshowa
.5 .49443 m
.50625 .49443 L
s
[(3)] .4875 .49443 1 0 Mshowa
.5 .61803 m
.50625 .61803 L
s
[(4)] .4875 .61803 1 0 Mshowa
.125 Mabswid
.5 .02472 m
.50375 .02472 L
s
.5 .04944 m
.50375 .04944 L
s
.5 .07416 m
.50375 .07416 L
s
.5 .09889 m
.50375 .09889 L
s
.5 .14833 m
.50375 .14833 L
s
.5 .17305 m
.50375 .17305 L
s
.5 .19777 m
.50375 .19777 L
s
.5 .22249 m
.50375 .22249 L
s
.5 .27193 m
.50375 .27193 L
s
.5 .29666 m
.50375 .29666 L
s
.5 .32138 m
.50375 .32138 L
s
.5 .3461 m
.50375 .3461 L
s
.5 .39554 m
.50375 .39554 L
s
.5 .42026 m
.50375 .42026 L
s
.5 .44498 m
.50375 .44498 L
s
.5 .46971 m
.50375 .46971 L
s
.5 .51915 m
.50375 .51915 L
s
.5 .54387 m
.50375 .54387 L
s
.5 .56859 m
.50375 .56859 L
s
.5 .59331 m
.50375 .59331 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -88.7813 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.58) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
108.563 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo0027oooo1@0009Coool008Woool00`000?ooooooo`2Doooo0029oooo00<0003ooooo
ool00oooo`<0002>oooo0021oooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0S_oo
o`00ROooo`030000oooooooo00?oool00`000?ooooooo`2>oooo0028oooo0P0000Goool00`000?oo
ooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool2
0000Soooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0
003oooooool0S_ooo`00Soooo`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?
oooo00<0003oooooool0S_ooo`00Soooo`80002?oooo002?oooo00<0003oooooool0S_ooo`00Sooo
o`030000oooooooo08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_oo
o`00Soooo`030000oooooooo08koool008ooool20000Soooo`005oooo`@0000ioooo1@0003Koool0
0`000?ooooooo`0goooo1@0003Soool400005_ooo`005oooo`030000oooooooo03coool00`000?oo
ooooo`0foooo00<0003oooooool0>Oooo`030000oooooooo03Soool00`000?ooooooo`0Goooo000H
oooo00<0003oooooool0>oooo`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003ooooo
ool0>Oooo`030000oooooooo01Koool0017oool400001?ooo`030000oooooooo03;oool400001?oo
o`030000oooooooo03Koool00`000?ooooooo`0ioooo00<0003oooooool0>_ooo`030000oooooooo
01Goool001Ooool010000?ooooooo`0003_oool00`000?ooooooo`0foooo00<0003oooooool0>Ooo
o`030000oooooooo03Soool010000?ooooooo`0001Koool001Soool20000>oooo`80000hoooo0P00
03Woool20000>oooo`80000Goooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000oooooooo
08koool008ooool00`000?ooooooo`2>oooo002?oooo00<0003oooooool0S_ooo`00Soooo`030000
oooooooo08koool0013ooooo00004Oooo`005_ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`09oooo00<0003ooooo
ool02Oooo`030000oooooooo00Woool00`000?ooooooo`07oooo00?o09Woool000002oooo`030000
oooooooo00Woool00`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Tco`00
0`0003?o03?o0009<ol000<0000co`0co`002C?o00030000<ol0<ol000Hco`0R00001_ooo`030000
oooooooo00Woool00`000?ooooooo`0Eoooo000Foooo00<0003oooooool0>_ooo`030000oooooooo
01ooool00ol0VOooooooo`0Goooo00<0000co`0co`00>C?o00T0000doooo00<0003oooooool05Ooo
o`00MOooo`03o`2Ioooooooo01Ooool00`0003?o03?o000c<ol01P0005Goool007Goool00ol0VOoo
ooooo`0Goooo00<0000co`0co`00<C?o0080001Koooo001eoooo00?o09Woooooool05oooo`030000
<ol0<ol002lco`020000GOooo`00MOooo`03o`2Ioooooooo01Ooool00`0003?o03?o000/<ol00`00
05ooool007Goool00ol0VOooooooo`0Goooo0P0002Xco`030000H_ooo`00MOooo`03o`2Ioooooooo
01Ooool00`0003?o03?o000W<ol00P0006Goool007Goool00ol0VOooooooo`0Goooo00<0000co`0c
o`009S?o00030000oooooooo06Goool007Goool00ol0VOooooooo`0Goooo00<0000co`0co`009C?o
00030000oooooooo06Koool007Goool00ol0VOooooooo`0Goooo00<0000co`0co`0093?o00030000
oooooooo06Ooool007Goool00ol0VOooooooo`0Goooo00<0000co`0co`008S?o0080001Zoooo001e
oooo00?o09Woooooool05oooo`80000R<ol000<0003oooooool0J_ooo`00MOooo`03o`2Ioooooooo
01Ooool00`0003?o03?o000P<ol000<0003oooooool0Joooo`00MOooo`03o`2Ioooooooo01Ooool0
0`0003?o03?o000O<ol000<0003oooooool0K?ooo`00MOooo`03o`2Ioooooooo01Ooool00`0003?o
03?o000O<ol000<0003oooooool0K?ooo`00MOooo`03o`2Ioooooooo01Ooool00`0003?o03?o000N
<ol000<0003oooooool0KOooo`00MOooo`03o`2Ioooooooo01Ooool00`0003?o03?o000M<ol000<0
003oooooool0K_ooo`00MOooo`03o`2Ioooooooo01Ooool200007C?o00030000oooooooo06ooool0
07Goool00ol0VOooooooo`0Goooo00<0000co`0co`006c?o00030000oooooooo073oool007Goool0
0ol0VOooooooo`0Goooo00<0000co`0co`006c?o00030000oooooooo073oool007Goool00ol0VOoo
ooooo`0Goooo00<0000co`0co`006S?o00030000oooooooo077oool007Goool00ol0VOooooooo`0G
oooo00<0000co`0co`006S?o00030000oooooooo077oool007Goool00ol0VOooooooo`0Goooo00<0
000co`0co`006C?o00030000oooooooo07;oool007Goool00ol0VOooooooo`0Goooo0P0001Xco`00
0`000?ooooooo`1boooo001eoooo00?o09Woooooool05oooo`030000<ol0<ol001Pco`000`000?oo
ooooo`1coooo001eoooo00?o09Woooooool05oooo`030000<ol0<ol001Pco`000`000?ooooooo`1c
oooo001eoooo00?o09Woooooool05oooo`030000<ol0<ol001Lco`000`000?ooooooo`1doooo001e
oooo00?o09Woooooool05oooo`030000<ol0<ol001Lco`000`000?ooooooo`1doooo001eoooo00?o
09Woooooool03oooo`D00003oooo00<0000co`0co`005S?o00030000oooooooo07Goool007Goool0
0ol0VOooooooo`0Aoooo00<0003oooooool00oooo`030000<ol0<ol001Hco`000`000?ooooooo`1e
oooo001eoooo00?o09Woooooool04Oooo`030000oooooooo00?oool300005C?o00030000oooooooo
07Koool007Goool00ol0VOooooooo`0Aoooo00<0003oooooool00oooo`030000<ol0<ol001Dco`00
0`000?ooooooo`1foooo001eoooo00?o09Woooooool04Oooo`030000oooooooo00?oool00`0003?o
03?o000E<ol000<0003oooooool0M_ooo`00MOooo`03o`2Ioooooooo013oool200001Oooo`030000
<ol0<ol001@co`000`000?ooooooo`1goooo001eoooo00?o09Woooooool05oooo`030000<ol0<ol0
01@co`000`000?ooooooo`1goooo001eoooo00?o09Woooooool05oooo`030000<ol0<ol001<co`00
0`000?ooooooo`1hoooo001eoooo00?o09Woooooool05oooo`80000D<ol000<0003oooooool0N?oo
o`00MOooo`03o`2Ioooooooo01Ooool00`0003?o03?o000C<ol000<0003oooooool0N?ooo`00MOoo
o`03o`2Ioooooooo01Ooool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00MOooo`03o`2I
oooooooo01Ooool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00MOooo`03o`2Ioooooooo
01Ooool00`0003?o03?o000B<ol000<0003oooooool0NOooo`00MOooo`03o`2Ioooooooo01Ooool0
0`0003?o03?o000A<ol000<0003oooooool0N_ooo`00MOooo`03o`2Ioooooooo01Ooool200004S?o
00030000oooooooo07[oool007Goool00ol0VOooooooo`0Goooo00<0000co`0co`004C?o00030000
oooooooo07[oool007Goool00ol0VOooooooo`0Goooo00<0000co`0co`004C?o00030000oooooooo
07[oool007Goool00ol0VOooooooo`0Goooo00<0000co`0co`0043?o00030000oooooooo07_oool0
07Goool00ol0VOooooooo`0Goooo00<0000co`0co`0043?o00030000oooooooo07_oool007Goool0
0ol0VOooooooo`0Goooo00<0000co`0co`0043?o00030000oooooooo07_oool007Goool00ol0VOoo
ooooo`0Goooo00<0000co`0co`0043?o00030000oooooooo07_oool007Goool00ol0VOooooooo`0G
oooo0P00010co`000`000?ooooooo`1loooo001eoooo00?o09Woooooool05oooo`030000<ol0<ol0
00lco`000`000?ooooooo`1loooo001eoooo00?o09Woooooool05oooo`030000<ol0<ol000lco`00
0`000?ooooooo`1loooo001eoooo00?o09Woooooool05oooo`030000<ol0<ol000lco`000`000?oo
ooooo`1loooo001eoooo00?o09Woooooool05oooo`030000<ol0<ol000lco`000`000?ooooooo`1l
oooo001eoooo00?o09Woooooool05oooo`030000<ol0<ol000hco`000`000?ooooooo`1moooo001e
oooo00?o09Woooooool05oooo`80000?<ol000<0003oooooool0OOooo`00MOooo`03o`2Ioooooooo
01Ooool00`0003?o03?o000><ol000<0003oooooool0OOooo`00MOooo`03o`2Ioooooooo01Ooool0
0`0003?o03?o000><ol000<0003oooooool0OOooo`00MOooo`03o`2Ioooooooo01Ooool00`0003?o
03?o000=<ol000<0003oooooool0O_ooo`00MOooo`03o`2Ioooooooo00ooool400001?ooo`030000
<ol0<ol000dco`000`000?ooooooo`1noooo001eoooo00?o09Woooooool03oooo`030000oooooooo
00Goool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00MOooo`03o`2Ioooooooo013oool0
0`000?ooooooo`04oooo0`0000dco`000`000?ooooooo`1noooo001foooo00?o09Woooooool04?oo
o`030000oooooooo00?oool00`0003?o03?o000=<ol000<0003oooooool0O_ooo`00M_ooo`03o`2I
oooooooo00koool010000?ooooooo`0000Coool00`0003?o03?o000<<ol000<0003oooooool0Oooo
o`00M_ooo`03o`2Ioooooooo00ooool200001Oooo`030000<ol0<ol000`co`000`000?ooooooo`1o
oooo001foooo00?o09Woooooool05_ooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001f
oooo00?o09Woooooool05_ooo`030000<ol0<ol000`co`000`000?ooooooo`1ooooo001foooo00?o
09Woooooool05_ooo`80000=<ol000<0003oooooool0Ooooo`00M_ooo`03o`2Ioooooooo01Koool0
0`0003?o03?o000<<ol000<0003oooooool0Ooooo`00M_ooo`03o`2Ioooooooo01Koool00`0003?o
03?o000;<ol000<0003oooooool0P?ooo`00M_ooo`03o`2Ioooooooo01Koool00`0003?o03?o000;
<ol000<0003oooooool0P?ooo`00M_ooo`03o`2Ioooooooo01Koool00`0003?o03?o000;<ol000<0
003oooooool0P?ooo`00M_ooo`03o`2Ioooooooo01Koool00`0003?o03?o000;<ol000<0003ooooo
ool0P?ooo`00M_ooo`03o`2Ioooooooo01Koool00`0003?o03?o000;<ol000<0003oooooool0P?