(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   3928840,     165386]*)
(*NotebookOutlinePosition[   3929583,     165411]*)
(*  CellTagsIndexPosition[   3929539,     165407]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["FOCUSING", "Text",
    FontSize->14,
    Background->None],
  StyleBox[" BEHIND NONHOMOGENEITY", "Text",
    FontSize->14,
    Background->None]
}], "Title",
  CellFrame->True,
  Background->GrayLevel[0.849989]],

Cell[TextData[{
  StyleBox["The wavefront  and the tail  are incident from the left.\n\nThe \
nonhomogeneity  ",
    FontSize->12],
  StyleBox["is located on the negative ",
    FontSize->12,
    CharacterEncoding->"WindowsANSI"],
  StyleBox["x",
    FontSize->12,
    FontSlant->"Italic",
    CharacterEncoding->"WindowsANSI"],
  StyleBox["-axis.",
    FontSize->12,
    CharacterEncoding->"WindowsANSI"],
  StyleBox["  \n\nThe focusing location,  ",
    FontSize->12],
  StyleBox["x0",
    FontSize->12,
    FontVariations->{"CompatibilityType"->0},
    CharacterEncoding->"WindowsANSI"],
  StyleBox[" >0, is behind the nonhomogeneity and needs to be specified. \n\n\
The potential   v[x], which is ",
    FontSize->12],
  StyleBox["the nonhomogeneity, is strictly positive.  \n\nThe transmission \
coefficient, left reflection coefficient, and right reflection coefficient, \
respectively, are denoted by  T[k],  L[k],  R[k].\n\nThe tail of the wave is \
denoted by  g[x,t].\n\nThe focusing moment is chosen as  t=0.",
    FontSize->12,
    CharacterEncoding->"WindowsANSI"]
}], "Text",
  FontSize->18,
  Background->RGBColor[1, 1, 0]],

Cell["\<\
The potential and the scattering coefficients are given next:\
\>", \
"Text",
  Background->RGBColor[1, 1, 0]],

Cell[BoxData[{
    \(Clear[v, T, L, R, x0, g]; 
    v[x_] = UnitStep[\(-x\)]\ 16 \((Sqrt[2] + 
              1)\)^2\ E^\((\(-2\)\ Sqrt[
                  2]\ x)\)/\((\((1 + 
                        Sqrt[2])\)^2\ \ E^\((\(-2\)\ Sqrt[2]\ x)\) - 
                1)\)^2;\ \), "\[IndentingNewLine]", 
    \(\(T[k_] = k \((k + I\ Sqrt[2])\)/\((k + I)\)^2;\)\), "\n", 
    \(\(L[
          k_] = \(-2\) \((k + 
                I\ Sqrt[2])\)/\((\((k + I)\)^2\ \((k - 
                    I\ Sqrt[2])\))\);\)\), "\n", 
    \(\(R[k_] = 1/\((k + I)\)^2;\)\)}], "Input",
  CellOpen->False],

Cell["\<\
Specify the focusing location  x0, a nonnegative number, \
next:\
\>", "Text",
  Background->RGBColor[1, 1, 0]],

Cell[BoxData[
    \(\(\(x0 = 1;\)\(\ \)\)\)], "Input"],

Cell["The tail  g[x,t]  of the focusing  wave is evaluated  next:", "Text",
  Background->RGBColor[1, 1, 0]],

Cell[BoxData[{
    \(\(q[x_] = 
        2\ Sqrt[2]/\((\((1 + Sqrt[2])\)^2\ \ E^\((\(-2\)\ Sqrt[2]\ x)\) - 
                1)\);\)\n\t\t\), "\n", 
    \(\(q16[x_, t_] = \ 
        q[x]\ \((1 + 
                Sqrt[2])\)^2\ \ E^\((\(-\ Sqrt[2]\)\ \ \((x - x0 - t)\))\)/
            4;\)\n\t\), "\n", 
    \(\t\(q17[x_, 
          t_] = \((1 + q[x]/Sqrt[2])\)/
            Sqrt[2] - \((\(-1\) + Sqrt[2])\)^2\ \((1 + 
                q[x]/\((2\ Sqrt[2])\))\) 
            E^\((Sqrt[2]\ \ \((x - x0 - t)\))\)/Sqrt[2];\)\n\), "\n", 
    \(\(\(q18[x_, t_] = \(-q[x]\) 
          E^\((\(-\ Sqrt[2]\)\ \ \((x + x0 - t)\))\)/4;\)\(\n\)
    \)\), "\n", 
    \(\(q19[x_, 
          t_] = \(-\((1 + q[x]/Sqrt[2])\)\)/
            Sqrt[2] + \((1 + q[x]/\((2\ Sqrt[2])\))\) 
            E^\((Sqrt[2]\ \ \((x + x0 - t)\))\)/Sqrt[2];\)\n\t\t\t\), "\n", 
    \(\t\t\t\(q20[x_, t_] = 
        q[x]\ \ \ E^\((\(-\ Sqrt[2]\)\ \ \((x + x0 + t)\))\)/
            4;\)\n\t\t\t\t\t\), "\n", 
    \(\t\t\(q21[x_, 
          t_] = \((1 + q[x]/Sqrt[2])\)/
            Sqrt[2] - \((1 + q[x]/\((2\ Sqrt[2])\))\) 
            E^\((Sqrt[2]\ \ \((x + x0 + t)\))\)/
              Sqrt[2];\)\n\t\t\t\n\t\), "\n", 
    \(\t\(q22[x_, 
          t_] = \(-\((1 + q[x]/Sqrt[2])\)\)/
            Sqrt[2]\ \  + \((Sqrt[2] - 1)\)^2\ \((1 + 
                q[x]/\((2\ Sqrt[2])\))\) 
            E^\((\(-Sqrt[2]\)\ \ \((\(-x\) + x0 - t)\))\)/
              Sqrt[2];\)\n\), "\n", 
    \(\(\(q23[x_, 
          t_] = \ \(-q[
              x]\)\ \ \((Sqrt[2] + 1)\)^2\ \ E^\((\ 
                Sqrt[2]\ \ \((\(-x\) + x0 - t)\))\)/4;\)\(\n\)
    \)\), "\n", 
    \(\(q24[x_, 
          t_] = \((q[x] - 2 + 
              Sqrt[2] + \((\(-x\) + x0 - 
                    t)\)\ \((1 + q[x]\ \((Sqrt[2] + 1)\))\)/\((Sqrt[2] + 
                      1)\))\)\ E^\((\(-x\) + x0 - t)\);\)\), "\n", 
    \(\(g[x_, t_] = \ 
        UnitStep[
              x]\ \((x + x0 - t)\)\ \ E^\((x + x0 - t)\)\ UnitStep[\(-x\) - 
                x0 + t]\  + 
          UnitStep[\(-x\)] \((q16[x, t]\ \n\t\tUnitStep[x - x0 - t]\  + \ 
                q17[x, t]\ UnitStep[\(-x\) + x0 + t]\  + 
                q18[x, t]\ UnitStep[x + x0 - t]\n + 
                q19[x, t]\ UnitStep[\(-x\) - x0 + t]\  + \ 
                q20[x, t]\ UnitStep[x + x0 + t] + 
                q21[x, t]\ UnitStep[\(-x\) - x0 - t] + 
                q22[x, t]\ UnitStep[\(-x\) + x0 - t] + \((q23[x, t]\  + 
                      q24[x, t])\)\ UnitStep[x - x0 + t])\);\)\)}], "Input",
  CellOpen->False],

Cell[BoxData[
    \(<< Graphics`Animation`\)], "Input",
  CellOpen->False],

Cell[BoxData[
    \(<< Graphics`FilledPlot`\)], "Input",
  CellOpen->False],

Cell[TextData[{
  "The focusing wave is animated  next. The wavefront (",
  StyleBox["magenta",
    FontColor->RGBColor[1, 0, 1]],
  ") and the tail (",
  StyleBox["blue",
    FontColor->RGBColor[0, 0, 1]],
  ") are incident from the left onto the nonhomogeneity (",
  StyleBox["green",
    FontColor->RGBColor[0, 1, 0]],
  "):"
}], "Text",
  Background->RGBColor[1, 1, 0]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Animate[{FilledPlot\[IndentingNewLine][{v[x]}, \ {x, \ \(-7\), \ 
              5}, \ PlotRange -> {\(-1\), 4}, \ 
            Fills \[Rule] {Hue[ .3]}], \[IndentingNewLine]\ \ \ \ \ \ \ \
Plot[{10\ UnitStep[x - x0 - t]}, \ {x, \ \(-7\), \ 5}, \ 
            PlotStyle \[Rule] \ Hue[ .9], 
            PlotRange -> {\(-1\), 
                4}], \[IndentingNewLine]\ \ \ \ \ \ \ Plot[{g[x, 
                t]}, {x, \ \(-7\), \ 5}, \ PlotStyle \[Rule] \ Hue[ .6], \ 
            PlotRange -> {\(-1\), 4}]}, \[IndentingNewLine]\ {t, \ \(-5\), \ 
          3.8,  .1}, PlotLabel \[Rule] {"\<t\>", t}];\)\)], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -22.0938 0 ]
[.5 .63053 22.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -83.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
97.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
.2 1 0 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.24141 .12361 L
.25127 .12361 L
.25666 .12361 L
.2593 .12361 L
.26045 .12361 L
.26171 .12361 L
s
.26171 .12361 m
.26223 .61803 L
s
0 .4 1 r
.02381 .14464 m
.04262 .15301 L
.06244 .16548 L
.07286 .17401 L
.08255 .18352 L
.09388 .19691 L
.09944 .20456 L
.10189 .20816 L
.10256 .20918 L
.10328 .21012 L
.10458 .2101 L
.10933 .21002 L
.11437 .20993 L
.125 .2097 L
.14357 .20919 L
.15368 .20883 L
.16471 .20836 L
.17524 .20781 L
.1848 .20721 L
.20447 .20562 L
.21527 .20448 L
.22544 .20318 L
.23521 .20169 L
.24552 .19981 L
.25433 .19791 L
.25674 .19733 L
.25933 .19669 L
.26058 .19636 L
.26177 .19605 L
.26283 .12361 L
.26399 .12361 L
.26521 .12361 L
.26633 .12361 L
.26755 .12361 L
.26884 .12361 L
.26997 .12361 L
.27101 .12361 L
.27216 .12361 L
.27339 .12361 L
.27409 .12361 L
.27473 .12361 L
.27544 .12361 L
.27619 .12361 L
.27745 .12361 L
.27816 .12361 L
.27883 .12361 L
.27997 .12361 L
.28119 .12361 L
.28189 .12361 L
.28253 .12361 L
Mistroke
.28377 .12361 L
.28444 .12361 L
.28517 .12361 L
.28648 .12361 L
.28714 .12361 L
.28783 .12361 L
.28906 .12361 L
.29025 .12361 L
.29137 .12361 L
.29259 .12361 L
.2939 .12361 L
.29462 .12361 L
.2953 .12361 L
.29604 .12361 L
.29682 .12361 L
.29814 .12361 L
.29889 .12361 L
.29959 .12361 L
.30089 .12361 L
.30209 .12361 L
.3034 .12361 L
.30411 .12361 L
.30478 .12361 L
.30602 .12361 L
.30667 .12361 L
.30736 .12361 L
.30852 .12361 L
.30979 .12361 L
.31093 .12361 L
.31215 .12361 L
.3133 .12361 L
.31435 .12361 L
.31565 .12361 L
.31686 .12361 L
.31748 .12361 L
.31818 .12361 L
.31891 .12361 L
.31959 .12361 L
.32083 .12361 L
.32198 .12361 L
.32323 .12361 L
.32386 .12361 L
.32456 .12361 L
.3258 .12361 L
.32697 .12361 L
.32802 .12361 L
.32916 .12361 L
.3304 .12361 L
.33171 .12361 L
.33284 .12361 L
Mistroke
.33407 .12361 L
.33523 .12361 L
.33628 .12361 L
.3375 .12361 L
.33865 .12361 L
.33971 .12361 L
.3407 .12361 L
.34178 .12361 L
.34294 .12361 L
.34418 .12361 L
.34489 .12361 L
.34554 .12361 L
.34624 .12361 L
.34687 .12361 L
.34761 .12361 L
.3483 .12361 L
.34953 .12361 L
.35066 .12361 L
.35191 .12361 L
.35254 .12361 L
.35323 .12361 L
.35393 .12361 L
.35467 .12361 L
.356 .12361 L
.35673 .12361 L
.35742 .12361 L
.35817 .12361 L
.35897 .12361 L
.35967 .12361 L
.36043 .12361 L
.36114 .12361 L
.3618 .12361 L
.36304 .12361 L
.36372 .12361 L
.36436 .12361 L
.36562 .12361 L
.36678 .12361 L
.36786 .12361 L
.36903 .12361 L
.37032 .12361 L
.37104 .12361 L
.3717 .12361 L
.37297 .12361 L
.37417 .12361 L
.37543 .12361 L
.37607 .12361 L
.37677 .12361 L
.378 .12361 L
.37915 .12361 L
.37985 .12361 L
Mistroke
.38051 .12361 L
.38175 .12361 L
.38245 .12361 L
.38309 .12361 L
.38379 .12361 L
.38454 .12361 L
.38574 .12361 L
.38706 .12361 L
.3883 .12361 L
.38945 .12361 L
.39059 .12361 L
.39162 .12361 L
.39282 .12361 L
.39394 .12361 L
.39517 .12361 L
.39647 .12361 L
.39758 .12361 L
.3988 .12361 L
.40012 .12361 L
.40085 .12361 L
.40152 .12361 L
.40283 .12361 L
.40406 .12361 L
.40511 .12361 L
.40627 .12361 L
.40748 .12361 L
.40861 .12361 L
.40967 .12361 L
.41064 .12361 L
.41171 .12361 L
.41283 .12361 L
.41397 .12361 L
.41518 .12361 L
.41633 .12361 L
.41738 .12361 L
.41861 .12361 L
.4193 .12361 L
.41994 .12361 L
.42112 .12361 L
.42236 .12361 L
.42357 .12361 L
.42489 .12361 L
.42613 .12361 L
.42729 .12361 L
.42843 .12361 L
.42947 .12361 L
.4306 .12361 L
.43179 .12361 L
.4331 .12361 L
.4343 .12361 L
Mistroke
.43559 .12361 L
.43633 .12361 L
.43701 .12361 L
.43825 .12361 L
.43938 .12361 L
.44069 .12361 L
.44193 .12361 L
.44298 .12361 L
.44414 .12361 L
.44535 .12361 L
.44649 .12361 L
.44747 .12361 L
.44852 .12361 L
.44966 .12361 L
.4507 .12361 L
.45184 .12361 L
.45306 .12361 L
.45421 .12361 L
.45526 .12361 L
.45649 .12361 L
.45718 .12361 L
.45782 .12361 L
.45899 .12361 L
.46024 .12361 L
.46145 .12361 L
.46277 .12361 L
.46402 .12361 L
.46518 .12361 L
.46622 .12361 L
.46737 .12361 L
.46857 .12361 L
.46969 .12361 L
.47093 .12361 L
.47224 .12361 L
.47335 .12361 L
.47457 .12361 L
.47589 .12361 L
.47663 .12361 L
.4773 .12361 L
.47861 .12361 L
.47984 .12361 L
.4809 .12361 L
.48206 .12361 L
.48327 .12361 L
.48441 .12361 L
.48547 .12361 L
.48644 .12361 L
.48756 .12361 L
.48863 .12361 L
.48977 .12361 L
Mistroke
.49099 .12361 L
.49214 .12361 L
.49319 .12361 L
.49442 .12361 L
.49511 .12361 L
.49575 .12361 L
.49692 .12361 L
.49816 .12361 L
.49938 .12361 L
.50007 .12361 L
.50071 .12361 L
.50188 .12361 L
.50312 .12361 L
.50418 .12361 L
.5053 .12361 L
.50652 .12361 L
.50764 .12361 L
.50883 .12361 L
.51014 .12361 L
.51135 .12361 L
.51248 .12361 L
.51317 .12361 L
.51383 .12361 L
.51505 .12361 L
.51637 .12361 L
.51712 .12361 L
.51781 .12361 L
.51886 .12361 L
.52 .12361 L
.52107 .12361 L
.52205 .12361 L
.52319 .12361 L
.52444 .12361 L
.52562 .12361 L
.52671 .12361 L
.52795 .12361 L
.52911 .12361 L
.53015 .12361 L
.53128 .12361 L
.53251 .12361 L
.53381 .12361 L
.53493 .12361 L
.53614 .12361 L
.53745 .12361 L
.53866 .12361 L
.5393 .12361 L
.53999 .12361 L
.54072 .12361 L
.5414 .12361 L
.54265 .12361 L
Mistroke
.5438 .12361 L
.54512 .12361 L
.54638 .12361 L
.5475 .12361 L
.54869 .12361 L
.54981 .12361 L
.55083 .12361 L
.55203 .12361 L
.55334 .12361 L
.55456 .12361 L
.5557 .12361 L
.55691 .12361 L
.5582 .12361 L
.55943 .12361 L
.56055 .12361 L
.56185 .12361 L
.56259 .12361 L
.56328 .12361 L
.56454 .12361 L
.56517 .12361 L
.56587 .12361 L
.56655 .12361 L
.56726 .12361 L
.56854 .12361 L
.56925 .12361 L
.56991 .12361 L
.57064 .12361 L
.57142 .12361 L
.57209 .12361 L
.57282 .12361 L
.57351 .12361 L
.57415 .12361 L
.57535 .12361 L
.57663 .12361 L
.57783 .12361 L
.57915 .12361 L
.5804 .12361 L
.58155 .12361 L
.58605 .12361 L
.59618 .12361 L
.61449 .12361 L
.65365 .12361 L
.69526 .12361 L
.73535 .12361 L
.77393 .12361 L
.81496 .12361 L
.85447 .12361 L
.89247 .12361 L
.93293 .12361 L
.97186 .12361 L
Mistroke
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -22.0938 0 ]
[.5 .63053 22.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -83.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
97.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Koooo1@00083oool009goool00`000?ooooooo`20oooo002Moooo00<0003ooooo
ool00oooo`<0001joooo002Eoooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0N_oo
o`00WOooo`030000oooooooo00?oool00`000?ooooooo`1joooo002Loooo0P0000Goool00`000?oo
ooooo`1joooo002Soooo00<0003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool2
0000Noooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0
003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002S
oooo00<0003oooooool0N_ooo`00Xoooo`80001koooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool00:?oool20000Noooo`00:oooo`<0000Xoooo0`0002?oool4
00008oooo`030000oooooooo02?oool400009oooo`<0000Yoooo000[oooo00@0003oooooool0000X
oooo00<0003oooooool08_ooo`030000oooooooo02Coool00`000?ooooooo`0Soooo00<0003ooooo
ool0:Oooo`030000oooooooo02Soool002_oool010000?ooooooo`0002Goool500009?ooo`030000
oooooooo02?oool00`000?ooooooo`0Toooo00<0003oooooool09Oooo`D0000Yoooo000Uoooo1000
00;oool300008?ooo`@00002oooo00@0003oooooool0000Noooo100000Coool00`000?ooooooo`0R
oooo00<0003oooooool09Oooo`030000oooooooo02Coool010000?ooooooo`0002[oool002coool0
0`000?ooooooo`0Voooo00<0003oool000009?ooo`040000oooooooo00008oooo`030000oooooooo
02?oool010000?ooooooo`0002Koool00`000?ooo`00000Zoooo000/oooo0`0002Ooool200009Ooo
o`80000Toooo0P0002Goool20000:?ooo`80000Zoooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool0013ooooo00004Oooo`005_ooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooo0000010000000c?o000003?o0008<ol000<0000co`0co`001c?o00030000
<ol0<ol000Lco`000`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool05Oooo`00:_ooo`030000oooooooo02Koool00`000?ooooooo`0Uoooo00<0003oooooool01_oo
o`@0000K<ol000<0003oooooool09Oooo`030000oooooooo02Koool00`000?ooooooo`0Yoooo001C
oooo00<0I_ooooooool0<_ooo`@0000G<ol000<0003oooooool0N_ooo`00Doooo`0306Kooooooooo
03Koool00`0003?o03?o000D<ol000<0003oooooool0N_ooo`00Doooo`0306Kooooooooo03Ooool2
000053?o00030000oooooooo07[oool001Koool206Ko>oooo`0306Kooooooooo03Woool00`0003?o
03?o000A<ol000<0003oooooool0N_ooo`006?ooo`80I_lioooo00<0I_ooooooool0>_ooo`030000
<ol0<ol0010co`020000Noooo`006_ooo`80I_lgoooo00<0I_ooooooool0>oooo`80000@<ol000<0
003oooooool0N_ooo`007?ooo`80I_leoooo00<0I_ooooooool0?Oooo`030000<ol0<ol000dco`00
0`000?ooooooo`1joooo000Noooo0P1Voc?oool00`1Vooooooooo`0moooo00<0000co`0co`003C?o
00030000oooooooo07[oool0023oool00`1Vooooooooo`0`oooo00<0I_ooooooool0?_ooo`030000
<ol0<ol000`co`000`000?ooooooo`1joooo000Qoooo0P1Voc3oool00`1Vooooooooo`0noooo00<0
000co`0co`0033?o00030000oooooooo07[oool002?oool00`1Vooooooooo`0]oooo00<0I_oooooo
ool0?oooo`030000<ol0<ol000/co`020000Noooo`009?ooo`0306Kooooooooo02coool00`1Voooo
ooooo`0ooooo00<0000co`0co`002c?o00030000oooooooo07[oool002Coool00`1Vooooooooo`0/
oooo00<0I_ooooooool0@?ooo`030000<ol0<ol000Xco`000`000?ooooooo`1joooo000Uoooo00<0
I_ooooooool0:oooo`0306Kooooooooo043oool00`0003?o03?o000:<ol000<0003oooooool0N_oo
o`009_ooo`0306Kooooooooo02[oool00`1Vooooooooo`11oooo00<0000co`0co`002C?o00030000
oooooooo07[oool002Ooool00`1Vooooooooo`0Yoooo00<0I_ooooooool0@Oooo`030000<ol0<ol0
00Tco`000`000?ooooooo`1joooo000Xoooo00<0I_ooooooool09Oooo`@0I_m4oooo00<0000co`0c
o`0023?o0080001koooo000Xoooo00<0I_ooooooool08?ooo`D0I_l3oooo00?o09Woooooool0@_oo
o`030000<ol0<ol000Pco`000`000?ooooooo`1joooo000Yoooo00<0I_ooooooool05_ooo`T0I_l8
oooo00?o09Woooooool0@_ooo`030000<ol0<ol000Pco`000`000?ooooooo`1joooo000Zoooo601V
oa7oool00ol0VOooooooo`13oooo00<0000co`0co`001c?o00030000oooooooo07[oool005?oool0
0ol0VOooooooo`13oooo00<0000co`0co`001c?o00030000oooooooo07[oool005?oool00ol0VOoo
ooooo`13oooo00<0000co`0co`001c?o00030000oooooooo07[oool005?oool00ol0VOooooooo`13
oooo00<0000co`0co`001c?o0080001koooo001Coooo00?o09Woooooool0A?ooo`030000<ol0<ol0
00Hco`000`000?ooooooo`1joooo001Coooo00?o09Woooooool0A?ooo`030000<ol0<ol000Hco`00
0`000?ooooooo`1joooo001Coooo00?o09Woooooool0A?ooo`030000<ol0<ol000Hco`000`000?oo
ooooo`1joooo001Coooo00?o09Woooooool0A?ooo`030000<ol0<ol000Hco`000`000?ooooooo`1j
oooo001Coooo00?o09Woooooool0AOooo`D00003<ol000<0003oooooool0N_ooo`00Doooo`03o`2I
oooooooo04Goool00`0003?o00000005<ol000<0003oooooool0N_ooo`00Doooo`03o`2Ioooooooo
04Goool00`0003?o00000005<ol00`0007[oool005?oool00ol0VOooooooo`16oooo0P0000Dco`00
0`000?ooooooo`1joooo001Coooo00?o09Woooooool0A_ooo`800005<ol000<0003oooooool0N_oo
o`00Doooo`03o`2Ioooooooo04Koool200001C?o00030000oooooooo07[oool005?oool00ol0VOoo
ooooo`16oooo00<0000co`0co`0013?o00030000oooooooo07[oool005?oool00ol0VOooooooo`16
oooo00<0000co`0co`0013?o00030000oooooooo07[oool005?oool00ol0VOooooooo`16oooo00<0
000co`0co`0013?o0080001koooo001Coooo00?o09Woooooool0Aoooo`030000<ol0<ol000<co`00
0`000?ooooooo`1joooo001Coooo00?o09Woooooool0Aoooo`030000<ol0<ol000<co`000`000?oo
ooooo`1joooo001Coooo00?o09Woooooool0Aoooo`030000<ol0<ol000<co`000`000?ooooooo`1j
oooo001Coooo00?o09Woooooool0Aoooo`030000<ol0<ol000<co`000`000?ooooooo`1joooo001C
oooo00?o09Woooooool0Aoooo`030000<ol0<ol000<co`000`000?ooooooo`1joooo001Coooo00?o
09Woooooool0Aoooo`030000<ol0<ol000<co`020000Noooo`00Doooo`03o`2Ioooooooo04Ooool0
0`0003?o03?o0003<ol000<0003oooooool0N_ooo`00Doooo`03o`2Ioooooooo04Ooool00`0003?o
03?o0003<ol000<0003oooooool0N_ooo`00Doooo`03o`2Ioooooooo04Soool00`0003?o03?o0002
<ol000<0003oooooool0N_ooo`00Doooo`03o`2Ioooooooo04Soool00`0003?o03?o0002<ol000<0
003oooooool0N_ooo`00Doooo`03o`2Ioooooooo04Soool00`0003?o03?o0002<ol000<0003ooooo
ool0N_ooo`00Doooo`03o`2Ioooooooo04Soool00`0003?o03?o0002<ol000<0003oooooool0N_oo
o`00Doooo`03o`2Ioooooooo04Soool00`0003?o03?o0002<ol00P0007_oool005?oool00ol0VOoo
ooooo`18oooo00<0000co`0co`000S?o00030000oooooooo07[oool005?oool00ol0VOooooooo`18
oooo00<0000co`0co`000S?o00030000oooooooo07[oool005?oool00ol0VOooooooo`18oooo00<0
000co`0co`000S?o00030000oooooooo07[oool005?oool00ol0VOooooooo`18oooo00<0000co`0c
o`000S?o00030000oooooooo07[oool005?oool00ol0VOooooooo`18oooo00<0000co`0co`000S?o
00030000oooooooo07[oool005?oool00ol0VOooooooo`18oooo00<0000co`0co`000S?o0080001k
oooo001Coooo00?o09Woooooool0BOooo`050000<ol0<ol0<ol0000007coool005?oool00ol0VOoo
ooooo`19oooo00D0000co`0co`0co`000000O?ooo`00Doooo`03o`2Ioooooooo04Woool01@0003?o
03?o03?o0000001loooo001Coooo00?o09Woooooool0AOooo`D00003<ol000<0003oooooool0N_oo
o`00Doooo`03o`2Ioooooooo04Goool01@000?ooooooooooo`000003<ol000<0003oooooool0N_oo
o`00Doooo`03o`2Ioooooooo04Koool010000?ooooooo`0000<co`030000N_ooo`00Doooo`03o`2I
oooooooo04Ooool00`000?ooo`000003<ol000<0003oooooool0N_ooo`00Doooo`03o`2Ioooooooo
04Goool00`000?ooooooo`0200000c?o00030000oooooooo07[oool005?oool00ol0VOooooooo`16
oooo0P000003oooo0000<ol0008co`000`000?ooooooo`1joooo001Coooo00?o09Woooooool0BOoo
o`050000<ol0<ol0<ol0000007coool005?oool00ol0VOooooooo`1:oooo00@0000co`0co`00001l
oooo001Coooo00?o09Woooooool0B_ooo`030000<ol0<ol00080001koooo001Coooo00?o09Wooooo
ool0B_ooo`040000<ol0<ol00000O?ooo`00Doooo`03o`2Ioooooooo04[oool0100003?o03?o0000
07coool005?oool00ol0VOooooooo`1:oooo00@0000co`0co`00001loooo001Coooo00?o09Wooooo
ool0B_ooo`040000<ol0<ol00000O?ooo`00Doooo`03o`2Ioooooooo04[oool0100003?o03?o0000
07coool005?oool00ol0VOooooooo`1:oooo00@0000co`0co`00001loooo001Coooo00?o09Wooooo
ool0Boooo`040000<ol000000000Noooo`00Doooo`03o`2Ioooooooo04_oool00`0003?o0000001l
oooo001Coooo00?o09Woooooool0Boooo`030000<ol0000007coool005?oool00ol0VOooooooo`1;
oooo00<0000co`000000O?ooo`00Doooo`03o`2Ioooooooo04_oool00`0003?o0000001loooo001C
oooo00?o09Woooooool0Boooo`030000<ol0000007coool005?oool00ol0VOooooooo`1;oooo00@0
000co`000000001koooo001Coooo00?o09Woooooool0Boooo`030000<ol0000007coool005?oool0
0ol0VOooooooo`1;oooo00<0000co`000000O?ooo`00Doooo`03o`2Ioooooooo04_oool00`0003?o
0000001loooo001Coooo00?o09Woooooool0Boooo`030000<ol0000007coool005?oool00ol0VOoo
ooooo`1;oooo00<0000co`000000O?ooo`00Doooo`03o`2Ioooooooo04_oool0100003?o00000000
07_oool005?oool00ol0VOooooooo`1;oooo00<0000co`000000O?ooo`00Doooo`03o`2Ioooooooo
04_oool00`0003?o0000001loooo001Coooo00?o09Woooooool0Boooo`030000<ol0000007coool0
05?oool00ol0VOooooooo`16oooo0P0000?oool00`0003?o0000001loooo001Coooo00?o09Wooooo
ool0AOooo`040000oooooooo00000_ooo`030000<ol0000007coool005?oool00ol0VOooooooo`17
oooo00H0003oooooooooool0000co`030000N_ooo`00Doooo`03o`2Ioooooooo04Soool01P000?oo
ooooo`0003?o000007coool005?oool00ol0VOooooooo`15oooo00@0003oooooool00002oooo00<0
000co`000000O?ooo`00Doooo`03o`2Ioooooooo04Koool200001?ooo`80001loooo001Coooo00?o
09Woooooool0C?ooo`80001loooo001Coooo00?o09Woooooool0C?ooo`80001loooo001Coooo00?o
09Woooooool0C?ooo`80001loooo001Coooo00?o09Woooooool0C?ooo`<0001koooo001Coooo00?o
09Woooooool0C?ooo`80001loooo001Coooo00?o09Woooooool0C?ooo`80001loooo001Coooo00?o
09Woooooool0C?ooo`80001loooo001Coooo00?o09Woooooool0C?ooo`80001loooo001Coooo00?o
09Woooooool0C?ooo`80001loooo001Coooo00?o09Woooooool0C?ooo`<0001koooo001Coooo00?o
09Woooooool0C?ooo`80001loooo001Coooo00?o09Woooooool0C?ooo`80001loooo001Coooo00?o
09Woooooool0C?ooo`80001loooo001Coooo00?o09Woooooool0C?ooo`80001loooo001Coooo00?o
09Woooooool0C?ooo`80001loooo001Coooo00?o09Woooooool0C?ooo`<0001koooo001Coooo00?o
09Woooooool0COooo`030000oooooooo07[oool005?oool00ol0VOooooooo`1=oooo00<0003ooooo
ool0N_ooo`00Doooo`03o`2Ioooooooo04goool00`000?ooooooo`1joooo001Coooo00?o09Wooooo
ool0COooo`030000oooooooo07[oool005?oool00ol0VOooooooo`1=oooo00<0003oooooool0N_oo
o`00Doooo`03o`2Ioooooooo04goool20000Noooo`00Doooo`03o`2Ioooooooo04goool00`000?oo
ooooo`1joooo001Coooo00?o09Woooooool0COooo`030000oooooooo07[oool005?oool00ol0VOoo
ooooo`1=oooo00<0003oooooool0N_ooo`00Doooo`03o`2Ioooooooo04goool00`000?ooooooo`1j
oooo001Coooo00?o09Woooooool0Aoooo`<00003oooo00<0003oooooool0N_ooo`00Doooo`03o`2I
oooooooo04Soool00`000?ooooooo`02oooo00<0003oooooool0N_ooo`00Doooo`03o`2Ioooooooo
04Goool500000oooo`<0001joooo002Koooo00@0003oooooool00021oooo002Loooo00<0003oool0
0000POooo`00WOooo`800021oooo003ooooo8Oooo`00ooooob7oool007ooool00`000?ooooooo`0L
oooo00<0003oooooool0Ooooo`00O_ooo`030000oooooooo00Soool00`000?ooooooo`0Coooo00<0
003oooooool0O_ooo`00O_ooo`030000oooooooo00;oool200001?ooo`030000oooooooo00goool2
00001?ooo`030000oooooooo07koool007koool01@000?ooooooooooo`000002oooo00<0003ooooo
ool00_ooo`030000oooooooo00Coool400000oooo`040000oooooooo00000oooo`030000oooooooo
07koool007goool00`000?ooooooo`02oooo00<0003oooooool05_ooo`030000oooooooo00;oool0
0`000?ooooooo`1moooo001noooo00<0003oooooool01@0001?oool200001?ooo`030000oooooooo
07koool007koool01@000?ooooooooooo`00000Foooo00<0003oooooool00oooo`030000oooooooo
07koool007ooool00`000?ooooooo`0Goooo0`0000;oool00`000?ooooooo`1ooooo003ooooo8Ooo
o`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{79.5625, 308.938}, {290.125, 148.813}} -> {-0.349561, \
1.05307, 0.00349883, 0.00566123}, {{79.875, 308.563}, {290.125, 148.813}} -> \
{-13.0867, 4.80237, 0.049786, 0.0319664}, {{79.875, 308.563}, {290.125, \
148.813}} -> {-13.0867, 4.80237, 0.049786, 0.0319664}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.9) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
.2 1 0 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.24141 .12361 L
.25127 .12361 L
.26171 .12361 L
.26425 .12361 L
.26698 .12361 L
.26778 .12361 L
.26855 .12361 L
.26923 .12361 L
s
.26923 .12361 m
.26953 .61803 L
s
0 .4 1 r
.02381 .14187 m
.04262 .14914 L
.06244 .15996 L
.07286 .16736 L
.08255 .17562 L
.09388 .18725 L
.10458 .20062 L
.10933 .20742 L
.11049 .20917 L
.11173 .21011 L
.11244 .2101 L
.11309 .21009 L
.11437 .21007 L
.1199 .20997 L
.125 .20987 L
.14357 .20943 L
.16256 .20879 L
.1733 .20833 L
.18328 .2078 L
.2038 .20639 L
.22241 .20457 L
.24166 .20193 L
.2525 .2 L
.25732 .19901 L
.26248 .19786 L
.26509 .19723 L
.26757 .19661 L
.26865 .19633 L
.26979 .19603 L
.27105 .12361 L
.27221 .12361 L
.27329 .12361 L
.27444 .12361 L
.27553 .12361 L
.27653 .12361 L
.27764 .12361 L
.27886 .12361 L
.28012 .12361 L
.2813 .12361 L
.28259 .12361 L
.28332 .12361 L
.28399 .12361 L
.28523 .12361 L
.28654 .12361 L
.28771 .12361 L
.2888 .12361 L
.29 .12361 L
.29129 .12361 L
.292 .12361 L
.29266 .12361 L
Mistroke
.29338 .12361 L
.29415 .12361 L
.29489 .12361 L
.29558 .12361 L
.29687 .12361 L
.29815 .12361 L
.29932 .12361 L
.30061 .12361 L
.30125 .12361 L
.30197 .12361 L
.30327 .12361 L
.30449 .12361 L
.30512 .12361 L
.30581 .12361 L
.30654 .12361 L
.30722 .12361 L
.30847 .12361 L
.30962 .12361 L
.31087 .12361 L
.3122 .12361 L
.31331 .12361 L
.3145 .12361 L
.31563 .12361 L
.31665 .12361 L
.31785 .12361 L
.31915 .12361 L
.32038 .12361 L
.32151 .12361 L
.32272 .12361 L
.32402 .12361 L
.32524 .12361 L
.32636 .12361 L
.32767 .12361 L
.32841 .12361 L
.32909 .12361 L
.33035 .12361 L
.33098 .12361 L
.33169 .12361 L
.33236 .12361 L
.33308 .12361 L
.33435 .12361 L
.33506 .12361 L
.33573 .12361 L
.3365 .12361 L
.33723 .12361 L
.33855 .12361 L
.33975 .12361 L
.34104 .12361 L
.34177 .12361 L
.34244 .12361 L
Mistroke
.34369 .12361 L
.34488 .12361 L
.34594 .12361 L
.34711 .12361 L
.34836 .12361 L
.34907 .12361 L
.34971 .12361 L
.35095 .12361 L
.35212 .12361 L
.35322 .12361 L
.35439 .12361 L
.35538 .12361 L
.35647 .12361 L
.35765 .12361 L
.35891 .12361 L
.3601 .12361 L
.36118 .12361 L
.36246 .12361 L
.36316 .12361 L
.36382 .12361 L
.36498 .12361 L
.36626 .12361 L
.36693 .12361 L
.36765 .12361 L
.36892 .12361 L
.36962 .12361 L
.37028 .12361 L
.37101 .12361 L
.37178 .12361 L
.37308 .12361 L
.37381 .12361 L
.37448 .12361 L
.37572 .12361 L
.37704 .12361 L
.37821 .12361 L
.37931 .12361 L
.38062 .12361 L
.38181 .12361 L
.38307 .12361 L
.38375 .12361 L
.3844 .12361 L
.38555 .12361 L
.3868 .12361 L
.38746 .12361 L
.38818 .12361 L
.38893 .12361 L
.38963 .12361 L
.39089 .12361 L
.39159 .12361 L
.39223 .12361 L
Mistroke
.3935 .12361 L
.39467 .12361 L
.39595 .12361 L
.39661 .12361 L
.39731 .12361 L
.39849 .12361 L
.3996 .12361 L
.40091 .12361 L
.40211 .12361 L
.40325 .12361 L
.40431 .12361 L
.40554 .12361 L
.40666 .12361 L
.40789 .12361 L
.40859 .12361 L
.40923 .12361 L
.41039 .12361 L
.41162 .12361 L
.41269 .12361 L
.41385 .12361 L
.41493 .12361 L
.41593 .12361 L
.41709 .12361 L
.41836 .12361 L
.41955 .12361 L
.42066 .12361 L
.42183 .12361 L
.42307 .12361 L
.42413 .12361 L
.42529 .12361 L
.42654 .12361 L
.42723 .12361 L
.42787 .12361 L
.42911 .12361 L
.43028 .12361 L
.43136 .12361 L
.43238 .12361 L
.43344 .12361 L
.43461 .12361 L
.43579 .12361 L
.43706 .12361 L
.43823 .12361 L
.43931 .12361 L
.44058 .12361 L
.44129 .12361 L
.44193 .12361 L
.44319 .12361 L
.44437 .12361 L
.44504 .12361 L
.44575 .12361 L
Mistroke
.44701 .12361 L
.44772 .12361 L
.44838 .12361 L
.4491 .12361 L
.44988 .12361 L
.45117 .12361 L
.4519 .12361 L
.45257 .12361 L
.45381 .12361 L
.45513 .12361 L
.45622 .12361 L
.4574 .12361 L
.4587 .12361 L
.45991 .12361 L
.46117 .12361 L
.46231 .12361 L
.46364 .12361 L
.46488 .12361 L
.46604 .12361 L
.4671 .12361 L
.46827 .12361 L
.4695 .12361 L
.47075 .12361 L
.47144 .12361 L
.47208 .12361 L
.47332 .12361 L
.47449 .12361 L
.47515 .12361 L
.47586 .12361 L
.47712 .12361 L
.47782 .12361 L
.47848 .12361 L
.4792 .12361 L
.47998 .12361 L
.48062 .12361 L
.4813 .12361 L
.48254 .12361 L
.48329 .12361 L
.48401 .12361 L
.48464 .12361 L
.48534 .12361 L
.48602 .12361 L
.48677 .12361 L
.48755 .12361 L
.48828 .12361 L
.48958 .12361 L
.49032 .12361 L
.49099 .12361 L
.49219 .12361 L
.49346 .12361 L
Mistroke
.4942 .12361 L
.49487 .12361 L
.49617 .12361 L
.49739 .12361 L
.4987 .12361 L
.49995 .12361 L
.50109 .12361 L
.50235 .12361 L
.50355 .12361 L
.50462 .12361 L
.50579 .12361 L
.50706 .12361 L
.50776 .12361 L
.50841 .12361 L
.50956 .12361 L
.51083 .12361 L
.51194 .12361 L
.51311 .12361 L
.51411 .12361 L
.5152 .12361 L
.51639 .12361 L
.51765 .12361 L
.51884 .12361 L
.51992 .12361 L
.52121 .12361 L
.52186 .12361 L
.52257 .12361 L
.52384 .12361 L
.52502 .12361 L
.52574 .12361 L
.52641 .12361 L
.52769 .12361 L
.5284 .12361 L
.52906 .12361 L
.52978 .12361 L
.53055 .12361 L
.53186 .12361 L
.53259 .12361 L
.53326 .12361 L
.53451 .12361 L
.53582 .12361 L
.53699 .12361 L
.53809 .12361 L
.5393 .12361 L
.54059 .12361 L
.54181 .12361 L
.54251 .12361 L
.54316 .12361 L
.54447 .12361 L
.54515 .12361 L
Mistroke
.54589 .12361 L
.5472 .12361 L
.54845 .12361 L
.54966 .12361 L
.55079 .12361 L
.55143 .12361 L
.55211 .12361 L
.55286 .12361 L
.55355 .12361 L
.55479 .12361 L
.55549 .12361 L
.55615 .12361 L
.55691 .12361 L
.5576 .12361 L
.5584 .12361 L
.55915 .12361 L
.56045 .12361 L
.56114 .12361 L
.56187 .12361 L
.56311 .12361 L
.56428 .12361 L
.56555 .12361 L
.56627 .12361 L
.56694 .12361 L
.5676 .12361 L
.56831 .12361 L
.56906 .12361 L
.56975 .12361 L
.57039 .12361 L
.57107 .12361 L
.57233 .12361 L
.57349 .12361 L
.57477 .12361 L
.57542 .12361 L
.57611 .12361 L
.57736 .12361 L
.57861 .12361 L
.57979 .12361 L
.58085 .12361 L
.58201 .12361 L
.62268 .12361 L
.66184 .12361 L
.70345 .12361 L
.74354 .12361 L
.78212 .12361 L
.82315 .12361 L
.86266 .12361 L
.90066 .12361 L
.94112 .12361 L
.97619 .12361 L
Mistroke
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.9) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Koooo1@00083oool009goool00`000?ooooooo`20oooo002Moooo00<0003ooooo
ool00oooo`<0001joooo002Eoooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0N_oo
o`00WOooo`030000oooooooo00?oool00`000?ooooooo`1joooo002Loooo0P0000Goool00`000?oo
ooooo`1joooo002Soooo00<0003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool2
0000Noooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0
003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002S
oooo00<0003oooooool0N_ooo`00Xoooo`80001koooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool00:?oool20000Noooo`00:oooo`<0000Xoooo0`0002?oool4
00008oooo`030000oooooooo02?oool400009oooo`<0000Yoooo000[oooo00@0003oooooool0000X
oooo00<0003oooooool08_ooo`030000oooooooo02Coool00`000?ooooooo`0Soooo00<0003ooooo
ool0:Oooo`030000oooooooo02Soool002_oool010000?ooooooo`0002Goool500009?ooo`030000
oooooooo02?oool00`000?ooooooo`0Toooo00<0003oooooool09Oooo`D0000Yoooo000Uoooo1000
00;oool300008?ooo`@00002oooo00@0003oooooool0000Noooo100000Coool00`000?ooooooo`0R
oooo00<0003oooooool09Oooo`030000oooooooo02Coool010000?ooooooo`0002[oool002coool0
0`000?ooooooo`0Voooo00<0003oool000009?ooo`040000oooooooo00008oooo`030000oooooooo
02?oool010000?ooooooo`0002Koool00`000?ooo`00000Zoooo000/oooo0`0002Ooool200009Ooo
o`80000Toooo0P0002Goool20000:?ooo`80000Zoooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool0013ooooo00004Oooo`005_ooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000o`2I06Ko00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooo0000010000000c?o000003?o0008<ol000<0000co`0co`001c?o00030000
<ol0<ol000Lco`000`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool05Oooo`00:_ooo`030000oooooooo02Koool00`000?l0V@1Vo`0Uoooo00<0003oooooool01_oo
o`@0000K<ol000<0003oooooool09Oooo`030000oooooooo02Koool00`000?ooooooo`0Yoooo001D
oooo00?o09T0I_ooool0<Oooo`@0000G<ol000<0003oooooool0N_ooo`00E?ooo`03o`2I06Kooooo
03Goool00`0003?o03?o000D<ol000<0003oooooool0N_ooo`005_ooo`80I_lloooo00?o09T0I_oo
ool0=_ooo`80000D<ol000<0003oooooool0N_ooo`006?ooo`80I_ljoooo00?o09T0I_ooool0>?oo
o`030000<ol0<ol0014co`000`000?ooooooo`1joooo000Joooo0P1VocSoool00ol0V@1Vooooo`0i
oooo00<0000co`0co`0043?o0080001koooo000Loooo0P1VocKoool00ol0V@1Vooooo`0joooo0P00
010co`000`000?ooooooo`1joooo000Noooo0P1VocCoool00ol0V@1Vooooo`0loooo00<0000co`0c
o`003C?o00030000oooooooo07[oool0023oool206Ko<_ooo`03o`2I06Kooooo03coool00`0003?o
03?o000=<ol000<0003oooooool0N_ooo`008_ooo`80I_l`oooo00?o09T0I_ooool0?Oooo`030000
<ol0<ol000`co`000`000?ooooooo`1joooo000Toooo00<0I_ooooooool0;Oooo`03o`2I06Kooooo
03goool00`0003?o03?o000<<ol000<0003oooooool0N_ooo`009?ooo`0306Kooooooooo02goool0
0ol0V@1Vooooo`0noooo00<0000co`0co`002c?o0080001koooo000Uoooo00<0I_ooooooool0;?oo
o`03o`2I06Kooooo03koool00`0003?o03?o000;<ol000<0003oooooool0N_ooo`009_ooo`0306Ko
oooooooo02_oool00ol0V@1Vooooo`0ooooo00<0000co`0co`002S?o00030000oooooooo07[oool0
02Ooool00`1Vooooooooo`0Zoooo00?o09T0I_ooool0?oooo`030000<ol0<ol000Xco`000`000?oo
ooooo`1joooo000Xoooo00<0I_ooooooool0:Oooo`03o`2I06Kooooo043oool00`0003?o03?o0009
<ol000<0003oooooool0N_ooo`00:Oooo`0306Kooooooooo02Soool00ol0V@1Vooooo`10oooo00<0
000co`0co`002C?o00030000oooooooo07[oool002[oool00`1Vooooooooo`0Voooo0`1Vod;oool0
0`0003?o03?o0008<ol00P0007_oool002_oool00`1Vooooooooo`0Noooo1`1Vo`03ooooo`2Ioooo
04;oool00`0003?o03?o0008<ol000<0003oooooool0N_ooo`00:oooo`0306Kooooooooo01Coool:
06Ko2?ooo`03o`2Ioooooooo047oool00`0003?o03?o0008<ol000<0003oooooool0N_ooo`00;?oo
oaH0I_lBoooo00?o09Woooooool0@_ooo`030000<ol0<ol000Lco`000`000?ooooooo`1joooo001D
oooo00?o09Woooooool0@_ooo`030000<ol0<ol000Lco`000`000?ooooooo`1joooo001Doooo00?o
09Woooooool0@_ooo`030000<ol0<ol000Lco`000`000?ooooooo`1joooo001Doooo00?o09Wooooo
ool0@_ooo`030000<ol0<ol000Lco`020000Noooo`00E?ooo`03o`2Ioooooooo04?oool00`0003?o
03?o0006<ol000<0003oooooool0N_ooo`00E?ooo`03o`2Ioooooooo04?oool00`0003?o03?o0006
<ol000<0003oooooool0N_ooo`00E?ooo`03o`2Ioooooooo04?oool00`0003?o03?o0006<ol000<0
003oooooool0N_ooo`00E?ooo`03o`2Ioooooooo04?oool00`0003?o03?o0006<ol000<0003ooooo
ool0N_ooo`00E?ooo`03o`2Ioooooooo04Coool500000c?o00030000oooooooo07[oool005Coool0
0ol0VOooooooo`14oooo00<0000co`0000001C?o00030000oooooooo07[oool005Coool00ol0VOoo
ooooo`14oooo00<0000co`0000001C?o00<0001joooo001Doooo00?o09Woooooool0AOooo`800005
<ol000<0003oooooool0N_ooo`00E?ooo`03o`2Ioooooooo04Goool200001C?o00030000oooooooo
07[oool005Coool00ol0VOooooooo`15oooo0P0000Dco`000`000?ooooooo`1joooo001Doooo00?o
09Woooooool0AOooo`030000<ol0<ol000@co`000`000?ooooooo`1joooo001Doooo00?o09Wooooo
ool0AOooo`030000<ol0<ol000@co`000`000?ooooooo`1joooo001Doooo00?o09Woooooool0AOoo
o`030000<ol0<ol000@co`020000Noooo`00E?ooo`03o`2Ioooooooo04Koool00`0003?o03?o0003
<ol000<0003oooooool0N_ooo`00E?ooo`03o`2Ioooooooo04Koool00`0003?o03?o0003<ol000<0
003oooooool0N_ooo`00E?ooo`03o`2Ioooooooo04Koool00`0003?o03?o0003<ol000<0003ooooo
ool0N_ooo`00E?ooo`03o`2Ioooooooo04Koool00`0003?o03?o0003<ol000<0003oooooool0N_oo
o`00E?ooo`03o`2Ioooooooo04Koool00`0003?o03?o0003<ol000<0003oooooool0N_ooo`00E?oo
o`03o`2Ioooooooo04Koool00`0003?o03?o0003<ol00P0007_oool005Coool00ol0VOooooooo`16
oooo00<0000co`0co`000c?o00030000oooooooo07[oool005Coool00ol0VOooooooo`16oooo00<0
000co`0co`000c?o00030000oooooooo07[oool005Coool00ol0VOooooooo`17oooo00<0000co`0c
o`000S?o00030000oooooooo07[oool005Coool00ol0VOooooooo`17oooo00<0000co`0co`000S?o
00030000oooooooo07[oool005Coool00ol0VOooooooo`17oooo00<0000co`0co`000S?o00030000
oooooooo07[oool005Coool00ol0VOooooooo`17oooo00<0000co`0co`000S?o00030000oooooooo
07[oool005Coool00ol0VOooooooo`17oooo00<0000co`0co`000S?o0080001koooo001Doooo00?o
09Woooooool0Aoooo`030000<ol0<ol0008co`000`000?ooooooo`1joooo001Doooo00?o09Wooooo
ool0Aoooo`030000<ol0<ol0008co`000`000?ooooooo`1joooo001Doooo00?o09Woooooool0Aooo
o`030000<ol0<ol0008co`000`000?ooooooo`1joooo001Doooo00?o09Woooooool0Aoooo`030000
<ol0<ol0008co`000`000?ooooooo`1joooo001Doooo00?o09Woooooool0Aoooo`030000<ol0<ol0
008co`000`000?ooooooo`1joooo001Doooo00?o09Woooooool0Aoooo`030000<ol0<ol0008co`02
0000Noooo`00E?ooo`03o`2Ioooooooo04Soool01@0003?o03?o03?o0000001loooo001Doooo00?o
09Woooooool0B?ooo`050000<ol0<ol0<ol0000007coool005Coool00ol0VOooooooo`18oooo00D0
000co`0co`0co`000000O?ooo`00E?ooo`03o`2Ioooooooo04Coool500000c?o00030000oooooooo
07[oool005Coool00ol0VOooooooo`14oooo00D0003oooooooooool000000c?o00030000oooooooo
07[oool005Coool00ol0VOooooooo`15oooo00@0003oooooool00003<ol00`0007[oool005Goool0
0ol0VOooooooo`15oooo00<0003oool000000c?o00030000oooooooo07[oool005Goool00ol0VOoo
ooooo`13oooo00<0003oooooool00P0000<co`000`000?ooooooo`1joooo001Eoooo00?o09Wooooo
ool0A?ooo`8000000oooo`0003?o0002<ol000<0003oooooool0N_ooo`00EOooo`03o`2Ioooooooo
04Ooool01@0003?o03?o03?o0000001loooo001Eoooo00?o09Woooooool0B?ooo`040000<ol0<ol0
0000O?ooo`00EOooo`03o`2Ioooooooo04Soool00`0003?o03?o00020000Noooo`00EOooo`03o`2I
oooooooo04Soool0100003?o03?o000007coool005Goool00ol0VOooooooo`18oooo00@0000co`0c
o`00001loooo001Eoooo00?o09Woooooool0B?ooo`040000<ol0<ol00000O?ooo`00EOooo`03o`2I
oooooooo04Soool0100003?o03?o000007coool005Goool00ol0VOooooooo`18oooo00@0000co`0c
o`00001loooo001Eoooo00?o09Woooooool0B?ooo`040000<ol0<ol00000O?ooo`00EOooo`03o`2I
oooooooo04Woool0100003?o0000000007_oool005Goool00ol0VOooooooo`19oooo00<0000co`00
0000O?ooo`00EOooo`03o`2Ioooooooo04Woool00`0003?o0000001loooo001Eoooo00?o09Wooooo
ool0BOooo`030000<ol0000007coool005Goool00ol0VOooooooo`19oooo00<0000co`000000O?oo
o`00EOooo`03o`2Ioooooooo04Woool00`0003?o0000001loooo001Eoooo00?o09Woooooool0BOoo
o`040000<ol000000000Noooo`00EOooo`03o`2Ioooooooo04Woool00`0003?o0000001loooo001E
oooo00?o09Woooooool0BOooo`030000<ol0000007coool005Goool00ol0VOooooooo`19oooo00<0
000co`000000O?ooo`00EOooo`03o`2Ioooooooo04Woool00`0003?o0000001loooo001Eoooo00?o
09Woooooool0BOooo`030000<ol0000007coool005Goool00ol0VOooooooo`19oooo00@0000co`00
0000001koooo001Eoooo00?o09Woooooool0BOooo`030000<ol0000007coool005Goool00ol0VOoo
ooooo`19oooo00<0000co`000000O?ooo`00EOooo`03o`2Ioooooooo04Woool00`0003?o0000001l
oooo001Eoooo00?o09Woooooool0A?ooo`800003oooo00<0000co`000000O?ooo`00EOooo`03o`2I
oooooooo04?oool010000?ooooooo`0000;oool00`0003?o0000001loooo001Eoooo00?o09Wooooo
ool0AOooo`060000oooooooooooo0000<ol00`0007[oool005Goool00ol0VOooooooo`16oooo00H0
003oooooool0000co`00001loooo001Eoooo00?o09Woooooool0@oooo`040000oooooooo00000_oo
o`030000<ol0000007coool005Goool00ol0VOooooooo`14oooo0P0000Coool20000O?ooo`00EOoo
o`03o`2Ioooooooo04[oool20000O?ooo`00EOooo`03o`2Ioooooooo04[oool20000O?ooo`00EOoo
o`03o`2Ioooooooo04[oool20000O?ooo`00EOooo`03o`2Ioooooooo04[oool30000Noooo`00EOoo
o`03o`2Ioooooooo04[oool20000O?ooo`00EOooo`03o`2Ioooooooo04[oool20000O?ooo`00EOoo
o`03o`2Ioooooooo04[oool20000O?ooo`00EOooo`03o`2Ioooooooo04[oool20000O?ooo`00EOoo
o`03o`2Ioooooooo04[oool20000O?ooo`00EOooo`03o`2Ioooooooo04[oool30000Noooo`00EOoo
o`03o`2Ioooooooo04[oool20000O?ooo`00EOooo`03o`2Ioooooooo04[oool20000O?ooo`00EOoo
o`03o`2Ioooooooo04[oool20000O?ooo`00EOooo`03o`2Ioooooooo04[oool20000O?ooo`00EOoo
o`03o`2Ioooooooo04[oool20000O?ooo`00EOooo`03o`2Ioooooooo04[oool30000Noooo`00EOoo
o`03o`2Ioooooooo04_oool00`000?ooooooo`1joooo001Eoooo00?o09Woooooool0Boooo`030000
oooooooo07[oool005Goool00ol0VOooooooo`1;oooo00<0003oooooool0N_ooo`00EOooo`03o`2I
oooooooo04_oool00`000?ooooooo`1joooo001Eoooo00?o09Woooooool0Boooo`030000oooooooo
07[oool005Goool00ol0VOooooooo`1;oooo0P0007_oool005Goool00ol0VOooooooo`1;oooo00<0
003oooooool0N_ooo`00EOooo`03o`2Ioooooooo04_oool00`000?ooooooo`1joooo001Eoooo00?o
09Woooooool0Boooo`030000oooooooo07[oool005Goool00ol0VOooooooo`1;oooo00<0003ooooo
ool0N_ooo`00EOooo`03o`2Ioooooooo04Goool300000oooo`030000oooooooo07[oool005Goool0
0ol0VOooooooo`16oooo00<0003oooooool00_ooo`030000oooooooo07[oool005Goool00ol0VOoo
ooooo`13oooo1@0000?oool30000N_ooo`00Voooo`040000oooooooo0000POooo`00W?ooo`030000
oooo0000087oool009goool20000POooo`00ooooob7oool00?oooolQoooo001ioooo00<0003ooooo
ool0:?ooo`030000oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07ooo
o`030000oooooooo07Soool007Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0>
oooo0`0000;oool200000oooo`<00004oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooo
oooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01?ooo`@00006oooo00<0003ooooo
ool02?ooo`030000oooooooo00;oool00`000?ooooooo`1hoooo001goooo00<0003oooooool00_oo
o`030000oooooooo01?oool500002?ooo`<00004oooo00<0003oooooool0Moooo`00N?ooo`030000
oooooooo00D0000Boooo00@0003oooooool00008oooo00@0003oooooool00003oooo00<0003ooooo
ool0N?ooo`00N?ooo`050000oooooooooooo000001Koool00`000?ooo`000008oooo00@0003ooooo
ool00003oooo00<0003oooooool0N?ooo`00NOooo`030000oooooooo01Soool200002Oooo`<00002
oooo00<0003oooooool0NOooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-8.12947, \
-1.14361, 0.0496935, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-8.12947, -1.14361, 0.0496935, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
.2 1 0 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.24141 .12361 L
.26171 .12361 L
.26709 .12361 L
.27279 .12361 L
.27513 .12361 L
.27643 .12361 L
.27765 .12361 L
s
.27765 .12361 m
.27793 .61803 L
s
0 .4 1 r
.02381 .13946 m
.04262 .14577 L
.06244 .15516 L
.07286 .16159 L
.08255 .16876 L
.10458 .19046 L
.10961 .19673 L
.11508 .20421 L
.11758 .20789 L
.11884 .20981 L
.11956 .21012 L
.12023 .2101 L
.125 .21002 L
.14357 .20964 L
.16382 .20904 L
.18234 .20827 L
.20133 .20717 L
.21208 .20636 L
.22205 .20545 L
.24258 .203 L
.26118 .19985 L
.26606 .19884 L
.27121 .19767 L
.27333 .19716 L
.2756 .19658 L
.27691 .19624 L
.2781 .12361 L
.2793 .12361 L
.28043 .12361 L
.28173 .12361 L
.28294 .12361 L
.28421 .12361 L
.28488 .12361 L
.28561 .12361 L
.28683 .12361 L
.28811 .12361 L
.2892 .12361 L
.2904 .12361 L
.29107 .12361 L
.2918 .12361 L
.29312 .12361 L
.29391 .12361 L
.29464 .12361 L
.29531 .12361 L
.29602 .12361 L
.29731 .12361 L
.29851 .12361 L
.29983 .12361 L
.30057 .12361 L
.30125 .12361 L
Mistroke
.30254 .12361 L
.30376 .12361 L
.30485 .12361 L
.30603 .12361 L
.30732 .12361 L
.30803 .12361 L
.30868 .12361 L
.30985 .12361 L
.31112 .12361 L
.31231 .12361 L
.31343 .12361 L
.31444 .12361 L
.31554 .12361 L
.31673 .12361 L
.318 .12361 L
.31908 .12361 L
.32027 .12361 L
.32158 .12361 L
.32224 .12361 L
.32296 .12361 L
.32424 .12361 L
.32543 .12361 L
.32615 .12361 L
.32683 .12361 L
.32811 .12361 L
.32883 .12361 L
.32949 .12361 L
.33021 .12361 L
.33098 .12361 L
.33217 .12361 L
.33345 .12361 L
.33466 .12361 L
.33576 .12361 L
.33705 .12361 L
.33778 .12361 L
.33845 .12361 L
.33969 .12361 L
.34101 .12361 L
.34214 .12361 L
.34339 .12361 L
.34468 .12361 L
.34589 .12361 L
.34702 .12361 L
.34805 .12361 L
.34924 .12361 L
.35036 .12361 L
.35159 .12361 L
.35288 .12361 L
.35399 .12361 L
.35521 .12361 L
Mistroke
.35588 .12361 L
.35661 .12361 L
.35731 .12361 L
.35795 .12361 L
.35916 .12361 L
.36046 .12361 L
.36169 .12361 L
.36284 .12361 L
.36388 .12361 L
.365 .12361 L
.36624 .12361 L
.36755 .12361 L
.36867 .12361 L
.36989 .12361 L
.37105 .12361 L
.3721 .12361 L
.37331 .12361 L
.37446 .12361 L
.37553 .12361 L
.37651 .12361 L
.37758 .12361 L
.37873 .12361 L
.37987 .12361 L
.38111 .12361 L
.38241 .12361 L
.38362 .12361 L
.38476 .12361 L
.38579 .12361 L
.38698 .12361 L
.38811 .12361 L
.38933 .12361 L
.39063 .12361 L
.39174 .12361 L
.39296 .12361 L
.39427 .12361 L
.395 .12361 L
.39567 .12361 L
.39698 .12361 L
.39821 .12361 L
.39937 .12361 L
.40041 .12361 L
.40162 .12361 L
.40276 .12361 L
.40381 .12361 L
.40478 .12361 L
.40584 .12361 L
.40697 .12361 L
.4081 .12361 L
.40932 .12361 L
.41047 .12361 L
Mistroke
.41151 .12361 L
.41274 .12361 L
.41344 .12361 L
.41408 .12361 L
.41525 .12361 L
.4165 .12361 L
.4177 .12361 L
.41902 .12361 L
.42026 .12361 L
.42141 .12361 L
.42255 .12361 L
.42358 .12361 L
.42478 .12361 L
.4259 .12361 L
.42713 .12361 L
.42844 .12361 L
.43077 .12361 L
.43206 .12361 L
.43327 .12361 L
.43397 .12361 L
.4346 .12361 L
.43533 .12361 L
.43602 .12361 L
.43707 .12361 L
.43823 .12361 L
.43944 .12361 L
.44058 .12361 L
.44163 .12361 L
.4426 .12361 L
.44367 .12361 L
.44479 .12361 L
.44593 .12361 L
.44715 .12361 L
.4483 .12361 L
.44934 .12361 L
.45057 .12361 L
.45126 .12361 L
.4519 .12361 L
.45308 .12361 L
.45432 .12361 L
.45553 .12361 L
.45685 .12361 L
.45809 .12361 L
.45925 .12361 L
.46039 .12361 L
.46143 .12361 L
.46263 .12361 L
.46375 .12361 L
.46499 .12361 L
.46629 .12361 L
Mistroke
.4674 .12361 L
.46862 .12361 L
.46994 .12361 L
.47068 .12361 L
.47135 .12361 L
.47265 .12361 L
.47389 .12361 L
.47494 .12361 L
.4761 .12361 L
.47731 .12361 L
.47845 .12361 L
.47951 .12361 L
.48048 .12361 L
.48154 .12361 L
.48266 .12361 L
.4838 .12361 L
.48502 .12361 L
.48617 .12361 L
.48722 .12361 L
.48845 .12361 L
.48914 .12361 L
.48978 .12361 L
.49095 .12361 L
.4922 .12361 L
.49341 .12361 L
.49473 .12361 L
.49598 .12361 L
.49714 .12361 L
.49818 .12361 L
.49933 .12361 L
.50053 .12361 L
.50165 .12361 L
.50289 .12361 L
.5042 .12361 L
.50531 .12361 L
.50653 .12361 L
.50785 .12361 L
.50859 .12361 L
.50926 .12361 L
.51057 .12361 L
.5118 .12361 L
.51286 .12361 L
.51402 .12361 L
.51523 .12361 L
.51637 .12361 L
.51743 .12361 L
.5184 .12361 L
.51952 .12361 L
.52059 .12361 L
.52173 .12361 L
Mistroke
.52295 .12361 L
.5241 .12361 L
.52515 .12361 L
.52638 .12361 L
.52707 .12361 L
.52771 .12361 L
.52888 .12361 L
.53012 .12361 L
.53134 .12361 L
.53199 .12361 L
.53267 .12361 L
.53392 .12361 L
.53508 .12361 L
.53619 .12361 L
.53723 .12361 L
.53838 .12361 L
.53961 .12361 L
.54084 .12361 L
.54154 .12361 L
.54219 .12361 L
.5435 .12361 L
.54424 .12361 L
.54491 .12361 L
.54611 .12361 L
.54741 .12361 L
.54864 .12361 L
.54977 .12361 L
.55082 .12361 L
.55196 .12361 L
.55303 .12361 L
.55401 .12361 L
.55516 .12361 L
.5564 .12361 L
.55758 .12361 L
.55868 .12361 L
.55991 .12361 L
.56107 .12361 L
.56212 .12361 L
.56324 .12361 L
.56448 .12361 L
.56578 .12361 L
.56689 .12361 L
.5681 .12361 L
.56941 .12361 L
.57062 .12361 L
.57126 .12361 L
.57195 .12361 L
.57268 .12361 L
.57336 .12361 L
.57461 .12361 L
Mistroke
.57576 .12361 L
.57708 .12361 L
.57834 .12361 L
.57946 .12361 L
.58065 .12361 L
.58279 .12361 L
.58766 .12361 L
.60859 .12361 L
.65015 .12361 L
.69019 .12361 L
.72871 .12361 L
.76969 .12361 L
.80915 .12361 L
.8471 .12361 L
.8875 .12361 L
.92639 .12361 L
.96772 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Koooo1@00083oool009goool00`000?ooooooo`20oooo002Moooo00<0003ooooo
ool00oooo`<0001joooo002Eoooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0N_oo
o`00WOooo`030000oooooooo00?oool00`000?ooooooo`1joooo002Loooo0P0000Goool00`000?oo
ooooo`1joooo002Soooo00<0003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool2
0000Noooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0
003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002S
oooo00<0003oooooool0N_ooo`00Xoooo`80001koooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool00:?oool20000Noooo`00:oooo`<0000Xoooo0`0002?oool4
00008oooo`030000oooooooo02?oool400009oooo`<0000Yoooo000[oooo00@0003oooooool0000X
oooo00<0003oooooool08_ooo`030000oooooooo02Coool00`000?ooooooo`0Soooo00<0003ooooo
ool0:Oooo`030000oooooooo02Soool002_oool010000?ooooooo`0002Goool500009?ooo`030000
oooooooo02?oool00`000?ooooooo`0Toooo00<0003oooooool09Oooo`D0000Yoooo000Uoooo1000
00;oool300008?ooo`@00002oooo00@0003oooooool0000Noooo100000Coool00`000?ooooooo`0R
oooo00<0003oooooool09Oooo`030000oooooooo02Coool010000?ooooooo`0002[oool002coool0
0`000?ooooooo`0Voooo00<0003oool000009?ooo`040000oooooooo00008oooo`030000oooooooo
02?oool010000?ooooooo`0002Koool00`000?ooo`00000Zoooo000/oooo0`0002Ooool200009Ooo
o`80000Toooo0P0002Goool20000:?ooo`80000Zoooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool0013ooooo00004Oooo`005_ooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`050000oooooooooooo06Ko00Goool00`000?ooooooo`07oooo00<0
003oooooool01oooo`030000oooo0000010000000c?o000003?o0008<ol000<0000co`0co`001c?o
00030000<ol0<ol000Lco`000`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo
00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?oo
ooooo`08oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0
003oooooool05Oooo`00:_ooo`030000oooooooo02Koool01@000?ooooooooooo`1Vo`0Soooo00<0
003oooooool01_ooo`@0000K<ol000<0003oooooool09Oooo`030000oooooooo02Koool00`000?oo
ooooo`0Yoooo001Goooo00<0I_ooooooool0;_ooo`@0000G<ol000<0003oooooool0N_ooo`005_oo
o`80I_looooo00<0I_ooooooool0<_ooo`030000<ol0<ol001@co`000`000?ooooooo`1joooo000H
oooo0P1Vocgoool00`1Vooooooooo`0coooo0P0001@co`000`000?ooooooo`1joooo000Joooo0`1V
oc[oool00`1Vooooooooo`0eoooo00<0000co`0co`004C?o00030000oooooooo07[oool001goool2
06Ko>?ooo`0306Kooooooooo03Koool00`0003?o03?o000@<ol00P0007_oool001ooool206Ko=_oo
o`0306Kooooooooo03Ooool2000043?o00030000oooooooo07[oool0027oool206Ko=?ooo`0306Ko
oooooooo03Woool00`0003?o03?o000=<ol000<0003oooooool0N_ooo`008oooo`0306Kooooooooo
033oool00`1Vool0VOooo`0joooo00<0000co`0co`003C?o00030000oooooooo07[oool002Coool0
0`1Vooooooooo`0_oooo00<0I_oo09Woool0>oooo`030000<ol0<ol000`co`000`000?ooooooo`1j
oooo000Uoooo00<0I_ooooooool0;_ooo`0306Koo`2Ioooo03_oool00`0003?o03?o000<<ol000<0
003oooooool0N_ooo`009_ooo`0306Kooooooooo02goool00`1Vool0VOooo`0loooo00<0000co`0c
o`002c?o0080001koooo000Woooo00<0I_ooooooool0;?ooo`0306Koo`2Ioooo03coool00`0003?o
03?o000;<ol000<0003oooooool0N_ooo`00:?ooo`80I_l/oooo00<0I_oo09Woool0?Oooo`030000
<ol0<ol000Xco`000`000?ooooooo`1joooo000Zoooo00<0I_ooooooool0:Oooo`0306Koo`2Ioooo
03goool00`0003?o03?o000:<ol000<0003oooooool0N_ooo`00:oooo`0306Kooooooooo02Soool0
0`1Vool0VOooo`0noooo00<0000co`0co`002C?o00030000oooooooo07[oool002_oool00`1Voooo
ooooo`0Xoooo00<0I_oo09Woool0?_ooo`030000<ol0<ol000Tco`000`000?ooooooo`1joooo000/
oooo00<0I_ooooooool09Oooo`<0I_l00ol0VOooooooo`0noooo00<0000co`0co`0023?o0080001k
oooo000/oooo00<0I_ooooooool08_ooo`<0I_l3oooo00?o09Woooooool0?_ooo`030000<ol0<ol0
00Pco`000`000?ooooooo`1joooo000]oooo00<0I_ooooooool05Oooo``0I_l6oooo00?o09Wooooo
ool0?_ooo`030000<ol0<ol000Pco`000`000?ooooooo`1joooo000^oooo5`1Voa;oool00ol0VOoo
ooooo`0ooooo00<0000co`0co`001c?o00030000oooooooo07[oool005Ooool00ol0VOooooooo`0o
oooo00<0000co`0co`001c?o00030000oooooooo07[oool005Ooool00ol0VOooooooo`0ooooo00<0
000co`0co`001c?o00030000oooooooo07[oool005Ooool00ol0VOooooooo`0ooooo00<0000co`0c
o`001c?o0080001koooo001Goooo00?o09Woooooool0@?ooo`030000<ol0<ol000Hco`000`000?oo
ooooo`1joooo001Goooo00?o09Woooooool0@?ooo`030000<ol0<ol000Hco`000`000?ooooooo`1j
oooo001Goooo00?o09Woooooool0@?ooo`030000<ol0<ol000Hco`000`000?ooooooo`1joooo001G
oooo00?o09Woooooool0@?ooo`030000<ol0<ol000Hco`000`000?ooooooo`1joooo001Goooo00?o
09Woooooool0@Oooo`D00003<ol000<0003oooooool0N_ooo`00Eoooo`03o`2Ioooooooo047oool0
0`0003?o00000005<ol000<0003oooooool0N_ooo`00Eoooo`03o`2Ioooooooo047oool00`0003?o
00000005<ol00`0007[oool005Ooool00ol0VOooooooo`12oooo0P0000Dco`000`000?ooooooo`1j
oooo001Goooo00?o09Woooooool0@_ooo`800005<ol000<0003oooooool0N_ooo`00Eoooo`03o`2I
oooooooo04;oool200001C?o00030000oooooooo07[oool005Ooool00ol0VOooooooo`12oooo00<0
000co`0co`0013?o00030000oooooooo07[oool005Ooool00ol0VOooooooo`12oooo00<0000co`0c
o`0013?o00030000oooooooo07[oool005Ooool00ol0VOooooooo`12oooo00<0000co`0co`0013?o
0080001koooo001Goooo00?o09Woooooool0@oooo`030000<ol0<ol000<co`000`000?ooooooo`1j
oooo001Goooo00?o09Woooooool0@oooo`030000<ol0<ol000<co`000`000?ooooooo`1joooo001G
oooo00?o09Woooooool0@oooo`030000<ol0<ol000<co`000`000?ooooooo`1joooo001Goooo00?o
09Woooooool0@oooo`030000<ol0<ol000<co`000`000?ooooooo`1joooo001Goooo00?o09Wooooo
ool0@oooo`030000<ol0<ol000<co`000`000?ooooooo`1joooo001Goooo00?o09Woooooool0@ooo
o`030000<ol0<ol000<co`020000Noooo`00Eoooo`03o`2Ioooooooo04?oool00`0003?o03?o0003
<ol000<0003oooooool0N_ooo`00Eoooo`03o`2Ioooooooo04?oool00`0003?o03?o0003<ol000<0
003oooooool0N_ooo`00Eoooo`03o`2Ioooooooo04Coool00`0003?o03?o0002<ol000<0003ooooo
ool0N_ooo`00Eoooo`03o`2Ioooooooo04Coool00`0003?o03?o0002<ol000<0003oooooool0N_oo
o`00Eoooo`03o`2Ioooooooo04Coool00`0003?o03?o0002<ol000<0003oooooool0N_ooo`00Eooo
o`03o`2Ioooooooo04Coool00`0003?o03?o0002<ol000<0003oooooool0N_ooo`00Eoooo`03o`2I
oooooooo04Coool00`0003?o03?o0002<ol00P0007_oool005Ooool00ol0VOooooooo`14oooo00<0
000co`0co`000S?o00030000oooooooo07[oool005Ooool00ol0VOooooooo`14oooo00<0000co`0c
o`000S?o00030000oooooooo07[oool005Ooool00ol0VOooooooo`14oooo00<0000co`0co`000S?o
00030000oooooooo07[oool005Ooool00ol0VOooooooo`14oooo00<0000co`0co`000S?o00030000
oooooooo07[oool005Ooool00ol0VOooooooo`14oooo00<0000co`0co`000S?o00030000oooooooo
07[oool005Ooool00ol0VOooooooo`14oooo00<0000co`0co`000S?o0080001koooo001Goooo00?o
09Woooooool0AOooo`050000<ol0<ol0<ol0000007coool005Ooool00ol0VOooooooo`15oooo00D0
000co`0co`0co`000000O?ooo`00Eoooo`03o`2Ioooooooo04Goool01@0003?o03?o03?o0000001l
oooo001Goooo00?o09Woooooool0@Oooo`D00003<ol000<0003oooooool0N_ooo`00Eoooo`03o`2I
oooooooo047oool01@000?ooooooooooo`000003<ol000<0003oooooool0N_ooo`00Eoooo`03o`2I
oooooooo04;oool010000?ooooooo`0000<co`030000N_ooo`00Eoooo`03o`2Ioooooooo04?oool0
0`000?ooo`000003<ol000<0003oooooool0N_ooo`00Eoooo`03o`2Ioooooooo047oool00`000?oo
ooooo`0200000c?o00030000oooooooo07[oool005Ooool00ol0VOooooooo`12oooo0P000003oooo
0000<ol0008co`000`000?ooooooo`1joooo001Goooo00?o09Woooooool0AOooo`050000<ol0<ol0
<ol0000007coool005Ooool00ol0VOooooooo`16oooo00@0000co`0co`00001loooo001Goooo00?o
09Woooooool0A_ooo`030000<ol0<ol00080001koooo001Goooo00?o09Woooooool0A_ooo`040000
<ol0<ol00000O?ooo`00Eoooo`03o`2Ioooooooo04Koool0100003?o03?o000007coool005Ooool0
0ol0VOooooooo`16oooo00@0000co`0co`00001loooo001Goooo00?o09Woooooool0A_ooo`040000
<ol0<ol00000O?ooo`00Eoooo`03o`2Ioooooooo04Koool0100003?o03?o000007coool005Ooool0
0ol0VOooooooo`16oooo00@0000co`0co`00001loooo001Goooo00?o09Woooooool0Aoooo`040000
<ol000000000Noooo`00Eoooo`03o`2Ioooooooo04Ooool00`0003?o0000001loooo001Goooo00?o
09Woooooool0Aoooo`030000<ol0000007coool005Ooool00ol0VOooooooo`17oooo00<0000co`00
0000O?ooo`00Eoooo`03o`2Ioooooooo04Ooool00`0003?o0000001loooo001Goooo00?o09Wooooo
ool0Aoooo`030000<ol0000007coool005Ooool00ol0VOooooooo`17oooo00@0000co`000000001k
oooo001Goooo00?o09Woooooool0Aoooo`030000<ol0000007coool005Ooool00ol0VOooooooo`17
oooo00<0000co`000000O?ooo`00Eoooo`03o`2Ioooooooo04Ooool00`0003?o0000001loooo001G
oooo00?o09Woooooool0Aoooo`030000<ol0000007coool005Ooool00ol0VOooooooo`17oooo00<0
000co`000000O?ooo`00Eoooo`03o`2Ioooooooo04Ooool0100003?o0000000007_oool005Ooool0
0ol0VOooooooo`17oooo00<0000co`000000O?ooo`00Eoooo`03o`2Ioooooooo04Ooool00`0003?o
0000001loooo001Goooo00?o09Woooooool0Aoooo`030000<ol0000007coool005Ooool00ol0VOoo
ooooo`12oooo0P0000?oool00`0003?o0000001loooo001Goooo00?o09Woooooool0@Oooo`040000
oooooooo00000_ooo`030000<ol0000007coool005Ooool00ol0VOooooooo`13oooo00H0003ooooo
ooooool0000co`030000N_ooo`00Eoooo`03o`2Ioooooooo04Coool01P000?ooooooo`0003?o0000
07coool005Ooool00ol0VOooooooo`11oooo00@0003oooooool00002oooo00<0000co`000000O?oo
o`00Eoooo`03o`2Ioooooooo04;oool200001?ooo`80001loooo001Goooo00?o09Woooooool0B?oo
o`80001loooo001Goooo00?o09Woooooool0B?ooo`80001loooo001Goooo00?o09Woooooool0B?oo
o`80001loooo001Goooo00?o09Woooooool0B?ooo`<0001koooo001Goooo00?o09Woooooool0B?oo
o`80001loooo001Goooo00?o09Woooooool0B?ooo`80001loooo001Goooo00?o09Woooooool0B?oo
o`80001loooo001Goooo00?o09Woooooool0B?ooo`80001loooo001Goooo00?o09Woooooool0B?oo
o`80001loooo001Goooo00?o09Woooooool0B?ooo`<0001koooo001Goooo00?o09Woooooool0B?oo
o`80001loooo001Goooo00?o09Woooooool0B?ooo`80001loooo001Goooo00?o09Woooooool0B?oo
o`80001loooo001Goooo00?o09Woooooool0B?ooo`80001loooo001Goooo00?o09Woooooool0B?oo
o`80001loooo001Goooo00?o09Woooooool0B?ooo`<0001koooo001Goooo00?o09Woooooool0BOoo
o`030000oooooooo07[oool005Ooool00ol0VOooooooo`19oooo00<0003oooooool0N_ooo`00Eooo
o`03o`2Ioooooooo04Woool00`000?ooooooo`1joooo001Goooo00?o09Woooooool0BOooo`030000
oooooooo07[oool005Ooool00ol0VOooooooo`19oooo00<0003oooooool0N_ooo`00Eoooo`03o`2I
oooooooo04Woool20000Noooo`00Eoooo`03o`2Ioooooooo04Woool00`000?ooooooo`1joooo001G
oooo00?o09Woooooool0BOooo`030000oooooooo07[oool005Ooool00ol0VOooooooo`19oooo00<0
003oooooool0N_ooo`00Eoooo`03o`2Ioooooooo04Woool00`000?ooooooo`1joooo001Goooo00?o
09Woooooool0@oooo`<00003oooo00<0003oooooool0N_ooo`00Eoooo`03o`2Ioooooooo04Coool0
0`000?ooooooo`02oooo00<0003oooooool0N_ooo`00Eoooo`03o`2Ioooooooo047oool500000ooo
o`<0001joooo002Koooo00@0003oooooool00021oooo002Loooo00<0003oool00000POooo`00WOoo
o`800021oooo003ooooo8Oooo`00ooooob7oool007Woool00`000?ooooooo`0Xoooo00<0003ooooo
ool0NOooo`00N?ooo`030000oooooooo00Soool00`000?ooooooo`0Ooooo00<0003oooooool0N?oo
o`00N?ooo`030000oooooooo00;oool200001?ooo`030000oooooooo00koool300000_ooo`800004
oooo0P0000Coool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000000_ooo`030000
oooooooo00;oool00`000?ooooooo`04oooo100000Koool00`000?ooooooo`06oooo00@0003ooooo
ool00003oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo00;oool00`000?ooooooo`0C
oooo1@0000Ooool010000?ooooooo`0000Coool00`000?ooooooo`1goooo001hoooo00<0003ooooo
ool01@0001;oool010000?ooooooo`0000Woool200001?ooo`030000oooooooo07Soool007Soool0
1@000?ooooooooooo`00000Foooo00<0003oool000002?ooo`040000oooooooo00000oooo`030000
oooooooo07Soool007Woool00`000?ooooooo`0Hoooo0P0000Woool200000oooo`030000oooooooo
07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-8.12947, \
-1.14361, 0.0496935, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-8.12947, -1.14361, 0.0496935, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.7) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
.2 1 0 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.27193 .12361 L
.27731 .12361 L
.28025 .12361 L
.28302 .12361 L
.28425 .12361 L
.28542 .12361 L
s
.28542 .12361 m
.28567 .61803 L
s
0 .4 1 r
.02381 .13737 m
.04262 .14285 L
.06244 .151 L
.07286 .15658 L
.08255 .16281 L
.10458 .18165 L
.11366 .19183 L
.12328 .20459 L
.1257 .20816 L
.12639 .20922 L
.12706 .21012 L
.1283 .2101 L
.13115 .21006 L
.13383 .21001 L
.14357 .20982 L
.15376 .20958 L
.16488 .20927 L
.17544 .20891 L
.18502 .20852 L
.20469 .20747 L
.21549 .20672 L
.22566 .20587 L
.24574 .20365 L
.26421 .20079 L
.2733 .19899 L
.2783 .19787 L
.28076 .19728 L
.28304 .19671 L
.28434 .19638 L
.28499 .1962 L
.28572 .12361 L
.28644 .12361 L
.28722 .12361 L
.28789 .12361 L
.28863 .12361 L
.28992 .12361 L
.29063 .12361 L
.29129 .12361 L
.29247 .12361 L
.29373 .12361 L
.29502 .12361 L
.29574 .12361 L
.29641 .12361 L
.29765 .12361 L
.29895 .12361 L
.30012 .12361 L
.30121 .12361 L
.30241 .12361 L
.3037 .12361 L
.30439 .12361 L
Mistroke
.30504 .12361 L
.30625 .12361 L
.30755 .12361 L
.30828 .12361 L
.30896 .12361 L
.31019 .12361 L
.31133 .12361 L
.31252 .12361 L
.31383 .12361 L
.31452 .12361 L
.31527 .12361 L
.31597 .12361 L
.31662 .12361 L
.31786 .12361 L
.31917 .12361 L
.31984 .12361 L
.32057 .12361 L
.32188 .12361 L
.32264 .12361 L
.32345 .12361 L
.32413 .12361 L
.32488 .12361 L
.32553 .12361 L
.32624 .12361 L
.32752 .12361 L
.32877 .12361 L
.32992 .12361 L
.33116 .12361 L
.33187 .12361 L
.33253 .12361 L
.33323 .12361 L
.33387 .12361 L
.3346 .12361 L
.3353 .12361 L
.33646 .12361 L
.3377 .12361 L
.33876 .12361 L
.33993 .12361 L
.34118 .12361 L
.34189 .12361 L
.34253 .12361 L
.34372 .12361 L
.34498 .12361 L
.34621 .12361 L
.3469 .12361 L
.34754 .12361 L
.34872 .12361 L
.34997 .12361 L
.35108 .12361 L
.35213 .12361 L
Mistroke
.35328 .12361 L
.35451 .12361 L
.35581 .12361 L
.35655 .12361 L
.35724 .12361 L
.35849 .12361 L
.35919 .12361 L
.35983 .12361 L
.36103 .12361 L
.36234 .12361 L
.36356 .12361 L
.3647 .12361 L
.36576 .12361 L
.3669 .12361 L
.36797 .12361 L
.36895 .12361 L
.3701 .12361 L
.37135 .12361 L
.37253 .12361 L
.37363 .12361 L
.37476 .12361 L
.376 .12361 L
.37722 .12361 L
.37852 .12361 L
.37968 .12361 L
.38089 .12361 L
.38192 .12361 L
.38305 .12361 L
.38438 .12361 L
.38559 .12361 L
.38623 .12361 L
.38693 .12361 L
.38766 .12361 L
.38835 .12361 L
.3896 .12361 L
.39075 .12361 L
.39139 .12361 L
.39208 .12361 L
.39334 .12361 L
.39457 .12361 L
.39569 .12361 L
.39698 .12361 L
.39819 .12361 L
.39931 .12361 L
.40035 .12361 L
.40148 .12361 L
.40268 .12361 L
.40399 .12361 L
.40518 .12361 L
.40584 .12361 L
Mistroke
.40656 .12361 L
.40786 .12361 L
.40907 .12361 L
.41036 .12361 L
.41147 .12361 L
.41268 .12361 L
.41341 .12361 L
.4141 .12361 L
.4154 .12361 L
.41613 .12361 L
.41681 .12361 L
.41755 .12361 L
.41834 .12361 L
.41902 .12361 L
.41977 .12361 L
.42047 .12361 L
.42111 .12361 L
.42234 .12361 L
.42364 .12361 L
.42485 .12361 L
.42554 .12361 L
.42618 .12361 L
.42735 .12361 L
.42859 .12361 L
.4297 .12361 L
.43074 .12361 L
.43188 .12361 L
.43311 .12361 L
.43434 .12361 L
.43504 .12361 L
.43569 .12361 L
.43642 .12361 L
.43711 .12361 L
.43841 .12361 L
.43953 .12361 L
.44075 .12361 L
.44206 .12361 L
.44326 .12361 L
.44432 .12361 L
.44545 .12361 L
.44652 .12361 L
.4475 .12361 L
.44992 .12361 L
.4511 .12361 L
.45217 .12361 L
.45329 .12361 L
.45448 .12361 L
.45578 .12361 L
.457 .12361 L
.45815 .12361 L
Mistroke
.45921 .12361 L
.46037 .12361 L
.4616 .12361 L
.46282 .12361 L
.46351 .12361 L
.46415 .12361 L
.46532 .12361 L
.46657 .12361 L
.46763 .12361 L
.46874 .12361 L
.46997 .12361 L
.47109 .12361 L
.47229 .12361 L
.47359 .12361 L
.4748 .12361 L
.47593 .12361 L
.47663 .12361 L
.47728 .12361 L
.47851 .12361 L
.47983 .12361 L
.48058 .12361 L
.48126 .12361 L
.48232 .12361 L
.48346 .12361 L
.48453 .12361 L
.48551 .12361 L
.48666 .12361 L
.48791 .12361 L
.48909 .12361 L
.49018 .12361 L
.4913 .12361 L
.49235 .12361 L
.4935 .12361 L
.49475 .12361 L
.49598 .12361 L
.49728 .12361 L
.49839 .12361 L
.49961 .12361 L
.50092 .12361 L
.50213 .12361 L
.50277 .12361 L
.50347 .12361 L
.50419 .12361 L
.50488 .12361 L
.50613 .12361 L
.50728 .12361 L
.50791 .12361 L
.5086 .12361 L
.50986 .12361 L
.51109 .12361 L
Mistroke
.5122 .12361 L
.51348 .12361 L
.5147 .12361 L
.51582 .12361 L
.51685 .12361 L
.51799 .12361 L
.51918 .12361 L
.52049 .12361 L
.52168 .12361 L
.52233 .12361 L
.52305 .12361 L
.52435 .12361 L
.52556 .12361 L
.52685 .12361 L
.52795 .12361 L
.52917 .12361 L
.52986 .12361 L
.53059 .12361 L
.53189 .12361 L
.53261 .12361 L
.53329 .12361 L
.53403 .12361 L
.53482 .12361 L
.5355 .12361 L
.53625 .12361 L
.53695 .12361 L
.5376 .12361 L
.53882 .12361 L
.54012 .12361 L
.54133 .12361 L
.54265 .12361 L
.5439 .12361 L
.54506 .12361 L
.5462 .12361 L
.54724 .12361 L
.54844 .12361 L
.54956 .12361 L
.5508 .12361 L
.5521 .12361 L
.55322 .12361 L
.55444 .12361 L
.55575 .12361 L
.55649 .12361 L
.55716 .12361 L
.55847 .12361 L
.5597 .12361 L
.56076 .12361 L
.56192 .12361 L
.56313 .12361 L
.56427 .12361 L
Mistroke
.56533 .12361 L
.5663 .12361 L
.56742 .12361 L
.56848 .12361 L
.56963 .12361 L
.57085 .12361 L
.572 .12361 L
.57304 .12361 L
.57427 .12361 L
.57496 .12361 L
.5756 .12361 L
.57678 .12361 L
.57802 .12361 L
.57923 .12361 L
.57992 .12361 L
.58056 .12361 L
.58297 .12361 L
.58748 .12361 L
.59764 .12361 L
.61597 .12361 L
.65521 .12361 L
.69293 .12361 L
.73311 .12361 L
.77177 .12361 L
.81289 .12361 L
.85249 .12361 L
.89057 .12361 L
.93111 .12361 L
.97013 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.7) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Koooo1@00083oool009goool00`000?ooooooo`20oooo002Moooo00<0003ooooo
ool00oooo`<0001joooo002Eoooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0N_oo
o`00WOooo`030000oooooooo00?oool00`000?ooooooo`1joooo002Loooo0P0000Goool00`000?oo
ooooo`1joooo002Soooo00<0003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool2
0000Noooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0
003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002S
oooo00<0003oooooool0N_ooo`00Xoooo`80001koooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool00:?oool20000Noooo`00:oooo`<0000Xoooo0`0002?oool4
00008oooo`030000oooooooo02?oool400009oooo`<0000Yoooo000[oooo00@0003oooooool0000X
oooo00<0003oooooool08_ooo`030000oooooooo02Coool00`000?ooooooo`0Soooo00<0003ooooo
ool0:Oooo`030000oooooooo02Soool002_oool010000?ooooooo`0002Goool500009?ooo`030000
oooooooo02?oool00`000?ooooooo`0Toooo00<0003oooooool09Oooo`D0000Yoooo000Uoooo1000
00;oool300008?ooo`@00002oooo00@0003oooooool0000Noooo100000Coool00`000?ooooooo`0R
oooo00<0003oooooool09Oooo`030000oooooooo02Coool010000?ooooooo`0002[oool002coool0
0`000?ooooooo`0Voooo00<0003oool000009?ooo`040000oooooooo00008oooo`030000oooooooo
02?oool010000?ooooooo`0002Koool00`000?ooo`00000Zoooo000/oooo0`0002Ooool200009Ooo
o`80000Toooo0P0002Goool20000:?ooo`80000Zoooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool0013ooooo00004Oooo`005_ooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00?oool01@1Vooooooooooooo`000009oooo00<0
003oooooool01oooo`030000oooo0000010000000c?o000003?o0008<ol000<0000co`0co`001c?o
00030000<ol0<ol000Lco`000`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo
00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?oo
ooooo`08oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0
003oooooool05Oooo`00:_ooo`030000oooooooo02Koool00`000?ooooooo`03oooo00<0I_oooooo
ool07oooo`030000oooooooo00Koool400006c?o00030000oooooooo02Goool00`000?ooooooo`0V
oooo00<0003oooooool0:Oooo`00FOooo`0306Kooooooooo02coool400005c?o00030000oooooooo
07[oool001Koool306Ko@?ooo`0306Kooooooooo033oool00`0003?o03?o000D<ol000<0003ooooo
ool0N_ooo`006Oooo`@0I_lloooo00<0I_ooooooool0<Oooo`80000D<ol000<0003oooooool0N_oo
o`007Oooo`80I_ljoooo00<0I_ooooooool0<oooo`030000<ol0<ol0014co`000`000?ooooooo`1j
oooo000Ooooo0P1VocSoool00`1Vooooooooo`0doooo00<0000co`0co`0043?o0080001koooo000Q
oooo0P1VocKoool00`1Vooooooooo`0eoooo0P00010co`000`000?ooooooo`1joooo000Soooo00<0
I_ooooooool0<oooo`0306Kooooooooo03Ooool00`0003?o03?o000=<ol000<0003oooooool0N_oo
o`009?ooo`80I_lboooo00<0I_oo09Woool0>?ooo`030000<ol0<ol000dco`000`000?ooooooo`1j
oooo000Voooo00<0I_ooooooool0;oooo`0306Koo`2Ioooo03Woool00`0003?o03?o000<<ol000<0
003oooooool0N_ooo`009oooo`0306Kooooooooo02koool00`1Vool0VOooo`0ioooo00<0000co`0c
o`0033?o00030000oooooooo07[oool002Soool206Ko;_ooo`0306Koo`2Ioooo03[oool00`0003?o
03?o000;<ol00P0007_oool002[oool00`1Vooooooooo`0[oooo00<0I_oo09Woool0>_ooo`030000
<ol0<ol000/co`000`000?ooooooo`1joooo000[oooo00<0I_ooooooool0:_ooo`0306Koo`2Ioooo
03_oool00`0003?o03?o000:<ol000<0003oooooool0N_ooo`00;?ooo`0306Kooooooooo02Woool0
0`1Vool0VOooo`0koooo00<0000co`0co`002S?o00030000oooooooo07[oool002coool00`1Voooo
ooooo`0Yoooo00<0I_oo09Woool0??ooo`030000<ol0<ol000Tco`000`000?ooooooo`1joooo000]
oooo00<0I_ooooooool0:?ooo`0306Koo`2Ioooo03coool00`0003?o03?o0009<ol000<0003ooooo
ool0N_ooo`00;_ooo`0306Kooooooooo02Koool206Ko00?o09Woooooool0??ooo`030000<ol0<ol0
00Pco`020000Noooo`00;_ooo`0306Kooooooooo027oool506Ko0_ooo`03o`2Ioooooooo03coool0
0`0003?o03?o0008<ol000<0003oooooool0N_ooo`00;oooo`0306Kooooooooo01Coool<06Ko1ooo
o`03o`2Ioooooooo03coool00`0003?o03?o0008<ol000<0003oooooool0N_ooo`00<?oooaH0I_lC
oooo00?o09Woooooool0?Oooo`030000<ol0<ol000Lco`000`000?ooooooo`1joooo001Ioooo00?o
09Woooooool0?Oooo`030000<ol0<ol000Lco`000`000?ooooooo`1joooo001Ioooo00?o09Wooooo
ool0?Oooo`030000<ol0<ol000Lco`000`000?ooooooo`1joooo001Ioooo00?o09Woooooool0?Ooo
o`030000<ol0<ol000Lco`020000Noooo`00FOooo`03o`2Ioooooooo03koool00`0003?o03?o0006
<ol000<0003oooooool0N_ooo`00FOooo`03o`2Ioooooooo03koool00`0003?o03?o0006<ol000<0
003oooooool0N_ooo`00FOooo`03o`2Ioooooooo03koool00`0003?o03?o0006<ol000<0003ooooo
ool0N_ooo`00FOooo`03o`2Ioooooooo03koool00`0003?o03?o0006<ol000<0003oooooool0N_oo
o`00FOooo`03o`2Ioooooooo03ooool500000c?o00030000oooooooo07[oool005Woool00ol0VOoo
ooooo`0ooooo00<0000co`0000001C?o00030000oooooooo07[oool005Woool00ol0VOooooooo`0o
oooo00<0000co`0000001C?o00<0001joooo001Ioooo00?o09Woooooool0@?ooo`800005<ol000<0
003oooooool0N_ooo`00FOooo`03o`2Ioooooooo043oool200001C?o00030000oooooooo07[oool0
05Woool00ol0VOooooooo`10oooo0P0000Dco`000`000?ooooooo`1joooo001Ioooo00?o09Wooooo
ool0@?ooo`030000<ol0<ol000@co`000`000?ooooooo`1joooo001Ioooo00?o09Woooooool0@?oo
o`030000<ol0<ol000@co`000`000?ooooooo`1joooo001Ioooo00?o09Woooooool0@?ooo`030000
<ol0<ol000@co`020000Noooo`00FOooo`03o`2Ioooooooo047oool00`0003?o03?o0003<ol000<0
003oooooool0N_ooo`00FOooo`03o`2Ioooooooo047oool00`0003?o03?o0003<ol000<0003ooooo
ool0N_ooo`00FOooo`03o`2Ioooooooo047oool00`0003?o03?o0003<ol000<0003oooooool0N_oo
o`00FOooo`03o`2Ioooooooo047oool00`0003?o03?o0003<ol000<0003oooooool0N_ooo`00FOoo
o`03o`2Ioooooooo047oool00`0003?o03?o0003<ol000<0003oooooool0N_ooo`00FOooo`03o`2I
oooooooo047oool00`0003?o03?o0003<ol00P0007_oool005Woool00ol0VOooooooo`11oooo00<0
000co`0co`000c?o00030000oooooooo07[oool005Woool00ol0VOooooooo`11oooo00<0000co`0c
o`000c?o00030000oooooooo07[oool005Woool00ol0VOooooooo`12oooo00<0000co`0co`000S?o
00030000oooooooo07[oool005Woool00ol0VOooooooo`12oooo00<0000co`0co`000S?o00030000
oooooooo07[oool005Woool00ol0VOooooooo`12oooo00<0000co`0co`000S?o00030000oooooooo
07[oool005Woool00ol0VOooooooo`12oooo00<0000co`0co`000S?o00030000oooooooo07[oool0
05Woool00ol0VOooooooo`12oooo00<0000co`0co`000S?o0080001koooo001Ioooo00?o09Wooooo
ool0@_ooo`030000<ol0<ol0008co`000`000?ooooooo`1joooo001Ioooo00?o09Woooooool0@_oo
o`030000<ol0<ol0008co`000`000?ooooooo`1joooo001Ioooo00?o09Woooooool0@_ooo`030000
<ol0<ol0008co`000`000?ooooooo`1joooo001Ioooo00?o09Woooooool0@_ooo`030000<ol0<ol0
008co`000`000?ooooooo`1joooo001Ioooo00?o09Woooooool0@_ooo`030000<ol0<ol0008co`00
0`000?ooooooo`1joooo001Ioooo00?o09Woooooool0@_ooo`030000<ol0<ol0008co`020000Nooo
o`00FOooo`03o`2Ioooooooo04?oool01@0003?o03?o03?o0000001loooo001Ioooo00?o09Wooooo
ool0@oooo`050000<ol0<ol0<ol0000007coool005Woool00ol0VOooooooo`13oooo00D0000co`0c
o`0co`000000O?ooo`00FOooo`03o`2Ioooooooo03ooool500000c?o00030000oooooooo07[oool0
05Woool00ol0VOooooooo`0ooooo00D0003oooooooooool000000c?o00030000oooooooo07[oool0
05Woool00ol0VOooooooo`10oooo00@0003oooooool00003<ol00`0007[oool005Woool00ol0VOoo
ooooo`11oooo00<0003oool000000c?o00030000oooooooo07[oool005Woool00ol0VOooooooo`0o
oooo00<0003oooooool00P0000<co`000`000?ooooooo`1joooo001Ioooo00?o09Woooooool0@?oo
o`8000000oooo`0003?o0002<ol000<0003oooooool0N_ooo`00FOooo`03o`2Ioooooooo04?oool0
1@0003?o03?o03?o0000001loooo001Ioooo00?o09Woooooool0A?ooo`040000<ol0<ol00000O?oo
o`00FOooo`03o`2Ioooooooo04Coool00`0003?o03?o00020000Noooo`00FOooo`03o`2Ioooooooo
04Coool0100003?o03?o000007coool005Woool00ol0VOooooooo`14oooo00@0000co`0co`00001l
oooo001Ioooo00?o09Woooooool0A?ooo`040000<ol0<ol00000O?ooo`00FOooo`03o`2Ioooooooo
04Coool0100003?o03?o000007coool005Woool00ol0VOooooooo`14oooo00@0000co`0co`00001l
oooo001Ioooo00?o09Woooooool0A?ooo`040000<ol0<ol00000O?ooo`00FOooo`03o`2Ioooooooo
04Goool0100003?o0000000007_oool005Woool00ol0VOooooooo`15oooo00<0000co`000000O?oo
o`00FOooo`03o`2Ioooooooo04Goool00`0003?o0000001loooo001Ioooo00?o09Woooooool0AOoo
o`030000<ol0000007coool005Woool00ol0VOooooooo`15oooo00<0000co`000000O?ooo`00FOoo
o`03o`2Ioooooooo04Goool00`0003?o0000001loooo001Ioooo00?o09Woooooool0AOooo`040000
<ol000000000Noooo`00FOooo`03o`2Ioooooooo04Goool00`0003?o0000001loooo001Ioooo00?o
09Woooooool0AOooo`030000<ol0000007coool005Woool00ol0VOooooooo`15oooo00<0000co`00
0000O?ooo`00FOooo`03o`2Ioooooooo04Goool00`0003?o0000001loooo001Ioooo00?o09Wooooo
ool0AOooo`030000<ol0000007coool005Woool00ol0VOooooooo`15oooo00@0000co`000000001k
oooo001Ioooo00?o09Woooooool0AOooo`030000<ol0000007coool005Woool00ol0VOooooooo`15
oooo00<0000co`000000O?ooo`00FOooo`03o`2Ioooooooo04Goool00`0003?o0000001loooo001I
oooo00?o09Woooooool0@?ooo`800003oooo00<0000co`000000O?ooo`00FOooo`03o`2Ioooooooo
03ooool010000?ooooooo`0000;oool00`0003?o0000001loooo001Ioooo00?o09Woooooool0@Ooo
o`060000oooooooooooo0000<ol00`0007[oool005Woool00ol0VOooooooo`12oooo00H0003ooooo
ool0000co`00001loooo001Ioooo00?o09Woooooool0?oooo`040000oooooooo00000_ooo`030000
<ol0000007coool005Woool00ol0VOooooooo`10oooo0P0000Coool20000O?ooo`00FOooo`03o`2I
oooooooo04Koool20000O?ooo`00FOooo`03o`2Ioooooooo04Koool20000O?ooo`00FOooo`03o`2I
oooooooo04Koool20000O?ooo`00FOooo`03o`2Ioooooooo04Koool30000Noooo`00FOooo`03o`2I
oooooooo04Koool20000O?ooo`00FOooo`03o`2Ioooooooo04Koool20000O?ooo`00FOooo`03o`2I
oooooooo04Koool20000O?ooo`00FOooo`03o`2Ioooooooo04Koool20000O?ooo`00FOooo`03o`2I
oooooooo04Koool20000O?ooo`00FOooo`03o`2Ioooooooo04Koool30000Noooo`00FOooo`03o`2I
oooooooo04Koool20000O?ooo`00FOooo`03o`2Ioooooooo04Koool20000O?ooo`00FOooo`03o`2I
oooooooo04Koool20000O?ooo`00FOooo`03o`2Ioooooooo04Koool20000O?ooo`00FOooo`03o`2I
oooooooo04Koool20000O?ooo`00FOooo`03o`2Ioooooooo04Koool30000Noooo`00FOooo`03o`2I
oooooooo04Ooool00`000?ooooooo`1joooo001Ioooo00?o09Woooooool0Aoooo`030000oooooooo
07[oool005Woool00ol0VOooooooo`17oooo00<0003oooooool0N_ooo`00FOooo`03o`2Ioooooooo
04Ooool00`000?ooooooo`1joooo001Ioooo00?o09Woooooool0Aoooo`030000oooooooo07[oool0
05Woool00ol0VOooooooo`17oooo0P0007_oool005Woool00ol0VOooooooo`17oooo00<0003ooooo
ool0N_ooo`00FOooo`03o`2Ioooooooo04Ooool00`000?ooooooo`1joooo001Ioooo00?o09Wooooo
ool0Aoooo`030000oooooooo07[oool005Woool00ol0VOooooooo`17oooo00<0003oooooool0N_oo
o`00FOooo`03o`2Ioooooooo047oool300000oooo`030000oooooooo07[oool005Woool00ol0VOoo
ooooo`12oooo00<0003oooooool00_ooo`030000oooooooo07[oool005Woool00ol0VOooooooo`0o
oooo1@0000?oool30000N_ooo`00Voooo`040000oooooooo0000POooo`00W?ooo`030000oooo0000
087oool009goool20000POooo`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?oo
o`030000oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000
oooooooo07Soool007Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0>oooo0`00
00;oool200001Oooo`030000oooooooo00;oool00`000?ooooooo`1hoooo001hoooo00D0003ooooo
ooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`04oooo100000Koool00`000?oo
ooooo`08oooo00<0003oooooool00_ooo`030000oooooooo07Soool007Ooool00`000?ooooooo`02
oooo00<0003oooooool04oooo`D00009oooo00<0003oooooool00oooo`030000oooooooo07Ooool0
07Soool00`000?ooooooo`0500004_ooo`040000oooooooo00002oooo`050000oooooooooooo0000
07[oool007Soool01@000?ooooooooooo`00000Foooo00<0003oool000002?ooo`040000oooooooo
00000oooo`030000oooooooo07Soool007Woool00`000?ooooooo`0Hoooo0P0000Soool400000_oo
o`030000oooooooo07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-8.12947, \
-1.14361, 0.0496935, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-8.12947, -1.14361, 0.0496935, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
.2 1 0 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.27193 .12361 L
.28302 .12361 L
.2881 .12361 L
.29088 .12361 L
.29224 .12361 L
.29349 .12361 L
s
.29349 .12361 m
.29394 .61803 L
s
0 .4 1 r
.02381 .13555 m
.04262 .14031 L
.06244 .14739 L
.07286 .15223 L
.08255 .15764 L
.10458 .17399 L
.12328 .19391 L
.12836 .20058 L
.13313 .2074 L
.13436 .20926 L
.13552 .21011 L
.13617 .2101 L
.13687 .21009 L
.1381 .21007 L
.14357 .20998 L
.15465 .20975 L
.16488 .2095 L
.17544 .20918 L
.18502 .20885 L
.20469 .20794 L
.21549 .20728 L
.22566 .20654 L
.24574 .20462 L
.26421 .20213 L
.2733 .20057 L
.28304 .1986 L
.28591 .19794 L
.28863 .1973 L
.29107 .19669 L
.29174 .19651 L
.29245 .19633 L
.29373 .12361 L
.2949 .12361 L
.29617 .12361 L
.29737 .12361 L
.29847 .12361 L
.29969 .12361 L
.30038 .12361 L
.30102 .12361 L
.30232 .12361 L
.30304 .12361 L
.3037 .12361 L
.30489 .12361 L
.30601 .12361 L
.30724 .12361 L
.30855 .12361 L
.30921 .12361 L
.30993 .12361 L
.31123 .12361 L
.3125 .12361 L
Mistroke
.31368 .12361 L
.31489 .12361 L
.31602 .12361 L
.31704 .12361 L
.31814 .12361 L
.31934 .12361 L
.32061 .12361 L
.3217 .12361 L
.32289 .12361 L
.32419 .12361 L
.32484 .12361 L
.32557 .12361 L
.32635 .12361 L
.32708 .12361 L
.32776 .12361 L
.32848 .12361 L
.32912 .12361 L
.32983 .12361 L
.33056 .12361 L
.33124 .12361 L
.33247 .12361 L
.33377 .12361 L
.33506 .12361 L
.33578 .12361 L
.33645 .12361 L
.33767 .12361 L
.33897 .12361 L
.34013 .12361 L
.34122 .12361 L
.34241 .12361 L
.34368 .12361 L
.34499 .12361 L
.3462 .12361 L
.34683 .12361 L
.34752 .12361 L
.34825 .12361 L
.34893 .12361 L
.35018 .12361 L
.35132 .12361 L
.35197 .12361 L
.35266 .12361 L
.35391 .12361 L
.35504 .12361 L
.35607 .12361 L
.35729 .12361 L
.35845 .12361 L
.35964 .12361 L
.36074 .12361 L
.36195 .12361 L
.36323 .12361 L
Mistroke
.36453 .12361 L
.36571 .12361 L
.36636 .12361 L
.36708 .12361 L
.36838 .12361 L
.36959 .12361 L
.37088 .12361 L
.37209 .12361 L
.37319 .12361 L
.37388 .12361 L
.37461 .12361 L
.37591 .12361 L
.37663 .12361 L
.37731 .12361 L
.37805 .12361 L
.37884 .12361 L
.37953 .12361 L
.38027 .12361 L
.38097 .12361 L
.38162 .12361 L
.38285 .12361 L
.38416 .12361 L
.3853 .12361 L
.38655 .12361 L
.38785 .12361 L
.38905 .12361 L
.39019 .12361 L
.39122 .12361 L
.39242 .12361 L
.39354 .12361 L
.39477 .12361 L
.39606 .12361 L
.39717 .12361 L
.39839 .12361 L
.3997 .12361 L
.40044 .12361 L
.40111 .12361 L
.40241 .12361 L
.40365 .12361 L
.4047 .12361 L
.40583 .12361 L
.4069 .12361 L
.40789 .12361 L
.40904 .12361 L
.41025 .12361 L
.4124 .12361 L
.41354 .12361 L
.41476 .12361 L
.41546 .12361 L
.4161 .12361 L
Mistroke
.41735 .12361 L
.41849 .12361 L
.41971 .12361 L
.42085 .12361 L
.42193 .12361 L
.42313 .12361 L
.42423 .12361 L
.42544 .12361 L
.42676 .12361 L
.42804 .12361 L
.42876 .12361 L
.42941 .12361 L
.43068 .12361 L
.43188 .12361 L
.433 .12361 L
.43418 .12361 L
.43519 .12361 L
.43629 .12361 L
.43747 .12361 L
.43875 .12361 L
.43995 .12361 L
.44107 .12361 L
.44238 .12361 L
.44305 .12361 L
.44378 .12361 L
.44506 .12361 L
.44625 .12361 L
.44693 .12361 L
.44765 .12361 L
.44893 .12361 L
.44964 .12361 L
.45031 .12361 L
.45104 .12361 L
.45181 .12361 L
.45311 .12361 L
.45384 .12361 L
.45452 .12361 L
.45576 .12361 L
.45707 .12361 L
.45825 .12361 L
.45935 .12361 L
.46055 .12361 L
.46185 .12361 L
.46254 .12361 L
.46318 .12361 L
.46439 .12361 L
.46569 .12361 L
.46643 .12361 L
.4671 .12361 L
.46823 .12361 L
Mistroke
.46947 .12361 L
.47077 .12361 L
.47197 .12361 L
.47266 .12361 L
.47341 .12361 L
.47411 .12361 L
.47476 .12361 L
.476 .12361 L
.4773 .12361 L
.478 .12361 L
.47864 .12361 L
.47932 .12361 L
.48005 .12361 L
.4808 .12361 L
.4816 .12361 L
.48234 .12361 L
.48301 .12361 L
.48423 .12361 L
.48555 .12361 L
.4868 .12361 L
.48795 .12361 L
.48902 .12361 L
.49019 .12361 L
.49142 .12361 L
.49257 .12361 L
.49323 .12361 L
.49394 .12361 L
.49523 .12361 L
.49649 .12361 L
.49766 .12361 L
.49891 .12361 L
.49963 .12361 L
.5003 .12361 L
.50096 .12361 L
.50165 .12361 L
.50241 .12361 L
.50311 .12361 L
.50434 .12361 L
.50504 .12361 L
.50568 .12361 L
.50685 .12361 L
.5081 .12361 L
.50921 .12361 L
.51026 .12361 L
.5114 .12361 L
.51264 .12361 L
.51394 .12361 L
.51468 .12361 L
.51536 .12361 L
.51662 .12361 L
Mistroke
.51732 .12361 L
.51795 .12361 L
.51916 .12361 L
.52046 .12361 L
.52169 .12361 L
.52282 .12361 L
.52388 .12361 L
.52502 .12361 L
.5261 .12361 L
.52708 .12361 L
.52823 .12361 L
.52948 .12361 L
.53066 .12361 L
.53175 .12361 L
.53287 .12361 L
.53392 .12361 L
.53508 .12361 L
.53632 .12361 L
.53755 .12361 L
.53885 .12361 L
.53996 .12361 L
.54118 .12361 L
.5425 .12361 L
.54371 .12361 L
.54435 .12361 L
.54505 .12361 L
.54578 .12361 L
.54646 .12361 L
.54772 .12361 L
.54887 .12361 L
.54951 .12361 L
.5502 .12361 L
.55146 .12361 L
.55269 .12361 L
.5538 .12361 L
.55509 .12361 L
.5563 .12361 L
.55743 .12361 L
.55846 .12361 L
.5596 .12361 L
.56079 .12361 L
.5621 .12361 L
.56329 .12361 L
.56395 .12361 L
.56467 .12361 L
.56597 .12361 L
.56718 .12361 L
.56847 .12361 L
.56957 .12361 L
.57079 .12361 L
Mistroke
.57152 .12361 L
.57221 .12361 L
.57351 .12361 L
.57424 .12361 L
.57491 .12361 L
.57565 .12361 L
.57644 .12361 L
.57713 .12361 L
.57787 .12361 L
.57858 .12361 L
.57922 .12361 L
.58045 .12361 L
.58175 .12361 L
.61969 .12361 L
.66009 .12361 L
.69898 .12361 L
.74031 .12361 L
.78013 .12361 L
.81844 .12361 L
.8592 .12361 L
.89844 .12361 L
.93616 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Koooo1@00083oool009goool00`000?ooooooo`20oooo002Moooo00<0003ooooo
ool00oooo`<0001joooo002Eoooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0N_oo
o`00WOooo`030000oooooooo00?oool00`000?ooooooo`1joooo002Loooo0P0000Goool00`000?oo
ooooo`1joooo002Soooo00<0003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool2
0000Noooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0
003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002S
oooo00<0003oooooool0N_ooo`00Xoooo`80001koooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool00:?oool20000Noooo`00:oooo`<0000Xoooo0`0002?oool4
00008oooo`030000oooooooo02?oool400009oooo`<0000Yoooo000[oooo00@0003oooooool0000X
oooo00<0003oooooool08_ooo`030000oooooooo02Coool00`000?ooooooo`0Soooo00<0003ooooo
ool0:Oooo`030000oooooooo02Soool002_oool010000?ooooooo`0002Goool500009?ooo`030000
oooooooo02?oool00`000?ooooooo`0Toooo00<0003oooooool09Oooo`D0000Yoooo000Uoooo1000
00;oool300008?ooo`@00002oooo00@0003oooooool0000Noooo100000Coool00`000?ooooooo`0R
oooo00<0003oooooool09Oooo`030000oooooooo02Coool010000?ooooooo`0002[oool002coool0
0`000?ooooooo`0Voooo00<0003oool000009?ooo`040000oooooooo00008oooo`030000oooooooo
02?oool010000?ooooooo`0002Koool00`000?ooo`00000Zoooo000/oooo0`0002Ooool200009Ooo
o`80000Toooo0P0002Goool20000:?ooo`80000Zoooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool0013ooooo00004Oooo`005_ooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Goool00`1Vooooo`000009oooo00<0003ooooo
ool01oooo`030000oooo0000010000000c?o000003?o0008<ol000<0000co`0co`001c?o00030000
<ol0<ol000Lco`000`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool05Oooo`00:_ooo`030000oooooooo02Koool00`000?ooooooo`05oooo00<0I_ooooooool07Ooo
o`030000oooooooo00Koool400006c?o00030000oooooooo02Goool00`000?ooooooo`0Voooo00<0
003oooooool0:Oooo`005_ooo`80I_m3oooo00<0I_ooooooool0:_ooo`@0000G<ol000<0003ooooo
ool0N_ooo`006?ooo`80I_m1oooo00<0I_ooooooool0;_ooo`030000<ol0<ol001@co`000`000?oo
ooooo`1joooo000Joooo101Vocgoool00`1Vooooooooo`0_oooo0P0001@co`000`000?ooooooo`1j
oooo000Noooo0`1Voc[oool00`1Vooooooooo`0aoooo00<0000co`0co`004C?o00030000oooooooo
07[oool0027oool206Ko>?ooo`0306Kooooooooo03;oool00`0003?o03?o000@<ol00P0007_oool0
02?oool00`1Vooooooooo`0eoooo00<0I_ooooooool0<oooo`80000@<ol000<0003oooooool0N_oo
o`009?ooo`80I_leoooo00<0I_ooooooool0=Oooo`030000<ol0<ol000dco`000`000?ooooooo`1j
oooo000Voooo0P1Voc;oool00`1Vool0VOooo`0foooo00<0000co`0co`003C?o00030000oooooooo
07[oool002Soool00`1Vooooooooo`0_oooo00<0I_oo09Woool0=oooo`030000<ol0<ol000`co`00
0`000?ooooooo`1joooo000Yoooo0P1Vobooool00`1Vool0VOooo`0goooo00<0000co`0co`0033?o
00030000oooooooo07[oool002_oool00`1Vooooooooo`0/oooo00<0I_oo09Woool0>?ooo`030000
<ol0<ol000/co`020000Noooo`00;?ooo`0306Kooooooooo02_oool00`1Vool0VOooo`0hoooo00<0
000co`0co`002c?o00030000oooooooo07[oool002goool00`1Vooooooooo`0Zoooo00<0I_oo09Wo
ool0>Oooo`030000<ol0<ol000Xco`000`000?ooooooo`1joooo000]oooo00<0I_ooooooool0:_oo
o`0306Koo`2Ioooo03Woool00`0003?o03?o000:<ol000<0003oooooool0N_ooo`00;_ooo`0306Ko
oooooooo02Woool00`1Vool0VOooo`0joooo00<0000co`0co`002C?o00030000oooooooo07[oool0
02ooool00`1Vooooooooo`0Xoooo00<0I_oo09Woool0>_ooo`030000<ol0<ol000Tco`000`000?oo
ooooo`1joooo000`oooo00<0I_ooooooool09?ooo`@0I_l00ol0VOooooooo`0joooo00<0000co`0c
o`0023?o0080001koooo000aoooo00<0I_ooooooool07_ooo`D0I_l4oooo00?o09Woooooool0>_oo
o`030000<ol0<ol000Pco`000`000?ooooooo`1joooo000aoooo00<0I_ooooooool05Oooo`T0I_l9
oooo00?o09Woooooool0>_ooo`030000<ol0<ol000Pco`000`000?ooooooo`1joooo000boooo5`1V
oa;oool00ol0VOooooooo`0koooo00<0000co`0co`001c?o00030000oooooooo07[oool005_oool0
0ol0VOooooooo`0koooo00<0000co`0co`001c?o00030000oooooooo07[oool005_oool00ol0VOoo
ooooo`0koooo00<0000co`0co`001c?o00030000oooooooo07[oool005_oool00ol0VOooooooo`0k
oooo00<0000co`0co`001c?o0080001koooo001Koooo00?o09Woooooool0??ooo`030000<ol0<ol0
00Hco`000`000?ooooooo`1joooo001Koooo00?o09Woooooool0??ooo`030000<ol0<ol000Hco`00
0`000?ooooooo`1joooo001Koooo00?o09Woooooool0??ooo`030000<ol0<ol000Hco`000`000?oo
ooooo`1joooo001Koooo00?o09Woooooool0??ooo`030000<ol0<ol000Hco`000`000?ooooooo`1j
oooo001Koooo00?o09Woooooool0?Oooo`D00003<ol000<0003oooooool0N_ooo`00Foooo`03o`2I
oooooooo03goool00`0003?o00000005<ol000<0003oooooool0N_ooo`00Foooo`03o`2Ioooooooo
03goool00`0003?o00000005<ol00`0007[oool005_oool00ol0VOooooooo`0noooo0P0000Dco`00
0`000?ooooooo`1joooo001Koooo00?o09Woooooool0?_ooo`800005<ol000<0003oooooool0N_oo
o`00Foooo`03o`2Ioooooooo03koool200001C?o00030000oooooooo07[oool005_oool00ol0VOoo
ooooo`0noooo00<0000co`0co`0013?o00030000oooooooo07[oool005_oool00ol0VOooooooo`0n
oooo00<0000co`0co`0013?o00030000oooooooo07[oool005_oool00ol0VOooooooo`0noooo00<0
000co`0co`0013?o0080001koooo001Koooo00?o09Woooooool0?oooo`030000<ol0<ol000<co`00
0`000?ooooooo`1joooo001Koooo00?o09Woooooool0?oooo`030000<ol0<ol000<co`000`000?oo
ooooo`1joooo001Koooo00?o09Woooooool0?oooo`030000<ol0<ol000<co`000`000?ooooooo`1j
oooo001Koooo00?o09Woooooool0?oooo`030000<ol0<ol000<co`000`000?ooooooo`1joooo001K
oooo00?o09Woooooool0?oooo`030000<ol0<ol000<co`000`000?ooooooo`1joooo001Koooo00?o
09Woooooool0?oooo`030000<ol0<ol000<co`020000Noooo`00Foooo`03o`2Ioooooooo03ooool0
0`0003?o03?o0003<ol000<0003oooooool0N_ooo`00Foooo`03o`2Ioooooooo03ooool00`0003?o
03?o0003<ol000<0003oooooool0N_ooo`00Foooo`03o`2Ioooooooo043oool00`0003?o03?o0002
<ol000<0003oooooool0N_ooo`00Foooo`03o`2Ioooooooo043oool00`0003?o03?o0002<ol000<0
003oooooool0N_ooo`00Foooo`03o`2Ioooooooo043oool00`0003?o03?o0002<ol000<0003ooooo
ool0N_ooo`00Foooo`03o`2Ioooooooo043oool00`0003?o03?o0002<ol000<0003oooooool0N_oo
o`00Foooo`03o`2Ioooooooo043oool00`0003?o03?o0002<ol00P0007_oool005_oool00ol0VOoo
ooooo`10oooo00<0000co`0co`000S?o00030000oooooooo07[oool005_oool00ol0VOooooooo`10
oooo00<0000co`0co`000S?o00030000oooooooo07[oool005_oool00ol0VOooooooo`10oooo00<0
000co`0co`000S?o00030000oooooooo07[oool005_oool00ol0VOooooooo`10oooo00<0000co`0c
o`000S?o00030000oooooooo07[oool005_oool00ol0VOooooooo`10oooo00<0000co`0co`000S?o
00030000oooooooo07[oool005_oool00ol0VOooooooo`10oooo00<0000co`0co`000S?o0080001k
oooo001Koooo00?o09Woooooool0@Oooo`050000<ol0<ol0<ol0000007coool005_oool00ol0VOoo
ooooo`11oooo00D0000co`0co`0co`000000O?ooo`00Foooo`03o`2Ioooooooo047oool01@0003?o
03?o03?o0000001loooo001Koooo00?o09Woooooool0?Oooo`D00003<ol000<0003oooooool0N_oo
o`00Foooo`03o`2Ioooooooo03goool01@000?ooooooooooo`000003<ol000<0003oooooool0N_oo
o`00Foooo`03o`2Ioooooooo03koool010000?ooooooo`0000<co`030000N_ooo`00Foooo`03o`2I
oooooooo03ooool00`000?ooo`000003<ol000<0003oooooool0N_ooo`00Foooo`03o`2Ioooooooo
03goool00`000?ooooooo`0200000c?o00030000oooooooo07[oool005_oool00ol0VOooooooo`0n
oooo0P000003oooo0000<ol0008co`000`000?ooooooo`1joooo001Koooo00?o09Woooooool0@Ooo
o`050000<ol0<ol0<ol0000007coool005_oool00ol0VOooooooo`12oooo00@0000co`0co`00001l
oooo001Koooo00?o09Woooooool0@_ooo`030000<ol0<ol00080001koooo001Koooo00?o09Wooooo
ool0@_ooo`040000<ol0<ol00000O?ooo`00Foooo`03o`2Ioooooooo04;oool0100003?o03?o0000
07coool005_oool00ol0VOooooooo`12oooo00@0000co`0co`00001loooo001Koooo00?o09Wooooo
ool0@_ooo`040000<ol0<ol00000O?ooo`00Foooo`03o`2Ioooooooo04;oool0100003?o03?o0000
07coool005_oool00ol0VOooooooo`12oooo00@0000co`0co`00001loooo001Koooo00?o09Wooooo
ool0@oooo`040000<ol000000000Noooo`00Foooo`03o`2Ioooooooo04?oool00`0003?o0000001l
oooo001Koooo00?o09Woooooool0@oooo`030000<ol0000007coool005_oool00ol0VOooooooo`13
oooo00<0000co`000000O?ooo`00Foooo`03o`2Ioooooooo04?oool00`0003?o0000001loooo001K
oooo00?o09Woooooool0@oooo`030000<ol0000007coool005_oool00ol0VOooooooo`13oooo00@0
000co`000000001koooo001Koooo00?o09Woooooool0@oooo`030000<ol0000007coool005_oool0
0ol0VOooooooo`13oooo00<0000co`000000O?ooo`00Foooo`03o`2Ioooooooo04?oool00`0003?o
0000001loooo001Koooo00?o09Woooooool0@oooo`030000<ol0000007coool005_oool00ol0VOoo
ooooo`13oooo00<0000co`000000O?ooo`00Foooo`03o`2Ioooooooo04?oool0100003?o00000000
07_oool005_oool00ol0VOooooooo`13oooo00<0000co`000000O?ooo`00Foooo`03o`2Ioooooooo
04?oool00`0003?o0000001loooo001Koooo00?o09Woooooool0@oooo`030000<ol0000007coool0
05_oool00ol0VOooooooo`0noooo0P0000?oool00`0003?o0000001loooo001Koooo00?o09Wooooo
ool0?Oooo`040000oooooooo00000_ooo`030000<ol0000007coool005_oool00ol0VOooooooo`0o
oooo00H0003oooooooooool0000co`030000N_ooo`00Foooo`03o`2Ioooooooo043oool01P000?oo
ooooo`0003?o000007coool005_oool00ol0VOooooooo`0moooo00@0003oooooool00002oooo00<0
000co`000000O?ooo`00Foooo`03o`2Ioooooooo03koool200001?ooo`80001loooo001Koooo00?o
09Woooooool0A?ooo`80001loooo001Koooo00?o09Woooooool0A?ooo`80001loooo001Koooo00?o
09Woooooool0A?ooo`80001loooo001Koooo00?o09Woooooool0A?ooo`<0001koooo001Koooo00?o
09Woooooool0A?ooo`80001loooo001Koooo00?o09Woooooool0A?ooo`80001loooo001Koooo00?o
09Woooooool0A?ooo`80001loooo001Koooo00?o09Woooooool0A?ooo`80001loooo001Koooo00?o
09Woooooool0A?ooo`80001loooo001Koooo00?o09Woooooool0A?ooo`<0001koooo001Koooo00?o
09Woooooool0A?ooo`80001loooo001Koooo00?o09Woooooool0A?ooo`80001loooo001Koooo00?o
09Woooooool0A?ooo`80001loooo001Koooo00?o09Woooooool0A?ooo`80001loooo001Koooo00?o
09Woooooool0A?ooo`80001loooo001Koooo00?o09Woooooool0A?ooo`<0001koooo001Koooo00?o
09Woooooool0AOooo`030000oooooooo07[oool005_oool00ol0VOooooooo`15oooo00<0003ooooo
ool0N_ooo`00Foooo`03o`2Ioooooooo04Goool00`000?ooooooo`1joooo001Koooo00?o09Wooooo
ool0AOooo`030000oooooooo07[oool005_oool00ol0VOooooooo`15oooo00<0003oooooool0N_oo
o`00Foooo`03o`2Ioooooooo04Goool20000Noooo`00Foooo`03o`2Ioooooooo04Goool00`000?oo
ooooo`1joooo001Koooo00?o09Woooooool0AOooo`030000oooooooo07[oool005_oool00ol0VOoo
ooooo`15oooo00<0003oooooool0N_ooo`00Foooo`03o`2Ioooooooo04Goool00`000?ooooooo`1j
oooo001Koooo00?o09Woooooool0?oooo`<00003oooo00<0003oooooool0N_ooo`00Foooo`03o`2I
oooooooo043oool00`000?ooooooo`02oooo00<0003oooooool0N_ooo`00Foooo`03o`2Ioooooooo
03goool500000oooo`<0001joooo002Koooo00@0003oooooool00021oooo002Loooo00<0003oool0
0000POooo`00WOooo`800021oooo003ooooo8Oooo`00ooooob7oool007Woool00`000?ooooooo`0X
oooo00<0003oooooool0NOooo`00N?ooo`030000oooooooo00Soool00`000?ooooooo`0Ooooo00<0
003oooooool0N?ooo`00N?ooo`030000oooooooo00;oool200001?ooo`030000oooooooo00koool3
00000_ooo`800003oooo0`0000Coool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool0
00000_ooo`030000oooooooo00;oool00`000?ooooooo`04oooo100000Koool00`000?ooooooo`06
oooo00@0003oooooool00003oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo00;oool0
0`000?ooooooo`0Coooo1@0000Ooool010000?ooooooo`0000Coool00`000?ooooooo`1goooo001h
oooo00<0003oooooool01@0001;oool010000?ooooooo`0000Soool300001?ooo`030000oooooooo
07Soool007Soool01@000?ooooooooooo`00000Foooo00<0003oool000002Oooo`030000oooooooo
00?oool00`000?ooooooo`1hoooo001ioooo00<0003oooooool06?ooo`800009oooo0`0000;oool0
0`000?ooooooo`1ioooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-8.12947, \
-1.14361, 0.0496935, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-8.12947, -1.14361, 0.0496935, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
.2 1 0 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.27193 .12361 L
.28302 .12361 L
.2881 .12361 L
.29349 .12361 L
.29809 .12361 L
.29935 .12361 L
.30004 .12361 L
.3007 .12361 L
s
.3007 .12361 m
.30122 .61803 L
s
0 .4 1 r
.02381 .13398 m
.04262 .13811 L
.06244 .14425 L
.07286 .14846 L
.08255 .15315 L
.09388 .15975 L
.10458 .16735 L
.125 .18654 L
.13384 .19728 L
.13886 .20418 L
.14012 .20601 L
.14132 .20779 L
.1424 .20942 L
.14357 .21011 L
.14475 .21009 L
.14599 .21007 L
.14824 .21003 L
.15327 .20994 L
.16355 .20973 L
.18199 .20923 L
.19227 .20887 L
.2034 .2084 L
.21301 .20792 L
.22357 .20727 L
.24351 .20568 L
.2544 .20454 L
.26457 .20325 L
.27502 .20167 L
.28492 .19986 L
.29381 .19795 L
.29625 .19737 L
.29883 .19673 L
.2999 .19646 L
.30104 .19616 L
.3023 .12361 L
.30348 .12361 L
.30474 .12361 L
.30588 .12361 L
.3072 .12361 L
.30844 .12361 L
.30959 .12361 L
.31065 .12361 L
.31182 .12361 L
.31305 .12361 L
.31429 .12361 L
.31499 .12361 L
.31563 .12361 L
.31686 .12361 L
.31804 .12361 L
.3187 .12361 L
Mistroke
.3194 .12361 L
.32066 .12361 L
.32143 .12361 L
.32216 .12361 L
.32282 .12361 L
.32352 .12361 L
.32484 .12361 L
.32607 .12361 L
.32678 .12361 L
.32743 .12361 L
.32817 .12361 L
.32887 .12361 L
.32955 .12361 L
.33028 .12361 L
.33158 .12361 L
.3323 .12361 L
.33298 .12361 L
.33372 .12361 L
.33452 .12361 L
.33575 .12361 L
.33644 .12361 L
.33709 .12361 L
.3384 .12361 L
.33913 .12361 L
.33979 .12361 L
.34098 .12361 L
.34228 .12361 L
.3435 .12361 L
.34462 .12361 L
.34588 .12361 L
.34707 .12361 L
.34814 .12361 L
.34931 .12361 L
.35058 .12361 L
.35122 .12361 L
.35192 .12361 L
.35317 .12361 L
.35434 .12361 L
.35545 .12361 L
.35662 .12361 L
.35763 .12361 L
.35871 .12361 L
.35987 .12361 L
.36096 .12361 L
.36225 .12361 L
.36342 .12361 L
.36471 .12361 L
.36536 .12361 L
.36607 .12361 L
.36733 .12361 L
Mistroke
.36852 .12361 L
.36922 .12361 L
.37 .12361 L
.37073 .12361 L
.3714 .12361 L
.37268 .12361 L
.37339 .12361 L
.37404 .12361 L
.37524 .12361 L
.37653 .12361 L
.37775 .12361 L
.37888 .12361 L
.38008 .12361 L
.38077 .12361 L
.38141 .12361 L
.38269 .12361 L
.38342 .12361 L
.38408 .12361 L
.38526 .12361 L
.38636 .12361 L
.38758 .12361 L
.38889 .12361 L
.39019 .12361 L
.39084 .12361 L
.39156 .12361 L
.39282 .12361 L
.394 .12361 L
.3952 .12361 L
.39632 .12361 L
.39734 .12361 L
.39844 .12361 L
.39964 .12361 L
.4009 .12361 L
.40199 .12361 L
.40318 .12361 L
.40384 .12361 L
.40456 .12361 L
.40588 .12361 L
.40716 .12361 L
.40835 .12361 L
.40908 .12361 L
.40976 .12361 L
.41104 .12361 L
.41176 .12361 L
.41242 .12361 L
.41314 .12361 L
.41391 .12361 L
.4151 .12361 L
.41639 .12361 L
.41759 .12361 L
Mistroke
.41869 .12361 L
.41999 .12361 L
.42072 .12361 L
.42139 .12361 L
.42263 .12361 L
.42394 .12361 L
.42514 .12361 L
.42646 .12361 L
.4277 .12361 L
.42885 .12361 L
.42999 .12361 L
.43103 .12361 L
.43222 .12361 L
.43335 .12361 L
.43458 .12361 L
.43588 .12361 L
.43699 .12361 L
.43821 .12361 L
.43952 .12361 L
.44026 .12361 L
.44093 .12361 L
.44223 .12361 L
.44347 .12361 L
.44452 .12361 L
.44567 .12361 L
.44688 .12361 L
.44802 .12361 L
.44907 .12361 L
.45004 .12361 L
.45111 .12361 L
.45223 .12361 L
.45337 .12361 L
.45459 .12361 L
.45574 .12361 L
.45678 .12361 L
.45801 .12361 L
.4587 .12361 L
.45934 .12361 L
.46052 .12361 L
.46176 .12361 L
.46297 .12361 L
.46429 .12361 L
.46554 .12361 L
.46669 .12361 L
.46784 .12361 L
.46887 .12361 L
.47007 .12361 L
.47119 .12361 L
.47243 .12361 L
.47373 .12361 L
Mistroke
.47485 .12361 L
.47607 .12361 L
.47738 .12361 L
.47812 .12361 L
.47879 .12361 L
.48009 .12361 L
.48133 .12361 L
.48238 .12361 L
.48354 .12361 L
.48475 .12361 L
.48589 .12361 L
.48695 .12361 L
.48792 .12361 L
.48898 .12361 L
.4901 .12361 L
.49125 .12361 L
.49247 .12361 L
.49362 .12361 L
.49466 .12361 L
.49589 .12361 L
.49658 .12361 L
.49722 .12361 L
.4984 .12361 L
.49964 .12361 L
.50085 .12361 L
.50218 .12361 L
.50343 .12361 L
.50458 .12361 L
.50562 .12361 L
.50677 .12361 L
.50797 .12361 L
.50909 .12361 L
.50974 .12361 L
.51043 .12361 L
.51167 .12361 L
.51297 .12361 L
.51371 .12361 L
.51439 .12361 L
.51558 .12361 L
.51688 .12361 L
.51811 .12361 L
.51924 .12361 L
.52029 .12361 L
.52128 .12361 L
.52236 .12361 L
.52352 .12361 L
.52474 .12361 L
.52589 .12361 L
.52703 .12361 L
.52806 .12361 L
Mistroke
.5292 .12361 L
.53041 .12361 L
.53154 .12361 L
.5326 .12361 L
.53385 .12361 L
.53499 .12361 L
.53624 .12361 L
.53687 .12361 L
.53757 .12361 L
.53887 .12361 L
.54008 .12361 L
.54071 .12361 L
.5414 .12361 L
.54213 .12361 L
.54281 .12361 L
.54406 .12361 L
.5452 .12361 L
.54645 .12361 L
.54778 .12361 L
.54889 .12361 L
.55008 .12361 L
.5512 .12361 L
.55222 .12361 L
.55342 .12361 L
.55472 .12361 L
.55595 .12361 L
.55708 .12361 L
.55829 .12361 L
.55958 .12361 L
.5608 .12361 L
.56192 .12361 L
.56323 .12361 L
.56397 .12361 L
.56465 .12361 L
.56591 .12361 L
.56661 .12361 L
.56724 .12361 L
.56792 .12361 L
.56863 .12361 L
.56991 .12361 L
.57062 .12361 L
.57128 .12361 L
.57201 .12361 L
.57278 .12361 L
.57346 .12361 L
.57419 .12361 L
.57488 .12361 L
.57551 .12361 L
.57672 .12361 L
.578 .12361 L
Mistroke
.5792 .12361 L
.58051 .12361 L
.58175 .12361 L
.5829 .12361 L
.5874 .12361 L
.59751 .12361 L
.61581 .12361 L
.65491 .12361 L
.69647 .12361 L
.73651 .12361 L
.77504 .12361 L
.81602 .12361 L
.85548 .12361 L
.89343 .12361 L
.93383 .12361 L
.97271 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Koooo1@00083oool009goool00`000?ooooooo`20oooo002Moooo00<0003ooooo
ool00oooo`<0001joooo002Eoooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0N_oo
o`00WOooo`030000oooooooo00?oool00`000?ooooooo`1joooo002Loooo0P0000Goool00`000?oo
ooooo`1joooo002Soooo00<0003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool2
0000Noooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0
003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002S
oooo00<0003oooooool0N_ooo`00Xoooo`80001koooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool00:?oool20000Noooo`00:oooo`<0000Xoooo0`0002?oool4
00008oooo`030000oooooooo02?oool400009oooo`<0000Yoooo000[oooo00@0003oooooool0000X
oooo00<0003oooooool08_ooo`030000oooooooo02Coool00`000?ooooooo`0Soooo00<0003ooooo
ool0:Oooo`030000oooooooo02Soool002_oool010000?ooooooo`0002Goool500009?ooo`030000
oooooooo02?oool00`000?ooooooo`0Toooo00<0003oooooool09Oooo`D0000Yoooo000Uoooo1000
00;oool300008?ooo`@00002oooo00@0003oooooool0000Noooo100000Coool00`000?ooooooo`0R
oooo00<0003oooooool09Oooo`030000oooooooo02Coool010000?ooooooo`0002[oool002coool0
0`000?ooooooo`0Voooo00<0003oool000009?ooo`040000oooooooo00008oooo`030000oooooooo
02?oool010000?ooooooo`0002Koool00`000?ooo`00000Zoooo000/oooo0`0002Ooool200009Ooo
o`80000Toooo0P0002Goool20000:?ooo`80000Zoooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool0013ooooo00004Oooo`005_ooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Koool00ol0V@000?ooo`08oooo00<0003ooooo
ool01oooo`030000oooo0000010000000c?o000003?o0008<ol000<0000co`0co`001c?o00030000
<ol0<ol000Lco`000`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool05Oooo`00:_ooo`030000oooooooo02Koool00`000?ooooooo`06oooo00?o09T0I_ooool07?oo
o`030000oooooooo00Koool400006c?o00030000oooooooo02Goool00`000?ooooooo`0Voooo00<0
003oooooool0:Oooo`005_ooo`<0I_m3oooo00?o09T0I_ooool0:Oooo`@0000G<ol000<0003ooooo
ool0N_ooo`006Oooo`@0I_looooo00?o09T0I_ooool0;Oooo`030000<ol0<ol001@co`000`000?oo
ooooo`1joooo000Moooo0P1Vocgoool00ol0V@1Vooooo`0^oooo0P0001@co`000`000?ooooooo`1j
oooo000Ooooo0`1Voc[oool00ol0V@1Vooooo`0`oooo00<0000co`0co`004C?o00030000oooooooo
07[oool002;oool206Ko>?ooo`03o`2I06Kooooo037oool00`0003?o03?o000@<ol00P0007_oool0
02Coool206Ko=_ooo`03o`2I06Kooooo03;oool2000043?o00030000oooooooo07[oool002Koool2
06Ko=?ooo`03o`2I06Kooooo03Coool00`0003?o03?o000=<ol000<0003oooooool0N_ooo`00:?oo
o`80I_lboooo00?o09T0I_ooool0=?ooo`030000<ol0<ol000dco`000`000?ooooooo`1joooo000Z
oooo0P1Voc3oool00ol0V@1Vooooo`0eoooo00<0000co`0co`0033?o00030000oooooooo07[oool0
02coool00`1Vooooooooo`0]oooo00?o09T0I_ooool0=Oooo`030000<ol0<ol000`co`000`000?oo
ooooo`1joooo000]oooo00<0I_ooooooool0;?ooo`03o`2I06Kooooo03Koool00`0003?o03?o000;
<ol00P0007_oool002koool00`1Vooooooooo`0[oooo00?o09T0I_ooool0=_ooo`030000<ol0<ol0
00/co`000`000?ooooooo`1joooo000_oooo00<0I_ooooooool0:_ooo`03o`2I06Kooooo03Ooool0
0`0003?o03?o000:<ol000<0003oooooool0N_ooo`00<?ooo`0306Kooooooooo02Woool00ol0V@1V
ooooo`0goooo00<0000co`0co`002S?o00030000oooooooo07[oool0037oool00`1Vooooooooo`0X
oooo00?o09T0I_ooool0>?ooo`030000<ol0<ol000Tco`000`000?ooooooo`1joooo000aoooo00<0
I_ooooooool0:?ooo`03o`2I06Kooooo03Soool00`0003?o03?o0009<ol000<0003oooooool0N_oo
o`00<_ooo`0306Kooooooooo02Goool406Ko>_ooo`030000<ol0<ol000Pco`020000Noooo`00<_oo
o`0306Kooooooooo023oool506Ko0_ooo`03o`2Ioooooooo03Woool00`0003?o03?o0008<ol000<0
003oooooool0N_ooo`00<oooo`80I_lGoooo2@1Vo`Ooool00ol0VOooooooo`0ioooo00<0000co`0c
o`0023?o00030000oooooooo07[oool003CooolH06Ko4?ooo`03o`2Ioooooooo03[oool00`0003?o
03?o0007<ol000<0003oooooool0N_ooo`00G?ooo`03o`2Ioooooooo03[oool00`0003?o03?o0007
<ol000<0003oooooool0N_ooo`00G?ooo`03o`2Ioooooooo03[oool00`0003?o03?o0007<ol000<0
003oooooool0N_ooo`00G?ooo`03o`2Ioooooooo03[oool00`0003?o03?o0007<ol00P0007_oool0
05coool00ol0VOooooooo`0koooo00<0000co`0co`001S?o00030000oooooooo07[oool005coool0
0ol0VOooooooo`0koooo00<0000co`0co`001S?o00030000oooooooo07[oool005coool00ol0VOoo
ooooo`0koooo00<0000co`0co`001S?o00030000oooooooo07[oool005coool00ol0VOooooooo`0k
oooo00<0000co`0co`001S?o00030000oooooooo07[oool005coool00ol0VOooooooo`0loooo1@00
00<co`000`000?ooooooo`1joooo001Loooo00?o09Woooooool0??ooo`030000<ol0000000Dco`00
0`000?ooooooo`1joooo001Loooo00?o09Woooooool0??ooo`030000<ol0000000Dco`030000N_oo
o`00G?ooo`03o`2Ioooooooo03goool200001C?o00030000oooooooo07[oool005coool00ol0VOoo
ooooo`0moooo0P0000Dco`000`000?ooooooo`1joooo001Loooo00?o09Woooooool0?Oooo`800005
<ol000<0003oooooool0N_ooo`00G?ooo`03o`2Ioooooooo03goool00`0003?o03?o0004<ol000<0
003oooooool0N_ooo`00G?ooo`03o`2Ioooooooo03goool00`0003?o03?o0004<ol000<0003ooooo
ool0N_ooo`00G?ooo`03o`2Ioooooooo03goool00`0003?o03?o0004<ol00P0007_oool005coool0
0ol0VOooooooo`0noooo00<0000co`0co`000c?o00030000oooooooo07[oool005coool00ol0VOoo
ooooo`0noooo00<0000co`0co`000c?o00030000oooooooo07[oool005coool00ol0VOooooooo`0n
oooo00<0000co`0co`000c?o00030000oooooooo07[oool005coool00ol0VOooooooo`0noooo00<0
000co`0co`000c?o00030000oooooooo07[oool005coool00ol0VOooooooo`0noooo00<0000co`0c
o`000c?o00030000oooooooo07[oool005coool00ol0VOooooooo`0noooo00<0000co`0co`000c?o
0080001koooo001Loooo00?o09Woooooool0?_ooo`030000<ol0<ol000<co`000`000?ooooooo`1j
oooo001Loooo00?o09Woooooool0?_ooo`030000<ol0<ol000<co`000`000?ooooooo`1joooo001L
oooo00?o09Woooooool0?oooo`030000<ol0<ol0008co`000`000?ooooooo`1joooo001Loooo00?o
09Woooooool0?oooo`030000<ol0<ol0008co`000`000?ooooooo`1joooo001Loooo00?o09Wooooo
ool0?oooo`030000<ol0<ol0008co`000`000?ooooooo`1joooo001Loooo00?o09Woooooool0?ooo
o`030000<ol0<ol0008co`000`000?ooooooo`1joooo001Loooo00?o09Woooooool0?oooo`030000
<ol0<ol0008co`020000Noooo`00G?ooo`03o`2Ioooooooo03ooool00`0003?o03?o0002<ol000<0
003oooooool0N_ooo`00G?ooo`03o`2Ioooooooo03ooool00`0003?o03?o0002<ol000<0003ooooo
ool0N_ooo`00G?ooo`03o`2Ioooooooo03ooool00`0003?o03?o0002<ol000<0003oooooool0N_oo
o`00G?ooo`03o`2Ioooooooo03ooool00`0003?o03?o0002<ol000<0003oooooool0N_ooo`00G?oo
o`03o`2Ioooooooo03ooool00`0003?o03?o0002<ol000<0003oooooool0N_ooo`00G?ooo`03o`2I
oooooooo03ooool00`0003?o03?o0002<ol00P0007_oool005coool00ol0VOooooooo`10oooo00D0
000co`0co`0co`000000O?ooo`00G?ooo`03o`2Ioooooooo043oool01@0003?o03?o03?o0000001l
oooo001Loooo00?o09Woooooool0@?ooo`050000<ol0<ol0<ol0000007coool005coool00ol0VOoo
ooooo`0loooo1@0000<co`000`000?ooooooo`1joooo001Loooo00?o09Woooooool0??ooo`050000
oooooooooooo000000<co`000`000?ooooooo`1joooo001Loooo00?o09Woooooool0?Oooo`040000
oooooooo00000c?o00<0001joooo001Moooo00?o09Woooooool0?Oooo`030000oooo000000<co`00
0`000?ooooooo`1joooo001Moooo00?o09Woooooool0>oooo`030000oooooooo00800003<ol000<0
003oooooool0N_ooo`00GOooo`03o`2Ioooooooo03coool2000000?oool0000co`000S?o00030000
oooooooo07[oool005goool00ol0VOooooooo`0ooooo00D0000co`0co`0co`000000O?ooo`00GOoo
o`03o`2Ioooooooo043oool0100003?o03?o000007coool005goool00ol0VOooooooo`10oooo00<0
000co`0co`000P0007_oool005goool00ol0VOooooooo`10oooo00@0000co`0co`00001loooo001M
oooo00?o09Woooooool0@?ooo`040000<ol0<ol00000O?ooo`00GOooo`03o`2Ioooooooo043oool0
100003?o03?o000007coool005goool00ol0VOooooooo`10oooo00@0000co`0co`00001loooo001M
oooo00?o09Woooooool0@?ooo`040000<ol0<ol00000O?ooo`00GOooo`03o`2Ioooooooo043oool0
100003?o03?o000007coool005goool00ol0VOooooooo`11oooo00@0000co`000000001koooo001M
oooo00?o09Woooooool0@Oooo`030000<ol0000007coool005goool00ol0VOooooooo`11oooo00<0
000co`000000O?ooo`00GOooo`03o`2Ioooooooo047oool00`0003?o0000001loooo001Moooo00?o
09Woooooool0@Oooo`030000<ol0000007coool005goool00ol0VOooooooo`11oooo00<0000co`00
0000O?ooo`00GOooo`03o`2Ioooooooo047oool0100003?o0000000007_oool005goool00ol0VOoo
ooooo`11oooo00<0000co`000000O?ooo`00GOooo`03o`2Ioooooooo047oool00`0003?o0000001l
oooo001Moooo00?o09Woooooool0@Oooo`030000<ol0000007coool005goool00ol0VOooooooo`11
oooo00<0000co`000000O?ooo`00GOooo`03o`2Ioooooooo047oool00`0003?o0000001loooo001M
oooo00?o09Woooooool0@Oooo`040000<ol000000000Noooo`00GOooo`03o`2Ioooooooo047oool0
0`0003?o0000001loooo001Moooo00?o09Woooooool0@Oooo`030000<ol0000007coool005goool0
0ol0VOooooooo`11oooo00<0000co`000000O?ooo`00GOooo`03o`2Ioooooooo03coool200000ooo
o`030000<ol0000007coool005goool00ol0VOooooooo`0koooo00@0003oooooool00002oooo00<0
000co`000000O?ooo`00GOooo`03o`2Ioooooooo03goool01P000?ooooooooooo`0003?o00<0001j
oooo001Moooo00?o09Woooooool0?_ooo`060000oooooooo0000<ol00000O?ooo`00GOooo`03o`2I
oooooooo03_oool010000?ooooooo`0000;oool00`0003?o0000001loooo001Moooo00?o09Wooooo
ool0??ooo`800004oooo0P0007coool005goool00ol0VOooooooo`12oooo0P0007coool005goool0
0ol0VOooooooo`12oooo0P0007coool005goool00ol0VOooooooo`12oooo0P0007coool005goool0
0ol0VOooooooo`12oooo0`0007_oool005goool00ol0VOooooooo`12oooo0P0007coool005goool0
0ol0VOooooooo`12oooo0P0007coool005goool00ol0VOooooooo`12oooo0P0007coool005goool0
0ol0VOooooooo`12oooo0P0007coool005goool00ol0VOooooooo`12oooo0P0007coool005goool0
0ol0VOooooooo`12oooo0`0007_oool005goool00ol0VOooooooo`12oooo0P0007coool005goool0
0ol0VOooooooo`12oooo0P0007coool005goool00ol0VOooooooo`12oooo0P0007coool005goool0
0ol0VOooooooo`12oooo0P0007coool005goool00ol0VOooooooo`12oooo0P0007coool005goool0
0ol0VOooooooo`12oooo0`0007_oool005goool00ol0VOooooooo`13oooo00<0003oooooool0N_oo
o`00GOooo`03o`2Ioooooooo04?oool00`000?ooooooo`1joooo001Moooo00?o09Woooooool0@ooo
o`030000oooooooo07[oool005goool00ol0VOooooooo`13oooo00<0003oooooool0N_ooo`00GOoo
o`03o`2Ioooooooo04?oool00`000?ooooooo`1joooo001Moooo00?o09Woooooool0@oooo`80001k
oooo001Moooo00?o09Woooooool0@oooo`030000oooooooo07[oool005goool00ol0VOooooooo`13
oooo00<0003oooooool0N_ooo`00GOooo`03o`2Ioooooooo04?oool00`000?ooooooo`1joooo001M
oooo00?o09Woooooool0@oooo`030000oooooooo07[oool005goool00ol0VOooooooo`0moooo0`00
00?oool00`000?ooooooo`1joooo001Moooo00?o09Woooooool0?_ooo`030000oooooooo00;oool0
0`000?ooooooo`1joooo001Moooo00?o09Woooooool0>oooo`D00003oooo0`0007[oool009_oool0
10000?ooooooo`00087oool009coool00`000?ooo`000021oooo002Moooo0P00087oool00?oooolQ
oooo003ooooo8Oooo`00NOooo`030000oooooooo02Soool00`000?ooooooo`1ioooo001hoooo00<0
003oooooool02?ooo`030000oooooooo01ooool00`000?ooooooo`1hoooo001hoooo00<0003ooooo
ool00_ooo`800004oooo00<0003oooooool03_ooo`<00002oooo0P0000Coool200001?ooo`030000
oooooooo07Soool007Soool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000
oooooooo00Coool400001_ooo`030000oooooooo00Koool010000?ooooooo`0000?oool00`000?oo
ooooo`1hoooo001goooo00<0003oooooool00_ooo`030000oooooooo01?oool500002_ooo`030000
oooooooo00;oool00`000?ooooooo`1goooo001hoooo00<0003oooooool01@0001;oool010000?oo
ooooo`0000Woool200001?ooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`00000F
oooo00<0003oool000002Oooo`030000oooooooo00?oool00`000?ooooooo`1hoooo001ioooo00<0
003oooooool06?ooo`800009oooo0`0000;oool00`000?ooooooo`1ioooo003ooooo8Oooo`00oooo
ob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-8.12947, \
-1.14361, 0.0496935, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-8.12947, -1.14361, 0.0496935, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
.2 1 0 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.29205 .12361 L
.29779 .12361 L
.30316 .12361 L
.3056 .12361 L
.30791 .12361 L
.30919 .12361 L
s
.30919 .12361 m
.30948 .61803 L
s
0 .4 1 r
.02381 .13261 m
.04262 .13619 L
.06244 .14153 L
.07286 .14518 L
.08255 .14925 L
.09388 .15499 L
.10458 .16158 L
.125 .17824 L
.14357 .19968 L
.14598 .20302 L
.14858 .20678 L
.14983 .20866 L
.15103 .21012 L
.1521 .2101 L
.15327 .21008 L
.15816 .21 L
.16355 .2099 L
.18199 .20946 L
.20166 .20882 L
.21266 .20834 L
.22263 .20782 L
.24188 .20652 L
.25272 .20556 L
.2627 .2045 L
.28152 .2019 L
.29221 .19999 L
.30219 .19785 L
.30461 .19727 L
.30719 .19662 L
.30854 .19627 L
.3093 .19607 L
.31002 .12361 L
.31128 .12361 L
.31199 .12361 L
.31264 .12361 L
.31383 .12361 L
.31494 .12361 L
.31616 .12361 L
.31746 .12361 L
.31812 .12361 L
.31883 .12361 L
.32012 .12361 L
.32138 .12361 L
.32254 .12361 L
.32361 .12361 L
.32476 .12361 L
.32584 .12361 L
.32683 .12361 L
.32799 .12361 L
.32925 .12361 L
Mistroke
.33045 .12361 L
.33155 .12361 L
.3328 .12361 L
.33398 .12361 L
.33503 .12361 L
.33617 .12361 L
.33742 .12361 L
.33874 .12361 L
.33986 .12361 L
.34109 .12361 L
.3424 .12361 L
.34361 .12361 L
.34425 .12361 L
.34494 .12361 L
.34567 .12361 L
.34635 .12361 L
.3476 .12361 L
.34875 .12361 L
.35 .12361 L
.35133 .12361 L
.35244 .12361 L
.35363 .12361 L
.35476 .12361 L
.35578 .12361 L
.35698 .12361 L
.35828 .12361 L
.35951 .12361 L
.36064 .12361 L
.36185 .12361 L
.36315 .12361 L
.36437 .12361 L
.36549 .12361 L
.3668 .12361 L
.36754 .12361 L
.36822 .12361 L
.36948 .12361 L
.37011 .12361 L
.37082 .12361 L
.37149 .12361 L
.37221 .12361 L
.37348 .12361 L
.37419 .12361 L
.37486 .12361 L
.37558 .12361 L
.37636 .12361 L
.37703 .12361 L
.37776 .12361 L
.37845 .12361 L
.37909 .12361 L
.38029 .12361 L
Mistroke
.38157 .12361 L
.38278 .12361 L
.38409 .12361 L
.38534 .12361 L
.38649 .12361 L
.38763 .12361 L
.38867 .12361 L
.38987 .12361 L
.39099 .12361 L
.39223 .12361 L
.39353 .12361 L
.39464 .12361 L
.39586 .12361 L
.39717 .12361 L
.39791 .12361 L
.39858 .12361 L
.39989 .12361 L
.40112 .12361 L
.40217 .12361 L
.40333 .12361 L
.40454 .12361 L
.40568 .12361 L
.40674 .12361 L
.40771 .12361 L
.40877 .12361 L
.40989 .12361 L
.41103 .12361 L
.41225 .12361 L
.4134 .12361 L
.41445 .12361 L
.41568 .12361 L
.41637 .12361 L
.41701 .12361 L
.41943 .12361 L
.42068 .12361 L
.42187 .12361 L
.42294 .12361 L
.42411 .12361 L
.42537 .12361 L
.42607 .12361 L
.42671 .12361 L
.42796 .12361 L
.42913 .12361 L
.43024 .12361 L
.4314 .12361 L
.4324 .12361 L
.43349 .12361 L
.43467 .12361 L
.43593 .12361 L
.43712 .12361 L
Mistroke
.4382 .12361 L
.43949 .12361 L
.44014 .12361 L
.44085 .12361 L
.44211 .12361 L
.44329 .12361 L
.444 .12361 L
.44468 .12361 L
.44595 .12361 L
.44666 .12361 L
.44732 .12361 L
.44804 .12361 L
.44882 .12361 L
.45012 .12361 L
.45085 .12361 L
.45152 .12361 L
.45277 .12361 L
.45408 .12361 L
.45525 .12361 L
.45635 .12361 L
.45756 .12361 L
.45885 .12361 L
.46007 .12361 L
.46076 .12361 L
.46141 .12361 L
.46272 .12361 L
.46345 .12361 L
.46413 .12361 L
.46527 .12361 L
.46651 .12361 L
.46781 .12361 L
.46902 .12361 L
.46971 .12361 L
.47046 .12361 L
.47117 .12361 L
.47182 .12361 L
.47305 .12361 L
.47436 .12361 L
.47504 .12361 L
.47577 .12361 L
.47709 .12361 L
.47789 .12361 L
.47865 .12361 L
.47933 .12361 L
.48008 .12361 L
.48074 .12361 L
.48145 .12361 L
.48273 .12361 L
.48398 .12361 L
.48513 .12361 L
Mistroke
.48638 .12361 L
.48709 .12361 L
.48775 .12361 L
.48845 .12361 L
.48909 .12361 L
.48982 .12361 L
.49052 .12361 L
.49169 .12361 L
.49293 .12361 L
.49399 .12361 L
.49516 .12361 L
.49641 .12361 L
.49711 .12361 L
.49776 .12361 L
.49895 .12361 L
.5002 .12361 L
.50144 .12361 L
.50213 .12361 L
.50278 .12361 L
.50396 .12361 L
.50521 .12361 L
.50633 .12361 L
.50738 .12361 L
.50853 .12361 L
.50976 .12361 L
.51107 .12361 L
.51177 .12361 L
.5125 .12361 L
.51314 .12361 L
.51385 .12361 L
.5151 .12361 L
.51631 .12361 L
.51761 .12361 L
.51884 .12361 L
.51997 .12361 L
.52104 .12361 L
.52218 .12361 L
.52326 .12361 L
.52424 .12361 L
.52539 .12361 L
.52664 .12361 L
.52783 .12361 L
.52892 .12361 L
.53004 .12361 L
.5311 .12361 L
.53225 .12361 L
.53349 .12361 L
.53835 .12361 L
.53965 .12361 L
.54088 .12361 L
Mistroke
.54157 .12361 L
.5423 .12361 L
.54359 .12361 L
.54482 .12361 L
.54612 .12361 L
.54734 .12361 L
.54845 .12361 L
.54977 .12361 L
.55049 .12361 L
.55118 .12361 L
.55239 .12361 L
.55308 .12361 L
.55371 .12361 L
.5544 .12361 L
.55504 .12361 L
.55575 .12361 L
.55651 .12361 L
.55727 .12361 L
.55806 .12361 L
.55874 .12361 L
.55949 .12361 L
.56014 .12361 L
.56084 .12361 L
.56212 .12361 L
.56337 .12361 L
.56452 .12361 L
.56576 .12361 L
.56647 .12361 L
.56713 .12361 L
.56783 .12361 L
.56846 .12361 L
.5692 .12361 L
.5699 .12361 L
.57106 .12361 L
.5723 .12361 L
.57347 .12361 L
.57453 .12361 L
.57578 .12361 L
.57644 .12361 L
.57713 .12361 L
.57841 .12361 L
.57958 .12361 L
.5808 .12361 L
.58214 .12361 L
.58455 .12361 L
.58909 .12361 L
.59926 .12361 L
.61761 .12361 L
.65845 .12361 L
.69778 .12361 L
Mistroke
.73559 .12361 L
.77585 .12361 L
.8146 .12361 L
.8558 .12361 L
.89548 .12361 L
.93365 .12361 L
.97427 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Koooo1@00083oool009goool00`000?ooooooo`20oooo002Moooo00<0003ooooo
ool00oooo`<0001joooo002Eoooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0N_oo
o`00WOooo`030000oooooooo00?oool00`000?ooooooo`1joooo002Loooo0P0000Goool00`000?oo
ooooo`1joooo002Soooo00<0003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool2
0000Noooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0
003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002S
oooo00<0003oooooool0N_ooo`00Xoooo`80001koooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool00:?oool20000Noooo`00:oooo`<0000Xoooo0`0002?oool4
00008oooo`030000oooooooo02?oool400009oooo`<0000Yoooo000[oooo00@0003oooooool0000X
oooo00<0003oooooool08_ooo`030000oooooooo02Coool00`000?ooooooo`0Soooo00<0003ooooo
ool0:Oooo`030000oooooooo02Soool002_oool010000?ooooooo`0002Goool500009?ooo`030000
oooooooo02?oool00`000?ooooooo`0Toooo00<0003oooooool09Oooo`D0000Yoooo000Uoooo1000
00;oool300008?ooo`@00002oooo00@0003oooooool0000Noooo100000Coool00`000?ooooooo`0R
oooo00<0003oooooool09Oooo`030000oooooooo02Coool010000?ooooooo`0002[oool002coool0
0`000?ooooooo`0Voooo00<0003oool000009?ooo`040000oooooooo00008oooo`030000oooooooo
02?oool010000?ooooooo`0002Koool00`000?ooo`00000Zoooo000/oooo0`0002Ooool200009Ooo
o`80000Toooo0P0002Goool20000:?ooo`80000Zoooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool0013ooooo00004Oooo`005_ooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooo`1Vo`07oooo00<0003ooooo
ool01oooo`030000oooo0000010000000c?o000003?o0008<ol000<0000co`0co`001c?o00030000
<ol0<ol000Lco`000`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool05Oooo`00:_ooo`030000oooooooo02Koool00`000?ooooooo`09oooo00<0I_ooooooool06Ooo
o`030000oooooooo00Koool400006c?o00030000oooooooo02Goool00`000?ooooooo`0Voooo00<0
003oooooool0:Oooo`005_ooo`<0I_m6oooo00<0I_ooooooool09_ooo`@0000G<ol000<0003ooooo
ool0N_ooo`006Oooo`D0I_m1oooo00<0I_ooooooool0:_ooo`030000<ol0<ol001@co`000`000?oo
ooooo`1joooo000Noooo101Vocgoool00`1Vooooooooo`0[oooo0P0001@co`000`000?ooooooo`1j
oooo000Roooo0P1Voc_oool00`1Vooooooooo`0]oooo00<0000co`0co`004C?o00030000oooooooo
07[oool002Coool306Ko>?ooo`0306Kooooooooo02koool00`0003?o03?o000@<ol00P0007_oool0
02Ooool206Ko=_ooo`0306Kooooooooo02ooool2000043?o00030000oooooooo07[oool002Woool2
06Ko=?ooo`0306Kooooooooo037oool00`0003?o03?o000=<ol000<0003oooooool0N_ooo`00:ooo
o`0306Kooooooooo037oool00`1Vooooooooo`0aoooo00<0000co`0co`003C?o00030000oooooooo
07[oool002coool00`1Vooooooooo`0`oooo00<0I_ooooooool0<_ooo`030000<ol0<ol000`co`00
0`000?ooooooo`1joooo000]oooo0P1Voc3oool00`1Vooooooooo`0boooo00<0000co`0co`0033?o
00030000oooooooo07[oool002ooool00`1Vooooooooo`0]oooo00<0I_ooooooool0<oooo`030000
<ol0<ol000/co`020000Noooo`00<?ooo`0306Kooooooooo02coool00`1Vooooooooo`0coooo00<0
000co`0co`002c?o00030000oooooooo07[oool0037oool00`1Vooooooooo`0[oooo00<0I_oooooo
ool0=?ooo`030000<ol0<ol000Xco`000`000?ooooooo`1joooo000boooo00<0I_ooooooool0:_oo
o`0306Kooooooooo03Coool00`0003?o03?o000:<ol000<0003oooooool0N_ooo`00<_ooo`0306Ko
oooooooo02[oool00`1Vooooooooo`0eoooo00<0000co`0co`002C?o00030000oooooooo07[oool0
03?oool00`1Vooooooooo`0Yoooo00<0I_ooooooool0=Oooo`030000<ol0<ol000Tco`000`000?oo
ooooo`1joooo000doooo00<0I_ooooooool09Oooo`@0I_lhoooo00<0000co`0co`0023?o0080001k
oooo000eoooo00<0I_ooooooool07_ooo`H0I_l3oooo00?o09Woooooool0=_ooo`030000<ol0<ol0
00Pco`000`000?ooooooo`1joooo000eoooo0P1VoaGoool:06Ko2Oooo`03o`2Ioooooooo03Koool0
0`0003?o03?o0008<ol000<0003oooooool0N_ooo`00=_oooaH0I_lCoooo00?o09Woooooool0=ooo
o`030000<ol0<ol000Lco`000`000?ooooooo`1joooo001Ooooo00?o09Woooooool0=oooo`030000
<ol0<ol000Lco`000`000?ooooooo`1joooo001Ooooo00?o09Woooooool0=oooo`030000<ol0<ol0
00Lco`000`000?ooooooo`1joooo001Ooooo00?o09Woooooool0=oooo`030000<ol0<ol000Lco`02
0000Noooo`00Goooo`03o`2Ioooooooo03Soool00`0003?o03?o0006<ol000<0003oooooool0N_oo
o`00Goooo`03o`2Ioooooooo03Soool00`0003?o03?o0006<ol000<0003oooooool0N_ooo`00Gooo
o`03o`2Ioooooooo03Soool00`0003?o03?o0006<ol000<0003oooooool0N_ooo`00Goooo`03o`2I
oooooooo03Soool00`0003?o03?o0006<ol000<0003oooooool0N_ooo`00Goooo`03o`2Ioooooooo
03Woool500000c?o00030000oooooooo07[oool005ooool00ol0VOooooooo`0ioooo00<0000co`00
00001C?o00030000oooooooo07[oool005ooool00ol0VOooooooo`0ioooo00<0000co`0000001C?o
00<0001joooo001Ooooo00?o09Woooooool0>_ooo`800005<ol000<0003oooooool0N_ooo`00Gooo
o`03o`2Ioooooooo03[oool200001C?o00030000oooooooo07[oool005ooool00ol0VOooooooo`0j
oooo0P0000Dco`000`000?ooooooo`1joooo001Ooooo00?o09Woooooool0>_ooo`030000<ol0<ol0
00@co`000`000?ooooooo`1joooo001Ooooo00?o09Woooooool0>_ooo`030000<ol0<ol000@co`00
0`000?ooooooo`1joooo001Ooooo00?o09Woooooool0>_ooo`030000<ol0<ol000@co`020000Nooo
o`00Goooo`03o`2Ioooooooo03_oool00`0003?o03?o0003<ol000<0003oooooool0N_ooo`00Gooo
o`03o`2Ioooooooo03_oool00`0003?o03?o0003<ol000<0003oooooool0N_ooo`00Goooo`03o`2I
oooooooo03_oool00`0003?o03?o0003<ol000<0003oooooool0N_ooo`00Goooo`03o`2Ioooooooo
03_oool00`0003?o03?o0003<ol000<0003oooooool0N_ooo`00Goooo`03o`2Ioooooooo03_oool0
0`0003?o03?o0003<ol000<0003oooooool0N_ooo`00Goooo`03o`2Ioooooooo03_oool00`0003?o
03?o0003<ol00P0007_oool005ooool00ol0VOooooooo`0koooo00<0000co`0co`000c?o00030000
oooooooo07[oool005ooool00ol0VOooooooo`0koooo00<0000co`0co`000c?o00030000oooooooo
07[oool005ooool00ol0VOooooooo`0loooo00<0000co`0co`000S?o00030000oooooooo07[oool0
05ooool00ol0VOooooooo`0loooo00<0000co`0co`000S?o00030000oooooooo07[oool005ooool0
0ol0VOooooooo`0loooo00<0000co`0co`000S?o00030000oooooooo07[oool005ooool00ol0VOoo
ooooo`0loooo00<0000co`0co`000S?o00030000oooooooo07[oool005ooool00ol0VOooooooo`0l
oooo00<0000co`0co`000S?o0080001koooo001Ooooo00?o09Woooooool0??ooo`030000<ol0<ol0
008co`000`000?ooooooo`1joooo001Ooooo00?o09Woooooool0??ooo`030000<ol0<ol0008co`00
0`000?ooooooo`1joooo001Ooooo00?o09Woooooool0??ooo`030000<ol0<ol0008co`000`000?oo
ooooo`1joooo001Ooooo00?o09Woooooool0??ooo`030000<ol0<ol0008co`000`000?ooooooo`1j
oooo001Ooooo00?o09Woooooool0??ooo`030000<ol0<ol0008co`000`000?ooooooo`1joooo001O
oooo00?o09Woooooool0??ooo`030000<ol0<ol0008co`020000Noooo`00Goooo`03o`2Ioooooooo
03goool01@0003?o03?o03?o0000001loooo001Ooooo00?o09Woooooool0?Oooo`050000<ol0<ol0
<ol0000007coool005ooool00ol0VOooooooo`0moooo00D0000co`0co`0co`000000O?ooo`00Gooo
o`03o`2Ioooooooo03Woool500000c?o00030000oooooooo07[oool005ooool00ol0VOooooooo`0i
oooo00D0003oooooooooool000000c?o00030000oooooooo07[oool005ooool00ol0VOooooooo`0j
oooo00@0003oooooool00003<ol00`0007[oool005ooool00ol0VOooooooo`0koooo00<0003oool0
00000c?o00030000oooooooo07[oool005ooool00ol0VOooooooo`0ioooo00<0003oooooool00P00
00<co`000`000?ooooooo`1joooo001Ooooo00?o09Woooooool0>_ooo`8000000oooo`0003?o0002
<ol000<0003oooooool0N_ooo`00Goooo`03o`2Ioooooooo03goool01@0003?o03?o03?o0000001l
oooo001Ooooo00?o09Woooooool0?_ooo`040000<ol0<ol00000O?ooo`00Goooo`03o`2Ioooooooo
03koool00`0003?o03?o00020000Noooo`00Goooo`03o`2Ioooooooo03koool0100003?o03?o0000
07coool005ooool00ol0VOooooooo`0noooo00@0000co`0co`00001loooo001Ooooo00?o09Wooooo
ool0?_ooo`040000<ol0<ol00000O?ooo`00Goooo`03o`2Ioooooooo03koool0100003?o03?o0000
07coool005ooool00ol0VOooooooo`0noooo00@0000co`0co`00001loooo001Ooooo00?o09Wooooo
ool0?_ooo`040000<ol0<ol00000O?ooo`00Goooo`03o`2Ioooooooo03ooool0100003?o00000000
07_oool005ooool00ol0VOooooooo`0ooooo00<0000co`000000O?ooo`00Goooo`03o`2Ioooooooo
03ooool00`0003?o0000001loooo001Ooooo00?o09Woooooool0?oooo`030000<ol0000007coool0
05ooool00ol0VOooooooo`0ooooo00<0000co`000000O?ooo`00Goooo`03o`2Ioooooooo03ooool0
0`0003?o0000001loooo001Ooooo00?o09Woooooool0?oooo`040000<ol000000000Noooo`00Gooo
o`03o`2Ioooooooo03ooool00`0003?o0000001loooo001Ooooo00?o09Woooooool0?oooo`030000
<ol0000007coool005ooool00ol0VOooooooo`0ooooo00<0000co`000000O?ooo`00Goooo`03o`2I
oooooooo03ooool00`0003?o0000001loooo001Ooooo00?o09Woooooool0?oooo`030000<ol00000
07coool005ooool00ol0VOooooooo`0ooooo00@0000co`000000001koooo001Ooooo00?o09Wooooo
ool0?oooo`030000<ol0000007coool005ooool00ol0VOooooooo`0ooooo00<0000co`000000O?oo
o`00Goooo`03o`2Ioooooooo03ooool00`0003?o0000001loooo001Ooooo00?o09Woooooool0>_oo
o`800003oooo00<0000co`000000O?ooo`00Goooo`03o`2Ioooooooo03Woool010000?ooooooo`00
00;oool00`0003?o0000001loooo001Ooooo00?o09Woooooool0>oooo`060000oooooooooooo0000
<ol00`0007[oool005ooool00ol0VOooooooo`0loooo00H0003oooooool0000co`00001loooo001O
oooo00?o09Woooooool0>Oooo`040000oooooooo00000_ooo`030000<ol0000007coool005ooool0
0ol0VOooooooo`0joooo0P0000Coool20000O?ooo`00Goooo`03o`2Ioooooooo043oool20000O?oo
o`00Goooo`03o`2Ioooooooo043oool20000O?ooo`00Goooo`03o`2Ioooooooo043oool20000O?oo
o`00Goooo`03o`2Ioooooooo043oool30000Noooo`00Goooo`03o`2Ioooooooo043oool20000O?oo
o`00Goooo`03o`2Ioooooooo043oool20000O?ooo`00Goooo`03o`2Ioooooooo043oool20000O?oo
o`00Goooo`03o`2Ioooooooo043oool20000O?ooo`00Goooo`03o`2Ioooooooo043oool20000O?oo
o`00Goooo`03o`2Ioooooooo043oool30000Noooo`00Goooo`03o`2Ioooooooo043oool20000O?oo
o`00Goooo`03o`2Ioooooooo043oool20000O?ooo`00Goooo`03o`2Ioooooooo043oool20000O?oo
o`00Goooo`03o`2Ioooooooo043oool20000O?ooo`00Goooo`03o`2Ioooooooo043oool20000O?oo
o`00Goooo`03o`2Ioooooooo043oool30000Noooo`00Goooo`03o`2Ioooooooo047oool00`000?oo
ooooo`1joooo001Ooooo00?o09Woooooool0@Oooo`030000oooooooo07[oool005ooool00ol0VOoo
ooooo`11oooo00<0003oooooool0N_ooo`00Goooo`03o`2Ioooooooo047oool00`000?ooooooo`1j
oooo001Ooooo00?o09Woooooool0@Oooo`030000oooooooo07[oool005ooool00ol0VOooooooo`11
oooo0P0007_oool005ooool00ol0VOooooooo`11oooo00<0003oooooool0N_ooo`00Goooo`03o`2I
oooooooo047oool00`000?ooooooo`1joooo001Ooooo00?o09Woooooool0@Oooo`030000oooooooo
07[oool005ooool00ol0VOooooooo`11oooo00<0003oooooool0N_ooo`00Goooo`03o`2Ioooooooo
03_oool300000oooo`030000oooooooo07[oool005ooool00ol0VOooooooo`0loooo00<0003ooooo
ool00_ooo`030000oooooooo07[oool005ooool00ol0VOooooooo`0ioooo1@0000?oool30000N_oo
o`00Voooo`040000oooooooo0000POooo`00W?ooo`030000oooo0000087oool009goool20000POoo
o`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo07Woool0
07Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool007Soool0
0`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0>oooo0`0000;oool200001Oooo`<00002
oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?ooooooo`02
oooo00<0003oooooool01?ooo`@00006oooo00<0003oooooool02Oooo`050000oooooooooooo0000
07[oool007Ooool00`000?ooooooo`02oooo00<0003oooooool04oooo`D00007oooo1@0000?oool0
0`000?ooooooo`1goooo001hoooo00<0003oooooool01@0001;oool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000005_oo
o`030000oooo000000Woool00`000?ooo`000003oooo00<0003oooooool0N?ooo`00NOooo`030000
oooooooo01Soool200002_ooo`800002oooo00<0003oooooool0NOooo`00ooooob7oool00?oooolQ
oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-8.12947, \
-1.14361, 0.0496935, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-8.12947, -1.14361, 0.0496935, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
.2 1 0 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.29205 .12361 L
.30316 .12361 L
.30791 .12361 L
.31304 .12361 L
.31454 .12361 L
.31597 .12361 L
.31725 .12361 L
s
.31725 .12361 m
.31754 .61803 L
s
0 .4 1 r
.02381 .13142 m
.04262 .13453 L
.06244 .13917 L
.07286 .14234 L
.08255 .14587 L
.09388 .15085 L
.10458 .15657 L
.125 .17104 L
.14357 .18965 L
.15327 .2021 L
.15562 .20547 L
.15692 .20738 L
.15816 .20925 L
.15885 .21012 L
.15961 .21011 L
.16094 .21009 L
.16355 .21004 L
.18199 .20967 L
.20166 .2091 L
.21266 .20869 L
.22263 .20824 L
.24188 .20711 L
.25272 .20628 L
.2627 .20536 L
.28152 .2031 L
.29221 .20144 L
.30219 .19958 L
.30719 .19852 L
.30983 .19791 L
.31264 .19724 L
.31508 .19663 L
.31575 .19646 L
.31647 .19627 L
.31778 .12361 L
.31899 .12361 L
.32026 .12361 L
.32135 .12361 L
.32254 .12361 L
.32379 .12361 L
.32497 .12361 L
.32604 .12361 L
.32719 .12361 L
.32844 .12361 L
.32907 .12361 L
.32977 .12361 L
.331 .12361 L
.33215 .12361 L
.33331 .12361 L
.3344 .12361 L
.33539 .12361 L
Mistroke
.33646 .12361 L
.33763 .12361 L
.33887 .12361 L
.34004 .12361 L
.34109 .12361 L
.3423 .12361 L
.34343 .12361 L
.34466 .12361 L
.34599 .12361 L
.34665 .12361 L
.34737 .12361 L
.34869 .12361 L
.34996 .12361 L
.35115 .12361 L
.35225 .12361 L
.35328 .12361 L
.35441 .12361 L
.35563 .12361 L
.35684 .12361 L
.35811 .12361 L
.35919 .12361 L
.36038 .12361 L
.36106 .12361 L
.36179 .12361 L
.36248 .12361 L
.36312 .12361 L
.36433 .12361 L
.3656 .12361 L
.36627 .12361 L
.36698 .12361 L
.36826 .12361 L
.36904 .12361 L
.36979 .12361 L
.37045 .12361 L
.37118 .12361 L
.37238 .12361 L
.37306 .12361 L
.3737 .12361 L
.375 .12361 L
.37572 .12361 L
.37639 .12361 L
.37761 .12361 L
.37874 .12361 L
.37992 .12361 L
.38121 .12361 L
.38249 .12361 L
.38313 .12361 L
.38383 .12361 L
.38508 .12361 L
.38625 .12361 L
Mistroke
.38696 .12361 L
.38763 .12361 L
.38889 .12361 L
.38959 .12361 L
.39026 .12361 L
.39102 .12361 L
.39172 .12361 L
.3929 .12361 L
.39418 .12361 L
.39537 .12361 L
.39647 .12361 L
.39767 .12361 L
.39899 .12361 L
.39965 .12361 L
.40036 .12361 L
.40165 .12361 L
.40289 .12361 L
.40404 .12361 L
.4053 .12361 L
.40594 .12361 L
.40664 .12361 L
.40781 .12361 L
.40908 .12361 L
.41027 .12361 L
.41137 .12361 L
.41244 .12361 L
.41343 .12361 L
.41452 .12361 L
.41568 .12361 L
.41691 .12361 L
.41806 .12361 L
.4191 .12361 L
.42023 .12361 L
.42146 .12361 L
.42259 .12361 L
.42389 .12361 L
.42512 .12361 L
.42626 .12361 L
.42731 .12361 L
.42847 .12361 L
.4297 .12361 L
.43041 .12361 L
.43106 .12361 L
.43177 .12361 L
.43252 .12361 L
.43378 .12361 L
.4345 .12361 L
.43517 .12361 L
.43642 .12361 L
.43756 .12361 L
Mistroke
.43887 .12361 L
.44012 .12361 L
.44133 .12361 L
.44202 .12361 L
.44266 .12361 L
.44396 .12361 L
.44463 .12361 L
.44536 .12361 L
.44666 .12361 L
.44789 .12361 L
.44909 .12361 L
.45021 .12361 L
.4509 .12361 L
.45164 .12361 L
.4523 .12361 L
.45299 .12361 L
.4543 .12361 L
.45551 .12361 L
.45618 .12361 L
.4569 .12361 L
.45821 .12361 L
.459 .12361 L
.45975 .12361 L
.46043 .12361 L
.46117 .12361 L
.46238 .12361 L
.4635 .12361 L
.46472 .12361 L
.46601 .12361 L
.46713 .12361 L
.46818 .12361 L
.46933 .12361 L
.47056 .12361 L
.47126 .12361 L
.4719 .12361 L
.47261 .12361 L
.47335 .12361 L
.47461 .12361 L
.47532 .12361 L
.47599 .12361 L
.47724 .12361 L
.47837 .12361 L
.47968 .12361 L
.48093 .12361 L
.48161 .12361 L
.48225 .12361 L
.48345 .12361 L
.48475 .12361 L
.48547 .12361 L
.48614 .12361 L
Mistroke
.48727 .12361 L
.4885 .12361 L
.48978 .12361 L
.49098 .12361 L
.49166 .12361 L
.4924 .12361 L
.4931 .12361 L
.49375 .12361 L
.49497 .12361 L
.49627 .12361 L
.49694 .12361 L
.49766 .12361 L
.49896 .12361 L
.49972 .12361 L
.50051 .12361 L
.50119 .12361 L
.50193 .12361 L
.50317 .12361 L
.50448 .12361 L
.50516 .12361 L
.50591 .12361 L
.50723 .12361 L
.50848 .12361 L
.50918 .12361 L
.50982 .12361 L
.51105 .12361 L
.51223 .12361 L
.51336 .12361 L
.51455 .12361 L
.51557 .12361 L
.5167 .12361 L
.51791 .12361 L
.51921 .12361 L
.52045 .12361 L
.52157 .12361 L
.52278 .12361 L
.52393 .12361 L
.52525 .12361 L
.52645 .12361 L
.52713 .12361 L
.52777 .12361 L
.52847 .12361 L
.52921 .12361 L
.53043 .12361 L
.53113 .12361 L
.53178 .12361 L
.53244 .12361 L
.53317 .12361 L
.53449 .12361 L
.53577 .12361 L
Mistroke
.53696 .12361 L
.53769 .12361 L
.53838 .12361 L
.53966 .12361 L
.54038 .12361 L
.54104 .12361 L
.54177 .12361 L
.54254 .12361 L
.54376 .12361 L
.54445 .12361 L
.54508 .12361 L
.54625 .12361 L
.5475 .12361 L
.5486 .12361 L
.54965 .12361 L
.55078 .12361 L
.55202 .12361 L
.55326 .12361 L
.55457 .12361 L
.55578 .12361 L
.55691 .12361 L
.5576 .12361 L
.55824 .12361 L
.55946 .12361 L
.56076 .12361 L
.5615 .12361 L
.56218 .12361 L
.56324 .12361 L
.56437 .12361 L
.56544 .12361 L
.56642 .12361 L
.56757 .12361 L
.56881 .12361 L
.56999 .12361 L
.57109 .12361 L
.57232 .12361 L
.57348 .12361 L
.57453 .12361 L
.57565 .12361 L
.57689 .12361 L
.57819 .12361 L
.5793 .12361 L
.58052 .12361 L
.58183 .12361 L
.58304 .12361 L
.58578 .12361 L
.59075 .12361 L
.60007 .12361 L
.621 .12361 L
.66033 .12361 L
Mistroke
.69814 .12361 L
.7384 .12361 L
.77715 .12361 L
.81835 .12361 L
.85803 .12361 L
.8962 .12361 L
.93682 .12361 L
.97592 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Koooo1@00083oool009goool00`000?ooooooo`20oooo002Moooo00<0003ooooo
ool00oooo`<0001joooo002Eoooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0N_oo
o`00WOooo`030000oooooooo00?oool00`000?ooooooo`1joooo002Loooo0P0000Goool00`000?oo
ooooo`1joooo002Soooo00<0003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool2
0000Noooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0
003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002S
oooo00<0003oooooool0N_ooo`00Xoooo`80001koooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool00:?oool20000Noooo`00:oooo`<0000Xoooo0`0002?oool4
00008oooo`030000oooooooo02?oool400009oooo`<0000Yoooo000[oooo00@0003oooooool0000X
oooo00<0003oooooool08_ooo`030000oooooooo02Coool00`000?ooooooo`0Soooo00<0003ooooo
ool0:Oooo`030000oooooooo02Soool002_oool010000?ooooooo`0002Goool500009?ooo`030000
oooooooo02?oool00`000?ooooooo`0Toooo00<0003oooooool09Oooo`D0000Yoooo000Uoooo1000
00;oool300008?ooo`@00002oooo00@0003oooooool0000Noooo100000Coool00`000?ooooooo`0R
oooo00<0003oooooool09Oooo`030000oooooooo02Coool010000?ooooooo`0002[oool002coool0
0`000?ooooooo`0Voooo00<0003oool000009?ooo`040000oooooooo00008oooo`030000oooooooo
02?oool010000?ooooooo`0002Koool00`000?ooo`00000Zoooo000/oooo0`0002Ooool200009Ooo
o`80000Toooo0P0002Goool20000:?ooo`80000Zoooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool0013ooooo00004Oooo`005_ooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Ooool01@000?ooooooooooo`1Vo`05oooo00<0
003oooooool01oooo`030000oooo0000010000000c?o000003?o0008<ol000<0000co`0co`001c?o
00030000<ol0<ol000Lco`000`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo
00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?oo
ooooo`08oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0
003oooooool05Oooo`005_ooo`<0I_lAoooo00<0003oooooool09_ooo`030000oooooooo00_oool0
0`1Vooooooooo`0Goooo00<0003oooooool01_ooo`@0000K<ol000<0003oooooool09Oooo`030000
oooooooo02Koool00`000?ooooooo`0Yoooo000Ioooo1@1Vod?oool00`1Vooooooooo`0Toooo1000
01Lco`000`000?ooooooo`1joooo000Noooo101Vocooool00`1Vooooooooo`0Xoooo00<0000co`0c
o`0053?o00030000oooooooo07[oool002;oool206Ko?Oooo`0306Kooooooooo02Woool2000053?o
00030000oooooooo07[oool002Coool306Ko>_ooo`0306Kooooooooo02_oool00`0003?o03?o000A
<ol000<0003oooooool0N_ooo`009oooo`80I_lhoooo00<0I_ooooooool0;?ooo`030000<ol0<ol0
010co`020000Noooo`00:Oooo`80I_lfoooo00<0I_ooooooool0;Oooo`80000@<ol000<0003ooooo
ool0N_ooo`00:oooo`0306Kooooooooo03?oool00`1Vooooooooo`0_oooo00<0000co`0co`003C?o
00030000oooooooo07[oool002coool206Ko<_ooo`0306Koo`2Ioooo033oool00`0003?o03?o000=
<ol000<0003oooooool0N_ooo`00;_ooo`80I_l`oooo00<0I_oo09Woool0<Oooo`030000<ol0<ol0
00`co`000`000?ooooooo`1joooo000`oooo00<0I_ooooooool0;Oooo`0306Koo`2Ioooo037oool0
0`0003?o03?o000<<ol000<0003oooooool0N_ooo`00<Oooo`0306Kooooooooo02coool00`1Vool0
VOooo`0boooo00<0000co`0co`002c?o0080001koooo000boooo00<0I_ooooooool0:oooo`0306Ko
o`2Ioooo03;oool00`0003?o03?o000;<ol000<0003oooooool0N_ooo`00<oooo`0306Kooooooooo
02[oool00`1Vool0VOooo`0coooo00<0000co`0co`002S?o00030000oooooooo07[oool003Coool0
0`1Vooooooooo`0Yoooo00<0I_oo09Woool0<oooo`030000<ol0<ol000Xco`000`000?ooooooo`1j
oooo000eoooo00<0I_ooooooool0:?ooo`0306Koo`2Ioooo03Coool00`0003?o03?o0009<ol000<0
003oooooool0N_ooo`00=_ooo`0306Kooooooooo02Ooool00`1Vool0VOooo`0doooo00<0000co`0c
o`002C?o00030000oooooooo07[oool003Koool00`1Vooooooooo`0Uoooo0`1Vo`03o`2Ioooooooo
03Coool00`0003?o03?o0008<ol00P0007_oool003Ooool00`1Vooooooooo`0Poooo101Vo`?oool0
0ol0VOooooooo`0doooo00<0000co`0co`0023?o00030000oooooooo07[oool003Soool00`1Voooo
ooooo`0Eoooo2P1Vo`Ooool00ol0VOooooooo`0doooo00<0000co`0co`0023?o00030000oooooooo
07[oool003SooolH06Ko4Oooo`03o`2Ioooooooo03Goool00`0003?o03?o0007<ol000<0003ooooo
ool0N_ooo`00HOooo`03o`2Ioooooooo03Goool00`0003?o03?o0007<ol000<0003oooooool0N_oo
o`00HOooo`03o`2Ioooooooo03Goool00`0003?o03?o0007<ol000<0003oooooool0N_ooo`00HOoo
o`03o`2Ioooooooo03Goool00`0003?o03?o0007<ol00P0007_oool0067oool00ol0VOooooooo`0f
oooo00<0000co`0co`001S?o00030000oooooooo07[oool0067oool00ol0VOooooooo`0foooo00<0
000co`0co`001S?o00030000oooooooo07[oool0067oool00ol0VOooooooo`0foooo00<0000co`0c
o`001S?o00030000oooooooo07[oool0067oool00ol0VOooooooo`0foooo00<0000co`0co`001S?o
00030000oooooooo07[oool0067oool00ol0VOooooooo`0goooo1@0000<co`000`000?ooooooo`1j
oooo001Qoooo00?o09Woooooool0=oooo`030000<ol0000000Dco`000`000?ooooooo`1joooo001Q
oooo00?o09Woooooool0=oooo`030000<ol0000000Dco`030000N_ooo`00HOooo`03o`2Ioooooooo
03Soool200001C?o00030000oooooooo07[oool0067oool00ol0VOooooooo`0hoooo0P0000Dco`00
0`000?ooooooo`1joooo001Qoooo00?o09Woooooool0>?ooo`800005<ol000<0003oooooool0N_oo
o`00HOooo`03o`2Ioooooooo03Soool00`0003?o03?o0004<ol000<0003oooooool0N_ooo`00HOoo
o`03o`2Ioooooooo03Soool00`0003?o03?o0004<ol000<0003oooooool0N_ooo`00HOooo`03o`2I
oooooooo03Soool00`0003?o03?o0004<ol00P0007_oool0067oool00ol0VOooooooo`0ioooo00<0
000co`0co`000c?o00030000oooooooo07[oool0067oool00ol0VOooooooo`0ioooo00<0000co`0c
o`000c?o00030000oooooooo07[oool0067oool00ol0VOooooooo`0ioooo00<0000co`0co`000c?o
00030000oooooooo07[oool0067oool00ol0VOooooooo`0ioooo00<0000co`0co`000c?o00030000
oooooooo07[oool0067oool00ol0VOooooooo`0ioooo00<0000co`0co`000c?o00030000oooooooo
07[oool0067oool00ol0VOooooooo`0ioooo00<0000co`0co`000c?o0080001koooo001Qoooo00?o
09Woooooool0>Oooo`030000<ol0<ol000<co`000`000?ooooooo`1joooo001Qoooo00?o09Wooooo
ool0>Oooo`030000<ol0<ol000<co`000`000?ooooooo`1joooo001Qoooo00?o09Woooooool0>_oo
o`030000<ol0<ol0008co`000`000?ooooooo`1joooo001Qoooo00?o09Woooooool0>_ooo`030000
<ol0<ol0008co`000`000?ooooooo`1joooo001Qoooo00?o09Woooooool0>_ooo`030000<ol0<ol0
008co`000`000?ooooooo`1joooo001Qoooo00?o09Woooooool0>_ooo`030000<ol0<ol0008co`00
0`000?ooooooo`1joooo001Qoooo00?o09Woooooool0>_ooo`030000<ol0<ol0008co`020000Nooo
o`00HOooo`03o`2Ioooooooo03[oool00`0003?o03?o0002<ol000<0003oooooool0N_ooo`00HOoo
o`03o`2Ioooooooo03[oool00`0003?o03?o0002<ol000<0003oooooool0N_ooo`00HOooo`03o`2I
oooooooo03[oool00`0003?o03?o0002<ol000<0003oooooool0N_ooo`00HOooo`03o`2Ioooooooo
03[oool00`0003?o03?o0002<ol000<0003oooooool0N_ooo`00HOooo`03o`2Ioooooooo03[oool0
0`0003?o03?o0002<ol000<0003oooooool0N_ooo`00HOooo`03o`2Ioooooooo03[oool00`0003?o
03?o0002<ol00P0007_oool0067oool00ol0VOooooooo`0koooo00D0000co`0co`0co`000000O?oo
o`00HOooo`03o`2Ioooooooo03_oool01@0003?o03?o03?o0000001loooo001Qoooo00?o09Wooooo
ool0>oooo`050000<ol0<ol0<ol0000007coool0067oool00ol0VOooooooo`0goooo1@0000<co`00
0`000?ooooooo`1joooo001Qoooo00?o09Woooooool0=oooo`050000oooooooooooo000000<co`00
0`000?ooooooo`1joooo001Qoooo00?o09Woooooool0>?ooo`040000oooooooo00000c?o00<0001j
oooo001Qoooo00?o09Woooooool0>Oooo`030000oooo000000<co`000`000?ooooooo`1joooo001Q
oooo00?o09Woooooool0=oooo`030000oooooooo00800003<ol000<0003oooooool0N_ooo`00HOoo
o`03o`2Ioooooooo03Soool2000000?oool0000co`000S?o00030000oooooooo07[oool0067oool0
0ol0VOooooooo`0koooo00D0000co`0co`0co`000000O?ooo`00HOooo`03o`2Ioooooooo03coool0
100003?o03?o000007coool0067oool00ol0VOooooooo`0loooo00<0000co`0co`000P0007_oool0
067oool00ol0VOooooooo`0loooo00@0000co`0co`00001loooo001Qoooo00?o09Woooooool0??oo
o`040000<ol0<ol00000O?ooo`00HOooo`03o`2Ioooooooo03coool0100003?o03?o000007coool0
067oool00ol0VOooooooo`0loooo00@0000co`0co`00001loooo001Qoooo00?o09Woooooool0??oo
o`040000<ol0<ol00000O?ooo`00HOooo`03o`2Ioooooooo03coool0100003?o03?o000007coool0
067oool00ol0VOooooooo`0moooo00@0000co`000000001koooo001Qoooo00?o09Woooooool0?Ooo
o`030000<ol0000007coool0067oool00ol0VOooooooo`0moooo00<0000co`000000O?ooo`00HOoo
o`03o`2Ioooooooo03goool00`0003?o0000001loooo001Qoooo00?o09Woooooool0?Oooo`030000
<ol0000007coool0067oool00ol0VOooooooo`0moooo00<0000co`000000O?ooo`00HOooo`03o`2I
oooooooo03goool0100003?o0000000007_oool0067oool00ol0VOooooooo`0moooo00<0000co`00
0000O?ooo`00HOooo`03o`2Ioooooooo03goool00`0003?o0000001loooo001Qoooo00?o09Wooooo
ool0?Oooo`030000<ol0000007coool0067oool00ol0VOooooooo`0moooo00<0000co`000000O?oo
o`00HOooo`03o`2Ioooooooo03goool00`0003?o0000001loooo001Qoooo00?o09Woooooool0?Ooo
o`040000<ol000000000Noooo`00HOooo`03o`2Ioooooooo03goool00`0003?o0000001loooo001Q
oooo00?o09Woooooool0?Oooo`030000<ol0000007coool0067oool00ol0VOooooooo`0moooo00<0
000co`000000O?ooo`00HOooo`03o`2Ioooooooo03Soool200000oooo`030000<ol0000007coool0
067oool00ol0VOooooooo`0goooo00@0003oooooool00002oooo00<0000co`000000O?ooo`00HOoo
o`03o`2Ioooooooo03Woool01P000?ooooooooooo`0003?o00<0001joooo001Qoooo00?o09Wooooo
ool0>_ooo`060000oooooooo0000<ol00000O?ooo`00HOooo`03o`2Ioooooooo03Ooool010000?oo
ooooo`0000;oool00`0003?o0000001loooo001Qoooo00?o09Woooooool0>?ooo`800004oooo0P00
07coool0067oool00ol0VOooooooo`0noooo0P0007coool0067oool00ol0VOooooooo`0noooo0P00
07coool0067oool00ol0VOooooooo`0noooo0P0007coool0067oool00ol0VOooooooo`0noooo0`00
07_oool0067oool00ol0VOooooooo`0noooo0P0007coool0067oool00ol0VOooooooo`0noooo0P00
07coool0067oool00ol0VOooooooo`0noooo0P0007coool0067oool00ol0VOooooooo`0noooo0P00
07coool0067oool00ol0VOooooooo`0noooo0P0007coool0067oool00ol0VOooooooo`0noooo0`00
07_oool0067oool00ol0VOooooooo`0noooo0P0007coool0067oool00ol0VOooooooo`0noooo0P00
07coool0067oool00ol0VOooooooo`0noooo0P0007coool0067oool00ol0VOooooooo`0noooo0P00
07coool0067oool00ol0VOooooooo`0noooo0P0007coool0067oool00ol0VOooooooo`0noooo0`00
07_oool0067oool00ol0VOooooooo`0ooooo00<0003oooooool0N_ooo`00HOooo`03o`2Ioooooooo
03ooool00`000?ooooooo`1joooo001Qoooo00?o09Woooooool0?oooo`030000oooooooo07[oool0
067oool00ol0VOooooooo`0ooooo00<0003oooooool0N_ooo`00HOooo`03o`2Ioooooooo03ooool0
0`000?ooooooo`1joooo001Qoooo00?o09Woooooool0?oooo`80001koooo001Qoooo00?o09Wooooo
ool0?oooo`030000oooooooo07[oool0067oool00ol0VOooooooo`0ooooo00<0003oooooool0N_oo
o`00HOooo`03o`2Ioooooooo03ooool00`000?ooooooo`1joooo001Qoooo00?o09Woooooool0?ooo
o`030000oooooooo07[oool0067oool00ol0VOooooooo`0ioooo0`0000?oool00`000?ooooooo`1j
oooo001Qoooo00?o09Woooooool0>_ooo`030000oooooooo00;oool00`000?ooooooo`1joooo001Q
oooo00?o09Woooooool0=oooo`D00003oooo0`0007[oool009_oool010000?ooooooo`00087oool0
09coool00`000?ooo`000021oooo002Moooo0P00087oool00?oooolQoooo003ooooo8Oooo`00NOoo
o`030000oooooooo02Soool00`000?ooooooo`1ioooo001hoooo00<0003oooooool02?ooo`030000
oooooooo01ooool00`000?ooooooo`1hoooo001hoooo00<0003oooooool00_ooo`800004oooo00<0
003oooooool03_ooo`<00002oooo0P0000Coool200001?ooo`030000oooooooo07Soool007Soool0
1@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo00Coool400001_oo
o`030000oooooooo00Koool010000?ooooooo`0000?oool00`000?ooooooo`1hoooo001goooo00<0
003oooooool00_ooo`030000oooooooo01?oool500002Oooo`030000oooooooo00?oool00`000?oo
ooooo`1goooo001hoooo00<0003oooooool01@0001;oool010000?ooooooo`0000_oool01@000?oo
ooooooooo`00001joooo001hoooo00D0003oooooooooool000005_ooo`030000oooo000000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`1hoooo001ioooo00<0003oooooool06?ooo`800009
oooo0P0000?oool00`000?ooooooo`1ioooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-8.12947, \
-1.14361, 0.0496935, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-8.12947, -1.14361, 0.0496935, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
.2 1 0 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.31875 .12361 L
.32145 .12361 L
.32263 .12361 L
.32392 .12361 L
.32509 .12361 L
s
.32509 .12361 m
.32552 .61803 L
s
0 .4 1 r
.02381 .13039 m
.04262 .13309 L
.06244 .13711 L
.07286 .13987 L
.08255 .14293 L
.09388 .14725 L
.10458 .15222 L
.125 .16478 L
.14357 .18094 L
.15238 .19068 L
.16185 .20301 L
.16464 .20705 L
.1653 .20804 L
.16601 .20911 L
.16728 .21011 L
.16853 .21009 L
.16966 .21007 L
.17225 .21003 L
.18199 .20984 L
.20182 .20935 L
.21265 .209 L
.22285 .2086 L
.24293 .20756 L
.2614 .20621 L
.28023 .2043 L
.29092 .20289 L
.30089 .20131 L
.31134 .19933 L
.31649 .19821 L
.31875 .19768 L
.32124 .19708 L
.32231 .19681 L
.32347 .19651 L
.32456 .19623 L
.32555 .12361 L
.32662 .12361 L
.32778 .12361 L
.329 .12361 L
.33013 .12361 L
.33139 .12361 L
.33258 .12361 L
.33365 .12361 L
.33481 .12361 L
.33607 .12361 L
.3367 .12361 L
.3374 .12361 L
.33864 .12361 L
.3398 .12361 L
.34105 .12361 L
.34175 .12361 L
Mistroke
.34238 .12361 L
.34362 .12361 L
.34478 .12361 L
.34544 .12361 L
.34614 .12361 L
.34739 .12361 L
.34804 .12361 L
.34873 .12361 L
.3495 .12361 L
.35021 .12361 L
.35148 .12361 L
.3522 .12361 L
.35286 .12361 L
.35408 .12361 L
.35538 .12361 L
.35653 .12361 L
.35762 .12361 L
.35881 .12361 L
.36009 .12361 L
.36126 .12361 L
.36234 .12361 L
.36353 .12361 L
.3648 .12361 L
.36603 .12361 L
.36672 .12361 L
.36736 .12361 L
.36853 .12361 L
.36976 .12361 L
.37091 .12361 L
.37198 .12361 L
.37315 .12361 L
.37441 .12361 L
.37554 .12361 L
.37661 .12361 L
.37766 .12361 L
.37862 .12361 L
.37976 .12361 L
.38099 .12361 L
.38207 .12361 L
.3832 .12361 L
.38445 .12361 L
.38562 .12361 L
.3869 .12361 L
.38761 .12361 L
.38826 .12361 L
.38958 .12361 L
.39079 .12361 L
.39209 .12361 L
.39284 .12361 L
.39353 .12361 L
Mistroke
.3947 .12361 L
.39595 .12361 L
.39663 .12361 L
.39729 .12361 L
.39851 .12361 L
.39967 .12361 L
.40072 .12361 L
.40193 .12361 L
.40308 .12361 L
.40414 .12361 L
.40511 .12361 L
.40618 .12361 L
.40731 .12361 L
.40846 .12361 L
.40968 .12361 L
.41084 .12361 L
.4119 .12361 L
.41313 .12361 L
.41383 .12361 L
.41448 .12361 L
.41566 .12361 L
.41692 .12361 L
.41806 .12361 L
.41931 .12361 L
.42061 .12361 L
.42182 .12361 L
.42295 .12361 L
.42399 .12361 L
.42518 .12361 L
.4263 .12361 L
.42753 .12361 L
.42883 .12361 L
.42993 .12361 L
.43115 .12361 L
.43246 .12361 L
.4332 .12361 L
.43387 .12361 L
.43517 .12361 L
.43641 .12361 L
.43756 .12361 L
.43861 .12361 L
.43981 .12361 L
.44095 .12361 L
.442 .12361 L
.44297 .12361 L
.44403 .12361 L
.44516 .12361 L
.4463 .12361 L
.44737 .12361 L
.44864 .12361 L
Mistroke
.4498 .12361 L
.451 .12361 L
.45231 .12361 L
.45355 .12361 L
.45469 .12361 L
.45594 .12361 L
.45712 .12361 L
.45819 .12361 L
.45935 .12361 L
.4606 .12361 L
.46131 .12361 L
.46194 .12361 L
.46318 .12361 L
.46435 .12361 L
.46546 .12361 L
.46662 .12361 L
.46762 .12361 L
.4687 .12361 L
.46986 .12361 L
.47095 .12361 L
.47223 .12361 L
.47341 .12361 L
.47469 .12361 L
.47533 .12361 L
.47604 .12361 L
.4773 .12361 L
.47848 .12361 L
.47915 .12361 L
.47986 .12361 L
.48113 .12361 L
.48184 .12361 L
.4825 .12361 L
.48322 .12361 L
.484 .12361 L
.48529 .12361 L
.48603 .12361 L
.4867 .12361 L
.48794 .12361 L
.48925 .12361 L
.49036 .12361 L
.49154 .12361 L
.49283 .12361 L
.49403 .12361 L
.49471 .12361 L
.49536 .12361 L
.49656 .12361 L
.49771 .12361 L
.49896 .12361 L
.5001 .12361 L
.5013 .12361 L
Mistroke
.50233 .12361 L
.50346 .12361 L
.50414 .12361 L
.50479 .12361 L
.50599 .12361 L
.50729 .12361 L
.50803 .12361 L
.5087 .12361 L
.50983 .12361 L
.51108 .12361 L
.51238 .12361 L
.5136 .12361 L
.51467 .12361 L
.51584 .12361 L
.51706 .12361 L
.5182 .12361 L
.51927 .12361 L
.52024 .12361 L
.52136 .12361 L
.52241 .12361 L
.52356 .12361 L
.52478 .12361 L
.52583 .12361 L
.52697 .12361 L
.5282 .12361 L
.52952 .12361 L
.53077 .12361 L
.53191 .12361 L
.53308 .12361 L
.53418 .12361 L
.53539 .12361 L
.5367 .12361 L
.53799 .12361 L
.53864 .12361 L
.53936 .12361 L
.54062 .12361 L
.5418 .12361 L
.54299 .12361 L
.54411 .12361 L
.54513 .12361 L
.54622 .12361 L
.54742 .12361 L
.54869 .12361 L
.54977 .12361 L
.55096 .12361 L
.55162 .12361 L
.55234 .12361 L
.55365 .12361 L
.55493 .12361 L
.55612 .12361 L
Mistroke
.55685 .12361 L
.55753 .12361 L
.55881 .12361 L
.55952 .12361 L
.56018 .12361 L
.56091 .12361 L
.56167 .12361 L
.56287 .12361 L
.56415 .12361 L
.56535 .12361 L
.56646 .12361 L
.56775 .12361 L
.56848 .12361 L
.56915 .12361 L
.57039 .12361 L
.57171 .12361 L
.57284 .12361 L
.57409 .12361 L
.57539 .12361 L
.5766 .12361 L
.57773 .12361 L
.57876 .12361 L
.57996 .12361 L
.58108 .12361 L
.59118 .12361 L
.60946 .12361 L
.64794 .12361 L
.68886 .12361 L
.72828 .12361 L
.76617 .12361 L
.80652 .12361 L
.84535 .12361 L
.88663 .12361 L
.9264 .12361 L
.96465 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Koooo1@00083oool009goool00`000?ooooooo`20oooo002Moooo00<0003ooooo
ool00oooo`<0001joooo002Eoooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0N_oo
o`00WOooo`030000oooooooo00?oool00`000?ooooooo`1joooo002Loooo0P0000Goool00`000?oo
ooooo`1joooo002Soooo00<0003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool2
0000Noooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0
003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002S
oooo00<0003oooooool0N_ooo`00Xoooo`80001koooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool00:?oool20000Noooo`00:oooo`<0000Xoooo0`0002?oool4
00008oooo`030000oooooooo02?oool400009oooo`<0000Yoooo000[oooo00@0003oooooool0000X
oooo00<0003oooooool08_ooo`030000oooooooo02Coool00`000?ooooooo`0Soooo00<0003ooooo
ool0:Oooo`030000oooooooo02Soool002_oool010000?ooooooo`0002Goool500009?ooo`030000
oooooooo02?oool00`000?ooooooo`0Toooo00<0003oooooool09Oooo`D0000Yoooo000Uoooo1000
00;oool300008?ooo`@00002oooo00@0003oooooool0000Noooo100000Coool00`000?ooooooo`0R
oooo00<0003oooooool09Oooo`030000oooooooo02Coool010000?ooooooo`0002[oool002coool0
0`000?ooooooo`0Voooo00<0003oool000009?ooo`040000oooooooo00008oooo`030000oooooooo
02?oool010000?ooooooo`0002Koool00`000?ooo`00000Zoooo000/oooo0`0002Ooool200009Ooo
o`80000Toooo0P0002Goool20000:?ooo`80000Zoooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool0013ooooo00004Oooo`005_ooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`03oooo00D0I_oooooo
ooooool000002Oooo`030000oooo0000010000000c?o000003?o0008<ol000<0000co`0co`001c?o
00030000<ol0<ol000Lco`000`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo
00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?oo
ooooo`08oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0
003oooooool05Oooo`005_ooo`<0I_lAoooo00<0003oooooool09_ooo`030000oooooooo00goool0
0`1Vooooooooo`0Eoooo00<0003oooooool01_ooo`@0000K<ol000<0003oooooool09Oooo`030000
oooooooo02Koool00`000?ooooooo`0Yoooo000Ioooo1@1VodGoool00`1Vooooooooo`0Roooo1000
01Lco`000`000?ooooooo`1joooo000Noooo101Vod7oool00`1Vooooooooo`0Voooo00<0000co`0c
o`0053?o00030000oooooooo07[oool002;oool506Ko??ooo`0306Kooooooooo02Ooool2000053?o
00030000oooooooo07[oool002Ooool206Ko>_ooo`0306Kooooooooo02Woool00`0003?o03?o000A
<ol000<0003oooooool0N_ooo`00:Oooo`80I_lhoooo00<0I_ooooooool0:_ooo`030000<ol0<ol0
010co`020000Noooo`00:oooo`0306Kooooooooo03Goool00`1Vooooooooo`0[oooo0P00010co`00
0`000?ooooooo`1joooo000/oooo0P1VocGoool00`1Vooooooooo`0]oooo00<0000co`0co`003C?o
00030000oooooooo07[oool002koool206Ko<_ooo`0306Koo`2Ioooo02koool00`0003?o03?o000=
<ol000<0003oooooool0N_ooo`00<?ooo`0306Kooooooooo02ooool00`1Vool0VOooo`0_oooo00<0
000co`0co`0033?o00030000oooooooo07[oool0037oool00`1Vooooooooo`0^oooo00<0I_oo09Wo
ool0;oooo`030000<ol0<ol000`co`000`000?ooooooo`1joooo000boooo0P1Vobkoool00`1Vool0
VOooo`0`oooo00<0000co`0co`002c?o0080001koooo000doooo00<0I_ooooooool0:oooo`0306Ko
o`2Ioooo033oool00`0003?o03?o000;<ol000<0003oooooool0N_ooo`00=Oooo`0306Kooooooooo
02[oool00`1Vool0VOooo`0aoooo00<0000co`0co`002S?o00030000oooooooo07[oool003Koool0
0`1Vooooooooo`0Yoooo00<0I_oo09Woool0<Oooo`030000<ol0<ol000Xco`000`000?ooooooo`1j
oooo000goooo00<0I_ooooooool0:?ooo`0306Koo`2Ioooo03;oool00`0003?o03?o0009<ol000<0
003oooooool0N_ooo`00=oooo`0306Kooooooooo02Soool00`1Vool0VOooo`0boooo00<0000co`0c
o`002C?o00030000oooooooo07[oool003Soool00`1Vooooooooo`0Uoooo0`1Vo`03o`2Ioooooooo
03;oool00`0003?o03?o0008<ol00P0007_oool003Soool00`1Vooooooooo`0Qoooo101Vo`?oool0
0ol0VOooooooo`0boooo00<0000co`0co`0023?o00030000oooooooo07[oool003Woool00`1Voooo
ooooo`0Eoooo2`1Vo`Ooool00ol0VOooooooo`0boooo00<0000co`0co`0023?o00030000oooooooo
07[oool003[ooolG06Ko4_ooo`03o`2Ioooooooo03?oool00`0003?o03?o0007<ol000<0003ooooo
ool0N_ooo`00Hoooo`03o`2Ioooooooo03?oool00`0003?o03?o0007<ol000<0003oooooool0N_oo
o`00Hoooo`03o`2Ioooooooo03?oool00`0003?o03?o0007<ol000<0003oooooool0N_ooo`00Hooo
o`03o`2Ioooooooo03?oool00`0003?o03?o0007<ol00P0007_oool006?oool00ol0VOooooooo`0d
oooo00<0000co`0co`001S?o00030000oooooooo07[oool006?oool00ol0VOooooooo`0doooo00<0
000co`0co`001S?o00030000oooooooo07[oool006?oool00ol0VOooooooo`0doooo00<0000co`0c
o`001S?o00030000oooooooo07[oool006?oool00ol0VOooooooo`0doooo00<0000co`0co`001S?o
00030000oooooooo07[oool006?oool00ol0VOooooooo`0eoooo1@0000<co`000`000?ooooooo`1j
oooo001Soooo00?o09Woooooool0=Oooo`030000<ol0000000Dco`000`000?ooooooo`1joooo001S
oooo00?o09Woooooool0=Oooo`030000<ol0000000Dco`030000N_ooo`00Hoooo`03o`2Ioooooooo
03Koool200001C?o00030000oooooooo07[oool006?oool00ol0VOooooooo`0foooo0P0000Dco`00
0`000?ooooooo`1joooo001Soooo00?o09Woooooool0=_ooo`800005<ol000<0003oooooool0N_oo
o`00Hoooo`03o`2Ioooooooo03Koool00`0003?o03?o0004<ol000<0003oooooool0N_ooo`00Hooo
o`03o`2Ioooooooo03Koool00`0003?o03?o0004<ol000<0003oooooool0N_ooo`00Hoooo`03o`2I
oooooooo03Koool00`0003?o03?o0004<ol00P0007_oool006?oool00ol0VOooooooo`0goooo00<0
000co`0co`000c?o00030000oooooooo07[oool006?oool00ol0VOooooooo`0goooo00<0000co`0c
o`000c?o00030000oooooooo07[oool006?oool00ol0VOooooooo`0goooo00<0000co`0co`000c?o
00030000oooooooo07[oool006?oool00ol0VOooooooo`0goooo00<0000co`0co`000c?o00030000
oooooooo07[oool006?oool00ol0VOooooooo`0goooo00<0000co`0co`000c?o00030000oooooooo
07[oool006?oool00ol0VOooooooo`0goooo00<0000co`0co`000c?o0080001koooo001Soooo00?o
09Woooooool0=oooo`030000<ol0<ol000<co`000`000?ooooooo`1joooo001Soooo00?o09Wooooo
ool0=oooo`030000<ol0<ol000<co`000`000?ooooooo`1joooo001Soooo00?o09Woooooool0>?oo
o`030000<ol0<ol0008co`000`000?ooooooo`1joooo001Soooo00?o09Woooooool0>?ooo`030000
<ol0<ol0008co`000`000?ooooooo`1joooo001Soooo00?o09Woooooool0>?ooo`030000<ol0<ol0
008co`000`000?ooooooo`1joooo001Soooo00?o09Woooooool0>?ooo`030000<ol0<ol0008co`00
0`000?ooooooo`1joooo001Soooo00?o09Woooooool0>?ooo`030000<ol0<ol0008co`020000Nooo
o`00Hoooo`03o`2Ioooooooo03Soool00`0003?o03?o0002<ol000<0003oooooool0N_ooo`00Hooo
o`03o`2Ioooooooo03Soool00`0003?o03?o0002<ol000<0003oooooool0N_ooo`00Hoooo`03o`2I
oooooooo03Soool00`0003?o03?o0002<ol000<0003oooooool0N_ooo`00Hoooo`03o`2Ioooooooo
03Soool00`0003?o03?o0002<ol000<0003oooooool0N_ooo`00Hoooo`03o`2Ioooooooo03Soool0
0`0003?o03?o0002<ol000<0003oooooool0N_ooo`00Hoooo`03o`2Ioooooooo03Soool00`0003?o
03?o0002<ol00P0007_oool006?oool00ol0VOooooooo`0ioooo00D0000co`0co`0co`000000O?oo
o`00Hoooo`03o`2Ioooooooo03Woool01@0003?o03?o03?o0000001loooo001Soooo00?o09Wooooo
ool0>Oooo`050000<ol0<ol0<ol0000007coool006?oool00ol0VOooooooo`0eoooo1@0000<co`00
0`000?ooooooo`1joooo001Soooo00?o09Woooooool0=Oooo`050000oooooooooooo000000<co`00
0`000?ooooooo`1joooo001Soooo00?o09Woooooool0=_ooo`040000oooooooo00000c?o00<0001j
oooo001Soooo00?o09Woooooool0=oooo`030000oooo000000<co`000`000?ooooooo`1joooo001S
oooo00?o09Woooooool0=Oooo`030000oooooooo00800003<ol000<0003oooooool0N_ooo`00Hooo
o`03o`2Ioooooooo03Koool2000000?oool0000co`000S?o00030000oooooooo07[oool006?oool0
0ol0VOooooooo`0ioooo00D0000co`0co`0co`000000O?ooo`00Hoooo`03o`2Ioooooooo03[oool0
100003?o03?o000007coool006?oool00ol0VOooooooo`0joooo00<0000co`0co`000P0007_oool0
06?oool00ol0VOooooooo`0joooo00@0000co`0co`00001loooo001Soooo00?o09Woooooool0>_oo
o`040000<ol0<ol00000O?ooo`00Hoooo`03o`2Ioooooooo03[oool0100003?o03?o000007coool0
06?oool00ol0VOooooooo`0joooo00@0000co`0co`00001loooo001Soooo00?o09Woooooool0>_oo
o`040000<ol0<ol00000O?ooo`00Hoooo`03o`2Ioooooooo03[oool0100003?o03?o000007coool0
06?oool00ol0VOooooooo`0koooo00@0000co`000000001koooo001Soooo00?o09Woooooool0>ooo
o`030000<ol0000007coool006?oool00ol0VOooooooo`0koooo00<0000co`000000O?ooo`00Hooo
o`03o`2Ioooooooo03_oool00`0003?o0000001loooo001Soooo00?o09Woooooool0>oooo`030000
<ol0000007coool006?oool00ol0VOooooooo`0koooo00<0000co`000000O?ooo`00Hoooo`03o`2I
oooooooo03_oool0100003?o0000000007_oool006?oool00ol0VOooooooo`0koooo00<0000co`00
0000O?ooo`00Hoooo`03o`2Ioooooooo03_oool00`0003?o0000001loooo001Soooo00?o09Wooooo
ool0>oooo`030000<ol0000007coool006?oool00ol0VOooooooo`0koooo00<0000co`000000O?oo
o`00Hoooo`03o`2Ioooooooo03_oool00`0003?o0000001loooo001Soooo00?o09Woooooool0>ooo
o`040000<ol000000000Noooo`00Hoooo`03o`2Ioooooooo03_oool00`0003?o0000001loooo001S
oooo00?o09Woooooool0>oooo`030000<ol0000007coool006?oool00ol0VOooooooo`0koooo00<0
000co`000000O?ooo`00Hoooo`03o`2Ioooooooo03Koool200000oooo`030000<ol0000007coool0
06?oool00ol0VOooooooo`0eoooo00@0003oooooool00002oooo00<0000co`000000O?ooo`00Hooo
o`03o`2Ioooooooo03Ooool01P000?ooooooooooo`0003?o00<0001joooo001Soooo00?o09Wooooo
ool0>?ooo`060000oooooooo0000<ol00000O?ooo`00Hoooo`03o`2Ioooooooo03Goool010000?oo
ooooo`0000;oool00`0003?o0000001loooo001Soooo00?o09Woooooool0=_ooo`800004oooo0P00
07coool006?oool00ol0VOooooooo`0loooo0P0007coool006?oool00ol0VOooooooo`0loooo0P00
07coool006?oool00ol0VOooooooo`0loooo0P0007coool006?oool00ol0VOooooooo`0loooo0`00
07_oool006?oool00ol0VOooooooo`0loooo0P0007coool006?oool00ol0VOooooooo`0loooo0P00
07coool006?oool00ol0VOooooooo`0loooo0P0007coool006?oool00ol0VOooooooo`0loooo0P00
07coool006?oool00ol0VOooooooo`0loooo0P0007coool006?oool00ol0VOooooooo`0loooo0`00
07_oool006?oool00ol0VOooooooo`0loooo0P0007coool006?oool00ol0VOooooooo`0loooo0P00
07coool006?oool00ol0VOooooooo`0loooo0P0007coool006?oool00ol0VOooooooo`0loooo0P00
07coool006?oool00ol0VOooooooo`0loooo0P0007coool006?oool00ol0VOooooooo`0loooo0`00
07_oool006?oool00ol0VOooooooo`0moooo00<0003oooooool0N_ooo`00Hoooo`03o`2Ioooooooo
03goool00`000?ooooooo`1joooo001Soooo00?o09Woooooool0?Oooo`030000oooooooo07[oool0
06?oool00ol0VOooooooo`0moooo00<0003oooooool0N_ooo`00Hoooo`03o`2Ioooooooo03goool0
0`000?ooooooo`1joooo001Soooo00?o09Woooooool0?Oooo`80001koooo001Soooo00?o09Wooooo
ool0?Oooo`030000oooooooo07[oool006?oool00ol0VOooooooo`0moooo00<0003oooooool0N_oo
o`00Hoooo`03o`2Ioooooooo03goool00`000?ooooooo`1joooo001Soooo00?o09Woooooool0?Ooo
o`030000oooooooo07[oool006?oool00ol0VOooooooo`0goooo0`0000?oool00`000?ooooooo`1j
oooo001Soooo00?o09Woooooool0>?ooo`030000oooooooo00;oool00`000?ooooooo`1joooo001S
oooo00?o09Woooooool0=Oooo`D00003oooo0`0007[oool009_oool010000?ooooooo`00087oool0
09coool00`000?ooo`000021oooo002Moooo0P00087oool00?oooolQoooo003ooooo8Oooo`00NOoo
o`030000oooooooo02Soool00`000?ooooooo`1ioooo001hoooo00<0003oooooool02?ooo`030000
oooooooo01ooool00`000?ooooooo`1hoooo001hoooo00<0003oooooool00_ooo`800004oooo00<0
003oooooool03_ooo`<00002oooo0P0000?oool400000oooo`030000oooooooo07Soool007Soool0
1@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000oooooooo00Coool400001_oo
o`030000oooooooo00Koool00`000?ooooooo`04oooo00<0003oooooool0N?ooo`00Moooo`030000
oooooooo00;oool00`000?ooooooo`0Coooo1@0000Soool00`000?ooooooo`04oooo00<0003ooooo
ool0Moooo`00N?ooo`030000oooooooo00D0000Boooo00@0003oooooool0000:oooo00<0003ooooo
ool00_ooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`00000Foooo00<0003oool0
00002?ooo`040000oooooooo00000oooo`030000oooooooo07Soool007Woool00`000?ooooooo`0H
oooo0P0000Woool200000oooo`030000oooooooo07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-8.12947, \
-1.14361, 0.0496935, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-8.12947, -1.14361, 0.0496935, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
.2 1 0 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.32831 .12361 L
.33073 .12361 L
.33193 .12361 L
.33304 .12361 L
s
.33304 .12361 m
.33356 .61803 L
s
0 .4 1 r
.02381 .1295 m
.04262 .13184 L
.06244 .13533 L
.07286 .13772 L
.08255 .14039 L
.09388 .14414 L
.10458 .14845 L
.125 .15935 L
.14357 .17338 L
.16185 .19254 L
.16686 .19897 L
.16962 .20278 L
.17225 .20657 L
.17343 .20833 L
.17468 .21012 L
.1754 .21011 L
.17606 .2101 L
.17733 .21008 L
.18199 .21 L
.20182 .20957 L
.21265 .20926 L
.22285 .20891 L
.24293 .20801 L
.2614 .20684 L
.28023 .20518 L
.29092 .20396 L
.30089 .20259 L
.31134 .20087 L
.32124 .19891 L
.32555 .19795 L
.33013 .19684 L
.33128 .19654 L
.33252 .19622 L
.33323 .19603 L
.33388 .12361 L
.33515 .12361 L
.33623 .12361 L
.33742 .12361 L
.33865 .12361 L
.3398 .12361 L
.34108 .12361 L
.34172 .12361 L
.34243 .12361 L
.34368 .12361 L
.34485 .12361 L
.34556 .12361 L
.34623 .12361 L
.34749 .12361 L
.34819 .12361 L
.34884 .12361 L
Mistroke
.34956 .12361 L
.35032 .12361 L
.35161 .12361 L
.35234 .12361 L
.35301 .12361 L
.35424 .12361 L
.35554 .12361 L
.3567 .12361 L
.35779 .12361 L
.35898 .12361 L
.36026 .12361 L
.3615 .12361 L
.36265 .12361 L
.36392 .12361 L
.36456 .12361 L
.36526 .12361 L
.36642 .12361 L
.36751 .12361 L
.3688 .12361 L
.36999 .12361 L
.37106 .12361 L
.37205 .12361 L
.37314 .12361 L
.3743 .12361 L
.37553 .12361 L
.37669 .12361 L
.37772 .12361 L
.37885 .12361 L
.38008 .12361 L
.38121 .12361 L
.38252 .12361 L
.38375 .12361 L
.38489 .12361 L
.38595 .12361 L
.3871 .12361 L
.38834 .12361 L
.38956 .12361 L
.39025 .12361 L
.39089 .12361 L
.39206 .12361 L
.39329 .12361 L
.39394 .12361 L
.39464 .12361 L
.3959 .12361 L
.39667 .12361 L
.3974 .12361 L
.39805 .12361 L
.39876 .12361 L
.40007 .12361 L
.40129 .12361 L
Mistroke
.40199 .12361 L
.40263 .12361 L
.40337 .12361 L
.40408 .12361 L
.40475 .12361 L
.40547 .12361 L
.40677 .12361 L
.40757 .12361 L
.40831 .12361 L
.40899 .12361 L
.40971 .12361 L
.41093 .12361 L
.41163 .12361 L
.41227 .12361 L
.41358 .12361 L
.41431 .12361 L
.41498 .12361 L
.41617 .12361 L
.41746 .12361 L
.41869 .12361 L
.41982 .12361 L
.421 .12361 L
.42224 .12361 L
.4233 .12361 L
.42445 .12361 L
.42571 .12361 L
.42641 .12361 L
.42704 .12361 L
.42828 .12361 L
.42945 .12361 L
.43055 .12361 L
.43171 .12361 L
.4327 .12361 L
.43379 .12361 L
.43496 .12361 L
.43622 .12361 L
.43741 .12361 L
.4385 .12361 L
.43977 .12361 L
.44048 .12361 L
.44112 .12361 L
.44238 .12361 L
.44356 .12361 L
.44423 .12361 L
.44494 .12361 L
.44621 .12361 L
.44691 .12361 L
.44757 .12361 L
.4483 .12361 L
.44907 .12361 L
Mistroke
.45036 .12361 L
.45109 .12361 L
.45177 .12361 L
.45298 .12361 L
.45367 .12361 L
.45432 .12361 L
.45544 .12361 L
.45664 .12361 L
.45791 .12361 L
.4591 .12361 L
.45974 .12361 L
.46043 .12361 L
.46164 .12361 L
.46232 .12361 L
.46304 .12361 L
.46434 .12361 L
.46554 .12361 L
.46666 .12361 L
.46788 .12361 L
.4692 .12361 L
.46994 .12361 L
.47062 .12361 L
.47137 .12361 L
.47216 .12361 L
.47285 .12361 L
.4735 .12361 L
.4742 .12361 L
.47497 .12361 L
.47561 .12361 L
.4763 .12361 L
.47703 .12361 L
.47771 .12361 L
.47893 .12361 L
.48023 .12361 L
.48149 .12361 L
.48212 .12361 L
.48282 .12361 L
.48358 .12361 L
.48429 .12361 L
.48494 .12361 L
.48564 .12361 L
.48629 .12361 L
.48701 .12361 L
.48831 .12361 L
.48958 .12361 L
.49075 .12361 L
.492 .12361 L
.49318 .12361 L
.49424 .12361 L
.49538 .12361 L
Mistroke
.49663 .12361 L
.49795 .12361 L
.49908 .12361 L
.50031 .12361 L
.50162 .12361 L
.50283 .12361 L
.50346 .12361 L
.50416 .12361 L
.50489 .12361 L
.50557 .12361 L
.50682 .12361 L
.50796 .12361 L
.50922 .12361 L
.51054 .12361 L
.51166 .12361 L
.51285 .12361 L
.51397 .12361 L
.51499 .12361 L
.51619 .12361 L
.51749 .12361 L
.51985 .12361 L
.52117 .12361 L
.52191 .12361 L
.52259 .12361 L
.5239 .12361 L
.52515 .12361 L
.52642 .12361 L
.52715 .12361 L
.52781 .12361 L
.52849 .12361 L
.52924 .12361 L
.53001 .12361 L
.53075 .12361 L
.53197 .12361 L
.53326 .12361 L
.53436 .12361 L
.53557 .12361 L
.53687 .12361 L
.5376 .12361 L
.53827 .12361 L
.53956 .12361 L
.54078 .12361 L
.54193 .12361 L
.54316 .12361 L
.54433 .12361 L
.54539 .12361 L
.54664 .12361 L
.54735 .12361 L
.548 .12361 L
.5492 .12361 L
Mistroke
.55048 .12361 L
.55117 .12361 L
.55181 .12361 L
.55251 .12361 L
.55325 .12361 L
.5545 .12361 L
.55521 .12361 L
.55587 .12361 L
.5571 .12361 L
.55823 .12361 L
.55953 .12361 L
.56076 .12361 L
.56182 .12361 L
.56298 .12361 L
.5642 .12361 L
.56535 .12361 L
.56641 .12361 L
.56739 .12361 L
.56846 .12361 L
.56959 .12361 L
.57074 .12361 L
.57197 .12361 L
.57313 .12361 L
.57418 .12361 L
.57542 .12361 L
.57612 .12361 L
.57676 .12361 L
.57795 .12361 L
.5792 .12361 L
.58041 .12361 L
.58173 .12361 L
.58413 .12361 L
.58864 .12361 L
.59878 .12361 L
.6171 .12361 L
.6578 .12361 L
.69699 .12361 L
.73863 .12361 L
.77876 .12361 L
.81737 .12361 L
.85843 .12361 L
.89798 .12361 L
.93601 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Koooo1@00083oool009goool00`000?ooooooo`20oooo002Moooo00<0003ooooo
ool00oooo`<0001joooo002Eoooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0N_oo
o`00WOooo`030000oooooooo00?oool00`000?ooooooo`1joooo002Loooo0P0000Goool00`000?oo
ooooo`1joooo002Soooo00<0003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool2
0000Noooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0
003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002S
oooo00<0003oooooool0N_ooo`00Xoooo`80001koooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool00:?oool20000Noooo`00:oooo`<0000Xoooo0`0002?oool4
00008oooo`030000oooooooo02?oool400009oooo`<0000Yoooo000[oooo00@0003oooooool0000X
oooo00<0003oooooool08_ooo`030000oooooooo02Coool00`000?ooooooo`0Soooo00<0003ooooo
ool0:Oooo`030000oooooooo02Soool002_oool010000?ooooooo`0002Goool500009?ooo`030000
oooooooo02?oool00`000?ooooooo`0Toooo00<0003oooooool09Oooo`D0000Yoooo000Uoooo1000
00;oool300008?ooo`@00002oooo00@0003oooooool0000Noooo100000Coool00`000?ooooooo`0R
oooo00<0003oooooool09Oooo`030000oooooooo02Coool010000?ooooooo`0002[oool002coool0
0`000?ooooooo`0Voooo00<0003oool000009?ooo`040000oooooooo00008oooo`030000oooooooo
02?oool010000?ooooooo`0002Koool00`000?ooo`00000Zoooo000/oooo0`0002Ooool200009Ooo
o`80000Toooo0P0002Goool20000:?ooo`80000Zoooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool0013ooooo00004Oooo`005_ooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`05oooo00<0I_ooool0
00002Oooo`030000oooo0000010000000c?o000003?o0008<ol000<0000co`0co`001c?o00030000
<ol0<ol000Lco`000`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool05Oooo`005_ooo`P0I_l<oooo00<0003oooooool09_ooo`030000oooooooo00ooool00`1Voooo
ooooo`0Coooo00<0003oooooool01_ooo`@0000K<ol000<0003oooooool09Oooo`030000oooooooo
02Koool00`000?ooooooo`0Yoooo000Noooo101Vod?oool00`1Vooooooooo`0Poooo100001Lco`00
0`000?ooooooo`1joooo000Roooo0P1Vod7oool00`1Vooooooooo`0Toooo00<0000co`0co`0053?o
00030000oooooooo07[oool002Coool306Ko?_ooo`0306Kooooooooo02Goool2000053?o00030000
oooooooo07[oool002Ooool306Ko>oooo`0306Kooooooooo02Ooool00`0003?o03?o000A<ol000<0
003oooooool0N_ooo`00:_ooo`<0I_lhoooo00<0I_ooooooool0:?ooo`030000<ol0<ol0010co`02
0000Noooo`00;Oooo`80I_lfoooo00<0I_ooooooool0:Oooo`80000@<ol000<0003oooooool0N_oo
o`00;oooo`80I_ldoooo00<0I_ooooooool0:oooo`030000<ol0<ol000dco`000`000?ooooooo`1j
oooo000aoooo00<0I_ooooooool0<Oooo`0306Kooooooooo02_oool00`0003?o03?o000=<ol000<0
003oooooool0N_ooo`00<_ooo`80I_laoooo00<0I_ooooooool0;?ooo`030000<ol0<ol000`co`00
0`000?ooooooo`1joooo000doooo00<0I_ooooooool0;_ooo`0306Kooooooooo02coool00`0003?o
03?o000<<ol000<0003oooooool0N_ooo`00=Oooo`0306Kooooooooo02goool00`1Vooooooooo`0]
oooo00<0000co`0co`002c?o0080001koooo000foooo00<0I_ooooooool0;?ooo`0306Kooooooooo
02goool00`0003?o03?o000;<ol000<0003oooooool0N_ooo`00=oooo`0306Kooooooooo02_oool0
0`1Vooooooooo`0^oooo00<0000co`0co`002S?o00030000oooooooo07[oool003Ooool00`1Voooo
ooooo`0[oooo00<0I_ooooooool0;_ooo`030000<ol0<ol000Xco`000`000?ooooooo`1joooo000h
oooo00<0I_ooooooool0:_ooo`0306Kooooooooo02ooool00`0003?o03?o0009<ol000<0003ooooo
ool0N_ooo`00>Oooo`0306Kooooooooo02Woool00`1Vooooooooo`0_oooo00<0000co`0co`002C?o
00030000oooooooo07[oool003[oool00`1Vooooooooo`0Toooo1@1Voc;oool00`0003?o03?o0008
<ol00P0007_oool003_oool00`1Vooooooooo`0Noooo1@1Vo`Coool00ol0VOooooooo`0`oooo00<0
000co`0co`0023?o00030000oooooooo07[oool003coool00`1Vooooooooo`0Foooo1`1Vo`Woool0
0ol0VOooooooo`0`oooo00<0000co`0co`0023?o00030000oooooooo07[oool003cooolI06Ko4?oo
o`03o`2Ioooooooo037oool00`0003?o03?o0007<ol000<0003oooooool0N_ooo`00IOooo`03o`2I
oooooooo037oool00`0003?o03?o0007<ol000<0003oooooool0N_ooo`00IOooo`03o`2Ioooooooo
037oool00`0003?o03?o0007<ol000<0003oooooool0N_ooo`00IOooo`03o`2Ioooooooo037oool0
0`0003?o03?o0007<ol00P0007_oool006Goool00ol0VOooooooo`0boooo00<0000co`0co`001S?o
00030000oooooooo07[oool006Goool00ol0VOooooooo`0boooo00<0000co`0co`001S?o00030000
oooooooo07[oool006Goool00ol0VOooooooo`0boooo00<0000co`0co`001S?o00030000oooooooo
07[oool006Goool00ol0VOooooooo`0boooo00<0000co`0co`001S?o00030000oooooooo07[oool0
06Goool00ol0VOooooooo`0coooo1@0000<co`000`000?ooooooo`1joooo001Uoooo00?o09Wooooo
ool0<oooo`030000<ol0000000Dco`000`000?ooooooo`1joooo001Uoooo00?o09Woooooool0<ooo
o`030000<ol0000000Dco`030000N_ooo`00IOooo`03o`2Ioooooooo03Coool200001C?o00030000
oooooooo07[oool006Goool00ol0VOooooooo`0doooo0P0000Dco`000`000?ooooooo`1joooo001U
oooo00?o09Woooooool0=?ooo`800005<ol000<0003oooooool0N_ooo`00IOooo`03o`2Ioooooooo
03Coool00`0003?o03?o0004<ol000<0003oooooool0N_ooo`00IOooo`03o`2Ioooooooo03Coool0
0`0003?o03?o0004<ol000<0003oooooool0N_ooo`00IOooo`03o`2Ioooooooo03Coool00`0003?o
03?o0004<ol00P0007_oool006Goool00ol0VOooooooo`0eoooo00<0000co`0co`000c?o00030000
oooooooo07[oool006Goool00ol0VOooooooo`0eoooo00<0000co`0co`000c?o00030000oooooooo
07[oool006Goool00ol0VOooooooo`0eoooo00<0000co`0co`000c?o00030000oooooooo07[oool0
06Goool00ol0VOooooooo`0eoooo00<0000co`0co`000c?o00030000oooooooo07[oool006Goool0
0ol0VOooooooo`0eoooo00<0000co`0co`000c?o00030000oooooooo07[oool006Goool00ol0VOoo
ooooo`0eoooo00<0000co`0co`000c?o0080001koooo001Uoooo00?o09Woooooool0=Oooo`030000
<ol0<ol000<co`000`000?ooooooo`1joooo001Uoooo00?o09Woooooool0=Oooo`030000<ol0<ol0
00<co`000`000?ooooooo`1joooo001Uoooo00?o09Woooooool0=_ooo`030000<ol0<ol0008co`00
0`000?ooooooo`1joooo001Uoooo00?o09Woooooool0=_ooo`030000<ol0<ol0008co`000`000?oo
ooooo`1joooo001Uoooo00?o09Woooooool0=_ooo`030000<ol0<ol0008co`000`000?ooooooo`1j
oooo001Uoooo00?o09Woooooool0=_ooo`030000<ol0<ol0008co`000`000?ooooooo`1joooo001U
oooo00?o09Woooooool0=_ooo`030000<ol0<ol0008co`020000Noooo`00IOooo`03o`2Ioooooooo
03Koool00`0003?o03?o0002<ol000<0003oooooool0N_ooo`00IOooo`03o`2Ioooooooo03Koool0
0`0003?o03?o0002<ol000<0003oooooool0N_ooo`00IOooo`03o`2Ioooooooo03Koool00`0003?o
03?o0002<ol000<0003oooooool0N_ooo`00IOooo`03o`2Ioooooooo03Koool00`0003?o03?o0002
<ol000<0003oooooool0N_ooo`00IOooo`03o`2Ioooooooo03Koool00`0003?o03?o0002<ol000<0
003oooooool0N_ooo`00IOooo`03o`2Ioooooooo03Koool00`0003?o03?o0002<ol00P0007_oool0
06Goool00ol0VOooooooo`0goooo00D0000co`0co`0co`000000O?ooo`00IOooo`03o`2Ioooooooo
03Ooool01@0003?o03?o03?o0000001loooo001Uoooo00?o09Woooooool0=oooo`050000<ol0<ol0
<ol0000007coool006Goool00ol0VOooooooo`0coooo1@0000<co`000`000?ooooooo`1joooo001U
oooo00?o09Woooooool0<oooo`050000oooooooooooo000000<co`000`000?ooooooo`1joooo001U
oooo00?o09Woooooool0=?ooo`040000oooooooo00000c?o00<0001joooo001Uoooo00?o09Wooooo
ool0=Oooo`030000oooo000000<co`000`000?ooooooo`1joooo001Uoooo00?o09Woooooool0<ooo
o`030000oooooooo00800003<ol000<0003oooooool0N_ooo`00IOooo`03o`2Ioooooooo03Coool2
000000?oool0000co`000S?o00030000oooooooo07[oool006Goool00ol0VOooooooo`0goooo00D0
000co`0co`0co`000000O?ooo`00IOooo`03o`2Ioooooooo03Soool0100003?o03?o000007coool0
06Goool00ol0VOooooooo`0hoooo00<0000co`0co`000P0007_oool006Goool00ol0VOooooooo`0h
oooo00@0000co`0co`00001loooo001Uoooo00?o09Woooooool0>?ooo`040000<ol0<ol00000O?oo
o`00IOooo`03o`2Ioooooooo03Soool0100003?o03?o000007coool006Goool00ol0VOooooooo`0h
oooo00@0000co`0co`00001loooo001Uoooo00?o09Woooooool0>?ooo`040000<ol0<ol00000O?oo
o`00IOooo`03o`2Ioooooooo03Soool0100003?o03?o000007coool006Goool00ol0VOooooooo`0i
oooo00@0000co`000000001koooo001Uoooo00?o09Woooooool0>Oooo`030000<ol0000007coool0
06Goool00ol0VOooooooo`0ioooo00<0000co`000000O?ooo`00IOooo`03o`2Ioooooooo03Woool0
0`0003?o0000001loooo001Uoooo00?o09Woooooool0>Oooo`030000<ol0000007coool006Goool0
0ol0VOooooooo`0ioooo00<0000co`000000O?ooo`00IOooo`03o`2Ioooooooo03Woool0100003?o
0000000007_oool006Goool00ol0VOooooooo`0ioooo00<0000co`000000O?ooo`00IOooo`03o`2I
oooooooo03Woool00`0003?o0000001loooo001Uoooo00?o09Woooooool0>Oooo`030000<ol00000
07coool006Goool00ol0VOooooooo`0ioooo00<0000co`000000O?ooo`00IOooo`03o`2Ioooooooo
03Woool00`0003?o0000001loooo001Uoooo00?o09Woooooool0>Oooo`040000<ol000000000Nooo
o`00IOooo`03o`2Ioooooooo03Woool00`0003?o0000001loooo001Uoooo00?o09Woooooool0>Ooo
o`030000<ol0000007coool006Goool00ol0VOooooooo`0ioooo00<0000co`000000O?ooo`00IOoo
o`03o`2Ioooooooo03Coool200000oooo`030000<ol0000007coool006Goool00ol0VOooooooo`0c
oooo00@0003oooooool00002oooo00<0000co`000000O?ooo`00IOooo`03o`2Ioooooooo03Goool0
1P000?ooooooooooo`0003?o00<0001joooo001Uoooo00?o09Woooooool0=_ooo`060000oooooooo
0000<ol00000O?ooo`00IOooo`03o`2Ioooooooo03?oool010000?ooooooo`0000;oool00`0003?o
0000001loooo001Uoooo00?o09Woooooool0=?ooo`800004oooo0P0007coool006Goool00ol0VOoo
ooooo`0joooo0P0007coool006Goool00ol0VOooooooo`0joooo0P0007coool006Goool00ol0VOoo
ooooo`0joooo0P0007coool006Goool00ol0VOooooooo`0joooo0`0007_oool006Goool00ol0VOoo
ooooo`0joooo0P0007coool006Goool00ol0VOooooooo`0joooo0P0007coool006Goool00ol0VOoo
ooooo`0joooo0P0007coool006Goool00ol0VOooooooo`0joooo0P0007coool006Goool00ol0VOoo
ooooo`0joooo0P0007coool006Goool00ol0VOooooooo`0joooo0`0007_oool006Goool00ol0VOoo
ooooo`0joooo0P0007coool006Goool00ol0VOooooooo`0joooo0P0007coool006Goool00ol0VOoo
ooooo`0joooo0P0007coool006Goool00ol0VOooooooo`0joooo0P0007coool006Goool00ol0VOoo
ooooo`0joooo0P0007coool006Goool00ol0VOooooooo`0joooo0`0007_oool006Goool00ol0VOoo
ooooo`0koooo00<0003oooooool0N_ooo`00IOooo`03o`2Ioooooooo03_oool00`000?ooooooo`1j
oooo001Uoooo00?o09Woooooool0>oooo`030000oooooooo07[oool006Goool00ol0VOooooooo`0k
oooo00<0003oooooool0N_ooo`00IOooo`03o`2Ioooooooo03_oool00`000?ooooooo`1joooo001U
oooo00?o09Woooooool0>oooo`80001koooo001Uoooo00?o09Woooooool0>oooo`030000oooooooo
07[oool006Goool00ol0VOooooooo`0koooo00<0003oooooool0N_ooo`00IOooo`03o`2Ioooooooo
03_oool00`000?ooooooo`1joooo001Uoooo00?o09Woooooool0>oooo`030000oooooooo07[oool0
06Goool00ol0VOooooooo`0eoooo0`0000?oool00`000?ooooooo`1joooo001Uoooo00?o09Wooooo
ool0=_ooo`030000oooooooo00;oool00`000?ooooooo`1joooo001Uoooo00?o09Woooooool0<ooo
o`D00003oooo0`0007[oool009_oool010000?ooooooo`00087oool009coool00`000?ooo`000021
oooo002Moooo0P00087oool00?oooolQoooo003ooooo8Oooo`00NOooo`030000oooooooo02Soool0
0`000?ooooooo`1ioooo001hoooo00<0003oooooool02?ooo`030000oooooooo01ooool00`000?oo
ooooo`1hoooo001hoooo00<0003oooooool00_ooo`800004oooo00<0003oooooool03_ooo`<00002
oooo0P0000?oool500000_ooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`000002
oooo00<0003oooooool00_ooo`030000oooooooo00Coool400001_ooo`030000oooooooo00Soool0
0`000?ooooooo`02oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo00;oool00`000?oo
ooooo`0Coooo1@0000Woool00`000?ooooooo`03oooo00<0003oooooool0Moooo`00N?ooo`030000
oooooooo00D0000Boooo00@0003oooooool0000:oooo00<0003oooooool00_ooo`030000oooooooo
07Soool007Soool01@000?ooooooooooo`00000Foooo00<0003oool000002_ooo`030000oooooooo
00;oool00`000?ooooooo`1hoooo001ioooo00<0003oooooool06?ooo`800009oooo0P0000?oool0
0`000?ooooooo`1ioooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-8.12947, \
-1.14361, 0.0496935, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-8.12947, -1.14361, 0.0496935, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
.2 1 0 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.28158 .12361 L
.30316 .12361 L
.31323 .12361 L
.32392 .12361 L
.33304 .12361 L
.33554 .12361 L
.33823 .12361 L
.33953 .12361 L
.34076 .12361 L
s
.34076 .12361 m
.34121 .61803 L
s
0 .4 1 r
.02381 .12872 m
.04262 .13076 L
.06244 .13379 L
.07286 .13586 L
.08255 .13817 L
.09388 .14143 L
.10458 .14517 L
.125 .15464 L
.14357 .16681 L
.16355 .18528 L
.17243 .19586 L
.17733 .20245 L
.17974 .20592 L
.18092 .20766 L
.18199 .20927 L
.18316 .21011 L
.1844 .21009 L
.18704 .21005 L
.19166 .20997 L
.20071 .20978 L
.21145 .20952 L
.22134 .20924 L
.24058 .20851 L
.25071 .20802 L
.2614 .20739 L
.28104 .20588 L
.29938 .20389 L
.31973 .20078 L
.32873 .19901 L
.33366 .19791 L
.33828 .19678 L
.33939 .1965 L
.34055 .19619 L
.34183 .12361 L
.343 .12361 L
.34428 .12361 L
.34548 .12361 L
.34679 .12361 L
.34753 .12361 L
.3482 .12361 L
.34938 .12361 L
.35046 .12361 L
.35165 .12361 L
.35292 .12361 L
.35401 .12361 L
.35504 .12361 L
.35616 .12361 L
.35737 .12361 L
.35804 .12361 L
.35875 .12361 L
Mistroke
.36003 .12361 L
.36082 .12361 L
.36156 .12361 L
.36222 .12361 L
.36293 .12361 L
.36357 .12361 L
.36427 .12361 L
.36501 .12361 L
.36569 .12361 L
.36691 .12361 L
.36822 .12361 L
.3695 .12361 L
.37022 .12361 L
.37088 .12361 L
.37211 .12361 L
.37341 .12361 L
.37457 .12361 L
.37565 .12361 L
.37685 .12361 L
.37813 .12361 L
.37939 .12361 L
.38054 .12361 L
.38186 .12361 L
.3831 .12361 L
.38426 .12361 L
.38532 .12361 L
.38649 .12361 L
.38773 .12361 L
.38897 .12361 L
.38966 .12361 L
.39031 .12361 L
.39157 .12361 L
.39272 .12361 L
.39338 .12361 L
.39409 .12361 L
.39535 .12361 L
.39605 .12361 L
.39671 .12361 L
.39743 .12361 L
.39821 .12361 L
.39885 .12361 L
.39953 .12361 L
.40077 .12361 L
.40152 .12361 L
.40224 .12361 L
.40288 .12361 L
.40357 .12361 L
.40425 .12361 L
.405 .12361 L
.40578 .12361 L
Mistroke
.40651 .12361 L
.40781 .12361 L
.40855 .12361 L
.40922 .12361 L
.4105 .12361 L
.4117 .12361 L
.41301 .12361 L
.41374 .12361 L
.4144 .12361 L
.41562 .12361 L
.41693 .12361 L
.41818 .12361 L
.41932 .12361 L
.42059 .12361 L
.42178 .12361 L
.42286 .12361 L
.42403 .12361 L
.4253 .12361 L
.42594 .12361 L
.42665 .12361 L
.42789 .12361 L
.42907 .12361 L
.43018 .12361 L
.43135 .12361 L
.43235 .12361 L
.43344 .12361 L
.43463 .12361 L
.43589 .12361 L
.43708 .12361 L
.43816 .12361 L
.43945 .12361 L
.4401 .12361 L
.44082 .12361 L
.44208 .12361 L
.44326 .12361 L
.44398 .12361 L
.44466 .12361 L
.44593 .12361 L
.44664 .12361 L
.4473 .12361 L
.44803 .12361 L
.4488 .12361 L
.4501 .12361 L
.45083 .12361 L
.45151 .12361 L
.45275 .12361 L
.45406 .12361 L
.45524 .12361 L
.45634 .12361 L
.45754 .12361 L
Mistroke
.45883 .12361 L
.46005 .12361 L
.46075 .12361 L
.46141 .12361 L
.46272 .12361 L
.46346 .12361 L
.46414 .12361 L
.46534 .12361 L
.46665 .12361 L
.46789 .12361 L
.46904 .12361 L
.46973 .12361 L
.47049 .12361 L
.4712 .12361 L
.47185 .12361 L
.47309 .12361 L
.4744 .12361 L
.47508 .12361 L
.47581 .12361 L
.47713 .12361 L
.47794 .12361 L
.4787 .12361 L
.47938 .12361 L
.48013 .12361 L
.48137 .12361 L
.48253 .12361 L
.48381 .12361 L
.48453 .12361 L
.4852 .12361 L
.48645 .12361 L
.48717 .12361 L
.48782 .12361 L
.48851 .12361 L
.48925 .12361 L
.48994 .12361 L
.49058 .12361 L
.49176 .12361 L
.493 .12361 L
.49406 .12361 L
.49523 .12361 L
.49648 .12361 L
.49718 .12361 L
.49783 .12361 L
.49908 .12361 L
.50026 .12361 L
.50142 .12361 L
.50264 .12361 L
.50328 .12361 L
.50398 .12361 L
.50521 .12361 L
Mistroke
.50637 .12361 L
.50762 .12361 L
.5088 .12361 L
.50987 .12361 L
.51119 .12361 L
.51194 .12361 L
.51263 .12361 L
.51389 .12361 L
.51453 .12361 L
.51524 .12361 L
.51644 .12361 L
.51775 .12361 L
.51897 .12361 L
.5201 .12361 L
.52117 .12361 L
.52232 .12361 L
.5234 .12361 L
.52438 .12361 L
.52554 .12361 L
.52679 .12361 L
.52798 .12361 L
.52906 .12361 L
.53019 .12361 L
.53125 .12361 L
.53241 .12361 L
.53365 .12361 L
.53495 .12361 L
.53618 .12361 L
.53729 .12361 L
.5385 .12361 L
.53971 .12361 L
.54082 .12361 L
.54204 .12361 L
.54333 .12361 L
.54445 .12361 L
.5455 .12361 L
.54665 .12361 L
.54787 .12361 L
.54857 .12361 L
.54921 .12361 L
.54992 .12361 L
.55066 .12361 L
.55192 .12361 L
.55263 .12361 L
.5533 .12361 L
.55454 .12361 L
.55568 .12361 L
.55699 .12361 L
.55824 .12361 L
.55956 .12361 L
Mistroke
.56076 .12361 L
.56142 .12361 L
.56214 .12361 L
.56344 .12361 L
.56467 .12361 L
.56596 .12361 L
.56706 .12361 L
.56828 .12361 L
.56901 .12361 L
.56971 .12361 L
.57101 .12361 L
.57174 .12361 L
.57242 .12361 L
.57316 .12361 L
.57394 .12361 L
.57524 .12361 L
.57646 .12361 L
.57715 .12361 L
.57779 .12361 L
.57849 .12361 L
.57923 .12361 L
.58047 .12361 L
.58116 .12361 L
.58181 .12361 L
.58424 .12361 L
.58878 .12361 L
.59898 .12361 L
.61735 .12361 L
.65676 .12361 L
.69465 .12361 L
.735 .12361 L
.77383 .12361 L
.81512 .12361 L
.85489 .12361 L
.89314 .12361 L
.93384 .12361 L
.97303 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Koooo1@00083oool009goool00`000?ooooooo`20oooo002Moooo00<0003ooooo
ool00oooo`<0001joooo002Eoooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0N_oo
o`00WOooo`030000oooooooo00?oool00`000?ooooooo`1joooo002Loooo0P0000Goool00`000?oo
ooooo`1joooo002Soooo00<0003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool2
0000Noooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0
003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002S
oooo00<0003oooooool0N_ooo`00Xoooo`80001koooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool00:?oool20000Noooo`00:oooo`<0000Xoooo0`0002?oool4
00008oooo`030000oooooooo02?oool400009oooo`<0000Yoooo000[oooo00@0003oooooool0000X
oooo00<0003oooooool08_ooo`030000oooooooo02Coool00`000?ooooooo`0Soooo00<0003ooooo
ool0:Oooo`030000oooooooo02Soool002_oool010000?ooooooo`0002Goool500009?ooo`030000
oooooooo02?oool00`000?ooooooo`0Toooo00<0003oooooool09Oooo`D0000Yoooo000Uoooo1000
00;oool300008?ooo`@00002oooo00@0003oooooool0000Noooo100000Coool00`000?ooooooo`0R
oooo00<0003oooooool09Oooo`030000oooooooo02Coool010000?ooooooo`0002[oool002coool0
0`000?ooooooo`0Voooo00<0003oool000009?ooo`040000oooooooo00008oooo`030000oooooooo
02?oool010000?ooooooo`0002Koool00`000?ooo`00000Zoooo000/oooo0`0002Ooool200009Ooo
o`80000Toooo0P0002Goool20000:?ooo`80000Zoooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool0013ooooo00004Oooo`005_ooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooo0000010000000c?o000003?o0008<ol000<0000co`0co`001c?o00030000
<ol0<ol000Lco`000`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool05Oooo`005_ooo`P0I_l<oooo00<0003oooooool09_ooo`030000oooooooo017oool00`1Voooo
ooooo`0Aoooo00<0003oooooool01_ooo`@0000K<ol000<0003oooooool09Oooo`030000oooooooo
02Koool00`000?ooooooo`0Yoooo000Noooo101VodGoool00`1Vooooooooo`0Noooo100001Lco`00
0`000?ooooooo`1joooo000Roooo1@1Vod3oool00`1Vooooooooo`0Roooo00<0000co`0co`0053?o
00030000oooooooo07[oool002Ooool306Ko?Oooo`0306Kooooooooo02?oool2000053?o00030000
oooooooo07[oool002[oool306Ko>_ooo`0306Kooooooooo02Goool00`0003?o03?o000A<ol000<0
003oooooool0N_ooo`00;Oooo`80I_lhoooo00<0I_ooooooool09_ooo`030000<ol0<ol0010co`02
0000Noooo`00;oooo`80I_lfoooo00<0I_ooooooool09oooo`80000@<ol000<0003oooooool0N_oo
o`00<Oooo`80I_ldoooo00<0I_ooooooool0:Oooo`030000<ol0<ol000dco`000`000?ooooooo`1j
oooo000coooo0P1Voc;oool00`1Vooooooooo`0Yoooo00<0000co`0co`003C?o00030000oooooooo
07[oool003Goool00`1Vooooooooo`0_oooo00<0I_ooooooool0:_ooo`030000<ol0<ol000`co`00
0`000?ooooooo`1joooo000foooo00<0I_ooooooool0;_ooo`0306Kooooooooo02[oool00`0003?o
03?o000<<ol000<0003oooooool0N_ooo`00=oooo`0306Kooooooooo02goool00`1Vooooooooo`0[
oooo00<0000co`0co`002c?o0080001koooo000hoooo00<0I_ooooooool0;?ooo`0306Kooooooooo
02_oool00`0003?o03?o000;<ol000<0003oooooool0N_ooo`00>Oooo`0306Kooooooooo02_oool0
0`1Vooooooooo`0/oooo00<0000co`0co`002S?o00030000oooooooo07[oool003[oool00`1Voooo
ooooo`0Zoooo00<0I_ooooooool0;?ooo`030000<ol0<ol000Xco`000`000?ooooooo`1joooo000k
oooo00<0I_ooooooool0:Oooo`0306Kooooooooo02goool00`0003?o03?o0009<ol000<0003ooooo
ool0N_ooo`00>oooo`0306Kooooooooo02Woool00`1Vooooooooo`0]oooo00<0000co`0co`002C?o
00030000oooooooo07[oool003coool00`1Vooooooooo`0Voooo0`1Voc3oool00`0003?o03?o0008
<ol00P0007_oool003goool00`1Vooooooooo`0Ooooo1P1Vo`;oool00ol0VOooooooo`0^oooo00<0
000co`0co`0023?o00030000oooooooo07[oool003koool00`1Vooooooooo`0Doooo2P1Vo`Soool0
0ol0VOooooooo`0^oooo00<0000co`0co`0023?o00030000oooooooo07[oool003kooolG06Ko4_oo
o`03o`2Ioooooooo02ooool00`0003?o03?o0007<ol000<0003oooooool0N_ooo`00Ioooo`03o`2I
oooooooo02ooool00`0003?o03?o0007<ol000<0003oooooool0N_ooo`00Ioooo`03o`2Ioooooooo
02ooool00`0003?o03?o0007<ol000<0003oooooool0N_ooo`00Ioooo`03o`2Ioooooooo02ooool0
0`0003?o03?o0007<ol00P0007_oool006Ooool00ol0VOooooooo`0`oooo00<0000co`0co`001S?o
00030000oooooooo07[oool006Ooool00ol0VOooooooo`0`oooo00<0000co`0co`001S?o00030000
oooooooo07[oool006Ooool00ol0VOooooooo`0`oooo00<0000co`0co`001S?o00030000oooooooo
07[oool006Ooool00ol0VOooooooo`0`oooo00<0000co`0co`001S?o00030000oooooooo07[oool0
06Ooool00ol0VOooooooo`0aoooo1@0000<co`000`000?ooooooo`1joooo001Woooo00?o09Wooooo
ool0<Oooo`030000<ol0000000Dco`000`000?ooooooo`1joooo001Woooo00?o09Woooooool0<Ooo
o`030000<ol0000000Dco`030000N_ooo`00Ioooo`03o`2Ioooooooo03;oool200001C?o00030000
oooooooo07[oool006Ooool00ol0VOooooooo`0boooo0P0000Dco`000`000?ooooooo`1joooo001W
oooo00?o09Woooooool0<_ooo`800005<ol000<0003oooooool0N_ooo`00Ioooo`03o`2Ioooooooo
03;oool00`0003?o03?o0004<ol000<0003oooooool0N_ooo`00Ioooo`03o`2Ioooooooo03;oool0
0`0003?o03?o0004<ol000<0003oooooool0N_ooo`00Ioooo`03o`2Ioooooooo03;oool00`0003?o
03?o0004<ol00P0007_oool006Ooool00ol0VOooooooo`0coooo00<0000co`0co`000c?o00030000
oooooooo07[oool006Ooool00ol0VOooooooo`0coooo00<0000co`0co`000c?o00030000oooooooo
07[oool006Ooool00ol0VOooooooo`0coooo00<0000co`0co`000c?o00030000oooooooo07[oool0
06Ooool00ol0VOooooooo`0coooo00<0000co`0co`000c?o00030000oooooooo07[oool006Ooool0
0ol0VOooooooo`0coooo00<0000co`0co`000c?o00030000oooooooo07[oool006Ooool00ol0VOoo
ooooo`0coooo00<0000co`0co`000c?o0080001koooo001Woooo00?o09Woooooool0<oooo`030000
<ol0<ol000<co`000`000?ooooooo`1joooo001Woooo00?o09Woooooool0<oooo`030000<ol0<ol0
00<co`000`000?ooooooo`1joooo001Woooo00?o09Woooooool0=?ooo`030000<ol0<ol0008co`00
0`000?ooooooo`1joooo001Woooo00?o09Woooooool0=?ooo`030000<ol0<ol0008co`000`000?oo
ooooo`1joooo001Woooo00?o09Woooooool0=?ooo`030000<ol0<ol0008co`000`000?ooooooo`1j
oooo001Woooo00?o09Woooooool0=?ooo`030000<ol0<ol0008co`000`000?ooooooo`1joooo001W
oooo00?o09Woooooool0=?ooo`030000<ol0<ol0008co`020000Noooo`00Ioooo`03o`2Ioooooooo
03Coool00`0003?o03?o0002<ol000<0003oooooool0N_ooo`00Ioooo`03o`2Ioooooooo03Coool0
0`0003?o03?o0002<ol000<0003oooooool0N_ooo`00Ioooo`03o`2Ioooooooo03Coool00`0003?o
03?o0002<ol000<0003oooooool0N_ooo`00Ioooo`03o`2Ioooooooo03Coool00`0003?o03?o0002
<ol000<0003oooooool0N_ooo`00Ioooo`03o`2Ioooooooo03Coool00`0003?o03?o0002<ol000<0
003oooooool0N_ooo`00Ioooo`03o`2Ioooooooo03Coool00`0003?o03?o0002<ol00P0007_oool0
06Ooool00ol0VOooooooo`0eoooo00D0000co`0co`0co`000000O?ooo`00Ioooo`03o`2Ioooooooo
03Goool01@0003?o03?o03?o0000001loooo001Woooo00?o09Woooooool0=Oooo`050000<ol0<ol0
<ol0000007coool006Ooool00ol0VOooooooo`0aoooo1@0000<co`000`000?ooooooo`1joooo001W
oooo00?o09Woooooool0<Oooo`050000oooooooooooo000000<co`000`000?ooooooo`1joooo001W
oooo00?o09Woooooool0<_ooo`040000oooooooo00000c?o00<0001joooo001Woooo00?o09Wooooo
ool0<oooo`030000oooo000000<co`000`000?ooooooo`1joooo001Woooo00?o09Woooooool0<Ooo
o`030000oooooooo00800003<ol000<0003oooooool0N_ooo`00Ioooo`03o`2Ioooooooo03;oool2
000000?oool0000co`000S?o00030000oooooooo07[oool006Ooool00ol0VOooooooo`0eoooo00D0
000co`0co`0co`000000O?ooo`00Ioooo`03o`2Ioooooooo03Koool0100003?o03?o000007coool0
06Ooool00ol0VOooooooo`0foooo00<0000co`0co`000P0007_oool006Ooool00ol0VOooooooo`0f
oooo00@0000co`0co`00001loooo001Woooo00?o09Woooooool0=_ooo`040000<ol0<ol00000O?oo
o`00Ioooo`03o`2Ioooooooo03Koool0100003?o03?o000007coool006Ooool00ol0VOooooooo`0f
oooo00@0000co`0co`00001loooo001Woooo00?o09Woooooool0=_ooo`040000<ol0<ol00000O?oo
o`00Ioooo`03o`2Ioooooooo03Koool0100003?o03?o000007coool006Ooool00ol0VOooooooo`0g
oooo00@0000co`000000001koooo001Woooo00?o09Woooooool0=oooo`030000<ol0000007coool0
06Ooool00ol0VOooooooo`0goooo00<0000co`000000O?ooo`00Ioooo`03o`2Ioooooooo03Ooool0
0`0003?o0000001loooo001Woooo00?o09Woooooool0=oooo`030000<ol0000007coool006Ooool0
0ol0VOooooooo`0goooo00<0000co`000000O?ooo`00Ioooo`03o`2Ioooooooo03Ooool0100003?o
0000000007_oool006Ooool00ol0VOooooooo`0goooo00<0000co`000000O?ooo`00Ioooo`03o`2I
oooooooo03Ooool00`0003?o0000001loooo001Woooo00?o09Woooooool0=oooo`030000<ol00000
07coool006Ooool00ol0VOooooooo`0goooo00<0000co`000000O?ooo`00Ioooo`03o`2Ioooooooo
03Ooool00`0003?o0000001loooo001Woooo00?o09Woooooool0=oooo`040000<ol000000000Nooo
o`00Ioooo`03o`2Ioooooooo03Ooool00`0003?o0000001loooo001Woooo00?o09Woooooool0=ooo
o`030000<ol0000007coool006Ooool00ol0VOooooooo`0goooo00<0000co`000000O?ooo`00Iooo
o`03o`2Ioooooooo03;oool200000oooo`030000<ol0000007coool006Ooool00ol0VOooooooo`0a
oooo00@0003oooooool00002oooo00<0000co`000000O?ooo`00Ioooo`03o`2Ioooooooo03?oool0
1P000?ooooooooooo`0003?o00<0001joooo001Woooo00?o09Woooooool0=?ooo`060000oooooooo
0000<ol00000O?ooo`00Ioooo`03o`2Ioooooooo037oool010000?ooooooo`0000;oool00`0003?o
0000001loooo001Woooo00?o09Woooooool0<_ooo`800004oooo0P0007coool006Ooool00ol0VOoo
ooooo`0hoooo0P0007coool006Ooool00ol0VOooooooo`0hoooo0P0007coool006Ooool00ol0VOoo
ooooo`0hoooo0P0007coool006Ooool00ol0VOooooooo`0hoooo0`0007_oool006Ooool00ol0VOoo
ooooo`0hoooo0P0007coool006Ooool00ol0VOooooooo`0hoooo0P0007coool006Ooool00ol0VOoo
ooooo`0hoooo0P0007coool006Ooool00ol0VOooooooo`0hoooo0P0007coool006Ooool00ol0VOoo
ooooo`0hoooo0P0007coool006Ooool00ol0VOooooooo`0hoooo0`0007_oool006Ooool00ol0VOoo
ooooo`0hoooo0P0007coool006Ooool00ol0VOooooooo`0hoooo0P0007coool006Ooool00ol0VOoo
ooooo`0hoooo0P0007coool006Ooool00ol0VOooooooo`0hoooo0P0007coool006Ooool00ol0VOoo
ooooo`0hoooo0P0007coool006Ooool00ol0VOooooooo`0hoooo0`0007_oool006Ooool00ol0VOoo
ooooo`0ioooo00<0003oooooool0N_ooo`00Ioooo`03o`2Ioooooooo03Woool00`000?ooooooo`1j
oooo001Woooo00?o09Woooooool0>Oooo`030000oooooooo07[oool006Ooool00ol0VOooooooo`0i
oooo00<0003oooooool0N_ooo`00Ioooo`03o`2Ioooooooo03Woool00`000?ooooooo`1joooo001W
oooo00?o09Woooooool0>Oooo`80001koooo001Woooo00?o09Woooooool0>Oooo`030000oooooooo
07[oool006Ooool00ol0VOooooooo`0ioooo00<0003oooooool0N_ooo`00Ioooo`03o`2Ioooooooo
03Woool00`000?ooooooo`1joooo001Woooo00?o09Woooooool0>Oooo`030000oooooooo07[oool0
06Ooool00ol0VOooooooo`0coooo0`0000?oool00`000?ooooooo`1joooo001Woooo00?o09Wooooo
ool0=?ooo`030000oooooooo00;oool00`000?ooooooo`1joooo001Woooo00?o09Woooooool0<Ooo
o`D00003oooo0`0007[oool009_oool010000?ooooooo`00087oool009coool00`000?ooo`000021
oooo002Moooo0P00087oool00?oooolQoooo003ooooo8Oooo`00O?ooo`030000oooooooo02;oool0
0`000?ooooooo`1loooo001koooo00<0003oooooool02?ooo`030000oooooooo01Woool00`000?oo
ooooo`1koooo001koooo00<0003oooooool00_ooo`800004oooo00<0003oooooool03_ooo`<00002
oooo0P0000Coool00`000?ooooooo`1koooo001koooo00D0003oooooooooool000000_ooo`030000
oooooooo00;oool00`000?ooooooo`04oooo100000Koool00`000?ooooooo`07oooo00<0003ooooo
ool0Noooo`00N_ooo`030000oooooooo00;oool00`000?ooooooo`0Coooo1@0000Woool00`000?oo
ooooo`1joooo001koooo00<0003oooooool01@0001;oool010000?ooooooo`0000Woool00`000?oo
ooooo`1koooo001koooo00D0003oooooooooool000005_ooo`030000oooo000000Woool00`000?oo
ooooo`1koooo001loooo00<0003oooooool06?ooo`800008oooo00<0003oooooool0O?ooo`00oooo
ob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-8.12947, \
-1.14361, 0.0496935, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-8.12947, -1.14361, 0.0496935, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.9) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
.2 1 0 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.32392 .12361 L
.33304 .12361 L
.33788 .12361 L
.34309 .12361 L
.34566 .12361 L
.34693 .12361 L
.34811 .12361 L
.34918 .12361 L
s
.34918 .12361 m
.34963 .61803 L
s
0 .4 1 r
.02381 .12805 m
.04262 .12981 L
.06244 .13244 L
.07286 .13424 L
.08255 .13625 L
.09388 .13908 L
.10458 .14233 L
.125 .15054 L
.14357 .16111 L
.16355 .17715 L
.18199 .19798 L
.18664 .20441 L
.18787 .2062 L
.18921 .2082 L
.19048 .21012 L
.19166 .2101 L
.19638 .21002 L
.20071 .20994 L
.21133 .20972 L
.22134 .20947 L
.24186 .20879 L
.26047 .20792 L
.28055 .20659 L
.29902 .20487 L
.31784 .20242 L
.32853 .20062 L
.33851 .1986 L
.34351 .19745 L
.34615 .19679 L
.3476 .19642 L
.34831 .19624 L
.34896 .19606 L
.35013 .12361 L
.3514 .12361 L
.35272 .12361 L
.35338 .12361 L
.3541 .12361 L
.35529 .12361 L
.35656 .12361 L
.35777 .12361 L
.35886 .12361 L
.36002 .12361 L
.36124 .12361 L
.36229 .12361 L
.36344 .12361 L
.36467 .12361 L
.36537 .12361 L
.366 .12361 L
.36723 .12361 L
.3684 .12361 L
Mistroke
.36949 .12361 L
.37064 .12361 L
.37173 .12361 L
.37271 .12361 L
.37388 .12361 L
.37514 .12361 L
.37632 .12361 L
.37741 .12361 L
.37868 .12361 L
.37988 .12361 L
.38096 .12361 L
.38213 .12361 L
.3834 .12361 L
.38404 .12361 L
.38475 .12361 L
.386 .12361 L
.38718 .12361 L
.38829 .12361 L
.38946 .12361 L
.39046 .12361 L
.39156 .12361 L
.39274 .12361 L
.394 .12361 L
.3952 .12361 L
.39628 .12361 L
.39757 .12361 L
.39822 .12361 L
.39894 .12361 L
.4002 .12361 L
.40139 .12361 L
.4021 .12361 L
.40278 .12361 L
.40406 .12361 L
.40477 .12361 L
.40543 .12361 L
.40615 .12361 L
.40692 .12361 L
.4081 .12361 L
.40938 .12361 L
.41058 .12361 L
.41169 .12361 L
.41291 .12361 L
.41361 .12361 L
.41425 .12361 L
.41556 .12361 L
.41629 .12361 L
.41695 .12361 L
.41814 .12361 L
.41926 .12361 L
.42048 .12361 L
Mistroke
.42179 .12361 L
.42245 .12361 L
.42317 .12361 L
.42447 .12361 L
.42574 .12361 L
.42692 .12361 L
.42812 .12361 L
.42925 .12361 L
.43027 .12361 L
.43137 .12361 L
.43257 .12361 L
.43384 .12361 L
.43493 .12361 L
.43612 .12361 L
.43739 .12361 L
.43811 .12361 L
.43878 .12361 L
.44001 .12361 L
.44131 .12361 L
.44202 .12361 L
.44269 .12361 L
.44343 .12361 L
.44422 .12361 L
.44489 .12361 L
.4456 .12361 L
.44687 .12361 L
.44807 .12361 L
.44935 .12361 L
.45056 .12361 L
.45166 .12361 L
.45296 .12361 L
.45369 .12361 L
.45436 .12361 L
.4556 .12361 L
.4569 .12361 L
.45812 .12361 L
.45944 .12361 L
.46068 .12361 L
.46184 .12361 L
.46299 .12361 L
.46403 .12361 L
.46522 .12361 L
.46635 .12361 L
.46759 .12361 L
.46889 .12361 L
.47001 .12361 L
.47123 .12361 L
.47254 .12361 L
.47328 .12361 L
.47395 .12361 L
Mistroke
.47526 .12361 L
.47649 .12361 L
.47755 .12361 L
.47871 .12361 L
.47992 .12361 L
.48106 .12361 L
.48212 .12361 L
.48309 .12361 L
.48421 .12361 L
.48527 .12361 L
.48642 .12361 L
.48764 .12361 L
.48879 .12361 L
.48983 .12361 L
.49106 .12361 L
.49176 .12361 L
.4924 .12361 L
.49357 .12361 L
.49481 .12361 L
.49603 .12361 L
.49667 .12361 L
.49735 .12361 L
.49861 .12361 L
.49976 .12361 L
.50087 .12361 L
.50191 .12361 L
.50305 .12361 L
.50428 .12361 L
.50551 .12361 L
.50621 .12361 L
.50686 .12361 L
.50818 .12361 L
.50891 .12361 L
.50958 .12361 L
.51078 .12361 L
.51208 .12361 L
.51331 .12361 L
.51444 .12361 L
.51549 .12361 L
.51663 .12361 L
.5177 .12361 L
.51868 .12361 L
.51982 .12361 L
.52107 .12361 L
.52225 .12361 L
.52334 .12361 L
.52458 .12361 L
.52574 .12361 L
.52678 .12361 L
.52791 .12361 L
Mistroke
.52914 .12361 L
.53044 .12361 L
.53155 .12361 L
.53277 .12361 L
.53399 .12361 L
.53529 .12361 L
.53596 .12361 L
.53671 .12361 L
.53802 .12361 L
.53926 .12361 L
.53991 .12361 L
.54059 .12361 L
.54185 .12361 L
.543 .12361 L
.54411 .12361 L
.5453 .12361 L
.54643 .12361 L
.54745 .12361 L
.54865 .12361 L
.54995 .12361 L
.55118 .12361 L
.55231 .12361 L
.55352 .12361 L
.55481 .12361 L
.55604 .12361 L
.55715 .12361 L
.55846 .12361 L
.5592 .12361 L
.55989 .12361 L
.56114 .12361 L
.56178 .12361 L
.56248 .12361 L
.56316 .12361 L
.56387 .12361 L
.56515 .12361 L
.56586 .12361 L
.56652 .12361 L
.56725 .12361 L
.56802 .12361 L
.5687 .12361 L
.56943 .12361 L
.57012 .12361 L
.57075 .12361 L
.57196 .12361 L
.57323 .12361 L
.57444 .12361 L
.57576 .12361 L
.577 .12361 L
.57815 .12361 L
.57929 .12361 L
Mistroke
.58033 .12361 L
.58152 .12361 L
.58265 .12361 L
.59277 .12361 L
.61108 .12361 L
.64964 .12361 L
.69065 .12361 L
.73014 .12361 L
.76812 .12361 L
.80855 .12361 L
.84747 .12361 L
.88884 .12361 L
.92869 .12361 L
.96703 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.9) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Koooo1@00083oool009goool00`000?ooooooo`20oooo002Moooo00<0003ooooo
ool00oooo`<0001joooo002Eoooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0N_oo
o`00WOooo`030000oooooooo00?oool00`000?ooooooo`1joooo002Loooo0P0000Goool00`000?oo
ooooo`1joooo002Soooo00<0003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool2
0000Noooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0
003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002S
oooo00<0003oooooool0N_ooo`00Xoooo`80001koooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool00:?oool20000Noooo`00:oooo`<0000Xoooo0`0002?oool4
00008oooo`030000oooooooo02?oool400009oooo`<0000Yoooo000[oooo00@0003oooooool0000X
oooo00<0003oooooool08_ooo`030000oooooooo02Coool00`000?ooooooo`0Soooo00<0003ooooo
ool0:Oooo`030000oooooooo02Soool002_oool010000?ooooooo`0002Goool500009?ooo`030000
oooooooo02?oool00`000?ooooooo`0Toooo00<0003oooooool09Oooo`D0000Yoooo000Uoooo1000
00;oool300008?ooo`@00002oooo00@0003oooooool0000Noooo100000Coool00`000?ooooooo`0R
oooo00<0003oooooool09Oooo`030000oooooooo02Coool010000?ooooooo`0002[oool002coool0
0`000?ooooooo`0Voooo00<0003oool000009?ooo`040000oooooooo00008oooo`030000oooooooo
02?oool010000?ooooooo`0002Koool00`000?ooo`00000Zoooo000/oooo0`0002Ooool200009Ooo
o`80000Toooo0P0002Goool20000:?ooo`80000Zoooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool0013ooooo00004Oooo`005_ooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oool0
I_l01oooo`030000oooo0000010000000c?o000003?o0008<ol000<0000co`0co`001c?o00030000
<ol0<ol000Lco`000`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool05Oooo`005_ooo`P0I_l<oooo00<0003oooooool09_ooo`030000oooooooo01?oool00`1Voooo
ooooo`0?oooo00<0003oooooool01_ooo`@0000K<ol000<0003oooooool09Oooo`030000oooooooo
02Koool00`000?ooooooo`0Yoooo000Noooo1P1VodGoool00`1Vooooooooo`0Loooo100001Lco`00
0`000?ooooooo`1joooo000Toooo1P1Vocooool00`1Vooooooooo`0Poooo00<0000co`0co`0053?o
00030000oooooooo07[oool002[oool306Ko??ooo`0306Kooooooooo027oool2000053?o00030000
oooooooo07[oool002goool206Ko>_ooo`0306Kooooooooo02?oool00`0003?o03?o000A<ol000<0
003oooooool0N_ooo`00;oooo`80I_lhoooo00<0I_ooooooool09?ooo`030000<ol0<ol0010co`02
0000Noooo`00<Oooo`80I_lfoooo00<0I_ooooooool09Oooo`80000@<ol000<0003oooooool0N_oo
o`00<oooo`80I_ldoooo00<0I_ooooooool09oooo`030000<ol0<ol000dco`000`000?ooooooo`1j
oooo000eoooo00<0I_ooooooool0<Oooo`0306Kooooooooo02Ooool00`0003?o03?o000=<ol000<0
003oooooool0N_ooo`00=_ooo`0306Kooooooooo033oool00`1Vooooooooo`0Xoooo00<0000co`0c
o`0033?o00030000oooooooo07[oool003Ooool206Ko<?ooo`0306Kooooooooo02Soool00`0003?o
03?o000<<ol000<0003oooooool0N_ooo`00>Oooo`0306Kooooooooo02goool00`1Vooooooooo`0Y
oooo00<0000co`0co`002c?o0080001koooo000joooo00<0I_ooooooool0;?ooo`0306Kooooooooo
02Woool00`0003?o03?o000;<ol000<0003oooooool0N_ooo`00>oooo`0306Kooooooooo02_oool0
0`1Vooooooooo`0Zoooo00<0000co`0co`002S?o00030000oooooooo07[oool003coool00`1Voooo
ooooo`0Zoooo00<0I_ooooooool0:_ooo`030000<ol0<ol000Xco`000`000?ooooooo`1joooo000l
oooo00<0I_ooooooool0:_ooo`0306Kooooooooo02_oool00`0003?o03?o0009<ol000<0003ooooo
ool0N_ooo`00?Oooo`0306Kooooooooo02Woool00`1Vooooooooo`0[oooo00<0000co`0co`002C?o
00030000oooooooo07[oool003koool00`1Vooooooooo`0Toooo1@1Vobkoool00`0003?o03?o0008
<ol00P0007_oool003ooool00`1Vooooooooo`0Moooo1P1Vo`Coool00ol0VOooooooo`0/oooo00<0
000co`0co`0023?o00030000oooooooo07[oool0043oool00`1Vooooooooo`0Boooo2P1Vo`[oool0
0ol0VOooooooo`0/oooo00<0000co`0co`0023?o00030000oooooooo07[oool0043ooolE06Ko5?oo
o`03o`2Ioooooooo02goool00`0003?o03?o0007<ol000<0003oooooool0N_ooo`00JOooo`03o`2I
oooooooo02goool00`0003?o03?o0007<ol000<0003oooooool0N_ooo`00JOooo`03o`2Ioooooooo
02goool00`0003?o03?o0007<ol000<0003oooooool0N_ooo`00JOooo`03o`2Ioooooooo02goool0
0`0003?o03?o0007<ol00P0007_oool006Woool00ol0VOooooooo`0^oooo00<0000co`0co`001S?o
00030000oooooooo07[oool006Woool00ol0VOooooooo`0^oooo00<0000co`0co`001S?o00030000
oooooooo07[oool006Woool00ol0VOooooooo`0^oooo00<0000co`0co`001S?o00030000oooooooo
07[oool006Woool00ol0VOooooooo`0^oooo00<0000co`0co`001S?o00030000oooooooo07[oool0
06Woool00ol0VOooooooo`0_oooo1@0000<co`000`000?ooooooo`1joooo001Yoooo00?o09Wooooo
ool0;oooo`030000<ol0000000Dco`000`000?ooooooo`1joooo001Yoooo00?o09Woooooool0;ooo
o`030000<ol0000000Dco`030000N_ooo`00JOooo`03o`2Ioooooooo033oool200001C?o00030000
oooooooo07[oool006Woool00ol0VOooooooo`0`oooo0P0000Dco`000`000?ooooooo`1joooo001Y
oooo00?o09Woooooool0<?ooo`800005<ol000<0003oooooool0N_ooo`00JOooo`03o`2Ioooooooo
033oool00`0003?o03?o0004<ol000<0003oooooool0N_ooo`00JOooo`03o`2Ioooooooo033oool0
0`0003?o03?o0004<ol000<0003oooooool0N_ooo`00JOooo`03o`2Ioooooooo033oool00`0003?o
03?o0004<ol00P0007_oool006Woool00ol0VOooooooo`0aoooo00<0000co`0co`000c?o00030000
oooooooo07[oool006Woool00ol0VOooooooo`0aoooo00<0000co`0co`000c?o00030000oooooooo
07[oool006Woool00ol0VOooooooo`0aoooo00<0000co`0co`000c?o00030000oooooooo07[oool0
06Woool00ol0VOooooooo`0aoooo00<0000co`0co`000c?o00030000oooooooo07[oool006Woool0
0ol0VOooooooo`0aoooo00<0000co`0co`000c?o00030000oooooooo07[oool006Woool00ol0VOoo
ooooo`0aoooo00<0000co`0co`000c?o0080001koooo001Yoooo00?o09Woooooool0<Oooo`030000
<ol0<ol000<co`000`000?ooooooo`1joooo001Yoooo00?o09Woooooool0<Oooo`030000<ol0<ol0
00<co`000`000?ooooooo`1joooo001Yoooo00?o09Woooooool0<_ooo`030000<ol0<ol0008co`00
0`000?ooooooo`1joooo001Yoooo00?o09Woooooool0<_ooo`030000<ol0<ol0008co`000`000?oo
ooooo`1joooo001Yoooo00?o09Woooooool0<_ooo`030000<ol0<ol0008co`000`000?ooooooo`1j
oooo001Yoooo00?o09Woooooool0<_ooo`030000<ol0<ol0008co`000`000?ooooooo`1joooo001Y
oooo00?o09Woooooool0<_ooo`030000<ol0<ol0008co`020000Noooo`00JOooo`03o`2Ioooooooo
03;oool00`0003?o03?o0002<ol000<0003oooooool0N_ooo`00JOooo`03o`2Ioooooooo03;oool0
0`0003?o03?o0002<ol000<0003oooooool0N_ooo`00JOooo`03o`2Ioooooooo03;oool00`0003?o
03?o0002<ol000<0003oooooool0N_ooo`00JOooo`03o`2Ioooooooo03;oool00`0003?o03?o0002
<ol000<0003oooooool0N_ooo`00JOooo`03o`2Ioooooooo03;oool00`0003?o03?o0002<ol000<0
003oooooool0N_ooo`00JOooo`03o`2Ioooooooo03;oool00`0003?o03?o0002<ol00P0007_oool0
06Woool00ol0VOooooooo`0coooo00D0000co`0co`0co`000000O?ooo`00JOooo`03o`2Ioooooooo
03?oool01@0003?o03?o03?o0000001loooo001Yoooo00?o09Woooooool0<oooo`050000<ol0<ol0
<ol0000007coool006Woool00ol0VOooooooo`0_oooo1@0000<co`000`000?ooooooo`1joooo001Y
oooo00?o09Woooooool0;oooo`050000oooooooooooo000000<co`000`000?ooooooo`1joooo001Y
oooo00?o09Woooooool0<?ooo`040000oooooooo00000c?o00<0001joooo001Yoooo00?o09Wooooo
ool0<Oooo`030000oooo000000<co`000`000?ooooooo`1joooo001Yoooo00?o09Woooooool0;ooo
o`030000oooooooo00800003<ol000<0003oooooool0N_ooo`00JOooo`03o`2Ioooooooo033oool2
000000?oool0000co`000S?o00030000oooooooo07[oool006Woool00ol0VOooooooo`0coooo00D0
000co`0co`0co`000000O?ooo`00JOooo`03o`2Ioooooooo03Coool0100003?o03?o000007coool0
06Woool00ol0VOooooooo`0doooo00<0000co`0co`000P0007_oool006Woool00ol0VOooooooo`0d
oooo00@0000co`0co`00001loooo001Yoooo00?o09Woooooool0=?ooo`040000<ol0<ol00000O?oo
o`00JOooo`03o`2Ioooooooo03Coool0100003?o03?o000007coool006Woool00ol0VOooooooo`0d
oooo00@0000co`0co`00001loooo001Yoooo00?o09Woooooool0=?ooo`040000<ol0<ol00000O?oo
o`00JOooo`03o`2Ioooooooo03Coool0100003?o03?o000007coool006Woool00ol0VOooooooo`0e
oooo00@0000co`000000001koooo001Yoooo00?o09Woooooool0=Oooo`030000<ol0000007coool0
06Woool00ol0VOooooooo`0eoooo00<0000co`000000O?ooo`00JOooo`03o`2Ioooooooo03Goool0
0`0003?o0000001loooo001Yoooo00?o09Woooooool0=Oooo`030000<ol0000007coool006Woool0
0ol0VOooooooo`0eoooo00<0000co`000000O?ooo`00JOooo`03o`2Ioooooooo03Goool0100003?o
0000000007_oool006Woool00ol0VOooooooo`0eoooo00<0000co`000000O?ooo`00JOooo`03o`2I
oooooooo03Goool00`0003?o0000001loooo001Yoooo00?o09Woooooool0=Oooo`030000<ol00000
07coool006Woool00ol0VOooooooo`0eoooo00<0000co`000000O?ooo`00JOooo`03o`2Ioooooooo
03Goool00`0003?o0000001loooo001Yoooo00?o09Woooooool0=Oooo`040000<ol000000000Nooo
o`00JOooo`03o`2Ioooooooo03Goool00`0003?o0000001loooo001Yoooo00?o09Woooooool0=Ooo
o`030000<ol0000007coool006Woool00ol0VOooooooo`0eoooo00<0000co`000000O?ooo`00JOoo
o`03o`2Ioooooooo033oool200000oooo`030000<ol0000007coool006Woool00ol0VOooooooo`0_
oooo00@0003oooooool00002oooo00<0000co`000000O?ooo`00JOooo`03o`2Ioooooooo037oool0
1P000?ooooooooooo`0003?o00<0001joooo001Yoooo00?o09Woooooool0<_ooo`060000oooooooo
0000<ol00000O?ooo`00JOooo`03o`2Ioooooooo02ooool010000?ooooooo`0000;oool00`0003?o
0000001loooo001Yoooo00?o09Woooooool0<?ooo`800004oooo0P0007coool006Woool00ol0VOoo
ooooo`0foooo0P0007coool006Woool00ol0VOooooooo`0foooo0P0007coool006Woool00ol0VOoo
ooooo`0foooo0P0007coool006Woool00ol0VOooooooo`0foooo0`0007_oool006Woool00ol0VOoo
ooooo`0foooo0P0007coool006Woool00ol0VOooooooo`0foooo0P0007coool006Woool00ol0VOoo
ooooo`0foooo0P0007coool006Woool00ol0VOooooooo`0foooo0P0007coool006Woool00ol0VOoo
ooooo`0foooo0P0007coool006Woool00ol0VOooooooo`0foooo0`0007_oool006Woool00ol0VOoo
ooooo`0foooo0P0007coool006Woool00ol0VOooooooo`0foooo0P0007coool006Woool00ol0VOoo
ooooo`0foooo0P0007coool006Woool00ol0VOooooooo`0foooo0P0007coool006Woool00ol0VOoo
ooooo`0foooo0P0007coool006Woool00ol0VOooooooo`0foooo0`0007_oool006Woool00ol0VOoo
ooooo`0goooo00<0003oooooool0N_ooo`00JOooo`03o`2Ioooooooo03Ooool00`000?ooooooo`1j
oooo001Yoooo00?o09Woooooool0=oooo`030000oooooooo07[oool006Woool00ol0VOooooooo`0g
oooo00<0003oooooool0N_ooo`00JOooo`03o`2Ioooooooo03Ooool00`000?ooooooo`1joooo001Y
oooo00?o09Woooooool0=oooo`80001koooo001Yoooo00?o09Woooooool0=oooo`030000oooooooo
07[oool006Woool00ol0VOooooooo`0goooo00<0003oooooool0N_ooo`00JOooo`03o`2Ioooooooo
03Ooool00`000?ooooooo`1joooo001Yoooo00?o09Woooooool0=oooo`030000oooooooo07[oool0
06Woool00ol0VOooooooo`0aoooo0`0000?oool00`000?ooooooo`1joooo001Yoooo00?o09Wooooo
ool0<_ooo`030000oooooooo00;oool00`000?ooooooo`1joooo001Yoooo00?o09Woooooool0;ooo
o`D00003oooo0`0007[oool009_oool010000?ooooooo`00087oool009coool00`000?ooo`000021
oooo002Moooo0P00087oool00?oooolQoooo003ooooo8Oooo`00NOooo`030000oooooooo02Soool0
0`000?ooooooo`1ioooo001hoooo00<0003oooooool02?ooo`030000oooooooo01ooool00`000?oo
ooooo`1hoooo001hoooo00<0003oooooool00_ooo`800004oooo00<0003oooooool03Oooo`800004
oooo0P0000?oool300001?ooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`000002
oooo00<0003oooooool00_ooo`030000oooooooo00Coool400000oooo`040000oooooooo00002_oo
o`030000oooooooo00;oool00`000?ooooooo`1hoooo001goooo00<0003oooooool00_ooo`030000
oooooooo01Goool00`000?ooooooo`08oooo0`0000Coool00`000?ooooooo`1goooo001hoooo00<0
003oooooool01@0001Goool00`000?ooooooo`06oooo00@0003oooooool00003oooo00<0003ooooo
ool0N?ooo`00N?ooo`050000oooooooooooo000001Goool010000?ooooooo`0000Soool010000?oo
ooooo`0000?oool00`000?ooooooo`1hoooo001ioooo00<0003oooooool05oooo`80000:oooo0`00
00;oool00`000?ooooooo`1ioooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-8.12947, \
-1.14361, 0.0496935, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-8.12947, -1.14361, 0.0496935, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
.2 1 0 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.32392 .12361 L
.33304 .12361 L
.34309 .12361 L
.34772 .12361 L
.35028 .12361 L
.35271 .12361 L
.35496 .12361 L
.35624 .12361 L
s
.35624 .12361 m
.35671 .61803 L
s
0 .4 1 r
.02381 .12746 m
.04262 .12899 L
.06244 .13128 L
.07286 .13284 L
.08255 .13458 L
.09388 .13704 L
.10458 .13986 L
.125 .14699 L
.14357 .15617 L
.16355 .17009 L
.18199 .18817 L
.19101 .19943 L
.19339 .20271 L
.19598 .20646 L
.19717 .20823 L
.19844 .21012 L
.19963 .2101 L
.20071 .21008 L
.20627 .20999 L
.21136 .20989 L
.22134 .20967 L
.24058 .20913 L
.25143 .20873 L
.2614 .20828 L
.28023 .20719 L
.29092 .20639 L
.30089 .2055 L
.32124 .20309 L
.3398 .19998 L
.34461 .199 L
.34971 .19785 L
.35407 .19679 L
.35527 .19649 L
.35656 .19615 L
.35777 .12361 L
.35889 .12361 L
.36009 .12361 L
.36139 .12361 L
.36261 .12361 L
.36371 .12361 L
.36502 .12361 L
.36575 .12361 L
.36643 .12361 L
.36768 .12361 L
.369 .12361 L
.37026 .12361 L
.37097 .12361 L
.37162 .12361 L
.37287 .12361 L
.37407 .12361 L
Mistroke
.37474 .12361 L
.37545 .12361 L
.37674 .12361 L
.37752 .12361 L
.37826 .12361 L
.37899 .12361 L
.37965 .12361 L
.38081 .12361 L
.38206 .12361 L
.38322 .12361 L
.38432 .12361 L
.38559 .12361 L
.38677 .12361 L
.38806 .12361 L
.38872 .12361 L
.38943 .12361 L
.39009 .12361 L
.39077 .12361 L
.392 .12361 L
.39332 .12361 L
.39407 .12361 L
.39477 .12361 L
.39603 .12361 L
.39718 .12361 L
.39782 .12361 L
.39851 .12361 L
.39976 .12361 L
.40092 .12361 L
.40199 .12361 L
.40317 .12361 L
.40444 .12361 L
.40508 .12361 L
.40577 .12361 L
.40703 .12361 L
.40825 .12361 L
.40939 .12361 L
.41044 .12361 L
.41143 .12361 L
.41251 .12361 L
.41368 .12361 L
.41484 .12361 L
.41606 .12361 L
.41711 .12361 L
.41825 .12361 L
.41956 .12361 L
.42078 .12361 L
.42141 .12361 L
.42211 .12361 L
.42284 .12361 L
.42352 .12361 L
Mistroke
.42478 .12361 L
.42592 .12361 L
.42656 .12361 L
.42725 .12361 L
.42851 .12361 L
.42974 .12361 L
.43085 .12361 L
.43213 .12361 L
.43335 .12361 L
.43447 .12361 L
.4355 .12361 L
.43664 .12361 L
.43784 .12361 L
.43914 .12361 L
.44033 .12361 L
.44099 .12361 L
.4417 .12361 L
.443 .12361 L
.44422 .12361 L
.44551 .12361 L
.44661 .12361 L
.44782 .12361 L
.44851 .12361 L
.44924 .12361 L
.45054 .12361 L
.45127 .12361 L
.45194 .12361 L
.45268 .12361 L
.45347 .12361 L
.45416 .12361 L
.4549 .12361 L
.45561 .12361 L
.45625 .12361 L
.45748 .12361 L
.45878 .12361 L
.45999 .12361 L
.46131 .12361 L
.46256 .12361 L
.46371 .12361 L
.46486 .12361 L
.4659 .12361 L
.46703 .12361 L
.46822 .12361 L
.46953 .12361 L
.47074 .12361 L
.47203 .12361 L
.47277 .12361 L
.47345 .12361 L
.47469 .12361 L
.47583 .12361 L
Mistroke
.47713 .12361 L
.47837 .12361 L
.47942 .12361 L
.48058 .12361 L
.48171 .12361 L
.48293 .12361 L
.48407 .12361 L
.48511 .12361 L
.48615 .12361 L
.48715 .12361 L
.48829 .12361 L
.48951 .12361 L
.49066 .12361 L
.49171 .12361 L
.49294 .12361 L
.49363 .12361 L
.49427 .12361 L
.49544 .12361 L
.49668 .12361 L
.4979 .12361 L
.49859 .12361 L
.49923 .12361 L
.5004 .12361 L
.50164 .12361 L
.50267 .12361 L
.50379 .12361 L
.50501 .12361 L
.50616 .12361 L
.50739 .12361 L
.50809 .12361 L
.50874 .12361 L
.51005 .12361 L
.51079 .12361 L
.51145 .12361 L
.51265 .12361 L
.51395 .12361 L
.51518 .12361 L
.51631 .12361 L
.51737 .12361 L
.5185 .12361 L
.51957 .12361 L
.52055 .12361 L
.5217 .12361 L
.52294 .12361 L
.52412 .12361 L
.52522 .12361 L
.52645 .12361 L
.52761 .12361 L
.52865 .12361 L
.52978 .12361 L
Mistroke
.53101 .12361 L
.53232 .12361 L
.53343 .12361 L
.53464 .12361 L
.53595 .12361 L
.53716 .12361 L
.53779 .12361 L
.53849 .12361 L
.53922 .12361 L
.5399 .12361 L
.54115 .12361 L
.54229 .12361 L
.54355 .12361 L
.54487 .12361 L
.55418 .12361 L
.55547 .12361 L
.55669 .12361 L
.55736 .12361 L
.55809 .12361 L
.55937 .12361 L
.56058 .12361 L
.56187 .12361 L
.56297 .12361 L
.56418 .12361 L
.56491 .12361 L
.56561 .12361 L
.56691 .12361 L
.56763 .12361 L
.56831 .12361 L
.56904 .12361 L
.56983 .12361 L
.57047 .12361 L
.57116 .12361 L
.5724 .12361 L
.57369 .12361 L
.57443 .12361 L
.57511 .12361 L
.57631 .12361 L
.57761 .12361 L
.57885 .12361 L
.57998 .12361 L
.58102 .12361 L
.58215 .12361 L
.58446 .12361 L
.59455 .12361 L
.61281 .12361 L
.65311 .12361 L
.69189 .12361 L
.73312 .12361 L
.77284 .12361 L
Mistroke
.81104 .12361 L
.85169 .12361 L
.89083 .12361 L
.93242 .12361 L
.97249 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Koooo1@00083oool009goool00`000?ooooooo`20oooo002Moooo00<0003ooooo
ool00oooo`<0001joooo002Eoooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0N_oo
o`00WOooo`030000oooooooo00?oool00`000?ooooooo`1joooo002Loooo0P0000Goool00`000?oo
ooooo`1joooo002Soooo00<0003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool2
0000Noooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0
003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002S
oooo00<0003oooooool0N_ooo`00Xoooo`80001koooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool00:?oool20000Noooo`00:oooo`<0000Xoooo0`0002?oool4
00008oooo`030000oooooooo02?oool400009oooo`<0000Yoooo000[oooo00@0003oooooool0000X
oooo00<0003oooooool08_ooo`030000oooooooo02Coool00`000?ooooooo`0Soooo00<0003ooooo
ool0:Oooo`030000oooooooo02Soool002_oool010000?ooooooo`0002Goool500009?ooo`030000
oooooooo02?oool00`000?ooooooo`0Toooo00<0003oooooool09Oooo`D0000Yoooo000Uoooo1000
00;oool300008?ooo`@00002oooo00@0003oooooool0000Noooo100000Coool00`000?ooooooo`0R
oooo00<0003oooooool09Oooo`030000oooooooo02Coool010000?ooooooo`0002[oool002coool0
0`000?ooooooo`0Voooo00<0003oool000009?ooo`040000oooooooo00008oooo`030000oooooooo
02?oool010000?ooooooo`0002Koool00`000?ooo`00000Zoooo000/oooo0`0002Ooool200009Ooo
o`80000Toooo0P0002Goool20000:?ooo`80000Zoooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool0013ooooo00004Oooo`005_ooo`03000006Ko06Ko00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00D0003ooooo
ooooool0I_l01Oooo`030000oooo0000010000000c?o000003?o0008<ol000<0000co`0co`001c?o
00030000<ol0<ol000Lco`000`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo
00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?oo
ooooo`08oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0
003oooooool05Oooo`006Oooo`T0I_l8oooo00<0003oooooool09_ooo`030000oooooooo01Goool0
0`1Vooooooooo`0=oooo00<0003oooooool01_ooo`@0000K<ol000<0003oooooool09Oooo`030000
oooooooo02Koool00`000?ooooooo`0Yoooo000Roooo1@1VodCoool00`1Vooooooooo`0Joooo1000
01Lco`000`000?ooooooo`1joooo000Woooo0`1Vod7oool00`1Vooooooooo`0Noooo00<0000co`0c
o`0053?o00030000oooooooo07[oool002[oool406Ko?Oooo`0306Kooooooooo01ooool2000053?o
00030000oooooooo07[oool002koool306Ko>_ooo`0306Kooooooooo027oool00`0003?o03?o000A
<ol000<0003oooooool0N_ooo`00<Oooo`80I_lhoooo00<0I_ooooooool08_ooo`030000<ol0<ol0
010co`020000Noooo`00<oooo`80I_lfoooo00<0I_ooooooool08oooo`80000@<ol000<0003ooooo
ool0N_ooo`00=Oooo`0306Kooooooooo03?oool00`1Vooooooooo`0Uoooo00<0000co`0co`003C?o
00030000oooooooo07[oool003Koool206Ko<oooo`0306Kooooooooo02Goool00`0003?o03?o000=
<ol000<0003oooooool0N_ooo`00>?ooo`80I_laoooo00<0I_ooooooool09_ooo`030000<ol0<ol0
00`co`000`000?ooooooo`1joooo000joooo00<0I_ooooooool0;_ooo`0306Kooooooooo02Koool0
0`0003?o03?o000<<ol000<0003oooooool0N_ooo`00>oooo`0306Kooooooooo02goool00`1Voooo
ooooo`0Woooo00<0000co`0co`002c?o0080001koooo000loooo00<0I_ooooooool0;?ooo`0306Ko
oooooooo02Ooool00`0003?o03?o000;<ol000<0003oooooool0N_ooo`00??ooo`0306Kooooooooo
02coool00`1Vooooooooo`0Xoooo00<0000co`0co`002S?o00030000oooooooo07[oool003goool0
0`1Vooooooooo`0[oooo00<0I_ooooooool0:?ooo`030000<ol0<ol000Xco`000`000?ooooooo`1j
oooo000noooo00<0I_ooooooool0:_ooo`0306Kooooooooo02Woool00`0003?o03?o0009<ol000<0
003oooooool0N_ooo`00?oooo`0306Kooooooooo02Woool00`1Vooooooooo`0Yoooo00<0000co`0c
o`002C?o00030000oooooooo07[oool0043oool00`1Vooooooooo`0Voooo0`1Vobcoool00`0003?o
03?o0008<ol00P0007_oool0047oool00`1Vooooooooo`0Qoooo101Vo`;oool00ol0VOooooooo`0Z
oooo00<0000co`0co`0023?o00030000oooooooo07[oool004;oool00`1Vooooooooo`0Doooo301V
o`Koool00ol0VOooooooo`0Zoooo00<0000co`0co`0023?o00030000oooooooo07[oool004;ooolG
06Ko4_ooo`03o`2Ioooooooo02_oool00`0003?o03?o0007<ol000<0003oooooool0N_ooo`00Jooo
o`03o`2Ioooooooo02_oool00`0003?o03?o0007<ol000<0003oooooool0N_ooo`00Joooo`03o`2I
oooooooo02_oool00`0003?o03?o0007<ol000<0003oooooool0N_ooo`00Joooo`03o`2Ioooooooo
02_oool00`0003?o03?o0007<ol00P0007_oool006_oool00ol0VOooooooo`0/oooo00<0000co`0c
o`001S?o00030000oooooooo07[oool006_oool00ol0VOooooooo`0/oooo00<0000co`0co`001S?o
00030000oooooooo07[oool006_oool00ol0VOooooooo`0/oooo00<0000co`0co`001S?o00030000
oooooooo07[oool006_oool00ol0VOooooooo`0/oooo00<0000co`0co`001S?o00030000oooooooo
07[oool006_oool00ol0VOooooooo`0]oooo1@0000<co`000`000?ooooooo`1joooo001[oooo00?o
09Woooooool0;Oooo`030000<ol0000000Dco`000`000?ooooooo`1joooo001[oooo00?o09Wooooo
ool0;Oooo`030000<ol0000000Dco`030000N_ooo`00Joooo`03o`2Ioooooooo02koool200001C?o
00030000oooooooo07[oool006_oool00ol0VOooooooo`0^oooo0P0000Dco`000`000?ooooooo`1j
oooo001[oooo00?o09Woooooool0;_ooo`800005<ol000<0003oooooool0N_ooo`00Joooo`03o`2I
oooooooo02koool00`0003?o03?o0004<ol000<0003oooooool0N_ooo`00Joooo`03o`2Ioooooooo
02koool00`0003?o03?o0004<ol000<0003oooooool0N_ooo`00Joooo`03o`2Ioooooooo02koool0
0`0003?o03?o0004<ol00P0007_oool006_oool00ol0VOooooooo`0_oooo00<0000co`0co`000c?o
00030000oooooooo07[oool006_oool00ol0VOooooooo`0_oooo00<0000co`0co`000c?o00030000
oooooooo07[oool006_oool00ol0VOooooooo`0_oooo00<0000co`0co`000c?o00030000oooooooo
07[oool006_oool00ol0VOooooooo`0_oooo00<0000co`0co`000c?o00030000oooooooo07[oool0
06_oool00ol0VOooooooo`0_oooo00<0000co`0co`000c?o00030000oooooooo07[oool006_oool0
0ol0VOooooooo`0_oooo00<0000co`0co`000c?o0080001koooo001[oooo00?o09Woooooool0;ooo
o`030000<ol0<ol000<co`000`000?ooooooo`1joooo001[oooo00?o09Woooooool0;oooo`030000
<ol0<ol000<co`000`000?ooooooo`1joooo001[oooo00?o09Woooooool0<?ooo`030000<ol0<ol0
008co`000`000?ooooooo`1joooo001[oooo00?o09Woooooool0<?ooo`030000<ol0<ol0008co`00
0`000?ooooooo`1joooo001[oooo00?o09Woooooool0<?ooo`030000<ol0<ol0008co`000`000?oo
ooooo`1joooo001[oooo00?o09Woooooool0<?ooo`030000<ol0<ol0008co`000`000?ooooooo`1j
oooo001[oooo00?o09Woooooool0<?ooo`030000<ol0<ol0008co`020000Noooo`00Joooo`03o`2I
oooooooo033oool00`0003?o03?o0002<ol000<0003oooooool0N_ooo`00Joooo`03o`2Ioooooooo
033oool00`0003?o03?o0002<ol000<0003oooooool0N_ooo`00Joooo`03o`2Ioooooooo033oool0
0`0003?o03?o0002<ol000<0003oooooool0N_ooo`00Joooo`03o`2Ioooooooo033oool00`0003?o
03?o0002<ol000<0003oooooool0N_ooo`00Joooo`03o`2Ioooooooo033oool00`0003?o03?o0002
<ol000<0003oooooool0N_ooo`00Joooo`03o`2Ioooooooo033oool00`0003?o03?o0002<ol00P00
07_oool006_oool00ol0VOooooooo`0aoooo00D0000co`0co`0co`000000O?ooo`00Joooo`03o`2I
oooooooo037oool01@0003?o03?o03?o0000001loooo001[oooo00?o09Woooooool0<Oooo`050000
<ol0<ol0<ol0000007coool006_oool00ol0VOooooooo`0]oooo1@0000<co`000`000?ooooooo`1j
oooo001[oooo00?o09Woooooool0;Oooo`050000oooooooooooo000000<co`000`000?ooooooo`1j
oooo001[oooo00?o09Woooooool0;_ooo`040000oooooooo00000c?o00<0001joooo001[oooo00?o
09Woooooool0;oooo`030000oooo000000<co`000`000?ooooooo`1joooo001[oooo00?o09Wooooo
ool0;Oooo`030000oooooooo00800003<ol000<0003oooooool0N_ooo`00Joooo`03o`2Ioooooooo
02koool2000000?oool0000co`000S?o00030000oooooooo07[oool006_oool00ol0VOooooooo`0a
oooo00D0000co`0co`0co`000000O?ooo`00Joooo`03o`2Ioooooooo03;oool0100003?o03?o0000
07coool006_oool00ol0VOooooooo`0boooo00<0000co`0co`000P0007_oool006_oool00ol0VOoo
ooooo`0boooo00@0000co`0co`00001loooo001[oooo00?o09Woooooool0<_ooo`040000<ol0<ol0
0000O?ooo`00Joooo`03o`2Ioooooooo03;oool0100003?o03?o000007coool006_oool00ol0VOoo
ooooo`0boooo00@0000co`0co`00001loooo001[oooo00?o09Woooooool0<_ooo`040000<ol0<ol0
0000O?ooo`00Joooo`03o`2Ioooooooo03;oool0100003?o03?o000007coool006_oool00ol0VOoo
ooooo`0coooo00@0000co`000000001koooo001[oooo00?o09Woooooool0<oooo`030000<ol00000
07coool006_oool00ol0VOooooooo`0coooo00<0000co`000000O?ooo`00Joooo`03o`2Ioooooooo
03?oool00`0003?o0000001loooo001[oooo00?o09Woooooool0<oooo`030000<ol0000007coool0
06_oool00ol0VOooooooo`0coooo00<0000co`000000O?ooo`00Joooo`03o`2Ioooooooo03?oool0
100003?o0000000007_oool006_oool00ol0VOooooooo`0coooo00<0000co`000000O?ooo`00Jooo
o`03o`2Ioooooooo03?oool00`0003?o0000001loooo001[oooo00?o09Woooooool0<oooo`030000
<ol0000007coool006_oool00ol0VOooooooo`0coooo00<0000co`000000O?ooo`00Joooo`03o`2I
oooooooo03?oool00`0003?o0000001loooo001[oooo00?o09Woooooool0<oooo`040000<ol00000
0000Noooo`00Joooo`03o`2Ioooooooo03?oool00`0003?o0000001loooo001[oooo00?o09Wooooo
ool0<oooo`030000<ol0000007coool006_oool00ol0VOooooooo`0coooo00<0000co`000000O?oo
o`00Joooo`03o`2Ioooooooo02koool200000oooo`030000<ol0000007coool006_oool00ol0VOoo
ooooo`0]oooo00@0003oooooool00002oooo00<0000co`000000O?ooo`00Joooo`03o`2Ioooooooo
02ooool01P000?ooooooooooo`0003?o00<0001joooo001[oooo00?o09Woooooool0<?ooo`060000
oooooooo0000<ol00000O?ooo`00Joooo`03o`2Ioooooooo02goool010000?ooooooo`0000;oool0
0`0003?o0000001loooo001[oooo00?o09Woooooool0;_ooo`800004oooo0P0007coool006_oool0
0ol0VOooooooo`0doooo0P0007coool006_oool00ol0VOooooooo`0doooo0P0007coool006_oool0
0ol0VOooooooo`0doooo0P0007coool006_oool00ol0VOooooooo`0doooo0`0007_oool006_oool0
0ol0VOooooooo`0doooo0P0007coool006_oool00ol0VOooooooo`0doooo0P0007coool006_oool0
0ol0VOooooooo`0doooo0P0007coool006_oool00ol0VOooooooo`0doooo0P0007coool006_oool0
0ol0VOooooooo`0doooo0P0007coool006_oool00ol0VOooooooo`0doooo0`0007_oool006_oool0
0ol0VOooooooo`0doooo0P0007coool006_oool00ol0VOooooooo`0doooo0P0007coool006_oool0
0ol0VOooooooo`0doooo0P0007coool006_oool00ol0VOooooooo`0doooo0P0007coool006_oool0
0ol0VOooooooo`0doooo0P0007coool006_oool00ol0VOooooooo`0doooo0`0007_oool006_oool0
0ol0VOooooooo`0eoooo00<0003oooooool0N_ooo`00Joooo`03o`2Ioooooooo03Goool00`000?oo
ooooo`1joooo001[oooo00?o09Woooooool0=Oooo`030000oooooooo07[oool006_oool00ol0VOoo
ooooo`0eoooo00<0003oooooool0N_ooo`00Joooo`03o`2Ioooooooo03Goool00`000?ooooooo`1j
oooo001[oooo00?o09Woooooool0=Oooo`80001koooo001[oooo00?o09Woooooool0=Oooo`030000
oooooooo07[oool006_oool00ol0VOooooooo`0eoooo00<0003oooooool0N_ooo`00Joooo`03o`2I
oooooooo03Goool00`000?ooooooo`1joooo001[oooo00?o09Woooooool0=Oooo`030000oooooooo
07[oool006_oool00ol0VOooooooo`0_oooo0`0000?oool00`000?ooooooo`1joooo001[oooo00?o
09Woooooool0<?ooo`030000oooooooo00;oool00`000?ooooooo`1joooo001[oooo00?o09Wooooo
ool0;Oooo`D00003oooo0`0007[oool009_oool010000?ooooooo`00087oool009coool00`000?oo
o`000021oooo002Moooo0P00087oool00?oooolQoooo003ooooo8Oooo`00NOooo`030000oooooooo
02Soool00`000?ooooooo`1ioooo001hoooo00<0003oooooool02?ooo`030000oooooooo01ooool0
0`000?ooooooo`1hoooo001hoooo00<0003oooooool00_ooo`800004oooo00<0003oooooool03Ooo
o`800004oooo0P0000Coool200001?ooo`030000oooooooo07Soool007Soool01@000?oooooooooo
o`000002oooo00<0003oooooool00_ooo`030000oooooooo00Coool400000oooo`040000oooooooo
00002?ooo`040000oooooooo00000oooo`030000oooooooo07Soool007Ooool00`000?ooooooo`02
oooo00<0003oooooool05Oooo`030000oooooooo00Ooool010000?ooooooo`0000Coool00`000?oo
ooooo`1goooo001hoooo00<0003oooooool01@0001Goool00`000?ooooooo`07oooo0P0000Coool0
0`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000005Oooo`040000oooooooo00002?oo
o`040000oooooooo00000oooo`030000oooooooo07Soool007Woool00`000?ooooooo`0Goooo0P00
00[oool200000oooo`030000oooooooo07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-8.12947, \
-1.14361, 0.0496935, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-8.12947, -1.14361, 0.0496935, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.7) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
.2 1 0 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.32392 .12361 L
.34309 .12361 L
.35271 .12361 L
.35742 .12361 L
.36173 .12361 L
.36284 .12361 L
.36405 .12361 L
s
.36405 .12361 m
.36451 .61803 L
s
0 .4 1 r
.02381 .12695 m
.04262 .12828 L
.06244 .13027 L
.07286 .13162 L
.08255 .13314 L
.09388 .13527 L
.10458 .13772 L
.125 .14391 L
.14357 .15187 L
.16355 .16396 L
.18199 .17965 L
.19177 .19033 L
.19717 .19707 L
.2023 .2041 L
.2046 .20747 L
.20587 .20938 L
.20706 .21011 L
.20773 .2101 L
.20847 .21009 L
.20975 .21007 L
.21224 .21002 L
.22134 .20985 L
.24104 .20936 L
.25917 .20873 L
.278 .20782 L
.28868 .20716 L
.29866 .20641 L
.31901 .2044 L
.33757 .2018 L
.34682 .20016 L
.35665 .19808 L
.36178 .19684 L
.36318 .19648 L
.36392 .19629 L
.3647 .19609 L
.36538 .12361 L
.36613 .12361 L
.36744 .12361 L
.36875 .12361 L
.36994 .12361 L
.37059 .12361 L
.37131 .12361 L
.37261 .12361 L
.37382 .12361 L
.37511 .12361 L
.37621 .12361 L
.37741 .12361 L
.37871 .12361 L
.37991 .12361 L
.38064 .12361 L
Mistroke
.38134 .12361 L
.38263 .12361 L
.38378 .12361 L
.38502 .12361 L
.38567 .12361 L
.38635 .12361 L
.38758 .12361 L
.38868 .12361 L
.38987 .12361 L
.39099 .12361 L
.39201 .12361 L
.3932 .12361 L
.3945 .12361 L
.39573 .12361 L
.39686 .12361 L
.39806 .12361 L
.39935 .12361 L
.40057 .12361 L
.40168 .12361 L
.40292 .12361 L
.40362 .12361 L
.40427 .12361 L
.40559 .12361 L
.40633 .12361 L
.407 .12361 L
.40767 .12361 L
.40838 .12361 L
.40966 .12361 L
.41032 .12361 L
.41103 .12361 L
.41181 .12361 L
.41253 .12361 L
.41321 .12361 L
.41394 .12361 L
.41463 .12361 L
.41526 .12361 L
.41647 .12361 L
.41775 .12361 L
.41889 .12361 L
.42013 .12361 L
.42143 .12361 L
.42263 .12361 L
.42377 .12361 L
.4248 .12361 L
.42598 .12361 L
.42711 .12361 L
.42833 .12361 L
.42963 .12361 L
.43073 .12361 L
.43195 .12361 L
Mistroke
.43326 .12361 L
.43399 .12361 L
.43466 .12361 L
.43596 .12361 L
.4372 .12361 L
.43835 .12361 L
.43939 .12361 L
.4406 .12361 L
.44173 .12361 L
.44279 .12361 L
.44375 .12361 L
.44482 .12361 L
.44594 .12361 L
.44707 .12361 L
.44813 .12361 L
.44936 .12361 L
.45048 .12361 L
.45172 .12361 L
.45242 .12361 L
.45306 .12361 L
.45423 .12361 L
.45547 .12361 L
.45661 .12361 L
.45786 .12361 L
.45916 .12361 L
.46037 .12361 L
.4615 .12361 L
.46254 .12361 L
.46373 .12361 L
.46485 .12361 L
.46608 .12361 L
.46738 .12361 L
.4697 .12361 L
.471 .12361 L
.47224 .12361 L
.47292 .12361 L
.47366 .12361 L
.47496 .12361 L
.47609 .12361 L
.47729 .12361 L
.47843 .12361 L
.47946 .12361 L
.4805 .12361 L
.48163 .12361 L
.48269 .12361 L
.48367 .12361 L
.48482 .12361 L
.48589 .12361 L
.48707 .12361 L
.48833 .12361 L
Mistroke
.48965 .12361 L
.4909 .12361 L
.49202 .12361 L
.49324 .12361 L
.49445 .12361 L
.49559 .12361 L
.49691 .12361 L
.49811 .12361 L
.49924 .12361 L
.50029 .12361 L
.50145 .12361 L
.50268 .12361 L
.50333 .12361 L
.50402 .12361 L
.50478 .12361 L
.50548 .12361 L
.50674 .12361 L
.50746 .12361 L
.50813 .12361 L
.50937 .12361 L
.51051 .12361 L
.51183 .12361 L
.51307 .12361 L
.51428 .12361 L
.51496 .12361 L
.51561 .12361 L
.5169 .12361 L
.51763 .12361 L
.5183 .12361 L
.51943 .12361 L
.52066 .12361 L
.52194 .12361 L
.52314 .12361 L
.52382 .12361 L
.52457 .12361 L
.52527 .12361 L
.52591 .12361 L
.52714 .12361 L
.52844 .12361 L
.52911 .12361 L
.52983 .12361 L
.53113 .12361 L
.53193 .12361 L
.53268 .12361 L
.53336 .12361 L
.5341 .12361 L
.53475 .12361 L
.53543 .12361 L
.53666 .12361 L
.53798 .12361 L
Mistroke
.53872 .12361 L
.53942 .12361 L
.54069 .12361 L
.54184 .12361 L
.54248 .12361 L
.54318 .12361 L
.54444 .12361 L
.54548 .12361 L
.54658 .12361 L
.54778 .12361 L
.54889 .12361 L
.5501 .12361 L
.55079 .12361 L
.55142 .12361 L
.55265 .12361 L
.5538 .12361 L
.55444 .12361 L
.55514 .12361 L
.55636 .12361 L
.55705 .12361 L
.55778 .12361 L
.55909 .12361 L
.55976 .12361 L
.56047 .12361 L
.56176 .12361 L
.56255 .12361 L
.5633 .12361 L
.56397 .12361 L
.5647 .12361 L
.56591 .12361 L
.56659 .12361 L
.56724 .12361 L
.56854 .12361 L
.56927 .12361 L
.56994 .12361 L
.57106 .12361 L
.5723 .12361 L
.57358 .12361 L
.57478 .12361 L
.57605 .12361 L
.57669 .12361 L
.5774 .12361 L
.57865 .12361 L
.57982 .12361 L
.58052 .12361 L
.58119 .12361 L
.58245 .12361 L
.58528 .12361 L
.59521 .12361 L
.61378 .12361 L
Mistroke
.65198 .12361 L
.69264 .12361 L
.73177 .12361 L
.77336 .12361 L
.81344 .12361 L
.852 .12361 L
.89301 .12361 L
.9325 .12361 L
.97048 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.7) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Koooo1@00083oool009goool00`000?ooooooo`20oooo002Moooo00<0003ooooo
ool00oooo`<0001joooo002Eoooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0N_oo
o`00WOooo`030000oooooooo00?oool00`000?ooooooo`1joooo002Loooo0P0000Goool00`000?oo
ooooo`1joooo002Soooo00<0003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool2
0000Noooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0
003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002S
oooo00<0003oooooool0N_ooo`00Xoooo`80001koooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool00:?oool20000Noooo`00:oooo`<0000Xoooo0`0002?oool4
00008oooo`030000oooooooo02?oool400009oooo`<0000Yoooo000[oooo00@0003oooooool0000X
oooo00<0003oooooool08_ooo`030000oooooooo02Coool00`000?ooooooo`0Soooo00<0003ooooo
ool0:Oooo`030000oooooooo02Soool002_oool010000?ooooooo`0002Goool500009?ooo`030000
oooooooo02?oool00`000?ooooooo`0Toooo00<0003oooooool09Oooo`D0000Yoooo000Uoooo1000
00;oool300008?ooo`@00002oooo00@0003oooooool0000Noooo100000Coool00`000?ooooooo`0R
oooo00<0003oooooool09Oooo`030000oooooooo02Coool010000?ooooooo`0002[oool002coool0
0`000?ooooooo`0Voooo00<0003oool000009?ooo`040000oooooooo00008oooo`030000oooooooo
02?oool010000?ooooooo`0002Koool00`000?ooo`00000Zoooo000/oooo0`0002Ooool200009Ooo
o`80000Toooo0P0002Goool20000:?ooo`80000Zoooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool0013ooooo00004Oooo`005_ooo`03000006Ko06Ko00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool00oooo`0606Kooooooooooooo0000oooo4@000003<ol00000<ol000Pco`000`0003?o03?o0007
<ol000<0000co`0co`001c?o00030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Soool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`0Eoooo000Ioooo2`1Vo`Koool00`000?ooooooo`0Voooo00<0003oooooool05ooo
o`0306Kooooooooo00_oool00`000?ooooooo`06oooo100001/co`000`000?ooooooo`0Uoooo00<0
003oooooool09_ooo`030000oooooooo02Woool002Coool606Ko@oooo`0306Kooooooooo01Soool4
00005c?o00030000oooooooo07[oool002[oool306Ko@?ooo`0306Kooooooooo01coool00`0003?o
03?o000D<ol000<0003oooooool0N_ooo`00;Oooo`80I_lnoooo00<0I_ooooooool07Oooo`80000D
<ol000<0003oooooool0N_ooo`00;oooo`<0I_lkoooo00<0I_ooooooool07oooo`030000<ol0<ol0
014co`000`000?ooooooo`1joooo000boooo0P1VocWoool00`1Vooooooooo`0Poooo00<0000co`0c
o`0043?o0080001koooo000doooo0P1VocOoool00`1Vooooooooo`0Qoooo0P00010co`000`000?oo
ooooo`1joooo000foooo0P1VocGoool00`1Vooooooooo`0Soooo00<0000co`0co`003C?o00030000
oooooooo07[oool003Soool206Ko<oooo`0306Kooooooooo02?oool00`0003?o03?o000=<ol000<0
003oooooool0N_ooo`00>_ooo`0306Kooooooooo033oool00`1Vooooooooo`0Toooo00<0000co`0c
o`0033?o00030000oooooooo07[oool003_oool00`1Vooooooooo`0_oooo00<0I_ooooooool09?oo
o`030000<ol0<ol000`co`000`000?ooooooo`1joooo000loooo00<0I_ooooooool0;_ooo`0306Ko
oooooooo02Goool00`0003?o03?o000;<ol00P0007_oool003goool00`1Vooooooooo`0]oooo00<0
I_ooooooool09Oooo`030000<ol0<ol000/co`000`000?ooooooo`1joooo000noooo00<0I_oooooo
ool0;?ooo`0306Kooooooooo02Koool00`0003?o03?o000:<ol000<0003oooooool0N_ooo`00?ooo
o`80I_l/oooo00<0I_ooooooool09_ooo`030000<ol0<ol000Xco`000`000?ooooooo`1joooo0011
oooo00<0I_ooooooool0:Oooo`0306Kooooooooo02Ooool00`0003?o03?o0009<ol000<0003ooooo
ool0N_ooo`00@Oooo`0306Kooooooooo02Woool00`1Vooooooooo`0Woooo00<0000co`0co`002C?o
00030000oooooooo07[oool004;oool00`1Vooooooooo`0Uoooo101Vob[oool00`0003?o03?o0008
<ol00P0007_oool004;oool00`1Vooooooooo`0Ooooo1P1Vo`?oool00ol0VOooooooo`0Xoooo00<0
000co`0co`0023?o00030000oooooooo07[oool004?oool00`1Vooooooooo`0Eoooo2@1Vo`Woool0
0ol0VOooooooo`0Xoooo00<0000co`0co`0023?o00030000oooooooo07[oool004CooolG06Ko4_oo
o`03o`2Ioooooooo02Woool00`0003?o03?o0007<ol000<0003oooooool0N_ooo`00KOooo`03o`2I
oooooooo02Woool00`0003?o03?o0007<ol000<0003oooooool0N_ooo`00KOooo`03o`2Ioooooooo
02Woool00`0003?o03?o0007<ol000<0003oooooool0N_ooo`00KOooo`03o`2Ioooooooo02Woool0
0`0003?o03?o0007<ol00P0007_oool006goool00ol0VOooooooo`0Zoooo00<0000co`0co`001S?o
00030000oooooooo07[oool006goool00ol0VOooooooo`0Zoooo00<0000co`0co`001S?o00030000
oooooooo07[oool006goool00ol0VOooooooo`0Zoooo00<0000co`0co`001S?o00030000oooooooo
07[oool006goool00ol0VOooooooo`0Zoooo00<0000co`0co`001S?o00030000oooooooo07[oool0
06goool00ol0VOooooooo`0[oooo1@0000<co`000`000?ooooooo`1joooo001]oooo00?o09Wooooo
ool0:oooo`030000<ol0000000Dco`000`000?ooooooo`1joooo001]oooo00?o09Woooooool0:ooo
o`030000<ol0000000Dco`030000N_ooo`00KOooo`03o`2Ioooooooo02coool200001C?o00030000
oooooooo07[oool006goool00ol0VOooooooo`0/oooo0P0000Dco`000`000?ooooooo`1joooo001]
oooo00?o09Woooooool0;?ooo`800005<ol000<0003oooooool0N_ooo`00KOooo`03o`2Ioooooooo
02coool00`0003?o03?o0004<ol000<0003oooooool0N_ooo`00KOooo`03o`2Ioooooooo02coool0
0`0003?o03?o0004<ol000<0003oooooool0N_ooo`00KOooo`03o`2Ioooooooo02coool00`0003?o
03?o0004<ol00P0007_oool006goool00ol0VOooooooo`0]oooo00<0000co`0co`000c?o00030000
oooooooo07[oool006goool00ol0VOooooooo`0]oooo00<0000co`0co`000c?o00030000oooooooo
07[oool006goool00ol0VOooooooo`0]oooo00<0000co`0co`000c?o00030000oooooooo07[oool0
06goool00ol0VOooooooo`0]oooo00<0000co`0co`000c?o00030000oooooooo07[oool006goool0
0ol0VOooooooo`0]oooo00<0000co`0co`000c?o00030000oooooooo07[oool006goool00ol0VOoo
ooooo`0]oooo00<0000co`0co`000c?o0080001koooo001]oooo00?o09Woooooool0;Oooo`030000
<ol0<ol000<co`000`000?ooooooo`1joooo001]oooo00?o09Woooooool0;Oooo`030000<ol0<ol0
00<co`000`000?ooooooo`1joooo001]oooo00?o09Woooooool0;_ooo`030000<ol0<ol0008co`00
0`000?ooooooo`1joooo001]oooo00?o09Woooooool0;_ooo`030000<ol0<ol0008co`000`000?oo
ooooo`1joooo001]oooo00?o09Woooooool0;_ooo`030000<ol0<ol0008co`000`000?ooooooo`1j
oooo001]oooo00?o09Woooooool0;_ooo`030000<ol0<ol0008co`000`000?ooooooo`1joooo001]
oooo00?o09Woooooool0;_ooo`030000<ol0<ol0008co`020000Noooo`00KOooo`03o`2Ioooooooo
02koool00`0003?o03?o0002<ol000<0003oooooool0N_ooo`00KOooo`03o`2Ioooooooo02koool0
0`0003?o03?o0002<ol000<0003oooooool0N_ooo`00KOooo`03o`2Ioooooooo02koool00`0003?o
03?o0002<ol000<0003oooooool0N_ooo`00KOooo`03o`2Ioooooooo02koool00`0003?o03?o0002
<ol000<0003oooooool0N_ooo`00KOooo`03o`2Ioooooooo02koool00`0003?o03?o0002<ol000<0
003oooooool0N_ooo`00KOooo`03o`2Ioooooooo02koool00`0003?o03?o0002<ol00P0007_oool0
06goool00ol0VOooooooo`0_oooo00D0000co`0co`0co`000000O?ooo`00KOooo`03o`2Ioooooooo
02ooool01@0003?o03?o03?o0000001loooo001]oooo00?o09Woooooool0;oooo`050000<ol0<ol0
<ol0000007coool006goool00ol0VOooooooo`0[oooo1@0000<co`000`000?ooooooo`1joooo001]
oooo00?o09Woooooool0:oooo`050000oooooooooooo000000<co`000`000?ooooooo`1joooo001]
oooo00?o09Woooooool0;?ooo`040000oooooooo00000c?o00<0001joooo001]oooo00?o09Wooooo
ool0;Oooo`030000oooo000000<co`000`000?ooooooo`1joooo001]oooo00?o09Woooooool0:ooo
o`030000oooooooo00800003<ol000<0003oooooool0N_ooo`00KOooo`03o`2Ioooooooo02coool2
000000?oool0000co`000S?o00030000oooooooo07[oool006goool00ol0VOooooooo`0_oooo00D0
000co`0co`0co`000000O?ooo`00KOooo`03o`2Ioooooooo033oool0100003?o03?o000007coool0
06goool00ol0VOooooooo`0`oooo00<0000co`0co`000P0007_oool006goool00ol0VOooooooo`0`
oooo00@0000co`0co`00001loooo001]oooo00?o09Woooooool0<?ooo`040000<ol0<ol00000O?oo
o`00KOooo`03o`2Ioooooooo033oool0100003?o03?o000007coool006goool00ol0VOooooooo`0`
oooo00@0000co`0co`00001loooo001]oooo00?o09Woooooool0<?ooo`040000<ol0<ol00000O?oo
o`00KOooo`03o`2Ioooooooo033oool0100003?o03?o000007coool006goool00ol0VOooooooo`0a
oooo00@0000co`000000001koooo001]oooo00?o09Woooooool0<Oooo`030000<ol0000007coool0
06goool00ol0VOooooooo`0aoooo00<0000co`000000O?ooo`00KOooo`03o`2Ioooooooo037oool0
0`0003?o0000001loooo001]oooo00?o09Woooooool0<Oooo`030000<ol0000007coool006goool0
0ol0VOooooooo`0aoooo00<0000co`000000O?ooo`00KOooo`03o`2Ioooooooo037oool0100003?o
0000000007_oool006goool00ol0VOooooooo`0aoooo00<0000co`000000O?ooo`00KOooo`03o`2I
oooooooo037oool00`0003?o0000001loooo001]oooo00?o09Woooooool0<Oooo`030000<ol00000
07coool006goool00ol0VOooooooo`0aoooo00<0000co`000000O?ooo`00KOooo`03o`2Ioooooooo
037oool00`0003?o0000001loooo001]oooo00?o09Woooooool0<Oooo`040000<ol000000000Nooo
o`00KOooo`03o`2Ioooooooo037oool00`0003?o0000001loooo001]oooo00?o09Woooooool0<Ooo
o`030000<ol0000007coool006goool00ol0VOooooooo`0aoooo00<0000co`000000O?ooo`00KOoo
o`03o`2Ioooooooo02coool200000oooo`030000<ol0000007coool006goool00ol0VOooooooo`0[
oooo00@0003oooooool00002oooo00<0000co`000000O?ooo`00KOooo`03o`2Ioooooooo02goool0
1P000?ooooooooooo`0003?o00<0001joooo001]oooo00?o09Woooooool0;_ooo`060000oooooooo
0000<ol00000O?ooo`00KOooo`03o`2Ioooooooo02_oool010000?ooooooo`0000;oool00`0003?o
0000001loooo001]oooo00?o09Woooooool0;?ooo`800004oooo0P0007coool006goool00ol0VOoo
ooooo`0boooo0P0007coool006goool00ol0VOooooooo`0boooo0P0007coool006goool00ol0VOoo
ooooo`0boooo0P0007coool006goool00ol0VOooooooo`0boooo0`0007_oool006goool00ol0VOoo
ooooo`0boooo0P0007coool006goool00ol0VOooooooo`0boooo0P0007coool006goool00ol0VOoo
ooooo`0boooo0P0007coool006goool00ol0VOooooooo`0boooo0P0007coool006goool00ol0VOoo
ooooo`0boooo0P0007coool006goool00ol0VOooooooo`0boooo0`0007_oool006goool00ol0VOoo
ooooo`0boooo0P0007coool006goool00ol0VOooooooo`0boooo0P0007coool006goool00ol0VOoo
ooooo`0boooo0P0007coool006goool00ol0VOooooooo`0boooo0P0007coool006goool00ol0VOoo
ooooo`0boooo0P0007coool006goool00ol0VOooooooo`0boooo0`0007_oool006goool00ol0VOoo
ooooo`0coooo00<0003oooooool0N_ooo`00KOooo`03o`2Ioooooooo03?oool00`000?ooooooo`1j
oooo001]oooo00?o09Woooooool0<oooo`030000oooooooo07[oool006goool00ol0VOooooooo`0c
oooo00<0003oooooool0N_ooo`00KOooo`03o`2Ioooooooo03?oool00`000?ooooooo`1joooo001]
oooo00?o09Woooooool0<oooo`80001koooo001]oooo00?o09Woooooool0<oooo`030000oooooooo
07[oool006goool00ol0VOooooooo`0coooo00<0003oooooool0N_ooo`00KOooo`03o`2Ioooooooo
03?oool00`000?ooooooo`1joooo001]oooo00?o09Woooooool0<oooo`030000oooooooo07[oool0
06goool00ol0VOooooooo`0]oooo0`0000?oool00`000?ooooooo`1joooo001]oooo00?o09Wooooo
ool0;_ooo`030000oooooooo00;oool00`000?ooooooo`1joooo001]oooo00?o09Woooooool0:ooo
o`D00003oooo0`0007[oool009_oool010000?ooooooo`00087oool009coool00`000?ooo`000021
oooo002Moooo0P00087oool00?oooolQoooo003ooooo8Oooo`00NOooo`030000oooooooo02Soool0
0`000?ooooooo`1ioooo001hoooo00<0003oooooool02?ooo`030000oooooooo01ooool00`000?oo
ooooo`1hoooo001hoooo00<0003oooooool00_ooo`800004oooo00<0003oooooool03Oooo`800004
oooo0P0000Goool00`000?ooooooo`02oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooo
oooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0003ooooo
ool0000:oooo00<0003oooooool00_ooo`030000oooooooo07Soool007Ooool00`000?ooooooo`02
oooo00<0003oooooool05Oooo`030000oooooooo00Woool00`000?ooooooo`03oooo00<0003ooooo
ool0Moooo`00N?ooo`030000oooooooo00D0000Eoooo00<0003oooooool02Oooo`050000oooooooo
oooo000007[oool007Soool01@000?ooooooooooo`00000Eoooo00@0003oooooool00008oooo00@0
003oooooool00003oooo00<0003oooooool0N?ooo`00NOooo`030000oooooooo01Ooool200002Ooo
o`@00002oooo00<0003oooooool0NOooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-8.12947, \
-1.14361, 0.0496935, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-8.12947, -1.14361, 0.0496935, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
.2 1 0 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.32392 .12361 L
.34309 .12361 L
.36173 .12361 L
.36626 .12361 L
.36876 .12361 L
.37114 .12361 L
.37178 .12361 L
.37247 .12361 L
s
.37247 .12361 m
.37278 .61803 L
s
0 .4 1 r
.02381 .12651 m
.04262 .12767 L
.06244 .12939 L
.07286 .13057 L
.08255 .13188 L
.09388 .13373 L
.10458 .13586 L
.125 .14123 L
.14357 .14815 L
.16355 .15864 L
.18199 .17226 L
.2023 .19349 L
.2074 .20013 L
.20991 .20363 L
.21224 .20703 L
.21333 .20866 L
.21435 .21012 L
.21552 .2101 L
.21659 .21008 L
.22134 .21 L
.23957 .20961 L
.25917 .20903 L
.26894 .20865 L
.27925 .20818 L
.29772 .20708 L
.31736 .20543 L
.3357 .20327 L
.34615 .20169 L
.35605 .1999 L
.36494 .19799 L
.36737 .19741 L
.36996 .19677 L
.37102 .1965 L
.37217 .1962 L
.37342 .12361 L
.3746 .12361 L
.37586 .12361 L
.377 .12361 L
.37832 .12361 L
.37956 .12361 L
.38071 .12361 L
.38178 .12361 L
.38294 .12361 L
.38417 .12361 L
.38542 .12361 L
.38611 .12361 L
.38675 .12361 L
.38799 .12361 L
.38916 .12361 L
.39182 .12361 L
Mistroke
.39252 .12361 L
.39327 .12361 L
.39399 .12361 L
.39464 .12361 L
.39528 .12361 L
.39598 .12361 L
.39671 .12361 L
.39739 .12361 L
.3986 .12361 L
.39988 .12361 L
.40119 .12361 L
.40242 .12361 L
.40353 .12361 L
.40474 .12361 L
.40606 .12361 L
.40681 .12361 L
.40751 .12361 L
.40825 .12361 L
.40893 .12361 L
.40968 .12361 L
.41046 .12361 L
.41168 .12361 L
.41298 .12361 L
.41373 .12361 L
.41441 .12361 L
.4151 .12361 L
.41574 .12361 L
.4169 .12361 L
.41814 .12361 L
.41932 .12361 L
.42039 .12361 L
.42164 .12361 L
.42235 .12361 L
.42301 .12361 L
.42421 .12361 L
.42549 .12361 L
.42671 .12361 L
.42802 .12361 L
.42925 .12361 L
.43039 .12361 L
.43165 .12361 L
.43236 .12361 L
.43302 .12361 L
.43372 .12361 L
.43436 .12361 L
.4351 .12361 L
.4358 .12361 L
.43686 .12361 L
.43803 .12361 L
.43926 .12361 L
Mistroke
.4404 .12361 L
.44147 .12361 L
.44245 .12361 L
.44358 .12361 L
.44465 .12361 L
.44581 .12361 L
.44704 .12361 L
.4482 .12361 L
.44925 .12361 L
.45049 .12361 L
.45119 .12361 L
.45183 .12361 L
.45301 .12361 L
.45426 .12361 L
.45548 .12361 L
.45617 .12361 L
.45681 .12361 L
.45798 .12361 L
.45923 .12361 L
.46034 .12361 L
.46138 .12361 L
.46252 .12361 L
.46375 .12361 L
.46498 .12361 L
.46568 .12361 L
.46633 .12361 L
.46765 .12361 L
.46839 .12361 L
.46905 .12361 L
.47025 .12361 L
.47156 .12361 L
.47278 .12361 L
.47392 .12361 L
.47497 .12361 L
.47611 .12361 L
.47718 .12361 L
.47816 .12361 L
.47931 .12361 L
.48055 .12361 L
.48173 .12361 L
.48283 .12361 L
.48406 .12361 L
.48522 .12361 L
.48627 .12361 L
.48739 .12361 L
.48863 .12361 L
.48993 .12361 L
.49104 .12361 L
.49225 .12361 L
.49346 .12361 L
Mistroke
.49459 .12361 L
.49577 .12361 L
.49707 .12361 L
.49839 .12361 L
.49912 .12361 L
.4998 .12361 L
.50108 .12361 L
.50231 .12361 L
.50345 .12361 L
.50467 .12361 L
.50581 .12361 L
.50685 .12361 L
.50808 .12361 L
.50877 .12361 L
.50941 .12361 L
.51058 .12361 L
.51182 .12361 L
.51312 .12361 L
.51385 .12361 L
.51452 .12361 L
.51581 .12361 L
.51704 .12361 L
.51773 .12361 L
.51847 .12361 L
.51979 .12361 L
.52052 .12361 L
.52121 .12361 L
.52196 .12361 L
.52278 .12361 L
.52399 .12361 L
.52468 .12361 L
.52531 .12361 L
.52598 .12361 L
.52669 .12361 L
.52798 .12361 L
.52916 .12361 L
.53043 .12361 L
.53164 .12361 L
.53275 .12361 L
.534 .12361 L
.53519 .12361 L
.53626 .12361 L
.53742 .12361 L
.53868 .12361 L
.53939 .12361 L
.54002 .12361 L
.54127 .12361 L
.54244 .12361 L
.54354 .12361 L
.54471 .12361 L
Mistroke
.5457 .12361 L
.5468 .12361 L
.54797 .12361 L
.54923 .12361 L
.55042 .12361 L
.5515 .12361 L
.55279 .12361 L
.55343 .12361 L
.55415 .12361 L
.5554 .12361 L
.55659 .12361 L
.55726 .12361 L
.55797 .12361 L
.55924 .12361 L
.55995 .12361 L
.56061 .12361 L
.56134 .12361 L
.56211 .12361 L
.56341 .12361 L
.56414 .12361 L
.56481 .12361 L
.56605 .12361 L
.56737 .12361 L
.56854 .12361 L
.56964 .12361 L
.57085 .12361 L
.57214 .12361 L
.57335 .12361 L
.57405 .12361 L
.57469 .12361 L
.576 .12361 L
.57667 .12361 L
.57741 .12361 L
.57865 .12361 L
.57996 .12361 L
.58117 .12361 L
.58229 .12361 L
.59335 .12361 L
.61346 .12361 L
.65246 .12361 L
.69391 .12361 L
.73385 .12361 L
.77227 .12361 L
.81314 .12361 L
.8525 .12361 L
.89035 .12361 L
.93064 .12361 L
.96942 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Koooo1@00083oool009goool00`000?ooooooo`20oooo002Moooo00<0003ooooo
ool00oooo`<0001joooo002Eoooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0N_oo
o`00WOooo`030000oooooooo00?oool00`000?ooooooo`1joooo002Loooo0P0000Goool00`000?oo
ooooo`1joooo002Soooo00<0003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool2
0000Noooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0
003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002S
oooo00<0003oooooool0N_ooo`00Xoooo`80001koooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool00:?oool20000Noooo`00:oooo`<0000Xoooo0`0002?oool4
00008oooo`030000oooooooo02?oool400009oooo`<0000Yoooo000[oooo00@0003oooooool0000X
oooo00<0003oooooool08_ooo`030000oooooooo02Coool00`000?ooooooo`0Soooo00<0003ooooo
ool0:Oooo`030000oooooooo02Soool002_oool010000?ooooooo`0002Goool500009?ooo`030000
oooooooo02?oool00`000?ooooooo`0Toooo00<0003oooooool09Oooo`D0000Yoooo000Uoooo1000
00;oool300008?ooo`@00002oooo00@0003oooooool0000Noooo100000Coool00`000?ooooooo`0R
oooo00<0003oooooool09Oooo`030000oooooooo02Coool010000?ooooooo`0002[oool002coool0
0`000?ooooooo`0Voooo00<0003oool000009?ooo`040000oooooooo00008oooo`030000oooooooo
02?oool010000?ooooooo`0002Koool00`000?ooo`00000Zoooo000/oooo0`0002Ooool200009Ooo
o`80000Toooo0P0002Goool20000:?ooo`80000Zoooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool0013ooooo00004Oooo`005_ooo`03000006Ko06Ko00D0I_l2
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool02?ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Goool0101Vooooo`000?oooa4000000c?o000003?o0008<ol000<0000co`0co`001c?o
00030000<ol0<ol000Lco`000`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo
00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?oo
ooooo`08oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0
003oooooool05Oooo`007_ooo`H0I_l6oooo00<0003oooooool09_ooo`030000oooooooo01Woool0
0`1Vooooooooo`09oooo00<0003oooooool01_ooo`@0000K<ol000<0003oooooool09Oooo`030000
oooooooo02Koool00`000?ooooooo`0Yoooo000Toooo1P1VodGoool00`1Vooooooooo`0Foooo1000
01Lco`000`000?ooooooo`1joooo000Zoooo101Vod7oool00`1Vooooooooo`0Joooo00<0000co`0c
o`0053?o00030000oooooooo07[oool002koool406Ko?Oooo`0306Kooooooooo01_oool2000053?o
00030000oooooooo07[oool003;oool206Ko>oooo`0306Kooooooooo01goool00`0003?o03?o000A
<ol000<0003oooooool0N_ooo`00=?ooo`<0I_lhoooo00<0I_ooooooool07_ooo`030000<ol0<ol0
010co`020000Noooo`00=oooo`80I_lfoooo00<0I_ooooooool07oooo`80000@<ol000<0003ooooo
ool0N_ooo`00>Oooo`80I_ldoooo00<0I_ooooooool08Oooo`030000<ol0<ol000dco`000`000?oo
ooooo`1joooo000koooo00<0I_ooooooool0<Oooo`0306Kooooooooo027oool00`0003?o03?o000=
<ol000<0003oooooool0N_ooo`00??ooo`0306Kooooooooo033oool00`1Vooooooooo`0Roooo00<0
000co`0co`0033?o00030000oooooooo07[oool003goool00`1Vooooooooo`0_oooo00<0I_oooooo
ool08_ooo`030000<ol0<ol000`co`000`000?ooooooo`1joooo000noooo00<0I_ooooooool0;_oo
o`0306Kooooooooo02?oool00`0003?o03?o000;<ol00P0007_oool003ooool00`1Vooooooooo`0]
oooo00<0I_ooooooool08oooo`030000<ol0<ol000/co`000`000?ooooooo`1joooo0010oooo00<0
I_ooooooool0;?ooo`0306Kooooooooo02Coool00`0003?o03?o000:<ol000<0003oooooool0N_oo
o`00@Oooo`0306Kooooooooo02_oool00`1Vooooooooo`0Toooo00<0000co`0co`002S?o00030000
oooooooo07[oool004;oool00`1Vooooooooo`0Zoooo00<0I_ooooooool09Oooo`030000<ol0<ol0
00Tco`000`000?ooooooo`1joooo0013oooo00<0I_ooooooool0:Oooo`0306Kooooooooo02Goool0
0`0003?o03?o0009<ol000<0003oooooool0N_ooo`00A?ooo`0306Kooooooooo02Goool406Ko:?oo
o`030000<ol0<ol000Pco`020000Noooo`00AOooo`0306Kooooooooo01ooool506Ko0oooo`03o`2I
oooooooo02Koool00`0003?o03?o0008<ol000<0003oooooool0N_ooo`00AOooo`0306Kooooooooo
01Ooool806Ko2?ooo`03o`2Ioooooooo02Koool00`0003?o03?o0008<ol000<0003oooooool0N_oo
o`00A_oooaT0I_l@oooo00?o09Woooooool09oooo`030000<ol0<ol000Lco`000`000?ooooooo`1j
oooo001_oooo00?o09Woooooool09oooo`030000<ol0<ol000Lco`000`000?ooooooo`1joooo001_
oooo00?o09Woooooool09oooo`030000<ol0<ol000Lco`000`000?ooooooo`1joooo001_oooo00?o
09Woooooool09oooo`030000<ol0<ol000Lco`020000Noooo`00Koooo`03o`2Ioooooooo02Soool0
0`0003?o03?o0006<ol000<0003oooooool0N_ooo`00Koooo`03o`2Ioooooooo02Soool00`0003?o
03?o0006<ol000<0003oooooool0N_ooo`00Koooo`03o`2Ioooooooo02Soool00`0003?o03?o0006
<ol000<0003oooooool0N_ooo`00Koooo`03o`2Ioooooooo02Soool00`0003?o03?o0006<ol000<0
003oooooool0N_ooo`00Koooo`03o`2Ioooooooo02Woool500000c?o00030000oooooooo07[oool0
06ooool00ol0VOooooooo`0Yoooo00<0000co`0000001C?o00030000oooooooo07[oool006ooool0
0ol0VOooooooo`0Yoooo00<0000co`0000001C?o00<0001joooo001_oooo00?o09Woooooool0:_oo
o`800005<ol000<0003oooooool0N_ooo`00Koooo`03o`2Ioooooooo02[oool200001C?o00030000
oooooooo07[oool006ooool00ol0VOooooooo`0Zoooo0P0000Dco`000`000?ooooooo`1joooo001_
oooo00?o09Woooooool0:_ooo`030000<ol0<ol000@co`000`000?ooooooo`1joooo001_oooo00?o
09Woooooool0:_ooo`030000<ol0<ol000@co`000`000?ooooooo`1joooo001_oooo00?o09Wooooo
ool0:_ooo`030000<ol0<ol000@co`020000Noooo`00Koooo`03o`2Ioooooooo02_oool00`0003?o
03?o0003<ol000<0003oooooool0N_ooo`00Koooo`03o`2Ioooooooo02_oool00`0003?o03?o0003
<ol000<0003oooooool0N_ooo`00Koooo`03o`2Ioooooooo02_oool00`0003?o03?o0003<ol000<0
003oooooool0N_ooo`00Koooo`03o`2Ioooooooo02_oool00`0003?o03?o0003<ol000<0003ooooo
ool0N_ooo`00Koooo`03o`2Ioooooooo02_oool00`0003?o03?o0003<ol000<0003oooooool0N_oo
o`00Koooo`03o`2Ioooooooo02_oool00`0003?o03?o0003<ol00P0007_oool006ooool00ol0VOoo
ooooo`0[oooo00<0000co`0co`000c?o00030000oooooooo07[oool006ooool00ol0VOooooooo`0[
oooo00<0000co`0co`000c?o00030000oooooooo07[oool006ooool00ol0VOooooooo`0/oooo00<0
000co`0co`000S?o00030000oooooooo07[oool006ooool00ol0VOooooooo`0/oooo00<0000co`0c
o`000S?o00030000oooooooo07[oool006ooool00ol0VOooooooo`0/oooo00<0000co`0co`000S?o
00030000oooooooo07[oool006ooool00ol0VOooooooo`0/oooo00<0000co`0co`000S?o00030000
oooooooo07[oool006ooool00ol0VOooooooo`0/oooo00<0000co`0co`000S?o0080001koooo001_
oooo00?o09Woooooool0;?ooo`030000<ol0<ol0008co`000`000?ooooooo`1joooo001_oooo00?o
09Woooooool0;?ooo`030000<ol0<ol0008co`000`000?ooooooo`1joooo001_oooo00?o09Wooooo
ool0;?ooo`030000<ol0<ol0008co`000`000?ooooooo`1joooo001_oooo00?o09Woooooool0;?oo
o`030000<ol0<ol0008co`000`000?ooooooo`1joooo001_oooo00?o09Woooooool0;?ooo`030000
<ol0<ol0008co`000`000?ooooooo`1joooo001_oooo00?o09Woooooool0;?ooo`030000<ol0<ol0
008co`020000Noooo`00Koooo`03o`2Ioooooooo02goool01@0003?o03?o03?o0000001loooo001_
oooo00?o09Woooooool0;Oooo`050000<ol0<ol0<ol0000007coool006ooool00ol0VOooooooo`0]
oooo00D0000co`0co`0co`000000O?ooo`00Koooo`03o`2Ioooooooo02Woool500000c?o00030000
oooooooo07[oool006ooool00ol0VOooooooo`0Yoooo00D0003oooooooooool000000c?o00030000
oooooooo07[oool006ooool00ol0VOooooooo`0Zoooo00@0003oooooool00003<ol00`0007[oool0
06ooool00ol0VOooooooo`0[oooo00<0003oool000000c?o00030000oooooooo07[oool006ooool0
0ol0VOooooooo`0Yoooo00<0003oooooool00P0000<co`000`000?ooooooo`1joooo001_oooo00?o
09Woooooool0:_ooo`8000000oooo`0003?o0002<ol000<0003oooooool0N_ooo`00Koooo`03o`2I
oooooooo02goool01@0003?o03?o03?o0000001loooo001_oooo00?o09Woooooool0;_ooo`040000
<ol0<ol00000O?ooo`00Koooo`03o`2Ioooooooo02koool00`0003?o03?o00020000Noooo`00Kooo
o`03o`2Ioooooooo02koool0100003?o03?o000007coool006ooool00ol0VOooooooo`0^oooo00@0
000co`0co`00001loooo001_oooo00?o09Woooooool0;_ooo`040000<ol0<ol00000O?ooo`00Kooo
o`03o`2Ioooooooo02koool0100003?o03?o000007coool006ooool00ol0VOooooooo`0^oooo00@0
000co`0co`00001loooo001_oooo00?o09Woooooool0;_ooo`040000<ol0<ol00000O?ooo`00Kooo
o`03o`2Ioooooooo02ooool0100003?o0000000007_oool006ooool00ol0VOooooooo`0_oooo00<0
000co`000000O?ooo`00Koooo`03o`2Ioooooooo02ooool00`0003?o0000001loooo001_oooo00?o
09Woooooool0;oooo`030000<ol0000007coool006ooool00ol0VOooooooo`0_oooo00<0000co`00
0000O?ooo`00Koooo`03o`2Ioooooooo02ooool00`0003?o0000001loooo001_oooo00?o09Wooooo
ool0;oooo`040000<ol000000000Noooo`00Koooo`03o`2Ioooooooo02ooool00`0003?o0000001l
oooo001_oooo00?o09Woooooool0;oooo`030000<ol0000007coool006ooool00ol0VOooooooo`0_
oooo00<0000co`000000O?ooo`00Koooo`03o`2Ioooooooo02ooool00`0003?o0000001loooo001_
oooo00?o09Woooooool0;oooo`030000<ol0000007coool006ooool00ol0VOooooooo`0_oooo00@0
000co`000000001koooo001_oooo00?o09Woooooool0;oooo`030000<ol0000007coool006ooool0
0ol0VOooooooo`0_oooo00<0000co`000000O?ooo`00Koooo`03o`2Ioooooooo02ooool00`0003?o
0000001loooo001_oooo00?o09Woooooool0:_ooo`800003oooo00<0000co`000000O?ooo`00Kooo
o`03o`2Ioooooooo02Woool010000?ooooooo`0000;oool00`0003?o0000001loooo001_oooo00?o
09Woooooool0:oooo`060000oooooooooooo0000<ol00`0007[oool006ooool00ol0VOooooooo`0/
oooo00H0003oooooool0000co`00001loooo001_oooo00?o09Woooooool0:Oooo`040000oooooooo
00000_ooo`030000<ol0000007coool006ooool00ol0VOooooooo`0Zoooo0P0000Coool20000O?oo
o`00Koooo`03o`2Ioooooooo033oool20000O?ooo`00Koooo`03o`2Ioooooooo033oool20000O?oo
o`00Koooo`03o`2Ioooooooo033oool20000O?ooo`00Koooo`03o`2Ioooooooo033oool30000Nooo
o`00Koooo`03o`2Ioooooooo033oool20000O?ooo`00Koooo`03o`2Ioooooooo033oool20000O?oo
o`00Koooo`03o`2Ioooooooo033oool20000O?ooo`00Koooo`03o`2Ioooooooo033oool20000O?oo
o`00Koooo`03o`2Ioooooooo033oool20000O?ooo`00Koooo`03o`2Ioooooooo033oool30000Nooo
o`00Koooo`03o`2Ioooooooo033oool20000O?ooo`00Koooo`03o`2Ioooooooo033oool20000O?oo
o`00Koooo`03o`2Ioooooooo033oool20000O?ooo`00Koooo`03o`2Ioooooooo033oool20000O?oo
o`00Koooo`03o`2Ioooooooo033oool20000O?ooo`00Koooo`03o`2Ioooooooo033oool30000Nooo
o`00Koooo`03o`2Ioooooooo037oool00`000?ooooooo`1joooo001_oooo00?o09Woooooool0<Ooo
o`030000oooooooo07[oool006ooool00ol0VOooooooo`0aoooo00<0003oooooool0N_ooo`00Kooo
o`03o`2Ioooooooo037oool00`000?ooooooo`1joooo001_oooo00?o09Woooooool0<Oooo`030000
oooooooo07[oool006ooool00ol0VOooooooo`0aoooo0P0007_oool006ooool00ol0VOooooooo`0a
oooo00<0003oooooool0N_ooo`00Koooo`03o`2Ioooooooo037oool00`000?ooooooo`1joooo001_
oooo00?o09Woooooool0<Oooo`030000oooooooo07[oool006ooool00ol0VOooooooo`0aoooo00<0
003oooooool0N_ooo`00Koooo`03o`2Ioooooooo02_oool300000oooo`030000oooooooo07[oool0
06ooool00ol0VOooooooo`0/oooo00<0003oooooool00_ooo`030000oooooooo07[oool006ooool0
0ol0VOooooooo`0Yoooo1@0000?oool30000N_ooo`00Voooo`040000oooooooo0000POooo`00W?oo
o`030000oooo0000087oool009goool20000POooo`00ooooob7oool00?oooolQoooo001ioooo00<0
003oooooool0:?ooo`030000oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003ooooo
ool07oooo`030000oooooooo07Soool007Soool00`000?ooooooo`02oooo0P0000Coool00`000?oo
ooooo`0=oooo0P0000Coool200000oooo`<00004oooo00<0003oooooool0N?ooo`00N?ooo`050000
oooooooooooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01?ooo`@00003oooo00@0
003oooooool00008oooo00@0003oooooool00003oooo00<0003oooooool0N?ooo`00Moooo`030000
oooooooo00;oool00`000?ooooooo`0Eoooo00<0003oooooool01oooo`040000oooooooo00001?oo
o`030000oooooooo07Ooool007Soool00`000?ooooooo`0500005Oooo`030000oooooooo00Koool3
00001?ooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`00000Eoooo00@0003ooooo
ool00009oooo00<0003oooooool00oooo`030000oooooooo07Soool007Woool00`000?ooooooo`0G
oooo0P0000[oool300000_ooo`030000oooooooo07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-8.12947, \
-1.14361, 0.0496935, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-8.12947, -1.14361, 0.0496935, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
.2 1 0 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.32392 .12361 L
.34309 .12361 L
.36173 .12361 L
.37114 .12361 L
.37372 .12361 L
.37649 .12361 L
.37783 .12361 L
.3791 .12361 L
.38025 .12361 L
s
.38025 .12361 m
.38075 .61803 L
s
0 .4 1 r
.02381 .12613 m
.04262 .12713 L
.06244 .12863 L
.07286 .12965 L
.08255 .13079 L
.09388 .13239 L
.10458 .13424 L
.125 .13891 L
.14357 .14491 L
.16355 .15402 L
.18199 .16585 L
.20071 .18258 L
.21136 .1949 L
.21653 .20178 L
.21905 .20537 L
.22134 .20877 L
.22257 .21011 L
.22374 .21009 L
.2263 .21005 L
.23172 .20996 L
.24158 .20975 L
.26011 .20926 L
.28019 .20851 L
.29866 .20753 L
.31748 .20615 L
.32817 .20513 L
.33815 .20399 L
.3585 .20092 L
.3675 .19917 L
.37243 .19808 L
.37706 .19697 L
.37932 .19639 L
.3806 .19606 L
.38177 .12361 L
.38298 .12361 L
.38366 .12361 L
.3843 .12361 L
.38559 .12361 L
.38631 .12361 L
.38697 .12361 L
.38815 .12361 L
.38923 .12361 L
.39043 .12361 L
.39169 .12361 L
.39278 .12361 L
.39381 .12361 L
.39493 .12361 L
.39614 .12361 L
.39681 .12361 L
.39752 .12361 L
Mistroke
.3988 .12361 L
.39959 .12361 L
.40033 .12361 L
.40099 .12361 L
.40171 .12361 L
.40235 .12361 L
.40305 .12361 L
.40378 .12361 L
.40446 .12361 L
.40568 .12361 L
.40699 .12361 L
.40827 .12361 L
.40899 .12361 L
.40966 .12361 L
.41088 .12361 L
.41218 .12361 L
.41334 .12361 L
.41442 .12361 L
.41562 .12361 L
.4169 .12361 L
.41816 .12361 L
.41931 .12361 L
.42063 .12361 L
.42188 .12361 L
.42295 .12361 L
.4241 .12361 L
.42535 .12361 L
.4265 .12361 L
.42774 .12361 L
.42844 .12361 L
.42908 .12361 L
.43032 .12361 L
.43149 .12361 L
.43215 .12361 L
.43286 .12361 L
.43412 .12361 L
.43482 .12361 L
.43548 .12361 L
.4362 .12361 L
.43698 .12361 L
.43762 .12361 L
.43831 .12361 L
.43954 .12361 L
.44029 .12361 L
.44101 .12361 L
.44165 .12361 L
.44234 .12361 L
.44302 .12361 L
.44377 .12361 L
.44455 .12361 L
Mistroke
.44528 .12361 L
.44659 .12361 L
.44732 .12361 L
.44799 .12361 L
.44928 .12361 L
.45047 .12361 L
.45178 .12361 L
.45251 .12361 L
.45317 .12361 L
.45439 .12361 L
.45571 .12361 L
.45695 .12361 L
.45809 .12361 L
.45936 .12361 L
.46056 .12361 L
.46163 .12361 L
.4628 .12361 L
.46407 .12361 L
.46471 .12361 L
.46542 .12361 L
.46667 .12361 L
.46784 .12361 L
.46895 .12361 L
.47012 .12361 L
.47112 .12361 L
.47222 .12361 L
.4734 .12361 L
.47466 .12361 L
.47585 .12361 L
.47693 .12361 L
.47822 .12361 L
.47887 .12361 L
.47959 .12361 L
.48085 .12361 L
.48204 .12361 L
.48275 .12361 L
.48343 .12361 L
.4847 .12361 L
.48541 .12361 L
.48607 .12361 L
.4868 .12361 L
.48757 .12361 L
.48887 .12361 L
.48961 .12361 L
.49028 .12361 L
.49152 .12361 L
.49283 .12361 L
.49401 .12361 L
.49511 .12361 L
.49631 .12361 L
Mistroke
.4976 .12361 L
.49883 .12361 L
.49952 .12361 L
.50018 .12361 L
.50149 .12361 L
.50223 .12361 L
.50291 .12361 L
.50411 .12361 L
.50542 .12361 L
.50666 .12361 L
.50781 .12361 L
.50851 .12361 L
.50926 .12361 L
.50997 .12361 L
.51062 .12361 L
.51186 .12361 L
.51318 .12361 L
.51386 .12361 L
.51459 .12361 L
.5159 .12361 L
.51671 .12361 L
.51747 .12361 L
.51815 .12361 L
.5189 .12361 L
.52014 .12361 L
.52131 .12361 L
.52259 .12361 L
.52331 .12361 L
.52397 .12361 L
.52522 .12361 L
.52593 .12361 L
.52659 .12361 L
.52729 .12361 L
.52793 .12361 L
.52866 .12361 L
.52936 .12361 L
.53053 .12361 L
.53177 .12361 L
.53283 .12361 L
.534 .12361 L
.53525 .12361 L
.53596 .12361 L
.5366 .12361 L
.53785 .12361 L
.53903 .12361 L
.54028 .12361 L
.54099 .12361 L
.54163 .12361 L
.54282 .12361 L
.54407 .12361 L
Mistroke
.5452 .12361 L
.54625 .12361 L
.54741 .12361 L
.54864 .12361 L
.54996 .12361 L
.5507 .12361 L
.55139 .12361 L
.55265 .12361 L
.5533 .12361 L
.55399 .12361 L
.55519 .12361 L
.55631 .12361 L
.55696 .12361 L
.55765 .12361 L
.55887 .12361 L
.56003 .12361 L
.56107 .12361 L
.56228 .12361 L
.56343 .12361 L
.56448 .12361 L
.56546 .12361 L
.56653 .12361 L
.56766 .12361 L
.56879 .12361 L
.56987 .12361 L
.57111 .12361 L
.57224 .12361 L
.57348 .12361 L
.57419 .12361 L
.57484 .12361 L
.57601 .12361 L
.57727 .12361 L
.5784 .12361 L
.57964 .12361 L
.58094 .12361 L
.58214 .12361 L
.58662 .12361 L
.5967 .12361 L
.61497 .12361 L
.65397 .12361 L
.69543 .12361 L
.73536 .12361 L
.77379 .12361 L
.81466 .12361 L
.85402 .12361 L
.89186 .12361 L
.93216 .12361 L
.97094 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Koooo1@00083oool009goool00`000?ooooooo`20oooo002Moooo00<0003ooooo
ool00oooo`<0001joooo002Eoooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0N_oo
o`00WOooo`030000oooooooo00?oool00`000?ooooooo`1joooo002Loooo0P0000Goool00`000?oo
ooooo`1joooo002Soooo00<0003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool2
0000Noooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0
003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002S
oooo00<0003oooooool0N_ooo`00Xoooo`80001koooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool00:?oool20000Noooo`00:oooo`<0000Xoooo0`0002?oool4
00008oooo`030000oooooooo02?oool400009oooo`<0000Yoooo000[oooo00@0003oooooool0000X
oooo00<0003oooooool08_ooo`030000oooooooo02Coool00`000?ooooooo`0Soooo00<0003ooooo
ool0:Oooo`030000oooooooo02Soool002_oool010000?ooooooo`0002Goool500009?ooo`030000
oooooooo02?oool00`000?ooooooo`0Toooo00<0003oooooool09Oooo`D0000Yoooo000Uoooo1000
00;oool300008?ooo`@00002oooo00@0003oooooool0000Noooo100000Coool00`000?ooooooo`0R
oooo00<0003oooooool09Oooo`030000oooooooo02Coool010000?ooooooo`0002[oool002coool0
0`000?ooooooo`0Voooo00<0003oool000009?ooo`040000oooooooo00008oooo`030000oooooooo
02?oool010000?ooooooo`0002Koool00`000?ooo`00000Zoooo000/oooo0`0002Ooool200009Ooo
o`80000Toooo0P0002Goool20000:?ooo`80000Zoooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool0013ooooo00004Oooo`005_ooo`03000006Ko06Ko00D0I_l2
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool02?ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Ooool00`000?ooo`00000@000000<co`00000co`0023?o00030000<ol0<ol000Lco`00
0`0003?o03?o0007<ol000<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool02?ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo01Goool001koool906Ko0oooo`030000oooooooo02Koool00`000?ooooooo`0Koooo00<0
I_ooooooool01oooo`030000oooooooo00Koool400006c?o00030000oooooooo02Goool00`000?oo
ooooo`0Voooo00<0003oooooool0:Oooo`009oooo`L0I_m3oooo00<0I_ooooooool05?ooo`@0000G
<ol000<0003oooooool0N_ooo`00;_ooo`@0I_looooo00<0I_ooooooool06?ooo`030000<ol0<ol0
01@co`000`000?ooooooo`1joooo000boooo0P1Vocgoool00`1Vooooooooo`0Ioooo0P0001@co`00
0`000?ooooooo`1joooo000doooo0`1Voc[oool00`1Vooooooooo`0Koooo00<0000co`0co`004C?o
00030000oooooooo07[oool003Ooool206Ko>?ooo`0306Kooooooooo01coool00`0003?o03?o000@
<ol00P0007_oool003Woool206Ko=_ooo`0306Kooooooooo01goool2000043?o00030000oooooooo
07[oool003_oool00`1Vooooooooo`0coooo00<0I_ooooooool07oooo`030000<ol0<ol000dco`00
0`000?ooooooo`1joooo000loooo0P1Voc?oool00`1Vooooooooo`0Ooooo00<0000co`0co`003C?o
00030000oooooooo07[oool003koool00`1Vooooooooo`0`oooo00<0I_ooooooool08?ooo`030000
<ol0<ol000`co`000`000?ooooooo`1joooo000ooooo00<0I_ooooooool0;oooo`0306Kooooooooo
023oool00`0003?o03?o000<<ol000<0003oooooool0N_ooo`00@?ooo`80I_l_oooo00<0I_oooooo
ool08Oooo`030000<ol0<ol000/co`020000Noooo`00@_ooo`0306Kooooooooo02coool00`1Voooo
ooooo`0Qoooo00<0000co`0co`002c?o00030000oooooooo07[oool004?oool00`1Vooooooooo`0[
oooo00<0I_ooooooool08_ooo`030000<ol0<ol000Xco`000`000?ooooooo`1joooo0014oooo00<0
I_ooooooool0:_ooo`0306Kooooooooo02;oool00`0003?o03?o000:<ol000<0003oooooool0N_oo
o`00AOooo`0306Kooooooooo02Woool00`1Vooooooooo`0Soooo00<0000co`0co`002C?o00030000
oooooooo07[oool004Koool00`1Vooooooooo`0Xoooo00<0I_ooooooool08oooo`030000<ol0<ol0
00Tco`000`000?ooooooo`1joooo0016oooo00<0I_ooooooool09_ooo`<0I_lVoooo00<0000co`0c
o`0023?o0080001koooo0017oooo00<0I_ooooooool07oooo`H0I_l2oooo00?o09Woooooool09?oo
o`030000<ol0<ol000Pco`000`000?ooooooo`1joooo0018oooo00<0I_ooooooool05?ooo`X0I_l8
oooo00?o09Woooooool09?ooo`030000<ol0<ol000Pco`000`000?ooooooo`1joooo0018oooo5`1V
oa;oool00ol0VOooooooo`0Uoooo00<0000co`0co`001c?o00030000oooooooo07[oool0077oool0
0ol0VOooooooo`0Uoooo00<0000co`0co`001c?o00030000oooooooo07[oool0077oool00ol0VOoo
ooooo`0Uoooo00<0000co`0co`001c?o00030000oooooooo07[oool0077oool00ol0VOooooooo`0U
oooo00<0000co`0co`001c?o0080001koooo001aoooo00?o09Woooooool09_ooo`030000<ol0<ol0
00Hco`000`000?ooooooo`1joooo001aoooo00?o09Woooooool09_ooo`030000<ol0<ol000Hco`00
0`000?ooooooo`1joooo001aoooo00?o09Woooooool09_ooo`030000<ol0<ol000Hco`000`000?oo
ooooo`1joooo001aoooo00?o09Woooooool09_ooo`030000<ol0<ol000Hco`000`000?ooooooo`1j
oooo001aoooo00?o09Woooooool09oooo`D00003<ol000<0003oooooool0N_ooo`00LOooo`03o`2I
oooooooo02Ooool00`0003?o00000005<ol000<0003oooooool0N_ooo`00LOooo`03o`2Ioooooooo
02Ooool00`0003?o00000005<ol00`0007[oool0077oool00ol0VOooooooo`0Xoooo0P0000Dco`00
0`000?ooooooo`1joooo001aoooo00?o09Woooooool0:?ooo`800005<ol000<0003oooooool0N_oo
o`00LOooo`03o`2Ioooooooo02Soool200001C?o00030000oooooooo07[oool0077oool00ol0VOoo
ooooo`0Xoooo00<0000co`0co`0013?o00030000oooooooo07[oool0077oool00ol0VOooooooo`0X
oooo00<0000co`0co`0013?o00030000oooooooo07[oool0077oool00ol0VOooooooo`0Xoooo00<0
000co`0co`0013?o0080001koooo001aoooo00?o09Woooooool0:Oooo`030000<ol0<ol000<co`00
0`000?ooooooo`1joooo001aoooo00?o09Woooooool0:Oooo`030000<ol0<ol000<co`000`000?oo
ooooo`1joooo001aoooo00?o09Woooooool0:Oooo`030000<ol0<ol000<co`000`000?ooooooo`1j
oooo001aoooo00?o09Woooooool0:Oooo`030000<ol0<ol000<co`000`000?ooooooo`1joooo001a
oooo00?o09Woooooool0:Oooo`030000<ol0<ol000<co`000`000?ooooooo`1joooo001aoooo00?o
09Woooooool0:Oooo`030000<ol0<ol000<co`020000Noooo`00LOooo`03o`2Ioooooooo02Woool0
0`0003?o03?o0003<ol000<0003oooooool0N_ooo`00LOooo`03o`2Ioooooooo02Woool00`0003?o
03?o0003<ol000<0003oooooool0N_ooo`00LOooo`03o`2Ioooooooo02[oool00`0003?o03?o0002
<ol000<0003oooooool0N_ooo`00LOooo`03o`2Ioooooooo02[oool00`0003?o03?o0002<ol000<0
003oooooool0N_ooo`00LOooo`03o`2Ioooooooo02[oool00`0003?o03?o0002<ol000<0003ooooo
ool0N_ooo`00LOooo`03o`2Ioooooooo02[oool00`0003?o03?o0002<ol000<0003oooooool0N_oo
o`00LOooo`03o`2Ioooooooo02[oool00`0003?o03?o0002<ol00P0007_oool0077oool00ol0VOoo
ooooo`0Zoooo00<0000co`0co`000S?o00030000oooooooo07[oool0077oool00ol0VOooooooo`0Z
oooo00<0000co`0co`000S?o00030000oooooooo07[oool0077oool00ol0VOooooooo`0Zoooo00<0
000co`0co`000S?o00030000oooooooo07[oool0077oool00ol0VOooooooo`0Zoooo00<0000co`0c
o`000S?o00030000oooooooo07[oool0077oool00ol0VOooooooo`0Zoooo00<0000co`0co`000S?o
00030000oooooooo07[oool0077oool00ol0VOooooooo`0Zoooo00<0000co`0co`000S?o0080001k
oooo001aoooo00?o09Woooooool0:oooo`050000<ol0<ol0<ol0000007coool0077oool00ol0VOoo
ooooo`0[oooo00D0000co`0co`0co`000000O?ooo`00LOooo`03o`2Ioooooooo02_oool01@0003?o
03?o03?o0000001loooo001aoooo00?o09Woooooool09oooo`D00003<ol000<0003oooooool0N_oo
o`00LOooo`03o`2Ioooooooo02Ooool01@000?ooooooooooo`000003<ol000<0003oooooool0N_oo
o`00LOooo`03o`2Ioooooooo02Soool010000?ooooooo`0000<co`030000N_ooo`00LOooo`03o`2I
oooooooo02Woool00`000?ooo`000003<ol000<0003oooooool0N_ooo`00LOooo`03o`2Ioooooooo
02Ooool00`000?ooooooo`0200000c?o00030000oooooooo07[oool0077oool00ol0VOooooooo`0X
oooo0P000003oooo0000<ol0008co`000`000?ooooooo`1joooo001aoooo00?o09Woooooool0:ooo
o`050000<ol0<ol0<ol0000007coool0077oool00ol0VOooooooo`0/oooo00@0000co`0co`00001l
oooo001aoooo00?o09Woooooool0;?ooo`030000<ol0<ol00080001koooo001aoooo00?o09Wooooo
ool0;?ooo`040000<ol0<ol00000O?ooo`00LOooo`03o`2Ioooooooo02coool0100003?o03?o0000
07coool0077oool00ol0VOooooooo`0/oooo00@0000co`0co`00001loooo001aoooo00?o09Wooooo
ool0;?ooo`040000<ol0<ol00000O?ooo`00LOooo`03o`2Ioooooooo02coool0100003?o03?o0000
07coool0077oool00ol0VOooooooo`0/oooo00@0000co`0co`00001loooo001aoooo00?o09Wooooo
ool0;Oooo`040000<ol000000000Noooo`00LOooo`03o`2Ioooooooo02goool00`0003?o0000001l
oooo001aoooo00?o09Woooooool0;Oooo`030000<ol0000007coool0077oool00ol0VOooooooo`0]
oooo00<0000co`000000O?ooo`00LOooo`03o`2Ioooooooo02goool00`0003?o0000001loooo001a
oooo00?o09Woooooool0;Oooo`030000<ol0000007coool0077oool00ol0VOooooooo`0]oooo00@0
000co`000000001koooo001aoooo00?o09Woooooool0;Oooo`030000<ol0000007coool0077oool0
0ol0VOooooooo`0]oooo00<0000co`000000O?ooo`00LOooo`03o`2Ioooooooo02goool00`0003?o
0000001loooo001aoooo00?o09Woooooool0;Oooo`030000<ol0000007coool0077oool00ol0VOoo
ooooo`0]oooo00<0000co`000000O?ooo`00LOooo`03o`2Ioooooooo02goool0100003?o00000000
07_oool0077oool00ol0VOooooooo`0]oooo00<0000co`000000O?ooo`00LOooo`03o`2Ioooooooo
02goool00`0003?o0000001loooo001aoooo00?o09Woooooool0;Oooo`030000<ol0000007coool0
077oool00ol0VOooooooo`0Xoooo0P0000?oool00`0003?o0000001loooo001aoooo00?o09Wooooo
ool09oooo`040000oooooooo00000_ooo`030000<ol0000007coool0077oool00ol0VOooooooo`0Y
oooo00H0003oooooooooool0000co`030000N_ooo`00LOooo`03o`2Ioooooooo02[oool01P000?oo
ooooo`0003?o000007coool0077oool00ol0VOooooooo`0Woooo00@0003oooooool00002oooo00<0
000co`000000O?ooo`00LOooo`03o`2Ioooooooo02Soool200001?ooo`80001loooo001aoooo00?o
09Woooooool0;_ooo`80001loooo001aoooo00?o09Woooooool0;_ooo`80001loooo001aoooo00?o
09Woooooool0;_ooo`80001loooo001aoooo00?o09Woooooool0;_ooo`<0001koooo001aoooo00?o
09Woooooool0;_ooo`80001loooo001aoooo00?o09Woooooool0;_ooo`80001loooo001aoooo00?o
09Woooooool0;_ooo`80001loooo001aoooo00?o09Woooooool0;_ooo`80001loooo001aoooo00?o
09Woooooool0;_ooo`80001loooo001aoooo00?o09Woooooool0;_ooo`<0001koooo001aoooo00?o
09Woooooool0;_ooo`80001loooo001aoooo00?o09Woooooool0;_ooo`80001loooo001aoooo00?o
09Woooooool0;_ooo`80001loooo001aoooo00?o09Woooooool0;_ooo`80001loooo001aoooo00?o
09Woooooool0;_ooo`80001loooo001aoooo00?o09Woooooool0;_ooo`<0001koooo001aoooo00?o
09Woooooool0;oooo`030000oooooooo07[oool0077oool00ol0VOooooooo`0_oooo00<0003ooooo
ool0N_ooo`00LOooo`03o`2Ioooooooo02ooool00`000?ooooooo`1joooo001aoooo00?o09Wooooo
ool0;oooo`030000oooooooo07[oool0077oool00ol0VOooooooo`0_oooo00<0003oooooool0N_oo
o`00LOooo`03o`2Ioooooooo02ooool20000Noooo`00LOooo`03o`2Ioooooooo02ooool00`000?oo
ooooo`1joooo001aoooo00?o09Woooooool0;oooo`030000oooooooo07[oool0077oool00ol0VOoo
ooooo`0_oooo00<0003oooooool0N_ooo`00LOooo`03o`2Ioooooooo02ooool00`000?ooooooo`1j
oooo001aoooo00?o09Woooooool0:Oooo`<00003oooo00<0003oooooool0N_ooo`00LOooo`03o`2I
oooooooo02[oool00`000?ooooooo`02oooo00<0003oooooool0N_ooo`00LOooo`03o`2Ioooooooo
02Ooool500000oooo`<0001joooo002Koooo00@0003oooooool00021oooo002Loooo00<0003oool0
0000POooo`00WOooo`800021oooo003ooooo8Oooo`00ooooob7oool007Woool00`000?ooooooo`0X
oooo00<0003oooooool0NOooo`00N?ooo`030000oooooooo00Soool00`000?ooooooo`0Ooooo00<0
003oooooool0N?ooo`00N?ooo`030000oooooooo00;oool200001?ooo`030000oooooooo00goool2
00001?ooo`800004oooo0P0000Coool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool0
00000_ooo`030000oooooooo00;oool00`000?ooooooo`04oooo100000?oool010000?ooooooo`00
00Soool010000?ooooooo`0000?oool00`000?ooooooo`1hoooo001goooo00<0003oooooool00_oo
o`030000oooooooo01Goool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`030000oooooooo
07Ooool007Soool00`000?ooooooo`0500005Oooo`030000oooooooo00Ooool200001?ooo`030000
oooooooo07Soool007Soool01@000?ooooooooooo`00000Eoooo00@0003oooooool00009oooo00<0
003oooooool00oooo`030000oooooooo07Soool007Woool00`000?ooooooo`0Goooo0P0000[oool3
00000_ooo`030000oooooooo07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-8.12947, \
-1.14361, 0.0496935, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-8.12947, -1.14361, 0.0496935, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
.2 1 0 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.36136 .12361 L
.37176 .12361 L
.37685 .12361 L
.3815 .12361 L
.38384 .12361 L
.3864 .12361 L
.38757 .12361 L
.38881 .12361 L
s
.38881 .12361 m
.38928 .61803 L
s
0 .4 1 r
.02381 .1258 m
.04262 .12667 L
.06244 .12796 L
.07286 .12885 L
.08255 .12984 L
.09388 .13123 L
.10458 .13284 L
.125 .13689 L
.14357 .1421 L
.16355 .15001 L
.18199 .16027 L
.20071 .1748 L
.21136 .18549 L
.22134 .19753 L
.2263 .20437 L
.22892 .20823 L
.22968 .20938 L
.23039 .21011 L
.23103 .2101 L
.23172 .21009 L
.23683 .21001 L
.24158 .20992 L
.26011 .20949 L
.28005 .20884 L
.29009 .20842 L
.30111 .20785 L
.32062 .20654 L
.33156 .20558 L
.34154 .20452 L
.36062 .2019 L
.37141 .19997 L
.37621 .19899 L
.38138 .19783 L
.38383 .19724 L
.3864 .1966 L
.38747 .19632 L
.3886 .19602 L
.38985 .12361 L
.39101 .12361 L
.39218 .12361 L
.39344 .12361 L
.39464 .12361 L
.39574 .12361 L
.39674 .12361 L
.39783 .12361 L
.39898 .12361 L
.40005 .12361 L
.40132 .12361 L
.40204 .12361 L
.40271 .12361 L
Mistroke
.40393 .12361 L
.40524 .12361 L
.40652 .12361 L
.40773 .12361 L
.40881 .12361 L
.40998 .12361 L
.41127 .12361 L
.412 .12361 L
.41268 .12361 L
.41341 .12361 L
.41406 .12361 L
.41482 .12361 L
.41554 .12361 L
.41681 .12361 L
.41799 .12361 L
.41928 .12361 L
.41993 .12361 L
.42065 .12361 L
.42187 .12361 L
.42301 .12361 L
.42425 .12361 L
.42495 .12361 L
.42558 .12361 L
.42686 .12361 L
.42759 .12361 L
.42825 .12361 L
.42947 .12361 L
.43077 .12361 L
.43187 .12361 L
.43305 .12361 L
.43417 .12361 L
.43518 .12361 L
.43638 .12361 L
.43767 .12361 L
.4389 .12361 L
.44003 .12361 L
.44123 .12361 L
.44251 .12361 L
.44373 .12361 L
.44484 .12361 L
.44607 .12361 L
.44677 .12361 L
.44743 .12361 L
.44874 .12361 L
.44948 .12361 L
.45015 .12361 L
.45082 .12361 L
.45153 .12361 L
.4528 .12361 L
.45351 .12361 L
Mistroke
.45417 .12361 L
.4549 .12361 L
.45568 .12361 L
.45635 .12361 L
.45708 .12361 L
.45777 .12361 L
.45841 .12361 L
.45962 .12361 L
.4609 .12361 L
.46215 .12361 L
.46285 .12361 L
.46351 .12361 L
.46421 .12361 L
.46484 .12361 L
.46557 .12361 L
.46627 .12361 L
.4675 .12361 L
.46863 .12361 L
.46988 .12361 L
.47051 .12361 L
.4712 .12361 L
.4719 .12361 L
.47264 .12361 L
.47396 .12361 L
.4747 .12361 L
.47539 .12361 L
.47614 .12361 L
.47694 .12361 L
.47764 .12361 L
.4784 .12361 L
.47911 .12361 L
.47977 .12361 L
.481 .12361 L
.4817 .12361 L
.48233 .12361 L
.48357 .12361 L
.48474 .12361 L
.48582 .12361 L
.487 .12361 L
.48829 .12361 L
.48901 .12361 L
.48966 .12361 L
.49094 .12361 L
.49213 .12361 L
.49336 .12361 L
.49452 .12361 L
.49517 .12361 L
.49586 .12361 L
.49708 .12361 L
.49779 .12361 L
Mistroke
.49854 .12361 L
.49918 .12361 L
.49989 .12361 L
.50054 .12361 L
.50124 .12361 L
.50251 .12361 L
.50376 .12361 L
.50447 .12361 L
.50513 .12361 L
.50634 .12361 L
.50762 .12361 L
.50889 .12361 L
.51008 .12361 L
.51115 .12361 L
.51231 .12361 L
.51355 .12361 L
.51426 .12361 L
.51492 .12361 L
.51769 .12361 L
.51891 .12361 L
.52008 .12361 L
.52072 .12361 L
.52142 .12361 L
.52264 .12361 L
.52378 .12361 L
.52485 .12361 L
.52603 .12361 L
.52729 .12361 L
.52855 .12361 L
.52918 .12361 L
.52988 .12361 L
.5311 .12361 L
.53224 .12361 L
.5334 .12361 L
.53449 .12361 L
.53547 .12361 L
.53654 .12361 L
.5377 .12361 L
.53893 .12361 L
.53998 .12361 L
.54113 .12361 L
.54232 .12361 L
.54344 .12361 L
.54473 .12361 L
.5459 .12361 L
.5472 .12361 L
.54793 .12361 L
.5486 .12361 L
.54981 .12361 L
.5511 .12361 L
Mistroke
.55231 .12361 L
.55346 .12361 L
.5541 .12361 L
.55479 .12361 L
.556 .12361 L
.55715 .12361 L
.55837 .12361 L
.55942 .12361 L
.56057 .12361 L
.56186 .12361 L
.56259 .12361 L
.56325 .12361 L
.56448 .12361 L
.56577 .12361 L
.56646 .12361 L
.56719 .12361 L
.5685 .12361 L
.5693 .12361 L
.57006 .12361 L
.57074 .12361 L
.57148 .12361 L
.57268 .12361 L
.574 .12361 L
.57467 .12361 L
.57538 .12361 L
.57667 .12361 L
.57796 .12361 L
.57917 .12361 L
.58027 .12361 L
.58146 .12361 L
.62219 .12361 L
.66142 .12361 L
.69912 .12361 L
.73928 .12361 L
.77792 .12361 L
.81902 .12361 L
.8586 .12361 L
.89666 .12361 L
.93718 .12361 L
.97618 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Koooo1@00083oool009goool00`000?ooooooo`20oooo002Moooo00<0003ooooo
ool00oooo`<0001joooo002Eoooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0N_oo
o`00WOooo`030000oooooooo00?oool00`000?ooooooo`1joooo002Loooo0P0000Goool00`000?oo
ooooo`1joooo002Soooo00<0003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool2
0000Noooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0
003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002S
oooo00<0003oooooool0N_ooo`00Xoooo`80001koooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool00:?oool20000Noooo`00:oooo`<0000Xoooo0`0002?oool4
00008oooo`030000oooooooo02?oool400009oooo`<0000Yoooo000[oooo00@0003oooooool0000X
oooo00<0003oooooool08_ooo`030000oooooooo02Coool00`000?ooooooo`0Soooo00<0003ooooo
ool0:Oooo`030000oooooooo02Soool002_oool010000?ooooooo`0002Goool500009?ooo`030000
oooooooo02?oool00`000?ooooooo`0Toooo00<0003oooooool09Oooo`D0000Yoooo000Uoooo1000
00;oool300008?ooo`@00002oooo00@0003oooooool0000Noooo100000Coool00`000?ooooooo`0R
oooo00<0003oooooool09Oooo`030000oooooooo02Coool010000?ooooooo`0002[oool002coool0
0`000?ooooooo`0Voooo00<0003oool000009?ooo`040000oooooooo00008oooo`030000oooooooo
02?oool010000?ooooooo`0002Koool00`000?ooo`00000Zoooo000/oooo0`0002Ooool200009Ooo
o`80000Toooo0P0002Goool20000:?ooo`80000Zoooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool0013ooooo00004Oooo`005_ooo`03000006Ko06Ko00D0I_l2
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool02?ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Ooool00`000?ooo`1Vo`0@000000<co`00000co`0023?o00030000<ol0<ol000Lco`00
0`0003?o03?o0007<ol000<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool02?ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo01Goool001koool<06Ko00<0003oooooool09_ooo`030000oooooooo01goool00`1Voooo
ooooo`05oooo00<0003oooooool01_ooo`@0000K<ol000<0003oooooool09Oooo`030000oooooooo
02Koool00`000?ooooooo`0Yoooo000Zoooo101VodGoool00`1Vooooooooo`0Boooo100001Lco`00
0`000?ooooooo`1joooo000^oooo1@1Vod3oool00`1Vooooooooo`0Foooo00<0000co`0co`0053?o
00030000oooooooo07[oool003?oool406Ko??ooo`0306Kooooooooo01Ooool2000053?o00030000
oooooooo07[oool003Ooool206Ko>_ooo`0306Kooooooooo01Woool00`0003?o03?o000A<ol000<0
003oooooool0N_ooo`00>Oooo`80I_lhoooo00<0I_ooooooool06_ooo`030000<ol0<ol0010co`02
0000Noooo`00>oooo`0306Kooooooooo03Goool00`1Vooooooooo`0Koooo0P00010co`000`000?oo
ooooo`1joooo000loooo0P1VocGoool00`1Vooooooooo`0Moooo00<0000co`0co`003C?o00030000
oooooooo07[oool003koool00`1Vooooooooo`0boooo00<0I_ooooooool07Oooo`030000<ol0<ol0
00dco`000`000?ooooooo`1joooo000ooooo0P1Voc;oool00`1Vooooooooo`0Noooo00<0000co`0c
o`0033?o00030000oooooooo07[oool0047oool206Ko<?ooo`0306Kooooooooo01koool00`0003?o
03?o000<<ol000<0003oooooool0N_ooo`00@oooo`0306Kooooooooo02goool00`1Vooooooooo`0O
oooo00<0000co`0co`002c?o0080001koooo0014oooo00<0I_ooooooool0;?ooo`0306Kooooooooo
01ooool00`0003?o03?o000;<ol000<0003oooooool0N_ooo`00AOooo`0306Kooooooooo02_oool0
0`1Vooooooooo`0Poooo00<0000co`0co`002S?o00030000oooooooo07[oool004Koool00`1Voooo
ooooo`0Zoooo00<0I_ooooooool08?ooo`030000<ol0<ol000Xco`000`000?ooooooo`1joooo0017
oooo00<0I_ooooooool0:Oooo`0306Kooooooooo027oool00`0003?o03?o0009<ol000<0003ooooo
ool0N_ooo`00Aoooo`0306Kooooooooo02Woool00`1Vooooooooo`0Qoooo00<0000co`0co`002C?o
00030000oooooooo07[oool004Soool00`1Vooooooooo`0Voooo0`1VobCoool00`0003?o03?o0008
<ol00P0007_oool004Woool00`1Vooooooooo`0Noooo1`1Vo`;oool00ol0VOooooooo`0Roooo00<0
000co`0co`0023?o00030000oooooooo07[oool004[oool00`1Vooooooooo`0Coooo2P1Vo`Woool0
0ol0VOooooooo`0Roooo00<0000co`0co`0023?o00030000oooooooo07[oool004[ooolF06Ko4ooo
o`03o`2Ioooooooo02?oool00`0003?o03?o0007<ol000<0003oooooool0N_ooo`00Loooo`03o`2I
oooooooo02?oool00`0003?o03?o0007<ol000<0003oooooool0N_ooo`00Loooo`03o`2Ioooooooo
02?oool00`0003?o03?o0007<ol000<0003oooooool0N_ooo`00Loooo`03o`2Ioooooooo02?oool0
0`0003?o03?o0007<ol00P0007_oool007?oool00ol0VOooooooo`0Toooo00<0000co`0co`001S?o
00030000oooooooo07[oool007?oool00ol0VOooooooo`0Toooo00<0000co`0co`001S?o00030000
oooooooo07[oool007?oool00ol0VOooooooo`0Toooo00<0000co`0co`001S?o00030000oooooooo
07[oool007?oool00ol0VOooooooo`0Toooo00<0000co`0co`001S?o00030000oooooooo07[oool0
07?oool00ol0VOooooooo`0Uoooo1@0000<co`000`000?ooooooo`1joooo001coooo00?o09Wooooo
ool09Oooo`030000<ol0000000Dco`000`000?ooooooo`1joooo001coooo00?o09Woooooool09Ooo
o`030000<ol0000000Dco`030000N_ooo`00Loooo`03o`2Ioooooooo02Koool200001C?o00030000
oooooooo07[oool007?oool00ol0VOooooooo`0Voooo0P0000Dco`000`000?ooooooo`1joooo001c
oooo00?o09Woooooool09_ooo`800005<ol000<0003oooooool0N_ooo`00Loooo`03o`2Ioooooooo
02Koool00`0003?o03?o0004<ol000<0003oooooool0N_ooo`00Loooo`03o`2Ioooooooo02Koool0
0`0003?o03?o0004<ol000<0003oooooool0N_ooo`00Loooo`03o`2Ioooooooo02Koool00`0003?o
03?o0004<ol00P0007_oool007?oool00ol0VOooooooo`0Woooo00<0000co`0co`000c?o00030000
oooooooo07[oool007?oool00ol0VOooooooo`0Woooo00<0000co`0co`000c?o00030000oooooooo
07[oool007?oool00ol0VOooooooo`0Woooo00<0000co`0co`000c?o00030000oooooooo07[oool0
07?oool00ol0VOooooooo`0Woooo00<0000co`0co`000c?o00030000oooooooo07[oool007?oool0
0ol0VOooooooo`0Woooo00<0000co`0co`000c?o00030000oooooooo07[oool007?oool00ol0VOoo
ooooo`0Woooo00<0000co`0co`000c?o0080001koooo001coooo00?o09Woooooool09oooo`030000
<ol0<ol000<co`000`000?ooooooo`1joooo001coooo00?o09Woooooool09oooo`030000<ol0<ol0
00<co`000`000?ooooooo`1joooo001coooo00?o09Woooooool0:?ooo`030000<ol0<ol0008co`00
0`000?ooooooo`1joooo001coooo00?o09Woooooool0:?ooo`030000<ol0<ol0008co`000`000?oo
ooooo`1joooo001coooo00?o09Woooooool0:?ooo`030000<ol0<ol0008co`000`000?ooooooo`1j
oooo001coooo00?o09Woooooool0:?ooo`030000<ol0<ol0008co`000`000?ooooooo`1joooo001c
oooo00?o09Woooooool0:?ooo`030000<ol0<ol0008co`020000Noooo`00Loooo`03o`2Ioooooooo
02Soool00`0003?o03?o0002<ol000<0003oooooool0N_ooo`00Loooo`03o`2Ioooooooo02Soool0
0`0003?o03?o0002<ol000<0003oooooool0N_ooo`00Loooo`03o`2Ioooooooo02Soool00`0003?o
03?o0002<ol000<0003oooooool0N_ooo`00Loooo`03o`2Ioooooooo02Soool00`0003?o03?o0002
<ol000<0003oooooool0N_ooo`00Loooo`03o`2Ioooooooo02Soool00`0003?o03?o0002<ol000<0
003oooooool0N_ooo`00Loooo`03o`2Ioooooooo02Soool00`0003?o03?o0002<ol00P0007_oool0
07?oool00ol0VOooooooo`0Yoooo00D0000co`0co`0co`000000O?ooo`00Loooo`03o`2Ioooooooo
02Woool01@0003?o03?o03?o0000001loooo001coooo00?o09Woooooool0:Oooo`050000<ol0<ol0
<ol0000007coool007?oool00ol0VOooooooo`0Uoooo1@0000<co`000`000?ooooooo`1joooo001c
oooo00?o09Woooooool09Oooo`050000oooooooooooo000000<co`000`000?ooooooo`1joooo001c
oooo00?o09Woooooool09_ooo`040000oooooooo00000c?o00<0001joooo001coooo00?o09Wooooo
ool09oooo`030000oooo000000<co`000`000?ooooooo`1joooo001coooo00?o09Woooooool09Ooo
o`030000oooooooo00800003<ol000<0003oooooool0N_ooo`00Loooo`03o`2Ioooooooo02Koool2
000000?oool0000co`000S?o00030000oooooooo07[oool007?oool00ol0VOooooooo`0Yoooo00D0
000co`0co`0co`000000O?ooo`00Loooo`03o`2Ioooooooo02[oool0100003?o03?o000007coool0
07?oool00ol0VOooooooo`0Zoooo00<0000co`0co`000P0007_oool007?oool00ol0VOooooooo`0Z
oooo00@0000co`0co`00001loooo001coooo00?o09Woooooool0:_ooo`040000<ol0<ol00000O?oo
o`00Loooo`03o`2Ioooooooo02[oool0100003?o03?o000007coool007?oool00ol0VOooooooo`0Z
oooo00@0000co`0co`00001loooo001coooo00?o09Woooooool0:_ooo`040000<ol0<ol00000O?oo
o`00Loooo`03o`2Ioooooooo02[oool0100003?o03?o000007coool007?oool00ol0VOooooooo`0[
oooo00@0000co`000000001koooo001coooo00?o09Woooooool0:oooo`030000<ol0000007coool0
07?oool00ol0VOooooooo`0[oooo00<0000co`000000O?ooo`00Loooo`03o`2Ioooooooo02_oool0
0`0003?o0000001loooo001coooo00?o09Woooooool0:oooo`030000<ol0000007coool007?oool0
0ol0VOooooooo`0[oooo00<0000co`000000O?ooo`00Loooo`03o`2Ioooooooo02_oool0100003?o
0000000007_oool007?oool00ol0VOooooooo`0[oooo00<0000co`000000O?ooo`00Loooo`03o`2I
oooooooo02_oool00`0003?o0000001loooo001coooo00?o09Woooooool0:oooo`030000<ol00000
07coool007?oool00ol0VOooooooo`0[oooo00<0000co`000000O?ooo`00Loooo`03o`2Ioooooooo
02_oool00`0003?o0000001loooo001coooo00?o09Woooooool0:oooo`040000<ol000000000Nooo
o`00Loooo`03o`2Ioooooooo02_oool00`0003?o0000001loooo001coooo00?o09Woooooool0:ooo
o`030000<ol0000007coool007?oool00ol0VOooooooo`0[oooo00<0000co`000000O?ooo`00Looo
o`03o`2Ioooooooo02Koool200000oooo`030000<ol0000007coool007?oool00ol0VOooooooo`0U
oooo00@0003oooooool00002oooo00<0000co`000000O?ooo`00Loooo`03o`2Ioooooooo02Ooool0
1P000?ooooooooooo`0003?o00<0001joooo001coooo00?o09Woooooool0:?ooo`060000oooooooo
0000<ol00000O?ooo`00Loooo`03o`2Ioooooooo02Goool010000?ooooooo`0000;oool00`0003?o
0000001loooo001coooo00?o09Woooooool09_ooo`800004oooo0P0007coool007?oool00ol0VOoo
ooooo`0/oooo0P0007coool007?oool00ol0VOooooooo`0/oooo0P0007coool007?oool00ol0VOoo
ooooo`0/oooo0P0007coool007?oool00ol0VOooooooo`0/oooo0`0007_oool007?oool00ol0VOoo
ooooo`0/oooo0P0007coool007?oool00ol0VOooooooo`0/oooo0P0007coool007?oool00ol0VOoo
ooooo`0/oooo0P0007coool007?oool00ol0VOooooooo`0/oooo0P0007coool007?oool00ol0VOoo
ooooo`0/oooo0P0007coool007?oool00ol0VOooooooo`0/oooo0`0007_oool007?oool00ol0VOoo
ooooo`0/oooo0P0007coool007?oool00ol0VOooooooo`0/oooo0P0007coool007?oool00ol0VOoo
ooooo`0/oooo0P0007coool007?oool00ol0VOooooooo`0/oooo0P0007coool007?oool00ol0VOoo
ooooo`0/oooo0P0007coool007?oool00ol0VOooooooo`0/oooo0`0007_oool007?oool00ol0VOoo
ooooo`0]oooo00<0003oooooool0N_ooo`00Loooo`03o`2Ioooooooo02goool00`000?ooooooo`1j
oooo001coooo00?o09Woooooool0;Oooo`030000oooooooo07[oool007?oool00ol0VOooooooo`0]
oooo00<0003oooooool0N_ooo`00Loooo`03o`2Ioooooooo02goool00`000?ooooooo`1joooo001c
oooo00?o09Woooooool0;Oooo`80001koooo001coooo00?o09Woooooool0;Oooo`030000oooooooo
07[oool007?oool00ol0VOooooooo`0]oooo00<0003oooooool0N_ooo`00Loooo`03o`2Ioooooooo
02goool00`000?ooooooo`1joooo001coooo00?o09Woooooool0;Oooo`030000oooooooo07[oool0
07?oool00ol0VOooooooo`0Woooo0`0000?oool00`000?ooooooo`1joooo001coooo00?o09Wooooo
ool0:?ooo`030000oooooooo00;oool00`000?ooooooo`1joooo001coooo00?o09Woooooool09Ooo
o`D00003oooo0`0007[oool009_oool010000?ooooooo`00087oool009coool00`000?ooo`000021
oooo002Moooo0P00087oool00?oooolQoooo003ooooo8Oooo`00NOooo`030000oooooooo02Soool0
0`000?ooooooo`1ioooo001hoooo00<0003oooooool02?ooo`030000oooooooo01ooool00`000?oo
ooooo`1hoooo001hoooo00<0003oooooool00_ooo`800004oooo00<0003oooooool03Oooo`800004
oooo0P0000Goool300000_ooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`000002
oooo00<0003oooooool00_ooo`030000oooooooo00Coool400000oooo`040000oooooooo00002ooo
o`050000oooooooooooo000007[oool007Ooool00`000?ooooooo`02oooo00<0003oooooool05Ooo
o`030000oooooooo00Ooool500000oooo`030000oooooooo07Ooool007Soool00`000?ooooooo`05
00005Oooo`030000oooooooo00Koool010000?ooooooo`0000?oool00`000?ooooooo`1hoooo001h
oooo00D0003oooooooooool000005Oooo`040000oooooooo00002Oooo`030000oooo000000?oool0
0`000?ooooooo`1hoooo001ioooo00<0003oooooool05oooo`80000;oooo0P0000;oool00`000?oo
ooooo`1ioooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-8.12947, \
-1.14361, 0.0496935, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-8.12947, -1.14361, 0.0496935, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
.2 1 0 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.36136 .12361 L
.37176 .12361 L
.3815 .12361 L
.39106 .12361 L
.39381 .12361 L
.39516 .12361 L
.39642 .12361 L
s
.39642 .12361 m
.39688 .61803 L
s
0 .4 1 r
.02381 .12551 m
.04262 .12626 L
.06244 .12739 L
.07286 .12816 L
.08255 .12902 L
.09388 .13023 L
.10458 .13162 L
.125 .13514 L
.14357 .13966 L
.16355 .14652 L
.18199 .15544 L
.20071 .16805 L
.21136 .17733 L
.22134 .18778 L
.23172 .20082 L
.23419 .20431 L
.23555 .20629 L
.23683 .20819 L
.23803 .21002 L
.23933 .2101 L
.2405 .21008 L
.24158 .21006 L
.25044 .2099 L
.26011 .20969 L
.27893 .20916 L
.28962 .20877 L
.2996 .20834 L
.31995 .20717 L
.33851 .20566 L
.35759 .2035 L
.36837 .20191 L
.37835 .20015 L
.38298 .19922 L
.38798 .19812 L
.39027 .19758 L
.39269 .19699 L
.39476 .19647 L
.39593 .19616 L
.39702 .12361 L
.3983 .12361 L
.39903 .12361 L
.3997 .12361 L
.40093 .12361 L
.40223 .12361 L
.4034 .12361 L
.40449 .12361 L
.40569 .12361 L
.40698 .12361 L
.40768 .12361 L
.40834 .12361 L
Mistroke
.40906 .12361 L
.40983 .12361 L
.41056 .12361 L
.41125 .12361 L
.41254 .12361 L
.41381 .12361 L
.41498 .12361 L
.41626 .12361 L
.41691 .12361 L
.41762 .12361 L
.41893 .12361 L
.42014 .12361 L
.42082 .12361 L
.42147 .12361 L
.42214 .12361 L
.42287 .12361 L
.42413 .12361 L
.42527 .12361 L
.42653 .12361 L
.42785 .12361 L
.42897 .12361 L
.43016 .12361 L
.43128 .12361 L
.4323 .12361 L
.4335 .12361 L
.43481 .12361 L
.43603 .12361 L
.43717 .12361 L
.43837 .12361 L
.43967 .12361 L
.4409 .12361 L
.44201 .12361 L
.44332 .12361 L
.44406 .12361 L
.44475 .12361 L
.446 .12361 L
.44664 .12361 L
.44734 .12361 L
.44802 .12361 L
.44873 .12361 L
.45001 .12361 L
.45072 .12361 L
.45138 .12361 L
.45211 .12361 L
.45288 .12361 L
.45356 .12361 L
.45429 .12361 L
.45498 .12361 L
.45561 .12361 L
.45682 .12361 L
Mistroke
.45809 .12361 L
.45921 .12361 L
.4604 .12361 L
.46171 .12361 L
.46292 .12361 L
.46416 .12361 L
.46533 .12361 L
.46638 .12361 L
.46751 .12361 L
.46815 .12361 L
.46886 .12361 L
.46959 .12361 L
.47027 .12361 L
.47149 .12361 L
.47281 .12361 L
.47411 .12361 L
.47534 .12361 L
.47644 .12361 L
.47764 .12361 L
.47877 .12361 L
.47984 .12361 L
.481 .12361 L
.48226 .12361 L
.4835 .12361 L
.48481 .12361 L
.48593 .12361 L
.48715 .12361 L
.48821 .12361 L
.4892 .12361 L
.49024 .12361 L
.49138 .12361 L
.49252 .12361 L
.49376 .12361 L
.4949 .12361 L
.49595 .12361 L
.49725 .12361 L
.49798 .12361 L
.49866 .12361 L
.49991 .12361 L
.50061 .12361 L
.50124 .12361 L
.50248 .12361 L
.50317 .12361 L
.50381 .12361 L
.50499 .12361 L
.50623 .12361 L
.50735 .12361 L
.50854 .12361 L
.50967 .12361 L
.51069 .12361 L
Mistroke
.51189 .12361 L
.5132 .12361 L
.51443 .12361 L
.51557 .12361 L
.51678 .12361 L
.51807 .12361 L
.51929 .12361 L
.52041 .12361 L
.52172 .12361 L
.52246 .12361 L
.52315 .12361 L
.5244 .12361 L
.52511 .12361 L
.52574 .12361 L
.52642 .12361 L
.52713 .12361 L
.52841 .12361 L
.52912 .12361 L
.52979 .12361 L
.53052 .12361 L
.5313 .12361 L
.53197 .12361 L
.5327 .12361 L
.53335 .12361 L
.53403 .12361 L
.53533 .12361 L
.53653 .12361 L
.53776 .12361 L
.53891 .12361 L
.5401 .12361 L
.54141 .12361 L
.54255 .12361 L
.54358 .12361 L
.54477 .12361 L
.54589 .12361 L
.54712 .12361 L
.54841 .12361 L
.54952 .12361 L
.55074 .12361 L
.55205 .12361 L
.55278 .12361 L
.55345 .12361 L
.55475 .12361 L
.55599 .12361 L
.55714 .12361 L
.55819 .12361 L
.55939 .12361 L
.56053 .12361 L
.56158 .12361 L
.56255 .12361 L
Mistroke
.56361 .12361 L
.56473 .12361 L
.56587 .12361 L
.56709 .12361 L
.56824 .12361 L
.56928 .12361 L
.57051 .12361 L
.5712 .12361 L
.57184 .12361 L
.57302 .12361 L
.57427 .12361 L
.57541 .12361 L
.57666 .12361 L
.57796 .12361 L
.57917 .12361 L
.58031 .12361 L
.58134 .12361 L
.58366 .12361 L
.59377 .12361 L
.61206 .12361 L
.65208 .12361 L
.69059 .12361 L
.73155 .12361 L
.77099 .12361 L
.80892 .12361 L
.84929 .12361 L
.88816 .12361 L
.92948 .12361 L
.96928 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Koooo1@00083oool009goool00`000?ooooooo`20oooo002Moooo00<0003ooooo
ool00oooo`<0001joooo002Eoooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0N_oo
o`00WOooo`030000oooooooo00?oool00`000?ooooooo`1joooo002Loooo0P0000Goool00`000?oo
ooooo`1joooo002Soooo00<0003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool2
0000Noooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0
003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002S
oooo00<0003oooooool0N_ooo`00Xoooo`80001koooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool00:?oool20000Noooo`00:oooo`<0000Xoooo0`0002?oool4
00008oooo`030000oooooooo02?oool400009oooo`<0000Yoooo000[oooo00@0003oooooool0000X
oooo00<0003oooooool08_ooo`030000oooooooo02Coool00`000?ooooooo`0Soooo00<0003ooooo
ool0:Oooo`030000oooooooo02Soool002_oool010000?ooooooo`0002Goool500009?ooo`030000
oooooooo02?oool00`000?ooooooo`0Toooo00<0003oooooool09Oooo`D0000Yoooo000Uoooo1000
00;oool300008?ooo`@00002oooo00@0003oooooool0000Noooo100000Coool00`000?ooooooo`0R
oooo00<0003oooooool09Oooo`030000oooooooo02Coool010000?ooooooo`0002[oool002coool0
0`000?ooooooo`0Voooo00<0003oool000009?ooo`040000oooooooo00008oooo`030000oooooooo
02?oool010000?ooooooo`0002Koool00`000?ooo`00000Zoooo000/oooo0`0002Ooool200009Ooo
o`80000Toooo0P0002Goool20000:?ooo`80000Zoooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool0013ooooo00004Oooo`005_ooo`03000006Ko06Ko00L0I_l0
0`00001Vooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`050000oooo0000000006Ko00h000000c?o000003?o0008<ol000<0000co`0co`001c?o
00030000<ol0<ol000Lco`000`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo
00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?oo
ooooo`08oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0
003oooooool05Oooo`008_ooo`P0I_l01000001Vo`1Vo`1VobGoool00`000?ooooooo`0Ooooo00<0
I_ooooooool00oooo`030000oooooooo00Koool400006c?o00030000oooooooo02Goool00`000?oo
ooooo`0Voooo00<0003oooooool0:Oooo`00;_ooo`D0I_m2oooo00<0I_ooooooool04?ooo`@0000G
<ol000<0003oooooool0N_ooo`00<oooo`@0I_lnoooo00<0I_ooooooool05?ooo`030000<ol0<ol0
01@co`000`000?ooooooo`1joooo000goooo0P1Voccoool00`1Vooooooooo`0Eoooo0P0001@co`00
0`000?ooooooo`1joooo000ioooo0P1Voc[oool00`1Vooooooooo`0Goooo00<0000co`0co`004C?o
00030000oooooooo07[oool003_oool206Ko>?ooo`0306Kooooooooo01Soool00`0003?o03?o000@
<ol00P0007_oool003goool206Ko=_ooo`0306Kooooooooo01Woool2000043?o00030000oooooooo
07[oool003ooool00`1Vooooooooo`0coooo00<0I_ooooooool06oooo`030000<ol0<ol000dco`00
0`000?ooooooo`1joooo0010oooo0P1Voc?oool00`1Vooooooooo`0Koooo00<0000co`0co`003C?o
00030000oooooooo07[oool004;oool00`1Vooooooooo`0`oooo00<0I_ooooooool07?ooo`030000
<ol0<ol000`co`000`000?ooooooo`1joooo0013oooo00<0I_ooooooool0;oooo`0306Kooooooooo
01coool00`0003?o03?o000<<ol000<0003oooooool0N_ooo`00A?ooo`80I_l_oooo00<0I_oooooo
ool07Oooo`030000<ol0<ol000/co`020000Noooo`00A_ooo`0306Kooooooooo02coool00`1Voooo
ooooo`0Moooo00<0000co`0co`002c?o00030000oooooooo07[oool004Ooool00`1Vooooooooo`0[
oooo00<0I_ooooooool07_ooo`030000<ol0<ol000Xco`000`000?ooooooo`1joooo0017oooo00<0
I_ooooooool0:oooo`0306Kooooooooo01koool00`0003?o03?o000:<ol000<0003oooooool0N_oo
o`00B?ooo`0306Kooooooooo02[oool00`1Vooooooooo`0Ooooo00<0000co`0co`002C?o00030000
oooooooo07[oool004Woool00`1Vooooooooo`0Yoooo00<0I_ooooooool07oooo`030000<ol0<ol0
00Tco`000`000?ooooooo`1joooo001:oooo00<0I_ooooooool09_ooo`<0I_lRoooo00<0000co`0c
o`0023?o0080001koooo001;oooo00<0I_ooooooool07oooo`H0I_l2oooo00?o09Woooooool08?oo
o`030000<ol0<ol000Pco`000`000?ooooooo`1joooo001<oooo00<0I_ooooooool05Oooo`T0I_l8
oooo00?o09Woooooool08?ooo`030000<ol0<ol000Pco`000`000?ooooooo`1joooo001<oooo601V
oa7oool00ol0VOooooooo`0Qoooo00<0000co`0co`001c?o00030000oooooooo07[oool007Goool0
0ol0VOooooooo`0Qoooo00<0000co`0co`001c?o00030000oooooooo07[oool007Goool00ol0VOoo
ooooo`0Qoooo00<0000co`0co`001c?o00030000oooooooo07[oool007Goool00ol0VOooooooo`0Q
oooo00<0000co`0co`001c?o0080001koooo001eoooo00?o09Woooooool08_ooo`030000<ol0<ol0
00Hco`000`000?ooooooo`1joooo001eoooo00?o09Woooooool08_ooo`030000<ol0<ol000Hco`00
0`000?ooooooo`1joooo001eoooo00?o09Woooooool08_ooo`030000<ol0<ol000Hco`000`000?oo
ooooo`1joooo001eoooo00?o09Woooooool08_ooo`030000<ol0<ol000Hco`000`000?ooooooo`1j
oooo001eoooo00?o09Woooooool08oooo`D00003<ol000<0003oooooool0N_ooo`00MOooo`03o`2I
oooooooo02?oool00`0003?o00000005<ol000<0003oooooool0N_ooo`00MOooo`03o`2Ioooooooo
02?oool00`0003?o00000005<ol00`0007[oool007Goool00ol0VOooooooo`0Toooo0P0000Dco`00
0`000?ooooooo`1joooo001eoooo00?o09Woooooool09?ooo`800005<ol000<0003oooooool0N_oo
o`00MOooo`03o`2Ioooooooo02Coool200001C?o00030000oooooooo07[oool007Goool00ol0VOoo
ooooo`0Toooo00<0000co`0co`0013?o00030000oooooooo07[oool007Goool00ol0VOooooooo`0T
oooo00<0000co`0co`0013?o00030000oooooooo07[oool007Goool00ol0VOooooooo`0Toooo00<0
000co`0co`0013?o0080001koooo001eoooo00?o09Woooooool09Oooo`030000<ol0<ol000<co`00
0`000?ooooooo`1joooo001eoooo00?o09Woooooool09Oooo`030000<ol0<ol000<co`000`000?oo
ooooo`1joooo001eoooo00?o09Woooooool09Oooo`030000<ol0<ol000<co`000`000?ooooooo`1j
oooo001eoooo00?o09Woooooool09Oooo`030000<ol0<ol000<co`000`000?ooooooo`1joooo001e
oooo00?o09Woooooool09Oooo`030000<ol0<ol000<co`000`000?ooooooo`1joooo001eoooo00?o
09Woooooool09Oooo`030000<ol0<ol000<co`020000Noooo`00MOooo`03o`2Ioooooooo02Goool0
0`0003?o03?o0003<ol000<0003oooooool0N_ooo`00MOooo`03o`2Ioooooooo02Goool00`0003?o
03?o0003<ol000<0003oooooool0N_ooo`00MOooo`03o`2Ioooooooo02Koool00`0003?o03?o0002
<ol000<0003oooooool0N_ooo`00MOooo`03o`2Ioooooooo02Koool00`0003?o03?o0002<ol000<0
003oooooool0N_ooo`00MOooo`03o`2Ioooooooo02Koool00`0003?o03?o0002<ol000<0003ooooo
ool0N_ooo`00MOooo`03o`2Ioooooooo02Koool00`0003?o03?o0002<ol000<0003oooooool0N_oo
o`00MOooo`03o`2Ioooooooo02Koool00`0003?o03?o0002<ol00P0007_oool007Goool00ol0VOoo
ooooo`0Voooo00<0000co`0co`000S?o00030000oooooooo07[oool007Goool00ol0VOooooooo`0V
oooo00<0000co`0co`000S?o00030000oooooooo07[oool007Goool00ol0VOooooooo`0Voooo00<0
000co`0co`000S?o00030000oooooooo07[oool007Goool00ol0VOooooooo`0Voooo00<0000co`0c
o`000S?o00030000oooooooo07[oool007Goool00ol0VOooooooo`0Voooo00<0000co`0co`000S?o
00030000oooooooo07[oool007Goool00ol0VOooooooo`0Voooo00<0000co`0co`000S?o0080001k
oooo001eoooo00?o09Woooooool09oooo`050000<ol0<ol0<ol0000007coool007Goool00ol0VOoo
ooooo`0Woooo00D0000co`0co`0co`000000O?ooo`00MOooo`03o`2Ioooooooo02Ooool01@0003?o
03?o03?o0000001loooo001eoooo00?o09Woooooool08oooo`D00003<ol000<0003oooooool0N_oo
o`00MOooo`03o`2Ioooooooo02?oool01@000?ooooooooooo`000003<ol000<0003oooooool0N_oo
o`00MOooo`03o`2Ioooooooo02Coool010000?ooooooo`0000<co`030000N_ooo`00MOooo`03o`2I
oooooooo02Goool00`000?ooo`000003<ol000<0003oooooool0N_ooo`00MOooo`03o`2Ioooooooo
02?oool00`000?ooooooo`0200000c?o00030000oooooooo07[oool007Goool00ol0VOooooooo`0T
oooo0P000003oooo0000<ol0008co`000`000?ooooooo`1joooo001eoooo00?o09Woooooool09ooo
o`050000<ol0<ol0<ol0000007coool007Goool00ol0VOooooooo`0Xoooo00@0000co`0co`00001l
oooo001eoooo00?o09Woooooool0:?ooo`030000<ol0<ol00080001koooo001eoooo00?o09Wooooo
ool0:?ooo`040000<ol0<ol00000O?ooo`00MOooo`03o`2Ioooooooo02Soool0100003?o03?o0000
07coool007Goool00ol0VOooooooo`0Xoooo00@0000co`0co`00001loooo001eoooo00?o09Wooooo
ool0:?ooo`040000<ol0<ol00000O?ooo`00MOooo`03o`2Ioooooooo02Soool0100003?o03?o0000
07coool007Goool00ol0VOooooooo`0Xoooo00@0000co`0co`00001loooo001eoooo00?o09Wooooo
ool0:Oooo`040000<ol000000000Noooo`00MOooo`03o`2Ioooooooo02Woool00`0003?o0000001l
oooo001eoooo00?o09Woooooool0:Oooo`030000<ol0000007coool007Goool00ol0VOooooooo`0Y
oooo00<0000co`000000O?ooo`00MOooo`03o`2Ioooooooo02Woool00`0003?o0000001loooo001e
oooo00?o09Woooooool0:Oooo`030000<ol0000007coool007Goool00ol0VOooooooo`0Yoooo00@0
000co`000000001koooo001eoooo00?o09Woooooool0:Oooo`030000<ol0000007coool007Goool0
0ol0VOooooooo`0Yoooo00<0000co`000000O?ooo`00MOooo`03o`2Ioooooooo02Woool00`0003?o
0000001loooo001eoooo00?o09Woooooool0:Oooo`030000<ol0000007coool007Goool00ol0VOoo
ooooo`0Yoooo00<0000co`000000O?ooo`00MOooo`03o`2Ioooooooo02Woool0100003?o00000000
07_oool007Goool00ol0VOooooooo`0Yoooo00<0000co`000000O?ooo`00MOooo`03o`2Ioooooooo
02Woool00`0003?o0000001loooo001eoooo00?o09Woooooool0:Oooo`030000<ol0000007coool0
07Goool00ol0VOooooooo`0Toooo0P0000?oool00`0003?o0000001loooo001eoooo00?o09Wooooo
ool08oooo`040000oooooooo00000_ooo`030000<ol0000007coool007Goool00ol0VOooooooo`0U
oooo00H0003oooooooooool0000co`030000N_ooo`00MOooo`03o`2Ioooooooo02Koool01P000?oo
ooooo`0003?o000007coool007Goool00ol0VOooooooo`0Soooo00@0003oooooool00002oooo00<0
000co`000000O?ooo`00MOooo`03o`2Ioooooooo02Coool200001?ooo`80001loooo001eoooo00?o
09Woooooool0:_ooo`80001loooo001eoooo00?o09Woooooool0:_ooo`80001loooo001eoooo00?o
09Woooooool0:_ooo`80001loooo001eoooo00?o09Woooooool0:_ooo`<0001koooo001eoooo00?o
09Woooooool0:_ooo`80001loooo001eoooo00?o09Woooooool0:_ooo`80001loooo001eoooo00?o
09Woooooool0:_ooo`80001loooo001eoooo00?o09Woooooool0:_ooo`80001loooo001eoooo00?o
09Woooooool0:_ooo`80001loooo001eoooo00?o09Woooooool0:_ooo`<0001koooo001eoooo00?o
09Woooooool0:_ooo`80001loooo001eoooo00?o09Woooooool0:_ooo`80001loooo001eoooo00?o
09Woooooool0:_ooo`80001loooo001eoooo00?o09Woooooool0:_ooo`80001loooo001eoooo00?o
09Woooooool0:_ooo`80001loooo001eoooo00?o09Woooooool0:_ooo`<0001koooo001eoooo00?o
09Woooooool0:oooo`030000oooooooo07[oool007Goool00ol0VOooooooo`0[oooo00<0003ooooo
ool0N_ooo`00MOooo`03o`2Ioooooooo02_oool00`000?ooooooo`1joooo001eoooo00?o09Wooooo
ool0:oooo`030000oooooooo07[oool007Goool00ol0VOooooooo`0[oooo00<0003oooooool0N_oo
o`00MOooo`03o`2Ioooooooo02_oool20000Noooo`00MOooo`03o`2Ioooooooo02_oool00`000?oo
ooooo`1joooo001eoooo00?o09Woooooool0:oooo`030000oooooooo07[oool007Goool00ol0VOoo
ooooo`0[oooo00<0003oooooool0N_ooo`00MOooo`03o`2Ioooooooo02_oool00`000?ooooooo`1j
oooo001eoooo00?o09Woooooool09Oooo`<00003oooo00<0003oooooool0N_ooo`00MOooo`03o`2I
oooooooo02Koool00`000?ooooooo`02oooo00<0003oooooool0N_ooo`00MOooo`03o`2Ioooooooo
02?oool500000oooo`<0001joooo002Koooo00@0003oooooool00021oooo002Loooo00<0003oool0
0000POooo`00WOooo`800021oooo003ooooo8Oooo`00ooooob7oool007Woool00`000?ooooooo`0X
oooo00<0003oooooool0NOooo`00N?ooo`030000oooooooo00Soool00`000?ooooooo`0Ooooo00<0
003oooooool0N?ooo`00N?ooo`030000oooooooo00;oool200001?ooo`030000oooooooo00goool2
00001?ooo`800004oooo0P0000Coool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool0
00000_ooo`030000oooooooo00;oool00`000?ooooooo`04oooo100000?oool010000?ooooooo`00
00Soool010000?ooooooo`0000?oool00`000?ooooooo`1hoooo001goooo00<0003oooooool00_oo
o`030000oooooooo01Goool00`000?ooooooo`09oooo00<0003oooooool00oooo`030000oooooooo
07Ooool007Soool00`000?ooooooo`0500005Oooo`030000oooooooo00Woool01@000?oooooooooo
o`00001joooo001hoooo00D0003oooooooooool000005Oooo`040000oooooooo00002?ooo`040000
oooooooo00000oooo`030000oooooooo07Soool007Woool00`000?ooooooo`0Goooo0P0000[oool2
00000oooo`030000oooooooo07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-8.12947, \
-1.14361, 0.0496935, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-8.12947, -1.14361, 0.0496935, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
.2 1 0 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.39174 .12361 L
.39675 .12361 L
.40134 .12361 L
.40252 .12361 L
.40381 .12361 L
s
.40381 .12361 m
.4043 .61803 L
s
0 .4 1 r
.02381 .12526 m
.04262 .12591 L
.06244 .12689 L
.07286 .12756 L
.08255 .12831 L
.09388 .12936 L
.10458 .13056 L
.125 .13362 L
.14357 .13754 L
.16355 .1435 L
.18199 .15124 L
.20071 .16218 L
.21136 .17025 L
.22134 .17932 L
.23988 .20113 L
.24249 .20482 L
.24495 .20847 L
.24562 .20948 L
.24632 .21011 L
.24709 .2101 L
.24779 .21009 L
.25037 .21004 L
.26011 .20986 L
.27018 .20963 L
.28124 .20933 L
.29175 .20899 L
.30133 .20861 L
.32084 .20761 L
.33158 .2069 L
.34176 .20608 L
.36167 .20398 L
.38009 .20126 L
.38907 .19957 L
.39875 .19743 L
.40145 .19676 L
.40293 .19638 L
.40364 .19619 L
.4043 .19602 L
.40547 .12361 L
.40672 .12361 L
.40738 .12361 L
.40809 .12361 L
.40938 .12361 L
.41058 .12361 L
.4119 .12361 L
.41256 .12361 L
.41328 .12361 L
.41457 .12361 L
.41586 .12361 L
.41708 .12361 L
Mistroke
.41817 .12361 L
.41935 .12361 L
.42 .12361 L
.42068 .12361 L
.4219 .12361 L
.42319 .12361 L
.42393 .12361 L
.42461 .12361 L
.42584 .12361 L
.42696 .12361 L
.42826 .12361 L
.42949 .12361 L
.43012 .12361 L
.43082 .12361 L
.43155 .12361 L
.43224 .12361 L
.43346 .12361 L
.43478 .12361 L
.43548 .12361 L
.43624 .12361 L
.43704 .12361 L
.43778 .12361 L
.43848 .12361 L
.43911 .12361 L
.43984 .12361 L
.44053 .12361 L
.44169 .12361 L
.44297 .12361 L
.44362 .12361 L
.44431 .12361 L
.44555 .12361 L
.4468 .12361 L
.44797 .12361 L
.44903 .12361 L
.45018 .12361 L
.45143 .12361 L
.45214 .12361 L
.45281 .12361 L
.45351 .12361 L
.45416 .12361 L
.45486 .12361 L
.45561 .12361 L
.45685 .12361 L
.45801 .12361 L
.45928 .12361 L
.45992 .12361 L
.46063 .12361 L
.46128 .12361 L
.46198 .12361 L
.46325 .12361 L
Mistroke
.46451 .12361 L
.46567 .12361 L
.46637 .12361 L
.46701 .12361 L
.46772 .12361 L
.46847 .12361 L
.46919 .12361 L
.46987 .12361 L
.47114 .12361 L
.47235 .12361 L
.47362 .12361 L
.47471 .12361 L
.47591 .12361 L
.47719 .12361 L
.47792 .12361 L
.47857 .12361 L
.47985 .12361 L
.48106 .12361 L
.48213 .12361 L
.48331 .12361 L
.48454 .12361 L
.48569 .12361 L
.48676 .12361 L
.48775 .12361 L
.48883 .12361 L
.48997 .12361 L
.49112 .12361 L
.49236 .12361 L
.49353 .12361 L
.49459 .12361 L
.49584 .12361 L
.49654 .12361 L
.49719 .12361 L
.49838 .12361 L
.49964 .12361 L
.50218 .12361 L
.50342 .12361 L
.50458 .12361 L
.50563 .12361 L
.50674 .12361 L
.50797 .12361 L
.50909 .12361 L
.5104 .12361 L
.5116 .12361 L
.51292 .12361 L
.51359 .12361 L
.51432 .12361 L
.51555 .12361 L
.51686 .12361 L
.5181 .12361 L
Mistroke
.51923 .12361 L
.52037 .12361 L
.52158 .12361 L
.52261 .12361 L
.52375 .12361 L
.52497 .12361 L
.52628 .12361 L
.52751 .12361 L
.52865 .12361 L
.52978 .12361 L
.53083 .12361 L
.53198 .12361 L
.53321 .12361 L
.53438 .12361 L
.53549 .12361 L
.53657 .12361 L
.53755 .12361 L
.53871 .12361 L
.53996 .12361 L
.54111 .12361 L
.5422 .12361 L
.54347 .12361 L
.54465 .12361 L
.54594 .12361 L
.54659 .12361 L
.54731 .12361 L
.54796 .12361 L
.54864 .12361 L
.54987 .12361 L
.55118 .12361 L
.55193 .12361 L
.55263 .12361 L
.55389 .12361 L
.55504 .12361 L
.55568 .12361 L
.55637 .12361 L
.55762 .12361 L
.55877 .12361 L
.55984 .12361 L
.56102 .12361 L
.56229 .12361 L
.56292 .12361 L
.56361 .12361 L
.56487 .12361 L
.56611 .12361 L
.56723 .12361 L
.56837 .12361 L
.56945 .12361 L
.57059 .12361 L
.57183 .12361 L
Mistroke
.57291 .12361 L
.57405 .12361 L
.57502 .12361 L
.57609 .12361 L
.5774 .12361 L
.57861 .12361 L
.57929 .12361 L
.57993 .12361 L
.5806 .12361 L
.58134 .12361 L
.58631 .12361 L
.59563 .12361 L
.61655 .12361 L
.65528 .12361 L
.69646 .12361 L
.73612 .12361 L
.77427 .12361 L
.81487 .12361 L
.85396 .12361 L
.8955 .12361 L
.93552 .12361 L
.97402 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Koooo1@00083oool009goool00`000?ooooooo`20oooo002Moooo00<0003ooooo
ool00oooo`<0001joooo002Eoooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0N_oo
o`00WOooo`030000oooooooo00?oool00`000?ooooooo`1joooo002Loooo0P0000Goool00`000?oo
ooooo`1joooo002Soooo00<0003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool2
0000Noooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0
003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002S
oooo00<0003oooooool0N_ooo`00Xoooo`80001koooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool00:?oool20000Noooo`00:oooo`<0000Xoooo0`0002?oool4
00008oooo`030000oooooooo02?oool400009oooo`<0000Yoooo000[oooo00@0003oooooool0000X
oooo00<0003oooooool08_ooo`030000oooooooo02Coool00`000?ooooooo`0Soooo00<0003ooooo
ool0:Oooo`030000oooooooo02Soool002_oool010000?ooooooo`0002Goool500009?ooo`030000
oooooooo02?oool00`000?ooooooo`0Toooo00<0003oooooool09Oooo`D0000Yoooo000Uoooo1000
00;oool300008?ooo`@00002oooo00@0003oooooool0000Noooo100000Coool00`000?ooooooo`0R
oooo00<0003oooooool09Oooo`030000oooooooo02Coool010000?ooooooo`0002[oool002coool0
0`000?ooooooo`0Voooo00<0003oool000009?ooo`040000oooooooo00008oooo`030000oooooooo
02?oool010000?ooooooo`0002Koool00`000?ooo`00000Zoooo000/oooo0`0002Ooool200009Ooo
o`80000Toooo0P0002Goool20000:?ooo`80000Zoooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool0013ooooo00004Oooo`005_ooo`03000006Ko06Ko00L0I_l0
1000001Vo`1Vo`1Vo`Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo
00Soool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?oo
ooooo`07oooo00<0003oool000000`00000306Ko0000000000X000000c?o000003?o0008<ol000<0
000co`0co`001c?o00030000<ol0<ol000Lco`000`000?ooooooo`07oooo00<0003oooooool01ooo
o`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo
00Ooool00`000?ooooooo`08oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?oo
ooooo`07oooo00<0003oooooool05Oooo`009?ooo`H0I_l01000001Vo`1Vo`1VobGoool00`000?oo
ooooo`0Qoooo00D0I_ooooooooooool000002?ooo`@0000K<ol000<0003oooooool09Oooo`030000
oooooooo02Koool00`000?ooooooo`0Yoooo000^oooo1@1VodCoool00`1Vooooooooo`0>oooo1000
01Lco`000`000?ooooooo`1joooo000coooo1@1Vocooool00`1Vooooooooo`0Boooo00<0000co`0c
o`0053?o00030000oooooooo07[oool003Soool306Ko??ooo`0306Kooooooooo01?oool2000053?o
00030000oooooooo07[oool003_oool206Ko>_ooo`0306Kooooooooo01Goool00`0003?o03?o000A
<ol000<0003oooooool0N_ooo`00?Oooo`80I_lhoooo00<0I_ooooooool05_ooo`030000<ol0<ol0
010co`020000Noooo`00?oooo`80I_lfoooo00<0I_ooooooool05oooo`80000@<ol000<0003ooooo
ool0N_ooo`00@Oooo`80I_ldoooo00<0I_ooooooool06Oooo`030000<ol0<ol000dco`000`000?oo
ooooo`1joooo0013oooo00<0I_ooooooool0<Oooo`0306Kooooooooo01Woool00`0003?o03?o000=
<ol000<0003oooooool0N_ooo`00A?ooo`80I_laoooo00<0I_ooooooool06_ooo`030000<ol0<ol0
00`co`000`000?ooooooo`1joooo0016oooo00<0I_ooooooool0;_ooo`0306Kooooooooo01[oool0
0`0003?o03?o000<<ol000<0003oooooool0N_ooo`00Aoooo`0306Kooooooooo02goool00`1Voooo
ooooo`0Koooo00<0000co`0co`002c?o0080001koooo0017oooo00<0I_ooooooool0;Oooo`0306Ko
oooooooo01_oool00`0003?o03?o000;<ol000<0003oooooool0N_ooo`00B?ooo`0306Kooooooooo
02coool00`1Vooooooooo`0Loooo00<0000co`0co`002S?o00030000oooooooo07[oool004Woool0
0`1Vooooooooo`0[oooo00<0I_ooooooool07?ooo`030000<ol0<ol000Xco`000`000?ooooooo`1j
oooo001:oooo00<0I_ooooooool0:_ooo`0306Kooooooooo01goool00`0003?o03?o0009<ol000<0
003oooooool0N_ooo`00Boooo`0306Kooooooooo02Woool00`1Vooooooooo`0Moooo00<0000co`0c
o`002C?o00030000oooooooo07[oool004coool00`1Vooooooooo`0Voooo0`1Vob3oool00`0003?o
03?o0008<ol00P0007_oool004goool00`1Vooooooooo`0Ooooo1P1Vo`;oool00ol0VOooooooo`0N
oooo00<0000co`0co`0023?o00030000oooooooo07[oool004koool00`1Vooooooooo`0Eoooo2@1V
o`Soool00ol0VOooooooo`0Noooo00<0000co`0co`0023?o00030000oooooooo07[oool004kooolH
06Ko4Oooo`03o`2Ioooooooo01ooool00`0003?o03?o0007<ol000<0003oooooool0N_ooo`00Mooo
o`03o`2Ioooooooo01ooool00`0003?o03?o0007<ol000<0003oooooool0N_ooo`00Moooo`03o`2I
oooooooo01ooool00`0003?o03?o0007<ol000<0003oooooool0N_ooo`00Moooo`03o`2Ioooooooo
01ooool00`0003?o03?o0007<ol00P0007_oool007Ooool00ol0VOooooooo`0Poooo00<0000co`0c
o`001S?o00030000oooooooo07[oool007Ooool00ol0VOooooooo`0Poooo00<0000co`0co`001S?o
00030000oooooooo07[oool007Ooool00ol0VOooooooo`0Poooo00<0000co`0co`001S?o00030000
oooooooo07[oool007Ooool00ol0VOooooooo`0Poooo00<0000co`0co`001S?o00030000oooooooo
07[oool007Ooool00ol0VOooooooo`0Qoooo1@0000<co`000`000?ooooooo`1joooo001goooo00?o
09Woooooool08Oooo`030000<ol0000000Dco`000`000?ooooooo`1joooo001goooo00?o09Wooooo
ool08Oooo`030000<ol0000000Dco`030000N_ooo`00Moooo`03o`2Ioooooooo02;oool200001C?o
00030000oooooooo07[oool007Ooool00ol0VOooooooo`0Roooo0P0000Dco`000`000?ooooooo`1j
oooo001goooo00?o09Woooooool08_ooo`800005<ol000<0003oooooool0N_ooo`00Moooo`03o`2I
oooooooo02;oool00`0003?o03?o0004<ol000<0003oooooool0N_ooo`00Moooo`03o`2Ioooooooo
02;oool00`0003?o03?o0004<ol000<0003oooooool0N_ooo`00Moooo`03o`2Ioooooooo02;oool0
0`0003?o03?o0004<ol00P0007_oool007Ooool00ol0VOooooooo`0Soooo00<0000co`0co`000c?o
00030000oooooooo07[oool007Ooool00ol0VOooooooo`0Soooo00<0000co`0co`000c?o00030000
oooooooo07[oool007Ooool00ol0VOooooooo`0Soooo00<0000co`0co`000c?o00030000oooooooo
07[oool007Ooool00ol0VOooooooo`0Soooo00<0000co`0co`000c?o00030000oooooooo07[oool0
07Ooool00ol0VOooooooo`0Soooo00<0000co`0co`000c?o00030000oooooooo07[oool007Ooool0
0ol0VOooooooo`0Soooo00<0000co`0co`000c?o0080001koooo001goooo00?o09Woooooool08ooo
o`030000<ol0<ol000<co`000`000?ooooooo`1joooo001goooo00?o09Woooooool08oooo`030000
<ol0<ol000<co`000`000?ooooooo`1joooo001goooo00?o09Woooooool09?ooo`030000<ol0<ol0
008co`000`000?ooooooo`1joooo001goooo00?o09Woooooool09?ooo`030000<ol0<ol0008co`00
0`000?ooooooo`1joooo001goooo00?o09Woooooool09?ooo`030000<ol0<ol0008co`000`000?oo
ooooo`1joooo001goooo00?o09Woooooool09?ooo`030000<ol0<ol0008co`000`000?ooooooo`1j
oooo001goooo00?o09Woooooool09?ooo`030000<ol0<ol0008co`020000Noooo`00Moooo`03o`2I
oooooooo02Coool00`0003?o03?o0002<ol000<0003oooooool0N_ooo`00Moooo`03o`2Ioooooooo
02Coool00`0003?o03?o0002<ol000<0003oooooool0N_ooo`00Moooo`03o`2Ioooooooo02Coool0
0`0003?o03?o0002<ol000<0003oooooool0N_ooo`00Moooo`03o`2Ioooooooo02Coool00`0003?o
03?o0002<ol000<0003oooooool0N_ooo`00Moooo`03o`2Ioooooooo02Coool00`0003?o03?o0002
<ol000<0003oooooool0N_ooo`00Moooo`03o`2Ioooooooo02Coool00`0003?o03?o0002<ol00P00
07_oool007Ooool00ol0VOooooooo`0Uoooo00D0000co`0co`0co`000000O?ooo`00Moooo`03o`2I
oooooooo02Goool01@0003?o03?o03?o0000001loooo001goooo00?o09Woooooool09Oooo`050000
<ol0<ol0<ol0000007coool007Ooool00ol0VOooooooo`0Qoooo1@0000<co`000`000?ooooooo`1j
oooo001goooo00?o09Woooooool08Oooo`050000oooooooooooo000000<co`000`000?ooooooo`1j
oooo001goooo00?o09Woooooool08_ooo`040000oooooooo00000c?o00<0001joooo001goooo00?o
09Woooooool08oooo`030000oooo000000<co`000`000?ooooooo`1joooo001goooo00?o09Wooooo
ool08Oooo`030000oooooooo00800003<ol000<0003oooooool0N_ooo`00Moooo`03o`2Ioooooooo
02;oool2000000?oool0000co`000S?o00030000oooooooo07[oool007Ooool00ol0VOooooooo`0U
oooo00D0000co`0co`0co`000000O?ooo`00Moooo`03o`2Ioooooooo02Koool0100003?o03?o0000
07coool007Ooool00ol0VOooooooo`0Voooo00<0000co`0co`000P0007_oool007Ooool00ol0VOoo
ooooo`0Voooo00@0000co`0co`00001loooo001goooo00?o09Woooooool09_ooo`040000<ol0<ol0
0000O?ooo`00Moooo`03o`2Ioooooooo02Koool0100003?o03?o000007coool007Ooool00ol0VOoo
ooooo`0Voooo00@0000co`0co`00001loooo001goooo00?o09Woooooool09_ooo`040000<ol0<ol0
0000O?ooo`00Moooo`03o`2Ioooooooo02Koool0100003?o03?o000007coool007Ooool00ol0VOoo
ooooo`0Woooo00@0000co`000000001koooo001goooo00?o09Woooooool09oooo`030000<ol00000
07coool007Ooool00ol0VOooooooo`0Woooo00<0000co`000000O?ooo`00Moooo`03o`2Ioooooooo
02Ooool00`0003?o0000001loooo001goooo00?o09Woooooool09oooo`030000<ol0000007coool0
07Ooool00ol0VOooooooo`0Woooo00<0000co`000000O?ooo`00Moooo`03o`2Ioooooooo02Ooool0
100003?o0000000007_oool007Ooool00ol0VOooooooo`0Woooo00<0000co`000000O?ooo`00Mooo
o`03o`2Ioooooooo02Ooool00`0003?o0000001loooo001goooo00?o09Woooooool09oooo`030000
<ol0000007coool007Ooool00ol0VOooooooo`0Woooo00<0000co`000000O?ooo`00Moooo`03o`2I
oooooooo02Ooool00`0003?o0000001loooo001goooo00?o09Woooooool09oooo`040000<ol00000
0000Noooo`00Moooo`03o`2Ioooooooo02Ooool00`0003?o0000001loooo001goooo00?o09Wooooo
ool09oooo`030000<ol0000007coool007Ooool00ol0VOooooooo`0Woooo00<0000co`000000O?oo
o`00Moooo`03o`2Ioooooooo02;oool200000oooo`030000<ol0000007coool007Ooool00ol0VOoo
ooooo`0Qoooo00@0003oooooool00002oooo00<0000co`000000O?ooo`00Moooo`03o`2Ioooooooo
02?oool01P000?ooooooooooo`0003?o00<0001joooo001goooo00?o09Woooooool09?ooo`060000
oooooooo0000<ol00000O?ooo`00Moooo`03o`2Ioooooooo027oool010000?ooooooo`0000;oool0
0`0003?o0000001loooo001goooo00?o09Woooooool08_ooo`800004oooo0P0007coool007Ooool0
0ol0VOooooooo`0Xoooo0P0007coool007Ooool00ol0VOooooooo`0Xoooo0P0007coool007Ooool0
0ol0VOooooooo`0Xoooo0P0007coool007Ooool00ol0VOooooooo`0Xoooo0`0007_oool007Ooool0
0ol0VOooooooo`0Xoooo0P0007coool007Ooool00ol0VOooooooo`0Xoooo0P0007coool007Ooool0
0ol0VOooooooo`0Xoooo0P0007coool007Ooool00ol0VOooooooo`0Xoooo0P0007coool007Ooool0
0ol0VOooooooo`0Xoooo0P0007coool007Ooool00ol0VOooooooo`0Xoooo0`0007_oool007Ooool0
0ol0VOooooooo`0Xoooo0P0007coool007Ooool00ol0VOooooooo`0Xoooo0P0007coool007Ooool0
0ol0VOooooooo`0Xoooo0P0007coool007Ooool00ol0VOooooooo`0Xoooo0P0007coool007Ooool0
0ol0VOooooooo`0Xoooo0P0007coool007Ooool00ol0VOooooooo`0Xoooo0`0007_oool007Ooool0
0ol0VOooooooo`0Yoooo00<0003oooooool0N_ooo`00Moooo`03o`2Ioooooooo02Woool00`000?oo
ooooo`1joooo001goooo00?o09Woooooool0:Oooo`030000oooooooo07[oool007Ooool00ol0VOoo
ooooo`0Yoooo00<0003oooooool0N_ooo`00Moooo`03o`2Ioooooooo02Woool00`000?ooooooo`1j
oooo001goooo00?o09Woooooool0:Oooo`80001koooo001goooo00?o09Woooooool0:Oooo`030000
oooooooo07[oool007Ooool00ol0VOooooooo`0Yoooo00<0003oooooool0N_ooo`00Moooo`03o`2I
oooooooo02Woool00`000?ooooooo`1joooo001goooo00?o09Woooooool0:Oooo`030000oooooooo
07[oool007Ooool00ol0VOooooooo`0Soooo0`0000?oool00`000?ooooooo`1joooo001goooo00?o
09Woooooool09?ooo`030000oooooooo00;oool00`000?ooooooo`1joooo001goooo00?o09Wooooo
ool08Oooo`D00003oooo0`0007[oool009_oool010000?ooooooo`00087oool009coool00`000?oo
o`000021oooo002Moooo0P00087oool00?oooolQoooo003ooooo8Oooo`00NOooo`030000oooooooo
02Soool00`000?ooooooo`1ioooo001hoooo00<0003oooooool02?ooo`030000oooooooo01ooool0
0`000?ooooooo`1hoooo001hoooo00<0003oooooool00_ooo`800004oooo00<0003oooooool03Ooo
o`800004oooo0P0000?oool400000oooo`030000oooooooo07Soool007Soool01@000?oooooooooo
o`000002oooo00<0003oooooool00_ooo`030000oooooooo00Coool400000oooo`040000oooooooo
00002?ooo`030000oooooooo00Coool00`000?ooooooo`1hoooo001goooo00<0003oooooool00_oo
o`030000oooooooo01Goool00`000?ooooooo`08oooo00<0003oooooool01?ooo`030000oooooooo
07Ooool007Soool00`000?ooooooo`0500005Oooo`030000oooooooo00Soool00`000?ooooooo`02
oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000001Goool010000?ooooooo`00
00Soool010000?ooooooo`0000?oool00`000?ooooooo`1hoooo001ioooo00<0003oooooool05ooo
o`80000:oooo0P0000?oool00`000?ooooooo`1ioooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-8.12947, \
-1.14361, 0.0496935, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-8.12947, -1.14361, 0.0496935, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
.2 1 0 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.40134 .12361 L
.40616 .12361 L
.40882 .12361 L
.41013 .12361 L
.41134 .12361 L
.41203 .12361 L
s
.41203 .12361 m
.41232 .61803 L
s
0 .4 1 r
.02381 .12504 m
.04262 .12561 L
.06244 .12646 L
.07286 .12704 L
.08255 .12769 L
.09388 .1286 L
.10458 .12965 L
.125 .1323 L
.14357 .1357 L
.16355 .14088 L
.18199 .14759 L
.20071 .1571 L
.21136 .16409 L
.22134 .17197 L
.23988 .1909 L
.24967 .20373 L
.25102 .20569 L
.25249 .20786 L
.25316 .20888 L
.25387 .20996 L
.25514 .21009 L
.25637 .21007 L
.25751 .21005 L
.26011 .21001 L
.27107 .20979 L
.28124 .20955 L
.30133 .20892 L
.31179 .20849 L
.32169 .20801 L
.34024 .20683 L
.36015 .20505 L
.37857 .20274 L
.39724 .19949 L
.40235 .1984 L
.40504 .19778 L
.40786 .1971 L
.41035 .19647 L
.41103 .1963 L
.41176 .19611 L
.41307 .12361 L
.41435 .12361 L
.41557 .12361 L
.41666 .12361 L
.41784 .12361 L
.41907 .12361 L
.4202 .12361 L
.42149 .12361 L
.42273 .12361 L
.42386 .12361 L
.42492 .12361 L
Mistroke
.42607 .12361 L
.4273 .12361 L
.42801 .12361 L
.42866 .12361 L
.42937 .12361 L
.43012 .12361 L
.43277 .12361 L
.43391 .12361 L
.43513 .12361 L
.43583 .12361 L
.43647 .12361 L
.43771 .12361 L
.43902 .12361 L
.43968 .12361 L
.44041 .12361 L
.44169 .12361 L
.4429 .12361 L
.44359 .12361 L
.44431 .12361 L
.44561 .12361 L
.44633 .12361 L
.447 .12361 L
.44774 .12361 L
.44853 .12361 L
.44922 .12361 L
.44985 .12361 L
.45055 .12361 L
.45129 .12361 L
.45253 .12361 L
.45323 .12361 L
.45389 .12361 L
.45512 .12361 L
.45624 .12361 L
.45753 .12361 L
.45876 .12361 L
.45989 .12361 L
.46112 .12361 L
.46227 .12361 L
.46334 .12361 L
.46451 .12361 L
.4658 .12361 L
.46645 .12361 L
.46714 .12361 L
.46839 .12361 L
.46908 .12361 L
.46972 .12361 L
.47042 .12361 L
.47115 .12361 L
.4724 .12361 L
.4731 .12361 L
Mistroke
.47376 .12361 L
.47499 .12361 L
.47611 .12361 L
.47741 .12361 L
.47864 .12361 L
.4798 .12361 L
.48085 .12361 L
.48207 .12361 L
.48321 .12361 L
.48427 .12361 L
.48525 .12361 L
.48632 .12361 L
.48745 .12361 L
.48859 .12361 L
.48982 .12361 L
.49097 .12361 L
.49203 .12361 L
.49327 .12361 L
.49396 .12361 L
.49461 .12361 L
.4958 .12361 L
.49705 .12361 L
.49819 .12361 L
.49944 .12361 L
.50074 .12361 L
.50195 .12361 L
.50309 .12361 L
.50412 .12361 L
.50531 .12361 L
.50643 .12361 L
.50766 .12361 L
.50896 .12361 L
.51007 .12361 L
.51128 .12361 L
.51259 .12361 L
.51333 .12361 L
.514 .12361 L
.5153 .12361 L
.51654 .12361 L
.5177 .12361 L
.51874 .12361 L
.51995 .12361 L
.52108 .12361 L
.52214 .12361 L
.52311 .12361 L
.52417 .12361 L
.52529 .12361 L
.52642 .12361 L
.52749 .12361 L
.52872 .12361 L
Mistroke
.52984 .12361 L
.53108 .12361 L
.53178 .12361 L
.53242 .12361 L
.53359 .12361 L
.53483 .12361 L
.53603 .12361 L
.53734 .12361 L
.53858 .12361 L
.53974 .12361 L
.54088 .12361 L
.54191 .12361 L
.5431 .12361 L
.54423 .12361 L
.54546 .12361 L
.54676 .12361 L
.54787 .12361 L
.54909 .12361 L
.5504 .12361 L
.55114 .12361 L
.55181 .12361 L
.55311 .12361 L
.55435 .12361 L
.5554 .12361 L
.55656 .12361 L
.55777 .12361 L
.5589 .12361 L
.55996 .12361 L
.56093 .12361 L
.56199 .12361 L
.56311 .12361 L
.56425 .12361 L
.56547 .12361 L
.56662 .12361 L
.56767 .12361 L
.5689 .12361 L
.56959 .12361 L
.57023 .12361 L
.5714 .12361 L
.57265 .12361 L
.57386 .12361 L
.57518 .12361 L
.57642 .12361 L
.57757 .12361 L
.57872 .12361 L
.57976 .12361 L
.58095 .12361 L
.58208 .12361 L
.59221 .12361 L
.61052 .12361 L
Mistroke
.64911 .12361 L
.69016 .12361 L
.72968 .12361 L
.7677 .12361 L
.80816 .12361 L
.84711 .12361 L
.88851 .12361 L
.92839 .12361 L
.96676 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Koooo1@00083oool009goool00`000?ooooooo`20oooo002Moooo00<0003ooooo
ool00oooo`<0001joooo002Eoooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0N_oo
o`00WOooo`030000oooooooo00?oool00`000?ooooooo`1joooo002Loooo0P0000Goool00`000?oo
ooooo`1joooo002Soooo00<0003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool2
0000Noooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0
003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002S
oooo00<0003oooooool0N_ooo`00Xoooo`80001koooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool00:?oool20000Noooo`00:oooo`<0000Xoooo0`0002?oool4
00008oooo`030000oooooooo02?oool400009oooo`<0000Yoooo000[oooo00@0003oooooool0000X
oooo00<0003oooooool08_ooo`030000oooooooo02Coool00`000?ooooooo`0Soooo00<0003ooooo
ool0:Oooo`030000oooooooo02Soool002_oool010000?ooooooo`0002Goool500009?ooo`030000
oooooooo02?oool00`000?ooooooo`0Toooo00<0003oooooool09Oooo`D0000Yoooo000Uoooo1000
00;oool300008?ooo`@00002oooo00@0003oooooool0000Noooo100000Coool00`000?ooooooo`0R
oooo00<0003oooooool09Oooo`030000oooooooo02Coool010000?ooooooo`0002[oool002coool0
0`000?ooooooo`0Voooo00<0003oool000009?ooo`040000oooooooo00008oooo`030000oooooooo
02?oool010000?ooooooo`0002Koool00`000?ooo`00000Zoooo000/oooo0`0002Ooool200009Ooo
o`80000Toooo0P0002Goool20000:?ooo`80000Zoooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool0013ooooo00004Oooo`005_ooo`03000006Ko06Ko00L0I_l0
0`00001Vo`1Vo`0406Ko0oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool02?ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Ooool00`000?ooo`000005000000<0I_l00000000020000003<ol00000<ol000Pco`00
0`0003?o03?o0007<ol000<0000co`0co`001c?o00030000oooooooo00Ooool00`000?ooooooo`07
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooooooo00Soool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Ooool00`000?ooooooo`0Eoooo000Woooo0`1Vo`04000006Ko06Ko06Ko9Oooo`030000
oooooooo02?oool00`1Vooooo`000008oooo100001/co`000`000?ooooooo`0Uoooo00<0003ooooo
ool09_ooo`030000oooooooo02Woool002koool906Ko@_ooo`0306Kooooooooo00coool400005c?o
00030000oooooooo07[oool003Ooool206Ko@?ooo`0306Kooooooooo013oool00`0003?o03?o000D
<ol000<0003oooooool0N_ooo`00>Oooo`<0I_lmoooo00<0I_ooooooool04Oooo`80000D<ol000<0
003oooooool0N_ooo`00??ooo`<0I_ljoooo00<0I_ooooooool04oooo`030000<ol0<ol0014co`00
0`000?ooooooo`1joooo000ooooo0P1VocSoool00`1Vooooooooo`0Doooo00<0000co`0co`0043?o
0080001koooo0011oooo0P1VocKoool00`1Vooooooooo`0Eoooo0P00010co`000`000?ooooooo`1j
oooo0013oooo00<0I_ooooooool0<oooo`0306Kooooooooo01Ooool00`0003?o03?o000=<ol000<0
003oooooool0N_ooo`00A?ooo`80I_lcoooo00<0I_ooooooool05oooo`030000<ol0<ol000dco`00
0`000?ooooooo`1joooo0016oooo00<0I_ooooooool0<?ooo`0306Kooooooooo01Soool00`0003?o
03?o000<<ol000<0003oooooool0N_ooo`00Aoooo`0306Kooooooooo02ooool00`1Vooooooooo`0H
oooo00<0000co`0co`0033?o00030000oooooooo07[oool004Soool00`1Vooooooooo`0^oooo00<0
I_ooooooool06Oooo`030000<ol0<ol000/co`020000Noooo`00BOooo`0306Kooooooooo02goool0
0`1Vooooooooo`0Ioooo00<0000co`0co`002c?o00030000oooooooo07[oool004[oool206Ko;Ooo
o`0306Kooooooooo01[oool00`0003?o03?o000:<ol000<0003oooooool0N_ooo`00C?ooo`0306Ko
oooooooo02[oool00`1Vooooooooo`0Joooo00<0000co`0co`002S?o00030000oooooooo07[oool0
04goool00`1Vooooooooo`0Yoooo00<0I_ooooooool06oooo`030000<ol0<ol000Tco`000`000?oo
ooooo`1joooo001=oooo00<0I_ooooooool0:Oooo`0306Kooooooooo01_oool00`0003?o03?o0009
<ol000<0003oooooool0N_ooo`00C_ooo`0306Kooooooooo02Goool406Ko7_ooo`030000<ol0<ol0
00Pco`020000Noooo`00C_ooo`0306Kooooooooo01koool706Ko0oooo`03o`2Ioooooooo01coool0
0`0003?o03?o0008<ol000<0003oooooool0N_ooo`00Coooo`80I_lIoooo1@1Vo`[oool00ol0VOoo
ooooo`0Loooo00<0000co`0co`0023?o00030000oooooooo07[oool0053ooolJ06Ko3oooo`03o`2I
oooooooo01goool00`0003?o03?o0007<ol000<0003oooooool0N_ooo`00NOooo`03o`2Ioooooooo
01goool00`0003?o03?o0007<ol000<0003oooooool0N_ooo`00NOooo`03o`2Ioooooooo01goool0
0`0003?o03?o0007<ol000<0003oooooool0N_ooo`00NOooo`03o`2Ioooooooo01goool00`0003?o
03?o0007<ol00P0007_oool007Woool00ol0VOooooooo`0Noooo00<0000co`0co`001S?o00030000
oooooooo07[oool007Woool00ol0VOooooooo`0Noooo00<0000co`0co`001S?o00030000oooooooo
07[oool007Woool00ol0VOooooooo`0Noooo00<0000co`0co`001S?o00030000oooooooo07[oool0
07Woool00ol0VOooooooo`0Noooo00<0000co`0co`001S?o00030000oooooooo07[oool007Woool0
0ol0VOooooooo`0Ooooo1@0000<co`000`000?ooooooo`1joooo001ioooo00?o09Woooooool07ooo
o`030000<ol0000000Dco`000`000?ooooooo`1joooo001ioooo00?o09Woooooool07oooo`030000
<ol0000000Dco`030000N_ooo`00NOooo`03o`2Ioooooooo023oool200001C?o00030000oooooooo
07[oool007Woool00ol0VOooooooo`0Poooo0P0000Dco`000`000?ooooooo`1joooo001ioooo00?o
09Woooooool08?ooo`800005<ol000<0003oooooool0N_ooo`00NOooo`03o`2Ioooooooo023oool0
0`0003?o03?o0004<ol000<0003oooooool0N_ooo`00NOooo`03o`2Ioooooooo023oool00`0003?o
03?o0004<ol000<0003oooooool0N_ooo`00NOooo`03o`2Ioooooooo023oool00`0003?o03?o0004
<ol00P0007_oool007Woool00ol0VOooooooo`0Qoooo00<0000co`0co`000c?o00030000oooooooo
07[oool007Woool00ol0VOooooooo`0Qoooo00<0000co`0co`000c?o00030000oooooooo07[oool0
07Woool00ol0VOooooooo`0Qoooo00<0000co`0co`000c?o00030000oooooooo07[oool007Woool0
0ol0VOooooooo`0Qoooo00<0000co`0co`000c?o00030000oooooooo07[oool007Woool00ol0VOoo
ooooo`0Qoooo00<0000co`0co`000c?o00030000oooooooo07[oool007Woool00ol0VOooooooo`0Q
oooo00<0000co`0co`000c?o0080001koooo001ioooo00?o09Woooooool08Oooo`030000<ol0<ol0
00<co`000`000?ooooooo`1joooo001ioooo00?o09Woooooool08Oooo`030000<ol0<ol000<co`00
0`000?ooooooo`1joooo001ioooo00?o09Woooooool08_ooo`030000<ol0<ol0008co`000`000?oo
ooooo`1joooo001ioooo00?o09Woooooool08_ooo`030000<ol0<ol0008co`000`000?ooooooo`1j
oooo001ioooo00?o09Woooooool08_ooo`030000<ol0<ol0008co`000`000?ooooooo`1joooo001i
oooo00?o09Woooooool08_ooo`030000<ol0<ol0008co`000`000?ooooooo`1joooo001ioooo00?o
09Woooooool08_ooo`030000<ol0<ol0008co`020000Noooo`00NOooo`03o`2Ioooooooo02;oool0
0`0003?o03?o0002<ol000<0003oooooool0N_ooo`00NOooo`03o`2Ioooooooo02;oool00`0003?o
03?o0002<ol000<0003oooooool0N_ooo`00NOooo`03o`2Ioooooooo02;oool00`0003?o03?o0002
<ol000<0003oooooool0N_ooo`00NOooo`03o`2Ioooooooo02;oool00`0003?o03?o0002<ol000<0
003oooooool0N_ooo`00NOooo`03o`2Ioooooooo02;oool00`0003?o03?o0002<ol000<0003ooooo
ool0N_ooo`00NOooo`03o`2Ioooooooo02;oool00`0003?o03?o0002<ol00P0007_oool007Woool0
0ol0VOooooooo`0Soooo00D0000co`0co`0co`000000O?ooo`00NOooo`03o`2Ioooooooo02?oool0
1@0003?o03?o03?o0000001loooo001ioooo00?o09Woooooool08oooo`050000<ol0<ol0<ol00000
07coool007Woool00ol0VOooooooo`0Ooooo1@0000<co`000`000?ooooooo`1joooo001ioooo00?o
09Woooooool07oooo`050000oooooooooooo000000<co`000`000?ooooooo`1joooo001ioooo00?o
09Woooooool08?ooo`040000oooooooo00000c?o00<0001joooo001ioooo00?o09Woooooool08Ooo
o`030000oooo000000<co`000`000?ooooooo`1joooo001ioooo00?o09Woooooool07oooo`030000
oooooooo00800003<ol000<0003oooooool0N_ooo`00NOooo`03o`2Ioooooooo023oool2000000?o
ool0000co`000S?o00030000oooooooo07[oool007Woool00ol0VOooooooo`0Soooo00D0000co`0c
o`0co`000000O?ooo`00NOooo`03o`2Ioooooooo02Coool0100003?o03?o000007coool007Woool0
0ol0VOooooooo`0Toooo00<0000co`0co`000P0007_oool007Woool00ol0VOooooooo`0Toooo00@0
000co`0co`00001loooo001ioooo00?o09Woooooool09?ooo`040000<ol0<ol00000O?ooo`00NOoo
o`03o`2Ioooooooo02Coool0100003?o03?o000007coool007Woool00ol0VOooooooo`0Toooo00@0
000co`0co`00001loooo001ioooo00?o09Woooooool09?ooo`040000<ol0<ol00000O?ooo`00NOoo
o`03o`2Ioooooooo02Coool0100003?o03?o000007coool007Woool00ol0VOooooooo`0Uoooo00@0
000co`000000001koooo001ioooo00?o09Woooooool09Oooo`030000<ol0000007coool007Woool0
0ol0VOooooooo`0Uoooo00<0000co`000000O?ooo`00NOooo`03o`2Ioooooooo02Goool00`0003?o
0000001loooo001ioooo00?o09Woooooool09Oooo`030000<ol0000007coool007Woool00ol0VOoo
ooooo`0Uoooo00<0000co`000000O?ooo`00NOooo`03o`2Ioooooooo02Goool0100003?o00000000
07_oool007Woool00ol0VOooooooo`0Uoooo00<0000co`000000O?ooo`00NOooo`03o`2Ioooooooo
02Goool00`0003?o0000001loooo001ioooo00?o09Woooooool09Oooo`030000<ol0000007coool0
07Woool00ol0VOooooooo`0Uoooo00<0000co`000000O?ooo`00NOooo`03o`2Ioooooooo02Goool0
0`0003?o0000001loooo001ioooo00?o09Woooooool09Oooo`040000<ol000000000Noooo`00NOoo
o`03o`2Ioooooooo02Goool00`0003?o0000001loooo001ioooo00?o09Woooooool09Oooo`030000
<ol0000007coool007Woool00ol0VOooooooo`0Uoooo00<0000co`000000O?ooo`00NOooo`03o`2I
oooooooo023oool200000oooo`030000<ol0000007coool007Woool00ol0VOooooooo`0Ooooo00@0
003oooooool00002oooo00<0000co`000000O?ooo`00NOooo`03o`2Ioooooooo027oool01P000?oo
ooooooooo`0003?o00<0001joooo001ioooo00?o09Woooooool08_ooo`060000oooooooo0000<ol0
0000O?ooo`00NOooo`03o`2Ioooooooo01ooool010000?ooooooo`0000;oool00`0003?o0000001l
oooo001ioooo00?o09Woooooool08?ooo`800004oooo0P0007coool007Woool00ol0VOooooooo`0V
oooo0P0007coool007Woool00ol0VOooooooo`0Voooo0P0007coool007Woool00ol0VOooooooo`0V
oooo0P0007coool007Woool00ol0VOooooooo`0Voooo0`0007_oool007Woool00ol0VOooooooo`0V
oooo0P0007coool007Woool00ol0VOooooooo`0Voooo0P0007coool007Woool00ol0VOooooooo`0V
oooo0P0007coool007Woool00ol0VOooooooo`0Voooo0P0007coool007Woool00ol0VOooooooo`0V
oooo0P0007coool007Woool00ol0VOooooooo`0Voooo0`0007_oool007Woool00ol0VOooooooo`0V
oooo0P0007coool007Woool00ol0VOooooooo`0Voooo0P0007coool007Woool00ol0VOooooooo`0V
oooo0P0007coool007Woool00ol0VOooooooo`0Voooo0P0007coool007Woool00ol0VOooooooo`0V
oooo0P0007coool007Woool00ol0VOooooooo`0Voooo0`0007_oool007Woool00ol0VOooooooo`0W
oooo00<0003oooooool0N_ooo`00NOooo`03o`2Ioooooooo02Ooool00`000?ooooooo`1joooo001i
oooo00?o09Woooooool09oooo`030000oooooooo07[oool007Woool00ol0VOooooooo`0Woooo00<0
003oooooool0N_ooo`00NOooo`03o`2Ioooooooo02Ooool00`000?ooooooo`1joooo001ioooo00?o
09Woooooool09oooo`80001koooo001ioooo00?o09Woooooool09oooo`030000oooooooo07[oool0
07Woool00ol0VOooooooo`0Woooo00<0003oooooool0N_ooo`00NOooo`03o`2Ioooooooo02Ooool0
0`000?ooooooo`1joooo001ioooo00?o09Woooooool09oooo`030000oooooooo07[oool007Woool0
0ol0VOooooooo`0Qoooo0`0000?oool00`000?ooooooo`1joooo001ioooo00?o09Woooooool08_oo
o`030000oooooooo00;oool00`000?ooooooo`1joooo001ioooo00?o09Woooooool07oooo`D00003
oooo0`0007[oool009_oool010000?ooooooo`00087oool009coool00`000?ooo`000021oooo002M
oooo0P00087oool00?oooolQoooo003ooooo8Oooo`00NOooo`030000oooooooo02Soool00`000?oo
ooooo`1ioooo001hoooo00<0003oooooool02?ooo`030000oooooooo01ooool00`000?ooooooo`1h
oooo001hoooo00<0003oooooool00_ooo`800004oooo00<0003oooooool03Oooo`800004oooo0P00
00?oool500000_ooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`000002oooo00<0
003oooooool00_ooo`030000oooooooo00Coool400000oooo`040000oooooooo00002_ooo`030000
oooooooo00;oool00`000?ooooooo`1hoooo001goooo00<0003oooooool00_ooo`030000oooooooo
01Goool00`000?ooooooo`09oooo00<0003oooooool00oooo`030000oooooooo07Ooool007Soool0
0`000?ooooooo`0500005Oooo`030000oooooooo00Soool00`000?ooooooo`02oooo00<0003ooooo
ool0N?ooo`00N?ooo`050000oooooooooooo000001Goool010000?ooooooo`0000[oool00`000?oo
ooooo`02oooo00<0003oooooool0N?ooo`00NOooo`030000oooooooo01Ooool200002_ooo`800003
oooo00<0003oooooool0NOooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-8.12947, \
-1.14361, 0.0496935, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-8.12947, -1.14361, 0.0496935, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
.2 1 0 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.40134 .12361 L
.41134 .12361 L
.41408 .12361 L
.41703 .12361 L
.41846 .12361 L
.41917 .12361 L
.41982 .12361 L
s
.41982 .12361 m
.42031 .61803 L
s
0 .4 1 r
.02381 .12485 m
.04262 .12534 L
.06244 .12608 L
.07286 .12659 L
.08255 .12715 L
.09388 .12794 L
.10458 .12885 L
.125 .13115 L
.14357 .13411 L
.16355 .1386 L
.18199 .14443 L
.20071 .15268 L
.21136 .15875 L
.22134 .16559 L
.24158 .18383 L
.25055 .19426 L
.25547 .20074 L
.26011 .20738 L
.26132 .2092 L
.26259 .21009 L
.26326 .21008 L
.26399 .21007 L
.26527 .21005 L
.26995 .20997 L
.27909 .20978 L
.28993 .20952 L
.29982 .20923 L
.31933 .2085 L
.33007 .20797 L
.34024 .20736 L
.36015 .20581 L
.37857 .2038 L
.39724 .20097 L
.40798 .19886 L
.41269 .1978 L
.41518 .19721 L
.41784 .19654 L
.41915 .1962 L
.4204 .19587 L
.42151 .12361 L
.42272 .12361 L
.42387 .12361 L
.42508 .12361 L
.42612 .12361 L
.42726 .12361 L
.42855 .12361 L
.42973 .12361 L
.43039 .12361 L
.4311 .12361 L
.43239 .12361 L
Mistroke
.43359 .12361 L
.43488 .12361 L
.43609 .12361 L
.43719 .12361 L
.43849 .12361 L
.4397 .12361 L
.44096 .12361 L
.44163 .12361 L
.44235 .12361 L
.44313 .12361 L
.44387 .12361 L
.44454 .12361 L
.44526 .12361 L
.44593 .12361 L
.44665 .12361 L
.44793 .12361 L
.44913 .12361 L
.45041 .12361 L
.45163 .12361 L
.45274 .12361 L
.45398 .12361 L
.45467 .12361 L
.45532 .12361 L
.45664 .12361 L
.45737 .12361 L
.45804 .12361 L
.45924 .12361 L
.46036 .12361 L
.46159 .12361 L
.46291 .12361 L
.46357 .12361 L
.46429 .12361 L
.4656 .12361 L
.46687 .12361 L
.46805 .12361 L
.46914 .12361 L
.47017 .12361 L
.4713 .12361 L
.47252 .12361 L
.47372 .12361 L
.47499 .12361 L
.47608 .12361 L
.47726 .12361 L
.47794 .12361 L
.47867 .12361 L
.47936 .12361 L
.47999 .12361 L
.4812 .12361 L
.48247 .12361 L
.48313 .12361 L
Mistroke
.48384 .12361 L
.48512 .12361 L
.4859 .12361 L
.48665 .12361 L
.48731 .12361 L
.48804 .12361 L
.48936 .12361 L
.49056 .12361 L
.49123 .12361 L
.49194 .12361 L
.49325 .12361 L
.49447 .12361 L
.49576 .12361 L
.49687 .12361 L
.49808 .12361 L
.49929 .12361 L
.50059 .12361 L
.50126 .12361 L
.50201 .12361 L
.50332 .12361 L
.50456 .12361 L
.50525 .12361 L
.50589 .12361 L
.50706 .12361 L
.50829 .12361 L
.50941 .12361 L
.5106 .12361 L
.51172 .12361 L
.51274 .12361 L
.51394 .12361 L
.51524 .12361 L
.51647 .12361 L
.5176 .12361 L
.51881 .12361 L
.5201 .12361 L
.52122 .12361 L
.52244 .12361 L
.52318 .12361 L
.52387 .12361 L
.52453 .12361 L
.52522 .12361 L
.52591 .12361 L
.52656 .12361 L
.52776 .12361 L
.52908 .12361 L
.52974 .12361 L
.53046 .12361 L
.53174 .12361 L
.53294 .12361 L
.53366 .12361 L
Mistroke
.53435 .12361 L
.53563 .12361 L
.53635 .12361 L
.53702 .12361 L
.53775 .12361 L
.53852 .12361 L
.53972 .12361 L
.54104 .12361 L
.5422 .12361 L
.54343 .12361 L
.54465 .12361 L
.54576 .12361 L
.54688 .12361 L
.54793 .12361 L
.54916 .12361 L
.55046 .12361 L
.55157 .12361 L
.55279 .12361 L
.5541 .12361 L
.55483 .12361 L
.55551 .12361 L
.55681 .12361 L
.55805 .12361 L
.55909 .12361 L
.56025 .12361 L
.56146 .12361 L
.5626 .12361 L
.56365 .12361 L
.56462 .12361 L
.56569 .12361 L
.56681 .12361 L
.56795 .12361 L
.56917 .12361 L
.57032 .12361 L
.57136 .12361 L
.57259 .12361 L
.57328 .12361 L
.57392 .12361 L
.5751 .12361 L
.57634 .12361 L
.57755 .12361 L
.57887 .12361 L
.58012 .12361 L
.58127 .12361 L
.58577 .12361 L
.59591 .12361 L
.61422 .12361 L
.65339 .12361 L
.69501 .12361 L
.73512 .12361 L
Mistroke
.77371 .12361 L
.81475 .12361 L
.85428 .12361 L
.89229 .12361 L
.93275 .12361 L
.9717 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Koooo1@00083oool009goool00`000?ooooooo`20oooo002Moooo00<0003ooooo
ool00oooo`<0001joooo002Eoooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0N_oo
o`00WOooo`030000oooooooo00?oool00`000?ooooooo`1joooo002Loooo0P0000Goool00`000?oo
ooooo`1joooo002Soooo00<0003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool2
0000Noooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0
003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002S
oooo00<0003oooooool0N_ooo`00Xoooo`80001koooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool00:?oool20000Noooo`00:oooo`<0000Xoooo0`0002?oool4
00008oooo`030000oooooooo02?oool400009oooo`<0000Yoooo000[oooo00@0003oooooool0000X
oooo00<0003oooooool08_ooo`030000oooooooo02Coool00`000?ooooooo`0Soooo00<0003ooooo
ool0:Oooo`030000oooooooo02Soool002_oool010000?ooooooo`0002Goool500009?ooo`030000
oooooooo02?oool00`000?ooooooo`0Toooo00<0003oooooool09Oooo`D0000Yoooo000Uoooo1000
00;oool300008?ooo`@00002oooo00@0003oooooool0000Noooo100000Coool00`000?ooooooo`0R
oooo00<0003oooooool09Oooo`030000oooooooo02Coool010000?ooooooo`0002[oool002coool0
0`000?ooooooo`0Voooo00<0003oool000009?ooo`040000oooooooo00008oooo`030000oooooooo
02?oool010000?ooooooo`0002Koool00`000?ooo`00000Zoooo000/oooo0`0002Ooool200009Ooo
o`80000Toooo0P0002Goool20000:?ooo`80000Zoooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool0013ooooo00004Oooo`005_ooo`03000006Ko06Ko00L0I_l0
0`00001Vo`1Vo`0406Ko0oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool02?ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Ooool00`000?ooo`00000@000000<co`00000co`0023?o00030000<ol0<ol000Lco`00
0`0003?o03?o0007<ol000<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool02?ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo01Goool002Ooool306Ko00<00000I_l0I_l01P1Vob3oool00`000?ooooooo`0Uoooo00<0
003oooooool01_ooo`@0000K<ol000<0003oooooool09Oooo`030000oooooooo02Koool00`000?oo
ooooo`0Yoooo000coooo1@1Vod?oool00`1Vooooooooo`0:oooo100001Lco`000`000?ooooooo`1j
oooo000hoooo0`1Vod3oool00`1Vooooooooo`0>oooo00<0000co`0co`0053?o00030000oooooooo
07[oool003_oool206Ko?_ooo`0306Kooooooooo00ooool2000053?o00030000oooooooo07[oool0
03goool306Ko>oooo`0306Kooooooooo017oool00`0003?o03?o000A<ol000<0003oooooool0N_oo
o`00@?ooo`80I_lioooo00<0I_ooooooool04_ooo`030000<ol0<ol0010co`020000Noooo`00@_oo
o`<0I_lfoooo00<0I_ooooooool04oooo`80000@<ol000<0003oooooool0N_ooo`00AOooo`80I_ld
oooo00<0I_ooooooool05Oooo`030000<ol0<ol000dco`000`000?ooooooo`1joooo0017oooo00<0
I_ooooooool0<Oooo`0306Kooooooooo01Goool00`0003?o03?o000=<ol000<0003oooooool0N_oo
o`00B?ooo`0306Kooooooooo033oool00`1Vooooooooo`0Foooo00<0000co`0co`0033?o00030000
oooooooo07[oool004Woool00`1Vooooooooo`0_oooo00<0I_ooooooool05_ooo`030000<ol0<ol0
00`co`000`000?ooooooo`1joooo001:oooo00<0I_ooooooool0;_ooo`0306Kooooooooo01Ooool0
0`0003?o03?o000;<ol00P0007_oool004_oool00`1Vooooooooo`0]oooo00<0I_ooooooool05ooo
o`030000<ol0<ol000/co`000`000?ooooooo`1joooo001<oooo00<0I_ooooooool0;?ooo`0306Ko
oooooooo01Soool00`0003?o03?o000:<ol000<0003oooooool0N_ooo`00COooo`0306Kooooooooo
02_oool00`1Vooooooooo`0Hoooo00<0000co`0co`002S?o00030000oooooooo07[oool004koool2
06Ko:oooo`0306Kooooooooo01Woool00`0003?o03?o0009<ol000<0003oooooool0N_ooo`00D?oo
o`0306Kooooooooo02Soool00`1Vooooooooo`0Ioooo00<0000co`0co`002C?o00030000oooooooo
07[oool0053oool00`1Vooooooooo`0Toooo1@1Voacoool00`0003?o03?o0008<ol00P0007_oool0
057oool00`1Vooooooooo`0Ooooo101Vo`Coool00ol0VOooooooo`0Joooo00<0000co`0co`0023?o
00030000oooooooo07[oool0057oool00`1Vooooooooo`0Foooo2@1Vo`Soool00ol0VOooooooo`0J
oooo00<0000co`0co`0023?o00030000oooooooo07[oool005;ooolH06Ko4Oooo`03o`2Ioooooooo
01_oool00`0003?o03?o0007<ol000<0003oooooool0N_ooo`00Noooo`03o`2Ioooooooo01_oool0
0`0003?o03?o0007<ol000<0003oooooool0N_ooo`00Noooo`03o`2Ioooooooo01_oool00`0003?o
03?o0007<ol000<0003oooooool0N_ooo`00Noooo`03o`2Ioooooooo01_oool00`0003?o03?o0007
<ol00P0007_oool007_oool00ol0VOooooooo`0Loooo00<0000co`0co`001S?o00030000oooooooo
07[oool007_oool00ol0VOooooooo`0Loooo00<0000co`0co`001S?o00030000oooooooo07[oool0
07_oool00ol0VOooooooo`0Loooo00<0000co`0co`001S?o00030000oooooooo07[oool007_oool0
0ol0VOooooooo`0Loooo00<0000co`0co`001S?o00030000oooooooo07[oool007_oool00ol0VOoo
ooooo`0Moooo1@0000<co`000`000?ooooooo`1joooo001koooo00?o09Woooooool07Oooo`030000
<ol0000000Dco`000`000?ooooooo`1joooo001koooo00?o09Woooooool07Oooo`030000<ol00000
00Dco`030000N_ooo`00Noooo`03o`2Ioooooooo01koool200001C?o00030000oooooooo07[oool0
07_oool00ol0VOooooooo`0Noooo0P0000Dco`000`000?ooooooo`1joooo001koooo00?o09Wooooo
ool07_ooo`800005<ol000<0003oooooool0N_ooo`00Noooo`03o`2Ioooooooo01koool00`0003?o
03?o0004<ol000<0003oooooool0N_ooo`00Noooo`03o`2Ioooooooo01koool00`0003?o03?o0004
<ol000<0003oooooool0N_ooo`00Noooo`03o`2Ioooooooo01koool00`0003?o03?o0004<ol00P00
07_oool007_oool00ol0VOooooooo`0Ooooo00<0000co`0co`000c?o00030000oooooooo07[oool0
07_oool00ol0VOooooooo`0Ooooo00<0000co`0co`000c?o00030000oooooooo07[oool007_oool0
0ol0VOooooooo`0Ooooo00<0000co`0co`000c?o00030000oooooooo07[oool007_oool00ol0VOoo
ooooo`0Ooooo00<0000co`0co`000c?o00030000oooooooo07[oool007_oool00ol0VOooooooo`0O
oooo00<0000co`0co`000c?o00030000oooooooo07[oool007_oool00ol0VOooooooo`0Ooooo00<0
000co`0co`000c?o0080001koooo001koooo00?o09Woooooool07oooo`030000<ol0<ol000<co`00
0`000?ooooooo`1joooo001koooo00?o09Woooooool07oooo`030000<ol0<ol000<co`000`000?oo
ooooo`1joooo001koooo00?o09Woooooool08?ooo`030000<ol0<ol0008co`000`000?ooooooo`1j
oooo001koooo00?o09Woooooool08?ooo`030000<ol0<ol0008co`000`000?ooooooo`1joooo001k
oooo00?o09Woooooool08?ooo`030000<ol0<ol0008co`000`000?ooooooo`1joooo001koooo00?o
09Woooooool08?ooo`030000<ol0<ol0008co`000`000?ooooooo`1joooo001koooo00?o09Wooooo
ool08?ooo`030000<ol0<ol0008co`020000Noooo`00Noooo`03o`2Ioooooooo023oool00`0003?o
03?o0002<ol000<0003oooooool0N_ooo`00Noooo`03o`2Ioooooooo023oool00`0003?o03?o0002
<ol000<0003oooooool0N_ooo`00Noooo`03o`2Ioooooooo023oool00`0003?o03?o0002<ol000<0
003oooooool0N_ooo`00Noooo`03o`2Ioooooooo023oool00`0003?o03?o0002<ol000<0003ooooo
ool0N_ooo`00Noooo`03o`2Ioooooooo023oool00`0003?o03?o0002<ol000<0003oooooool0N_oo
o`00Noooo`03o`2Ioooooooo023oool00`0003?o03?o0002<ol00P0007_oool007_oool00ol0VOoo
ooooo`0Qoooo00D0000co`0co`0co`000000O?ooo`00Noooo`03o`2Ioooooooo027oool01@0003?o
03?o03?o0000001loooo001koooo00?o09Woooooool08Oooo`050000<ol0<ol0<ol0000007coool0
07_oool00ol0VOooooooo`0Moooo1@0000<co`000`000?ooooooo`1joooo001koooo00?o09Wooooo
ool07Oooo`050000oooooooooooo000000<co`000`000?ooooooo`1joooo001koooo00?o09Wooooo
ool07_ooo`040000oooooooo00000c?o00<0001joooo001koooo00?o09Woooooool07oooo`030000
oooo000000<co`000`000?ooooooo`1joooo001koooo00?o09Woooooool07Oooo`030000oooooooo
00800003<ol000<0003oooooool0N_ooo`00Noooo`03o`2Ioooooooo01koool2000000?oool0000c
o`000S?o00030000oooooooo07[oool007_oool00ol0VOooooooo`0Qoooo00D0000co`0co`0co`00
0000O?ooo`00Noooo`03o`2Ioooooooo02;oool0100003?o03?o000007coool007_oool00ol0VOoo
ooooo`0Roooo00<0000co`0co`000P0007_oool007_oool00ol0VOooooooo`0Roooo00@0000co`0c
o`00001loooo001koooo00?o09Woooooool08_ooo`040000<ol0<ol00000O?ooo`00Noooo`03o`2I
oooooooo02;oool0100003?o03?o000007coool007_oool00ol0VOooooooo`0Roooo00@0000co`0c
o`00001loooo001koooo00?o09Woooooool08_ooo`040000<ol0<ol00000O?ooo`00Noooo`03o`2I
oooooooo02;oool0100003?o03?o000007coool007_oool00ol0VOooooooo`0Soooo00@0000co`00
0000001koooo001koooo00?o09Woooooool08oooo`030000<ol0000007coool007_oool00ol0VOoo
ooooo`0Soooo00<0000co`000000O?ooo`00Noooo`03o`2Ioooooooo02?oool00`0003?o0000001l
oooo001koooo00?o09Woooooool08oooo`030000<ol0000007coool007_oool00ol0VOooooooo`0S
oooo00<0000co`000000O?ooo`00Noooo`03o`2Ioooooooo02?oool0100003?o0000000007_oool0
07_oool00ol0VOooooooo`0Soooo00<0000co`000000O?ooo`00Noooo`03o`2Ioooooooo02?oool0
0`0003?o0000001loooo001koooo00?o09Woooooool08oooo`030000<ol0000007coool007_oool0
0ol0VOooooooo`0Soooo00<0000co`000000O?ooo`00Noooo`03o`2Ioooooooo02?oool00`0003?o
0000001loooo001koooo00?o09Woooooool08oooo`040000<ol000000000Noooo`00Noooo`03o`2I
oooooooo02?oool00`0003?o0000001loooo001koooo00?o09Woooooool08oooo`030000<ol00000
07coool007_oool00ol0VOooooooo`0Soooo00<0000co`000000O?ooo`00Noooo`03o`2Ioooooooo
01koool200000oooo`030000<ol0000007coool007_oool00ol0VOooooooo`0Moooo00@0003ooooo
ool00002oooo00<0000co`000000O?ooo`00Noooo`03o`2Ioooooooo01ooool01P000?oooooooooo
o`0003?o00<0001joooo001koooo00?o09Woooooool08?ooo`060000oooooooo0000<ol00000O?oo
o`00Noooo`03o`2Ioooooooo01goool010000?ooooooo`0000;oool00`0003?o0000001loooo001k
oooo00?o09Woooooool07_ooo`800004oooo0P0007coool007_oool00ol0VOooooooo`0Toooo0P00
07coool007_oool00ol0VOooooooo`0Toooo0P0007coool007_oool00ol0VOooooooo`0Toooo0P00
07coool007_oool00ol0VOooooooo`0Toooo0`0007_oool007_oool00ol0VOooooooo`0Toooo0P00
07coool007_oool00ol0VOooooooo`0Toooo0P0007coool007_oool00ol0VOooooooo`0Toooo0P00
07coool007_oool00ol0VOooooooo`0Toooo0P0007coool007_oool00ol0VOooooooo`0Toooo0P00
07coool007_oool00ol0VOooooooo`0Toooo0`0007_oool007_oool00ol0VOooooooo`0Toooo0P00
07coool007_oool00ol0VOooooooo`0Toooo0P0007coool007_oool00ol0VOooooooo`0Toooo0P00
07coool007_oool00ol0VOooooooo`0Toooo0P0007coool007_oool00ol0VOooooooo`0Toooo0P00
07coool007_oool00ol0VOooooooo`0Toooo0`0007_oool007_oool00ol0VOooooooo`0Uoooo00<0
003oooooool0N_ooo`00Noooo`03o`2Ioooooooo02Goool00`000?ooooooo`1joooo001koooo00?o
09Woooooool09Oooo`030000oooooooo07[oool007_oool00ol0VOooooooo`0Uoooo00<0003ooooo
ool0N_ooo`00Noooo`03o`2Ioooooooo02Goool00`000?ooooooo`1joooo001koooo00?o09Wooooo
ool09Oooo`80001koooo001koooo00?o09Woooooool09Oooo`030000oooooooo07[oool007_oool0
0ol0VOooooooo`0Uoooo00<0003oooooool0N_ooo`00Noooo`03o`2Ioooooooo02Goool00`000?oo
ooooo`1joooo001koooo00?o09Woooooool09Oooo`030000oooooooo07[oool007_oool00ol0VOoo
ooooo`0Ooooo0`0000?oool00`000?ooooooo`1joooo001koooo00?o09Woooooool08?ooo`030000
oooooooo00;oool00`000?ooooooo`1joooo001koooo00?o09Woooooool07Oooo`D00003oooo0`00
07[oool009_oool010000?ooooooo`00087oool009coool00`000?ooo`000021oooo002Moooo0P00
087oool00?oooolQoooo003ooooo8Oooo`00O?ooo`030000oooooooo02;oool00`000?ooooooo`1l
oooo001koooo00<0003oooooool02?ooo`030000oooooooo01Woool00`000?ooooooo`1koooo001k
oooo00<0003oooooool00_ooo`800004oooo00<0003oooooool03Oooo`800004oooo0P0000Coool0
0`000?ooooooo`1koooo001koooo00D0003oooooooooool000000_ooo`030000oooooooo00;oool0
0`000?ooooooo`04oooo100000?oool010000?ooooooo`0000Woool00`000?ooooooo`1koooo001j
oooo00<0003oooooool00_ooo`030000oooooooo01Goool00`000?ooooooo`09oooo00<0003ooooo
ool0N_ooo`00Noooo`030000oooooooo00D0000Eoooo00<0003oooooool01oooo`030000oooooooo
07_oool007_oool01@000?ooooooooooo`00000Eoooo00@0003oooooool00009oooo00<0003ooooo
ool0Noooo`00O?ooo`030000oooooooo01Ooool200002Oooo`030000oooooooo07coool00?oooolQ
oooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-8.12947, \
-1.14361, 0.0496935, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-8.12947, -1.14361, 0.0496935, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.9) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
.2 1 0 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.40095 .12361 L
.41127 .12361 L
.41696 .12361 L
.42237 .12361 L
.42482 .12361 L
.42617 .12361 L
.42744 .12361 L
.42816 .12361 L
s
.42816 .12361 m
.42847 .61803 L
s
0 .4 1 r
.02381 .12469 m
.04262 .12512 L
.06244 .12575 L
.07286 .12619 L
.08255 .12668 L
.09388 .12737 L
.10458 .12816 L
.125 .13015 L
.14357 .13272 L
.16355 .13662 L
.18199 .14168 L
.20071 .14884 L
.21136 .15412 L
.22134 .16005 L
.24158 .17588 L
.26011 .19633 L
.26487 .20277 L
.26749 .20655 L
.26877 .20847 L
.26995 .2101 L
.27107 .21008 L
.27226 .21006 L
.27475 .21002 L
.27909 .20994 L
.2891 .20973 L
.29982 .20946 L
.31946 .20881 L
.33779 .20796 L
.34796 .20736 L
.35903 .20656 L
.36859 .20574 L
.37915 .20465 L
.39893 .20197 L
.40976 .20006 L
.41462 .19908 L
.41993 .1979 L
.4224 .19732 L
.42503 .19666 L
.4263 .19634 L
.42751 .19602 L
.42859 .12361 L
.42976 .12361 L
.43101 .12361 L
.43172 .12361 L
.43238 .12361 L
.43308 .12361 L
.43372 .12361 L
.43445 .12361 L
.43515 .12361 L
.43638 .12361 L
Mistroke
.43753 .12361 L
.43878 .12361 L
.43948 .12361 L
.44012 .12361 L
.44128 .12361 L
.4425 .12361 L
.44355 .12361 L
.4447 .12361 L
.44594 .12361 L
.44663 .12361 L
.44726 .12361 L
.44849 .12361 L
.44965 .12361 L
.45073 .12361 L
.45188 .12361 L
.45287 .12361 L
.45395 .12361 L
.45511 .12361 L
.45636 .12361 L
.45754 .12361 L
.45862 .12361 L
.4598 .12361 L
.46107 .12361 L
.46227 .12361 L
.46338 .12361 L
.46467 .12361 L
.46532 .12361 L
.46604 .12361 L
.46728 .12361 L
.46845 .12361 L
.46963 .12361 L
.47075 .12361 L
.47176 .12361 L
.47286 .12361 L
.47404 .12361 L
.47531 .12361 L
.47639 .12361 L
.47758 .12361 L
.47889 .12361 L
.47954 .12361 L
.48026 .12361 L
.48153 .12361 L
.48272 .12361 L
.48344 .12361 L
.48412 .12361 L
.4854 .12361 L
.48611 .12361 L
.48677 .12361 L
.4875 .12361 L
.48826 .12361 L
Mistroke
.48945 .12361 L
.49073 .12361 L
.49194 .12361 L
.49304 .12361 L
.49433 .12361 L
.49506 .12361 L
.49573 .12361 L
.49698 .12361 L
.4983 .12361 L
.5033 .12361 L
.50463 .12361 L
.50537 .12361 L
.50604 .12361 L
.50735 .12361 L
.50859 .12361 L
.50928 .12361 L
.50992 .12361 L
.51062 .12361 L
.51136 .12361 L
.5121 .12361 L
.5128 .12361 L
.51357 .12361 L
.51439 .12361 L
.51504 .12361 L
.51575 .12361 L
.51649 .12361 L
.51717 .12361 L
.51841 .12361 L
.51972 .12361 L
.52038 .12361 L
.52108 .12361 L
.52233 .12361 L
.52303 .12361 L
.52368 .12361 L
.5244 .12361 L
.52516 .12361 L
.52582 .12361 L
.52654 .12361 L
.52785 .12361 L
.52912 .12361 L
.5303 .12361 L
.53156 .12361 L
.53274 .12361 L
.5338 .12361 L
.53495 .12361 L
.5362 .12361 L
.53684 .12361 L
.53753 .12361 L
.53876 .12361 L
.5399 .12361 L
Mistroke
.54117 .12361 L
.54181 .12361 L
.54251 .12361 L
.54376 .12361 L
.54493 .12361 L
.54563 .12361 L
.5463 .12361 L
.54756 .12361 L
.54826 .12361 L
.54891 .12361 L
.54963 .12361 L
.55039 .12361 L
.55167 .12361 L
.5524 .12361 L
.55307 .12361 L
.55429 .12361 L
.55559 .12361 L
.55675 .12361 L
.55784 .12361 L
.55903 .12361 L
.56031 .12361 L
.56146 .12361 L
.5627 .12361 L
.56334 .12361 L
.56404 .12361 L
.56529 .12361 L
.56647 .12361 L
.56773 .12361 L
.56893 .12361 L
.57002 .12361 L
.57109 .12361 L
.57208 .12361 L
.57317 .12361 L
.57434 .12361 L
.57556 .12361 L
.57672 .12361 L
.57775 .12361 L
.57888 .12361 L
.58011 .12361 L
.58123 .12361 L
.58377 .12361 L
.58834 .12361 L
.59875 .12361 L
.61979 .12361 L
.65953 .12361 L
.69777 .12361 L
.73845 .12361 L
.77762 .12361 L
.81924 .12361 L
.85935 .12361 L
Mistroke
.89794 .12361 L
.93898 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.9) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Koooo1@00083oool009goool00`000?ooooooo`20oooo002Moooo00<0003ooooo
ool00oooo`<0001joooo002Eoooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0N_oo
o`00WOooo`030000oooooooo00?oool00`000?ooooooo`1joooo002Loooo0P0000Goool00`000?oo
ooooo`1joooo002Soooo00<0003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool2
0000Noooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0
003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002S
oooo00<0003oooooool0N_ooo`00Xoooo`80001koooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool00:?oool20000Noooo`00:oooo`<0000Xoooo0`0002?oool4
00008oooo`030000oooooooo02?oool400009oooo`<0000Yoooo000[oooo00@0003oooooool0000X
oooo00<0003oooooool08_ooo`030000oooooooo02Coool00`000?ooooooo`0Soooo00<0003ooooo
ool0:Oooo`030000oooooooo02Soool002_oool010000?ooooooo`0002Goool500009?ooo`030000
oooooooo02?oool00`000?ooooooo`0Toooo00<0003oooooool09Oooo`D0000Yoooo000Uoooo1000
00;oool300008?ooo`@00002oooo00@0003oooooool0000Noooo100000Coool00`000?ooooooo`0R
oooo00<0003oooooool09Oooo`030000oooooooo02Coool010000?ooooooo`0002[oool002coool0
0`000?ooooooo`0Voooo00<0003oool000009?ooo`040000oooooooo00008oooo`030000oooooooo
02?oool010000?ooooooo`0002Koool00`000?ooo`00000Zoooo000/oooo0`0002Ooool200009Ooo
o`80000Toooo0P0002Goool20000:?ooo`80000Zoooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool0013ooooo00004Oooo`005_ooo`03000006Ko06Ko00L0I_l0
0`00001Vo`1Vo`0706Ko00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooo000000T000000`1Vo`0000000004000000<co`00000co`0023?o00030000
<ol0<ol000Lco`000`0003?o03?o0007<ol000<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07
oooo00<0003oooooool02?ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooooooo01Goool002[oool00`00001Vo`1Vo`0606Ko8?ooo`030000oooooooo
02Goool00`000?ooo`1Vo`06oooo100001/co`000`000?ooooooo`0Uoooo00<0003oooooool09_oo
o`030000oooooooo02Woool003?oool506KoAOooo`0306Kooooooooo00Soool400005c?o00030000
oooooooo07[oool003Soool406Ko@Oooo`0306Kooooooooo00coool00`0003?o03?o000D<ol000<0
003oooooool0N_ooo`00??ooo`@0I_lmoooo00<0I_ooooooool03Oooo`80000D<ol000<0003ooooo
ool0N_ooo`00@?ooo`80I_lkoooo00<0I_ooooooool03oooo`030000<ol0<ol0014co`000`000?oo
ooooo`1joooo0012oooo0`1VocSoool00`1Vooooooooo`0@oooo00<0000co`0co`0043?o0080001k
oooo0015oooo0P1VocKoool00`1Vooooooooo`0Aoooo0P00010co`000`000?ooooooo`1joooo0017
oooo00<0I_ooooooool0<oooo`0306Kooooooooo01?oool00`0003?o03?o000=<ol000<0003ooooo
ool0N_ooo`00B?ooo`0306Kooooooooo03;oool00`1Vooooooooo`0Coooo00<0000co`0co`003C?o
00030000oooooooo07[oool004Woool00`1Vooooooooo`0aoooo00<0I_ooooooool05?ooo`030000
<ol0<ol000`co`000`000?ooooooo`1joooo001:oooo0P1Voc7oool00`1Vooooooooo`0Doooo00<0
000co`0co`0033?o00030000oooooooo07[oool004coool00`1Vooooooooo`0^oooo00<0I_oooooo
ool05Oooo`030000<ol0<ol000/co`020000Noooo`00COooo`0306Kooooooooo02goool00`1Voooo
ooooo`0Eoooo00<0000co`0co`002c?o00030000oooooooo07[oool004koool00`1Vooooooooo`0/
oooo00<0I_ooooooool05_ooo`030000<ol0<ol000Xco`000`000?ooooooo`1joooo001?oooo00<0
I_ooooooool0:oooo`0306Kooooooooo01Koool00`0003?o03?o000:<ol000<0003oooooool0N_oo
o`00D?ooo`0306Kooooooooo02[oool00`1Vooooooooo`0Goooo00<0000co`0co`002C?o00030000
oooooooo07[oool0057oool00`1Vooooooooo`0Yoooo00<0I_ooooooool05oooo`030000<ol0<ol0
00Tco`000`000?ooooooo`1joooo001Boooo00<0I_ooooooool09_ooo`<0I_lJoooo00<0000co`0c
o`0023?o0080001koooo001Coooo00<0I_ooooooool07Oooo`P0I_l2oooo00?o09Woooooool06?oo
o`030000<ol0<ol000Pco`000`000?ooooooo`1joooo001Doooo00<0I_ooooooool04oooo`T0I_l:
oooo00?o09Woooooool06?ooo`030000<ol0<ol000Pco`000`000?ooooooo`1joooo001Doooo5P1V
oa?oool00ol0VOooooooo`0Ioooo00<0000co`0co`001c?o00030000oooooooo07[oool007goool0
0ol0VOooooooo`0Ioooo00<0000co`0co`001c?o00030000oooooooo07[oool007goool00ol0VOoo
ooooo`0Ioooo00<0000co`0co`001c?o00030000oooooooo07[oool007goool00ol0VOooooooo`0I
oooo00<0000co`0co`001c?o0080001koooo001moooo00?o09Woooooool06_ooo`030000<ol0<ol0
00Hco`000`000?ooooooo`1joooo001moooo00?o09Woooooool06_ooo`030000<ol0<ol000Hco`00
0`000?ooooooo`1joooo001moooo00?o09Woooooool06_ooo`030000<ol0<ol000Hco`000`000?oo
ooooo`1joooo001moooo00?o09Woooooool06_ooo`030000<ol0<ol000Hco`000`000?ooooooo`1j
oooo001moooo00?o09Woooooool06oooo`D00003<ol000<0003oooooool0N_ooo`00OOooo`03o`2I
oooooooo01_oool00`0003?o00000005<ol000<0003oooooool0N_ooo`00OOooo`03o`2Ioooooooo
01_oool00`0003?o00000005<ol00`0007[oool007goool00ol0VOooooooo`0Loooo0P0000Dco`00
0`000?ooooooo`1joooo001moooo00?o09Woooooool07?ooo`800005<ol000<0003oooooool0N_oo
o`00OOooo`03o`2Ioooooooo01coool200001C?o00030000oooooooo07[oool007goool00ol0VOoo
ooooo`0Loooo00<0000co`0co`0013?o00030000oooooooo07[oool007goool00ol0VOooooooo`0L
oooo00<0000co`0co`0013?o00030000oooooooo07[oool007goool00ol0VOooooooo`0Loooo00<0
000co`0co`0013?o0080001koooo001moooo00?o09Woooooool07Oooo`030000<ol0<ol000<co`00
0`000?ooooooo`1joooo001moooo00?o09Woooooool07Oooo`030000<ol0<ol000<co`000`000?oo
ooooo`1joooo001moooo00?o09Woooooool07Oooo`030000<ol0<ol000<co`000`000?ooooooo`1j
oooo001moooo00?o09Woooooool07Oooo`030000<ol0<ol000<co`000`000?ooooooo`1joooo001m
oooo00?o09Woooooool07Oooo`030000<ol0<ol000<co`000`000?ooooooo`1joooo001moooo00?o
09Woooooool07Oooo`030000<ol0<ol000<co`020000Noooo`00OOooo`03o`2Ioooooooo01goool0
0`0003?o03?o0003<ol000<0003oooooool0N_ooo`00OOooo`03o`2Ioooooooo01goool00`0003?o
03?o0003<ol000<0003oooooool0N_ooo`00OOooo`03o`2Ioooooooo01koool00`0003?o03?o0002
<ol000<0003oooooool0N_ooo`00OOooo`03o`2Ioooooooo01koool00`0003?o03?o0002<ol000<0
003oooooool0N_ooo`00OOooo`03o`2Ioooooooo01koool00`0003?o03?o0002<ol000<0003ooooo
ool0N_ooo`00OOooo`03o`2Ioooooooo01koool00`0003?o03?o0002<ol000<0003oooooool0N_oo
o`00OOooo`03o`2Ioooooooo01koool00`0003?o03?o0002<ol00P0007_oool007goool00ol0VOoo
ooooo`0Noooo00<0000co`0co`000S?o00030000oooooooo07[oool007goool00ol0VOooooooo`0N
oooo00<0000co`0co`000S?o00030000oooooooo07[oool007goool00ol0VOooooooo`0Noooo00<0
000co`0co`000S?o00030000oooooooo07[oool007goool00ol0VOooooooo`0Noooo00<0000co`0c
o`000S?o00030000oooooooo07[oool007goool00ol0VOooooooo`0Noooo00<0000co`0co`000S?o
00030000oooooooo07[oool007goool00ol0VOooooooo`0Noooo00<0000co`0co`000S?o0080001k
oooo001moooo00?o09Woooooool07oooo`050000<ol0<ol0<ol0000007coool007goool00ol0VOoo
ooooo`0Ooooo00D0000co`0co`0co`000000O?ooo`00OOooo`03o`2Ioooooooo01ooool01@0003?o
03?o03?o0000001loooo001moooo00?o09Woooooool06oooo`D00003<ol000<0003oooooool0N_oo
o`00OOooo`03o`2Ioooooooo01_oool01@000?ooooooooooo`000003<ol000<0003oooooool0N_oo
o`00OOooo`03o`2Ioooooooo01coool010000?ooooooo`0000<co`030000N_ooo`00OOooo`03o`2I
oooooooo01goool00`000?ooo`000003<ol000<0003oooooool0N_ooo`00OOooo`03o`2Ioooooooo
01_oool00`000?ooooooo`0200000c?o00030000oooooooo07[oool007goool00ol0VOooooooo`0L
oooo0P000003oooo0000<ol0008co`000`000?ooooooo`1joooo001moooo00?o09Woooooool07ooo
o`050000<ol0<ol0<ol0000007coool007goool00ol0VOooooooo`0Poooo00@0000co`0co`00001l
oooo001moooo00?o09Woooooool08?ooo`030000<ol0<ol00080001koooo001moooo00?o09Wooooo
ool08?ooo`040000<ol0<ol00000O?ooo`00OOooo`03o`2Ioooooooo023oool0100003?o03?o0000
07coool007goool00ol0VOooooooo`0Poooo00@0000co`0co`00001loooo001moooo00?o09Wooooo
ool08?ooo`040000<ol0<ol00000O?ooo`00OOooo`03o`2Ioooooooo023oool0100003?o03?o0000
07coool007goool00ol0VOooooooo`0Poooo00@0000co`0co`00001loooo001moooo00?o09Wooooo
ool08Oooo`040000<ol000000000Noooo`00OOooo`03o`2Ioooooooo027oool00`0003?o0000001l
oooo001moooo00?o09Woooooool08Oooo`030000<ol0000007coool007goool00ol0VOooooooo`0Q
oooo00<0000co`000000O?ooo`00OOooo`03o`2Ioooooooo027oool00`0003?o0000001loooo001m
oooo00?o09Woooooool08Oooo`030000<ol0000007coool007goool00ol0VOooooooo`0Qoooo00@0
000co`000000001koooo001moooo00?o09Woooooool08Oooo`030000<ol0000007coool007goool0
0ol0VOooooooo`0Qoooo00<0000co`000000O?ooo`00OOooo`03o`2Ioooooooo027oool00`0003?o
0000001loooo001moooo00?o09Woooooool08Oooo`030000<ol0000007coool007goool00ol0VOoo
ooooo`0Qoooo00<0000co`000000O?ooo`00OOooo`03o`2Ioooooooo027oool0100003?o00000000
07_oool007goool00ol0VOooooooo`0Qoooo00<0000co`000000O?ooo`00OOooo`03o`2Ioooooooo
027oool00`0003?o0000001loooo001moooo00?o09Woooooool08Oooo`030000<ol0000007coool0
07goool00ol0VOooooooo`0Loooo0P0000?oool00`0003?o0000001loooo001moooo00?o09Wooooo
ool06oooo`040000oooooooo00000_ooo`030000<ol0000007coool007goool00ol0VOooooooo`0M
oooo00H0003oooooooooool0000co`030000N_ooo`00OOooo`03o`2Ioooooooo01koool01P000?oo
ooooo`0003?o000007coool007goool00ol0VOooooooo`0Koooo00@0003oooooool00002oooo00<0
000co`000000O?ooo`00OOooo`03o`2Ioooooooo01coool200001?ooo`80001loooo001moooo00?o
09Woooooool08_ooo`80001loooo001moooo00?o09Woooooool08_ooo`80001loooo001moooo00?o
09Woooooool08_ooo`80001loooo001moooo00?o09Woooooool08_ooo`<0001koooo001moooo00?o
09Woooooool08_ooo`80001loooo001moooo00?o09Woooooool08_ooo`80001loooo001moooo00?o
09Woooooool08_ooo`80001loooo001moooo00?o09Woooooool08_ooo`80001loooo001moooo00?o
09Woooooool08_ooo`80001loooo001moooo00?o09Woooooool08_ooo`<0001koooo001moooo00?o
09Woooooool08_ooo`80001loooo001moooo00?o09Woooooool08_ooo`80001loooo001moooo00?o
09Woooooool08_ooo`80001loooo001moooo00?o09Woooooool08_ooo`80001loooo001moooo00?o
09Woooooool08_ooo`80001loooo001moooo00?o09Woooooool08_ooo`<0001koooo001moooo00?o
09Woooooool08oooo`030000oooooooo07[oool007goool00ol0VOooooooo`0Soooo00<0003ooooo
ool0N_ooo`00OOooo`03o`2Ioooooooo02?oool00`000?ooooooo`1joooo001moooo00?o09Wooooo
ool08oooo`030000oooooooo07[oool007goool00ol0VOooooooo`0Soooo00<0003oooooool0N_oo
o`00OOooo`03o`2Ioooooooo02?oool20000Noooo`00OOooo`03o`2Ioooooooo02?oool00`000?oo
ooooo`1joooo001moooo00?o09Woooooool08oooo`030000oooooooo07[oool007goool00ol0VOoo
ooooo`0Soooo00<0003oooooool0N_ooo`00OOooo`03o`2Ioooooooo02?oool00`000?ooooooo`1j
oooo001moooo00?o09Woooooool07Oooo`<00003oooo00<0003oooooool0N_ooo`00OOooo`03o`2I
oooooooo01koool00`000?ooooooo`02oooo00<0003oooooool0N_ooo`00OOooo`03o`2Ioooooooo
01_oool500000oooo`<0001joooo002Koooo00@0003oooooool00021oooo002Loooo00<0003oool0
0000POooo`00WOooo`800021oooo003ooooo8Oooo`00ooooob7oool007Woool00`000?ooooooo`0X
oooo00<0003oooooool0NOooo`00N?ooo`030000oooooooo00Soool00`000?ooooooo`0Ooooo00<0
003oooooool0N?ooo`00N?ooo`030000oooooooo00;oool200001?ooo`030000oooooooo00coool4
00000oooo`800003oooo0`0000Coool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool0
00000_ooo`030000oooooooo00;oool00`000?ooooooo`04oooo100000?oool00`000?ooooooo`0;
oooo00<0003oooooool00_ooo`030000oooooooo07Soool007Ooool00`000?ooooooo`02oooo00<0
003oooooool05?ooo`030000oooooooo00Woool300001?ooo`030000oooooooo07Ooool007Soool0
0`000?ooooooo`0500005?ooo`030000oooooooo00Ooool010000?ooooooo`0000?oool00`000?oo
ooooo`1hoooo001hoooo00D0003oooooooooool000005Oooo`040000oooooooo00002?ooo`040000
oooooooo00000oooo`030000oooooooo07Soool007Woool00`000?ooooooo`0Goooo0P0000[oool3
00000_ooo`030000oooooooo07Woool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-8.12947, \
-1.14361, 0.0496935, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-8.12947, -1.14361, 0.0496935, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
.2 1 0 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.40095 .12361 L
.41127 .12361 L
.42237 .12361 L
.42781 .12361 L
.43049 .12361 L
.43298 .12361 L
.43522 .12361 L
.43648 .12361 L
s
.43648 .12361 m
.43693 .61803 L
s
0 .4 1 r
.02381 .12454 m
.04262 .12492 L
.06244 .12547 L
.07286 .12585 L
.08255 .12627 L
.09388 .12687 L
.10458 .12756 L
.125 .12929 L
.14357 .13152 L
.16355 .1349 L
.18199 .1393 L
.20071 .14551 L
.21136 .15009 L
.22134 .15524 L
.24158 .16899 L
.26011 .18673 L
.2693 .19796 L
.27434 .20496 L
.27555 .20672 L
.27682 .20863 L
.2779 .21009 L
.27909 .21007 L
.2818 .21002 L
.28473 .20997 L
.28984 .20987 L
.29982 .20965 L
.31933 .20909 L
.33027 .20867 L
.34024 .20822 L
.35933 .2071 L
.37011 .20627 L
.38009 .20535 L
.39875 .20313 L
.4095 .20148 L
.41935 .19966 L
.42878 .1976 L
.43352 .19643 L
.43482 .1961 L
.43553 .19591 L
.4362 .19573 L
.43751 .12361 L
.4387 .12361 L
.43991 .12361 L
.44059 .12361 L
.44123 .12361 L
.44252 .12361 L
.44325 .12361 L
.44391 .12361 L
.44509 .12361 L
.44637 .12361 L
Mistroke
.44758 .12361 L
.44871 .12361 L
.44939 .12361 L
.45013 .12361 L
.45083 .12361 L
.45147 .12361 L
.45268 .12361 L
.45396 .12361 L
.45463 .12361 L
.45534 .12361 L
.45663 .12361 L
.45742 .12361 L
.45816 .12361 L
.45889 .12361 L
.45956 .12361 L
.4607 .12361 L
.46193 .12361 L
.46302 .12361 L
.46416 .12361 L
.46533 .12361 L
.46659 .12361 L
.46731 .12361 L
.46796 .12361 L
.46924 .12361 L
.47056 .12361 L
.47177 .12361 L
.47241 .12361 L
.47311 .12361 L
.47384 .12361 L
.47452 .12361 L
.47578 .12361 L
.47693 .12361 L
.47756 .12361 L
.47825 .12361 L
.47951 .12361 L
.48064 .12361 L
.48171 .12361 L
.48288 .12361 L
.48415 .12361 L
.4854 .12361 L
.48672 .12361 L
.48784 .12361 L
.48908 .12361 L
.49024 .12361 L
.49129 .12361 L
.49251 .12361 L
.49367 .12361 L
.49473 .12361 L
.49572 .12361 L
.4968 .12361 L
Mistroke
.49794 .12361 L
.49915 .12361 L
.50046 .12361 L
.50171 .12361 L
.50286 .12361 L
.504 .12361 L
.50504 .12361 L
.50623 .12361 L
.50736 .12361 L
.50859 .12361 L
.5099 .12361 L
.51101 .12361 L
.51223 .12361 L
.51354 .12361 L
.51428 .12361 L
.51495 .12361 L
.51625 .12361 L
.51749 .12361 L
.51854 .12361 L
.5197 .12361 L
.52091 .12361 L
.52205 .12361 L
.5231 .12361 L
.52407 .12361 L
.52514 .12361 L
.52626 .12361 L
.5274 .12361 L
.52862 .12361 L
.52977 .12361 L
.53081 .12361 L
.53204 .12361 L
.53274 .12361 L
.53338 .12361 L
.53455 .12361 L
.53579 .12361 L
.53701 .12361 L
.53833 .12361 L
.53958 .12361 L
.54073 .12361 L
.54188 .12361 L
.54292 .12361 L
.54411 .12361 L
.54524 .12361 L
.54648 .12361 L
.54778 .12361 L
.5489 .12361 L
.55012 .12361 L
.55143 .12361 L
.55217 .12361 L
.55284 .12361 L
Mistroke
.55415 .12361 L
.55538 .12361 L
.55644 .12361 L
.55758 .12361 L
.55866 .12361 L
.55965 .12361 L
.56075 .12361 L
.5618 .12361 L
.56293 .12361 L
.56417 .12361 L
.56541 .12361 L
.56611 .12361 L
.56674 .12361 L
.56796 .12361 L
.56912 .12361 L
.57027 .12361 L
.57132 .12361 L
.57248 .12361 L
.5737 .12361 L
.57492 .12361 L
.57561 .12361 L
.57624 .12361 L
.57741 .12361 L
.57866 .12361 L
.57976 .12361 L
.5808 .12361 L
.58317 .12361 L
.59333 .12361 L
.61166 .12361 L
.65034 .12361 L
.69146 .12361 L
.73108 .12361 L
.76917 .12361 L
.80972 .12361 L
.84875 .12361 L
.89024 .12361 L
.93021 .12361 L
.96866 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Koooo1@00083oool009goool00`000?ooooooo`20oooo002Moooo00<0003ooooo
ool00oooo`<0001joooo002Eoooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0N_oo
o`00WOooo`030000oooooooo00?oool00`000?ooooooo`1joooo002Loooo0P0000Goool00`000?oo
ooooo`1joooo002Soooo00<0003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool2
0000Noooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0
003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002S
oooo00<0003oooooool0N_ooo`00Xoooo`80001koooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool00:?oool20000Noooo`00:oooo`<0000Xoooo0`0002?oool4
00008oooo`030000oooooooo02?oool400009oooo`<0000Yoooo000[oooo00@0003oooooool0000X
oooo00<0003oooooool08_ooo`030000oooooooo02Coool00`000?ooooooo`0Soooo00<0003ooooo
ool0:Oooo`030000oooooooo02Soool002_oool010000?ooooooo`0002Goool500009?ooo`030000
oooooooo02?oool00`000?ooooooo`0Toooo00<0003oooooool09Oooo`D0000Yoooo000Uoooo1000
00;oool300008?ooo`@00002oooo00@0003oooooool0000Noooo100000Coool00`000?ooooooo`0R
oooo00<0003oooooool09Oooo`030000oooooooo02Coool010000?ooooooo`0002[oool002coool0
0`000?ooooooo`0Voooo00<0003oool000009?ooo`040000oooooooo00008oooo`030000oooooooo
02?oool010000?ooooooo`0002Koool00`000?ooo`00000Zoooo000/oooo0`0002Ooool200009Ooo
o`80000Toooo0P0002Goool20000:?ooo`80000Zoooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool0013ooooo00004Oooo`005_ooo`03000006Ko06Ko00L0I_l0
0`00001Vo`1Vo`0706Ko00@00000I_l0I_l0I_l6oooo00<0003oooooool01oooo`030000oooooooo
00Soool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?oo
ooooo`07oooo00<0003oool000002`00000306Ko00000000008000000c?o000003?o0008<ol000<0
000co`0co`001c?o00030000<ol0<ol000Lco`000`000?ooooooo`07oooo00<0003oooooool01ooo
o`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo
00Ooool00`000?ooooooo`08oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?oo
ooooo`07oooo00<0003oooooool05Oooo`00:_ooo`040000oooooooooooo2P1Voa_oool00`000?oo
ooooo`0Uoooo00D0003oooooooooool0I_l01?ooo`@0000K<ol000<0003oooooool09Oooo`030000
oooooooo02Koool00`000?ooooooo`0Yoooo000hoooo101Vod?oool00`1Vooooooooo`06oooo1000
01Lco`000`000?ooooooo`1joooo000loooo101Vocooool00`1Vooooooooo`0:oooo00<0000co`0c
o`0053?o00030000oooooooo07[oool0043oool206Ko?Oooo`0306Kooooooooo00_oool2000053?o
00030000oooooooo07[oool004;oool306Ko>_ooo`0306Kooooooooo00goool00`0003?o03?o000A
<ol000<0003oooooool0N_ooo`00AOooo`80I_lhoooo00<0I_ooooooool03_ooo`030000<ol0<ol0
010co`020000Noooo`00Aoooo`80I_lfoooo00<0I_ooooooool03oooo`80000@<ol000<0003ooooo
ool0N_ooo`00BOooo`0306Kooooooooo03?oool00`1Vooooooooo`0Aoooo00<0000co`0co`003C?o
00030000oooooooo07[oool004[oool206Ko<oooo`0306Kooooooooo017oool00`0003?o03?o000=
<ol000<0003oooooool0N_ooo`00C?ooo`0306Kooooooooo033oool00`1Vooooooooo`0Boooo00<0
000co`0co`0033?o00030000oooooooo07[oool004goool00`1Vooooooooo`0_oooo00<0I_oooooo
ool04_ooo`030000<ol0<ol000`co`000`000?ooooooo`1joooo001>oooo00<0I_ooooooool0;_oo
o`0306Kooooooooo01?oool00`0003?o03?o000;<ol00P0007_oool004ooool206Ko;_ooo`0306Ko
oooooooo01?oool00`0003?o03?o000;<ol000<0003oooooool0N_ooo`00DOooo`0306Kooooooooo
02_oool00`1Vooooooooo`0Doooo00<0000co`0co`002S?o00030000oooooooo07[oool005;oool0
0`1Vooooooooo`0Zoooo00<0I_ooooooool05?ooo`030000<ol0<ol000Xco`000`000?ooooooo`1j
oooo001Coooo00<0I_ooooooool0:Oooo`0306Kooooooooo01Goool00`0003?o03?o0009<ol000<0
003oooooool0N_ooo`00Doooo`0306Kooooooooo02Woool00`1Vooooooooo`0Eoooo00<0000co`0c
o`002C?o00030000oooooooo07[oool005Coool00`1Vooooooooo`0Voooo0`1VoaSoool00`0003?o
03?o0008<ol00P0007_oool005Goool00`1Vooooooooo`0Ooooo1P1Vo`;oool00ol0VOooooooo`0F
oooo00<0000co`0co`0023?o00030000oooooooo07[oool005Koool00`1Vooooooooo`0Doooo2P1V
o`Soool00ol0VOooooooo`0Foooo00<0000co`0co`0023?o00030000oooooooo07[oool005KooolG
06Ko4_ooo`03o`2Ioooooooo01Ooool00`0003?o03?o0007<ol000<0003oooooool0N_ooo`00Oooo
o`03o`2Ioooooooo01Ooool00`0003?o03?o0007<ol000<0003oooooool0N_ooo`00Ooooo`03o`2I
oooooooo01Ooool00`0003?o03?o0007<ol000<0003oooooool0N_ooo`00Ooooo`03o`2Ioooooooo
01Ooool00`0003?o03?o0007<ol00P0007_oool007ooool00ol0VOooooooo`0Hoooo00<0000co`0c
o`001S?o00030000oooooooo07[oool007ooool00ol0VOooooooo`0Hoooo00<0000co`0co`001S?o
00030000oooooooo07[oool007ooool00ol0VOooooooo`0Hoooo00<0000co`0co`001S?o00030000
oooooooo07[oool007ooool00ol0VOooooooo`0Hoooo00<0000co`0co`001S?o00030000oooooooo
07[oool007ooool00ol0VOooooooo`0Ioooo1@0000<co`000`000?ooooooo`1joooo001ooooo00?o
09Woooooool06Oooo`030000<ol0000000Dco`000`000?ooooooo`1joooo001ooooo00?o09Wooooo
ool06Oooo`030000<ol0000000Dco`030000N_ooo`00Ooooo`03o`2Ioooooooo01[oool200001C?o
00030000oooooooo07[oool007ooool00ol0VOooooooo`0Joooo0P0000Dco`000`000?ooooooo`1j
oooo001ooooo00?o09Woooooool06_ooo`800005<ol000<0003oooooool0N_ooo`00Ooooo`03o`2I
oooooooo01[oool00`0003?o03?o0004<ol000<0003oooooool0N_ooo`00Ooooo`03o`2Ioooooooo
01[oool00`0003?o03?o0004<ol000<0003oooooool0N_ooo`00Ooooo`03o`2Ioooooooo01[oool0
0`0003?o03?o0004<ol00P0007_oool007ooool00ol0VOooooooo`0Koooo00<0000co`0co`000c?o
00030000oooooooo07[oool007ooool00ol0VOooooooo`0Koooo00<0000co`0co`000c?o00030000
oooooooo07[oool007ooool00ol0VOooooooo`0Koooo00<0000co`0co`000c?o00030000oooooooo
07[oool007ooool00ol0VOooooooo`0Koooo00<0000co`0co`000c?o00030000oooooooo07[oool0
07ooool00ol0VOooooooo`0Koooo00<0000co`0co`000c?o00030000oooooooo07[oool007ooool0
0ol0VOooooooo`0Koooo00<0000co`0co`000c?o0080001koooo001ooooo00?o09Woooooool06ooo
o`030000<ol0<ol000<co`000`000?ooooooo`1joooo001ooooo00?o09Woooooool06oooo`030000
<ol0<ol000<co`000`000?ooooooo`1joooo001ooooo00?o09Woooooool07?ooo`030000<ol0<ol0
008co`000`000?ooooooo`1joooo001ooooo00?o09Woooooool07?ooo`030000<ol0<ol0008co`00
0`000?ooooooo`1joooo001ooooo00?o09Woooooool07?ooo`030000<ol0<ol0008co`000`000?oo
ooooo`1joooo001ooooo00?o09Woooooool07?ooo`030000<ol0<ol0008co`000`000?ooooooo`1j
oooo001ooooo00?o09Woooooool07?ooo`030000<ol0<ol0008co`020000Noooo`00Ooooo`03o`2I
oooooooo01coool00`0003?o03?o0002<ol000<0003oooooool0N_ooo`00Ooooo`03o`2Ioooooooo
01coool00`0003?o03?o0002<ol000<0003oooooool0N_ooo`00Ooooo`03o`2Ioooooooo01coool0
0`0003?o03?o0002<ol000<0003oooooool0N_ooo`00Ooooo`03o`2Ioooooooo01coool00`0003?o
03?o0002<ol000<0003oooooool0N_ooo`00Ooooo`03o`2Ioooooooo01coool00`0003?o03?o0002
<ol000<0003oooooool0N_ooo`00Ooooo`03o`2Ioooooooo01coool00`0003?o03?o0002<ol00P00
07_oool007ooool00ol0VOooooooo`0Moooo00D0000co`0co`0co`000000O?ooo`00Ooooo`03o`2I
oooooooo01goool01@0003?o03?o03?o0000001loooo001ooooo00?o09Woooooool07Oooo`050000
<ol0<ol0<ol0000007coool007ooool00ol0VOooooooo`0Ioooo1@0000<co`000`000?ooooooo`1j
oooo001ooooo00?o09Woooooool06Oooo`050000oooooooooooo000000<co`000`000?ooooooo`1j
oooo001ooooo00?o09Woooooool06_ooo`040000oooooooo00000c?o00<0001joooo001ooooo00?o
09Woooooool06oooo`030000oooo000000<co`000`000?ooooooo`1joooo001ooooo00?o09Wooooo
ool06Oooo`030000oooooooo00800003<ol000<0003oooooool0N_ooo`00Ooooo`03o`2Ioooooooo
01[oool2000000?oool0000co`000S?o00030000oooooooo07[oool007ooool00ol0VOooooooo`0M
oooo00D0000co`0co`0co`000000O?ooo`00Ooooo`03o`2Ioooooooo01koool0100003?o03?o0000
07coool007ooool00ol0VOooooooo`0Noooo00<0000co`0co`000P0007_oool007ooool00ol0VOoo
ooooo`0Noooo00@0000co`0co`00001loooo001ooooo00?o09Woooooool07_ooo`040000<ol0<ol0
0000O?ooo`00Ooooo`03o`2Ioooooooo01koool0100003?o03?o000007coool007ooool00ol0VOoo
ooooo`0Noooo00@0000co`0co`00001loooo001ooooo00?o09Woooooool07_ooo`040000<ol0<ol0
0000O?ooo`00Ooooo`03o`2Ioooooooo01koool0100003?o03?o000007coool007ooool00ol0VOoo
ooooo`0Ooooo00@0000co`000000001koooo001ooooo00?o09Woooooool07oooo`030000<ol00000
07coool007ooool00ol0VOooooooo`0Ooooo00<0000co`000000O?ooo`00Ooooo`03o`2Ioooooooo
01ooool00`0003?o0000001loooo001ooooo00?o09Woooooool07oooo`030000<ol0000007coool0
07ooool00ol0VOooooooo`0Ooooo00<0000co`000000O?ooo`00Ooooo`03o`2Ioooooooo01ooool0
100003?o0000000007_oool007ooool00ol0VOooooooo`0Ooooo00<0000co`000000O?ooo`00Oooo
o`03o`2Ioooooooo01ooool00`0003?o0000001loooo001ooooo00?o09Woooooool07oooo`030000
<ol0000007coool007ooool00ol0VOooooooo`0Ooooo00<0000co`000000O?ooo`00Ooooo`03o`2I
oooooooo01ooool00`0003?o0000001loooo001ooooo00?o09Woooooool07oooo`040000<ol00000
0000Noooo`00Ooooo`03o`2Ioooooooo01ooool00`0003?o0000001loooo001ooooo00?o09Wooooo
ool07oooo`030000<ol0000007coool007ooool00ol0VOooooooo`0Ooooo00<0000co`000000O?oo
o`00Ooooo`03o`2Ioooooooo01[oool200000oooo`030000<ol0000007coool007ooool00ol0VOoo
ooooo`0Ioooo00@0003oooooool00002oooo00<0000co`000000O?ooo`00Ooooo`03o`2Ioooooooo
01_oool01P000?ooooooooooo`0003?o00<0001joooo001ooooo00?o09Woooooool07?ooo`060000
oooooooo0000<ol00000O?ooo`00Ooooo`03o`2Ioooooooo01Woool010000?ooooooo`0000;oool0
0`0003?o0000001loooo001ooooo00?o09Woooooool06_ooo`800004oooo0P0007coool007ooool0
0ol0VOooooooo`0Poooo0P0007coool007ooool00ol0VOooooooo`0Poooo0P0007coool007ooool0
0ol0VOooooooo`0Poooo0P0007coool007ooool00ol0VOooooooo`0Poooo0`0007_oool007ooool0
0ol0VOooooooo`0Poooo0P0007coool007ooool00ol0VOooooooo`0Poooo0P0007coool007ooool0
0ol0VOooooooo`0Poooo0P0007coool007ooool00ol0VOooooooo`0Poooo0P0007coool007ooool0
0ol0VOooooooo`0Poooo0P0007coool007ooool00ol0VOooooooo`0Poooo0`0007_oool007ooool0
0ol0VOooooooo`0Poooo0P0007coool007ooool00ol0VOooooooo`0Poooo0P0007coool007ooool0
0ol0VOooooooo`0Poooo0P0007coool007ooool00ol0VOooooooo`0Poooo0P0007coool007ooool0
0ol0VOooooooo`0Poooo0P0007coool007ooool00ol0VOooooooo`0Poooo0`0007_oool007ooool0
0ol0VOooooooo`0Qoooo00<0003oooooool0N_ooo`00Ooooo`03o`2Ioooooooo027oool00`000?oo
ooooo`1joooo001ooooo00?o09Woooooool08Oooo`030000oooooooo07[oool007ooool00ol0VOoo
ooooo`0Qoooo00<0003oooooool0N_ooo`00Ooooo`03o`2Ioooooooo027oool00`000?ooooooo`1j
oooo001ooooo00?o09Woooooool08Oooo`80001koooo001ooooo00?o09Woooooool08Oooo`030000
oooooooo07[oool007ooool00ol0VOooooooo`0Qoooo00<0003oooooool0N_ooo`00Ooooo`03o`2I
oooooooo027oool00`000?ooooooo`1joooo001ooooo00?o09Woooooool08Oooo`030000oooooooo
07[oool007ooool00ol0VOooooooo`0Koooo0`0000?oool00`000?ooooooo`1joooo001ooooo00?o
09Woooooool07?ooo`030000oooooooo00;oool00`000?ooooooo`1joooo001ooooo00?o09Wooooo
ool06Oooo`D00003oooo0`0007[oool009_oool010000?ooooooo`00087oool009coool00`000?oo
o`000021oooo002Moooo0P00087oool00?oooolQoooo003ooooo8Oooo`00NOooo`030000oooooooo
02Soool00`000?ooooooo`1ioooo001hoooo00<0003oooooool02?ooo`030000oooooooo01ooool0
0`000?ooooooo`1hoooo001hoooo00<0003oooooool00_ooo`800004oooo00<0003oooooool03?oo
o`@00003oooo0P0000Coool200001?ooo`030000oooooooo07Soool007Soool01@000?oooooooooo
o`000002oooo00<0003oooooool00_ooo`030000oooooooo00Coool400000oooo`030000oooooooo
00Woool010000?ooooooo`0000?oool00`000?ooooooo`1hoooo001goooo00<0003oooooool00_oo
o`030000oooooooo01Coool00`000?ooooooo`08oooo00@0003oooooool00004oooo00<0003ooooo
ool0Moooo`00N?ooo`030000oooooooo00D0000Doooo00<0003oooooool02?ooo`800004oooo00<0
003oooooool0N?ooo`00N?ooo`050000oooooooooooo000001Goool010000?ooooooo`0000Soool0
10000?ooooooo`0000?oool00`000?ooooooo`1hoooo001ioooo00<0003oooooool05oooo`80000:
oooo0P0000?oool00`000?ooooooo`1ioooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-8.12947, \
-1.14361, 0.0496935, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-8.12947, -1.14361, 0.0496935, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.7) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
.2 1 0 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.40095 .12361 L
.42237 .12361 L
.43215 .12361 L
.43755 .12361 L
.44021 .12361 L
.44151 .12361 L
.44268 .12361 L
.44387 .12361 L
s
.44387 .12361 m
.44431 .61803 L
s
0 .4 1 r
.02381 .12442 m
.04262 .12474 L
.06244 .12523 L
.07286 .12555 L
.08255 .12592 L
.09388 .12644 L
.10458 .12704 L
.125 .12854 L
.14357 .13048 L
.16355 .13341 L
.18199 .13723 L
.20071 .14262 L
.21136 .14659 L
.22134 .15107 L
.24158 .163 L
.26011 .1784 L
.27008 .18905 L
.27555 .19575 L
.2807 .20269 L
.28304 .20606 L
.28432 .20796 L
.28552 .20978 L
.28681 .21006 L
.2875 .21005 L
.28823 .21004 L
.29073 .21 L
.29982 .20982 L
.3198 .20931 L
.33801 .20866 L
.3571 .20771 L
.36788 .20701 L
.37786 .20624 L
.39652 .20436 L
.41712 .20144 L
.42655 .19971 L
.43647 .19755 L
.43898 .19694 L
.44167 .19626 L
.44246 .19606 L
.44321 .19586 L
.44388 .19568 L
.44461 .12361 L
.4453 .12361 L
.44604 .12361 L
.44735 .12361 L
.44853 .12361 L
.4498 .12361 L
.451 .12361 L
.4521 .12361 L
.45338 .12361 L
Mistroke
.45411 .12361 L
.45478 .12361 L
.45601 .12361 L
.45733 .12361 L
.45857 .12361 L
.45928 .12361 L
.45994 .12361 L
.46064 .12361 L
.46127 .12361 L
.46201 .12361 L
.4627 .12361 L
.46393 .12361 L
.46507 .12361 L
.46631 .12361 L
.46694 .12361 L
.46764 .12361 L
.46834 .12361 L
.46908 .12361 L
.46972 .12361 L
.47041 .12361 L
.47115 .12361 L
.47195 .12361 L
.4727 .12361 L
.47339 .12361 L
.47408 .12361 L
.47472 .12361 L
.47542 .12361 L
.47616 .12361 L
.47741 .12361 L
.47812 .12361 L
.47878 .12361 L
.48003 .12361 L
.48074 .12361 L
.48139 .12361 L
.48259 .12361 L
.48387 .12361 L
.48501 .12361 L
.48608 .12361 L
.48725 .12361 L
.48851 .12361 L
.48978 .12361 L
.4905 .12361 L
.49117 .12361 L
.49187 .12361 L
.49252 .12361 L
.49326 .12361 L
.49396 .12361 L
.49521 .12361 L
.49636 .12361 L
.49762 .12361 L
Mistroke
.49826 .12361 L
.49896 .12361 L
.50025 .12361 L
.50145 .12361 L
.50276 .12361 L
.5035 .12361 L
.50416 .12361 L
.50539 .12361 L
.50671 .12361 L
.50796 .12361 L
.50911 .12361 L
.51022 .12361 L
.51126 .12361 L
.5124 .12361 L
.51362 .12361 L
.5149 .12361 L
.51611 .12361 L
.5172 .12361 L
.51838 .12361 L
.51967 .12361 L
.52089 .12361 L
.52158 .12361 L
.52221 .12361 L
.52291 .12361 L
.52365 .12361 L
.52432 .12361 L
.52503 .12361 L
.52632 .12361 L
.5271 .12361 L
.52785 .12361 L
.52851 .12361 L
.52923 .12361 L
.53044 .12361 L
.53113 .12361 L
.53177 .12361 L
.53307 .12361 L
.53379 .12361 L
.53446 .12361 L
.53564 .12361 L
.53693 .12361 L
.53814 .12361 L
.53927 .12361 L
.54056 .12361 L
.54121 .12361 L
.54193 .12361 L
.54319 .12361 L
.54437 .12361 L
.54508 .12361 L
.54576 .12361 L
.54703 .12361 L
Mistroke
.54774 .12361 L
.54839 .12361 L
.54911 .12361 L
.54987 .12361 L
.55105 .12361 L
.55232 .12361 L
.55342 .12361 L
.55462 .12361 L
.55534 .12361 L
.55602 .12361 L
.55666 .12361 L
.55735 .12361 L
.55866 .12361 L
.55985 .12361 L
.56101 .12361 L
.56224 .12361 L
.5633 .12361 L
.56445 .12361 L
.56569 .12361 L
.56639 .12361 L
.56703 .12361 L
.56826 .12361 L
.56943 .12361 L
.57052 .12361 L
.57168 .12361 L
.57267 .12361 L
.57376 .12361 L
.57493 .12361 L
.57619 .12361 L
.57738 .12361 L
.57847 .12361 L
.57975 .12361 L
.58095 .12361 L
.58321 .12361 L
.58827 .12361 L
.59738 .12361 L
.61808 .12361 L
.65654 .12361 L
.69744 .12361 L
.73683 .12361 L
.77471 .12361 L
.81504 .12361 L
.85385 .12361 L
.89511 .12361 L
.93486 .12361 L
.97309 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.7) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Koooo1@00083oool009goool00`000?ooooooo`20oooo002Moooo00<0003ooooo
ool00oooo`<0001joooo002Eoooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0N_oo
o`00WOooo`030000oooooooo00?oool00`000?ooooooo`1joooo002Loooo0P0000Goool00`000?oo
ooooo`1joooo002Soooo00<0003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool2
0000Noooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0
003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002S
oooo00<0003oooooool0N_ooo`00Xoooo`80001koooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool00:?oool20000Noooo`00:oooo`<0000Xoooo0`0002?oool4
00008oooo`030000oooooooo02?oool400009oooo`<0000Yoooo000[oooo00@0003oooooool0000X
oooo00<0003oooooool08_ooo`030000oooooooo02Coool00`000?ooooooo`0Soooo00<0003ooooo
ool0:Oooo`030000oooooooo02Soool002_oool010000?ooooooo`0002Goool500009?ooo`030000
oooooooo02?oool00`000?ooooooo`0Toooo00<0003oooooool09Oooo`D0000Yoooo000Uoooo1000
00;oool300008?ooo`@00002oooo00@0003oooooool0000Noooo100000Coool00`000?ooooooo`0R
oooo00<0003oooooool09Oooo`030000oooooooo02Coool010000?ooooooo`0002[oool002coool0
0`000?ooooooo`0Voooo00<0003oool000009?ooo`040000oooooooo00008oooo`030000oooooooo
02?oool010000?ooooooo`0002Koool00`000?ooo`00000Zoooo000/oooo0`0002Ooool200009Ooo
o`80000Toooo0P0002Goool20000:?ooo`80000Zoooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool0013ooooo00004Oooo`005_ooo`03000006Ko06Ko00L0I_l0
0`00001Vo`1Vo`0706Ko00@00000I_l0I_l0I_l6oooo00<0003oooooool01oooo`030000oooooooo
00Soool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?oo
ooooo`07oooo00<0003oool000003@00000506Ko00000000<ol0000000Tco`000`0003?o03?o0007
<ol000<0000co`0co`001c?o00030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Soool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`0Eoooo000Zoooo00@0003oooooooooool:06Ko6oooo`030000oooooooo02Goool0
0`000?ooooooo`03oooo00<0I_ooooooool0100001/co`000`000?ooooooo`0Uoooo00<0003ooooo
ool09_ooo`030000oooooooo02Woool003Soool406KoAOooo`0306Kooooooooo00Coool400005c?o
00030000oooooooo07[oool003coool506Ko@?ooo`0306Kooooooooo00Soool00`0003?o03?o000D
<ol000<0003oooooool0N_ooo`00@Oooo`@0I_lloooo00<0I_ooooooool02Oooo`80000D<ol000<0
003oooooool0N_ooo`00AOooo`80I_ljoooo00<0I_ooooooool02oooo`030000<ol0<ol0014co`00
0`000?ooooooo`1joooo0017oooo0P1VocSoool00`1Vooooooooo`0<oooo00<0000co`0co`0043?o
0080001koooo0019oooo0P1VocKoool00`1Vooooooooo`0=oooo0P00010co`000`000?ooooooo`1j
oooo001;oooo0P1VocCoool00`1Vooooooooo`0?oooo00<0000co`0co`003C?o00030000oooooooo
07[oool004goool00`1Vooooooooo`0aoooo00<0I_ooooooool03oooo`030000<ol0<ol000dco`00
0`000?ooooooo`1joooo001>oooo00<0I_ooooooool0<?ooo`0306Kooooooooo013oool00`0003?o
03?o000<<ol000<0003oooooool0N_ooo`00Coooo`80I_l`oooo00<0I_ooooooool04?ooo`030000
<ol0<ol000`co`000`000?ooooooo`1joooo001Aoooo00<0I_ooooooool0;Oooo`0306Kooooooooo
017oool00`0003?o03?o000;<ol00P0007_oool005;oool00`1Vooooooooo`0/oooo00<0I_oooooo
ool04Oooo`030000<ol0<ol000/co`000`000?ooooooo`1joooo001Coooo00<0I_ooooooool0:ooo
o`0306Kooooooooo01;oool00`0003?o03?o000:<ol000<0003oooooool0N_ooo`00E?ooo`0306Ko
oooooooo02[oool00`1Vooooooooo`0Boooo00<0000co`0co`002S?o00030000oooooooo07[oool0
05Goool00`1Vooooooooo`0Yoooo00<0I_ooooooool04oooo`030000<ol0<ol000Tco`000`000?oo
ooooo`1joooo001Eoooo00<0I_ooooooool0:Oooo`0306Kooooooooo01?oool00`0003?o03?o0009
<ol000<0003oooooool0N_ooo`00E_ooo`0306Kooooooooo02Goool406Ko5_ooo`030000<ol0<ol0
00Pco`020000Noooo`00Eoooo`0306Kooooooooo01koool606Ko0oooo`03o`2Ioooooooo01Coool0
0`0003?o03?o0008<ol000<0003oooooool0N_ooo`00F?ooo`0306Kooooooooo01Coool906Ko2Ooo
o`03o`2Ioooooooo01Coool00`0003?o03?o0008<ol000<0003oooooool0N_ooo`00F?oooaL0I_lB
oooo00?o09Woooooool05Oooo`030000<ol0<ol000Lco`000`000?ooooooo`1joooo0021oooo00?o
09Woooooool05Oooo`030000<ol0<ol000Lco`000`000?ooooooo`1joooo0021oooo00?o09Wooooo
ool05Oooo`030000<ol0<ol000Lco`000`000?ooooooo`1joooo0021oooo00?o09Woooooool05Ooo
o`030000<ol0<ol000Lco`020000Noooo`00POooo`03o`2Ioooooooo01Koool00`0003?o03?o0006
<ol000<0003oooooool0N_ooo`00POooo`03o`2Ioooooooo01Koool00`0003?o03?o0006<ol000<0
003oooooool0N_ooo`00POooo`03o`2Ioooooooo01Koool00`0003?o03?o0006<ol000<0003ooooo
ool0N_ooo`00POooo`03o`2Ioooooooo01Koool00`0003?o03?o0006<ol000<0003oooooool0N_oo
o`00POooo`03o`2Ioooooooo01Ooool500000c?o00030000oooooooo07[oool0087oool00ol0VOoo
ooooo`0Goooo00<0000co`0000001C?o00030000oooooooo07[oool0087oool00ol0VOooooooo`0G
oooo00<0000co`0000001C?o00<0001joooo0021oooo00?o09Woooooool06?ooo`800005<ol000<0
003oooooool0N_ooo`00POooo`03o`2Ioooooooo01Soool200001C?o00030000oooooooo07[oool0
087oool00ol0VOooooooo`0Hoooo0P0000Dco`000`000?ooooooo`1joooo0021oooo00?o09Wooooo
ool06?ooo`030000<ol0<ol000@co`000`000?ooooooo`1joooo0021oooo00?o09Woooooool06?oo
o`030000<ol0<ol000@co`000`000?ooooooo`1joooo0021oooo00?o09Woooooool06?ooo`030000
<ol0<ol000@co`020000Noooo`00POooo`03o`2Ioooooooo01Woool00`0003?o03?o0003<ol000<0
003oooooool0N_ooo`00POooo`03o`2Ioooooooo01Woool00`0003?o03?o0003<ol000<0003ooooo
ool0N_ooo`00POooo`03o`2Ioooooooo01Woool00`0003?o03?o0003<ol000<0003oooooool0N_oo
o`00POooo`03o`2Ioooooooo01Woool00`0003?o03?o0003<ol000<0003oooooool0N_ooo`00POoo
o`03o`2Ioooooooo01Woool00`0003?o03?o0003<ol000<0003oooooool0N_ooo`00POooo`03o`2I
oooooooo01Woool00`0003?o03?o0003<ol00P0007_oool0087oool00ol0VOooooooo`0Ioooo00<0
000co`0co`000c?o00030000oooooooo07[oool0087oool00ol0VOooooooo`0Ioooo00<0000co`0c
o`000c?o00030000oooooooo07[oool0087oool00ol0VOooooooo`0Joooo00<0000co`0co`000S?o
00030000oooooooo07[oool0087oool00ol0VOooooooo`0Joooo00<0000co`0co`000S?o00030000
oooooooo07[oool0087oool00ol0VOooooooo`0Joooo00<0000co`0co`000S?o00030000oooooooo
07[oool0087oool00ol0VOooooooo`0Joooo00<0000co`0co`000S?o00030000oooooooo07[oool0
087oool00ol0VOooooooo`0Joooo00<0000co`0co`000S?o0080001koooo0021oooo00?o09Wooooo
ool06_ooo`030000<ol0<ol0008co`000`000?ooooooo`1joooo0021oooo00?o09Woooooool06_oo
o`030000<ol0<ol0008co`000`000?ooooooo`1joooo0021oooo00?o09Woooooool06_ooo`030000
<ol0<ol0008co`000`000?ooooooo`1joooo0021oooo00?o09Woooooool06_ooo`030000<ol0<ol0
008co`000`000?ooooooo`1joooo0021oooo00?o09Woooooool06_ooo`030000<ol0<ol0008co`00
0`000?ooooooo`1joooo0021oooo00?o09Woooooool06_ooo`030000<ol0<ol0008co`020000Nooo
o`00POooo`03o`2Ioooooooo01_oool01@0003?o03?o03?o0000001loooo0021oooo00?o09Wooooo
ool06oooo`050000<ol0<ol0<ol0000007coool0087oool00ol0VOooooooo`0Koooo00D0000co`0c
o`0co`000000O?ooo`00POooo`03o`2Ioooooooo01Ooool500000c?o00030000oooooooo07[oool0
087oool00ol0VOooooooo`0Goooo00D0003oooooooooool000000c?o00030000oooooooo07[oool0
087oool00ol0VOooooooo`0Hoooo00@0003oooooool00003<ol00`0007[oool0087oool00ol0VOoo
ooooo`0Ioooo00<0003oool000000c?o00030000oooooooo07[oool0087oool00ol0VOooooooo`0G
oooo00<0003oooooool00P0000<co`000`000?ooooooo`1joooo0021oooo00?o09Woooooool06?oo
o`8000000oooo`0003?o0002<ol000<0003oooooool0N_ooo`00POooo`03o`2Ioooooooo01_oool0
1@0003?o03?o03?o0000001loooo0021oooo00?o09Woooooool07?ooo`040000<ol0<ol00000O?oo
o`00POooo`03o`2Ioooooooo01coool00`0003?o03?o00020000Noooo`00POooo`03o`2Ioooooooo
01coool0100003?o03?o000007coool0087oool00ol0VOooooooo`0Loooo00@0000co`0co`00001l
oooo0021oooo00?o09Woooooool07?ooo`040000<ol0<ol00000O?ooo`00POooo`03o`2Ioooooooo
01coool0100003?o03?o000007coool0087oool00ol0VOooooooo`0Loooo00@0000co`0co`00001l
oooo0021oooo00?o09Woooooool07?ooo`040000<ol0<ol00000O?ooo`00POooo`03o`2Ioooooooo
01goool0100003?o0000000007_oool0087oool00ol0VOooooooo`0Moooo00<0000co`000000O?oo
o`00POooo`03o`2Ioooooooo01goool00`0003?o0000001loooo0021oooo00?o09Woooooool07Ooo
o`030000<ol0000007coool0087oool00ol0VOooooooo`0Moooo00<0000co`000000O?ooo`00POoo
o`03o`2Ioooooooo01goool00`0003?o0000001loooo0021oooo00?o09Woooooool07Oooo`040000
<ol000000000Noooo`00POooo`03o`2Ioooooooo01goool00`0003?o0000001loooo0021oooo00?o
09Woooooool07Oooo`030000<ol0000007coool0087oool00ol0VOooooooo`0Moooo00<0000co`00
0000O?ooo`00POooo`03o`2Ioooooooo01goool00`0003?o0000001loooo0021oooo00?o09Wooooo
ool07Oooo`030000<ol0000007coool0087oool00ol0VOooooooo`0Moooo00@0000co`000000001k
oooo0021oooo00?o09Woooooool07Oooo`030000<ol0000007coool0087oool00ol0VOooooooo`0M
oooo00<0000co`000000O?ooo`00POooo`03o`2Ioooooooo01goool00`0003?o0000001loooo0021
oooo00?o09Woooooool06?ooo`800003oooo00<0000co`000000O?ooo`00POooo`03o`2Ioooooooo
01Ooool010000?ooooooo`0000;oool00`0003?o0000001loooo0021oooo00?o09Woooooool06Ooo
o`060000oooooooooooo0000<ol00`0007[oool0087oool00ol0VOooooooo`0Joooo00H0003ooooo
ool0000co`00001loooo0021oooo00?o09Woooooool05oooo`040000oooooooo00000_ooo`030000
<ol0000007coool0087oool00ol0VOooooooo`0Hoooo0P0000Coool20000O?ooo`00POooo`03o`2I
oooooooo01koool20000O?ooo`00POooo`03o`2Ioooooooo01koool20000O?ooo`00POooo`03o`2I
oooooooo01koool20000O?ooo`00POooo`03o`2Ioooooooo01koool30000Noooo`00POooo`03o`2I
oooooooo01koool20000O?ooo`00POooo`03o`2Ioooooooo01koool20000O?ooo`00POooo`03o`2I
oooooooo01koool20000O?ooo`00POooo`03o`2Ioooooooo01koool20000O?ooo`00POooo`03o`2I
oooooooo01koool20000O?ooo`00POooo`03o`2Ioooooooo01koool30000Noooo`00POooo`03o`2I
oooooooo01koool20000O?ooo`00POooo`03o`2Ioooooooo01koool20000O?ooo`00POooo`03o`2I
oooooooo01koool20000O?ooo`00POooo`03o`2Ioooooooo01koool20000O?ooo`00POooo`03o`2I
oooooooo01koool20000O?ooo`00POooo`03o`2Ioooooooo01koool30000Noooo`00POooo`03o`2I
oooooooo01ooool00`000?ooooooo`1joooo0021oooo00?o09Woooooool07oooo`030000oooooooo
07[oool0087oool00ol0VOooooooo`0Ooooo00<0003oooooool0N_ooo`00POooo`03o`2Ioooooooo
01ooool00`000?ooooooo`1joooo0021oooo00?o09Woooooool07oooo`030000oooooooo07[oool0
087oool00ol0VOooooooo`0Ooooo0P0007_oool0087oool00ol0VOooooooo`0Ooooo00<0003ooooo
ool0N_ooo`00POooo`03o`2Ioooooooo01ooool00`000?ooooooo`1joooo0021oooo00?o09Wooooo
ool07oooo`030000oooooooo07[oool0087oool00ol0VOooooooo`0Ooooo00<0003oooooool0N_oo
o`00POooo`03o`2Ioooooooo01Woool300000oooo`030000oooooooo07[oool0087oool00ol0VOoo
ooooo`0Joooo00<0003oooooool00_ooo`030000oooooooo07[oool0087oool00ol0VOooooooo`0G
oooo1@0000?oool30000N_ooo`00Voooo`040000oooooooo0000POooo`00W?ooo`030000oooo0000
087oool009goool20000POooo`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?oo
o`030000oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000
oooooooo07Soool007Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1000
00?oool200001Oooo`030000oooooooo00;oool00`000?ooooooo`1hoooo001hoooo00D0003ooooo
ooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`04oooo100000?oool00`000?oo
ooooo`0;oooo00<0003oooooool00_ooo`030000oooooooo07Soool007Ooool00`000?ooooooo`02
oooo00<0003oooooool05?ooo`030000oooooooo00[oool00`000?ooooooo`03oooo00<0003ooooo
ool0Moooo`00N?ooo`030000oooooooo00D0000Doooo00<0003oooooool02_ooo`050000oooooooo
oooo000007[oool007Soool01@000?ooooooooooo`00000Eoooo00@0003oooooool00008oooo00@0
003oooooool00003oooo00<0003oooooool0N?ooo`00NOooo`030000oooooooo01Ooool200002Ooo
o`@00002oooo00<0003oooooool0NOooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-8.12947, \
-1.14361, 0.0496935, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-8.12947, -1.14361, 0.0496935, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
.2 1 0 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.40095 .12361 L
.42237 .12361 L
.43215 .12361 L
.43755 .12361 L
.44268 .12361 L
.44744 .12361 L
.44874 .12361 L
.45013 .12361 L
.45143 .12361 L
s
.45143 .12361 m
.45191 .61803 L
s
0 .4 1 r
.02381 .12431 m
.04262 .12459 L
.06244 .12501 L
.07286 .1253 L
.08255 .12562 L
.09388 .12607 L
.10458 .12658 L
.125 .12789 L
.14357 .12957 L
.16355 .13212 L
.18199 .13543 L
.20071 .14011 L
.21136 .14356 L
.22134 .14744 L
.24158 .1578 L
.26011 .17117 L
.2807 .19225 L
.28586 .19887 L
.29073 .20568 L
.29285 .20885 L
.29392 .21006 L
.29509 .21004 L
.29755 .21 L
.29982 .20996 L
.3183 .20955 L
.33801 .20894 L
.35752 .20808 L
.36846 .20745 L
.37844 .20676 L
.39752 .20506 L
.40739 .20392 L
.41828 .20242 L
.43806 .19884 L
.44327 .19767 L
.44601 .19702 L
.44889 .19629 L
.45012 .19597 L
.45142 .19562 L
.45218 .19542 L
.45286 .12361 L
.45355 .12361 L
.4542 .12361 L
.45541 .12361 L
.45653 .12361 L
.45776 .12361 L
.45906 .12361 L
.46027 .12361 L
.46159 .12361 L
.46284 .12361 L
.46399 .12361 L
Mistroke
.46514 .12361 L
.46618 .12361 L
.46737 .12361 L
.4685 .12361 L
.46974 .12361 L
.47104 .12361 L
.47215 .12361 L
.47337 .12361 L
.47469 .12361 L
.47543 .12361 L
.4761 .12361 L
.4774 .12361 L
.47864 .12361 L
.47969 .12361 L
.48085 .12361 L
.48206 .12361 L
.4832 .12361 L
.48426 .12361 L
.48523 .12361 L
.48629 .12361 L
.48741 .12361 L
.48856 .12361 L
.48978 .12361 L
.49093 .12361 L
.49197 .12361 L
.4932 .12361 L
.4939 .12361 L
.49453 .12361 L
.49571 .12361 L
.49695 .12361 L
.49817 .12361 L
.49885 .12361 L
.49949 .12361 L
.50063 .12361 L
.5019 .12361 L
.50303 .12361 L
.50409 .12361 L
.5052 .12361 L
.50641 .12361 L
.50764 .12361 L
.50834 .12361 L
.50899 .12361 L
.5103 .12361 L
.51104 .12361 L
.51171 .12361 L
.5129 .12361 L
.5142 .12361 L
.51543 .12361 L
.51656 .12361 L
.51762 .12361 L
Mistroke
.51875 .12361 L
.51982 .12361 L
.5208 .12361 L
.52194 .12361 L
.52319 .12361 L
.52437 .12361 L
.52546 .12361 L
.52669 .12361 L
.52786 .12361 L
.5289 .12361 L
.53003 .12361 L
.53126 .12361 L
.53256 .12361 L
.53367 .12361 L
.53489 .12361 L
.5362 .12361 L
.5374 .12361 L
.53803 .12361 L
.53873 .12361 L
.53946 .12361 L
.54014 .12361 L
.54138 .12361 L
.54253 .12361 L
.54378 .12361 L
.5451 .12361 L
.54622 .12361 L
.54741 .12361 L
.54853 .12361 L
.54955 .12361 L
.55075 .12361 L
.55205 .12361 L
.55328 .12361 L
.55441 .12361 L
.55562 .12361 L
.55692 .12361 L
.55814 .12361 L
.55926 .12361 L
.56056 .12361 L
.5613 .12361 L
.56199 .12361 L
.56324 .12361 L
.56394 .12361 L
.56458 .12361 L
.56525 .12361 L
.56597 .12361 L
.56724 .12361 L
.56795 .12361 L
.56862 .12361 L
.56934 .12361 L
.57012 .12361 L
Mistroke
.57079 .12361 L
.57152 .12361 L
.57217 .12361 L
.57285 .12361 L
.57414 .12361 L
.57533 .12361 L
.57654 .12361 L
.57785 .12361 L
.57909 .12361 L
.58024 .12361 L
.58139 .12361 L
.58242 .12361 L
.58474 .12361 L
.59486 .12361 L
.61316 .12361 L
.65321 .12361 L
.69175 .12361 L
.73274 .12361 L
.77222 .12361 L
.81017 .12361 L
.85059 .12361 L
.88948 .12361 L
.93083 .12361 L
.97066 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.6) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Koooo1@00083oool009goool00`000?ooooooo`20oooo002Moooo00<0003ooooo
ool00oooo`<0001joooo002Eoooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0N_oo
o`00WOooo`030000oooooooo00?oool00`000?ooooooo`1joooo002Loooo0P0000Goool00`000?oo
ooooo`1joooo002Soooo00<0003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool2
0000Noooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0
003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002S
oooo00<0003oooooool0N_ooo`00Xoooo`80001koooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool00:?oool20000Noooo`00:oooo`<0000Xoooo0`0002?oool4
00008oooo`030000oooooooo02?oool400009oooo`<0000Yoooo000[oooo00@0003oooooool0000X
oooo00<0003oooooool08_ooo`030000oooooooo02Coool00`000?ooooooo`0Soooo00<0003ooooo
ool0:Oooo`030000oooooooo02Soool002_oool010000?ooooooo`0002Goool500009?ooo`030000
oooooooo02?oool00`000?ooooooo`0Toooo00<0003oooooool09Oooo`D0000Yoooo000Uoooo1000
00;oool300008?ooo`@00002oooo00@0003oooooool0000Noooo100000Coool00`000?ooooooo`0R
oooo00<0003oooooool09Oooo`030000oooooooo02Coool010000?ooooooo`0002[oool002coool0
0`000?ooooooo`0Voooo00<0003oool000009?ooo`040000oooooooo00008oooo`030000oooooooo
02?oool010000?ooooooo`0002Koool00`000?ooo`00000Zoooo000/oooo0`0002Ooool200009Ooo
o`80000Toooo0P0002Goool20000:?ooo`80000Zoooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool0013ooooo00004Oooo`005_ooo`03000006Ko06Ko00L0I_l0
0`00001Vo`1Vo`0706Ko00<00000I_l0I_l01P1Vo`03oooo0000oooo00Soool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooo000000l000000`1Voc?o00000009<ol000<0000co`0co`001c?o00030000
<ol0<ol000Lco`000`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool05Oooo`00:_ooo`030000oooooooo00Koool506Ko6oooo`030000oooooooo02Goool00`000?oo
ooooo`05oooo00<0I_l0000000000P0001/co`000`000?ooooooo`0Uoooo00<0003oooooool09_oo
o`030000oooooooo02Woool003Soool806Ko@oooo`0306Kooooooooo00;oool400005c?o00030000
oooooooo07[oool0043oool206Ko@Oooo`0306Kooooooooo00Koool00`0003?o03?o000D<ol000<0
003oooooool0N_ooo`00@_ooo`D0I_lloooo00<0I_ooooooool01oooo`80000D<ol000<0003ooooo
ool0N_ooo`00Aoooo`80I_ljoooo00<0I_ooooooool02Oooo`030000<ol0<ol0014co`000`000?oo
ooooo`1joooo0019oooo0P1VocSoool00`1Vooooooooo`0:oooo00<0000co`0co`0043?o0080001k
oooo001;oooo0P1VocKoool00`1Vooooooooo`0;oooo0P00010co`000`000?ooooooo`1joooo001=
oooo00<0I_ooooooool0<oooo`0306Kooooooooo00goool00`0003?o03?o000=<ol000<0003ooooo
ool0N_ooo`00C_ooo`80I_lcoooo00<0I_ooooooool03Oooo`030000<ol0<ol000dco`000`000?oo
ooooo`1joooo001@oooo0P1Voc7oool00`1Vooooooooo`0>oooo00<0000co`0co`0033?o00030000
oooooooo07[oool005;oool00`1Vooooooooo`0^oooo00<0I_ooooooool03_ooo`030000<ol0<ol0
00`co`000`000?ooooooo`1joooo001Coooo00<0I_ooooooool0;Oooo`0306Kooooooooo00ooool0
0`0003?o03?o000;<ol00P0007_oool005Coool00`1Vooooooooo`0/oooo00<0I_ooooooool03ooo
o`030000<ol0<ol000/co`000`000?ooooooo`1joooo001Doooo00<0I_ooooooool0;?ooo`0306Ko
oooooooo013oool00`0003?o03?o000:<ol000<0003oooooool0N_ooo`00EOooo`0306Kooooooooo
02_oool00`1Vooooooooo`0@oooo00<0000co`0co`002S?o00030000oooooooo07[oool005Koool0
0`1Vooooooooo`0Zoooo00<0I_ooooooool04Oooo`030000<ol0<ol000Tco`000`000?ooooooo`1j
oooo001Goooo00<0I_ooooooool0:Oooo`0306Kooooooooo017oool00`0003?o03?o0009<ol000<0
003oooooool0N_ooo`00F?ooo`80I_lSoooo1`1VoaCoool00`0003?o03?o0008<ol00P0007_oool0
05Woool00`1Vooooooooo`0Moooo101Vo`Koool00ol0VOooooooo`0Boooo00<0000co`0co`0023?o
00030000oooooooo07[oool005[oool00`1Vooooooooo`0Coooo2@1Vo`[oool00ol0VOooooooo`0B
oooo00<0000co`0co`0023?o00030000oooooooo07[oool005[ooolF06Ko4oooo`03o`2Ioooooooo
01?oool00`0003?o03?o0007<ol000<0003oooooool0N_ooo`00Poooo`03o`2Ioooooooo01?oool0
0`0003?o03?o0007<ol000<0003oooooool0N_ooo`00Poooo`03o`2Ioooooooo01?oool00`0003?o
03?o0007<ol000<0003oooooool0N_ooo`00Poooo`03o`2Ioooooooo01?oool00`0003?o03?o0007
<ol00P0007_oool008?oool00ol0VOooooooo`0Doooo00<0000co`0co`001S?o00030000oooooooo
07[oool008?oool00ol0VOooooooo`0Doooo00<0000co`0co`001S?o00030000oooooooo07[oool0
08?oool00ol0VOooooooo`0Doooo00<0000co`0co`001S?o00030000oooooooo07[oool008?oool0
0ol0VOooooooo`0Doooo00<0000co`0co`001S?o00030000oooooooo07[oool008?oool00ol0VOoo
ooooo`0Eoooo1@0000<co`000`000?ooooooo`1joooo0023oooo00?o09Woooooool05Oooo`030000
<ol0000000Dco`000`000?ooooooo`1joooo0023oooo00?o09Woooooool05Oooo`030000<ol00000
00Dco`030000N_ooo`00Poooo`03o`2Ioooooooo01Koool200001C?o00030000oooooooo07[oool0
08?oool00ol0VOooooooo`0Foooo0P0000Dco`000`000?ooooooo`1joooo0023oooo00?o09Wooooo
ool05_ooo`800005<ol000<0003oooooool0N_ooo`00Poooo`03o`2Ioooooooo01Koool00`0003?o
03?o0004<ol000<0003oooooool0N_ooo`00Poooo`03o`2Ioooooooo01Koool00`0003?o03?o0004
<ol000<0003oooooool0N_ooo`00Poooo`03o`2Ioooooooo01Koool00`0003?o03?o0004<ol00P00
07_oool008?oool00ol0VOooooooo`0Goooo00<0000co`0co`000c?o00030000oooooooo07[oool0
08?oool00ol0VOooooooo`0Goooo00<0000co`0co`000c?o00030000oooooooo07[oool008?oool0
0ol0VOooooooo`0Goooo00<0000co`0co`000c?o00030000oooooooo07[oool008?oool00ol0VOoo
ooooo`0Goooo00<0000co`0co`000c?o00030000oooooooo07[oool008?oool00ol0VOooooooo`0G
oooo00<0000co`0co`000c?o00030000oooooooo07[oool008?oool00ol0VOooooooo`0Goooo00<0
000co`0co`000c?o0080001koooo0023oooo00?o09Woooooool05oooo`030000<ol0<ol000<co`00
0`000?ooooooo`1joooo0023oooo00?o09Woooooool05oooo`030000<ol0<ol000<co`000`000?oo
ooooo`1joooo0023oooo00?o09Woooooool06?ooo`030000<ol0<ol0008co`000`000?ooooooo`1j
oooo0023oooo00?o09Woooooool06?ooo`030000<ol0<ol0008co`000`000?ooooooo`1joooo0023
oooo00?o09Woooooool06?ooo`030000<ol0<ol0008co`000`000?ooooooo`1joooo0023oooo00?o
09Woooooool06?ooo`030000<ol0<ol0008co`000`000?ooooooo`1joooo0023oooo00?o09Wooooo
ool06?ooo`030000<ol0<ol0008co`020000Noooo`00Poooo`03o`2Ioooooooo01Soool00`0003?o
03?o0002<ol000<0003oooooool0N_ooo`00Poooo`03o`2Ioooooooo01Soool00`0003?o03?o0002
<ol000<0003oooooool0N_ooo`00Poooo`03o`2Ioooooooo01Soool00`0003?o03?o0002<ol000<0
003oooooool0N_ooo`00Poooo`03o`2Ioooooooo01Soool00`0003?o03?o0002<ol000<0003ooooo
ool0N_ooo`00Poooo`03o`2Ioooooooo01Soool00`0003?o03?o0002<ol000<0003oooooool0N_oo
o`00Poooo`03o`2Ioooooooo01Soool00`0003?o03?o0002<ol00P0007_oool008?oool00ol0VOoo
ooooo`0Ioooo00D0000co`0co`0co`000000O?ooo`00Poooo`03o`2Ioooooooo01Woool01@0003?o
03?o03?o0000001loooo0023oooo00?o09Woooooool06Oooo`050000<ol0<ol0<ol0000007coool0
08?oool00ol0VOooooooo`0Eoooo1@0000<co`000`000?ooooooo`1joooo0023oooo00?o09Wooooo
ool05Oooo`050000oooooooooooo000000<co`000`000?ooooooo`1joooo0023oooo00?o09Wooooo
ool05_ooo`040000oooooooo00000c?o00<0001joooo0023oooo00?o09Woooooool05oooo`030000
oooo000000<co`000`000?ooooooo`1joooo0023oooo00?o09Woooooool05Oooo`030000oooooooo
00800003<ol000<0003oooooool0N_ooo`00Poooo`03o`2Ioooooooo01Koool2000000?oool0000c
o`000S?o00030000oooooooo07[oool008?oool00ol0VOooooooo`0Ioooo00D0000co`0co`0co`00
0000O?ooo`00Poooo`03o`2Ioooooooo01[oool0100003?o03?o000007coool008?oool00ol0VOoo
ooooo`0Joooo00<0000co`0co`000P0007_oool008?oool00ol0VOooooooo`0Joooo00@0000co`0c
o`00001loooo0023oooo00?o09Woooooool06_ooo`040000<ol0<ol00000O?ooo`00Poooo`03o`2I
oooooooo01[oool0100003?o03?o000007coool008?oool00ol0VOooooooo`0Joooo00@0000co`0c
o`00001loooo0023oooo00?o09Woooooool06_ooo`040000<ol0<ol00000O?ooo`00Poooo`03o`2I
oooooooo01[oool0100003?o03?o000007coool008?oool00ol0VOooooooo`0Koooo00@0000co`00
0000001koooo0023oooo00?o09Woooooool06oooo`030000<ol0000007coool008?oool00ol0VOoo
ooooo`0Koooo00<0000co`000000O?ooo`00Poooo`03o`2Ioooooooo01_oool00`0003?o0000001l
oooo0023oooo00?o09Woooooool06oooo`030000<ol0000007coool008?oool00ol0VOooooooo`0K
oooo00<0000co`000000O?ooo`00Poooo`03o`2Ioooooooo01_oool0100003?o0000000007_oool0
08?oool00ol0VOooooooo`0Koooo00<0000co`000000O?ooo`00Poooo`03o`2Ioooooooo01_oool0
0`0003?o0000001loooo0023oooo00?o09Woooooool06oooo`030000<ol0000007coool008?oool0
0ol0VOooooooo`0Koooo00<0000co`000000O?ooo`00Poooo`03o`2Ioooooooo01_oool00`0003?o
0000001loooo0023oooo00?o09Woooooool06oooo`040000<ol000000000Noooo`00Poooo`03o`2I
oooooooo01_oool00`0003?o0000001loooo0023oooo00?o09Woooooool06oooo`030000<ol00000
07coool008?oool00ol0VOooooooo`0Koooo00<0000co`000000O?ooo`00Poooo`03o`2Ioooooooo
01Koool200000oooo`030000<ol0000007coool008?oool00ol0VOooooooo`0Eoooo00@0003ooooo
ool00002oooo00<0000co`000000O?ooo`00Poooo`03o`2Ioooooooo01Ooool01P000?oooooooooo
o`0003?o00<0001joooo0023oooo00?o09Woooooool06?ooo`060000oooooooo0000<ol00000O?oo
o`00Poooo`03o`2Ioooooooo01Goool010000?ooooooo`0000;oool00`0003?o0000001loooo0023
oooo00?o09Woooooool05_ooo`800004oooo0P0007coool008?oool00ol0VOooooooo`0Loooo0P00
07coool008?oool00ol0VOooooooo`0Loooo0P0007coool008?oool00ol0VOooooooo`0Loooo0P00
07coool008?oool00ol0VOooooooo`0Loooo0`0007_oool008?oool00ol0VOooooooo`0Loooo0P00
07coool008?oool00ol0VOooooooo`0Loooo0P0007coool008?oool00ol0VOooooooo`0Loooo0P00
07coool008?oool00ol0VOooooooo`0Loooo0P0007coool008?oool00ol0VOooooooo`0Loooo0P00
07coool008?oool00ol0VOooooooo`0Loooo0`0007_oool008?oool00ol0VOooooooo`0Loooo0P00
07coool008?oool00ol0VOooooooo`0Loooo0P0007coool008?oool00ol0VOooooooo`0Loooo0P00
07coool008?oool00ol0VOooooooo`0Loooo0P0007coool008?oool00ol0VOooooooo`0Loooo0P00
07coool008?oool00ol0VOooooooo`0Loooo0`0007_oool008?oool00ol0VOooooooo`0Moooo00<0
003oooooool0N_ooo`00Poooo`03o`2Ioooooooo01goool00`000?ooooooo`1joooo0023oooo00?o
09Woooooool07Oooo`030000oooooooo07[oool008?oool00ol0VOooooooo`0Moooo00<0003ooooo
ool0N_ooo`00Poooo`03o`2Ioooooooo01goool00`000?ooooooo`1joooo0023oooo00?o09Wooooo
ool07Oooo`80001koooo0023oooo00?o09Woooooool07Oooo`030000oooooooo07[oool008?oool0
0ol0VOooooooo`0Moooo00<0003oooooool0N_ooo`00Poooo`03o`2Ioooooooo01goool00`000?oo
ooooo`1joooo0023oooo00?o09Woooooool07Oooo`030000oooooooo07[oool008?oool00ol0VOoo
ooooo`0Goooo0`0000?oool00`000?ooooooo`1joooo0023oooo00?o09Woooooool06?ooo`030000
oooooooo00;oool00`000?ooooooo`1joooo0023oooo00?o09Woooooool05Oooo`D00003oooo0`00
07[oool009_oool010000?ooooooo`00087oool009coool00`000?ooo`000021oooo002Moooo0P00
087oool00?oooolQoooo003ooooo8Oooo`00NOooo`030000oooooooo02Soool00`000?ooooooo`1i
oooo001hoooo00<0003oooooool02?ooo`030000oooooooo01ooool00`000?ooooooo`1hoooo001h
oooo00<0003oooooool00_ooo`800004oooo00<0003oooooool03?ooo`@00003oooo0P0000?oool3
00001?ooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`000002oooo00<0003ooooo
ool00_ooo`030000oooooooo00Coool400000oooo`030000oooooooo00Woool010000?ooooooo`00
00?oool00`000?ooooooo`1hoooo001goooo00<0003oooooool00_ooo`030000oooooooo01Coool0
0`000?ooooooo`08oooo00@0003oooooool00004oooo00<0003oooooool0Moooo`00N?ooo`030000
oooooooo00D0000Doooo00<0003oooooool01oooo`<00004oooo00<0003oooooool0N?ooo`00N?oo
o`050000oooooooooooo000001Goool010000?ooooooo`0000Woool00`000?ooooooo`03oooo00<0
003oooooool0N?ooo`00NOooo`030000oooooooo01Ooool200002_ooo`<00002oooo00<0003ooooo
ool0NOooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-8.12947, \
-1.14361, 0.0496935, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-8.12947, -1.14361, 0.0496935, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
.2 1 0 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.40095 .12361 L
.42237 .12361 L
.43215 .12361 L
.44268 .12361 L
.44778 .12361 L
.45262 .12361 L
.45697 .12361 L
.45816 .12361 L
.45943 .12361 L
s
.45943 .12361 m
.45991 .61803 L
s
0 .4 1 r
.02381 .12422 m
.04262 .12446 L
.06244 .12483 L
.07286 .12507 L
.08255 .12535 L
.09388 .12574 L
.10458 .12619 L
.125 .12732 L
.14357 .12878 L
.16355 .13099 L
.18199 .13387 L
.20071 .13793 L
.21136 .14092 L
.22134 .14429 L
.24158 .15328 L
.26011 .16489 L
.27909 .18151 L
.28984 .19373 L
.29504 .20053 L
.29982 .20737 L
.30109 .2093 L
.30229 .21004 L
.30353 .21002 L
.30489 .20999 L
.31039 .20989 L
.32034 .20967 L
.33895 .20915 L
.3593 .20834 L
.37786 .20729 L
.39694 .2058 L
.40681 .20481 L
.4177 .2035 L
.43748 .20037 L
.44831 .19815 L
.45317 .19701 L
.45574 .19637 L
.45715 .196 L
.45848 .19565 L
.45976 .1953 L
.46049 .12361 L
.46115 .12361 L
.46233 .12361 L
.46358 .12361 L
.46474 .12361 L
.46583 .12361 L
.46703 .12361 L
.46832 .12361 L
.469 .12361 L
.46964 .12361 L
.47034 .12361 L
Mistroke
.47109 .12361 L
.4718 .12361 L
.47247 .12361 L
.47372 .12361 L
.47496 .12361 L
.4761 .12361 L
.47735 .12361 L
.47867 .12361 L
.47982 .12361 L
.48087 .12361 L
.48209 .12361 L
.48323 .12361 L
.4843 .12361 L
.48528 .12361 L
.48635 .12361 L
.48749 .12361 L
.48864 .12361 L
.48987 .12361 L
.49093 .12361 L
.4921 .12361 L
.49339 .12361 L
.49409 .12361 L
.49475 .12361 L
.49592 .12361 L
.49717 .12361 L
.49841 .12361 L
.49911 .12361 L
.49977 .12361 L
.50045 .12361 L
.5011 .12361 L
.50184 .12361 L
.50252 .12361 L
.50374 .12361 L
.50487 .12361 L
.50612 .12361 L
.50744 .12361 L
.50875 .12361 L
.50949 .12361 L
.51016 .12361 L
.51141 .12361 L
.51272 .12361 L
.51342 .12361 L
.51416 .12361 L
.51487 .12361 L
.51551 .12361 L
.51626 .12361 L
.51708 .12361 L
.51785 .12361 L
.51856 .12361 L
.51972 .12361 L
Mistroke
.52096 .12361 L
.52214 .12361 L
.52322 .12361 L
.52448 .12361 L
.52519 .12361 L
.52585 .12361 L
.52706 .12361 L
.52835 .12361 L
.52905 .12361 L
.52969 .12361 L
.53115 .12361 L
.53241 .12361 L
.53312 .12361 L
.53379 .12361 L
.53495 .12361 L
.53619 .12361 L
.53687 .12361 L
.53751 .12361 L
.53872 .12361 L
.53986 .12361 L
.54109 .12361 L
.54225 .12361 L
.54332 .12361 L
.5445 .12361 L
.54579 .12361 L
.54644 .12361 L
.54713 .12361 L
.54838 .12361 L
.54903 .12361 L
.54971 .12361 L
.55046 .12361 L
.55115 .12361 L
.55239 .12361 L
.5531 .12361 L
.55376 .12361 L
.55499 .12361 L
.55612 .12361 L
.55741 .12361 L
.55865 .12361 L
.55981 .12361 L
.56086 .12361 L
.56208 .12361 L
.56322 .12361 L
.56429 .12361 L
.56526 .12361 L
.56633 .12361 L
.56746 .12361 L
.56861 .12361 L
.56984 .12361 L
.57099 .12361 L
Mistroke
.57205 .12361 L
.57329 .12361 L
.57398 .12361 L
.57463 .12361 L
.57581 .12361 L
.57707 .12361 L
.57827 .12361 L
.57959 .12361 L
.58083 .12361 L
.58198 .12361 L
.58648 .12361 L
.5966 .12361 L
.61489 .12361 L
.65401 .12361 L
.69558 .12361 L
.73563 .12361 L
.77417 .12361 L
.81516 .12361 L
.85464 .12361 L
.8926 .12361 L
.93301 .12361 L
.97191 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.5) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Koooo1@00083oool009goool00`000?ooooooo`20oooo002Moooo00<0003ooooo
ool00oooo`<0001joooo002Eoooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0N_oo
o`00WOooo`030000oooooooo00?oool00`000?ooooooo`1joooo002Loooo0P0000Goool00`000?oo
ooooo`1joooo002Soooo00<0003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool2
0000Noooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0
003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002S
oooo00<0003oooooool0N_ooo`00Xoooo`80001koooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool00:?oool20000Noooo`00:oooo`<0000Xoooo0`0002?oool4
00008oooo`030000oooooooo02?oool400009oooo`<0000Yoooo000[oooo00@0003oooooool0000X
oooo00<0003oooooool08_ooo`030000oooooooo02Coool00`000?ooooooo`0Soooo00<0003ooooo
ool0:Oooo`030000oooooooo02Soool002_oool010000?ooooooo`0002Goool500009?ooo`030000
oooooooo02?oool00`000?ooooooo`0Toooo00<0003oooooool09Oooo`D0000Yoooo000Uoooo1000
00;oool300008?ooo`@00002oooo00@0003oooooool0000Noooo100000Coool00`000?ooooooo`0R
oooo00<0003oooooool09Oooo`030000oooooooo02Coool010000?ooooooo`0002[oool002coool0
0`000?ooooooo`0Voooo00<0003oool000009?ooo`040000oooooooo00008oooo`030000oooooooo
02?oool010000?ooooooo`0002Koool00`000?ooo`00000Zoooo000/oooo0`0002Ooool200009Ooo
o`80000Toooo0P0002Goool20000:?ooo`80000Zoooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool0013ooooo00004Oooo`005_ooo`03000006Ko06Ko00L0I_l0
0`00001Vo`1Vo`0706Ko00<00000I_l0I_l01P1Vo`03oooo0000oooo00Soool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooo0000010000000c?o000003?o0008<ol000<0000co`0co`001c?o00030000
<ol0<ol000Lco`000`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool05Oooo`00:_ooo`030000oooooooo00Koool906Ko5oooo`030000oooooooo02Goool00`000?oo
ooooo`06oooo00@00000I_l00000000K<ol000<0003oooooool09Oooo`030000oooooooo02Koool0
0`000?ooooooo`0Yoooo000loooo1@1VodCoool00`1Vooooooooo`0400005c?o00030000oooooooo
07[oool0047oool406Ko@?ooo`0306Kooooooooo00Coool00`0003?o03?o000D<ol000<0003ooooo
ool0N_ooo`00AOooo`80I_lnoooo00<0I_ooooooool01Oooo`80000D<ol000<0003oooooool0N_oo
o`00Aoooo`<0I_lkoooo00<0I_ooooooool01oooo`030000<ol0<ol0014co`000`000?ooooooo`1j
oooo001:oooo0P1VocWoool00`1Vooooooooo`08oooo00<0000co`0co`0043?o0080001koooo001<
oooo0P1VocOoool00`1Vooooooooo`09oooo0P00010co`000`000?ooooooo`1joooo001>oooo0P1V
ocGoool00`1Vooooooooo`0;oooo00<0000co`0co`003C?o00030000oooooooo07[oool0053oool2
06Ko<oooo`0306Kooooooooo00_oool00`0003?o03?o000=<ol000<0003oooooool0N_ooo`00D_oo
o`0306Kooooooooo033oool00`1Vooooooooo`0<oooo00<0000co`0co`0033?o00030000oooooooo
07[oool005?oool00`1Vooooooooo`0_oooo00<0I_ooooooool03?ooo`030000<ol0<ol000`co`00
0`000?ooooooo`1joooo001Doooo0P1Vobooool00`1Vooooooooo`0=oooo00<0000co`0co`002c?o
0080001koooo001Foooo00<0I_ooooooool0;?ooo`0306Kooooooooo00goool00`0003?o03?o000;
<ol000<0003oooooool0N_ooo`00Eoooo`0306Kooooooooo02_oool00`1Vooooooooo`0>oooo00<0
000co`0co`002S?o00030000oooooooo07[oool005Soool00`1Vooooooooo`0Zoooo00<0I_oooooo
ool03_ooo`030000<ol0<ol000Xco`000`000?ooooooo`1joooo001Ioooo00<0I_ooooooool0:Ooo
o`0306Kooooooooo00ooool00`0003?o03?o0009<ol000<0003oooooool0N_ooo`00F_ooo`0306Ko
oooooooo02Soool00`1Vooooooooo`0?oooo00<0000co`0co`002C?o00030000oooooooo07[oool0
05[oool00`1Vooooooooo`0Toooo1@1Voa;oool00`0003?o03?o0008<ol00P0007_oool005_oool0
0`1Vooooooooo`0Ooooo101Vo`Coool00ol0VOooooooo`0@oooo00<0000co`0co`0023?o00030000
oooooooo07[oool005_oool00`1Vooooooooo`0Eoooo2P1Vo`Soool00ol0VOooooooo`0@oooo00<0
000co`0co`0023?o00030000oooooooo07[oool005cooolG06Ko4_ooo`03o`2Ioooooooo017oool0
0`0003?o03?o0007<ol000<0003oooooool0N_ooo`00QOooo`03o`2Ioooooooo017oool00`0003?o
03?o0007<ol000<0003oooooool0N_ooo`00QOooo`03o`2Ioooooooo017oool00`0003?o03?o0007
<ol000<0003oooooool0N_ooo`00QOooo`03o`2Ioooooooo017oool00`0003?o03?o0007<ol00P00
07_oool008Goool00ol0VOooooooo`0Boooo00<0000co`0co`001S?o00030000oooooooo07[oool0
08Goool00ol0VOooooooo`0Boooo00<0000co`0co`001S?o00030000oooooooo07[oool008Goool0
0ol0VOooooooo`0Boooo00<0000co`0co`001S?o00030000oooooooo07[oool008Goool00ol0VOoo
ooooo`0Boooo00<0000co`0co`001S?o00030000oooooooo07[oool008Goool00ol0VOooooooo`0C
oooo1@0000<co`000`000?ooooooo`1joooo0025oooo00?o09Woooooool04oooo`030000<ol00000
00Dco`000`000?ooooooo`1joooo0025oooo00?o09Woooooool04oooo`030000<ol0000000Dco`03
0000N_ooo`00QOooo`03o`2Ioooooooo01Coool200001C?o00030000oooooooo07[oool008Goool0
0ol0VOooooooo`0Doooo0P0000Dco`000`000?ooooooo`1joooo0025oooo00?o09Woooooool05?oo
o`800005<ol000<0003oooooool0N_ooo`00QOooo`03o`2Ioooooooo01Coool00`0003?o03?o0004
<ol000<0003oooooool0N_ooo`00QOooo`03o`2Ioooooooo01Coool00`0003?o03?o0004<ol000<0
003oooooool0N_ooo`00QOooo`03o`2Ioooooooo01Coool00`0003?o03?o0004<ol00P0007_oool0
08Goool00ol0VOooooooo`0Eoooo00<0000co`0co`000c?o00030000oooooooo07[oool008Goool0
0ol0VOooooooo`0Eoooo00<0000co`0co`000c?o00030000oooooooo07[oool008Goool00ol0VOoo
ooooo`0Eoooo00<0000co`0co`000c?o00030000oooooooo07[oool008Goool00ol0VOooooooo`0E
oooo00<0000co`0co`000c?o00030000oooooooo07[oool008Goool00ol0VOooooooo`0Eoooo00<0
000co`0co`000c?o00030000oooooooo07[oool008Goool00ol0VOooooooo`0Eoooo00<0000co`0c
o`000c?o0080001koooo0025oooo00?o09Woooooool05Oooo`030000<ol0<ol000<co`000`000?oo
ooooo`1joooo0025oooo00?o09Woooooool05Oooo`030000<ol0<ol000<co`000`000?ooooooo`1j
oooo0025oooo00?o09Woooooool05_ooo`030000<ol0<ol0008co`000`000?ooooooo`1joooo0025
oooo00?o09Woooooool05_ooo`030000<ol0<ol0008co`000`000?ooooooo`1joooo0025oooo00?o
09Woooooool05_ooo`030000<ol0<ol0008co`000`000?ooooooo`1joooo0025oooo00?o09Wooooo
ool05_ooo`030000<ol0<ol0008co`000`000?ooooooo`1joooo0025oooo00?o09Woooooool05_oo
o`030000<ol0<ol0008co`020000Noooo`00QOooo`03o`2Ioooooooo01Koool00`0003?o03?o0002
<ol000<0003oooooool0N_ooo`00QOooo`03o`2Ioooooooo01Koool00`0003?o03?o0002<ol000<0
003oooooool0N_ooo`00QOooo`03o`2Ioooooooo01Koool00`0003?o03?o0002<ol000<0003ooooo
ool0N_ooo`00QOooo`03o`2Ioooooooo01Koool00`0003?o03?o0002<ol000<0003oooooool0N_oo
o`00QOooo`03o`2Ioooooooo01Koool00`0003?o03?o0002<ol000<0003oooooool0N_ooo`00QOoo
o`03o`2Ioooooooo01Koool00`0003?o03?o0002<ol00P0007_oool008Goool00ol0VOooooooo`0G
oooo00D0000co`0co`0co`000000O?ooo`00QOooo`03o`2Ioooooooo01Ooool01@0003?o03?o03?o
0000001loooo0025oooo00?o09Woooooool05oooo`050000<ol0<ol0<ol0000007coool008Goool0
0ol0VOooooooo`0Coooo1@0000<co`000`000?ooooooo`1joooo0025oooo00?o09Woooooool04ooo
o`050000oooooooooooo000000<co`000`000?ooooooo`1joooo0025oooo00?o09Woooooool05?oo
o`040000oooooooo00000c?o00<0001joooo0025oooo00?o09Woooooool05Oooo`030000oooo0000
00<co`000`000?ooooooo`1joooo0025oooo00?o09Woooooool04oooo`030000oooooooo00800003
<ol000<0003oooooool0N_ooo`00QOooo`03o`2Ioooooooo01Coool2000000?oool0000co`000S?o
00030000oooooooo07[oool008Goool00ol0VOooooooo`0Goooo00D0000co`0co`0co`000000O?oo
o`00QOooo`03o`2Ioooooooo01Soool0100003?o03?o000007coool008Goool00ol0VOooooooo`0H
oooo00<0000co`0co`000P0007_oool008Goool00ol0VOooooooo`0Hoooo00@0000co`0co`00001l
oooo0025oooo00?o09Woooooool06?ooo`040000<ol0<ol00000O?ooo`00QOooo`03o`2Ioooooooo
01Soool0100003?o03?o000007coool008Goool00ol0VOooooooo`0Hoooo00@0000co`0co`00001l
oooo0025oooo00?o09Woooooool06?ooo`040000<ol0<ol00000O?ooo`00QOooo`03o`2Ioooooooo
01Soool0100003?o03?o000007coool008Goool00ol0VOooooooo`0Ioooo00@0000co`000000001k
oooo0025oooo00?o09Woooooool06Oooo`030000<ol0000007coool008Goool00ol0VOooooooo`0I
oooo00<0000co`000000O?ooo`00QOooo`03o`2Ioooooooo01Woool00`0003?o0000001loooo0025
oooo00?o09Woooooool06Oooo`030000<ol0000007coool008Goool00ol0VOooooooo`0Ioooo00<0
000co`000000O?ooo`00QOooo`03o`2Ioooooooo01Woool0100003?o0000000007_oool008Goool0
0ol0VOooooooo`0Ioooo00<0000co`000000O?ooo`00QOooo`03o`2Ioooooooo01Woool00`0003?o
0000001loooo0025oooo00?o09Woooooool06Oooo`030000<ol0000007coool008Goool00ol0VOoo
ooooo`0Ioooo00<0000co`000000O?ooo`00QOooo`03o`2Ioooooooo01Woool00`0003?o0000001l
oooo0025oooo00?o09Woooooool06Oooo`040000<ol000000000Noooo`00QOooo`03o`2Ioooooooo
01Woool00`0003?o0000001loooo0025oooo00?o09Woooooool06Oooo`030000<ol0000007coool0
08Goool00ol0VOooooooo`0Ioooo00<0000co`000000O?ooo`00QOooo`03o`2Ioooooooo01Coool2
00000oooo`030000<ol0000007coool008Goool00ol0VOooooooo`0Coooo00@0003oooooool00002
oooo00<0000co`000000O?ooo`00QOooo`03o`2Ioooooooo01Goool01P000?ooooooooooo`0003?o
00<0001joooo0025oooo00?o09Woooooool05_ooo`060000oooooooo0000<ol00000O?ooo`00QOoo
o`03o`2Ioooooooo01?oool010000?ooooooo`0000;oool00`0003?o0000001loooo0025oooo00?o
09Woooooool05?ooo`800004oooo0P0007coool008Goool00ol0VOooooooo`0Joooo0P0007coool0
08Goool00ol0VOooooooo`0Joooo0P0007coool008Goool00ol0VOooooooo`0Joooo0P0007coool0
08Goool00ol0VOooooooo`0Joooo0`0007_oool008Goool00ol0VOooooooo`0Joooo0P0007coool0
08Goool00ol0VOooooooo`0Joooo0P0007coool008Goool00ol0VOooooooo`0Joooo0P0007coool0
08Goool00ol0VOooooooo`0Joooo0P0007coool008Goool00ol0VOooooooo`0Joooo0P0007coool0
08Goool00ol0VOooooooo`0Joooo0`0007_oool008Goool00ol0VOooooooo`0Joooo0P0007coool0
08Goool00ol0VOooooooo`0Joooo0P0007coool008Goool00ol0VOooooooo`0Joooo0P0007coool0
08Goool00ol0VOooooooo`0Joooo0P0007coool008Goool00ol0VOooooooo`0Joooo0P0007coool0
08Goool00ol0VOooooooo`0Joooo0`0007_oool008Goool00ol0VOooooooo`0Koooo00<0003ooooo
ool0N_ooo`00QOooo`03o`2Ioooooooo01_oool00`000?ooooooo`1joooo0025oooo00?o09Wooooo
ool06oooo`030000oooooooo07[oool008Goool00ol0VOooooooo`0Koooo00<0003oooooool0N_oo
o`00QOooo`03o`2Ioooooooo01_oool00`000?ooooooo`1joooo0025oooo00?o09Woooooool06ooo
o`80001koooo0025oooo00?o09Woooooool06oooo`030000oooooooo07[oool008Goool00ol0VOoo
ooooo`0Koooo00<0003oooooool0N_ooo`00QOooo`03o`2Ioooooooo01_oool00`000?ooooooo`1j
oooo0025oooo00?o09Woooooool06oooo`030000oooooooo07[oool008Goool00ol0VOooooooo`0E
oooo0`0000?oool00`000?ooooooo`1joooo0025oooo00?o09Woooooool05_ooo`030000oooooooo
00;oool00`000?ooooooo`1joooo0025oooo00?o09Woooooool04oooo`D00003oooo0`0007[oool0
09_oool010000?ooooooo`00087oool009coool00`000?ooo`000021oooo002Moooo0P00087oool0
0?oooolQoooo003ooooo8Oooo`00NOooo`030000oooooooo02Soool00`000?ooooooo`1ioooo001h
oooo00<0003oooooool02?ooo`030000oooooooo01ooool00`000?ooooooo`1hoooo001hoooo00<0
003oooooool00_ooo`800004oooo00<0003oooooool03?ooo`@00003oooo0P0000Coool200001?oo
o`030000oooooooo07Soool007Soool01@000?ooooooooooo`000002oooo00<0003oooooool00_oo
o`030000oooooooo00Coool400000oooo`030000oooooooo00Woool010000?ooooooo`0000?oool0
0`000?ooooooo`1hoooo001goooo00<0003oooooool00_ooo`030000oooooooo01Coool00`000?oo
ooooo`0;oooo00<0003oooooool00_ooo`030000oooooooo07Ooool007Soool00`000?ooooooo`05
00005?ooo`030000oooooooo00Soool200001?ooo`030000oooooooo07Soool007Soool01@000?oo
ooooooooo`00000Eoooo00@0003oooooool00009oooo00<0003oooooool00oooo`030000oooooooo
07Soool007Woool00`000?ooooooo`0Goooo0P0000[oool300000_ooo`030000oooooooo07Woool0
0?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-8.12947, \
-1.14361, 0.0496935, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-8.12947, -1.14361, 0.0496935, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
.2 1 0 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.44268 .12361 L
.45262 .12361 L
.46172 .12361 L
.46388 .12361 L
.46618 .12361 L
.46687 .12361 L
.46751 .12361 L
s
.46751 .12361 m
.46799 .61803 L
s
0 .4 1 r
.02381 .12414 m
.04262 .12435 L
.06244 .12466 L
.07286 .12488 L
.08255 .12512 L
.09388 .12546 L
.10458 .12585 L
.125 .12683 L
.14357 .1281 L
.16355 .13002 L
.18199 .13251 L
.20071 .13604 L
.21136 .13864 L
.22134 .14156 L
.24158 .14936 L
.26011 .15943 L
.27909 .17386 L
.28984 .18446 L
.29982 .1963 L
.30489 .20318 L
.30756 .20706 L
.30827 .20812 L
.30902 .20926 L
.30974 .21002 L
.31039 .21001 L
.31286 .20997 L
.31557 .20992 L
.32034 .20982 L
.33895 .20935 L
.35803 .20868 L
.36882 .20819 L
.37879 .20765 L
.39746 .20634 L
.41806 .20429 L
.43741 .20157 L
.44737 .19978 L
.45263 .1987 L
.45826 .19743 L
.46106 .19676 L
.4637 .19609 L
.46607 .19546 L
.46672 .19529 L
.46741 .1951 L
.46864 .12361 L
.46979 .12361 L
.47102 .12361 L
.47218 .12361 L
.47324 .12361 L
.47449 .12361 L
.47519 .12361 L
Mistroke
.47584 .12361 L
.47703 .12361 L
.4783 .12361 L
.479 .12361 L
.47973 .12361 L
.48105 .12361 L
.48178 .12361 L
.48246 .12361 L
.48321 .12361 L
.48401 .12361 L
.4847 .12361 L
.48545 .12361 L
.48616 .12361 L
.48682 .12361 L
.48806 .12361 L
.48938 .12361 L
.49056 .12361 L
.49184 .12361 L
.49304 .12361 L
.49415 .12361 L
.49537 .12361 L
.49606 .12361 L
.49671 .12361 L
.49801 .12361 L
.49874 .12361 L
.4994 .12361 L
.5006 .12361 L
.50172 .12361 L
.50295 .12361 L
.50427 .12361 L
.50493 .12361 L
.50565 .12361 L
.50696 .12361 L
.50823 .12361 L
.50941 .12361 L
.5105 .12361 L
.51153 .12361 L
.51266 .12361 L
.51388 .12361 L
.51508 .12361 L
.51635 .12361 L
.51744 .12361 L
.51863 .12361 L
.5193 .12361 L
.52003 .12361 L
.52072 .12361 L
.52135 .12361 L
.52256 .12361 L
.52383 .12361 L
.52449 .12361 L
Mistroke
.5252 .12361 L
.52648 .12361 L
.52727 .12361 L
.52801 .12361 L
.52868 .12361 L
.5294 .12361 L
.53072 .12361 L
.53192 .12361 L
.53259 .12361 L
.53331 .12361 L
.53461 .12361 L
.53583 .12361 L
.53712 .12361 L
.53823 .12361 L
.53944 .12361 L
.54074 .12361 L
.54195 .12361 L
.54325 .12361 L
.54399 .12361 L
.54468 .12361 L
.54584 .12361 L
.54709 .12361 L
.54774 .12361 L
.54843 .12361 L
.54965 .12361 L
.55077 .12361 L
.55196 .12361 L
.55308 .12361 L
.5541 .12361 L
.5553 .12361 L
.5566 .12361 L
.55774 .12361 L
.55896 .12361 L
.56026 .12361 L
.56148 .12361 L
.56222 .12361 L
.56293 .12361 L
.56425 .12361 L
.56492 .12361 L
.56564 .12361 L
.56693 .12361 L
.56772 .12361 L
.56846 .12361 L
.56913 .12361 L
.56985 .12361 L
.57106 .12361 L
.57175 .12361 L
.57239 .12361 L
.57369 .12361 L
.57442 .12361 L
Mistroke
.57508 .12361 L
.57626 .12361 L
.57755 .12361 L
.57876 .12361 L
.57988 .12361 L
.58113 .12361 L
.58231 .12361 L
.58454 .12361 L
.58954 .12361 L
.5986 .12361 L
.61922 .12361 L
.6574 .12361 L
.69803 .12361 L
.73715 .12361 L
.77872 .12361 L
.81877 .12361 L
.85731 .12361 L
.8983 .12361 L
.93778 .12361 L
.97574 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.4) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Koooo1@00083oool009goool00`000?ooooooo`20oooo002Moooo00<0003ooooo
ool00oooo`<0001joooo002Eoooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0N_oo
o`00WOooo`030000oooooooo00?oool00`000?ooooooo`1joooo002Loooo0P0000Goool00`000?oo
ooooo`1joooo002Soooo00<0003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool2
0000Noooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0
003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002S
oooo00<0003oooooool0N_ooo`00Xoooo`80001koooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool00:?oool20000Noooo`00:oooo`<0000Xoooo0`0002?oool4
00008oooo`030000oooooooo02?oool400009oooo`<0000Yoooo000[oooo00@0003oooooool0000X
oooo00<0003oooooool08_ooo`030000oooooooo02Coool00`000?ooooooo`0Soooo00<0003ooooo
ool0:Oooo`030000oooooooo02Soool002_oool010000?ooooooo`0002Goool500009?ooo`030000
oooooooo02?oool00`000?ooooooo`0Toooo00<0003oooooool09Oooo`D0000Yoooo000Uoooo1000
00;oool300008?ooo`@00002oooo00@0003oooooool0000Noooo100000Coool00`000?ooooooo`0R
oooo00<0003oooooool09Oooo`030000oooooooo02Coool010000?ooooooo`0002[oool002coool0
0`000?ooooooo`0Voooo00<0003oool000009?ooo`040000oooooooo00008oooo`030000oooooooo
02?oool010000?ooooooo`0002Koool00`000?ooo`00000Zoooo000/oooo0`0002Ooool200009Ooo
o`80000Toooo0P0002Goool20000:?ooo`80000Zoooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool0013ooooo00004Oooo`005_ooo`03000006Ko06Ko00L0I_l0
0`00001Vo`1Vo`0706Ko00<00000I_l0I_l01P1Vo`03oooo0000oooo00Soool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooo00000100000013?o000003?o001Vo`Lco`000`0003?o03?o0007<ol000<0
000co`0co`001c?o00030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01ooo
o`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo
00Soool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?oo
ooooo`0Eoooo000Zoooo00<0003oooooool01_ooo`T0I_lGoooo00<0003oooooool09Oooo`030000
oooooooo00Koool3000000<0I_lco`0co`006C?o00030000oooooooo02Goool00`000?ooooooo`0V
oooo00<0003oooooool0:Oooo`00??ooo`D0I_m6oooo00<0I_l0000000000P0001Lco`000`000?oo
ooooo`1joooo0011oooo1P1Vod3oool00`1Vooooooooo`02oooo00<0000co`0co`0053?o00030000
oooooooo07[oool004Ooool306Ko?Oooo`0306Kooooooooo00?oool2000053?o00030000oooooooo
07[oool004[oool206Ko>oooo`0306Kooooooooo00Goool00`0003?o03?o000A<ol000<0003ooooo
ool0N_ooo`00C?ooo`<0I_lhoooo00<0I_ooooooool01_ooo`030000<ol0<ol0010co`020000Nooo
o`00Coooo`80I_lfoooo00<0I_ooooooool01oooo`80000@<ol000<0003oooooool0N_ooo`00DOoo
o`80I_ldoooo00<0I_ooooooool02Oooo`030000<ol0<ol000dco`000`000?ooooooo`1joooo001C
oooo00<0I_ooooooool0<Oooo`0306Kooooooooo00Woool00`0003?o03?o000=<ol000<0003ooooo
ool0N_ooo`00E?ooo`80I_laoooo00<0I_ooooooool02_ooo`030000<ol0<ol000`co`000`000?oo
ooooo`1joooo001Foooo00<0I_ooooooool0;_ooo`0306Kooooooooo00[oool00`0003?o03?o000<
<ol000<0003oooooool0N_ooo`00Eoooo`0306Kooooooooo02goool00`1Vooooooooo`0;oooo00<0
000co`0co`002c?o0080001koooo001Hoooo00<0I_ooooooool0;?ooo`0306Kooooooooo00_oool0
0`0003?o03?o000;<ol000<0003oooooool0N_ooo`00FOooo`0306Kooooooooo02_oool00`1Voooo
ooooo`0<oooo00<0000co`0co`002S?o00030000oooooooo07[oool005[oool00`1Vooooooooo`0Z
oooo00<0I_ooooooool03?ooo`030000<ol0<ol000Xco`000`000?ooooooo`1joooo001Koooo00<0
I_ooooooool0:Oooo`0306Kooooooooo00goool00`0003?o03?o0009<ol000<0003oooooool0N_oo
o`00Foooo`0306Kooooooooo02Woool00`1Vooooooooo`0=oooo00<0000co`0co`002C?o00030000
oooooooo07[oool005coool00`1Vooooooooo`0Toooo1@1Voa3oool00`0003?o03?o0008<ol00P00
07_oool005coool00`1Vooooooooo`0Noooo1P1Vo`Coool00ol0VOooooooo`0>oooo00<0000co`0c
o`0023?o00030000oooooooo07[oool005goool00`1Vooooooooo`0Coooo2P1Vo`[oool00ol0VOoo
ooooo`0>oooo00<0000co`0co`0023?o00030000oooooooo07[oool005kooolE06Ko5?ooo`03o`2I
oooooooo00ooool00`0003?o03?o0007<ol000<0003oooooool0N_ooo`00Qoooo`03o`2Ioooooooo
00ooool00`0003?o03?o0007<ol000<0003oooooool0N_ooo`00Qoooo`03o`2Ioooooooo00ooool0
0`0003?o03?o0007<ol000<0003oooooool0N_ooo`00Qoooo`03o`2Ioooooooo00ooool00`0003?o
03?o0007<ol00P0007_oool008Ooool00ol0VOooooooo`0@oooo00<0000co`0co`001S?o00030000
oooooooo07[oool008Ooool00ol0VOooooooo`0@oooo00<0000co`0co`001S?o00030000oooooooo
07[oool008Ooool00ol0VOooooooo`0@oooo00<0000co`0co`001S?o00030000oooooooo07[oool0
08Ooool00ol0VOooooooo`0@oooo00<0000co`0co`001S?o00030000oooooooo07[oool008Ooool0
0ol0VOooooooo`0Aoooo1@0000<co`000`000?ooooooo`1joooo0027oooo00?o09Woooooool04Ooo
o`030000<ol0000000Dco`000`000?ooooooo`1joooo0027oooo00?o09Woooooool04Oooo`030000
<ol0000000Dco`030000N_ooo`00Qoooo`03o`2Ioooooooo01;oool200001C?o00030000oooooooo
07[oool008Ooool00ol0VOooooooo`0Boooo0P0000Dco`000`000?ooooooo`1joooo0027oooo00?o
09Woooooool04_ooo`800005<ol000<0003oooooool0N_ooo`00Qoooo`03o`2Ioooooooo01;oool0
0`0003?o03?o0004<ol000<0003oooooool0N_ooo`00Qoooo`03o`2Ioooooooo01;oool00`0003?o
03?o0004<ol000<0003oooooool0N_ooo`00Qoooo`03o`2Ioooooooo01;oool00`0003?o03?o0004
<ol00P0007_oool008Ooool00ol0VOooooooo`0Coooo00<0000co`0co`000c?o00030000oooooooo
07[oool008Ooool00ol0VOooooooo`0Coooo00<0000co`0co`000c?o00030000oooooooo07[oool0
08Ooool00ol0VOooooooo`0Coooo00<0000co`0co`000c?o00030000oooooooo07[oool008Ooool0
0ol0VOooooooo`0Coooo00<0000co`0co`000c?o00030000oooooooo07[oool008Ooool00ol0VOoo
ooooo`0Coooo00<0000co`0co`000c?o00030000oooooooo07[oool008Ooool00ol0VOooooooo`0C
oooo00<0000co`0co`000c?o0080001koooo0027oooo00?o09Woooooool04oooo`030000<ol0<ol0
00<co`000`000?ooooooo`1joooo0027oooo00?o09Woooooool04oooo`030000<ol0<ol000<co`00
0`000?ooooooo`1joooo0027oooo00?o09Woooooool05?ooo`030000<ol0<ol0008co`000`000?oo
ooooo`1joooo0027oooo00?o09Woooooool05?ooo`030000<ol0<ol0008co`000`000?ooooooo`1j
oooo0027oooo00?o09Woooooool05?ooo`030000<ol0<ol0008co`000`000?ooooooo`1joooo0027
oooo00?o09Woooooool05?ooo`030000<ol0<ol0008co`000`000?ooooooo`1joooo0027oooo00?o
09Woooooool05?ooo`030000<ol0<ol0008co`020000Noooo`00Qoooo`03o`2Ioooooooo01Coool0
0`0003?o03?o0002<ol000<0003oooooool0N_ooo`00Qoooo`03o`2Ioooooooo01Coool00`0003?o
03?o0002<ol000<0003oooooool0N_ooo`00Qoooo`03o`2Ioooooooo01Coool00`0003?o03?o0002
<ol000<0003oooooool0N_ooo`00Qoooo`03o`2Ioooooooo01Coool00`0003?o03?o0002<ol000<0
003oooooool0N_ooo`00Qoooo`03o`2Ioooooooo01Coool00`0003?o03?o0002<ol000<0003ooooo
ool0N_ooo`00Qoooo`03o`2Ioooooooo01Coool00`0003?o03?o0002<ol00P0007_oool008Ooool0
0ol0VOooooooo`0Eoooo00D0000co`0co`0co`000000O?ooo`00Qoooo`03o`2Ioooooooo01Goool0
1@0003?o03?o03?o0000001loooo0027oooo00?o09Woooooool05Oooo`050000<ol0<ol0<ol00000
07coool008Ooool00ol0VOooooooo`0Aoooo1@0000<co`000`000?ooooooo`1joooo0027oooo00?o
09Woooooool04Oooo`050000oooooooooooo000000<co`000`000?ooooooo`1joooo0027oooo00?o
09Woooooool04_ooo`040000oooooooo00000c?o00<0001joooo0027oooo00?o09Woooooool04ooo
o`030000oooo000000<co`000`000?ooooooo`1joooo0027oooo00?o09Woooooool04Oooo`030000
oooooooo00800003<ol000<0003oooooool0N_ooo`00Qoooo`03o`2Ioooooooo01;oool2000000?o
ool0000co`000S?o00030000oooooooo07[oool008Ooool00ol0VOooooooo`0Eoooo00D0000co`0c
o`0co`000000O?ooo`00Qoooo`03o`2Ioooooooo01Koool0100003?o03?o000007coool008Ooool0
0ol0VOooooooo`0Foooo00<0000co`0co`000P0007_oool008Ooool00ol0VOooooooo`0Foooo00@0
000co`0co`00001loooo0027oooo00?o09Woooooool05_ooo`040000<ol0<ol00000O?ooo`00Qooo
o`03o`2Ioooooooo01Koool0100003?o03?o000007coool008Ooool00ol0VOooooooo`0Foooo00@0
000co`0co`00001loooo0027oooo00?o09Woooooool05_ooo`040000<ol0<ol00000O?ooo`00Qooo
o`03o`2Ioooooooo01Koool0100003?o03?o000007coool008Ooool00ol0VOooooooo`0Goooo00@0
000co`000000001koooo0027oooo00?o09Woooooool05oooo`030000<ol0000007coool008Ooool0
0ol0VOooooooo`0Goooo00<0000co`000000O?ooo`00Qoooo`03o`2Ioooooooo01Ooool00`0003?o
0000001loooo0027oooo00?o09Woooooool05oooo`030000<ol0000007coool008Ooool00ol0VOoo
ooooo`0Goooo00<0000co`000000O?ooo`00Qoooo`03o`2Ioooooooo01Ooool0100003?o00000000
07_oool008Ooool00ol0VOooooooo`0Goooo00<0000co`000000O?ooo`00Qoooo`03o`2Ioooooooo
01Ooool00`0003?o0000001loooo0027oooo00?o09Woooooool05oooo`030000<ol0000007coool0
08Ooool00ol0VOooooooo`0Goooo00<0000co`000000O?ooo`00Qoooo`03o`2Ioooooooo01Ooool0
0`0003?o0000001loooo0027oooo00?o09Woooooool05oooo`040000<ol000000000Noooo`00Qooo
o`03o`2Ioooooooo01Ooool00`0003?o0000001loooo0027oooo00?o09Woooooool05oooo`030000
<ol0000007coool008Ooool00ol0VOooooooo`0Goooo00<0000co`000000O?ooo`00Qoooo`03o`2I
oooooooo01;oool200000oooo`030000<ol0000007coool008Ooool00ol0VOooooooo`0Aoooo00@0
003oooooool00002oooo00<0000co`000000O?ooo`00Qoooo`03o`2Ioooooooo01?oool01P000?oo
ooooooooo`0003?o00<0001joooo0027oooo00?o09Woooooool05?ooo`060000oooooooo0000<ol0
0000O?ooo`00Qoooo`03o`2Ioooooooo017oool010000?ooooooo`0000;oool00`0003?o0000001l
oooo0027oooo00?o09Woooooool04_ooo`800004oooo0P0007coool008Ooool00ol0VOooooooo`0H
oooo0P0007coool008Ooool00ol0VOooooooo`0Hoooo0P0007coool008Ooool00ol0VOooooooo`0H
oooo0P0007coool008Ooool00ol0VOooooooo`0Hoooo0`0007_oool008Ooool00ol0VOooooooo`0H
oooo0P0007coool008Ooool00ol0VOooooooo`0Hoooo0P0007coool008Ooool00ol0VOooooooo`0H
oooo0P0007coool008Ooool00ol0VOooooooo`0Hoooo0P0007coool008Ooool00ol0VOooooooo`0H
oooo0P0007coool008Ooool00ol0VOooooooo`0Hoooo0`0007_oool008Ooool00ol0VOooooooo`0H
oooo0P0007coool008Ooool00ol0VOooooooo`0Hoooo0P0007coool008Ooool00ol0VOooooooo`0H
oooo0P0007coool008Ooool00ol0VOooooooo`0Hoooo0P0007coool008Ooool00ol0VOooooooo`0H
oooo0P0007coool008Ooool00ol0VOooooooo`0Hoooo0`0007_oool008Ooool00ol0VOooooooo`0I
oooo00<0003oooooool0N_ooo`00Qoooo`03o`2Ioooooooo01Woool00`000?ooooooo`1joooo0027
oooo00?o09Woooooool06Oooo`030000oooooooo07[oool008Ooool00ol0VOooooooo`0Ioooo00<0
003oooooool0N_ooo`00Qoooo`03o`2Ioooooooo01Woool00`000?ooooooo`1joooo0027oooo00?o
09Woooooool06Oooo`80001koooo0027oooo00?o09Woooooool06Oooo`030000oooooooo07[oool0
08Ooool00ol0VOooooooo`0Ioooo00<0003oooooool0N_ooo`00Qoooo`03o`2Ioooooooo01Woool0
0`000?ooooooo`1joooo0027oooo00?o09Woooooool06Oooo`030000oooooooo07[oool008Ooool0
0ol0VOooooooo`0Coooo0`0000?oool00`000?ooooooo`1joooo0027oooo00?o09Woooooool05?oo
o`030000oooooooo00;oool00`000?ooooooo`1joooo0027oooo00?o09Woooooool04Oooo`D00003
oooo0`0007[oool009_oool010000?ooooooo`00087oool009coool00`000?ooo`000021oooo002M
oooo0P00087oool00?oooolQoooo003ooooo8Oooo`00NOooo`030000oooooooo02Soool00`000?oo
ooooo`1ioooo001hoooo00<0003oooooool02?ooo`030000oooooooo01ooool00`000?ooooooo`1h
oooo001hoooo00<0003oooooool00_ooo`800004oooo00<0003oooooool03?ooo`@00003oooo0P00
00Goool300000_ooo`030000oooooooo07Soool007Soool01@000?ooooooooooo`000002oooo00<0
003oooooool00_ooo`030000oooooooo00Coool400000oooo`030000oooooooo00coool01@000?oo
ooooooooo`00001joooo001goooo00<0003oooooool00_ooo`030000oooooooo01Coool00`000?oo
ooooo`08oooo1@0000?oool00`000?ooooooo`1goooo001hoooo00<0003oooooool01@0001Coool0
0`000?ooooooo`07oooo00@0003oooooool00003oooo00<0003oooooool0N?ooo`00N?ooo`050000
oooooooooooo000001Goool010000?ooooooo`0000Woool00`000?ooo`000003oooo00<0003ooooo
ool0N?ooo`00NOooo`030000oooooooo01Ooool200002oooo`800002oooo00<0003oooooool0NOoo
o`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-8.12947, \
-1.14361, 0.0496935, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-8.12947, -1.14361, 0.0496935, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
.2 1 0 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.44268 .12361 L
.45262 .12361 L
.46172 .12361 L
.46618 .12361 L
.47106 .12361 L
.47329 .12361 L
.47451 .12361 L
.47567 .12361 L
s
.47567 .12361 m
.4761 .61803 L
s
0 .4 1 r
.02381 .12407 m
.04262 .12425 L
.06244 .12453 L
.07286 .12471 L
.08255 .12492 L
.09388 .12521 L
.10458 .12555 L
.125 .12641 L
.14357 .1275 L
.16355 .12917 L
.18199 .13133 L
.20071 .1344 L
.21136 .13665 L
.22134 .13919 L
.24158 .14596 L
.26011 .1547 L
.27909 .16721 L
.28984 .17642 L
.29982 .18669 L
.31039 .19976 L
.31291 .20326 L
.31557 .20713 L
.31667 .20878 L
.31784 .20999 L
.31914 .20996 L
.32034 .20994 L
.32928 .20976 L
.33895 .20952 L
.34912 .20923 L
.36019 .20884 L
.38031 .20792 L
.40008 .20663 L
.41007 .20578 L
.42109 .20467 L
.44044 .20211 L
.4504 .20043 L
.46129 .19823 L
.46631 .19707 L
.46907 .19639 L
.47168 .19572 L
.4741 .19507 L
.47477 .19489 L
.47547 .19469 L
.47674 .12361 L
.47787 .12361 L
.47893 .12361 L
.48009 .12361 L
.48133 .12361 L
.48201 .12361 L
.48274 .12361 L
Mistroke
.48404 .12361 L
.48484 .12361 L
.48559 .12361 L
.48626 .12361 L
.48699 .12361 L
.48764 .12361 L
.48835 .12361 L
.4891 .12361 L
.48979 .12361 L
.49103 .12361 L
.49173 .12361 L
.49236 .12361 L
.49356 .12361 L
.49484 .12361 L
.49551 .12361 L
.49624 .12361 L
.49754 .12361 L
.49875 .12361 L
.50006 .12361 L
.5013 .12361 L
.50243 .12361 L
.50372 .12361 L
.50493 .12361 L
.50601 .12361 L
.50719 .12361 L
.50847 .12361 L
.50912 .12361 L
.50983 .12361 L
.51109 .12361 L
.51226 .12361 L
.51345 .12361 L
.51457 .12361 L
.51557 .12361 L
.51667 .12361 L
.51786 .12361 L
.51912 .12361 L
.5202 .12361 L
.5214 .12361 L
.5227 .12361 L
.52336 .12361 L
.52407 .12361 L
.52535 .12361 L
.52653 .12361 L
.52725 .12361 L
.52794 .12361 L
.52921 .12361 L
.52993 .12361 L
.53059 .12361 L
.53131 .12361 L
.53208 .12361 L
Mistroke
.53326 .12361 L
.53454 .12361 L
.53575 .12361 L
.53685 .12361 L
.53814 .12361 L
.53882 .12361 L
.53955 .12361 L
.54025 .12361 L
.54088 .12361 L
.54211 .12361 L
.54331 .12361 L
.54444 .12361 L
.54567 .12361 L
.54699 .12361 L
.54765 .12361 L
.54838 .12361 L
.54969 .12361 L
.55096 .12361 L
.55214 .12361 L
.55324 .12361 L
.55427 .12361 L
.5554 .12361 L
.55662 .12361 L
.55783 .12361 L
.5591 .12361 L
.56018 .12361 L
.56137 .12361 L
.56205 .12361 L
.56278 .12361 L
.56347 .12361 L
.56411 .12361 L
.56531 .12361 L
.56659 .12361 L
.56725 .12361 L
.56796 .12361 L
.56924 .12361 L
.57003 .12361 L
.57077 .12361 L
.57144 .12361 L
.57216 .12361 L
.57285 .12361 L
.57349 .12361 L
.57469 .12361 L
.57598 .12361 L
.5767 .12361 L
.57737 .12361 L
.57849 .12361 L
.57972 .12361 L
.581 .12361 L
.5822 .12361 L
Mistroke
.62118 .12361 L
.66261 .12361 L
.70253 .12361 L
.74093 .12361 L
.78178 .12361 L
.82112 .12361 L
.85895 .12361 L
.89922 .12361 L
.93798 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.3) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Koooo1@00083oool009goool00`000?ooooooo`20oooo002Moooo00<0003ooooo
ool00oooo`<0001joooo002Eoooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0N_oo
o`00WOooo`030000oooooooo00?oool00`000?ooooooo`1joooo002Loooo0P0000Goool00`000?oo
ooooo`1joooo002Soooo00<0003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool2
0000Noooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0
003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002S
oooo00<0003oooooool0N_ooo`00Xoooo`80001koooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool00:?oool20000Noooo`00:oooo`<0000Xoooo0`0002?oool4
00008oooo`030000oooooooo02?oool400009oooo`<0000Yoooo000[oooo00@0003oooooool0000X
oooo00<0003oooooool08_ooo`030000oooooooo02Coool00`000?ooooooo`0Soooo00<0003ooooo
ool0:Oooo`030000oooooooo02Soool002_oool010000?ooooooo`0002Goool500009?ooo`030000
oooooooo02?oool00`000?ooooooo`0Toooo00<0003oooooool09Oooo`D0000Yoooo000Uoooo1000
00;oool300008?ooo`@00002oooo00@0003oooooool0000Noooo100000Coool00`000?ooooooo`0R
oooo00<0003oooooool09Oooo`030000oooooooo02Coool010000?ooooooo`0002[oool002coool0
0`000?ooooooo`0Voooo00<0003oool000009?ooo`040000oooooooo00008oooo`030000oooooooo
02?oool010000?ooooooo`0002Koool00`000?ooo`00000Zoooo000/oooo0`0002Ooool200009Ooo
o`80000Toooo0P0002Goool20000:?ooo`80000Zoooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool0013ooooo00004Oooo`005_ooo`03000006Ko06Ko00L0I_l0
0`00001Vo`1Vo`0706Ko00<00000I_l0I_l01`1Vo`04000006Ko06Ko06Ko1_ooo`030000oooooooo
00Soool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?oo
ooooo`07oooo00<0003oool0000040000003<ol00000<ol0008co`000`1Voc?o03?o0003<ol000<0
000co`0co`001c?o00030000<ol0<ol000Lco`000`000?ooooooo`07oooo00<0003oooooool01ooo
o`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo
00Ooool00`000?ooooooo`08oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?oo
ooooo`07oooo00<0003oooooool05Oooo`00:_ooo`030000oooooooo00_oool906Ko4_ooo`030000
oooooooo02Goool00`000?ooooooo`06oooo10000003<ol006Ko<ol001Pco`000`000?ooooooo`0U
oooo00<0003oooooool09_ooo`030000oooooooo02Woool0047oool406Ko@oooo`04000006Ko0000
00005c?o00030000oooooooo07[oool004Goool506Ko?oooo`0406Kooooooooo00005S?o00030000
oooooooo07[oool004[oool206Ko?Oooo`0406Kooooooooooooo0P0001@co`000`000?ooooooo`1j
oooo001<oooo0`1Voc[oool00`1Vooooooooo`03oooo00<0000co`0co`004C?o00030000oooooooo
07[oool004ooool206Ko>?ooo`0306Kooooooooo00Coool00`0003?o03?o000@<ol00P0007_oool0
057oool206Ko=_ooo`0306Kooooooooo00Goool2000043?o00030000oooooooo07[oool005?oool2
06Ko=?ooo`0306Kooooooooo00Ooool00`0003?o03?o000=<ol000<0003oooooool0N_ooo`00EOoo
o`80I_lboooo00<0I_ooooooool01oooo`030000<ol0<ol000dco`000`000?ooooooo`1joooo001G
oooo00<0I_ooooooool0;oooo`0306Kooooooooo00Soool00`0003?o03?o000<<ol000<0003ooooo
ool0N_ooo`00F?ooo`0306Kooooooooo02koool00`1Vooooooooo`08oooo00<0000co`0co`0033?o
00030000oooooooo07[oool005Woool00`1Vooooooooo`0]oooo00<0I_ooooooool02Oooo`030000
<ol0<ol000/co`020000Noooo`00F_ooo`0306Kooooooooo02coool00`1Vooooooooo`09oooo00<0
000co`0co`002c?o00030000oooooooo07[oool005_oool00`1Vooooooooo`0[oooo00<0I_oooooo
ool02_ooo`030000<ol0<ol000Xco`000`000?ooooooo`1joooo001Loooo00<0I_ooooooool0:_oo
o`0306Kooooooooo00[oool00`0003?o03?o000:<ol000<0003oooooool0N_ooo`00GOooo`0306Ko
oooooooo02Woool00`1Vooooooooo`0;oooo00<0000co`0co`002C?o00030000oooooooo07[oool0
05goool00`1Vooooooooo`0Yoooo00<0I_ooooooool02oooo`030000<ol0<ol000Tco`000`000?oo
ooooo`1joooo001Noooo00<0I_ooooooool08oooo`D0I_l00ol0VOooooooo`0<oooo00<0000co`0c
o`0023?o0080001koooo001Ooooo00<0I_ooooooool07?ooo`H0I_l5oooo00?o09Woooooool03?oo
o`030000<ol0<ol000Pco`000`000?ooooooo`1joooo001Poooo00<0I_ooooooool04Oooo`X0I_l;
oooo00?o09Woooooool03?ooo`030000<ol0<ol000Pco`000`000?ooooooo`1joooo001Poooo501V
oaGoool00ol0VOooooooo`0=oooo00<0000co`0co`001c?o00030000oooooooo07[oool008Woool0
0ol0VOooooooo`0=oooo00<0000co`0co`001c?o00030000oooooooo07[oool008Woool00ol0VOoo
ooooo`0=oooo00<0000co`0co`001c?o00030000oooooooo07[oool008Woool00ol0VOooooooo`0=
oooo00<0000co`0co`001c?o0080001koooo0029oooo00?o09Woooooool03_ooo`030000<ol0<ol0
00Hco`000`000?ooooooo`1joooo0029oooo00?o09Woooooool03_ooo`030000<ol0<ol000Hco`00
0`000?ooooooo`1joooo0029oooo00?o09Woooooool03_ooo`030000<ol0<ol000Hco`000`000?oo
ooooo`1joooo0029oooo00?o09Woooooool03_ooo`030000<ol0<ol000Hco`000`000?ooooooo`1j
oooo0029oooo00?o09Woooooool03oooo`D00003<ol000<0003oooooool0N_ooo`00ROooo`03o`2I
oooooooo00ooool00`0003?o00000005<ol000<0003oooooool0N_ooo`00ROooo`03o`2Ioooooooo
00ooool00`0003?o00000005<ol00`0007[oool008Woool00ol0VOooooooo`0@oooo0P0000Dco`00
0`000?ooooooo`1joooo0029oooo00?o09Woooooool04?ooo`800005<ol000<0003oooooool0N_oo
o`00ROooo`03o`2Ioooooooo013oool200001C?o00030000oooooooo07[oool008Woool00ol0VOoo
ooooo`0@oooo00<0000co`0co`0013?o00030000oooooooo07[oool008Woool00ol0VOooooooo`0@
oooo00<0000co`0co`0013?o00030000oooooooo07[oool008Woool00ol0VOooooooo`0@oooo00<0
000co`0co`0013?o0080001koooo0029oooo00?o09Woooooool04Oooo`030000<ol0<ol000<co`00
0`000?ooooooo`1joooo0029oooo00?o09Woooooool04Oooo`030000<ol0<ol000<co`000`000?oo
ooooo`1joooo0029oooo00?o09Woooooool04Oooo`030000<ol0<ol000<co`000`000?ooooooo`1j
oooo0029oooo00?o09Woooooool04Oooo`030000<ol0<ol000<co`000`000?ooooooo`1joooo0029
oooo00?o09Woooooool04Oooo`030000<ol0<ol000<co`000`000?ooooooo`1joooo0029oooo00?o
09Woooooool04Oooo`030000<ol0<ol000<co`020000Noooo`00ROooo`03o`2Ioooooooo017oool0
0`0003?o03?o0003<ol000<0003oooooool0N_ooo`00ROooo`03o`2Ioooooooo017oool00`0003?o
03?o0003<ol000<0003oooooool0N_ooo`00ROooo`03o`2Ioooooooo01;oool00`0003?o03?o0002
<ol000<0003oooooool0N_ooo`00ROooo`03o`2Ioooooooo01;oool00`0003?o03?o0002<ol000<0
003oooooool0N_ooo`00ROooo`03o`2Ioooooooo01;oool00`0003?o03?o0002<ol000<0003ooooo
ool0N_ooo`00ROooo`03o`2Ioooooooo01;oool00`0003?o03?o0002<ol000<0003oooooool0N_oo
o`00ROooo`03o`2Ioooooooo01;oool00`0003?o03?o0002<ol00P0007_oool008Woool00ol0VOoo
ooooo`0Boooo00<0000co`0co`000S?o00030000oooooooo07[oool008Woool00ol0VOooooooo`0B
oooo00<0000co`0co`000S?o00030000oooooooo07[oool008Woool00ol0VOooooooo`0Boooo00<0
000co`0co`000S?o00030000oooooooo07[oool008Woool00ol0VOooooooo`0Boooo00<0000co`0c
o`000S?o00030000oooooooo07[oool008Woool00ol0VOooooooo`0Boooo00<0000co`0co`000S?o
00030000oooooooo07[oool008Woool00ol0VOooooooo`0Boooo00<0000co`0co`000S?o0080001k
oooo0029oooo00?o09Woooooool04oooo`050000<ol0<ol0<ol0000007coool008Woool00ol0VOoo
ooooo`0Coooo00D0000co`0co`0co`000000O?ooo`00ROooo`03o`2Ioooooooo01?oool01@0003?o
03?o03?o0000001loooo0029oooo00?o09Woooooool03oooo`D00003<ol000<0003oooooool0N_oo
o`00ROooo`03o`2Ioooooooo00ooool01@000?ooooooooooo`000003<ol000<0003oooooool0N_oo
o`00ROooo`03o`2Ioooooooo013oool010000?ooooooo`0000<co`030000N_ooo`00ROooo`03o`2I
oooooooo017oool00`000?ooo`000003<ol000<0003oooooool0N_ooo`00ROooo`03o`2Ioooooooo
00ooool00`000?ooooooo`0200000c?o00030000oooooooo07[oool008Woool00ol0VOooooooo`0@
oooo0P000003oooo0000<ol0008co`000`000?ooooooo`1joooo0029oooo00?o09Woooooool04ooo
o`050000<ol0<ol0<ol0000007coool008Woool00ol0VOooooooo`0Doooo00@0000co`0co`00001l
oooo0029oooo00?o09Woooooool05?ooo`030000<ol0<ol00080001koooo0029oooo00?o09Wooooo
ool05?ooo`040000<ol0<ol00000O?ooo`00ROooo`03o`2Ioooooooo01Coool0100003?o03?o0000
07coool008Woool00ol0VOooooooo`0Doooo00@0000co`0co`00001loooo0029oooo00?o09Wooooo
ool05?ooo`040000<ol0<ol00000O?ooo`00ROooo`03o`2Ioooooooo01Coool0100003?o03?o0000
07coool008Woool00ol0VOooooooo`0Doooo00@0000co`0co`00001loooo0029oooo00?o09Wooooo
ool05Oooo`040000<ol000000000Noooo`00ROooo`03o`2Ioooooooo01Goool00`0003?o0000001l
oooo0029oooo00?o09Woooooool05Oooo`030000<ol0000007coool008Woool00ol0VOooooooo`0E
oooo00<0000co`000000O?ooo`00ROooo`03o`2Ioooooooo01Goool00`0003?o0000001loooo0029
oooo00?o09Woooooool05Oooo`030000<ol0000007coool008Woool00ol0VOooooooo`0Eoooo00@0
000co`000000001koooo0029oooo00?o09Woooooool05Oooo`030000<ol0000007coool008Woool0
0ol0VOooooooo`0Eoooo00<0000co`000000O?ooo`00ROooo`03o`2Ioooooooo01Goool00`0003?o
0000001loooo0029oooo00?o09Woooooool05Oooo`030000<ol0000007coool008Woool00ol0VOoo
ooooo`0Eoooo00<0000co`000000O?ooo`00ROooo`03o`2Ioooooooo01Goool0100003?o00000000
07_oool008Woool00ol0VOooooooo`0Eoooo00<0000co`000000O?ooo`00ROooo`03o`2Ioooooooo
01Goool00`0003?o0000001loooo0029oooo00?o09Woooooool05Oooo`030000<ol0000007coool0
08Woool00ol0VOooooooo`0@oooo0P0000?oool00`0003?o0000001loooo0029oooo00?o09Wooooo
ool03oooo`040000oooooooo00000_ooo`030000<ol0000007coool008Woool00ol0VOooooooo`0A
oooo00H0003oooooooooool0000co`030000N_ooo`00ROooo`03o`2Ioooooooo01;oool01P000?oo
ooooo`0003?o000007coool008Woool00ol0VOooooooo`0?oooo00@0003oooooool00002oooo00<0
000co`000000O?ooo`00ROooo`03o`2Ioooooooo013oool200001?ooo`80001loooo0029oooo00?o
09Woooooool05_ooo`80001loooo0029oooo00?o09Woooooool05_ooo`80001loooo0029oooo00?o
09Woooooool05_ooo`80001loooo0029oooo00?o09Woooooool05_ooo`<0001koooo0029oooo00?o
09Woooooool05_ooo`80001loooo0029oooo00?o09Woooooool05_ooo`80001loooo0029oooo00?o
09Woooooool05_ooo`80001loooo0029oooo00?o09Woooooool05_ooo`80001loooo0029oooo00?o
09Woooooool05_ooo`80001loooo0029oooo00?o09Woooooool05_ooo`<0001koooo0029oooo00?o
09Woooooool05_ooo`80001loooo0029oooo00?o09Woooooool05_ooo`80001loooo0029oooo00?o
09Woooooool05_ooo`80001loooo0029oooo00?o09Woooooool05_ooo`80001loooo0029oooo00?o
09Woooooool05_ooo`80001loooo0029oooo00?o09Woooooool05_ooo`<0001koooo0029oooo00?o
09Woooooool05oooo`030000oooooooo07[oool008Woool00ol0VOooooooo`0Goooo00<0003ooooo
ool0N_ooo`00ROooo`03o`2Ioooooooo01Ooool00`000?ooooooo`1joooo0029oooo00?o09Wooooo
ool05oooo`030000oooooooo07[oool008Woool00ol0VOooooooo`0Goooo00<0003oooooool0N_oo
o`00ROooo`03o`2Ioooooooo01Ooool20000Noooo`00ROooo`03o`2Ioooooooo01Ooool00`000?oo
ooooo`1joooo0029oooo00?o09Woooooool05oooo`030000oooooooo07[oool008Woool00ol0VOoo
ooooo`0Goooo00<0003oooooool0N_ooo`00ROooo`03o`2Ioooooooo01Ooool00`000?ooooooo`1j
oooo0029oooo00?o09Woooooool04Oooo`<00003oooo00<0003oooooool0N_ooo`00ROooo`03o`2I
oooooooo01;oool00`000?ooooooo`02oooo00<0003oooooool0N_ooo`00ROooo`03o`2Ioooooooo
00ooool500000oooo`<0001joooo002Koooo00@0003oooooool00021oooo002Loooo00<0003oool0
0000POooo`00WOooo`800021oooo003ooooo8Oooo`00ooooob7oool007Woool00`000?ooooooo`0X
oooo00<0003oooooool0NOooo`00N?ooo`030000oooooooo00Soool00`000?ooooooo`0Ooooo00<0
003oooooool0N?ooo`00N?ooo`030000oooooooo00;oool200001?ooo`030000oooooooo00coool4
00000oooo`800004oooo0P0000Coool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool0
00000_ooo`030000oooooooo00;oool00`000?ooooooo`04oooo100000?oool00`000?ooooooo`09
oooo00@0003oooooool00003oooo00<0003oooooool0N?ooo`00Moooo`030000oooooooo00;oool0
0`000?ooooooo`0Doooo00<0003oooooool02_ooo`030000oooooooo00?oool00`000?ooooooo`1g
oooo001hoooo00<0003oooooool01@0001Coool00`000?ooooooo`0:oooo00D0003oooooooooool0
0000N_ooo`00N?ooo`050000oooooooooooo000001Goool010000?ooooooo`0000Soool010000?oo
ooooo`0000?oool00`000?ooooooo`1hoooo001ioooo00<0003oooooool05oooo`80000:oooo0P00
00?oool00`000?ooooooo`1ioooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-8.12947, \
-1.14361, 0.0496935, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-8.12947, -1.14361, 0.0496935, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
.2 1 0 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.44268 .12361 L
.46172 .12361 L
.47106 .12361 L
.47567 .12361 L
.47994 .12361 L
.48231 .12361 L
.483 .12361 L
.48364 .12361 L
s
.48364 .12361 m
.48412 .61803 L
s
0 .4 1 r
.02381 .12401 m
.04262 .12417 L
.06244 .1244 L
.07286 .12457 L
.08255 .12475 L
.09388 .125 L
.10458 .12529 L
.125 .12604 L
.14357 .12699 L
.16355 .12843 L
.18199 .13031 L
.20071 .13297 L
.21136 .13492 L
.22134 .13713 L
.24158 .143 L
.26011 .15058 L
.27909 .16144 L
.28984 .16943 L
.29982 .17835 L
.31861 .20012 L
.32128 .20384 L
.32376 .20748 L
.32502 .20937 L
.32572 .20995 L
.32636 .20994 L
.3292 .20988 L
.33895 .20967 L
.34994 .20938 L
.36036 .20905 L
.38053 .2082 L
.40044 .20702 L
.41886 .2055 L
.43752 .20338 L
.45813 .2001 L
.46755 .19818 L
.47747 .19581 L
.47999 .19515 L
.48137 .19477 L
.48267 .1944 L
.48341 .19419 L
.48421 .12361 L
.48494 .12361 L
.48561 .12361 L
.48625 .12361 L
.48694 .12361 L
.48767 .12361 L
.48835 .12361 L
.48964 .12361 L
.49087 .12361 L
.49196 .12361 L
Mistroke
.49316 .12361 L
.49446 .12361 L
.49519 .12361 L
.49584 .12361 L
.49712 .12361 L
.49833 .12361 L
.4995 .12361 L
.50075 .12361 L
.50193 .12361 L
.503 .12361 L
.50426 .12361 L
.50497 .12361 L
.50563 .12361 L
.50684 .12361 L
.50812 .12361 L
.50934 .12361 L
.51065 .12361 L
.5119 .12361 L
.51303 .12361 L
.51429 .12361 L
.51501 .12361 L
.51567 .12361 L
.51638 .12361 L
.51701 .12361 L
.51775 .12361 L
.51845 .12361 L
.51952 .12361 L
.52069 .12361 L
.52192 .12361 L
.52307 .12361 L
.52414 .12361 L
.52512 .12361 L
.52625 .12361 L
.52732 .12361 L
.52848 .12361 L
.52971 .12361 L
.53076 .12361 L
.53192 .12361 L
.53317 .12361 L
.53386 .12361 L
.53451 .12361 L
.53569 .12361 L
.53693 .12361 L
.53816 .12361 L
.53886 .12361 L
.5395 .12361 L
.54068 .12361 L
.54192 .12361 L
.54304 .12361 L
.54408 .12361 L
Mistroke
.54523 .12361 L
.54646 .12361 L
.54777 .12361 L
.5485 .12361 L
.54919 .12361 L
.55045 .12361 L
.55115 .12361 L
.55178 .12361 L
.55299 .12361 L
.55429 .12361 L
.55552 .12361 L
.55665 .12361 L
.55771 .12361 L
.55885 .12361 L
.55993 .12361 L
.56091 .12361 L
.56206 .12361 L
.56331 .12361 L
.56449 .12361 L
.56558 .12361 L
.5667 .12361 L
.56775 .12361 L
.56891 .12361 L
.57015 .12361 L
.57139 .12361 L
.57269 .12361 L
.5738 .12361 L
.57501 .12361 L
.57633 .12361 L
.57755 .12361 L
.57818 .12361 L
.57889 .12361 L
.57962 .12361 L
.5803 .12361 L
.58529 .12361 L
.59463 .12361 L
.61559 .12361 L
.65443 .12361 L
.69573 .12361 L
.73551 .12361 L
.77378 .12361 L
.81449 .12361 L
.85369 .12361 L
.89535 .12361 L
.93549 .12361 L
.97411 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.2) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Koooo1@00083oool009goool00`000?ooooooo`20oooo002Moooo00<0003ooooo
ool00oooo`<0001joooo002Eoooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0N_oo
o`00WOooo`030000oooooooo00?oool00`000?ooooooo`1joooo002Loooo0P0000Goool00`000?oo
ooooo`1joooo002Soooo00<0003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool2
0000Noooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0
003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002S
oooo00<0003oooooool0N_ooo`00Xoooo`80001koooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool00:?oool20000Noooo`00:oooo`<0000Xoooo0`0002?oool4
00008oooo`030000oooooooo02?oool400009oooo`<0000Yoooo000[oooo00@0003oooooool0000X
oooo00<0003oooooool08_ooo`030000oooooooo02Coool00`000?ooooooo`0Soooo00<0003ooooo
ool0:Oooo`030000oooooooo02Soool002_oool010000?ooooooo`0002Goool500009?ooo`030000
oooooooo02?oool00`000?ooooooo`0Toooo00<0003oooooool09Oooo`D0000Yoooo000Uoooo1000
00;oool300008?ooo`@00002oooo00@0003oooooool0000Noooo100000Coool00`000?ooooooo`0R
oooo00<0003oooooool09Oooo`030000oooooooo02Coool010000?ooooooo`0002[oool002coool0
0`000?ooooooo`0Voooo00<0003oool000009?ooo`040000oooooooo00008oooo`030000oooooooo
02?oool010000?ooooooo`0002Koool00`000?ooo`00000Zoooo000/oooo0`0002Ooool200009Ooo
o`80000Toooo0P0002Goool20000:?ooo`80000Zoooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool0013ooooo00004Oooo`005_ooo`03000006Ko06Ko00L0I_l0
0`00001Vo`1Vo`0706Ko00<00000I_l0I_l01`1Vo`04000006Ko06Ko06Ko1_ooo`030000oooooooo
00Soool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?oo
ooooo`07oooo00<0003oool0000040000003<ol00000<ol000@co`001@1Voc?o03?o03?o00000009
<ol000<0000co`0co`001c?o00030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Soool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`0Eoooo000Zoooo00<0003oooooool02oooo`T0I_lBoooo00<0003oooooool09Ooo
o`030000oooooooo00Koool400000c?o000306Ko<ol0<ol001Dco`000`000?ooooooo`0Uoooo00<0
003oooooool09_ooo`030000oooooooo02Woool0047oool606Ko@Oooo`<000000`1Voc?o03?o000E
<ol000<0003oooooool0N_ooo`00Aoooo`@0I_m0oooo00<0I_l0000co`005C?o00030000oooooooo
07[oool004_oool406Ko??ooo`0406Kooooo0000000053?o00030000oooooooo07[oool004ooool2
06Ko>_ooo`0506Kooooooooooooo000001<co`000`000?ooooooo`1joooo001Aoooo0P1VocSoool0
0`1Vooooooooo`02oooo00<0000co`0co`0043?o0080001koooo001Coooo0P1VocKoool00`1Voooo
ooooo`03oooo0P00010co`000`000?ooooooo`1joooo001Eoooo0P1VocCoool00`1Vooooooooo`05
oooo00<0000co`0co`003C?o00030000oooooooo07[oool005Ooool00`1Vooooooooo`0aoooo00<0
I_ooooooool01Oooo`030000<ol0<ol000dco`000`000?ooooooo`1joooo001Hoooo0P1Voc7oool0
0`1Vooooooooo`06oooo00<0000co`0co`0033?o00030000oooooooo07[oool005[oool00`1Voooo
ooooo`0^oooo00<0I_ooooooool01_ooo`030000<ol0<ol000`co`000`000?ooooooo`1joooo001K
oooo00<0I_ooooooool0;Oooo`0306Kooooooooo00Ooool00`0003?o03?o000;<ol00P0007_oool0
05coool00`1Vooooooooo`0/oooo00<0I_ooooooool01oooo`030000<ol0<ol000/co`000`000?oo
ooooo`1joooo001Moooo00<0I_ooooooool0:oooo`0306Kooooooooo00Soool00`0003?o03?o000:
<ol000<0003oooooool0N_ooo`00G_ooo`0306Kooooooooo02[oool00`1Vooooooooo`08oooo00<0
000co`0co`002S?o00030000oooooooo07[oool005koool00`1Vooooooooo`0Zoooo00<0I_oooooo
ool02Oooo`030000<ol0<ol000Tco`000`000?ooooooo`1joooo001Ooooo00<0I_ooooooool0:?oo
o`80I_l;oooo00<0000co`0co`002C?o00030000oooooooo07[oool0063oool00`1Vooooooooo`0S
oooo1@1Vo`03o`2Ioooooooo00[oool00`0003?o03?o0008<ol00P0007_oool0067oool00`1Voooo
ooooo`0Noooo101Vo`Goool00ol0VOooooooo`0:oooo00<0000co`0co`0023?o00030000oooooooo
07[oool006;oool00`1Vooooooooo`0Doooo2@1Vo`Woool00ol0VOooooooo`0:oooo00<0000co`0c
o`0023?o00030000oooooooo07[oool006;ooolG06Ko4_ooo`03o`2Ioooooooo00_oool00`0003?o
03?o0007<ol000<0003oooooool0N_ooo`00Roooo`03o`2Ioooooooo00_oool00`0003?o03?o0007
<ol000<0003oooooool0N_ooo`00Roooo`03o`2Ioooooooo00_oool00`0003?o03?o0007<ol000<0
003oooooool0N_ooo`00Roooo`03o`2Ioooooooo00_oool00`0003?o03?o0007<ol00P0007_oool0
08_oool00ol0VOooooooo`0<oooo00<0000co`0co`001S?o00030000oooooooo07[oool008_oool0
0ol0VOooooooo`0<oooo00<0000co`0co`001S?o00030000oooooooo07[oool008_oool00ol0VOoo
ooooo`0<oooo00<0000co`0co`001S?o00030000oooooooo07[oool008_oool00ol0VOooooooo`0<
oooo00<0000co`0co`001S?o00030000oooooooo07[oool008_oool00ol0VOooooooo`0=oooo1@00
00<co`000`000?ooooooo`1joooo002;oooo00?o09Woooooool03Oooo`030000<ol0000000Dco`00
0`000?ooooooo`1joooo002;oooo00?o09Woooooool03Oooo`030000<ol0000000Dco`030000N_oo
o`00Roooo`03o`2Ioooooooo00koool200001C?o00030000oooooooo07[oool008_oool00ol0VOoo
ooooo`0>oooo0P0000Dco`000`000?ooooooo`1joooo002;oooo00?o09Woooooool03_ooo`800005
<ol000<0003oooooool0N_ooo`00Roooo`03o`2Ioooooooo00koool00`0003?o03?o0004<ol000<0
003oooooool0N_ooo`00Roooo`03o`2Ioooooooo00koool00`0003?o03?o0004<ol000<0003ooooo
ool0N_ooo`00Roooo`03o`2Ioooooooo00koool00`0003?o03?o0004<ol00P0007_oool008_oool0
0ol0VOooooooo`0?oooo00<0000co`0co`000c?o00030000oooooooo07[oool008_oool00ol0VOoo
ooooo`0?oooo00<0000co`0co`000c?o00030000oooooooo07[oool008_oool00ol0VOooooooo`0?
oooo00<0000co`0co`000c?o00030000oooooooo07[oool008_oool00ol0VOooooooo`0?oooo00<0
000co`0co`000c?o00030000oooooooo07[oool008_oool00ol0VOooooooo`0?oooo00<0000co`0c
o`000c?o00030000oooooooo07[oool008_oool00ol0VOooooooo`0?oooo00<0000co`0co`000c?o
0080001koooo002;oooo00?o09Woooooool03oooo`030000<ol0<ol000<co`000`000?ooooooo`1j
oooo002;oooo00?o09Woooooool03oooo`030000<ol0<ol000<co`000`000?ooooooo`1joooo002;
oooo00?o09Woooooool04?ooo`030000<ol0<ol0008co`000`000?ooooooo`1joooo002;oooo00?o
09Woooooool04?ooo`030000<ol0<ol0008co`000`000?ooooooo`1joooo002;oooo00?o09Wooooo
ool04?ooo`030000<ol0<ol0008co`000`000?ooooooo`1joooo002;oooo00?o09Woooooool04?oo
o`030000<ol0<ol0008co`000`000?ooooooo`1joooo002;oooo00?o09Woooooool04?ooo`030000
<ol0<ol0008co`020000Noooo`00Roooo`03o`2Ioooooooo013oool00`0003?o03?o0002<ol000<0
003oooooool0N_ooo`00Roooo`03o`2Ioooooooo013oool00`0003?o03?o0002<ol000<0003ooooo
ool0N_ooo`00Roooo`03o`2Ioooooooo013oool00`0003?o03?o0002<ol000<0003oooooool0N_oo
o`00Roooo`03o`2Ioooooooo013oool00`0003?o03?o0002<ol000<0003oooooool0N_ooo`00Rooo
o`03o`2Ioooooooo013oool00`0003?o03?o0002<ol000<0003oooooool0N_ooo`00Roooo`03o`2I
oooooooo013oool00`0003?o03?o0002<ol00P0007_oool008_oool00ol0VOooooooo`0Aoooo00D0
000co`0co`0co`000000O?ooo`00Roooo`03o`2Ioooooooo017oool01@0003?o03?o03?o0000001l
oooo002;oooo00?o09Woooooool04Oooo`050000<ol0<ol0<ol0000007coool008_oool00ol0VOoo
ooooo`0=oooo1@0000<co`000`000?ooooooo`1joooo002;oooo00?o09Woooooool03Oooo`050000
oooooooooooo000000<co`000`000?ooooooo`1joooo002;oooo00?o09Woooooool03_ooo`040000
oooooooo00000c?o00<0001joooo002;oooo00?o09Woooooool03oooo`030000oooo000000<co`00
0`000?ooooooo`1joooo002;oooo00?o09Woooooool03Oooo`030000oooooooo00800003<ol000<0
003oooooool0N_ooo`00Roooo`03o`2Ioooooooo00koool2000000?oool0000co`000S?o00030000
oooooooo07[oool008_oool00ol0VOooooooo`0Aoooo00D0000co`0co`0co`000000O?ooo`00Rooo
o`03o`2Ioooooooo01;oool0100003?o03?o000007coool008_oool00ol0VOooooooo`0Boooo00<0
000co`0co`000P0007_oool008_oool00ol0VOooooooo`0Boooo00@0000co`0co`00001loooo002;
oooo00?o09Woooooool04_ooo`040000<ol0<ol00000O?ooo`00Roooo`03o`2Ioooooooo01;oool0
100003?o03?o000007coool008_oool00ol0VOooooooo`0Boooo00@0000co`0co`00001loooo002;
oooo00?o09Woooooool04_ooo`040000<ol0<ol00000O?ooo`00Roooo`03o`2Ioooooooo01;oool0
100003?o03?o000007coool008_oool00ol0VOooooooo`0Coooo00@0000co`000000001koooo002;
oooo00?o09Woooooool04oooo`030000<ol0000007coool008_oool00ol0VOooooooo`0Coooo00<0
000co`000000O?ooo`00Roooo`03o`2Ioooooooo01?oool00`0003?o0000001loooo002;oooo00?o
09Woooooool04oooo`030000<ol0000007coool008_oool00ol0VOooooooo`0Coooo00<0000co`00
0000O?ooo`00Roooo`03o`2Ioooooooo01?oool0100003?o0000000007_oool008_oool00ol0VOoo
ooooo`0Coooo00<0000co`000000O?ooo`00Roooo`03o`2Ioooooooo01?oool00`0003?o0000001l
oooo002;oooo00?o09Woooooool04oooo`030000<ol0000007coool008_oool00ol0VOooooooo`0C
oooo00<0000co`000000O?ooo`00Roooo`03o`2Ioooooooo01?oool00`0003?o0000001loooo002;
oooo00?o09Woooooool04oooo`040000<ol000000000Noooo`00Roooo`03o`2Ioooooooo01?oool0
0`0003?o0000001loooo002;oooo00?o09Woooooool04oooo`030000<ol0000007coool008_oool0
0ol0VOooooooo`0Coooo00<0000co`000000O?ooo`00Roooo`03o`2Ioooooooo00koool200000ooo
o`030000<ol0000007coool008_oool00ol0VOooooooo`0=oooo00@0003oooooool00002oooo00<0
000co`000000O?ooo`00Roooo`03o`2Ioooooooo00ooool01P000?ooooooooooo`0003?o00<0001j
oooo002;oooo00?o09Woooooool04?ooo`060000oooooooo0000<ol00000O?ooo`00Roooo`03o`2I
oooooooo00goool010000?ooooooo`0000;oool00`0003?o0000001loooo002;oooo00?o09Wooooo
ool03_ooo`800004oooo0P0007coool008_oool00ol0VOooooooo`0Doooo0P0007coool008_oool0
0ol0VOooooooo`0Doooo0P0007coool008_oool00ol0VOooooooo`0Doooo0P0007coool008_oool0
0ol0VOooooooo`0Doooo0`0007_oool008_oool00ol0VOooooooo`0Doooo0P0007coool008_oool0
0ol0VOooooooo`0Doooo0P0007coool008_oool00ol0VOooooooo`0Doooo0P0007coool008_oool0
0ol0VOooooooo`0Doooo0P0007coool008_oool00ol0VOooooooo`0Doooo0P0007coool008_oool0
0ol0VOooooooo`0Doooo0`0007_oool008_oool00ol0VOooooooo`0Doooo0P0007coool008_oool0
0ol0VOooooooo`0Doooo0P0007coool008_oool00ol0VOooooooo`0Doooo0P0007coool008_oool0
0ol0VOooooooo`0Doooo0P0007coool008_oool00ol0VOooooooo`0Doooo0P0007coool008_oool0
0ol0VOooooooo`0Doooo0`0007_oool008_oool00ol0VOooooooo`0Eoooo00<0003oooooool0N_oo
o`00Roooo`03o`2Ioooooooo01Goool00`000?ooooooo`1joooo002;oooo00?o09Woooooool05Ooo
o`030000oooooooo07[oool008_oool00ol0VOooooooo`0Eoooo00<0003oooooool0N_ooo`00Rooo
o`03o`2Ioooooooo01Goool00`000?ooooooo`1joooo002;oooo00?o09Woooooool05Oooo`80001k
oooo002;oooo00?o09Woooooool05Oooo`030000oooooooo07[oool008_oool00ol0VOooooooo`0E
oooo00<0003oooooool0N_ooo`00Roooo`03o`2Ioooooooo01Goool00`000?ooooooo`1joooo002;
oooo00?o09Woooooool05Oooo`030000oooooooo07[oool008_oool00ol0VOooooooo`0?oooo0`00
00?oool00`000?ooooooo`1joooo002;oooo00?o09Woooooool04?ooo`030000oooooooo00;oool0
0`000?ooooooo`1joooo002;oooo00?o09Woooooool03Oooo`D00003oooo0`0007[oool009_oool0
10000?ooooooo`00087oool009coool00`000?ooo`000021oooo002Moooo0P00087oool00?oooolQ
oooo003ooooo8Oooo`00NOooo`030000oooooooo02Soool00`000?ooooooo`1ioooo001hoooo00<0
003oooooool02?ooo`030000oooooooo01ooool00`000?ooooooo`1hoooo001hoooo00<0003ooooo
ool00_ooo`800004oooo00<0003oooooool03?ooo`@00003oooo0P0000?oool400000oooo`030000
oooooooo07Soool007Soool01@000?ooooooooooo`000002oooo00<0003oooooool00_ooo`030000
oooooooo00Coool400000oooo`030000oooooooo00Woool00`000?ooooooo`04oooo00<0003ooooo
ool0N?ooo`00Moooo`030000oooooooo00;oool00`000?ooooooo`0Doooo00<0003oooooool02Ooo
o`030000oooooooo00Coool00`000?ooooooo`1goooo001hoooo00<0003oooooool01@0001Coool0
0`000?ooooooo`09oooo00<0003oooooool00_ooo`030000oooooooo07Soool007Soool01@000?oo
ooooooooo`00000Eoooo00@0003oooooool00008oooo00@0003oooooool00003oooo00<0003ooooo
ool0N?ooo`00NOooo`030000oooooooo01Ooool200002_ooo`800003oooo00<0003oooooool0NOoo
o`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-8.12947, \
-1.14361, 0.0496935, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-8.12947, -1.14361, 0.0496935, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
.2 1 0 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.44268 .12361 L
.46172 .12361 L
.47994 .12361 L
.48519 .12361 L
.48778 .12361 L
.48904 .12361 L
.49018 .12361 L
.4913 .12361 L
s
.4913 .12361 m
.49172 .61803 L
s
0 .4 1 r
.02381 .12395 m
.04262 .12409 L
.06244 .1243 L
.07286 .12444 L
.08255 .1246 L
.09388 .12482 L
.10458 .12507 L
.125 .12571 L
.14357 .12654 L
.16355 .12779 L
.18199 .12942 L
.20071 .13173 L
.21136 .13343 L
.22134 .13534 L
.24158 .14043 L
.26011 .14701 L
.27909 .15643 L
.28984 .16336 L
.29982 .1711 L
.31861 .18999 L
.3285 .20278 L
.33091 .20624 L
.33223 .20822 L
.33348 .2099 L
.33419 .20988 L
.33496 .20987 L
.33631 .20984 L
.33895 .20978 L
.3501 .20951 L
.36036 .20921 L
.38053 .20845 L
.4003 .20738 L
.41029 .20668 L
.42131 .20576 L
.44066 .20366 L
.46152 .20047 L
.48156 .19619 L
.48643 .19492 L
.48911 .19418 L
.49042 .1938 L
.49163 .19345 L
.49233 .12361 L
.49307 .12361 L
.49381 .12361 L
.49462 .12361 L
.4953 .12361 L
.49603 .12361 L
.49734 .12361 L
.49802 .12361 L
.49877 .12361 L
Mistroke
.49947 .12361 L
.50012 .12361 L
.50135 .12361 L
.50266 .12361 L
.5039 .12361 L
.50461 .12361 L
.50527 .12361 L
.50597 .12361 L
.5066 .12361 L
.50734 .12361 L
.50803 .12361 L
.50926 .12361 L
.5104 .12361 L
.51164 .12361 L
.51227 .12361 L
.51297 .12361 L
.51367 .12361 L
.51441 .12361 L
.51504 .12361 L
.51574 .12361 L
.51648 .12361 L
.51728 .12361 L
.51803 .12361 L
.51872 .12361 L
.51941 .12361 L
.52005 .12361 L
.52075 .12361 L
.52149 .12361 L
.52274 .12361 L
.52345 .12361 L
.52411 .12361 L
.52536 .12361 L
.52602 .12361 L
.52672 .12361 L
.52801 .12361 L
.5292 .12361 L
.53034 .12361 L
.53141 .12361 L
.53258 .12361 L
.53384 .12361 L
.53511 .12361 L
.53583 .12361 L
.5365 .12361 L
.5372 .12361 L
.53785 .12361 L
.5386 .12361 L
.53929 .12361 L
.54052 .12361 L
.54117 .12361 L
.54186 .12361 L
Mistroke
.54312 .12361 L
.54429 .12361 L
.5455 .12361 L
.54681 .12361 L
.54797 .12361 L
.54921 .12361 L
.55043 .12361 L
.55157 .12361 L
.55371 .12361 L
.55504 .12361 L
.55628 .12361 L
.55757 .12361 L
.55825 .12361 L
.55899 .12361 L
.56029 .12361 L
.56153 .12361 L
.56263 .12361 L
.56384 .12361 L
.56489 .12361 L
.56606 .12361 L
.56727 .12361 L
.56841 .12361 L
.56947 .12361 L
.57044 .12361 L
.57151 .12361 L
.57263 .12361 L
.57377 .12361 L
.57499 .12361 L
.57604 .12361 L
.57718 .12361 L
.57787 .12361 L
.57852 .12361 L
.57978 .12361 L
.58093 .12361 L
.58214 .12361 L
.62005 .12361 L
.66041 .12361 L
.69926 .12361 L
.74055 .12361 L
.78033 .12361 L
.8186 .12361 L
.85932 .12361 L
.89852 .12361 L
.94017 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.1) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Koooo1@00083oool009goool00`000?ooooooo`20oooo002Moooo00<0003ooooo
ool00oooo`<0001joooo002Eoooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0N_oo
o`00WOooo`030000oooooooo00?oool00`000?ooooooo`1joooo002Loooo0P0000Goool00`000?oo
ooooo`1joooo002Soooo00<0003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool2
0000Noooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0
003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002S
oooo00<0003oooooool0N_ooo`00Xoooo`80001koooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool00:?oool20000Noooo`00:oooo`<0000Xoooo0`0002?oool4
00008oooo`030000oooooooo02?oool400009oooo`<0000Yoooo000[oooo00@0003oooooool0000X
oooo00<0003oooooool08_ooo`030000oooooooo02Coool00`000?ooooooo`0Soooo00<0003ooooo
ool0:Oooo`030000oooooooo02Soool002_oool010000?ooooooo`0002Goool500009?ooo`030000
oooooooo02?oool00`000?ooooooo`0Toooo00<0003oooooool09Oooo`D0000Yoooo000Uoooo1000
00;oool300008?ooo`@00002oooo00@0003oooooool0000Noooo100000Coool00`000?ooooooo`0R
oooo00<0003oooooool09Oooo`030000oooooooo02Coool010000?ooooooo`0002[oool002coool0
0`000?ooooooo`0Voooo00<0003oool000009?ooo`040000oooooooo00008oooo`030000oooooooo
02?oool010000?ooooooo`0002Koool00`000?ooo`00000Zoooo000/oooo0`0002Ooool200009Ooo
o`80000Toooo0P0002Goool20000:?ooo`80000Zoooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool0013ooooo00004Oooo`005_ooo`030000oooooooo00L0I_l0
0`00001Vo`1Vo`0706Ko00<00000I_l0I_l01`1Vo`03000006Ko06Ko00D0I_l2oooo00<0003ooooo
ool02?ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Ooool00`000?ooo`00000@000000<co`00000co`001S?o000306Ko<ol0000000Tco`00
0`0003?o03?o0007<ol000<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool02?ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo01Goool002[oool00`000?ooooooo`0?oooo2@1Vo`koool00`000?ooooooo`0Uoooo00<0
003oooooool01_ooo`@00005<ol000<0I_lco`0co`004c?o00030000oooooooo02Goool00`000?oo
ooooo`0Voooo00<0003oooooool0:Oooo`00AOooo`D0I_lnoooo10000003<ol006Ko<ol001@co`00
0`000?ooooooo`1joooo001:oooo0P1Vod3oool00`00001Voc?o000D<ol000<0003oooooool0N_oo
o`00C?ooo`@0I_lmoooo00<0I_l0000co`004c?o00030000oooooooo07[oool0053oool306Ko>_oo
o`0306Kooooo000001<co`000`000?ooooooo`1joooo001Coooo0P1VocSoool0101Vooooooooo`00
018co`020000Noooo`00EOooo`80I_lfoooo00@0I_ooooooooooool2000043?o00030000oooooooo
07[oool005Ooool206Ko=?ooo`0306Kooooooooo00?oool00`0003?o03?o000=<ol000<0003ooooo
ool0N_ooo`00FOooo`80I_lboooo00<0I_ooooooool00oooo`030000<ol0<ol000dco`000`000?oo
ooooo`1joooo001Koooo00<0I_ooooooool0;oooo`0306Kooooooooo00Coool00`0003?o03?o000<
<ol000<0003oooooool0N_ooo`00G?ooo`0306Kooooooooo02koool00`1Vooooooooo`04oooo00<0
000co`0co`0033?o00030000oooooooo07[oool005goool00`1Vooooooooo`0]oooo00<0I_oooooo
ool01Oooo`030000<ol0<ol000/co`020000Noooo`00G_ooo`0306Kooooooooo02coool00`1Voooo
ooooo`05oooo00<0000co`0co`002c?o00030000oooooooo07[oool005ooool00`1Vooooooooo`0[
oooo00<0I_ooooooool01_ooo`030000<ol0<ol000Xco`000`000?ooooooo`1joooo001Poooo00<0
I_ooooooool0:_ooo`0306Kooooooooo00Koool00`0003?o03?o000:<ol000<0003oooooool0N_oo
o`00HOooo`0306Kooooooooo02Woool00`1Vooooooooo`07oooo00<0000co`0co`002C?o00030000
oooooooo07[oool006;oool00`1Vooooooooo`0Woooo0P1Vo`Woool00`0003?o03?o0009<ol000<0
003oooooool0N_ooo`00H_ooo`0306Kooooooooo02?oool406Ko00?ooooo09Woool02Oooo`030000
<ol0<ol000Pco`020000Noooo`00Hoooo`0306Kooooooooo01goool506Ko1Oooo`03o`2Ioooooooo
00Soool00`0003?o03?o0008<ol000<0003oooooool0N_ooo`00I?ooo`0306Kooooooooo017oool;
06Ko2_ooo`03o`2Ioooooooo00Soool00`0003?o03?o0008<ol000<0003oooooool0N_ooo`00I?oo
oa@0I_lEoooo00?o09Woooooool02Oooo`030000<ol0<ol000Lco`000`000?ooooooo`1joooo002=
oooo00?o09Woooooool02Oooo`030000<ol0<ol000Lco`000`000?ooooooo`1joooo002=oooo00?o
09Woooooool02Oooo`030000<ol0<ol000Lco`000`000?ooooooo`1joooo002=oooo00?o09Wooooo
ool02Oooo`030000<ol0<ol000Lco`020000Noooo`00SOooo`03o`2Ioooooooo00[oool00`0003?o
03?o0006<ol000<0003oooooool0N_ooo`00SOooo`03o`2Ioooooooo00[oool00`0003?o03?o0006
<ol000<0003oooooool0N_ooo`00SOooo`03o`2Ioooooooo00[oool00`0003?o03?o0006<ol000<0
003oooooool0N_ooo`00SOooo`03o`2Ioooooooo00[oool00`0003?o03?o0006<ol000<0003ooooo
ool0N_ooo`00SOooo`03o`2Ioooooooo00_oool500000c?o00030000oooooooo07[oool008goool0
0ol0VOooooooo`0;oooo00<0000co`0000001C?o00030000oooooooo07[oool008goool00ol0VOoo
ooooo`0;oooo00<0000co`0000001C?o00<0001joooo002=oooo00?o09Woooooool03?ooo`800005
<ol000<0003oooooool0N_ooo`00SOooo`03o`2Ioooooooo00coool200001C?o00030000oooooooo
07[oool008goool00ol0VOooooooo`0<oooo0P0000Dco`000`000?ooooooo`1joooo002=oooo00?o
09Woooooool03?ooo`030000<ol0<ol000@co`000`000?ooooooo`1joooo002=oooo00?o09Wooooo
ool03?ooo`030000<ol0<ol000@co`000`000?ooooooo`1joooo002=oooo00?o09Woooooool03?oo
o`030000<ol0<ol000@co`020000Noooo`00SOooo`03o`2Ioooooooo00goool00`0003?o03?o0003
<ol000<0003oooooool0N_ooo`00SOooo`03o`2Ioooooooo00goool00`0003?o03?o0003<ol000<0
003oooooool0N_ooo`00SOooo`03o`2Ioooooooo00goool00`0003?o03?o0003<ol000<0003ooooo
ool0N_ooo`00SOooo`03o`2Ioooooooo00goool00`0003?o03?o0003<ol000<0003oooooool0N_oo
o`00SOooo`03o`2Ioooooooo00goool00`0003?o03?o0003<ol000<0003oooooool0N_ooo`00SOoo
o`03o`2Ioooooooo00goool00`0003?o03?o0003<ol00P0007_oool008goool00ol0VOooooooo`0=
oooo00<0000co`0co`000c?o00030000oooooooo07[oool008goool00ol0VOooooooo`0=oooo00<0
000co`0co`000c?o00030000oooooooo07[oool008goool00ol0VOooooooo`0>oooo00<0000co`0c
o`000S?o00030000oooooooo07[oool008goool00ol0VOooooooo`0>oooo00<0000co`0co`000S?o
00030000oooooooo07[oool008goool00ol0VOooooooo`0>oooo00<0000co`0co`000S?o00030000
oooooooo07[oool008goool00ol0VOooooooo`0>oooo00<0000co`0co`000S?o00030000oooooooo
07[oool008goool00ol0VOooooooo`0>oooo00<0000co`0co`000S?o0080001koooo002=oooo00?o
09Woooooool03_ooo`030000<ol0<ol0008co`000`000?ooooooo`1joooo002=oooo00?o09Wooooo
ool03_ooo`030000<ol0<ol0008co`000`000?ooooooo`1joooo002=oooo00?o09Woooooool03_oo
o`030000<ol0<ol0008co`000`000?ooooooo`1joooo002=oooo00?o09Woooooool03_ooo`030000
<ol0<ol0008co`000`000?ooooooo`1joooo002=oooo00?o09Woooooool03_ooo`030000<ol0<ol0
008co`000`000?ooooooo`1joooo002=oooo00?o09Woooooool03_ooo`030000<ol0<ol0008co`02
0000Noooo`00SOooo`03o`2Ioooooooo00ooool01@0003?o03?o03?o0000001loooo002=oooo00?o
09Woooooool03oooo`050000<ol0<ol0<ol0000007coool008goool00ol0VOooooooo`0?oooo00D0
000co`0co`0co`000000O?ooo`00SOooo`03o`2Ioooooooo00_oool500000c?o00030000oooooooo
07[oool008goool00ol0VOooooooo`0;oooo00D0003oooooooooool000000c?o00030000oooooooo
07[oool008goool00ol0VOooooooo`0<oooo00@0003oooooool00003<ol00`0007[oool008goool0
0ol0VOooooooo`0=oooo00<0003oool000000c?o00030000oooooooo07[oool008goool00ol0VOoo
ooooo`0;oooo00<0003oooooool00P0000<co`000`000?ooooooo`1joooo002=oooo00?o09Wooooo
ool03?ooo`8000000oooo`0003?o0002<ol000<0003oooooool0N_ooo`00SOooo`03o`2Ioooooooo
00ooool01@0003?o03?o03?o0000001loooo002=oooo00?o09Woooooool04?ooo`040000<ol0<ol0
0000O?ooo`00SOooo`03o`2Ioooooooo013oool00`0003?o03?o00020000Noooo`00SOooo`03o`2I
oooooooo013oool0100003?o03?o000007coool008goool00ol0VOooooooo`0@oooo00@0000co`0c
o`00001loooo002=oooo00?o09Woooooool04?ooo`040000<ol0<ol00000O?ooo`00SOooo`03o`2I
oooooooo013oool0100003?o03?o000007coool008goool00ol0VOooooooo`0@oooo00@0000co`0c
o`00001loooo002=oooo00?o09Woooooool04?ooo`040000<ol0<ol00000O?ooo`00SOooo`03o`2I
oooooooo017oool0100003?o0000000007_oool008goool00ol0VOooooooo`0Aoooo00<0000co`00
0000O?ooo`00SOooo`03o`2Ioooooooo017oool00`0003?o0000001loooo002=oooo00?o09Wooooo
ool04Oooo`030000<ol0000007coool008goool00ol0VOooooooo`0Aoooo00<0000co`000000O?oo
o`00SOooo`03o`2Ioooooooo017oool00`0003?o0000001loooo002=oooo00?o09Woooooool04Ooo
o`040000<ol000000000Noooo`00SOooo`03o`2Ioooooooo017oool00`0003?o0000001loooo002=
oooo00?o09Woooooool04Oooo`030000<ol0000007coool008goool00ol0VOooooooo`0Aoooo00<0
000co`000000O?ooo`00SOooo`03o`2Ioooooooo017oool00`0003?o0000001loooo002=oooo00?o
09Woooooool04Oooo`030000<ol0000007coool008goool00ol0VOooooooo`0Aoooo00@0000co`00
0000001koooo002=oooo00?o09Woooooool04Oooo`030000<ol0000007coool008goool00ol0VOoo
ooooo`0Aoooo00<0000co`000000O?ooo`00SOooo`03o`2Ioooooooo017oool00`0003?o0000001l
oooo002=oooo00?o09Woooooool03?ooo`800003oooo00<0000co`000000O?ooo`00SOooo`03o`2I
oooooooo00_oool010000?ooooooo`0000;oool00`0003?o0000001loooo002=oooo00?o09Wooooo
ool03Oooo`060000oooooooooooo0000<ol00`0007[oool008goool00ol0VOooooooo`0>oooo00H0
003oooooool0000co`00001loooo002=oooo00?o09Woooooool02oooo`040000oooooooo00000_oo
o`030000<ol0000007coool008goool00ol0VOooooooo`0<oooo0P0000Coool20000O?ooo`00SOoo
o`03o`2Ioooooooo01;oool20000O?ooo`00SOooo`03o`2Ioooooooo01;oool20000O?ooo`00SOoo
o`03o`2Ioooooooo01;oool20000O?ooo`00SOooo`03o`2Ioooooooo01;oool30000Noooo`00SOoo
o`03o`2Ioooooooo01;oool20000O?ooo`00SOooo`03o`2Ioooooooo01;oool20000O?ooo`00SOoo
o`03o`2Ioooooooo01;oool20000O?ooo`00SOooo`03o`2Ioooooooo01;oool20000O?ooo`00SOoo
o`03o`2Ioooooooo01;oool20000O?ooo`00SOooo`03o`2Ioooooooo01;oool30000Noooo`00SOoo
o`03o`2Ioooooooo01;oool20000O?ooo`00SOooo`03o`2Ioooooooo01;oool20000O?ooo`00SOoo
o`03o`2Ioooooooo01;oool20000O?ooo`00SOooo`03o`2Ioooooooo01;oool20000O?ooo`00SOoo
o`03o`2Ioooooooo01;oool20000O?ooo`00SOooo`03o`2Ioooooooo01;oool30000Noooo`00SOoo
o`03o`2Ioooooooo01?oool00`000?ooooooo`1joooo002=oooo00?o09Woooooool04oooo`030000
oooooooo07[oool008goool00ol0VOooooooo`0Coooo00<0003oooooool0N_ooo`00SOooo`03o`2I
oooooooo01?oool00`000?ooooooo`1joooo002=oooo00?o09Woooooool04oooo`030000oooooooo
07[oool008goool00ol0VOooooooo`0Coooo0P0007_oool008goool00ol0VOooooooo`0Coooo00<0
003oooooool0N_ooo`00SOooo`03o`2Ioooooooo01?oool00`000?ooooooo`1joooo002=oooo00?o
09Woooooool04oooo`030000oooooooo07[oool008goool00ol0VOooooooo`0Coooo00<0003ooooo
ool0N_ooo`00SOooo`03o`2Ioooooooo00goool300000oooo`030000oooooooo07[oool008goool0
0ol0VOooooooo`0>oooo00<0003oooooool00_ooo`030000oooooooo07[oool008goool00ol0VOoo
ooooo`0;oooo1@0000?oool30000N_ooo`00Voooo`040000oooooooo0000POooo`00W?ooo`030000
oooo0000087oool009goool20000POooo`00ooooob7oool00?oooolQoooo001ioooo00<0003ooooo
ool0:?ooo`030000oooooooo07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07ooo
o`030000oooooooo07Soool007Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<
oooo100000?oool200000oooo`D00002oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooo
oooo000000;oool00`000?ooooooo`02oooo00<0003oooooool01?ooo`@00003oooo00<0003ooooo
ool02oooo`030000oooooooo00;oool00`000?ooooooo`1hoooo001goooo00<0003oooooool00_oo
o`030000oooooooo01Coool00`000?ooooooo`0:oooo00<0003oooooool00oooo`030000oooooooo
07Ooool007Soool00`000?ooooooo`0500005?ooo`030000oooooooo00Woool00`000?ooooooo`02
oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000001Goool010000?ooooooo`00
00[oool00`000?ooooooo`02oooo00<0003oooooool0N?ooo`00NOooo`030000oooooooo01Ooool2
00002_ooo`800003oooo00<0003oooooool0NOooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-8.12947, \
-1.14361, 0.0496935, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-8.12947, -1.14361, 0.0496935, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
.2 1 0 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49468 .12361 L
.49719 .12361 L
.49842 .12361 L
.49955 .12361 L
s
.49955 .12361 m
.50007 .61803 L
s
0 .4 1 r
.02381 .12391 m
.04262 .12403 L
.06244 .12421 L
.07286 .12433 L
.08255 .12446 L
.09388 .12466 L
.10458 .12488 L
.125 .12543 L
.14357 .12615 L
.16355 .12724 L
.18199 .12865 L
.20071 .13065 L
.21136 .13212 L
.22134 .13378 L
.24158 .1382 L
.26011 .14391 L
.27909 .15208 L
.28984 .15809 L
.29982 .1648 L
.32034 .18298 L
.32939 .19337 L
.33433 .1998 L
.33895 .20633 L
.34013 .20809 L
.34125 .2098 L
.34255 .2098 L
.34373 .20977 L
.34897 .20965 L
.35819 .20941 L
.36829 .2091 L
.37901 .2087 L
.39892 .20773 L
.41734 .20648 L
.43681 .20465 L
.45509 .20229 L
.47528 .19871 L
.48422 .19672 L
.49378 .19425 L
.49642 .1935 L
.49772 .19312 L
.49892 .19276 L
.50001 .12361 L
.50116 .12361 L
.50233 .12361 L
.50359 .12361 L
.50476 .12361 L
.50583 .12361 L
.50691 .12361 L
.50793 .12361 L
.50911 .12361 L
Mistroke
.51021 .12361 L
.51142 .12361 L
.51271 .12361 L
.51339 .12361 L
.51411 .12361 L
.5154 .12361 L
.51611 .12361 L
.51678 .12361 L
.51752 .12361 L
.5183 .12361 L
.51898 .12361 L
.51972 .12361 L
.52042 .12361 L
.52106 .12361 L
.52228 .12361 L
.52357 .12361 L
.52473 .12361 L
.52598 .12361 L
.52717 .12361 L
.52825 .12361 L
.52945 .12361 L
.53076 .12361 L
.53143 .12361 L
.53213 .12361 L
.53341 .12361 L
.53464 .12361 L
.53535 .12361 L
.536 .12361 L
.5367 .12361 L
.53733 .12361 L
.53806 .12361 L
.53875 .12361 L
.53998 .12361 L
.54111 .12361 L
.54235 .12361 L
.54368 .12361 L
.54491 .12361 L
.54622 .12361 L
.5469 .12361 L
.54765 .12361 L
.54896 .12361 L
.54971 .12361 L
.55052 .12361 L
.55127 .12361 L
.55197 .12361 L
.55266 .12361 L
.55342 .12361 L
.55413 .12361 L
.55479 .12361 L
.55595 .12361 L
Mistroke
.5572 .12361 L
.55838 .12361 L
.55945 .12361 L
.56071 .12361 L
.56142 .12361 L
.56208 .12361 L
.56329 .12361 L
.56458 .12361 L
.56524 .12361 L
.56593 .12361 L
.56669 .12361 L
.56739 .12361 L
.56864 .12361 L
.56936 .12361 L
.57002 .12361 L
.57127 .12361 L
.57241 .12361 L
.57372 .12361 L
.57496 .12361 L
.5761 .12361 L
.57733 .12361 L
.57849 .12361 L
.57955 .12361 L
.58073 .12361 L
.58202 .12361 L
.58462 .12361 L
.59488 .12361 L
.61331 .12361 L
.65389 .12361 L
.69295 .12361 L
.73447 .12361 L
.77447 .12361 L
.81296 .12361 L
.8539 .12361 L
.89332 .12361 L
.93123 .12361 L
.97159 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -25.0938 0 ]
[.5 .63053 25.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -86.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
103.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Koooo1@00083oool009goool00`000?ooooooo`20oooo002Moooo00<0003ooooo
ool00oooo`<0001joooo002Eoooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0N_oo
o`00WOooo`030000oooooooo00?oool00`000?ooooooo`1joooo002Loooo0P0000Goool00`000?oo
ooooo`1joooo002Soooo00<0003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool2
0000Noooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0
003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002S
oooo00<0003oooooool0N_ooo`00Xoooo`80001koooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool00:?oool20000Noooo`00:oooo`<0000Xoooo0`0002?oool4
00008oooo`030000oooooooo02?oool400009oooo`<0000Yoooo000[oooo00@0003oooooool0000X
oooo00<0003oooooool08_ooo`030000oooooooo02Coool00`000?ooooooo`0Soooo00<0003ooooo
ool0:Oooo`030000oooooooo02Soool002_oool010000?ooooooo`0002Goool500009?ooo`030000
oooooooo02?oool00`000?ooooooo`0Toooo00<0003oooooool09Oooo`D0000Yoooo000Uoooo1000
00;oool300008?ooo`@00002oooo00@0003oooooool0000Noooo100000Coool00`000?ooooooo`0R
oooo00<0003oooooool09Oooo`030000oooooooo02Coool010000?ooooooo`0002[oool002coool0
0`000?ooooooo`0Voooo00<0003oool000009?ooo`040000oooooooo00008oooo`030000oooooooo
02?oool010000?ooooooo`0002Koool00`000?ooo`00000Zoooo000/oooo0`0002Ooool200009Ooo
o`80000Toooo0P0002Goool20000:?ooo`80000Zoooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool0013ooooo00004Oooo`005_ooo`030000oooooooo00L0I_l0
0`00001Vo`1Vo`0706Ko00<00000I_l0I_l01`1Vo`03000006Ko06Ko00D0I_l2oooo00<0003ooooo
ool02?ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Ooool00`000?ooo`00000@000000<co`00000co`0023?o00030000<ol0<ol000Lco`00
0`0003?o03?o0007<ol000<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool02?ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo01Goool002[oool00`000?ooooooo`0?oooo2@1Vo`koool00`000?ooooooo`0Uoooo00<0
003oooooool01_ooo`@00007<ol000<0I_lco`0co`004C?o00030000oooooooo02Goool00`000?oo
ooooo`0Voooo00<0003oooooool0:Oooo`00AOooo`H0I_lmoooo100000<co`000`1Voc?o03?o000A
<ol000<0003oooooool0N_ooo`00Boooo`@0I_lmoooo00@0000co`0co`00I_lC<ol000<0003ooooo
ool0N_ooo`00Coooo`80I_lloooo0P00000306Ko<ol0<ol0014co`000`000?ooooooo`1joooo001A
oooo0`1Voc_oool00`1Voc?o03?o000A<ol000<0003oooooool0N_ooo`00E?ooo`80I_lioooo00<0
I_l0000co`004C?o0080001koooo001Foooo0`1VocKoool0101Vooooo`000000010co`000`000?oo
ooooo`1joooo001Ioooo0P1VocCoool01@1Vooooooooooooo`00000?<ol000<0003oooooool0N_oo
o`00Foooo`0306Kooooooooo037oool01@1Vooooooooooooo`00000?<ol000<0003oooooool0N_oo
o`00G?ooo`0306Kooooooooo033oool00`1Vooooooooo`02oooo00<0000co`0co`0033?o00030000
oooooooo07[oool005goool00`1Vooooooooo`0_oooo00<0I_ooooooool00_ooo`030000<ol0<ol0
00`co`000`000?ooooooo`1joooo001Noooo0P1Vobooool00`1Vooooooooo`03oooo00<0000co`0c
o`002c?o0080001koooo001Poooo00<0I_ooooooool0;?ooo`0306Kooooooooo00?oool00`0003?o
03?o000;<ol000<0003oooooool0N_ooo`00HOooo`0306Kooooooooo02_oool00`1Vooooooooo`04
oooo00<0000co`0co`002S?o00030000oooooooo07[oool006;oool00`1Vooooooooo`0Zoooo00<0
I_ooooooool01?ooo`030000<ol0<ol000Xco`000`000?ooooooo`1joooo001Soooo00<0I_oooooo
ool0:Oooo`0306Kooooooooo00Goool00`0003?o03?o0009<ol000<0003oooooool0N_ooo`00I?oo
o`0306Kooooooooo02Koool306Ko1oooo`030000<ol0<ol000Tco`000`000?ooooooo`1joooo001T
oooo00<0I_ooooooool08?ooo`H0I_l2oooo00?o09Woooooool01_ooo`030000<ol0<ol000Pco`02
0000Noooo`00IOooo`0306Kooooooooo01[oool506Ko2?ooo`03o`2Ioooooooo00Koool00`0003?o
03?o0008<ol000<0003oooooool0N_ooo`00I_ooo`0306Kooooooooo00ooool:06Ko3Oooo`03o`2I
oooooooo00Koool00`0003?o03?o0008<ol000<0003oooooool0N_ooo`00I_oooa80I_lGoooo00?o
09Woooooool01oooo`030000<ol0<ol000Lco`000`000?ooooooo`1joooo002?oooo00?o09Wooooo
ool01oooo`030000<ol0<ol000Lco`000`000?ooooooo`1joooo002?oooo00?o09Woooooool01ooo
o`030000<ol0<ol000Lco`000`000?ooooooo`1joooo002?oooo00?o09Woooooool01oooo`030000
<ol0<ol000Lco`020000Noooo`00Soooo`03o`2Ioooooooo00Soool00`0003?o03?o0006<ol000<0
003oooooool0N_ooo`00Soooo`03o`2Ioooooooo00Soool00`0003?o03?o0006<ol000<0003ooooo
ool0N_ooo`00Soooo`03o`2Ioooooooo00Soool00`0003?o03?o0006<ol000<0003oooooool0N_oo
o`00Soooo`03o`2Ioooooooo00Soool00`0003?o03?o0006<ol000<0003oooooool0N_ooo`00Sooo
o`03o`2Ioooooooo00Woool500000c?o00030000oooooooo07[oool008ooool00ol0VOooooooo`09
oooo00<0000co`0000001C?o00030000oooooooo07[oool008ooool00ol0VOooooooo`09oooo00<0
000co`0000001C?o00<0001joooo002?oooo00?o09Woooooool02_ooo`800005<ol000<0003ooooo
ool0N_ooo`00Soooo`03o`2Ioooooooo00[oool200001C?o00030000oooooooo07[oool008ooool0
0ol0VOooooooo`0:oooo0P0000Dco`000`000?ooooooo`1joooo002?oooo00?o09Woooooool02_oo
o`030000<ol0<ol000@co`000`000?ooooooo`1joooo002?oooo00?o09Woooooool02_ooo`030000
<ol0<ol000@co`000`000?ooooooo`1joooo002?oooo00?o09Woooooool02_ooo`030000<ol0<ol0
00@co`020000Noooo`00Soooo`03o`2Ioooooooo00_oool00`0003?o03?o0003<ol000<0003ooooo
ool0N_ooo`00Soooo`03o`2Ioooooooo00_oool00`0003?o03?o0003<ol000<0003oooooool0N_oo
o`00Soooo`03o`2Ioooooooo00_oool00`0003?o03?o0003<ol000<0003oooooool0N_ooo`00Sooo
o`03o`2Ioooooooo00_oool00`0003?o03?o0003<ol000<0003oooooool0N_ooo`00Soooo`03o`2I
oooooooo00_oool00`0003?o03?o0003<ol000<0003oooooool0N_ooo`00Soooo`03o`2Ioooooooo
00_oool00`0003?o03?o0003<ol00P0007_oool008ooool00ol0VOooooooo`0;oooo00<0000co`0c
o`000c?o00030000oooooooo07[oool008ooool00ol0VOooooooo`0;oooo00<0000co`0co`000c?o
00030000oooooooo07[oool008ooool00ol0VOooooooo`0<oooo00<0000co`0co`000S?o00030000
oooooooo07[oool008ooool00ol0VOooooooo`0<oooo00<0000co`0co`000S?o00030000oooooooo
07[oool008ooool00ol0VOooooooo`0<oooo00<0000co`0co`000S?o00030000oooooooo07[oool0
08ooool00ol0VOooooooo`0<oooo00<0000co`0co`000S?o00030000oooooooo07[oool008ooool0
0ol0VOooooooo`0<oooo00<0000co`0co`000S?o0080001koooo002?oooo00?o09Woooooool03?oo
o`030000<ol0<ol0008co`000`000?ooooooo`1joooo002?oooo00?o09Woooooool03?ooo`030000
<ol0<ol0008co`000`000?ooooooo`1joooo002?oooo00?o09Woooooool03?ooo`030000<ol0<ol0
008co`000`000?ooooooo`1joooo002?oooo00?o09Woooooool03?ooo`030000<ol0<ol0008co`00
0`000?ooooooo`1joooo002?oooo00?o09Woooooool03?ooo`030000<ol0<ol0008co`000`000?oo
ooooo`1joooo002?oooo00?o09Woooooool03?ooo`030000<ol0<ol0008co`020000Noooo`00Sooo
o`03o`2Ioooooooo00goool01@0003?o03?o03?o0000001loooo002?oooo00?o09Woooooool03Ooo
o`050000<ol0<ol0<ol0000007coool008ooool00ol0VOooooooo`0=oooo00D0000co`0co`0co`00
0000O?ooo`00Soooo`03o`2Ioooooooo00Woool500000c?o00030000oooooooo07[oool008ooool0
0ol0VOooooooo`09oooo00D0003oooooooooool000000c?o00030000oooooooo07[oool008ooool0
0ol0VOooooooo`0:oooo00@0003oooooool00003<ol00`0007[oool008ooool00ol0VOooooooo`0;
oooo00<0003oool000000c?o00030000oooooooo07[oool008ooool00ol0VOooooooo`09oooo00<0
003oooooool00P0000<co`000`000?ooooooo`1joooo002?oooo00?o09Woooooool02_ooo`800000
0oooo`0003?o0002<ol000<0003oooooool0N_ooo`00Soooo`03o`2Ioooooooo00goool01@0003?o
03?o03?o0000001loooo002?oooo00?o09Woooooool03_ooo`040000<ol0<ol00000O?ooo`00Sooo
o`03o`2Ioooooooo00koool00`0003?o03?o00020000Noooo`00Soooo`03o`2Ioooooooo00koool0
100003?o03?o000007coool008ooool00ol0VOooooooo`0>oooo00@0000co`0co`00001loooo002?
oooo00?o09Woooooool03_ooo`040000<ol0<ol00000O?ooo`00Soooo`03o`2Ioooooooo00koool0
100003?o03?o000007coool008ooool00ol0VOooooooo`0>oooo00@0000co`0co`00001loooo002?
oooo00?o09Woooooool03_ooo`040000<ol0<ol00000O?ooo`00Soooo`03o`2Ioooooooo00ooool0
100003?o0000000007_oool008ooool00ol0VOooooooo`0?oooo00<0000co`000000O?ooo`00Sooo
o`03o`2Ioooooooo00ooool00`0003?o0000001loooo002?oooo00?o09Woooooool03oooo`030000
<ol0000007coool008ooool00ol0VOooooooo`0?oooo00<0000co`000000O?ooo`00Soooo`03o`2I
oooooooo00ooool00`0003?o0000001loooo002?oooo00?o09Woooooool03oooo`040000<ol00000
0000Noooo`00Soooo`03o`2Ioooooooo00ooool00`0003?o0000001loooo002?oooo00?o09Wooooo
ool03oooo`030000<ol0000007coool008ooool00ol0VOooooooo`0?oooo00<0000co`000000O?oo
o`00Soooo`03o`2Ioooooooo00ooool00`0003?o0000001loooo002?oooo00?o09Woooooool03ooo
o`030000<ol0000007coool008ooool00ol0VOooooooo`0?oooo00@0000co`000000001koooo002?
oooo00?o09Woooooool03oooo`030000<ol0000007coool008ooool00ol0VOooooooo`0?oooo00<0
000co`000000O?ooo`00Soooo`03o`2Ioooooooo00ooool00`0003?o0000001loooo002?oooo00?o
09Woooooool02_ooo`800003oooo00<0000co`000000O?ooo`00Soooo`03o`2Ioooooooo00Woool0
10000?ooooooo`0000;oool00`0003?o0000001loooo002?oooo00?o09Woooooool02oooo`060000
oooooooooooo0000<ol00`0007[oool008ooool00ol0VOooooooo`0<oooo00H0003oooooool0000c
o`00001loooo002?oooo00?o09Woooooool02Oooo`040000oooooooo00000_ooo`030000<ol00000
07coool008ooool00ol0VOooooooo`0:oooo0P0000Coool20000O?ooo`00Soooo`03o`2Ioooooooo
013oool20000O?ooo`00Soooo`03o`2Ioooooooo013oool20000O?ooo`00Soooo`03o`2Ioooooooo
013oool20000O?ooo`00Soooo`03o`2Ioooooooo013oool30000Noooo`00Soooo`03o`2Ioooooooo
013oool20000O?ooo`00Soooo`03o`2Ioooooooo013oool20000O?ooo`00Soooo`03o`2Ioooooooo
013oool20000O?ooo`00Soooo`03o`2Ioooooooo013oool20000O?ooo`00Soooo`03o`2Ioooooooo
013oool20000O?ooo`00Soooo`03o`2Ioooooooo013oool30000Noooo`00Soooo`03o`2Ioooooooo
013oool20000O?ooo`00Soooo`03o`2Ioooooooo013oool20000O?ooo`00Soooo`03o`2Ioooooooo
013oool20000O?ooo`00Soooo`03o`2Ioooooooo013oool20000O?ooo`00Soooo`03o`2Ioooooooo
013oool20000O?ooo`00Soooo`03o`2Ioooooooo013oool30000Noooo`00Soooo`03o`2Ioooooooo
017oool00`000?ooooooo`1joooo002?oooo00?o09Woooooool04Oooo`030000oooooooo07[oool0
08ooool00ol0VOooooooo`0Aoooo00<0003oooooool0N_ooo`00Soooo`03o`2Ioooooooo017oool0
0`000?ooooooo`1joooo002?oooo00?o09Woooooool04Oooo`030000oooooooo07[oool008ooool0
0ol0VOooooooo`0Aoooo0P0007_oool008ooool00ol0VOooooooo`0Aoooo00<0003oooooool0N_oo
o`00Soooo`03o`2Ioooooooo017oool00`000?ooooooo`1joooo002?oooo00?o09Woooooool04Ooo
o`030000oooooooo07[oool008ooool00ol0VOooooooo`0Aoooo00<0003oooooool0N_ooo`00Sooo
o`03o`2Ioooooooo00_oool300000oooo`030000oooooooo07[oool008ooool00ol0VOooooooo`0<
oooo00<0003oooooool00_ooo`030000oooooooo07[oool008ooool00ol0VOooooooo`09oooo1@00
00?oool30000N_ooo`00Voooo`040000oooooooo0000POooo`00W?ooo`030000oooo0000087oool0
09goool20000POooo`00ooooob7oool00?oooolQoooo001loooo00<0003oooooool08_ooo`030000
oooooooo07coool007_oool00`000?ooooooo`08oooo00<0003oooooool06Oooo`030000oooooooo
07_oool007_oool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo100000?oool2
00001?ooo`030000oooooooo07_oool007_oool01@000?ooooooooooo`000002oooo00<0003ooooo
ool00_ooo`030000oooooooo00Coool400000oooo`030000oooooooo00[oool00`000?ooooooo`1k
oooo001joooo00<0003oooooool00_ooo`030000oooooooo01Coool00`000?ooooooo`0:oooo00<0
003oooooool0N_ooo`00Noooo`030000oooooooo00D0000Doooo00<0003oooooool02?ooo`030000
oooooooo07_oool007_oool01@000?ooooooooooo`00000Eoooo00@0003oooooool00009oooo00<0
003oooooool0Noooo`00O?ooo`030000oooooooo01Ooool200002Oooo`030000oooooooo07coool0
0?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-8.12947, \
-1.14361, 0.0496935, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-8.12947, -1.14361, 0.0496935, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.9) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
.2 1 0 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49012 .12361 L
.49955 .12361 L
.50205 .12361 L
.50471 .12361 L
.50601 .12361 L
.50722 .12361 L
s
.50722 .12361 m
.50766 .61803 L
s
0 .4 1 r
.02381 .12387 m
.04262 .12397 L
.06244 .12413 L
.07286 .12423 L
.08255 .12435 L
.09388 .12452 L
.10458 .12471 L
.125 .12519 L
.14357 .12581 L
.16355 .12676 L
.18199 .12798 L
.20071 .12972 L
.21136 .13099 L
.22134 .13243 L
.24158 .13626 L
.26011 .14121 L
.27909 .1483 L
.28984 .15351 L
.29982 .15932 L
.32034 .17509 L
.33895 .19534 L
.34382 .20185 L
.34649 .20565 L
.34779 .20757 L
.34897 .20937 L
.35006 .20971 L
.35109 .20968 L
.35337 .20963 L
.35819 .20951 L
.36829 .20921 L
.37901 .20884 L
.39892 .20793 L
.41734 .20675 L
.43681 .20504 L
.45509 .20283 L
.47528 .19949 L
.49378 .19532 L
.49852 .19405 L
.50113 .19331 L
.50359 .19259 L
.50588 .19189 L
.50717 .19149 L
.50836 .12361 L
.50937 .12361 L
.51047 .12361 L
.51163 .12361 L
.51271 .12361 L
.51399 .12361 L
.51471 .12361 L
.51538 .12361 L
Mistroke
.51661 .12361 L
.51792 .12361 L
.51921 .12361 L
.52042 .12361 L
.52151 .12361 L
.52269 .12361 L
.52398 .12361 L
.52472 .12361 L
.5254 .12361 L
.52613 .12361 L
.52679 .12361 L
.52755 .12361 L
.52827 .12361 L
.52955 .12361 L
.53073 .12361 L
.53203 .12361 L
.53268 .12361 L
.53341 .12361 L
.53455 .12361 L
.53576 .12361 L
.53646 .12361 L
.5371 .12361 L
.53834 .12361 L
.53962 .12361 L
.54034 .12361 L
.54101 .12361 L
.54231 .12361 L
.54353 .12361 L
.54456 .12361 L
.54567 .12361 L
.54803 .12361 L
.54931 .12361 L
.55052 .12361 L
.55161 .12361 L
.55279 .12361 L
.55408 .12361 L
.55529 .12361 L
.55598 .12361 L
.55661 .12361 L
.55731 .12361 L
.55804 .12361 L
.55871 .12361 L
.55942 .12361 L
.56071 .12361 L
.5615 .12361 L
.56224 .12361 L
.5629 .12361 L
.56363 .12361 L
.56483 .12361 L
.56553 .12361 L
Mistroke
.56616 .12361 L
.56683 .12361 L
.56755 .12361 L
.56885 .12361 L
.57003 .12361 L
.57132 .12361 L
.57253 .12361 L
.57366 .12361 L
.57495 .12361 L
.5756 .12361 L
.57631 .12361 L
.57757 .12361 L
.57874 .12361 L
.57946 .12361 L
.58013 .12361 L
.5814 .12361 L
.58424 .12361 L
.5942 .12361 L
.61281 .12361 L
.65116 .12361 L
.69196 .12361 L
.73125 .12361 L
.76902 .12361 L
.80924 .12361 L
.84795 .12361 L
.88911 .12361 L
.92875 .12361 L
.96688 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.9) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Koooo1@00083oool009goool00`000?ooooooo`20oooo002Moooo00<0003ooooo
ool00oooo`<0001joooo002Eoooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0N_oo
o`00WOooo`030000oooooooo00?oool00`000?ooooooo`1joooo002Loooo0P0000Goool00`000?oo
ooooo`1joooo002Soooo00<0003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool2
0000Noooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0
003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002S
oooo00<0003oooooool0N_ooo`00Xoooo`80001koooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool00:?oool20000Noooo`00:oooo`<0000Xoooo0`0002?oool4
00008oooo`030000oooooooo02?oool400009oooo`<0000Yoooo000[oooo00@0003oooooool0000X
oooo00<0003oooooool08_ooo`030000oooooooo02Coool00`000?ooooooo`0Soooo00<0003ooooo
ool0:Oooo`030000oooooooo02Soool002_oool010000?ooooooo`0002Goool500009?ooo`030000
oooooooo02?oool00`000?ooooooo`0Toooo00<0003oooooool09Oooo`D0000Yoooo000Uoooo1000
00;oool300008?ooo`@00002oooo00@0003oooooool0000Noooo100000Coool00`000?ooooooo`0R
oooo00<0003oooooool09Oooo`030000oooooooo02Coool010000?ooooooo`0002[oool002coool0
0`000?ooooooo`0Voooo00<0003oool000009?ooo`040000oooooooo00008oooo`030000oooooooo
02?oool010000?ooooooo`0002Koool00`000?ooo`00000Zoooo000/oooo0`0002Ooool200009Ooo
o`80000Toooo0P0002Goool20000:?ooo`80000Zoooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool2
06Ko00<00000I_l0I_l01`1Vo`03000006Ko06Ko00L0I_l00`00001Vo`1Vo`0506Ko0_ooo`030000
oooooooo00Soool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oool0000040000003<ol00000<ol000Pco`000`0003?o001Vo`07
<ol000<0000co`0co`001c?o00030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Soool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`0Eoooo000Zoooo00<0003oooooool03oooo`/0I_l<oooo00<0003oooooool09Ooo
o`030000oooooooo00Koool400002C?o000306Ko<ol0<ol000lco`000`000?ooooooo`0Uoooo00<0
003oooooool09_ooo`030000oooooooo02Woool004Ooool406Ko?Oooo`@00005<ol000<0I_lco`0c
o`003c?o00030000oooooooo07[oool004_oool506Ko??ooo`030000<ol0<ol0008co`000`1Voc?o
03?o000?<ol000<0003oooooool0N_ooo`00D?ooo`@0I_lioooo0P00008co`000`1Voc?o03?o000?
<ol000<0003oooooool0N_ooo`00E?ooo`80I_lioooo00<0000co`00I_l04C?o00030000oooooooo
07[oool005Koool306Ko=oooo`03000006Ko<ol0010co`020000Noooo`00FOooo`80I_lfoooo00<0
I_l0000co`003c?o00030000oooooooo07[oool005_oool206Ko=?ooo`0306Kooooo000000lco`00
0`000?ooooooo`1joooo001Moooo00<0I_ooooooool0<Oooo`0306Kooooo000000lco`000`000?oo
ooooo`1joooo001Noooo0P1Voc7oool0101Vooooooooo`0000hco`000`000?ooooooo`1joooo001P
oooo00<0I_ooooooool0;_ooo`0406Kooooooooo00003S?o00030000oooooooo07[oool0067oool0
0`1Vooooooooo`0]oooo00D0I_ooooooooooool000003C?o0080001koooo001Roooo00<0I_oooooo
ool0;?ooo`0506Kooooooooooooo000000dco`000`000?ooooooo`1joooo001Soooo00<0I_oooooo
ool0:oooo`0306Kooooooooo00;oool00`0003?o03?o000:<ol000<0003oooooool0N_ooo`00Hooo
o`0306Kooooooooo02_oool00`1Vooooooooo`02oooo00<0000co`0co`002S?o00030000oooooooo
07[oool006Coool00`1Vooooooooo`0Zoooo00<0I_ooooooool00oooo`030000<ol0<ol000Tco`00
0`000?ooooooo`1joooo001Uoooo00<0I_ooooooool09oooo`<0I_l5oooo00<0000co`0co`002C?o
00030000oooooooo07[oool006Koool00`1Vooooooooo`0Soooo0`1Vo`;oool00ol0VOooooooo`04
oooo00<0000co`0co`0023?o0080001koooo001Woooo00<0I_ooooooool06?ooo`X0I_l5oooo00?o
09Woooooool01?ooo`030000<ol0<ol000Pco`000`000?ooooooo`1joooo001Xoooo00<0I_oooooo
ool03Oooo`X0I_l?oooo00?o09Woooooool01?ooo`030000<ol0<ol000Pco`000`000?ooooooo`1j
oooo001Xoooo401VoaWoool00ol0VOooooooo`05oooo00<0000co`0co`001c?o00030000oooooooo
07[oool0097oool00ol0VOooooooo`05oooo00<0000co`0co`001c?o00030000oooooooo07[oool0
097oool00ol0VOooooooo`05oooo00<0000co`0co`001c?o00030000oooooooo07[oool0097oool0
0ol0VOooooooo`05oooo00<0000co`0co`001c?o0080001koooo002Aoooo00?o09Woooooool01_oo
o`030000<ol0<ol000Hco`000`000?ooooooo`1joooo002Aoooo00?o09Woooooool01_ooo`030000
<ol0<ol000Hco`000`000?ooooooo`1joooo002Aoooo00?o09Woooooool01_ooo`030000<ol0<ol0
00Hco`000`000?ooooooo`1joooo002Aoooo00?o09Woooooool01_ooo`030000<ol0<ol000Hco`00
0`000?ooooooo`1joooo002Aoooo00?o09Woooooool01oooo`D00003<ol000<0003oooooool0N_oo
o`00TOooo`03o`2Ioooooooo00Ooool00`0003?o00000005<ol000<0003oooooool0N_ooo`00TOoo
o`03o`2Ioooooooo00Ooool00`0003?o00000005<ol00`0007[oool0097oool00ol0VOooooooo`08
oooo0P0000Dco`000`000?ooooooo`1joooo002Aoooo00?o09Woooooool02?ooo`800005<ol000<0
003oooooool0N_ooo`00TOooo`03o`2Ioooooooo00Soool200001C?o00030000oooooooo07[oool0
097oool00ol0VOooooooo`08oooo00<0000co`0co`0013?o00030000oooooooo07[oool0097oool0
0ol0VOooooooo`08oooo00<0000co`0co`0013?o00030000oooooooo07[oool0097oool00ol0VOoo
ooooo`08oooo00<0000co`0co`0013?o0080001koooo002Aoooo00?o09Woooooool02Oooo`030000
<ol0<ol000<co`000`000?ooooooo`1joooo002Aoooo00?o09Woooooool02Oooo`030000<ol0<ol0
00<co`000`000?ooooooo`1joooo002Aoooo00?o09Woooooool02Oooo`030000<ol0<ol000<co`00
0`000?ooooooo`1joooo002Aoooo00?o09Woooooool02Oooo`030000<ol0<ol000<co`000`000?oo
ooooo`1joooo002Aoooo00?o09Woooooool02Oooo`030000<ol0<ol000<co`000`000?ooooooo`1j
oooo002Aoooo00?o09Woooooool02Oooo`030000<ol0<ol000<co`020000Noooo`00TOooo`03o`2I
oooooooo00Woool00`0003?o03?o0003<ol000<0003oooooool0N_ooo`00TOooo`03o`2Ioooooooo
00Woool00`0003?o03?o0003<ol000<0003oooooool0N_ooo`00TOooo`03o`2Ioooooooo00[oool0
0`0003?o03?o0002<ol000<0003oooooool0N_ooo`00TOooo`03o`2Ioooooooo00[oool00`0003?o
03?o0002<ol000<0003oooooool0N_ooo`00TOooo`03o`2Ioooooooo00[oool00`0003?o03?o0002
<ol000<0003oooooool0N_ooo`00TOooo`03o`2Ioooooooo00[oool00`0003?o03?o0002<ol000<0
003oooooool0N_ooo`00TOooo`03o`2Ioooooooo00[oool00`0003?o03?o0002<ol00P0007_oool0
097oool00ol0VOooooooo`0:oooo00<0000co`0co`000S?o00030000oooooooo07[oool0097oool0
0ol0VOooooooo`0:oooo00<0000co`0co`000S?o00030000oooooooo07[oool0097oool00ol0VOoo
ooooo`0:oooo00<0000co`0co`000S?o00030000oooooooo07[oool0097oool00ol0VOooooooo`0:
oooo00<0000co`0co`000S?o00030000oooooooo07[oool0097oool00ol0VOooooooo`0:oooo00<0
000co`0co`000S?o00030000oooooooo07[oool0097oool00ol0VOooooooo`0:oooo00<0000co`0c
o`000S?o0080001koooo002Aoooo00?o09Woooooool02oooo`050000<ol0<ol0<ol0000007coool0
097oool00ol0VOooooooo`0;oooo00D0000co`0co`0co`000000O?ooo`00TOooo`03o`2Ioooooooo
00_oool01@0003?o03?o03?o0000001loooo002Aoooo00?o09Woooooool01oooo`D00003<ol000<0
003oooooool0N_ooo`00TOooo`03o`2Ioooooooo00Ooool01@000?ooooooooooo`000003<ol000<0
003oooooool0N_ooo`00TOooo`03o`2Ioooooooo00Soool010000?ooooooo`0000<co`030000N_oo
o`00TOooo`03o`2Ioooooooo00Woool00`000?ooo`000003<ol000<0003oooooool0N_ooo`00TOoo
o`03o`2Ioooooooo00Ooool00`000?ooooooo`0200000c?o00030000oooooooo07[oool0097oool0
0ol0VOooooooo`08oooo0P000003oooo0000<ol0008co`000`000?ooooooo`1joooo002Aoooo00?o
09Woooooool02oooo`050000<ol0<ol0<ol0000007coool0097oool00ol0VOooooooo`0<oooo00@0
000co`0co`00001loooo002Aoooo00?o09Woooooool03?ooo`030000<ol0<ol00080001koooo002A
oooo00?o09Woooooool03?ooo`040000<ol0<ol00000O?ooo`00TOooo`03o`2Ioooooooo00coool0
100003?o03?o000007coool0097oool00ol0VOooooooo`0<oooo00@0000co`0co`00001loooo002A
oooo00?o09Woooooool03?ooo`040000<ol0<ol00000O?ooo`00TOooo`03o`2Ioooooooo00coool0
100003?o03?o000007coool0097oool00ol0VOooooooo`0<oooo00@0000co`0co`00001loooo002A
oooo00?o09Woooooool03Oooo`040000<ol000000000Noooo`00TOooo`03o`2Ioooooooo00goool0
0`0003?o0000001loooo002Aoooo00?o09Woooooool03Oooo`030000<ol0000007coool0097oool0
0ol0VOooooooo`0=oooo00<0000co`000000O?ooo`00TOooo`03o`2Ioooooooo00goool00`0003?o
0000001loooo002Aoooo00?o09Woooooool03Oooo`030000<ol0000007coool0097oool00ol0VOoo
ooooo`0=oooo00@0000co`000000001koooo002Aoooo00?o09Woooooool03Oooo`030000<ol00000
07coool0097oool00ol0VOooooooo`0=oooo00<0000co`000000O?ooo`00TOooo`03o`2Ioooooooo
00goool00`0003?o0000001loooo002Aoooo00?o09Woooooool03Oooo`030000<ol0000007coool0
097oool00ol0VOooooooo`0=oooo00<0000co`000000O?ooo`00TOooo`03o`2Ioooooooo00goool0
100003?o0000000007_oool0097oool00ol0VOooooooo`0=oooo00<0000co`000000O?ooo`00TOoo
o`03o`2Ioooooooo00goool00`0003?o0000001loooo002Aoooo00?o09Woooooool03Oooo`030000
<ol0000007coool0097oool00ol0VOooooooo`08oooo0P0000?oool00`0003?o0000001loooo002A
oooo00?o09Woooooool01oooo`040000oooooooo00000_ooo`030000<ol0000007coool0097oool0
0ol0VOooooooo`09oooo00H0003oooooooooool0000co`030000N_ooo`00TOooo`03o`2Ioooooooo
00[oool01P000?ooooooo`0003?o000007coool0097oool00ol0VOooooooo`07oooo00@0003ooooo
ool00002oooo00<0000co`000000O?ooo`00TOooo`03o`2Ioooooooo00Soool200001?ooo`80001l
oooo002Aoooo00?o09Woooooool03_ooo`80001loooo002Aoooo00?o09Woooooool03_ooo`80001l
oooo002Aoooo00?o09Woooooool03_ooo`80001loooo002Aoooo00?o09Woooooool03_ooo`<0001k
oooo002Aoooo00?o09Woooooool03_ooo`80001loooo002Aoooo00?o09Woooooool03_ooo`80001l
oooo002Aoooo00?o09Woooooool03_ooo`80001loooo002Aoooo00?o09Woooooool03_ooo`80001l
oooo002Aoooo00?o09Woooooool03_ooo`80001loooo002Aoooo00?o09Woooooool03_ooo`<0001k
oooo002Aoooo00?o09Woooooool03_ooo`80001loooo002Aoooo00?o09Woooooool03_ooo`80001l
oooo002Aoooo00?o09Woooooool03_ooo`80001loooo002Aoooo00?o09Woooooool03_ooo`80001l
oooo002Aoooo00?o09Woooooool03_ooo`80001loooo002Aoooo00?o09Woooooool03_ooo`<0001k
oooo002Aoooo00?o09Woooooool03oooo`030000oooooooo07[oool0097oool00ol0VOooooooo`0?
oooo00<0003oooooool0N_ooo`00TOooo`03o`2Ioooooooo00ooool00`000?ooooooo`1joooo002A
oooo00?o09Woooooool03oooo`030000oooooooo07[oool0097oool00ol0VOooooooo`0?oooo00<0
003oooooool0N_ooo`00TOooo`03o`2Ioooooooo00ooool20000Noooo`00TOooo`03o`2Ioooooooo
00ooool00`000?ooooooo`1joooo002Aoooo00?o09Woooooool03oooo`030000oooooooo07[oool0
097oool00ol0VOooooooo`0?oooo00<0003oooooool0N_ooo`00TOooo`03o`2Ioooooooo00ooool0
0`000?ooooooo`1joooo002Aoooo00?o09Woooooool02Oooo`<00003oooo00<0003oooooool0N_oo
o`00TOooo`03o`2Ioooooooo00[oool00`000?ooooooo`02oooo00<0003oooooool0N_ooo`00TOoo
o`03o`2Ioooooooo00Ooool500000oooo`<0001joooo002Koooo00@0003oooooool00021oooo002L
oooo00<0003oool00000POooo`00WOooo`800021oooo003ooooo8Oooo`00ooooob7oool007Woool0
0`000?ooooooo`0Xoooo00<0003oooooool0NOooo`00N?ooo`030000oooooooo00Soool00`000?oo
ooooo`0Ooooo00<0003oooooool0N?ooo`00N?ooo`030000oooooooo00;oool200001?ooo`030000
oooooooo00coool500000_ooo`800003oooo0`0000Coool00`000?ooooooo`1hoooo001hoooo00D0
003oooooooooool000000_ooo`030000oooooooo00;oool00`000?ooooooo`04oooo100000Goool0
0`000?ooooooo`09oooo00<0003oooooool00_ooo`030000oooooooo07Soool007Ooool00`000?oo
ooooo`02oooo00<0003oooooool05Oooo`030000oooooooo00Soool300001?ooo`030000oooooooo
07Ooool007Soool00`000?ooooooo`0500005?ooo`030000oooooooo00Ooool010000?ooooooo`00
00?oool00`000?ooooooo`1hoooo001hoooo00D0003oooooooooool000005oooo`030000oooooooo
00Ooool010000?ooooooo`0000?oool00`000?ooooooo`1hoooo001ioooo00<0003oooooool05ooo
o`80000:oooo0`0000;oool00`000?ooooooo`1ioooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-8.12947, \
-1.14361, 0.0496935, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-8.12947, -1.14361, 0.0496935, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
.2 1 0 r
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
.97619 .12361 L
.02381 .12361 L
F
0 g
.02381 .12361 m
.03279 .12361 L
.04262 .12361 L
.04758 .12361 L
.05288 .12361 L
.06244 .12361 L
.06788 .12361 L
.07379 .12361 L
.07899 .12361 L
.08451 .12361 L
.08947 .12361 L
.09494 .12361 L
.10458 .12361 L
.10978 .12361 L
.11472 .12361 L
.12399 .12361 L
.13397 .12361 L
.13962 .12361 L
.14487 .12361 L
.14994 .12361 L
.15543 .12361 L
.16539 .12361 L
.17508 .12361 L
.184 .12361 L
.19373 .12361 L
.20282 .12361 L
.21279 .12361 L
.21839 .12361 L
.22348 .12361 L
.2334 .12361 L
.24257 .12361 L
.25264 .12361 L
.25772 .12361 L
.26333 .12361 L
.27342 .12361 L
.28268 .12362 L
.29284 .12362 L
.29795 .12362 L
.30353 .12363 L
.31381 .12363 L
.32314 .12364 L
.32831 .12365 L
.33392 .12366 L
.34409 .12368 L
.35356 .12372 L
.35894 .12374 L
.36397 .12376 L
.37411 .12383 L
.37981 .12388 L
.38501 .12394 L
Mistroke
.39488 .12408 L
.40404 .12426 L
.41408 .12455 L
.41969 .12475 L
.42477 .12498 L
.43482 .12558 L
.44406 .12635 L
.4542 .12754 L
.4593 .12833 L
.46489 .12938 L
.47015 .13058 L
.47512 .13194 L
.48444 .13526 L
.48965 .13767 L
.49447 .14035 L
.49972 .14387 L
.50537 .1485 L
.51041 .15354 L
.51502 .15908 L
.52407 .17325 L
.52887 .18305 L
.53412 .19615 L
.53956 .21301 L
.54469 .23283 L
.54963 .25656 L
.55499 .28888 L
.55944 .32259 L
.56434 .36904 L
.56964 .43439 L
.57235 .47563 L
.57525 .52746 L
.57665 .55567 L
.57797 .58468 L
.57915 .61281 L
.58045 .12361 L
.58167 .12361 L
.58297 .12361 L
.5853 .12361 L
.62302 .12361 L
.66319 .12361 L
.70184 .12361 L
.74295 .12361 L
.78254 .12361 L
.82062 .12361 L
.86115 .12361 L
.90016 .12361 L
.94163 .12361 L
.97619 .12361 L
Mfstroke
1 0 .6 r
.02381 .12361 m
.06244 .12361 L
.10458 .12361 L
.14415 .12361 L
.18221 .12361 L
.22272 .12361 L
.26171 .12361 L
.30316 .12361 L
.34309 .12361 L
.3815 .12361 L
.42237 .12361 L
.46172 .12361 L
.48147 .12361 L
.49955 .12361 L
.50431 .12361 L
.5095 .12361 L
.51188 .12361 L
.51318 .12361 L
.51441 .12361 L
.51555 .12361 L
s
.51555 .12361 m
.51605 .61803 L
s
0 .4 1 r
.02381 .12383 m
.04262 .12392 L
.06244 .12406 L
.07286 .12415 L
.08255 .12425 L
.09388 .1244 L
.10458 .12456 L
.125 .12498 L
.14357 .12552 L
.16355 .12634 L
.18199 .1274 L
.20071 .1289 L
.21136 .13001 L
.22134 .13125 L
.24158 .13458 L
.26011 .13887 L
.27909 .14501 L
.28984 .14952 L
.29982 .15457 L
.32034 .16824 L
.33895 .18578 L
.34831 .19707 L
.35342 .20408 L
.3547 .20594 L
.35592 .20774 L
.35701 .20939 L
.35819 .20957 L
.35949 .20954 L
.36069 .20951 L
.36336 .20943 L
.36904 .20927 L
.37901 .20893 L
.39768 .20812 L
.41828 .20687 L
.43763 .20522 L
.45848 .20273 L
.47852 .1994 L
.48873 .19725 L
.49962 .19456 L
.50494 .19308 L
.50997 .19157 L
.51216 .19088 L
.51448 .19013 L
.51569 .18972 L
.51638 .12361 L
.51702 .12361 L
.51815 .12361 L
.51937 .12361 L
.52059 .12361 L
.52172 .12361 L
Mistroke
.52296 .12361 L
.52366 .12361 L
.52429 .12361 L
.52545 .12361 L
.5267 .12361 L
.52788 .12361 L
.52896 .12361 L
.52995 .12361 L
.531 .12361 L
.53215 .12361 L
.53323 .12361 L
.53444 .12361 L
.53559 .12361 L
.53661 .12361 L
.53773 .12361 L
.53895 .12361 L
.54007 .12361 L
.5413 .12361 L
.5426 .12361 L
.54373 .12361 L
.54478 .12361 L
.54593 .12361 L
.54716 .12361 L
.54786 .12361 L
.5485 .12361 L
.54921 .12361 L
.54996 .12361 L
.55122 .12361 L
.55194 .12361 L
.5526 .12361 L
.55384 .12361 L
.55516 .12361 L
.55638 .12361 L
.55755 .12361 L
.55875 .12361 L
.55943 .12361 L
.56008 .12361 L
.56137 .12361 L
.56204 .12361 L
.56277 .12361 L
.564 .12361 L
.56529 .12361 L
.56649 .12361 L
.56761 .12361 L
.56829 .12361 L
.56904 .12361 L
.56974 .12361 L
.57038 .12361 L
.57161 .12361 L
.5729 .12361 L
Mistroke
.57358 .12361 L
.5743 .12361 L
.5756 .12361 L
.57639 .12361 L
.57715 .12361 L
.57783 .12361 L
.57857 .12361 L
.57921 .12361 L
.5799 .12361 L
.58112 .12361 L
.58389 .12361 L
.58889 .12361 L
.59825 .12361 L
.61923 .12361 L
.65722 .12361 L
.69767 .12361 L
.7366 .12361 L
.77798 .12361 L
.81784 .12361 L
.85619 .12361 L
.89699 .12361 L
.93628 .12361 L
.97405 .12361 L
.97619 .12361 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .3461 L
s
.57937 .39554 m
.58312 .39554 L
s
.57937 .42026 m
.58312 .42026 L
s
.57937 .44498 m
.58312 .44498 L
s
.57937 .46971 m
.58312 .46971 L
s
.57937 .51915 m
.58312 .51915 L
s
.57937 .54387 m
.58312 .54387 L
s
.57937 .56859 m
.58312 .56859 L
s
.57937 .59331 m
.58312 .59331 L
s
.25 Mabswid
.57937 0 m
.57937 .61803 L
s
gsave
.5 .63053 -89.0938 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 12.813 moveto
(8) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
75.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
75.000 12.813 moveto
(,) show
84.563 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
91.188 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.8) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
109.188 12.813 moveto
(<) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
0?oooolQoooo002Koooo1@00083oool009goool00`000?ooooooo`20oooo002Moooo00<0003ooooo
ool00oooo`<0001joooo002Eoooo100000Coool00`000?ooooooo`03oooo00<0003oooooool0N_oo
o`00WOooo`030000oooooooo00?oool00`000?ooooooo`1joooo002Loooo0P0000Goool00`000?oo
ooooo`1joooo002Soooo00<0003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool2
0000Noooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0
003oooooool0N_ooo`00Xoooo`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002S
oooo00<0003oooooool0N_ooo`00Xoooo`80001koooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool00:?oool20000Noooo`00:oooo`<0000Xoooo0`0002?oool4
00008oooo`030000oooooooo02?oool400009oooo`<0000Yoooo000[oooo00@0003oooooool0000X
oooo00<0003oooooool08_ooo`030000oooooooo02Coool00`000?ooooooo`0Soooo00<0003ooooo
ool0:Oooo`030000oooooooo02Soool002_oool010000?ooooooo`0002Goool500009?ooo`030000
oooooooo02?oool00`000?ooooooo`0Toooo00<0003oooooool09Oooo`D0000Yoooo000Uoooo1000
00;oool300008?ooo`@00002oooo00@0003oooooool0000Noooo100000Coool00`000?ooooooo`0R
oooo00<0003oooooool09Oooo`030000oooooooo02Coool010000?ooooooo`0002[oool002coool0
0`000?ooooooo`0Voooo00<0003oool000009?ooo`040000oooooooo00008oooo`030000oooooooo
02?oool010000?ooooooo`0002Koool00`000?ooo`00000Zoooo000/oooo0`0002Ooool200009Ooo
o`80000Toooo0P0002Goool20000:?ooo`80000Zoooo002Soooo00<0003oooooool0N_ooo`00Xooo
o`030000oooooooo07[oool00:?oool00`000?ooooooo`1joooo002Soooo00<0003oooooool0N_oo
o`00Xoooo`030000oooooooo07[oool0013ooooo00004Oooo`005_ooo`030000oooooooo00Goool2
06Ko00<00000I_l0I_l01`1Vo`03000006Ko06Ko00L0I_l00`00001Vo`1Vo`0706Ko00<00000I_l0
I_l02?ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Ooool00`000?ooo`00000@000000<co`00000co`0023?o00050000<ol0<ol0<ol006Ko
00Dco`000`0003?o03?o0007<ol000<0003oooooool01oooo`030000oooooooo00Ooool00`000?oo
ooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0
003oooooool02?ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01ooo
o`030000oooooooo01Goool002[oool00`000?ooooooo`0Doooo2P1Vo`Soool00`000?ooooooo`0U
oooo00<0003oooooool01_ooo`@0000;<ol000<0I_lco`0co`003C?o00030000oooooooo02Goool0
0`000?ooooooo`0Voooo00<0003oooooool0:Oooo`00Boooo`D0I_lhoooo100000Lco`000`1Voc?o
03?o000=<ol000<0003oooooool0N_ooo`00D?ooo`@0I_lhoooo00<0000co`0co`0013?o000306Ko
<ol0<ol000dco`000`000?ooooooo`1joooo001Doooo0P1VocOoool2000013?o000306Ko<ol0<ol0
00dco`000`000?ooooooo`1joooo001Foooo0`1VocKoool01@0003?o03?o03?o001Vo`0?<ol000<0
003oooooool0N_ooo`00FOooo`80I_leoooo00@0000co`0co`00I_l?<ol00P0007_oool005_oool2
06Ko=?ooo`8000000`1Voc?o03?o000=<ol000<0003oooooool0N_ooo`00GOooo`0306Kooooooooo
03?oool00`1Voc?o03?o000=<ol000<0003oooooool0N_ooo`00G_ooo`80I_lcoooo00<0I_lco`0c
o`003C?o00030000oooooooo07[oool0063oool00`1Vooooooooo`0`oooo00<0I_l0000co`003C?o
00030000oooooooo07[oool0067oool00`1Vooooooooo`0_oooo00<0I_l0000co`003C?o00030000
oooooooo07[oool006;oool00`1Vooooooooo`0^oooo00<0I_ooool000003C?o0080001koooo001S
oooo0P1Vobkoool00`1Vooooo`00000=<ol000<0003oooooool0N_ooo`00IOooo`0306Kooooooooo
02_oool0101Vooooooooo`0000`co`000`000?ooooooo`1joooo001Voooo00<0I_ooooooool0:_oo
o`0406Kooooooooo000033?o00030000oooooooo07[oool006Ooool00`1Vooooooooo`0Xoooo0P1V
o`?oool00`0003?o03?o0009<ol000<0003oooooool0N_ooo`00J?ooo`0306Kooooooooo02?oool4
06Ko00?ooooo09Woool00_ooo`030000<ol0<ol000Tco`000`000?ooooooo`1joooo001Yoooo00<0
I_ooooooool08?ooo`80I_l5oooo00?o09Woooooool00_ooo`030000<ol0<ol000Pco`020000Nooo
o`00JOooo`0306Kooooooooo01Koool:06Ko1oooo`03o`2Ioooooooo00;oool00`0003?o03?o0008
<ol000<0003oooooool0N_ooo`00J_ooo`0306Kooooooooo013oool506Ko4Oooo`03o`2Ioooooooo
00;oool00`0003?o03?o0008<ol000<0003oooooool0N_ooo`00J_oooa<0I_lFoooo00?o09Wooooo
ool00oooo`030000<ol0<ol000Lco`000`000?ooooooo`1joooo002Coooo00?o09Woooooool00ooo
o`030000<ol0<ol000Lco`000`000?ooooooo`1joooo002Coooo00?o09Woooooool00oooo`030000
<ol0<ol000Lco`000`000?ooooooo`1joooo002Coooo00?o09Woooooool00oooo`030000<ol0<ol0
00Lco`020000Noooo`00Toooo`03o`2Ioooooooo00Coool00`0003?o03?o0006<ol000<0003ooooo
ool0N_ooo`00Toooo`03o`2Ioooooooo00Coool00`0003?o03?o0006<ol000<0003oooooool0N_oo
o`00Toooo`03o`2Ioooooooo00Coool00`0003?o03?o0006<ol000<0003oooooool0N_ooo`00Tooo
o`03o`2Ioooooooo00Coool00`0003?o03?o0006<ol000<0003oooooool0N_ooo`00Toooo`03o`2I
oooooooo00Goool500000c?o00030000oooooooo07[oool009?oool00ol0VOooooooo`05oooo00<0
000co`0000001C?o00030000oooooooo07[oool009?oool00ol0VOooooooo`05oooo00<0000co`00
00001C?o00<0001joooo002Coooo00?o09Woooooool01_ooo`800005<ol000<0003oooooool0N_oo
o`00Toooo`03o`2Ioooooooo00Koool200001C?o00030000oooooooo07[oool009?oool00ol0VOoo
ooooo`06oooo0P0000Dco`000`000?ooooooo`1joooo002Coooo00?o09Woooooool01_ooo`030000
<ol0<ol000@co`000`000?ooooooo`1joooo002Coooo00?o09Woooooool01_ooo`030000<ol0<ol0
00@co`000`000?ooooooo`1joooo002Coooo00?o09Woooooool01_ooo`030000<ol0<ol000@co`02
0000Noooo`00Toooo`03o`2Ioooooooo00Ooool00`0003?o03?o0003<ol000<0003oooooool0N_oo
o`00Toooo`03o`2Ioooooooo00Ooool00`0003?o03?o0003<ol000<0003oooooool0N_ooo`00Tooo
o`03o`2Ioooooooo00Ooool00`0003?o03?o0003<ol000<0003oooooool0N_ooo`00Toooo`03o`2I
oooooooo00Ooool00`0003?o03?o0003<ol000<0003oooooool0N_ooo`00Toooo`03o`2Ioooooooo
00Ooool00`0003?o03?o0003<ol000<0003oooooool0N_ooo`00Toooo`03o`2Ioooooooo00Ooool0
0`0003?o03?o0003<ol00P0007_oool009?oool00ol0VOooooooo`07oooo00<0000co`0co`000c?o
00030000oooooooo07[oool009?oool00ol0VOooooooo`07oooo00<0000co`0co`000c?o00030000
oooooooo07[oool009?oool00ol0VOooooooo`08oooo00<0000co`0co`000S?o00030000oooooooo
07[oool009?oool00ol0VOooooooo`08oooo00<0000co`0co`000S?o00030000oooooooo07[oool0
09?oool00ol0VOooooooo`08oooo00<0000co`0co`000S?o00030000oooooooo07[oool009?oool0
0ol0VOooooooo`08oooo00<0000co`0co`000S?o00030000oooooooo07[oool009?oool00ol0VOoo
ooooo`08oooo00<0000co`0co`000S?o0080001koooo002Coooo00?o09Woooooool02?ooo`030000
<ol0<ol0008co`000`000?ooooooo`1joooo002Coooo00?o09Woooooool02?ooo`030000<ol0<ol0
008co`000`000?ooooooo`1joooo002Coooo00?o09Woooooool02?ooo`030000<ol0<ol0008co`00
0`000?ooooooo`1joooo002Coooo00?o09Woooooool02?ooo`030000<ol0<ol0008co`000`000?oo
ooooo`1joooo002Coooo00?o09Woooooool02?ooo`030000<ol0<ol0008co`000`000?ooooooo`1j
oooo002Coooo00?o09Woooooool02?ooo`030000<ol0<ol0008co`020000Noooo`00Toooo`03o`2I
oooooooo00Woool01@0003?o03?o03?o0000001loooo002Coooo00?o09Woooooool02Oooo`050000
<ol0<ol0<ol0000007coool009?oool00ol0VOooooooo`09oooo00D0000co`0co`0co`000000O?oo
o`00Toooo`03o`2Ioooooooo00Goool500000c?o00030000oooooooo07[oool009?oool00ol0VOoo
ooooo`05oooo00D0003oooooooooool000000c?o00030000oooooooo07[oool009?oool00ol0VOoo
ooooo`06oooo00@0003oooooool00003<ol00`0007[oool009?oool00ol0VOooooooo`07oooo00<0
003oool000000c?o00030000oooooooo07[oool009?oool00ol0VOooooooo`05oooo00<0003ooooo
ool00P0000<co`000`000?ooooooo`1joooo002Coooo00?o09Woooooool01_ooo`8000000oooo`00
03?o0002<ol000<0003oooooool0N_ooo`00Toooo`03o`2Ioooooooo00Woool01@0003?o03?o03?o
0000001loooo002Coooo00?o09Woooooool02_ooo`040000<ol0<ol00000O?ooo`00Toooo`03o`2I
oooooooo00[oool00`0003?o03?o00020000Noooo`00Toooo`03o`2Ioooooooo00[oool0100003?o
03?o000007coool009?oool00ol0VOooooooo`0:oooo00@0000co`0co`00001loooo002Coooo00?o
09Woooooool02_ooo`040000<ol0<ol00000O?ooo`00Toooo`03o`2Ioooooooo00[oool0100003?o
03?o000007coool009?oool00ol0VOooooooo`0:oooo00@0000co`0co`00001loooo002Coooo00?o
09Woooooool02_ooo`040000<ol0<ol00000O?ooo`00Toooo`03o`2Ioooooooo00_oool0100003?o
0000000007_oool009?oool00ol0VOooooooo`0;oooo00<0000co`000000O?ooo`00Toooo`03o`2I
oooooooo00_oool00`0003?o0000001loooo002Coooo00?o09Woooooool02oooo`030000<ol00000
07coool009?oool00ol0VOooooooo`0;oooo00<0000co`000000O?ooo`00Toooo`03o`2Ioooooooo
00_oool00`0003?o0000001loooo002Coooo00?o09Woooooool02oooo`040000<ol000000000Nooo
o`00Toooo`03o`2Ioooooooo00_oool00`0003?o0000001loooo002Coooo00?o09Woooooool02ooo
o`030000<ol0000007coool009?oool00ol0VOooooooo`0;oooo00<0000co`000000O?ooo`00Tooo
o`03o`2Ioooooooo00_oool00`0003?o0000001loooo002Coooo00?o09Woooooool02oooo`030000
<ol0000007coool009?oool00ol0VOooooooo`0;oooo00@0000co`000000001koooo002Coooo00?o
09Woooooool02oooo`030000<ol0000007coool009?oool00ol0VOooooooo`0;oooo00<0000co`00
0000O?ooo`00Toooo`03o`2Ioooooooo00_oool00`0003?o0000001loooo002Coooo00?o09Wooooo
ool01_ooo`800003oooo00<0000co`000000O?ooo`00Toooo`03o`2Ioooooooo00Goool010000?oo
ooooo`0000;oool00`0003?o0000001loooo002Coooo00?o09Woooooool01oooo`060000oooooooo
oooo0000<ol00`0007[oool009?oool00ol0VOooooooo`08oooo00H0003oooooool0000co`00001l
oooo002Coooo00?o09Woooooool01Oooo`040000oooooooo00000_ooo`030000<ol0000007coool0
09?oool00ol0VOooooooo`06oooo0P0000Coool20000O?ooo`00Toooo`03o`2Ioooooooo00coool2
0000O?ooo`00Toooo`03o`2Ioooooooo00coool20000O?ooo`00Toooo`03o`2Ioooooooo00coool2
0000O?ooo`00Toooo`03o`2Ioooooooo00coool30000Noooo`00Toooo`03o`2Ioooooooo00coool2
0000O?ooo`00Toooo`03o`2Ioooooooo00coool20000O?ooo`00Toooo`03o`2Ioooooooo00coool2
0000O?ooo`00Toooo`03o`2Ioooooooo00coool20000O?ooo`00Toooo`03o`2Ioooooooo00coool2
0000O?ooo`00Toooo`03o`2Ioooooooo00coool30000Noooo`00Toooo`03o`2Ioooooooo00coool2
0000O?ooo`00Toooo`03o`2Ioooooooo00coool20000O?ooo`00Toooo`03o`2Ioooooooo00coool2
0000O?ooo`00Toooo`03o`2Ioooooooo00coool20000O?ooo`00Toooo`03o`2Ioooooooo00coool2
0000O?ooo`00Toooo`03o`2Ioooooooo00coool30000Noooo`00Toooo`03o`2Ioooooooo00goool0
0`000?ooooooo`1joooo002Coooo00?o09Woooooool03Oooo`030000oooooooo07[oool009?oool0
0ol0VOooooooo`0=oooo00<0003oooooool0N_ooo`00Toooo`03o`2Ioooooooo00goool00`000?oo
ooooo`1joooo002Coooo00?o09Woooooool03Oooo`030000oooooooo07[oool009?oool00ol0VOoo
ooooo`0=oooo0P0007_oool009?oool00ol0VOooooooo`0=oooo00<0003oooooool0N_ooo`00Tooo
o`03o`2Ioooooooo00goool00`000?ooooooo`1joooo002Coooo00?o09Woooooool03Oooo`030000
oooooooo07[oool009?oool00ol0VOooooooo`0=oooo00<0003oooooool0N_ooo`00Toooo`03o`2I
oooooooo00Ooool300000oooo`030000oooooooo07[oool009?oool00ol0VOooooooo`08oooo00<0
003oooooool00_ooo`030000oooooooo07[oool009?oool00ol0VOooooooo`05oooo1@0000?oool3
0000N_ooo`00Voooo`040000oooooooo0000POooo`00W?ooo`030000oooo0000087oool009goool2
0000POooo`00ooooob7oool00?oooolQoooo001ioooo00<0003oooooool0:?ooo`030000oooooooo
07Woool007Soool00`000?ooooooo`08oooo00<0003oooooool07oooo`030000oooooooo07Soool0
07Soool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`0<oooo1@0000;oool200001?oo
o`800004oooo00<0003oooooool0N?ooo`00N?ooo`050000oooooooooooo000000;oool00`000?oo
ooooo`02oooo00<0003oooooool01?ooo`@00005oooo00<0003oooooool01oooo`040000oooooooo
00000oooo`030000oooooooo07Soool007Ooool00`000?ooooooo`02oooo00<0003oooooool05Ooo
o`030000oooooooo00Ooool010000?ooooooo`0000Coool00`000?ooooooo`1goooo001hoooo00<0
003oooooool01@0001Coool00`000?ooooooo`08oooo0P0000Coool00`000?ooooooo`1hoooo001h
oooo00D0003oooooooooool000005oooo`030000oooooooo00Ooool010000?ooooooo`0000?oool0
0`000?ooooooo`1hoooo001ioooo00<0003oooooool05oooo`80000:oooo0P0000?oool00`000?oo
ooooo`1ioooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.00124022, -5.00002*^-06, \
0.00349296, 0.00565173}, {{0.3125, 286.625}, {176.938, 0}} -> {-8.12947, \
-1.14361, 0.0496935, 0.031907}, {{0.3125, 286.625}, {176.938, 0}} -> \
{-8.12947, -1.14361, 0.0496935, 0.031907}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% Start of sub-graphic
p
0 0 1 0.618034 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.579365 0.0793651 0.123607 0.123607 [
[.10317 .11111 -6 -9 ]
[.10317 .11111 6 0 ]
[.2619 .11111 -6 -9 ]
[.2619 .11111 6 0 ]
[.42063 .11111 -6 -9 ]
[.42063 .11111 6 0 ]
[.7381 .11111 -3 -9 ]
[.7381 .11111 3 0 ]
[.89683 .11111 -3 -9 ]
[.89683 .11111 3 0 ]
[.56687 0 -12 -4.5 ]
[.56687 0 0 4.5 ]
[.56687 .24721 -6 -4.5 ]
[.56687 .24721 0 4.5 ]
[.56687 .37082 -6 -4.5 ]
[.56687 .37082 0 4.5 ]
[.56687 .49443 -6 -4.5 ]
[.56687 .49443 0 4.5 ]
[.56687 .61803 -6 -4.5 ]
[.56687 .61803 0 4.5 ]
[.5 .63053 -28.0938 0 ]
[.5 .63053 28.0938 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.10317 .12361 m
.10317 .12986 L
s
[(-6)] .10317 .11111 0 1 Mshowa
.2619 .12361 m
.2619 .12986 L
s
[(-4)] .2619 .11111 0 1 Mshowa
.42063 .12361 m
.42063 .12986 L
s
[(-2)] .42063 .11111 0 1 Mshowa
.7381 .12361 m
.7381 .12986 L
s
[(2)] .7381 .11111 0 1 Mshowa
.89683 .12361 m
.89683 .12986 L
s
[(4)] .89683 .11111 0 1 Mshowa
.125 Mabswid
.14286 .12361 m
.14286 .12736 L
s
.18254 .12361 m
.18254 .12736 L
s
.22222 .12361 m
.22222 .12736 L
s
.30159 .12361 m
.30159 .12736 L
s
.34127 .12361 m
.34127 .12736 L
s
.38095 .12361 m
.38095 .12736 L
s
.46032 .12361 m
.46032 .12736 L
s
.5 .12361 m
.5 .12736 L
s
.53968 .12361 m
.53968 .12736 L
s
.61905 .12361 m
.61905 .12736 L
s
.65873 .12361 m
.65873 .12736 L
s
.69841 .12361 m
.69841 .12736 L
s
.77778 .12361 m
.77778 .12736 L
s
.81746 .12361 m
.81746 .12736 L
s
.85714 .12361 m
.85714 .12736 L
s
.06349 .12361 m
.06349 .12736 L
s
.02381 .12361 m
.02381 .12736 L
s
.93651 .12361 m
.93651 .12736 L
s
.97619 .12361 m
.97619 .12736 L
s
.25 Mabswid
0 .12361 m
1 .12361 L
s
.57937 0 m
.58562 0 L
s
[(-1)] .56687 0 1 0 Mshowa
.57937 .24721 m
.58562 .24721 L
s
[(1)] .56687 .24721 1 0 Mshowa
.57937 .37082 m
.58562 .37082 L
s
[(2)] .56687 .37082 1 0 Mshowa
.57937 .49443 m
.58562 .49443 L
s
[(3)] .56687 .49443 1 0 Mshowa
.57937 .61803 m
.58562 .61803 L
s
[(4)] .56687 .61803 1 0 Mshowa
.125 Mabswid
.57937 .02472 m
.58312 .02472 L
s
.57937 .04944 m
.58312 .04944 L
s
.57937 .07416 m
.58312 .07416 L
s
.57937 .09889 m
.58312 .09889 L
s
.57937 .14833 m
.58312 .14833 L
s
.57937 .17305 m
.58312 .17305 L
s
.57937 .19777 m
.58312 .19777 L
s
.57937 .22249 m
.58312 .22249 L
s
.57937 .27193 m
.58312 .27193 L
s
.57937 .29666 m
.58312 .29666 L
s
.57937 .32138 m
.58312 .32138 L
s
.57937 .3461 m
.58312 .